#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 3470
#define LARGE_STATE_COUNT 939
#define SYMBOL_COUNT 277
#define ALIAS_COUNT 6
#define TOKEN_COUNT 175
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 37
#define MAX_ALIAS_SEQUENCE_LENGTH 12
#define PRODUCTION_ID_COUNT 265

enum {
  sym_identifier = 1,
  anon_sym_LF = 2,
  anon_sym_SEMI = 3,
  anon_sym_package = 4,
  anon_sym_import = 5,
  anon_sym_foreign = 6,
  anon_sym_LBRACE = 7,
  anon_sym_RBRACE = 8,
  sym_blank_identifier = 9,
  anon_sym_defer = 10,
  anon_sym_using = 11,
  anon_sym_return = 12,
  anon_sym_COLON = 13,
  anon_sym_POUNDno_bounds_check = 14,
  anon_sym_POUNDbounds_check = 15,
  anon_sym_AT = 16,
  anon_sym_LPAREN = 17,
  anon_sym_EQ = 18,
  anon_sym_COMMA = 19,
  anon_sym_RPAREN = 20,
  anon_sym_distinct = 21,
  anon_sym_int = 22,
  anon_sym_uint = 23,
  anon_sym_uintptr = 24,
  anon_sym_typeid = 25,
  anon_sym_rawptr = 26,
  anon_sym_string = 27,
  anon_sym_cstring = 28,
  anon_sym_i8 = 29,
  anon_sym_u8 = 30,
  anon_sym_bool = 31,
  anon_sym_b8 = 32,
  anon_sym_b16 = 33,
  anon_sym_b32 = 34,
  anon_sym_b64 = 35,
  anon_sym_i16 = 36,
  anon_sym_i16le = 37,
  anon_sym_i16be = 38,
  anon_sym_i32 = 39,
  anon_sym_i32le = 40,
  anon_sym_i32be = 41,
  anon_sym_i64 = 42,
  anon_sym_i64le = 43,
  anon_sym_i64be = 44,
  anon_sym_i128 = 45,
  anon_sym_i128le = 46,
  anon_sym_i128be = 47,
  anon_sym_u16 = 48,
  anon_sym_u16le = 49,
  anon_sym_u16be = 50,
  anon_sym_u32 = 51,
  anon_sym_u32le = 52,
  anon_sym_u32be = 53,
  anon_sym_u64 = 54,
  anon_sym_u64le = 55,
  anon_sym_u64be = 56,
  anon_sym_u128 = 57,
  anon_sym_u128le = 58,
  anon_sym_u128be = 59,
  anon_sym_f16 = 60,
  anon_sym_f16le = 61,
  anon_sym_f16be = 62,
  anon_sym_f32 = 63,
  anon_sym_f32le = 64,
  anon_sym_f32be = 65,
  anon_sym_f64 = 66,
  anon_sym_f64le = 67,
  anon_sym_f64be = 68,
  anon_sym_complex32 = 69,
  anon_sym_complex64 = 70,
  anon_sym_complex128 = 71,
  anon_sym_quaternion64 = 72,
  anon_sym_quaternion128 = 73,
  anon_sym_quaternion256 = 74,
  anon_sym_SLASH = 75,
  anon_sym_DOLLAR = 76,
  anon_sym_CARET = 77,
  anon_sym_POUNDrelative = 78,
  anon_sym_bit_set = 79,
  anon_sym_LBRACK = 80,
  anon_sym_RBRACK = 81,
  anon_sym_matrix = 82,
  anon_sym_QMARK = 83,
  anon_sym_dynamic = 84,
  anon_sym_POUNDsoa = 85,
  anon_sym_POUNDsimd = 86,
  anon_sym_union = 87,
  anon_sym_POUNDno_nil = 88,
  anon_sym_POUNDshared_nil = 89,
  anon_sym_POUNDalign = 90,
  anon_sym_enum = 91,
  anon_sym_struct = 92,
  anon_sym_POUNDno_copy = 93,
  anon_sym_POUNDpacked = 94,
  anon_sym_POUNDraw_union = 95,
  anon_sym_map = 96,
  anon_sym_POUNDtype = 97,
  anon_sym_DOT = 98,
  anon_sym_cast = 99,
  anon_sym_transmute = 100,
  anon_sym_auto_cast = 101,
  anon_sym_if = 102,
  anon_sym_else = 103,
  anon_sym_DASH_DASH_DASH = 104,
  anon_sym_where = 105,
  anon_sym_POUNDforce_inline = 106,
  anon_sym_POUNDforce_no_inline = 107,
  anon_sym_proc = 108,
  anon_sym_DASH_GT = 109,
  anon_sym_BANG = 110,
  anon_sym_POUNDoptional_ok = 111,
  anon_sym_DOT_DOT = 112,
  anon_sym_POUNDno_alias = 113,
  anon_sym_POUNDby_ptr = 114,
  anon_sym_POUNDany_int = 115,
  anon_sym_POUNDc_vararg = 116,
  anon_sym_STAR_EQ = 117,
  anon_sym_SLASH_EQ = 118,
  anon_sym_PERCENT_EQ = 119,
  anon_sym_PERCENT_PERCENT_EQ = 120,
  anon_sym_LT_LT_EQ = 121,
  anon_sym_GT_GT_EQ = 122,
  anon_sym_AMP_EQ = 123,
  anon_sym_AMP_TILDE_EQ = 124,
  anon_sym_PLUS_EQ = 125,
  anon_sym_DASH_EQ = 126,
  anon_sym_TILDE_EQ = 127,
  anon_sym_PIPE_EQ = 128,
  anon_sym_case = 129,
  anon_sym_continue = 130,
  anon_sym_break = 131,
  anon_sym_when = 132,
  anon_sym_do = 133,
  anon_sym_switch = 134,
  anon_sym_in = 135,
  anon_sym_POUNDpartial = 136,
  anon_sym_for = 137,
  anon_sym_POUNDunroll = 138,
  anon_sym_or_return = 139,
  anon_sym_PLUS = 140,
  anon_sym_DASH = 141,
  anon_sym_TILDE = 142,
  anon_sym_AMP = 143,
  anon_sym_or_else = 144,
  anon_sym_STAR = 145,
  anon_sym_PERCENT = 146,
  anon_sym_PERCENT_PERCENT = 147,
  anon_sym_LT_LT = 148,
  anon_sym_GT_GT = 149,
  anon_sym_AMP_TILDE = 150,
  anon_sym_not_in = 151,
  anon_sym_PIPE = 152,
  anon_sym_GT = 153,
  anon_sym_LT = 154,
  anon_sym_LT_EQ = 155,
  anon_sym_GT_EQ = 156,
  anon_sym_EQ_EQ = 157,
  anon_sym_BANG_EQ = 158,
  anon_sym_DOT_DOT_LT = 159,
  anon_sym_DOT_DOT_EQ = 160,
  anon_sym_AMP_AMP = 161,
  anon_sym_PIPE_PIPE = 162,
  sym_builtin_procedure = 163,
  sym_raw_string_literal = 164,
  anon_sym_DQUOTE = 165,
  aux_sym_interpreted_string_literal_token1 = 166,
  sym_escape_sequence = 167,
  sym_int_literal = 168,
  sym_float_literal = 169,
  sym_rune_literal = 170,
  sym_nil = 171,
  sym__true = 172,
  sym__false = 173,
  sym_comment = 174,
  sym_source_file = 175,
  sym_package_clause = 176,
  sym_import_declaration = 177,
  sym_foreign_block = 178,
  sym__simple_statement = 179,
  sym__statement = 180,
  sym_defer_statement = 181,
  sym_using_statement = 182,
  sym_return_statement = 183,
  sym_block_statement = 184,
  sym_block = 185,
  sym__block_directive = 186,
  sym_pragma = 187,
  sym__declaration = 188,
  sym_var_declaration = 189,
  sym_const_declaration = 190,
  sym__simple_type = 191,
  sym_generic_type = 192,
  sym_pointer_type = 193,
  sym__pointer_directive = 194,
  sym_bit_set_type = 195,
  sym_matrix_type = 196,
  sym_array_type = 197,
  sym__array_directive = 198,
  sym_union_type = 199,
  sym__union_directive = 200,
  sym_enum_type = 201,
  sym_struct_type = 202,
  sym_struct_field_declaration = 203,
  sym__struct_directive = 204,
  sym_map_type = 205,
  sym__expression = 206,
  sym__type_directive = 207,
  sym_selector_expression = 208,
  sym_type_conversion = 209,
  sym_ternary_expression = 210,
  sym_index_expression = 211,
  sym__parenthesized_expression = 212,
  sym_proc_literal = 213,
  sym_where_clause = 214,
  sym__proc_directive = 215,
  sym_proc_group = 216,
  sym__proc_type = 217,
  sym_parameter_list = 218,
  sym__parameter_list_directive = 219,
  sym_parameter_declaration = 220,
  sym__parameter_directive = 221,
  sym__calling_convention = 222,
  sym_proc_call = 223,
  sym_initializer_list = 224,
  sym_single_assignment = 225,
  sym_assignment_statement = 226,
  sym__expression_pack = 227,
  sym_case_statement = 228,
  sym_continue_statement = 229,
  sym_break_statement = 230,
  sym_if_statement = 231,
  sym_switch_statement = 232,
  sym__switch_block = 233,
  sym__switch_directive = 234,
  sym_for_statement = 235,
  sym__for_directive = 236,
  sym__for_full_clause = 237,
  sym__for_empty_clause = 238,
  sym__for_conditional_clause = 239,
  sym__for_conditional_and_update_clause = 240,
  sym__for_init_and_update_clause = 241,
  sym__for_init_clause = 242,
  sym__range_clause = 243,
  sym_right_unary_expression = 244,
  sym_left_unary_expression = 245,
  sym_binary_expression = 246,
  sym_compound_literal = 247,
  sym__pragma_identifier = 248,
  sym_interpreted_string_literal = 249,
  sym_bool_literal = 250,
  aux_sym_source_file_repeat1 = 251,
  aux_sym_foreign_block_repeat1 = 252,
  aux_sym_foreign_block_repeat2 = 253,
  aux_sym_block_repeat1 = 254,
  aux_sym_block_repeat2 = 255,
  aux_sym_pragma_repeat1 = 256,
  aux_sym_var_declaration_repeat1 = 257,
  aux_sym_const_declaration_repeat1 = 258,
  aux_sym_pointer_type_repeat1 = 259,
  aux_sym_array_type_repeat1 = 260,
  aux_sym_union_type_repeat1 = 261,
  aux_sym_union_type_repeat2 = 262,
  aux_sym_struct_type_repeat1 = 263,
  aux_sym_struct_type_repeat2 = 264,
  aux_sym_struct_field_declaration_repeat1 = 265,
  aux_sym_proc_literal_repeat1 = 266,
  aux_sym_parameter_list_repeat1 = 267,
  aux_sym_parameter_declaration_repeat1 = 268,
  aux_sym_parameter_declaration_repeat2 = 269,
  aux_sym_initializer_list_repeat1 = 270,
  aux_sym__expression_pack_repeat1 = 271,
  aux_sym_switch_statement_repeat1 = 272,
  aux_sym__switch_block_repeat1 = 273,
  aux_sym_for_statement_repeat1 = 274,
  aux_sym__range_clause_repeat1 = 275,
  aux_sym_interpreted_string_literal_repeat1 = 276,
  alias_sym_calling_convention = 277,
  alias_sym_const_identifier = 278,
  alias_sym_label_identifier = 279,
  alias_sym_package_identifier = 280,
  alias_sym_pragma_identifier = 281,
  alias_sym_proc_type = 282,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_package] = "keyword",
  [anon_sym_import] = "keyword",
  [anon_sym_foreign] = "keyword",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym_blank_identifier] = "blank_identifier",
  [anon_sym_defer] = "keyword",
  [anon_sym_using] = "keyword",
  [anon_sym_return] = "keyword",
  [anon_sym_COLON] = ":",
  [anon_sym_POUNDno_bounds_check] = "#no_bounds_check",
  [anon_sym_POUNDbounds_check] = "#bounds_check",
  [anon_sym_AT] = "@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_EQ] = "=",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_distinct] = "keyword",
  [anon_sym_int] = "type_identifier",
  [anon_sym_uint] = "type_identifier",
  [anon_sym_uintptr] = "type_identifier",
  [anon_sym_typeid] = "type_identifier",
  [anon_sym_rawptr] = "type_identifier",
  [anon_sym_string] = "type_identifier",
  [anon_sym_cstring] = "type_identifier",
  [anon_sym_i8] = "type_identifier",
  [anon_sym_u8] = "type_identifier",
  [anon_sym_bool] = "type_identifier",
  [anon_sym_b8] = "type_identifier",
  [anon_sym_b16] = "type_identifier",
  [anon_sym_b32] = "type_identifier",
  [anon_sym_b64] = "type_identifier",
  [anon_sym_i16] = "type_identifier",
  [anon_sym_i16le] = "type_identifier",
  [anon_sym_i16be] = "type_identifier",
  [anon_sym_i32] = "type_identifier",
  [anon_sym_i32le] = "type_identifier",
  [anon_sym_i32be] = "type_identifier",
  [anon_sym_i64] = "type_identifier",
  [anon_sym_i64le] = "type_identifier",
  [anon_sym_i64be] = "type_identifier",
  [anon_sym_i128] = "type_identifier",
  [anon_sym_i128le] = "type_identifier",
  [anon_sym_i128be] = "type_identifier",
  [anon_sym_u16] = "type_identifier",
  [anon_sym_u16le] = "type_identifier",
  [anon_sym_u16be] = "type_identifier",
  [anon_sym_u32] = "type_identifier",
  [anon_sym_u32le] = "type_identifier",
  [anon_sym_u32be] = "type_identifier",
  [anon_sym_u64] = "type_identifier",
  [anon_sym_u64le] = "type_identifier",
  [anon_sym_u64be] = "type_identifier",
  [anon_sym_u128] = "type_identifier",
  [anon_sym_u128le] = "type_identifier",
  [anon_sym_u128be] = "type_identifier",
  [anon_sym_f16] = "type_identifier",
  [anon_sym_f16le] = "type_identifier",
  [anon_sym_f16be] = "type_identifier",
  [anon_sym_f32] = "type_identifier",
  [anon_sym_f32le] = "type_identifier",
  [anon_sym_f32be] = "type_identifier",
  [anon_sym_f64] = "type_identifier",
  [anon_sym_f64le] = "type_identifier",
  [anon_sym_f64be] = "type_identifier",
  [anon_sym_complex32] = "type_identifier",
  [anon_sym_complex64] = "type_identifier",
  [anon_sym_complex128] = "type_identifier",
  [anon_sym_quaternion64] = "type_identifier",
  [anon_sym_quaternion128] = "type_identifier",
  [anon_sym_quaternion256] = "type_identifier",
  [anon_sym_SLASH] = "operator",
  [anon_sym_DOLLAR] = "operator",
  [anon_sym_CARET] = "operator",
  [anon_sym_POUNDrelative] = "#relative",
  [anon_sym_bit_set] = "keyword",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_matrix] = "keyword",
  [anon_sym_QMARK] = "operator",
  [anon_sym_dynamic] = "keyword",
  [anon_sym_POUNDsoa] = "#soa",
  [anon_sym_POUNDsimd] = "#simd",
  [anon_sym_union] = "keyword",
  [anon_sym_POUNDno_nil] = "#no_nil",
  [anon_sym_POUNDshared_nil] = "#shared_nil",
  [anon_sym_POUNDalign] = "#align",
  [anon_sym_enum] = "keyword",
  [anon_sym_struct] = "keyword",
  [anon_sym_POUNDno_copy] = "#no_copy",
  [anon_sym_POUNDpacked] = "#packed",
  [anon_sym_POUNDraw_union] = "#raw_union",
  [anon_sym_map] = "keyword",
  [anon_sym_POUNDtype] = "#type",
  [anon_sym_DOT] = ".",
  [anon_sym_cast] = "keyword",
  [anon_sym_transmute] = "keyword",
  [anon_sym_auto_cast] = "operator",
  [anon_sym_if] = "keyword",
  [anon_sym_else] = "keyword",
  [anon_sym_DASH_DASH_DASH] = "---",
  [anon_sym_where] = "keyword",
  [anon_sym_POUNDforce_inline] = "#force_inline",
  [anon_sym_POUNDforce_no_inline] = "#force_no_inline",
  [anon_sym_proc] = "keyword",
  [anon_sym_DASH_GT] = "operator",
  [anon_sym_BANG] = "keyword",
  [anon_sym_POUNDoptional_ok] = "#optional_ok",
  [anon_sym_DOT_DOT] = "operator",
  [anon_sym_POUNDno_alias] = "#no_alias",
  [anon_sym_POUNDby_ptr] = "#by_ptr",
  [anon_sym_POUNDany_int] = "#any_int",
  [anon_sym_POUNDc_vararg] = "#c_vararg",
  [anon_sym_STAR_EQ] = "operator",
  [anon_sym_SLASH_EQ] = "operator",
  [anon_sym_PERCENT_EQ] = "operator",
  [anon_sym_PERCENT_PERCENT_EQ] = "operator",
  [anon_sym_LT_LT_EQ] = "operator",
  [anon_sym_GT_GT_EQ] = "operator",
  [anon_sym_AMP_EQ] = "operator",
  [anon_sym_AMP_TILDE_EQ] = "operator",
  [anon_sym_PLUS_EQ] = "operator",
  [anon_sym_DASH_EQ] = "operator",
  [anon_sym_TILDE_EQ] = "operator",
  [anon_sym_PIPE_EQ] = "operator",
  [anon_sym_case] = "keyword",
  [anon_sym_continue] = "keyword",
  [anon_sym_break] = "keyword",
  [anon_sym_when] = "keyword",
  [anon_sym_do] = "keyword",
  [anon_sym_switch] = "keyword",
  [anon_sym_in] = "keyword",
  [anon_sym_POUNDpartial] = "#partial",
  [anon_sym_for] = "keyword",
  [anon_sym_POUNDunroll] = "#unroll",
  [anon_sym_or_return] = "operator",
  [anon_sym_PLUS] = "operator",
  [anon_sym_DASH] = "operator",
  [anon_sym_TILDE] = "operator",
  [anon_sym_AMP] = "operator",
  [anon_sym_or_else] = "operator",
  [anon_sym_STAR] = "operator",
  [anon_sym_PERCENT] = "operator",
  [anon_sym_PERCENT_PERCENT] = "operator",
  [anon_sym_LT_LT] = "operator",
  [anon_sym_GT_GT] = "operator",
  [anon_sym_AMP_TILDE] = "operator",
  [anon_sym_not_in] = "operator",
  [anon_sym_PIPE] = "operator",
  [anon_sym_GT] = "operator",
  [anon_sym_LT] = "operator",
  [anon_sym_LT_EQ] = "operator",
  [anon_sym_GT_EQ] = "operator",
  [anon_sym_EQ_EQ] = "operator",
  [anon_sym_BANG_EQ] = "operator",
  [anon_sym_DOT_DOT_LT] = "operator",
  [anon_sym_DOT_DOT_EQ] = "operator",
  [anon_sym_AMP_AMP] = "operator",
  [anon_sym_PIPE_PIPE] = "operator",
  [sym_builtin_procedure] = "compiler_directive",
  [sym_raw_string_literal] = "raw_string_literal",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_interpreted_string_literal_token1] = "interpreted_string_literal_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_int_literal] = "int_literal",
  [sym_float_literal] = "float_literal",
  [sym_rune_literal] = "rune_literal",
  [sym_nil] = "nil",
  [sym__true] = "_true",
  [sym__false] = "_false",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym_package_clause] = "package_clause",
  [sym_import_declaration] = "import_declaration",
  [sym_foreign_block] = "foreign_block",
  [sym__simple_statement] = "_simple_statement",
  [sym__statement] = "_statement",
  [sym_defer_statement] = "defer_statement",
  [sym_using_statement] = "using_statement",
  [sym_return_statement] = "return_statement",
  [sym_block_statement] = "block_statement",
  [sym_block] = "block",
  [sym__block_directive] = "compiler_directive",
  [sym_pragma] = "pragma",
  [sym__declaration] = "_declaration",
  [sym_var_declaration] = "var_declaration",
  [sym_const_declaration] = "const_declaration",
  [sym__simple_type] = "_simple_type",
  [sym_generic_type] = "generic_type",
  [sym_pointer_type] = "pointer_type",
  [sym__pointer_directive] = "compiler_directive",
  [sym_bit_set_type] = "bit_set_type",
  [sym_matrix_type] = "matrix_type",
  [sym_array_type] = "array_type",
  [sym__array_directive] = "compiler_directive",
  [sym_union_type] = "union_type",
  [sym__union_directive] = "compiler_directive",
  [sym_enum_type] = "enum_type",
  [sym_struct_type] = "struct_type",
  [sym_struct_field_declaration] = "struct_field_declaration",
  [sym__struct_directive] = "compiler_directive",
  [sym_map_type] = "map_type",
  [sym__expression] = "_expression",
  [sym__type_directive] = "compiler_directive",
  [sym_selector_expression] = "selector_expression",
  [sym_type_conversion] = "type_conversion",
  [sym_ternary_expression] = "ternary_expression",
  [sym_index_expression] = "index_expression",
  [sym__parenthesized_expression] = "_parenthesized_expression",
  [sym_proc_literal] = "proc_literal",
  [sym_where_clause] = "where_clause",
  [sym__proc_directive] = "compiler_directive",
  [sym_proc_group] = "proc_group",
  [sym__proc_type] = "_proc_type",
  [sym_parameter_list] = "parameter_list",
  [sym__parameter_list_directive] = "compiler_directive",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym__parameter_directive] = "compiler_directive",
  [sym__calling_convention] = "_calling_convention",
  [sym_proc_call] = "proc_call",
  [sym_initializer_list] = "initializer_list",
  [sym_single_assignment] = "single_assignment",
  [sym_assignment_statement] = "assignment_statement",
  [sym__expression_pack] = "_expression_pack",
  [sym_case_statement] = "case_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_break_statement] = "break_statement",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym__switch_block] = "block",
  [sym__switch_directive] = "compiler_directive",
  [sym_for_statement] = "for_statement",
  [sym__for_directive] = "compiler_directive",
  [sym__for_full_clause] = "_for_full_clause",
  [sym__for_empty_clause] = "_for_empty_clause",
  [sym__for_conditional_clause] = "_for_conditional_clause",
  [sym__for_conditional_and_update_clause] = "_for_conditional_and_update_clause",
  [sym__for_init_and_update_clause] = "_for_init_and_update_clause",
  [sym__for_init_clause] = "_for_init_clause",
  [sym__range_clause] = "_range_clause",
  [sym_right_unary_expression] = "right_unary_expression",
  [sym_left_unary_expression] = "left_unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_compound_literal] = "compound_literal",
  [sym__pragma_identifier] = "_pragma_identifier",
  [sym_interpreted_string_literal] = "interpreted_string_literal",
  [sym_bool_literal] = "bool_literal",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_foreign_block_repeat1] = "foreign_block_repeat1",
  [aux_sym_foreign_block_repeat2] = "foreign_block_repeat2",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_block_repeat2] = "block_repeat2",
  [aux_sym_pragma_repeat1] = "pragma_repeat1",
  [aux_sym_var_declaration_repeat1] = "var_declaration_repeat1",
  [aux_sym_const_declaration_repeat1] = "const_declaration_repeat1",
  [aux_sym_pointer_type_repeat1] = "pointer_type_repeat1",
  [aux_sym_array_type_repeat1] = "array_type_repeat1",
  [aux_sym_union_type_repeat1] = "union_type_repeat1",
  [aux_sym_union_type_repeat2] = "union_type_repeat2",
  [aux_sym_struct_type_repeat1] = "struct_type_repeat1",
  [aux_sym_struct_type_repeat2] = "struct_type_repeat2",
  [aux_sym_struct_field_declaration_repeat1] = "struct_field_declaration_repeat1",
  [aux_sym_proc_literal_repeat1] = "proc_literal_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_parameter_declaration_repeat1] = "parameter_declaration_repeat1",
  [aux_sym_parameter_declaration_repeat2] = "parameter_declaration_repeat2",
  [aux_sym_initializer_list_repeat1] = "initializer_list_repeat1",
  [aux_sym__expression_pack_repeat1] = "_expression_pack_repeat1",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym__switch_block_repeat1] = "_switch_block_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym__range_clause_repeat1] = "_range_clause_repeat1",
  [aux_sym_interpreted_string_literal_repeat1] = "interpreted_string_literal_repeat1",
  [alias_sym_calling_convention] = "calling_convention",
  [alias_sym_const_identifier] = "const_identifier",
  [alias_sym_label_identifier] = "label_identifier",
  [alias_sym_package_identifier] = "package_identifier",
  [alias_sym_pragma_identifier] = "pragma_identifier",
  [alias_sym_proc_type] = "proc_type",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_package,
  [anon_sym_foreign] = anon_sym_package,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym_blank_identifier] = sym_blank_identifier,
  [anon_sym_defer] = anon_sym_package,
  [anon_sym_using] = anon_sym_package,
  [anon_sym_return] = anon_sym_package,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_POUNDno_bounds_check] = anon_sym_POUNDno_bounds_check,
  [anon_sym_POUNDbounds_check] = anon_sym_POUNDbounds_check,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_distinct] = anon_sym_package,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_uint] = anon_sym_int,
  [anon_sym_uintptr] = anon_sym_int,
  [anon_sym_typeid] = anon_sym_int,
  [anon_sym_rawptr] = anon_sym_int,
  [anon_sym_string] = anon_sym_int,
  [anon_sym_cstring] = anon_sym_int,
  [anon_sym_i8] = anon_sym_int,
  [anon_sym_u8] = anon_sym_int,
  [anon_sym_bool] = anon_sym_int,
  [anon_sym_b8] = anon_sym_int,
  [anon_sym_b16] = anon_sym_int,
  [anon_sym_b32] = anon_sym_int,
  [anon_sym_b64] = anon_sym_int,
  [anon_sym_i16] = anon_sym_int,
  [anon_sym_i16le] = anon_sym_int,
  [anon_sym_i16be] = anon_sym_int,
  [anon_sym_i32] = anon_sym_int,
  [anon_sym_i32le] = anon_sym_int,
  [anon_sym_i32be] = anon_sym_int,
  [anon_sym_i64] = anon_sym_int,
  [anon_sym_i64le] = anon_sym_int,
  [anon_sym_i64be] = anon_sym_int,
  [anon_sym_i128] = anon_sym_int,
  [anon_sym_i128le] = anon_sym_int,
  [anon_sym_i128be] = anon_sym_int,
  [anon_sym_u16] = anon_sym_int,
  [anon_sym_u16le] = anon_sym_int,
  [anon_sym_u16be] = anon_sym_int,
  [anon_sym_u32] = anon_sym_int,
  [anon_sym_u32le] = anon_sym_int,
  [anon_sym_u32be] = anon_sym_int,
  [anon_sym_u64] = anon_sym_int,
  [anon_sym_u64le] = anon_sym_int,
  [anon_sym_u64be] = anon_sym_int,
  [anon_sym_u128] = anon_sym_int,
  [anon_sym_u128le] = anon_sym_int,
  [anon_sym_u128be] = anon_sym_int,
  [anon_sym_f16] = anon_sym_int,
  [anon_sym_f16le] = anon_sym_int,
  [anon_sym_f16be] = anon_sym_int,
  [anon_sym_f32] = anon_sym_int,
  [anon_sym_f32le] = anon_sym_int,
  [anon_sym_f32be] = anon_sym_int,
  [anon_sym_f64] = anon_sym_int,
  [anon_sym_f64le] = anon_sym_int,
  [anon_sym_f64be] = anon_sym_int,
  [anon_sym_complex32] = anon_sym_int,
  [anon_sym_complex64] = anon_sym_int,
  [anon_sym_complex128] = anon_sym_int,
  [anon_sym_quaternion64] = anon_sym_int,
  [anon_sym_quaternion128] = anon_sym_int,
  [anon_sym_quaternion256] = anon_sym_int,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOLLAR] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_SLASH,
  [anon_sym_POUNDrelative] = anon_sym_POUNDrelative,
  [anon_sym_bit_set] = anon_sym_package,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_matrix] = anon_sym_package,
  [anon_sym_QMARK] = anon_sym_SLASH,
  [anon_sym_dynamic] = anon_sym_package,
  [anon_sym_POUNDsoa] = anon_sym_POUNDsoa,
  [anon_sym_POUNDsimd] = anon_sym_POUNDsimd,
  [anon_sym_union] = anon_sym_package,
  [anon_sym_POUNDno_nil] = anon_sym_POUNDno_nil,
  [anon_sym_POUNDshared_nil] = anon_sym_POUNDshared_nil,
  [anon_sym_POUNDalign] = anon_sym_POUNDalign,
  [anon_sym_enum] = anon_sym_package,
  [anon_sym_struct] = anon_sym_package,
  [anon_sym_POUNDno_copy] = anon_sym_POUNDno_copy,
  [anon_sym_POUNDpacked] = anon_sym_POUNDpacked,
  [anon_sym_POUNDraw_union] = anon_sym_POUNDraw_union,
  [anon_sym_map] = anon_sym_package,
  [anon_sym_POUNDtype] = anon_sym_POUNDtype,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_cast] = anon_sym_package,
  [anon_sym_transmute] = anon_sym_package,
  [anon_sym_auto_cast] = anon_sym_SLASH,
  [anon_sym_if] = anon_sym_package,
  [anon_sym_else] = anon_sym_package,
  [anon_sym_DASH_DASH_DASH] = anon_sym_DASH_DASH_DASH,
  [anon_sym_where] = anon_sym_package,
  [anon_sym_POUNDforce_inline] = anon_sym_POUNDforce_inline,
  [anon_sym_POUNDforce_no_inline] = anon_sym_POUNDforce_no_inline,
  [anon_sym_proc] = anon_sym_package,
  [anon_sym_DASH_GT] = anon_sym_SLASH,
  [anon_sym_BANG] = anon_sym_package,
  [anon_sym_POUNDoptional_ok] = anon_sym_POUNDoptional_ok,
  [anon_sym_DOT_DOT] = anon_sym_SLASH,
  [anon_sym_POUNDno_alias] = anon_sym_POUNDno_alias,
  [anon_sym_POUNDby_ptr] = anon_sym_POUNDby_ptr,
  [anon_sym_POUNDany_int] = anon_sym_POUNDany_int,
  [anon_sym_POUNDc_vararg] = anon_sym_POUNDc_vararg,
  [anon_sym_STAR_EQ] = anon_sym_SLASH,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH,
  [anon_sym_PERCENT_EQ] = anon_sym_SLASH,
  [anon_sym_PERCENT_PERCENT_EQ] = anon_sym_SLASH,
  [anon_sym_LT_LT_EQ] = anon_sym_SLASH,
  [anon_sym_GT_GT_EQ] = anon_sym_SLASH,
  [anon_sym_AMP_EQ] = anon_sym_SLASH,
  [anon_sym_AMP_TILDE_EQ] = anon_sym_SLASH,
  [anon_sym_PLUS_EQ] = anon_sym_SLASH,
  [anon_sym_DASH_EQ] = anon_sym_SLASH,
  [anon_sym_TILDE_EQ] = anon_sym_SLASH,
  [anon_sym_PIPE_EQ] = anon_sym_SLASH,
  [anon_sym_case] = anon_sym_package,
  [anon_sym_continue] = anon_sym_package,
  [anon_sym_break] = anon_sym_package,
  [anon_sym_when] = anon_sym_package,
  [anon_sym_do] = anon_sym_package,
  [anon_sym_switch] = anon_sym_package,
  [anon_sym_in] = anon_sym_package,
  [anon_sym_POUNDpartial] = anon_sym_POUNDpartial,
  [anon_sym_for] = anon_sym_package,
  [anon_sym_POUNDunroll] = anon_sym_POUNDunroll,
  [anon_sym_or_return] = anon_sym_SLASH,
  [anon_sym_PLUS] = anon_sym_SLASH,
  [anon_sym_DASH] = anon_sym_SLASH,
  [anon_sym_TILDE] = anon_sym_SLASH,
  [anon_sym_AMP] = anon_sym_SLASH,
  [anon_sym_or_else] = anon_sym_SLASH,
  [anon_sym_STAR] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_SLASH,
  [anon_sym_PERCENT_PERCENT] = anon_sym_SLASH,
  [anon_sym_LT_LT] = anon_sym_SLASH,
  [anon_sym_GT_GT] = anon_sym_SLASH,
  [anon_sym_AMP_TILDE] = anon_sym_SLASH,
  [anon_sym_not_in] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_SLASH,
  [anon_sym_GT] = anon_sym_SLASH,
  [anon_sym_LT] = anon_sym_SLASH,
  [anon_sym_LT_EQ] = anon_sym_SLASH,
  [anon_sym_GT_EQ] = anon_sym_SLASH,
  [anon_sym_EQ_EQ] = anon_sym_SLASH,
  [anon_sym_BANG_EQ] = anon_sym_SLASH,
  [anon_sym_DOT_DOT_LT] = anon_sym_SLASH,
  [anon_sym_DOT_DOT_EQ] = anon_sym_SLASH,
  [anon_sym_AMP_AMP] = anon_sym_SLASH,
  [anon_sym_PIPE_PIPE] = anon_sym_SLASH,
  [sym_builtin_procedure] = sym_builtin_procedure,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_interpreted_string_literal_token1] = aux_sym_interpreted_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_int_literal] = sym_int_literal,
  [sym_float_literal] = sym_float_literal,
  [sym_rune_literal] = sym_rune_literal,
  [sym_nil] = sym_nil,
  [sym__true] = sym__true,
  [sym__false] = sym__false,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym_package_clause] = sym_package_clause,
  [sym_import_declaration] = sym_import_declaration,
  [sym_foreign_block] = sym_foreign_block,
  [sym__simple_statement] = sym__simple_statement,
  [sym__statement] = sym__statement,
  [sym_defer_statement] = sym_defer_statement,
  [sym_using_statement] = sym_using_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_block_statement] = sym_block_statement,
  [sym_block] = sym_block,
  [sym__block_directive] = sym_builtin_procedure,
  [sym_pragma] = sym_pragma,
  [sym__declaration] = sym__declaration,
  [sym_var_declaration] = sym_var_declaration,
  [sym_const_declaration] = sym_const_declaration,
  [sym__simple_type] = sym__simple_type,
  [sym_generic_type] = sym_generic_type,
  [sym_pointer_type] = sym_pointer_type,
  [sym__pointer_directive] = sym_builtin_procedure,
  [sym_bit_set_type] = sym_bit_set_type,
  [sym_matrix_type] = sym_matrix_type,
  [sym_array_type] = sym_array_type,
  [sym__array_directive] = sym_builtin_procedure,
  [sym_union_type] = sym_union_type,
  [sym__union_directive] = sym_builtin_procedure,
  [sym_enum_type] = sym_enum_type,
  [sym_struct_type] = sym_struct_type,
  [sym_struct_field_declaration] = sym_struct_field_declaration,
  [sym__struct_directive] = sym_builtin_procedure,
  [sym_map_type] = sym_map_type,
  [sym__expression] = sym__expression,
  [sym__type_directive] = sym_builtin_procedure,
  [sym_selector_expression] = sym_selector_expression,
  [sym_type_conversion] = sym_type_conversion,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_index_expression] = sym_index_expression,
  [sym__parenthesized_expression] = sym__parenthesized_expression,
  [sym_proc_literal] = sym_proc_literal,
  [sym_where_clause] = sym_where_clause,
  [sym__proc_directive] = sym_builtin_procedure,
  [sym_proc_group] = sym_proc_group,
  [sym__proc_type] = sym__proc_type,
  [sym_parameter_list] = sym_parameter_list,
  [sym__parameter_list_directive] = sym_builtin_procedure,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym__parameter_directive] = sym_builtin_procedure,
  [sym__calling_convention] = sym__calling_convention,
  [sym_proc_call] = sym_proc_call,
  [sym_initializer_list] = sym_initializer_list,
  [sym_single_assignment] = sym_single_assignment,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym__expression_pack] = sym__expression_pack,
  [sym_case_statement] = sym_case_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym__switch_block] = sym_block,
  [sym__switch_directive] = sym_builtin_procedure,
  [sym_for_statement] = sym_for_statement,
  [sym__for_directive] = sym_builtin_procedure,
  [sym__for_full_clause] = sym__for_full_clause,
  [sym__for_empty_clause] = sym__for_empty_clause,
  [sym__for_conditional_clause] = sym__for_conditional_clause,
  [sym__for_conditional_and_update_clause] = sym__for_conditional_and_update_clause,
  [sym__for_init_and_update_clause] = sym__for_init_and_update_clause,
  [sym__for_init_clause] = sym__for_init_clause,
  [sym__range_clause] = sym__range_clause,
  [sym_right_unary_expression] = sym_right_unary_expression,
  [sym_left_unary_expression] = sym_left_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_compound_literal] = sym_compound_literal,
  [sym__pragma_identifier] = sym__pragma_identifier,
  [sym_interpreted_string_literal] = sym_interpreted_string_literal,
  [sym_bool_literal] = sym_bool_literal,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_foreign_block_repeat1] = aux_sym_foreign_block_repeat1,
  [aux_sym_foreign_block_repeat2] = aux_sym_foreign_block_repeat2,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_block_repeat2] = aux_sym_block_repeat2,
  [aux_sym_pragma_repeat1] = aux_sym_pragma_repeat1,
  [aux_sym_var_declaration_repeat1] = aux_sym_var_declaration_repeat1,
  [aux_sym_const_declaration_repeat1] = aux_sym_const_declaration_repeat1,
  [aux_sym_pointer_type_repeat1] = aux_sym_pointer_type_repeat1,
  [aux_sym_array_type_repeat1] = aux_sym_array_type_repeat1,
  [aux_sym_union_type_repeat1] = aux_sym_union_type_repeat1,
  [aux_sym_union_type_repeat2] = aux_sym_union_type_repeat2,
  [aux_sym_struct_type_repeat1] = aux_sym_struct_type_repeat1,
  [aux_sym_struct_type_repeat2] = aux_sym_struct_type_repeat2,
  [aux_sym_struct_field_declaration_repeat1] = aux_sym_struct_field_declaration_repeat1,
  [aux_sym_proc_literal_repeat1] = aux_sym_proc_literal_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_parameter_declaration_repeat1] = aux_sym_parameter_declaration_repeat1,
  [aux_sym_parameter_declaration_repeat2] = aux_sym_parameter_declaration_repeat2,
  [aux_sym_initializer_list_repeat1] = aux_sym_initializer_list_repeat1,
  [aux_sym__expression_pack_repeat1] = aux_sym__expression_pack_repeat1,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym__switch_block_repeat1] = aux_sym__switch_block_repeat1,
  [aux_sym_for_statement_repeat1] = aux_sym_for_statement_repeat1,
  [aux_sym__range_clause_repeat1] = aux_sym__range_clause_repeat1,
  [aux_sym_interpreted_string_literal_repeat1] = aux_sym_interpreted_string_literal_repeat1,
  [alias_sym_calling_convention] = alias_sym_calling_convention,
  [alias_sym_const_identifier] = alias_sym_const_identifier,
  [alias_sym_label_identifier] = alias_sym_label_identifier,
  [alias_sym_package_identifier] = alias_sym_package_identifier,
  [alias_sym_pragma_identifier] = alias_sym_pragma_identifier,
  [alias_sym_proc_type] = alias_sym_proc_type,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_foreign] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_blank_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_defer] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDno_bounds_check] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDbounds_check] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_distinct] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_uint] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_uintptr] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_typeid] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_rawptr] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_cstring] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i8] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u8] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_b8] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_b16] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_b32] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_b64] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i16] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i16le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i16be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i32] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i32le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i32be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i64] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i64le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i64be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i128] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i128le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_i128be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u16] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u16le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u16be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u32] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u32le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u32be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u64] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u64le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u64be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u128] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u128le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u128be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_f16] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_f16le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_f16be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_f32] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_f32le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_f32be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_f64] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_f64le] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_f64be] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_complex32] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_complex64] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_complex128] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_quaternion64] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_quaternion128] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_quaternion256] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDrelative] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bit_set] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_matrix] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_dynamic] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDsoa] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDsimd] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDno_nil] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDshared_nil] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDalign] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDno_copy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDpacked] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDraw_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDtype] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cast] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_transmute] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_auto_cast] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_where] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDforce_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDforce_no_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_proc] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDoptional_ok] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDno_alias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDby_ptr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDany_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDc_vararg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT_PERCENT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP_TILDE_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDpartial] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDunroll] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or_return] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_or_else] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT_PERCENT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP_TILDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_not_in] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_LT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_procedure] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_rune_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym__true] = {
    .visible = false,
    .named = true,
  },
  [sym__false] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_package_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_foreign_block] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_defer_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_using_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_block_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__block_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_pragma] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_const_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_type] = {
    .visible = false,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type] = {
    .visible = true,
    .named = true,
  },
  [sym__pointer_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_bit_set_type] = {
    .visible = true,
    .named = true,
  },
  [sym_matrix_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym__array_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym__union_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_type] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_type] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__struct_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_map_type] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__type_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__parenthesized_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_proc_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_where_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__proc_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_proc_group] = {
    .visible = true,
    .named = true,
  },
  [sym__proc_type] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_list_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__calling_convention] = {
    .visible = false,
    .named = true,
  },
  [sym_proc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_initializer_list] = {
    .visible = true,
    .named = true,
  },
  [sym_single_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_pack] = {
    .visible = false,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__switch_block] = {
    .visible = true,
    .named = true,
  },
  [sym__switch_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__for_full_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__for_empty_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__for_conditional_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__for_conditional_and_update_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__for_init_and_update_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__for_init_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__range_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_right_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_left_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__pragma_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_interpreted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_foreign_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_foreign_block_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pragma_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_var_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pointer_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_type_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_type_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_field_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_proc_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_declaration_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_initializer_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_pack_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__switch_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__range_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_calling_convention] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_const_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_label_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_package_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pragma_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_proc_type] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_arguments = 1,
  field_backing = 2,
  field_bind = 3,
  field_body = 4,
  field_caller = 5,
  field_condition = 6,
  field_contents = 7,
  field_end = 8,
  field_expression = 9,
  field_field = 10,
  field_if_false = 11,
  field_if_true = 12,
  field_index = 13,
  field_initializer = 14,
  field_key = 15,
  field_label = 16,
  field_left = 17,
  field_lhs = 18,
  field_member_proc = 19,
  field_name = 20,
  field_operand = 21,
  field_operator = 22,
  field_parameters = 23,
  field_parent = 24,
  field_path = 25,
  field_procedure = 26,
  field_range = 27,
  field_result = 28,
  field_rhs = 29,
  field_right = 30,
  field_size = 31,
  field_start = 32,
  field_tag = 33,
  field_type = 34,
  field_update = 35,
  field_value = 36,
  field_variants = 37,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arguments] = "arguments",
  [field_backing] = "backing",
  [field_bind] = "bind",
  [field_body] = "body",
  [field_caller] = "caller",
  [field_condition] = "condition",
  [field_contents] = "contents",
  [field_end] = "end",
  [field_expression] = "expression",
  [field_field] = "field",
  [field_if_false] = "if_false",
  [field_if_true] = "if_true",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_lhs] = "lhs",
  [field_member_proc] = "member_proc",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_parent] = "parent",
  [field_path] = "path",
  [field_procedure] = "procedure",
  [field_range] = "range",
  [field_result] = "result",
  [field_rhs] = "rhs",
  [field_right] = "right",
  [field_size] = "size",
  [field_start] = "start",
  [field_tag] = "tag",
  [field_type] = "type",
  [field_update] = "update",
  [field_value] = "value",
  [field_variants] = "variants",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 2},
  [5] = {.index = 1, .length = 2},
  [7] = {.index = 3, .length = 2},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 4},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 1},
  [15] = {.index = 14, .length = 3},
  [16] = {.index = 17, .length = 1},
  [17] = {.index = 18, .length = 1},
  [19] = {.index = 19, .length = 2},
  [20] = {.index = 21, .length = 2},
  [21] = {.index = 23, .length = 2},
  [22] = {.index = 5, .length = 2},
  [23] = {.index = 25, .length = 3},
  [24] = {.index = 28, .length = 5},
  [25] = {.index = 33, .length = 1},
  [26] = {.index = 34, .length = 2},
  [27] = {.index = 36, .length = 2},
  [28] = {.index = 38, .length = 1},
  [29] = {.index = 39, .length = 3},
  [30] = {.index = 42, .length = 1},
  [31] = {.index = 43, .length = 1},
  [32] = {.index = 44, .length = 1},
  [33] = {.index = 45, .length = 3},
  [34] = {.index = 45, .length = 3},
  [35] = {.index = 48, .length = 3},
  [36] = {.index = 51, .length = 2},
  [37] = {.index = 53, .length = 5},
  [38] = {.index = 53, .length = 5},
  [39] = {.index = 23, .length = 2},
  [40] = {.index = 58, .length = 3},
  [41] = {.index = 58, .length = 3},
  [43] = {.index = 61, .length = 2},
  [44] = {.index = 63, .length = 2},
  [45] = {.index = 65, .length = 1},
  [46] = {.index = 66, .length = 2},
  [47] = {.index = 68, .length = 4},
  [48] = {.index = 72, .length = 1},
  [49] = {.index = 73, .length = 1},
  [50] = {.index = 74, .length = 2},
  [51] = {.index = 76, .length = 4},
  [52] = {.index = 80, .length = 2},
  [53] = {.index = 82, .length = 2},
  [54] = {.index = 84, .length = 3},
  [55] = {.index = 87, .length = 1},
  [56] = {.index = 88, .length = 2},
  [57] = {.index = 90, .length = 1},
  [59] = {.index = 91, .length = 1},
  [60] = {.index = 92, .length = 1},
  [61] = {.index = 93, .length = 5},
  [62] = {.index = 98, .length = 1},
  [63] = {.index = 99, .length = 3},
  [64] = {.index = 102, .length = 4},
  [65] = {.index = 106, .length = 6},
  [66] = {.index = 112, .length = 3},
  [67] = {.index = 102, .length = 4},
  [68] = {.index = 106, .length = 6},
  [69] = {.index = 63, .length = 2},
  [70] = {.index = 115, .length = 2},
  [71] = {.index = 117, .length = 1},
  [72] = {.index = 118, .length = 2},
  [73] = {.index = 120, .length = 2},
  [74] = {.index = 122, .length = 4},
  [75] = {.index = 126, .length = 4},
  [76] = {.index = 130, .length = 6},
  [77] = {.index = 136, .length = 2},
  [78] = {.index = 138, .length = 4},
  [79] = {.index = 142, .length = 2},
  [80] = {.index = 144, .length = 2},
  [81] = {.index = 146, .length = 3},
  [82] = {.index = 149, .length = 3},
  [83] = {.index = 152, .length = 2},
  [84] = {.index = 154, .length = 2},
  [85] = {.index = 156, .length = 2},
  [86] = {.index = 158, .length = 2},
  [87] = {.index = 160, .length = 4},
  [88] = {.index = 164, .length = 1},
  [89] = {.index = 165, .length = 2},
  [90] = {.index = 167, .length = 3},
  [91] = {.index = 170, .length = 3},
  [92] = {.index = 173, .length = 2},
  [93] = {.index = 175, .length = 3},
  [94] = {.index = 178, .length = 2},
  [95] = {.index = 61, .length = 2},
  [96] = {.index = 180, .length = 2},
  [97] = {.index = 182, .length = 4},
  [98] = {.index = 186, .length = 4},
  [99] = {.index = 190, .length = 6},
  [100] = {.index = 196, .length = 2},
  [101] = {.index = 198, .length = 4},
  [102] = {.index = 202, .length = 2},
  [103] = {.index = 204, .length = 4},
  [104] = {.index = 208, .length = 2},
  [105] = {.index = 210, .length = 4},
  [106] = {.index = 214, .length = 3},
  [107] = {.index = 217, .length = 5},
  [108] = {.index = 222, .length = 1},
  [109] = {.index = 223, .length = 3},
  [110] = {.index = 226, .length = 5},
  [111] = {.index = 231, .length = 3},
  [112] = {.index = 234, .length = 5},
  [113] = {.index = 239, .length = 3},
  [114] = {.index = 242, .length = 3},
  [115] = {.index = 245, .length = 3},
  [117] = {.index = 248, .length = 2},
  [118] = {.index = 250, .length = 2},
  [119] = {.index = 252, .length = 1},
  [120] = {.index = 253, .length = 5},
  [121] = {.index = 258, .length = 2},
  [122] = {.index = 260, .length = 3},
  [123] = {.index = 263, .length = 4},
  [124] = {.index = 267, .length = 4},
  [125] = {.index = 271, .length = 3},
  [126] = {.index = 274, .length = 4},
  [127] = {.index = 278, .length = 3},
  [128] = {.index = 281, .length = 2},
  [129] = {.index = 283, .length = 4},
  [130] = {.index = 287, .length = 1},
  [131] = {.index = 288, .length = 2},
  [132] = {.index = 290, .length = 3},
  [133] = {.index = 293, .length = 3},
  [134] = {.index = 296, .length = 2},
  [135] = {.index = 298, .length = 3},
  [136] = {.index = 301, .length = 1},
  [137] = {.index = 302, .length = 3},
  [138] = {.index = 305, .length = 3},
  [139] = {.index = 308, .length = 5},
  [140] = {.index = 313, .length = 3},
  [141] = {.index = 316, .length = 5},
  [142] = {.index = 321, .length = 4},
  [143] = {.index = 325, .length = 6},
  [144] = {.index = 331, .length = 2},
  [145] = {.index = 333, .length = 3},
  [146] = {.index = 336, .length = 5},
  [147] = {.index = 341, .length = 1},
  [148] = {.index = 342, .length = 3},
  [149] = {.index = 345, .length = 4},
  [150] = {.index = 349, .length = 6},
  [151] = {.index = 355, .length = 2},
  [152] = {.index = 357, .length = 4},
  [153] = {.index = 361, .length = 3},
  [154] = {.index = 364, .length = 4},
  [155] = {.index = 368, .length = 3},
  [157] = {.index = 371, .length = 3},
  [158] = {.index = 374, .length = 3},
  [159] = {.index = 377, .length = 2},
  [160] = {.index = 379, .length = 3},
  [161] = {.index = 382, .length = 2},
  [162] = {.index = 384, .length = 4},
  [163] = {.index = 388, .length = 4},
  [164] = {.index = 392, .length = 4},
  [165] = {.index = 396, .length = 6},
  [166] = {.index = 402, .length = 3},
  [167] = {.index = 405, .length = 4},
  [168] = {.index = 409, .length = 5},
  [169] = {.index = 414, .length = 5},
  [170] = {.index = 419, .length = 4},
  [171] = {.index = 423, .length = 5},
  [172] = {.index = 428, .length = 2},
  [173] = {.index = 430, .length = 5},
  [174] = {.index = 435, .length = 2},
  [175] = {.index = 437, .length = 3},
  [176] = {.index = 440, .length = 4},
  [177] = {.index = 444, .length = 4},
  [178] = {.index = 448, .length = 3},
  [179] = {.index = 451, .length = 4},
  [180] = {.index = 455, .length = 4},
  [181] = {.index = 459, .length = 6},
  [182] = {.index = 465, .length = 3},
  [183] = {.index = 468, .length = 5},
  [184] = {.index = 473, .length = 3},
  [185] = {.index = 476, .length = 4},
  [186] = {.index = 480, .length = 6},
  [187] = {.index = 486, .length = 4},
  [188] = {.index = 490, .length = 6},
  [189] = {.index = 496, .length = 2},
  [190] = {.index = 498, .length = 3},
  [191] = {.index = 501, .length = 5},
  [192] = {.index = 506, .length = 3},
  [193] = {.index = 509, .length = 5},
  [194] = {.index = 514, .length = 4},
  [195] = {.index = 518, .length = 4},
  [196] = {.index = 522, .length = 4},
  [198] = {.index = 526, .length = 3},
  [199] = {.index = 529, .length = 5},
  [200] = {.index = 534, .length = 4},
  [201] = {.index = 538, .length = 7},
  [202] = {.index = 545, .length = 4},
  [203] = {.index = 549, .length = 5},
  [204] = {.index = 554, .length = 6},
  [205] = {.index = 560, .length = 6},
  [206] = {.index = 566, .length = 5},
  [207] = {.index = 571, .length = 6},
  [208] = {.index = 577, .length = 4},
  [209] = {.index = 581, .length = 6},
  [210] = {.index = 587, .length = 3},
  [211] = {.index = 590, .length = 4},
  [212] = {.index = 594, .length = 5},
  [213] = {.index = 599, .length = 5},
  [214] = {.index = 604, .length = 4},
  [215] = {.index = 608, .length = 5},
  [216] = {.index = 613, .length = 3},
  [217] = {.index = 616, .length = 3},
  [218] = {.index = 619, .length = 4},
  [219] = {.index = 623, .length = 6},
  [220] = {.index = 629, .length = 3},
  [221] = {.index = 632, .length = 5},
  [222] = {.index = 637, .length = 3},
  [223] = {.index = 640, .length = 4},
  [224] = {.index = 644, .length = 6},
  [225] = {.index = 650, .length = 5},
  [226] = {.index = 655, .length = 4},
  [227] = {.index = 659, .length = 5},
  [228] = {.index = 664, .length = 5},
  [229] = {.index = 669, .length = 5},
  [230] = {.index = 674, .length = 6},
  [231] = {.index = 680, .length = 5},
  [232] = {.index = 685, .length = 5},
  [233] = {.index = 690, .length = 5},
  [234] = {.index = 695, .length = 4},
  [235] = {.index = 699, .length = 7},
  [236] = {.index = 706, .length = 4},
  [237] = {.index = 710, .length = 5},
  [238] = {.index = 715, .length = 6},
  [239] = {.index = 721, .length = 6},
  [240] = {.index = 727, .length = 5},
  [241] = {.index = 732, .length = 6},
  [242] = {.index = 738, .length = 4},
  [243] = {.index = 742, .length = 6},
  [244] = {.index = 748, .length = 5},
  [245] = {.index = 753, .length = 5},
  [246] = {.index = 758, .length = 6},
  [247] = {.index = 764, .length = 6},
  [248] = {.index = 770, .length = 6},
  [249] = {.index = 776, .length = 6},
  [250] = {.index = 782, .length = 5},
  [251] = {.index = 787, .length = 5},
  [252] = {.index = 792, .length = 6},
  [253] = {.index = 798, .length = 6},
  [254] = {.index = 804, .length = 7},
  [255] = {.index = 811, .length = 6},
  [256] = {.index = 817, .length = 7},
  [257] = {.index = 824, .length = 7},
  [258] = {.index = 831, .length = 7},
  [259] = {.index = 838, .length = 7},
  [260] = {.index = 845, .length = 7},
  [261] = {.index = 852, .length = 8},
  [262] = {.index = 860, .length = 8},
  [263] = {.index = 868, .length = 8},
  [264] = {.index = 876, .length = 9},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_path, 1},
  [1] =
    {field_name, 1},
    {field_path, 2},
  [3] =
    {field_name, 0},
    {field_type, 2},
  [5] =
    {field_parameters, 0, .inherited = true},
    {field_result, 0, .inherited = true},
  [7] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_result, 2, .inherited = true},
    {field_type, 2},
  [11] =
    {field_name, 0},
    {field_value, 3},
  [13] =
    {field_type, 1},
  [14] =
    {field_parameters, 1, .inherited = true},
    {field_result, 1, .inherited = true},
    {field_type, 1},
  [17] =
    {field_field, 1},
  [18] =
    {field_parameters, 1},
  [19] =
    {field_operand, 1},
    {field_operator, 0},
  [21] =
    {field_operand, 0},
    {field_operator, 1},
  [23] =
    {field_parameters, 1, .inherited = true},
    {field_result, 1, .inherited = true},
  [25] =
    {field_name, 0},
    {field_name, 1},
    {field_type, 3},
  [28] =
    {field_name, 0},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_type, 3},
  [33] =
    {field_contents, 1},
  [34] =
    {field_name, 0},
    {field_value, 4},
  [36] =
    {field_parameters, 2, .inherited = true},
    {field_result, 2, .inherited = true},
  [38] =
    {field_type, 2},
  [39] =
    {field_parameters, 2, .inherited = true},
    {field_result, 2, .inherited = true},
    {field_type, 2},
  [42] =
    {field_parameters, 2},
  [43] =
    {field_procedure, 0},
  [44] =
    {field_type, 0},
  [45] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [48] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [51] =
    {field_field, 2},
    {field_parent, 0},
  [53] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_result, 2, .inherited = true},
    {field_type, 2},
    {field_value, 4},
  [58] =
    {field_name, 0},
    {field_name, 1},
    {field_value, 4},
  [61] =
    {field_lhs, 0},
    {field_rhs, 2},
  [63] =
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
  [65] =
    {field_range, 2},
  [66] =
    {field_size, 1},
    {field_type, 3},
  [68] =
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_size, 1},
    {field_type, 3},
  [72] =
    {field_variants, 2},
  [73] =
    {field_backing, 1},
  [74] =
    {field_parameters, 1},
    {field_result, 3},
  [76] =
    {field_parameters, 1},
    {field_parameters, 3, .inherited = true},
    {field_result, 3},
    {field_result, 3, .inherited = true},
  [80] =
    {field_arguments, 2},
    {field_procedure, 0},
  [82] =
    {field_contents, 2},
    {field_type, 0},
  [84] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 5},
  [87] =
    {field_operand, 0},
  [88] =
    {field_index, 2},
    {field_operand, 0},
  [90] =
    {field_value, 1},
  [91] =
    {field_body, 1},
  [92] =
    {field_condition, 0},
  [93] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_result, 2, .inherited = true},
    {field_type, 2},
    {field_value, 5},
  [98] =
    {field_type, 3},
  [99] =
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_type, 3},
  [102] =
    {field_name, 0},
    {field_name, 1},
    {field_type, 3},
    {field_value, 5},
  [106] =
    {field_name, 0},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_type, 3},
    {field_value, 5},
  [112] =
    {field_name, 0},
    {field_name, 1},
    {field_value, 5},
  [115] =
    {field_backing, 1},
    {field_variants, 3},
  [117] =
    {field_name, 1},
  [118] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [120] =
    {field_key, 2},
    {field_value, 4},
  [122] =
    {field_key, 2},
    {field_parameters, 4, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_value, 4},
  [126] =
    {field_key, 2},
    {field_parameters, 2, .inherited = true},
    {field_result, 2, .inherited = true},
    {field_value, 4},
  [130] =
    {field_key, 2},
    {field_parameters, 2, .inherited = true},
    {field_parameters, 4, .inherited = true},
    {field_result, 2, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_value, 4},
  [136] =
    {field_parameters, 2},
    {field_result, 4},
  [138] =
    {field_parameters, 2},
    {field_parameters, 4, .inherited = true},
    {field_result, 4},
    {field_result, 4, .inherited = true},
  [142] =
    {field_end, 3},
    {field_operand, 0},
  [144] =
    {field_operand, 0},
    {field_start, 2},
  [146] =
    {field_condition, 0},
    {field_if_false, 4},
    {field_if_true, 2},
  [149] =
    {field_condition, 2},
    {field_if_false, 4},
    {field_if_true, 0},
  [152] =
    {field_caller, 0},
    {field_member_proc, 2},
  [154] =
    {field_condition, 1},
    {field_if_true, 2},
  [156] =
    {field_body, 2},
    {field_expression, 1},
  [158] =
    {field_body, 1},
    {field_body, 2},
  [160] =
    {field_body, 2},
    {field_condition, 1, .inherited = true},
    {field_initializer, 1, .inherited = true},
    {field_update, 1, .inherited = true},
  [164] =
    {field_body, 2},
  [165] =
    {field_body, 2},
    {field_condition, 1, .inherited = true},
  [167] =
    {field_body, 2},
    {field_condition, 1, .inherited = true},
    {field_update, 1, .inherited = true},
  [170] =
    {field_body, 2},
    {field_initializer, 1, .inherited = true},
    {field_update, 1, .inherited = true},
  [173] =
    {field_body, 2},
    {field_initializer, 1, .inherited = true},
  [175] =
    {field_body, 2},
    {field_name, 1, .inherited = true},
    {field_range, 1, .inherited = true},
  [178] =
    {field_label, 0},
    {field_label, 1},
  [180] =
    {field_size, 2},
    {field_type, 4},
  [182] =
    {field_parameters, 4, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_size, 2},
    {field_type, 4},
  [186] =
    {field_name, 0},
    {field_name, 1},
    {field_type, 3},
    {field_value, 6},
  [190] =
    {field_name, 0},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_type, 3},
    {field_value, 6},
  [196] =
    {field_backing, 4},
    {field_type, 2},
  [198] =
    {field_backing, 4},
    {field_parameters, 4, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_type, 2},
  [202] =
    {field_backing, 4},
    {field_range, 2},
  [204] =
    {field_backing, 4},
    {field_parameters, 4, .inherited = true},
    {field_range, 2},
    {field_result, 4, .inherited = true},
  [208] =
    {field_name, 1},
    {field_type, 3},
  [210] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_type, 3},
  [214] =
    {field_name, 0},
    {field_tag, 3},
    {field_type, 2},
  [217] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_result, 2, .inherited = true},
    {field_tag, 3},
    {field_type, 2},
  [222] =
    {field_name, 2},
  [223] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_type, 3},
  [226] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_type, 3},
  [231] =
    {field_name, 0},
    {field_type, 2},
    {field_type, 3},
  [234] =
    {field_name, 0},
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_type, 2},
    {field_type, 3},
  [239] =
    {field_end, 4},
    {field_operand, 0},
    {field_start, 2},
  [242] =
    {field_arguments, 4},
    {field_caller, 0},
    {field_member_proc, 2},
  [245] =
    {field_condition, 1},
    {field_if_true, 2},
    {field_if_true, 3},
  [248] =
    {field_body, 3},
    {field_initializer, 1},
  [250] =
    {field_name, 0},
    {field_range, 2},
  [252] =
    {field_initializer, 0},
  [253] =
    {field_body, 2},
    {field_body, 3},
    {field_condition, 1, .inherited = true},
    {field_initializer, 1, .inherited = true},
    {field_update, 1, .inherited = true},
  [258] =
    {field_body, 2},
    {field_body, 3},
  [260] =
    {field_body, 2},
    {field_body, 3},
    {field_condition, 1, .inherited = true},
  [263] =
    {field_body, 2},
    {field_body, 3},
    {field_condition, 1, .inherited = true},
    {field_update, 1, .inherited = true},
  [267] =
    {field_body, 2},
    {field_body, 3},
    {field_initializer, 1, .inherited = true},
    {field_update, 1, .inherited = true},
  [271] =
    {field_body, 2},
    {field_body, 3},
    {field_initializer, 1, .inherited = true},
  [274] =
    {field_body, 2},
    {field_body, 3},
    {field_name, 1, .inherited = true},
    {field_range, 1, .inherited = true},
  [278] =
    {field_body, 3},
    {field_label, 0},
    {field_label, 1},
  [281] =
    {field_body, 3},
    {field_expression, 2},
  [283] =
    {field_body, 3},
    {field_condition, 2, .inherited = true},
    {field_initializer, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [287] =
    {field_body, 3},
  [288] =
    {field_body, 3},
    {field_condition, 2, .inherited = true},
  [290] =
    {field_body, 3},
    {field_condition, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [293] =
    {field_body, 3},
    {field_initializer, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [296] =
    {field_body, 3},
    {field_initializer, 2, .inherited = true},
  [298] =
    {field_body, 3},
    {field_name, 2, .inherited = true},
    {field_range, 2, .inherited = true},
  [301] =
    {field_type, 6},
  [302] =
    {field_parameters, 6, .inherited = true},
    {field_result, 6, .inherited = true},
    {field_type, 6},
  [305] =
    {field_name, 1},
    {field_tag, 4},
    {field_type, 3},
  [308] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_tag, 4},
    {field_type, 3},
  [313] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_type, 4},
  [316] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_parameters, 4, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_type, 4},
  [321] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_tag, 4},
    {field_type, 3},
  [325] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_tag, 4},
    {field_type, 3},
  [331] =
    {field_name, 1},
    {field_value, 4},
  [333] =
    {field_name, 1},
    {field_type, 3},
    {field_type, 4},
  [336] =
    {field_name, 1},
    {field_parameters, 4, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_type, 3},
    {field_type, 4},
  [341] =
    {field_name, 3},
  [342] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_value, 4},
  [345] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_type, 3},
    {field_type, 4},
  [349] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_parameters, 4, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_type, 3},
    {field_type, 4},
  [355] =
    {field_name, 2},
    {field_type, 4},
  [357] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_type, 4},
  [361] =
    {field_condition, 3},
    {field_if_true, 4},
    {field_initializer, 1},
  [364] =
    {field_condition, 1},
    {field_if_true, 2},
    {field_if_true, 3},
    {field_if_true, 4},
  [368] =
    {field_condition, 1},
    {field_if_false, 4},
    {field_if_true, 2},
  [371] =
    {field_bind, 1},
    {field_body, 4},
    {field_expression, 3},
  [374] =
    {field_body, 4},
    {field_expression, 3},
    {field_initializer, 1},
  [377] =
    {field_condition, 1},
    {field_update, 3},
  [379] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_range, 3},
  [382] =
    {field_initializer, 0},
    {field_update, 3},
  [384] =
    {field_condition, 3},
    {field_if_true, 4},
    {field_label, 0},
    {field_label, 1},
  [388] =
    {field_body, 4},
    {field_expression, 3},
    {field_label, 0},
    {field_label, 1},
  [392] =
    {field_body, 3},
    {field_body, 4},
    {field_label, 0},
    {field_label, 1},
  [396] =
    {field_body, 4},
    {field_condition, 3, .inherited = true},
    {field_initializer, 3, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 3, .inherited = true},
  [402] =
    {field_body, 4},
    {field_label, 0},
    {field_label, 1},
  [405] =
    {field_body, 4},
    {field_condition, 3, .inherited = true},
    {field_label, 0},
    {field_label, 1},
  [409] =
    {field_body, 4},
    {field_condition, 3, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 3, .inherited = true},
  [414] =
    {field_body, 4},
    {field_initializer, 3, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 3, .inherited = true},
  [419] =
    {field_body, 4},
    {field_initializer, 3, .inherited = true},
    {field_label, 0},
    {field_label, 1},
  [423] =
    {field_body, 4},
    {field_label, 0},
    {field_label, 1},
    {field_name, 3, .inherited = true},
    {field_range, 3, .inherited = true},
  [428] =
    {field_body, 4},
    {field_initializer, 2},
  [430] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 2, .inherited = true},
    {field_initializer, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [435] =
    {field_body, 3},
    {field_body, 4},
  [437] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 2, .inherited = true},
  [440] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [444] =
    {field_body, 3},
    {field_body, 4},
    {field_initializer, 2, .inherited = true},
    {field_update, 2, .inherited = true},
  [448] =
    {field_body, 3},
    {field_body, 4},
    {field_initializer, 2, .inherited = true},
  [451] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 2, .inherited = true},
    {field_range, 2, .inherited = true},
  [455] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_tag, 5},
    {field_type, 4},
  [459] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_parameters, 4, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_tag, 5},
    {field_type, 4},
  [465] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 5},
  [468] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_type, 3},
    {field_value, 5},
  [473] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_value, 5},
  [476] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_type, 4},
    {field_type, 5},
  [480] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_parameters, 5, .inherited = true},
    {field_result, 5, .inherited = true},
    {field_type, 4},
    {field_type, 5},
  [486] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_type, 3},
    {field_value, 5},
  [490] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_parameters, 3, .inherited = true},
    {field_result, 3, .inherited = true},
    {field_type, 3},
    {field_value, 5},
  [496] =
    {field_name, 2},
    {field_value, 5},
  [498] =
    {field_name, 2},
    {field_type, 4},
    {field_type, 5},
  [501] =
    {field_name, 2},
    {field_parameters, 5, .inherited = true},
    {field_result, 5, .inherited = true},
    {field_type, 4},
    {field_type, 5},
  [506] =
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_type, 5},
  [509] =
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_parameters, 5, .inherited = true},
    {field_result, 5, .inherited = true},
    {field_type, 5},
  [514] =
    {field_condition, 3},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_initializer, 1},
  [518] =
    {field_condition, 1},
    {field_if_false, 5},
    {field_if_true, 2},
    {field_if_true, 3},
  [522] =
    {field_condition, 1},
    {field_if_false, 4},
    {field_if_false, 5},
    {field_if_true, 2},
  [526] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [529] =
    {field_condition, 3},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_label, 0},
    {field_label, 1},
  [534] =
    {field_body, 5},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
  [538] =
    {field_body, 4},
    {field_body, 5},
    {field_condition, 3, .inherited = true},
    {field_initializer, 3, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 3, .inherited = true},
  [545] =
    {field_body, 4},
    {field_body, 5},
    {field_label, 0},
    {field_label, 1},
  [549] =
    {field_body, 4},
    {field_body, 5},
    {field_condition, 3, .inherited = true},
    {field_label, 0},
    {field_label, 1},
  [554] =
    {field_body, 4},
    {field_body, 5},
    {field_condition, 3, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 3, .inherited = true},
  [560] =
    {field_body, 4},
    {field_body, 5},
    {field_initializer, 3, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 3, .inherited = true},
  [566] =
    {field_body, 4},
    {field_body, 5},
    {field_initializer, 3, .inherited = true},
    {field_label, 0},
    {field_label, 1},
  [571] =
    {field_body, 4},
    {field_body, 5},
    {field_label, 0},
    {field_label, 1},
    {field_name, 3, .inherited = true},
    {field_range, 3, .inherited = true},
  [577] =
    {field_body, 5},
    {field_expression, 4},
    {field_label, 0},
    {field_label, 1},
  [581] =
    {field_body, 5},
    {field_condition, 4, .inherited = true},
    {field_initializer, 4, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 4, .inherited = true},
  [587] =
    {field_body, 5},
    {field_label, 0},
    {field_label, 1},
  [590] =
    {field_body, 5},
    {field_condition, 4, .inherited = true},
    {field_label, 0},
    {field_label, 1},
  [594] =
    {field_body, 5},
    {field_condition, 4, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 4, .inherited = true},
  [599] =
    {field_body, 5},
    {field_initializer, 4, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 4, .inherited = true},
  [604] =
    {field_body, 5},
    {field_initializer, 4, .inherited = true},
    {field_label, 0},
    {field_label, 1},
  [608] =
    {field_body, 5},
    {field_label, 0},
    {field_label, 1},
    {field_name, 4, .inherited = true},
    {field_range, 4, .inherited = true},
  [613] =
    {field_bind, 2},
    {field_body, 5},
    {field_expression, 4},
  [616] =
    {field_body, 5},
    {field_expression, 4},
    {field_initializer, 2},
  [619] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_type, 4},
    {field_value, 6},
  [623] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
    {field_parameters, 4, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_type, 4},
    {field_value, 6},
  [629] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 6},
  [632] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_result, 4, .inherited = true},
    {field_type, 4},
    {field_value, 6},
  [637] =
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_value, 6},
  [640] =
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_type, 5},
    {field_type, 6},
  [644] =
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_parameters, 6, .inherited = true},
    {field_result, 6, .inherited = true},
    {field_type, 5},
    {field_type, 6},
  [650] =
    {field_condition, 3},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_if_true, 6},
    {field_initializer, 1},
  [655] =
    {field_condition, 3},
    {field_if_false, 6},
    {field_if_true, 4},
    {field_initializer, 1},
  [659] =
    {field_condition, 1},
    {field_if_false, 6},
    {field_if_true, 2},
    {field_if_true, 3},
    {field_if_true, 4},
  [664] =
    {field_condition, 1},
    {field_if_false, 5},
    {field_if_false, 6},
    {field_if_true, 2},
    {field_if_true, 3},
  [669] =
    {field_condition, 5},
    {field_if_true, 6},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
  [674] =
    {field_condition, 3},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_if_true, 6},
    {field_label, 0},
    {field_label, 1},
  [680] =
    {field_condition, 3},
    {field_if_false, 6},
    {field_if_true, 4},
    {field_label, 0},
    {field_label, 1},
  [685] =
    {field_bind, 3},
    {field_body, 6},
    {field_expression, 5},
    {field_label, 0},
    {field_label, 1},
  [690] =
    {field_body, 6},
    {field_expression, 5},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
  [695] =
    {field_body, 6},
    {field_initializer, 4},
    {field_label, 0},
    {field_label, 1},
  [699] =
    {field_body, 5},
    {field_body, 6},
    {field_condition, 4, .inherited = true},
    {field_initializer, 4, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 4, .inherited = true},
  [706] =
    {field_body, 5},
    {field_body, 6},
    {field_label, 0},
    {field_label, 1},
  [710] =
    {field_body, 5},
    {field_body, 6},
    {field_condition, 4, .inherited = true},
    {field_label, 0},
    {field_label, 1},
  [715] =
    {field_body, 5},
    {field_body, 6},
    {field_condition, 4, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 4, .inherited = true},
  [721] =
    {field_body, 5},
    {field_body, 6},
    {field_initializer, 4, .inherited = true},
    {field_label, 0},
    {field_label, 1},
    {field_update, 4, .inherited = true},
  [727] =
    {field_body, 5},
    {field_body, 6},
    {field_initializer, 4, .inherited = true},
    {field_label, 0},
    {field_label, 1},
  [732] =
    {field_body, 5},
    {field_body, 6},
    {field_label, 0},
    {field_label, 1},
    {field_name, 4, .inherited = true},
    {field_range, 4, .inherited = true},
  [738] =
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_type, 5},
    {field_value, 7},
  [742] =
    {field_name, 2},
    {field_name, 3, .inherited = true},
    {field_parameters, 5, .inherited = true},
    {field_result, 5, .inherited = true},
    {field_type, 5},
    {field_value, 7},
  [748] =
    {field_condition, 3},
    {field_if_false, 7},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_initializer, 1},
  [753] =
    {field_condition, 3},
    {field_if_false, 6},
    {field_if_false, 7},
    {field_if_true, 4},
    {field_initializer, 1},
  [758] =
    {field_condition, 1},
    {field_if_false, 6},
    {field_if_false, 7},
    {field_if_true, 2},
    {field_if_true, 3},
    {field_if_true, 4},
  [764] =
    {field_condition, 5},
    {field_if_true, 6},
    {field_if_true, 7},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
  [770] =
    {field_condition, 3},
    {field_if_false, 7},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_label, 0},
    {field_label, 1},
  [776] =
    {field_condition, 3},
    {field_if_false, 6},
    {field_if_false, 7},
    {field_if_true, 4},
    {field_label, 0},
    {field_label, 1},
  [782] =
    {field_bind, 4},
    {field_body, 7},
    {field_expression, 6},
    {field_label, 0},
    {field_label, 1},
  [787] =
    {field_body, 7},
    {field_expression, 6},
    {field_initializer, 4},
    {field_label, 0},
    {field_label, 1},
  [792] =
    {field_condition, 3},
    {field_if_false, 8},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_if_true, 6},
    {field_initializer, 1},
  [798] =
    {field_condition, 3},
    {field_if_false, 7},
    {field_if_false, 8},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_initializer, 1},
  [804] =
    {field_condition, 5},
    {field_if_true, 6},
    {field_if_true, 7},
    {field_if_true, 8},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
  [811] =
    {field_condition, 5},
    {field_if_false, 8},
    {field_if_true, 6},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
  [817] =
    {field_condition, 3},
    {field_if_false, 8},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_if_true, 6},
    {field_label, 0},
    {field_label, 1},
  [824] =
    {field_condition, 3},
    {field_if_false, 7},
    {field_if_false, 8},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_label, 0},
    {field_label, 1},
  [831] =
    {field_condition, 3},
    {field_if_false, 8},
    {field_if_false, 9},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_if_true, 6},
    {field_initializer, 1},
  [838] =
    {field_condition, 5},
    {field_if_false, 9},
    {field_if_true, 6},
    {field_if_true, 7},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
  [845] =
    {field_condition, 5},
    {field_if_false, 8},
    {field_if_false, 9},
    {field_if_true, 6},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
  [852] =
    {field_condition, 3},
    {field_if_false, 8},
    {field_if_false, 9},
    {field_if_true, 4},
    {field_if_true, 5},
    {field_if_true, 6},
    {field_label, 0},
    {field_label, 1},
  [860] =
    {field_condition, 5},
    {field_if_false, 10},
    {field_if_true, 6},
    {field_if_true, 7},
    {field_if_true, 8},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
  [868] =
    {field_condition, 5},
    {field_if_false, 9},
    {field_if_false, 10},
    {field_if_true, 6},
    {field_if_true, 7},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
  [876] =
    {field_condition, 5},
    {field_if_false, 10},
    {field_if_false, 11},
    {field_if_true, 6},
    {field_if_true, 7},
    {field_if_true, 8},
    {field_initializer, 3},
    {field_label, 0},
    {field_label, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [1] = alias_sym_package_identifier,
  },
  [3] = {
    [0] = alias_sym_pragma_identifier,
  },
  [5] = {
    [1] = alias_sym_package_identifier,
  },
  [6] = {
    [0] = anon_sym_int,
  },
  [7] = {
    [1] = anon_sym_SLASH,
  },
  [8] = {
    [0] = alias_sym_proc_type,
  },
  [9] = {
    [1] = anon_sym_SLASH,
    [2] = alias_sym_proc_type,
  },
  [10] = {
    [1] = alias_sym_const_identifier,
  },
  [11] = {
    [0] = alias_sym_const_identifier,
    [1] = anon_sym_SLASH,
    [2] = anon_sym_SLASH,
  },
  [12] = {
    [1] = anon_sym_SLASH,
    [2] = anon_sym_SLASH,
  },
  [13] = {
    [1] = anon_sym_int,
  },
  [15] = {
    [1] = alias_sym_proc_type,
  },
  [18] = {
    [0] = alias_sym_calling_convention,
  },
  [19] = {
    [0] = anon_sym_SLASH,
  },
  [21] = {
    [1] = alias_sym_proc_type,
  },
  [23] = {
    [2] = anon_sym_SLASH,
  },
  [24] = {
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
  },
  [26] = {
    [0] = alias_sym_const_identifier,
    [1] = anon_sym_SLASH,
    [2] = anon_sym_SLASH,
  },
  [27] = {
    [2] = alias_sym_proc_type,
  },
  [29] = {
    [2] = alias_sym_proc_type,
  },
  [33] = {
    [0] = alias_sym_const_identifier,
    [1] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [34] = {
    [1] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [35] = {
    [1] = anon_sym_SLASH,
  },
  [37] = {
    [0] = alias_sym_const_identifier,
    [1] = anon_sym_SLASH,
    [2] = alias_sym_proc_type,
    [3] = anon_sym_SLASH,
  },
  [38] = {
    [1] = anon_sym_SLASH,
    [2] = alias_sym_proc_type,
    [3] = anon_sym_SLASH,
  },
  [40] = {
    [2] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [41] = {
    [0] = alias_sym_const_identifier,
    [2] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [42] = {
    [2] = alias_sym_package_identifier,
  },
  [44] = {
    [1] = anon_sym_int,
    [3] = alias_sym_proc_type,
  },
  [47] = {
    [3] = alias_sym_proc_type,
  },
  [51] = {
    [3] = alias_sym_proc_type,
  },
  [54] = {
    [0] = alias_sym_const_identifier,
    [1] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [55] = {
    [2] = anon_sym_SLASH,
  },
  [58] = {
    [1] = alias_sym_label_identifier,
  },
  [61] = {
    [0] = alias_sym_const_identifier,
    [1] = anon_sym_SLASH,
    [2] = alias_sym_proc_type,
    [3] = anon_sym_SLASH,
  },
  [63] = {
    [3] = alias_sym_proc_type,
  },
  [64] = {
    [2] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
  },
  [65] = {
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
    [4] = anon_sym_SLASH,
  },
  [66] = {
    [0] = alias_sym_const_identifier,
    [2] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [67] = {
    [0] = alias_sym_const_identifier,
    [2] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
  },
  [68] = {
    [0] = alias_sym_const_identifier,
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
    [4] = anon_sym_SLASH,
  },
  [69] = {
    [3] = alias_sym_proc_type,
  },
  [74] = {
    [4] = alias_sym_proc_type,
  },
  [75] = {
    [2] = alias_sym_proc_type,
  },
  [76] = {
    [2] = alias_sym_proc_type,
    [4] = alias_sym_proc_type,
  },
  [78] = {
    [4] = alias_sym_proc_type,
  },
  [79] = {
    [2] = anon_sym_SLASH,
  },
  [80] = {
    [3] = anon_sym_SLASH,
  },
  [81] = {
    [3] = anon_sym_SLASH,
  },
  [94] = {
    [0] = alias_sym_label_identifier,
  },
  [95] = {
    [1] = anon_sym_SLASH,
  },
  [97] = {
    [4] = alias_sym_proc_type,
  },
  [98] = {
    [0] = alias_sym_const_identifier,
    [2] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
  },
  [99] = {
    [0] = alias_sym_const_identifier,
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
    [4] = anon_sym_SLASH,
  },
  [101] = {
    [4] = alias_sym_proc_type,
  },
  [103] = {
    [4] = alias_sym_proc_type,
  },
  [104] = {
    [2] = anon_sym_SLASH,
  },
  [105] = {
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
  },
  [106] = {
    [1] = anon_sym_SLASH,
  },
  [107] = {
    [1] = anon_sym_SLASH,
    [2] = alias_sym_proc_type,
  },
  [109] = {
    [2] = anon_sym_SLASH,
  },
  [110] = {
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
  },
  [111] = {
    [1] = anon_sym_SLASH,
    [2] = anon_sym_SLASH,
  },
  [112] = {
    [1] = anon_sym_SLASH,
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
  },
  [113] = {
    [3] = anon_sym_SLASH,
  },
  [116] = {
    [1] = anon_sym_SLASH,
  },
  [127] = {
    [0] = alias_sym_label_identifier,
  },
  [137] = {
    [6] = alias_sym_proc_type,
  },
  [138] = {
    [2] = anon_sym_SLASH,
  },
  [139] = {
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
  },
  [140] = {
    [3] = anon_sym_SLASH,
  },
  [141] = {
    [3] = anon_sym_SLASH,
    [4] = alias_sym_proc_type,
  },
  [142] = {
    [2] = anon_sym_SLASH,
  },
  [143] = {
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
  },
  [144] = {
    [2] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [145] = {
    [2] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [146] = {
    [2] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
    [4] = alias_sym_proc_type,
  },
  [148] = {
    [2] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [149] = {
    [2] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [150] = {
    [2] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
    [4] = alias_sym_proc_type,
  },
  [151] = {
    [1] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
  },
  [152] = {
    [1] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
    [4] = alias_sym_proc_type,
  },
  [156] = {
    [2] = anon_sym_SLASH,
  },
  [162] = {
    [0] = alias_sym_label_identifier,
  },
  [163] = {
    [0] = alias_sym_label_identifier,
  },
  [164] = {
    [0] = alias_sym_label_identifier,
  },
  [165] = {
    [0] = alias_sym_label_identifier,
  },
  [166] = {
    [0] = alias_sym_label_identifier,
  },
  [167] = {
    [0] = alias_sym_label_identifier,
  },
  [168] = {
    [0] = alias_sym_label_identifier,
  },
  [169] = {
    [0] = alias_sym_label_identifier,
  },
  [170] = {
    [0] = alias_sym_label_identifier,
  },
  [171] = {
    [0] = alias_sym_label_identifier,
  },
  [180] = {
    [3] = anon_sym_SLASH,
  },
  [181] = {
    [3] = anon_sym_SLASH,
    [4] = alias_sym_proc_type,
  },
  [182] = {
    [2] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
  },
  [183] = {
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
    [4] = anon_sym_SLASH,
  },
  [184] = {
    [3] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
  },
  [185] = {
    [3] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
  },
  [186] = {
    [3] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
    [5] = alias_sym_proc_type,
  },
  [187] = {
    [2] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
  },
  [188] = {
    [2] = anon_sym_SLASH,
    [3] = alias_sym_proc_type,
    [4] = anon_sym_SLASH,
  },
  [189] = {
    [1] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
  },
  [190] = {
    [1] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
  },
  [191] = {
    [1] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
    [5] = alias_sym_proc_type,
  },
  [192] = {
    [1] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
  },
  [193] = {
    [1] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
    [5] = alias_sym_proc_type,
  },
  [197] = {
    [3] = anon_sym_SLASH,
  },
  [199] = {
    [0] = alias_sym_label_identifier,
  },
  [200] = {
    [0] = alias_sym_label_identifier,
  },
  [201] = {
    [0] = alias_sym_label_identifier,
  },
  [202] = {
    [0] = alias_sym_label_identifier,
  },
  [203] = {
    [0] = alias_sym_label_identifier,
  },
  [204] = {
    [0] = alias_sym_label_identifier,
  },
  [205] = {
    [0] = alias_sym_label_identifier,
  },
  [206] = {
    [0] = alias_sym_label_identifier,
  },
  [207] = {
    [0] = alias_sym_label_identifier,
  },
  [208] = {
    [0] = alias_sym_label_identifier,
  },
  [209] = {
    [0] = alias_sym_label_identifier,
  },
  [210] = {
    [0] = alias_sym_label_identifier,
  },
  [211] = {
    [0] = alias_sym_label_identifier,
  },
  [212] = {
    [0] = alias_sym_label_identifier,
  },
  [213] = {
    [0] = alias_sym_label_identifier,
  },
  [214] = {
    [0] = alias_sym_label_identifier,
  },
  [215] = {
    [0] = alias_sym_label_identifier,
  },
  [218] = {
    [3] = anon_sym_SLASH,
    [5] = anon_sym_SLASH,
  },
  [219] = {
    [3] = anon_sym_SLASH,
    [4] = alias_sym_proc_type,
    [5] = anon_sym_SLASH,
  },
  [220] = {
    [1] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
    [5] = anon_sym_SLASH,
  },
  [221] = {
    [1] = anon_sym_SLASH,
    [3] = anon_sym_SLASH,
    [4] = alias_sym_proc_type,
    [5] = anon_sym_SLASH,
  },
  [222] = {
    [1] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
    [5] = anon_sym_SLASH,
  },
  [223] = {
    [1] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
    [5] = anon_sym_SLASH,
  },
  [224] = {
    [1] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
    [5] = anon_sym_SLASH,
    [6] = alias_sym_proc_type,
  },
  [229] = {
    [0] = alias_sym_label_identifier,
  },
  [230] = {
    [0] = alias_sym_label_identifier,
  },
  [231] = {
    [0] = alias_sym_label_identifier,
  },
  [232] = {
    [0] = alias_sym_label_identifier,
  },
  [233] = {
    [0] = alias_sym_label_identifier,
  },
  [234] = {
    [0] = alias_sym_label_identifier,
  },
  [235] = {
    [0] = alias_sym_label_identifier,
  },
  [236] = {
    [0] = alias_sym_label_identifier,
  },
  [237] = {
    [0] = alias_sym_label_identifier,
  },
  [238] = {
    [0] = alias_sym_label_identifier,
  },
  [239] = {
    [0] = alias_sym_label_identifier,
  },
  [240] = {
    [0] = alias_sym_label_identifier,
  },
  [241] = {
    [0] = alias_sym_label_identifier,
  },
  [242] = {
    [1] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
    [6] = anon_sym_SLASH,
  },
  [243] = {
    [1] = anon_sym_SLASH,
    [4] = anon_sym_SLASH,
    [5] = alias_sym_proc_type,
    [6] = anon_sym_SLASH,
  },
  [247] = {
    [0] = alias_sym_label_identifier,
  },
  [248] = {
    [0] = alias_sym_label_identifier,
  },
  [249] = {
    [0] = alias_sym_label_identifier,
  },
  [250] = {
    [0] = alias_sym_label_identifier,
  },
  [251] = {
    [0] = alias_sym_label_identifier,
  },
  [254] = {
    [0] = alias_sym_label_identifier,
  },
  [255] = {
    [0] = alias_sym_label_identifier,
  },
  [256] = {
    [0] = alias_sym_label_identifier,
  },
  [257] = {
    [0] = alias_sym_label_identifier,
  },
  [259] = {
    [0] = alias_sym_label_identifier,
  },
  [260] = {
    [0] = alias_sym_label_identifier,
  },
  [261] = {
    [0] = alias_sym_label_identifier,
  },
  [262] = {
    [0] = alias_sym_label_identifier,
  },
  [263] = {
    [0] = alias_sym_label_identifier,
  },
  [264] = {
    [0] = alias_sym_label_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__proc_type, 2,
    sym__proc_type,
    alias_sym_proc_type,
  sym_interpreted_string_literal, 2,
    sym_interpreted_string_literal,
    alias_sym_calling_convention,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 7,
  [10] = 8,
  [11] = 6,
  [12] = 12,
  [13] = 12,
  [14] = 8,
  [15] = 8,
  [16] = 16,
  [17] = 17,
  [18] = 17,
  [19] = 19,
  [20] = 17,
  [21] = 19,
  [22] = 19,
  [23] = 23,
  [24] = 23,
  [25] = 19,
  [26] = 19,
  [27] = 17,
  [28] = 17,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 39,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 41,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 45,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 70,
  [77] = 63,
  [78] = 58,
  [79] = 56,
  [80] = 55,
  [81] = 54,
  [82] = 52,
  [83] = 47,
  [84] = 43,
  [85] = 42,
  [86] = 40,
  [87] = 38,
  [88] = 88,
  [89] = 36,
  [90] = 34,
  [91] = 75,
  [92] = 33,
  [93] = 50,
  [94] = 32,
  [95] = 95,
  [96] = 96,
  [97] = 31,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 37,
  [102] = 35,
  [103] = 74,
  [104] = 73,
  [105] = 72,
  [106] = 88,
  [107] = 71,
  [108] = 69,
  [109] = 67,
  [110] = 66,
  [111] = 100,
  [112] = 99,
  [113] = 98,
  [114] = 65,
  [115] = 64,
  [116] = 44,
  [117] = 96,
  [118] = 95,
  [119] = 62,
  [120] = 61,
  [121] = 48,
  [122] = 49,
  [123] = 60,
  [124] = 53,
  [125] = 57,
  [126] = 59,
  [127] = 6,
  [128] = 7,
  [129] = 7,
  [130] = 6,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 131,
  [135] = 135,
  [136] = 132,
  [137] = 135,
  [138] = 133,
  [139] = 139,
  [140] = 139,
  [141] = 141,
  [142] = 142,
  [143] = 142,
  [144] = 144,
  [145] = 145,
  [146] = 144,
  [147] = 145,
  [148] = 148,
  [149] = 148,
  [150] = 150,
  [151] = 150,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 154,
  [156] = 156,
  [157] = 157,
  [158] = 157,
  [159] = 157,
  [160] = 157,
  [161] = 156,
  [162] = 156,
  [163] = 163,
  [164] = 7,
  [165] = 6,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 166,
  [170] = 170,
  [171] = 167,
  [172] = 168,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 175,
  [177] = 177,
  [178] = 167,
  [179] = 167,
  [180] = 177,
  [181] = 173,
  [182] = 177,
  [183] = 167,
  [184] = 167,
  [185] = 167,
  [186] = 174,
  [187] = 175,
  [188] = 177,
  [189] = 177,
  [190] = 177,
  [191] = 177,
  [192] = 167,
  [193] = 170,
  [194] = 168,
  [195] = 167,
  [196] = 173,
  [197] = 167,
  [198] = 173,
  [199] = 199,
  [200] = 166,
  [201] = 166,
  [202] = 167,
  [203] = 167,
  [204] = 173,
  [205] = 175,
  [206] = 177,
  [207] = 168,
  [208] = 177,
  [209] = 170,
  [210] = 168,
  [211] = 170,
  [212] = 212,
  [213] = 173,
  [214] = 168,
  [215] = 177,
  [216] = 174,
  [217] = 177,
  [218] = 168,
  [219] = 166,
  [220] = 177,
  [221] = 175,
  [222] = 174,
  [223] = 168,
  [224] = 173,
  [225] = 174,
  [226] = 174,
  [227] = 167,
  [228] = 166,
  [229] = 166,
  [230] = 166,
  [231] = 174,
  [232] = 177,
  [233] = 177,
  [234] = 167,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 235,
  [239] = 239,
  [240] = 236,
  [241] = 241,
  [242] = 236,
  [243] = 243,
  [244] = 239,
  [245] = 241,
  [246] = 246,
  [247] = 235,
  [248] = 248,
  [249] = 248,
  [250] = 243,
  [251] = 248,
  [252] = 243,
  [253] = 237,
  [254] = 254,
  [255] = 237,
  [256] = 246,
  [257] = 235,
  [258] = 239,
  [259] = 246,
  [260] = 237,
  [261] = 248,
  [262] = 246,
  [263] = 243,
  [264] = 236,
  [265] = 241,
  [266] = 239,
  [267] = 241,
  [268] = 246,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 271,
  [276] = 271,
  [277] = 272,
  [278] = 278,
  [279] = 279,
  [280] = 272,
  [281] = 271,
  [282] = 282,
  [283] = 273,
  [284] = 272,
  [285] = 272,
  [286] = 286,
  [287] = 287,
  [288] = 271,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 282,
  [295] = 272,
  [296] = 279,
  [297] = 271,
  [298] = 298,
  [299] = 272,
  [300] = 300,
  [301] = 270,
  [302] = 302,
  [303] = 282,
  [304] = 304,
  [305] = 269,
  [306] = 272,
  [307] = 290,
  [308] = 298,
  [309] = 292,
  [310] = 287,
  [311] = 271,
  [312] = 289,
  [313] = 271,
  [314] = 314,
  [315] = 315,
  [316] = 273,
  [317] = 290,
  [318] = 293,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 302,
  [323] = 271,
  [324] = 324,
  [325] = 325,
  [326] = 319,
  [327] = 320,
  [328] = 328,
  [329] = 321,
  [330] = 324,
  [331] = 331,
  [332] = 331,
  [333] = 333,
  [334] = 282,
  [335] = 272,
  [336] = 336,
  [337] = 270,
  [338] = 274,
  [339] = 331,
  [340] = 279,
  [341] = 304,
  [342] = 314,
  [343] = 336,
  [344] = 272,
  [345] = 345,
  [346] = 271,
  [347] = 274,
  [348] = 289,
  [349] = 349,
  [350] = 274,
  [351] = 351,
  [352] = 271,
  [353] = 353,
  [354] = 279,
  [355] = 290,
  [356] = 272,
  [357] = 321,
  [358] = 282,
  [359] = 320,
  [360] = 319,
  [361] = 272,
  [362] = 271,
  [363] = 302,
  [364] = 364,
  [365] = 290,
  [366] = 314,
  [367] = 304,
  [368] = 368,
  [369] = 269,
  [370] = 282,
  [371] = 371,
  [372] = 272,
  [373] = 289,
  [374] = 273,
  [375] = 304,
  [376] = 298,
  [377] = 287,
  [378] = 270,
  [379] = 379,
  [380] = 331,
  [381] = 324,
  [382] = 336,
  [383] = 271,
  [384] = 324,
  [385] = 271,
  [386] = 290,
  [387] = 273,
  [388] = 292,
  [389] = 287,
  [390] = 289,
  [391] = 300,
  [392] = 324,
  [393] = 290,
  [394] = 292,
  [395] = 331,
  [396] = 278,
  [397] = 314,
  [398] = 293,
  [399] = 302,
  [400] = 400,
  [401] = 298,
  [402] = 379,
  [403] = 319,
  [404] = 282,
  [405] = 272,
  [406] = 320,
  [407] = 321,
  [408] = 325,
  [409] = 333,
  [410] = 410,
  [411] = 269,
  [412] = 333,
  [413] = 336,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 421,
  [425] = 425,
  [426] = 425,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 428,
  [431] = 429,
  [432] = 432,
  [433] = 429,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 415,
  [440] = 429,
  [441] = 441,
  [442] = 432,
  [443] = 443,
  [444] = 444,
  [445] = 438,
  [446] = 437,
  [447] = 438,
  [448] = 437,
  [449] = 449,
  [450] = 450,
  [451] = 415,
  [452] = 436,
  [453] = 437,
  [454] = 438,
  [455] = 432,
  [456] = 415,
  [457] = 429,
  [458] = 428,
  [459] = 432,
  [460] = 428,
  [461] = 428,
  [462] = 432,
  [463] = 437,
  [464] = 438,
  [465] = 436,
  [466] = 435,
  [467] = 425,
  [468] = 434,
  [469] = 423,
  [470] = 420,
  [471] = 421,
  [472] = 419,
  [473] = 417,
  [474] = 443,
  [475] = 450,
  [476] = 476,
  [477] = 477,
  [478] = 416,
  [479] = 417,
  [480] = 419,
  [481] = 420,
  [482] = 423,
  [483] = 416,
  [484] = 476,
  [485] = 485,
  [486] = 486,
  [487] = 450,
  [488] = 488,
  [489] = 443,
  [490] = 415,
  [491] = 491,
  [492] = 434,
  [493] = 435,
  [494] = 436,
  [495] = 495,
  [496] = 496,
  [497] = 428,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 432,
  [502] = 488,
  [503] = 503,
  [504] = 449,
  [505] = 441,
  [506] = 429,
  [507] = 507,
  [508] = 438,
  [509] = 429,
  [510] = 438,
  [511] = 437,
  [512] = 432,
  [513] = 428,
  [514] = 429,
  [515] = 437,
  [516] = 429,
  [517] = 429,
  [518] = 429,
  [519] = 519,
  [520] = 520,
  [521] = 443,
  [522] = 450,
  [523] = 476,
  [524] = 416,
  [525] = 417,
  [526] = 419,
  [527] = 429,
  [528] = 420,
  [529] = 422,
  [530] = 423,
  [531] = 427,
  [532] = 444,
  [533] = 437,
  [534] = 423,
  [535] = 420,
  [536] = 441,
  [537] = 419,
  [538] = 422,
  [539] = 438,
  [540] = 540,
  [541] = 438,
  [542] = 437,
  [543] = 418,
  [544] = 436,
  [545] = 417,
  [546] = 546,
  [547] = 435,
  [548] = 434,
  [549] = 423,
  [550] = 503,
  [551] = 551,
  [552] = 420,
  [553] = 419,
  [554] = 432,
  [555] = 555,
  [556] = 417,
  [557] = 416,
  [558] = 428,
  [559] = 503,
  [560] = 476,
  [561] = 450,
  [562] = 443,
  [563] = 563,
  [564] = 416,
  [565] = 476,
  [566] = 450,
  [567] = 443,
  [568] = 520,
  [569] = 569,
  [570] = 570,
  [571] = 428,
  [572] = 432,
  [573] = 432,
  [574] = 427,
  [575] = 575,
  [576] = 437,
  [577] = 438,
  [578] = 436,
  [579] = 435,
  [580] = 434,
  [581] = 444,
  [582] = 422,
  [583] = 443,
  [584] = 450,
  [585] = 476,
  [586] = 586,
  [587] = 416,
  [588] = 427,
  [589] = 417,
  [590] = 586,
  [591] = 419,
  [592] = 420,
  [593] = 423,
  [594] = 434,
  [595] = 435,
  [596] = 444,
  [597] = 422,
  [598] = 434,
  [599] = 428,
  [600] = 427,
  [601] = 443,
  [602] = 450,
  [603] = 436,
  [604] = 434,
  [605] = 435,
  [606] = 436,
  [607] = 435,
  [608] = 476,
  [609] = 416,
  [610] = 449,
  [611] = 611,
  [612] = 496,
  [613] = 449,
  [614] = 417,
  [615] = 615,
  [616] = 415,
  [617] = 425,
  [618] = 421,
  [619] = 520,
  [620] = 419,
  [621] = 569,
  [622] = 570,
  [623] = 623,
  [624] = 624,
  [625] = 586,
  [626] = 420,
  [627] = 436,
  [628] = 519,
  [629] = 507,
  [630] = 423,
  [631] = 631,
  [632] = 632,
  [633] = 449,
  [634] = 415,
  [635] = 635,
  [636] = 636,
  [637] = 425,
  [638] = 444,
  [639] = 421,
  [640] = 520,
  [641] = 569,
  [642] = 435,
  [643] = 570,
  [644] = 495,
  [645] = 586,
  [646] = 519,
  [647] = 507,
  [648] = 441,
  [649] = 422,
  [650] = 441,
  [651] = 425,
  [652] = 449,
  [653] = 429,
  [654] = 519,
  [655] = 575,
  [656] = 488,
  [657] = 421,
  [658] = 507,
  [659] = 415,
  [660] = 438,
  [661] = 437,
  [662] = 432,
  [663] = 428,
  [664] = 425,
  [665] = 421,
  [666] = 520,
  [667] = 444,
  [668] = 570,
  [669] = 569,
  [670] = 444,
  [671] = 671,
  [672] = 496,
  [673] = 427,
  [674] = 495,
  [675] = 503,
  [676] = 520,
  [677] = 569,
  [678] = 586,
  [679] = 443,
  [680] = 450,
  [681] = 476,
  [682] = 416,
  [683] = 488,
  [684] = 441,
  [685] = 417,
  [686] = 488,
  [687] = 419,
  [688] = 422,
  [689] = 420,
  [690] = 423,
  [691] = 519,
  [692] = 449,
  [693] = 449,
  [694] = 415,
  [695] = 425,
  [696] = 421,
  [697] = 415,
  [698] = 418,
  [699] = 699,
  [700] = 540,
  [701] = 520,
  [702] = 503,
  [703] = 569,
  [704] = 540,
  [705] = 570,
  [706] = 546,
  [707] = 520,
  [708] = 555,
  [709] = 586,
  [710] = 699,
  [711] = 519,
  [712] = 712,
  [713] = 507,
  [714] = 714,
  [715] = 425,
  [716] = 421,
  [717] = 441,
  [718] = 520,
  [719] = 719,
  [720] = 569,
  [721] = 423,
  [722] = 570,
  [723] = 611,
  [724] = 586,
  [725] = 519,
  [726] = 441,
  [727] = 441,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 418,
  [733] = 507,
  [734] = 441,
  [735] = 507,
  [736] = 569,
  [737] = 422,
  [738] = 427,
  [739] = 507,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 570,
  [745] = 519,
  [746] = 520,
  [747] = 449,
  [748] = 748,
  [749] = 570,
  [750] = 421,
  [751] = 425,
  [752] = 428,
  [753] = 432,
  [754] = 586,
  [755] = 575,
  [756] = 575,
  [757] = 570,
  [758] = 569,
  [759] = 444,
  [760] = 438,
  [761] = 437,
  [762] = 569,
  [763] = 436,
  [764] = 764,
  [765] = 435,
  [766] = 432,
  [767] = 428,
  [768] = 437,
  [769] = 496,
  [770] = 441,
  [771] = 507,
  [772] = 519,
  [773] = 586,
  [774] = 712,
  [775] = 570,
  [776] = 569,
  [777] = 714,
  [778] = 520,
  [779] = 421,
  [780] = 425,
  [781] = 540,
  [782] = 449,
  [783] = 438,
  [784] = 611,
  [785] = 496,
  [786] = 415,
  [787] = 495,
  [788] = 586,
  [789] = 488,
  [790] = 444,
  [791] = 570,
  [792] = 422,
  [793] = 520,
  [794] = 427,
  [795] = 427,
  [796] = 488,
  [797] = 444,
  [798] = 443,
  [799] = 450,
  [800] = 476,
  [801] = 416,
  [802] = 417,
  [803] = 419,
  [804] = 420,
  [805] = 423,
  [806] = 422,
  [807] = 443,
  [808] = 450,
  [809] = 476,
  [810] = 416,
  [811] = 417,
  [812] = 419,
  [813] = 434,
  [814] = 435,
  [815] = 436,
  [816] = 420,
  [817] = 418,
  [818] = 422,
  [819] = 540,
  [820] = 427,
  [821] = 575,
  [822] = 436,
  [823] = 823,
  [824] = 824,
  [825] = 421,
  [826] = 425,
  [827] = 415,
  [828] = 586,
  [829] = 503,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 443,
  [835] = 488,
  [836] = 435,
  [837] = 450,
  [838] = 476,
  [839] = 839,
  [840] = 840,
  [841] = 449,
  [842] = 416,
  [843] = 417,
  [844] = 441,
  [845] = 507,
  [846] = 419,
  [847] = 420,
  [848] = 423,
  [849] = 507,
  [850] = 519,
  [851] = 444,
  [852] = 427,
  [853] = 569,
  [854] = 570,
  [855] = 422,
  [856] = 503,
  [857] = 575,
  [858] = 488,
  [859] = 519,
  [860] = 495,
  [861] = 507,
  [862] = 503,
  [863] = 488,
  [864] = 418,
  [865] = 719,
  [866] = 866,
  [867] = 496,
  [868] = 503,
  [869] = 449,
  [870] = 449,
  [871] = 586,
  [872] = 434,
  [873] = 586,
  [874] = 503,
  [875] = 575,
  [876] = 611,
  [877] = 540,
  [878] = 496,
  [879] = 879,
  [880] = 444,
  [881] = 415,
  [882] = 503,
  [883] = 425,
  [884] = 421,
  [885] = 443,
  [886] = 520,
  [887] = 450,
  [888] = 476,
  [889] = 416,
  [890] = 427,
  [891] = 891,
  [892] = 892,
  [893] = 569,
  [894] = 570,
  [895] = 586,
  [896] = 519,
  [897] = 495,
  [898] = 417,
  [899] = 488,
  [900] = 507,
  [901] = 419,
  [902] = 488,
  [903] = 420,
  [904] = 570,
  [905] = 423,
  [906] = 444,
  [907] = 495,
  [908] = 488,
  [909] = 569,
  [910] = 503,
  [911] = 519,
  [912] = 441,
  [913] = 449,
  [914] = 507,
  [915] = 488,
  [916] = 611,
  [917] = 476,
  [918] = 503,
  [919] = 503,
  [920] = 434,
  [921] = 435,
  [922] = 436,
  [923] = 519,
  [924] = 441,
  [925] = 520,
  [926] = 429,
  [927] = 540,
  [928] = 928,
  [929] = 418,
  [930] = 427,
  [931] = 421,
  [932] = 425,
  [933] = 415,
  [934] = 422,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 943,
  [949] = 942,
  [950] = 950,
  [951] = 950,
  [952] = 952,
  [953] = 953,
  [954] = 946,
  [955] = 955,
  [956] = 939,
  [957] = 957,
  [958] = 958,
  [959] = 957,
  [960] = 958,
  [961] = 944,
  [962] = 940,
  [963] = 947,
  [964] = 945,
  [965] = 952,
  [966] = 941,
  [967] = 941,
  [968] = 944,
  [969] = 941,
  [970] = 944,
  [971] = 945,
  [972] = 943,
  [973] = 939,
  [974] = 946,
  [975] = 941,
  [976] = 946,
  [977] = 942,
  [978] = 957,
  [979] = 953,
  [980] = 958,
  [981] = 958,
  [982] = 955,
  [983] = 945,
  [984] = 939,
  [985] = 946,
  [986] = 958,
  [987] = 943,
  [988] = 943,
  [989] = 957,
  [990] = 942,
  [991] = 944,
  [992] = 942,
  [993] = 945,
  [994] = 939,
  [995] = 957,
  [996] = 996,
  [997] = 997,
  [998] = 996,
  [999] = 999,
  [1000] = 999,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1003,
  [1006] = 1004,
  [1007] = 1002,
  [1008] = 1001,
  [1009] = 997,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1011,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1028,
  [1031] = 1026,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1010,
  [1040] = 1037,
  [1041] = 1041,
  [1042] = 1038,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1022,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1016,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1035,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1013,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1020,
  [1067] = 1019,
  [1068] = 1048,
  [1069] = 1069,
  [1070] = 1049,
  [1071] = 1071,
  [1072] = 1059,
  [1073] = 1073,
  [1074] = 1021,
  [1075] = 1071,
  [1076] = 1073,
  [1077] = 1062,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1017,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1082,
  [1088] = 1084,
  [1089] = 1025,
  [1090] = 1090,
  [1091] = 1052,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1015,
  [1096] = 1012,
  [1097] = 1079,
  [1098] = 1044,
  [1099] = 1014,
  [1100] = 1033,
  [1101] = 1090,
  [1102] = 1102,
  [1103] = 1047,
  [1104] = 1055,
  [1105] = 1056,
  [1106] = 1057,
  [1107] = 1064,
  [1108] = 1061,
  [1109] = 1024,
  [1110] = 1060,
  [1111] = 1046,
  [1112] = 1081,
  [1113] = 1085,
  [1114] = 1050,
  [1115] = 1053,
  [1116] = 1092,
  [1117] = 1102,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1043,
  [1122] = 1063,
  [1123] = 1041,
  [1124] = 1029,
  [1125] = 1118,
  [1126] = 1065,
  [1127] = 1093,
  [1128] = 1023,
  [1129] = 1069,
  [1130] = 1119,
  [1131] = 1131,
  [1132] = 1083,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1027,
  [1136] = 1120,
  [1137] = 1134,
  [1138] = 1078,
  [1139] = 1036,
  [1140] = 1034,
  [1141] = 1032,
  [1142] = 1142,
  [1143] = 1094,
  [1144] = 1086,
  [1145] = 1024,
  [1146] = 1021,
  [1147] = 1023,
  [1148] = 1025,
  [1149] = 1019,
  [1150] = 1043,
  [1151] = 1085,
  [1152] = 1119,
  [1153] = 1081,
  [1154] = 1024,
  [1155] = 1118,
  [1156] = 1156,
  [1157] = 1102,
  [1158] = 1041,
  [1159] = 1159,
  [1160] = 1043,
  [1161] = 1161,
  [1162] = 1120,
  [1163] = 1163,
  [1164] = 1082,
  [1165] = 1131,
  [1166] = 1023,
  [1167] = 1069,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1063,
  [1172] = 1053,
  [1173] = 1173,
  [1174] = 1050,
  [1175] = 1046,
  [1176] = 1033,
  [1177] = 1064,
  [1178] = 1014,
  [1179] = 1090,
  [1180] = 1084,
  [1181] = 1181,
  [1182] = 1057,
  [1183] = 1056,
  [1184] = 1055,
  [1185] = 1047,
  [1186] = 1186,
  [1187] = 1044,
  [1188] = 1079,
  [1189] = 1012,
  [1190] = 1073,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1015,
  [1194] = 1194,
  [1195] = 1025,
  [1196] = 1196,
  [1197] = 1028,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1026,
  [1201] = 1071,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1021,
  [1205] = 1205,
  [1206] = 1206,
  [1207] = 1059,
  [1208] = 1049,
  [1209] = 1048,
  [1210] = 1013,
  [1211] = 1022,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1205,
  [1218] = 1142,
  [1219] = 1219,
  [1220] = 1220,
  [1221] = 1026,
  [1222] = 1028,
  [1223] = 1020,
  [1224] = 1224,
  [1225] = 1017,
  [1226] = 1226,
  [1227] = 1011,
  [1228] = 1019,
  [1229] = 1011,
  [1230] = 1230,
  [1231] = 1022,
  [1232] = 1017,
  [1233] = 1233,
  [1234] = 1025,
  [1235] = 1015,
  [1236] = 1013,
  [1237] = 1092,
  [1238] = 1238,
  [1239] = 1048,
  [1240] = 1012,
  [1241] = 1049,
  [1242] = 1079,
  [1243] = 1059,
  [1244] = 1044,
  [1245] = 1245,
  [1246] = 1021,
  [1247] = 1247,
  [1248] = 1047,
  [1249] = 1071,
  [1250] = 1055,
  [1251] = 1073,
  [1252] = 1056,
  [1253] = 1057,
  [1254] = 1082,
  [1255] = 1064,
  [1256] = 1256,
  [1257] = 1024,
  [1258] = 1084,
  [1259] = 1090,
  [1260] = 1014,
  [1261] = 1033,
  [1262] = 1020,
  [1263] = 1046,
  [1264] = 1081,
  [1265] = 1050,
  [1266] = 1085,
  [1267] = 1092,
  [1268] = 1053,
  [1269] = 1037,
  [1270] = 1038,
  [1271] = 1063,
  [1272] = 1069,
  [1273] = 1023,
  [1274] = 1102,
  [1275] = 1118,
  [1276] = 1010,
  [1277] = 1119,
  [1278] = 1278,
  [1279] = 1120,
  [1280] = 1041,
  [1281] = 1010,
  [1282] = 1278,
  [1283] = 1283,
  [1284] = 1284,
  [1285] = 1285,
  [1286] = 1224,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1038,
  [1290] = 1220,
  [1291] = 1192,
  [1292] = 1168,
  [1293] = 1293,
  [1294] = 1191,
  [1295] = 1295,
  [1296] = 1159,
  [1297] = 1297,
  [1298] = 1219,
  [1299] = 1283,
  [1300] = 1285,
  [1301] = 1037,
  [1302] = 1216,
  [1303] = 1032,
  [1304] = 1156,
  [1305] = 1186,
  [1306] = 1288,
  [1307] = 1034,
  [1308] = 1198,
  [1309] = 1205,
  [1310] = 1310,
  [1311] = 1199,
  [1312] = 1312,
  [1313] = 1230,
  [1314] = 1247,
  [1315] = 1202,
  [1316] = 1316,
  [1317] = 1203,
  [1318] = 1318,
  [1319] = 1213,
  [1320] = 1256,
  [1321] = 1194,
  [1322] = 1295,
  [1323] = 1323,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1326,
  [1327] = 1206,
  [1328] = 1181,
  [1329] = 1329,
  [1330] = 1212,
  [1331] = 1233,
  [1332] = 1205,
  [1333] = 1214,
  [1334] = 1163,
  [1335] = 1326,
  [1336] = 1215,
  [1337] = 1238,
  [1338] = 1245,
  [1339] = 1142,
  [1340] = 1196,
  [1341] = 1173,
  [1342] = 1342,
  [1343] = 1170,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1169,
  [1347] = 1347,
  [1348] = 1348,
  [1349] = 1349,
  [1350] = 1347,
  [1351] = 1351,
  [1352] = 1349,
  [1353] = 1353,
  [1354] = 1353,
  [1355] = 1348,
  [1356] = 1293,
  [1357] = 945,
  [1358] = 1226,
  [1359] = 941,
  [1360] = 1034,
  [1361] = 1205,
  [1362] = 939,
  [1363] = 1010,
  [1364] = 1038,
  [1365] = 943,
  [1366] = 1037,
  [1367] = 946,
  [1368] = 957,
  [1369] = 958,
  [1370] = 1032,
  [1371] = 944,
  [1372] = 1372,
  [1373] = 942,
  [1374] = 1318,
  [1375] = 958,
  [1376] = 946,
  [1377] = 946,
  [1378] = 942,
  [1379] = 939,
  [1380] = 943,
  [1381] = 957,
  [1382] = 1382,
  [1383] = 941,
  [1384] = 1382,
  [1385] = 957,
  [1386] = 1325,
  [1387] = 1342,
  [1388] = 1325,
  [1389] = 1389,
  [1390] = 945,
  [1391] = 1312,
  [1392] = 958,
  [1393] = 1342,
  [1394] = 939,
  [1395] = 1395,
  [1396] = 1310,
  [1397] = 1310,
  [1398] = 950,
  [1399] = 1345,
  [1400] = 947,
  [1401] = 1312,
  [1402] = 940,
  [1403] = 1329,
  [1404] = 952,
  [1405] = 1324,
  [1406] = 1323,
  [1407] = 1316,
  [1408] = 1287,
  [1409] = 1284,
  [1410] = 1318,
  [1411] = 942,
  [1412] = 1345,
  [1413] = 944,
  [1414] = 1344,
  [1415] = 941,
  [1416] = 1344,
  [1417] = 945,
  [1418] = 943,
  [1419] = 944,
  [1420] = 1329,
  [1421] = 1324,
  [1422] = 1323,
  [1423] = 1316,
  [1424] = 1287,
  [1425] = 1284,
  [1426] = 957,
  [1427] = 1427,
  [1428] = 941,
  [1429] = 943,
  [1430] = 944,
  [1431] = 945,
  [1432] = 946,
  [1433] = 942,
  [1434] = 939,
  [1435] = 958,
  [1436] = 1389,
  [1437] = 1437,
  [1438] = 955,
  [1439] = 1037,
  [1440] = 1001,
  [1441] = 1010,
  [1442] = 1442,
  [1443] = 1443,
  [1444] = 953,
  [1445] = 955,
  [1446] = 1443,
  [1447] = 1447,
  [1448] = 1448,
  [1449] = 1449,
  [1450] = 1450,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1452,
  [1454] = 1443,
  [1455] = 1455,
  [1456] = 1456,
  [1457] = 1443,
  [1458] = 1456,
  [1459] = 1452,
  [1460] = 1443,
  [1461] = 1452,
  [1462] = 1389,
  [1463] = 1427,
  [1464] = 1452,
  [1465] = 1456,
  [1466] = 1452,
  [1467] = 1456,
  [1468] = 997,
  [1469] = 999,
  [1470] = 1389,
  [1471] = 1471,
  [1472] = 1456,
  [1473] = 1456,
  [1474] = 1452,
  [1475] = 1003,
  [1476] = 1456,
  [1477] = 1443,
  [1478] = 1478,
  [1479] = 1004,
  [1480] = 1038,
  [1481] = 996,
  [1482] = 1443,
  [1483] = 1002,
  [1484] = 1484,
  [1485] = 1485,
  [1486] = 1486,
  [1487] = 1427,
  [1488] = 1488,
  [1489] = 1489,
  [1490] = 1427,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1493,
  [1494] = 1494,
  [1495] = 1495,
  [1496] = 1496,
  [1497] = 958,
  [1498] = 1057,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1059,
  [1502] = 1502,
  [1503] = 1499,
  [1504] = 1504,
  [1505] = 1021,
  [1506] = 1037,
  [1507] = 1499,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1038,
  [1511] = 1500,
  [1512] = 1502,
  [1513] = 1509,
  [1514] = 1499,
  [1515] = 1499,
  [1516] = 1508,
  [1517] = 1071,
  [1518] = 1065,
  [1519] = 1078,
  [1520] = 1083,
  [1521] = 1508,
  [1522] = 1052,
  [1523] = 1508,
  [1524] = 1010,
  [1525] = 1093,
  [1526] = 957,
  [1527] = 939,
  [1528] = 1499,
  [1529] = 942,
  [1530] = 1499,
  [1531] = 1029,
  [1532] = 1035,
  [1533] = 1036,
  [1534] = 946,
  [1535] = 1509,
  [1536] = 1502,
  [1537] = 955,
  [1538] = 945,
  [1539] = 1499,
  [1540] = 944,
  [1541] = 943,
  [1542] = 1502,
  [1543] = 1499,
  [1544] = 1509,
  [1545] = 1500,
  [1546] = 1508,
  [1547] = 941,
  [1548] = 1500,
  [1549] = 1508,
  [1550] = 1499,
  [1551] = 1060,
  [1552] = 1061,
  [1553] = 1508,
  [1554] = 1499,
  [1555] = 1508,
  [1556] = 1508,
  [1557] = 1499,
  [1558] = 1499,
  [1559] = 1034,
  [1560] = 1502,
  [1561] = 1094,
  [1562] = 1508,
  [1563] = 1073,
  [1564] = 1508,
  [1565] = 1508,
  [1566] = 1508,
  [1567] = 1509,
  [1568] = 1502,
  [1569] = 1082,
  [1570] = 1509,
  [1571] = 1084,
  [1572] = 1509,
  [1573] = 1508,
  [1574] = 1032,
  [1575] = 1028,
  [1576] = 1026,
  [1577] = 1022,
  [1578] = 1013,
  [1579] = 1502,
  [1580] = 1086,
  [1581] = 1020,
  [1582] = 1019,
  [1583] = 1011,
  [1584] = 1017,
  [1585] = 1293,
  [1586] = 1025,
  [1587] = 1048,
  [1588] = 1015,
  [1589] = 1012,
  [1590] = 1027,
  [1591] = 1134,
  [1592] = 1079,
  [1593] = 1044,
  [1594] = 1047,
  [1595] = 1055,
  [1596] = 1056,
  [1597] = 1049,
  [1598] = 1064,
  [1599] = 1024,
  [1600] = 1081,
  [1601] = 1085,
  [1602] = 1092,
  [1603] = 1102,
  [1604] = 1118,
  [1605] = 1119,
  [1606] = 1120,
  [1607] = 1043,
  [1608] = 1041,
  [1609] = 1090,
  [1610] = 1023,
  [1611] = 1069,
  [1612] = 1063,
  [1613] = 1053,
  [1614] = 1050,
  [1615] = 1046,
  [1616] = 1033,
  [1617] = 1014,
  [1618] = 952,
  [1619] = 950,
  [1620] = 1206,
  [1621] = 1032,
  [1622] = 1034,
  [1623] = 1032,
  [1624] = 1094,
  [1625] = 1034,
  [1626] = 1086,
  [1627] = 1293,
  [1628] = 1233,
  [1629] = 1256,
  [1630] = 1372,
  [1631] = 1278,
  [1632] = 1019,
  [1633] = 1028,
  [1634] = 1034,
  [1635] = 1032,
  [1636] = 1069,
  [1637] = 1026,
  [1638] = 1022,
  [1639] = 1013,
  [1640] = 1048,
  [1641] = 1049,
  [1642] = 1059,
  [1643] = 1021,
  [1644] = 1071,
  [1645] = 1073,
  [1646] = 1082,
  [1647] = 1084,
  [1648] = 1090,
  [1649] = 1014,
  [1650] = 1033,
  [1651] = 1038,
  [1652] = 1010,
  [1653] = 1037,
  [1654] = 1046,
  [1655] = 1050,
  [1656] = 1020,
  [1657] = 1011,
  [1658] = 1053,
  [1659] = 1017,
  [1660] = 1025,
  [1661] = 1015,
  [1662] = 1012,
  [1663] = 1079,
  [1664] = 1044,
  [1665] = 1047,
  [1666] = 1055,
  [1667] = 1056,
  [1668] = 1057,
  [1669] = 1063,
  [1670] = 1064,
  [1671] = 1024,
  [1672] = 1081,
  [1673] = 1085,
  [1674] = 1092,
  [1675] = 1102,
  [1676] = 1118,
  [1677] = 1119,
  [1678] = 1120,
  [1679] = 1043,
  [1680] = 1041,
  [1681] = 1023,
  [1682] = 1034,
  [1683] = 1032,
  [1684] = 1024,
  [1685] = 1085,
  [1686] = 1079,
  [1687] = 1022,
  [1688] = 1012,
  [1689] = 1013,
  [1690] = 1048,
  [1691] = 1043,
  [1692] = 1019,
  [1693] = 1026,
  [1694] = 1063,
  [1695] = 1064,
  [1696] = 1053,
  [1697] = 1325,
  [1698] = 1032,
  [1699] = 1342,
  [1700] = 1057,
  [1701] = 1345,
  [1702] = 1037,
  [1703] = 1034,
  [1704] = 1071,
  [1705] = 1705,
  [1706] = 1034,
  [1707] = 1120,
  [1708] = 1049,
  [1709] = 1059,
  [1710] = 1329,
  [1711] = 1015,
  [1712] = 1020,
  [1713] = 1119,
  [1714] = 1025,
  [1715] = 1715,
  [1716] = 1046,
  [1717] = 1033,
  [1718] = 1324,
  [1719] = 1310,
  [1720] = 1014,
  [1721] = 1090,
  [1722] = 1323,
  [1723] = 1312,
  [1724] = 1316,
  [1725] = 1312,
  [1726] = 1310,
  [1727] = 1287,
  [1728] = 1284,
  [1729] = 1318,
  [1730] = 1069,
  [1731] = 1118,
  [1732] = 1329,
  [1733] = 1084,
  [1734] = 1021,
  [1735] = 1344,
  [1736] = 1082,
  [1737] = 1011,
  [1738] = 1050,
  [1739] = 1324,
  [1740] = 1102,
  [1741] = 1741,
  [1742] = 1041,
  [1743] = 1056,
  [1744] = 1073,
  [1745] = 1017,
  [1746] = 1032,
  [1747] = 1318,
  [1748] = 1705,
  [1749] = 1715,
  [1750] = 1323,
  [1751] = 1284,
  [1752] = 1028,
  [1753] = 1316,
  [1754] = 1092,
  [1755] = 1044,
  [1756] = 1023,
  [1757] = 1081,
  [1758] = 1287,
  [1759] = 1038,
  [1760] = 1055,
  [1761] = 1010,
  [1762] = 1382,
  [1763] = 1325,
  [1764] = 1342,
  [1765] = 1345,
  [1766] = 1047,
  [1767] = 1344,
  [1768] = 1324,
  [1769] = 1323,
  [1770] = 1316,
  [1771] = 1214,
  [1772] = 1287,
  [1773] = 1284,
  [1774] = 1318,
  [1775] = 1212,
  [1776] = 1329,
  [1777] = 1215,
  [1778] = 1203,
  [1779] = 1202,
  [1780] = 1213,
  [1781] = 1199,
  [1782] = 1741,
  [1783] = 1216,
  [1784] = 1198,
  [1785] = 1219,
  [1786] = 1220,
  [1787] = 1293,
  [1788] = 1224,
  [1789] = 1789,
  [1790] = 1437,
  [1791] = 1052,
  [1792] = 1230,
  [1793] = 1310,
  [1794] = 1169,
  [1795] = 1032,
  [1796] = 1312,
  [1797] = 1382,
  [1798] = 1238,
  [1799] = 1034,
  [1800] = 1741,
  [1801] = 1245,
  [1802] = 1293,
  [1803] = 1196,
  [1804] = 1247,
  [1805] = 1163,
  [1806] = 1382,
  [1807] = 1372,
  [1808] = 1344,
  [1809] = 1170,
  [1810] = 1173,
  [1811] = 1194,
  [1812] = 1345,
  [1813] = 1156,
  [1814] = 1159,
  [1815] = 1168,
  [1816] = 1342,
  [1817] = 1325,
  [1818] = 1027,
  [1819] = 1181,
  [1820] = 1037,
  [1821] = 1038,
  [1822] = 1010,
  [1823] = 1186,
  [1824] = 1192,
  [1825] = 1191,
  [1826] = 1215,
  [1827] = 1284,
  [1828] = 1789,
  [1829] = 1325,
  [1830] = 1342,
  [1831] = 1168,
  [1832] = 1325,
  [1833] = 1159,
  [1834] = 1156,
  [1835] = 1345,
  [1836] = 1344,
  [1837] = 1310,
  [1838] = 1256,
  [1839] = 1342,
  [1840] = 1169,
  [1841] = 1163,
  [1842] = 1173,
  [1843] = 1345,
  [1844] = 1344,
  [1845] = 1845,
  [1846] = 1312,
  [1847] = 1226,
  [1848] = 1848,
  [1849] = 1247,
  [1850] = 1850,
  [1851] = 1196,
  [1852] = 1213,
  [1853] = 1233,
  [1854] = 1245,
  [1855] = 1170,
  [1856] = 1238,
  [1857] = 1382,
  [1858] = 1312,
  [1859] = 1181,
  [1860] = 1278,
  [1861] = 1186,
  [1862] = 1191,
  [1863] = 1372,
  [1864] = 1192,
  [1865] = 1310,
  [1866] = 1437,
  [1867] = 1230,
  [1868] = 1293,
  [1869] = 1194,
  [1870] = 1329,
  [1871] = 1224,
  [1872] = 1848,
  [1873] = 1220,
  [1874] = 1219,
  [1875] = 1324,
  [1876] = 1216,
  [1877] = 1877,
  [1878] = 1789,
  [1879] = 1323,
  [1880] = 1316,
  [1881] = 1038,
  [1882] = 1010,
  [1883] = 1037,
  [1884] = 1287,
  [1885] = 1329,
  [1886] = 1206,
  [1887] = 1324,
  [1888] = 1437,
  [1889] = 1212,
  [1890] = 1198,
  [1891] = 1199,
  [1892] = 1318,
  [1893] = 1318,
  [1894] = 1284,
  [1895] = 1287,
  [1896] = 1202,
  [1897] = 1203,
  [1898] = 1214,
  [1899] = 1316,
  [1900] = 1323,
  [1901] = 1168,
  [1902] = 1902,
  [1903] = 1032,
  [1904] = 1034,
  [1905] = 1032,
  [1906] = 1906,
  [1907] = 1907,
  [1908] = 1206,
  [1909] = 1212,
  [1910] = 1256,
  [1911] = 1318,
  [1912] = 1284,
  [1913] = 1287,
  [1914] = 1214,
  [1915] = 1906,
  [1916] = 1316,
  [1917] = 1917,
  [1918] = 1918,
  [1919] = 1741,
  [1920] = 1920,
  [1921] = 1215,
  [1922] = 1329,
  [1923] = 1163,
  [1924] = 1924,
  [1925] = 1344,
  [1926] = 1924,
  [1927] = 1196,
  [1928] = 1324,
  [1929] = 1345,
  [1930] = 1156,
  [1931] = 1931,
  [1932] = 1329,
  [1933] = 1159,
  [1934] = 1934,
  [1935] = 1203,
  [1936] = 1902,
  [1937] = 1181,
  [1938] = 1216,
  [1939] = 1920,
  [1940] = 1940,
  [1941] = 1219,
  [1942] = 1202,
  [1943] = 1220,
  [1944] = 1224,
  [1945] = 1199,
  [1946] = 1230,
  [1947] = 1310,
  [1948] = 1312,
  [1949] = 1342,
  [1950] = 1198,
  [1951] = 1924,
  [1952] = 1325,
  [1953] = 1213,
  [1954] = 1247,
  [1955] = 1245,
  [1956] = 1924,
  [1957] = 1906,
  [1958] = 1958,
  [1959] = 1902,
  [1960] = 1437,
  [1961] = 1924,
  [1962] = 1920,
  [1963] = 1906,
  [1964] = 1920,
  [1965] = 1965,
  [1966] = 1344,
  [1967] = 1323,
  [1968] = 1194,
  [1969] = 1192,
  [1970] = 1902,
  [1971] = 1345,
  [1972] = 1906,
  [1973] = 1173,
  [1974] = 1233,
  [1975] = 1342,
  [1976] = 1325,
  [1977] = 1977,
  [1978] = 1312,
  [1979] = 1310,
  [1980] = 1920,
  [1981] = 1902,
  [1982] = 1191,
  [1983] = 1038,
  [1984] = 1010,
  [1985] = 1037,
  [1986] = 1986,
  [1987] = 1924,
  [1988] = 1924,
  [1989] = 1318,
  [1990] = 1990,
  [1991] = 1991,
  [1992] = 1284,
  [1993] = 1906,
  [1994] = 1287,
  [1995] = 1995,
  [1996] = 1316,
  [1997] = 1902,
  [1998] = 1238,
  [1999] = 1186,
  [2000] = 1170,
  [2001] = 1169,
  [2002] = 1278,
  [2003] = 2003,
  [2004] = 1323,
  [2005] = 1324,
  [2006] = 1906,
  [2007] = 1902,
  [2008] = 2008,
  [2009] = 1131,
  [2010] = 1034,
  [2011] = 2011,
  [2012] = 1316,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 1437,
  [2016] = 2014,
  [2017] = 2014,
  [2018] = 2018,
  [2019] = 2019,
  [2020] = 1329,
  [2021] = 1312,
  [2022] = 1310,
  [2023] = 2023,
  [2024] = 2014,
  [2025] = 2025,
  [2026] = 1382,
  [2027] = 2014,
  [2028] = 1789,
  [2029] = 1344,
  [2030] = 2030,
  [2031] = 1345,
  [2032] = 2014,
  [2033] = 2033,
  [2034] = 1342,
  [2035] = 2014,
  [2036] = 1287,
  [2037] = 1284,
  [2038] = 2038,
  [2039] = 1318,
  [2040] = 1325,
  [2041] = 2041,
  [2042] = 2042,
  [2043] = 1010,
  [2044] = 1038,
  [2045] = 2045,
  [2046] = 1324,
  [2047] = 1323,
  [2048] = 2048,
  [2049] = 2049,
  [2050] = 2050,
  [2051] = 2051,
  [2052] = 2052,
  [2053] = 2051,
  [2054] = 2054,
  [2055] = 2054,
  [2056] = 2056,
  [2057] = 2048,
  [2058] = 2058,
  [2059] = 2059,
  [2060] = 2060,
  [2061] = 2061,
  [2062] = 2062,
  [2063] = 2063,
  [2064] = 2064,
  [2065] = 2065,
  [2066] = 2066,
  [2067] = 2067,
  [2068] = 2068,
  [2069] = 2050,
  [2070] = 2056,
  [2071] = 2071,
  [2072] = 2072,
  [2073] = 2073,
  [2074] = 2074,
  [2075] = 1437,
  [2076] = 2076,
  [2077] = 2077,
  [2078] = 2056,
  [2079] = 2056,
  [2080] = 2058,
  [2081] = 2058,
  [2082] = 2076,
  [2083] = 2052,
  [2084] = 2084,
  [2085] = 2076,
  [2086] = 2086,
  [2087] = 2087,
  [2088] = 2068,
  [2089] = 2058,
  [2090] = 2050,
  [2091] = 2091,
  [2092] = 2076,
  [2093] = 2061,
  [2094] = 2056,
  [2095] = 2084,
  [2096] = 2096,
  [2097] = 2068,
  [2098] = 2067,
  [2099] = 2068,
  [2100] = 2100,
  [2101] = 2050,
  [2102] = 2049,
  [2103] = 2068,
  [2104] = 2056,
  [2105] = 2050,
  [2106] = 2058,
  [2107] = 2107,
  [2108] = 2058,
  [2109] = 2050,
  [2110] = 2084,
  [2111] = 2111,
  [2112] = 2058,
  [2113] = 2076,
  [2114] = 2068,
  [2115] = 2115,
  [2116] = 1226,
  [2117] = 2056,
  [2118] = 2058,
  [2119] = 2058,
  [2120] = 2058,
  [2121] = 2056,
  [2122] = 2076,
  [2123] = 2123,
  [2124] = 2056,
  [2125] = 2125,
  [2126] = 2056,
  [2127] = 2084,
  [2128] = 2058,
  [2129] = 2129,
  [2130] = 2076,
  [2131] = 2058,
  [2132] = 2056,
  [2133] = 2056,
  [2134] = 2058,
  [2135] = 2135,
  [2136] = 2096,
  [2137] = 2050,
  [2138] = 2056,
  [2139] = 2056,
  [2140] = 2068,
  [2141] = 2141,
  [2142] = 2141,
  [2143] = 2143,
  [2144] = 2144,
  [2145] = 2143,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 2144,
  [2149] = 2147,
  [2150] = 2150,
  [2151] = 2150,
  [2152] = 2141,
  [2153] = 2146,
  [2154] = 2146,
  [2155] = 2143,
  [2156] = 2143,
  [2157] = 2144,
  [2158] = 2158,
  [2159] = 2147,
  [2160] = 2147,
  [2161] = 2144,
  [2162] = 1325,
  [2163] = 2143,
  [2164] = 1342,
  [2165] = 2144,
  [2166] = 2166,
  [2167] = 2146,
  [2168] = 2141,
  [2169] = 1345,
  [2170] = 1344,
  [2171] = 2147,
  [2172] = 2150,
  [2173] = 2147,
  [2174] = 2144,
  [2175] = 2144,
  [2176] = 2176,
  [2177] = 2144,
  [2178] = 2146,
  [2179] = 1131,
  [2180] = 2158,
  [2181] = 2146,
  [2182] = 2150,
  [2183] = 1318,
  [2184] = 2146,
  [2185] = 2147,
  [2186] = 2150,
  [2187] = 2144,
  [2188] = 2188,
  [2189] = 1284,
  [2190] = 1287,
  [2191] = 2141,
  [2192] = 2143,
  [2193] = 2143,
  [2194] = 2141,
  [2195] = 1316,
  [2196] = 1323,
  [2197] = 2197,
  [2198] = 1324,
  [2199] = 2146,
  [2200] = 2141,
  [2201] = 2143,
  [2202] = 2150,
  [2203] = 1329,
  [2204] = 2197,
  [2205] = 2147,
  [2206] = 2144,
  [2207] = 2141,
  [2208] = 2143,
  [2209] = 2150,
  [2210] = 2147,
  [2211] = 2197,
  [2212] = 2158,
  [2213] = 2150,
  [2214] = 2150,
  [2215] = 2197,
  [2216] = 2166,
  [2217] = 2150,
  [2218] = 2147,
  [2219] = 2150,
  [2220] = 2158,
  [2221] = 2150,
  [2222] = 2166,
  [2223] = 2150,
  [2224] = 2143,
  [2225] = 2146,
  [2226] = 2146,
  [2227] = 2147,
  [2228] = 2166,
  [2229] = 2229,
  [2230] = 2141,
  [2231] = 2143,
  [2232] = 2188,
  [2233] = 2188,
  [2234] = 2146,
  [2235] = 2197,
  [2236] = 2141,
  [2237] = 2166,
  [2238] = 2144,
  [2239] = 2197,
  [2240] = 2143,
  [2241] = 2144,
  [2242] = 2188,
  [2243] = 2141,
  [2244] = 1310,
  [2245] = 2147,
  [2246] = 2158,
  [2247] = 2188,
  [2248] = 2146,
  [2249] = 1312,
  [2250] = 2144,
  [2251] = 2197,
  [2252] = 2146,
  [2253] = 2147,
  [2254] = 2143,
  [2255] = 2141,
  [2256] = 2144,
  [2257] = 2147,
  [2258] = 2150,
  [2259] = 2141,
  [2260] = 2146,
  [2261] = 2261,
  [2262] = 2261,
  [2263] = 1345,
  [2264] = 2261,
  [2265] = 1318,
  [2266] = 2261,
  [2267] = 2261,
  [2268] = 1284,
  [2269] = 1287,
  [2270] = 1316,
  [2271] = 1342,
  [2272] = 1329,
  [2273] = 1323,
  [2274] = 1325,
  [2275] = 1324,
  [2276] = 1312,
  [2277] = 2261,
  [2278] = 1344,
  [2279] = 2261,
  [2280] = 1310,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2284,
  [2285] = 2285,
  [2286] = 2285,
  [2287] = 2285,
  [2288] = 2288,
  [2289] = 2289,
  [2290] = 2290,
  [2291] = 2291,
  [2292] = 2292,
  [2293] = 2293,
  [2294] = 2294,
  [2295] = 2295,
  [2296] = 2292,
  [2297] = 2293,
  [2298] = 2291,
  [2299] = 2299,
  [2300] = 2300,
  [2301] = 2288,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2304,
  [2305] = 2305,
  [2306] = 2305,
  [2307] = 2300,
  [2308] = 2294,
  [2309] = 2289,
  [2310] = 2310,
  [2311] = 2311,
  [2312] = 2302,
  [2313] = 2290,
  [2314] = 2295,
  [2315] = 2299,
  [2316] = 2316,
  [2317] = 2316,
  [2318] = 2316,
  [2319] = 2316,
  [2320] = 2320,
  [2321] = 2316,
  [2322] = 2322,
  [2323] = 2323,
  [2324] = 2323,
  [2325] = 2323,
  [2326] = 2326,
  [2327] = 2327,
  [2328] = 2323,
  [2329] = 2323,
  [2330] = 2323,
  [2331] = 2323,
  [2332] = 2332,
  [2333] = 2333,
  [2334] = 2334,
  [2335] = 2334,
  [2336] = 2333,
  [2337] = 2334,
  [2338] = 2333,
  [2339] = 2334,
  [2340] = 2333,
  [2341] = 2333,
  [2342] = 2334,
  [2343] = 2343,
  [2344] = 2344,
  [2345] = 2345,
  [2346] = 2346,
  [2347] = 2347,
  [2348] = 1094,
  [2349] = 2349,
  [2350] = 2350,
  [2351] = 1086,
  [2352] = 2352,
  [2353] = 2353,
  [2354] = 2354,
  [2355] = 2355,
  [2356] = 2346,
  [2357] = 2357,
  [2358] = 2344,
  [2359] = 2345,
  [2360] = 2346,
  [2361] = 2361,
  [2362] = 2362,
  [2363] = 2363,
  [2364] = 2364,
  [2365] = 2365,
  [2366] = 2366,
  [2367] = 996,
  [2368] = 2368,
  [2369] = 2369,
  [2370] = 2370,
  [2371] = 2371,
  [2372] = 997,
  [2373] = 2361,
  [2374] = 2345,
  [2375] = 999,
  [2376] = 2376,
  [2377] = 1003,
  [2378] = 2363,
  [2379] = 2364,
  [2380] = 2365,
  [2381] = 2343,
  [2382] = 2370,
  [2383] = 2383,
  [2384] = 2361,
  [2385] = 2385,
  [2386] = 2376,
  [2387] = 2387,
  [2388] = 2282,
  [2389] = 2389,
  [2390] = 2390,
  [2391] = 2391,
  [2392] = 2392,
  [2393] = 2393,
  [2394] = 2346,
  [2395] = 2395,
  [2396] = 2361,
  [2397] = 2361,
  [2398] = 2398,
  [2399] = 2353,
  [2400] = 1001,
  [2401] = 2346,
  [2402] = 2345,
  [2403] = 2403,
  [2404] = 2366,
  [2405] = 2383,
  [2406] = 2353,
  [2407] = 2407,
  [2408] = 2361,
  [2409] = 1002,
  [2410] = 1004,
  [2411] = 2411,
  [2412] = 2345,
  [2413] = 2413,
  [2414] = 2393,
  [2415] = 2346,
  [2416] = 2357,
  [2417] = 2355,
  [2418] = 2354,
  [2419] = 2352,
  [2420] = 2392,
  [2421] = 2350,
  [2422] = 2344,
  [2423] = 2349,
  [2424] = 2347,
  [2425] = 2353,
  [2426] = 2391,
  [2427] = 2390,
  [2428] = 2361,
  [2429] = 2344,
  [2430] = 2389,
  [2431] = 2362,
  [2432] = 2345,
  [2433] = 2283,
  [2434] = 2345,
  [2435] = 2369,
  [2436] = 2346,
  [2437] = 2371,
  [2438] = 2395,
  [2439] = 2385,
  [2440] = 2403,
  [2441] = 2387,
  [2442] = 2344,
  [2443] = 2398,
  [2444] = 2353,
  [2445] = 2445,
  [2446] = 2446,
  [2447] = 2447,
  [2448] = 2446,
  [2449] = 2449,
  [2450] = 2446,
  [2451] = 2451,
  [2452] = 2451,
  [2453] = 2453,
  [2454] = 2451,
  [2455] = 2455,
  [2456] = 2456,
  [2457] = 2282,
  [2458] = 2445,
  [2459] = 2449,
  [2460] = 2449,
  [2461] = 2451,
  [2462] = 2453,
  [2463] = 2456,
  [2464] = 2445,
  [2465] = 2283,
  [2466] = 2453,
  [2467] = 2456,
  [2468] = 2445,
  [2469] = 2446,
  [2470] = 2446,
  [2471] = 2453,
  [2472] = 2472,
  [2473] = 2473,
  [2474] = 2451,
  [2475] = 2453,
  [2476] = 2456,
  [2477] = 2446,
  [2478] = 2456,
  [2479] = 2449,
  [2480] = 2453,
  [2481] = 2451,
  [2482] = 2472,
  [2483] = 2446,
  [2484] = 2449,
  [2485] = 2446,
  [2486] = 2282,
  [2487] = 2445,
  [2488] = 2472,
  [2489] = 2489,
  [2490] = 2451,
  [2491] = 2283,
  [2492] = 2453,
  [2493] = 2493,
  [2494] = 2494,
  [2495] = 2495,
  [2496] = 2496,
  [2497] = 2497,
  [2498] = 2498,
  [2499] = 2499,
  [2500] = 2500,
  [2501] = 2501,
  [2502] = 2499,
  [2503] = 2495,
  [2504] = 2504,
  [2505] = 2505,
  [2506] = 2499,
  [2507] = 1060,
  [2508] = 2508,
  [2509] = 1061,
  [2510] = 2473,
  [2511] = 2499,
  [2512] = 2489,
  [2513] = 2501,
  [2514] = 1035,
  [2515] = 2515,
  [2516] = 2501,
  [2517] = 2500,
  [2518] = 2501,
  [2519] = 1029,
  [2520] = 2495,
  [2521] = 2515,
  [2522] = 2495,
  [2523] = 2515,
  [2524] = 1036,
  [2525] = 2515,
  [2526] = 2495,
  [2527] = 2515,
  [2528] = 2528,
  [2529] = 2515,
  [2530] = 2530,
  [2531] = 2531,
  [2532] = 2532,
  [2533] = 2515,
  [2534] = 2534,
  [2535] = 2515,
  [2536] = 2500,
  [2537] = 2501,
  [2538] = 2499,
  [2539] = 2498,
  [2540] = 2498,
  [2541] = 2515,
  [2542] = 2542,
  [2543] = 2515,
  [2544] = 2498,
  [2545] = 2545,
  [2546] = 2515,
  [2547] = 2501,
  [2548] = 2548,
  [2549] = 2549,
  [2550] = 2550,
  [2551] = 2499,
  [2552] = 2495,
  [2553] = 2553,
  [2554] = 2500,
  [2555] = 2555,
  [2556] = 2498,
  [2557] = 2500,
  [2558] = 2558,
  [2559] = 2499,
  [2560] = 2560,
  [2561] = 2515,
  [2562] = 2562,
  [2563] = 2515,
  [2564] = 2564,
  [2565] = 2515,
  [2566] = 1083,
  [2567] = 1078,
  [2568] = 2568,
  [2569] = 2569,
  [2570] = 1065,
  [2571] = 2498,
  [2572] = 2572,
  [2573] = 2573,
  [2574] = 2498,
  [2575] = 2575,
  [2576] = 2282,
  [2577] = 2283,
  [2578] = 2578,
  [2579] = 2579,
  [2580] = 2580,
  [2581] = 2581,
  [2582] = 2501,
  [2583] = 2495,
  [2584] = 2584,
  [2585] = 2585,
  [2586] = 2586,
  [2587] = 2587,
  [2588] = 2588,
  [2589] = 2589,
  [2590] = 2590,
  [2591] = 2591,
  [2592] = 2592,
  [2593] = 2593,
  [2594] = 2594,
  [2595] = 2595,
  [2596] = 2596,
  [2597] = 2545,
  [2598] = 2598,
  [2599] = 2599,
  [2600] = 2595,
  [2601] = 2601,
  [2602] = 2602,
  [2603] = 2603,
  [2604] = 2604,
  [2605] = 2605,
  [2606] = 2606,
  [2607] = 2607,
  [2608] = 2608,
  [2609] = 2609,
  [2610] = 2560,
  [2611] = 2564,
  [2612] = 2612,
  [2613] = 2569,
  [2614] = 2572,
  [2615] = 2573,
  [2616] = 2578,
  [2617] = 2579,
  [2618] = 2618,
  [2619] = 2532,
  [2620] = 2283,
  [2621] = 2553,
  [2622] = 2550,
  [2623] = 2542,
  [2624] = 2558,
  [2625] = 2595,
  [2626] = 2493,
  [2627] = 2534,
  [2628] = 2581,
  [2629] = 2586,
  [2630] = 2282,
  [2631] = 2531,
  [2632] = 2632,
  [2633] = 2508,
  [2634] = 2634,
  [2635] = 2505,
  [2636] = 2636,
  [2637] = 2637,
  [2638] = 2638,
  [2639] = 2634,
  [2640] = 2640,
  [2641] = 2641,
  [2642] = 2642,
  [2643] = 2643,
  [2644] = 2594,
  [2645] = 2645,
  [2646] = 2646,
  [2647] = 2647,
  [2648] = 2632,
  [2649] = 2649,
  [2650] = 2650,
  [2651] = 2651,
  [2652] = 2652,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 2590,
  [2656] = 2656,
  [2657] = 2657,
  [2658] = 2658,
  [2659] = 2659,
  [2660] = 2660,
  [2661] = 2592,
  [2662] = 2662,
  [2663] = 2663,
  [2664] = 2664,
  [2665] = 2665,
  [2666] = 2590,
  [2667] = 2594,
  [2668] = 2638,
  [2669] = 2669,
  [2670] = 2670,
  [2671] = 2671,
  [2672] = 2672,
  [2673] = 2649,
  [2674] = 2674,
  [2675] = 2595,
  [2676] = 2676,
  [2677] = 2677,
  [2678] = 2678,
  [2679] = 2679,
  [2680] = 2680,
  [2681] = 2664,
  [2682] = 2663,
  [2683] = 2683,
  [2684] = 2684,
  [2685] = 2685,
  [2686] = 2686,
  [2687] = 2687,
  [2688] = 2586,
  [2689] = 2689,
  [2690] = 2575,
  [2691] = 2691,
  [2692] = 2562,
  [2693] = 2693,
  [2694] = 2694,
  [2695] = 2695,
  [2696] = 2696,
  [2697] = 2660,
  [2698] = 2698,
  [2699] = 2699,
  [2700] = 2700,
  [2701] = 2595,
  [2702] = 2702,
  [2703] = 2649,
  [2704] = 2704,
  [2705] = 2705,
  [2706] = 2632,
  [2707] = 2707,
  [2708] = 2708,
  [2709] = 2709,
  [2710] = 2710,
  [2711] = 2634,
  [2712] = 2638,
  [2713] = 2713,
  [2714] = 2714,
  [2715] = 2715,
  [2716] = 2716,
  [2717] = 2717,
  [2718] = 2718,
  [2719] = 2719,
  [2720] = 2720,
  [2721] = 2721,
  [2722] = 2722,
  [2723] = 2723,
  [2724] = 2724,
  [2725] = 2725,
  [2726] = 2726,
  [2727] = 2727,
  [2728] = 2728,
  [2729] = 2729,
  [2730] = 2604,
  [2731] = 2605,
  [2732] = 2732,
  [2733] = 2733,
  [2734] = 2734,
  [2735] = 2735,
  [2736] = 2618,
  [2737] = 2737,
  [2738] = 2738,
  [2739] = 2739,
  [2740] = 2740,
  [2741] = 2741,
  [2742] = 2590,
  [2743] = 2743,
  [2744] = 2618,
  [2745] = 2745,
  [2746] = 2594,
  [2747] = 2747,
  [2748] = 2748,
  [2749] = 2749,
  [2750] = 2504,
  [2751] = 2751,
  [2752] = 2595,
  [2753] = 2753,
  [2754] = 2754,
  [2755] = 2755,
  [2756] = 2605,
  [2757] = 2604,
  [2758] = 2758,
  [2759] = 2759,
  [2760] = 2638,
  [2761] = 2634,
  [2762] = 2762,
  [2763] = 2763,
  [2764] = 2764,
  [2765] = 2765,
  [2766] = 2766,
  [2767] = 2767,
  [2768] = 2768,
  [2769] = 2769,
  [2770] = 2632,
  [2771] = 2649,
  [2772] = 2772,
  [2773] = 2586,
  [2774] = 2774,
  [2775] = 2775,
  [2776] = 2776,
  [2777] = 2777,
  [2778] = 2595,
  [2779] = 2779,
  [2780] = 2780,
  [2781] = 2781,
  [2782] = 2660,
  [2783] = 2592,
  [2784] = 2604,
  [2785] = 2663,
  [2786] = 2664,
  [2787] = 2605,
  [2788] = 2788,
  [2789] = 2595,
  [2790] = 2790,
  [2791] = 2618,
  [2792] = 2792,
  [2793] = 2595,
  [2794] = 2595,
  [2795] = 2795,
  [2796] = 2796,
  [2797] = 2797,
  [2798] = 2798,
  [2799] = 2799,
  [2800] = 2745,
  [2801] = 2743,
  [2802] = 2802,
  [2803] = 2548,
  [2804] = 2804,
  [2805] = 2595,
  [2806] = 2618,
  [2807] = 2807,
  [2808] = 2808,
  [2809] = 2809,
  [2810] = 2810,
  [2811] = 2604,
  [2812] = 2638,
  [2813] = 2660,
  [2814] = 2664,
  [2815] = 2815,
  [2816] = 2634,
  [2817] = 2605,
  [2818] = 2595,
  [2819] = 2748,
  [2820] = 2747,
  [2821] = 2664,
  [2822] = 2595,
  [2823] = 2663,
  [2824] = 2592,
  [2825] = 2825,
  [2826] = 2649,
  [2827] = 2594,
  [2828] = 2649,
  [2829] = 2590,
  [2830] = 2632,
  [2831] = 2716,
  [2832] = 2719,
  [2833] = 2632,
  [2834] = 2592,
  [2835] = 2618,
  [2836] = 2663,
  [2837] = 2837,
  [2838] = 2592,
  [2839] = 2839,
  [2840] = 2664,
  [2841] = 2802,
  [2842] = 2618,
  [2843] = 2663,
  [2844] = 2844,
  [2845] = 2660,
  [2846] = 2846,
  [2847] = 2837,
  [2848] = 2839,
  [2849] = 2849,
  [2850] = 2850,
  [2851] = 2851,
  [2852] = 2632,
  [2853] = 2649,
  [2854] = 2854,
  [2855] = 2855,
  [2856] = 2592,
  [2857] = 2663,
  [2858] = 2664,
  [2859] = 2859,
  [2860] = 2860,
  [2861] = 2595,
  [2862] = 2862,
  [2863] = 2863,
  [2864] = 2864,
  [2865] = 2865,
  [2866] = 2866,
  [2867] = 2867,
  [2868] = 2868,
  [2869] = 2869,
  [2870] = 2870,
  [2871] = 2871,
  [2872] = 2872,
  [2873] = 2873,
  [2874] = 2874,
  [2875] = 2875,
  [2876] = 2876,
  [2877] = 2877,
  [2878] = 2493,
  [2879] = 2879,
  [2880] = 2880,
  [2881] = 2881,
  [2882] = 2882,
  [2883] = 2883,
  [2884] = 2884,
  [2885] = 2885,
  [2886] = 2886,
  [2887] = 2887,
  [2888] = 2888,
  [2889] = 2889,
  [2890] = 2890,
  [2891] = 2891,
  [2892] = 2892,
  [2893] = 2893,
  [2894] = 2894,
  [2895] = 2895,
  [2896] = 2896,
  [2897] = 2897,
  [2898] = 2898,
  [2899] = 2899,
  [2900] = 2900,
  [2901] = 2901,
  [2902] = 2902,
  [2903] = 2903,
  [2904] = 2904,
  [2905] = 2553,
  [2906] = 2550,
  [2907] = 2907,
  [2908] = 2908,
  [2909] = 2504,
  [2910] = 2910,
  [2911] = 2911,
  [2912] = 2912,
  [2913] = 2913,
  [2914] = 2914,
  [2915] = 2915,
  [2916] = 2916,
  [2917] = 2884,
  [2918] = 2918,
  [2919] = 2671,
  [2920] = 2920,
  [2921] = 2737,
  [2922] = 2741,
  [2923] = 2923,
  [2924] = 2924,
  [2925] = 2913,
  [2926] = 2926,
  [2927] = 2927,
  [2928] = 2928,
  [2929] = 2887,
  [2930] = 2887,
  [2931] = 2927,
  [2932] = 2844,
  [2933] = 2933,
  [2934] = 2934,
  [2935] = 2935,
  [2936] = 2888,
  [2937] = 2569,
  [2938] = 2908,
  [2939] = 2913,
  [2940] = 2940,
  [2941] = 2915,
  [2942] = 2572,
  [2943] = 2943,
  [2944] = 2944,
  [2945] = 2945,
  [2946] = 2946,
  [2947] = 2505,
  [2948] = 2508,
  [2949] = 2899,
  [2950] = 2898,
  [2951] = 2887,
  [2952] = 2884,
  [2953] = 2885,
  [2954] = 2927,
  [2955] = 2955,
  [2956] = 2889,
  [2957] = 2573,
  [2958] = 2898,
  [2959] = 2899,
  [2960] = 2889,
  [2961] = 2901,
  [2962] = 2888,
  [2963] = 2885,
  [2964] = 2964,
  [2965] = 2965,
  [2966] = 2913,
  [2967] = 2967,
  [2968] = 2968,
  [2969] = 2908,
  [2970] = 2542,
  [2971] = 2558,
  [2972] = 2560,
  [2973] = 2564,
  [2974] = 2910,
  [2975] = 2283,
  [2976] = 2915,
  [2977] = 2884,
  [2978] = 2978,
  [2979] = 2578,
  [2980] = 2579,
  [2981] = 2904,
  [2982] = 2982,
  [2983] = 2885,
  [2984] = 2581,
  [2985] = 2985,
  [2986] = 2986,
  [2987] = 2987,
  [2988] = 2901,
  [2989] = 2884,
  [2990] = 2885,
  [2991] = 2889,
  [2992] = 2898,
  [2993] = 2993,
  [2994] = 2994,
  [2995] = 2899,
  [2996] = 2996,
  [2997] = 2888,
  [2998] = 2998,
  [2999] = 2982,
  [3000] = 2927,
  [3001] = 3001,
  [3002] = 3002,
  [3003] = 2915,
  [3004] = 2913,
  [3005] = 2908,
  [3006] = 3006,
  [3007] = 3007,
  [3008] = 2889,
  [3009] = 2967,
  [3010] = 2898,
  [3011] = 2965,
  [3012] = 2964,
  [3013] = 2888,
  [3014] = 2964,
  [3015] = 2899,
  [3016] = 2913,
  [3017] = 2965,
  [3018] = 2927,
  [3019] = 2904,
  [3020] = 2915,
  [3021] = 2887,
  [3022] = 2915,
  [3023] = 3023,
  [3024] = 2899,
  [3025] = 2967,
  [3026] = 2898,
  [3027] = 2910,
  [3028] = 3028,
  [3029] = 2913,
  [3030] = 2889,
  [3031] = 2534,
  [3032] = 2532,
  [3033] = 2910,
  [3034] = 2885,
  [3035] = 3035,
  [3036] = 3036,
  [3037] = 2910,
  [3038] = 2881,
  [3039] = 2884,
  [3040] = 3040,
  [3041] = 2899,
  [3042] = 3042,
  [3043] = 2898,
  [3044] = 2904,
  [3045] = 3045,
  [3046] = 2982,
  [3047] = 2882,
  [3048] = 2882,
  [3049] = 2881,
  [3050] = 2889,
  [3051] = 2531,
  [3052] = 2910,
  [3053] = 2908,
  [3054] = 2885,
  [3055] = 2967,
  [3056] = 2884,
  [3057] = 2882,
  [3058] = 2965,
  [3059] = 2964,
  [3060] = 2982,
  [3061] = 2888,
  [3062] = 2927,
  [3063] = 2887,
  [3064] = 2927,
  [3065] = 2887,
  [3066] = 2882,
  [3067] = 2888,
  [3068] = 3068,
  [3069] = 2910,
  [3070] = 2901,
  [3071] = 2982,
  [3072] = 2908,
  [3073] = 2915,
  [3074] = 2908,
  [3075] = 2881,
  [3076] = 3076,
  [3077] = 3077,
  [3078] = 3078,
  [3079] = 3079,
  [3080] = 2654,
  [3081] = 3081,
  [3082] = 3082,
  [3083] = 3083,
  [3084] = 3084,
  [3085] = 2696,
  [3086] = 2698,
  [3087] = 3087,
  [3088] = 2704,
  [3089] = 3089,
  [3090] = 3090,
  [3091] = 3091,
  [3092] = 3092,
  [3093] = 3093,
  [3094] = 3094,
  [3095] = 2781,
  [3096] = 3096,
  [3097] = 2808,
  [3098] = 2810,
  [3099] = 3099,
  [3100] = 3100,
  [3101] = 3101,
  [3102] = 3099,
  [3103] = 3103,
  [3104] = 2714,
  [3105] = 3105,
  [3106] = 3106,
  [3107] = 3107,
  [3108] = 3108,
  [3109] = 3105,
  [3110] = 3105,
  [3111] = 3105,
  [3112] = 3112,
  [3113] = 3113,
  [3114] = 3114,
  [3115] = 3105,
  [3116] = 3116,
  [3117] = 3117,
  [3118] = 2790,
  [3119] = 3119,
  [3120] = 2765,
  [3121] = 3121,
  [3122] = 3122,
  [3123] = 3123,
  [3124] = 3124,
  [3125] = 3125,
  [3126] = 3126,
  [3127] = 3127,
  [3128] = 3128,
  [3129] = 3129,
  [3130] = 3130,
  [3131] = 3131,
  [3132] = 3132,
  [3133] = 3121,
  [3134] = 3134,
  [3135] = 3121,
  [3136] = 3132,
  [3137] = 3137,
  [3138] = 3138,
  [3139] = 3128,
  [3140] = 3121,
  [3141] = 3141,
  [3142] = 3142,
  [3143] = 3132,
  [3144] = 3125,
  [3145] = 3129,
  [3146] = 3123,
  [3147] = 3129,
  [3148] = 3129,
  [3149] = 3125,
  [3150] = 3138,
  [3151] = 3137,
  [3152] = 3142,
  [3153] = 3131,
  [3154] = 3129,
  [3155] = 3134,
  [3156] = 3138,
  [3157] = 3137,
  [3158] = 3137,
  [3159] = 3142,
  [3160] = 3160,
  [3161] = 3123,
  [3162] = 3128,
  [3163] = 3163,
  [3164] = 3164,
  [3165] = 3165,
  [3166] = 3137,
  [3167] = 3130,
  [3168] = 3119,
  [3169] = 3142,
  [3170] = 3142,
  [3171] = 3131,
  [3172] = 3127,
  [3173] = 3142,
  [3174] = 3174,
  [3175] = 3134,
  [3176] = 3124,
  [3177] = 3129,
  [3178] = 3126,
  [3179] = 3179,
  [3180] = 3138,
  [3181] = 3137,
  [3182] = 3164,
  [3183] = 3183,
  [3184] = 3142,
  [3185] = 3141,
  [3186] = 3131,
  [3187] = 3187,
  [3188] = 3174,
  [3189] = 3189,
  [3190] = 3164,
  [3191] = 3138,
  [3192] = 3192,
  [3193] = 3129,
  [3194] = 3164,
  [3195] = 3195,
  [3196] = 3137,
  [3197] = 3129,
  [3198] = 3121,
  [3199] = 3130,
  [3200] = 3142,
  [3201] = 3123,
  [3202] = 3142,
  [3203] = 3125,
  [3204] = 3130,
  [3205] = 2815,
  [3206] = 3126,
  [3207] = 3129,
  [3208] = 3124,
  [3209] = 3134,
  [3210] = 3129,
  [3211] = 3138,
  [3212] = 2694,
  [3213] = 2693,
  [3214] = 2686,
  [3215] = 2684,
  [3216] = 3179,
  [3217] = 2754,
  [3218] = 3121,
  [3219] = 3119,
  [3220] = 3131,
  [3221] = 3183,
  [3222] = 3137,
  [3223] = 2722,
  [3224] = 2751,
  [3225] = 2763,
  [3226] = 3119,
  [3227] = 2777,
  [3228] = 3174,
  [3229] = 2780,
  [3230] = 2792,
  [3231] = 3131,
  [3232] = 2796,
  [3233] = 2797,
  [3234] = 3142,
  [3235] = 2799,
  [3236] = 3130,
  [3237] = 2809,
  [3238] = 3127,
  [3239] = 3179,
  [3240] = 2846,
  [3241] = 2850,
  [3242] = 2851,
  [3243] = 2854,
  [3244] = 2855,
  [3245] = 2859,
  [3246] = 3138,
  [3247] = 2860,
  [3248] = 3179,
  [3249] = 2764,
  [3250] = 2863,
  [3251] = 3128,
  [3252] = 2864,
  [3253] = 2866,
  [3254] = 2870,
  [3255] = 2871,
  [3256] = 2872,
  [3257] = 2873,
  [3258] = 2874,
  [3259] = 2875,
  [3260] = 3174,
  [3261] = 3142,
  [3262] = 3127,
  [3263] = 2876,
  [3264] = 2877,
  [3265] = 2585,
  [3266] = 3266,
  [3267] = 3130,
  [3268] = 3122,
  [3269] = 2807,
  [3270] = 3126,
  [3271] = 2804,
  [3272] = 3179,
  [3273] = 2798,
  [3274] = 3123,
  [3275] = 3119,
  [3276] = 3276,
  [3277] = 2779,
  [3278] = 2776,
  [3279] = 3137,
  [3280] = 3137,
  [3281] = 2775,
  [3282] = 2774,
  [3283] = 2772,
  [3284] = 2769,
  [3285] = 2768,
  [3286] = 3174,
  [3287] = 3126,
  [3288] = 3124,
  [3289] = 3289,
  [3290] = 2767,
  [3291] = 3119,
  [3292] = 3164,
  [3293] = 3132,
  [3294] = 2862,
  [3295] = 2762,
  [3296] = 3137,
  [3297] = 2759,
  [3298] = 2758,
  [3299] = 2755,
  [3300] = 2721,
  [3301] = 3137,
  [3302] = 2753,
  [3303] = 2825,
  [3304] = 2749,
  [3305] = 3305,
  [3306] = 2702,
  [3307] = 2740,
  [3308] = 2739,
  [3309] = 2735,
  [3310] = 2734,
  [3311] = 2733,
  [3312] = 3174,
  [3313] = 3125,
  [3314] = 3314,
  [3315] = 3315,
  [3316] = 3130,
  [3317] = 2732,
  [3318] = 3318,
  [3319] = 3174,
  [3320] = 3320,
  [3321] = 2729,
  [3322] = 2728,
  [3323] = 2727,
  [3324] = 2726,
  [3325] = 3134,
  [3326] = 2725,
  [3327] = 2724,
  [3328] = 2713,
  [3329] = 3329,
  [3330] = 2720,
  [3331] = 2766,
  [3332] = 3130,
  [3333] = 2715,
  [3334] = 2718,
  [3335] = 2710,
  [3336] = 3336,
  [3337] = 3337,
  [3338] = 3338,
  [3339] = 2708,
  [3340] = 3142,
  [3341] = 3338,
  [3342] = 3134,
  [3343] = 3189,
  [3344] = 2705,
  [3345] = 3160,
  [3346] = 3337,
  [3347] = 3124,
  [3348] = 3348,
  [3349] = 2640,
  [3350] = 3187,
  [3351] = 3351,
  [3352] = 3352,
  [3353] = 3336,
  [3354] = 3354,
  [3355] = 3129,
  [3356] = 2700,
  [3357] = 3164,
  [3358] = 2699,
  [3359] = 3121,
  [3360] = 3127,
  [3361] = 3129,
  [3362] = 3126,
  [3363] = 3124,
  [3364] = 2695,
  [3365] = 3123,
  [3366] = 3125,
  [3367] = 3142,
  [3368] = 2691,
  [3369] = 2689,
  [3370] = 2687,
  [3371] = 2685,
  [3372] = 3119,
  [3373] = 3137,
  [3374] = 2683,
  [3375] = 2584,
  [3376] = 2680,
  [3377] = 3138,
  [3378] = 2679,
  [3379] = 2678,
  [3380] = 3336,
  [3381] = 3337,
  [3382] = 3338,
  [3383] = 3125,
  [3384] = 3384,
  [3385] = 3128,
  [3386] = 3189,
  [3387] = 2677,
  [3388] = 3336,
  [3389] = 3337,
  [3390] = 3338,
  [3391] = 3123,
  [3392] = 3124,
  [3393] = 3393,
  [3394] = 3189,
  [3395] = 2676,
  [3396] = 3336,
  [3397] = 3337,
  [3398] = 3338,
  [3399] = 3399,
  [3400] = 3131,
  [3401] = 2674,
  [3402] = 3189,
  [3403] = 2672,
  [3404] = 3336,
  [3405] = 3337,
  [3406] = 3338,
  [3407] = 3163,
  [3408] = 3408,
  [3409] = 2670,
  [3410] = 3189,
  [3411] = 2662,
  [3412] = 3336,
  [3413] = 3337,
  [3414] = 3338,
  [3415] = 3132,
  [3416] = 3164,
  [3417] = 3320,
  [3418] = 3189,
  [3419] = 2659,
  [3420] = 3337,
  [3421] = 3189,
  [3422] = 2658,
  [3423] = 3337,
  [3424] = 2657,
  [3425] = 3337,
  [3426] = 2656,
  [3427] = 3337,
  [3428] = 3129,
  [3429] = 3337,
  [3430] = 2653,
  [3431] = 3337,
  [3432] = 2652,
  [3433] = 3337,
  [3434] = 2651,
  [3435] = 3338,
  [3436] = 3348,
  [3437] = 2650,
  [3438] = 2647,
  [3439] = 3129,
  [3440] = 3338,
  [3441] = 3142,
  [3442] = 3338,
  [3443] = 2646,
  [3444] = 3338,
  [3445] = 3121,
  [3446] = 3338,
  [3447] = 3174,
  [3448] = 3338,
  [3449] = 3137,
  [3450] = 3134,
  [3451] = 3126,
  [3452] = 2645,
  [3453] = 2643,
  [3454] = 2642,
  [3455] = 2641,
  [3456] = 3456,
  [3457] = 3352,
  [3458] = 3352,
  [3459] = 3352,
  [3460] = 3352,
  [3461] = 3352,
  [3462] = 3352,
  [3463] = 3352,
  [3464] = 3352,
  [3465] = 3352,
  [3466] = 3352,
  [3467] = 3352,
  [3468] = 3352,
  [3469] = 3352,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 6688
    ? (c < 2984
      ? (c < 2365
        ? (c < 1488
          ? (c < 886
            ? (c < 216
              ? (c < 181
                ? (c < 'a'
                  ? (c >= 'A' && c <= '_')
                  : (c <= 'z' || c == 170))
                : (c <= 181 || (c < 192
                  ? c == 186
                  : c <= 214)))
              : (c <= 246 || (c < 748
                ? (c < 710
                  ? (c >= 248 && c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))
                : (c <= 748 || (c < 880
                  ? c == 750
                  : c <= 884)))))
            : (c <= 887 || (c < 931
              ? (c < 904
                ? (c < 895
                  ? (c >= 890 && c <= 893)
                  : (c <= 895 || c == 902))
                : (c <= 906 || (c < 910
                  ? c == 908
                  : c <= 929)))
              : (c <= 1013 || (c < 1329
                ? (c < 1162
                  ? (c >= 1015 && c <= 1153)
                  : c <= 1327)
                : (c <= 1366 || (c < 1376
                  ? c == 1369
                  : c <= 1416)))))))
          : (c <= 1514 || (c < 1994
            ? (c < 1774
              ? (c < 1649
                ? (c < 1568
                  ? (c >= 1519 && c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))
                : (c <= 1747 || (c < 1765
                  ? c == 1749
                  : c <= 1766)))
              : (c <= 1775 || (c < 1810
                ? (c < 1791
                  ? (c >= 1786 && c <= 1788)
                  : (c <= 1791 || c == 1808))
                : (c <= 1839 || (c < 1969
                  ? (c >= 1869 && c <= 1957)
                  : c <= 1969)))))
            : (c <= 2026 || (c < 2112
              ? (c < 2074
                ? (c < 2042
                  ? (c >= 2036 && c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2088
                  ? c == 2084
                  : c <= 2088)))
              : (c <= 2136 || (c < 2185
                ? (c < 2160
                  ? (c >= 2144 && c <= 2154)
                  : c <= 2183)
                : (c <= 2190 || (c < 2308
                  ? (c >= 2208 && c <= 2249)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2544
            ? (c < 2474
              ? (c < 2437
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : c <= 2472)))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2654
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : c <= 2652)
                : (c <= 2654 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2869
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2958
              ? (c < 2929
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2949
                  ? c == 2947
                  : c <= 2954)))
              : (c <= 2960 || (c < 2972
                ? (c < 2969
                  ? (c >= 2962 && c <= 2965)
                  : c <= 2970)
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 4176
        ? (c < 3423
          ? (c < 3218
            ? (c < 3133
              ? (c < 3086
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3114
                  ? (c >= 3090 && c <= 3112)
                  : c <= 3129)))
              : (c <= 3133 || (c < 3200
                ? (c < 3165
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3332
              ? (c < 3293
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3313
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3314)))
              : (c <= 3340 || (c < 3389
                ? (c < 3346
                  ? (c >= 3342 && c <= 3344)
                  : c <= 3386)
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3749
            ? (c < 3585
              ? (c < 3507
                ? (c < 3461
                  ? (c >= 3450 && c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3520
                  ? c == 3517
                  : c <= 3526)))
              : (c <= 3632 || (c < 3716
                ? (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : c <= 3747)))))
            : (c <= 3749 || (c < 3840
              ? (c < 3776
                ? (c < 3762
                  ? (c >= 3751 && c <= 3760)
                  : (c <= 3763 || c == 3773))
                : (c <= 3780 || (c < 3804
                  ? c == 3782
                  : c <= 3807)))
              : (c <= 3840 || (c < 3976
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : c <= 3948)
                : (c <= 3980 || (c < 4159
                  ? (c >= 4096 && c <= 4138)
                  : c <= 4159)))))))))
        : (c <= 4181 || (c < 4992
          ? (c < 4696
            ? (c < 4256
              ? (c < 4206
                ? (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))
                : (c <= 4208 || (c < 4238
                  ? (c >= 4213 && c <= 4225)
                  : c <= 4238)))
              : (c <= 4293 || (c < 4348
                ? (c < 4301
                  ? c == 4295
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))
                : (c <= 4680 || (c < 4688
                  ? (c >= 4682 && c <= 4685)
                  : c <= 4694)))))
            : (c <= 4696 || (c < 4800
              ? (c < 4752
                ? (c < 4704
                  ? (c >= 4698 && c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4792
                  ? (c >= 4786 && c <= 4789)
                  : c <= 4798)))
              : (c <= 4800 || (c < 4824
                ? (c < 4808
                  ? (c >= 4802 && c <= 4805)
                  : c <= 4822)
                : (c <= 4880 || (c < 4888
                  ? (c >= 4882 && c <= 4885)
                  : c <= 4954)))))))
          : (c <= 5007 || (c < 6103
            ? (c < 5873
              ? (c < 5743
                ? (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))
                : (c <= 5759 || (c < 5792
                  ? (c >= 5761 && c <= 5786)
                  : c <= 5866)))
              : (c <= 5880 || (c < 5984
                ? (c < 5919
                  ? (c >= 5888 && c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6016
                  ? (c >= 5998 && c <= 6000)
                  : c <= 6067)))))
            : (c <= 6103 || (c < 6400
              ? (c < 6279
                ? (c < 6176
                  ? c == 6108
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))
              : (c <= 6430 || (c < 6528
                ? (c < 6512
                  ? (c >= 6480 && c <= 6509)
                  : c <= 6516)
                : (c <= 6571 || (c < 6656
                  ? (c >= 6576 && c <= 6601)
                  : c <= 6678)))))))))))))
    : (c <= 6740 || (c < 43261
      ? (c < 11264
        ? (c < 8064
          ? (c < 7406
            ? (c < 7168
              ? (c < 7043
                ? (c < 6917
                  ? c == 6823
                  : (c <= 6963 || (c >= 6981 && c <= 6988)))
                : (c <= 7072 || (c < 7098
                  ? (c >= 7086 && c <= 7087)
                  : c <= 7141)))
              : (c <= 7203 || (c < 7312
                ? (c < 7258
                  ? (c >= 7245 && c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))
                : (c <= 7354 || (c < 7401
                  ? (c >= 7357 && c <= 7359)
                  : c <= 7404)))))
            : (c <= 7411 || (c < 8008
              ? (c < 7680
                ? (c < 7418
                  ? (c >= 7413 && c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 7968
                  ? (c >= 7960 && c <= 7965)
                  : c <= 8005)))
              : (c <= 8013 || (c < 8027
                ? (c < 8025
                  ? (c >= 8016 && c <= 8023)
                  : c <= 8025)
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))))))
          : (c <= 8116 || (c < 8455
            ? (c < 8160
              ? (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))
              : (c <= 8172 || (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))))
            : (c <= 8455 || (c < 8490
              ? (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))
              : (c <= 8493 || (c < 8517
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : c <= 8511)
                : (c <= 8521 || (c < 8579
                  ? c == 8526
                  : c <= 8580)))))))))
        : (c <= 11492 || (c < 12704
          ? (c < 11720
            ? (c < 11631
              ? (c < 11559
                ? (c < 11506
                  ? (c >= 11499 && c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : c <= 11623)))
              : (c <= 11631 || (c < 11696
                ? (c < 11680
                  ? (c >= 11648 && c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : c <= 11718)))))
            : (c <= 11726 || (c < 12353
              ? (c < 12293
                ? (c < 11736
                  ? (c >= 11728 && c <= 11734)
                  : (c <= 11742 || c == 11823))
                : (c <= 12294 || (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))
              : (c <= 12438 || (c < 12540
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)
                : (c <= 12543 || (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : c <= 12686)))))))
          : (c <= 12735 || (c < 42786
            ? (c < 42240
              ? (c < 19968
                ? (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : (c <= 13312 || c == 19903))
                : (c <= 19968 || (c < 42192
                  ? (c >= 40959 && c <= 42124)
                  : c <= 42237)))
              : (c <= 42508 || (c < 42623
                ? (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : c <= 42783)))))
            : (c <= 42888 || (c < 43015
              ? (c < 42965
                ? (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : c <= 43013)))
              : (c <= 43018 || (c < 43138
                ? (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)
                : (c <= 43187 || (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : c <= 43259)))))))))))
      : (c <= 43262 || (c < 65345
        ? (c < 43816
          ? (c < 43646
            ? (c < 43494
              ? (c < 43396
                ? (c < 43312
                  ? (c >= 43274 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43488
                  ? c == 43471
                  : c <= 43492)))
              : (c <= 43503 || (c < 43588
                ? (c < 43520
                  ? (c >= 43514 && c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : c <= 43642)))))
            : (c <= 43695 || (c < 43744
              ? (c < 43712
                ? (c < 43701
                  ? c == 43697
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43739
                  ? c == 43714
                  : c <= 43741)))
              : (c <= 43754 || (c < 43785
                ? (c < 43777
                  ? (c >= 43762 && c <= 43764)
                  : c <= 43782)
                : (c <= 43790 || (c < 43808
                  ? (c >= 43793 && c <= 43798)
                  : c <= 43814)))))))
          : (c <= 43822 || (c < 64298
            ? (c < 55243
              ? (c < 44032
                ? (c < 43868
                  ? (c >= 43824 && c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 44032 || (c < 55216
                  ? c == 55203
                  : c <= 55238)))
              : (c <= 55291 || (c < 64275
                ? (c < 64112
                  ? (c >= 63744 && c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))
                : (c <= 64279 || (c < 64287
                  ? c == 64285
                  : c <= 64296)))))
            : (c <= 64310 || (c < 64848
              ? (c < 64323
                ? (c < 64318
                  ? (c >= 64312 && c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : c <= 64829)))
              : (c <= 64911 || (c < 65136
                ? (c < 65008
                  ? (c >= 64914 && c <= 64967)
                  : c <= 65019)
                : (c <= 65140 || (c < 65313
                  ? (c >= 65142 && c <= 65276)
                  : c <= 65338)))))))))
        : (c <= 65370 || (c < 66928
          ? (c < 66208
            ? (c < 65549
              ? (c < 65490
                ? (c < 65474
                  ? (c >= 65382 && c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : c <= 65547)))
              : (c <= 65574 || (c < 65616
                ? (c < 65596
                  ? (c >= 65576 && c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 66176
                  ? (c >= 65664 && c <= 65786)
                  : c <= 66204)))))
            : (c <= 66256 || (c < 66504
              ? (c < 66384
                ? (c < 66349
                  ? (c >= 66304 && c <= 66335)
                  : (c <= 66368 || (c >= 66370 && c <= 66377)))
                : (c <= 66421 || (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : c <= 66499)))
              : (c <= 66511 || (c < 66776
                ? (c < 66736
                  ? (c >= 66560 && c <= 66717)
                  : c <= 66771)
                : (c <= 66811 || (c < 66864
                  ? (c >= 66816 && c <= 66855)
                  : c <= 66915)))))))
          : (c <= 66938 || (c < 67506
            ? (c < 67003
              ? (c < 66967
                ? (c < 66956
                  ? (c >= 66940 && c <= 66954)
                  : (c <= 66962 || (c >= 66964 && c <= 66965)))
                : (c <= 66977 || (c < 66995
                  ? (c >= 66979 && c <= 66993)
                  : c <= 67001)))
              : (c <= 67004 || (c < 67424
                ? (c < 67392
                  ? (c >= 67072 && c <= 67382)
                  : c <= 67413)
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < '_'
                  ? (c >= 'A' && c <= 'Z')
                  : (c <= '_' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < 'a'
                ? (c < 'A'
                  ? (c >= '0' && c <= '9')
                  : (c <= 'Z' || c == '_'))
                : (c <= 'z' || (c < 181
                  ? c == 170
                  : c <= 181)))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_rune_literal_character_set_1(int32_t c) {
  return (c < 'f'
    ? (c < '\\'
      ? (c < '\''
        ? c == '"'
        : c <= '\'')
      : (c <= '\\' || (c >= 'a' && c <= 'b')))
    : (c <= 'f' || (c < 't'
      ? (c < 'r'
        ? c == 'n'
        : c <= 'r')
      : (c <= 't' || c == 'v'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(243);
      if (lookahead == '!') ADVANCE(282);
      if (lookahead == '"') ADVANCE(347);
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '$') ADVANCE(259);
      if (lookahead == '%') ADVANCE(319);
      if (lookahead == '&') ADVANCE(315);
      if (lookahead == '\'') ADVANCE(18);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == ')') ADVANCE(256);
      if (lookahead == '*') ADVANCE(318);
      if (lookahead == '+') ADVANCE(305);
      if (lookahead == ',') ADVANCE(255);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '.') ADVANCE(275);
      if (lookahead == '/') ADVANCE(258);
      if (lookahead == '0') ADVANCE(356);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(245);
      if (lookahead == '<') ADVANCE(333);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(331);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '@') ADVANCE(251);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == ']') ADVANCE(263);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(343);
      if (lookahead == '`') ADVANCE(35);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '|') ADVANCE(329);
      if (lookahead == '}') ADVANCE(247);
      if (lookahead == '~') ADVANCE(313);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(242)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(357);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(244);
      if (lookahead == '!') ADVANCE(282);
      if (lookahead == '"') ADVANCE(347);
      if (lookahead == '#') ADVANCE(51);
      if (lookahead == '$') ADVANCE(259);
      if (lookahead == '%') ADVANCE(319);
      if (lookahead == '&') ADVANCE(315);
      if (lookahead == '\'') ADVANCE(18);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == '*') ADVANCE(318);
      if (lookahead == '+') ADVANCE(305);
      if (lookahead == ',') ADVANCE(255);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '.') ADVANCE(275);
      if (lookahead == '/') ADVANCE(258);
      if (lookahead == '0') ADVANCE(356);
      if (lookahead == '<') ADVANCE(333);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(331);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(343);
      if (lookahead == '`') ADVANCE(35);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '|') ADVANCE(329);
      if (lookahead == '}') ADVANCE(247);
      if (lookahead == '~') ADVANCE(313);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(357);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(244);
      if (lookahead == '!') ADVANCE(281);
      if (lookahead == '"') ADVANCE(347);
      if (lookahead == '#') ADVANCE(53);
      if (lookahead == '$') ADVANCE(259);
      if (lookahead == '&') ADVANCE(314);
      if (lookahead == '\'') ADVANCE(18);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == '-') ADVANCE(307);
      if (lookahead == '.') ADVANCE(276);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '0') ADVANCE(356);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(343);
      if (lookahead == '`') ADVANCE(35);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '~') ADVANCE(312);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(357);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(244);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(65);
      if (lookahead == '%') ADVANCE(319);
      if (lookahead == '&') ADVANCE(315);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == '*') ADVANCE(318);
      if (lookahead == '+') ADVANCE(305);
      if (lookahead == ',') ADVANCE(255);
      if (lookahead == '-') ADVANCE(310);
      if (lookahead == '.') ADVANCE(274);
      if (lookahead == '/') ADVANCE(258);
      if (lookahead == ';') ADVANCE(245);
      if (lookahead == '<') ADVANCE(333);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(331);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(343);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '|') ADVANCE(329);
      if (lookahead == '}') ADVANCE(247);
      if (lookahead == '~') ADVANCE(313);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(8)
      if (lookahead == '"') ADVANCE(347);
      if (lookahead == '/') ADVANCE(348);
      if (lookahead == '\\') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0) ADVANCE(352);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(281);
      if (lookahead == '"') ADVANCE(347);
      if (lookahead == '#') ADVANCE(45);
      if (lookahead == '$') ADVANCE(259);
      if (lookahead == '&') ADVANCE(314);
      if (lookahead == '\'') ADVANCE(18);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == ')') ADVANCE(256);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(276);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '0') ADVANCE(356);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(245);
      if (lookahead == '=') ADVANCE(253);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '@') ADVANCE(251);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == ']') ADVANCE(263);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(343);
      if (lookahead == '`') ADVANCE(35);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '}') ADVANCE(247);
      if (lookahead == '~') ADVANCE(312);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(357);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(65);
      if (lookahead == '%') ADVANCE(319);
      if (lookahead == '&') ADVANCE(315);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == '*') ADVANCE(318);
      if (lookahead == '+') ADVANCE(305);
      if (lookahead == ',') ADVANCE(255);
      if (lookahead == '-') ADVANCE(310);
      if (lookahead == '.') ADVANCE(274);
      if (lookahead == '/') ADVANCE(258);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(245);
      if (lookahead == '<') ADVANCE(333);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(331);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(343);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '|') ADVANCE(329);
      if (lookahead == '}') ADVANCE(247);
      if (lookahead == '~') ADVANCE(313);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(58);
      if (lookahead == '%') ADVANCE(320);
      if (lookahead == '&') ADVANCE(316);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == ')') ADVANCE(256);
      if (lookahead == '*') ADVANCE(317);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == ',') ADVANCE(255);
      if (lookahead == '-') ADVANCE(311);
      if (lookahead == '.') ADVANCE(274);
      if (lookahead == '/') ADVANCE(257);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(245);
      if (lookahead == '<') ADVANCE(334);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(332);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == ']') ADVANCE(263);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(343);
      if (lookahead == '`') ADVANCE(35);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '|') ADVANCE(330);
      if (lookahead == '}') ADVANCE(247);
      if (lookahead == '~') ADVANCE(312);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(347);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      END_STATE();
    case 9:
      if (lookahead == '\'') ADVANCE(364);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(366);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(365);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '-') ADVANCE(277);
      END_STATE();
    case 14:
      if (lookahead == '.') ADVANCE(363);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(209);
      if (lookahead == '_') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '.') ADVANCE(224);
      if (lookahead == '_') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(358);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(338);
      END_STATE();
    case 17:
      if (lookahead == 'U') ADVANCE(237);
      if (lookahead == 'u') ADVANCE(229);
      if (lookahead == 'x') ADVANCE(225);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(355);
      if (lookahead != 0) ADVANCE(353);
      END_STATE();
    case 18:
      if (lookahead == '\\') ADVANCE(216);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(9);
      END_STATE();
    case 19:
      if (lookahead == '_') ADVANCE(204);
      if (lookahead == 'o') ADVANCE(137);
      END_STATE();
    case 20:
      if (lookahead == '_') ADVANCE(212);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(359);
      END_STATE();
    case 21:
      if (lookahead == '_') ADVANCE(47);
      END_STATE();
    case 22:
      if (lookahead == '_') ADVANCE(113);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(63);
      END_STATE();
    case 24:
      if (lookahead == '_') ADVANCE(64);
      END_STATE();
    case 25:
      if (lookahead == '_') ADVANCE(46);
      END_STATE();
    case 26:
      if (lookahead == '_') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(360);
      END_STATE();
    case 27:
      if (lookahead == '_') ADVANCE(70);
      END_STATE();
    case 28:
      if (lookahead == '_') ADVANCE(109);
      END_STATE();
    case 29:
      if (lookahead == '_') ADVANCE(160);
      END_STATE();
    case 30:
      if (lookahead == '_') ADVANCE(148);
      END_STATE();
    case 31:
      if (lookahead == '_') ADVANCE(174);
      END_STATE();
    case 32:
      if (lookahead == '_') ADVANCE(201);
      END_STATE();
    case 33:
      if (lookahead == '_') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == '_') ADVANCE(118);
      END_STATE();
    case 35:
      if (lookahead == '`') ADVANCE(346);
      if (lookahead != 0) ADVANCE(35);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(124);
      if (lookahead == 'b') ADVANCE(156);
      if (lookahead == 'c') ADVANCE(19);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == 'f') ADVANCE(161);
      if (lookahead == 'l') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(159);
      if (lookahead == 'o') ADVANCE(173);
      if (lookahead == 'p') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(39);
      if (lookahead == 's') ADVANCE(98);
      if (lookahead == 't') ADVANCE(207);
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 37:
      if (lookahead == 'a') ADVANCE(68);
      END_STATE();
    case 38:
      if (lookahead == 'a') ADVANCE(205);
      END_STATE();
    case 39:
      if (lookahead == 'a') ADVANCE(205);
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 40:
      if (lookahead == 'a') ADVANCE(75);
      if (lookahead == 'c') ADVANCE(62);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(265);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(143);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(125);
      if (lookahead == 'b') ADVANCE(155);
      if (lookahead == 'c') ADVANCE(158);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == 'f') ADVANCE(161);
      if (lookahead == 'l') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(168);
      if (lookahead == 'o') ADVANCE(173);
      if (lookahead == 'p') ADVANCE(44);
      if (lookahead == 'r') ADVANCE(39);
      if (lookahead == 's') ADVANCE(98);
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(141);
      if (lookahead == 'b') ADVANCE(156);
      if (lookahead == 'c') ADVANCE(19);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == 'f') ADVANCE(161);
      if (lookahead == 'l') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(170);
      if (lookahead == 'p') ADVANCE(42);
      if (lookahead == 'r') ADVANCE(81);
      if (lookahead == 's') ADVANCE(102);
      if (lookahead == 't') ADVANCE(207);
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(131);
      if (lookahead == 'b') ADVANCE(172);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(131);
      if (lookahead == 'b') ADVANCE(172);
      if (lookahead == 'c') ADVANCE(162);
      if (lookahead == 'n') ADVANCE(107);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(190);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(189);
      END_STATE();
    case 50:
      if (lookahead == 'a') ADVANCE(185);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == 'b') ADVANCE(155);
      if (lookahead == 'c') ADVANCE(158);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == 'f') ADVANCE(161);
      if (lookahead == 'l') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(167);
      if (lookahead == 'o') ADVANCE(173);
      if (lookahead == 'p') ADVANCE(60);
      if (lookahead == 'r') ADVANCE(81);
      if (lookahead == 's') ADVANCE(102);
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == 'b') ADVANCE(155);
      if (lookahead == 'c') ADVANCE(158);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == 'f') ADVANCE(161);
      if (lookahead == 'l') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(167);
      if (lookahead == 'p') ADVANCE(42);
      if (lookahead == 'r') ADVANCE(81);
      if (lookahead == 's') ADVANCE(102);
      if (lookahead == 't') ADVANCE(207);
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == 'b') ADVANCE(155);
      if (lookahead == 'c') ADVANCE(158);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == 'f') ADVANCE(161);
      if (lookahead == 'l') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(167);
      if (lookahead == 'p') ADVANCE(60);
      if (lookahead == 'r') ADVANCE(81);
      if (lookahead == 's') ADVANCE(102);
      if (lookahead == 't') ADVANCE(207);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(128);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(66);
      END_STATE();
    case 56:
      if (lookahead == 'a') ADVANCE(186);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(132);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(123);
      if (lookahead == 'b') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(168);
      if (lookahead == 'p') ADVANCE(55);
      if (lookahead == 'r') ADVANCE(38);
      if (lookahead == 's') ADVANCE(97);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(182);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(142);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(197);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(199);
      END_STATE();
    case 63:
      if (lookahead == 'b') ADVANCE(172);
      END_STATE();
    case 64:
      if (lookahead == 'b') ADVANCE(172);
      if (lookahead == 'c') ADVANCE(162);
      if (lookahead == 'n') ADVANCE(107);
      END_STATE();
    case 65:
      if (lookahead == 'b') ADVANCE(155);
      if (lookahead == 'n') ADVANCE(167);
      END_STATE();
    case 66:
      if (lookahead == 'c') ADVANCE(122);
      END_STATE();
    case 67:
      if (lookahead == 'c') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 68:
      if (lookahead == 'c') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(106);
      if (lookahead == 'r') ADVANCE(196);
      END_STATE();
    case 69:
      if (lookahead == 'c') ADVANCE(344);
      END_STATE();
    case 70:
      if (lookahead == 'c') ADVANCE(100);
      END_STATE();
    case 71:
      if (lookahead == 'c') ADVANCE(88);
      END_STATE();
    case 72:
      if (lookahead == 'c') ADVANCE(120);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(121);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(101);
      END_STATE();
    case 75:
      if (lookahead == 'd') ADVANCE(345);
      END_STATE();
    case 76:
      if (lookahead == 'd') ADVANCE(266);
      END_STATE();
    case 77:
      if (lookahead == 'd') ADVANCE(271);
      END_STATE();
    case 78:
      if (lookahead == 'd') ADVANCE(191);
      END_STATE();
    case 79:
      if (lookahead == 'd') ADVANCE(30);
      END_STATE();
    case 80:
      if (lookahead == 'd') ADVANCE(192);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(261);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(278);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(279);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(22);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 92:
      if (lookahead == 'f') ADVANCE(105);
      END_STATE();
    case 93:
      if (lookahead == 'g') ADVANCE(344);
      END_STATE();
    case 94:
      if (lookahead == 'g') ADVANCE(289);
      END_STATE();
    case 95:
      if (lookahead == 'g') ADVANCE(138);
      END_STATE();
    case 96:
      if (lookahead == 'h') ADVANCE(344);
      END_STATE();
    case 97:
      if (lookahead == 'h') ADVANCE(50);
      END_STATE();
    case 98:
      if (lookahead == 'h') ADVANCE(50);
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 99:
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'o') ADVANCE(178);
      END_STATE();
    case 100:
      if (lookahead == 'h') ADVANCE(86);
      END_STATE();
    case 101:
      if (lookahead == 'h') ADVANCE(89);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 103:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 104:
      if (lookahead == 'i') ADVANCE(203);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(93);
      END_STATE();
    case 106:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 107:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 108:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 109:
      if (lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 110:
      if (lookahead == 'i') ADVANCE(164);
      END_STATE();
    case 111:
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(166);
      END_STATE();
    case 113:
      if (lookahead == 'i') ADVANCE(150);
      if (lookahead == 'n') ADVANCE(171);
      END_STATE();
    case 114:
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 115:
      if (lookahead == 'i') ADVANCE(147);
      END_STATE();
    case 116:
      if (lookahead == 'i') ADVANCE(149);
      END_STATE();
    case 117:
      if (lookahead == 'i') ADVANCE(169);
      END_STATE();
    case 118:
      if (lookahead == 'i') ADVANCE(154);
      END_STATE();
    case 119:
      if (lookahead == 'k') ADVANCE(283);
      END_STATE();
    case 120:
      if (lookahead == 'k') ADVANCE(250);
      END_STATE();
    case 121:
      if (lookahead == 'k') ADVANCE(249);
      END_STATE();
    case 122:
      if (lookahead == 'k') ADVANCE(87);
      END_STATE();
    case 123:
      if (lookahead == 'l') ADVANCE(103);
      END_STATE();
    case 124:
      if (lookahead == 'l') ADVANCE(103);
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 125:
      if (lookahead == 'l') ADVANCE(103);
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 126:
      if (lookahead == 'l') ADVANCE(267);
      END_STATE();
    case 127:
      if (lookahead == 'l') ADVANCE(303);
      END_STATE();
    case 128:
      if (lookahead == 'l') ADVANCE(302);
      END_STATE();
    case 129:
      if (lookahead == 'l') ADVANCE(268);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(127);
      END_STATE();
    case 131:
      if (lookahead == 'l') ADVANCE(111);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(29);
      END_STATE();
    case 133:
      if (lookahead == 'l') ADVANCE(61);
      END_STATE();
    case 134:
      if (lookahead == 'l') ADVANCE(115);
      END_STATE();
    case 135:
      if (lookahead == 'l') ADVANCE(116);
      END_STATE();
    case 136:
      if (lookahead == 'm') ADVANCE(76);
      END_STATE();
    case 137:
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 138:
      if (lookahead == 'n') ADVANCE(269);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(344);
      END_STATE();
    case 140:
      if (lookahead == 'n') ADVANCE(272);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(208);
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(106);
      if (lookahead == 'r') ADVANCE(196);
      END_STATE();
    case 144:
      if (lookahead == 'n') ADVANCE(78);
      END_STATE();
    case 145:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 146:
      if (lookahead == 'n') ADVANCE(194);
      END_STATE();
    case 147:
      if (lookahead == 'n') ADVANCE(84);
      END_STATE();
    case 148:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(85);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(134);
      END_STATE();
    case 151:
      if (lookahead == 'n') ADVANCE(57);
      END_STATE();
    case 152:
      if (lookahead == 'n') ADVANCE(117);
      END_STATE();
    case 153:
      if (lookahead == 'n') ADVANCE(80);
      END_STATE();
    case 154:
      if (lookahead == 'n') ADVANCE(135);
      END_STATE();
    case 155:
      if (lookahead == 'o') ADVANCE(200);
      END_STATE();
    case 156:
      if (lookahead == 'o') ADVANCE(200);
      if (lookahead == 'y') ADVANCE(31);
      END_STATE();
    case 157:
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 158:
      if (lookahead == 'o') ADVANCE(137);
      END_STATE();
    case 159:
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 160:
      if (lookahead == 'o') ADVANCE(119);
      END_STATE();
    case 161:
      if (lookahead == 'o') ADVANCE(177);
      END_STATE();
    case 162:
      if (lookahead == 'o') ADVANCE(176);
      END_STATE();
    case 163:
      if (lookahead == 'o') ADVANCE(130);
      END_STATE();
    case 164:
      if (lookahead == 'o') ADVANCE(151);
      END_STATE();
    case 165:
      if (lookahead == 'o') ADVANCE(178);
      END_STATE();
    case 166:
      if (lookahead == 'o') ADVANCE(139);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 168:
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 169:
      if (lookahead == 'o') ADVANCE(140);
      END_STATE();
    case 170:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 171:
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 172:
      if (lookahead == 'o') ADVANCE(202);
      END_STATE();
    case 173:
      if (lookahead == 'p') ADVANCE(195);
      END_STATE();
    case 174:
      if (lookahead == 'p') ADVANCE(198);
      END_STATE();
    case 175:
      if (lookahead == 'p') ADVANCE(82);
      END_STATE();
    case 176:
      if (lookahead == 'p') ADVANCE(206);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 178:
      if (lookahead == 'r') ADVANCE(344);
      END_STATE();
    case 179:
      if (lookahead == 'r') ADVANCE(287);
      END_STATE();
    case 180:
      if (lookahead == 'r') ADVANCE(184);
      END_STATE();
    case 181:
      if (lookahead == 'r') ADVANCE(193);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(94);
      END_STATE();
    case 183:
      if (lookahead == 'r') ADVANCE(163);
      END_STATE();
    case 184:
      if (lookahead == 'r') ADVANCE(165);
      END_STATE();
    case 185:
      if (lookahead == 'r') ADVANCE(90);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 187:
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 188:
      if (lookahead == 's') ADVANCE(91);
      END_STATE();
    case 189:
      if (lookahead == 's') ADVANCE(286);
      END_STATE();
    case 190:
      if (lookahead == 's') ADVANCE(96);
      END_STATE();
    case 191:
      if (lookahead == 's') ADVANCE(27);
      END_STATE();
    case 192:
      if (lookahead == 's') ADVANCE(33);
      END_STATE();
    case 193:
      if (lookahead == 't') ADVANCE(344);
      END_STATE();
    case 194:
      if (lookahead == 't') ADVANCE(288);
      END_STATE();
    case 195:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 196:
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 197:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 198:
      if (lookahead == 't') ADVANCE(179);
      END_STATE();
    case 199:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 200:
      if (lookahead == 'u') ADVANCE(144);
      END_STATE();
    case 201:
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 202:
      if (lookahead == 'u') ADVANCE(153);
      END_STATE();
    case 203:
      if (lookahead == 'v') ADVANCE(83);
      END_STATE();
    case 204:
      if (lookahead == 'v') ADVANCE(56);
      END_STATE();
    case 205:
      if (lookahead == 'w') ADVANCE(32);
      END_STATE();
    case 206:
      if (lookahead == 'y') ADVANCE(270);
      END_STATE();
    case 207:
      if (lookahead == 'y') ADVANCE(175);
      END_STATE();
    case 208:
      if (lookahead == 'y') ADVANCE(28);
      END_STATE();
    case 209:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(361);
      END_STATE();
    case 210:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(209);
      if (lookahead == '_') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(210);
      END_STATE();
    case 211:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(210);
      END_STATE();
    case 212:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(359);
      END_STATE();
    case 213:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(9);
      END_STATE();
    case 214:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(360);
      END_STATE();
    case 215:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(213);
      END_STATE();
    case 216:
      if (sym_rune_literal_character_set_1(lookahead)) ADVANCE(9);
      if (lookahead == 'U') ADVANCE(238);
      if (lookahead == 'u') ADVANCE(230);
      if (lookahead == 'x') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(215);
      END_STATE();
    case 217:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(357);
      END_STATE();
    case 218:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(362);
      END_STATE();
    case 219:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(14);
      END_STATE();
    case 220:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(361);
      END_STATE();
    case 221:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(9);
      END_STATE();
    case 222:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(353);
      END_STATE();
    case 223:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(358);
      END_STATE();
    case 224:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(210);
      END_STATE();
    case 225:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(222);
      END_STATE();
    case 226:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(221);
      END_STATE();
    case 227:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(225);
      END_STATE();
    case 228:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(226);
      END_STATE();
    case 229:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(227);
      END_STATE();
    case 230:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(228);
      END_STATE();
    case 231:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(229);
      END_STATE();
    case 232:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(230);
      END_STATE();
    case 233:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(231);
      END_STATE();
    case 234:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(232);
      END_STATE();
    case 235:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(233);
      END_STATE();
    case 236:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(234);
      END_STATE();
    case 237:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(235);
      END_STATE();
    case 238:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(236);
      END_STATE();
    case 239:
      if (eof) ADVANCE(243);
      if (lookahead == '\n') ADVANCE(244);
      if (lookahead == '!') ADVANCE(282);
      if (lookahead == '"') ADVANCE(347);
      if (lookahead == '#') ADVANCE(43);
      if (lookahead == '$') ADVANCE(259);
      if (lookahead == '%') ADVANCE(320);
      if (lookahead == '&') ADVANCE(316);
      if (lookahead == '\'') ADVANCE(18);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == ')') ADVANCE(256);
      if (lookahead == '*') ADVANCE(317);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == ',') ADVANCE(255);
      if (lookahead == '-') ADVANCE(309);
      if (lookahead == '.') ADVANCE(275);
      if (lookahead == '/') ADVANCE(257);
      if (lookahead == '0') ADVANCE(356);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(245);
      if (lookahead == '<') ADVANCE(334);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(332);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == ']') ADVANCE(263);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(343);
      if (lookahead == '`') ADVANCE(35);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '|') ADVANCE(330);
      if (lookahead == '}') ADVANCE(247);
      if (lookahead == '~') ADVANCE(312);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(239)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(357);
      END_STATE();
    case 240:
      if (eof) ADVANCE(243);
      if (lookahead == '\n') ADVANCE(244);
      if (lookahead == '!') ADVANCE(281);
      if (lookahead == '"') ADVANCE(347);
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '$') ADVANCE(259);
      if (lookahead == '&') ADVANCE(314);
      if (lookahead == '\'') ADVANCE(18);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == ',') ADVANCE(255);
      if (lookahead == '-') ADVANCE(306);
      if (lookahead == '.') ADVANCE(276);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == '0') ADVANCE(356);
      if (lookahead == ';') ADVANCE(245);
      if (lookahead == '@') ADVANCE(251);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(343);
      if (lookahead == '`') ADVANCE(35);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '}') ADVANCE(247);
      if (lookahead == '~') ADVANCE(312);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(240)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(357);
      END_STATE();
    case 241:
      if (eof) ADVANCE(243);
      if (lookahead == '\n') ADVANCE(244);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '%') ADVANCE(320);
      if (lookahead == '&') ADVANCE(316);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == '*') ADVANCE(317);
      if (lookahead == '+') ADVANCE(304);
      if (lookahead == ',') ADVANCE(255);
      if (lookahead == '-') ADVANCE(311);
      if (lookahead == '.') ADVANCE(274);
      if (lookahead == '/') ADVANCE(257);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(245);
      if (lookahead == '<') ADVANCE(334);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(332);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(343);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '|') ADVANCE(330);
      if (lookahead == '}') ADVANCE(247);
      if (lookahead == '~') ADVANCE(312);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(241)
      END_STATE();
    case 242:
      if (eof) ADVANCE(243);
      if (lookahead == '!') ADVANCE(282);
      if (lookahead == '"') ADVANCE(347);
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '$') ADVANCE(259);
      if (lookahead == '%') ADVANCE(319);
      if (lookahead == '&') ADVANCE(315);
      if (lookahead == '\'') ADVANCE(18);
      if (lookahead == '(') ADVANCE(252);
      if (lookahead == ')') ADVANCE(256);
      if (lookahead == '*') ADVANCE(318);
      if (lookahead == '+') ADVANCE(305);
      if (lookahead == ',') ADVANCE(255);
      if (lookahead == '-') ADVANCE(308);
      if (lookahead == '.') ADVANCE(275);
      if (lookahead == '/') ADVANCE(258);
      if (lookahead == '0') ADVANCE(356);
      if (lookahead == ':') ADVANCE(248);
      if (lookahead == ';') ADVANCE(245);
      if (lookahead == '<') ADVANCE(333);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(331);
      if (lookahead == '?') ADVANCE(264);
      if (lookahead == '@') ADVANCE(251);
      if (lookahead == '[') ADVANCE(262);
      if (lookahead == ']') ADVANCE(263);
      if (lookahead == '^') ADVANCE(260);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(343);
      if (lookahead == '`') ADVANCE(35);
      if (lookahead == '{') ADVANCE(246);
      if (lookahead == '|') ADVANCE(329);
      if (lookahead == '}') ADVANCE(247);
      if (lookahead == '~') ADVANCE(313);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(242)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(357);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(244);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_POUNDno_bounds_check);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_POUNDbounds_check);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(337);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(366);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(366);
      if (lookahead == '=') ADVANCE(291);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_POUNDrelative);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_POUNDsoa);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_POUNDsimd);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_POUNDno_nil);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_POUNDshared_nil);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_POUNDalign);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_POUNDno_copy);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_POUNDpacked);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_POUNDraw_union);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_POUNDtype);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(285);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(362);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(362);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_DASH);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_POUNDforce_inline);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_POUNDforce_no_inline);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(338);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_POUNDoptional_ok);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '<') ADVANCE(339);
      if (lookahead == '=') ADVANCE(340);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_POUNDno_alias);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_POUNDby_ptr);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_POUNDany_int);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_POUNDc_vararg);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_PERCENT_PERCENT_EQ);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_AMP_TILDE_EQ);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_POUNDpartial);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_POUNDunroll);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(298);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(13);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(13);
      if (lookahead == '=') ADVANCE(299);
      if (lookahead == '>') ADVANCE(280);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(13);
      if (lookahead == '>') ADVANCE(280);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(299);
      if (lookahead == '>') ADVANCE(280);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(280);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(300);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(341);
      if (lookahead == '=') ADVANCE(296);
      if (lookahead == '~') ADVANCE(328);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(341);
      if (lookahead == '~') ADVANCE(327);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(290);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '%') ADVANCE(322);
      if (lookahead == '=') ADVANCE(292);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '%') ADVANCE(321);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_PERCENT_PERCENT);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_PERCENT_PERCENT);
      if (lookahead == '=') ADVANCE(293);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(294);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(295);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_AMP_TILDE);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_AMP_TILDE);
      if (lookahead == '=') ADVANCE(297);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(301);
      if (lookahead == '|') ADVANCE(342);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(342);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(336);
      if (lookahead == '>') ADVANCE(326);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(336);
      if (lookahead == '>') ADVANCE(325);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(324);
      if (lookahead == '=') ADVANCE(335);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(323);
      if (lookahead == '=') ADVANCE(335);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_LT);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_EQ);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(343);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_builtin_procedure);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_builtin_procedure);
      if (lookahead == '_') ADVANCE(99);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_raw_string_literal);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '*') ADVANCE(350);
      if (lookahead == '/') ADVANCE(352);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(352);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '*') ADVANCE(349);
      if (lookahead == '/') ADVANCE(352);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(350);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '*') ADVANCE(349);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(350);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '/') ADVANCE(348);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(351);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(352);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(352);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(353);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(354);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(363);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(20);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(209);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(26);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(15);
      if (lookahead == '_') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(14);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(363);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(209);
      if (lookahead == '_') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(357);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(211);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(209);
      if (lookahead == '_') ADVANCE(223);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(358);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(212);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(359);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(360);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == '_') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(361);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(209);
      if (lookahead == '_') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(362);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(362);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_rune_literal);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(366);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '_') ADVANCE(1);
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'b') ADVANCE(3);
      if (lookahead == 'c') ADVANCE(4);
      if (lookahead == 'd') ADVANCE(5);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'f') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'p') ADVANCE(12);
      if (lookahead == 'q') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(14);
      if (lookahead == 's') ADVANCE(15);
      if (lookahead == 't') ADVANCE(16);
      if (lookahead == 'u') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      ACCEPT_TOKEN(sym_blank_identifier);
      END_STATE();
    case 2:
      if (lookahead == 'u') ADVANCE(19);
      END_STATE();
    case 3:
      if (lookahead == '1') ADVANCE(20);
      if (lookahead == '3') ADVANCE(21);
      if (lookahead == '6') ADVANCE(22);
      if (lookahead == '8') ADVANCE(23);
      if (lookahead == 'i') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(25);
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      if (lookahead == 's') ADVANCE(29);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      if (lookahead == 'y') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 7:
      if (lookahead == '1') ADVANCE(36);
      if (lookahead == '3') ADVANCE(37);
      if (lookahead == '6') ADVANCE(38);
      if (lookahead == 'a') ADVANCE(39);
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(41);
      if (lookahead == '3') ADVANCE(42);
      if (lookahead == '6') ADVANCE(43);
      if (lookahead == '8') ADVANCE(44);
      if (lookahead == 'f') ADVANCE(45);
      if (lookahead == 'm') ADVANCE(46);
      if (lookahead == 'n') ADVANCE(47);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(48);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(49);
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(51);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'r') ADVANCE(53);
      END_STATE();
    case 13:
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(55);
      if (lookahead == 'e') ADVANCE(56);
      END_STATE();
    case 15:
      if (lookahead == 't') ADVANCE(57);
      if (lookahead == 'w') ADVANCE(58);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(59);
      if (lookahead == 'y') ADVANCE(60);
      END_STATE();
    case 17:
      if (lookahead == '1') ADVANCE(61);
      if (lookahead == '3') ADVANCE(62);
      if (lookahead == '6') ADVANCE(63);
      if (lookahead == '8') ADVANCE(64);
      if (lookahead == 'i') ADVANCE(65);
      if (lookahead == 'n') ADVANCE(66);
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(68);
      END_STATE();
    case 19:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 20:
      if (lookahead == '6') ADVANCE(70);
      END_STATE();
    case 21:
      if (lookahead == '2') ADVANCE(71);
      END_STATE();
    case 22:
      if (lookahead == '4') ADVANCE(72);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_b8);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(73);
      END_STATE();
    case 25:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(76);
      END_STATE();
    case 28:
      if (lookahead == 'm') ADVANCE(77);
      if (lookahead == 'n') ADVANCE(78);
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 30:
      if (lookahead == 'f') ADVANCE(80);
      END_STATE();
    case 31:
      if (lookahead == 's') ADVANCE(81);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 36:
      if (lookahead == '6') ADVANCE(85);
      END_STATE();
    case 37:
      if (lookahead == '2') ADVANCE(86);
      END_STATE();
    case 38:
      if (lookahead == '4') ADVANCE(87);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(88);
      END_STATE();
    case 40:
      if (lookahead == 'r') ADVANCE(89);
      END_STATE();
    case 41:
      if (lookahead == '2') ADVANCE(90);
      if (lookahead == '6') ADVANCE(91);
      END_STATE();
    case 42:
      if (lookahead == '2') ADVANCE(92);
      END_STATE();
    case 43:
      if (lookahead == '4') ADVANCE(93);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_i8);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 46:
      if (lookahead == 'p') ADVANCE(94);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 48:
      if (lookahead == 'p') ADVANCE(96);
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(99);
      END_STATE();
    case 51:
      if (lookahead == '_') ADVANCE(100);
      END_STATE();
    case 52:
      if (lookahead == 'c') ADVANCE(101);
      END_STATE();
    case 53:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(103);
      END_STATE();
    case 55:
      if (lookahead == 'w') ADVANCE(104);
      END_STATE();
    case 56:
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 57:
      if (lookahead == 'r') ADVANCE(106);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(107);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(108);
      if (lookahead == 'u') ADVANCE(109);
      END_STATE();
    case 60:
      if (lookahead == 'p') ADVANCE(110);
      END_STATE();
    case 61:
      if (lookahead == '2') ADVANCE(111);
      if (lookahead == '6') ADVANCE(112);
      END_STATE();
    case 62:
      if (lookahead == '2') ADVANCE(113);
      END_STATE();
    case 63:
      if (lookahead == '4') ADVANCE(114);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_u8);
      END_STATE();
    case 65:
      if (lookahead == 'n') ADVANCE(115);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(116);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(117);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 69:
      if (lookahead == 'o') ADVANCE(119);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_b16);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_b32);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_b64);
      END_STATE();
    case 73:
      if (lookahead == '_') ADVANCE(120);
      END_STATE();
    case 74:
      if (lookahead == 'l') ADVANCE(121);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(122);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(123);
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 77:
      if (lookahead == 'p') ADVANCE(125);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(130);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 84:
      if (lookahead == 'm') ADVANCE(132);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_f16);
      if (lookahead == 'b') ADVANCE(133);
      if (lookahead == 'l') ADVANCE(134);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_f32);
      if (lookahead == 'b') ADVANCE(135);
      if (lookahead == 'l') ADVANCE(136);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_f64);
      if (lookahead == 'b') ADVANCE(137);
      if (lookahead == 'l') ADVANCE(138);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(139);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == 'e') ADVANCE(140);
      END_STATE();
    case 90:
      if (lookahead == '8') ADVANCE(141);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_i16);
      if (lookahead == 'b') ADVANCE(142);
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_i32);
      if (lookahead == 'b') ADVANCE(144);
      if (lookahead == 'l') ADVANCE(145);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_i64);
      if (lookahead == 'b') ADVANCE(146);
      if (lookahead == 'l') ADVANCE(147);
      END_STATE();
    case 94:
      if (lookahead == 'o') ADVANCE(148);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_map);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 99:
      if (lookahead == '_') ADVANCE(150);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(151);
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 101:
      if (lookahead == 'k') ADVANCE(153);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(154);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(155);
      END_STATE();
    case 104:
      if (lookahead == 'p') ADVANCE(156);
      END_STATE();
    case 105:
      if (lookahead == 'u') ADVANCE(157);
      END_STATE();
    case 106:
      if (lookahead == 'i') ADVANCE(158);
      if (lookahead == 'u') ADVANCE(159);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 108:
      if (lookahead == 'n') ADVANCE(161);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 111:
      if (lookahead == '8') ADVANCE(164);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_u16);
      if (lookahead == 'b') ADVANCE(165);
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_u32);
      if (lookahead == 'b') ADVANCE(167);
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_u64);
      if (lookahead == 'b') ADVANCE(169);
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 116:
      if (lookahead == 'o') ADVANCE(172);
      END_STATE();
    case 117:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 118:
      if (lookahead == 'n') ADVANCE(174);
      if (lookahead == 'r') ADVANCE(175);
      END_STATE();
    case 119:
      if (lookahead == '_') ADVANCE(176);
      END_STATE();
    case 120:
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 122:
      if (lookahead == 'k') ADVANCE(178);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_cast);
      END_STATE();
    case 125:
      if (lookahead == 'l') ADVANCE(179);
      END_STATE();
    case 126:
      if (lookahead == 'i') ADVANCE(180);
      END_STATE();
    case 127:
      if (lookahead == 'i') ADVANCE(181);
      END_STATE();
    case 128:
      if (lookahead == 'r') ADVANCE(182);
      END_STATE();
    case 129:
      if (lookahead == 'i') ADVANCE(183);
      END_STATE();
    case 130:
      if (lookahead == 'm') ADVANCE(184);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 135:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 140:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_i128);
      if (lookahead == 'b') ADVANCE(193);
      if (lookahead == 'l') ADVANCE(194);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(196);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(197);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(198);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(199);
      END_STATE();
    case 147:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(201);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(202);
      END_STATE();
    case 150:
      if (lookahead == 'i') ADVANCE(203);
      END_STATE();
    case 151:
      if (lookahead == 'l') ADVANCE(204);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 153:
      if (lookahead == 'a') ADVANCE(206);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_proc);
      END_STATE();
    case 155:
      if (lookahead == 'e') ADVANCE(207);
      END_STATE();
    case 156:
      if (lookahead == 't') ADVANCE(208);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(209);
      END_STATE();
    case 158:
      if (lookahead == 'n') ADVANCE(210);
      END_STATE();
    case 159:
      if (lookahead == 'c') ADVANCE(211);
      END_STATE();
    case 160:
      if (lookahead == 'c') ADVANCE(212);
      END_STATE();
    case 161:
      if (lookahead == 's') ADVANCE(213);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym__true);
      END_STATE();
    case 163:
      if (lookahead == 'i') ADVANCE(214);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_u128);
      if (lookahead == 'b') ADVANCE(215);
      if (lookahead == 'l') ADVANCE(216);
      END_STATE();
    case 165:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 167:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 168:
      if (lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 169:
      if (lookahead == 'e') ADVANCE(221);
      END_STATE();
    case 170:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_uint);
      if (lookahead == 'p') ADVANCE(223);
      END_STATE();
    case 172:
      if (lookahead == 'n') ADVANCE(224);
      END_STATE();
    case 173:
      if (lookahead == 'g') ADVANCE(225);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 175:
      if (lookahead == 'e') ADVANCE(226);
      END_STATE();
    case 176:
      if (lookahead == 'c') ADVANCE(227);
      END_STATE();
    case 177:
      if (lookahead == 'e') ADVANCE(228);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 179:
      if (lookahead == 'e') ADVANCE(229);
      END_STATE();
    case 180:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(231);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_defer);
      END_STATE();
    case 183:
      if (lookahead == 'n') ADVANCE(232);
      END_STATE();
    case 184:
      if (lookahead == 'i') ADVANCE(233);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_f16be);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_f16le);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_f32be);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_f32le);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_f64be);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_f64le);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym__false);
      END_STATE();
    case 192:
      if (lookahead == 'g') ADVANCE(234);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(235);
      END_STATE();
    case 194:
      if (lookahead == 'e') ADVANCE(236);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_i16be);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_i16le);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_i32be);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_i32le);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_i64be);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_i64le);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(237);
      END_STATE();
    case 202:
      if (lookahead == 'x') ADVANCE(238);
      END_STATE();
    case 203:
      if (lookahead == 'n') ADVANCE(239);
      END_STATE();
    case 204:
      if (lookahead == 's') ADVANCE(240);
      END_STATE();
    case 205:
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 206:
      if (lookahead == 'g') ADVANCE(242);
      END_STATE();
    case 207:
      if (lookahead == 'r') ADVANCE(243);
      END_STATE();
    case 208:
      if (lookahead == 'r') ADVANCE(244);
      END_STATE();
    case 209:
      if (lookahead == 'n') ADVANCE(245);
      END_STATE();
    case 210:
      if (lookahead == 'g') ADVANCE(246);
      END_STATE();
    case 211:
      if (lookahead == 't') ADVANCE(247);
      END_STATE();
    case 212:
      if (lookahead == 'h') ADVANCE(248);
      END_STATE();
    case 213:
      if (lookahead == 'm') ADVANCE(249);
      END_STATE();
    case 214:
      if (lookahead == 'd') ADVANCE(250);
      END_STATE();
    case 215:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(252);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_u16be);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_u16le);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_u32be);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_u32le);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_u64be);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_u64le);
      END_STATE();
    case 223:
      if (lookahead == 't') ADVANCE(253);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_where);
      END_STATE();
    case 227:
      if (lookahead == 'a') ADVANCE(254);
      END_STATE();
    case 228:
      if (lookahead == 't') ADVANCE(255);
      END_STATE();
    case 229:
      if (lookahead == 'x') ADVANCE(256);
      END_STATE();
    case 230:
      if (lookahead == 'u') ADVANCE(257);
      END_STATE();
    case 231:
      if (lookahead == 'g') ADVANCE(258);
      END_STATE();
    case 232:
      if (lookahead == 'c') ADVANCE(259);
      END_STATE();
    case 233:
      if (lookahead == 'c') ADVANCE(260);
      END_STATE();
    case 234:
      if (lookahead == 'n') ADVANCE(261);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_i128be);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_i128le);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_matrix);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_not_in);
      END_STATE();
    case 240:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 241:
      if (lookahead == 'u') ADVANCE(263);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 243:
      if (lookahead == 'n') ADVANCE(265);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_rawptr);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 249:
      if (lookahead == 'u') ADVANCE(266);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_typeid);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_u128be);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_u128le);
      END_STATE();
    case 253:
      if (lookahead == 'r') ADVANCE(267);
      END_STATE();
    case 254:
      if (lookahead == 's') ADVANCE(268);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_bit_set);
      END_STATE();
    case 256:
      if (lookahead == '1') ADVANCE(269);
      if (lookahead == '3') ADVANCE(270);
      if (lookahead == '6') ADVANCE(271);
      END_STATE();
    case 257:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_cstring);
      END_STATE();
    case 259:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_dynamic);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_foreign);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_or_else);
      END_STATE();
    case 263:
      if (lookahead == 'r') ADVANCE(274);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 265:
      if (lookahead == 'i') ADVANCE(275);
      END_STATE();
    case 266:
      if (lookahead == 't') ADVANCE(276);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_uintptr);
      END_STATE();
    case 268:
      if (lookahead == 't') ADVANCE(277);
      END_STATE();
    case 269:
      if (lookahead == '2') ADVANCE(278);
      END_STATE();
    case 270:
      if (lookahead == '2') ADVANCE(279);
      END_STATE();
    case 271:
      if (lookahead == '4') ADVANCE(280);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_distinct);
      END_STATE();
    case 274:
      if (lookahead == 'n') ADVANCE(281);
      END_STATE();
    case 275:
      if (lookahead == 'o') ADVANCE(282);
      END_STATE();
    case 276:
      if (lookahead == 'e') ADVANCE(283);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_auto_cast);
      END_STATE();
    case 278:
      if (lookahead == '8') ADVANCE(284);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_complex32);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_complex64);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_or_return);
      END_STATE();
    case 282:
      if (lookahead == 'n') ADVANCE(285);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_transmute);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_complex128);
      END_STATE();
    case 285:
      if (lookahead == '1') ADVANCE(286);
      if (lookahead == '2') ADVANCE(287);
      if (lookahead == '6') ADVANCE(288);
      END_STATE();
    case 286:
      if (lookahead == '2') ADVANCE(289);
      END_STATE();
    case 287:
      if (lookahead == '5') ADVANCE(290);
      END_STATE();
    case 288:
      if (lookahead == '4') ADVANCE(291);
      END_STATE();
    case 289:
      if (lookahead == '8') ADVANCE(292);
      END_STATE();
    case 290:
      if (lookahead == '6') ADVANCE(293);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_quaternion64);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_quaternion128);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_quaternion256);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 240},
  [3] = {.lex_state = 240},
  [4] = {.lex_state = 240},
  [5] = {.lex_state = 240},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 240},
  [9] = {.lex_state = 239},
  [10] = {.lex_state = 240},
  [11] = {.lex_state = 239},
  [12] = {.lex_state = 240},
  [13] = {.lex_state = 240},
  [14] = {.lex_state = 240},
  [15] = {.lex_state = 240},
  [16] = {.lex_state = 240},
  [17] = {.lex_state = 240},
  [18] = {.lex_state = 240},
  [19] = {.lex_state = 240},
  [20] = {.lex_state = 240},
  [21] = {.lex_state = 240},
  [22] = {.lex_state = 240},
  [23] = {.lex_state = 240},
  [24] = {.lex_state = 240},
  [25] = {.lex_state = 240},
  [26] = {.lex_state = 240},
  [27] = {.lex_state = 240},
  [28] = {.lex_state = 240},
  [29] = {.lex_state = 240},
  [30] = {.lex_state = 240},
  [31] = {.lex_state = 5},
  [32] = {.lex_state = 5},
  [33] = {.lex_state = 5},
  [34] = {.lex_state = 5},
  [35] = {.lex_state = 5},
  [36] = {.lex_state = 5},
  [37] = {.lex_state = 5},
  [38] = {.lex_state = 5},
  [39] = {.lex_state = 5},
  [40] = {.lex_state = 5},
  [41] = {.lex_state = 5},
  [42] = {.lex_state = 5},
  [43] = {.lex_state = 5},
  [44] = {.lex_state = 5},
  [45] = {.lex_state = 5},
  [46] = {.lex_state = 5},
  [47] = {.lex_state = 5},
  [48] = {.lex_state = 5},
  [49] = {.lex_state = 5},
  [50] = {.lex_state = 5},
  [51] = {.lex_state = 5},
  [52] = {.lex_state = 5},
  [53] = {.lex_state = 5},
  [54] = {.lex_state = 5},
  [55] = {.lex_state = 5},
  [56] = {.lex_state = 5},
  [57] = {.lex_state = 5},
  [58] = {.lex_state = 5},
  [59] = {.lex_state = 5},
  [60] = {.lex_state = 5},
  [61] = {.lex_state = 5},
  [62] = {.lex_state = 5},
  [63] = {.lex_state = 5},
  [64] = {.lex_state = 5},
  [65] = {.lex_state = 5},
  [66] = {.lex_state = 5},
  [67] = {.lex_state = 5},
  [68] = {.lex_state = 5},
  [69] = {.lex_state = 5},
  [70] = {.lex_state = 5},
  [71] = {.lex_state = 5},
  [72] = {.lex_state = 5},
  [73] = {.lex_state = 5},
  [74] = {.lex_state = 5},
  [75] = {.lex_state = 5},
  [76] = {.lex_state = 5},
  [77] = {.lex_state = 5},
  [78] = {.lex_state = 5},
  [79] = {.lex_state = 5},
  [80] = {.lex_state = 5},
  [81] = {.lex_state = 5},
  [82] = {.lex_state = 5},
  [83] = {.lex_state = 5},
  [84] = {.lex_state = 5},
  [85] = {.lex_state = 5},
  [86] = {.lex_state = 5},
  [87] = {.lex_state = 5},
  [88] = {.lex_state = 5},
  [89] = {.lex_state = 5},
  [90] = {.lex_state = 5},
  [91] = {.lex_state = 5},
  [92] = {.lex_state = 5},
  [93] = {.lex_state = 5},
  [94] = {.lex_state = 5},
  [95] = {.lex_state = 5},
  [96] = {.lex_state = 5},
  [97] = {.lex_state = 5},
  [98] = {.lex_state = 5},
  [99] = {.lex_state = 5},
  [100] = {.lex_state = 5},
  [101] = {.lex_state = 5},
  [102] = {.lex_state = 5},
  [103] = {.lex_state = 5},
  [104] = {.lex_state = 5},
  [105] = {.lex_state = 5},
  [106] = {.lex_state = 5},
  [107] = {.lex_state = 5},
  [108] = {.lex_state = 5},
  [109] = {.lex_state = 5},
  [110] = {.lex_state = 5},
  [111] = {.lex_state = 5},
  [112] = {.lex_state = 5},
  [113] = {.lex_state = 5},
  [114] = {.lex_state = 5},
  [115] = {.lex_state = 5},
  [116] = {.lex_state = 5},
  [117] = {.lex_state = 5},
  [118] = {.lex_state = 5},
  [119] = {.lex_state = 5},
  [120] = {.lex_state = 5},
  [121] = {.lex_state = 5},
  [122] = {.lex_state = 5},
  [123] = {.lex_state = 5},
  [124] = {.lex_state = 5},
  [125] = {.lex_state = 5},
  [126] = {.lex_state = 5},
  [127] = {.lex_state = 239},
  [128] = {.lex_state = 239},
  [129] = {.lex_state = 239},
  [130] = {.lex_state = 239},
  [131] = {.lex_state = 5},
  [132] = {.lex_state = 5},
  [133] = {.lex_state = 5},
  [134] = {.lex_state = 5},
  [135] = {.lex_state = 5},
  [136] = {.lex_state = 5},
  [137] = {.lex_state = 5},
  [138] = {.lex_state = 5},
  [139] = {.lex_state = 5},
  [140] = {.lex_state = 5},
  [141] = {.lex_state = 5},
  [142] = {.lex_state = 5},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 5},
  [147] = {.lex_state = 5},
  [148] = {.lex_state = 5},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 5},
  [156] = {.lex_state = 5},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 5},
  [159] = {.lex_state = 5},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 5},
  [162] = {.lex_state = 5},
  [163] = {.lex_state = 5},
  [164] = {.lex_state = 2},
  [165] = {.lex_state = 2},
  [166] = {.lex_state = 5},
  [167] = {.lex_state = 5},
  [168] = {.lex_state = 5},
  [169] = {.lex_state = 5},
  [170] = {.lex_state = 5},
  [171] = {.lex_state = 5},
  [172] = {.lex_state = 5},
  [173] = {.lex_state = 5},
  [174] = {.lex_state = 5},
  [175] = {.lex_state = 5},
  [176] = {.lex_state = 5},
  [177] = {.lex_state = 5},
  [178] = {.lex_state = 5},
  [179] = {.lex_state = 5},
  [180] = {.lex_state = 5},
  [181] = {.lex_state = 5},
  [182] = {.lex_state = 5},
  [183] = {.lex_state = 5},
  [184] = {.lex_state = 5},
  [185] = {.lex_state = 5},
  [186] = {.lex_state = 5},
  [187] = {.lex_state = 5},
  [188] = {.lex_state = 5},
  [189] = {.lex_state = 5},
  [190] = {.lex_state = 5},
  [191] = {.lex_state = 5},
  [192] = {.lex_state = 5},
  [193] = {.lex_state = 5},
  [194] = {.lex_state = 5},
  [195] = {.lex_state = 5},
  [196] = {.lex_state = 5},
  [197] = {.lex_state = 5},
  [198] = {.lex_state = 5},
  [199] = {.lex_state = 5},
  [200] = {.lex_state = 5},
  [201] = {.lex_state = 5},
  [202] = {.lex_state = 5},
  [203] = {.lex_state = 5},
  [204] = {.lex_state = 5},
  [205] = {.lex_state = 5},
  [206] = {.lex_state = 5},
  [207] = {.lex_state = 5},
  [208] = {.lex_state = 5},
  [209] = {.lex_state = 5},
  [210] = {.lex_state = 5},
  [211] = {.lex_state = 5},
  [212] = {.lex_state = 5},
  [213] = {.lex_state = 5},
  [214] = {.lex_state = 5},
  [215] = {.lex_state = 5},
  [216] = {.lex_state = 5},
  [217] = {.lex_state = 5},
  [218] = {.lex_state = 5},
  [219] = {.lex_state = 5},
  [220] = {.lex_state = 5},
  [221] = {.lex_state = 5},
  [222] = {.lex_state = 5},
  [223] = {.lex_state = 5},
  [224] = {.lex_state = 5},
  [225] = {.lex_state = 5},
  [226] = {.lex_state = 5},
  [227] = {.lex_state = 5},
  [228] = {.lex_state = 5},
  [229] = {.lex_state = 5},
  [230] = {.lex_state = 5},
  [231] = {.lex_state = 5},
  [232] = {.lex_state = 5},
  [233] = {.lex_state = 5},
  [234] = {.lex_state = 5},
  [235] = {.lex_state = 5},
  [236] = {.lex_state = 5},
  [237] = {.lex_state = 5},
  [238] = {.lex_state = 5},
  [239] = {.lex_state = 5},
  [240] = {.lex_state = 5},
  [241] = {.lex_state = 5},
  [242] = {.lex_state = 5},
  [243] = {.lex_state = 5},
  [244] = {.lex_state = 5},
  [245] = {.lex_state = 5},
  [246] = {.lex_state = 5},
  [247] = {.lex_state = 5},
  [248] = {.lex_state = 5},
  [249] = {.lex_state = 5},
  [250] = {.lex_state = 5},
  [251] = {.lex_state = 5},
  [252] = {.lex_state = 5},
  [253] = {.lex_state = 5},
  [254] = {.lex_state = 5},
  [255] = {.lex_state = 5},
  [256] = {.lex_state = 5},
  [257] = {.lex_state = 5},
  [258] = {.lex_state = 5},
  [259] = {.lex_state = 5},
  [260] = {.lex_state = 5},
  [261] = {.lex_state = 5},
  [262] = {.lex_state = 5},
  [263] = {.lex_state = 5},
  [264] = {.lex_state = 5},
  [265] = {.lex_state = 5},
  [266] = {.lex_state = 5},
  [267] = {.lex_state = 5},
  [268] = {.lex_state = 5},
  [269] = {.lex_state = 5},
  [270] = {.lex_state = 5},
  [271] = {.lex_state = 5},
  [272] = {.lex_state = 5},
  [273] = {.lex_state = 5},
  [274] = {.lex_state = 5},
  [275] = {.lex_state = 5},
  [276] = {.lex_state = 5},
  [277] = {.lex_state = 5},
  [278] = {.lex_state = 5},
  [279] = {.lex_state = 5},
  [280] = {.lex_state = 5},
  [281] = {.lex_state = 5},
  [282] = {.lex_state = 5},
  [283] = {.lex_state = 5},
  [284] = {.lex_state = 5},
  [285] = {.lex_state = 5},
  [286] = {.lex_state = 5},
  [287] = {.lex_state = 5},
  [288] = {.lex_state = 5},
  [289] = {.lex_state = 5},
  [290] = {.lex_state = 5},
  [291] = {.lex_state = 5},
  [292] = {.lex_state = 5},
  [293] = {.lex_state = 5},
  [294] = {.lex_state = 5},
  [295] = {.lex_state = 5},
  [296] = {.lex_state = 5},
  [297] = {.lex_state = 5},
  [298] = {.lex_state = 5},
  [299] = {.lex_state = 5},
  [300] = {.lex_state = 5},
  [301] = {.lex_state = 5},
  [302] = {.lex_state = 5},
  [303] = {.lex_state = 5},
  [304] = {.lex_state = 5},
  [305] = {.lex_state = 5},
  [306] = {.lex_state = 5},
  [307] = {.lex_state = 5},
  [308] = {.lex_state = 5},
  [309] = {.lex_state = 5},
  [310] = {.lex_state = 5},
  [311] = {.lex_state = 5},
  [312] = {.lex_state = 5},
  [313] = {.lex_state = 5},
  [314] = {.lex_state = 5},
  [315] = {.lex_state = 5},
  [316] = {.lex_state = 5},
  [317] = {.lex_state = 5},
  [318] = {.lex_state = 5},
  [319] = {.lex_state = 5},
  [320] = {.lex_state = 5},
  [321] = {.lex_state = 5},
  [322] = {.lex_state = 5},
  [323] = {.lex_state = 5},
  [324] = {.lex_state = 5},
  [325] = {.lex_state = 5},
  [326] = {.lex_state = 5},
  [327] = {.lex_state = 5},
  [328] = {.lex_state = 5},
  [329] = {.lex_state = 5},
  [330] = {.lex_state = 5},
  [331] = {.lex_state = 5},
  [332] = {.lex_state = 5},
  [333] = {.lex_state = 5},
  [334] = {.lex_state = 5},
  [335] = {.lex_state = 5},
  [336] = {.lex_state = 5},
  [337] = {.lex_state = 5},
  [338] = {.lex_state = 5},
  [339] = {.lex_state = 5},
  [340] = {.lex_state = 5},
  [341] = {.lex_state = 5},
  [342] = {.lex_state = 5},
  [343] = {.lex_state = 5},
  [344] = {.lex_state = 5},
  [345] = {.lex_state = 5},
  [346] = {.lex_state = 5},
  [347] = {.lex_state = 5},
  [348] = {.lex_state = 5},
  [349] = {.lex_state = 5},
  [350] = {.lex_state = 5},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 5},
  [353] = {.lex_state = 5},
  [354] = {.lex_state = 5},
  [355] = {.lex_state = 5},
  [356] = {.lex_state = 5},
  [357] = {.lex_state = 5},
  [358] = {.lex_state = 5},
  [359] = {.lex_state = 5},
  [360] = {.lex_state = 5},
  [361] = {.lex_state = 5},
  [362] = {.lex_state = 5},
  [363] = {.lex_state = 5},
  [364] = {.lex_state = 5},
  [365] = {.lex_state = 5},
  [366] = {.lex_state = 5},
  [367] = {.lex_state = 5},
  [368] = {.lex_state = 5},
  [369] = {.lex_state = 5},
  [370] = {.lex_state = 5},
  [371] = {.lex_state = 5},
  [372] = {.lex_state = 5},
  [373] = {.lex_state = 5},
  [374] = {.lex_state = 5},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 5},
  [377] = {.lex_state = 5},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 5},
  [380] = {.lex_state = 5},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 5},
  [383] = {.lex_state = 5},
  [384] = {.lex_state = 5},
  [385] = {.lex_state = 5},
  [386] = {.lex_state = 5},
  [387] = {.lex_state = 5},
  [388] = {.lex_state = 5},
  [389] = {.lex_state = 5},
  [390] = {.lex_state = 5},
  [391] = {.lex_state = 5},
  [392] = {.lex_state = 5},
  [393] = {.lex_state = 5},
  [394] = {.lex_state = 5},
  [395] = {.lex_state = 5},
  [396] = {.lex_state = 5},
  [397] = {.lex_state = 5},
  [398] = {.lex_state = 5},
  [399] = {.lex_state = 5},
  [400] = {.lex_state = 5},
  [401] = {.lex_state = 5},
  [402] = {.lex_state = 5},
  [403] = {.lex_state = 5},
  [404] = {.lex_state = 5},
  [405] = {.lex_state = 5},
  [406] = {.lex_state = 5},
  [407] = {.lex_state = 5},
  [408] = {.lex_state = 5},
  [409] = {.lex_state = 5},
  [410] = {.lex_state = 5},
  [411] = {.lex_state = 5},
  [412] = {.lex_state = 5},
  [413] = {.lex_state = 5},
  [414] = {.lex_state = 5},
  [415] = {.lex_state = 5},
  [416] = {.lex_state = 5},
  [417] = {.lex_state = 5},
  [418] = {.lex_state = 5},
  [419] = {.lex_state = 5},
  [420] = {.lex_state = 5},
  [421] = {.lex_state = 5},
  [422] = {.lex_state = 5},
  [423] = {.lex_state = 5},
  [424] = {.lex_state = 5},
  [425] = {.lex_state = 5},
  [426] = {.lex_state = 5},
  [427] = {.lex_state = 5},
  [428] = {.lex_state = 5},
  [429] = {.lex_state = 5},
  [430] = {.lex_state = 5},
  [431] = {.lex_state = 5},
  [432] = {.lex_state = 5},
  [433] = {.lex_state = 5},
  [434] = {.lex_state = 5},
  [435] = {.lex_state = 5},
  [436] = {.lex_state = 5},
  [437] = {.lex_state = 5},
  [438] = {.lex_state = 5},
  [439] = {.lex_state = 5},
  [440] = {.lex_state = 5},
  [441] = {.lex_state = 5},
  [442] = {.lex_state = 5},
  [443] = {.lex_state = 5},
  [444] = {.lex_state = 5},
  [445] = {.lex_state = 5},
  [446] = {.lex_state = 5},
  [447] = {.lex_state = 5},
  [448] = {.lex_state = 5},
  [449] = {.lex_state = 5},
  [450] = {.lex_state = 5},
  [451] = {.lex_state = 5},
  [452] = {.lex_state = 5},
  [453] = {.lex_state = 5},
  [454] = {.lex_state = 5},
  [455] = {.lex_state = 5},
  [456] = {.lex_state = 5},
  [457] = {.lex_state = 5},
  [458] = {.lex_state = 5},
  [459] = {.lex_state = 5},
  [460] = {.lex_state = 5},
  [461] = {.lex_state = 5},
  [462] = {.lex_state = 5},
  [463] = {.lex_state = 5},
  [464] = {.lex_state = 5},
  [465] = {.lex_state = 5},
  [466] = {.lex_state = 5},
  [467] = {.lex_state = 5},
  [468] = {.lex_state = 5},
  [469] = {.lex_state = 5},
  [470] = {.lex_state = 5},
  [471] = {.lex_state = 5},
  [472] = {.lex_state = 5},
  [473] = {.lex_state = 5},
  [474] = {.lex_state = 5},
  [475] = {.lex_state = 5},
  [476] = {.lex_state = 5},
  [477] = {.lex_state = 5},
  [478] = {.lex_state = 5},
  [479] = {.lex_state = 5},
  [480] = {.lex_state = 5},
  [481] = {.lex_state = 5},
  [482] = {.lex_state = 5},
  [483] = {.lex_state = 5},
  [484] = {.lex_state = 5},
  [485] = {.lex_state = 5},
  [486] = {.lex_state = 5},
  [487] = {.lex_state = 5},
  [488] = {.lex_state = 5},
  [489] = {.lex_state = 5},
  [490] = {.lex_state = 5},
  [491] = {.lex_state = 5},
  [492] = {.lex_state = 5},
  [493] = {.lex_state = 5},
  [494] = {.lex_state = 5},
  [495] = {.lex_state = 5},
  [496] = {.lex_state = 5},
  [497] = {.lex_state = 5},
  [498] = {.lex_state = 5},
  [499] = {.lex_state = 5},
  [500] = {.lex_state = 5},
  [501] = {.lex_state = 5},
  [502] = {.lex_state = 5},
  [503] = {.lex_state = 5},
  [504] = {.lex_state = 5},
  [505] = {.lex_state = 5},
  [506] = {.lex_state = 5},
  [507] = {.lex_state = 5},
  [508] = {.lex_state = 5},
  [509] = {.lex_state = 5},
  [510] = {.lex_state = 5},
  [511] = {.lex_state = 5},
  [512] = {.lex_state = 5},
  [513] = {.lex_state = 5},
  [514] = {.lex_state = 5},
  [515] = {.lex_state = 5},
  [516] = {.lex_state = 5},
  [517] = {.lex_state = 5},
  [518] = {.lex_state = 5},
  [519] = {.lex_state = 5},
  [520] = {.lex_state = 5},
  [521] = {.lex_state = 5},
  [522] = {.lex_state = 5},
  [523] = {.lex_state = 5},
  [524] = {.lex_state = 5},
  [525] = {.lex_state = 5},
  [526] = {.lex_state = 5},
  [527] = {.lex_state = 5},
  [528] = {.lex_state = 5},
  [529] = {.lex_state = 5},
  [530] = {.lex_state = 5},
  [531] = {.lex_state = 5},
  [532] = {.lex_state = 5},
  [533] = {.lex_state = 5},
  [534] = {.lex_state = 5},
  [535] = {.lex_state = 5},
  [536] = {.lex_state = 5},
  [537] = {.lex_state = 5},
  [538] = {.lex_state = 5},
  [539] = {.lex_state = 5},
  [540] = {.lex_state = 5},
  [541] = {.lex_state = 5},
  [542] = {.lex_state = 5},
  [543] = {.lex_state = 5},
  [544] = {.lex_state = 5},
  [545] = {.lex_state = 5},
  [546] = {.lex_state = 5},
  [547] = {.lex_state = 5},
  [548] = {.lex_state = 5},
  [549] = {.lex_state = 5},
  [550] = {.lex_state = 5},
  [551] = {.lex_state = 5},
  [552] = {.lex_state = 5},
  [553] = {.lex_state = 5},
  [554] = {.lex_state = 5},
  [555] = {.lex_state = 5},
  [556] = {.lex_state = 5},
  [557] = {.lex_state = 5},
  [558] = {.lex_state = 5},
  [559] = {.lex_state = 5},
  [560] = {.lex_state = 5},
  [561] = {.lex_state = 5},
  [562] = {.lex_state = 5},
  [563] = {.lex_state = 5},
  [564] = {.lex_state = 5},
  [565] = {.lex_state = 5},
  [566] = {.lex_state = 5},
  [567] = {.lex_state = 5},
  [568] = {.lex_state = 5},
  [569] = {.lex_state = 5},
  [570] = {.lex_state = 5},
  [571] = {.lex_state = 5},
  [572] = {.lex_state = 5},
  [573] = {.lex_state = 5},
  [574] = {.lex_state = 5},
  [575] = {.lex_state = 5},
  [576] = {.lex_state = 5},
  [577] = {.lex_state = 5},
  [578] = {.lex_state = 5},
  [579] = {.lex_state = 5},
  [580] = {.lex_state = 5},
  [581] = {.lex_state = 5},
  [582] = {.lex_state = 5},
  [583] = {.lex_state = 5},
  [584] = {.lex_state = 5},
  [585] = {.lex_state = 5},
  [586] = {.lex_state = 5},
  [587] = {.lex_state = 5},
  [588] = {.lex_state = 5},
  [589] = {.lex_state = 5},
  [590] = {.lex_state = 5},
  [591] = {.lex_state = 5},
  [592] = {.lex_state = 5},
  [593] = {.lex_state = 5},
  [594] = {.lex_state = 5},
  [595] = {.lex_state = 5},
  [596] = {.lex_state = 5},
  [597] = {.lex_state = 5},
  [598] = {.lex_state = 5},
  [599] = {.lex_state = 5},
  [600] = {.lex_state = 5},
  [601] = {.lex_state = 5},
  [602] = {.lex_state = 5},
  [603] = {.lex_state = 5},
  [604] = {.lex_state = 5},
  [605] = {.lex_state = 5},
  [606] = {.lex_state = 5},
  [607] = {.lex_state = 5},
  [608] = {.lex_state = 5},
  [609] = {.lex_state = 5},
  [610] = {.lex_state = 5},
  [611] = {.lex_state = 5},
  [612] = {.lex_state = 5},
  [613] = {.lex_state = 5},
  [614] = {.lex_state = 5},
  [615] = {.lex_state = 5},
  [616] = {.lex_state = 5},
  [617] = {.lex_state = 5},
  [618] = {.lex_state = 5},
  [619] = {.lex_state = 5},
  [620] = {.lex_state = 5},
  [621] = {.lex_state = 5},
  [622] = {.lex_state = 5},
  [623] = {.lex_state = 5},
  [624] = {.lex_state = 5},
  [625] = {.lex_state = 5},
  [626] = {.lex_state = 5},
  [627] = {.lex_state = 5},
  [628] = {.lex_state = 5},
  [629] = {.lex_state = 5},
  [630] = {.lex_state = 5},
  [631] = {.lex_state = 5},
  [632] = {.lex_state = 5},
  [633] = {.lex_state = 5},
  [634] = {.lex_state = 5},
  [635] = {.lex_state = 5},
  [636] = {.lex_state = 5},
  [637] = {.lex_state = 5},
  [638] = {.lex_state = 5},
  [639] = {.lex_state = 5},
  [640] = {.lex_state = 5},
  [641] = {.lex_state = 5},
  [642] = {.lex_state = 5},
  [643] = {.lex_state = 5},
  [644] = {.lex_state = 5},
  [645] = {.lex_state = 5},
  [646] = {.lex_state = 5},
  [647] = {.lex_state = 5},
  [648] = {.lex_state = 5},
  [649] = {.lex_state = 5},
  [650] = {.lex_state = 5},
  [651] = {.lex_state = 5},
  [652] = {.lex_state = 5},
  [653] = {.lex_state = 5},
  [654] = {.lex_state = 5},
  [655] = {.lex_state = 5},
  [656] = {.lex_state = 5},
  [657] = {.lex_state = 5},
  [658] = {.lex_state = 5},
  [659] = {.lex_state = 5},
  [660] = {.lex_state = 5},
  [661] = {.lex_state = 5},
  [662] = {.lex_state = 5},
  [663] = {.lex_state = 5},
  [664] = {.lex_state = 5},
  [665] = {.lex_state = 5},
  [666] = {.lex_state = 5},
  [667] = {.lex_state = 5},
  [668] = {.lex_state = 5},
  [669] = {.lex_state = 5},
  [670] = {.lex_state = 5},
  [671] = {.lex_state = 5},
  [672] = {.lex_state = 5},
  [673] = {.lex_state = 5},
  [674] = {.lex_state = 5},
  [675] = {.lex_state = 5},
  [676] = {.lex_state = 5},
  [677] = {.lex_state = 5},
  [678] = {.lex_state = 5},
  [679] = {.lex_state = 5},
  [680] = {.lex_state = 5},
  [681] = {.lex_state = 5},
  [682] = {.lex_state = 5},
  [683] = {.lex_state = 5},
  [684] = {.lex_state = 5},
  [685] = {.lex_state = 5},
  [686] = {.lex_state = 5},
  [687] = {.lex_state = 5},
  [688] = {.lex_state = 5},
  [689] = {.lex_state = 5},
  [690] = {.lex_state = 5},
  [691] = {.lex_state = 5},
  [692] = {.lex_state = 5},
  [693] = {.lex_state = 5},
  [694] = {.lex_state = 5},
  [695] = {.lex_state = 5},
  [696] = {.lex_state = 5},
  [697] = {.lex_state = 5},
  [698] = {.lex_state = 5},
  [699] = {.lex_state = 5},
  [700] = {.lex_state = 5},
  [701] = {.lex_state = 5},
  [702] = {.lex_state = 5},
  [703] = {.lex_state = 5},
  [704] = {.lex_state = 5},
  [705] = {.lex_state = 5},
  [706] = {.lex_state = 5},
  [707] = {.lex_state = 5},
  [708] = {.lex_state = 5},
  [709] = {.lex_state = 5},
  [710] = {.lex_state = 5},
  [711] = {.lex_state = 5},
  [712] = {.lex_state = 5},
  [713] = {.lex_state = 5},
  [714] = {.lex_state = 5},
  [715] = {.lex_state = 5},
  [716] = {.lex_state = 5},
  [717] = {.lex_state = 5},
  [718] = {.lex_state = 5},
  [719] = {.lex_state = 5},
  [720] = {.lex_state = 5},
  [721] = {.lex_state = 5},
  [722] = {.lex_state = 5},
  [723] = {.lex_state = 5},
  [724] = {.lex_state = 5},
  [725] = {.lex_state = 5},
  [726] = {.lex_state = 5},
  [727] = {.lex_state = 5},
  [728] = {.lex_state = 5},
  [729] = {.lex_state = 5},
  [730] = {.lex_state = 5},
  [731] = {.lex_state = 5},
  [732] = {.lex_state = 5},
  [733] = {.lex_state = 5},
  [734] = {.lex_state = 5},
  [735] = {.lex_state = 5},
  [736] = {.lex_state = 5},
  [737] = {.lex_state = 5},
  [738] = {.lex_state = 5},
  [739] = {.lex_state = 5},
  [740] = {.lex_state = 5},
  [741] = {.lex_state = 5},
  [742] = {.lex_state = 5},
  [743] = {.lex_state = 5},
  [744] = {.lex_state = 5},
  [745] = {.lex_state = 5},
  [746] = {.lex_state = 5},
  [747] = {.lex_state = 5},
  [748] = {.lex_state = 5},
  [749] = {.lex_state = 5},
  [750] = {.lex_state = 5},
  [751] = {.lex_state = 5},
  [752] = {.lex_state = 5},
  [753] = {.lex_state = 5},
  [754] = {.lex_state = 5},
  [755] = {.lex_state = 5},
  [756] = {.lex_state = 5},
  [757] = {.lex_state = 5},
  [758] = {.lex_state = 5},
  [759] = {.lex_state = 5},
  [760] = {.lex_state = 5},
  [761] = {.lex_state = 5},
  [762] = {.lex_state = 5},
  [763] = {.lex_state = 5},
  [764] = {.lex_state = 5},
  [765] = {.lex_state = 5},
  [766] = {.lex_state = 5},
  [767] = {.lex_state = 5},
  [768] = {.lex_state = 5},
  [769] = {.lex_state = 5},
  [770] = {.lex_state = 5},
  [771] = {.lex_state = 5},
  [772] = {.lex_state = 5},
  [773] = {.lex_state = 5},
  [774] = {.lex_state = 5},
  [775] = {.lex_state = 5},
  [776] = {.lex_state = 5},
  [777] = {.lex_state = 5},
  [778] = {.lex_state = 5},
  [779] = {.lex_state = 5},
  [780] = {.lex_state = 5},
  [781] = {.lex_state = 5},
  [782] = {.lex_state = 5},
  [783] = {.lex_state = 5},
  [784] = {.lex_state = 5},
  [785] = {.lex_state = 5},
  [786] = {.lex_state = 5},
  [787] = {.lex_state = 5},
  [788] = {.lex_state = 5},
  [789] = {.lex_state = 5},
  [790] = {.lex_state = 5},
  [791] = {.lex_state = 5},
  [792] = {.lex_state = 5},
  [793] = {.lex_state = 5},
  [794] = {.lex_state = 5},
  [795] = {.lex_state = 5},
  [796] = {.lex_state = 5},
  [797] = {.lex_state = 5},
  [798] = {.lex_state = 5},
  [799] = {.lex_state = 5},
  [800] = {.lex_state = 5},
  [801] = {.lex_state = 5},
  [802] = {.lex_state = 5},
  [803] = {.lex_state = 5},
  [804] = {.lex_state = 5},
  [805] = {.lex_state = 5},
  [806] = {.lex_state = 5},
  [807] = {.lex_state = 5},
  [808] = {.lex_state = 5},
  [809] = {.lex_state = 5},
  [810] = {.lex_state = 5},
  [811] = {.lex_state = 5},
  [812] = {.lex_state = 5},
  [813] = {.lex_state = 5},
  [814] = {.lex_state = 5},
  [815] = {.lex_state = 5},
  [816] = {.lex_state = 5},
  [817] = {.lex_state = 5},
  [818] = {.lex_state = 5},
  [819] = {.lex_state = 5},
  [820] = {.lex_state = 5},
  [821] = {.lex_state = 5},
  [822] = {.lex_state = 5},
  [823] = {.lex_state = 5},
  [824] = {.lex_state = 5},
  [825] = {.lex_state = 5},
  [826] = {.lex_state = 5},
  [827] = {.lex_state = 5},
  [828] = {.lex_state = 5},
  [829] = {.lex_state = 5},
  [830] = {.lex_state = 5},
  [831] = {.lex_state = 5},
  [832] = {.lex_state = 5},
  [833] = {.lex_state = 5},
  [834] = {.lex_state = 5},
  [835] = {.lex_state = 5},
  [836] = {.lex_state = 5},
  [837] = {.lex_state = 5},
  [838] = {.lex_state = 5},
  [839] = {.lex_state = 5},
  [840] = {.lex_state = 5},
  [841] = {.lex_state = 5},
  [842] = {.lex_state = 5},
  [843] = {.lex_state = 5},
  [844] = {.lex_state = 5},
  [845] = {.lex_state = 5},
  [846] = {.lex_state = 5},
  [847] = {.lex_state = 5},
  [848] = {.lex_state = 5},
  [849] = {.lex_state = 5},
  [850] = {.lex_state = 5},
  [851] = {.lex_state = 5},
  [852] = {.lex_state = 5},
  [853] = {.lex_state = 5},
  [854] = {.lex_state = 5},
  [855] = {.lex_state = 5},
  [856] = {.lex_state = 5},
  [857] = {.lex_state = 5},
  [858] = {.lex_state = 5},
  [859] = {.lex_state = 5},
  [860] = {.lex_state = 5},
  [861] = {.lex_state = 5},
  [862] = {.lex_state = 5},
  [863] = {.lex_state = 5},
  [864] = {.lex_state = 5},
  [865] = {.lex_state = 5},
  [866] = {.lex_state = 5},
  [867] = {.lex_state = 5},
  [868] = {.lex_state = 5},
  [869] = {.lex_state = 5},
  [870] = {.lex_state = 5},
  [871] = {.lex_state = 5},
  [872] = {.lex_state = 5},
  [873] = {.lex_state = 5},
  [874] = {.lex_state = 5},
  [875] = {.lex_state = 5},
  [876] = {.lex_state = 5},
  [877] = {.lex_state = 5},
  [878] = {.lex_state = 5},
  [879] = {.lex_state = 5},
  [880] = {.lex_state = 5},
  [881] = {.lex_state = 5},
  [882] = {.lex_state = 5},
  [883] = {.lex_state = 5},
  [884] = {.lex_state = 5},
  [885] = {.lex_state = 5},
  [886] = {.lex_state = 5},
  [887] = {.lex_state = 5},
  [888] = {.lex_state = 5},
  [889] = {.lex_state = 5},
  [890] = {.lex_state = 5},
  [891] = {.lex_state = 5},
  [892] = {.lex_state = 5},
  [893] = {.lex_state = 5},
  [894] = {.lex_state = 5},
  [895] = {.lex_state = 5},
  [896] = {.lex_state = 5},
  [897] = {.lex_state = 5},
  [898] = {.lex_state = 5},
  [899] = {.lex_state = 5},
  [900] = {.lex_state = 5},
  [901] = {.lex_state = 5},
  [902] = {.lex_state = 5},
  [903] = {.lex_state = 5},
  [904] = {.lex_state = 5},
  [905] = {.lex_state = 5},
  [906] = {.lex_state = 5},
  [907] = {.lex_state = 5},
  [908] = {.lex_state = 5},
  [909] = {.lex_state = 5},
  [910] = {.lex_state = 5},
  [911] = {.lex_state = 5},
  [912] = {.lex_state = 5},
  [913] = {.lex_state = 5},
  [914] = {.lex_state = 5},
  [915] = {.lex_state = 5},
  [916] = {.lex_state = 5},
  [917] = {.lex_state = 5},
  [918] = {.lex_state = 5},
  [919] = {.lex_state = 5},
  [920] = {.lex_state = 5},
  [921] = {.lex_state = 5},
  [922] = {.lex_state = 5},
  [923] = {.lex_state = 5},
  [924] = {.lex_state = 5},
  [925] = {.lex_state = 5},
  [926] = {.lex_state = 5},
  [927] = {.lex_state = 5},
  [928] = {.lex_state = 5},
  [929] = {.lex_state = 5},
  [930] = {.lex_state = 5},
  [931] = {.lex_state = 5},
  [932] = {.lex_state = 5},
  [933] = {.lex_state = 5},
  [934] = {.lex_state = 5},
  [935] = {.lex_state = 240},
  [936] = {.lex_state = 240},
  [937] = {.lex_state = 240},
  [938] = {.lex_state = 5},
  [939] = {.lex_state = 239},
  [940] = {.lex_state = 1},
  [941] = {.lex_state = 239},
  [942] = {.lex_state = 1},
  [943] = {.lex_state = 239},
  [944] = {.lex_state = 239},
  [945] = {.lex_state = 239},
  [946] = {.lex_state = 239},
  [947] = {.lex_state = 1},
  [948] = {.lex_state = 1},
  [949] = {.lex_state = 239},
  [950] = {.lex_state = 239},
  [951] = {.lex_state = 1},
  [952] = {.lex_state = 1},
  [953] = {.lex_state = 1},
  [954] = {.lex_state = 1},
  [955] = {.lex_state = 1},
  [956] = {.lex_state = 1},
  [957] = {.lex_state = 239},
  [958] = {.lex_state = 239},
  [959] = {.lex_state = 1},
  [960] = {.lex_state = 1},
  [961] = {.lex_state = 1},
  [962] = {.lex_state = 239},
  [963] = {.lex_state = 239},
  [964] = {.lex_state = 1},
  [965] = {.lex_state = 239},
  [966] = {.lex_state = 1},
  [967] = {.lex_state = 1},
  [968] = {.lex_state = 1},
  [969] = {.lex_state = 239},
  [970] = {.lex_state = 239},
  [971] = {.lex_state = 239},
  [972] = {.lex_state = 1},
  [973] = {.lex_state = 239},
  [974] = {.lex_state = 1},
  [975] = {.lex_state = 1},
  [976] = {.lex_state = 1},
  [977] = {.lex_state = 1},
  [978] = {.lex_state = 1},
  [979] = {.lex_state = 239},
  [980] = {.lex_state = 239},
  [981] = {.lex_state = 1},
  [982] = {.lex_state = 239},
  [983] = {.lex_state = 1},
  [984] = {.lex_state = 1},
  [985] = {.lex_state = 239},
  [986] = {.lex_state = 1},
  [987] = {.lex_state = 239},
  [988] = {.lex_state = 1},
  [989] = {.lex_state = 239},
  [990] = {.lex_state = 239},
  [991] = {.lex_state = 1},
  [992] = {.lex_state = 1},
  [993] = {.lex_state = 1},
  [994] = {.lex_state = 1},
  [995] = {.lex_state = 1},
  [996] = {.lex_state = 239},
  [997] = {.lex_state = 1},
  [998] = {.lex_state = 1},
  [999] = {.lex_state = 1},
  [1000] = {.lex_state = 239},
  [1001] = {.lex_state = 239},
  [1002] = {.lex_state = 239},
  [1003] = {.lex_state = 1},
  [1004] = {.lex_state = 239},
  [1005] = {.lex_state = 239},
  [1006] = {.lex_state = 1},
  [1007] = {.lex_state = 1},
  [1008] = {.lex_state = 1},
  [1009] = {.lex_state = 239},
  [1010] = {.lex_state = 1},
  [1011] = {.lex_state = 239},
  [1012] = {.lex_state = 1},
  [1013] = {.lex_state = 1},
  [1014] = {.lex_state = 239},
  [1015] = {.lex_state = 1},
  [1016] = {.lex_state = 6},
  [1017] = {.lex_state = 1},
  [1018] = {.lex_state = 1},
  [1019] = {.lex_state = 1},
  [1020] = {.lex_state = 1},
  [1021] = {.lex_state = 1},
  [1022] = {.lex_state = 1},
  [1023] = {.lex_state = 1},
  [1024] = {.lex_state = 1},
  [1025] = {.lex_state = 1},
  [1026] = {.lex_state = 1},
  [1027] = {.lex_state = 1},
  [1028] = {.lex_state = 1},
  [1029] = {.lex_state = 1},
  [1030] = {.lex_state = 239},
  [1031] = {.lex_state = 239},
  [1032] = {.lex_state = 1},
  [1033] = {.lex_state = 239},
  [1034] = {.lex_state = 1},
  [1035] = {.lex_state = 1},
  [1036] = {.lex_state = 1},
  [1037] = {.lex_state = 239},
  [1038] = {.lex_state = 239},
  [1039] = {.lex_state = 239},
  [1040] = {.lex_state = 1},
  [1041] = {.lex_state = 1},
  [1042] = {.lex_state = 1},
  [1043] = {.lex_state = 1},
  [1044] = {.lex_state = 1},
  [1045] = {.lex_state = 239},
  [1046] = {.lex_state = 239},
  [1047] = {.lex_state = 1},
  [1048] = {.lex_state = 1},
  [1049] = {.lex_state = 1},
  [1050] = {.lex_state = 239},
  [1051] = {.lex_state = 6},
  [1052] = {.lex_state = 1},
  [1053] = {.lex_state = 239},
  [1054] = {.lex_state = 239},
  [1055] = {.lex_state = 1},
  [1056] = {.lex_state = 1},
  [1057] = {.lex_state = 1},
  [1058] = {.lex_state = 239},
  [1059] = {.lex_state = 1},
  [1060] = {.lex_state = 1},
  [1061] = {.lex_state = 1},
  [1062] = {.lex_state = 6},
  [1063] = {.lex_state = 239},
  [1064] = {.lex_state = 1},
  [1065] = {.lex_state = 1},
  [1066] = {.lex_state = 239},
  [1067] = {.lex_state = 239},
  [1068] = {.lex_state = 239},
  [1069] = {.lex_state = 239},
  [1070] = {.lex_state = 239},
  [1071] = {.lex_state = 1},
  [1072] = {.lex_state = 239},
  [1073] = {.lex_state = 1},
  [1074] = {.lex_state = 239},
  [1075] = {.lex_state = 239},
  [1076] = {.lex_state = 239},
  [1077] = {.lex_state = 6},
  [1078] = {.lex_state = 1},
  [1079] = {.lex_state = 1},
  [1080] = {.lex_state = 239},
  [1081] = {.lex_state = 1},
  [1082] = {.lex_state = 239},
  [1083] = {.lex_state = 1},
  [1084] = {.lex_state = 239},
  [1085] = {.lex_state = 1},
  [1086] = {.lex_state = 1},
  [1087] = {.lex_state = 1},
  [1088] = {.lex_state = 1},
  [1089] = {.lex_state = 239},
  [1090] = {.lex_state = 1},
  [1091] = {.lex_state = 239},
  [1092] = {.lex_state = 1},
  [1093] = {.lex_state = 239},
  [1094] = {.lex_state = 1},
  [1095] = {.lex_state = 239},
  [1096] = {.lex_state = 239},
  [1097] = {.lex_state = 239},
  [1098] = {.lex_state = 239},
  [1099] = {.lex_state = 1},
  [1100] = {.lex_state = 1},
  [1101] = {.lex_state = 239},
  [1102] = {.lex_state = 1},
  [1103] = {.lex_state = 239},
  [1104] = {.lex_state = 239},
  [1105] = {.lex_state = 239},
  [1106] = {.lex_state = 239},
  [1107] = {.lex_state = 239},
  [1108] = {.lex_state = 239},
  [1109] = {.lex_state = 239},
  [1110] = {.lex_state = 239},
  [1111] = {.lex_state = 1},
  [1112] = {.lex_state = 239},
  [1113] = {.lex_state = 239},
  [1114] = {.lex_state = 1},
  [1115] = {.lex_state = 1},
  [1116] = {.lex_state = 239},
  [1117] = {.lex_state = 239},
  [1118] = {.lex_state = 239},
  [1119] = {.lex_state = 239},
  [1120] = {.lex_state = 239},
  [1121] = {.lex_state = 239},
  [1122] = {.lex_state = 1},
  [1123] = {.lex_state = 239},
  [1124] = {.lex_state = 239},
  [1125] = {.lex_state = 1},
  [1126] = {.lex_state = 239},
  [1127] = {.lex_state = 1},
  [1128] = {.lex_state = 239},
  [1129] = {.lex_state = 1},
  [1130] = {.lex_state = 1},
  [1131] = {.lex_state = 3},
  [1132] = {.lex_state = 239},
  [1133] = {.lex_state = 6},
  [1134] = {.lex_state = 1},
  [1135] = {.lex_state = 239},
  [1136] = {.lex_state = 1},
  [1137] = {.lex_state = 239},
  [1138] = {.lex_state = 239},
  [1139] = {.lex_state = 239},
  [1140] = {.lex_state = 239},
  [1141] = {.lex_state = 239},
  [1142] = {.lex_state = 6},
  [1143] = {.lex_state = 239},
  [1144] = {.lex_state = 239},
  [1145] = {.lex_state = 6},
  [1146] = {.lex_state = 6},
  [1147] = {.lex_state = 6},
  [1148] = {.lex_state = 6},
  [1149] = {.lex_state = 6},
  [1150] = {.lex_state = 6},
  [1151] = {.lex_state = 7},
  [1152] = {.lex_state = 7},
  [1153] = {.lex_state = 7},
  [1154] = {.lex_state = 7},
  [1155] = {.lex_state = 7},
  [1156] = {.lex_state = 6},
  [1157] = {.lex_state = 7},
  [1158] = {.lex_state = 7},
  [1159] = {.lex_state = 6},
  [1160] = {.lex_state = 7},
  [1161] = {.lex_state = 6},
  [1162] = {.lex_state = 7},
  [1163] = {.lex_state = 6},
  [1164] = {.lex_state = 7},
  [1165] = {.lex_state = 6},
  [1166] = {.lex_state = 7},
  [1167] = {.lex_state = 7},
  [1168] = {.lex_state = 6},
  [1169] = {.lex_state = 6},
  [1170] = {.lex_state = 6},
  [1171] = {.lex_state = 7},
  [1172] = {.lex_state = 7},
  [1173] = {.lex_state = 6},
  [1174] = {.lex_state = 7},
  [1175] = {.lex_state = 7},
  [1176] = {.lex_state = 7},
  [1177] = {.lex_state = 7},
  [1178] = {.lex_state = 7},
  [1179] = {.lex_state = 7},
  [1180] = {.lex_state = 7},
  [1181] = {.lex_state = 6},
  [1182] = {.lex_state = 7},
  [1183] = {.lex_state = 7},
  [1184] = {.lex_state = 7},
  [1185] = {.lex_state = 7},
  [1186] = {.lex_state = 6},
  [1187] = {.lex_state = 7},
  [1188] = {.lex_state = 7},
  [1189] = {.lex_state = 7},
  [1190] = {.lex_state = 7},
  [1191] = {.lex_state = 6},
  [1192] = {.lex_state = 6},
  [1193] = {.lex_state = 7},
  [1194] = {.lex_state = 6},
  [1195] = {.lex_state = 7},
  [1196] = {.lex_state = 6},
  [1197] = {.lex_state = 6},
  [1198] = {.lex_state = 6},
  [1199] = {.lex_state = 6},
  [1200] = {.lex_state = 6},
  [1201] = {.lex_state = 7},
  [1202] = {.lex_state = 6},
  [1203] = {.lex_state = 6},
  [1204] = {.lex_state = 7},
  [1205] = {.lex_state = 6},
  [1206] = {.lex_state = 6},
  [1207] = {.lex_state = 7},
  [1208] = {.lex_state = 7},
  [1209] = {.lex_state = 7},
  [1210] = {.lex_state = 7},
  [1211] = {.lex_state = 7},
  [1212] = {.lex_state = 6},
  [1213] = {.lex_state = 6},
  [1214] = {.lex_state = 6},
  [1215] = {.lex_state = 6},
  [1216] = {.lex_state = 6},
  [1217] = {.lex_state = 3},
  [1218] = {.lex_state = 6},
  [1219] = {.lex_state = 6},
  [1220] = {.lex_state = 6},
  [1221] = {.lex_state = 7},
  [1222] = {.lex_state = 7},
  [1223] = {.lex_state = 6},
  [1224] = {.lex_state = 6},
  [1225] = {.lex_state = 7},
  [1226] = {.lex_state = 3},
  [1227] = {.lex_state = 7},
  [1228] = {.lex_state = 7},
  [1229] = {.lex_state = 6},
  [1230] = {.lex_state = 6},
  [1231] = {.lex_state = 6},
  [1232] = {.lex_state = 6},
  [1233] = {.lex_state = 6},
  [1234] = {.lex_state = 3},
  [1235] = {.lex_state = 6},
  [1236] = {.lex_state = 6},
  [1237] = {.lex_state = 7},
  [1238] = {.lex_state = 6},
  [1239] = {.lex_state = 6},
  [1240] = {.lex_state = 6},
  [1241] = {.lex_state = 6},
  [1242] = {.lex_state = 6},
  [1243] = {.lex_state = 6},
  [1244] = {.lex_state = 6},
  [1245] = {.lex_state = 6},
  [1246] = {.lex_state = 3},
  [1247] = {.lex_state = 6},
  [1248] = {.lex_state = 6},
  [1249] = {.lex_state = 6},
  [1250] = {.lex_state = 6},
  [1251] = {.lex_state = 6},
  [1252] = {.lex_state = 6},
  [1253] = {.lex_state = 6},
  [1254] = {.lex_state = 6},
  [1255] = {.lex_state = 6},
  [1256] = {.lex_state = 6},
  [1257] = {.lex_state = 3},
  [1258] = {.lex_state = 6},
  [1259] = {.lex_state = 6},
  [1260] = {.lex_state = 6},
  [1261] = {.lex_state = 6},
  [1262] = {.lex_state = 7},
  [1263] = {.lex_state = 6},
  [1264] = {.lex_state = 6},
  [1265] = {.lex_state = 6},
  [1266] = {.lex_state = 6},
  [1267] = {.lex_state = 6},
  [1268] = {.lex_state = 6},
  [1269] = {.lex_state = 6},
  [1270] = {.lex_state = 6},
  [1271] = {.lex_state = 6},
  [1272] = {.lex_state = 6},
  [1273] = {.lex_state = 3},
  [1274] = {.lex_state = 6},
  [1275] = {.lex_state = 6},
  [1276] = {.lex_state = 6},
  [1277] = {.lex_state = 6},
  [1278] = {.lex_state = 6},
  [1279] = {.lex_state = 6},
  [1280] = {.lex_state = 6},
  [1281] = {.lex_state = 7},
  [1282] = {.lex_state = 7},
  [1283] = {.lex_state = 6},
  [1284] = {.lex_state = 6},
  [1285] = {.lex_state = 6},
  [1286] = {.lex_state = 7},
  [1287] = {.lex_state = 6},
  [1288] = {.lex_state = 6},
  [1289] = {.lex_state = 7},
  [1290] = {.lex_state = 7},
  [1291] = {.lex_state = 7},
  [1292] = {.lex_state = 7},
  [1293] = {.lex_state = 6},
  [1294] = {.lex_state = 7},
  [1295] = {.lex_state = 6},
  [1296] = {.lex_state = 7},
  [1297] = {.lex_state = 6},
  [1298] = {.lex_state = 7},
  [1299] = {.lex_state = 6},
  [1300] = {.lex_state = 6},
  [1301] = {.lex_state = 7},
  [1302] = {.lex_state = 7},
  [1303] = {.lex_state = 6},
  [1304] = {.lex_state = 7},
  [1305] = {.lex_state = 7},
  [1306] = {.lex_state = 6},
  [1307] = {.lex_state = 6},
  [1308] = {.lex_state = 7},
  [1309] = {.lex_state = 6},
  [1310] = {.lex_state = 6},
  [1311] = {.lex_state = 7},
  [1312] = {.lex_state = 6},
  [1313] = {.lex_state = 7},
  [1314] = {.lex_state = 7},
  [1315] = {.lex_state = 7},
  [1316] = {.lex_state = 6},
  [1317] = {.lex_state = 7},
  [1318] = {.lex_state = 6},
  [1319] = {.lex_state = 7},
  [1320] = {.lex_state = 7},
  [1321] = {.lex_state = 7},
  [1322] = {.lex_state = 6},
  [1323] = {.lex_state = 6},
  [1324] = {.lex_state = 6},
  [1325] = {.lex_state = 6},
  [1326] = {.lex_state = 6},
  [1327] = {.lex_state = 7},
  [1328] = {.lex_state = 7},
  [1329] = {.lex_state = 6},
  [1330] = {.lex_state = 7},
  [1331] = {.lex_state = 7},
  [1332] = {.lex_state = 3},
  [1333] = {.lex_state = 7},
  [1334] = {.lex_state = 7},
  [1335] = {.lex_state = 6},
  [1336] = {.lex_state = 7},
  [1337] = {.lex_state = 7},
  [1338] = {.lex_state = 7},
  [1339] = {.lex_state = 6},
  [1340] = {.lex_state = 7},
  [1341] = {.lex_state = 7},
  [1342] = {.lex_state = 6},
  [1343] = {.lex_state = 7},
  [1344] = {.lex_state = 6},
  [1345] = {.lex_state = 6},
  [1346] = {.lex_state = 7},
  [1347] = {.lex_state = 6},
  [1348] = {.lex_state = 6},
  [1349] = {.lex_state = 6},
  [1350] = {.lex_state = 6},
  [1351] = {.lex_state = 6},
  [1352] = {.lex_state = 6},
  [1353] = {.lex_state = 6},
  [1354] = {.lex_state = 6},
  [1355] = {.lex_state = 6},
  [1356] = {.lex_state = 6},
  [1357] = {.lex_state = 239},
  [1358] = {.lex_state = 6},
  [1359] = {.lex_state = 239},
  [1360] = {.lex_state = 6},
  [1361] = {.lex_state = 6},
  [1362] = {.lex_state = 239},
  [1363] = {.lex_state = 6},
  [1364] = {.lex_state = 6},
  [1365] = {.lex_state = 239},
  [1366] = {.lex_state = 6},
  [1367] = {.lex_state = 239},
  [1368] = {.lex_state = 239},
  [1369] = {.lex_state = 239},
  [1370] = {.lex_state = 6},
  [1371] = {.lex_state = 239},
  [1372] = {.lex_state = 6},
  [1373] = {.lex_state = 239},
  [1374] = {.lex_state = 6},
  [1375] = {.lex_state = 239},
  [1376] = {.lex_state = 239},
  [1377] = {.lex_state = 239},
  [1378] = {.lex_state = 239},
  [1379] = {.lex_state = 239},
  [1380] = {.lex_state = 239},
  [1381] = {.lex_state = 239},
  [1382] = {.lex_state = 6},
  [1383] = {.lex_state = 239},
  [1384] = {.lex_state = 6},
  [1385] = {.lex_state = 239},
  [1386] = {.lex_state = 6},
  [1387] = {.lex_state = 6},
  [1388] = {.lex_state = 6},
  [1389] = {.lex_state = 239},
  [1390] = {.lex_state = 239},
  [1391] = {.lex_state = 6},
  [1392] = {.lex_state = 239},
  [1393] = {.lex_state = 6},
  [1394] = {.lex_state = 239},
  [1395] = {.lex_state = 6},
  [1396] = {.lex_state = 6},
  [1397] = {.lex_state = 6},
  [1398] = {.lex_state = 239},
  [1399] = {.lex_state = 6},
  [1400] = {.lex_state = 239},
  [1401] = {.lex_state = 6},
  [1402] = {.lex_state = 239},
  [1403] = {.lex_state = 6},
  [1404] = {.lex_state = 239},
  [1405] = {.lex_state = 6},
  [1406] = {.lex_state = 6},
  [1407] = {.lex_state = 6},
  [1408] = {.lex_state = 6},
  [1409] = {.lex_state = 6},
  [1410] = {.lex_state = 6},
  [1411] = {.lex_state = 239},
  [1412] = {.lex_state = 6},
  [1413] = {.lex_state = 239},
  [1414] = {.lex_state = 6},
  [1415] = {.lex_state = 239},
  [1416] = {.lex_state = 6},
  [1417] = {.lex_state = 239},
  [1418] = {.lex_state = 239},
  [1419] = {.lex_state = 239},
  [1420] = {.lex_state = 6},
  [1421] = {.lex_state = 6},
  [1422] = {.lex_state = 6},
  [1423] = {.lex_state = 6},
  [1424] = {.lex_state = 6},
  [1425] = {.lex_state = 6},
  [1426] = {.lex_state = 239},
  [1427] = {.lex_state = 239},
  [1428] = {.lex_state = 239},
  [1429] = {.lex_state = 239},
  [1430] = {.lex_state = 239},
  [1431] = {.lex_state = 239},
  [1432] = {.lex_state = 239},
  [1433] = {.lex_state = 239},
  [1434] = {.lex_state = 239},
  [1435] = {.lex_state = 239},
  [1436] = {.lex_state = 239},
  [1437] = {.lex_state = 6},
  [1438] = {.lex_state = 239},
  [1439] = {.lex_state = 7},
  [1440] = {.lex_state = 239},
  [1441] = {.lex_state = 7},
  [1442] = {.lex_state = 239},
  [1443] = {.lex_state = 239},
  [1444] = {.lex_state = 239},
  [1445] = {.lex_state = 239},
  [1446] = {.lex_state = 239},
  [1447] = {.lex_state = 239},
  [1448] = {.lex_state = 239},
  [1449] = {.lex_state = 239},
  [1450] = {.lex_state = 239},
  [1451] = {.lex_state = 239},
  [1452] = {.lex_state = 239},
  [1453] = {.lex_state = 239},
  [1454] = {.lex_state = 239},
  [1455] = {.lex_state = 239},
  [1456] = {.lex_state = 239},
  [1457] = {.lex_state = 239},
  [1458] = {.lex_state = 239},
  [1459] = {.lex_state = 239},
  [1460] = {.lex_state = 239},
  [1461] = {.lex_state = 239},
  [1462] = {.lex_state = 239},
  [1463] = {.lex_state = 239},
  [1464] = {.lex_state = 239},
  [1465] = {.lex_state = 239},
  [1466] = {.lex_state = 239},
  [1467] = {.lex_state = 239},
  [1468] = {.lex_state = 239},
  [1469] = {.lex_state = 239},
  [1470] = {.lex_state = 239},
  [1471] = {.lex_state = 239},
  [1472] = {.lex_state = 239},
  [1473] = {.lex_state = 239},
  [1474] = {.lex_state = 239},
  [1475] = {.lex_state = 239},
  [1476] = {.lex_state = 239},
  [1477] = {.lex_state = 239},
  [1478] = {.lex_state = 239},
  [1479] = {.lex_state = 239},
  [1480] = {.lex_state = 7},
  [1481] = {.lex_state = 239},
  [1482] = {.lex_state = 239},
  [1483] = {.lex_state = 239},
  [1484] = {.lex_state = 239},
  [1485] = {.lex_state = 239},
  [1486] = {.lex_state = 239},
  [1487] = {.lex_state = 239},
  [1488] = {.lex_state = 239},
  [1489] = {.lex_state = 239},
  [1490] = {.lex_state = 239},
  [1491] = {.lex_state = 239},
  [1492] = {.lex_state = 239},
  [1493] = {.lex_state = 239},
  [1494] = {.lex_state = 239},
  [1495] = {.lex_state = 239},
  [1496] = {.lex_state = 239},
  [1497] = {.lex_state = 239},
  [1498] = {.lex_state = 239},
  [1499] = {.lex_state = 239},
  [1500] = {.lex_state = 239},
  [1501] = {.lex_state = 239},
  [1502] = {.lex_state = 239},
  [1503] = {.lex_state = 239},
  [1504] = {.lex_state = 239},
  [1505] = {.lex_state = 239},
  [1506] = {.lex_state = 239},
  [1507] = {.lex_state = 239},
  [1508] = {.lex_state = 239},
  [1509] = {.lex_state = 239},
  [1510] = {.lex_state = 239},
  [1511] = {.lex_state = 239},
  [1512] = {.lex_state = 239},
  [1513] = {.lex_state = 239},
  [1514] = {.lex_state = 239},
  [1515] = {.lex_state = 239},
  [1516] = {.lex_state = 239},
  [1517] = {.lex_state = 239},
  [1518] = {.lex_state = 239},
  [1519] = {.lex_state = 239},
  [1520] = {.lex_state = 239},
  [1521] = {.lex_state = 239},
  [1522] = {.lex_state = 239},
  [1523] = {.lex_state = 239},
  [1524] = {.lex_state = 239},
  [1525] = {.lex_state = 239},
  [1526] = {.lex_state = 239},
  [1527] = {.lex_state = 239},
  [1528] = {.lex_state = 239},
  [1529] = {.lex_state = 239},
  [1530] = {.lex_state = 239},
  [1531] = {.lex_state = 239},
  [1532] = {.lex_state = 239},
  [1533] = {.lex_state = 239},
  [1534] = {.lex_state = 239},
  [1535] = {.lex_state = 239},
  [1536] = {.lex_state = 239},
  [1537] = {.lex_state = 239},
  [1538] = {.lex_state = 239},
  [1539] = {.lex_state = 239},
  [1540] = {.lex_state = 239},
  [1541] = {.lex_state = 239},
  [1542] = {.lex_state = 239},
  [1543] = {.lex_state = 239},
  [1544] = {.lex_state = 239},
  [1545] = {.lex_state = 239},
  [1546] = {.lex_state = 239},
  [1547] = {.lex_state = 239},
  [1548] = {.lex_state = 239},
  [1549] = {.lex_state = 239},
  [1550] = {.lex_state = 239},
  [1551] = {.lex_state = 239},
  [1552] = {.lex_state = 239},
  [1553] = {.lex_state = 239},
  [1554] = {.lex_state = 239},
  [1555] = {.lex_state = 239},
  [1556] = {.lex_state = 239},
  [1557] = {.lex_state = 239},
  [1558] = {.lex_state = 239},
  [1559] = {.lex_state = 239},
  [1560] = {.lex_state = 239},
  [1561] = {.lex_state = 239},
  [1562] = {.lex_state = 239},
  [1563] = {.lex_state = 239},
  [1564] = {.lex_state = 239},
  [1565] = {.lex_state = 239},
  [1566] = {.lex_state = 239},
  [1567] = {.lex_state = 239},
  [1568] = {.lex_state = 239},
  [1569] = {.lex_state = 239},
  [1570] = {.lex_state = 239},
  [1571] = {.lex_state = 239},
  [1572] = {.lex_state = 239},
  [1573] = {.lex_state = 239},
  [1574] = {.lex_state = 239},
  [1575] = {.lex_state = 239},
  [1576] = {.lex_state = 239},
  [1577] = {.lex_state = 239},
  [1578] = {.lex_state = 239},
  [1579] = {.lex_state = 239},
  [1580] = {.lex_state = 239},
  [1581] = {.lex_state = 239},
  [1582] = {.lex_state = 239},
  [1583] = {.lex_state = 239},
  [1584] = {.lex_state = 239},
  [1585] = {.lex_state = 7},
  [1586] = {.lex_state = 239},
  [1587] = {.lex_state = 239},
  [1588] = {.lex_state = 239},
  [1589] = {.lex_state = 239},
  [1590] = {.lex_state = 239},
  [1591] = {.lex_state = 239},
  [1592] = {.lex_state = 239},
  [1593] = {.lex_state = 239},
  [1594] = {.lex_state = 239},
  [1595] = {.lex_state = 239},
  [1596] = {.lex_state = 239},
  [1597] = {.lex_state = 239},
  [1598] = {.lex_state = 239},
  [1599] = {.lex_state = 239},
  [1600] = {.lex_state = 239},
  [1601] = {.lex_state = 239},
  [1602] = {.lex_state = 239},
  [1603] = {.lex_state = 239},
  [1604] = {.lex_state = 239},
  [1605] = {.lex_state = 239},
  [1606] = {.lex_state = 239},
  [1607] = {.lex_state = 239},
  [1608] = {.lex_state = 239},
  [1609] = {.lex_state = 239},
  [1610] = {.lex_state = 239},
  [1611] = {.lex_state = 239},
  [1612] = {.lex_state = 239},
  [1613] = {.lex_state = 239},
  [1614] = {.lex_state = 239},
  [1615] = {.lex_state = 239},
  [1616] = {.lex_state = 239},
  [1617] = {.lex_state = 239},
  [1618] = {.lex_state = 239},
  [1619] = {.lex_state = 239},
  [1620] = {.lex_state = 239},
  [1621] = {.lex_state = 239},
  [1622] = {.lex_state = 239},
  [1623] = {.lex_state = 7},
  [1624] = {.lex_state = 239},
  [1625] = {.lex_state = 7},
  [1626] = {.lex_state = 239},
  [1627] = {.lex_state = 7},
  [1628] = {.lex_state = 239},
  [1629] = {.lex_state = 239},
  [1630] = {.lex_state = 7},
  [1631] = {.lex_state = 239},
  [1632] = {.lex_state = 241},
  [1633] = {.lex_state = 241},
  [1634] = {.lex_state = 241},
  [1635] = {.lex_state = 241},
  [1636] = {.lex_state = 241},
  [1637] = {.lex_state = 241},
  [1638] = {.lex_state = 241},
  [1639] = {.lex_state = 241},
  [1640] = {.lex_state = 241},
  [1641] = {.lex_state = 241},
  [1642] = {.lex_state = 241},
  [1643] = {.lex_state = 241},
  [1644] = {.lex_state = 241},
  [1645] = {.lex_state = 241},
  [1646] = {.lex_state = 241},
  [1647] = {.lex_state = 241},
  [1648] = {.lex_state = 241},
  [1649] = {.lex_state = 241},
  [1650] = {.lex_state = 241},
  [1651] = {.lex_state = 241},
  [1652] = {.lex_state = 241},
  [1653] = {.lex_state = 241},
  [1654] = {.lex_state = 241},
  [1655] = {.lex_state = 241},
  [1656] = {.lex_state = 241},
  [1657] = {.lex_state = 241},
  [1658] = {.lex_state = 241},
  [1659] = {.lex_state = 241},
  [1660] = {.lex_state = 241},
  [1661] = {.lex_state = 241},
  [1662] = {.lex_state = 241},
  [1663] = {.lex_state = 241},
  [1664] = {.lex_state = 241},
  [1665] = {.lex_state = 241},
  [1666] = {.lex_state = 241},
  [1667] = {.lex_state = 241},
  [1668] = {.lex_state = 241},
  [1669] = {.lex_state = 241},
  [1670] = {.lex_state = 241},
  [1671] = {.lex_state = 241},
  [1672] = {.lex_state = 241},
  [1673] = {.lex_state = 241},
  [1674] = {.lex_state = 241},
  [1675] = {.lex_state = 241},
  [1676] = {.lex_state = 241},
  [1677] = {.lex_state = 241},
  [1678] = {.lex_state = 241},
  [1679] = {.lex_state = 241},
  [1680] = {.lex_state = 241},
  [1681] = {.lex_state = 241},
  [1682] = {.lex_state = 7},
  [1683] = {.lex_state = 7},
  [1684] = {.lex_state = 241},
  [1685] = {.lex_state = 241},
  [1686] = {.lex_state = 241},
  [1687] = {.lex_state = 241},
  [1688] = {.lex_state = 241},
  [1689] = {.lex_state = 241},
  [1690] = {.lex_state = 241},
  [1691] = {.lex_state = 241},
  [1692] = {.lex_state = 241},
  [1693] = {.lex_state = 241},
  [1694] = {.lex_state = 241},
  [1695] = {.lex_state = 241},
  [1696] = {.lex_state = 241},
  [1697] = {.lex_state = 7},
  [1698] = {.lex_state = 7},
  [1699] = {.lex_state = 7},
  [1700] = {.lex_state = 241},
  [1701] = {.lex_state = 7},
  [1702] = {.lex_state = 241},
  [1703] = {.lex_state = 241},
  [1704] = {.lex_state = 241},
  [1705] = {.lex_state = 7},
  [1706] = {.lex_state = 7},
  [1707] = {.lex_state = 241},
  [1708] = {.lex_state = 241},
  [1709] = {.lex_state = 241},
  [1710] = {.lex_state = 7},
  [1711] = {.lex_state = 241},
  [1712] = {.lex_state = 241},
  [1713] = {.lex_state = 241},
  [1714] = {.lex_state = 241},
  [1715] = {.lex_state = 7},
  [1716] = {.lex_state = 241},
  [1717] = {.lex_state = 241},
  [1718] = {.lex_state = 7},
  [1719] = {.lex_state = 7},
  [1720] = {.lex_state = 241},
  [1721] = {.lex_state = 241},
  [1722] = {.lex_state = 7},
  [1723] = {.lex_state = 7},
  [1724] = {.lex_state = 7},
  [1725] = {.lex_state = 7},
  [1726] = {.lex_state = 7},
  [1727] = {.lex_state = 7},
  [1728] = {.lex_state = 7},
  [1729] = {.lex_state = 7},
  [1730] = {.lex_state = 241},
  [1731] = {.lex_state = 241},
  [1732] = {.lex_state = 7},
  [1733] = {.lex_state = 241},
  [1734] = {.lex_state = 241},
  [1735] = {.lex_state = 7},
  [1736] = {.lex_state = 241},
  [1737] = {.lex_state = 241},
  [1738] = {.lex_state = 241},
  [1739] = {.lex_state = 7},
  [1740] = {.lex_state = 241},
  [1741] = {.lex_state = 241},
  [1742] = {.lex_state = 241},
  [1743] = {.lex_state = 241},
  [1744] = {.lex_state = 241},
  [1745] = {.lex_state = 241},
  [1746] = {.lex_state = 241},
  [1747] = {.lex_state = 7},
  [1748] = {.lex_state = 7},
  [1749] = {.lex_state = 7},
  [1750] = {.lex_state = 7},
  [1751] = {.lex_state = 7},
  [1752] = {.lex_state = 241},
  [1753] = {.lex_state = 7},
  [1754] = {.lex_state = 241},
  [1755] = {.lex_state = 241},
  [1756] = {.lex_state = 241},
  [1757] = {.lex_state = 241},
  [1758] = {.lex_state = 7},
  [1759] = {.lex_state = 241},
  [1760] = {.lex_state = 241},
  [1761] = {.lex_state = 241},
  [1762] = {.lex_state = 239},
  [1763] = {.lex_state = 7},
  [1764] = {.lex_state = 7},
  [1765] = {.lex_state = 7},
  [1766] = {.lex_state = 241},
  [1767] = {.lex_state = 7},
  [1768] = {.lex_state = 239},
  [1769] = {.lex_state = 239},
  [1770] = {.lex_state = 239},
  [1771] = {.lex_state = 239},
  [1772] = {.lex_state = 239},
  [1773] = {.lex_state = 239},
  [1774] = {.lex_state = 239},
  [1775] = {.lex_state = 239},
  [1776] = {.lex_state = 239},
  [1777] = {.lex_state = 239},
  [1778] = {.lex_state = 239},
  [1779] = {.lex_state = 239},
  [1780] = {.lex_state = 239},
  [1781] = {.lex_state = 239},
  [1782] = {.lex_state = 241},
  [1783] = {.lex_state = 239},
  [1784] = {.lex_state = 239},
  [1785] = {.lex_state = 239},
  [1786] = {.lex_state = 239},
  [1787] = {.lex_state = 239},
  [1788] = {.lex_state = 239},
  [1789] = {.lex_state = 241},
  [1790] = {.lex_state = 239},
  [1791] = {.lex_state = 239},
  [1792] = {.lex_state = 239},
  [1793] = {.lex_state = 239},
  [1794] = {.lex_state = 239},
  [1795] = {.lex_state = 239},
  [1796] = {.lex_state = 239},
  [1797] = {.lex_state = 241},
  [1798] = {.lex_state = 239},
  [1799] = {.lex_state = 239},
  [1800] = {.lex_state = 7},
  [1801] = {.lex_state = 239},
  [1802] = {.lex_state = 241},
  [1803] = {.lex_state = 239},
  [1804] = {.lex_state = 239},
  [1805] = {.lex_state = 239},
  [1806] = {.lex_state = 7},
  [1807] = {.lex_state = 241},
  [1808] = {.lex_state = 239},
  [1809] = {.lex_state = 239},
  [1810] = {.lex_state = 239},
  [1811] = {.lex_state = 239},
  [1812] = {.lex_state = 239},
  [1813] = {.lex_state = 239},
  [1814] = {.lex_state = 239},
  [1815] = {.lex_state = 239},
  [1816] = {.lex_state = 239},
  [1817] = {.lex_state = 239},
  [1818] = {.lex_state = 239},
  [1819] = {.lex_state = 239},
  [1820] = {.lex_state = 241},
  [1821] = {.lex_state = 241},
  [1822] = {.lex_state = 241},
  [1823] = {.lex_state = 239},
  [1824] = {.lex_state = 239},
  [1825] = {.lex_state = 239},
  [1826] = {.lex_state = 241},
  [1827] = {.lex_state = 7},
  [1828] = {.lex_state = 241},
  [1829] = {.lex_state = 241},
  [1830] = {.lex_state = 241},
  [1831] = {.lex_state = 241},
  [1832] = {.lex_state = 7},
  [1833] = {.lex_state = 241},
  [1834] = {.lex_state = 241},
  [1835] = {.lex_state = 241},
  [1836] = {.lex_state = 241},
  [1837] = {.lex_state = 7},
  [1838] = {.lex_state = 241},
  [1839] = {.lex_state = 7},
  [1840] = {.lex_state = 241},
  [1841] = {.lex_state = 241},
  [1842] = {.lex_state = 241},
  [1843] = {.lex_state = 7},
  [1844] = {.lex_state = 7},
  [1845] = {.lex_state = 7},
  [1846] = {.lex_state = 7},
  [1847] = {.lex_state = 241},
  [1848] = {.lex_state = 7},
  [1849] = {.lex_state = 241},
  [1850] = {.lex_state = 7},
  [1851] = {.lex_state = 241},
  [1852] = {.lex_state = 241},
  [1853] = {.lex_state = 241},
  [1854] = {.lex_state = 241},
  [1855] = {.lex_state = 241},
  [1856] = {.lex_state = 241},
  [1857] = {.lex_state = 241},
  [1858] = {.lex_state = 241},
  [1859] = {.lex_state = 241},
  [1860] = {.lex_state = 241},
  [1861] = {.lex_state = 241},
  [1862] = {.lex_state = 241},
  [1863] = {.lex_state = 241},
  [1864] = {.lex_state = 241},
  [1865] = {.lex_state = 241},
  [1866] = {.lex_state = 7},
  [1867] = {.lex_state = 241},
  [1868] = {.lex_state = 241},
  [1869] = {.lex_state = 241},
  [1870] = {.lex_state = 7},
  [1871] = {.lex_state = 241},
  [1872] = {.lex_state = 7},
  [1873] = {.lex_state = 241},
  [1874] = {.lex_state = 241},
  [1875] = {.lex_state = 7},
  [1876] = {.lex_state = 241},
  [1877] = {.lex_state = 7},
  [1878] = {.lex_state = 7},
  [1879] = {.lex_state = 7},
  [1880] = {.lex_state = 7},
  [1881] = {.lex_state = 241},
  [1882] = {.lex_state = 241},
  [1883] = {.lex_state = 241},
  [1884] = {.lex_state = 7},
  [1885] = {.lex_state = 241},
  [1886] = {.lex_state = 241},
  [1887] = {.lex_state = 241},
  [1888] = {.lex_state = 241},
  [1889] = {.lex_state = 241},
  [1890] = {.lex_state = 241},
  [1891] = {.lex_state = 241},
  [1892] = {.lex_state = 7},
  [1893] = {.lex_state = 241},
  [1894] = {.lex_state = 241},
  [1895] = {.lex_state = 241},
  [1896] = {.lex_state = 241},
  [1897] = {.lex_state = 241},
  [1898] = {.lex_state = 241},
  [1899] = {.lex_state = 241},
  [1900] = {.lex_state = 241},
  [1901] = {.lex_state = 241},
  [1902] = {.lex_state = 7},
  [1903] = {.lex_state = 7},
  [1904] = {.lex_state = 7},
  [1905] = {.lex_state = 7},
  [1906] = {.lex_state = 7},
  [1907] = {.lex_state = 7},
  [1908] = {.lex_state = 241},
  [1909] = {.lex_state = 241},
  [1910] = {.lex_state = 241},
  [1911] = {.lex_state = 241},
  [1912] = {.lex_state = 241},
  [1913] = {.lex_state = 241},
  [1914] = {.lex_state = 241},
  [1915] = {.lex_state = 7},
  [1916] = {.lex_state = 241},
  [1917] = {.lex_state = 7},
  [1918] = {.lex_state = 7},
  [1919] = {.lex_state = 7},
  [1920] = {.lex_state = 7},
  [1921] = {.lex_state = 241},
  [1922] = {.lex_state = 7},
  [1923] = {.lex_state = 241},
  [1924] = {.lex_state = 7},
  [1925] = {.lex_state = 241},
  [1926] = {.lex_state = 7},
  [1927] = {.lex_state = 241},
  [1928] = {.lex_state = 241},
  [1929] = {.lex_state = 241},
  [1930] = {.lex_state = 241},
  [1931] = {.lex_state = 7},
  [1932] = {.lex_state = 241},
  [1933] = {.lex_state = 241},
  [1934] = {.lex_state = 7},
  [1935] = {.lex_state = 241},
  [1936] = {.lex_state = 7},
  [1937] = {.lex_state = 241},
  [1938] = {.lex_state = 241},
  [1939] = {.lex_state = 7},
  [1940] = {.lex_state = 7},
  [1941] = {.lex_state = 241},
  [1942] = {.lex_state = 241},
  [1943] = {.lex_state = 241},
  [1944] = {.lex_state = 241},
  [1945] = {.lex_state = 241},
  [1946] = {.lex_state = 241},
  [1947] = {.lex_state = 241},
  [1948] = {.lex_state = 241},
  [1949] = {.lex_state = 241},
  [1950] = {.lex_state = 241},
  [1951] = {.lex_state = 7},
  [1952] = {.lex_state = 241},
  [1953] = {.lex_state = 241},
  [1954] = {.lex_state = 241},
  [1955] = {.lex_state = 241},
  [1956] = {.lex_state = 7},
  [1957] = {.lex_state = 7},
  [1958] = {.lex_state = 7},
  [1959] = {.lex_state = 7},
  [1960] = {.lex_state = 241},
  [1961] = {.lex_state = 7},
  [1962] = {.lex_state = 7},
  [1963] = {.lex_state = 7},
  [1964] = {.lex_state = 7},
  [1965] = {.lex_state = 7},
  [1966] = {.lex_state = 7},
  [1967] = {.lex_state = 241},
  [1968] = {.lex_state = 241},
  [1969] = {.lex_state = 241},
  [1970] = {.lex_state = 7},
  [1971] = {.lex_state = 7},
  [1972] = {.lex_state = 7},
  [1973] = {.lex_state = 241},
  [1974] = {.lex_state = 241},
  [1975] = {.lex_state = 7},
  [1976] = {.lex_state = 7},
  [1977] = {.lex_state = 7},
  [1978] = {.lex_state = 7},
  [1979] = {.lex_state = 7},
  [1980] = {.lex_state = 7},
  [1981] = {.lex_state = 7},
  [1982] = {.lex_state = 241},
  [1983] = {.lex_state = 7},
  [1984] = {.lex_state = 7},
  [1985] = {.lex_state = 7},
  [1986] = {.lex_state = 7},
  [1987] = {.lex_state = 7},
  [1988] = {.lex_state = 7},
  [1989] = {.lex_state = 7},
  [1990] = {.lex_state = 7},
  [1991] = {.lex_state = 7},
  [1992] = {.lex_state = 7},
  [1993] = {.lex_state = 7},
  [1994] = {.lex_state = 7},
  [1995] = {.lex_state = 7},
  [1996] = {.lex_state = 7},
  [1997] = {.lex_state = 7},
  [1998] = {.lex_state = 241},
  [1999] = {.lex_state = 241},
  [2000] = {.lex_state = 241},
  [2001] = {.lex_state = 241},
  [2002] = {.lex_state = 241},
  [2003] = {.lex_state = 7},
  [2004] = {.lex_state = 7},
  [2005] = {.lex_state = 7},
  [2006] = {.lex_state = 7},
  [2007] = {.lex_state = 7},
  [2008] = {.lex_state = 7},
  [2009] = {.lex_state = 241},
  [2010] = {.lex_state = 7},
  [2011] = {.lex_state = 7},
  [2012] = {.lex_state = 7},
  [2013] = {.lex_state = 7},
  [2014] = {.lex_state = 7},
  [2015] = {.lex_state = 7},
  [2016] = {.lex_state = 7},
  [2017] = {.lex_state = 7},
  [2018] = {.lex_state = 7},
  [2019] = {.lex_state = 7},
  [2020] = {.lex_state = 7},
  [2021] = {.lex_state = 7},
  [2022] = {.lex_state = 7},
  [2023] = {.lex_state = 7},
  [2024] = {.lex_state = 7},
  [2025] = {.lex_state = 7},
  [2026] = {.lex_state = 7},
  [2027] = {.lex_state = 7},
  [2028] = {.lex_state = 7},
  [2029] = {.lex_state = 7},
  [2030] = {.lex_state = 7},
  [2031] = {.lex_state = 7},
  [2032] = {.lex_state = 7},
  [2033] = {.lex_state = 7},
  [2034] = {.lex_state = 7},
  [2035] = {.lex_state = 7},
  [2036] = {.lex_state = 7},
  [2037] = {.lex_state = 7},
  [2038] = {.lex_state = 7},
  [2039] = {.lex_state = 7},
  [2040] = {.lex_state = 7},
  [2041] = {.lex_state = 7},
  [2042] = {.lex_state = 7},
  [2043] = {.lex_state = 7},
  [2044] = {.lex_state = 7},
  [2045] = {.lex_state = 7},
  [2046] = {.lex_state = 7},
  [2047] = {.lex_state = 7},
  [2048] = {.lex_state = 7},
  [2049] = {.lex_state = 7},
  [2050] = {.lex_state = 7},
  [2051] = {.lex_state = 7},
  [2052] = {.lex_state = 7},
  [2053] = {.lex_state = 7},
  [2054] = {.lex_state = 7},
  [2055] = {.lex_state = 7},
  [2056] = {.lex_state = 7},
  [2057] = {.lex_state = 7},
  [2058] = {.lex_state = 7},
  [2059] = {.lex_state = 7},
  [2060] = {.lex_state = 7},
  [2061] = {.lex_state = 7},
  [2062] = {.lex_state = 7},
  [2063] = {.lex_state = 7},
  [2064] = {.lex_state = 7},
  [2065] = {.lex_state = 7},
  [2066] = {.lex_state = 7},
  [2067] = {.lex_state = 7},
  [2068] = {.lex_state = 7},
  [2069] = {.lex_state = 7},
  [2070] = {.lex_state = 7},
  [2071] = {.lex_state = 7},
  [2072] = {.lex_state = 7},
  [2073] = {.lex_state = 7},
  [2074] = {.lex_state = 7},
  [2075] = {.lex_state = 7},
  [2076] = {.lex_state = 7},
  [2077] = {.lex_state = 7},
  [2078] = {.lex_state = 7},
  [2079] = {.lex_state = 7},
  [2080] = {.lex_state = 7},
  [2081] = {.lex_state = 7},
  [2082] = {.lex_state = 7},
  [2083] = {.lex_state = 7},
  [2084] = {.lex_state = 7},
  [2085] = {.lex_state = 7},
  [2086] = {.lex_state = 7},
  [2087] = {.lex_state = 7},
  [2088] = {.lex_state = 7},
  [2089] = {.lex_state = 7},
  [2090] = {.lex_state = 7},
  [2091] = {.lex_state = 7},
  [2092] = {.lex_state = 7},
  [2093] = {.lex_state = 7},
  [2094] = {.lex_state = 7},
  [2095] = {.lex_state = 7},
  [2096] = {.lex_state = 7},
  [2097] = {.lex_state = 7},
  [2098] = {.lex_state = 7},
  [2099] = {.lex_state = 7},
  [2100] = {.lex_state = 7},
  [2101] = {.lex_state = 7},
  [2102] = {.lex_state = 7},
  [2103] = {.lex_state = 7},
  [2104] = {.lex_state = 7},
  [2105] = {.lex_state = 7},
  [2106] = {.lex_state = 7},
  [2107] = {.lex_state = 7},
  [2108] = {.lex_state = 7},
  [2109] = {.lex_state = 7},
  [2110] = {.lex_state = 7},
  [2111] = {.lex_state = 7},
  [2112] = {.lex_state = 7},
  [2113] = {.lex_state = 7},
  [2114] = {.lex_state = 7},
  [2115] = {.lex_state = 7},
  [2116] = {.lex_state = 7},
  [2117] = {.lex_state = 7},
  [2118] = {.lex_state = 7},
  [2119] = {.lex_state = 7},
  [2120] = {.lex_state = 7},
  [2121] = {.lex_state = 7},
  [2122] = {.lex_state = 7},
  [2123] = {.lex_state = 7},
  [2124] = {.lex_state = 7},
  [2125] = {.lex_state = 7},
  [2126] = {.lex_state = 7},
  [2127] = {.lex_state = 7},
  [2128] = {.lex_state = 7},
  [2129] = {.lex_state = 7},
  [2130] = {.lex_state = 7},
  [2131] = {.lex_state = 7},
  [2132] = {.lex_state = 7},
  [2133] = {.lex_state = 7},
  [2134] = {.lex_state = 7},
  [2135] = {.lex_state = 7},
  [2136] = {.lex_state = 7},
  [2137] = {.lex_state = 7},
  [2138] = {.lex_state = 7},
  [2139] = {.lex_state = 7},
  [2140] = {.lex_state = 7},
  [2141] = {.lex_state = 7},
  [2142] = {.lex_state = 7},
  [2143] = {.lex_state = 7},
  [2144] = {.lex_state = 7},
  [2145] = {.lex_state = 7},
  [2146] = {.lex_state = 7},
  [2147] = {.lex_state = 7},
  [2148] = {.lex_state = 7},
  [2149] = {.lex_state = 7},
  [2150] = {.lex_state = 7},
  [2151] = {.lex_state = 7},
  [2152] = {.lex_state = 7},
  [2153] = {.lex_state = 7},
  [2154] = {.lex_state = 7},
  [2155] = {.lex_state = 7},
  [2156] = {.lex_state = 7},
  [2157] = {.lex_state = 7},
  [2158] = {.lex_state = 7},
  [2159] = {.lex_state = 7},
  [2160] = {.lex_state = 7},
  [2161] = {.lex_state = 7},
  [2162] = {.lex_state = 7},
  [2163] = {.lex_state = 7},
  [2164] = {.lex_state = 7},
  [2165] = {.lex_state = 7},
  [2166] = {.lex_state = 7},
  [2167] = {.lex_state = 7},
  [2168] = {.lex_state = 7},
  [2169] = {.lex_state = 7},
  [2170] = {.lex_state = 7},
  [2171] = {.lex_state = 7},
  [2172] = {.lex_state = 7},
  [2173] = {.lex_state = 7},
  [2174] = {.lex_state = 7},
  [2175] = {.lex_state = 7},
  [2176] = {.lex_state = 7},
  [2177] = {.lex_state = 7},
  [2178] = {.lex_state = 7},
  [2179] = {.lex_state = 7},
  [2180] = {.lex_state = 7},
  [2181] = {.lex_state = 7},
  [2182] = {.lex_state = 7},
  [2183] = {.lex_state = 7},
  [2184] = {.lex_state = 7},
  [2185] = {.lex_state = 7},
  [2186] = {.lex_state = 7},
  [2187] = {.lex_state = 7},
  [2188] = {.lex_state = 7},
  [2189] = {.lex_state = 7},
  [2190] = {.lex_state = 7},
  [2191] = {.lex_state = 7},
  [2192] = {.lex_state = 7},
  [2193] = {.lex_state = 7},
  [2194] = {.lex_state = 7},
  [2195] = {.lex_state = 7},
  [2196] = {.lex_state = 7},
  [2197] = {.lex_state = 7},
  [2198] = {.lex_state = 7},
  [2199] = {.lex_state = 7},
  [2200] = {.lex_state = 7},
  [2201] = {.lex_state = 7},
  [2202] = {.lex_state = 7},
  [2203] = {.lex_state = 7},
  [2204] = {.lex_state = 7},
  [2205] = {.lex_state = 7},
  [2206] = {.lex_state = 7},
  [2207] = {.lex_state = 7},
  [2208] = {.lex_state = 7},
  [2209] = {.lex_state = 7},
  [2210] = {.lex_state = 7},
  [2211] = {.lex_state = 7},
  [2212] = {.lex_state = 7},
  [2213] = {.lex_state = 7},
  [2214] = {.lex_state = 7},
  [2215] = {.lex_state = 7},
  [2216] = {.lex_state = 7},
  [2217] = {.lex_state = 7},
  [2218] = {.lex_state = 7},
  [2219] = {.lex_state = 7},
  [2220] = {.lex_state = 7},
  [2221] = {.lex_state = 7},
  [2222] = {.lex_state = 7},
  [2223] = {.lex_state = 7},
  [2224] = {.lex_state = 7},
  [2225] = {.lex_state = 7},
  [2226] = {.lex_state = 7},
  [2227] = {.lex_state = 7},
  [2228] = {.lex_state = 7},
  [2229] = {.lex_state = 7},
  [2230] = {.lex_state = 7},
  [2231] = {.lex_state = 7},
  [2232] = {.lex_state = 7},
  [2233] = {.lex_state = 7},
  [2234] = {.lex_state = 7},
  [2235] = {.lex_state = 7},
  [2236] = {.lex_state = 7},
  [2237] = {.lex_state = 7},
  [2238] = {.lex_state = 7},
  [2239] = {.lex_state = 7},
  [2240] = {.lex_state = 7},
  [2241] = {.lex_state = 7},
  [2242] = {.lex_state = 7},
  [2243] = {.lex_state = 7},
  [2244] = {.lex_state = 7},
  [2245] = {.lex_state = 7},
  [2246] = {.lex_state = 7},
  [2247] = {.lex_state = 7},
  [2248] = {.lex_state = 7},
  [2249] = {.lex_state = 7},
  [2250] = {.lex_state = 7},
  [2251] = {.lex_state = 7},
  [2252] = {.lex_state = 7},
  [2253] = {.lex_state = 7},
  [2254] = {.lex_state = 7},
  [2255] = {.lex_state = 7},
  [2256] = {.lex_state = 7},
  [2257] = {.lex_state = 7},
  [2258] = {.lex_state = 7},
  [2259] = {.lex_state = 7},
  [2260] = {.lex_state = 7},
  [2261] = {.lex_state = 7},
  [2262] = {.lex_state = 7},
  [2263] = {.lex_state = 7},
  [2264] = {.lex_state = 7},
  [2265] = {.lex_state = 7},
  [2266] = {.lex_state = 7},
  [2267] = {.lex_state = 7},
  [2268] = {.lex_state = 7},
  [2269] = {.lex_state = 7},
  [2270] = {.lex_state = 7},
  [2271] = {.lex_state = 7},
  [2272] = {.lex_state = 7},
  [2273] = {.lex_state = 7},
  [2274] = {.lex_state = 7},
  [2275] = {.lex_state = 7},
  [2276] = {.lex_state = 7},
  [2277] = {.lex_state = 7},
  [2278] = {.lex_state = 7},
  [2279] = {.lex_state = 7},
  [2280] = {.lex_state = 7},
  [2281] = {.lex_state = 240},
  [2282] = {.lex_state = 0},
  [2283] = {.lex_state = 0},
  [2284] = {.lex_state = 240},
  [2285] = {.lex_state = 0},
  [2286] = {.lex_state = 0},
  [2287] = {.lex_state = 0},
  [2288] = {.lex_state = 0},
  [2289] = {.lex_state = 0},
  [2290] = {.lex_state = 0},
  [2291] = {.lex_state = 0},
  [2292] = {.lex_state = 0},
  [2293] = {.lex_state = 0},
  [2294] = {.lex_state = 0},
  [2295] = {.lex_state = 0},
  [2296] = {.lex_state = 0},
  [2297] = {.lex_state = 0},
  [2298] = {.lex_state = 0},
  [2299] = {.lex_state = 0},
  [2300] = {.lex_state = 0},
  [2301] = {.lex_state = 0},
  [2302] = {.lex_state = 0},
  [2303] = {.lex_state = 240},
  [2304] = {.lex_state = 240},
  [2305] = {.lex_state = 0},
  [2306] = {.lex_state = 0},
  [2307] = {.lex_state = 0},
  [2308] = {.lex_state = 0},
  [2309] = {.lex_state = 0},
  [2310] = {.lex_state = 240},
  [2311] = {.lex_state = 240},
  [2312] = {.lex_state = 0},
  [2313] = {.lex_state = 0},
  [2314] = {.lex_state = 0},
  [2315] = {.lex_state = 0},
  [2316] = {.lex_state = 1},
  [2317] = {.lex_state = 1},
  [2318] = {.lex_state = 1},
  [2319] = {.lex_state = 1},
  [2320] = {.lex_state = 240},
  [2321] = {.lex_state = 1},
  [2322] = {.lex_state = 0},
  [2323] = {.lex_state = 0},
  [2324] = {.lex_state = 0},
  [2325] = {.lex_state = 0},
  [2326] = {.lex_state = 0},
  [2327] = {.lex_state = 0},
  [2328] = {.lex_state = 0},
  [2329] = {.lex_state = 0},
  [2330] = {.lex_state = 0},
  [2331] = {.lex_state = 0},
  [2332] = {.lex_state = 0},
  [2333] = {.lex_state = 1},
  [2334] = {.lex_state = 1},
  [2335] = {.lex_state = 1},
  [2336] = {.lex_state = 1},
  [2337] = {.lex_state = 1},
  [2338] = {.lex_state = 1},
  [2339] = {.lex_state = 1},
  [2340] = {.lex_state = 1},
  [2341] = {.lex_state = 1},
  [2342] = {.lex_state = 1},
  [2343] = {.lex_state = 0},
  [2344] = {.lex_state = 0},
  [2345] = {.lex_state = 0},
  [2346] = {.lex_state = 0},
  [2347] = {.lex_state = 0},
  [2348] = {.lex_state = 1},
  [2349] = {.lex_state = 0},
  [2350] = {.lex_state = 0},
  [2351] = {.lex_state = 1},
  [2352] = {.lex_state = 0},
  [2353] = {.lex_state = 0},
  [2354] = {.lex_state = 0},
  [2355] = {.lex_state = 0},
  [2356] = {.lex_state = 0},
  [2357] = {.lex_state = 0},
  [2358] = {.lex_state = 0},
  [2359] = {.lex_state = 0},
  [2360] = {.lex_state = 0},
  [2361] = {.lex_state = 0},
  [2362] = {.lex_state = 0},
  [2363] = {.lex_state = 0},
  [2364] = {.lex_state = 0},
  [2365] = {.lex_state = 0},
  [2366] = {.lex_state = 0},
  [2367] = {.lex_state = 0},
  [2368] = {.lex_state = 0},
  [2369] = {.lex_state = 0},
  [2370] = {.lex_state = 0},
  [2371] = {.lex_state = 0},
  [2372] = {.lex_state = 0},
  [2373] = {.lex_state = 0},
  [2374] = {.lex_state = 0},
  [2375] = {.lex_state = 0},
  [2376] = {.lex_state = 0},
  [2377] = {.lex_state = 0},
  [2378] = {.lex_state = 0},
  [2379] = {.lex_state = 0},
  [2380] = {.lex_state = 0},
  [2381] = {.lex_state = 0},
  [2382] = {.lex_state = 0},
  [2383] = {.lex_state = 0},
  [2384] = {.lex_state = 0},
  [2385] = {.lex_state = 0},
  [2386] = {.lex_state = 0},
  [2387] = {.lex_state = 0},
  [2388] = {.lex_state = 1},
  [2389] = {.lex_state = 0},
  [2390] = {.lex_state = 0},
  [2391] = {.lex_state = 0},
  [2392] = {.lex_state = 0},
  [2393] = {.lex_state = 0},
  [2394] = {.lex_state = 0},
  [2395] = {.lex_state = 0},
  [2396] = {.lex_state = 0},
  [2397] = {.lex_state = 0},
  [2398] = {.lex_state = 0},
  [2399] = {.lex_state = 0},
  [2400] = {.lex_state = 0},
  [2401] = {.lex_state = 0},
  [2402] = {.lex_state = 0},
  [2403] = {.lex_state = 0},
  [2404] = {.lex_state = 0},
  [2405] = {.lex_state = 0},
  [2406] = {.lex_state = 0},
  [2407] = {.lex_state = 240},
  [2408] = {.lex_state = 0},
  [2409] = {.lex_state = 0},
  [2410] = {.lex_state = 0},
  [2411] = {.lex_state = 0},
  [2412] = {.lex_state = 0},
  [2413] = {.lex_state = 0},
  [2414] = {.lex_state = 0},
  [2415] = {.lex_state = 0},
  [2416] = {.lex_state = 0},
  [2417] = {.lex_state = 0},
  [2418] = {.lex_state = 0},
  [2419] = {.lex_state = 0},
  [2420] = {.lex_state = 0},
  [2421] = {.lex_state = 0},
  [2422] = {.lex_state = 0},
  [2423] = {.lex_state = 0},
  [2424] = {.lex_state = 0},
  [2425] = {.lex_state = 0},
  [2426] = {.lex_state = 0},
  [2427] = {.lex_state = 0},
  [2428] = {.lex_state = 0},
  [2429] = {.lex_state = 0},
  [2430] = {.lex_state = 0},
  [2431] = {.lex_state = 0},
  [2432] = {.lex_state = 0},
  [2433] = {.lex_state = 1},
  [2434] = {.lex_state = 0},
  [2435] = {.lex_state = 0},
  [2436] = {.lex_state = 0},
  [2437] = {.lex_state = 0},
  [2438] = {.lex_state = 0},
  [2439] = {.lex_state = 0},
  [2440] = {.lex_state = 0},
  [2441] = {.lex_state = 0},
  [2442] = {.lex_state = 0},
  [2443] = {.lex_state = 0},
  [2444] = {.lex_state = 0},
  [2445] = {.lex_state = 0},
  [2446] = {.lex_state = 0},
  [2447] = {.lex_state = 0},
  [2448] = {.lex_state = 0},
  [2449] = {.lex_state = 0},
  [2450] = {.lex_state = 0},
  [2451] = {.lex_state = 0},
  [2452] = {.lex_state = 0},
  [2453] = {.lex_state = 0},
  [2454] = {.lex_state = 0},
  [2455] = {.lex_state = 0},
  [2456] = {.lex_state = 0},
  [2457] = {.lex_state = 240},
  [2458] = {.lex_state = 0},
  [2459] = {.lex_state = 0},
  [2460] = {.lex_state = 0},
  [2461] = {.lex_state = 0},
  [2462] = {.lex_state = 0},
  [2463] = {.lex_state = 0},
  [2464] = {.lex_state = 0},
  [2465] = {.lex_state = 0},
  [2466] = {.lex_state = 0},
  [2467] = {.lex_state = 0},
  [2468] = {.lex_state = 0},
  [2469] = {.lex_state = 0},
  [2470] = {.lex_state = 0},
  [2471] = {.lex_state = 0},
  [2472] = {.lex_state = 0},
  [2473] = {.lex_state = 0},
  [2474] = {.lex_state = 0},
  [2475] = {.lex_state = 0},
  [2476] = {.lex_state = 0},
  [2477] = {.lex_state = 0},
  [2478] = {.lex_state = 0},
  [2479] = {.lex_state = 0},
  [2480] = {.lex_state = 0},
  [2481] = {.lex_state = 0},
  [2482] = {.lex_state = 0},
  [2483] = {.lex_state = 0},
  [2484] = {.lex_state = 0},
  [2485] = {.lex_state = 0},
  [2486] = {.lex_state = 0},
  [2487] = {.lex_state = 0},
  [2488] = {.lex_state = 0},
  [2489] = {.lex_state = 0},
  [2490] = {.lex_state = 0},
  [2491] = {.lex_state = 240},
  [2492] = {.lex_state = 0},
  [2493] = {.lex_state = 0},
  [2494] = {.lex_state = 0},
  [2495] = {.lex_state = 0},
  [2496] = {.lex_state = 1},
  [2497] = {.lex_state = 1},
  [2498] = {.lex_state = 0},
  [2499] = {.lex_state = 0},
  [2500] = {.lex_state = 0},
  [2501] = {.lex_state = 0},
  [2502] = {.lex_state = 0},
  [2503] = {.lex_state = 0},
  [2504] = {.lex_state = 0},
  [2505] = {.lex_state = 0},
  [2506] = {.lex_state = 0},
  [2507] = {.lex_state = 0},
  [2508] = {.lex_state = 0},
  [2509] = {.lex_state = 0},
  [2510] = {.lex_state = 240},
  [2511] = {.lex_state = 0},
  [2512] = {.lex_state = 240},
  [2513] = {.lex_state = 0},
  [2514] = {.lex_state = 0},
  [2515] = {.lex_state = 0},
  [2516] = {.lex_state = 0},
  [2517] = {.lex_state = 0},
  [2518] = {.lex_state = 0},
  [2519] = {.lex_state = 0},
  [2520] = {.lex_state = 0},
  [2521] = {.lex_state = 0},
  [2522] = {.lex_state = 0},
  [2523] = {.lex_state = 0},
  [2524] = {.lex_state = 0},
  [2525] = {.lex_state = 0},
  [2526] = {.lex_state = 0},
  [2527] = {.lex_state = 0},
  [2528] = {.lex_state = 0},
  [2529] = {.lex_state = 0},
  [2530] = {.lex_state = 0},
  [2531] = {.lex_state = 0},
  [2532] = {.lex_state = 0},
  [2533] = {.lex_state = 0},
  [2534] = {.lex_state = 0},
  [2535] = {.lex_state = 0},
  [2536] = {.lex_state = 0},
  [2537] = {.lex_state = 0},
  [2538] = {.lex_state = 0},
  [2539] = {.lex_state = 0},
  [2540] = {.lex_state = 0},
  [2541] = {.lex_state = 0},
  [2542] = {.lex_state = 0},
  [2543] = {.lex_state = 0},
  [2544] = {.lex_state = 0},
  [2545] = {.lex_state = 0},
  [2546] = {.lex_state = 0},
  [2547] = {.lex_state = 0},
  [2548] = {.lex_state = 0},
  [2549] = {.lex_state = 0},
  [2550] = {.lex_state = 0},
  [2551] = {.lex_state = 0},
  [2552] = {.lex_state = 0},
  [2553] = {.lex_state = 0},
  [2554] = {.lex_state = 0},
  [2555] = {.lex_state = 0},
  [2556] = {.lex_state = 0},
  [2557] = {.lex_state = 0},
  [2558] = {.lex_state = 0},
  [2559] = {.lex_state = 0},
  [2560] = {.lex_state = 0},
  [2561] = {.lex_state = 0},
  [2562] = {.lex_state = 0},
  [2563] = {.lex_state = 0},
  [2564] = {.lex_state = 0},
  [2565] = {.lex_state = 0},
  [2566] = {.lex_state = 0},
  [2567] = {.lex_state = 0},
  [2568] = {.lex_state = 0},
  [2569] = {.lex_state = 0},
  [2570] = {.lex_state = 0},
  [2571] = {.lex_state = 0},
  [2572] = {.lex_state = 0},
  [2573] = {.lex_state = 0},
  [2574] = {.lex_state = 0},
  [2575] = {.lex_state = 0},
  [2576] = {.lex_state = 240},
  [2577] = {.lex_state = 240},
  [2578] = {.lex_state = 0},
  [2579] = {.lex_state = 0},
  [2580] = {.lex_state = 0},
  [2581] = {.lex_state = 0},
  [2582] = {.lex_state = 0},
  [2583] = {.lex_state = 0},
  [2584] = {.lex_state = 240},
  [2585] = {.lex_state = 240},
  [2586] = {.lex_state = 0},
  [2587] = {.lex_state = 240},
  [2588] = {.lex_state = 240},
  [2589] = {.lex_state = 240},
  [2590] = {.lex_state = 4},
  [2591] = {.lex_state = 240},
  [2592] = {.lex_state = 0},
  [2593] = {.lex_state = 240},
  [2594] = {.lex_state = 4},
  [2595] = {.lex_state = 0},
  [2596] = {.lex_state = 240},
  [2597] = {.lex_state = 240},
  [2598] = {.lex_state = 240},
  [2599] = {.lex_state = 0},
  [2600] = {.lex_state = 0},
  [2601] = {.lex_state = 0},
  [2602] = {.lex_state = 4},
  [2603] = {.lex_state = 240},
  [2604] = {.lex_state = 240},
  [2605] = {.lex_state = 240},
  [2606] = {.lex_state = 240},
  [2607] = {.lex_state = 240},
  [2608] = {.lex_state = 240},
  [2609] = {.lex_state = 0},
  [2610] = {.lex_state = 240},
  [2611] = {.lex_state = 240},
  [2612] = {.lex_state = 0},
  [2613] = {.lex_state = 240},
  [2614] = {.lex_state = 240},
  [2615] = {.lex_state = 240},
  [2616] = {.lex_state = 240},
  [2617] = {.lex_state = 240},
  [2618] = {.lex_state = 0},
  [2619] = {.lex_state = 240},
  [2620] = {.lex_state = 0},
  [2621] = {.lex_state = 240},
  [2622] = {.lex_state = 240},
  [2623] = {.lex_state = 240},
  [2624] = {.lex_state = 240},
  [2625] = {.lex_state = 0},
  [2626] = {.lex_state = 240},
  [2627] = {.lex_state = 240},
  [2628] = {.lex_state = 240},
  [2629] = {.lex_state = 0},
  [2630] = {.lex_state = 0},
  [2631] = {.lex_state = 240},
  [2632] = {.lex_state = 0},
  [2633] = {.lex_state = 240},
  [2634] = {.lex_state = 240},
  [2635] = {.lex_state = 240},
  [2636] = {.lex_state = 0},
  [2637] = {.lex_state = 0},
  [2638] = {.lex_state = 240},
  [2639] = {.lex_state = 240},
  [2640] = {.lex_state = 240},
  [2641] = {.lex_state = 240},
  [2642] = {.lex_state = 240},
  [2643] = {.lex_state = 240},
  [2644] = {.lex_state = 4},
  [2645] = {.lex_state = 240},
  [2646] = {.lex_state = 240},
  [2647] = {.lex_state = 240},
  [2648] = {.lex_state = 0},
  [2649] = {.lex_state = 0},
  [2650] = {.lex_state = 240},
  [2651] = {.lex_state = 240},
  [2652] = {.lex_state = 240},
  [2653] = {.lex_state = 240},
  [2654] = {.lex_state = 240},
  [2655] = {.lex_state = 4},
  [2656] = {.lex_state = 240},
  [2657] = {.lex_state = 240},
  [2658] = {.lex_state = 240},
  [2659] = {.lex_state = 240},
  [2660] = {.lex_state = 240},
  [2661] = {.lex_state = 0},
  [2662] = {.lex_state = 240},
  [2663] = {.lex_state = 0},
  [2664] = {.lex_state = 0},
  [2665] = {.lex_state = 240},
  [2666] = {.lex_state = 4},
  [2667] = {.lex_state = 4},
  [2668] = {.lex_state = 240},
  [2669] = {.lex_state = 0},
  [2670] = {.lex_state = 240},
  [2671] = {.lex_state = 240},
  [2672] = {.lex_state = 240},
  [2673] = {.lex_state = 0},
  [2674] = {.lex_state = 240},
  [2675] = {.lex_state = 0},
  [2676] = {.lex_state = 240},
  [2677] = {.lex_state = 240},
  [2678] = {.lex_state = 240},
  [2679] = {.lex_state = 240},
  [2680] = {.lex_state = 240},
  [2681] = {.lex_state = 0},
  [2682] = {.lex_state = 0},
  [2683] = {.lex_state = 240},
  [2684] = {.lex_state = 240},
  [2685] = {.lex_state = 240},
  [2686] = {.lex_state = 240},
  [2687] = {.lex_state = 240},
  [2688] = {.lex_state = 0},
  [2689] = {.lex_state = 240},
  [2690] = {.lex_state = 240},
  [2691] = {.lex_state = 240},
  [2692] = {.lex_state = 240},
  [2693] = {.lex_state = 240},
  [2694] = {.lex_state = 240},
  [2695] = {.lex_state = 240},
  [2696] = {.lex_state = 240},
  [2697] = {.lex_state = 240},
  [2698] = {.lex_state = 240},
  [2699] = {.lex_state = 240},
  [2700] = {.lex_state = 240},
  [2701] = {.lex_state = 0},
  [2702] = {.lex_state = 240},
  [2703] = {.lex_state = 0},
  [2704] = {.lex_state = 240},
  [2705] = {.lex_state = 240},
  [2706] = {.lex_state = 0},
  [2707] = {.lex_state = 240},
  [2708] = {.lex_state = 240},
  [2709] = {.lex_state = 240},
  [2710] = {.lex_state = 240},
  [2711] = {.lex_state = 240},
  [2712] = {.lex_state = 240},
  [2713] = {.lex_state = 240},
  [2714] = {.lex_state = 240},
  [2715] = {.lex_state = 240},
  [2716] = {.lex_state = 240},
  [2717] = {.lex_state = 0},
  [2718] = {.lex_state = 240},
  [2719] = {.lex_state = 240},
  [2720] = {.lex_state = 240},
  [2721] = {.lex_state = 240},
  [2722] = {.lex_state = 240},
  [2723] = {.lex_state = 0},
  [2724] = {.lex_state = 240},
  [2725] = {.lex_state = 240},
  [2726] = {.lex_state = 240},
  [2727] = {.lex_state = 240},
  [2728] = {.lex_state = 240},
  [2729] = {.lex_state = 240},
  [2730] = {.lex_state = 240},
  [2731] = {.lex_state = 240},
  [2732] = {.lex_state = 240},
  [2733] = {.lex_state = 240},
  [2734] = {.lex_state = 240},
  [2735] = {.lex_state = 240},
  [2736] = {.lex_state = 0},
  [2737] = {.lex_state = 240},
  [2738] = {.lex_state = 0},
  [2739] = {.lex_state = 240},
  [2740] = {.lex_state = 240},
  [2741] = {.lex_state = 240},
  [2742] = {.lex_state = 4},
  [2743] = {.lex_state = 0},
  [2744] = {.lex_state = 0},
  [2745] = {.lex_state = 0},
  [2746] = {.lex_state = 4},
  [2747] = {.lex_state = 0},
  [2748] = {.lex_state = 0},
  [2749] = {.lex_state = 240},
  [2750] = {.lex_state = 240},
  [2751] = {.lex_state = 240},
  [2752] = {.lex_state = 0},
  [2753] = {.lex_state = 240},
  [2754] = {.lex_state = 240},
  [2755] = {.lex_state = 240},
  [2756] = {.lex_state = 240},
  [2757] = {.lex_state = 240},
  [2758] = {.lex_state = 240},
  [2759] = {.lex_state = 240},
  [2760] = {.lex_state = 240},
  [2761] = {.lex_state = 240},
  [2762] = {.lex_state = 240},
  [2763] = {.lex_state = 240},
  [2764] = {.lex_state = 240},
  [2765] = {.lex_state = 240},
  [2766] = {.lex_state = 240},
  [2767] = {.lex_state = 240},
  [2768] = {.lex_state = 240},
  [2769] = {.lex_state = 240},
  [2770] = {.lex_state = 0},
  [2771] = {.lex_state = 0},
  [2772] = {.lex_state = 240},
  [2773] = {.lex_state = 0},
  [2774] = {.lex_state = 240},
  [2775] = {.lex_state = 240},
  [2776] = {.lex_state = 240},
  [2777] = {.lex_state = 240},
  [2778] = {.lex_state = 0},
  [2779] = {.lex_state = 240},
  [2780] = {.lex_state = 240},
  [2781] = {.lex_state = 240},
  [2782] = {.lex_state = 240},
  [2783] = {.lex_state = 0},
  [2784] = {.lex_state = 240},
  [2785] = {.lex_state = 0},
  [2786] = {.lex_state = 0},
  [2787] = {.lex_state = 240},
  [2788] = {.lex_state = 0},
  [2789] = {.lex_state = 0},
  [2790] = {.lex_state = 240},
  [2791] = {.lex_state = 0},
  [2792] = {.lex_state = 240},
  [2793] = {.lex_state = 0},
  [2794] = {.lex_state = 0},
  [2795] = {.lex_state = 0},
  [2796] = {.lex_state = 240},
  [2797] = {.lex_state = 240},
  [2798] = {.lex_state = 240},
  [2799] = {.lex_state = 240},
  [2800] = {.lex_state = 0},
  [2801] = {.lex_state = 0},
  [2802] = {.lex_state = 240},
  [2803] = {.lex_state = 240},
  [2804] = {.lex_state = 240},
  [2805] = {.lex_state = 0},
  [2806] = {.lex_state = 0},
  [2807] = {.lex_state = 240},
  [2808] = {.lex_state = 240},
  [2809] = {.lex_state = 240},
  [2810] = {.lex_state = 240},
  [2811] = {.lex_state = 240},
  [2812] = {.lex_state = 240},
  [2813] = {.lex_state = 240},
  [2814] = {.lex_state = 0},
  [2815] = {.lex_state = 240},
  [2816] = {.lex_state = 240},
  [2817] = {.lex_state = 240},
  [2818] = {.lex_state = 0},
  [2819] = {.lex_state = 0},
  [2820] = {.lex_state = 0},
  [2821] = {.lex_state = 0},
  [2822] = {.lex_state = 0},
  [2823] = {.lex_state = 0},
  [2824] = {.lex_state = 0},
  [2825] = {.lex_state = 240},
  [2826] = {.lex_state = 0},
  [2827] = {.lex_state = 4},
  [2828] = {.lex_state = 0},
  [2829] = {.lex_state = 4},
  [2830] = {.lex_state = 0},
  [2831] = {.lex_state = 240},
  [2832] = {.lex_state = 240},
  [2833] = {.lex_state = 0},
  [2834] = {.lex_state = 0},
  [2835] = {.lex_state = 0},
  [2836] = {.lex_state = 0},
  [2837] = {.lex_state = 240},
  [2838] = {.lex_state = 0},
  [2839] = {.lex_state = 240},
  [2840] = {.lex_state = 0},
  [2841] = {.lex_state = 240},
  [2842] = {.lex_state = 0},
  [2843] = {.lex_state = 0},
  [2844] = {.lex_state = 240},
  [2845] = {.lex_state = 240},
  [2846] = {.lex_state = 240},
  [2847] = {.lex_state = 240},
  [2848] = {.lex_state = 240},
  [2849] = {.lex_state = 240},
  [2850] = {.lex_state = 240},
  [2851] = {.lex_state = 240},
  [2852] = {.lex_state = 0},
  [2853] = {.lex_state = 0},
  [2854] = {.lex_state = 240},
  [2855] = {.lex_state = 240},
  [2856] = {.lex_state = 0},
  [2857] = {.lex_state = 0},
  [2858] = {.lex_state = 0},
  [2859] = {.lex_state = 240},
  [2860] = {.lex_state = 240},
  [2861] = {.lex_state = 0},
  [2862] = {.lex_state = 240},
  [2863] = {.lex_state = 240},
  [2864] = {.lex_state = 240},
  [2865] = {.lex_state = 0},
  [2866] = {.lex_state = 240},
  [2867] = {.lex_state = 240},
  [2868] = {.lex_state = 240},
  [2869] = {.lex_state = 240},
  [2870] = {.lex_state = 240},
  [2871] = {.lex_state = 240},
  [2872] = {.lex_state = 240},
  [2873] = {.lex_state = 240},
  [2874] = {.lex_state = 240},
  [2875] = {.lex_state = 240},
  [2876] = {.lex_state = 240},
  [2877] = {.lex_state = 240},
  [2878] = {.lex_state = 240},
  [2879] = {.lex_state = 0},
  [2880] = {.lex_state = 0},
  [2881] = {.lex_state = 0},
  [2882] = {.lex_state = 0},
  [2883] = {.lex_state = 0},
  [2884] = {.lex_state = 0},
  [2885] = {.lex_state = 0},
  [2886] = {.lex_state = 240},
  [2887] = {.lex_state = 0},
  [2888] = {.lex_state = 0},
  [2889] = {.lex_state = 0},
  [2890] = {.lex_state = 0},
  [2891] = {.lex_state = 0},
  [2892] = {.lex_state = 0},
  [2893] = {.lex_state = 240},
  [2894] = {.lex_state = 0},
  [2895] = {.lex_state = 0},
  [2896] = {.lex_state = 0},
  [2897] = {.lex_state = 240},
  [2898] = {.lex_state = 0},
  [2899] = {.lex_state = 0},
  [2900] = {.lex_state = 240},
  [2901] = {.lex_state = 0},
  [2902] = {.lex_state = 0},
  [2903] = {.lex_state = 0},
  [2904] = {.lex_state = 0},
  [2905] = {.lex_state = 240},
  [2906] = {.lex_state = 240},
  [2907] = {.lex_state = 240},
  [2908] = {.lex_state = 0},
  [2909] = {.lex_state = 240},
  [2910] = {.lex_state = 0},
  [2911] = {.lex_state = 240},
  [2912] = {.lex_state = 240},
  [2913] = {.lex_state = 0},
  [2914] = {.lex_state = 240},
  [2915] = {.lex_state = 0},
  [2916] = {.lex_state = 0},
  [2917] = {.lex_state = 0},
  [2918] = {.lex_state = 0},
  [2919] = {.lex_state = 240},
  [2920] = {.lex_state = 0},
  [2921] = {.lex_state = 240},
  [2922] = {.lex_state = 240},
  [2923] = {.lex_state = 0},
  [2924] = {.lex_state = 0},
  [2925] = {.lex_state = 0},
  [2926] = {.lex_state = 0},
  [2927] = {.lex_state = 0},
  [2928] = {.lex_state = 240},
  [2929] = {.lex_state = 0},
  [2930] = {.lex_state = 0},
  [2931] = {.lex_state = 0},
  [2932] = {.lex_state = 240},
  [2933] = {.lex_state = 240},
  [2934] = {.lex_state = 240},
  [2935] = {.lex_state = 0},
  [2936] = {.lex_state = 0},
  [2937] = {.lex_state = 240},
  [2938] = {.lex_state = 0},
  [2939] = {.lex_state = 0},
  [2940] = {.lex_state = 240},
  [2941] = {.lex_state = 0},
  [2942] = {.lex_state = 240},
  [2943] = {.lex_state = 0},
  [2944] = {.lex_state = 0},
  [2945] = {.lex_state = 0},
  [2946] = {.lex_state = 0},
  [2947] = {.lex_state = 240},
  [2948] = {.lex_state = 240},
  [2949] = {.lex_state = 0},
  [2950] = {.lex_state = 0},
  [2951] = {.lex_state = 0},
  [2952] = {.lex_state = 0},
  [2953] = {.lex_state = 0},
  [2954] = {.lex_state = 0},
  [2955] = {.lex_state = 0},
  [2956] = {.lex_state = 0},
  [2957] = {.lex_state = 240},
  [2958] = {.lex_state = 0},
  [2959] = {.lex_state = 0},
  [2960] = {.lex_state = 0},
  [2961] = {.lex_state = 0},
  [2962] = {.lex_state = 0},
  [2963] = {.lex_state = 0},
  [2964] = {.lex_state = 0},
  [2965] = {.lex_state = 0},
  [2966] = {.lex_state = 0},
  [2967] = {.lex_state = 0},
  [2968] = {.lex_state = 240},
  [2969] = {.lex_state = 0},
  [2970] = {.lex_state = 240},
  [2971] = {.lex_state = 240},
  [2972] = {.lex_state = 240},
  [2973] = {.lex_state = 240},
  [2974] = {.lex_state = 0},
  [2975] = {.lex_state = 0},
  [2976] = {.lex_state = 0},
  [2977] = {.lex_state = 0},
  [2978] = {.lex_state = 240},
  [2979] = {.lex_state = 240},
  [2980] = {.lex_state = 240},
  [2981] = {.lex_state = 0},
  [2982] = {.lex_state = 0},
  [2983] = {.lex_state = 0},
  [2984] = {.lex_state = 240},
  [2985] = {.lex_state = 0},
  [2986] = {.lex_state = 0},
  [2987] = {.lex_state = 0},
  [2988] = {.lex_state = 0},
  [2989] = {.lex_state = 0},
  [2990] = {.lex_state = 0},
  [2991] = {.lex_state = 0},
  [2992] = {.lex_state = 0},
  [2993] = {.lex_state = 0},
  [2994] = {.lex_state = 240},
  [2995] = {.lex_state = 0},
  [2996] = {.lex_state = 0},
  [2997] = {.lex_state = 0},
  [2998] = {.lex_state = 0},
  [2999] = {.lex_state = 0},
  [3000] = {.lex_state = 0},
  [3001] = {.lex_state = 0},
  [3002] = {.lex_state = 0},
  [3003] = {.lex_state = 0},
  [3004] = {.lex_state = 0},
  [3005] = {.lex_state = 0},
  [3006] = {.lex_state = 0},
  [3007] = {.lex_state = 0},
  [3008] = {.lex_state = 0},
  [3009] = {.lex_state = 0},
  [3010] = {.lex_state = 0},
  [3011] = {.lex_state = 0},
  [3012] = {.lex_state = 0},
  [3013] = {.lex_state = 0},
  [3014] = {.lex_state = 0},
  [3015] = {.lex_state = 0},
  [3016] = {.lex_state = 0},
  [3017] = {.lex_state = 0},
  [3018] = {.lex_state = 0},
  [3019] = {.lex_state = 0},
  [3020] = {.lex_state = 0},
  [3021] = {.lex_state = 0},
  [3022] = {.lex_state = 0},
  [3023] = {.lex_state = 240},
  [3024] = {.lex_state = 0},
  [3025] = {.lex_state = 0},
  [3026] = {.lex_state = 0},
  [3027] = {.lex_state = 0},
  [3028] = {.lex_state = 0},
  [3029] = {.lex_state = 0},
  [3030] = {.lex_state = 0},
  [3031] = {.lex_state = 240},
  [3032] = {.lex_state = 240},
  [3033] = {.lex_state = 0},
  [3034] = {.lex_state = 0},
  [3035] = {.lex_state = 240},
  [3036] = {.lex_state = 240},
  [3037] = {.lex_state = 0},
  [3038] = {.lex_state = 0},
  [3039] = {.lex_state = 0},
  [3040] = {.lex_state = 0},
  [3041] = {.lex_state = 0},
  [3042] = {.lex_state = 0},
  [3043] = {.lex_state = 0},
  [3044] = {.lex_state = 0},
  [3045] = {.lex_state = 0},
  [3046] = {.lex_state = 0},
  [3047] = {.lex_state = 0},
  [3048] = {.lex_state = 0},
  [3049] = {.lex_state = 0},
  [3050] = {.lex_state = 0},
  [3051] = {.lex_state = 240},
  [3052] = {.lex_state = 0},
  [3053] = {.lex_state = 0},
  [3054] = {.lex_state = 0},
  [3055] = {.lex_state = 0},
  [3056] = {.lex_state = 0},
  [3057] = {.lex_state = 0},
  [3058] = {.lex_state = 0},
  [3059] = {.lex_state = 0},
  [3060] = {.lex_state = 0},
  [3061] = {.lex_state = 0},
  [3062] = {.lex_state = 0},
  [3063] = {.lex_state = 0},
  [3064] = {.lex_state = 0},
  [3065] = {.lex_state = 0},
  [3066] = {.lex_state = 0},
  [3067] = {.lex_state = 0},
  [3068] = {.lex_state = 0},
  [3069] = {.lex_state = 0},
  [3070] = {.lex_state = 0},
  [3071] = {.lex_state = 0},
  [3072] = {.lex_state = 0},
  [3073] = {.lex_state = 0},
  [3074] = {.lex_state = 0},
  [3075] = {.lex_state = 0},
  [3076] = {.lex_state = 0},
  [3077] = {.lex_state = 0},
  [3078] = {.lex_state = 0},
  [3079] = {.lex_state = 0},
  [3080] = {.lex_state = 0},
  [3081] = {.lex_state = 0},
  [3082] = {.lex_state = 0},
  [3083] = {.lex_state = 0},
  [3084] = {.lex_state = 0},
  [3085] = {.lex_state = 0},
  [3086] = {.lex_state = 0},
  [3087] = {.lex_state = 0},
  [3088] = {.lex_state = 0},
  [3089] = {.lex_state = 0},
  [3090] = {.lex_state = 0},
  [3091] = {.lex_state = 0},
  [3092] = {.lex_state = 0},
  [3093] = {.lex_state = 0},
  [3094] = {.lex_state = 0},
  [3095] = {.lex_state = 0},
  [3096] = {.lex_state = 0},
  [3097] = {.lex_state = 0},
  [3098] = {.lex_state = 0},
  [3099] = {.lex_state = 0},
  [3100] = {.lex_state = 0},
  [3101] = {.lex_state = 0},
  [3102] = {.lex_state = 0},
  [3103] = {.lex_state = 0},
  [3104] = {.lex_state = 0},
  [3105] = {.lex_state = 0},
  [3106] = {.lex_state = 0},
  [3107] = {.lex_state = 0},
  [3108] = {.lex_state = 0},
  [3109] = {.lex_state = 0},
  [3110] = {.lex_state = 0},
  [3111] = {.lex_state = 0},
  [3112] = {.lex_state = 0},
  [3113] = {.lex_state = 0},
  [3114] = {.lex_state = 0},
  [3115] = {.lex_state = 0},
  [3116] = {.lex_state = 0},
  [3117] = {.lex_state = 0},
  [3118] = {.lex_state = 0},
  [3119] = {.lex_state = 0},
  [3120] = {.lex_state = 0},
  [3121] = {.lex_state = 0},
  [3122] = {.lex_state = 0},
  [3123] = {.lex_state = 0},
  [3124] = {.lex_state = 0},
  [3125] = {.lex_state = 0},
  [3126] = {.lex_state = 0},
  [3127] = {.lex_state = 0},
  [3128] = {.lex_state = 0},
  [3129] = {.lex_state = 0},
  [3130] = {.lex_state = 0},
  [3131] = {.lex_state = 0},
  [3132] = {.lex_state = 0},
  [3133] = {.lex_state = 0},
  [3134] = {.lex_state = 0},
  [3135] = {.lex_state = 0},
  [3136] = {.lex_state = 0},
  [3137] = {.lex_state = 0},
  [3138] = {.lex_state = 0},
  [3139] = {.lex_state = 0},
  [3140] = {.lex_state = 0},
  [3141] = {.lex_state = 0},
  [3142] = {.lex_state = 0},
  [3143] = {.lex_state = 0},
  [3144] = {.lex_state = 0},
  [3145] = {.lex_state = 0},
  [3146] = {.lex_state = 0},
  [3147] = {.lex_state = 0},
  [3148] = {.lex_state = 0},
  [3149] = {.lex_state = 0},
  [3150] = {.lex_state = 0},
  [3151] = {.lex_state = 0},
  [3152] = {.lex_state = 0},
  [3153] = {.lex_state = 0},
  [3154] = {.lex_state = 0},
  [3155] = {.lex_state = 0},
  [3156] = {.lex_state = 0},
  [3157] = {.lex_state = 0},
  [3158] = {.lex_state = 0},
  [3159] = {.lex_state = 0},
  [3160] = {.lex_state = 0},
  [3161] = {.lex_state = 0},
  [3162] = {.lex_state = 0},
  [3163] = {.lex_state = 0},
  [3164] = {.lex_state = 0},
  [3165] = {.lex_state = 0},
  [3166] = {.lex_state = 0},
  [3167] = {.lex_state = 0},
  [3168] = {.lex_state = 0},
  [3169] = {.lex_state = 0},
  [3170] = {.lex_state = 0},
  [3171] = {.lex_state = 0},
  [3172] = {.lex_state = 0},
  [3173] = {.lex_state = 0},
  [3174] = {.lex_state = 0},
  [3175] = {.lex_state = 0},
  [3176] = {.lex_state = 0},
  [3177] = {.lex_state = 0},
  [3178] = {.lex_state = 0},
  [3179] = {.lex_state = 0},
  [3180] = {.lex_state = 0},
  [3181] = {.lex_state = 0},
  [3182] = {.lex_state = 0},
  [3183] = {.lex_state = 0},
  [3184] = {.lex_state = 0},
  [3185] = {.lex_state = 0},
  [3186] = {.lex_state = 0},
  [3187] = {.lex_state = 0},
  [3188] = {.lex_state = 0},
  [3189] = {.lex_state = 0},
  [3190] = {.lex_state = 0},
  [3191] = {.lex_state = 0},
  [3192] = {.lex_state = 0},
  [3193] = {.lex_state = 0},
  [3194] = {.lex_state = 0},
  [3195] = {.lex_state = 0},
  [3196] = {.lex_state = 0},
  [3197] = {.lex_state = 0},
  [3198] = {.lex_state = 0},
  [3199] = {.lex_state = 0},
  [3200] = {.lex_state = 0},
  [3201] = {.lex_state = 0},
  [3202] = {.lex_state = 0},
  [3203] = {.lex_state = 0},
  [3204] = {.lex_state = 0},
  [3205] = {.lex_state = 0},
  [3206] = {.lex_state = 0},
  [3207] = {.lex_state = 0},
  [3208] = {.lex_state = 0},
  [3209] = {.lex_state = 0},
  [3210] = {.lex_state = 0},
  [3211] = {.lex_state = 0},
  [3212] = {.lex_state = 0},
  [3213] = {.lex_state = 0},
  [3214] = {.lex_state = 0},
  [3215] = {.lex_state = 0},
  [3216] = {.lex_state = 0},
  [3217] = {.lex_state = 0},
  [3218] = {.lex_state = 0},
  [3219] = {.lex_state = 0},
  [3220] = {.lex_state = 0},
  [3221] = {.lex_state = 0},
  [3222] = {.lex_state = 0},
  [3223] = {.lex_state = 0},
  [3224] = {.lex_state = 0},
  [3225] = {.lex_state = 0},
  [3226] = {.lex_state = 0},
  [3227] = {.lex_state = 0},
  [3228] = {.lex_state = 0},
  [3229] = {.lex_state = 0},
  [3230] = {.lex_state = 0},
  [3231] = {.lex_state = 0},
  [3232] = {.lex_state = 0},
  [3233] = {.lex_state = 0},
  [3234] = {.lex_state = 0},
  [3235] = {.lex_state = 0},
  [3236] = {.lex_state = 0},
  [3237] = {.lex_state = 0},
  [3238] = {.lex_state = 0},
  [3239] = {.lex_state = 0},
  [3240] = {.lex_state = 0},
  [3241] = {.lex_state = 0},
  [3242] = {.lex_state = 0},
  [3243] = {.lex_state = 0},
  [3244] = {.lex_state = 0},
  [3245] = {.lex_state = 0},
  [3246] = {.lex_state = 0},
  [3247] = {.lex_state = 0},
  [3248] = {.lex_state = 0},
  [3249] = {.lex_state = 0},
  [3250] = {.lex_state = 0},
  [3251] = {.lex_state = 0},
  [3252] = {.lex_state = 0},
  [3253] = {.lex_state = 0},
  [3254] = {.lex_state = 0},
  [3255] = {.lex_state = 0},
  [3256] = {.lex_state = 0},
  [3257] = {.lex_state = 0},
  [3258] = {.lex_state = 0},
  [3259] = {.lex_state = 0},
  [3260] = {.lex_state = 0},
  [3261] = {.lex_state = 0},
  [3262] = {.lex_state = 0},
  [3263] = {.lex_state = 0},
  [3264] = {.lex_state = 0},
  [3265] = {.lex_state = 0},
  [3266] = {.lex_state = 0},
  [3267] = {.lex_state = 0},
  [3268] = {.lex_state = 0},
  [3269] = {.lex_state = 0},
  [3270] = {.lex_state = 0},
  [3271] = {.lex_state = 0},
  [3272] = {.lex_state = 0},
  [3273] = {.lex_state = 0},
  [3274] = {.lex_state = 0},
  [3275] = {.lex_state = 0},
  [3276] = {.lex_state = 0},
  [3277] = {.lex_state = 0},
  [3278] = {.lex_state = 0},
  [3279] = {.lex_state = 0},
  [3280] = {.lex_state = 0},
  [3281] = {.lex_state = 0},
  [3282] = {.lex_state = 0},
  [3283] = {.lex_state = 0},
  [3284] = {.lex_state = 0},
  [3285] = {.lex_state = 0},
  [3286] = {.lex_state = 0},
  [3287] = {.lex_state = 0},
  [3288] = {.lex_state = 0},
  [3289] = {.lex_state = 0},
  [3290] = {.lex_state = 0},
  [3291] = {.lex_state = 0},
  [3292] = {.lex_state = 0},
  [3293] = {.lex_state = 0},
  [3294] = {.lex_state = 0},
  [3295] = {.lex_state = 0},
  [3296] = {.lex_state = 0},
  [3297] = {.lex_state = 0},
  [3298] = {.lex_state = 0},
  [3299] = {.lex_state = 0},
  [3300] = {.lex_state = 0},
  [3301] = {.lex_state = 0},
  [3302] = {.lex_state = 0},
  [3303] = {.lex_state = 0},
  [3304] = {.lex_state = 0},
  [3305] = {.lex_state = 0},
  [3306] = {.lex_state = 0},
  [3307] = {.lex_state = 0},
  [3308] = {.lex_state = 0},
  [3309] = {.lex_state = 0},
  [3310] = {.lex_state = 0},
  [3311] = {.lex_state = 0},
  [3312] = {.lex_state = 0},
  [3313] = {.lex_state = 0},
  [3314] = {.lex_state = 0},
  [3315] = {.lex_state = 0},
  [3316] = {.lex_state = 0},
  [3317] = {.lex_state = 0},
  [3318] = {.lex_state = 0},
  [3319] = {.lex_state = 0},
  [3320] = {.lex_state = 0},
  [3321] = {.lex_state = 0},
  [3322] = {.lex_state = 0},
  [3323] = {.lex_state = 0},
  [3324] = {.lex_state = 0},
  [3325] = {.lex_state = 0},
  [3326] = {.lex_state = 0},
  [3327] = {.lex_state = 0},
  [3328] = {.lex_state = 0},
  [3329] = {.lex_state = 0},
  [3330] = {.lex_state = 0},
  [3331] = {.lex_state = 0},
  [3332] = {.lex_state = 0},
  [3333] = {.lex_state = 0},
  [3334] = {.lex_state = 0},
  [3335] = {.lex_state = 0},
  [3336] = {.lex_state = 0},
  [3337] = {.lex_state = 0},
  [3338] = {.lex_state = 0},
  [3339] = {.lex_state = 0},
  [3340] = {.lex_state = 0},
  [3341] = {.lex_state = 0},
  [3342] = {.lex_state = 0},
  [3343] = {.lex_state = 0},
  [3344] = {.lex_state = 0},
  [3345] = {.lex_state = 0},
  [3346] = {.lex_state = 0},
  [3347] = {.lex_state = 0},
  [3348] = {.lex_state = 0},
  [3349] = {.lex_state = 0},
  [3350] = {.lex_state = 0},
  [3351] = {.lex_state = 0},
  [3352] = {.lex_state = 0},
  [3353] = {.lex_state = 0},
  [3354] = {.lex_state = 0},
  [3355] = {.lex_state = 0},
  [3356] = {.lex_state = 0},
  [3357] = {.lex_state = 0},
  [3358] = {.lex_state = 0},
  [3359] = {.lex_state = 0},
  [3360] = {.lex_state = 0},
  [3361] = {.lex_state = 0},
  [3362] = {.lex_state = 0},
  [3363] = {.lex_state = 0},
  [3364] = {.lex_state = 0},
  [3365] = {.lex_state = 0},
  [3366] = {.lex_state = 0},
  [3367] = {.lex_state = 0},
  [3368] = {.lex_state = 0},
  [3369] = {.lex_state = 0},
  [3370] = {.lex_state = 0},
  [3371] = {.lex_state = 0},
  [3372] = {.lex_state = 0},
  [3373] = {.lex_state = 0},
  [3374] = {.lex_state = 0},
  [3375] = {.lex_state = 0},
  [3376] = {.lex_state = 0},
  [3377] = {.lex_state = 0},
  [3378] = {.lex_state = 0},
  [3379] = {.lex_state = 0},
  [3380] = {.lex_state = 0},
  [3381] = {.lex_state = 0},
  [3382] = {.lex_state = 0},
  [3383] = {.lex_state = 0},
  [3384] = {.lex_state = 0},
  [3385] = {.lex_state = 0},
  [3386] = {.lex_state = 0},
  [3387] = {.lex_state = 0},
  [3388] = {.lex_state = 0},
  [3389] = {.lex_state = 0},
  [3390] = {.lex_state = 0},
  [3391] = {.lex_state = 0},
  [3392] = {.lex_state = 0},
  [3393] = {.lex_state = 0},
  [3394] = {.lex_state = 0},
  [3395] = {.lex_state = 0},
  [3396] = {.lex_state = 0},
  [3397] = {.lex_state = 0},
  [3398] = {.lex_state = 0},
  [3399] = {.lex_state = 0},
  [3400] = {.lex_state = 0},
  [3401] = {.lex_state = 0},
  [3402] = {.lex_state = 0},
  [3403] = {.lex_state = 0},
  [3404] = {.lex_state = 0},
  [3405] = {.lex_state = 0},
  [3406] = {.lex_state = 0},
  [3407] = {.lex_state = 0},
  [3408] = {.lex_state = 0},
  [3409] = {.lex_state = 0},
  [3410] = {.lex_state = 0},
  [3411] = {.lex_state = 0},
  [3412] = {.lex_state = 0},
  [3413] = {.lex_state = 0},
  [3414] = {.lex_state = 0},
  [3415] = {.lex_state = 0},
  [3416] = {.lex_state = 0},
  [3417] = {.lex_state = 0},
  [3418] = {.lex_state = 0},
  [3419] = {.lex_state = 0},
  [3420] = {.lex_state = 0},
  [3421] = {.lex_state = 0},
  [3422] = {.lex_state = 0},
  [3423] = {.lex_state = 0},
  [3424] = {.lex_state = 0},
  [3425] = {.lex_state = 0},
  [3426] = {.lex_state = 0},
  [3427] = {.lex_state = 0},
  [3428] = {.lex_state = 0},
  [3429] = {.lex_state = 0},
  [3430] = {.lex_state = 0},
  [3431] = {.lex_state = 0},
  [3432] = {.lex_state = 0},
  [3433] = {.lex_state = 0},
  [3434] = {.lex_state = 0},
  [3435] = {.lex_state = 0},
  [3436] = {.lex_state = 0},
  [3437] = {.lex_state = 0},
  [3438] = {.lex_state = 0},
  [3439] = {.lex_state = 0},
  [3440] = {.lex_state = 0},
  [3441] = {.lex_state = 0},
  [3442] = {.lex_state = 0},
  [3443] = {.lex_state = 0},
  [3444] = {.lex_state = 0},
  [3445] = {.lex_state = 0},
  [3446] = {.lex_state = 0},
  [3447] = {.lex_state = 0},
  [3448] = {.lex_state = 0},
  [3449] = {.lex_state = 0},
  [3450] = {.lex_state = 0},
  [3451] = {.lex_state = 0},
  [3452] = {.lex_state = 0},
  [3453] = {.lex_state = 0},
  [3454] = {.lex_state = 0},
  [3455] = {.lex_state = 0},
  [3456] = {.lex_state = 0},
  [3457] = {.lex_state = 0},
  [3458] = {.lex_state = 0},
  [3459] = {.lex_state = 0},
  [3460] = {.lex_state = 0},
  [3461] = {.lex_state = 0},
  [3462] = {.lex_state = 0},
  [3463] = {.lex_state = 0},
  [3464] = {.lex_state = 0},
  [3465] = {.lex_state = 0},
  [3466] = {.lex_state = 0},
  [3467] = {.lex_state = 0},
  [3468] = {.lex_state = 0},
  [3469] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_foreign] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym_blank_identifier] = ACTIONS(1),
    [anon_sym_defer] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(1),
    [anon_sym_POUNDbounds_check] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_distinct] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_uint] = ACTIONS(1),
    [anon_sym_uintptr] = ACTIONS(1),
    [anon_sym_typeid] = ACTIONS(1),
    [anon_sym_rawptr] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_cstring] = ACTIONS(1),
    [anon_sym_i8] = ACTIONS(1),
    [anon_sym_u8] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_b8] = ACTIONS(1),
    [anon_sym_b16] = ACTIONS(1),
    [anon_sym_b32] = ACTIONS(1),
    [anon_sym_b64] = ACTIONS(1),
    [anon_sym_i16] = ACTIONS(1),
    [anon_sym_i16le] = ACTIONS(1),
    [anon_sym_i16be] = ACTIONS(1),
    [anon_sym_i32] = ACTIONS(1),
    [anon_sym_i32le] = ACTIONS(1),
    [anon_sym_i32be] = ACTIONS(1),
    [anon_sym_i64] = ACTIONS(1),
    [anon_sym_i64le] = ACTIONS(1),
    [anon_sym_i64be] = ACTIONS(1),
    [anon_sym_i128] = ACTIONS(1),
    [anon_sym_i128le] = ACTIONS(1),
    [anon_sym_i128be] = ACTIONS(1),
    [anon_sym_u16] = ACTIONS(1),
    [anon_sym_u16le] = ACTIONS(1),
    [anon_sym_u16be] = ACTIONS(1),
    [anon_sym_u32] = ACTIONS(1),
    [anon_sym_u32le] = ACTIONS(1),
    [anon_sym_u32be] = ACTIONS(1),
    [anon_sym_u64] = ACTIONS(1),
    [anon_sym_u64le] = ACTIONS(1),
    [anon_sym_u64be] = ACTIONS(1),
    [anon_sym_u128] = ACTIONS(1),
    [anon_sym_u128le] = ACTIONS(1),
    [anon_sym_u128be] = ACTIONS(1),
    [anon_sym_f16] = ACTIONS(1),
    [anon_sym_f16le] = ACTIONS(1),
    [anon_sym_f16be] = ACTIONS(1),
    [anon_sym_f32] = ACTIONS(1),
    [anon_sym_f32le] = ACTIONS(1),
    [anon_sym_f32be] = ACTIONS(1),
    [anon_sym_f64] = ACTIONS(1),
    [anon_sym_f64le] = ACTIONS(1),
    [anon_sym_f64be] = ACTIONS(1),
    [anon_sym_complex32] = ACTIONS(1),
    [anon_sym_complex64] = ACTIONS(1),
    [anon_sym_complex128] = ACTIONS(1),
    [anon_sym_quaternion64] = ACTIONS(1),
    [anon_sym_quaternion128] = ACTIONS(1),
    [anon_sym_quaternion256] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_POUNDrelative] = ACTIONS(1),
    [anon_sym_bit_set] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_matrix] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_dynamic] = ACTIONS(1),
    [anon_sym_POUNDsoa] = ACTIONS(1),
    [anon_sym_POUNDsimd] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_POUNDno_nil] = ACTIONS(1),
    [anon_sym_POUNDshared_nil] = ACTIONS(1),
    [anon_sym_POUNDalign] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_POUNDno_copy] = ACTIONS(1),
    [anon_sym_POUNDpacked] = ACTIONS(1),
    [anon_sym_POUNDraw_union] = ACTIONS(1),
    [anon_sym_map] = ACTIONS(1),
    [anon_sym_POUNDtype] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_cast] = ACTIONS(1),
    [anon_sym_transmute] = ACTIONS(1),
    [anon_sym_auto_cast] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_DASH_DASH_DASH] = ACTIONS(1),
    [anon_sym_where] = ACTIONS(1),
    [anon_sym_POUNDforce_inline] = ACTIONS(1),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(1),
    [anon_sym_proc] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUNDoptional_ok] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_POUNDno_alias] = ACTIONS(1),
    [anon_sym_POUNDby_ptr] = ACTIONS(1),
    [anon_sym_POUNDany_int] = ACTIONS(1),
    [anon_sym_POUNDc_vararg] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_AMP_TILDE_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_POUNDpartial] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_POUNDunroll] = ACTIONS(1),
    [anon_sym_or_return] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_or_else] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PERCENT_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_TILDE] = ACTIONS(1),
    [anon_sym_not_in] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_LT] = ACTIONS(1),
    [anon_sym_DOT_DOT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [sym_builtin_procedure] = ACTIONS(1),
    [sym_raw_string_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_float_literal] = ACTIONS(1),
    [sym_rune_literal] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym__true] = ACTIONS(1),
    [sym__false] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(3456),
    [sym_package_clause] = STATE(2281),
    [anon_sym_package] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__simple_statement] = STATE(2831),
    [sym__statement] = STATE(2831),
    [sym_defer_statement] = STATE(2831),
    [sym_using_statement] = STATE(2831),
    [sym_return_statement] = STATE(2831),
    [sym_block_statement] = STATE(2831),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2831),
    [sym_var_declaration] = STATE(2831),
    [sym_const_declaration] = STATE(2831),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1351),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1351),
    [sym_ternary_expression] = STATE(1351),
    [sym_index_expression] = STATE(1351),
    [sym__parenthesized_expression] = STATE(1351),
    [sym_proc_literal] = STATE(1351),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1351),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1332),
    [sym_initializer_list] = STATE(3262),
    [sym_single_assignment] = STATE(2609),
    [sym_assignment_statement] = STATE(2831),
    [sym__expression_pack] = STATE(2287),
    [sym_case_statement] = STATE(23),
    [sym_continue_statement] = STATE(2831),
    [sym_break_statement] = STATE(2831),
    [sym_if_statement] = STATE(2831),
    [sym_switch_statement] = STATE(2831),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2831),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1351),
    [sym_left_unary_expression] = STATE(1351),
    [sym_binary_expression] = STATE(1351),
    [sym_compound_literal] = STATE(1351),
    [sym_interpreted_string_literal] = STATE(1351),
    [sym_bool_literal] = STATE(1351),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym__switch_block_repeat1] = STATE(2832),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(15),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(87),
    [sym_float_literal] = ACTIONS(87),
    [sym_rune_literal] = ACTIONS(87),
    [sym_nil] = ACTIONS(87),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [3] = {
    [sym__simple_statement] = STATE(2716),
    [sym__statement] = STATE(2716),
    [sym_defer_statement] = STATE(2716),
    [sym_using_statement] = STATE(2716),
    [sym_return_statement] = STATE(2716),
    [sym_block_statement] = STATE(2716),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2716),
    [sym_var_declaration] = STATE(2716),
    [sym_const_declaration] = STATE(2716),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1351),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1351),
    [sym_ternary_expression] = STATE(1351),
    [sym_index_expression] = STATE(1351),
    [sym__parenthesized_expression] = STATE(1351),
    [sym_proc_literal] = STATE(1351),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1351),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1332),
    [sym_initializer_list] = STATE(3262),
    [sym_single_assignment] = STATE(2609),
    [sym_assignment_statement] = STATE(2716),
    [sym__expression_pack] = STATE(2287),
    [sym_case_statement] = STATE(24),
    [sym_continue_statement] = STATE(2716),
    [sym_break_statement] = STATE(2716),
    [sym_if_statement] = STATE(2716),
    [sym_switch_statement] = STATE(2716),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2716),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1351),
    [sym_left_unary_expression] = STATE(1351),
    [sym_binary_expression] = STATE(1351),
    [sym_compound_literal] = STATE(1351),
    [sym_interpreted_string_literal] = STATE(1351),
    [sym_bool_literal] = STATE(1351),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym__switch_block_repeat1] = STATE(2719),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(95),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(87),
    [sym_float_literal] = ACTIONS(87),
    [sym_rune_literal] = ACTIONS(87),
    [sym_nil] = ACTIONS(87),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [4] = {
    [sym__simple_statement] = STATE(2716),
    [sym__statement] = STATE(2716),
    [sym_defer_statement] = STATE(2716),
    [sym_using_statement] = STATE(2716),
    [sym_return_statement] = STATE(2716),
    [sym_block_statement] = STATE(2716),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2716),
    [sym_var_declaration] = STATE(2716),
    [sym_const_declaration] = STATE(2716),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1351),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1351),
    [sym_ternary_expression] = STATE(1351),
    [sym_index_expression] = STATE(1351),
    [sym__parenthesized_expression] = STATE(1351),
    [sym_proc_literal] = STATE(1351),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1351),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1332),
    [sym_initializer_list] = STATE(3127),
    [sym_single_assignment] = STATE(2609),
    [sym_assignment_statement] = STATE(2716),
    [sym__expression_pack] = STATE(2287),
    [sym_case_statement] = STATE(24),
    [sym_continue_statement] = STATE(2716),
    [sym_break_statement] = STATE(2716),
    [sym_if_statement] = STATE(2716),
    [sym_switch_statement] = STATE(2716),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2716),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1351),
    [sym_left_unary_expression] = STATE(1351),
    [sym_binary_expression] = STATE(1351),
    [sym_compound_literal] = STATE(1351),
    [sym_interpreted_string_literal] = STATE(1351),
    [sym_bool_literal] = STATE(1351),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym__switch_block_repeat1] = STATE(2719),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(87),
    [sym_float_literal] = ACTIONS(87),
    [sym_rune_literal] = ACTIONS(87),
    [sym_nil] = ACTIONS(87),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [5] = {
    [sym__simple_statement] = STATE(2831),
    [sym__statement] = STATE(2831),
    [sym_defer_statement] = STATE(2831),
    [sym_using_statement] = STATE(2831),
    [sym_return_statement] = STATE(2831),
    [sym_block_statement] = STATE(2831),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2831),
    [sym_var_declaration] = STATE(2831),
    [sym_const_declaration] = STATE(2831),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1351),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1351),
    [sym_ternary_expression] = STATE(1351),
    [sym_index_expression] = STATE(1351),
    [sym__parenthesized_expression] = STATE(1351),
    [sym_proc_literal] = STATE(1351),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1351),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1332),
    [sym_initializer_list] = STATE(3127),
    [sym_single_assignment] = STATE(2609),
    [sym_assignment_statement] = STATE(2831),
    [sym__expression_pack] = STATE(2287),
    [sym_case_statement] = STATE(23),
    [sym_continue_statement] = STATE(2831),
    [sym_break_statement] = STATE(2831),
    [sym_if_statement] = STATE(2831),
    [sym_switch_statement] = STATE(2831),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2831),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1351),
    [sym_left_unary_expression] = STATE(1351),
    [sym_binary_expression] = STATE(1351),
    [sym_compound_literal] = STATE(1351),
    [sym_interpreted_string_literal] = STATE(1351),
    [sym_bool_literal] = STATE(1351),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym__switch_block_repeat1] = STATE(2832),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(87),
    [sym_float_literal] = ACTIONS(87),
    [sym_rune_literal] = ACTIONS(87),
    [sym_nil] = ACTIONS(87),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [6] = {
    [sym__simple_type] = STATE(1630),
    [sym_generic_type] = STATE(1630),
    [sym_pointer_type] = STATE(1630),
    [sym__pointer_directive] = STATE(2822),
    [sym_bit_set_type] = STATE(1630),
    [sym_matrix_type] = STATE(1630),
    [sym_array_type] = STATE(1630),
    [sym__array_directive] = STATE(2546),
    [sym_union_type] = STATE(1630),
    [sym_enum_type] = STATE(1630),
    [sym_struct_type] = STATE(1630),
    [sym_map_type] = STATE(1630),
    [sym__expression] = STATE(2280),
    [sym__type_directive] = STATE(872),
    [sym_selector_expression] = STATE(1281),
    [sym_type_conversion] = STATE(2280),
    [sym_ternary_expression] = STATE(2280),
    [sym_index_expression] = STATE(2280),
    [sym__parenthesized_expression] = STATE(2280),
    [sym_proc_literal] = STATE(2280),
    [sym__proc_directive] = STATE(2464),
    [sym_proc_group] = STATE(2280),
    [sym__proc_type] = STATE(982),
    [sym_proc_call] = STATE(1289),
    [sym_right_unary_expression] = STATE(2280),
    [sym_left_unary_expression] = STATE(2280),
    [sym_binary_expression] = STATE(2280),
    [sym_compound_literal] = STATE(2280),
    [sym_interpreted_string_literal] = STATE(2280),
    [sym_bool_literal] = STATE(2280),
    [aux_sym_pointer_type_repeat1] = STATE(2822),
    [aux_sym_array_type_repeat1] = STATE(2546),
    [aux_sym_proc_literal_repeat1] = STATE(2464),
    [sym_identifier] = ACTIONS(101),
    [anon_sym_LF] = ACTIONS(103),
    [anon_sym_LBRACE] = ACTIONS(105),
    [anon_sym_RBRACE] = ACTIONS(105),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(105),
    [anon_sym_POUNDbounds_check] = ACTIONS(105),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(105),
    [anon_sym_int] = ACTIONS(107),
    [anon_sym_uint] = ACTIONS(107),
    [anon_sym_uintptr] = ACTIONS(107),
    [anon_sym_typeid] = ACTIONS(109),
    [anon_sym_rawptr] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_cstring] = ACTIONS(107),
    [anon_sym_i8] = ACTIONS(107),
    [anon_sym_u8] = ACTIONS(107),
    [anon_sym_bool] = ACTIONS(107),
    [anon_sym_b8] = ACTIONS(107),
    [anon_sym_b16] = ACTIONS(107),
    [anon_sym_b32] = ACTIONS(107),
    [anon_sym_b64] = ACTIONS(107),
    [anon_sym_i16] = ACTIONS(107),
    [anon_sym_i16le] = ACTIONS(107),
    [anon_sym_i16be] = ACTIONS(107),
    [anon_sym_i32] = ACTIONS(107),
    [anon_sym_i32le] = ACTIONS(107),
    [anon_sym_i32be] = ACTIONS(107),
    [anon_sym_i64] = ACTIONS(107),
    [anon_sym_i64le] = ACTIONS(107),
    [anon_sym_i64be] = ACTIONS(107),
    [anon_sym_i128] = ACTIONS(107),
    [anon_sym_i128le] = ACTIONS(107),
    [anon_sym_i128be] = ACTIONS(107),
    [anon_sym_u16] = ACTIONS(107),
    [anon_sym_u16le] = ACTIONS(107),
    [anon_sym_u16be] = ACTIONS(107),
    [anon_sym_u32] = ACTIONS(107),
    [anon_sym_u32le] = ACTIONS(107),
    [anon_sym_u32be] = ACTIONS(107),
    [anon_sym_u64] = ACTIONS(107),
    [anon_sym_u64le] = ACTIONS(107),
    [anon_sym_u64be] = ACTIONS(107),
    [anon_sym_u128] = ACTIONS(107),
    [anon_sym_u128le] = ACTIONS(107),
    [anon_sym_u128be] = ACTIONS(107),
    [anon_sym_f16] = ACTIONS(107),
    [anon_sym_f16le] = ACTIONS(107),
    [anon_sym_f16be] = ACTIONS(107),
    [anon_sym_f32] = ACTIONS(107),
    [anon_sym_f32le] = ACTIONS(107),
    [anon_sym_f32be] = ACTIONS(107),
    [anon_sym_f64] = ACTIONS(107),
    [anon_sym_f64le] = ACTIONS(107),
    [anon_sym_f64be] = ACTIONS(107),
    [anon_sym_complex32] = ACTIONS(107),
    [anon_sym_complex64] = ACTIONS(107),
    [anon_sym_complex128] = ACTIONS(107),
    [anon_sym_quaternion64] = ACTIONS(107),
    [anon_sym_quaternion128] = ACTIONS(107),
    [anon_sym_quaternion256] = ACTIONS(107),
    [anon_sym_SLASH] = ACTIONS(105),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_CARET] = ACTIONS(105),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(113),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_matrix] = ACTIONS(115),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(117),
    [anon_sym_enum] = ACTIONS(119),
    [anon_sym_struct] = ACTIONS(121),
    [anon_sym_map] = ACTIONS(123),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(105),
    [anon_sym_cast] = ACTIONS(125),
    [anon_sym_transmute] = ACTIONS(125),
    [anon_sym_auto_cast] = ACTIONS(127),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_DASH_DASH_DASH] = ACTIONS(105),
    [anon_sym_where] = ACTIONS(105),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_BANG] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(105),
    [anon_sym_STAR_EQ] = ACTIONS(105),
    [anon_sym_SLASH_EQ] = ACTIONS(105),
    [anon_sym_PERCENT_EQ] = ACTIONS(105),
    [anon_sym_PERCENT_PERCENT_EQ] = ACTIONS(105),
    [anon_sym_LT_LT_EQ] = ACTIONS(105),
    [anon_sym_GT_GT_EQ] = ACTIONS(105),
    [anon_sym_AMP_EQ] = ACTIONS(105),
    [anon_sym_AMP_TILDE_EQ] = ACTIONS(105),
    [anon_sym_PLUS_EQ] = ACTIONS(105),
    [anon_sym_DASH_EQ] = ACTIONS(105),
    [anon_sym_TILDE_EQ] = ACTIONS(105),
    [anon_sym_PIPE_EQ] = ACTIONS(105),
    [anon_sym_do] = ACTIONS(105),
    [anon_sym_in] = ACTIONS(105),
    [anon_sym_or_return] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(105),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_AMP] = ACTIONS(105),
    [anon_sym_or_else] = ACTIONS(105),
    [anon_sym_STAR] = ACTIONS(105),
    [anon_sym_PERCENT] = ACTIONS(105),
    [anon_sym_PERCENT_PERCENT] = ACTIONS(105),
    [anon_sym_LT_LT] = ACTIONS(105),
    [anon_sym_GT_GT] = ACTIONS(105),
    [anon_sym_AMP_TILDE] = ACTIONS(105),
    [anon_sym_not_in] = ACTIONS(105),
    [anon_sym_PIPE] = ACTIONS(105),
    [anon_sym_GT] = ACTIONS(105),
    [anon_sym_LT] = ACTIONS(105),
    [anon_sym_LT_EQ] = ACTIONS(105),
    [anon_sym_GT_EQ] = ACTIONS(105),
    [anon_sym_EQ_EQ] = ACTIONS(105),
    [anon_sym_BANG_EQ] = ACTIONS(105),
    [anon_sym_DOT_DOT_LT] = ACTIONS(105),
    [anon_sym_DOT_DOT_EQ] = ACTIONS(105),
    [anon_sym_AMP_AMP] = ACTIONS(105),
    [anon_sym_PIPE_PIPE] = ACTIONS(105),
    [sym_builtin_procedure] = ACTIONS(133),
    [sym_raw_string_literal] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_int_literal] = ACTIONS(135),
    [sym_float_literal] = ACTIONS(135),
    [sym_rune_literal] = ACTIONS(135),
    [sym_nil] = ACTIONS(135),
    [sym__true] = ACTIONS(139),
    [sym__false] = ACTIONS(139),
    [sym_comment] = ACTIONS(93),
  },
  [7] = {
    [sym__simple_type] = STATE(1630),
    [sym_generic_type] = STATE(1630),
    [sym_pointer_type] = STATE(1630),
    [sym__pointer_directive] = STATE(2822),
    [sym_bit_set_type] = STATE(1630),
    [sym_matrix_type] = STATE(1630),
    [sym_array_type] = STATE(1630),
    [sym__array_directive] = STATE(2546),
    [sym_union_type] = STATE(1630),
    [sym_enum_type] = STATE(1630),
    [sym_struct_type] = STATE(1630),
    [sym_map_type] = STATE(1630),
    [sym__expression] = STATE(2280),
    [sym__type_directive] = STATE(872),
    [sym_selector_expression] = STATE(1281),
    [sym_type_conversion] = STATE(2280),
    [sym_ternary_expression] = STATE(2280),
    [sym_index_expression] = STATE(2280),
    [sym__parenthesized_expression] = STATE(2280),
    [sym_proc_literal] = STATE(2280),
    [sym__proc_directive] = STATE(2464),
    [sym_proc_group] = STATE(2280),
    [sym__proc_type] = STATE(982),
    [sym_proc_call] = STATE(1289),
    [sym_right_unary_expression] = STATE(2280),
    [sym_left_unary_expression] = STATE(2280),
    [sym_binary_expression] = STATE(2280),
    [sym_compound_literal] = STATE(2280),
    [sym_interpreted_string_literal] = STATE(2280),
    [sym_bool_literal] = STATE(2280),
    [aux_sym_pointer_type_repeat1] = STATE(2822),
    [aux_sym_array_type_repeat1] = STATE(2546),
    [aux_sym_proc_literal_repeat1] = STATE(2464),
    [sym_identifier] = ACTIONS(101),
    [anon_sym_LF] = ACTIONS(141),
    [anon_sym_LBRACE] = ACTIONS(143),
    [anon_sym_RBRACE] = ACTIONS(143),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(143),
    [anon_sym_POUNDbounds_check] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_int] = ACTIONS(107),
    [anon_sym_uint] = ACTIONS(107),
    [anon_sym_uintptr] = ACTIONS(107),
    [anon_sym_typeid] = ACTIONS(109),
    [anon_sym_rawptr] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_cstring] = ACTIONS(107),
    [anon_sym_i8] = ACTIONS(107),
    [anon_sym_u8] = ACTIONS(107),
    [anon_sym_bool] = ACTIONS(107),
    [anon_sym_b8] = ACTIONS(107),
    [anon_sym_b16] = ACTIONS(107),
    [anon_sym_b32] = ACTIONS(107),
    [anon_sym_b64] = ACTIONS(107),
    [anon_sym_i16] = ACTIONS(107),
    [anon_sym_i16le] = ACTIONS(107),
    [anon_sym_i16be] = ACTIONS(107),
    [anon_sym_i32] = ACTIONS(107),
    [anon_sym_i32le] = ACTIONS(107),
    [anon_sym_i32be] = ACTIONS(107),
    [anon_sym_i64] = ACTIONS(107),
    [anon_sym_i64le] = ACTIONS(107),
    [anon_sym_i64be] = ACTIONS(107),
    [anon_sym_i128] = ACTIONS(107),
    [anon_sym_i128le] = ACTIONS(107),
    [anon_sym_i128be] = ACTIONS(107),
    [anon_sym_u16] = ACTIONS(107),
    [anon_sym_u16le] = ACTIONS(107),
    [anon_sym_u16be] = ACTIONS(107),
    [anon_sym_u32] = ACTIONS(107),
    [anon_sym_u32le] = ACTIONS(107),
    [anon_sym_u32be] = ACTIONS(107),
    [anon_sym_u64] = ACTIONS(107),
    [anon_sym_u64le] = ACTIONS(107),
    [anon_sym_u64be] = ACTIONS(107),
    [anon_sym_u128] = ACTIONS(107),
    [anon_sym_u128le] = ACTIONS(107),
    [anon_sym_u128be] = ACTIONS(107),
    [anon_sym_f16] = ACTIONS(107),
    [anon_sym_f16le] = ACTIONS(107),
    [anon_sym_f16be] = ACTIONS(107),
    [anon_sym_f32] = ACTIONS(107),
    [anon_sym_f32le] = ACTIONS(107),
    [anon_sym_f32be] = ACTIONS(107),
    [anon_sym_f64] = ACTIONS(107),
    [anon_sym_f64le] = ACTIONS(107),
    [anon_sym_f64be] = ACTIONS(107),
    [anon_sym_complex32] = ACTIONS(107),
    [anon_sym_complex64] = ACTIONS(107),
    [anon_sym_complex128] = ACTIONS(107),
    [anon_sym_quaternion64] = ACTIONS(107),
    [anon_sym_quaternion128] = ACTIONS(107),
    [anon_sym_quaternion256] = ACTIONS(107),
    [anon_sym_SLASH] = ACTIONS(143),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_CARET] = ACTIONS(143),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(113),
    [anon_sym_LBRACK] = ACTIONS(143),
    [anon_sym_matrix] = ACTIONS(115),
    [anon_sym_QMARK] = ACTIONS(143),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(117),
    [anon_sym_enum] = ACTIONS(119),
    [anon_sym_struct] = ACTIONS(121),
    [anon_sym_map] = ACTIONS(123),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(143),
    [anon_sym_cast] = ACTIONS(125),
    [anon_sym_transmute] = ACTIONS(125),
    [anon_sym_auto_cast] = ACTIONS(127),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_DASH_DASH_DASH] = ACTIONS(143),
    [anon_sym_where] = ACTIONS(143),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(143),
    [anon_sym_STAR_EQ] = ACTIONS(143),
    [anon_sym_SLASH_EQ] = ACTIONS(143),
    [anon_sym_PERCENT_EQ] = ACTIONS(143),
    [anon_sym_PERCENT_PERCENT_EQ] = ACTIONS(143),
    [anon_sym_LT_LT_EQ] = ACTIONS(143),
    [anon_sym_GT_GT_EQ] = ACTIONS(143),
    [anon_sym_AMP_EQ] = ACTIONS(143),
    [anon_sym_AMP_TILDE_EQ] = ACTIONS(143),
    [anon_sym_PLUS_EQ] = ACTIONS(143),
    [anon_sym_DASH_EQ] = ACTIONS(143),
    [anon_sym_TILDE_EQ] = ACTIONS(143),
    [anon_sym_PIPE_EQ] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_in] = ACTIONS(143),
    [anon_sym_or_return] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(143),
    [anon_sym_AMP] = ACTIONS(143),
    [anon_sym_or_else] = ACTIONS(143),
    [anon_sym_STAR] = ACTIONS(143),
    [anon_sym_PERCENT] = ACTIONS(143),
    [anon_sym_PERCENT_PERCENT] = ACTIONS(143),
    [anon_sym_LT_LT] = ACTIONS(143),
    [anon_sym_GT_GT] = ACTIONS(143),
    [anon_sym_AMP_TILDE] = ACTIONS(143),
    [anon_sym_not_in] = ACTIONS(143),
    [anon_sym_PIPE] = ACTIONS(143),
    [anon_sym_GT] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(143),
    [anon_sym_LT_EQ] = ACTIONS(143),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_EQ_EQ] = ACTIONS(143),
    [anon_sym_BANG_EQ] = ACTIONS(143),
    [anon_sym_DOT_DOT_LT] = ACTIONS(143),
    [anon_sym_DOT_DOT_EQ] = ACTIONS(143),
    [anon_sym_AMP_AMP] = ACTIONS(143),
    [anon_sym_PIPE_PIPE] = ACTIONS(143),
    [sym_builtin_procedure] = ACTIONS(133),
    [sym_raw_string_literal] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_int_literal] = ACTIONS(135),
    [sym_float_literal] = ACTIONS(135),
    [sym_rune_literal] = ACTIONS(135),
    [sym_nil] = ACTIONS(135),
    [sym__true] = ACTIONS(139),
    [sym__false] = ACTIONS(139),
    [sym_comment] = ACTIONS(93),
  },
  [8] = {
    [sym__simple_statement] = STATE(2811),
    [sym__statement] = STATE(2811),
    [sym_defer_statement] = STATE(2811),
    [sym_using_statement] = STATE(2811),
    [sym_return_statement] = STATE(2811),
    [sym_block_statement] = STATE(2811),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2811),
    [sym_var_declaration] = STATE(2811),
    [sym_const_declaration] = STATE(2811),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1351),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1351),
    [sym_ternary_expression] = STATE(1351),
    [sym_index_expression] = STATE(1351),
    [sym__parenthesized_expression] = STATE(1351),
    [sym_proc_literal] = STATE(1351),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1351),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1332),
    [sym_initializer_list] = STATE(3127),
    [sym_single_assignment] = STATE(2609),
    [sym_assignment_statement] = STATE(2811),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2811),
    [sym_break_statement] = STATE(2811),
    [sym_if_statement] = STATE(2811),
    [sym_switch_statement] = STATE(2811),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2811),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1351),
    [sym_left_unary_expression] = STATE(1351),
    [sym_binary_expression] = STATE(1351),
    [sym_compound_literal] = STATE(1351),
    [sym_interpreted_string_literal] = STATE(1351),
    [sym_bool_literal] = STATE(1351),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2817),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(149),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(87),
    [sym_float_literal] = ACTIONS(87),
    [sym_rune_literal] = ACTIONS(87),
    [sym_nil] = ACTIONS(87),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [9] = {
    [sym__simple_type] = STATE(1630),
    [sym_generic_type] = STATE(1630),
    [sym_pointer_type] = STATE(1630),
    [sym__pointer_directive] = STATE(2822),
    [sym_bit_set_type] = STATE(1630),
    [sym_matrix_type] = STATE(1630),
    [sym_array_type] = STATE(1630),
    [sym__array_directive] = STATE(2546),
    [sym_union_type] = STATE(1630),
    [sym_enum_type] = STATE(1630),
    [sym_struct_type] = STATE(1630),
    [sym_map_type] = STATE(1630),
    [sym__expression] = STATE(2280),
    [sym__type_directive] = STATE(872),
    [sym_selector_expression] = STATE(1281),
    [sym_type_conversion] = STATE(2280),
    [sym_ternary_expression] = STATE(2280),
    [sym_index_expression] = STATE(2280),
    [sym__parenthesized_expression] = STATE(2280),
    [sym_proc_literal] = STATE(2280),
    [sym__proc_directive] = STATE(2464),
    [sym_proc_group] = STATE(2280),
    [sym__proc_type] = STATE(982),
    [sym_proc_call] = STATE(1289),
    [sym_right_unary_expression] = STATE(2280),
    [sym_left_unary_expression] = STATE(2280),
    [sym_binary_expression] = STATE(2280),
    [sym_compound_literal] = STATE(2280),
    [sym_interpreted_string_literal] = STATE(2280),
    [sym_bool_literal] = STATE(2280),
    [aux_sym_pointer_type_repeat1] = STATE(2822),
    [aux_sym_array_type_repeat1] = STATE(2546),
    [aux_sym_proc_literal_repeat1] = STATE(2464),
    [sym_identifier] = ACTIONS(101),
    [anon_sym_LF] = ACTIONS(141),
    [anon_sym_SEMI] = ACTIONS(143),
    [anon_sym_LBRACE] = ACTIONS(143),
    [anon_sym_RBRACE] = ACTIONS(143),
    [anon_sym_COLON] = ACTIONS(143),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(143),
    [anon_sym_POUNDbounds_check] = ACTIONS(143),
    [anon_sym_LPAREN] = ACTIONS(143),
    [anon_sym_EQ] = ACTIONS(143),
    [anon_sym_COMMA] = ACTIONS(143),
    [anon_sym_RPAREN] = ACTIONS(143),
    [anon_sym_int] = ACTIONS(107),
    [anon_sym_uint] = ACTIONS(107),
    [anon_sym_uintptr] = ACTIONS(107),
    [anon_sym_typeid] = ACTIONS(109),
    [anon_sym_rawptr] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_cstring] = ACTIONS(107),
    [anon_sym_i8] = ACTIONS(107),
    [anon_sym_u8] = ACTIONS(107),
    [anon_sym_bool] = ACTIONS(107),
    [anon_sym_b8] = ACTIONS(107),
    [anon_sym_b16] = ACTIONS(107),
    [anon_sym_b32] = ACTIONS(107),
    [anon_sym_b64] = ACTIONS(107),
    [anon_sym_i16] = ACTIONS(107),
    [anon_sym_i16le] = ACTIONS(107),
    [anon_sym_i16be] = ACTIONS(107),
    [anon_sym_i32] = ACTIONS(107),
    [anon_sym_i32le] = ACTIONS(107),
    [anon_sym_i32be] = ACTIONS(107),
    [anon_sym_i64] = ACTIONS(107),
    [anon_sym_i64le] = ACTIONS(107),
    [anon_sym_i64be] = ACTIONS(107),
    [anon_sym_i128] = ACTIONS(107),
    [anon_sym_i128le] = ACTIONS(107),
    [anon_sym_i128be] = ACTIONS(107),
    [anon_sym_u16] = ACTIONS(107),
    [anon_sym_u16le] = ACTIONS(107),
    [anon_sym_u16be] = ACTIONS(107),
    [anon_sym_u32] = ACTIONS(107),
    [anon_sym_u32le] = ACTIONS(107),
    [anon_sym_u32be] = ACTIONS(107),
    [anon_sym_u64] = ACTIONS(107),
    [anon_sym_u64le] = ACTIONS(107),
    [anon_sym_u64be] = ACTIONS(107),
    [anon_sym_u128] = ACTIONS(107),
    [anon_sym_u128le] = ACTIONS(107),
    [anon_sym_u128be] = ACTIONS(107),
    [anon_sym_f16] = ACTIONS(107),
    [anon_sym_f16le] = ACTIONS(107),
    [anon_sym_f16be] = ACTIONS(107),
    [anon_sym_f32] = ACTIONS(107),
    [anon_sym_f32le] = ACTIONS(107),
    [anon_sym_f32be] = ACTIONS(107),
    [anon_sym_f64] = ACTIONS(107),
    [anon_sym_f64le] = ACTIONS(107),
    [anon_sym_f64be] = ACTIONS(107),
    [anon_sym_complex32] = ACTIONS(107),
    [anon_sym_complex64] = ACTIONS(107),
    [anon_sym_complex128] = ACTIONS(107),
    [anon_sym_quaternion64] = ACTIONS(107),
    [anon_sym_quaternion128] = ACTIONS(107),
    [anon_sym_quaternion256] = ACTIONS(107),
    [anon_sym_SLASH] = ACTIONS(143),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_CARET] = ACTIONS(143),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(113),
    [anon_sym_LBRACK] = ACTIONS(143),
    [anon_sym_RBRACK] = ACTIONS(143),
    [anon_sym_matrix] = ACTIONS(115),
    [anon_sym_QMARK] = ACTIONS(143),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(117),
    [anon_sym_POUNDno_nil] = ACTIONS(143),
    [anon_sym_POUNDshared_nil] = ACTIONS(143),
    [anon_sym_POUNDalign] = ACTIONS(143),
    [anon_sym_enum] = ACTIONS(119),
    [anon_sym_struct] = ACTIONS(121),
    [anon_sym_POUNDno_copy] = ACTIONS(143),
    [anon_sym_POUNDpacked] = ACTIONS(143),
    [anon_sym_POUNDraw_union] = ACTIONS(143),
    [anon_sym_map] = ACTIONS(123),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(143),
    [anon_sym_cast] = ACTIONS(125),
    [anon_sym_transmute] = ACTIONS(125),
    [anon_sym_auto_cast] = ACTIONS(127),
    [anon_sym_if] = ACTIONS(143),
    [anon_sym_else] = ACTIONS(143),
    [anon_sym_DASH_DASH_DASH] = ACTIONS(143),
    [anon_sym_where] = ACTIONS(143),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(143),
    [anon_sym_BANG] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(143),
    [anon_sym_do] = ACTIONS(143),
    [anon_sym_in] = ACTIONS(143),
    [anon_sym_or_return] = ACTIONS(143),
    [anon_sym_PLUS] = ACTIONS(143),
    [anon_sym_DASH] = ACTIONS(143),
    [anon_sym_TILDE] = ACTIONS(143),
    [anon_sym_AMP] = ACTIONS(143),
    [anon_sym_or_else] = ACTIONS(143),
    [anon_sym_STAR] = ACTIONS(143),
    [anon_sym_PERCENT] = ACTIONS(143),
    [anon_sym_PERCENT_PERCENT] = ACTIONS(143),
    [anon_sym_LT_LT] = ACTIONS(143),
    [anon_sym_GT_GT] = ACTIONS(143),
    [anon_sym_AMP_TILDE] = ACTIONS(143),
    [anon_sym_not_in] = ACTIONS(143),
    [anon_sym_PIPE] = ACTIONS(143),
    [anon_sym_GT] = ACTIONS(143),
    [anon_sym_LT] = ACTIONS(143),
    [anon_sym_LT_EQ] = ACTIONS(143),
    [anon_sym_GT_EQ] = ACTIONS(143),
    [anon_sym_EQ_EQ] = ACTIONS(143),
    [anon_sym_BANG_EQ] = ACTIONS(143),
    [anon_sym_DOT_DOT_LT] = ACTIONS(143),
    [anon_sym_DOT_DOT_EQ] = ACTIONS(143),
    [anon_sym_AMP_AMP] = ACTIONS(143),
    [anon_sym_PIPE_PIPE] = ACTIONS(143),
    [sym_builtin_procedure] = ACTIONS(133),
    [sym_raw_string_literal] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_int_literal] = ACTIONS(135),
    [sym_float_literal] = ACTIONS(135),
    [sym_rune_literal] = ACTIONS(135),
    [sym_nil] = ACTIONS(135),
    [sym__true] = ACTIONS(139),
    [sym__false] = ACTIONS(139),
    [sym_comment] = ACTIONS(93),
  },
  [10] = {
    [sym__simple_statement] = STATE(2757),
    [sym__statement] = STATE(2757),
    [sym_defer_statement] = STATE(2757),
    [sym_using_statement] = STATE(2757),
    [sym_return_statement] = STATE(2757),
    [sym_block_statement] = STATE(2757),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2757),
    [sym_var_declaration] = STATE(2757),
    [sym_const_declaration] = STATE(2757),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1351),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1351),
    [sym_ternary_expression] = STATE(1351),
    [sym_index_expression] = STATE(1351),
    [sym__parenthesized_expression] = STATE(1351),
    [sym_proc_literal] = STATE(1351),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1351),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1332),
    [sym_initializer_list] = STATE(3127),
    [sym_single_assignment] = STATE(2609),
    [sym_assignment_statement] = STATE(2757),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2757),
    [sym_break_statement] = STATE(2757),
    [sym_if_statement] = STATE(2757),
    [sym_switch_statement] = STATE(2757),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2757),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1351),
    [sym_left_unary_expression] = STATE(1351),
    [sym_binary_expression] = STATE(1351),
    [sym_compound_literal] = STATE(1351),
    [sym_interpreted_string_literal] = STATE(1351),
    [sym_bool_literal] = STATE(1351),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2756),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(151),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(87),
    [sym_float_literal] = ACTIONS(87),
    [sym_rune_literal] = ACTIONS(87),
    [sym_nil] = ACTIONS(87),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [11] = {
    [sym__simple_type] = STATE(1630),
    [sym_generic_type] = STATE(1630),
    [sym_pointer_type] = STATE(1630),
    [sym__pointer_directive] = STATE(2822),
    [sym_bit_set_type] = STATE(1630),
    [sym_matrix_type] = STATE(1630),
    [sym_array_type] = STATE(1630),
    [sym__array_directive] = STATE(2546),
    [sym_union_type] = STATE(1630),
    [sym_enum_type] = STATE(1630),
    [sym_struct_type] = STATE(1630),
    [sym_map_type] = STATE(1630),
    [sym__expression] = STATE(2280),
    [sym__type_directive] = STATE(872),
    [sym_selector_expression] = STATE(1281),
    [sym_type_conversion] = STATE(2280),
    [sym_ternary_expression] = STATE(2280),
    [sym_index_expression] = STATE(2280),
    [sym__parenthesized_expression] = STATE(2280),
    [sym_proc_literal] = STATE(2280),
    [sym__proc_directive] = STATE(2464),
    [sym_proc_group] = STATE(2280),
    [sym__proc_type] = STATE(982),
    [sym_proc_call] = STATE(1289),
    [sym_right_unary_expression] = STATE(2280),
    [sym_left_unary_expression] = STATE(2280),
    [sym_binary_expression] = STATE(2280),
    [sym_compound_literal] = STATE(2280),
    [sym_interpreted_string_literal] = STATE(2280),
    [sym_bool_literal] = STATE(2280),
    [aux_sym_pointer_type_repeat1] = STATE(2822),
    [aux_sym_array_type_repeat1] = STATE(2546),
    [aux_sym_proc_literal_repeat1] = STATE(2464),
    [sym_identifier] = ACTIONS(101),
    [anon_sym_LF] = ACTIONS(103),
    [anon_sym_SEMI] = ACTIONS(105),
    [anon_sym_LBRACE] = ACTIONS(105),
    [anon_sym_RBRACE] = ACTIONS(105),
    [anon_sym_COLON] = ACTIONS(105),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(105),
    [anon_sym_POUNDbounds_check] = ACTIONS(105),
    [anon_sym_LPAREN] = ACTIONS(105),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_COMMA] = ACTIONS(105),
    [anon_sym_RPAREN] = ACTIONS(105),
    [anon_sym_int] = ACTIONS(107),
    [anon_sym_uint] = ACTIONS(107),
    [anon_sym_uintptr] = ACTIONS(107),
    [anon_sym_typeid] = ACTIONS(109),
    [anon_sym_rawptr] = ACTIONS(107),
    [anon_sym_string] = ACTIONS(107),
    [anon_sym_cstring] = ACTIONS(107),
    [anon_sym_i8] = ACTIONS(107),
    [anon_sym_u8] = ACTIONS(107),
    [anon_sym_bool] = ACTIONS(107),
    [anon_sym_b8] = ACTIONS(107),
    [anon_sym_b16] = ACTIONS(107),
    [anon_sym_b32] = ACTIONS(107),
    [anon_sym_b64] = ACTIONS(107),
    [anon_sym_i16] = ACTIONS(107),
    [anon_sym_i16le] = ACTIONS(107),
    [anon_sym_i16be] = ACTIONS(107),
    [anon_sym_i32] = ACTIONS(107),
    [anon_sym_i32le] = ACTIONS(107),
    [anon_sym_i32be] = ACTIONS(107),
    [anon_sym_i64] = ACTIONS(107),
    [anon_sym_i64le] = ACTIONS(107),
    [anon_sym_i64be] = ACTIONS(107),
    [anon_sym_i128] = ACTIONS(107),
    [anon_sym_i128le] = ACTIONS(107),
    [anon_sym_i128be] = ACTIONS(107),
    [anon_sym_u16] = ACTIONS(107),
    [anon_sym_u16le] = ACTIONS(107),
    [anon_sym_u16be] = ACTIONS(107),
    [anon_sym_u32] = ACTIONS(107),
    [anon_sym_u32le] = ACTIONS(107),
    [anon_sym_u32be] = ACTIONS(107),
    [anon_sym_u64] = ACTIONS(107),
    [anon_sym_u64le] = ACTIONS(107),
    [anon_sym_u64be] = ACTIONS(107),
    [anon_sym_u128] = ACTIONS(107),
    [anon_sym_u128le] = ACTIONS(107),
    [anon_sym_u128be] = ACTIONS(107),
    [anon_sym_f16] = ACTIONS(107),
    [anon_sym_f16le] = ACTIONS(107),
    [anon_sym_f16be] = ACTIONS(107),
    [anon_sym_f32] = ACTIONS(107),
    [anon_sym_f32le] = ACTIONS(107),
    [anon_sym_f32be] = ACTIONS(107),
    [anon_sym_f64] = ACTIONS(107),
    [anon_sym_f64le] = ACTIONS(107),
    [anon_sym_f64be] = ACTIONS(107),
    [anon_sym_complex32] = ACTIONS(107),
    [anon_sym_complex64] = ACTIONS(107),
    [anon_sym_complex128] = ACTIONS(107),
    [anon_sym_quaternion64] = ACTIONS(107),
    [anon_sym_quaternion128] = ACTIONS(107),
    [anon_sym_quaternion256] = ACTIONS(107),
    [anon_sym_SLASH] = ACTIONS(105),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [anon_sym_CARET] = ACTIONS(105),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(113),
    [anon_sym_LBRACK] = ACTIONS(105),
    [anon_sym_RBRACK] = ACTIONS(105),
    [anon_sym_matrix] = ACTIONS(115),
    [anon_sym_QMARK] = ACTIONS(105),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(117),
    [anon_sym_POUNDno_nil] = ACTIONS(105),
    [anon_sym_POUNDshared_nil] = ACTIONS(105),
    [anon_sym_POUNDalign] = ACTIONS(105),
    [anon_sym_enum] = ACTIONS(119),
    [anon_sym_struct] = ACTIONS(121),
    [anon_sym_POUNDno_copy] = ACTIONS(105),
    [anon_sym_POUNDpacked] = ACTIONS(105),
    [anon_sym_POUNDraw_union] = ACTIONS(105),
    [anon_sym_map] = ACTIONS(123),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(105),
    [anon_sym_cast] = ACTIONS(125),
    [anon_sym_transmute] = ACTIONS(125),
    [anon_sym_auto_cast] = ACTIONS(127),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_else] = ACTIONS(105),
    [anon_sym_DASH_DASH_DASH] = ACTIONS(105),
    [anon_sym_where] = ACTIONS(105),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(129),
    [anon_sym_DASH_GT] = ACTIONS(105),
    [anon_sym_BANG] = ACTIONS(131),
    [anon_sym_DOT_DOT] = ACTIONS(105),
    [anon_sym_do] = ACTIONS(105),
    [anon_sym_in] = ACTIONS(105),
    [anon_sym_or_return] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(105),
    [anon_sym_TILDE] = ACTIONS(105),
    [anon_sym_AMP] = ACTIONS(105),
    [anon_sym_or_else] = ACTIONS(105),
    [anon_sym_STAR] = ACTIONS(105),
    [anon_sym_PERCENT] = ACTIONS(105),
    [anon_sym_PERCENT_PERCENT] = ACTIONS(105),
    [anon_sym_LT_LT] = ACTIONS(105),
    [anon_sym_GT_GT] = ACTIONS(105),
    [anon_sym_AMP_TILDE] = ACTIONS(105),
    [anon_sym_not_in] = ACTIONS(105),
    [anon_sym_PIPE] = ACTIONS(105),
    [anon_sym_GT] = ACTIONS(105),
    [anon_sym_LT] = ACTIONS(105),
    [anon_sym_LT_EQ] = ACTIONS(105),
    [anon_sym_GT_EQ] = ACTIONS(105),
    [anon_sym_EQ_EQ] = ACTIONS(105),
    [anon_sym_BANG_EQ] = ACTIONS(105),
    [anon_sym_DOT_DOT_LT] = ACTIONS(105),
    [anon_sym_DOT_DOT_EQ] = ACTIONS(105),
    [anon_sym_AMP_AMP] = ACTIONS(105),
    [anon_sym_PIPE_PIPE] = ACTIONS(105),
    [sym_builtin_procedure] = ACTIONS(133),
    [sym_raw_string_literal] = ACTIONS(135),
    [anon_sym_DQUOTE] = ACTIONS(137),
    [sym_int_literal] = ACTIONS(135),
    [sym_float_literal] = ACTIONS(135),
    [sym_rune_literal] = ACTIONS(135),
    [sym_nil] = ACTIONS(135),
    [sym__true] = ACTIONS(139),
    [sym__false] = ACTIONS(139),
    [sym_comment] = ACTIONS(93),
  },
  [12] = {
    [sym__simple_statement] = STATE(2716),
    [sym__statement] = STATE(2716),
    [sym_defer_statement] = STATE(2716),
    [sym_using_statement] = STATE(2716),
    [sym_return_statement] = STATE(2716),
    [sym_block_statement] = STATE(2716),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2716),
    [sym_var_declaration] = STATE(2716),
    [sym_const_declaration] = STATE(2716),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2716),
    [sym__expression_pack] = STATE(2287),
    [sym_case_statement] = STATE(24),
    [sym_continue_statement] = STATE(2716),
    [sym_break_statement] = STATE(2716),
    [sym_if_statement] = STATE(2716),
    [sym_switch_statement] = STATE(2716),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2716),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym__switch_block_repeat1] = STATE(2719),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(153),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [13] = {
    [sym__simple_statement] = STATE(2831),
    [sym__statement] = STATE(2831),
    [sym_defer_statement] = STATE(2831),
    [sym_using_statement] = STATE(2831),
    [sym_return_statement] = STATE(2831),
    [sym_block_statement] = STATE(2831),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2831),
    [sym_var_declaration] = STATE(2831),
    [sym_const_declaration] = STATE(2831),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2831),
    [sym__expression_pack] = STATE(2287),
    [sym_case_statement] = STATE(23),
    [sym_continue_statement] = STATE(2831),
    [sym_break_statement] = STATE(2831),
    [sym_if_statement] = STATE(2831),
    [sym_switch_statement] = STATE(2831),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2831),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym__switch_block_repeat1] = STATE(2832),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(157),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [14] = {
    [sym__simple_statement] = STATE(2811),
    [sym__statement] = STATE(2811),
    [sym_defer_statement] = STATE(2811),
    [sym_using_statement] = STATE(2811),
    [sym_return_statement] = STATE(2811),
    [sym_block_statement] = STATE(2811),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2811),
    [sym_var_declaration] = STATE(2811),
    [sym_const_declaration] = STATE(2811),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1351),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1351),
    [sym_ternary_expression] = STATE(1351),
    [sym_index_expression] = STATE(1351),
    [sym__parenthesized_expression] = STATE(1351),
    [sym_proc_literal] = STATE(1351),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1351),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1332),
    [sym_initializer_list] = STATE(3262),
    [sym_single_assignment] = STATE(2609),
    [sym_assignment_statement] = STATE(2811),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2811),
    [sym_break_statement] = STATE(2811),
    [sym_if_statement] = STATE(2811),
    [sym_switch_statement] = STATE(2811),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2811),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1351),
    [sym_left_unary_expression] = STATE(1351),
    [sym_binary_expression] = STATE(1351),
    [sym_compound_literal] = STATE(1351),
    [sym_interpreted_string_literal] = STATE(1351),
    [sym_bool_literal] = STATE(1351),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2817),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(159),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(87),
    [sym_float_literal] = ACTIONS(87),
    [sym_rune_literal] = ACTIONS(87),
    [sym_nil] = ACTIONS(87),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [15] = {
    [sym__simple_statement] = STATE(2757),
    [sym__statement] = STATE(2757),
    [sym_defer_statement] = STATE(2757),
    [sym_using_statement] = STATE(2757),
    [sym_return_statement] = STATE(2757),
    [sym_block_statement] = STATE(2757),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2757),
    [sym_var_declaration] = STATE(2757),
    [sym_const_declaration] = STATE(2757),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1351),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1351),
    [sym_ternary_expression] = STATE(1351),
    [sym_index_expression] = STATE(1351),
    [sym__parenthesized_expression] = STATE(1351),
    [sym_proc_literal] = STATE(1351),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1351),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1332),
    [sym_initializer_list] = STATE(3262),
    [sym_single_assignment] = STATE(2609),
    [sym_assignment_statement] = STATE(2757),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2757),
    [sym_break_statement] = STATE(2757),
    [sym_if_statement] = STATE(2757),
    [sym_switch_statement] = STATE(2757),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2757),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1351),
    [sym_left_unary_expression] = STATE(1351),
    [sym_binary_expression] = STATE(1351),
    [sym_compound_literal] = STATE(1351),
    [sym_interpreted_string_literal] = STATE(1351),
    [sym_bool_literal] = STATE(1351),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2756),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(161),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(87),
    [sym_float_literal] = ACTIONS(87),
    [sym_rune_literal] = ACTIONS(87),
    [sym_nil] = ACTIONS(87),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [16] = {
    [sym__simple_statement] = STATE(2978),
    [sym__statement] = STATE(2978),
    [sym_defer_statement] = STATE(2978),
    [sym_using_statement] = STATE(2978),
    [sym_return_statement] = STATE(2978),
    [sym_block_statement] = STATE(2978),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2978),
    [sym_var_declaration] = STATE(2978),
    [sym_const_declaration] = STATE(2978),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2978),
    [sym__expression_pack] = STATE(2287),
    [sym_case_statement] = STATE(30),
    [sym_continue_statement] = STATE(2978),
    [sym_break_statement] = STATE(2978),
    [sym_if_statement] = STATE(2978),
    [sym_switch_statement] = STATE(2978),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2978),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(163),
    [anon_sym_SEMI] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(165),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [17] = {
    [sym__simple_statement] = STATE(2604),
    [sym__statement] = STATE(2604),
    [sym_defer_statement] = STATE(2604),
    [sym_using_statement] = STATE(2604),
    [sym_return_statement] = STATE(2604),
    [sym_block_statement] = STATE(2604),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2604),
    [sym_var_declaration] = STATE(2604),
    [sym_const_declaration] = STATE(2604),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2604),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2604),
    [sym_break_statement] = STATE(2604),
    [sym_if_statement] = STATE(2604),
    [sym_switch_statement] = STATE(2604),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2604),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2605),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(167),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [18] = {
    [sym__simple_statement] = STATE(2757),
    [sym__statement] = STATE(2757),
    [sym_defer_statement] = STATE(2757),
    [sym_using_statement] = STATE(2757),
    [sym_return_statement] = STATE(2757),
    [sym_block_statement] = STATE(2757),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2757),
    [sym_var_declaration] = STATE(2757),
    [sym_const_declaration] = STATE(2757),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2757),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2757),
    [sym_break_statement] = STATE(2757),
    [sym_if_statement] = STATE(2757),
    [sym_switch_statement] = STATE(2757),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2757),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2756),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(169),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [19] = {
    [sym__simple_statement] = STATE(2711),
    [sym__statement] = STATE(2711),
    [sym_defer_statement] = STATE(2711),
    [sym_using_statement] = STATE(2711),
    [sym_return_statement] = STATE(2711),
    [sym_block_statement] = STATE(2711),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2711),
    [sym_var_declaration] = STATE(2711),
    [sym_const_declaration] = STATE(2711),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2711),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2711),
    [sym_break_statement] = STATE(2711),
    [sym_if_statement] = STATE(2711),
    [sym_switch_statement] = STATE(2711),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2711),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2712),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(171),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [20] = {
    [sym__simple_statement] = STATE(2730),
    [sym__statement] = STATE(2730),
    [sym_defer_statement] = STATE(2730),
    [sym_using_statement] = STATE(2730),
    [sym_return_statement] = STATE(2730),
    [sym_block_statement] = STATE(2730),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2730),
    [sym_var_declaration] = STATE(2730),
    [sym_const_declaration] = STATE(2730),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2730),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2730),
    [sym_break_statement] = STATE(2730),
    [sym_if_statement] = STATE(2730),
    [sym_switch_statement] = STATE(2730),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2730),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2731),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(173),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [21] = {
    [sym__simple_statement] = STATE(2761),
    [sym__statement] = STATE(2761),
    [sym_defer_statement] = STATE(2761),
    [sym_using_statement] = STATE(2761),
    [sym_return_statement] = STATE(2761),
    [sym_block_statement] = STATE(2761),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2761),
    [sym_var_declaration] = STATE(2761),
    [sym_const_declaration] = STATE(2761),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2761),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2761),
    [sym_break_statement] = STATE(2761),
    [sym_if_statement] = STATE(2761),
    [sym_switch_statement] = STATE(2761),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2761),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2760),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(175),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [22] = {
    [sym__simple_statement] = STATE(2639),
    [sym__statement] = STATE(2639),
    [sym_defer_statement] = STATE(2639),
    [sym_using_statement] = STATE(2639),
    [sym_return_statement] = STATE(2639),
    [sym_block_statement] = STATE(2639),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2639),
    [sym_var_declaration] = STATE(2639),
    [sym_const_declaration] = STATE(2639),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2639),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2639),
    [sym_break_statement] = STATE(2639),
    [sym_if_statement] = STATE(2639),
    [sym_switch_statement] = STATE(2639),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2639),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2638),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(177),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [23] = {
    [sym__simple_statement] = STATE(2839),
    [sym__statement] = STATE(2839),
    [sym_defer_statement] = STATE(2839),
    [sym_using_statement] = STATE(2839),
    [sym_return_statement] = STATE(2839),
    [sym_block_statement] = STATE(2839),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2839),
    [sym_var_declaration] = STATE(2839),
    [sym_const_declaration] = STATE(2839),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2839),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2839),
    [sym_break_statement] = STATE(2839),
    [sym_if_statement] = STATE(2839),
    [sym_switch_statement] = STATE(2839),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2839),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym__switch_block_repeat1] = STATE(2837),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(179),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [24] = {
    [sym__simple_statement] = STATE(2848),
    [sym__statement] = STATE(2848),
    [sym_defer_statement] = STATE(2848),
    [sym_using_statement] = STATE(2848),
    [sym_return_statement] = STATE(2848),
    [sym_block_statement] = STATE(2848),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2848),
    [sym_var_declaration] = STATE(2848),
    [sym_const_declaration] = STATE(2848),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2848),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2848),
    [sym_break_statement] = STATE(2848),
    [sym_if_statement] = STATE(2848),
    [sym_switch_statement] = STATE(2848),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2848),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym__switch_block_repeat1] = STATE(2847),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_SEMI] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(181),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [25] = {
    [sym__simple_statement] = STATE(2634),
    [sym__statement] = STATE(2634),
    [sym_defer_statement] = STATE(2634),
    [sym_using_statement] = STATE(2634),
    [sym_return_statement] = STATE(2634),
    [sym_block_statement] = STATE(2634),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2634),
    [sym_var_declaration] = STATE(2634),
    [sym_const_declaration] = STATE(2634),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2634),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2634),
    [sym_break_statement] = STATE(2634),
    [sym_if_statement] = STATE(2634),
    [sym_switch_statement] = STATE(2634),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2634),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2668),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(183),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [26] = {
    [sym__simple_statement] = STATE(2816),
    [sym__statement] = STATE(2816),
    [sym_defer_statement] = STATE(2816),
    [sym_using_statement] = STATE(2816),
    [sym_return_statement] = STATE(2816),
    [sym_block_statement] = STATE(2816),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2816),
    [sym_var_declaration] = STATE(2816),
    [sym_const_declaration] = STATE(2816),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2816),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2816),
    [sym_break_statement] = STATE(2816),
    [sym_if_statement] = STATE(2816),
    [sym_switch_statement] = STATE(2816),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2816),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2812),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(185),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [27] = {
    [sym__simple_statement] = STATE(2784),
    [sym__statement] = STATE(2784),
    [sym_defer_statement] = STATE(2784),
    [sym_using_statement] = STATE(2784),
    [sym_return_statement] = STATE(2784),
    [sym_block_statement] = STATE(2784),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2784),
    [sym_var_declaration] = STATE(2784),
    [sym_const_declaration] = STATE(2784),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2784),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2784),
    [sym_break_statement] = STATE(2784),
    [sym_if_statement] = STATE(2784),
    [sym_switch_statement] = STATE(2784),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2784),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2787),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(187),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [28] = {
    [sym__simple_statement] = STATE(2811),
    [sym__statement] = STATE(2811),
    [sym_defer_statement] = STATE(2811),
    [sym_using_statement] = STATE(2811),
    [sym_return_statement] = STATE(2811),
    [sym_block_statement] = STATE(2811),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2811),
    [sym_var_declaration] = STATE(2811),
    [sym_const_declaration] = STATE(2811),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2811),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2811),
    [sym_break_statement] = STATE(2811),
    [sym_if_statement] = STATE(2811),
    [sym_switch_statement] = STATE(2811),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2811),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_block_repeat2] = STATE(2817),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(145),
    [anon_sym_SEMI] = ACTIONS(147),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(189),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [29] = {
    [sym__simple_statement] = STATE(3023),
    [sym__statement] = STATE(3023),
    [sym_defer_statement] = STATE(3023),
    [sym_using_statement] = STATE(3023),
    [sym_return_statement] = STATE(3023),
    [sym_block_statement] = STATE(3023),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(3023),
    [sym_var_declaration] = STATE(3023),
    [sym_const_declaration] = STATE(3023),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(3023),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(3023),
    [sym_break_statement] = STATE(3023),
    [sym_if_statement] = STATE(3023),
    [sym_switch_statement] = STATE(3023),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(3023),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(193),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(193),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [30] = {
    [sym__simple_statement] = STATE(2994),
    [sym__statement] = STATE(2994),
    [sym_defer_statement] = STATE(2994),
    [sym_using_statement] = STATE(2994),
    [sym_return_statement] = STATE(2994),
    [sym_block_statement] = STATE(2994),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2994),
    [sym_var_declaration] = STATE(2994),
    [sym_const_declaration] = STATE(2994),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2994),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2994),
    [sym_break_statement] = STATE(2994),
    [sym_if_statement] = STATE(2994),
    [sym_switch_statement] = STATE(2994),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2994),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(195),
    [anon_sym_SEMI] = ACTIONS(197),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(197),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(23),
    [anon_sym_POUNDbounds_check] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(35),
    [anon_sym_POUNDrelative] = ACTIONS(37),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(41),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(45),
    [anon_sym_POUNDsimd] = ACTIONS(45),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(55),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(65),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(65),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_DOT_DOT] = ACTIONS(69),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(83),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [sym_builtin_procedure] = ACTIONS(85),
    [sym_raw_string_literal] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(155),
    [sym_rune_literal] = ACTIONS(155),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(93),
  },
  [31] = {
    [sym__simple_statement] = STATE(2860),
    [sym__statement] = STATE(2860),
    [sym_defer_statement] = STATE(2860),
    [sym_using_statement] = STATE(2860),
    [sym_return_statement] = STATE(2860),
    [sym_block_statement] = STATE(2860),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2860),
    [sym_var_declaration] = STATE(2860),
    [sym_const_declaration] = STATE(2860),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2860),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2860),
    [sym_break_statement] = STATE(2860),
    [sym_if_statement] = STATE(2860),
    [sym_switch_statement] = STATE(2860),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2860),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__simple_statement] = STATE(2864),
    [sym__statement] = STATE(2864),
    [sym_defer_statement] = STATE(2864),
    [sym_using_statement] = STATE(2864),
    [sym_return_statement] = STATE(2864),
    [sym_block_statement] = STATE(2864),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2864),
    [sym_var_declaration] = STATE(2864),
    [sym_const_declaration] = STATE(2864),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2864),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2864),
    [sym_break_statement] = STATE(2864),
    [sym_if_statement] = STATE(2864),
    [sym_switch_statement] = STATE(2864),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2864),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__simple_statement] = STATE(2759),
    [sym__statement] = STATE(2759),
    [sym_defer_statement] = STATE(2759),
    [sym_using_statement] = STATE(2759),
    [sym_return_statement] = STATE(2759),
    [sym_block_statement] = STATE(2759),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2759),
    [sym_var_declaration] = STATE(2759),
    [sym_const_declaration] = STATE(2759),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2759),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2759),
    [sym_break_statement] = STATE(2759),
    [sym_if_statement] = STATE(2759),
    [sym_switch_statement] = STATE(2759),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2759),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__simple_statement] = STATE(2758),
    [sym__statement] = STATE(2758),
    [sym_defer_statement] = STATE(2758),
    [sym_using_statement] = STATE(2758),
    [sym_return_statement] = STATE(2758),
    [sym_block_statement] = STATE(2758),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2758),
    [sym_var_declaration] = STATE(2758),
    [sym_const_declaration] = STATE(2758),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2758),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2758),
    [sym_break_statement] = STATE(2758),
    [sym_if_statement] = STATE(2758),
    [sym_switch_statement] = STATE(2758),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2758),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__simple_statement] = STATE(2932),
    [sym__statement] = STATE(2932),
    [sym_defer_statement] = STATE(2932),
    [sym_using_statement] = STATE(2932),
    [sym_return_statement] = STATE(2932),
    [sym_block_statement] = STATE(2932),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2932),
    [sym_var_declaration] = STATE(2932),
    [sym_const_declaration] = STATE(2932),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2932),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2932),
    [sym_break_statement] = STATE(2932),
    [sym_if_statement] = STATE(2932),
    [sym_switch_statement] = STATE(2932),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2932),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__simple_statement] = STATE(2755),
    [sym__statement] = STATE(2755),
    [sym_defer_statement] = STATE(2755),
    [sym_using_statement] = STATE(2755),
    [sym_return_statement] = STATE(2755),
    [sym_block_statement] = STATE(2755),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2755),
    [sym_var_declaration] = STATE(2755),
    [sym_const_declaration] = STATE(2755),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2755),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2755),
    [sym_break_statement] = STATE(2755),
    [sym_if_statement] = STATE(2755),
    [sym_switch_statement] = STATE(2755),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2755),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__simple_statement] = STATE(3348),
    [sym__statement] = STATE(3348),
    [sym_defer_statement] = STATE(3348),
    [sym_using_statement] = STATE(3348),
    [sym_return_statement] = STATE(3348),
    [sym_block_statement] = STATE(3348),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3348),
    [sym_var_declaration] = STATE(3348),
    [sym_const_declaration] = STATE(3348),
    [sym__simple_type] = STATE(1062),
    [sym_generic_type] = STATE(1062),
    [sym_pointer_type] = STATE(1062),
    [sym__pointer_directive] = STATE(2818),
    [sym_bit_set_type] = STATE(1062),
    [sym_matrix_type] = STATE(1062),
    [sym_array_type] = STATE(1062),
    [sym__array_directive] = STATE(2543),
    [sym_union_type] = STATE(1062),
    [sym_enum_type] = STATE(1062),
    [sym_struct_type] = STATE(1062),
    [sym_map_type] = STATE(1062),
    [sym__expression] = STATE(1062),
    [sym__type_directive] = STATE(548),
    [sym_selector_expression] = STATE(1062),
    [sym_type_conversion] = STATE(1062),
    [sym_ternary_expression] = STATE(1062),
    [sym_index_expression] = STATE(1062),
    [sym__parenthesized_expression] = STATE(1062),
    [sym_proc_literal] = STATE(1062),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1062),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1205),
    [sym_assignment_statement] = STATE(3348),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3348),
    [sym_break_statement] = STATE(3348),
    [sym_if_statement] = STATE(3348),
    [sym_switch_statement] = STATE(3348),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3348),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1062),
    [sym_left_unary_expression] = STATE(1062),
    [sym_binary_expression] = STATE(1062),
    [sym_compound_literal] = STATE(1062),
    [sym_interpreted_string_literal] = STATE(1062),
    [sym_bool_literal] = STATE(1062),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2818),
    [aux_sym_array_type_repeat1] = STATE(2543),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(243),
    [anon_sym_uint] = ACTIONS(243),
    [anon_sym_uintptr] = ACTIONS(243),
    [anon_sym_typeid] = ACTIONS(245),
    [anon_sym_rawptr] = ACTIONS(243),
    [anon_sym_string] = ACTIONS(243),
    [anon_sym_cstring] = ACTIONS(243),
    [anon_sym_i8] = ACTIONS(243),
    [anon_sym_u8] = ACTIONS(243),
    [anon_sym_bool] = ACTIONS(243),
    [anon_sym_b8] = ACTIONS(243),
    [anon_sym_b16] = ACTIONS(243),
    [anon_sym_b32] = ACTIONS(243),
    [anon_sym_b64] = ACTIONS(243),
    [anon_sym_i16] = ACTIONS(243),
    [anon_sym_i16le] = ACTIONS(243),
    [anon_sym_i16be] = ACTIONS(243),
    [anon_sym_i32] = ACTIONS(243),
    [anon_sym_i32le] = ACTIONS(243),
    [anon_sym_i32be] = ACTIONS(243),
    [anon_sym_i64] = ACTIONS(243),
    [anon_sym_i64le] = ACTIONS(243),
    [anon_sym_i64be] = ACTIONS(243),
    [anon_sym_i128] = ACTIONS(243),
    [anon_sym_i128le] = ACTIONS(243),
    [anon_sym_i128be] = ACTIONS(243),
    [anon_sym_u16] = ACTIONS(243),
    [anon_sym_u16le] = ACTIONS(243),
    [anon_sym_u16be] = ACTIONS(243),
    [anon_sym_u32] = ACTIONS(243),
    [anon_sym_u32le] = ACTIONS(243),
    [anon_sym_u32be] = ACTIONS(243),
    [anon_sym_u64] = ACTIONS(243),
    [anon_sym_u64le] = ACTIONS(243),
    [anon_sym_u64be] = ACTIONS(243),
    [anon_sym_u128] = ACTIONS(243),
    [anon_sym_u128le] = ACTIONS(243),
    [anon_sym_u128be] = ACTIONS(243),
    [anon_sym_f16] = ACTIONS(243),
    [anon_sym_f16le] = ACTIONS(243),
    [anon_sym_f16be] = ACTIONS(243),
    [anon_sym_f32] = ACTIONS(243),
    [anon_sym_f32le] = ACTIONS(243),
    [anon_sym_f32be] = ACTIONS(243),
    [anon_sym_f64] = ACTIONS(243),
    [anon_sym_f64le] = ACTIONS(243),
    [anon_sym_f64be] = ACTIONS(243),
    [anon_sym_complex32] = ACTIONS(243),
    [anon_sym_complex64] = ACTIONS(243),
    [anon_sym_complex128] = ACTIONS(243),
    [anon_sym_quaternion64] = ACTIONS(243),
    [anon_sym_quaternion128] = ACTIONS(243),
    [anon_sym_quaternion256] = ACTIONS(243),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_CARET] = ACTIONS(249),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(251),
    [anon_sym_matrix] = ACTIONS(253),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(255),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(257),
    [anon_sym_transmute] = ACTIONS(257),
    [anon_sym_auto_cast] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(263),
    [anon_sym_DOT_DOT] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_DASH] = ACTIONS(263),
    [anon_sym_TILDE] = ACTIONS(263),
    [anon_sym_AMP] = ACTIONS(263),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(275),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(243),
    [sym_float_literal] = ACTIONS(275),
    [sym_rune_literal] = ACTIONS(275),
    [sym_nil] = ACTIONS(243),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__simple_statement] = STATE(2754),
    [sym__statement] = STATE(2754),
    [sym_defer_statement] = STATE(2754),
    [sym_using_statement] = STATE(2754),
    [sym_return_statement] = STATE(2754),
    [sym_block_statement] = STATE(2754),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2754),
    [sym_var_declaration] = STATE(2754),
    [sym_const_declaration] = STATE(2754),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2754),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2754),
    [sym_break_statement] = STATE(2754),
    [sym_if_statement] = STATE(2754),
    [sym_switch_statement] = STATE(2754),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2754),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__simple_statement] = STATE(2922),
    [sym__statement] = STATE(2922),
    [sym_defer_statement] = STATE(2922),
    [sym_using_statement] = STATE(2922),
    [sym_return_statement] = STATE(2922),
    [sym_block_statement] = STATE(2922),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2922),
    [sym_var_declaration] = STATE(2922),
    [sym_const_declaration] = STATE(2922),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2922),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2922),
    [sym_break_statement] = STATE(2922),
    [sym_if_statement] = STATE(2922),
    [sym_switch_statement] = STATE(2922),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2922),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__simple_statement] = STATE(2753),
    [sym__statement] = STATE(2753),
    [sym_defer_statement] = STATE(2753),
    [sym_using_statement] = STATE(2753),
    [sym_return_statement] = STATE(2753),
    [sym_block_statement] = STATE(2753),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2753),
    [sym_var_declaration] = STATE(2753),
    [sym_const_declaration] = STATE(2753),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2753),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2753),
    [sym_break_statement] = STATE(2753),
    [sym_if_statement] = STATE(2753),
    [sym_switch_statement] = STATE(2753),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2753),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__simple_statement] = STATE(2921),
    [sym__statement] = STATE(2921),
    [sym_defer_statement] = STATE(2921),
    [sym_using_statement] = STATE(2921),
    [sym_return_statement] = STATE(2921),
    [sym_block_statement] = STATE(2921),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2921),
    [sym_var_declaration] = STATE(2921),
    [sym_const_declaration] = STATE(2921),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2921),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2921),
    [sym_break_statement] = STATE(2921),
    [sym_if_statement] = STATE(2921),
    [sym_switch_statement] = STATE(2921),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2921),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__simple_statement] = STATE(2825),
    [sym__statement] = STATE(2825),
    [sym_defer_statement] = STATE(2825),
    [sym_using_statement] = STATE(2825),
    [sym_return_statement] = STATE(2825),
    [sym_block_statement] = STATE(2825),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2825),
    [sym_var_declaration] = STATE(2825),
    [sym_const_declaration] = STATE(2825),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2825),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2825),
    [sym_break_statement] = STATE(2825),
    [sym_if_statement] = STATE(2825),
    [sym_switch_statement] = STATE(2825),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2825),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__simple_statement] = STATE(2749),
    [sym__statement] = STATE(2749),
    [sym_defer_statement] = STATE(2749),
    [sym_using_statement] = STATE(2749),
    [sym_return_statement] = STATE(2749),
    [sym_block_statement] = STATE(2749),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2749),
    [sym_var_declaration] = STATE(2749),
    [sym_const_declaration] = STATE(2749),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2749),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2749),
    [sym_break_statement] = STATE(2749),
    [sym_if_statement] = STATE(2749),
    [sym_switch_statement] = STATE(2749),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2749),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__simple_statement] = STATE(2919),
    [sym__statement] = STATE(2919),
    [sym_defer_statement] = STATE(2919),
    [sym_using_statement] = STATE(2919),
    [sym_return_statement] = STATE(2919),
    [sym_block_statement] = STATE(2919),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2919),
    [sym_var_declaration] = STATE(2919),
    [sym_const_declaration] = STATE(2919),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2919),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2919),
    [sym_break_statement] = STATE(2919),
    [sym_if_statement] = STATE(2919),
    [sym_switch_statement] = STATE(2919),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2919),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__simple_statement] = STATE(3345),
    [sym__statement] = STATE(3345),
    [sym_defer_statement] = STATE(3345),
    [sym_using_statement] = STATE(3345),
    [sym_return_statement] = STATE(3345),
    [sym_block_statement] = STATE(3345),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3345),
    [sym_var_declaration] = STATE(3345),
    [sym_const_declaration] = STATE(3345),
    [sym__simple_type] = STATE(1051),
    [sym_generic_type] = STATE(1051),
    [sym_pointer_type] = STATE(1051),
    [sym__pointer_directive] = STATE(2818),
    [sym_bit_set_type] = STATE(1051),
    [sym_matrix_type] = STATE(1051),
    [sym_array_type] = STATE(1051),
    [sym__array_directive] = STATE(2543),
    [sym_union_type] = STATE(1051),
    [sym_enum_type] = STATE(1051),
    [sym_struct_type] = STATE(1051),
    [sym_map_type] = STATE(1051),
    [sym__expression] = STATE(1051),
    [sym__type_directive] = STATE(548),
    [sym_selector_expression] = STATE(1051),
    [sym_type_conversion] = STATE(1051),
    [sym_ternary_expression] = STATE(1051),
    [sym_index_expression] = STATE(1051),
    [sym__parenthesized_expression] = STATE(1051),
    [sym_proc_literal] = STATE(1051),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1051),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1205),
    [sym_assignment_statement] = STATE(3345),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3345),
    [sym_break_statement] = STATE(3345),
    [sym_if_statement] = STATE(3345),
    [sym_switch_statement] = STATE(3345),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3345),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1051),
    [sym_left_unary_expression] = STATE(1051),
    [sym_binary_expression] = STATE(1051),
    [sym_compound_literal] = STATE(1051),
    [sym_interpreted_string_literal] = STATE(1051),
    [sym_bool_literal] = STATE(1051),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2818),
    [aux_sym_array_type_repeat1] = STATE(2543),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(277),
    [anon_sym_uint] = ACTIONS(277),
    [anon_sym_uintptr] = ACTIONS(277),
    [anon_sym_typeid] = ACTIONS(245),
    [anon_sym_rawptr] = ACTIONS(277),
    [anon_sym_string] = ACTIONS(277),
    [anon_sym_cstring] = ACTIONS(277),
    [anon_sym_i8] = ACTIONS(277),
    [anon_sym_u8] = ACTIONS(277),
    [anon_sym_bool] = ACTIONS(277),
    [anon_sym_b8] = ACTIONS(277),
    [anon_sym_b16] = ACTIONS(277),
    [anon_sym_b32] = ACTIONS(277),
    [anon_sym_b64] = ACTIONS(277),
    [anon_sym_i16] = ACTIONS(277),
    [anon_sym_i16le] = ACTIONS(277),
    [anon_sym_i16be] = ACTIONS(277),
    [anon_sym_i32] = ACTIONS(277),
    [anon_sym_i32le] = ACTIONS(277),
    [anon_sym_i32be] = ACTIONS(277),
    [anon_sym_i64] = ACTIONS(277),
    [anon_sym_i64le] = ACTIONS(277),
    [anon_sym_i64be] = ACTIONS(277),
    [anon_sym_i128] = ACTIONS(277),
    [anon_sym_i128le] = ACTIONS(277),
    [anon_sym_i128be] = ACTIONS(277),
    [anon_sym_u16] = ACTIONS(277),
    [anon_sym_u16le] = ACTIONS(277),
    [anon_sym_u16be] = ACTIONS(277),
    [anon_sym_u32] = ACTIONS(277),
    [anon_sym_u32le] = ACTIONS(277),
    [anon_sym_u32be] = ACTIONS(277),
    [anon_sym_u64] = ACTIONS(277),
    [anon_sym_u64le] = ACTIONS(277),
    [anon_sym_u64be] = ACTIONS(277),
    [anon_sym_u128] = ACTIONS(277),
    [anon_sym_u128le] = ACTIONS(277),
    [anon_sym_u128be] = ACTIONS(277),
    [anon_sym_f16] = ACTIONS(277),
    [anon_sym_f16le] = ACTIONS(277),
    [anon_sym_f16be] = ACTIONS(277),
    [anon_sym_f32] = ACTIONS(277),
    [anon_sym_f32le] = ACTIONS(277),
    [anon_sym_f32be] = ACTIONS(277),
    [anon_sym_f64] = ACTIONS(277),
    [anon_sym_f64le] = ACTIONS(277),
    [anon_sym_f64be] = ACTIONS(277),
    [anon_sym_complex32] = ACTIONS(277),
    [anon_sym_complex64] = ACTIONS(277),
    [anon_sym_complex128] = ACTIONS(277),
    [anon_sym_quaternion64] = ACTIONS(277),
    [anon_sym_quaternion128] = ACTIONS(277),
    [anon_sym_quaternion256] = ACTIONS(277),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_CARET] = ACTIONS(249),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(251),
    [anon_sym_matrix] = ACTIONS(253),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(255),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(257),
    [anon_sym_transmute] = ACTIONS(257),
    [anon_sym_auto_cast] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(263),
    [anon_sym_DOT_DOT] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_DASH] = ACTIONS(263),
    [anon_sym_TILDE] = ACTIONS(263),
    [anon_sym_AMP] = ACTIONS(263),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(279),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(277),
    [sym_float_literal] = ACTIONS(279),
    [sym_rune_literal] = ACTIONS(279),
    [sym_nil] = ACTIONS(277),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__simple_statement] = STATE(2741),
    [sym__statement] = STATE(2741),
    [sym_defer_statement] = STATE(2741),
    [sym_using_statement] = STATE(2741),
    [sym_return_statement] = STATE(2741),
    [sym_block_statement] = STATE(2741),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2741),
    [sym_var_declaration] = STATE(2741),
    [sym_const_declaration] = STATE(2741),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2741),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2741),
    [sym_break_statement] = STATE(2741),
    [sym_if_statement] = STATE(2741),
    [sym_switch_statement] = STATE(2741),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2741),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__simple_statement] = STATE(2740),
    [sym__statement] = STATE(2740),
    [sym_defer_statement] = STATE(2740),
    [sym_using_statement] = STATE(2740),
    [sym_return_statement] = STATE(2740),
    [sym_block_statement] = STATE(2740),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2740),
    [sym_var_declaration] = STATE(2740),
    [sym_const_declaration] = STATE(2740),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2740),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2740),
    [sym_break_statement] = STATE(2740),
    [sym_if_statement] = STATE(2740),
    [sym_switch_statement] = STATE(2740),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2740),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__simple_statement] = STATE(3455),
    [sym__statement] = STATE(3455),
    [sym_defer_statement] = STATE(3455),
    [sym_using_statement] = STATE(3455),
    [sym_return_statement] = STATE(3455),
    [sym_block_statement] = STATE(3455),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3455),
    [sym_var_declaration] = STATE(3455),
    [sym_const_declaration] = STATE(3455),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3455),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3455),
    [sym_break_statement] = STATE(3455),
    [sym_if_statement] = STATE(3455),
    [sym_switch_statement] = STATE(3455),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3455),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__simple_statement] = STATE(3454),
    [sym__statement] = STATE(3454),
    [sym_defer_statement] = STATE(3454),
    [sym_using_statement] = STATE(3454),
    [sym_return_statement] = STATE(3454),
    [sym_block_statement] = STATE(3454),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3454),
    [sym_var_declaration] = STATE(3454),
    [sym_const_declaration] = STATE(3454),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3454),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3454),
    [sym_break_statement] = STATE(3454),
    [sym_if_statement] = STATE(3454),
    [sym_switch_statement] = STATE(3454),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3454),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__simple_statement] = STATE(2776),
    [sym__statement] = STATE(2776),
    [sym_defer_statement] = STATE(2776),
    [sym_using_statement] = STATE(2776),
    [sym_return_statement] = STATE(2776),
    [sym_block_statement] = STATE(2776),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2776),
    [sym_var_declaration] = STATE(2776),
    [sym_const_declaration] = STATE(2776),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2776),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2776),
    [sym_break_statement] = STATE(2776),
    [sym_if_statement] = STATE(2776),
    [sym_switch_statement] = STATE(2776),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2776),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__simple_statement] = STATE(2737),
    [sym__statement] = STATE(2737),
    [sym_defer_statement] = STATE(2737),
    [sym_using_statement] = STATE(2737),
    [sym_return_statement] = STATE(2737),
    [sym_block_statement] = STATE(2737),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2737),
    [sym_var_declaration] = STATE(2737),
    [sym_const_declaration] = STATE(2737),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2737),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2737),
    [sym_break_statement] = STATE(2737),
    [sym_if_statement] = STATE(2737),
    [sym_switch_statement] = STATE(2737),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2737),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__simple_statement] = STATE(2734),
    [sym__statement] = STATE(2734),
    [sym_defer_statement] = STATE(2734),
    [sym_using_statement] = STATE(2734),
    [sym_return_statement] = STATE(2734),
    [sym_block_statement] = STATE(2734),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2734),
    [sym_var_declaration] = STATE(2734),
    [sym_const_declaration] = STATE(2734),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2734),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2734),
    [sym_break_statement] = STATE(2734),
    [sym_if_statement] = STATE(2734),
    [sym_switch_statement] = STATE(2734),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2734),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__simple_statement] = STATE(3452),
    [sym__statement] = STATE(3452),
    [sym_defer_statement] = STATE(3452),
    [sym_using_statement] = STATE(3452),
    [sym_return_statement] = STATE(3452),
    [sym_block_statement] = STATE(3452),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3452),
    [sym_var_declaration] = STATE(3452),
    [sym_const_declaration] = STATE(3452),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3452),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3452),
    [sym_break_statement] = STATE(3452),
    [sym_if_statement] = STATE(3452),
    [sym_switch_statement] = STATE(3452),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3452),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__simple_statement] = STATE(2733),
    [sym__statement] = STATE(2733),
    [sym_defer_statement] = STATE(2733),
    [sym_using_statement] = STATE(2733),
    [sym_return_statement] = STATE(2733),
    [sym_block_statement] = STATE(2733),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2733),
    [sym_var_declaration] = STATE(2733),
    [sym_const_declaration] = STATE(2733),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2733),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2733),
    [sym_break_statement] = STATE(2733),
    [sym_if_statement] = STATE(2733),
    [sym_switch_statement] = STATE(2733),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2733),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__simple_statement] = STATE(2732),
    [sym__statement] = STATE(2732),
    [sym_defer_statement] = STATE(2732),
    [sym_using_statement] = STATE(2732),
    [sym_return_statement] = STATE(2732),
    [sym_block_statement] = STATE(2732),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2732),
    [sym_var_declaration] = STATE(2732),
    [sym_const_declaration] = STATE(2732),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2732),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2732),
    [sym_break_statement] = STATE(2732),
    [sym_if_statement] = STATE(2732),
    [sym_switch_statement] = STATE(2732),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2732),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__simple_statement] = STATE(2729),
    [sym__statement] = STATE(2729),
    [sym_defer_statement] = STATE(2729),
    [sym_using_statement] = STATE(2729),
    [sym_return_statement] = STATE(2729),
    [sym_block_statement] = STATE(2729),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2729),
    [sym_var_declaration] = STATE(2729),
    [sym_const_declaration] = STATE(2729),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2729),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2729),
    [sym_break_statement] = STATE(2729),
    [sym_if_statement] = STATE(2729),
    [sym_switch_statement] = STATE(2729),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2729),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__simple_statement] = STATE(3443),
    [sym__statement] = STATE(3443),
    [sym_defer_statement] = STATE(3443),
    [sym_using_statement] = STATE(3443),
    [sym_return_statement] = STATE(3443),
    [sym_block_statement] = STATE(3443),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3443),
    [sym_var_declaration] = STATE(3443),
    [sym_const_declaration] = STATE(3443),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3443),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3443),
    [sym_break_statement] = STATE(3443),
    [sym_if_statement] = STATE(3443),
    [sym_switch_statement] = STATE(3443),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3443),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__simple_statement] = STATE(2728),
    [sym__statement] = STATE(2728),
    [sym_defer_statement] = STATE(2728),
    [sym_using_statement] = STATE(2728),
    [sym_return_statement] = STATE(2728),
    [sym_block_statement] = STATE(2728),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2728),
    [sym_var_declaration] = STATE(2728),
    [sym_const_declaration] = STATE(2728),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2728),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2728),
    [sym_break_statement] = STATE(2728),
    [sym_if_statement] = STATE(2728),
    [sym_switch_statement] = STATE(2728),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2728),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__simple_statement] = STATE(3437),
    [sym__statement] = STATE(3437),
    [sym_defer_statement] = STATE(3437),
    [sym_using_statement] = STATE(3437),
    [sym_return_statement] = STATE(3437),
    [sym_block_statement] = STATE(3437),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3437),
    [sym_var_declaration] = STATE(3437),
    [sym_const_declaration] = STATE(3437),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3437),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3437),
    [sym_break_statement] = STATE(3437),
    [sym_if_statement] = STATE(3437),
    [sym_switch_statement] = STATE(3437),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3437),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__simple_statement] = STATE(3434),
    [sym__statement] = STATE(3434),
    [sym_defer_statement] = STATE(3434),
    [sym_using_statement] = STATE(3434),
    [sym_return_statement] = STATE(3434),
    [sym_block_statement] = STATE(3434),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3434),
    [sym_var_declaration] = STATE(3434),
    [sym_const_declaration] = STATE(3434),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3434),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3434),
    [sym_break_statement] = STATE(3434),
    [sym_if_statement] = STATE(3434),
    [sym_switch_statement] = STATE(3434),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3434),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__simple_statement] = STATE(3426),
    [sym__statement] = STATE(3426),
    [sym_defer_statement] = STATE(3426),
    [sym_using_statement] = STATE(3426),
    [sym_return_statement] = STATE(3426),
    [sym_block_statement] = STATE(3426),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3426),
    [sym_var_declaration] = STATE(3426),
    [sym_const_declaration] = STATE(3426),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3426),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3426),
    [sym_break_statement] = STATE(3426),
    [sym_if_statement] = STATE(3426),
    [sym_switch_statement] = STATE(3426),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3426),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__simple_statement] = STATE(3411),
    [sym__statement] = STATE(3411),
    [sym_defer_statement] = STATE(3411),
    [sym_using_statement] = STATE(3411),
    [sym_return_statement] = STATE(3411),
    [sym_block_statement] = STATE(3411),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3411),
    [sym_var_declaration] = STATE(3411),
    [sym_const_declaration] = STATE(3411),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3411),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3411),
    [sym_break_statement] = STATE(3411),
    [sym_if_statement] = STATE(3411),
    [sym_switch_statement] = STATE(3411),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3411),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__simple_statement] = STATE(2727),
    [sym__statement] = STATE(2727),
    [sym_defer_statement] = STATE(2727),
    [sym_using_statement] = STATE(2727),
    [sym_return_statement] = STATE(2727),
    [sym_block_statement] = STATE(2727),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2727),
    [sym_var_declaration] = STATE(2727),
    [sym_const_declaration] = STATE(2727),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2727),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2727),
    [sym_break_statement] = STATE(2727),
    [sym_if_statement] = STATE(2727),
    [sym_switch_statement] = STATE(2727),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2727),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__simple_statement] = STATE(3403),
    [sym__statement] = STATE(3403),
    [sym_defer_statement] = STATE(3403),
    [sym_using_statement] = STATE(3403),
    [sym_return_statement] = STATE(3403),
    [sym_block_statement] = STATE(3403),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3403),
    [sym_var_declaration] = STATE(3403),
    [sym_const_declaration] = STATE(3403),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3403),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3403),
    [sym_break_statement] = STATE(3403),
    [sym_if_statement] = STATE(3403),
    [sym_switch_statement] = STATE(3403),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3403),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__simple_statement] = STATE(3401),
    [sym__statement] = STATE(3401),
    [sym_defer_statement] = STATE(3401),
    [sym_using_statement] = STATE(3401),
    [sym_return_statement] = STATE(3401),
    [sym_block_statement] = STATE(3401),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3401),
    [sym_var_declaration] = STATE(3401),
    [sym_const_declaration] = STATE(3401),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3401),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3401),
    [sym_break_statement] = STATE(3401),
    [sym_if_statement] = STATE(3401),
    [sym_switch_statement] = STATE(3401),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3401),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__simple_statement] = STATE(3387),
    [sym__statement] = STATE(3387),
    [sym_defer_statement] = STATE(3387),
    [sym_using_statement] = STATE(3387),
    [sym_return_statement] = STATE(3387),
    [sym_block_statement] = STATE(3387),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3387),
    [sym_var_declaration] = STATE(3387),
    [sym_const_declaration] = STATE(3387),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3387),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3387),
    [sym_break_statement] = STATE(3387),
    [sym_if_statement] = STATE(3387),
    [sym_switch_statement] = STATE(3387),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3387),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__simple_statement] = STATE(3379),
    [sym__statement] = STATE(3379),
    [sym_defer_statement] = STATE(3379),
    [sym_using_statement] = STATE(3379),
    [sym_return_statement] = STATE(3379),
    [sym_block_statement] = STATE(3379),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3379),
    [sym_var_declaration] = STATE(3379),
    [sym_const_declaration] = STATE(3379),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3379),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3379),
    [sym_break_statement] = STATE(3379),
    [sym_if_statement] = STATE(3379),
    [sym_switch_statement] = STATE(3379),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3379),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__simple_statement] = STATE(3160),
    [sym__statement] = STATE(3160),
    [sym_defer_statement] = STATE(3160),
    [sym_using_statement] = STATE(3160),
    [sym_return_statement] = STATE(3160),
    [sym_block_statement] = STATE(3160),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3160),
    [sym_var_declaration] = STATE(3160),
    [sym_const_declaration] = STATE(3160),
    [sym__simple_type] = STATE(1016),
    [sym_generic_type] = STATE(1016),
    [sym_pointer_type] = STATE(1016),
    [sym__pointer_directive] = STATE(2818),
    [sym_bit_set_type] = STATE(1016),
    [sym_matrix_type] = STATE(1016),
    [sym_array_type] = STATE(1016),
    [sym__array_directive] = STATE(2543),
    [sym_union_type] = STATE(1016),
    [sym_enum_type] = STATE(1016),
    [sym_struct_type] = STATE(1016),
    [sym_map_type] = STATE(1016),
    [sym__expression] = STATE(1016),
    [sym__type_directive] = STATE(548),
    [sym_selector_expression] = STATE(1016),
    [sym_type_conversion] = STATE(1016),
    [sym_ternary_expression] = STATE(1016),
    [sym_index_expression] = STATE(1016),
    [sym__parenthesized_expression] = STATE(1016),
    [sym_proc_literal] = STATE(1016),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1016),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1205),
    [sym_assignment_statement] = STATE(3160),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3160),
    [sym_break_statement] = STATE(3160),
    [sym_if_statement] = STATE(3160),
    [sym_switch_statement] = STATE(3160),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3160),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1016),
    [sym_left_unary_expression] = STATE(1016),
    [sym_binary_expression] = STATE(1016),
    [sym_compound_literal] = STATE(1016),
    [sym_interpreted_string_literal] = STATE(1016),
    [sym_bool_literal] = STATE(1016),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2818),
    [aux_sym_array_type_repeat1] = STATE(2543),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(233),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(287),
    [anon_sym_uint] = ACTIONS(287),
    [anon_sym_uintptr] = ACTIONS(287),
    [anon_sym_typeid] = ACTIONS(245),
    [anon_sym_rawptr] = ACTIONS(287),
    [anon_sym_string] = ACTIONS(287),
    [anon_sym_cstring] = ACTIONS(287),
    [anon_sym_i8] = ACTIONS(287),
    [anon_sym_u8] = ACTIONS(287),
    [anon_sym_bool] = ACTIONS(287),
    [anon_sym_b8] = ACTIONS(287),
    [anon_sym_b16] = ACTIONS(287),
    [anon_sym_b32] = ACTIONS(287),
    [anon_sym_b64] = ACTIONS(287),
    [anon_sym_i16] = ACTIONS(287),
    [anon_sym_i16le] = ACTIONS(287),
    [anon_sym_i16be] = ACTIONS(287),
    [anon_sym_i32] = ACTIONS(287),
    [anon_sym_i32le] = ACTIONS(287),
    [anon_sym_i32be] = ACTIONS(287),
    [anon_sym_i64] = ACTIONS(287),
    [anon_sym_i64le] = ACTIONS(287),
    [anon_sym_i64be] = ACTIONS(287),
    [anon_sym_i128] = ACTIONS(287),
    [anon_sym_i128le] = ACTIONS(287),
    [anon_sym_i128be] = ACTIONS(287),
    [anon_sym_u16] = ACTIONS(287),
    [anon_sym_u16le] = ACTIONS(287),
    [anon_sym_u16be] = ACTIONS(287),
    [anon_sym_u32] = ACTIONS(287),
    [anon_sym_u32le] = ACTIONS(287),
    [anon_sym_u32be] = ACTIONS(287),
    [anon_sym_u64] = ACTIONS(287),
    [anon_sym_u64le] = ACTIONS(287),
    [anon_sym_u64be] = ACTIONS(287),
    [anon_sym_u128] = ACTIONS(287),
    [anon_sym_u128le] = ACTIONS(287),
    [anon_sym_u128be] = ACTIONS(287),
    [anon_sym_f16] = ACTIONS(287),
    [anon_sym_f16le] = ACTIONS(287),
    [anon_sym_f16be] = ACTIONS(287),
    [anon_sym_f32] = ACTIONS(287),
    [anon_sym_f32le] = ACTIONS(287),
    [anon_sym_f32be] = ACTIONS(287),
    [anon_sym_f64] = ACTIONS(287),
    [anon_sym_f64le] = ACTIONS(287),
    [anon_sym_f64be] = ACTIONS(287),
    [anon_sym_complex32] = ACTIONS(287),
    [anon_sym_complex64] = ACTIONS(287),
    [anon_sym_complex128] = ACTIONS(287),
    [anon_sym_quaternion64] = ACTIONS(287),
    [anon_sym_quaternion128] = ACTIONS(287),
    [anon_sym_quaternion256] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(247),
    [anon_sym_CARET] = ACTIONS(249),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(251),
    [anon_sym_matrix] = ACTIONS(253),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(255),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(257),
    [anon_sym_transmute] = ACTIONS(257),
    [anon_sym_auto_cast] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(263),
    [anon_sym_DOT_DOT] = ACTIONS(263),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(263),
    [anon_sym_DASH] = ACTIONS(263),
    [anon_sym_TILDE] = ACTIONS(263),
    [anon_sym_AMP] = ACTIONS(263),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(289),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(287),
    [sym_float_literal] = ACTIONS(289),
    [sym_rune_literal] = ACTIONS(289),
    [sym_nil] = ACTIONS(287),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__simple_statement] = STATE(3378),
    [sym__statement] = STATE(3378),
    [sym_defer_statement] = STATE(3378),
    [sym_using_statement] = STATE(3378),
    [sym_return_statement] = STATE(3378),
    [sym_block_statement] = STATE(3378),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3378),
    [sym_var_declaration] = STATE(3378),
    [sym_const_declaration] = STATE(3378),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3378),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3378),
    [sym_break_statement] = STATE(3378),
    [sym_if_statement] = STATE(3378),
    [sym_switch_statement] = STATE(3378),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3378),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__simple_statement] = STATE(2726),
    [sym__statement] = STATE(2726),
    [sym_defer_statement] = STATE(2726),
    [sym_using_statement] = STATE(2726),
    [sym_return_statement] = STATE(2726),
    [sym_block_statement] = STATE(2726),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2726),
    [sym_var_declaration] = STATE(2726),
    [sym_const_declaration] = STATE(2726),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2726),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2726),
    [sym_break_statement] = STATE(2726),
    [sym_if_statement] = STATE(2726),
    [sym_switch_statement] = STATE(2726),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2726),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__simple_statement] = STATE(3376),
    [sym__statement] = STATE(3376),
    [sym_defer_statement] = STATE(3376),
    [sym_using_statement] = STATE(3376),
    [sym_return_statement] = STATE(3376),
    [sym_block_statement] = STATE(3376),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3376),
    [sym_var_declaration] = STATE(3376),
    [sym_const_declaration] = STATE(3376),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3376),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3376),
    [sym_break_statement] = STATE(3376),
    [sym_if_statement] = STATE(3376),
    [sym_switch_statement] = STATE(3376),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3376),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__simple_statement] = STATE(3375),
    [sym__statement] = STATE(3375),
    [sym_defer_statement] = STATE(3375),
    [sym_using_statement] = STATE(3375),
    [sym_return_statement] = STATE(3375),
    [sym_block_statement] = STATE(3375),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3375),
    [sym_var_declaration] = STATE(3375),
    [sym_const_declaration] = STATE(3375),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3375),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3375),
    [sym_break_statement] = STATE(3375),
    [sym_if_statement] = STATE(3375),
    [sym_switch_statement] = STATE(3375),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3375),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__simple_statement] = STATE(3374),
    [sym__statement] = STATE(3374),
    [sym_defer_statement] = STATE(3374),
    [sym_using_statement] = STATE(3374),
    [sym_return_statement] = STATE(3374),
    [sym_block_statement] = STATE(3374),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3374),
    [sym_var_declaration] = STATE(3374),
    [sym_const_declaration] = STATE(3374),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3374),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3374),
    [sym_break_statement] = STATE(3374),
    [sym_if_statement] = STATE(3374),
    [sym_switch_statement] = STATE(3374),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3374),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym__simple_statement] = STATE(3371),
    [sym__statement] = STATE(3371),
    [sym_defer_statement] = STATE(3371),
    [sym_using_statement] = STATE(3371),
    [sym_return_statement] = STATE(3371),
    [sym_block_statement] = STATE(3371),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3371),
    [sym_var_declaration] = STATE(3371),
    [sym_const_declaration] = STATE(3371),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3371),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3371),
    [sym_break_statement] = STATE(3371),
    [sym_if_statement] = STATE(3371),
    [sym_switch_statement] = STATE(3371),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3371),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym__simple_statement] = STATE(3358),
    [sym__statement] = STATE(3358),
    [sym_defer_statement] = STATE(3358),
    [sym_using_statement] = STATE(3358),
    [sym_return_statement] = STATE(3358),
    [sym_block_statement] = STATE(3358),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3358),
    [sym_var_declaration] = STATE(3358),
    [sym_const_declaration] = STATE(3358),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3358),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3358),
    [sym_break_statement] = STATE(3358),
    [sym_if_statement] = STATE(3358),
    [sym_switch_statement] = STATE(3358),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3358),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym__simple_statement] = STATE(3324),
    [sym__statement] = STATE(3324),
    [sym_defer_statement] = STATE(3324),
    [sym_using_statement] = STATE(3324),
    [sym_return_statement] = STATE(3324),
    [sym_block_statement] = STATE(3324),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3324),
    [sym_var_declaration] = STATE(3324),
    [sym_const_declaration] = STATE(3324),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3324),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3324),
    [sym_break_statement] = STATE(3324),
    [sym_if_statement] = STATE(3324),
    [sym_switch_statement] = STATE(3324),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3324),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym__simple_statement] = STATE(3323),
    [sym__statement] = STATE(3323),
    [sym_defer_statement] = STATE(3323),
    [sym_using_statement] = STATE(3323),
    [sym_return_statement] = STATE(3323),
    [sym_block_statement] = STATE(3323),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3323),
    [sym_var_declaration] = STATE(3323),
    [sym_const_declaration] = STATE(3323),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3323),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3323),
    [sym_break_statement] = STATE(3323),
    [sym_if_statement] = STATE(3323),
    [sym_switch_statement] = STATE(3323),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3323),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym__simple_statement] = STATE(3322),
    [sym__statement] = STATE(3322),
    [sym_defer_statement] = STATE(3322),
    [sym_using_statement] = STATE(3322),
    [sym_return_statement] = STATE(3322),
    [sym_block_statement] = STATE(3322),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3322),
    [sym_var_declaration] = STATE(3322),
    [sym_const_declaration] = STATE(3322),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3322),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3322),
    [sym_break_statement] = STATE(3322),
    [sym_if_statement] = STATE(3322),
    [sym_switch_statement] = STATE(3322),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3322),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym__simple_statement] = STATE(3321),
    [sym__statement] = STATE(3321),
    [sym_defer_statement] = STATE(3321),
    [sym_using_statement] = STATE(3321),
    [sym_return_statement] = STATE(3321),
    [sym_block_statement] = STATE(3321),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3321),
    [sym_var_declaration] = STATE(3321),
    [sym_const_declaration] = STATE(3321),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3321),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3321),
    [sym_break_statement] = STATE(3321),
    [sym_if_statement] = STATE(3321),
    [sym_switch_statement] = STATE(3321),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3321),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym__simple_statement] = STATE(3317),
    [sym__statement] = STATE(3317),
    [sym_defer_statement] = STATE(3317),
    [sym_using_statement] = STATE(3317),
    [sym_return_statement] = STATE(3317),
    [sym_block_statement] = STATE(3317),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3317),
    [sym_var_declaration] = STATE(3317),
    [sym_const_declaration] = STATE(3317),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3317),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3317),
    [sym_break_statement] = STATE(3317),
    [sym_if_statement] = STATE(3317),
    [sym_switch_statement] = STATE(3317),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3317),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym__simple_statement] = STATE(3311),
    [sym__statement] = STATE(3311),
    [sym_defer_statement] = STATE(3311),
    [sym_using_statement] = STATE(3311),
    [sym_return_statement] = STATE(3311),
    [sym_block_statement] = STATE(3311),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3311),
    [sym_var_declaration] = STATE(3311),
    [sym_const_declaration] = STATE(3311),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3311),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3311),
    [sym_break_statement] = STATE(3311),
    [sym_if_statement] = STATE(3311),
    [sym_switch_statement] = STATE(3311),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3311),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym__simple_statement] = STATE(3310),
    [sym__statement] = STATE(3310),
    [sym_defer_statement] = STATE(3310),
    [sym_using_statement] = STATE(3310),
    [sym_return_statement] = STATE(3310),
    [sym_block_statement] = STATE(3310),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3310),
    [sym_var_declaration] = STATE(3310),
    [sym_const_declaration] = STATE(3310),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3310),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3310),
    [sym_break_statement] = STATE(3310),
    [sym_if_statement] = STATE(3310),
    [sym_switch_statement] = STATE(3310),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3310),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym__simple_statement] = STATE(3307),
    [sym__statement] = STATE(3307),
    [sym_defer_statement] = STATE(3307),
    [sym_using_statement] = STATE(3307),
    [sym_return_statement] = STATE(3307),
    [sym_block_statement] = STATE(3307),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3307),
    [sym_var_declaration] = STATE(3307),
    [sym_const_declaration] = STATE(3307),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3307),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3307),
    [sym_break_statement] = STATE(3307),
    [sym_if_statement] = STATE(3307),
    [sym_switch_statement] = STATE(3307),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3307),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [sym__simple_statement] = STATE(3304),
    [sym__statement] = STATE(3304),
    [sym_defer_statement] = STATE(3304),
    [sym_using_statement] = STATE(3304),
    [sym_return_statement] = STATE(3304),
    [sym_block_statement] = STATE(3304),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3304),
    [sym_var_declaration] = STATE(3304),
    [sym_const_declaration] = STATE(3304),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3304),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3304),
    [sym_break_statement] = STATE(3304),
    [sym_if_statement] = STATE(3304),
    [sym_switch_statement] = STATE(3304),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3304),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym__simple_statement] = STATE(3303),
    [sym__statement] = STATE(3303),
    [sym_defer_statement] = STATE(3303),
    [sym_using_statement] = STATE(3303),
    [sym_return_statement] = STATE(3303),
    [sym_block_statement] = STATE(3303),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3303),
    [sym_var_declaration] = STATE(3303),
    [sym_const_declaration] = STATE(3303),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3303),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3303),
    [sym_break_statement] = STATE(3303),
    [sym_if_statement] = STATE(3303),
    [sym_switch_statement] = STATE(3303),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3303),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [sym__simple_statement] = STATE(3302),
    [sym__statement] = STATE(3302),
    [sym_defer_statement] = STATE(3302),
    [sym_using_statement] = STATE(3302),
    [sym_return_statement] = STATE(3302),
    [sym_block_statement] = STATE(3302),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3302),
    [sym_var_declaration] = STATE(3302),
    [sym_const_declaration] = STATE(3302),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3302),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3302),
    [sym_break_statement] = STATE(3302),
    [sym_if_statement] = STATE(3302),
    [sym_switch_statement] = STATE(3302),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3302),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym__simple_statement] = STATE(3217),
    [sym__statement] = STATE(3217),
    [sym_defer_statement] = STATE(3217),
    [sym_using_statement] = STATE(3217),
    [sym_return_statement] = STATE(3217),
    [sym_block_statement] = STATE(3217),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3217),
    [sym_var_declaration] = STATE(3217),
    [sym_const_declaration] = STATE(3217),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3217),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3217),
    [sym_break_statement] = STATE(3217),
    [sym_if_statement] = STATE(3217),
    [sym_switch_statement] = STATE(3217),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3217),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym__simple_statement] = STATE(2751),
    [sym__statement] = STATE(2751),
    [sym_defer_statement] = STATE(2751),
    [sym_using_statement] = STATE(2751),
    [sym_return_statement] = STATE(2751),
    [sym_block_statement] = STATE(2751),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2751),
    [sym_var_declaration] = STATE(2751),
    [sym_const_declaration] = STATE(2751),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2751),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2751),
    [sym_break_statement] = STATE(2751),
    [sym_if_statement] = STATE(2751),
    [sym_switch_statement] = STATE(2751),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2751),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym__simple_statement] = STATE(3299),
    [sym__statement] = STATE(3299),
    [sym_defer_statement] = STATE(3299),
    [sym_using_statement] = STATE(3299),
    [sym_return_statement] = STATE(3299),
    [sym_block_statement] = STATE(3299),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3299),
    [sym_var_declaration] = STATE(3299),
    [sym_const_declaration] = STATE(3299),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3299),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3299),
    [sym_break_statement] = STATE(3299),
    [sym_if_statement] = STATE(3299),
    [sym_switch_statement] = STATE(3299),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3299),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym__simple_statement] = STATE(3298),
    [sym__statement] = STATE(3298),
    [sym_defer_statement] = STATE(3298),
    [sym_using_statement] = STATE(3298),
    [sym_return_statement] = STATE(3298),
    [sym_block_statement] = STATE(3298),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3298),
    [sym_var_declaration] = STATE(3298),
    [sym_const_declaration] = STATE(3298),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3298),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3298),
    [sym_break_statement] = STATE(3298),
    [sym_if_statement] = STATE(3298),
    [sym_switch_statement] = STATE(3298),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3298),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym__simple_statement] = STATE(2699),
    [sym__statement] = STATE(2699),
    [sym_defer_statement] = STATE(2699),
    [sym_using_statement] = STATE(2699),
    [sym_return_statement] = STATE(2699),
    [sym_block_statement] = STATE(2699),
    [sym_block] = STATE(2815),
    [sym__block_directive] = STATE(2554),
    [sym_pragma] = STATE(2488),
    [sym__declaration] = STATE(2699),
    [sym_var_declaration] = STATE(2699),
    [sym_const_declaration] = STATE(2699),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1382),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1382),
    [sym_ternary_expression] = STATE(1382),
    [sym_index_expression] = STATE(1382),
    [sym__parenthesized_expression] = STATE(1382),
    [sym_proc_literal] = STATE(1382),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1382),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1217),
    [sym_assignment_statement] = STATE(2699),
    [sym__expression_pack] = STATE(2287),
    [sym_continue_statement] = STATE(2699),
    [sym_break_statement] = STATE(2699),
    [sym_if_statement] = STATE(2699),
    [sym_switch_statement] = STATE(2699),
    [sym__switch_directive] = STATE(2819),
    [sym_for_statement] = STATE(2699),
    [sym__for_directive] = STATE(2820),
    [sym_right_unary_expression] = STATE(1382),
    [sym_left_unary_expression] = STATE(1382),
    [sym_binary_expression] = STATE(1382),
    [sym_compound_literal] = STATE(1382),
    [sym_interpreted_string_literal] = STATE(1382),
    [sym_bool_literal] = STATE(1382),
    [aux_sym_foreign_block_repeat1] = STATE(2488),
    [aux_sym_block_repeat1] = STATE(2554),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2819),
    [aux_sym_for_statement_repeat1] = STATE(2820),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_defer] = ACTIONS(17),
    [anon_sym_using] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(73),
    [anon_sym_break] = ACTIONS(75),
    [anon_sym_when] = ACTIONS(63),
    [anon_sym_switch] = ACTIONS(77),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(227),
    [sym_raw_string_literal] = ACTIONS(229),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(155),
    [sym_float_literal] = ACTIONS(229),
    [sym_rune_literal] = ACTIONS(229),
    [sym_nil] = ACTIONS(155),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [sym__simple_statement] = STATE(3297),
    [sym__statement] = STATE(3297),
    [sym_defer_statement] = STATE(3297),
    [sym_using_statement] = STATE(3297),
    [sym_return_statement] = STATE(3297),
    [sym_block_statement] = STATE(3297),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3297),
    [sym_var_declaration] = STATE(3297),
    [sym_const_declaration] = STATE(3297),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3297),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3297),
    [sym_break_statement] = STATE(3297),
    [sym_if_statement] = STATE(3297),
    [sym_switch_statement] = STATE(3297),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3297),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym__simple_statement] = STATE(3278),
    [sym__statement] = STATE(3278),
    [sym_defer_statement] = STATE(3278),
    [sym_using_statement] = STATE(3278),
    [sym_return_statement] = STATE(3278),
    [sym_block_statement] = STATE(3278),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3278),
    [sym_var_declaration] = STATE(3278),
    [sym_const_declaration] = STATE(3278),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3278),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3278),
    [sym_break_statement] = STATE(3278),
    [sym_if_statement] = STATE(3278),
    [sym_switch_statement] = STATE(3278),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3278),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_literal] = STATE(1384),
    [aux_sym_foreign_block_repeat1] = STATE(2472),
    [aux_sym_block_repeat1] = STATE(2536),
    [aux_sym_pointer_type_repeat1] = STATE(2675),
    [aux_sym_array_type_repeat1] = STATE(2561),
    [aux_sym_proc_literal_repeat1] = STATE(2468),
    [aux_sym_switch_statement_repeat1] = STATE(2748),
    [aux_sym_for_statement_repeat1] = STATE(2747),
    [sym_identifier] = ACTIONS(281),
    [anon_sym_LBRACE] = ACTIONS(235),
    [anon_sym_defer] = ACTIONS(237),
    [anon_sym_using] = ACTIONS(239),
    [anon_sym_return] = ACTIONS(241),
    [anon_sym_POUNDno_bounds_check] = ACTIONS(201),
    [anon_sym_POUNDbounds_check] = ACTIONS(201),
    [anon_sym_AT] = ACTIONS(203),
    [anon_sym_LPAREN] = ACTIONS(205),
    [anon_sym_int] = ACTIONS(29),
    [anon_sym_uint] = ACTIONS(29),
    [anon_sym_uintptr] = ACTIONS(29),
    [anon_sym_typeid] = ACTIONS(31),
    [anon_sym_rawptr] = ACTIONS(29),
    [anon_sym_string] = ACTIONS(29),
    [anon_sym_cstring] = ACTIONS(29),
    [anon_sym_i8] = ACTIONS(29),
    [anon_sym_u8] = ACTIONS(29),
    [anon_sym_bool] = ACTIONS(29),
    [anon_sym_b8] = ACTIONS(29),
    [anon_sym_b16] = ACTIONS(29),
    [anon_sym_b32] = ACTIONS(29),
    [anon_sym_b64] = ACTIONS(29),
    [anon_sym_i16] = ACTIONS(29),
    [anon_sym_i16le] = ACTIONS(29),
    [anon_sym_i16be] = ACTIONS(29),
    [anon_sym_i32] = ACTIONS(29),
    [anon_sym_i32le] = ACTIONS(29),
    [anon_sym_i32be] = ACTIONS(29),
    [anon_sym_i64] = ACTIONS(29),
    [anon_sym_i64le] = ACTIONS(29),
    [anon_sym_i64be] = ACTIONS(29),
    [anon_sym_i128] = ACTIONS(29),
    [anon_sym_i128le] = ACTIONS(29),
    [anon_sym_i128be] = ACTIONS(29),
    [anon_sym_u16] = ACTIONS(29),
    [anon_sym_u16le] = ACTIONS(29),
    [anon_sym_u16be] = ACTIONS(29),
    [anon_sym_u32] = ACTIONS(29),
    [anon_sym_u32le] = ACTIONS(29),
    [anon_sym_u32be] = ACTIONS(29),
    [anon_sym_u64] = ACTIONS(29),
    [anon_sym_u64le] = ACTIONS(29),
    [anon_sym_u64be] = ACTIONS(29),
    [anon_sym_u128] = ACTIONS(29),
    [anon_sym_u128le] = ACTIONS(29),
    [anon_sym_u128be] = ACTIONS(29),
    [anon_sym_f16] = ACTIONS(29),
    [anon_sym_f16le] = ACTIONS(29),
    [anon_sym_f16be] = ACTIONS(29),
    [anon_sym_f32] = ACTIONS(29),
    [anon_sym_f32le] = ACTIONS(29),
    [anon_sym_f32be] = ACTIONS(29),
    [anon_sym_f64] = ACTIONS(29),
    [anon_sym_f64le] = ACTIONS(29),
    [anon_sym_f64be] = ACTIONS(29),
    [anon_sym_complex32] = ACTIONS(29),
    [anon_sym_complex64] = ACTIONS(29),
    [anon_sym_complex128] = ACTIONS(29),
    [anon_sym_quaternion64] = ACTIONS(29),
    [anon_sym_quaternion128] = ACTIONS(29),
    [anon_sym_quaternion256] = ACTIONS(29),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [anon_sym_CARET] = ACTIONS(209),
    [anon_sym_POUNDrelative] = ACTIONS(211),
    [anon_sym_bit_set] = ACTIONS(39),
    [anon_sym_LBRACK] = ACTIONS(213),
    [anon_sym_matrix] = ACTIONS(43),
    [anon_sym_POUNDsoa] = ACTIONS(215),
    [anon_sym_POUNDsimd] = ACTIONS(215),
    [anon_sym_union] = ACTIONS(47),
    [anon_sym_enum] = ACTIONS(49),
    [anon_sym_struct] = ACTIONS(51),
    [anon_sym_map] = ACTIONS(53),
    [anon_sym_POUNDtype] = ACTIONS(217),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_cast] = ACTIONS(59),
    [anon_sym_transmute] = ACTIONS(59),
    [anon_sym_auto_cast] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_POUNDforce_inline] = ACTIONS(219),
    [anon_sym_POUNDforce_no_inline] = ACTIONS(219),
    [anon_sym_proc] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(221),
    [anon_sym_DOT_DOT] = ACTIONS(221),
    [anon_sym_continue] = ACTIONS(265),
    [anon_sym_break] = ACTIONS(267),
    [anon_sym_when] = ACTIONS(261),
    [anon_sym_switch] = ACTIONS(269),
    [anon_sym_POUNDpartial] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(271),
    [anon_sym_POUNDunroll] = ACTIONS(225),
    [anon_sym_PLUS] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [sym_builtin_procedure] = ACTIONS(273),
    [sym_raw_string_literal] = ACTIONS(283),
    [anon_sym_DQUOTE] = ACTIONS(231),
    [sym_int_literal] = ACTIONS(285),
    [sym_float_literal] = ACTIONS(283),
    [sym_rune_literal] = ACTIONS(283),
    [sym_nil] = ACTIONS(285),
    [sym__true] = ACTIONS(91),
    [sym__false] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym__simple_statement] = STATE(3252),
    [sym__statement] = STATE(3252),
    [sym_defer_statement] = STATE(3252),
    [sym_using_statement] = STATE(3252),
    [sym_return_statement] = STATE(3252),
    [sym_block_statement] = STATE(3252),
    [sym_block] = STATE(3205),
    [sym__block_directive] = STATE(2536),
    [sym_pragma] = STATE(2472),
    [sym__declaration] = STATE(3252),
    [sym_var_declaration] = STATE(3252),
    [sym_const_declaration] = STATE(3252),
    [sym__simple_type] = STATE(1372),
    [sym_generic_type] = STATE(1372),
    [sym_pointer_type] = STATE(1372),
    [sym__pointer_directive] = STATE(2675),
    [sym_bit_set_type] = STATE(1372),
    [sym_matrix_type] = STATE(1372),
    [sym_array_type] = STATE(1372),
    [sym__array_directive] = STATE(2561),
    [sym_union_type] = STATE(1372),
    [sym_enum_type] = STATE(1372),
    [sym_struct_type] = STATE(1372),
    [sym_map_type] = STATE(1372),
    [sym__expression] = STATE(1384),
    [sym__type_directive] = STATE(492),
    [sym_selector_expression] = STATE(1363),
    [sym_type_conversion] = STATE(1384),
    [sym_ternary_expression] = STATE(1384),
    [sym_index_expression] = STATE(1384),
    [sym__parenthesized_expression] = STATE(1384),
    [sym_proc_literal] = STATE(1384),
    [sym__proc_directive] = STATE(2468),
    [sym_proc_group] = STATE(1384),
    [sym__proc_type] = STATE(955),
    [sym_proc_call] = STATE(1361),
    [sym_assignment_statement] = STATE(3252),
    [sym__expression_pack] = STATE(2286),
    [sym_continue_statement] = STATE(3252),
    [sym_break_statement] = STATE(3252),
    [sym_if_statement] = STATE(3252),
    [sym_switch_statement] = STATE(3252),
    [sym__switch_directive] = STATE(2748),
    [sym_for_statement] = STATE(3252),
    [sym__for_directive] = STATE(2747),
    [sym_right_unary_expression] = STATE(1384),
    [sym_left_unary_expression] = STATE(1384),
    [sym_binary_expression] = STATE(1384),
    [sym_compound_literal] = STATE(1384),
    [sym_interpreted_string_literal] = STATE(1384),
    [sym_bool_lit