#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1040
#define LARGE_STATE_COUNT 8
#define SYMBOL_COUNT 149
#define ALIAS_COUNT 0
#define TOKEN_COUNT 79
#define EXTERNAL_TOKEN_COUNT 8
#define FIELD_COUNT 34
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 61

enum {
  sym_keyword = 1,
  sym_num_literal = 2,
  sym_signed_num_literal = 3,
  sym_ident = 4,
  sym_raw_enum_tag = 5,
  anon_sym_PIPE = 6,
  anon_sym_default = 7,
  anon_sym_force = 8,
  anon_sym_optional = 9,
  anon_sym_priority = 10,
  anon_sym_doc = 11,
  anon_sym_rec = 12,
  anon_sym_not_exported = 13,
  anon_sym_COLON = 14,
  anon_sym_let = 15,
  anon_sym_EQ = 16,
  anon_sym_in = 17,
  anon_sym_fun = 18,
  anon_sym_EQ_GT = 19,
  anon_sym_match = 20,
  anon_sym_LBRACE = 21,
  anon_sym_COMMA = 22,
  anon_sym_RBRACE = 23,
  anon_sym_if = 24,
  anon_sym_then = 25,
  anon_sym_else = 26,
  anon_sym_forall = 27,
  anon_sym_DOT = 28,
  anon_sym_import = 29,
  anon_sym_Array = 30,
  anon_sym_Dyn = 31,
  anon_sym_SEMI = 32,
  anon_sym_LPAREN = 33,
  anon_sym_RPAREN = 34,
  anon_sym_null = 35,
  anon_sym_LBRACK = 36,
  anon_sym_RBRACK = 37,
  anon_sym_DOT_DOT = 38,
  anon_sym_AT = 39,
  anon_sym_QMARK = 40,
  anon_sym_true = 41,
  anon_sym_false = 42,
  anon_sym_PERCENT = 43,
  sym_double_quote = 44,
  sym_str_literal = 45,
  sym_mult_str_literal = 46,
  sym_str_esc_char = 47,
  anon_sym__ = 48,
  anon_sym_PLUS_PLUS = 49,
  anon_sym_STAR = 50,
  anon_sym_SLASH = 51,
  anon_sym_PLUS = 52,
  anon_sym_DASH = 53,
  anon_sym_BANG = 54,
  anon_sym_AMP = 55,
  anon_sym_PIPE_GT = 56,
  anon_sym_LT = 57,
  anon_sym_LT_EQ = 58,
  anon_sym_GT = 59,
  anon_sym_GT_EQ = 60,
  anon_sym_EQ_EQ = 61,
  anon_sym_BANG_EQ = 62,
  anon_sym_AMP_AMP = 63,
  anon_sym_PIPE_PIPE = 64,
  anon_sym_DASH_GT = 65,
  anon_sym_Number = 66,
  anon_sym_Bool = 67,
  anon_sym_String = 68,
  anon_sym_LBRACK_PIPE = 69,
  anon_sym_PIPE_RBRACK = 70,
  sym_multstr_start = 71,
  sym_multstr_end = 72,
  sym__str_start = 73,
  sym__str_end = 74,
  sym_interpolation_start = 75,
  sym_interpolation_end = 76,
  sym_quoted_enum_tag_start = 77,
  sym_comment = 78,
  sym_term = 79,
  sym_annot_atom = 80,
  sym_annot = 81,
  sym_types = 82,
  sym_uni_term = 83,
  sym_let_expr = 84,
  sym_let_in_block = 85,
  sym_fun_expr = 86,
  sym_match_expr = 87,
  sym_ite_expr = 88,
  sym_annotated_infix_expr = 89,
  sym_forall = 90,
  sym_applicative = 91,
  sym_type_array = 92,
  sym_record_operand = 93,
  sym_record_operation_chain = 94,
  sym_row_tail = 95,
  sym_uni_record = 96,
  sym_atom = 97,
  sym_record_field = 98,
  sym_record_last_field = 99,
  sym_field_path = 100,
  sym_field_path_elem = 101,
  sym_last_match = 102,
  sym_pattern = 103,
  sym_destruct = 104,
  sym_match = 105,
  sym_default_annot = 106,
  sym_bool = 107,
  sym_str_chunks = 108,
  sym_str_chunks_single = 109,
  sym_str_chunks_multi = 110,
  sym_chunk_expr = 111,
  sym_static_string = 112,
  sym_quoted_enum_tag = 113,
  sym_enum_tag = 114,
  sym_chunk_literal_single = 115,
  sym_chunk_literal_multi = 116,
  sym_percent = 117,
  sym_builtin = 118,
  sym_match_case = 119,
  sym_infix_b_op_2 = 120,
  sym_infix_b_op_3 = 121,
  sym_infix_b_op_4 = 122,
  sym_infix_u_op_5 = 123,
  sym_infix_b_op_6 = 124,
  sym_infix_b_op_7 = 125,
  sym_infix_b_op_8 = 126,
  sym_infix_lazy_b_op_9 = 127,
  sym_infix_lazy_b_op_10 = 128,
  sym_infix_b_op = 129,
  sym_infix_u_op_or_lazy_b_op = 130,
  sym_infix_op = 131,
  sym_curried_op = 132,
  sym_infix_expr = 133,
  sym_type_builtin = 134,
  sym_type_atom = 135,
  aux_sym_annot_repeat1 = 136,
  aux_sym_fun_expr_repeat1 = 137,
  aux_sym_match_expr_repeat1 = 138,
  aux_sym_forall_repeat1 = 139,
  aux_sym_uni_record_repeat1 = 140,
  aux_sym_atom_repeat1 = 141,
  aux_sym_field_path_repeat1 = 142,
  aux_sym_destruct_repeat1 = 143,
  aux_sym_str_chunks_single_repeat1 = 144,
  aux_sym_str_chunks_multi_repeat1 = 145,
  aux_sym_static_string_repeat1 = 146,
  aux_sym_static_string_repeat2 = 147,
  aux_sym_type_atom_repeat1 = 148,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_keyword] = "keyword",
  [sym_num_literal] = "num_literal",
  [sym_signed_num_literal] = "signed_num_literal",
  [sym_ident] = "ident",
  [sym_raw_enum_tag] = "raw_enum_tag",
  [anon_sym_PIPE] = "|",
  [anon_sym_default] = "default",
  [anon_sym_force] = "force",
  [anon_sym_optional] = "optional",
  [anon_sym_priority] = "priority",
  [anon_sym_doc] = "doc",
  [anon_sym_rec] = "rec",
  [anon_sym_not_exported] = "not_exported",
  [anon_sym_COLON] = ":",
  [anon_sym_let] = "let",
  [anon_sym_EQ] = "=",
  [anon_sym_in] = "in",
  [anon_sym_fun] = "fun",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_match] = "match",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_forall] = "forall",
  [anon_sym_DOT] = ".",
  [anon_sym_import] = "import",
  [anon_sym_Array] = "Array",
  [anon_sym_Dyn] = "Dyn",
  [anon_sym_SEMI] = ";",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_null] = "null",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_AT] = "@",
  [anon_sym_QMARK] = "\?",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_PERCENT] = "%",
  [sym_double_quote] = "double_quote",
  [sym_str_literal] = "str_literal",
  [sym_mult_str_literal] = "mult_str_literal",
  [sym_str_esc_char] = "str_esc_char",
  [anon_sym__] = "_",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_Number] = "Number",
  [anon_sym_Bool] = "Bool",
  [anon_sym_String] = "String",
  [anon_sym_LBRACK_PIPE] = "[|",
  [anon_sym_PIPE_RBRACK] = "|]",
  [sym_multstr_start] = "multstr_start",
  [sym_multstr_end] = "multstr_end",
  [sym__str_start] = "_str_start",
  [sym__str_end] = "_str_end",
  [sym_interpolation_start] = "interpolation_start",
  [sym_interpolation_end] = "interpolation_end",
  [sym_quoted_enum_tag_start] = "quoted_enum_tag_start",
  [sym_comment] = "comment",
  [sym_term] = "term",
  [sym_annot_atom] = "annot_atom",
  [sym_annot] = "annot",
  [sym_types] = "types",
  [sym_uni_term] = "uni_term",
  [sym_let_expr] = "let_expr",
  [sym_let_in_block] = "let_in_block",
  [sym_fun_expr] = "fun_expr",
  [sym_match_expr] = "match_expr",
  [sym_ite_expr] = "ite_expr",
  [sym_annotated_infix_expr] = "annotated_infix_expr",
  [sym_forall] = "forall",
  [sym_applicative] = "applicative",
  [sym_type_array] = "type_array",
  [sym_record_operand] = "record_operand",
  [sym_record_operation_chain] = "record_operation_chain",
  [sym_row_tail] = "row_tail",
  [sym_uni_record] = "uni_record",
  [sym_atom] = "atom",
  [sym_record_field] = "record_field",
  [sym_record_last_field] = "record_last_field",
  [sym_field_path] = "field_path",
  [sym_field_path_elem] = "field_path_elem",
  [sym_last_match] = "last_match",
  [sym_pattern] = "pattern",
  [sym_destruct] = "destruct",
  [sym_match] = "match",
  [sym_default_annot] = "default_annot",
  [sym_bool] = "bool",
  [sym_str_chunks] = "str_chunks",
  [sym_str_chunks_single] = "str_chunks_single",
  [sym_str_chunks_multi] = "str_chunks_multi",
  [sym_chunk_expr] = "chunk_expr",
  [sym_static_string] = "static_string",
  [sym_quoted_enum_tag] = "quoted_enum_tag",
  [sym_enum_tag] = "enum_tag",
  [sym_chunk_literal_single] = "chunk_literal_single",
  [sym_chunk_literal_multi] = "chunk_literal_multi",
  [sym_percent] = "percent",
  [sym_builtin] = "builtin",
  [sym_match_case] = "match_case",
  [sym_infix_b_op_2] = "infix_b_op_2",
  [sym_infix_b_op_3] = "infix_b_op_3",
  [sym_infix_b_op_4] = "infix_b_op_4",
  [sym_infix_u_op_5] = "infix_u_op_5",
  [sym_infix_b_op_6] = "infix_b_op_6",
  [sym_infix_b_op_7] = "infix_b_op_7",
  [sym_infix_b_op_8] = "infix_b_op_8",
  [sym_infix_lazy_b_op_9] = "infix_lazy_b_op_9",
  [sym_infix_lazy_b_op_10] = "infix_lazy_b_op_10",
  [sym_infix_b_op] = "infix_b_op",
  [sym_infix_u_op_or_lazy_b_op] = "infix_u_op_or_lazy_b_op",
  [sym_infix_op] = "infix_op",
  [sym_curried_op] = "curried_op",
  [sym_infix_expr] = "infix_expr",
  [sym_type_builtin] = "type_builtin",
  [sym_type_atom] = "type_atom",
  [aux_sym_annot_repeat1] = "annot_repeat1",
  [aux_sym_fun_expr_repeat1] = "fun_expr_repeat1",
  [aux_sym_match_expr_repeat1] = "match_expr_repeat1",
  [aux_sym_forall_repeat1] = "forall_repeat1",
  [aux_sym_uni_record_repeat1] = "uni_record_repeat1",
  [aux_sym_atom_repeat1] = "atom_repeat1",
  [aux_sym_field_path_repeat1] = "field_path_repeat1",
  [aux_sym_destruct_repeat1] = "destruct_repeat1",
  [aux_sym_str_chunks_single_repeat1] = "str_chunks_single_repeat1",
  [aux_sym_str_chunks_multi_repeat1] = "str_chunks_multi_repeat1",
  [aux_sym_static_string_repeat1] = "static_string_repeat1",
  [aux_sym_static_string_repeat2] = "static_string_repeat2",
  [aux_sym_type_atom_repeat1] = "type_atom_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_keyword] = sym_keyword,
  [sym_num_literal] = sym_num_literal,
  [sym_signed_num_literal] = sym_signed_num_literal,
  [sym_ident] = sym_ident,
  [sym_raw_enum_tag] = sym_raw_enum_tag,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_force] = anon_sym_force,
  [anon_sym_optional] = anon_sym_optional,
  [anon_sym_priority] = anon_sym_priority,
  [anon_sym_doc] = anon_sym_doc,
  [anon_sym_rec] = anon_sym_rec,
  [anon_sym_not_exported] = anon_sym_not_exported,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_fun] = anon_sym_fun,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_forall] = anon_sym_forall,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_Array] = anon_sym_Array,
  [anon_sym_Dyn] = anon_sym_Dyn,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_null] = anon_sym_null,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [sym_double_quote] = sym_double_quote,
  [sym_str_literal] = sym_str_literal,
  [sym_mult_str_literal] = sym_mult_str_literal,
  [sym_str_esc_char] = sym_str_esc_char,
  [anon_sym__] = anon_sym__,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_Number] = anon_sym_Number,
  [anon_sym_Bool] = anon_sym_Bool,
  [anon_sym_String] = anon_sym_String,
  [anon_sym_LBRACK_PIPE] = anon_sym_LBRACK_PIPE,
  [anon_sym_PIPE_RBRACK] = anon_sym_PIPE_RBRACK,
  [sym_multstr_start] = sym_multstr_start,
  [sym_multstr_end] = sym_multstr_end,
  [sym__str_start] = sym__str_start,
  [sym__str_end] = sym__str_end,
  [sym_interpolation_start] = sym_interpolation_start,
  [sym_interpolation_end] = sym_interpolation_end,
  [sym_quoted_enum_tag_start] = sym_quoted_enum_tag_start,
  [sym_comment] = sym_comment,
  [sym_term] = sym_term,
  [sym_annot_atom] = sym_annot_atom,
  [sym_annot] = sym_annot,
  [sym_types] = sym_types,
  [sym_uni_term] = sym_uni_term,
  [sym_let_expr] = sym_let_expr,
  [sym_let_in_block] = sym_let_in_block,
  [sym_fun_expr] = sym_fun_expr,
  [sym_match_expr] = sym_match_expr,
  [sym_ite_expr] = sym_ite_expr,
  [sym_annotated_infix_expr] = sym_annotated_infix_expr,
  [sym_forall] = sym_forall,
  [sym_applicative] = sym_applicative,
  [sym_type_array] = sym_type_array,
  [sym_record_operand] = sym_record_operand,
  [sym_record_operation_chain] = sym_record_operation_chain,
  [sym_row_tail] = sym_row_tail,
  [sym_uni_record] = sym_uni_record,
  [sym_atom] = sym_atom,
  [sym_record_field] = sym_record_field,
  [sym_record_last_field] = sym_record_last_field,
  [sym_field_path] = sym_field_path,
  [sym_field_path_elem] = sym_field_path_elem,
  [sym_last_match] = sym_last_match,
  [sym_pattern] = sym_pattern,
  [sym_destruct] = sym_destruct,
  [sym_match] = sym_match,
  [sym_default_annot] = sym_default_annot,
  [sym_bool] = sym_bool,
  [sym_str_chunks] = sym_str_chunks,
  [sym_str_chunks_single] = sym_str_chunks_single,
  [sym_str_chunks_multi] = sym_str_chunks_multi,
  [sym_chunk_expr] = sym_chunk_expr,
  [sym_static_string] = sym_static_string,
  [sym_quoted_enum_tag] = sym_quoted_enum_tag,
  [sym_enum_tag] = sym_enum_tag,
  [sym_chunk_literal_single] = sym_chunk_literal_single,
  [sym_chunk_literal_multi] = sym_chunk_literal_multi,
  [sym_percent] = sym_percent,
  [sym_builtin] = sym_builtin,
  [sym_match_case] = sym_match_case,
  [sym_infix_b_op_2] = sym_infix_b_op_2,
  [sym_infix_b_op_3] = sym_infix_b_op_3,
  [sym_infix_b_op_4] = sym_infix_b_op_4,
  [sym_infix_u_op_5] = sym_infix_u_op_5,
  [sym_infix_b_op_6] = sym_infix_b_op_6,
  [sym_infix_b_op_7] = sym_infix_b_op_7,
  [sym_infix_b_op_8] = sym_infix_b_op_8,
  [sym_infix_lazy_b_op_9] = sym_infix_lazy_b_op_9,
  [sym_infix_lazy_b_op_10] = sym_infix_lazy_b_op_10,
  [sym_infix_b_op] = sym_infix_b_op,
  [sym_infix_u_op_or_lazy_b_op] = sym_infix_u_op_or_lazy_b_op,
  [sym_infix_op] = sym_infix_op,
  [sym_curried_op] = sym_curried_op,
  [sym_infix_expr] = sym_infix_expr,
  [sym_type_builtin] = sym_type_builtin,
  [sym_type_atom] = sym_type_atom,
  [aux_sym_annot_repeat1] = aux_sym_annot_repeat1,
  [aux_sym_fun_expr_repeat1] = aux_sym_fun_expr_repeat1,
  [aux_sym_match_expr_repeat1] = aux_sym_match_expr_repeat1,
  [aux_sym_forall_repeat1] = aux_sym_forall_repeat1,
  [aux_sym_uni_record_repeat1] = aux_sym_uni_record_repeat1,
  [aux_sym_atom_repeat1] = aux_sym_atom_repeat1,
  [aux_sym_field_path_repeat1] = aux_sym_field_path_repeat1,
  [aux_sym_destruct_repeat1] = aux_sym_destruct_repeat1,
  [aux_sym_str_chunks_single_repeat1] = aux_sym_str_chunks_single_repeat1,
  [aux_sym_str_chunks_multi_repeat1] = aux_sym_str_chunks_multi_repeat1,
  [aux_sym_static_string_repeat1] = aux_sym_static_string_repeat1,
  [aux_sym_static_string_repeat2] = aux_sym_static_string_repeat2,
  [aux_sym_type_atom_repeat1] = aux_sym_type_atom_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_num_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_signed_num_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_enum_tag] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_force] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_optional] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_priority] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_doc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not_exported] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Dyn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [sym_double_quote] = {
    .visible = true,
    .named = true,
  },
  [sym_str_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_mult_str_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_str_esc_char] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_String] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_multstr_start] = {
    .visible = true,
    .named = true,
  },
  [sym_multstr_end] = {
    .visible = true,
    .named = true,
  },
  [sym__str_start] = {
    .visible = false,
    .named = true,
  },
  [sym__str_end] = {
    .visible = false,
    .named = true,
  },
  [sym_interpolation_start] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation_end] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_enum_tag_start] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_annot_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_annot] = {
    .visible = true,
    .named = true,
  },
  [sym_types] = {
    .visible = true,
    .named = true,
  },
  [sym_uni_term] = {
    .visible = true,
    .named = true,
  },
  [sym_let_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in_block] = {
    .visible = true,
    .named = true,
  },
  [sym_fun_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_ite_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_annotated_infix_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_applicative] = {
    .visible = true,
    .named = true,
  },
  [sym_type_array] = {
    .visible = true,
    .named = true,
  },
  [sym_record_operand] = {
    .visible = true,
    .named = true,
  },
  [sym_record_operation_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_row_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_uni_record] = {
    .visible = true,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym_record_field] = {
    .visible = true,
    .named = true,
  },
  [sym_record_last_field] = {
    .visible = true,
    .named = true,
  },
  [sym_field_path] = {
    .visible = true,
    .named = true,
  },
  [sym_field_path_elem] = {
    .visible = true,
    .named = true,
  },
  [sym_last_match] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_destruct] = {
    .visible = true,
    .named = true,
  },
  [sym_match] = {
    .visible = true,
    .named = true,
  },
  [sym_default_annot] = {
    .visible = true,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_str_chunks] = {
    .visible = true,
    .named = true,
  },
  [sym_str_chunks_single] = {
    .visible = true,
    .named = true,
  },
  [sym_str_chunks_multi] = {
    .visible = true,
    .named = true,
  },
  [sym_chunk_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_static_string] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_enum_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_chunk_literal_single] = {
    .visible = true,
    .named = true,
  },
  [sym_chunk_literal_multi] = {
    .visible = true,
    .named = true,
  },
  [sym_percent] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_match_case] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_2] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_3] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_4] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_u_op_5] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_6] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_7] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op_8] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_lazy_b_op_9] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_lazy_b_op_10] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_b_op] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_u_op_or_lazy_b_op] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_curried_op] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_type_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_type_atom] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_annot_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fun_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_forall_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_uni_record_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_atom_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_destruct_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_str_chunks_single_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_str_chunks_multi_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_static_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_static_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_atom_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_ann = 1,
  field_anns = 2,
  field_binding = 3,
  field_cases = 4,
  field_chunks = 5,
  field_cond = 6,
  field_default = 7,
  field_doc = 8,
  field_end = 9,
  field_fields = 10,
  field_id = 11,
  field_ids = 12,
  field_last = 13,
  field_left = 14,
  field_matches = 15,
  field_meta = 16,
  field_op = 17,
  field_pat = 18,
  field_path = 19,
  field_pats = 20,
  field_priority = 21,
  field_right = 22,
  field_rows = 23,
  field_s = 24,
  field_start = 25,
  field_t = 26,
  field_t1 = 27,
  field_t2 = 28,
  field_t_id = 29,
  field_tag = 30,
  field_tail = 31,
  field_terms = 32,
  field_ty = 33,
  field_types = 34,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_ann] = "ann",
  [field_anns] = "anns",
  [field_binding] = "binding",
  [field_cases] = "cases",
  [field_chunks] = "chunks",
  [field_cond] = "cond",
  [field_default] = "default",
  [field_doc] = "doc",
  [field_end] = "end",
  [field_fields] = "fields",
  [field_id] = "id",
  [field_ids] = "ids",
  [field_last] = "last",
  [field_left] = "left",
  [field_matches] = "matches",
  [field_meta] = "meta",
  [field_op] = "op",
  [field_pat] = "pat",
  [field_path] = "path",
  [field_pats] = "pats",
  [field_priority] = "priority",
  [field_right] = "right",
  [field_rows] = "rows",
  [field_s] = "s",
  [field_start] = "start",
  [field_t] = "t",
  [field_t1] = "t1",
  [field_t2] = "t2",
  [field_t_id] = "t_id",
  [field_tag] = "tag",
  [field_tail] = "tail",
  [field_terms] = "terms",
  [field_ty] = "ty",
  [field_types] = "types",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 2},
  [8] = {.index = 10, .length = 2},
  [9] = {.index = 12, .length = 2},
  [10] = {.index = 14, .length = 1},
  [11] = {.index = 15, .length = 3},
  [12] = {.index = 18, .length = 1},
  [13] = {.index = 19, .length = 1},
  [14] = {.index = 20, .length = 2},
  [15] = {.index = 22, .length = 1},
  [16] = {.index = 23, .length = 1},
  [17] = {.index = 24, .length = 1},
  [18] = {.index = 25, .length = 2},
  [19] = {.index = 27, .length = 2},
  [20] = {.index = 29, .length = 1},
  [21] = {.index = 30, .length = 3},
  [22] = {.index = 33, .length = 3},
  [23] = {.index = 36, .length = 3},
  [24] = {.index = 39, .length = 2},
  [25] = {.index = 41, .length = 2},
  [26] = {.index = 43, .length = 1},
  [27] = {.index = 44, .length = 2},
  [28] = {.index = 46, .length = 1},
  [29] = {.index = 47, .length = 2},
  [30] = {.index = 49, .length = 3},
  [31] = {.index = 52, .length = 2},
  [32] = {.index = 54, .length = 2},
  [33] = {.index = 56, .length = 2},
  [34] = {.index = 58, .length = 2},
  [35] = {.index = 60, .length = 1},
  [36] = {.index = 61, .length = 1},
  [37] = {.index = 62, .length = 2},
  [38] = {.index = 64, .length = 1},
  [39] = {.index = 65, .length = 3},
  [40] = {.index = 68, .length = 2},
  [41] = {.index = 70, .length = 2},
  [42] = {.index = 72, .length = 1},
  [43] = {.index = 73, .length = 2},
  [44] = {.index = 75, .length = 2},
  [45] = {.index = 77, .length = 1},
  [46] = {.index = 78, .length = 3},
  [47] = {.index = 81, .length = 4},
  [48] = {.index = 85, .length = 3},
  [49] = {.index = 88, .length = 3},
  [50] = {.index = 91, .length = 3},
  [51] = {.index = 94, .length = 2},
  [52] = {.index = 96, .length = 3},
  [53] = {.index = 99, .length = 3},
  [54] = {.index = 102, .length = 3},
  [55] = {.index = 105, .length = 3},
  [56] = {.index = 108, .length = 4},
  [57] = {.index = 112, .length = 3},
  [58] = {.index = 115, .length = 4},
  [59] = {.index = 119, .length = 3},
  [60] = {.index = 122, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_end, 1},
    {field_start, 0},
  [2] =
    {field_id, 0},
  [3] =
    {field_pat, 0},
  [4] =
    {field_path, 0},
  [5] =
    {field_s, 1},
  [6] =
    {field_op, 0},
    {field_t, 1},
  [8] =
    {field_binding, 0},
    {field_t2, 1},
  [10] =
    {field_t1, 0},
    {field_t2, 1},
  [12] =
    {field_meta, 1},
    {field_t, 0},
  [14] =
    {field_anns, 0},
  [15] =
    {field_chunks, 1},
    {field_end, 2},
    {field_start, 0},
  [18] =
    {field_chunks, 1},
  [19] =
    {field_last, 1},
  [20] =
    {field_ann, 1},
    {field_path, 0},
  [22] =
    {field_fields, 1},
  [23] =
    {field_terms, 1},
  [24] =
    {field_rows, 1},
  [25] =
    {field_id, 2},
    {field_t, 0},
  [27] =
    {field_t, 0},
    {field_t_id, 2},
  [29] =
    {field_ty, 1},
  [30] =
    {field_op, 1},
    {field_t1, 0},
    {field_t2, 2},
  [33] =
    {field_end, 2},
    {field_start, 0},
    {field_t, 1},
  [36] =
    {field_id, 0},
    {field_id, 1},
    {field_pat, 2},
  [39] =
    {field_anns, 1},
    {field_id, 0},
  [41] =
    {field_default, 1},
    {field_id, 0},
  [43] =
    {field_matches, 1},
  [44] =
    {field_pats, 1},
    {field_t, 3},
  [46] =
    {field_cases, 2},
  [47] =
    {field_tail, 1},
    {field_tail, 2},
  [49] =
    {field_path, 0},
    {field_t, 1},
    {field_t, 2},
  [52] =
    {field_fields, 1},
    {field_last, 2},
  [54] =
    {field_ids, 1},
    {field_ty, 3},
  [56] =
    {field_terms, 1},
    {field_terms, 2},
  [58] =
    {field_rows, 1},
    {field_rows, 2},
  [60] =
    {field_priority, 2},
  [61] =
    {field_doc, 2},
  [62] =
    {field_left, 0},
    {field_right, 2},
  [64] =
    {field_t, 1},
  [65] =
    {field_anns, 1},
    {field_default, 2},
    {field_id, 0},
  [68] =
    {field_last, 2},
    {field_matches, 1},
  [70] =
    {field_pat, 1},
    {field_t1, 3},
  [72] =
    {field_t, 2},
  [73] =
    {field_t, 2},
    {field_tag, 0},
  [75] =
    {field_cases, 2},
    {field_cases, 3},
  [77] =
    {field_types, 3},
  [78] =
    {field_last, 1},
    {field_tail, 2},
    {field_tail, 3},
  [81] =
    {field_ann, 1},
    {field_path, 0},
    {field_t, 2},
    {field_t, 3},
  [85] =
    {field_fields, 1},
    {field_tail, 2},
    {field_tail, 3},
  [88] =
    {field_terms, 1},
    {field_terms, 2},
    {field_terms, 3},
  [91] =
    {field_rows, 1},
    {field_tail, 2},
    {field_tail, 3},
  [94] =
    {field_pat, 2},
    {field_t1, 4},
  [96] =
    {field_anns, 1},
    {field_left, 0},
    {field_right, 3},
  [99] =
    {field_default, 1},
    {field_left, 0},
    {field_right, 3},
  [102] =
    {field_meta, 2},
    {field_pat, 1},
    {field_t1, 4},
  [105] =
    {field_cases, 2},
    {field_cases, 3},
    {field_cases, 4},
  [108] =
    {field_fields, 1},
    {field_last, 2},
    {field_tail, 3},
    {field_tail, 4},
  [112] =
    {field_cond, 1},
    {field_t1, 3},
    {field_t2, 5},
  [115] =
    {field_rows, 1},
    {field_rows, 2},
    {field_tail, 3},
    {field_tail, 4},
  [119] =
    {field_meta, 3},
    {field_pat, 2},
    {field_t1, 5},
  [122] =
    {field_anns, 1},
    {field_default, 2},
    {field_left, 0},
    {field_right, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 2,
  [7] = 2,
  [8] = 8,
  [9] = 9,
  [10] = 9,
  [11] = 9,
  [12] = 9,
  [13] = 9,
  [14] = 9,
  [15] = 15,
  [16] = 16,
  [17] = 15,
  [18] = 15,
  [19] = 16,
  [20] = 15,
  [21] = 16,
  [22] = 15,
  [23] = 15,
  [24] = 16,
  [25] = 16,
  [26] = 16,
  [27] = 27,
  [28] = 27,
  [29] = 29,
  [30] = 30,
  [31] = 29,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 34,
  [36] = 36,
  [37] = 33,
  [38] = 34,
  [39] = 39,
  [40] = 29,
  [41] = 34,
  [42] = 39,
  [43] = 43,
  [44] = 39,
  [45] = 29,
  [46] = 46,
  [47] = 27,
  [48] = 29,
  [49] = 29,
  [50] = 39,
  [51] = 27,
  [52] = 52,
  [53] = 52,
  [54] = 27,
  [55] = 55,
  [56] = 34,
  [57] = 52,
  [58] = 58,
  [59] = 39,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 52,
  [64] = 27,
  [65] = 34,
  [66] = 39,
  [67] = 52,
  [68] = 52,
  [69] = 69,
  [70] = 8,
  [71] = 69,
  [72] = 69,
  [73] = 8,
  [74] = 69,
  [75] = 69,
  [76] = 69,
  [77] = 8,
  [78] = 8,
  [79] = 8,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 121,
  [124] = 124,
  [125] = 124,
  [126] = 122,
  [127] = 127,
  [128] = 121,
  [129] = 122,
  [130] = 130,
  [131] = 124,
  [132] = 121,
  [133] = 133,
  [134] = 124,
  [135] = 121,
  [136] = 136,
  [137] = 137,
  [138] = 124,
  [139] = 121,
  [140] = 122,
  [141] = 141,
  [142] = 122,
  [143] = 124,
  [144] = 122,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 148,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 154,
  [157] = 147,
  [158] = 155,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 153,
  [163] = 152,
  [164] = 151,
  [165] = 159,
  [166] = 160,
  [167] = 161,
  [168] = 153,
  [169] = 152,
  [170] = 161,
  [171] = 151,
  [172] = 160,
  [173] = 159,
  [174] = 150,
  [175] = 155,
  [176] = 147,
  [177] = 154,
  [178] = 148,
  [179] = 150,
  [180] = 148,
  [181] = 151,
  [182] = 152,
  [183] = 153,
  [184] = 161,
  [185] = 160,
  [186] = 159,
  [187] = 155,
  [188] = 147,
  [189] = 154,
  [190] = 148,
  [191] = 154,
  [192] = 147,
  [193] = 155,
  [194] = 159,
  [195] = 160,
  [196] = 161,
  [197] = 150,
  [198] = 153,
  [199] = 152,
  [200] = 151,
  [201] = 152,
  [202] = 151,
  [203] = 153,
  [204] = 161,
  [205] = 150,
  [206] = 160,
  [207] = 159,
  [208] = 155,
  [209] = 148,
  [210] = 147,
  [211] = 154,
  [212] = 150,
  [213] = 88,
  [214] = 94,
  [215] = 97,
  [216] = 103,
  [217] = 80,
  [218] = 88,
  [219] = 96,
  [220] = 95,
  [221] = 100,
  [222] = 99,
  [223] = 104,
  [224] = 86,
  [225] = 83,
  [226] = 106,
  [227] = 82,
  [228] = 87,
  [229] = 85,
  [230] = 81,
  [231] = 84,
  [232] = 98,
  [233] = 94,
  [234] = 110,
  [235] = 94,
  [236] = 109,
  [237] = 116,
  [238] = 105,
  [239] = 89,
  [240] = 91,
  [241] = 90,
  [242] = 101,
  [243] = 100,
  [244] = 99,
  [245] = 98,
  [246] = 115,
  [247] = 89,
  [248] = 105,
  [249] = 94,
  [250] = 93,
  [251] = 107,
  [252] = 108,
  [253] = 117,
  [254] = 111,
  [255] = 112,
  [256] = 114,
  [257] = 116,
  [258] = 113,
  [259] = 115,
  [260] = 92,
  [261] = 91,
  [262] = 118,
  [263] = 92,
  [264] = 98,
  [265] = 91,
  [266] = 82,
  [267] = 117,
  [268] = 83,
  [269] = 118,
  [270] = 86,
  [271] = 88,
  [272] = 80,
  [273] = 88,
  [274] = 90,
  [275] = 86,
  [276] = 83,
  [277] = 82,
  [278] = 88,
  [279] = 113,
  [280] = 80,
  [281] = 118,
  [282] = 115,
  [283] = 117,
  [284] = 91,
  [285] = 92,
  [286] = 82,
  [287] = 116,
  [288] = 83,
  [289] = 86,
  [290] = 114,
  [291] = 111,
  [292] = 108,
  [293] = 107,
  [294] = 93,
  [295] = 94,
  [296] = 113,
  [297] = 98,
  [298] = 80,
  [299] = 81,
  [300] = 106,
  [301] = 104,
  [302] = 103,
  [303] = 102,
  [304] = 112,
  [305] = 97,
  [306] = 99,
  [307] = 96,
  [308] = 100,
  [309] = 95,
  [310] = 101,
  [311] = 93,
  [312] = 87,
  [313] = 102,
  [314] = 85,
  [315] = 84,
  [316] = 110,
  [317] = 90,
  [318] = 109,
  [319] = 89,
  [320] = 105,
  [321] = 89,
  [322] = 112,
  [323] = 90,
  [324] = 101,
  [325] = 100,
  [326] = 99,
  [327] = 105,
  [328] = 98,
  [329] = 105,
  [330] = 109,
  [331] = 110,
  [332] = 114,
  [333] = 111,
  [334] = 84,
  [335] = 85,
  [336] = 87,
  [337] = 95,
  [338] = 96,
  [339] = 97,
  [340] = 108,
  [341] = 92,
  [342] = 101,
  [343] = 101,
  [344] = 93,
  [345] = 112,
  [346] = 113,
  [347] = 115,
  [348] = 92,
  [349] = 91,
  [350] = 107,
  [351] = 102,
  [352] = 99,
  [353] = 82,
  [354] = 83,
  [355] = 86,
  [356] = 109,
  [357] = 102,
  [358] = 103,
  [359] = 100,
  [360] = 81,
  [361] = 104,
  [362] = 106,
  [363] = 81,
  [364] = 103,
  [365] = 93,
  [366] = 106,
  [367] = 109,
  [368] = 107,
  [369] = 108,
  [370] = 111,
  [371] = 110,
  [372] = 114,
  [373] = 116,
  [374] = 110,
  [375] = 117,
  [376] = 84,
  [377] = 118,
  [378] = 85,
  [379] = 87,
  [380] = 95,
  [381] = 84,
  [382] = 85,
  [383] = 96,
  [384] = 80,
  [385] = 118,
  [386] = 117,
  [387] = 89,
  [388] = 116,
  [389] = 114,
  [390] = 115,
  [391] = 90,
  [392] = 113,
  [393] = 97,
  [394] = 112,
  [395] = 111,
  [396] = 108,
  [397] = 107,
  [398] = 87,
  [399] = 81,
  [400] = 104,
  [401] = 106,
  [402] = 104,
  [403] = 102,
  [404] = 103,
  [405] = 97,
  [406] = 96,
  [407] = 95,
  [408] = 141,
  [409] = 137,
  [410] = 137,
  [411] = 119,
  [412] = 120,
  [413] = 136,
  [414] = 141,
  [415] = 133,
  [416] = 127,
  [417] = 120,
  [418] = 133,
  [419] = 141,
  [420] = 130,
  [421] = 136,
  [422] = 141,
  [423] = 133,
  [424] = 136,
  [425] = 133,
  [426] = 130,
  [427] = 120,
  [428] = 127,
  [429] = 130,
  [430] = 133,
  [431] = 119,
  [432] = 141,
  [433] = 120,
  [434] = 136,
  [435] = 130,
  [436] = 120,
  [437] = 137,
  [438] = 130,
  [439] = 119,
  [440] = 119,
  [441] = 127,
  [442] = 119,
  [443] = 136,
  [444] = 127,
  [445] = 127,
  [446] = 137,
  [447] = 137,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 448,
  [463] = 461,
  [464] = 461,
  [465] = 461,
  [466] = 448,
  [467] = 448,
  [468] = 448,
  [469] = 448,
  [470] = 461,
  [471] = 461,
  [472] = 452,
  [473] = 454,
  [474] = 454,
  [475] = 459,
  [476] = 455,
  [477] = 457,
  [478] = 451,
  [479] = 452,
  [480] = 454,
  [481] = 450,
  [482] = 455,
  [483] = 457,
  [484] = 456,
  [485] = 451,
  [486] = 459,
  [487] = 452,
  [488] = 453,
  [489] = 449,
  [490] = 458,
  [491] = 459,
  [492] = 460,
  [493] = 456,
  [494] = 450,
  [495] = 450,
  [496] = 451,
  [497] = 457,
  [498] = 455,
  [499] = 453,
  [500] = 454,
  [501] = 453,
  [502] = 456,
  [503] = 460,
  [504] = 460,
  [505] = 458,
  [506] = 458,
  [507] = 449,
  [508] = 449,
  [509] = 452,
  [510] = 453,
  [511] = 454,
  [512] = 449,
  [513] = 458,
  [514] = 460,
  [515] = 456,
  [516] = 450,
  [517] = 451,
  [518] = 457,
  [519] = 455,
  [520] = 459,
  [521] = 452,
  [522] = 453,
  [523] = 459,
  [524] = 449,
  [525] = 458,
  [526] = 455,
  [527] = 457,
  [528] = 451,
  [529] = 450,
  [530] = 456,
  [531] = 460,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 545,
  [547] = 545,
  [548] = 545,
  [549] = 545,
  [550] = 545,
  [551] = 551,
  [552] = 551,
  [553] = 551,
  [554] = 551,
  [555] = 551,
  [556] = 551,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 119,
  [561] = 561,
  [562] = 562,
  [563] = 136,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 569,
  [572] = 570,
  [573] = 573,
  [574] = 574,
  [575] = 569,
  [576] = 576,
  [577] = 577,
  [578] = 570,
  [579] = 579,
  [580] = 580,
  [581] = 569,
  [582] = 570,
  [583] = 570,
  [584] = 570,
  [585] = 569,
  [586] = 569,
  [587] = 587,
  [588] = 570,
  [589] = 569,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 591,
  [594] = 594,
  [595] = 591,
  [596] = 591,
  [597] = 591,
  [598] = 594,
  [599] = 594,
  [600] = 594,
  [601] = 591,
  [602] = 591,
  [603] = 594,
  [604] = 604,
  [605] = 594,
  [606] = 594,
  [607] = 607,
  [608] = 608,
  [609] = 608,
  [610] = 610,
  [611] = 611,
  [612] = 608,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 613,
  [618] = 616,
  [619] = 613,
  [620] = 608,
  [621] = 616,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 608,
  [627] = 613,
  [628] = 616,
  [629] = 608,
  [630] = 608,
  [631] = 616,
  [632] = 616,
  [633] = 633,
  [634] = 613,
  [635] = 635,
  [636] = 616,
  [637] = 613,
  [638] = 608,
  [639] = 616,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 640,
  [644] = 644,
  [645] = 645,
  [646] = 642,
  [647] = 640,
  [648] = 648,
  [649] = 641,
  [650] = 641,
  [651] = 651,
  [652] = 89,
  [653] = 641,
  [654] = 90,
  [655] = 648,
  [656] = 656,
  [657] = 645,
  [658] = 648,
  [659] = 644,
  [660] = 644,
  [661] = 645,
  [662] = 644,
  [663] = 642,
  [664] = 642,
  [665] = 641,
  [666] = 640,
  [667] = 112,
  [668] = 648,
  [669] = 640,
  [670] = 644,
  [671] = 645,
  [672] = 642,
  [673] = 640,
  [674] = 648,
  [675] = 645,
  [676] = 642,
  [677] = 648,
  [678] = 644,
  [679] = 641,
  [680] = 680,
  [681] = 113,
  [682] = 648,
  [683] = 645,
  [684] = 645,
  [685] = 115,
  [686] = 645,
  [687] = 687,
  [688] = 641,
  [689] = 640,
  [690] = 641,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 692,
  [696] = 696,
  [697] = 694,
  [698] = 694,
  [699] = 692,
  [700] = 700,
  [701] = 692,
  [702] = 702,
  [703] = 703,
  [704] = 692,
  [705] = 696,
  [706] = 706,
  [707] = 694,
  [708] = 696,
  [709] = 696,
  [710] = 696,
  [711] = 694,
  [712] = 694,
  [713] = 713,
  [714] = 714,
  [715] = 696,
  [716] = 716,
  [717] = 717,
  [718] = 692,
  [719] = 719,
  [720] = 568,
  [721] = 721,
  [722] = 567,
  [723] = 723,
  [724] = 568,
  [725] = 567,
  [726] = 567,
  [727] = 727,
  [728] = 568,
  [729] = 568,
  [730] = 719,
  [731] = 693,
  [732] = 719,
  [733] = 568,
  [734] = 719,
  [735] = 706,
  [736] = 567,
  [737] = 737,
  [738] = 719,
  [739] = 714,
  [740] = 567,
  [741] = 719,
  [742] = 706,
  [743] = 743,
  [744] = 744,
  [745] = 93,
  [746] = 737,
  [747] = 747,
  [748] = 747,
  [749] = 749,
  [750] = 749,
  [751] = 747,
  [752] = 706,
  [753] = 105,
  [754] = 754,
  [755] = 747,
  [756] = 747,
  [757] = 749,
  [758] = 749,
  [759] = 759,
  [760] = 749,
  [761] = 761,
  [762] = 747,
  [763] = 88,
  [764] = 764,
  [765] = 765,
  [766] = 749,
  [767] = 767,
  [768] = 768,
  [769] = 557,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 768,
  [774] = 774,
  [775] = 775,
  [776] = 768,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 770,
  [781] = 561,
  [782] = 559,
  [783] = 558,
  [784] = 784,
  [785] = 785,
  [786] = 777,
  [787] = 785,
  [788] = 788,
  [789] = 777,
  [790] = 566,
  [791] = 791,
  [792] = 565,
  [793] = 564,
  [794] = 794,
  [795] = 779,
  [796] = 791,
  [797] = 775,
  [798] = 778,
  [799] = 779,
  [800] = 775,
  [801] = 770,
  [802] = 778,
  [803] = 119,
  [804] = 788,
  [805] = 778,
  [806] = 791,
  [807] = 777,
  [808] = 794,
  [809] = 775,
  [810] = 136,
  [811] = 779,
  [812] = 779,
  [813] = 794,
  [814] = 779,
  [815] = 815,
  [816] = 770,
  [817] = 817,
  [818] = 785,
  [819] = 819,
  [820] = 788,
  [821] = 777,
  [822] = 791,
  [823] = 823,
  [824] = 794,
  [825] = 785,
  [826] = 778,
  [827] = 768,
  [828] = 770,
  [829] = 788,
  [830] = 768,
  [831] = 791,
  [832] = 794,
  [833] = 833,
  [834] = 770,
  [835] = 788,
  [836] = 791,
  [837] = 794,
  [838] = 785,
  [839] = 785,
  [840] = 775,
  [841] = 775,
  [842] = 842,
  [843] = 778,
  [844] = 844,
  [845] = 777,
  [846] = 768,
  [847] = 847,
  [848] = 784,
  [849] = 788,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 852,
  [859] = 859,
  [860] = 857,
  [861] = 857,
  [862] = 852,
  [863] = 854,
  [864] = 852,
  [865] = 857,
  [866] = 866,
  [867] = 857,
  [868] = 851,
  [869] = 854,
  [870] = 852,
  [871] = 857,
  [872] = 872,
  [873] = 854,
  [874] = 852,
  [875] = 875,
  [876] = 875,
  [877] = 877,
  [878] = 878,
  [879] = 875,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 875,
  [885] = 854,
  [886] = 875,
  [887] = 875,
  [888] = 854,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 889,
  [896] = 894,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 897,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 577,
  [906] = 906,
  [907] = 907,
  [908] = 890,
  [909] = 909,
  [910] = 579,
  [911] = 543,
  [912] = 912,
  [913] = 900,
  [914] = 904,
  [915] = 915,
  [916] = 906,
  [917] = 899,
  [918] = 912,
  [919] = 912,
  [920] = 912,
  [921] = 899,
  [922] = 899,
  [923] = 923,
  [924] = 906,
  [925] = 892,
  [926] = 904,
  [927] = 890,
  [928] = 900,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 891,
  [933] = 892,
  [934] = 893,
  [935] = 890,
  [936] = 889,
  [937] = 937,
  [938] = 894,
  [939] = 897,
  [940] = 940,
  [941] = 891,
  [942] = 906,
  [943] = 931,
  [944] = 891,
  [945] = 904,
  [946] = 898,
  [947] = 947,
  [948] = 892,
  [949] = 537,
  [950] = 539,
  [951] = 540,
  [952] = 541,
  [953] = 542,
  [954] = 893,
  [955] = 955,
  [956] = 889,
  [957] = 897,
  [958] = 958,
  [959] = 959,
  [960] = 894,
  [961] = 940,
  [962] = 544,
  [963] = 894,
  [964] = 931,
  [965] = 965,
  [966] = 966,
  [967] = 587,
  [968] = 968,
  [969] = 900,
  [970] = 955,
  [971] = 893,
  [972] = 972,
  [973] = 958,
  [974] = 892,
  [975] = 940,
  [976] = 968,
  [977] = 891,
  [978] = 931,
  [979] = 889,
  [980] = 966,
  [981] = 897,
  [982] = 968,
  [983] = 538,
  [984] = 955,
  [985] = 931,
  [986] = 958,
  [987] = 958,
  [988] = 590,
  [989] = 940,
  [990] = 990,
  [991] = 890,
  [992] = 992,
  [993] = 966,
  [994] = 966,
  [995] = 890,
  [996] = 968,
  [997] = 937,
  [998] = 955,
  [999] = 899,
  [1000] = 912,
  [1001] = 958,
  [1002] = 1002,
  [1003] = 940,
  [1004] = 900,
  [1005] = 904,
  [1006] = 906,
  [1007] = 904,
  [1008] = 966,
  [1009] = 900,
  [1010] = 968,
  [1011] = 1011,
  [1012] = 955,
  [1013] = 906,
  [1014] = 1014,
  [1015] = 958,
  [1016] = 912,
  [1017] = 940,
  [1018] = 955,
  [1019] = 1019,
  [1020] = 899,
  [1021] = 1021,
  [1022] = 966,
  [1023] = 580,
  [1024] = 968,
  [1025] = 897,
  [1026] = 947,
  [1027] = 894,
  [1028] = 947,
  [1029] = 889,
  [1030] = 947,
  [1031] = 893,
  [1032] = 947,
  [1033] = 892,
  [1034] = 947,
  [1035] = 891,
  [1036] = 893,
  [1037] = 1037,
  [1038] = 931,
  [1039] = 576,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(75);
      if (lookahead == '!') ADVANCE(196);
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '&') ADVANCE(197);
      if (lookahead == '\'') ADVANCE(11);
      if (lookahead == '(') ADVANCE(174);
      if (lookahead == ')') ADVANCE(175);
      if (lookahead == '*') ADVANCE(192);
      if (lookahead == '+') ADVANCE(194);
      if (lookahead == ',') ADVANCE(167);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(170);
      if (lookahead == '/') ADVANCE(193);
      if (lookahead == ':') ADVANCE(161);
      if (lookahead == ';') ADVANCE(173);
      if (lookahead == '<') ADVANCE(199);
      if (lookahead == '=') ADVANCE(163);
      if (lookahead == '>') ADVANCE(201);
      if (lookahead == '?') ADVANCE(180);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == 'A') ADVANCE(137);
      if (lookahead == 'B') ADVANCE(120);
      if (lookahead == 'D') ADVANCE(152);
      if (lookahead == 'N') ADVANCE(148);
      if (lookahead == 'S') ADVANCE(145);
      if (lookahead == '[') ADVANCE(176);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == ']') ADVANCE(177);
      if (lookahead == '_') ADVANCE(190);
      if (lookahead == 'd') ADVANCE(93);
      if (lookahead == 'e') ADVANCE(110);
      if (lookahead == 'f') ADVANCE(83);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'l') ADVANCE(98);
      if (lookahead == 'm') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(122);
      if (lookahead == 'o') ADVANCE(128);
      if (lookahead == 'p') ADVANCE(130);
      if (lookahead == 'r') ADVANCE(94);
      if (lookahead == 't') ADVANCE(105);
      if (lookahead == '{') ADVANCE(166);
      if (lookahead == '|') ADVANCE(159);
      if (lookahead == '}') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (('C' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(182);
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(186);
      if (lookahead != 0) ADVANCE(187);
      END_STATE();
    case 2:
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '\\') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(183);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(184);
      END_STATE();
    case 3:
      if (lookahead == '\'') ADVANCE(11);
      if (lookahead == ',') ADVANCE(167);
      if (lookahead == '.') ADVANCE(169);
      if (lookahead == ';') ADVANCE(173);
      if (lookahead == '=') ADVANCE(8);
      if (lookahead == '_') ADVANCE(70);
      if (lookahead == '{') ADVANCE(166);
      if (lookahead == '|') ADVANCE(10);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 4:
      if (lookahead == ')') ADVANCE(175);
      if (lookahead == ',') ADVANCE(167);
      if (lookahead == '-') ADVANCE(6);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == ':') ADVANCE(161);
      if (lookahead == ';') ADVANCE(173);
      if (lookahead == '=') ADVANCE(164);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == '_') ADVANCE(190);
      if (lookahead == '{') ADVANCE(166);
      if (lookahead == '|') ADVANCE(158);
      if (lookahead == '}') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 7:
      if (lookahead == '=') ADVANCE(204);
      END_STATE();
    case 8:
      if (lookahead == '>') ADVANCE(165);
      END_STATE();
    case 9:
      if (lookahead == 'D') ADVANCE(152);
      if (lookahead == '_') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 10:
      if (lookahead == ']') ADVANCE(212);
      END_STATE();
    case 11:
      if (lookahead == '_') ADVANCE(71);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 12:
      if (lookahead == '_') ADVANCE(70);
      if (lookahead == 'd') ADVANCE(93);
      if (lookahead == 'e') ADVANCE(110);
      if (lookahead == 'f') ADVANCE(83);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'l') ADVANCE(98);
      if (lookahead == 'm') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(122);
      if (lookahead == 'o') ADVANCE(128);
      if (lookahead == 'p') ADVANCE(130);
      if (lookahead == 'r') ADVANCE(94);
      if (lookahead == 't') ADVANCE(105);
      if (lookahead == '{') ADVANCE(166);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 13:
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(52);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(39);
      if (lookahead == 'c') ADVANCE(25);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(60);
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(63);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(37);
      END_STATE();
    case 19:
      if (lookahead == 'c') ADVANCE(76);
      END_STATE();
    case 20:
      if (lookahead == 'c') ADVANCE(31);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(76);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(19);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 25:
      if (lookahead == 'e') ADVANCE(76);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(57);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(21);
      END_STATE();
    case 29:
      if (lookahead == 'f') ADVANCE(17);
      END_STATE();
    case 30:
      if (lookahead == 'g') ADVANCE(25);
      END_STATE();
    case 31:
      if (lookahead == 'h') ADVANCE(76);
      END_STATE();
    case 32:
      if (lookahead == 'h') ADVANCE(24);
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 33:
      if (lookahead == 'i') ADVANCE(46);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(42);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(59);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(56);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(76);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(57);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(18);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(58);
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 44:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 45:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 46:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 47:
      if (lookahead == 'p') ADVANCE(44);
      END_STATE();
    case 48:
      if (lookahead == 'p') ADVANCE(62);
      END_STATE();
    case 49:
      if (lookahead == 'p') ADVANCE(45);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(57);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(15);
      END_STATE();
    case 53:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 55:
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 56:
      if (lookahead == 's') ADVANCE(25);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 58:
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 59:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 60:
      if (lookahead == 't') ADVANCE(20);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(34);
      END_STATE();
    case 63:
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(25);
      END_STATE();
    case 65:
      if (lookahead == 'x') ADVANCE(49);
      END_STATE();
    case 66:
      if (lookahead == 'y') ADVANCE(76);
      END_STATE();
    case 67:
      if (lookahead == 'f' ||
          lookahead == 'n') ADVANCE(76);
      if (lookahead == 'm') ADVANCE(47);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      END_STATE();
    case 70:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 71:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 72:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(188);
      END_STATE();
    case 73:
      if (eof) ADVANCE(75);
      if (lookahead == '!') ADVANCE(7);
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '&') ADVANCE(197);
      if (lookahead == '\'') ADVANCE(11);
      if (lookahead == '(') ADVANCE(174);
      if (lookahead == ')') ADVANCE(175);
      if (lookahead == '*') ADVANCE(192);
      if (lookahead == '+') ADVANCE(194);
      if (lookahead == ',') ADVANCE(167);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(170);
      if (lookahead == '/') ADVANCE(193);
      if (lookahead == ':') ADVANCE(161);
      if (lookahead == ';') ADVANCE(173);
      if (lookahead == '<') ADVANCE(199);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(201);
      if (lookahead == '?') ADVANCE(180);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == 'B') ADVANCE(120);
      if (lookahead == 'D') ADVANCE(152);
      if (lookahead == 'N') ADVANCE(148);
      if (lookahead == 'S') ADVANCE(145);
      if (lookahead == '[') ADVANCE(176);
      if (lookahead == ']') ADVANCE(177);
      if (lookahead == '_') ADVANCE(190);
      if (lookahead == 'd') ADVANCE(93);
      if (lookahead == 'e') ADVANCE(110);
      if (lookahead == 'f') ADVANCE(83);
      if (lookahead == 'i') ADVANCE(155);
      if (lookahead == 'l') ADVANCE(98);
      if (lookahead == 'm') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(122);
      if (lookahead == 'o') ADVANCE(128);
      if (lookahead == 'p') ADVANCE(130);
      if (lookahead == 'r') ADVANCE(94);
      if (lookahead == 't') ADVANCE(105);
      if (lookahead == '{') ADVANCE(166);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '}') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(73)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 74:
      if (eof) ADVANCE(75);
      if (lookahead == '!') ADVANCE(7);
      if (lookahead == '%') ADVANCE(181);
      if (lookahead == '&') ADVANCE(197);
      if (lookahead == '\'') ADVANCE(11);
      if (lookahead == ')') ADVANCE(175);
      if (lookahead == '*') ADVANCE(192);
      if (lookahead == '+') ADVANCE(194);
      if (lookahead == ',') ADVANCE(167);
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '.') ADVANCE(169);
      if (lookahead == '/') ADVANCE(193);
      if (lookahead == ':') ADVANCE(161);
      if (lookahead == ';') ADVANCE(173);
      if (lookahead == '<') ADVANCE(199);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(201);
      if (lookahead == '?') ADVANCE(180);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == ']') ADVANCE(177);
      if (lookahead == '_') ADVANCE(189);
      if (lookahead == 'd') ADVANCE(22);
      if (lookahead == 'e') ADVANCE(36);
      if (lookahead == 'f') ADVANCE(14);
      if (lookahead == 'i') ADVANCE(67);
      if (lookahead == 'l') ADVANCE(26);
      if (lookahead == 'm') ADVANCE(16);
      if (lookahead == 'n') ADVANCE(43);
      if (lookahead == 'o') ADVANCE(48);
      if (lookahead == 'p') ADVANCE(51);
      if (lookahead == 'r') ADVANCE(23);
      if (lookahead == 't') ADVANCE(32);
      if (lookahead == '|') ADVANCE(160);
      if (lookahead == '}') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(74)
      END_STATE();
    case 75:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_keyword);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_keyword);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_num_literal);
      if (lookahead == '.') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_num_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_signed_num_literal);
      if (lookahead == '.') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_signed_num_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(81);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '_') ADVANCE(96);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(110);
      if (lookahead == 'o') ADVANCE(132);
      if (lookahead == 'u') ADVANCE(116);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(154);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(114);
      if (lookahead == 'c') ADVANCE(95);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(150);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(143);
      if (lookahead == 'e') ADVANCE(133);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(111);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'b') ADVANCE(100);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(77);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(104);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'd') ADVANCE(77);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(90);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(151);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(92);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(116);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(134);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'f') ADVANCE(86);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'g') ADVANCE(210);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'g') ADVANCE(95);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'h') ADVANCE(77);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'h') ADVANCE(99);
      if (lookahead == 'r') ADVANCE(149);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(118);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(123);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(144);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(125);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(140);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(77);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(209);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(141);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(111);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(89);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(77);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(172);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(102);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(121);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(112);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(142);
      if (lookahead == 'u') ADVANCE(114);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(119);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(135);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(138);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(139);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'p') ADVANCE(124);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'p') ADVANCE(147);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'p') ADVANCE(126);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(109);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(84);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(85);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(103);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(208);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(141);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(106);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(131);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(108);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(146);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(95);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(77);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(82);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(91);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(153);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(136);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(107);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(115);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(95);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(113);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'x') ADVANCE(129);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(117);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(77);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(171);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'f' ||
          lookahead == 'n') ADVANCE(77);
      if (lookahead == 'm') ADVANCE(127);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_raw_enum_tag);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(198);
      if (lookahead == ']') ADVANCE(212);
      if (lookahead == '|') ADVANCE(206);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(198);
      if (lookahead == '|') ADVANCE(206);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(203);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(203);
      if (lookahead == '>') ADVANCE(165);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(165);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_Array);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_Dyn);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '|') ADVANCE(211);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_double_quote);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_str_literal);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(183);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_str_literal);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_mult_str_literal);
      if (lookahead == '\n') ADVANCE(187);
      if (lookahead == '"' ||
          lookahead == '%') ADVANCE(188);
      if (lookahead != 0) ADVANCE(187);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_mult_str_literal);
      if (lookahead == '\\') ADVANCE(185);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%') ADVANCE(187);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_mult_str_literal);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%') ADVANCE(187);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_str_esc_char);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym__);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(191);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(207);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(204);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(205);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(200);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(202);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_Number);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_Bool);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_String);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(156);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_LBRACK_PIPE);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACK);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'd') ADVANCE(1);
      if (lookahead == 'e') ADVANCE(2);
      if (lookahead == 'f') ADVANCE(3);
      if (lookahead == 'i') ADVANCE(4);
      if (lookahead == 'l') ADVANCE(5);
      if (lookahead == 'm') ADVANCE(6);
      if (lookahead == 'n') ADVANCE(7);
      if (lookahead == 'o') ADVANCE(8);
      if (lookahead == 'p') ADVANCE(9);
      if (lookahead == 'r') ADVANCE(10);
      if (lookahead == 't') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'e') ADVANCE(12);
      if (lookahead == 'o') ADVANCE(13);
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(14);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'u') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'f') ADVANCE(18);
      if (lookahead == 'm') ADVANCE(19);
      if (lookahead == 'n') ADVANCE(20);
      END_STATE();
    case 5:
      if (lookahead == 'e') ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'u') ADVANCE(24);
      END_STATE();
    case 8:
      if (lookahead == 'p') ADVANCE(25);
      END_STATE();
    case 9:
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(27);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(30);
      END_STATE();
    case 13:
      if (lookahead == 'c') ADVANCE(31);
      END_STATE();
    case 14:
      if (lookahead == 's') ADVANCE(32);
      END_STATE();
    case 15:
      if (lookahead == 'l') ADVANCE(33);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(34);
      END_STATE();
    case 17:
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 19:
      if (lookahead == 'p') ADVANCE(36);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 21:
      if (lookahead == 't') ADVANCE(37);
      END_STATE();
    case 22:
      if (lookahead == 't') ADVANCE(38);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 24:
      if (lookahead == 'l') ADVANCE(40);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(42);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(43);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 29:
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(46);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_doc);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 33:
      if (lookahead == 's') ADVANCE(48);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'c') ADVANCE(50);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_fun);
      END_STATE();
    case 36:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 38:
      if (lookahead == 'c') ADVANCE(52);
      END_STATE();
    case 39:
      if (lookahead == '_') ADVANCE(53);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(54);
      END_STATE();
    case 41:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_rec);
      END_STATE();
    case 44:
      if (lookahead == 'n') ADVANCE(57);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 46:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(61);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(63);
      END_STATE();
    case 52:
      if (lookahead == 'h') ADVANCE(64);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_null);
      END_STATE();
    case 55:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 59:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 61:
      if (lookahead == 'l') ADVANCE(69);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_force);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 65:
      if (lookahead == 'x') ADVANCE(71);
      END_STATE();
    case 66:
      if (lookahead == 'n') ADVANCE(72);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(73);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(74);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_forall);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 71:
      if (lookahead == 'p') ADVANCE(75);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 75:
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 76:
      if (lookahead == 'l') ADVANCE(79);
      END_STATE();
    case 77:
      if (lookahead == 'y') ADVANCE(80);
      END_STATE();
    case 78:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_optional);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_priority);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 83:
      if (lookahead == 'd') ADVANCE(84);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_not_exported);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 0, .external_lex_state = 2},
  [3] = {.lex_state = 0, .external_lex_state = 2},
  [4] = {.lex_state = 0, .external_lex_state = 2},
  [5] = {.lex_state = 0, .external_lex_state = 2},
  [6] = {.lex_state = 0, .external_lex_state = 2},
  [7] = {.lex_state = 0, .external_lex_state = 2},
  [8] = {.lex_state = 73, .external_lex_state = 2},
  [9] = {.lex_state = 0, .external_lex_state = 2},
  [10] = {.lex_state = 0, .external_lex_state = 2},
  [11] = {.lex_state = 0, .external_lex_state = 2},
  [12] = {.lex_state = 0, .external_lex_state = 2},
  [13] = {.lex_state = 0, .external_lex_state = 2},
  [14] = {.lex_state = 0, .external_lex_state = 2},
  [15] = {.lex_state = 0, .external_lex_state = 2},
  [16] = {.lex_state = 0, .external_lex_state = 2},
  [17] = {.lex_state = 0, .external_lex_state = 2},
  [18] = {.lex_state = 0, .external_lex_state = 2},
  [19] = {.lex_state = 0, .external_lex_state = 2},
  [20] = {.lex_state = 0, .external_lex_state = 2},
  [21] = {.lex_state = 0, .external_lex_state = 2},
  [22] = {.lex_state = 0, .external_lex_state = 2},
  [23] = {.lex_state = 0, .external_lex_state = 2},
  [24] = {.lex_state = 0, .external_lex_state = 2},
  [25] = {.lex_state = 0, .external_lex_state = 2},
  [26] = {.lex_state = 0, .external_lex_state = 2},
  [27] = {.lex_state = 0, .external_lex_state = 2},
  [28] = {.lex_state = 0, .external_lex_state = 2},
  [29] = {.lex_state = 0, .external_lex_state = 2},
  [30] = {.lex_state = 0, .external_lex_state = 2},
  [31] = {.lex_state = 0, .external_lex_state = 2},
  [32] = {.lex_state = 0, .external_lex_state = 2},
  [33] = {.lex_state = 0, .external_lex_state = 2},
  [34] = {.lex_state = 0, .external_lex_state = 2},
  [35] = {.lex_state = 0, .external_lex_state = 2},
  [36] = {.lex_state = 0, .external_lex_state = 2},
  [37] = {.lex_state = 0, .external_lex_state = 2},
  [38] = {.lex_state = 0, .external_lex_state = 2},
  [39] = {.lex_state = 0, .external_lex_state = 2},
  [40] = {.lex_state = 0, .external_lex_state = 2},
  [41] = {.lex_state = 0, .external_lex_state = 2},
  [42] = {.lex_state = 0, .external_lex_state = 2},
  [43] = {.lex_state = 0, .external_lex_state = 2},
  [44] = {.lex_state = 0, .external_lex_state = 2},
  [45] = {.lex_state = 0, .external_lex_state = 2},
  [46] = {.lex_state = 0, .external_lex_state = 2},
  [47] = {.lex_state = 0, .external_lex_state = 2},
  [48] = {.lex_state = 0, .external_lex_state = 2},
  [49] = {.lex_state = 0, .external_lex_state = 2},
  [50] = {.lex_state = 0, .external_lex_state = 2},
  [51] = {.lex_state = 0, .external_lex_state = 2},
  [52] = {.lex_state = 0, .external_lex_state = 2},
  [53] = {.lex_state = 0, .external_lex_state = 2},
  [54] = {.lex_state = 0, .external_lex_state = 2},
  [55] = {.lex_state = 0, .external_lex_state = 2},
  [56] = {.lex_state = 0, .external_lex_state = 2},
  [57] = {.lex_state = 0, .external_lex_state = 2},
  [58] = {.lex_state = 0, .external_lex_state = 2},
  [59] = {.lex_state = 0, .external_lex_state = 2},
  [60] = {.lex_state = 0, .external_lex_state = 2},
  [61] = {.lex_state = 0, .external_lex_state = 2},
  [62] = {.lex_state = 0, .external_lex_state = 2},
  [63] = {.lex_state = 0, .external_lex_state = 2},
  [64] = {.lex_state = 0, .external_lex_state = 2},
  [65] = {.lex_state = 0, .external_lex_state = 2},
  [66] = {.lex_state = 0, .external_lex_state = 2},
  [67] = {.lex_state = 0, .external_lex_state = 2},
  [68] = {.lex_state = 0, .external_lex_state = 2},
  [69] = {.lex_state = 0, .external_lex_state = 2},
  [70] = {.lex_state = 73, .external_lex_state = 2},
  [71] = {.lex_state = 0, .external_lex_state = 2},
  [72] = {.lex_state = 0, .external_lex_state = 2},
  [73] = {.lex_state = 73, .external_lex_state = 2},
  [74] = {.lex_state = 0, .external_lex_state = 2},
  [75] = {.lex_state = 0, .external_lex_state = 2},
  [76] = {.lex_state = 0, .external_lex_state = 2},
  [77] = {.lex_state = 73, .external_lex_state = 3},
  [78] = {.lex_state = 73, .external_lex_state = 2},
  [79] = {.lex_state = 73, .external_lex_state = 2},
  [80] = {.lex_state = 73, .external_lex_state = 2},
  [81] = {.lex_state = 73, .external_lex_state = 2},
  [82] = {.lex_state = 73, .external_lex_state = 2},
  [83] = {.lex_state = 73, .external_lex_state = 2},
  [84] = {.lex_state = 73, .external_lex_state = 2},
  [85] = {.lex_state = 73, .external_lex_state = 2},
  [86] = {.lex_state = 73, .external_lex_state = 2},
  [87] = {.lex_state = 73, .external_lex_state = 2},
  [88] = {.lex_state = 73, .external_lex_state = 2},
  [89] = {.lex_state = 73, .external_lex_state = 2},
  [90] = {.lex_state = 73, .external_lex_state = 2},
  [91] = {.lex_state = 73, .external_lex_state = 2},
  [92] = {.lex_state = 73, .external_lex_state = 2},
  [93] = {.lex_state = 73, .external_lex_state = 2},
  [94] = {.lex_state = 73, .external_lex_state = 2},
  [95] = {.lex_state = 73, .external_lex_state = 2},
  [96] = {.lex_state = 73, .external_lex_state = 2},
  [97] = {.lex_state = 73, .external_lex_state = 2},
  [98] = {.lex_state = 73, .external_lex_state = 2},
  [99] = {.lex_state = 73, .external_lex_state = 2},
  [100] = {.lex_state = 73, .external_lex_state = 2},
  [101] = {.lex_state = 73, .external_lex_state = 2},
  [102] = {.lex_state = 73, .external_lex_state = 2},
  [103] = {.lex_state = 73, .external_lex_state = 2},
  [104] = {.lex_state = 73, .external_lex_state = 2},
  [105] = {.lex_state = 73, .external_lex_state = 2},
  [106] = {.lex_state = 73, .external_lex_state = 2},
  [107] = {.lex_state = 73, .external_lex_state = 2},
  [108] = {.lex_state = 73, .external_lex_state = 2},
  [109] = {.lex_state = 73, .external_lex_state = 2},
  [110] = {.lex_state = 73, .external_lex_state = 2},
  [111] = {.lex_state = 73, .external_lex_state = 2},
  [112] = {.lex_state = 73, .external_lex_state = 2},
  [113] = {.lex_state = 73, .external_lex_state = 2},
  [114] = {.lex_state = 73, .external_lex_state = 2},
  [115] = {.lex_state = 73, .external_lex_state = 2},
  [116] = {.lex_state = 73, .external_lex_state = 2},
  [117] = {.lex_state = 73, .external_lex_state = 2},
  [118] = {.lex_state = 73, .external_lex_state = 2},
  [119] = {.lex_state = 73, .external_lex_state = 2},
  [120] = {.lex_state = 73, .external_lex_state = 2},
  [121] = {.lex_state = 0, .external_lex_state = 2},
  [122] = {.lex_state = 0, .external_lex_state = 2},
  [123] = {.lex_state = 0, .external_lex_state = 2},
  [124] = {.lex_state = 0, .external_lex_state = 2},
  [125] = {.lex_state = 0, .external_lex_state = 2},
  [126] = {.lex_state = 0, .external_lex_state = 2},
  [127] = {.lex_state = 73, .external_lex_state = 2},
  [128] = {.lex_state = 0, .external_lex_state = 2},
  [129] = {.lex_state = 0, .external_lex_state = 2},
  [130] = {.lex_state = 73, .external_lex_state = 2},
  [131] = {.lex_state = 0, .external_lex_state = 2},
  [132] = {.lex_state = 0, .external_lex_state = 2},
  [133] = {.lex_state = 73, .external_lex_state = 2},
  [134] = {.lex_state = 0, .external_lex_state = 2},
  [135] = {.lex_state = 0, .external_lex_state = 2},
  [136] = {.lex_state = 73, .external_lex_state = 2},
  [137] = {.lex_state = 73, .external_lex_state = 2},
  [138] = {.lex_state = 0, .external_lex_state = 2},
  [139] = {.lex_state = 0, .external_lex_state = 2},
  [140] = {.lex_state = 0, .external_lex_state = 2},
  [141] = {.lex_state = 73, .external_lex_state = 2},
  [142] = {.lex_state = 0, .external_lex_state = 2},
  [143] = {.lex_state = 0, .external_lex_state = 2},
  [144] = {.lex_state = 0, .external_lex_state = 2},
  [145] = {.lex_state = 0, .external_lex_state = 2},
  [146] = {.lex_state = 0, .external_lex_state = 2},
  [147] = {.lex_state = 0, .external_lex_state = 2},
  [148] = {.lex_state = 0, .external_lex_state = 2},
  [149] = {.lex_state = 0, .external_lex_state = 2},
  [150] = {.lex_state = 0, .external_lex_state = 2},
  [151] = {.lex_state = 0, .external_lex_state = 2},
  [152] = {.lex_state = 0, .external_lex_state = 2},
  [153] = {.lex_state = 0, .external_lex_state = 2},
  [154] = {.lex_state = 0, .external_lex_state = 2},
  [155] = {.lex_state = 0, .external_lex_state = 2},
  [156] = {.lex_state = 0, .external_lex_state = 2},
  [157] = {.lex_state = 0, .external_lex_state = 2},
  [158] = {.lex_state = 0, .external_lex_state = 2},
  [159] = {.lex_state = 0, .external_lex_state = 2},
  [160] = {.lex_state = 0, .external_lex_state = 2},
  [161] = {.lex_state = 0, .external_lex_state = 2},
  [162] = {.lex_state = 0, .external_lex_state = 2},
  [163] = {.lex_state = 0, .external_lex_state = 2},
  [164] = {.lex_state = 0, .external_lex_state = 2},
  [165] = {.lex_state = 0, .external_lex_state = 2},
  [166] = {.lex_state = 0, .external_lex_state = 2},
  [167] = {.lex_state = 0, .external_lex_state = 2},
  [168] = {.lex_state = 0, .external_lex_state = 2},
  [169] = {.lex_state = 0, .external_lex_state = 2},
  [170] = {.lex_state = 0, .external_lex_state = 2},
  [171] = {.lex_state = 0, .external_lex_state = 2},
  [172] = {.lex_state = 0, .external_lex_state = 2},
  [173] = {.lex_state = 0, .external_lex_state = 2},
  [174] = {.lex_state = 0, .external_lex_state = 2},
  [175] = {.lex_state = 0, .external_lex_state = 2},
  [176] = {.lex_state = 0, .external_lex_state = 2},
  [177] = {.lex_state = 0, .external_lex_state = 2},
  [178] = {.lex_state = 0, .external_lex_state = 2},
  [179] = {.lex_state = 0, .external_lex_state = 2},
  [180] = {.lex_state = 0, .external_lex_state = 2},
  [181] = {.lex_state = 0, .external_lex_state = 2},
  [182] = {.lex_state = 0, .external_lex_state = 2},
  [183] = {.lex_state = 0, .external_lex_state = 2},
  [184] = {.lex_state = 0, .external_lex_state = 2},
  [185] = {.lex_state = 0, .external_lex_state = 2},
  [186] = {.lex_state = 0, .external_lex_state = 2},
  [187] = {.lex_state = 0, .external_lex_state = 2},
  [188] = {.lex_state = 0, .external_lex_state = 2},
  [189] = {.lex_state = 0, .external_lex_state = 2},
  [190] = {.lex_state = 0, .external_lex_state = 2},
  [191] = {.lex_state = 0, .external_lex_state = 2},
  [192] = {.lex_state = 0, .external_lex_state = 2},
  [193] = {.lex_state = 0, .external_lex_state = 2},
  [194] = {.lex_state = 0, .external_lex_state = 2},
  [195] = {.lex_state = 0, .external_lex_state = 2},
  [196] = {.lex_state = 0, .external_lex_state = 2},
  [197] = {.lex_state = 0, .external_lex_state = 2},
  [198] = {.lex_state = 0, .external_lex_state = 2},
  [199] = {.lex_state = 0, .external_lex_state = 2},
  [200] = {.lex_state = 0, .external_lex_state = 2},
  [201] = {.lex_state = 0, .external_lex_state = 2},
  [202] = {.lex_state = 0, .external_lex_state = 2},
  [203] = {.lex_state = 0, .external_lex_state = 2},
  [204] = {.lex_state = 0, .external_lex_state = 2},
  [205] = {.lex_state = 0, .external_lex_state = 2},
  [206] = {.lex_state = 0, .external_lex_state = 2},
  [207] = {.lex_state = 0, .external_lex_state = 2},
  [208] = {.lex_state = 0, .external_lex_state = 2},
  [209] = {.lex_state = 0, .external_lex_state = 2},
  [210] = {.lex_state = 0, .external_lex_state = 2},
  [211] = {.lex_state = 0, .external_lex_state = 2},
  [212] = {.lex_state = 0, .external_lex_state = 2},
  [213] = {.lex_state = 73, .external_lex_state = 3},
  [214] = {.lex_state = 73, .external_lex_state = 2},
  [215] = {.lex_state = 73, .external_lex_state = 2},
  [216] = {.lex_state = 73, .external_lex_state = 2},
  [217] = {.lex_state = 73, .external_lex_state = 2},
  [218] = {.lex_state = 73, .external_lex_state = 2},
  [219] = {.lex_state = 73, .external_lex_state = 2},
  [220] = {.lex_state = 73, .external_lex_state = 2},
  [221] = {.lex_state = 73, .external_lex_state = 3},
  [222] = {.lex_state = 73, .external_lex_state = 3},
  [223] = {.lex_state = 73, .external_lex_state = 2},
  [224] = {.lex_state = 73, .external_lex_state = 2},
  [225] = {.lex_state = 73, .external_lex_state = 2},
  [226] = {.lex_state = 73, .external_lex_state = 2},
  [227] = {.lex_state = 73, .external_lex_state = 2},
  [228] = {.lex_state = 73, .external_lex_state = 2},
  [229] = {.lex_state = 73, .external_lex_state = 2},
  [230] = {.lex_state = 73, .external_lex_state = 2},
  [231] = {.lex_state = 73, .external_lex_state = 2},
  [232] = {.lex_state = 73, .external_lex_state = 3},
  [233] = {.lex_state = 73, .external_lex_state = 2},
  [234] = {.lex_state = 73, .external_lex_state = 2},
  [235] = {.lex_state = 73, .external_lex_state = 3},
  [236] = {.lex_state = 73, .external_lex_state = 2},
  [237] = {.lex_state = 73, .external_lex_state = 2},
  [238] = {.lex_state = 73, .external_lex_state = 2},
  [239] = {.lex_state = 73, .external_lex_state = 2},
  [240] = {.lex_state = 73, .external_lex_state = 2},
  [241] = {.lex_state = 73, .external_lex_state = 2},
  [242] = {.lex_state = 73, .external_lex_state = 2},
  [243] = {.lex_state = 73, .external_lex_state = 2},
  [244] = {.lex_state = 73, .external_lex_state = 2},
  [245] = {.lex_state = 73, .external_lex_state = 2},
  [246] = {.lex_state = 73, .external_lex_state = 2},
  [247] = {.lex_state = 73, .external_lex_state = 2},
  [248] = {.lex_state = 73, .external_lex_state = 2},
  [249] = {.lex_state = 73, .external_lex_state = 2},
  [250] = {.lex_state = 73, .external_lex_state = 2},
  [251] = {.lex_state = 73, .external_lex_state = 2},
  [252] = {.lex_state = 73, .external_lex_state = 2},
  [253] = {.lex_state = 73, .external_lex_state = 2},
  [254] = {.lex_state = 73, .external_lex_state = 2},
  [255] = {.lex_state = 73, .external_lex_state = 2},
  [256] = {.lex_state = 73, .external_lex_state = 2},
  [257] = {.lex_state = 73, .external_lex_state = 2},
  [258] = {.lex_state = 73, .external_lex_state = 2},
  [259] = {.lex_state = 73, .external_lex_state = 2},
  [260] = {.lex_state = 73, .external_lex_state = 2},
  [261] = {.lex_state = 73, .external_lex_state = 2},
  [262] = {.lex_state = 73, .external_lex_state = 2},
  [263] = {.lex_state = 73, .external_lex_state = 3},
  [264] = {.lex_state = 73, .external_lex_state = 2},
  [265] = {.lex_state = 73, .external_lex_state = 3},
  [266] = {.lex_state = 73, .external_lex_state = 2},
  [267] = {.lex_state = 73, .external_lex_state = 2},
  [268] = {.lex_state = 73, .external_lex_state = 2},
  [269] = {.lex_state = 73, .external_lex_state = 2},
  [270] = {.lex_state = 73, .external_lex_state = 2},
  [271] = {.lex_state = 73, .external_lex_state = 2},
  [272] = {.lex_state = 73, .external_lex_state = 2},
  [273] = {.lex_state = 73, .external_lex_state = 2},
  [274] = {.lex_state = 73, .external_lex_state = 2},
  [275] = {.lex_state = 73, .external_lex_state = 2},
  [276] = {.lex_state = 73, .external_lex_state = 2},
  [277] = {.lex_state = 73, .external_lex_state = 2},
  [278] = {.lex_state = 73, .external_lex_state = 2},
  [279] = {.lex_state = 73, .external_lex_state = 2},
  [280] = {.lex_state = 73, .external_lex_state = 2},
  [281] = {.lex_state = 73, .external_lex_state = 2},
  [282] = {.lex_state = 73, .external_lex_state = 2},
  [283] = {.lex_state = 73, .external_lex_state = 2},
  [284] = {.lex_state = 73, .external_lex_state = 2},
  [285] = {.lex_state = 73, .external_lex_state = 2},
  [286] = {.lex_state = 73, .external_lex_state = 3},
  [287] = {.lex_state = 73, .external_lex_state = 2},
  [288] = {.lex_state = 73, .external_lex_state = 3},
  [289] = {.lex_state = 73, .external_lex_state = 3},
  [290] = {.lex_state = 73, .external_lex_state = 2},
  [291] = {.lex_state = 73, .external_lex_state = 2},
  [292] = {.lex_state = 73, .external_lex_state = 2},
  [293] = {.lex_state = 73, .external_lex_state = 2},
  [294] = {.lex_state = 73, .external_lex_state = 2},
  [295] = {.lex_state = 73, .external_lex_state = 2},
  [296] = {.lex_state = 73, .external_lex_state = 2},
  [297] = {.lex_state = 73, .external_lex_state = 2},
  [298] = {.lex_state = 73, .external_lex_state = 3},
  [299] = {.lex_state = 73, .external_lex_state = 2},
  [300] = {.lex_state = 73, .external_lex_state = 2},
  [301] = {.lex_state = 73, .external_lex_state = 2},
  [302] = {.lex_state = 73, .external_lex_state = 2},
  [303] = {.lex_state = 73, .external_lex_state = 2},
  [304] = {.lex_state = 73, .external_lex_state = 2},
  [305] = {.lex_state = 73, .external_lex_state = 2},
  [306] = {.lex_state = 73, .external_lex_state = 2},
  [307] = {.lex_state = 73, .external_lex_state = 2},
  [308] = {.lex_state = 73, .external_lex_state = 2},
  [309] = {.lex_state = 73, .external_lex_state = 2},
  [310] = {.lex_state = 73, .external_lex_state = 2},
  [311] = {.lex_state = 73, .external_lex_state = 2},
  [312] = {.lex_state = 73, .external_lex_state = 2},
  [313] = {.lex_state = 73, .external_lex_state = 2},
  [314] = {.lex_state = 73, .external_lex_state = 2},
  [315] = {.lex_state = 73, .external_lex_state = 2},
  [316] = {.lex_state = 73, .external_lex_state = 2},
  [317] = {.lex_state = 73, .external_lex_state = 2},
  [318] = {.lex_state = 73, .external_lex_state = 2},
  [319] = {.lex_state = 73, .external_lex_state = 2},
  [320] = {.lex_state = 73, .external_lex_state = 3},
  [321] = {.lex_state = 73, .external_lex_state = 3},
  [322] = {.lex_state = 73, .external_lex_state = 2},
  [323] = {.lex_state = 73, .external_lex_state = 3},
  [324] = {.lex_state = 73, .external_lex_state = 2},
  [325] = {.lex_state = 73, .external_lex_state = 2},
  [326] = {.lex_state = 73, .external_lex_state = 2},
  [327] = {.lex_state = 73, .external_lex_state = 2},
  [328] = {.lex_state = 73, .external_lex_state = 2},
  [329] = {.lex_state = 73, .external_lex_state = 2},
  [330] = {.lex_state = 73, .external_lex_state = 2},
  [331] = {.lex_state = 73, .external_lex_state = 2},
  [332] = {.lex_state = 73, .external_lex_state = 2},
  [333] = {.lex_state = 73, .external_lex_state = 2},
  [334] = {.lex_state = 73, .external_lex_state = 2},
  [335] = {.lex_state = 73, .external_lex_state = 2},
  [336] = {.lex_state = 73, .external_lex_state = 2},
  [337] = {.lex_state = 73, .external_lex_state = 2},
  [338] = {.lex_state = 73, .external_lex_state = 2},
  [339] = {.lex_state = 73, .external_lex_state = 2},
  [340] = {.lex_state = 73, .external_lex_state = 2},
  [341] = {.lex_state = 73, .external_lex_state = 2},
  [342] = {.lex_state = 73, .external_lex_state = 3},
  [343] = {.lex_state = 73, .external_lex_state = 2},
  [344] = {.lex_state = 73, .external_lex_state = 3},
  [345] = {.lex_state = 73, .external_lex_state = 3},
  [346] = {.lex_state = 73, .external_lex_state = 3},
  [347] = {.lex_state = 73, .external_lex_state = 3},
  [348] = {.lex_state = 73, .external_lex_state = 2},
  [349] = {.lex_state = 73, .external_lex_state = 2},
  [350] = {.lex_state = 73, .external_lex_state = 2},
  [351] = {.lex_state = 73, .external_lex_state = 2},
  [352] = {.lex_state = 73, .external_lex_state = 2},
  [353] = {.lex_state = 73, .external_lex_state = 2},
  [354] = {.lex_state = 73, .external_lex_state = 2},
  [355] = {.lex_state = 73, .external_lex_state = 2},
  [356] = {.lex_state = 73, .external_lex_state = 2},
  [357] = {.lex_state = 73, .external_lex_state = 2},
  [358] = {.lex_state = 73, .external_lex_state = 2},
  [359] = {.lex_state = 73, .external_lex_state = 2},
  [360] = {.lex_state = 73, .external_lex_state = 2},
  [361] = {.lex_state = 73, .external_lex_state = 2},
  [362] = {.lex_state = 73, .external_lex_state = 2},
  [363] = {.lex_state = 73, .external_lex_state = 2},
  [364] = {.lex_state = 73, .external_lex_state = 2},
  [365] = {.lex_state = 73, .external_lex_state = 2},
  [366] = {.lex_state = 73, .external_lex_state = 2},
  [367] = {.lex_state = 73, .external_lex_state = 3},
  [368] = {.lex_state = 73, .external_lex_state = 2},
  [369] = {.lex_state = 73, .external_lex_state = 2},
  [370] = {.lex_state = 73, .external_lex_state = 2},
  [371] = {.lex_state = 73, .external_lex_state = 2},
  [372] = {.lex_state = 73, .external_lex_state = 2},
  [373] = {.lex_state = 73, .external_lex_state = 2},
  [374] = {.lex_state = 73, .external_lex_state = 3},
  [375] = {.lex_state = 73, .external_lex_state = 2},
  [376] = {.lex_state = 73, .external_lex_state = 3},
  [377] = {.lex_state = 73, .external_lex_state = 2},
  [378] = {.lex_state = 73, .external_lex_state = 3},
  [379] = {.lex_state = 73, .external_lex_state = 3},
  [380] = {.lex_state = 73, .external_lex_state = 3},
  [381] = {.lex_state = 73, .external_lex_state = 2},
  [382] = {.lex_state = 73, .external_lex_state = 2},
  [383] = {.lex_state = 73, .external_lex_state = 3},
  [384] = {.lex_state = 73, .external_lex_state = 2},
  [385] = {.lex_state = 73, .external_lex_state = 3},
  [386] = {.lex_state = 73, .external_lex_state = 3},
  [387] = {.lex_state = 73, .external_lex_state = 2},
  [388] = {.lex_state = 73, .external_lex_state = 3},
  [389] = {.lex_state = 73, .external_lex_state = 3},
  [390] = {.lex_state = 73, .external_lex_state = 2},
  [391] = {.lex_state = 73, .external_lex_state = 2},
  [392] = {.lex_state = 73, .external_lex_state = 2},
  [393] = {.lex_state = 73, .external_lex_state = 3},
  [394] = {.lex_state = 73, .external_lex_state = 2},
  [395] = {.lex_state = 73, .external_lex_state = 3},
  [396] = {.lex_state = 73, .external_lex_state = 3},
  [397] = {.lex_state = 73, .external_lex_state = 3},
  [398] = {.lex_state = 73, .external_lex_state = 2},
  [399] = {.lex_state = 73, .external_lex_state = 3},
  [400] = {.lex_state = 73, .external_lex_state = 2},
  [401] = {.lex_state = 73, .external_lex_state = 3},
  [402] = {.lex_state = 73, .external_lex_state = 3},
  [403] = {.lex_state = 73, .external_lex_state = 3},
  [404] = {.lex_state = 73, .external_lex_state = 3},
  [405] = {.lex_state = 73, .external_lex_state = 2},
  [406] = {.lex_state = 73, .external_lex_state = 2},
  [407] = {.lex_state = 73, .external_lex_state = 2},
  [408] = {.lex_state = 73, .external_lex_state = 2},
  [409] = {.lex_state = 73, .external_lex_state = 2},
  [410] = {.lex_state = 73, .external_lex_state = 3},
  [411] = {.lex_state = 73, .external_lex_state = 2},
  [412] = {.lex_state = 73, .external_lex_state = 3},
  [413] = {.lex_state = 73, .external_lex_state = 2},
  [414] = {.lex_state = 73, .external_lex_state = 3},
  [415] = {.lex_state = 73, .external_lex_state = 3},
  [416] = {.lex_state = 73, .external_lex_state = 2},
  [417] = {.lex_state = 73, .external_lex_state = 2},
  [418] = {.lex_state = 73, .external_lex_state = 2},
  [419] = {.lex_state = 73, .external_lex_state = 2},
  [420] = {.lex_state = 73, .external_lex_state = 2},
  [421] = {.lex_state = 73, .external_lex_state = 2},
  [422] = {.lex_state = 73, .external_lex_state = 2},
  [423] = {.lex_state = 73, .external_lex_state = 2},
  [424] = {.lex_state = 73, .external_lex_state = 3},
  [425] = {.lex_state = 73, .external_lex_state = 2},
  [426] = {.lex_state = 73, .external_lex_state = 3},
  [427] = {.lex_state = 73, .external_lex_state = 2},
  [428] = {.lex_state = 73, .external_lex_state = 3},
  [429] = {.lex_state = 73, .external_lex_state = 2},
  [430] = {.lex_state = 73, .external_lex_state = 2},
  [431] = {.lex_state = 73, .external_lex_state = 2},
  [432] = {.lex_state = 73, .external_lex_state = 2},
  [433] = {.lex_state = 73, .external_lex_state = 2},
  [434] = {.lex_state = 73, .external_lex_state = 2},
  [435] = {.lex_state = 73, .external_lex_state = 2},
  [436] = {.lex_state = 73, .external_lex_state = 2},
  [437] = {.lex_state = 73, .external_lex_state = 2},
  [438] = {.lex_state = 73, .external_lex_state = 2},
  [439] = {.lex_state = 73, .external_lex_state = 3},
  [440] = {.lex_state = 73, .external_lex_state = 2},
  [441] = {.lex_state = 73, .external_lex_state = 2},
  [442] = {.lex_state = 73, .external_lex_state = 2},
  [443] = {.lex_state = 73, .external_lex_state = 2},
  [444] = {.lex_state = 73, .external_lex_state = 2},
  [445] = {.lex_state = 73, .external_lex_state = 2},
  [446] = {.lex_state = 73, .external_lex_state = 2},
  [447] = {.lex_state = 73, .external_lex_state = 2},
  [448] = {.lex_state = 73, .external_lex_state = 4},
  [449] = {.lex_state = 73, .external_lex_state = 4},
  [450] = {.lex_state = 73, .external_lex_state = 4},
  [451] = {.lex_state = 73, .external_lex_state = 4},
  [452] = {.lex_state = 73, .external_lex_state = 4},
  [453] = {.lex_state = 73, .external_lex_state = 4},
  [454] = {.lex_state = 73, .external_lex_state = 4},
  [455] = {.lex_state = 73, .external_lex_state = 4},
  [456] = {.lex_state = 73, .external_lex_state = 4},
  [457] = {.lex_state = 73, .external_lex_state = 4},
  [458] = {.lex_state = 73, .external_lex_state = 4},
  [459] = {.lex_state = 73, .external_lex_state = 4},
  [460] = {.lex_state = 73, .external_lex_state = 4},
  [461] = {.lex_state = 73, .external_lex_state = 2},
  [462] = {.lex_state = 73, .external_lex_state = 4},
  [463] = {.lex_state = 73, .external_lex_state = 2},
  [464] = {.lex_state = 73, .external_lex_state = 2},
  [465] = {.lex_state = 73, .external_lex_state = 2},
  [466] = {.lex_state = 74, .external_lex_state = 4},
  [467] = {.lex_state = 74, .external_lex_state = 4},
  [468] = {.lex_state = 73, .external_lex_state = 5},
  [469] = {.lex_state = 74, .external_lex_state = 4},
  [470] = {.lex_state = 73, .external_lex_state = 2},
  [471] = {.lex_state = 73, .external_lex_state = 2},
  [472] = {.lex_state = 73, .external_lex_state = 5},
  [473] = {.lex_state = 73, .external_lex_state = 4},
  [474] = {.lex_state = 74, .external_lex_state = 4},
  [475] = {.lex_state = 73, .external_lex_state = 5},
  [476] = {.lex_state = 74, .external_lex_state = 4},
  [477] = {.lex_state = 74, .external_lex_state = 4},
  [478] = {.lex_state = 74, .external_lex_state = 4},
  [479] = {.lex_state = 73, .external_lex_state = 4},
  [480] = {.lex_state = 74, .external_lex_state = 4},
  [481] = {.lex_state = 74, .external_lex_state = 4},
  [482] = {.lex_state = 74, .external_lex_state = 4},
  [483] = {.lex_state = 74, .external_lex_state = 4},
  [484] = {.lex_state = 74, .external_lex_state = 4},
  [485] = {.lex_state = 74, .external_lex_state = 4},
  [486] = {.lex_state = 74, .external_lex_state = 4},
  [487] = {.lex_state = 74, .external_lex_state = 4},
  [488] = {.lex_state = 74, .external_lex_state = 4},
  [489] = {.lex_state = 74, .external_lex_state = 4},
  [490] = {.lex_state = 74, .external_lex_state = 4},
  [491] = {.lex_state = 73, .external_lex_state = 4},
  [492] = {.lex_state = 74, .external_lex_state = 4},
  [493] = {.lex_state = 74, .external_lex_state = 4},
  [494] = {.lex_state = 74, .external_lex_state = 4},
  [495] = {.lex_state = 74, .external_lex_state = 4},
  [496] = {.lex_state = 74, .external_lex_state = 4},
  [497] = {.lex_state = 74, .external_lex_state = 4},
  [498] = {.lex_state = 74, .external_lex_state = 4},
  [499] = {.lex_state = 73, .external_lex_state = 5},
  [500] = {.lex_state = 73, .external_lex_state = 5},
  [501] = {.lex_state = 74, .external_lex_state = 4},
  [502] = {.lex_state = 74, .external_lex_state = 4},
  [503] = {.lex_state = 74, .external_lex_state = 4},
  [504] = {.lex_state = 74, .external_lex_state = 4},
  [505] = {.lex_state = 74, .external_lex_state = 4},
  [506] = {.lex_state = 74, .external_lex_state = 4},
  [507] = {.lex_state = 74, .external_lex_state = 4},
  [508] = {.lex_state = 74, .external_lex_state = 4},
  [509] = {.lex_state = 74, .external_lex_state = 4},
  [510] = {.lex_state = 73, .external_lex_state = 4},
  [511] = {.lex_state = 74, .external_lex_state = 4},
  [512] = {.lex_state = 73, .external_lex_state = 4},
  [513] = {.lex_state = 73, .external_lex_state = 4},
  [514] = {.lex_state = 73, .external_lex_state = 4},
  [515] = {.lex_state = 73, .external_lex_state = 4},
  [516] = {.lex_state = 73, .external_lex_state = 4},
  [517] = {.lex_state = 73, .external_lex_state = 4},
  [518] = {.lex_state = 73, .external_lex_state = 4},
  [519] = {.lex_state = 73, .external_lex_state = 4},
  [520] = {.lex_state = 74, .external_lex_state = 4},
  [521] = {.lex_state = 74, .external_lex_state = 4},
  [522] = {.lex_state = 74, .external_lex_state = 4},
  [523] = {.lex_state = 74, .external_lex_state = 4},
  [524] = {.lex_state = 73, .external_lex_state = 5},
  [525] = {.lex_state = 73, .external_lex_state = 5},
  [526] = {.lex_state = 73, .external_lex_state = 5},
  [527] = {.lex_state = 73, .external_lex_state = 5},
  [528] = {.lex_state = 73, .external_lex_state = 5},
  [529] = {.lex_state = 73, .external_lex_state = 5},
  [530] = {.lex_state = 73, .external_lex_state = 5},
  [531] = {.lex_state = 73, .external_lex_state = 5},
  [532] = {.lex_state = 0, .external_lex_state = 2},
  [533] = {.lex_state = 0, .external_lex_state = 2},
  [534] = {.lex_state = 0, .external_lex_state = 2},
  [535] = {.lex_state = 0, .external_lex_state = 2},
  [536] = {.lex_state = 0, .external_lex_state = 2},
  [537] = {.lex_state = 0, .external_lex_state = 2},
  [538] = {.lex_state = 0, .external_lex_state = 2},
  [539] = {.lex_state = 0, .external_lex_state = 2},
  [540] = {.lex_state = 0, .external_lex_state = 2},
  [541] = {.lex_state = 0, .external_lex_state = 2},
  [542] = {.lex_state = 0, .external_lex_state = 2},
  [543] = {.lex_state = 0, .external_lex_state = 2},
  [544] = {.lex_state = 0, .external_lex_state = 2},
  [545] = {.lex_state = 4, .external_lex_state = 6},
  [546] = {.lex_state = 4, .external_lex_state = 6},
  [547] = {.lex_state = 4, .external_lex_state = 6},
  [548] = {.lex_state = 4, .external_lex_state = 6},
  [549] = {.lex_state = 4, .external_lex_state = 6},
  [550] = {.lex_state = 4, .external_lex_state = 6},
  [551] = {.lex_state = 4, .external_lex_state = 6},
  [552] = {.lex_state = 4, .external_lex_state = 6},
  [553] = {.lex_state = 4, .external_lex_state = 6},
  [554] = {.lex_state = 4, .external_lex_state = 6},
  [555] = {.lex_state = 4, .external_lex_state = 6},
  [556] = {.lex_state = 4, .external_lex_state = 6},
  [557] = {.lex_state = 74, .external_lex_state = 4},
  [558] = {.lex_state = 74, .external_lex_state = 4},
  [559] = {.lex_state = 74, .external_lex_state = 4},
  [560] = {.lex_state = 74, .external_lex_state = 4},
  [561] = {.lex_state = 74, .external_lex_state = 4},
  [562] = {.lex_state = 4, .external_lex_state = 6},
  [563] = {.lex_state = 74, .external_lex_state = 4},
  [564] = {.lex_state = 74, .external_lex_state = 4},
  [565] = {.lex_state = 74, .external_lex_state = 4},
  [566] = {.lex_state = 74, .external_lex_state = 4},
  [567] = {.lex_state = 73, .external_lex_state = 4},
  [568] = {.lex_state = 73, .external_lex_state = 4},
  [569] = {.lex_state = 1, .external_lex_state = 7},
  [570] = {.lex_state = 1, .external_lex_state = 7},
  [571] = {.lex_state = 1, .external_lex_state = 7},
  [572] = {.lex_state = 1, .external_lex_state = 7},
  [573] = {.lex_state = 73, .external_lex_state = 4},
  [574] = {.lex_state = 1, .external_lex_state = 7},
  [575] = {.lex_state = 1, .external_lex_state = 7},
  [576] = {.lex_state = 74, .external_lex_state = 4},
  [577] = {.lex_state = 74, .external_lex_state = 4},
  [578] = {.lex_state = 1, .external_lex_state = 7},
  [579] = {.lex_state = 74, .external_lex_state = 4},
  [580] = {.lex_state = 74, .external_lex_state = 4},
  [581] = {.lex_state = 1, .external_lex_state = 7},
  [582] = {.lex_state = 1, .external_lex_state = 7},
  [583] = {.lex_state = 1, .external_lex_state = 7},
  [584] = {.lex_state = 1, .external_lex_state = 7},
  [585] = {.lex_state = 1, .external_lex_state = 7},
  [586] = {.lex_state = 1, .external_lex_state = 7},
  [587] = {.lex_state = 74, .external_lex_state = 4},
  [588] = {.lex_state = 1, .external_lex_state = 7},
  [589] = {.lex_state = 1, .external_lex_state = 7},
  [590] = {.lex_state = 74, .external_lex_state = 4},
  [591] = {.lex_state = 2, .external_lex_state = 8},
  [592] = {.lex_state = 73, .external_lex_state = 4},
  [593] = {.lex_state = 2, .external_lex_state = 8},
  [594] = {.lex_state = 2, .external_lex_state = 8},
  [595] = {.lex_state = 2, .external_lex_state = 8},
  [596] = {.lex_state = 2, .external_lex_state = 8},
  [597] = {.lex_state = 2, .external_lex_state = 8},
  [598] = {.lex_state = 2, .external_lex_state = 8},
  [599] = {.lex_state = 2, .external_lex_state = 8},
  [600] = {.lex_state = 2, .external_lex_state = 8},
  [601] = {.lex_state = 2, .external_lex_state = 8},
  [602] = {.lex_state = 2, .external_lex_state = 8},
  [603] = {.lex_state = 2, .external_lex_state = 8},
  [604] = {.lex_state = 4, .external_lex_state = 4},
  [605] = {.lex_state = 2, .external_lex_state = 8},
  [606] = {.lex_state = 2, .external_lex_state = 8},
  [607] = {.lex_state = 2, .external_lex_state = 8},
  [608] = {.lex_state = 1, .external_lex_state = 9},
  [609] = {.lex_state = 1, .external_lex_state = 9},
  [610] = {.lex_state = 74, .external_lex_state = 4},
  [611] = {.lex_state = 4, .external_lex_state = 4},
  [612] = {.lex_state = 1, .external_lex_state = 9},
  [613] = {.lex_state = 74, .external_lex_state = 10},
  [614] = {.lex_state = 1, .external_lex_state = 9},
  [615] = {.lex_state = 4, .external_lex_state = 4},
  [616] = {.lex_state = 1, .external_lex_state = 9},
  [617] = {.lex_state = 74, .external_lex_state = 10},
  [618] = {.lex_state = 1, .external_lex_state = 9},
  [619] = {.lex_state = 74, .external_lex_state = 10},
  [620] = {.lex_state = 1, .external_lex_state = 9},
  [621] = {.lex_state = 1, .external_lex_state = 9},
  [622] = {.lex_state = 4, .external_lex_state = 4},
  [623] = {.lex_state = 4, .external_lex_state = 4},
  [624] = {.lex_state = 74, .external_lex_state = 4},
  [625] = {.lex_state = 74, .external_lex_state = 4},
  [626] = {.lex_state = 1, .external_lex_state = 9},
  [627] = {.lex_state = 74, .external_lex_state = 10},
  [628] = {.lex_state = 1, .external_lex_state = 9},
  [629] = {.lex_state = 1, .external_lex_state = 9},
  [630] = {.lex_state = 1, .external_lex_state = 9},
  [631] = {.lex_state = 1, .external_lex_state = 9},
  [632] = {.lex_state = 1, .external_lex_state = 9},
  [633] = {.lex_state = 4, .external_lex_state = 4},
  [634] = {.lex_state = 74, .external_lex_state = 10},
  [635] = {.lex_state = 4, .external_lex_state = 4},
  [636] = {.lex_state = 1, .external_lex_state = 9},
  [637] = {.lex_state = 74, .external_lex_state = 10},
  [638] = {.lex_state = 1, .external_lex_state = 9},
  [639] = {.lex_state = 1, .external_lex_state = 9},
  [640] = {.lex_state = 2, .external_lex_state = 11},
  [641] = {.lex_state = 2, .external_lex_state = 11},
  [642] = {.lex_state = 74, .external_lex_state = 10},
  [643] = {.lex_state = 2, .external_lex_state = 11},
  [644] = {.lex_state = 74, .external_lex_state = 10},
  [645] = {.lex_state = 2, .external_lex_state = 11},
  [646] = {.lex_state = 74, .external_lex_state = 10},
  [647] = {.lex_state = 2, .external_lex_state = 11},
  [648] = {.lex_state = 2, .external_lex_state = 11},
  [649] = {.lex_state = 2, .external_lex_state = 11},
  [650] = {.lex_state = 2, .external_lex_state = 11},
  [651] = {.lex_state = 74, .external_lex_state = 4},
  [652] = {.lex_state = 74, .external_lex_state = 4},
  [653] = {.lex_state = 2, .external_lex_state = 11},
  [654] = {.lex_state = 74, .external_lex_state = 4},
  [655] = {.lex_state = 2, .external_lex_state = 11},
  [656] = {.lex_state = 2, .external_lex_state = 11},
  [657] = {.lex_state = 2, .external_lex_state = 11},
  [658] = {.lex_state = 2, .external_lex_state = 11},
  [659] = {.lex_state = 74, .external_lex_state = 10},
  [660] = {.lex_state = 74, .external_lex_state = 10},
  [661] = {.lex_state = 2, .external_lex_state = 11},
  [662] = {.lex_state = 74, .external_lex_state = 10},
  [663] = {.lex_state = 74, .external_lex_state = 10},
  [664] = {.lex_state = 74, .external_lex_state = 10},
  [665] = {.lex_state = 2, .external_lex_state = 11},
  [666] = {.lex_state = 2, .external_lex_state = 11},
  [667] = {.lex_state = 74, .external_lex_state = 4},
  [668] = {.lex_state = 2, .external_lex_state = 11},
  [669] = {.lex_state = 2, .external_lex_state = 11},
  [670] = {.lex_state = 74, .external_lex_state = 10},
  [671] = {.lex_state = 2, .external_lex_state = 11},
  [672] = {.lex_state = 74, .external_lex_state = 10},
  [673] = {.lex_state = 2, .external_lex_state = 11},
  [674] = {.lex_state = 2, .external_lex_state = 11},
  [675] = {.lex_state = 2, .external_lex_state = 11},
  [676] = {.lex_state = 74, .external_lex_state = 10},
  [677] = {.lex_state = 2, .external_lex_state = 11},
  [678] = {.lex_state = 74, .external_lex_state = 10},
  [679] = {.lex_state = 2, .external_lex_state = 11},
  [680] = {.lex_state = 4, .external_lex_state = 6},
  [681] = {.lex_state = 74, .external_lex_state = 4},
  [682] = {.lex_state = 2, .external_lex_state = 11},
  [683] = {.lex_state = 2, .external_lex_state = 11},
  [684] = {.lex_state = 2, .external_lex_state = 11},
  [685] = {.lex_state = 74, .external_lex_state = 4},
  [686] = {.lex_state = 2, .external_lex_state = 11},
  [687] = {.lex_state = 74, .external_lex_state = 4},
  [688] = {.lex_state = 2, .external_lex_state = 11},
  [689] = {.lex_state = 2, .external_lex_state = 11},
  [690] = {.lex_state = 2, .external_lex_state = 11},
  [691] = {.lex_state = 4, .external_lex_state = 4},
  [692] = {.lex_state = 4, .external_lex_state = 6},
  [693] = {.lex_state = 1, .external_lex_state = 7},
  [694] = {.lex_state = 3, .external_lex_state = 4},
  [695] = {.lex_state = 4, .external_lex_state = 6},
  [696] = {.lex_state = 3, .external_lex_state = 10},
  [697] = {.lex_state = 3, .external_lex_state = 4},
  [698] = {.lex_state = 3, .external_lex_state = 4},
  [699] = {.lex_state = 4, .external_lex_state = 6},
  [700] = {.lex_state = 74, .external_lex_state = 10},
  [701] = {.lex_state = 4, .external_lex_state = 6},
  [702] = {.lex_state = 4, .external_lex_state = 4},
  [703] = {.lex_state = 4, .external_lex_state = 6},
  [704] = {.lex_state = 4, .external_lex_state = 6},
  [705] = {.lex_state = 3, .external_lex_state = 10},
  [706] = {.lex_state = 1, .external_lex_state = 7},
  [707] = {.lex_state = 3, .external_lex_state = 4},
  [708] = {.lex_state = 3, .external_lex_state = 10},
  [709] = {.lex_state = 3, .external_lex_state = 10},
  [710] = {.lex_state = 3, .external_lex_state = 10},
  [711] = {.lex_state = 3, .external_lex_state = 4},
  [712] = {.lex_state = 3, .external_lex_state = 4},
  [713] = {.lex_state = 73, .external_lex_state = 4},
  [714] = {.lex_state = 1, .external_lex_state = 7},
  [715] = {.lex_state = 3, .external_lex_state = 10},
  [716] = {.lex_state = 73, .external_lex_state = 4},
  [717] = {.lex_state = 3, .external_lex_state = 4},
  [718] = {.lex_state = 4, .external_lex_state = 6},
  [719] = {.lex_state = 4, .external_lex_state = 4},
  [720] = {.lex_state = 73, .external_lex_state = 5},
  [721] = {.lex_state = 73, .external_lex_state = 4},
  [722] = {.lex_state = 74, .external_lex_state = 4},
  [723] = {.lex_state = 4, .external_lex_state = 4},
  [724] = {.lex_state = 74, .external_lex_state = 4},
  [725] = {.lex_state = 74, .external_lex_state = 4},
  [726] = {.lex_state = 74, .external_lex_state = 4},
  [727] = {.lex_state = 12, .external_lex_state = 4},
  [728] = {.lex_state = 73, .external_lex_state = 4},
  [729] = {.lex_state = 74, .external_lex_state = 4},
  [730] = {.lex_state = 4, .external_lex_state = 4},
  [731] = {.lex_state = 2, .external_lex_state = 8},
  [732] = {.lex_state = 4, .external_lex_state = 4},
  [733] = {.lex_state = 74, .external_lex_state = 4},
  [734] = {.lex_state = 4, .external_lex_state = 4},
  [735] = {.lex_state = 1, .external_lex_state = 9},
  [736] = {.lex_state = 73, .external_lex_state = 5},
  [737] = {.lex_state = 2, .external_lex_state = 8},
  [738] = {.lex_state = 4, .external_lex_state = 4},
  [739] = {.lex_state = 1, .external_lex_state = 9},
  [740] = {.lex_state = 73, .external_lex_state = 4},
  [741] = {.lex_state = 4, .external_lex_state = 4},
  [742] = {.lex_state = 2, .external_lex_state = 8},
  [743] = {.lex_state = 4, .external_lex_state = 4},
  [744] = {.lex_state = 4, .external_lex_state = 4},
  [745] = {.lex_state = 3, .external_lex_state = 4},
  [746] = {.lex_state = 2, .external_lex_state = 11},
  [747] = {.lex_state = 3, .external_lex_state = 4},
  [748] = {.lex_state = 3, .external_lex_state = 4},
  [749] = {.lex_state = 3, .external_lex_state = 4},
  [750] = {.lex_state = 3, .external_lex_state = 4},
  [751] = {.lex_state = 3, .external_lex_state = 4},
  [752] = {.lex_state = 2, .external_lex_state = 11},
  [753] = {.lex_state = 3, .external_lex_state = 4},
  [754] = {.lex_state = 73, .external_lex_state = 4},
  [755] = {.lex_state = 3, .external_lex_state = 4},
  [756] = {.lex_state = 3, .external_lex_state = 4},
  [757] = {.lex_state = 3, .external_lex_state = 4},
  [758] = {.lex_state = 3, .external_lex_state = 4},
  [759] = {.lex_state = 4, .external_lex_state = 4},
  [760] = {.lex_state = 3, .external_lex_state = 4},
  [761] = {.lex_state = 0, .external_lex_state = 10},
  [762] = {.lex_state = 3, .external_lex_state = 4},
  [763] = {.lex_state = 3, .external_lex_state = 4},
  [764] = {.lex_state = 3, .external_lex_state = 4},
  [765] = {.lex_state = 4, .external_lex_state = 4},
  [766] = {.lex_state = 3, .external_lex_state = 4},
  [767] = {.lex_state = 4, .external_lex_state = 4},
  [768] = {.lex_state = 0, .external_lex_state = 4},
  [769] = {.lex_state = 73, .external_lex_state = 5},
  [770] = {.lex_state = 9, .external_lex_state = 4},
  [771] = {.lex_state = 0, .external_lex_state = 4},
  [772] = {.lex_state = 73, .external_lex_state = 4},
  [773] = {.lex_state = 0, .external_lex_state = 4},
  [774] = {.lex_state = 0, .external_lex_state = 4},
  [775] = {.lex_state = 3, .external_lex_state = 4},
  [776] = {.lex_state = 0, .external_lex_state = 4},
  [777] = {.lex_state = 0, .external_lex_state = 6},
  [778] = {.lex_state = 0, .external_lex_state = 4},
  [779] = {.lex_state = 0, .external_lex_state = 4},
  [780] = {.lex_state = 9, .external_lex_state = 4},
  [781] = {.lex_state = 73, .external_lex_state = 5},
  [782] = {.lex_state = 73, .external_lex_state = 5},
  [783] = {.lex_state = 73, .external_lex_state = 5},
  [784] = {.lex_state = 0, .external_lex_state = 6},
  [785] = {.lex_state = 0, .external_lex_state = 4},
  [786] = {.lex_state = 0, .external_lex_state = 6},
  [787] = {.lex_state = 0, .external_lex_state = 4},
  [788] = {.lex_state = 9, .external_lex_state = 4},
  [789] = {.lex_state = 0, .external_lex_state = 6},
  [790] = {.lex_state = 73, .external_lex_state = 5},
  [791] = {.lex_state = 9, .external_lex_state = 4},
  [792] = {.lex_state = 73, .external_lex_state = 5},
  [793] = {.lex_state = 73, .external_lex_state = 5},
  [794] = {.lex_state = 9, .external_lex_state = 4},
  [795] = {.lex_state = 0, .external_lex_state = 4},
  [796] = {.lex_state = 9, .external_lex_state = 4},
  [797] = {.lex_state = 3, .external_lex_state = 4},
  [798] = {.lex_state = 0, .external_lex_state = 4},
  [799] = {.lex_state = 0, .external_lex_state = 4},
  [800] = {.lex_state = 3, .external_lex_state = 4},
  [801] = {.lex_state = 9, .external_lex_state = 4},
  [802] = {.lex_state = 0, .external_lex_state = 4},
  [803] = {.lex_state = 73, .external_lex_state = 5},
  [804] = {.lex_state = 9, .external_lex_state = 4},
  [805] = {.lex_state = 0, .external_lex_state = 4},
  [806] = {.lex_state = 9, .external_lex_state = 4},
  [807] = {.lex_state = 0, .external_lex_state = 6},
  [808] = {.lex_state = 9, .external_lex_state = 4},
  [809] = {.lex_state = 3, .external_lex_state = 4},
  [810] = {.lex_state = 73, .external_lex_state = 5},
  [811] = {.lex_state = 0, .external_lex_state = 4},
  [812] = {.lex_state = 0, .external_lex_state = 4},
  [813] = {.lex_state = 9, .external_lex_state = 4},
  [814] = {.lex_state = 0, .external_lex_state = 4},
  [815] = {.lex_state = 0, .external_lex_state = 4},
  [816] = {.lex_state = 9, .external_lex_state = 4},
  [817] = {.lex_state = 4, .external_lex_state = 4},
  [818] = {.lex_state = 0, .external_lex_state = 4},
  [819] = {.lex_state = 0, .external_lex_state = 4},
  [820] = {.lex_state = 9, .external_lex_state = 4},
  [821] = {.lex_state = 0, .external_lex_state = 6},
  [822] = {.lex_state = 9, .external_lex_state = 4},
  [823] = {.lex_state = 3, .external_lex_state = 4},
  [824] = {.lex_state = 9, .external_lex_state = 4},
  [825] = {.lex_state = 0, .external_lex_state = 4},
  [826] = {.lex_state = 0, .external_lex_state = 4},
  [827] = {.lex_state = 0, .external_lex_state = 4},
  [828] = {.lex_state = 9, .external_lex_state = 4},
  [829] = {.lex_state = 9, .external_lex_state = 4},
  [830] = {.lex_state = 0, .external_lex_state = 4},
  [831] = {.lex_state = 9, .external_lex_state = 4},
  [832] = {.lex_state = 9, .external_lex_state = 4},
  [833] = {.lex_state = 0, .external_lex_state = 4},
  [834] = {.lex_state = 9, .external_lex_state = 4},
  [835] = {.lex_state = 9, .external_lex_state = 4},
  [836] = {.lex_state = 9, .external_lex_state = 4},
  [837] = {.lex_state = 9, .external_lex_state = 4},
  [838] = {.lex_state = 0, .external_lex_state = 4},
  [839] = {.lex_state = 0, .external_lex_state = 4},
  [840] = {.lex_state = 3, .external_lex_state = 4},
  [841] = {.lex_state = 3, .external_lex_state = 4},
  [842] = {.lex_state = 73, .external_lex_state = 4},
  [843] = {.lex_state = 0, .external_lex_state = 4},
  [844] = {.lex_state = 73, .external_lex_state = 4},
  [845] = {.lex_state = 0, .external_lex_state = 6},
  [846] = {.lex_state = 0, .external_lex_state = 4},
  [847] = {.lex_state = 3, .external_lex_state = 4},
  [848] = {.lex_state = 0, .external_lex_state = 6},
  [849] = {.lex_state = 9, .external_lex_state = 4},
  [850] = {.lex_state = 0, .external_lex_state = 4},
  [851] = {.lex_state = 74, .external_lex_state = 4},
  [852] = {.lex_state = 0, .external_lex_state = 4},
  [853] = {.lex_state = 4, .external_lex_state = 4},
  [854] = {.lex_state = 0, .external_lex_state = 4},
  [855] = {.lex_state = 0, .external_lex_state = 4},
  [856] = {.lex_state = 4, .external_lex_state = 4},
  [857] = {.lex_state = 4, .external_lex_state = 4},
  [858] = {.lex_state = 0, .external_lex_state = 4},
  [859] = {.lex_state = 0, .external_lex_state = 4},
  [860] = {.lex_state = 4, .external_lex_state = 4},
  [861] = {.lex_state = 4, .external_lex_state = 4},
  [862] = {.lex_state = 0, .external_lex_state = 4},
  [863] = {.lex_state = 0, .external_lex_state = 4},
  [864] = {.lex_state = 0, .external_lex_state = 4},
  [865] = {.lex_state = 4, .external_lex_state = 4},
  [866] = {.lex_state = 0, .external_lex_state = 4},
  [867] = {.lex_state = 4, .external_lex_state = 4},
  [868] = {.lex_state = 74, .external_lex_state = 4},
  [869] = {.lex_state = 0, .external_lex_state = 4},
  [870] = {.lex_state = 0, .external_lex_state = 4},
  [871] = {.lex_state = 4, .external_lex_state = 4},
  [872] = {.lex_state = 0, .external_lex_state = 4},
  [873] = {.lex_state = 0, .external_lex_state = 4},
  [874] = {.lex_state = 0, .external_lex_state = 4},
  [875] = {.lex_state = 73, .external_lex_state = 4},
  [876] = {.lex_state = 73, .external_lex_state = 4},
  [877] = {.lex_state = 0, .external_lex_state = 4},
  [878] = {.lex_state = 0, .external_lex_state = 4},
  [879] = {.lex_state = 73, .external_lex_state = 4},
  [880] = {.lex_state = 0, .external_lex_state = 4},
  [881] = {.lex_state = 0, .external_lex_state = 4},
  [882] = {.lex_state = 0, .external_lex_state = 4},
  [883] = {.lex_state = 0, .external_lex_state = 4},
  [884] = {.lex_state = 73, .external_lex_state = 4},
  [885] = {.lex_state = 0, .external_lex_state = 4},
  [886] = {.lex_state = 73, .external_lex_state = 4},
  [887] = {.lex_state = 73, .external_lex_state = 4},
  [888] = {.lex_state = 0, .external_lex_state = 4},
  [889] = {.lex_state = 3, .external_lex_state = 4},
  [890] = {.lex_state = 3, .external_lex_state = 4},
  [891] = {.lex_state = 0, .external_lex_state = 4},
  [892] = {.lex_state = 0, .external_lex_state = 4},
  [893] = {.lex_state = 74, .external_lex_state = 4},
  [894] = {.lex_state = 0, .external_lex_state = 4},
  [895] = {.lex_state = 3, .external_lex_state = 4},
  [896] = {.lex_state = 0, .external_lex_state = 4},
  [897] = {.lex_state = 3, .external_lex_state = 4},
  [898] = {.lex_state = 0, .external_lex_state = 5},
  [899] = {.lex_state = 0, .external_lex_state = 4},
  [900] = {.lex_state = 0, .external_lex_state = 4},
  [901] = {.lex_state = 3, .external_lex_state = 4},
  [902] = {.lex_state = 0, .external_lex_state = 4},
  [903] = {.lex_state = 74, .external_lex_state = 4},
  [904] = {.lex_state = 0, .external_lex_state = 4},
  [905] = {.lex_state = 0, .external_lex_state = 5},
  [906] = {.lex_state = 0, .external_lex_state = 4},
  [907] = {.lex_state = 3, .external_lex_state = 4},
  [908] = {.lex_state = 3, .external_lex_state = 4},
  [909] = {.lex_state = 74, .external_lex_state = 4},
  [910] = {.lex_state = 0, .external_lex_state = 5},
  [911] = {.lex_state = 0, .external_lex_state = 4},
  [912] = {.lex_state = 0, .external_lex_state = 4},
  [913] = {.lex_state = 0, .external_lex_state = 4},
  [914] = {.lex_state = 0, .external_lex_state = 4},
  [915] = {.lex_state = 73, .external_lex_state = 4},
  [916] = {.lex_state = 0, .external_lex_state = 4},
  [917] = {.lex_state = 0, .external_lex_state = 4},
  [918] = {.lex_state = 0, .external_lex_state = 4},
  [919] = {.lex_state = 0, .external_lex_state = 4},
  [920] = {.lex_state = 0, .external_lex_state = 4},
  [921] = {.lex_state = 0, .external_lex_state = 4},
  [922] = {.lex_state = 0, .external_lex_state = 4},
  [923] = {.lex_state = 73, .external_lex_state = 4},
  [924] = {.lex_state = 0, .external_lex_state = 4},
  [925] = {.lex_state = 0, .external_lex_state = 4},
  [926] = {.lex_state = 0, .external_lex_state = 4},
  [927] = {.lex_state = 3, .external_lex_state = 4},
  [928] = {.lex_state = 0, .external_lex_state = 4},
  [929] = {.lex_state = 0, .external_lex_state = 4},
  [930] = {.lex_state = 0, .external_lex_state = 4},
  [931] = {.lex_state = 0, .external_lex_state = 4},
  [932] = {.lex_state = 0, .external_lex_state = 4},
  [933] = {.lex_state = 0, .external_lex_state = 4},
  [934] = {.lex_state = 74, .external_lex_state = 4},
  [935] = {.lex_state = 3, .external_lex_state = 4},
  [936] = {.lex_state = 3, .external_lex_state = 4},
  [937] = {.lex_state = 4, .external_lex_state = 4},
  [938] = {.lex_state = 0, .external_lex_state = 4},
  [939] = {.lex_state = 3, .external_lex_state = 4},
  [940] = {.lex_state = 4, .external_lex_state = 4},
  [941] = {.lex_state = 0, .external_lex_state = 4},
  [942] = {.lex_state = 0, .external_lex_state = 4},
  [943] = {.lex_state = 0, .external_lex_state = 4},
  [944] = {.lex_state = 0, .external_lex_state = 4},
  [945] = {.lex_state = 0, .external_lex_state = 4},
  [946] = {.lex_state = 0, .external_lex_state = 5},
  [947] = {.lex_state = 74, .external_lex_state = 4},
  [948] = {.lex_state = 0, .external_lex_state = 4},
  [949] = {.lex_state = 0, .external_lex_state = 4},
  [950] = {.lex_state = 0, .external_lex_state = 4},
  [951] = {.lex_state = 0, .external_lex_state = 4},
  [952] = {.lex_state = 0, .external_lex_state = 4},
  [953] = {.lex_state = 0, .external_lex_state = 4},
  [954] = {.lex_state = 74, .external_lex_state = 4},
  [955] = {.lex_state = 0, .external_lex_state = 4},
  [956] = {.lex_state = 3, .external_lex_state = 4},
  [957] = {.lex_state = 3, .external_lex_state = 4},
  [958] = {.lex_state = 4, .external_lex_state = 4},
  [959] = {.lex_state = 74, .external_lex_state = 4},
  [960] = {.lex_state = 0, .external_lex_state = 4},
  [961] = {.lex_state = 4, .external_lex_state = 4},
  [962] = {.lex_state = 0, .external_lex_state = 4},
  [963] = {.lex_state = 0, .external_lex_state = 4},
  [964] = {.lex_state = 0, .external_lex_state = 4},
  [965] = {.lex_state = 0, .external_lex_state = 4},
  [966] = {.lex_state = 4, .external_lex_state = 4},
  [967] = {.lex_state = 0, .external_lex_state = 5},
  [968] = {.lex_state = 4, .external_lex_state = 4},
  [969] = {.lex_state = 0, .external_lex_state = 4},
  [970] = {.lex_state = 0, .external_lex_state = 4},
  [971] = {.lex_state = 74, .external_lex_state = 4},
  [972] = {.lex_state = 0, .external_lex_state = 4},
  [973] = {.lex_state = 4, .external_lex_state = 4},
  [974] = {.lex_state = 0, .external_lex_state = 4},
  [975] = {.lex_state = 4, .external_lex_state = 4},
  [976] = {.lex_state = 4, .external_lex_state = 4},
  [977] = {.lex_state = 0, .external_lex_state = 4},
  [978] = {.lex_state = 0, .external_lex_state = 4},
  [979] = {.lex_state = 3, .external_lex_state = 4},
  [980] = {.lex_state = 4, .external_lex_state = 4},
  [981] = {.lex_state = 3, .external_lex_state = 4},
  [982] = {.lex_state = 4, .external_lex_state = 4},
  [983] = {.lex_state = 0, .external_lex_state = 4},
  [984] = {.lex_state = 0, .external_lex_state = 4},
  [985] = {.lex_state = 0, .external_lex_state = 4},
  [986] = {.lex_state = 4, .external_lex_state = 4},
  [987] = {.lex_state = 4, .external_lex_state = 4},
  [988] = {.lex_state = 0, .external_lex_state = 5},
  [989] = {.lex_state = 4, .external_lex_state = 4},
  [990] = {.lex_state = 74, .external_lex_state = 4},
  [991] = {.lex_state = 3, .external_lex_state = 4},
  [992] = {.lex_state = 0, .external_lex_state = 4},
  [993] = {.lex_state = 4, .external_lex_state = 4},
  [994] = {.lex_state = 4, .external_lex_state = 4},
  [995] = {.lex_state = 3, .external_lex_state = 4},
  [996] = {.lex_state = 4, .external_lex_state = 4},
  [997] = {.lex_state = 4, .external_lex_state = 4},
  [998] = {.lex_state = 0, .external_lex_state = 4},
  [999] = {.lex_state = 0, .external_lex_state = 4},
  [1000] = {.lex_state = 0, .external_lex_state = 4},
  [1001] = {.lex_state = 4, .external_lex_state = 4},
  [1002] = {.lex_state = 0, .external_lex_state = 4},
  [1003] = {.lex_state = 4, .external_lex_state = 4},
  [1004] = {.lex_state = 0, .external_lex_state = 4},
  [1005] = {.lex_state = 0, .external_lex_state = 4},
  [1006] = {.lex_state = 0, .external_lex_state = 4},
  [1007] = {.lex_state = 0, .external_lex_state = 4},
  [1008] = {.lex_state = 4, .external_lex_state = 4},
  [1009] = {.lex_state = 0, .external_lex_state = 4},
  [1010] = {.lex_state = 4, .external_lex_state = 4},
  [1011] = {.lex_state = 0, .external_lex_state = 4},
  [1012] = {.lex_state = 0, .external_lex_state = 4},
  [1013] = {.lex_state = 0, .external_lex_state = 4},
  [1014] = {.lex_state = 3, .external_lex_state = 4},
  [1015] = {.lex_state = 4, .external_lex_state = 4},
  [1016] = {.lex_state = 0, .external_lex_state = 4},
  [1017] = {.lex_state = 4, .external_lex_state = 4},
  [1018] = {.lex_state = 0, .external_lex_state = 4},
  [1019] = {.lex_state = 0, .external_lex_state = 4},
  [1020] = {.lex_state = 0, .external_lex_state = 4},
  [1021] = {.lex_state = 0, .external_lex_state = 4},
  [1022] = {.lex_state = 4, .external_lex_state = 4},
  [1023] = {.lex_state = 0, .external_lex_state = 5},
  [1024] = {.lex_state = 4, .external_lex_state = 4},
  [1025] = {.lex_state = 3, .external_lex_state = 4},
  [1026] = {.lex_state = 74, .external_lex_state = 4},
  [1027] = {.lex_state = 0, .external_lex_state = 4},
  [1028] = {.lex_state = 74, .external_lex_state = 4},
  [1029] = {.lex_state = 3, .external_lex_state = 4},
  [1030] = {.lex_state = 74, .external_lex_state = 4},
  [1031] = {.lex_state = 74, .external_lex_state = 4},
  [1032] = {.lex_state = 74, .external_lex_state = 4},
  [1033] = {.lex_state = 0, .external_lex_state = 4},
  [1034] = {.lex_state = 74, .external_lex_state = 4},
  [1035] = {.lex_state = 0, .external_lex_state = 4},
  [1036] = {.lex_state = 74, .external_lex_state = 4},
  [1037] = {.lex_state = 0, .external_lex_state = 4},
  [1038] = {.lex_state = 0, .external_lex_state = 4},
  [1039] = {.lex_state = 0, .external_lex_state = 5},
};

enum {
  ts_external_token_multstr_start = 0,
  ts_external_token_multstr_end = 1,
  ts_external_token__str_start = 2,
  ts_external_token__str_end = 3,
  ts_external_token_interpolation_start = 4,
  ts_external_token_interpolation_end = 5,
  ts_external_token_quoted_enum_tag_start = 6,
  ts_external_token_comment = 7,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_multstr_start] = sym_multstr_start,
  [ts_external_token_multstr_end] = sym_multstr_end,
  [ts_external_token__str_start] = sym__str_start,
  [ts_external_token__str_end] = sym__str_end,
  [ts_external_token_interpolation_start] = sym_interpolation_start,
  [ts_external_token_interpolation_end] = sym_interpolation_end,
  [ts_external_token_quoted_enum_tag_start] = sym_quoted_enum_tag_start,
  [ts_external_token_comment] = sym_comment,
};

static const bool ts_external_scanner_states[12][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_multstr_start] = true,
    [ts_external_token_multstr_end] = true,
    [ts_external_token__str_start] = true,
    [ts_external_token__str_end] = true,
    [ts_external_token_interpolation_start] = true,
    [ts_external_token_interpolation_end] = true,
    [ts_external_token_quoted_enum_tag_start] = true,
    [ts_external_token_comment] = true,
  },
  [2] = {
    [ts_external_token_multstr_start] = true,
    [ts_external_token__str_start] = true,
    [ts_external_token_quoted_enum_tag_start] = true,
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token_multstr_start] = true,
    [ts_external_token__str_start] = true,
    [ts_external_token_interpolation_end] = true,
    [ts_external_token_quoted_enum_tag_start] = true,
    [ts_external_token_comment] = true,
  },
  [4] = {
    [ts_external_token_comment] = true,
  },
  [5] = {
    [ts_external_token_interpolation_end] = true,
    [ts_external_token_comment] = true,
  },
  [6] = {
    [ts_external_token_multstr_start] = true,
    [ts_external_token__str_start] = true,
    [ts_external_token_comment] = true,
  },
  [7] = {
    [ts_external_token_multstr_end] = true,
    [ts_external_token_interpolation_start] = true,
    [ts_external_token_comment] = true,
  },
  [8] = {
    [ts_external_token__str_end] = true,
    [ts_external_token_interpolation_start] = true,
    [ts_external_token_comment] = true,
  },
  [9] = {
    [ts_external_token_multstr_end] = true,
    [ts_external_token_comment] = true,
  },
  [10] = {
    [ts_external_token_quoted_enum_tag_start] = true,
    [ts_external_token_comment] = true,
  },
  [11] = {
    [ts_external_token__str_end] = true,
    [ts_external_token_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_keyword] = ACTIONS(1),
    [sym_num_literal] = ACTIONS(1),
    [sym_ident] = ACTIONS(1),
    [sym_raw_enum_tag] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_force] = ACTIONS(1),
    [anon_sym_optional] = ACTIONS(1),
    [anon_sym_priority] = ACTIONS(1),
    [anon_sym_doc] = ACTIONS(1),
    [anon_sym_rec] = ACTIONS(1),
    [anon_sym_not_exported] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_fun] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_forall] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_Array] = ACTIONS(1),
    [anon_sym_Dyn] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_double_quote] = ACTIONS(1),
    [sym_str_esc_char] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_Number] = ACTIONS(1),
    [anon_sym_Bool] = ACTIONS(1),
    [anon_sym_String] = ACTIONS(1),
    [anon_sym_LBRACK_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACK] = ACTIONS(1),
    [sym_multstr_start] = ACTIONS(1),
    [sym_multstr_end] = ACTIONS(1),
    [sym__str_start] = ACTIONS(1),
    [sym__str_end] = ACTIONS(1),
    [sym_interpolation_start] = ACTIONS(1),
    [sym_interpolation_end] = ACTIONS(1),
    [sym_quoted_enum_tag_start] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_term] = STATE(965),
    [sym_uni_term] = STATE(577),
    [sym_let_expr] = STATE(579),
    [sym_let_in_block] = STATE(34),
    [sym_fun_expr] = STATE(579),
    [sym_match_expr] = STATE(438),
    [sym_ite_expr] = STATE(579),
    [sym_annotated_infix_expr] = STATE(579),
    [sym_forall] = STATE(579),
    [sym_applicative] = STATE(79),
    [sym_type_array] = STATE(438),
    [sym_record_operand] = STATE(240),
    [sym_record_operation_chain] = STATE(341),
    [sym_uni_record] = STATE(217),
    [sym_atom] = STATE(341),
    [sym_bool] = STATE(217),
    [sym_str_chunks] = STATE(217),
    [sym_str_chunks_single] = STATE(246),
    [sym_str_chunks_multi] = STATE(246),
    [sym_quoted_enum_tag] = STATE(218),
    [sym_enum_tag] = STATE(217),
    [sym_builtin] = STATE(217),
    [sym_infix_u_op_5] = STATE(212),
    [sym_infix_expr] = STATE(462),
    [sym_type_builtin] = STATE(227),
    [sym_type_atom] = STATE(217),
    [sym_num_literal] = ACTIONS(5),
    [sym_ident] = ACTIONS(7),
    [sym_raw_enum_tag] = ACTIONS(9),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(13),
    [anon_sym_match] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_forall] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_Array] = ACTIONS(25),
    [anon_sym_Dyn] = ACTIONS(27),
    [anon_sym_LPAREN] = ACTIONS(29),
    [anon_sym_null] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_true] = ACTIONS(33),
    [anon_sym_false] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(35),
    [anon_sym__] = ACTIONS(37),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_BANG] = ACTIONS(41),
    [anon_sym_Number] = ACTIONS(27),
    [anon_sym_Bool] = ACTIONS(27),
    [anon_sym_String] = ACTIONS(27),
    [anon_sym_LBRACK_PIPE] = ACTIONS(43),
    [sym_multstr_start] = ACTIONS(45),
    [sym__str_start] = ACTIONS(47),
    [sym_quoted_enum_tag_start] = ACTIONS(49),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_uni_term] = STATE(913),
    [sym_let_expr] = STATE(579),
    [sym_let_in_block] = STATE(41),
    [sym_fun_expr] = STATE(579),
    [sym_match_expr] = STATE(130),
    [sym_ite_expr] = STATE(579),
    [sym_annotated_infix_expr] = STATE(579),
    [sym_forall] = STATE(579),
    [sym_applicative] = STATE(8),
    [sym_type_array] = STATE(130),
    [sym_record_operand] = STATE(91),
    [sym_record_operation_chain] = STATE(92),
    [sym_uni_record] = STATE(80),
    [sym_atom] = STATE(92),
    [sym_bool] = STATE(80),
    [sym_str_chunks] = STATE(80),
    [sym_str_chunks_single] = STATE(115),
    [sym_str_chunks_multi] = STATE(115),
    [sym_quoted_enum_tag] = STATE(88),
    [sym_enum_tag] = STATE(80),
    [sym_builtin] = STATE(80),
    [sym_infix_b_op_2] = STATE(972),
    [sym_infix_b_op_3] = STATE(972),
    [sym_infix_b_op_4] = STATE(972),
    [sym_infix_u_op_5] = STATE(146),
    [sym_infix_b_op_6] = STATE(972),
    [sym_infix_b_op_7] = STATE(972),
    [sym_infix_b_op_8] = STATE(972),
    [sym_infix_lazy_b_op_9] = STATE(1011),
    [sym_infix_lazy_b_op_10] = STATE(1011),
    [sym_infix_b_op] = STATE(930),
    [sym_infix_u_op_or_lazy_b_op] = STATE(930),
    [sym_infix_op] = STATE(1002),
    [sym_curried_op] = STATE(913),
    [sym_infix_expr] = STATE(448),
    [sym_type_builtin] = STATE(82),
    [sym_type_atom] = STATE(80),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_import] = ACTIONS(67),
    [anon_sym_Array] = ACTIONS(69),
    [anon_sym_Dyn] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_true] = ACTIONS(79),
    [anon_sym_false] = ACTIONS(79),
    [anon_sym_PERCENT] = ACTIONS(81),
    [anon_sym__] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_PLUS] = ACTIONS(87),
    [anon_sym_DASH] = ACTIONS(89),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_AMP] = ACTIONS(93),
    [anon_sym_PIPE_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(101),
    [anon_sym_BANG_EQ] = ACTIONS(101),
    [anon_sym_AMP_AMP] = ACTIONS(103),
    [anon_sym_PIPE_PIPE] = ACTIONS(105),
    [anon_sym_Number] = ACTIONS(71),
    [anon_sym_Bool] = ACTIONS(71),
    [anon_sym_String] = ACTIONS(71),
    [anon_sym_LBRACK_PIPE] = ACTIONS(107),
    [sym_multstr_start] = ACTIONS(109),
    [sym__str_start] = ACTIONS(111),
    [sym_quoted_enum_tag_start] = ACTIONS(113),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_uni_term] = STATE(900),
    [sym_let_expr] = STATE(579),
    [sym_let_in_block] = STATE(41),
    [sym_fun_expr] = STATE(579),
    [sym_match_expr] = STATE(130),
    [sym_ite_expr] = STATE(579),
    [sym_annotated_infix_expr] = STATE(579),
    [sym_forall] = STATE(579),
    [sym_applicative] = STATE(8),
    [sym_type_array] = STATE(130),
    [sym_record_operand] = STATE(91),
    [sym_record_operation_chain] = STATE(92),
    [sym_uni_record] = STATE(80),
    [sym_atom] = STATE(92),
    [sym_bool] = STATE(80),
    [sym_str_chunks] = STATE(80),
    [sym_str_chunks_single] = STATE(115),
    [sym_str_chunks_multi] = STATE(115),
    [sym_quoted_enum_tag] = STATE(88),
    [sym_enum_tag] = STATE(80),
    [sym_builtin] = STATE(80),
    [sym_infix_b_op_2] = STATE(972),
    [sym_infix_b_op_3] = STATE(972),
    [sym_infix_b_op_4] = STATE(972),
    [sym_infix_u_op_5] = STATE(146),
    [sym_infix_b_op_6] = STATE(972),
    [sym_infix_b_op_7] = STATE(972),
    [sym_infix_b_op_8] = STATE(972),
    [sym_infix_lazy_b_op_9] = STATE(1011),
    [sym_infix_lazy_b_op_10] = STATE(1011),
    [sym_infix_b_op] = STATE(930),
    [sym_infix_u_op_or_lazy_b_op] = STATE(930),
    [sym_infix_op] = STATE(1002),
    [sym_curried_op] = STATE(900),
    [sym_infix_expr] = STATE(448),
    [sym_type_builtin] = STATE(82),
    [sym_type_atom] = STATE(80),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_import] = ACTIONS(67),
    [anon_sym_Array] = ACTIONS(69),
    [anon_sym_Dyn] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_true] = ACTIONS(79),
    [anon_sym_false] = ACTIONS(79),
    [anon_sym_PERCENT] = ACTIONS(81),
    [anon_sym__] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_PLUS] = ACTIONS(87),
    [anon_sym_DASH] = ACTIONS(89),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_AMP] = ACTIONS(93),
    [anon_sym_PIPE_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(101),
    [anon_sym_BANG_EQ] = ACTIONS(101),
    [anon_sym_AMP_AMP] = ACTIONS(103),
    [anon_sym_PIPE_PIPE] = ACTIONS(105),
    [anon_sym_Number] = ACTIONS(71),
    [anon_sym_Bool] = ACTIONS(71),
    [anon_sym_String] = ACTIONS(71),
    [anon_sym_LBRACK_PIPE] = ACTIONS(107),
    [sym_multstr_start] = ACTIONS(109),
    [sym__str_start] = ACTIONS(111),
    [sym_quoted_enum_tag_start] = ACTIONS(113),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_uni_term] = STATE(1004),
    [sym_let_expr] = STATE(579),
    [sym_let_in_block] = STATE(41),
    [sym_fun_expr] = STATE(579),
    [sym_match_expr] = STATE(130),
    [sym_ite_expr] = STATE(579),
    [sym_annotated_infix_expr] = STATE(579),
    [sym_forall] = STATE(579),
    [sym_applicative] = STATE(8),
    [sym_type_array] = STATE(130),
    [sym_record_operand] = STATE(91),
    [sym_record_operation_chain] = STATE(92),
    [sym_uni_record] = STATE(80),
    [sym_atom] = STATE(92),
    [sym_bool] = STATE(80),
    [sym_str_chunks] = STATE(80),
    [sym_str_chunks_single] = STATE(115),
    [sym_str_chunks_multi] = STATE(115),
    [sym_quoted_enum_tag] = STATE(88),
    [sym_enum_tag] = STATE(80),
    [sym_builtin] = STATE(80),
    [sym_infix_b_op_2] = STATE(972),
    [sym_infix_b_op_3] = STATE(972),
    [sym_infix_b_op_4] = STATE(972),
    [sym_infix_u_op_5] = STATE(146),
    [sym_infix_b_op_6] = STATE(972),
    [sym_infix_b_op_7] = STATE(972),
    [sym_infix_b_op_8] = STATE(972),
    [sym_infix_lazy_b_op_9] = STATE(1011),
    [sym_infix_lazy_b_op_10] = STATE(1011),
    [sym_infix_b_op] = STATE(930),
    [sym_infix_u_op_or_lazy_b_op] = STATE(930),
    [sym_infix_op] = STATE(1002),
    [sym_curried_op] = STATE(1004),
    [sym_infix_expr] = STATE(448),
    [sym_type_builtin] = STATE(82),
    [sym_type_atom] = STATE(80),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_import] = ACTIONS(67),
    [anon_sym_Array] = ACTIONS(69),
    [anon_sym_Dyn] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_true] = ACTIONS(79),
    [anon_sym_false] = ACTIONS(79),
    [anon_sym_PERCENT] = ACTIONS(81),
    [anon_sym__] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_PLUS] = ACTIONS(87),
    [anon_sym_DASH] = ACTIONS(89),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_AMP] = ACTIONS(93),
    [anon_sym_PIPE_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(101),
    [anon_sym_BANG_EQ] = ACTIONS(101),
    [anon_sym_AMP_AMP] = ACTIONS(103),
    [anon_sym_PIPE_PIPE] = ACTIONS(105),
    [anon_sym_Number] = ACTIONS(71),
    [anon_sym_Bool] = ACTIONS(71),
    [anon_sym_String] = ACTIONS(71),
    [anon_sym_LBRACK_PIPE] = ACTIONS(107),
    [sym_multstr_start] = ACTIONS(109),
    [sym__str_start] = ACTIONS(111),
    [sym_quoted_enum_tag_start] = ACTIONS(113),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_uni_term] = STATE(1009),
    [sym_let_expr] = STATE(579),
    [sym_let_in_block] = STATE(41),
    [sym_fun_expr] = STATE(579),
    [sym_match_expr] = STATE(130),
    [sym_ite_expr] = STATE(579),
    [sym_annotated_infix_expr] = STATE(579),
    [sym_forall] = STATE(579),
    [sym_applicative] = STATE(8),
    [sym_type_array] = STATE(130),
    [sym_record_operand] = STATE(91),
    [sym_record_operation_chain] = STATE(92),
    [sym_uni_record] = STATE(80),
    [sym_atom] = STATE(92),
    [sym_bool] = STATE(80),
    [sym_str_chunks] = STATE(80),
    [sym_str_chunks_single] = STATE(115),
    [sym_str_chunks_multi] = STATE(115),
    [sym_quoted_enum_tag] = STATE(88),
    [sym_enum_tag] = STATE(80),
    [sym_builtin] = STATE(80),
    [sym_infix_b_op_2] = STATE(972),
    [sym_infix_b_op_3] = STATE(972),
    [sym_infix_b_op_4] = STATE(972),
    [sym_infix_u_op_5] = STATE(146),
    [sym_infix_b_op_6] = STATE(972),
    [sym_infix_b_op_7] = STATE(972),
    [sym_infix_b_op_8] = STATE(972),
    [sym_infix_lazy_b_op_9] = STATE(1011),
    [sym_infix_lazy_b_op_10] = STATE(1011),
    [sym_infix_b_op] = STATE(930),
    [sym_infix_u_op_or_lazy_b_op] = STATE(930),
    [sym_infix_op] = STATE(1002),
    [sym_curried_op] = STATE(1009),
    [sym_infix_expr] = STATE(448),
    [sym_type_builtin] = STATE(82),
    [sym_type_atom] = STATE(80),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_import] = ACTIONS(67),
    [anon_sym_Array] = ACTIONS(69),
    [anon_sym_Dyn] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_true] = ACTIONS(79),
    [anon_sym_false] = ACTIONS(79),
    [anon_sym_PERCENT] = ACTIONS(81),
    [anon_sym__] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_PLUS] = ACTIONS(87),
    [anon_sym_DASH] = ACTIONS(89),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_AMP] = ACTIONS(93),
    [anon_sym_PIPE_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(101),
    [anon_sym_BANG_EQ] = ACTIONS(101),
    [anon_sym_AMP_AMP] = ACTIONS(103),
    [anon_sym_PIPE_PIPE] = ACTIONS(105),
    [anon_sym_Number] = ACTIONS(71),
    [anon_sym_Bool] = ACTIONS(71),
    [anon_sym_String] = ACTIONS(71),
    [anon_sym_LBRACK_PIPE] = ACTIONS(107),
    [sym_multstr_start] = ACTIONS(109),
    [sym__str_start] = ACTIONS(111),
    [sym_quoted_enum_tag_start] = ACTIONS(113),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_uni_term] = STATE(969),
    [sym_let_expr] = STATE(579),
    [sym_let_in_block] = STATE(41),
    [sym_fun_expr] = STATE(579),
    [sym_match_expr] = STATE(130),
    [sym_ite_expr] = STATE(579),
    [sym_annotated_infix_expr] = STATE(579),
    [sym_forall] = STATE(579),
    [sym_applicative] = STATE(8),
    [sym_type_array] = STATE(130),
    [sym_record_operand] = STATE(91),
    [sym_record_operation_chain] = STATE(92),
    [sym_uni_record] = STATE(80),
    [sym_atom] = STATE(92),
    [sym_bool] = STATE(80),
    [sym_str_chunks] = STATE(80),
    [sym_str_chunks_single] = STATE(115),
    [sym_str_chunks_multi] = STATE(115),
    [sym_quoted_enum_tag] = STATE(88),
    [sym_enum_tag] = STATE(80),
    [sym_builtin] = STATE(80),
    [sym_infix_b_op_2] = STATE(972),
    [sym_infix_b_op_3] = STATE(972),
    [sym_infix_b_op_4] = STATE(972),
    [sym_infix_u_op_5] = STATE(146),
    [sym_infix_b_op_6] = STATE(972),
    [sym_infix_b_op_7] = STATE(972),
    [sym_infix_b_op_8] = STATE(972),
    [sym_infix_lazy_b_op_9] = STATE(1011),
    [sym_infix_lazy_b_op_10] = STATE(1011),
    [sym_infix_b_op] = STATE(930),
    [sym_infix_u_op_or_lazy_b_op] = STATE(930),
    [sym_infix_op] = STATE(1002),
    [sym_curried_op] = STATE(969),
    [sym_infix_expr] = STATE(448),
    [sym_type_builtin] = STATE(82),
    [sym_type_atom] = STATE(80),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_import] = ACTIONS(67),
    [anon_sym_Array] = ACTIONS(69),
    [anon_sym_Dyn] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_true] = ACTIONS(79),
    [anon_sym_false] = ACTIONS(79),
    [anon_sym_PERCENT] = ACTIONS(81),
    [anon_sym__] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_PLUS] = ACTIONS(87),
    [anon_sym_DASH] = ACTIONS(89),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_AMP] = ACTIONS(93),
    [anon_sym_PIPE_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(101),
    [anon_sym_BANG_EQ] = ACTIONS(101),
    [anon_sym_AMP_AMP] = ACTIONS(103),
    [anon_sym_PIPE_PIPE] = ACTIONS(105),
    [anon_sym_Number] = ACTIONS(71),
    [anon_sym_Bool] = ACTIONS(71),
    [anon_sym_String] = ACTIONS(71),
    [anon_sym_LBRACK_PIPE] = ACTIONS(107),
    [sym_multstr_start] = ACTIONS(109),
    [sym__str_start] = ACTIONS(111),
    [sym_quoted_enum_tag_start] = ACTIONS(113),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_uni_term] = STATE(928),
    [sym_let_expr] = STATE(579),
    [sym_let_in_block] = STATE(41),
    [sym_fun_expr] = STATE(579),
    [sym_match_expr] = STATE(130),
    [sym_ite_expr] = STATE(579),
    [sym_annotated_infix_expr] = STATE(579),
    [sym_forall] = STATE(579),
    [sym_applicative] = STATE(8),
    [sym_type_array] = STATE(130),
    [sym_record_operand] = STATE(91),
    [sym_record_operation_chain] = STATE(92),
    [sym_uni_record] = STATE(80),
    [sym_atom] = STATE(92),
    [sym_bool] = STATE(80),
    [sym_str_chunks] = STATE(80),
    [sym_str_chunks_single] = STATE(115),
    [sym_str_chunks_multi] = STATE(115),
    [sym_quoted_enum_tag] = STATE(88),
    [sym_enum_tag] = STATE(80),
    [sym_builtin] = STATE(80),
    [sym_infix_b_op_2] = STATE(972),
    [sym_infix_b_op_3] = STATE(972),
    [sym_infix_b_op_4] = STATE(972),
    [sym_infix_u_op_5] = STATE(146),
    [sym_infix_b_op_6] = STATE(972),
    [sym_infix_b_op_7] = STATE(972),
    [sym_infix_b_op_8] = STATE(972),
    [sym_infix_lazy_b_op_9] = STATE(1011),
    [sym_infix_lazy_b_op_10] = STATE(1011),
    [sym_infix_b_op] = STATE(930),
    [sym_infix_u_op_or_lazy_b_op] = STATE(930),
    [sym_infix_op] = STATE(1002),
    [sym_curried_op] = STATE(928),
    [sym_infix_expr] = STATE(448),
    [sym_type_builtin] = STATE(82),
    [sym_type_atom] = STATE(80),
    [sym_num_literal] = ACTIONS(51),
    [sym_ident] = ACTIONS(53),
    [sym_raw_enum_tag] = ACTIONS(55),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_fun] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACE] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_forall] = ACTIONS(65),
    [anon_sym_import] = ACTIONS(67),
    [anon_sym_Array] = ACTIONS(69),
    [anon_sym_Dyn] = ACTIONS(71),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_null] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_true] = ACTIONS(79),
    [anon_sym_false] = ACTIONS(79),
    [anon_sym_PERCENT] = ACTIONS(81),
    [anon_sym__] = ACTIONS(83),
    [anon_sym_PLUS_PLUS] = ACTIONS(77),
    [anon_sym_STAR] = ACTIONS(85),
    [anon_sym_SLASH] = ACTIONS(85),
    [anon_sym_PLUS] = ACTIONS(87),
    [anon_sym_DASH] = ACTIONS(89),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_AMP] = ACTIONS(93),
    [anon_sym_PIPE_GT] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(97),
    [anon_sym_LT_EQ] = ACTIONS(99),
    [anon_sym_GT] = ACTIONS(97),
    [anon_sym_GT_EQ] = ACTIONS(99),
    [anon_sym_EQ_EQ] = ACTIONS(101),
    [anon_sym_BANG_EQ] = ACTIONS(101),
    [anon_sym_AMP_AMP] = ACTIONS(103),
    [anon_sym_PIPE_PIPE] = ACTIONS(105),
    [anon_sym_Number] = ACTIONS(71),
    [anon_sym_Bool] = ACTIONS(71),
    [anon_sym_String] = ACTIONS(71),
    [anon_sym_LBRACK_PIPE] = ACTIONS(107),
    [sym_multstr_start] = ACTIONS(109),
    [sym__str_start] = ACTIONS(111),
    [sym_quoted_enum_tag_start] = ACTIONS(113),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(101), 1,
      sym_record_operand,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(115), 7,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 20,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [104] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(119), 1,
      anon_sym_COMMA,
    ACTIONS(121), 1,
      anon_sym_RBRACK,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(805), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [242] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(129), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(802), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [380] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(131), 1,
      anon_sym_COMMA,
    ACTIONS(133), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(843), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [518] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(135), 1,
      anon_sym_COMMA,
    ACTIONS(137), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(826), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [656] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(139), 1,
      anon_sym_COMMA,
    ACTIONS(141), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(778), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [794] = 40,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(143), 1,
      anon_sym_COMMA,
    ACTIONS(145), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(798), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [932] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(147), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [1067] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(149), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [1202] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(151), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [1337] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(153), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [1472] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(155), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [1607] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(157), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [1742] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(159), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [1877] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(161), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [2012] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(163), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [2147] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(165), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [2282] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(167), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [2417] = 39,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(169), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [2552] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(576), 1,
      sym_term,
    STATE(577), 1,
      sym_uni_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [2684] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_forall,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(35), 1,
      sym_let_in_block,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(467), 1,
      sym_infix_expr,
    STATE(576), 1,
      sym_term,
    STATE(577), 1,
      sym_uni_term,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [2816] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(219), 1,
      anon_sym_fun,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(225), 1,
      anon_sym_if,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(469), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(1031), 1,
      sym_term,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [2948] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_forall,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(35), 1,
      sym_let_in_block,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(467), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(903), 1,
      sym_term,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [3080] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(219), 1,
      anon_sym_fun,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(225), 1,
      anon_sym_if,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(469), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(954), 1,
      sym_term,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [3212] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_forall,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(35), 1,
      sym_let_in_block,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(467), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(990), 1,
      sym_term,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [3344] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(261), 1,
      anon_sym_fun,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(267), 1,
      anon_sym_if,
    ACTIONS(269), 1,
      anon_sym_forall,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(468), 1,
      sym_infix_expr,
    STATE(898), 1,
      sym_term,
    STATE(905), 1,
      sym_uni_term,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(910), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [3476] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_fun,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(34), 1,
      sym_let_in_block,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(462), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(587), 1,
      sym_term,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [3608] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_forall,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(35), 1,
      sym_let_in_block,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(467), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(587), 1,
      sym_term,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [3740] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(866), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [3872] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(261), 1,
      anon_sym_fun,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(267), 1,
      anon_sym_if,
    ACTIONS(269), 1,
      anon_sym_forall,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(468), 1,
      sym_infix_expr,
    STATE(905), 1,
      sym_uni_term,
    STATE(946), 1,
      sym_term,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(910), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [4004] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(261), 1,
      anon_sym_fun,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(267), 1,
      anon_sym_if,
    ACTIONS(269), 1,
      anon_sym_forall,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(468), 1,
      sym_infix_expr,
    STATE(905), 1,
      sym_uni_term,
    STATE(967), 1,
      sym_term,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(910), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [4136] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(303), 1,
      anon_sym_fun,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(309), 1,
      anon_sym_if,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(56), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(466), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(1034), 1,
      sym_term,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [4268] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(219), 1,
      anon_sym_fun,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(225), 1,
      anon_sym_if,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(469), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(971), 1,
      sym_term,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [4400] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(587), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [4532] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(303), 1,
      anon_sym_fun,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(309), 1,
      anon_sym_if,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(56), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(466), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(1032), 1,
      sym_term,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [4664] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(815), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [4796] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(303), 1,
      anon_sym_fun,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(309), 1,
      anon_sym_if,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(56), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(466), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(947), 1,
      sym_term,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [4928] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(219), 1,
      anon_sym_fun,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(225), 1,
      anon_sym_if,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(469), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(893), 1,
      sym_term,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [5060] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_forall,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(35), 1,
      sym_let_in_block,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(467), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(959), 1,
      sym_term,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [5192] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(261), 1,
      anon_sym_fun,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(267), 1,
      anon_sym_if,
    ACTIONS(269), 1,
      anon_sym_forall,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(468), 1,
      sym_infix_expr,
    STATE(905), 1,
      sym_uni_term,
    STATE(1039), 1,
      sym_term,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(910), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [5324] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(219), 1,
      anon_sym_fun,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(225), 1,
      anon_sym_if,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(469), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(1036), 1,
      sym_term,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [5456] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(219), 1,
      anon_sym_fun,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(225), 1,
      anon_sym_if,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(469), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(934), 1,
      sym_term,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [5588] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(303), 1,
      anon_sym_fun,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(309), 1,
      anon_sym_if,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(56), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(466), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(1026), 1,
      sym_term,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [5720] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(219), 1,
      anon_sym_fun,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(225), 1,
      anon_sym_if,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(469), 1,
      sym_infix_expr,
    STATE(576), 1,
      sym_term,
    STATE(577), 1,
      sym_uni_term,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [5852] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(580), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [5984] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(219), 1,
      anon_sym_fun,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(225), 1,
      anon_sym_if,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(469), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(580), 1,
      sym_term,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [6116] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_fun,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(34), 1,
      sym_let_in_block,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(462), 1,
      sym_infix_expr,
    STATE(576), 1,
      sym_term,
    STATE(577), 1,
      sym_uni_term,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [6248] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(771), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [6380] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(303), 1,
      anon_sym_fun,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(309), 1,
      anon_sym_if,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(56), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(466), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(587), 1,
      sym_term,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [6512] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(261), 1,
      anon_sym_fun,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(267), 1,
      anon_sym_if,
    ACTIONS(269), 1,
      anon_sym_forall,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(38), 1,
      sym_let_in_block,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(468), 1,
      sym_infix_expr,
    STATE(905), 1,
      sym_uni_term,
    STATE(1023), 1,
      sym_term,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(910), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [6644] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(842), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [6776] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(303), 1,
      anon_sym_fun,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(309), 1,
      anon_sym_if,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(56), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(466), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(1028), 1,
      sym_term,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [6908] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(881), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [7040] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(57), 1,
      anon_sym_fun,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(63), 1,
      anon_sym_if,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(41), 1,
      sym_let_in_block,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(448), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(877), 1,
      sym_term,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [7172] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_forall,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(35), 1,
      sym_let_in_block,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(467), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(909), 1,
      sym_term,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [7304] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(303), 1,
      anon_sym_fun,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(309), 1,
      anon_sym_if,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(56), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(466), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(580), 1,
      sym_term,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [7436] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(303), 1,
      anon_sym_fun,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(309), 1,
      anon_sym_if,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(56), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(466), 1,
      sym_infix_expr,
    STATE(576), 1,
      sym_term,
    STATE(577), 1,
      sym_uni_term,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [7568] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(219), 1,
      anon_sym_fun,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(225), 1,
      anon_sym_if,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(65), 1,
      sym_let_in_block,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(469), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(587), 1,
      sym_term,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [7700] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(303), 1,
      anon_sym_fun,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(309), 1,
      anon_sym_if,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(56), 1,
      sym_let_in_block,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(466), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(1030), 1,
      sym_term,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [7832] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_fun,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_if,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(34), 1,
      sym_let_in_block,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(462), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(580), 1,
      sym_term,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [7964] = 38,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(177), 1,
      anon_sym_fun,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_forall,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(35), 1,
      sym_let_in_block,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(467), 1,
      sym_infix_expr,
    STATE(577), 1,
      sym_uni_term,
    STATE(580), 1,
      sym_term,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(579), 5,
      sym_let_expr,
      sym_fun_expr,
      sym_ite_expr,
      sym_annotated_infix_expr,
      sym_forall,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [8096] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(341), 1,
      anon_sym_priority,
    ACTIONS(343), 1,
      anon_sym_doc,
    ACTIONS(345), 1,
      anon_sym_rec,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(488), 1,
      sym_infix_expr,
    STATE(565), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(339), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [8224] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(242), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(115), 7,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 14,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [8322] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(341), 1,
      anon_sym_priority,
    ACTIONS(343), 1,
      anon_sym_doc,
    ACTIONS(345), 1,
      anon_sym_rec,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(453), 1,
      sym_infix_expr,
    STATE(565), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(339), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [8450] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(341), 1,
      anon_sym_priority,
    ACTIONS(343), 1,
      anon_sym_doc,
    ACTIONS(345), 1,
      anon_sym_rec,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(510), 1,
      sym_infix_expr,
    STATE(565), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(339), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [8578] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(310), 1,
      sym_record_operand,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(115), 7,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 14,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [8676] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(185), 1,
      anon_sym_forall,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(341), 1,
      anon_sym_priority,
    ACTIONS(343), 1,
      anon_sym_doc,
    ACTIONS(345), 1,
      anon_sym_rec,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(501), 1,
      sym_infix_expr,
    STATE(565), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(339), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [8804] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(269), 1,
      anon_sym_forall,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(349), 1,
      anon_sym_priority,
    ACTIONS(351), 1,
      anon_sym_doc,
    ACTIONS(353), 1,
      anon_sym_rec,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(499), 1,
      sym_infix_expr,
    STATE(790), 1,
      sym_forall,
    STATE(792), 1,
      sym_types,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(347), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [8932] = 37,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(341), 1,
      anon_sym_priority,
    ACTIONS(343), 1,
      anon_sym_doc,
    ACTIONS(345), 1,
      anon_sym_rec,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(522), 1,
      sym_infix_expr,
    STATE(565), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(339), 4,
      anon_sym_default,
      anon_sym_force,
      anon_sym_optional,
      anon_sym_not_exported,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [9060] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(286), 1,
      sym_type_builtin,
    STATE(342), 1,
      sym_record_operand,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(115), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(117), 15,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [9158] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(324), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(115), 7,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 14,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [9256] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(343), 1,
      sym_record_operand,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(115), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
    ACTIONS(117), 15,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [9354] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(355), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9408] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(359), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9462] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(363), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9516] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(367), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(371), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9624] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(375), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9678] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(379), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9732] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(383), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9786] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [9948] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_DOT,
    ACTIONS(401), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(405), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10058] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(409), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10112] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(413), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10166] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(417), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10220] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(421), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10274] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(425), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10328] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_DOT,
    ACTIONS(431), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(429), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10384] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(433), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(437), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10492] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(403), 1,
      anon_sym_DOT,
    ACTIONS(443), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(441), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10548] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(445), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10602] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(449), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10656] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(453), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(457), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(461), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(465), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10872] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(469), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(473), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [10980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(477), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11034] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(481), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11088] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(485), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11142] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(489), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(493), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11250] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(497), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(501), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11358] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(507), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(505), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(509), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11466] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(513), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(517), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [11572] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(269), 1,
      anon_sym_forall,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(499), 1,
      sym_infix_expr,
    STATE(790), 1,
      sym_forall,
    STATE(792), 1,
      sym_types,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [11685] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(453), 1,
      sym_infix_expr,
    STATE(557), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [11798] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(522), 1,
      sym_infix_expr,
    STATE(565), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [11911] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(453), 1,
      sym_infix_expr,
    STATE(566), 1,
      sym_forall,
    STATE(943), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [12024] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(453), 1,
      sym_infix_expr,
    STATE(566), 1,
      sym_forall,
    STATE(1038), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [12137] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(227), 1,
      anon_sym_forall,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(522), 1,
      sym_infix_expr,
    STATE(557), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [12250] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(521), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12303] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(453), 1,
      sym_infix_expr,
    STATE(565), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [12416] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(185), 1,
      anon_sym_forall,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(501), 1,
      sym_infix_expr,
    STATE(557), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [12529] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12582] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(453), 1,
      sym_infix_expr,
    STATE(566), 1,
      sym_forall,
    STATE(964), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [12695] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(185), 1,
      anon_sym_forall,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(501), 1,
      sym_infix_expr,
    STATE(565), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [12808] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(525), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [12861] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(453), 1,
      sym_infix_expr,
    STATE(566), 1,
      sym_forall,
    STATE(985), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [12974] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(488), 1,
      sym_infix_expr,
    STATE(565), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [13087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(529), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [13140] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(535), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(533), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [13193] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(453), 1,
      sym_infix_expr,
    STATE(566), 1,
      sym_forall,
    STATE(978), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [13306] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(510), 1,
      sym_infix_expr,
    STATE(565), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [13419] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_forall,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(510), 1,
      sym_infix_expr,
    STATE(557), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [13532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(537), 28,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [13585] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(269), 1,
      anon_sym_forall,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(499), 1,
      sym_infix_expr,
    STATE(769), 1,
      sym_types,
    STATE(790), 1,
      sym_forall,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [13698] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(65), 1,
      anon_sym_forall,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(453), 1,
      sym_infix_expr,
    STATE(566), 1,
      sym_forall,
    STATE(931), 1,
      sym_types,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [13811] = 33,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(311), 1,
      anon_sym_forall,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(488), 1,
      sym_infix_expr,
    STATE(557), 1,
      sym_types,
    STATE(566), 1,
      sym_forall,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [13924] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(541), 1,
      anon_sym_RPAREN,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(459), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [14031] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    ACTIONS(543), 1,
      anon_sym_RPAREN,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(452), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [14138] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(518), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [14242] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(475), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [14346] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(491), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [14450] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(472), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [14554] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(500), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [14658] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(524), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [14762] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(525), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [14866] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(519), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [14970] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(517), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [15074] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(455), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [15178] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(457), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [15282] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(451), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [15386] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(450), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [15490] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(456), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [15594] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(460), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [15698] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(458), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [15802] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(449), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [15906] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(454), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [16010] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(516), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [16114] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(515), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [16218] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(514), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [16322] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(513), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [16426] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(512), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [16530] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(531), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [16634] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(473), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [16738] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(530), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [16842] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(529), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [16946] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(452), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [17050] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(528), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [17154] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(527), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [17258] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(263), 1,
      anon_sym_match,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(271), 1,
      anon_sym_import,
    ACTIONS(273), 1,
      anon_sym_Array,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(287), 1,
      anon_sym_DASH,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(77), 1,
      sym_applicative,
    STATE(150), 1,
      sym_infix_u_op_5,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(265), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    STATE(526), 1,
      sym_infix_expr,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(426), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [17362] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(523), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [17466] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(521), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [17570] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(59), 1,
      anon_sym_match,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(67), 1,
      anon_sym_import,
    ACTIONS(69), 1,
      anon_sym_Array,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    ACTIONS(125), 1,
      anon_sym_DASH,
    STATE(8), 1,
      sym_applicative,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(91), 1,
      sym_record_operand,
    STATE(174), 1,
      sym_infix_u_op_5,
    STATE(459), 1,
      sym_infix_expr,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(130), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [17674] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(511), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [17778] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(507), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [17882] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(505), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [17986] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(504), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [18090] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(484), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [18194] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(481), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [18298] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(478), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [18402] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(477), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [18506] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(179), 1,
      anon_sym_match,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(187), 1,
      anon_sym_import,
    ACTIONS(189), 1,
      anon_sym_Array,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(203), 1,
      anon_sym_DASH,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(78), 1,
      sym_applicative,
    STATE(179), 1,
      sym_infix_u_op_5,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(349), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    STATE(476), 1,
      sym_infix_expr,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(435), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [18610] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(520), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [18714] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(498), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [18818] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(497), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [18922] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(496), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [19026] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(495), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [19130] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(493), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [19234] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(492), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [19338] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(509), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [19442] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(490), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [19546] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(489), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [19650] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(474), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [19754] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(508), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [19858] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(480), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [19962] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(506), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [20066] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(503), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [20170] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(487), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [20274] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(502), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [20378] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(494), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [20482] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(485), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [20586] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(305), 1,
      anon_sym_match,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(313), 1,
      anon_sym_import,
    ACTIONS(315), 1,
      anon_sym_Array,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(329), 1,
      anon_sym_DASH,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(73), 1,
      sym_applicative,
    STATE(205), 1,
      sym_infix_u_op_5,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(284), 1,
      sym_record_operand,
    STATE(486), 1,
      sym_infix_expr,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(429), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [20690] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(483), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [20794] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(221), 1,
      anon_sym_match,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(229), 1,
      anon_sym_import,
    ACTIONS(231), 1,
      anon_sym_Array,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(245), 1,
      anon_sym_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(70), 1,
      sym_applicative,
    STATE(197), 1,
      sym_infix_u_op_5,
    STATE(261), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    STATE(482), 1,
      sym_infix_expr,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(420), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [20898] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(15), 1,
      anon_sym_match,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_Array,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(39), 1,
      anon_sym_DASH,
    ACTIONS(41), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(79), 1,
      sym_applicative,
    STATE(212), 1,
      sym_infix_u_op_5,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(240), 1,
      sym_record_operand,
    STATE(479), 1,
      sym_infix_expr,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(438), 2,
      sym_match_expr,
      sym_type_array,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [21002] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21050] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(413), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21098] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(425), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21146] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(449), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21194] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(355), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21242] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(421), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21338] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(417), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21386] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(437), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(433), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21482] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(453), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21530] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(379), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(367), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21626] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(461), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(363), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21722] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(383), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21770] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(375), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(359), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21866] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(371), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21914] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(431), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(429), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [21964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(413), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22012] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(477), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(413), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22108] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(473), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(501), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22204] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(457), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22300] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(547), 1,
      anon_sym_DOT,
    ACTIONS(401), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22350] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22398] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 1,
      anon_sym_DOT,
    ACTIONS(443), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(441), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22448] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(437), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22496] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(433), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22544] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 1,
      anon_sym_DOT,
    ACTIONS(431), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(429), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22594] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(497), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(457), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22738] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(413), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22786] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(409), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22834] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(465), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(469), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22930] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(507), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(505), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [22978] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(481), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23026] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(485), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23074] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(493), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23122] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(501), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(489), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23218] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(497), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23266] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(405), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23314] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 1,
      anon_sym_DOT,
    ACTIONS(401), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23364] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(509), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23412] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(405), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23460] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(547), 1,
      anon_sym_DOT,
    ACTIONS(431), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(429), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23510] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(401), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23560] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(363), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23608] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(507), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(505), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23656] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(367), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(509), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(379), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23800] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23848] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(355), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23896] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23944] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [23992] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(379), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24040] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(367), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24088] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(363), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24136] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(387), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(489), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24232] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(355), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(509), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24328] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(497), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24376] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(507), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(505), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24424] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(551), 1,
      anon_sym_DOT,
    ACTIONS(401), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24474] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(405), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24522] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(363), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(501), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24618] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(367), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24666] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(379), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24714] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(493), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24762] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(481), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(469), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24858] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(465), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(409), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [24954] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(413), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25002] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(489), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25050] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(551), 1,
      anon_sym_DOT,
    ACTIONS(431), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(429), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25100] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(355), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25148] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(359), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(461), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25244] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(453), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25292] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(449), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25340] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(445), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25388] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(485), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25436] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(425), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25484] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(433), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(421), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(437), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(417), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25676] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(551), 1,
      anon_sym_DOT,
    ACTIONS(443), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(441), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25726] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(409), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25774] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(383), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25822] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(445), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25870] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(375), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25918] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(371), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [25966] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(477), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26014] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26062] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(473), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26110] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26158] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(457), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26206] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26254] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(485), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26302] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26350] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 1,
      anon_sym_DOT,
    ACTIONS(443), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(441), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26400] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(437), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26448] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(433), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26496] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(457), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26544] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 1,
      anon_sym_DOT,
    ACTIONS(431), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(429), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26594] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(459), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(457), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(473), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26690] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(477), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26738] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(493), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26786] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(481), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26834] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(371), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(375), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26930] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(383), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [26978] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(417), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27026] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(421), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27074] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(425), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27122] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(469), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(405), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27218] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 1,
      anon_sym_DOT,
    ACTIONS(443), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(441), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27268] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(547), 1,
      anon_sym_DOT,
    ACTIONS(443), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(441), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(409), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27366] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(485), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27414] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(489), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27462] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(497), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27510] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(405), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27558] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(553), 1,
      anon_sym_DOT,
    ACTIONS(401), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27608] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(465), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27656] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(445), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(435), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(433), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(363), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27800] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(367), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27848] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(379), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27896] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(473), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27944] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(445), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [27992] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(449), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28040] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(439), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(437), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28088] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(359), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28136] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(453), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(461), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28232] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(359), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(449), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28328] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(409), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28376] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(461), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28424] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(475), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(473), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28472] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(465), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28520] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(469), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28568] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(481), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28616] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(477), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28664] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(493), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28712] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(501), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28760] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(477), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28808] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(507), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(505), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28856] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(371), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28904] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(509), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [28952] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(375), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29000] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(383), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29048] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(417), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29096] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(371), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29144] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(375), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29192] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(421), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29240] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(355), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29288] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(509), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29336] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(507), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(505), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29384] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(391), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29432] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(501), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29480] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(493), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29528] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(497), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29576] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(395), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29624] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(489), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29672] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(425), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29720] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(485), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29768] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(481), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29816] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(471), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(469), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29864] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(467), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(465), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29912] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(383), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [29960] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(359), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30008] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 18,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(453), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(463), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(461), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30104] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(453), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30152] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(447), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(445), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30200] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(451), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(449), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30248] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(425), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30296] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(421), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(417), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30392] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(537), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30439] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(535), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(533), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30486] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(535), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(533), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30533] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(513), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(517), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30627] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(529), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30674] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(537), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30721] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(525), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30768] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(521), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30815] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(517), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30862] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(525), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30909] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(537), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [30956] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31003] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(529), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31050] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(537), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31097] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(525), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31144] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(529), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(525), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31238] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(517), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31332] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(521), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31426] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(525), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(513), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31520] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(537), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31567] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(517), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31614] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(529), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31661] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31708] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(517), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31755] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(535), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(533), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31802] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(399), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(513), 23,
      sym_multstr_start,
      sym__str_start,
      sym_interpolation_end,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31896] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(513), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31943] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(521), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [31990] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(513), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32037] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(529), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32084] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_then,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(521), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_in,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(521), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32178] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(535), 16,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(533), 23,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      ts_builtin_sym_end,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(535), 17,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_else,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    ACTIONS(533), 22,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK_PIPE,
  [32272] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(555), 1,
      anon_sym_PIPE,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(559), 1,
      anon_sym_EQ,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(583), 1,
      anon_sym_DASH_GT,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    STATE(590), 1,
      sym_annot,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(567), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(561), 5,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [32363] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(585), 7,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 20,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [32422] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 4,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 14,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [32491] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(585), 2,
      anon_sym_PIPE,
      anon_sym_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 12,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [32564] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(589), 5,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 15,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [32629] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(583), 1,
      anon_sym_DASH_GT,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(593), 2,
      anon_sym_PIPE,
      anon_sym_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(595), 7,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [32710] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(583), 1,
      anon_sym_DASH_GT,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(585), 2,
      anon_sym_PIPE,
      anon_sym_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 7,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [32791] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(585), 2,
      anon_sym_PIPE,
      anon_sym_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 9,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [32868] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 5,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 15,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [32933] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(585), 2,
      anon_sym_PIPE,
      anon_sym_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 10,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [33008] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(585), 7,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 18,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [33069] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(589), 7,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 20,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_QMARK,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [33128] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(156), 1,
      sym_infix_lazy_b_op_10,
    STATE(157), 1,
      sym_infix_lazy_b_op_9,
    STATE(158), 1,
      sym_infix_b_op_8,
    STATE(159), 1,
      sym_infix_b_op_7,
    STATE(160), 1,
      sym_infix_b_op_6,
    STATE(161), 1,
      sym_infix_b_op_4,
    STATE(162), 1,
      sym_infix_b_op_3,
    STATE(163), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 7,
      anon_sym_PIPE,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 15,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [33191] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 1,
      sym_num_literal,
    ACTIONS(175), 1,
      sym_raw_enum_tag,
    ACTIONS(181), 1,
      anon_sym_LBRACE,
    ACTIONS(193), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_LBRACK,
    ACTIONS(199), 1,
      anon_sym_PERCENT,
    ACTIONS(201), 1,
      anon_sym__,
    ACTIONS(205), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(211), 1,
      sym_quoted_enum_tag_start,
    STATE(278), 1,
      sym_quoted_enum_tag,
    STATE(328), 1,
      sym_record_operand,
    STATE(353), 1,
      sym_type_builtin,
    ACTIONS(173), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(348), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(191), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(384), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [33267] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 1,
      ts_builtin_sym_end,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(597), 1,
      anon_sym_PIPE,
    ACTIONS(599), 1,
      anon_sym_COLON,
    ACTIONS(601), 1,
      anon_sym_DASH_GT,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    STATE(590), 1,
      sym_annot,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(740), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [33351] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(51), 1,
      sym_num_literal,
    ACTIONS(55), 1,
      sym_raw_enum_tag,
    ACTIONS(61), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_LPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(83), 1,
      anon_sym__,
    ACTIONS(107), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(113), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(123), 1,
      anon_sym_PERCENT,
    STATE(82), 1,
      sym_type_builtin,
    STATE(88), 1,
      sym_quoted_enum_tag,
    STATE(98), 1,
      sym_record_operand,
    ACTIONS(53), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(79), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(92), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(71), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(80), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [33427] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 1,
      sym_num_literal,
    ACTIONS(301), 1,
      sym_raw_enum_tag,
    ACTIONS(307), 1,
      anon_sym_LBRACE,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    ACTIONS(321), 1,
      anon_sym_LBRACK,
    ACTIONS(325), 1,
      anon_sym_PERCENT,
    ACTIONS(327), 1,
      anon_sym__,
    ACTIONS(331), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(337), 1,
      sym_quoted_enum_tag_start,
    STATE(273), 1,
      sym_quoted_enum_tag,
    STATE(277), 1,
      sym_type_builtin,
    STATE(297), 1,
      sym_record_operand,
    ACTIONS(299), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(323), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(285), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(317), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(272), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [33503] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 1,
      sym_num_literal,
    ACTIONS(217), 1,
      sym_raw_enum_tag,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    ACTIONS(235), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_PERCENT,
    ACTIONS(243), 1,
      anon_sym__,
    ACTIONS(247), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(253), 1,
      sym_quoted_enum_tag_start,
    STATE(245), 1,
      sym_record_operand,
    STATE(266), 1,
      sym_type_builtin,
    STATE(271), 1,
      sym_quoted_enum_tag,
    ACTIONS(215), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(239), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(260), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(233), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(280), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [33579] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 1,
      anon_sym_then,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(603), 1,
      anon_sym_PIPE,
    ACTIONS(605), 1,
      anon_sym_COLON,
    ACTIONS(607), 1,
      anon_sym_DASH_GT,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    STATE(590), 1,
      sym_annot,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(725), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [33663] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 1,
      anon_sym_in,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(609), 1,
      anon_sym_PIPE,
    ACTIONS(611), 1,
      anon_sym_COLON,
    ACTIONS(613), 1,
      anon_sym_DASH_GT,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    STATE(590), 1,
      sym_annot,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(722), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [33747] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 1,
      sym_interpolation_end,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(615), 1,
      anon_sym_PIPE,
    ACTIONS(617), 1,
      anon_sym_COLON,
    ACTIONS(619), 1,
      anon_sym_DASH_GT,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    STATE(988), 1,
      sym_annot,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(736), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [33831] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 1,
      anon_sym_else,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(621), 1,
      anon_sym_PIPE,
    ACTIONS(623), 1,
      anon_sym_COLON,
    ACTIONS(625), 1,
      anon_sym_DASH_GT,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    STATE(590), 1,
      sym_annot,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    STATE(726), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [33915] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(5), 1,
      sym_num_literal,
    ACTIONS(9), 1,
      sym_raw_enum_tag,
    ACTIONS(17), 1,
      anon_sym_LBRACE,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_PERCENT,
    ACTIONS(37), 1,
      anon_sym__,
    ACTIONS(43), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(49), 1,
      sym_quoted_enum_tag_start,
    STATE(218), 1,
      sym_quoted_enum_tag,
    STATE(227), 1,
      sym_type_builtin,
    STATE(264), 1,
      sym_record_operand,
    ACTIONS(7), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(33), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    STATE(341), 2,
      sym_record_operation_chain,
      sym_atom,
    ACTIONS(27), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(217), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [33991] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      sym_num_literal,
    ACTIONS(259), 1,
      sym_raw_enum_tag,
    ACTIONS(265), 1,
      anon_sym_LBRACE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(279), 1,
      anon_sym_LBRACK,
    ACTIONS(283), 1,
      anon_sym_PERCENT,
    ACTIONS(285), 1,
      anon_sym__,
    ACTIONS(289), 1,
      anon_sym_LBRACK_PIPE,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(295), 1,
      sym_quoted_enum_tag_start,
    STATE(213), 1,
      sym_quoted_enum_tag,
    STATE(232), 1,
      sym_record_operand,
    STATE(286), 1,
      sym_type_builtin,
    ACTIONS(257), 2,
      sym_ident,
      anon_sym_null,
    ACTIONS(281), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(263), 2,
      sym_record_operation_chain,
      sym_atom,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(275), 4,
      anon_sym_Dyn,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
    STATE(298), 6,
      sym_uni_record,
      sym_bool,
      sym_str_chunks,
      sym_enum_tag,
      sym_builtin,
      sym_type_atom,
  [34067] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(589), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 10,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34126] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    ACTIONS(601), 1,
      anon_sym_DASH_GT,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(587), 2,
      ts_builtin_sym_end,
      anon_sym_COLON,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [34201] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    ACTIONS(625), 1,
      anon_sym_DASH_GT,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(587), 2,
      anon_sym_COLON,
      anon_sym_else,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [34276] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(589), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 15,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34329] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 4,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34400] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 5,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34469] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 7,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34536] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(589), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 10,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34595] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    ACTIONS(607), 1,
      anon_sym_DASH_GT,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(587), 2,
      anon_sym_COLON,
      anon_sym_then,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [34670] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 9,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34733] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 4,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34804] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 5,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34873] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 10,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34932] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 7,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [34999] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(589), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 15,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35052] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(589), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 10,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35111] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(593), 1,
      anon_sym_PIPE,
    ACTIONS(607), 1,
      anon_sym_DASH_GT,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(595), 2,
      anon_sym_COLON,
      anon_sym_then,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [35186] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 15,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35239] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 13,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35294] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(589), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 15,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35347] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 10,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35404] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 10,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35463] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 9,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35526] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 9,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35589] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 7,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35656] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 5,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35725] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(191), 1,
      sym_infix_lazy_b_op_10,
    STATE(192), 1,
      sym_infix_lazy_b_op_9,
    STATE(193), 1,
      sym_infix_b_op_8,
    STATE(194), 1,
      sym_infix_b_op_7,
    STATE(195), 1,
      sym_infix_b_op_6,
    STATE(196), 1,
      sym_infix_b_op_4,
    STATE(198), 1,
      sym_infix_b_op_3,
    STATE(199), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 4,
      anon_sym_COLON,
      anon_sym_then,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [35796] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(593), 1,
      anon_sym_PIPE,
    ACTIONS(619), 1,
      anon_sym_DASH_GT,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(595), 2,
      sym_interpolation_end,
      anon_sym_COLON,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [35871] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    ACTIONS(619), 1,
      anon_sym_DASH_GT,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(587), 2,
      sym_interpolation_end,
      anon_sym_COLON,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [35946] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(593), 1,
      anon_sym_PIPE,
    ACTIONS(613), 1,
      anon_sym_DASH_GT,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(595), 2,
      anon_sym_COLON,
      anon_sym_in,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [36021] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 10,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36080] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 10,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36137] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 10,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36194] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 13,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36249] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 13,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36304] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 15,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36357] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 15,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36410] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(589), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 10,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36469] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(593), 1,
      anon_sym_PIPE,
    ACTIONS(601), 1,
      anon_sym_DASH_GT,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(595), 2,
      ts_builtin_sym_end,
      anon_sym_COLON,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [36544] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    ACTIONS(613), 1,
      anon_sym_DASH_GT,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(587), 2,
      anon_sym_COLON,
      anon_sym_in,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [36619] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 15,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36672] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 13,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36727] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 10,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36784] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 10,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36843] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 9,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36906] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 7,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [36973] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 5,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37042] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(147), 1,
      sym_infix_lazy_b_op_9,
    STATE(154), 1,
      sym_infix_lazy_b_op_10,
    STATE(155), 1,
      sym_infix_b_op_8,
    STATE(165), 1,
      sym_infix_b_op_7,
    STATE(166), 1,
      sym_infix_b_op_6,
    STATE(167), 1,
      sym_infix_b_op_4,
    STATE(168), 1,
      sym_infix_b_op_3,
    STATE(169), 1,
      sym_infix_b_op_2,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 4,
      ts_builtin_sym_end,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37113] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(589), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 15,
      anon_sym_COLON,
      anon_sym_else,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37166] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(589), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 10,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37225] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(581), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(593), 1,
      anon_sym_PIPE,
    ACTIONS(625), 1,
      anon_sym_DASH_GT,
    STATE(201), 1,
      sym_infix_b_op_2,
    STATE(203), 1,
      sym_infix_b_op_3,
    STATE(204), 1,
      sym_infix_b_op_4,
    STATE(206), 1,
      sym_infix_b_op_6,
    STATE(207), 1,
      sym_infix_b_op_7,
    STATE(208), 1,
      sym_infix_b_op_8,
    STATE(210), 1,
      sym_infix_lazy_b_op_9,
    STATE(211), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(595), 2,
      anon_sym_COLON,
      anon_sym_else,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
  [37300] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(182), 1,
      sym_infix_b_op_2,
    STATE(183), 1,
      sym_infix_b_op_3,
    STATE(184), 1,
      sym_infix_b_op_4,
    STATE(185), 1,
      sym_infix_b_op_6,
    STATE(186), 1,
      sym_infix_b_op_7,
    STATE(187), 1,
      sym_infix_b_op_8,
    STATE(188), 1,
      sym_infix_lazy_b_op_9,
    STATE(189), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(589), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(591), 15,
      anon_sym_COLON,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37353] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 15,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_AT,
      anon_sym_PERCENT,
      anon_sym_PLUS_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37406] = 12,
    ACTIONS(3), 1,
      sym_comment,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 13,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37461] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(579), 1,
      anon_sym_AMP_AMP,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 4,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37532] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(577), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 5,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37601] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    ACTIONS(585), 1,
      anon_sym_PIPE,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(573), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(587), 7,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37668] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 1,
      anon_sym_AMP,
    ACTIONS(571), 1,
      anon_sym_PIPE_GT,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 9,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37731] = 14,
    ACTIONS(3), 1,
      sym_comment,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(567), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 10,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37790] = 13,
    ACTIONS(3), 1,
      sym_comment,
    STATE(152), 1,
      sym_infix_b_op_2,
    STATE(153), 1,
      sym_infix_b_op_3,
    STATE(170), 1,
      sym_infix_b_op_4,
    STATE(172), 1,
      sym_infix_b_op_6,
    STATE(173), 1,
      sym_infix_b_op_7,
    STATE(175), 1,
      sym_infix_b_op_8,
    STATE(176), 1,
      sym_infix_lazy_b_op_9,
    STATE(177), 1,
      sym_infix_lazy_b_op_10,
    ACTIONS(563), 2,
      anon_sym_AT,
      anon_sym_PLUS_PLUS,
    ACTIONS(565), 3,
      anon_sym_PERCENT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(585), 6,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 10,
      sym_interpolation_end,
      anon_sym_COLON,
      anon_sym_PIPE_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DASH_GT,
  [37847] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(629), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [37883] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(633), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [37919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(635), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(637), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [37955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(641), 17,
      sym_ident,
      anon_sym_let,
      anon_sym_fun,
      anon_sym_match,
      anon_sym_if,
      anon_sym_forall,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [37991] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(643), 12,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(645), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [38024] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(647), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [38056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(651), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [38088] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(655), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [38120] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(659), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [38152] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(663), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [38184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(667), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [38216] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(669), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(671), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [38248] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 11,
      sym_multstr_start,
      sym__str_start,
      sym_quoted_enum_tag_start,
      sym_num_literal,
      sym_raw_enum_tag,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_LBRACK_PIPE,
    ACTIONS(675), 13,
      sym_ident,
      anon_sym_match,
      anon_sym_import,
      anon_sym_Array,
      anon_sym_Dyn,
      anon_sym_null,
      anon_sym_LBRACK,
      anon_sym_true,
      anon_sym_false,
      anon_sym__,
      anon_sym_Number,
      anon_sym_Bool,
      anon_sym_String,
  [38280] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(679), 1,
      anon_sym_RBRACE,
    ACTIONS(681), 1,
      anon_sym_SEMI,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(685), 1,
      anon_sym__,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    STATE(551), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(869), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38327] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(691), 1,
      anon_sym_RBRACE,
    ACTIONS(693), 1,
      anon_sym_SEMI,
    ACTIONS(695), 1,
      anon_sym__,
    STATE(552), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(854), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38374] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(697), 1,
      anon_sym_RBRACE,
    ACTIONS(699), 1,
      anon_sym_SEMI,
    ACTIONS(701), 1,
      anon_sym__,
    STATE(556), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(863), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38421] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(703), 1,
      anon_sym_RBRACE,
    ACTIONS(705), 1,
      anon_sym_SEMI,
    ACTIONS(707), 1,
      anon_sym__,
    STATE(555), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(885), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38468] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(709), 1,
      anon_sym_RBRACE,
    ACTIONS(711), 1,
      anon_sym_SEMI,
    ACTIONS(713), 1,
      anon_sym__,
    STATE(553), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(873), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38515] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(715), 1,
      anon_sym_RBRACE,
    ACTIONS(717), 1,
      anon_sym_SEMI,
    ACTIONS(719), 1,
      anon_sym__,
    STATE(554), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(888), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38562] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(721), 1,
      anon_sym_RBRACE,
    ACTIONS(723), 1,
      anon_sym_SEMI,
    STATE(562), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(864), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38606] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(725), 1,
      anon_sym_RBRACE,
    ACTIONS(727), 1,
      anon_sym_SEMI,
    STATE(562), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(870), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38650] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(729), 1,
      anon_sym_RBRACE,
    ACTIONS(731), 1,
      anon_sym_SEMI,
    STATE(562), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(862), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38694] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(733), 1,
      anon_sym_RBRACE,
    ACTIONS(735), 1,
      anon_sym_SEMI,
    STATE(562), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(852), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38738] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(737), 1,
      anon_sym_RBRACE,
    ACTIONS(739), 1,
      anon_sym_SEMI,
    STATE(562), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(858), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38782] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(683), 1,
      anon_sym_DOT_DOT,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    ACTIONS(741), 1,
      anon_sym_RBRACE,
    ACTIONS(743), 1,
      anon_sym_SEMI,
    STATE(562), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(774), 1,
      sym_record_field,
    STATE(874), 1,
      sym_record_last_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [38826] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 13,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [38845] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 13,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [38864] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 13,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [38883] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 13,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [38902] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 13,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [38921] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(753), 1,
      sym_ident,
    ACTIONS(758), 1,
      sym_multstr_start,
    ACTIONS(761), 1,
      sym__str_start,
    STATE(562), 1,
      aux_sym_uni_record_repeat1,
    STATE(592), 1,
      sym_field_path,
    STATE(610), 1,
      sym_field_path_elem,
    STATE(651), 1,
      sym_str_chunks,
    STATE(1037), 1,
      sym_record_field,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
    ACTIONS(756), 3,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_DOT_DOT,
  [38958] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 13,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [38977] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 13,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [38996] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 13,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [39015] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 13,
      ts_builtin_sym_end,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [39034] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    STATE(568), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(770), 7,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [39057] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_PIPE,
    ACTIONS(775), 1,
      anon_sym_COLON,
    STATE(568), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(778), 7,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_QMARK,
  [39080] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(784), 1,
      sym_multstr_end,
    ACTIONS(786), 1,
      sym_interpolation_start,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(578), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39106] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(788), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(574), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39132] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(790), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(583), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39158] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(792), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(574), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39184] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    ACTIONS(794), 1,
      anon_sym_EQ,
    ACTIONS(798), 1,
      anon_sym_QMARK,
    STATE(721), 1,
      sym_annot,
    STATE(772), 1,
      sym_default_annot,
    ACTIONS(796), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    STATE(567), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [39214] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 1,
      anon_sym_PERCENT,
    ACTIONS(806), 1,
      sym_multstr_end,
    ACTIONS(808), 1,
      sym_interpolation_start,
    STATE(714), 1,
      sym_percent,
    ACTIONS(803), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(574), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39240] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(811), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(584), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39266] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(813), 10,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [39282] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 10,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [39298] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(817), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(574), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39324] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 10,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [39340] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 10,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [39356] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(821), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(572), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39382] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(823), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(574), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39408] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(825), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(574), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39434] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(827), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(574), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39460] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(829), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(588), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39486] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(831), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(570), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39512] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 10,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [39528] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(835), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(574), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39554] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_PERCENT,
    ACTIONS(786), 1,
      sym_interpolation_start,
    ACTIONS(837), 1,
      sym_multstr_end,
    STATE(714), 1,
      sym_percent,
    ACTIONS(782), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
    STATE(582), 3,
      sym_chunk_expr,
      sym_chunk_literal_multi,
      aux_sym_str_chunks_multi_repeat1,
  [39580] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 10,
      ts_builtin_sym_end,
      anon_sym_EQ,
      anon_sym_in,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_then,
      anon_sym_else,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [39596] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(847), 1,
      sym__str_end,
    ACTIONS(849), 1,
      sym_interpolation_start,
    STATE(737), 1,
      sym_percent,
    STATE(600), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39623] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    ACTIONS(851), 1,
      anon_sym_EQ,
    STATE(754), 1,
      sym_annot,
    STATE(567), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
    ACTIONS(853), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [39648] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(855), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(605), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39675] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(857), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(607), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39702] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(859), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(594), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39729] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(861), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(598), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39756] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(863), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(606), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39783] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(865), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(607), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39810] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(867), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(607), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39837] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(869), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(607), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39864] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(871), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(599), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39891] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(873), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(603), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39918] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(875), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(607), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39945] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(879), 1,
      anon_sym_EQ,
    ACTIONS(881), 1,
      anon_sym_AT,
    ACTIONS(877), 7,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [39964] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(883), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(607), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [39991] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(841), 1,
      anon_sym_PERCENT,
    ACTIONS(843), 1,
      sym_str_literal,
    ACTIONS(845), 1,
      sym_str_esc_char,
    ACTIONS(849), 1,
      sym_interpolation_start,
    ACTIONS(885), 1,
      sym__str_end,
    STATE(737), 1,
      sym_percent,
    STATE(607), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [40018] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(887), 1,
      anon_sym_PERCENT,
    ACTIONS(890), 1,
      sym_str_literal,
    ACTIONS(893), 1,
      sym_str_esc_char,
    ACTIONS(896), 1,
      sym__str_end,
    ACTIONS(898), 1,
      sym_interpolation_start,
    STATE(737), 1,
      sym_percent,
    STATE(607), 3,
      sym_chunk_expr,
      sym_chunk_literal_single,
      aux_sym_str_chunks_single_repeat1,
  [40045] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(905), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(614), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40067] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(907), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(614), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40089] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 1,
      anon_sym_DOT,
    STATE(625), 1,
      aux_sym_field_path_repeat1,
    ACTIONS(909), 6,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [40107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      anon_sym_EQ,
    ACTIONS(913), 7,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [40123] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(917), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(614), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40145] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(921), 1,
      anon_sym_COMMA,
    ACTIONS(923), 1,
      anon_sym_RBRACE,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(812), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [40173] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(929), 1,
      anon_sym_PERCENT,
    ACTIONS(935), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(614), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(932), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 1,
      anon_sym_EQ,
    ACTIONS(937), 7,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [40211] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(941), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(620), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40233] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(943), 1,
      anon_sym_COMMA,
    ACTIONS(945), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(779), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [40261] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(947), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(612), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40283] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(949), 1,
      anon_sym_COMMA,
    ACTIONS(951), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(795), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [40311] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(953), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(614), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40333] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(955), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(608), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40355] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(959), 1,
      anon_sym_EQ,
    ACTIONS(957), 7,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [40371] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(963), 1,
      anon_sym_EQ,
    ACTIONS(961), 7,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [40387] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(967), 1,
      anon_sym_DOT,
    STATE(624), 1,
      aux_sym_field_path_repeat1,
    ACTIONS(965), 6,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [40405] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(911), 1,
      anon_sym_DOT,
    STATE(624), 1,
      aux_sym_field_path_repeat1,
    ACTIONS(970), 6,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [40423] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(972), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(614), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40445] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(974), 1,
      anon_sym_COMMA,
    ACTIONS(976), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(799), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [40473] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(978), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(626), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40495] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(980), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(614), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40517] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(982), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(614), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40539] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(984), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(638), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40561] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(986), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(630), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40583] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 1,
      anon_sym_EQ,
    ACTIONS(988), 7,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [40599] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(992), 1,
      anon_sym_COMMA,
    ACTIONS(994), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(814), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [40627] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 1,
      anon_sym_EQ,
    ACTIONS(996), 7,
      sym_ident,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ_GT,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [40643] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(1000), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(629), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40665] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1002), 1,
      anon_sym_COMMA,
    ACTIONS(1004), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(811), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [40693] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(1006), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(614), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40715] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 1,
      anon_sym_PERCENT,
    ACTIONS(1008), 1,
      sym_multstr_end,
    STATE(739), 1,
      sym_percent,
    STATE(609), 2,
      sym_chunk_literal_multi,
      aux_sym_static_string_repeat2,
    ACTIONS(903), 3,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [40737] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1016), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(655), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [40760] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(978), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(675), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [40783] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1018), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [40808] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1020), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(677), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [40831] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1022), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [40856] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [40879] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1024), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [40904] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1026), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(648), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [40927] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1028), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [40950] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(955), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(671), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [40973] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(657), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [40996] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1030), 7,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_SEMI,
  [41009] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 7,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_SEMI,
  [41022] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(645), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41045] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(395), 7,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_SEMI,
  [41058] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1032), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41081] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1034), 1,
      anon_sym_PERCENT,
    ACTIONS(1037), 1,
      sym_str_literal,
    ACTIONS(1040), 1,
      sym_str_esc_char,
    ACTIONS(1043), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41104] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41127] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1045), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41150] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1047), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [41175] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1049), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [41200] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(907), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41223] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1051), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [41248] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1053), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [41273] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1055), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [41298] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(661), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41321] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1057), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(674), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41344] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(485), 7,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_SEMI,
  [41357] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1059), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41380] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1061), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(682), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41403] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1063), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [41428] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(905), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41451] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1065), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [41476] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1067), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(668), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41499] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1069), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41522] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(972), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41545] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1071), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [41570] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1073), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41593] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1075), 1,
      anon_sym_RBRACE,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [41618] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(686), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41641] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      sym_ident,
    ACTIONS(687), 1,
      sym_multstr_start,
    ACTIONS(689), 1,
      sym__str_start,
    STATE(651), 1,
      sym_str_chunks,
    STATE(687), 1,
      sym_field_path_elem,
    STATE(685), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [41664] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 7,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_SEMI,
  [41677] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1077), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41700] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1006), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41723] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41746] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 7,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_SEMI,
  [41759] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(980), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(656), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41782] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 7,
      anon_sym_PIPE,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_SEMI,
  [41795] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(684), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41818] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    ACTIONS(1079), 1,
      sym__str_end,
    STATE(746), 1,
      sym_percent,
    STATE(658), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41841] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 1,
      sym__str_end,
    ACTIONS(1010), 1,
      anon_sym_PERCENT,
    ACTIONS(1012), 1,
      sym_str_literal,
    ACTIONS(1014), 1,
      sym_str_esc_char,
    STATE(746), 1,
      sym_percent,
    STATE(683), 2,
      sym_chunk_literal_single,
      aux_sym_static_string_repeat1,
  [41864] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1081), 1,
      sym_ident,
    ACTIONS(1083), 1,
      anon_sym_RBRACE,
    ACTIONS(1085), 1,
      anon_sym_DOT_DOT,
    STATE(702), 1,
      aux_sym_destruct_repeat1,
    STATE(855), 1,
      sym_match,
    STATE(929), 1,
      sym_last_match,
  [41886] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(207), 1,
      sym_multstr_start,
    ACTIONS(209), 1,
      sym__str_start,
    ACTIONS(1087), 1,
      sym_ident,
    STATE(305), 1,
      sym_str_chunks,
    STATE(259), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [41906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1091), 2,
      sym_multstr_end,
      sym_interpolation_start,
    ACTIONS(1089), 4,
      anon_sym_PERCENT,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [41920] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1095), 1,
      anon_sym_EQ_GT,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(717), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [41940] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 1,
      sym_multstr_start,
    ACTIONS(335), 1,
      sym__str_start,
    ACTIONS(1099), 1,
      sym_ident,
    STATE(339), 1,
      sym_str_chunks,
    STATE(390), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [41960] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1101), 1,
      anon_sym_SEMI,
    ACTIONS(1103), 1,
      anon_sym_PIPE_RBRACK,
    STATE(747), 1,
      sym_enum_tag,
    STATE(763), 1,
      sym_quoted_enum_tag,
  [41982] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    ACTIONS(1105), 1,
      anon_sym_EQ_GT,
    STATE(623), 1,
      sym_destruct,
    STATE(717), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42002] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    ACTIONS(1107), 1,
      anon_sym_EQ_GT,
    STATE(623), 1,
      sym_destruct,
    STATE(717), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42022] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(109), 1,
      sym_multstr_start,
    ACTIONS(111), 1,
      sym__str_start,
    ACTIONS(1109), 1,
      sym_ident,
    STATE(97), 1,
      sym_str_chunks,
    STATE(115), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [42042] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(925), 1,
      anon_sym__,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(883), 1,
      sym_match_case,
    STATE(907), 1,
      sym_enum_tag,
  [42064] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      sym_multstr_start,
    ACTIONS(47), 1,
      sym__str_start,
    ACTIONS(1111), 1,
      sym_ident,
    STATE(405), 1,
      sym_str_chunks,
    STATE(246), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [42084] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1081), 1,
      sym_ident,
    ACTIONS(1085), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1113), 1,
      anon_sym_RBRACE,
    STATE(723), 1,
      aux_sym_destruct_repeat1,
    STATE(855), 1,
      sym_match,
    STATE(992), 1,
      sym_last_match,
  [42106] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 6,
      sym_multstr_start,
      sym__str_start,
      sym_ident,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_DOT_DOT,
  [42118] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(291), 1,
      sym_multstr_start,
    ACTIONS(293), 1,
      sym__str_start,
    ACTIONS(1115), 1,
      sym_ident,
    STATE(393), 1,
      sym_str_chunks,
    STATE(347), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [42138] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1117), 1,
      anon_sym_SEMI,
    ACTIONS(1119), 1,
      anon_sym_PIPE_RBRACK,
    STATE(755), 1,
      sym_enum_tag,
    STATE(763), 1,
      sym_quoted_enum_tag,
  [42160] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 2,
      sym_multstr_end,
      sym_interpolation_start,
    ACTIONS(1121), 4,
      anon_sym_PERCENT,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [42174] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    ACTIONS(1125), 1,
      anon_sym_EQ_GT,
    STATE(623), 1,
      sym_destruct,
    STATE(717), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42194] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1127), 1,
      anon_sym_SEMI,
    ACTIONS(1129), 1,
      anon_sym_PIPE_RBRACK,
    STATE(756), 1,
      sym_enum_tag,
    STATE(763), 1,
      sym_quoted_enum_tag,
  [42216] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1131), 1,
      anon_sym_SEMI,
    ACTIONS(1133), 1,
      anon_sym_PIPE_RBRACK,
    STATE(762), 1,
      sym_enum_tag,
    STATE(763), 1,
      sym_quoted_enum_tag,
  [42238] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1135), 1,
      anon_sym_SEMI,
    ACTIONS(1137), 1,
      anon_sym_PIPE_RBRACK,
    STATE(751), 1,
      sym_enum_tag,
    STATE(763), 1,
      sym_quoted_enum_tag,
  [42260] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      anon_sym_EQ_GT,
    STATE(623), 1,
      sym_destruct,
    STATE(717), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42280] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    ACTIONS(1141), 1,
      anon_sym_EQ_GT,
    STATE(623), 1,
      sym_destruct,
    STATE(717), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42300] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    ACTIONS(1143), 1,
      anon_sym_EQ,
    STATE(915), 1,
      sym_annot,
    STATE(567), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42320] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1147), 2,
      sym_multstr_end,
      sym_interpolation_start,
    ACTIONS(1145), 4,
      anon_sym_PERCENT,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [42334] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    ACTIONS(1149), 1,
      anon_sym_SEMI,
    ACTIONS(1151), 1,
      anon_sym_PIPE_RBRACK,
    STATE(748), 1,
      sym_enum_tag,
    STATE(763), 1,
      sym_quoted_enum_tag,
  [42356] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(768), 1,
      anon_sym_PIPE,
    ACTIONS(1153), 1,
      anon_sym_EQ,
    STATE(923), 1,
      sym_annot,
    STATE(567), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42376] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1155), 1,
      sym_ident,
    ACTIONS(1158), 1,
      anon_sym_EQ_GT,
    ACTIONS(1160), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(717), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42396] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 1,
      sym_multstr_start,
    ACTIONS(251), 1,
      sym__str_start,
    ACTIONS(1163), 1,
      sym_ident,
    STATE(215), 1,
      sym_str_chunks,
    STATE(282), 2,
      sym_str_chunks_single,
      sym_str_chunks_multi,
  [42416] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(712), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42433] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 1,
      sym_interpolation_end,
    ACTIONS(1165), 1,
      anon_sym_PIPE,
    ACTIONS(1168), 1,
      anon_sym_COLON,
    STATE(720), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42450] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 1,
      anon_sym_QMARK,
    ACTIONS(1171), 1,
      anon_sym_EQ,
    STATE(844), 1,
      sym_default_annot,
    ACTIONS(1173), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [42467] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 1,
      anon_sym_COLON,
    ACTIONS(770), 1,
      anon_sym_in,
    ACTIONS(1175), 1,
      anon_sym_PIPE,
    STATE(724), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42484] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1177), 1,
      sym_ident,
    STATE(723), 1,
      aux_sym_destruct_repeat1,
    STATE(1021), 1,
      sym_match,
    ACTIONS(1180), 2,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT,
  [42501] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 1,
      anon_sym_in,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1185), 1,
      anon_sym_COLON,
    STATE(724), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42518] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(605), 1,
      anon_sym_COLON,
    ACTIONS(770), 1,
      anon_sym_then,
    ACTIONS(1188), 1,
      anon_sym_PIPE,
    STATE(733), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42535] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      anon_sym_COLON,
    ACTIONS(770), 1,
      anon_sym_else,
    ACTIONS(1190), 1,
      anon_sym_PIPE,
    STATE(729), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42552] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    ACTIONS(1192), 1,
      sym_ident,
    ACTIONS(1194), 1,
      anon_sym_rec,
    STATE(623), 1,
      sym_destruct,
    STATE(716), 1,
      sym_pattern,
  [42571] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 1,
      ts_builtin_sym_end,
    ACTIONS(1196), 1,
      anon_sym_PIPE,
    ACTIONS(1199), 1,
      anon_sym_COLON,
    STATE(728), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42588] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 1,
      anon_sym_else,
    ACTIONS(1202), 1,
      anon_sym_PIPE,
    ACTIONS(1205), 1,
      anon_sym_COLON,
    STATE(729), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42605] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(694), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42622] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1089), 2,
      anon_sym_PERCENT,
      sym_str_esc_char,
    ACTIONS(1091), 3,
      sym__str_end,
      sym_interpolation_start,
      sym_str_literal,
  [42635] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(707), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42652] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 1,
      anon_sym_then,
    ACTIONS(1208), 1,
      anon_sym_PIPE,
    ACTIONS(1211), 1,
      anon_sym_COLON,
    STATE(733), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42669] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(711), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42686] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1123), 1,
      sym_multstr_end,
    ACTIONS(1121), 4,
      anon_sym_PERCENT,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [42699] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 1,
      anon_sym_COLON,
    ACTIONS(770), 1,
      sym_interpolation_end,
    ACTIONS(1214), 1,
      anon_sym_PIPE,
    STATE(720), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 2,
      anon_sym_PERCENT,
      sym_str_esc_char,
    ACTIONS(1218), 3,
      sym__str_end,
      sym_interpolation_start,
      sym_str_literal,
  [42729] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(698), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42746] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1147), 1,
      sym_multstr_end,
    ACTIONS(1145), 4,
      anon_sym_PERCENT,
      sym_double_quote,
      sym_mult_str_literal,
      sym_str_esc_char,
  [42759] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(599), 1,
      anon_sym_COLON,
    ACTIONS(770), 1,
      ts_builtin_sym_end,
    ACTIONS(1220), 1,
      anon_sym_PIPE,
    STATE(728), 2,
      sym_annot_atom,
      aux_sym_annot_repeat1,
  [42776] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(697), 2,
      sym_pattern,
      aux_sym_fun_expr_repeat1,
  [42793] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1121), 2,
      anon_sym_PERCENT,
      sym_str_esc_char,
    ACTIONS(1123), 3,
      sym__str_end,
      sym_interpolation_start,
      sym_str_literal,
  [42806] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(713), 1,
      sym_pattern,
  [42822] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(878), 1,
      sym_pattern,
  [42838] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 4,
      anon_sym_EQ_GT,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_PIPE_RBRACK,
  [42848] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1216), 2,
      anon_sym_PERCENT,
      sym_str_esc_char,
    ACTIONS(1218), 2,
      sym__str_end,
      sym_str_literal,
  [42860] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1224), 1,
      anon_sym_SEMI,
    ACTIONS(1226), 1,
      anon_sym_PIPE_RBRACK,
    STATE(758), 1,
      aux_sym_type_atom_repeat1,
  [42876] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1228), 1,
      anon_sym_SEMI,
    ACTIONS(1230), 1,
      anon_sym_PIPE_RBRACK,
    STATE(760), 1,
      aux_sym_type_atom_repeat1,
  [42892] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1232), 1,
      anon_sym_SEMI,
    ACTIONS(1234), 1,
      anon_sym_PIPE_RBRACK,
    STATE(764), 1,
      aux_sym_type_atom_repeat1,
  [42908] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1236), 1,
      anon_sym_SEMI,
    ACTIONS(1238), 1,
      anon_sym_PIPE_RBRACK,
    STATE(764), 1,
      aux_sym_type_atom_repeat1,
  [42924] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1240), 1,
      anon_sym_SEMI,
    ACTIONS(1242), 1,
      anon_sym_PIPE_RBRACK,
    STATE(749), 1,
      aux_sym_type_atom_repeat1,
  [42940] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1121), 2,
      anon_sym_PERCENT,
      sym_str_esc_char,
    ACTIONS(1123), 2,
      sym__str_end,
      sym_str_literal,
  [42952] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 4,
      anon_sym_EQ_GT,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_PIPE_RBRACK,
  [42962] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1244), 1,
      anon_sym_EQ,
    ACTIONS(1246), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [42974] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1248), 1,
      anon_sym_SEMI,
    ACTIONS(1250), 1,
      anon_sym_PIPE_RBRACK,
    STATE(750), 1,
      aux_sym_type_atom_repeat1,
  [42990] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1252), 1,
      anon_sym_SEMI,
    ACTIONS(1254), 1,
      anon_sym_PIPE_RBRACK,
    STATE(766), 1,
      aux_sym_type_atom_repeat1,
  [43006] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1256), 1,
      anon_sym_SEMI,
    ACTIONS(1258), 1,
      anon_sym_PIPE_RBRACK,
    STATE(764), 1,
      aux_sym_type_atom_repeat1,
  [43022] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1260), 1,
      anon_sym_SEMI,
    ACTIONS(1262), 1,
      anon_sym_PIPE_RBRACK,
    STATE(764), 1,
      aux_sym_type_atom_repeat1,
  [43038] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(880), 1,
      sym_pattern,
  [43054] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1264), 1,
      anon_sym_SEMI,
    ACTIONS(1266), 1,
      anon_sym_PIPE_RBRACK,
    STATE(764), 1,
      aux_sym_type_atom_repeat1,
  [43070] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      sym_raw_enum_tag,
    ACTIONS(927), 1,
      sym_quoted_enum_tag_start,
    STATE(763), 1,
      sym_quoted_enum_tag,
    STATE(823), 1,
      sym_enum_tag,
  [43086] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1268), 1,
      anon_sym_SEMI,
    ACTIONS(1270), 1,
      anon_sym_PIPE_RBRACK,
    STATE(757), 1,
      aux_sym_type_atom_repeat1,
  [43102] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(387), 4,
      anon_sym_EQ_GT,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_PIPE_RBRACK,
  [43112] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      anon_sym_COMMA,
    STATE(764), 1,
      aux_sym_type_atom_repeat1,
    ACTIONS(1275), 2,
      anon_sym_SEMI,
      anon_sym_PIPE_RBRACK,
  [43126] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(859), 1,
      sym_pattern,
  [43142] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1222), 1,
      anon_sym_COMMA,
    ACTIONS(1277), 1,
      anon_sym_SEMI,
    ACTIONS(1279), 1,
      anon_sym_PIPE_RBRACK,
    STATE(764), 1,
      aux_sym_type_atom_repeat1,
  [43158] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1093), 1,
      sym_ident,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(623), 1,
      sym_destruct,
    STATE(882), 1,
      sym_pattern,
  [43174] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_RBRACE,
    ACTIONS(1281), 1,
      anon_sym_COMMA,
    STATE(833), 1,
      aux_sym_match_expr_repeat1,
  [43187] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 3,
      sym_interpolation_end,
      anon_sym_PIPE,
      anon_sym_COLON,
  [43196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(894), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43207] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1285), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [43216] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1287), 1,
      anon_sym_EQ,
    ACTIONS(1289), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [43227] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 1,
      anon_sym_RBRACE,
    ACTIONS(1291), 1,
      anon_sym_COMMA,
    STATE(833), 1,
      aux_sym_match_expr_repeat1,
  [43240] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 1,
      anon_sym_COMMA,
    ACTIONS(1295), 2,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [43251] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      sym_ident,
    ACTIONS(1299), 1,
      anon_sym_DOT,
    STATE(847), 1,
      aux_sym_forall_repeat1,
  [43264] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1075), 1,
      anon_sym_RBRACE,
    ACTIONS(1301), 1,
      anon_sym_COMMA,
    STATE(833), 1,
      aux_sym_match_expr_repeat1,
  [43277] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1303), 1,
      sym_multstr_start,
    ACTIONS(1305), 1,
      sym__str_start,
    STATE(419), 1,
      sym_static_string,
  [43290] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1307), 1,
      anon_sym_COMMA,
    ACTIONS(1309), 1,
      anon_sym_RBRACK,
    STATE(839), 1,
      aux_sym_atom_repeat1,
  [43303] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1311), 1,
      anon_sym_COMMA,
    ACTIONS(1313), 1,
      anon_sym_RBRACE,
    STATE(827), 1,
      aux_sym_match_expr_repeat1,
  [43316] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(938), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43327] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 3,
      sym_interpolation_end,
      anon_sym_PIPE,
      anon_sym_COLON,
  [43336] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 3,
      sym_interpolation_end,
      anon_sym_PIPE,
      anon_sym_COLON,
  [43345] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(747), 3,
      sym_interpolation_end,
      anon_sym_PIPE,
      anon_sym_COLON,
  [43354] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      sym_multstr_start,
    ACTIONS(1317), 1,
      sym__str_start,
    STATE(559), 1,
      sym_static_string,
  [43367] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 1,
      anon_sym_RBRACK,
    ACTIONS(1319), 1,
      anon_sym_COMMA,
    STATE(819), 1,
      aux_sym_atom_repeat1,
  [43380] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1321), 1,
      sym_multstr_start,
    ACTIONS(1323), 1,
      sym__str_start,
    STATE(432), 1,
      sym_static_string,
  [43393] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(151), 1,
      anon_sym_RBRACK,
    ACTIONS(1325), 1,
      anon_sym_COMMA,
    STATE(819), 1,
      aux_sym_atom_repeat1,
  [43406] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(933), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43417] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1327), 1,
      sym_multstr_start,
    ACTIONS(1329), 1,
      sym__str_start,
    STATE(414), 1,
      sym_static_string,
  [43430] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(595), 3,
      sym_interpolation_end,
      anon_sym_PIPE,
      anon_sym_COLON,
  [43439] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(932), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43450] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 3,
      sym_interpolation_end,
      anon_sym_PIPE,
      anon_sym_COLON,
  [43459] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 3,
      sym_interpolation_end,
      anon_sym_PIPE,
      anon_sym_COLON,
  [43468] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(921), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43479] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1331), 1,
      anon_sym_COMMA,
    ACTIONS(1333), 1,
      anon_sym_RBRACE,
    STATE(773), 1,
      aux_sym_match_expr_repeat1,
  [43492] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(941), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43503] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      sym_ident,
    ACTIONS(1335), 1,
      anon_sym_DOT,
    STATE(847), 1,
      aux_sym_forall_repeat1,
  [43516] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1337), 1,
      anon_sym_COMMA,
    ACTIONS(1339), 1,
      anon_sym_RBRACK,
    STATE(838), 1,
      aux_sym_atom_repeat1,
  [43529] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 1,
      anon_sym_COMMA,
    ACTIONS(1343), 1,
      anon_sym_RBRACE,
    STATE(776), 1,
      aux_sym_match_expr_repeat1,
  [43542] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      sym_ident,
    ACTIONS(1345), 1,
      anon_sym_DOT,
    STATE(847), 1,
      aux_sym_forall_repeat1,
  [43555] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(896), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43566] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1347), 1,
      anon_sym_COMMA,
    ACTIONS(1349), 1,
      anon_sym_RBRACK,
    STATE(785), 1,
      aux_sym_atom_repeat1,
  [43579] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 3,
      sym_interpolation_end,
      anon_sym_PIPE,
      anon_sym_COLON,
  [43588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(892), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43599] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1351), 1,
      anon_sym_COMMA,
    ACTIONS(1353), 1,
      anon_sym_RBRACK,
    STATE(818), 1,
      aux_sym_atom_repeat1,
  [43612] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(891), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43623] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      sym_multstr_start,
    ACTIONS(1357), 1,
      sym__str_start,
    STATE(422), 1,
      sym_static_string,
  [43636] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(917), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43647] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      sym_ident,
    ACTIONS(1359), 1,
      anon_sym_DOT,
    STATE(847), 1,
      aux_sym_forall_repeat1,
  [43660] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(529), 3,
      sym_interpolation_end,
      anon_sym_PIPE,
      anon_sym_COLON,
  [43669] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1361), 1,
      anon_sym_COMMA,
    ACTIONS(1363), 1,
      anon_sym_RBRACE,
    STATE(846), 1,
      aux_sym_match_expr_repeat1,
  [43682] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1365), 1,
      anon_sym_COMMA,
    ACTIONS(1367), 1,
      anon_sym_RBRACE,
    STATE(830), 1,
      aux_sym_match_expr_repeat1,
  [43695] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(899), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43706] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1369), 1,
      anon_sym_COMMA,
    ACTIONS(1371), 1,
      anon_sym_RBRACE,
    STATE(768), 1,
      aux_sym_match_expr_repeat1,
  [43719] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [43728] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(960), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43739] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1180), 3,
      sym_ident,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT,
  [43748] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(153), 1,
      anon_sym_RBRACK,
    ACTIONS(1375), 1,
      anon_sym_COMMA,
    STATE(819), 1,
      aux_sym_atom_repeat1,
  [43761] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1377), 1,
      anon_sym_COMMA,
    ACTIONS(1380), 1,
      anon_sym_RBRACK,
    STATE(819), 1,
      aux_sym_atom_repeat1,
  [43774] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(974), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43785] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1382), 1,
      sym_multstr_start,
    ACTIONS(1384), 1,
      sym__str_start,
    STATE(141), 1,
      sym_static_string,
  [43798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(977), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43809] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1275), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_PIPE_RBRACK,
  [43818] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(999), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43829] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(157), 1,
      anon_sym_RBRACK,
    ACTIONS(1386), 1,
      anon_sym_COMMA,
    STATE(819), 1,
      aux_sym_atom_repeat1,
  [43842] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1388), 1,
      anon_sym_COMMA,
    ACTIONS(1390), 1,
      anon_sym_RBRACK,
    STATE(787), 1,
      aux_sym_atom_repeat1,
  [43855] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1049), 1,
      anon_sym_RBRACE,
    ACTIONS(1392), 1,
      anon_sym_COMMA,
    STATE(833), 1,
      aux_sym_match_expr_repeat1,
  [43868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(1027), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(1033), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43890] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      anon_sym_RBRACE,
    ACTIONS(1394), 1,
      anon_sym_COMMA,
    STATE(833), 1,
      aux_sym_match_expr_repeat1,
  [43903] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(1035), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(1020), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43925] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1396), 1,
      anon_sym_COMMA,
    ACTIONS(1399), 1,
      anon_sym_RBRACE,
    STATE(833), 1,
      aux_sym_match_expr_repeat1,
  [43938] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(963), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(948), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43960] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(944), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(922), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [43982] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 1,
      anon_sym_RBRACK,
    ACTIONS(1401), 1,
      anon_sym_COMMA,
    STATE(819), 1,
      aux_sym_atom_repeat1,
  [43995] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(161), 1,
      anon_sym_RBRACK,
    ACTIONS(1403), 1,
      anon_sym_COMMA,
    STATE(819), 1,
      aux_sym_atom_repeat1,
  [44008] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      sym_ident,
    ACTIONS(1405), 1,
      anon_sym_DOT,
    STATE(847), 1,
      aux_sym_forall_repeat1,
  [44021] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1297), 1,
      sym_ident,
    ACTIONS(1407), 1,
      anon_sym_DOT,
    STATE(847), 1,
      aux_sym_forall_repeat1,
  [44034] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1409), 3,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [44043] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1411), 1,
      anon_sym_COMMA,
    ACTIONS(1413), 1,
      anon_sym_RBRACK,
    STATE(825), 1,
      aux_sym_atom_repeat1,
  [44056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1415), 1,
      anon_sym_EQ,
    ACTIONS(1417), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [44067] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1419), 1,
      sym_multstr_start,
    ACTIONS(1421), 1,
      sym__str_start,
    STATE(408), 1,
      sym_static_string,
  [44080] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1063), 1,
      anon_sym_RBRACE,
    ACTIONS(1423), 1,
      anon_sym_COMMA,
    STATE(833), 1,
      aux_sym_match_expr_repeat1,
  [44093] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1425), 1,
      sym_ident,
    ACTIONS(1428), 1,
      anon_sym_DOT,
    STATE(847), 1,
      aux_sym_forall_repeat1,
  [44106] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1430), 1,
      sym_multstr_start,
    ACTIONS(1432), 1,
      sym__str_start,
    STATE(782), 1,
      sym_static_string,
  [44119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(925), 1,
      sym_row_tail,
    ACTIONS(1283), 2,
      sym_ident,
      anon_sym_Dyn,
  [44130] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      anon_sym_LBRACE,
    STATE(611), 1,
      sym_destruct,
  [44140] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1434), 2,
      anon_sym_default,
      anon_sym_force,
  [44148] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1436), 1,
      anon_sym_RBRACE,
    ACTIONS(1438), 1,
      anon_sym_SEMI,
  [44158] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1440), 1,
      sym_ident,
    ACTIONS(1442), 1,
      anon_sym_RBRACE,
  [44168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1444), 1,
      anon_sym_RBRACE,
    ACTIONS(1446), 1,
      anon_sym_SEMI,
  [44178] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1442), 1,
      anon_sym_RBRACE,
    ACTIONS(1448), 1,
      anon_sym_COMMA,
  [44188] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 1,
      anon_sym_RPAREN,
    ACTIONS(1450), 1,
      sym_ident,
  [44198] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1452), 1,
      sym_ident,
    STATE(775), 1,
      aux_sym_forall_repeat1,
  [44208] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1454), 1,
      anon_sym_RBRACE,
    ACTIONS(1456), 1,
      anon_sym_SEMI,
  [44218] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1458), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [44226] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1460), 1,
      sym_ident,
    STATE(809), 1,
      aux_sym_forall_repeat1,
  [44236] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1462), 1,
      sym_ident,
    STATE(800), 1,
      aux_sym_forall_repeat1,
  [44246] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_RBRACE,
    ACTIONS(1466), 1,
      anon_sym_SEMI,
  [44256] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1468), 1,
      anon_sym_RBRACE,
    ACTIONS(1470), 1,
      anon_sym_SEMI,
  [44266] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1472), 1,
      anon_sym_RBRACE,
    ACTIONS(1474), 1,
      anon_sym_SEMI,
  [44276] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1476), 1,
      sym_ident,
    STATE(840), 1,
      aux_sym_forall_repeat1,
  [44286] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1380), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [44294] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1478), 1,
      sym_ident,
    STATE(841), 1,
      aux_sym_forall_repeat1,
  [44304] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1480), 2,
      anon_sym_default,
      anon_sym_force,
  [44312] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1482), 1,
      anon_sym_RBRACE,
    ACTIONS(1484), 1,
      anon_sym_SEMI,
  [44322] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1486), 1,
      anon_sym_RBRACE,
    ACTIONS(1488), 1,
      anon_sym_SEMI,
  [44332] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1490), 1,
      sym_ident,
    STATE(797), 1,
      aux_sym_forall_repeat1,
  [44342] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 2,
      anon_sym_RBRACE,
      anon_sym_SEMI,
  [44350] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1492), 1,
      anon_sym_RBRACE,
    ACTIONS(1494), 1,
      anon_sym_SEMI,
  [44360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1496), 1,
      anon_sym_RBRACE,
    ACTIONS(1498), 1,
      anon_sym_SEMI,
  [44370] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1500), 2,
      anon_sym_PIPE,
      anon_sym_COLON,
  [44378] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1502), 2,
      anon_sym_PIPE,
      anon_sym_COLON,
  [44386] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1504), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [44394] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1506), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [44402] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1508), 2,
      anon_sym_PIPE,
      anon_sym_COLON,
  [44410] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1510), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [44418] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1512), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [44426] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1514), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [44434] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1399), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [44442] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1516), 2,
      anon_sym_PIPE,
      anon_sym_COLON,
  [44450] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1518), 1,
      anon_sym_RBRACE,
    ACTIONS(1520), 1,
      anon_sym_SEMI,
  [44460] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1522), 2,
      anon_sym_PIPE,
      anon_sym_COLON,
  [44468] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1524), 2,
      anon_sym_PIPE,
      anon_sym_COLON,
  [44476] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1526), 1,
      anon_sym_RBRACE,
    ACTIONS(1528), 1,
      anon_sym_SEMI,
  [44486] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1530), 1,
      anon_sym_PIPE_RBRACK,
  [44493] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1532), 1,
      anon_sym_PIPE_RBRACK,
  [44500] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1534), 1,
      anon_sym_RBRACE,
  [44507] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1536), 1,
      anon_sym_RBRACE,
  [44514] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1538), 1,
      anon_sym_else,
  [44521] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1540), 1,
      anon_sym_RBRACE,
  [44528] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1542), 1,
      anon_sym_PIPE_RBRACK,
  [44535] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1544), 1,
      anon_sym_RBRACE,
  [44542] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1546), 1,
      anon_sym_PIPE_RBRACK,
  [44549] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1548), 1,
      sym_interpolation_end,
  [44556] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1550), 1,
      anon_sym_RBRACE,
  [44563] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1552), 1,
      anon_sym_RPAREN,
  [44570] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1554), 1,
      anon_sym_PIPE_RBRACK,
  [44577] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1556), 1,
      anon_sym_RBRACE,
  [44584] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1558), 1,
      anon_sym_in,
  [44591] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 1,
      anon_sym_RBRACK,
  [44598] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 1,
      sym_interpolation_end,
  [44605] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1560), 1,
      anon_sym_PERCENT,
  [44612] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1562), 1,
      anon_sym_EQ_GT,
  [44619] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1564), 1,
      anon_sym_PIPE_RBRACK,
  [44626] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1566), 1,
      anon_sym_in,
  [44633] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 1,
      sym_interpolation_end,
  [44640] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(669), 1,
      anon_sym_RPAREN,
  [44647] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1313), 1,
      anon_sym_RBRACE,
  [44654] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1568), 1,
      anon_sym_RPAREN,
  [44661] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1339), 1,
      anon_sym_RBRACK,
  [44668] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1570), 1,
      anon_sym_EQ,
  [44675] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1572), 1,
      anon_sym_PERCENT,
  [44682] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1574), 1,
      anon_sym_RBRACE,
  [44689] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1343), 1,
      anon_sym_RBRACE,
  [44696] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1371), 1,
      anon_sym_RBRACE,
  [44703] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1363), 1,
      anon_sym_RBRACE,
  [44710] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1576), 1,
      anon_sym_RBRACE,
  [44717] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1578), 1,
      anon_sym_RBRACE,
  [44724] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1580), 1,
      anon_sym_EQ,
  [44731] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1582), 1,
      anon_sym_PERCENT,
  [44738] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 1,
      anon_sym_RBRACE,
  [44745] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1390), 1,
      anon_sym_RBRACK,
  [44752] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1586), 1,
      anon_sym_PIPE_RBRACK,
  [44759] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1588), 1,
      anon_sym_RPAREN,
  [44766] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1590), 1,
      anon_sym_RBRACE,
  [44773] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1592), 1,
      anon_sym_RPAREN,
  [44780] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1594), 1,
      anon_sym_RBRACE,
  [44787] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1596), 1,
      anon_sym_RBRACE,
  [44794] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1598), 1,
      anon_sym_RBRACE,
  [44801] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1600), 1,
      anon_sym_else,
  [44808] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1602), 1,
      anon_sym_PIPE_RBRACK,
  [44815] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1604), 1,
      anon_sym_PIPE_RBRACK,
  [44822] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1606), 1,
      sym_signed_num_literal,
  [44829] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1608), 1,
      anon_sym_RBRACE,
  [44836] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1610), 1,
      anon_sym_PIPE_RBRACK,
  [44843] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1612), 1,
      sym_ident,
  [44850] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1614), 1,
      anon_sym_RBRACE,
  [44857] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1616), 1,
      anon_sym_PERCENT,
  [44864] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1618), 1,
      anon_sym_RBRACE,
  [44871] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1620), 1,
      anon_sym_RBRACE,
  [44878] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1413), 1,
      anon_sym_RBRACK,
  [44885] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1622), 1,
      sym_interpolation_end,
  [44892] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1624), 1,
      anon_sym_then,
  [44899] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1626), 1,
      anon_sym_RBRACE,
  [44906] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 1,
      anon_sym_RPAREN,
  [44913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 1,
      anon_sym_RPAREN,
  [44920] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(657), 1,
      anon_sym_RPAREN,
  [44927] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      anon_sym_RPAREN,
  [44934] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_RPAREN,
  [44941] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1628), 1,
      anon_sym_else,
  [44948] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1630), 1,
      anon_sym_LBRACE,
  [44955] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1632), 1,
      anon_sym_PIPE_RBRACK,
  [44962] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_PIPE_RBRACK,
  [44969] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1636), 1,
      sym_ident,
  [44976] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1638), 1,
      anon_sym_in,
  [44983] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1640), 1,
      anon_sym_RBRACE,
  [44990] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1642), 1,
      sym_ident,
  [44997] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_RPAREN,
  [45004] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1644), 1,
      anon_sym_RBRACE,
  [45011] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1646), 1,
      anon_sym_RBRACE,
  [45018] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1648), 1,
      ts_builtin_sym_end,
  [45025] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1650), 1,
      sym_ident,
  [45032] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      sym_interpolation_end,
  [45039] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1652), 1,
      sym_ident,
  [45046] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1654), 1,
      anon_sym_RPAREN,
  [45053] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1656), 1,
      anon_sym_LBRACE,
  [45060] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1658), 1,
      anon_sym_else,
  [45067] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1660), 1,
      anon_sym_RPAREN,
  [45074] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1450), 1,
      sym_ident,
  [45081] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1662), 1,
      anon_sym_RBRACE,
  [45088] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1664), 1,
      sym_ident,
  [45095] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1666), 1,
      sym_ident,
  [45102] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1668), 1,
      anon_sym_RBRACE,
  [45109] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1670), 1,
      anon_sym_RBRACE,
  [45116] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1672), 1,
      anon_sym_PIPE_RBRACK,
  [45123] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1674), 1,
      sym_ident,
  [45130] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1676), 1,
      anon_sym_PIPE_RBRACK,
  [45137] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1678), 1,
      sym_ident,
  [45144] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(649), 1,
      anon_sym_RPAREN,
  [45151] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1680), 1,
      anon_sym_LBRACE,
  [45158] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1682), 1,
      anon_sym_RBRACE,
  [45165] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1684), 1,
      sym_ident,
  [45172] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1686), 1,
      sym_ident,
  [45179] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      sym_interpolation_end,
  [45186] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1688), 1,
      sym_ident,
  [45193] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1690), 1,
      anon_sym_in,
  [45200] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1692), 1,
      anon_sym_PIPE_RBRACK,
  [45207] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1694), 1,
      anon_sym_RBRACE,
  [45214] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1696), 1,
      sym_ident,
  [45221] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1698), 1,
      sym_ident,
  [45228] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1700), 1,
      anon_sym_PIPE_RBRACK,
  [45235] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1702), 1,
      sym_ident,
  [45242] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1704), 1,
      sym_signed_num_literal,
  [45249] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1706), 1,
      anon_sym_LBRACE,
  [45256] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1708), 1,
      anon_sym_RBRACE,
  [45263] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1367), 1,
      anon_sym_RBRACE,
  [45270] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1710), 1,
      sym_ident,
  [45277] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1712), 1,
      anon_sym_RPAREN,
  [45284] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1714), 1,
      sym_ident,
  [45291] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1716), 1,
      anon_sym_RPAREN,
  [45298] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1349), 1,
      anon_sym_RBRACK,
  [45305] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1718), 1,
      anon_sym_PERCENT,
  [45312] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1353), 1,
      anon_sym_RBRACK,
  [45319] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1720), 1,
      sym_ident,
  [45326] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1722), 1,
      anon_sym_RPAREN,
  [45333] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1724), 1,
      sym_ident,
  [45340] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_RPAREN,
  [45347] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1726), 1,
      anon_sym_LBRACE,
  [45354] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1728), 1,
      anon_sym_PERCENT,
  [45361] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1730), 1,
      anon_sym_EQ_GT,
  [45368] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1732), 1,
      sym_ident,
  [45375] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 1,
      anon_sym_RBRACE,
  [45382] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1734), 1,
      sym_ident,
  [45389] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1736), 1,
      anon_sym_LBRACE,
  [45396] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1738), 1,
      anon_sym_RBRACE,
  [45403] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1740), 1,
      anon_sym_RBRACE,
  [45410] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1448), 1,
      anon_sym_COMMA,
  [45417] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1742), 1,
      sym_ident,
  [45424] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 1,
      sym_interpolation_end,
  [45431] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1744), 1,
      sym_ident,
  [45438] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1746), 1,
      anon_sym_PIPE_RBRACK,
  [45445] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1748), 1,
      anon_sym_then,
  [45452] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1750), 1,
      anon_sym_RBRACE,
  [45459] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1752), 1,
      anon_sym_then,
  [45466] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1754), 1,
      anon_sym_PIPE_RBRACK,
  [45473] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1756), 1,
      anon_sym_then,
  [45480] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1758), 1,
      anon_sym_else,
  [45487] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1760), 1,
      anon_sym_then,
  [45494] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1762), 1,
      anon_sym_RBRACE,
  [45501] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1764), 1,
      anon_sym_then,
  [45508] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1766), 1,
      anon_sym_RBRACE,
  [45515] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1768), 1,
      anon_sym_else,
  [45522] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 1,
      anon_sym_COMMA,
  [45529] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1770), 1,
      anon_sym_RBRACE,
  [45536] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(813), 1,
      sym_interpolation_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(8)] = 0,
  [SMALL_STATE(9)] = 104,
  [SMALL_STATE(10)] = 242,
  [SMALL_STATE(11)] = 380,
  [SMALL_STATE(12)] = 518,
  [SMALL_STATE(13)] = 656,
  [SMALL_STATE(14)] = 794,
  [SMALL_STATE(15)] = 932,
  [SMALL_STATE(16)] = 1067,
  [SMALL_STATE(17)] = 1202,
  [SMALL_STATE(18)] = 1337,
  [SMALL_STATE(19)] = 1472,
  [SMALL_STATE(20)] = 1607,
  [SMALL_STATE(21)] = 1742,
  [SMALL_STATE(22)] = 1877,
  [SMALL_STATE(23)] = 2012,
  [SMALL_STATE(24)] = 2147,
  [SMALL_STATE(25)] = 2282,
  [SMALL_STATE(26)] = 2417,
  [SMALL_STATE(27)] = 2552,
  [SMALL_STATE(28)] = 2684,
  [SMALL_STATE(29)] = 2816,
  [SMALL_STATE(30)] = 2948,
  [SMALL_STATE(31)] = 3080,
  [SMALL_STATE(32)] = 3212,
  [SMALL_STATE(33)] = 3344,
  [SMALL_STATE(34)] = 3476,
  [SMALL_STATE(35)] = 3608,
  [SMALL_STATE(36)] = 3740,
  [SMALL_STATE(37)] = 3872,
  [SMALL_STATE(38)] = 4004,
  [SMALL_STATE(39)] = 4136,
  [SMALL_STATE(40)] = 4268,
  [SMALL_STATE(41)] = 4400,
  [SMALL_STATE(42)] = 4532,
  [SMALL_STATE(43)] = 4664,
  [SMALL_STATE(44)] = 4796,
  [SMALL_STATE(45)] = 4928,
  [SMALL_STATE(46)] = 5060,
  [SMALL_STATE(47)] = 5192,
  [SMALL_STATE(48)] = 5324,
  [SMALL_STATE(49)] = 5456,
  [SMALL_STATE(50)] = 5588,
  [SMALL_STATE(51)] = 5720,
  [SMALL_STATE(52)] = 5852,
  [SMALL_STATE(53)] = 5984,
  [SMALL_STATE(54)] = 6116,
  [SMALL_STATE(55)] = 6248,
  [SMALL_STATE(56)] = 6380,
  [SMALL_STATE(57)] = 6512,
  [SMALL_STATE(58)] = 6644,
  [SMALL_STATE(59)] = 6776,
  [SMALL_STATE(60)] = 6908,
  [SMALL_STATE(61)] = 7040,
  [SMALL_STATE(62)] = 7172,
  [SMALL_STATE(63)] = 7304,
  [SMALL_STATE(64)] = 7436,
  [SMALL_STATE(65)] = 7568,
  [SMALL_STATE(66)] = 7700,
  [SMALL_STATE(67)] = 7832,
  [SMALL_STATE(68)] = 7964,
  [SMALL_STATE(69)] = 8096,
  [SMALL_STATE(70)] = 8224,
  [SMALL_STATE(71)] = 8322,
  [SMALL_STATE(72)] = 8450,
  [SMALL_STATE(73)] = 8578,
  [SMALL_STATE(74)] = 8676,
  [SMALL_STATE(75)] = 8804,
  [SMALL_STATE(76)] = 8932,
  [SMALL_STATE(77)] = 9060,
  [SMALL_STATE(78)] = 9158,
  [SMALL_STATE(79)] = 9256,
  [SMALL_STATE(80)] = 9354,
  [SMALL_STATE(81)] = 9408,
  [SMALL_STATE(82)] = 9462,
  [SMALL_STATE(83)] = 9516,
  [SMALL_STATE(84)] = 9570,
  [SMALL_STATE(85)] = 9624,
  [SMALL_STATE(86)] = 9678,
  [SMALL_STATE(87)] = 9732,
  [SMALL_STATE(88)] = 9786,
  [SMALL_STATE(89)] = 9840,
  [SMALL_STATE(90)] = 9894,
  [SMALL_STATE(91)] = 9948,
  [SMALL_STATE(92)] = 10004,
  [SMALL_STATE(93)] = 10058,
  [SMALL_STATE(94)] = 10112,
  [SMALL_STATE(95)] = 10166,
  [SMALL_STATE(96)] = 10220,
  [SMALL_STATE(97)] = 10274,
  [SMALL_STATE(98)] = 10328,
  [SMALL_STATE(99)] = 10384,
  [SMALL_STATE(100)] = 10438,
  [SMALL_STATE(101)] = 10492,
  [SMALL_STATE(102)] = 10548,
  [SMALL_STATE(103)] = 10602,
  [SMALL_STATE(104)] = 10656,
  [SMALL_STATE(105)] = 10710,
  [SMALL_STATE(106)] = 10764,
  [SMALL_STATE(107)] = 10818,
  [SMALL_STATE(108)] = 10872,
  [SMALL_STATE(109)] = 10926,
  [SMALL_STATE(110)] = 10980,
  [SMALL_STATE(111)] = 11034,
  [SMALL_STATE(112)] = 11088,
  [SMALL_STATE(113)] = 11142,
  [SMALL_STATE(114)] = 11196,
  [SMALL_STATE(115)] = 11250,
  [SMALL_STATE(116)] = 11304,
  [SMALL_STATE(117)] = 11358,
  [SMALL_STATE(118)] = 11412,
  [SMALL_STATE(119)] = 11466,
  [SMALL_STATE(120)] = 11519,
  [SMALL_STATE(121)] = 11572,
  [SMALL_STATE(122)] = 11685,
  [SMALL_STATE(123)] = 11798,
  [SMALL_STATE(124)] = 11911,
  [SMALL_STATE(125)] = 12024,
  [SMALL_STATE(126)] = 12137,
  [SMALL_STATE(127)] = 12250,
  [SMALL_STATE(128)] = 12303,
  [SMALL_STATE(129)] = 12416,
  [SMALL_STATE(130)] = 12529,
  [SMALL_STATE(131)] = 12582,
  [SMALL_STATE(132)] = 12695,
  [SMALL_STATE(133)] = 12808,
  [SMALL_STATE(134)] = 12861,
  [SMALL_STATE(135)] = 12974,
  [SMALL_STATE(136)] = 13087,
  [SMALL_STATE(137)] = 13140,
  [SMALL_STATE(138)] = 13193,
  [SMALL_STATE(139)] = 13306,
  [SMALL_STATE(140)] = 13419,
  [SMALL_STATE(141)] = 13532,
  [SMALL_STATE(142)] = 13585,
  [SMALL_STATE(143)] = 13698,
  [SMALL_STATE(144)] = 13811,
  [SMALL_STATE(145)] = 13924,
  [SMALL_STATE(146)] = 14031,
  [SMALL_STATE(147)] = 14138,
  [SMALL_STATE(148)] = 14242,
  [SMALL_STATE(149)] = 14346,
  [SMALL_STATE(150)] = 14450,
  [SMALL_STATE(151)] = 14554,
  [SMALL_STATE(152)] = 14658,
  [SMALL_STATE(153)] = 14762,
  [SMALL_STATE(154)] = 14866,
  [SMALL_STATE(155)] = 14970,
  [SMALL_STATE(156)] = 15074,
  [SMALL_STATE(157)] = 15178,
  [SMALL_STATE(158)] = 15282,
  [SMALL_STATE(159)] = 15386,
  [SMALL_STATE(160)] = 15490,
  [SMALL_STATE(161)] = 15594,
  [SMALL_STATE(162)] = 15698,
  [SMALL_STATE(163)] = 15802,
  [SMALL_STATE(164)] = 15906,
  [SMALL_STATE(165)] = 16010,
  [SMALL_STATE(166)] = 16114,
  [SMALL_STATE(167)] = 16218,
  [SMALL_STATE(168)] = 16322,
  [SMALL_STATE(169)] = 16426,
  [SMALL_STATE(170)] = 16530,
  [SMALL_STATE(171)] = 16634,
  [SMALL_STATE(172)] = 16738,
  [SMALL_STATE(173)] = 16842,
  [SMALL_STATE(174)] = 16946,
  [SMALL_STATE(175)] = 17050,
  [SMALL_STATE(176)] = 17154,
  [SMALL_STATE(177)] = 17258,
  [SMALL_STATE(178)] = 17362,
  [SMALL_STATE(179)] = 17466,
  [SMALL_STATE(180)] = 17570,
  [SMALL_STATE(181)] = 17674,
  [SMALL_STATE(182)] = 17778,
  [SMALL_STATE(183)] = 17882,
  [SMALL_STATE(184)] = 17986,
  [SMALL_STATE(185)] = 18090,
  [SMALL_STATE(186)] = 18194,
  [SMALL_STATE(187)] = 18298,
  [SMALL_STATE(188)] = 18402,
  [SMALL_STATE(189)] = 18506,
  [SMALL_STATE(190)] = 18610,
  [SMALL_STATE(191)] = 18714,
  [SMALL_STATE(192)] = 18818,
  [SMALL_STATE(193)] = 18922,
  [SMALL_STATE(194)] = 19026,
  [SMALL_STATE(195)] = 19130,
  [SMALL_STATE(196)] = 19234,
  [SMALL_STATE(197)] = 19338,
  [SMALL_STATE(198)] = 19442,
  [SMALL_STATE(199)] = 19546,
  [SMALL_STATE(200)] = 19650,
  [SMALL_STATE(201)] = 19754,
  [SMALL_STATE(202)] = 19858,
  [SMALL_STATE(203)] = 19962,
  [SMALL_STATE(204)] = 20066,
  [SMALL_STATE(205)] = 20170,
  [SMALL_STATE(206)] = 20274,
  [SMALL_STATE(207)] = 20378,
  [SMALL_STATE(208)] = 20482,
  [SMALL_STATE(209)] = 20586,
  [SMALL_STATE(210)] = 20690,
  [SMALL_STATE(211)] = 20794,
  [SMALL_STATE(212)] = 20898,
  [SMALL_STATE(213)] = 21002,
  [SMALL_STATE(214)] = 21050,
  [SMALL_STATE(215)] = 21098,
  [SMALL_STATE(216)] = 21146,
  [SMALL_STATE(217)] = 21194,
  [SMALL_STATE(218)] = 21242,
  [SMALL_STATE(219)] = 21290,
  [SMALL_STATE(220)] = 21338,
  [SMALL_STATE(221)] = 21386,
  [SMALL_STATE(222)] = 21434,
  [SMALL_STATE(223)] = 21482,
  [SMALL_STATE(224)] = 21530,
  [SMALL_STATE(225)] = 21578,
  [SMALL_STATE(226)] = 21626,
  [SMALL_STATE(227)] = 21674,
  [SMALL_STATE(228)] = 21722,
  [SMALL_STATE(229)] = 21770,
  [SMALL_STATE(230)] = 21818,
  [SMALL_STATE(231)] = 21866,
  [SMALL_STATE(232)] = 21914,
  [SMALL_STATE(233)] = 21964,
  [SMALL_STATE(234)] = 22012,
  [SMALL_STATE(235)] = 22060,
  [SMALL_STATE(236)] = 22108,
  [SMALL_STATE(237)] = 22156,
  [SMALL_STATE(238)] = 22204,
  [SMALL_STATE(239)] = 22252,
  [SMALL_STATE(240)] = 22300,
  [SMALL_STATE(241)] = 22350,
  [SMALL_STATE(242)] = 22398,
  [SMALL_STATE(243)] = 22448,
  [SMALL_STATE(244)] = 22496,
  [SMALL_STATE(245)] = 22544,
  [SMALL_STATE(246)] = 22594,
  [SMALL_STATE(247)] = 22642,
  [SMALL_STATE(248)] = 22690,
  [SMALL_STATE(249)] = 22738,
  [SMALL_STATE(250)] = 22786,
  [SMALL_STATE(251)] = 22834,
  [SMALL_STATE(252)] = 22882,
  [SMALL_STATE(253)] = 22930,
  [SMALL_STATE(254)] = 22978,
  [SMALL_STATE(255)] = 23026,
  [SMALL_STATE(256)] = 23074,
  [SMALL_STATE(257)] = 23122,
  [SMALL_STATE(258)] = 23170,
  [SMALL_STATE(259)] = 23218,
  [SMALL_STATE(260)] = 23266,
  [SMALL_STATE(261)] = 23314,
  [SMALL_STATE(262)] = 23364,
  [SMALL_STATE(263)] = 23412,
  [SMALL_STATE(264)] = 23460,
  [SMALL_STATE(265)] = 23510,
  [SMALL_STATE(266)] = 23560,
  [SMALL_STATE(267)] = 23608,
  [SMALL_STATE(268)] = 23656,
  [SMALL_STATE(269)] = 23704,
  [SMALL_STATE(270)] = 23752,
  [SMALL_STATE(271)] = 23800,
  [SMALL_STATE(272)] = 23848,
  [SMALL_STATE(273)] = 23896,
  [SMALL_STATE(274)] = 23944,
  [SMALL_STATE(275)] = 23992,
  [SMALL_STATE(276)] = 24040,
  [SMALL_STATE(277)] = 24088,
  [SMALL_STATE(278)] = 24136,
  [SMALL_STATE(279)] = 24184,
  [SMALL_STATE(280)] = 24232,
  [SMALL_STATE(281)] = 24280,
  [SMALL_STATE(282)] = 24328,
  [SMALL_STATE(283)] = 24376,
  [SMALL_STATE(284)] = 24424,
  [SMALL_STATE(285)] = 24474,
  [SMALL_STATE(286)] = 24522,
  [SMALL_STATE(287)] = 24570,
  [SMALL_STATE(288)] = 24618,
  [SMALL_STATE(289)] = 24666,
  [SMALL_STATE(290)] = 24714,
  [SMALL_STATE(291)] = 24762,
  [SMALL_STATE(292)] = 24810,
  [SMALL_STATE(293)] = 24858,
  [SMALL_STATE(294)] = 24906,
  [SMALL_STATE(295)] = 24954,
  [SMALL_STATE(296)] = 25002,
  [SMALL_STATE(297)] = 25050,
  [SMALL_STATE(298)] = 25100,
  [SMALL_STATE(299)] = 25148,
  [SMALL_STATE(300)] = 25196,
  [SMALL_STATE(301)] = 25244,
  [SMALL_STATE(302)] = 25292,
  [SMALL_STATE(303)] = 25340,
  [SMALL_STATE(304)] = 25388,
  [SMALL_STATE(305)] = 25436,
  [SMALL_STATE(306)] = 25484,
  [SMALL_STATE(307)] = 25532,
  [SMALL_STATE(308)] = 25580,
  [SMALL_STATE(309)] = 25628,
  [SMALL_STATE(310)] = 25676,
  [SMALL_STATE(311)] = 25726,
  [SMALL_STATE(312)] = 25774,
  [SMALL_STATE(313)] = 25822,
  [SMALL_STATE(314)] = 25870,
  [SMALL_STATE(315)] = 25918,
  [SMALL_STATE(316)] = 25966,
  [SMALL_STATE(317)] = 26014,
  [SMALL_STATE(318)] = 26062,
  [SMALL_STATE(319)] = 26110,
  [SMALL_STATE(320)] = 26158,
  [SMALL_STATE(321)] = 26206,
  [SMALL_STATE(322)] = 26254,
  [SMALL_STATE(323)] = 26302,
  [SMALL_STATE(324)] = 26350,
  [SMALL_STATE(325)] = 26400,
  [SMALL_STATE(326)] = 26448,
  [SMALL_STATE(327)] = 26496,
  [SMALL_STATE(328)] = 26544,
  [SMALL_STATE(329)] = 26594,
  [SMALL_STATE(330)] = 26642,
  [SMALL_STATE(331)] = 26690,
  [SMALL_STATE(332)] = 26738,
  [SMALL_STATE(333)] = 26786,
  [SMALL_STATE(334)] = 26834,
  [SMALL_STATE(335)] = 26882,
  [SMALL_STATE(336)] = 26930,
  [SMALL_STATE(337)] = 26978,
  [SMALL_STATE(338)] = 27026,
  [SMALL_STATE(339)] = 27074,
  [SMALL_STATE(340)] = 27122,
  [SMALL_STATE(341)] = 27170,
  [SMALL_STATE(342)] = 27218,
  [SMALL_STATE(343)] = 27268,
  [SMALL_STATE(344)] = 27318,
  [SMALL_STATE(345)] = 27366,
  [SMALL_STATE(346)] = 27414,
  [SMALL_STATE(347)] = 27462,
  [SMALL_STATE(348)] = 27510,
  [SMALL_STATE(349)] = 27558,
  [SMALL_STATE(350)] = 27608,
  [SMALL_STATE(351)] = 27656,
  [SMALL_STATE(352)] = 27704,
  [SMALL_STATE(353)] = 27752,
  [SMALL_STATE(354)] = 27800,
  [SMALL_STATE(355)] = 27848,
  [SMALL_STATE(356)] = 27896,
  [SMALL_STATE(357)] = 27944,
  [SMALL_STATE(358)] = 27992,
  [SMALL_STATE(359)] = 28040,
  [SMALL_STATE(360)] = 28088,
  [SMALL_STATE(361)] = 28136,
  [SMALL_STATE(362)] = 28184,
  [SMALL_STATE(363)] = 28232,
  [SMALL_STATE(364)] = 28280,
  [SMALL_STATE(365)] = 28328,
  [SMALL_STATE(366)] = 28376,
  [SMALL_STATE(367)] = 28424,
  [SMALL_STATE(368)] = 28472,
  [SMALL_STATE(369)] = 28520,
  [SMALL_STATE(370)] = 28568,
  [SMALL_STATE(371)] = 28616,
  [SMALL_STATE(372)] = 28664,
  [SMALL_STATE(373)] = 28712,
  [SMALL_STATE(374)] = 28760,
  [SMALL_STATE(375)] = 28808,
  [SMALL_STATE(376)] = 28856,
  [SMALL_STATE(377)] = 28904,
  [SMALL_STATE(378)] = 28952,
  [SMALL_STATE(379)] = 29000,
  [SMALL_STATE(380)] = 29048,
  [SMALL_STATE(381)] = 29096,
  [SMALL_STATE(382)] = 29144,
  [SMALL_STATE(383)] = 29192,
  [SMALL_STATE(384)] = 29240,
  [SMALL_STATE(385)] = 29288,
  [SMALL_STATE(386)] = 29336,
  [SMALL_STATE(387)] = 29384,
  [SMALL_STATE(388)] = 29432,
  [SMALL_STATE(389)] = 29480,
  [SMALL_STATE(390)] = 29528,
  [SMALL_STATE(391)] = 29576,
  [SMALL_STATE(392)] = 29624,
  [SMALL_STATE(393)] = 29672,
  [SMALL_STATE(394)] = 29720,
  [SMALL_STATE(395)] = 29768,
  [SMALL_STATE(396)] = 29816,
  [SMALL_STATE(397)] = 29864,
  [SMALL_STATE(398)] = 29912,
  [SMALL_STATE(399)] = 29960,
  [SMALL_STATE(400)] = 30008,
  [SMALL_STATE(401)] = 30056,
  [SMALL_STATE(402)] = 30104,
  [SMALL_STATE(403)] = 30152,
  [SMALL_STATE(404)] = 30200,
  [SMALL_STATE(405)] = 30248,
  [SMALL_STATE(406)] = 30296,
  [SMALL_STATE(407)] = 30344,
  [SMALL_STATE(408)] = 30392,
  [SMALL_STATE(409)] = 30439,
  [SMALL_STATE(410)] = 30486,
  [SMALL_STATE(411)] = 30533,
  [SMALL_STATE(412)] = 30580,
  [SMALL_STATE(413)] = 30627,
  [SMALL_STATE(414)] = 30674,
  [SMALL_STATE(415)] = 30721,
  [SMALL_STATE(416)] = 30768,
  [SMALL_STATE(417)] = 30815,
  [SMALL_STATE(418)] = 30862,
  [SMALL_STATE(419)] = 30909,
  [SMALL_STATE(420)] = 30956,
  [SMALL_STATE(421)] = 31003,
  [SMALL_STATE(422)] = 31050,
  [SMALL_STATE(423)] = 31097,
  [SMALL_STATE(424)] = 31144,
  [SMALL_STATE(425)] = 31191,
  [SMALL_STATE(426)] = 31238,
  [SMALL_STATE(427)] = 31285,
  [SMALL_STATE(428)] = 31332,
  [SMALL_STATE(429)] = 31379,
  [SMALL_STATE(430)] = 31426,
  [SMALL_STATE(431)] = 31473,
  [SMALL_STATE(432)] = 31520,
  [SMALL_STATE(433)] = 31567,
  [SMALL_STATE(434)] = 31614,
  [SMALL_STATE(435)] = 31661,
  [SMALL_STATE(436)] = 31708,
  [SMALL_STATE(437)] = 31755,
  [SMALL_STATE(438)] = 31802,
  [SMALL_STATE(439)] = 31849,
  [SMALL_STATE(440)] = 31896,
  [SMALL_STATE(441)] = 31943,
  [SMALL_STATE(442)] = 31990,
  [SMALL_STATE(443)] = 32037,
  [SMALL_STATE(444)] = 32084,
  [SMALL_STATE(445)] = 32131,
  [SMALL_STATE(446)] = 32178,
  [SMALL_STATE(447)] = 32225,
  [SMALL_STATE(448)] = 32272,
  [SMALL_STATE(449)] = 32363,
  [SMALL_STATE(450)] = 32422,
  [SMALL_STATE(451)] = 32491,
  [SMALL_STATE(452)] = 32564,
  [SMALL_STATE(453)] = 32629,
  [SMALL_STATE(454)] = 32710,
  [SMALL_STATE(455)] = 32791,
  [SMALL_STATE(456)] = 32868,
  [SMALL_STATE(457)] = 32933,
  [SMALL_STATE(458)] = 33008,
  [SMALL_STATE(459)] = 33069,
  [SMALL_STATE(460)] = 33128,
  [SMALL_STATE(461)] = 33191,
  [SMALL_STATE(462)] = 33267,
  [SMALL_STATE(463)] = 33351,
  [SMALL_STATE(464)] = 33427,
  [SMALL_STATE(465)] = 33503,
  [SMALL_STATE(466)] = 33579,
  [SMALL_STATE(467)] = 33663,
  [SMALL_STATE(468)] = 33747,
  [SMALL_STATE(469)] = 33831,
  [SMALL_STATE(470)] = 33915,
  [SMALL_STATE(471)] = 33991,
  [SMALL_STATE(472)] = 34067,
  [SMALL_STATE(473)] = 34126,
  [SMALL_STATE(474)] = 34201,
  [SMALL_STATE(475)] = 34276,
  [SMALL_STATE(476)] = 34329,
  [SMALL_STATE(477)] = 34400,
  [SMALL_STATE(478)] = 34469,
  [SMALL_STATE(479)] = 34536,
  [SMALL_STATE(480)] = 34595,
  [SMALL_STATE(481)] = 34670,
  [SMALL_STATE(482)] = 34733,
  [SMALL_STATE(483)] = 34804,
  [SMALL_STATE(484)] = 34873,
  [SMALL_STATE(485)] = 34932,
  [SMALL_STATE(486)] = 34999,
  [SMALL_STATE(487)] = 35052,
  [SMALL_STATE(488)] = 35111,
  [SMALL_STATE(489)] = 35186,
  [SMALL_STATE(490)] = 35239,
  [SMALL_STATE(491)] = 35294,
  [SMALL_STATE(492)] = 35347,
  [SMALL_STATE(493)] = 35404,
  [SMALL_STATE(494)] = 35463,
  [SMALL_STATE(495)] = 35526,
  [SMALL_STATE(496)] = 35589,
  [SMALL_STATE(497)] = 35656,
  [SMALL_STATE(498)] = 35725,
  [SMALL_STATE(499)] = 35796,
  [SMALL_STATE(500)] = 35871,
  [SMALL_STATE(501)] = 35946,
  [SMALL_STATE(502)] = 36021,
  [SMALL_STATE(503)] = 36080,
  [SMALL_STATE(504)] = 36137,
  [SMALL_STATE(505)] = 36194,
  [SMALL_STATE(506)] = 36249,
  [SMALL_STATE(507)] = 36304,
  [SMALL_STATE(508)] = 36357,
  [SMALL_STATE(509)] = 36410,
  [SMALL_STATE(510)] = 36469,
  [SMALL_STATE(511)] = 36544,
  [SMALL_STATE(512)] = 36619,
  [SMALL_STATE(513)] = 36672,
  [SMALL_STATE(514)] = 36727,
  [SMALL_STATE(515)] = 36784,
  [SMALL_STATE(516)] = 36843,
  [SMALL_STATE(517)] = 36906,
  [SMALL_STATE(518)] = 36973,
  [SMALL_STATE(519)] = 37042,
  [SMALL_STATE(520)] = 37113,
  [SMALL_STATE(521)] = 37166,
  [SMALL_STATE(522)] = 37225,
  [SMALL_STATE(523)] = 37300,
  [SMALL_STATE(524)] = 37353,
  [SMALL_STATE(525)] = 37406,
  [SMALL_STATE(526)] = 37461,
  [SMALL_STATE(527)] = 37532,
  [SMALL_STATE(528)] = 37601,
  [SMALL_STATE(529)] = 37668,
  [SMALL_STATE(530)] = 37731,
  [SMALL_STATE(531)] = 37790,
  [SMALL_STATE(532)] = 37847,
  [SMALL_STATE(533)] = 37883,
  [SMALL_STATE(534)] = 37919,
  [SMALL_STATE(535)] = 37955,
  [SMALL_STATE(536)] = 37991,
  [SMALL_STATE(537)] = 38024,
  [SMALL_STATE(538)] = 38056,
  [SMALL_STATE(539)] = 38088,
  [SMALL_STATE(540)] = 38120,
  [SMALL_STATE(541)] = 38152,
  [SMALL_STATE(542)] = 38184,
  [SMALL_STATE(543)] = 38216,
  [SMALL_STATE(544)] = 38248,
  [SMALL_STATE(545)] = 38280,
  [SMALL_STATE(546)] = 38327,
  [SMALL_STATE(547)] = 38374,
  [SMALL_STATE(548)] = 38421,
  [SMALL_STATE(549)] = 38468,
  [SMALL_STATE(550)] = 38515,
  [SMALL_STATE(551)] = 38562,
  [SMALL_STATE(552)] = 38606,
  [SMALL_STATE(553)] = 38650,
  [SMALL_STATE(554)] = 38694,
  [SMALL_STATE(555)] = 38738,
  [SMALL_STATE(556)] = 38782,
  [SMALL_STATE(557)] = 38826,
  [SMALL_STATE(558)] = 38845,
  [SMALL_STATE(559)] = 38864,
  [SMALL_STATE(560)] = 38883,
  [SMALL_STATE(561)] = 38902,
  [SMALL_STATE(562)] = 38921,
  [SMALL_STATE(563)] = 38958,
  [SMALL_STATE(564)] = 38977,
  [SMALL_STATE(565)] = 38996,
  [SMALL_STATE(566)] = 39015,
  [SMALL_STATE(567)] = 39034,
  [SMALL_STATE(568)] = 39057,
  [SMALL_STATE(569)] = 39080,
  [SMALL_STATE(570)] = 39106,
  [SMALL_STATE(571)] = 39132,
  [SMALL_STATE(572)] = 39158,
  [SMALL_STATE(573)] = 39184,
  [SMALL_STATE(574)] = 39214,
  [SMALL_STATE(575)] = 39240,
  [SMALL_STATE(576)] = 39266,
  [SMALL_STATE(577)] = 39282,
  [SMALL_STATE(578)] = 39298,
  [SMALL_STATE(579)] = 39324,
  [SMALL_STATE(580)] = 39340,
  [SMALL_STATE(581)] = 39356,
  [SMALL_STATE(582)] = 39382,
  [SMALL_STATE(583)] = 39408,
  [SMALL_STATE(584)] = 39434,
  [SMALL_STATE(585)] = 39460,
  [SMALL_STATE(586)] = 39486,
  [SMALL_STATE(587)] = 39512,
  [SMALL_STATE(588)] = 39528,
  [SMALL_STATE(589)] = 39554,
  [SMALL_STATE(590)] = 39580,
  [SMALL_STATE(591)] = 39596,
  [SMALL_STATE(592)] = 39623,
  [SMALL_STATE(593)] = 39648,
  [SMALL_STATE(594)] = 39675,
  [SMALL_STATE(595)] = 39702,
  [SMALL_STATE(596)] = 39729,
  [SMALL_STATE(597)] = 39756,
  [SMALL_STATE(598)] = 39783,
  [SMALL_STATE(599)] = 39810,
  [SMALL_STATE(600)] = 39837,
  [SMALL_STATE(601)] = 39864,
  [SMALL_STATE(602)] = 39891,
  [SMALL_STATE(603)] = 39918,
  [SMALL_STATE(604)] = 39945,
  [SMALL_STATE(605)] = 39964,
  [SMALL_STATE(606)] = 39991,
  [SMALL_STATE(607)] = 40018,
  [SMALL_STATE(608)] = 40045,
  [SMALL_STATE(609)] = 40067,
  [SMALL_STATE(610)] = 40089,
  [SMALL_STATE(611)] = 40107,
  [SMALL_STATE(612)] = 40123,
  [SMALL_STATE(613)] = 40145,
  [SMALL_STATE(614)] = 40173,
  [SMALL_STATE(615)] = 40195,
  [SMALL_STATE(616)] = 40211,
  [SMALL_STATE(617)] = 40233,
  [SMALL_STATE(618)] = 40261,
  [SMALL_STATE(619)] = 40283,
  [SMALL_STATE(620)] = 40311,
  [SMALL_STATE(621)] = 40333,
  [SMALL_STATE(622)] = 40355,
  [SMALL_STATE(623)] = 40371,
  [SMALL_STATE(624)] = 40387,
  [SMALL_STATE(625)] = 40405,
  [SMALL_STATE(626)] = 40423,
  [SMALL_STATE(627)] = 40445,
  [SMALL_STATE(628)] = 40473,
  [SMALL_STATE(629)] = 40495,
  [SMALL_STATE(630)] = 40517,
  [SMALL_STATE(631)] = 40539,
  [SMALL_STATE(632)] = 40561,
  [SMALL_STATE(633)] = 40583,
  [SMALL_STATE(634)] = 40599,
  [SMALL_STATE(635)] = 40627,
  [SMALL_STATE(636)] = 40643,
  [SMALL_STATE(637)] = 40665,
  [SMALL_STATE(638)] = 40693,
  [SMALL_STATE(639)] = 40715,
  [SMALL_STATE(640)] = 40737,
  [SMALL_STATE(641)] = 40760,
  [SMALL_STATE(642)] = 40783,
  [SMALL_STATE(643)] = 40808,
  [SMALL_STATE(644)] = 40831,
  [SMALL_STATE(645)] = 40856,
  [SMALL_STATE(646)] = 40879,
  [SMALL_STATE(647)] = 40904,
  [SMALL_STATE(648)] = 40927,
  [SMALL_STATE(649)] = 40950,
  [SMALL_STATE(650)] = 40973,
  [SMALL_STATE(651)] = 40996,
  [SMALL_STATE(652)] = 41009,
  [SMALL_STATE(653)] = 41022,
  [SMALL_STATE(654)] = 41045,
  [SMALL_STATE(655)] = 41058,
  [SMALL_STATE(656)] = 41081,
  [SMALL_STATE(657)] = 41104,
  [SMALL_STATE(658)] = 41127,
  [SMALL_STATE(659)] = 41150,
  [SMALL_STATE(660)] = 41175,
  [SMALL_STATE(661)] = 41200,
  [SMALL_STATE(662)] = 41223,
  [SMALL_STATE(663)] = 41248,
  [SMALL_STATE(664)] = 41273,
  [SMALL_STATE(665)] = 41298,
  [SMALL_STATE(666)] = 41321,
  [SMALL_STATE(667)] = 41344,
  [SMALL_STATE(668)] = 41357,
  [SMALL_STATE(669)] = 41380,
  [SMALL_STATE(670)] = 41403,
  [SMALL_STATE(671)] = 41428,
  [SMALL_STATE(672)] = 41451,
  [SMALL_STATE(673)] = 41476,
  [SMALL_STATE(674)] = 41499,
  [SMALL_STATE(675)] = 41522,
  [SMALL_STATE(676)] = 41545,
  [SMALL_STATE(677)] = 41570,
  [SMALL_STATE(678)] = 41593,
  [SMALL_STATE(679)] = 41618,
  [SMALL_STATE(680)] = 41641,
  [SMALL_STATE(681)] = 41664,
  [SMALL_STATE(682)] = 41677,
  [SMALL_STATE(683)] = 41700,
  [SMALL_STATE(684)] = 41723,
  [SMALL_STATE(685)] = 41746,
  [SMALL_STATE(686)] = 41759,
  [SMALL_STATE(687)] = 41782,
  [SMALL_STATE(688)] = 41795,
  [SMALL_STATE(689)] = 41818,
  [SMALL_STATE(690)] = 41841,
  [SMALL_STATE(691)] = 41864,
  [SMALL_STATE(692)] = 41886,
  [SMALL_STATE(693)] = 41906,
  [SMALL_STATE(694)] = 41920,
  [SMALL_STATE(695)] = 41940,
  [SMALL_STATE(696)] = 41960,
  [SMALL_STATE(697)] = 41982,
  [SMALL_STATE(698)] = 42002,
  [SMALL_STATE(699)] = 42022,
  [SMALL_STATE(700)] = 42042,
  [SMALL_STATE(701)] = 42064,
  [SMALL_STATE(702)] = 42084,
  [SMALL_STATE(703)] = 42106,
  [SMALL_STATE(704)] = 42118,
  [SMALL_STATE(705)] = 42138,
  [SMALL_STATE(706)] = 42160,
  [SMALL_STATE(707)] = 42174,
  [SMALL_STATE(708)] = 42194,
  [SMALL_STATE(709)] = 42216,
  [SMALL_STATE(710)] = 42238,
  [SMALL_STATE(711)] = 42260,
  [SMALL_STATE(712)] = 42280,
  [SMALL_STATE(713)] = 42300,
  [SMALL_STATE(714)] = 42320,
  [SMALL_STATE(715)] = 42334,
  [SMALL_STATE(716)] = 42356,
  [SMALL_STATE(717)] = 42376,
  [SMALL_STATE(718)] = 42396,
  [SMALL_STATE(719)] = 42416,
  [SMALL_STATE(720)] = 42433,
  [SMALL_STATE(721)] = 42450,
  [SMALL_STATE(722)] = 42467,
  [SMALL_STATE(723)] = 42484,
  [SMALL_STATE(724)] = 42501,
  [SMALL_STATE(725)] = 42518,
  [SMALL_STATE(726)] = 42535,
  [SMALL_STATE(727)] = 42552,
  [SMALL_STATE(728)] = 42571,
  [SMALL_STATE(729)] = 42588,
  [SMALL_STATE(730)] = 42605,
  [SMALL_STATE(731)] = 42622,
  [SMALL_STATE(732)] = 42635,
  [SMALL_STATE(733)] = 42652,
  [SMALL_STATE(734)] = 42669,
  [SMALL_STATE(735)] = 42686,
  [SMALL_STATE(736)] = 42699,
  [SMALL_STATE(737)] = 42716,
  [SMALL_STATE(738)] = 42729,
  [SMALL_STATE(739)] = 42746,
  [SMALL_STATE(740)] = 42759,
  [SMALL_STATE(741)] = 42776,
  [SMALL_STATE(742)] = 42793,
  [SMALL_STATE(743)] = 42806,
  [SMALL_STATE(744)] = 42822,
  [SMALL_STATE(745)] = 42838,
  [SMALL_STATE(746)] = 42848,
  [SMALL_STATE(747)] = 42860,
  [SMALL_STATE(748)] = 42876,
  [SMALL_STATE(749)] = 42892,
  [SMALL_STATE(750)] = 42908,
  [SMALL_STATE(751)] = 42924,
  [SMALL_STATE(752)] = 42940,
  [SMALL_STATE(753)] = 42952,
  [SMALL_STATE(754)] = 42962,
  [SMALL_STATE(755)] = 42974,
  [SMALL_STATE(756)] = 42990,
  [SMALL_STATE(757)] = 43006,
  [SMALL_STATE(758)] = 43022,
  [SMALL_STATE(759)] = 43038,
  [SMALL_STATE(760)] = 43054,
  [SMALL_STATE(761)] = 43070,
  [SMALL_STATE(762)] = 43086,
  [SMALL_STATE(763)] = 43102,
  [SMALL_STATE(764)] = 43112,
  [SMALL_STATE(765)] = 43126,
  [SMALL_STATE(766)] = 43142,
  [SMALL_STATE(767)] = 43158,
  [SMALL_STATE(768)] = 43174,
  [SMALL_STATE(769)] = 43187,
  [SMALL_STATE(770)] = 43196,
  [SMALL_STATE(771)] = 43207,
  [SMALL_STATE(772)] = 43216,
  [SMALL_STATE(773)] = 43227,
  [SMALL_STATE(774)] = 43240,
  [SMALL_STATE(775)] = 43251,
  [SMALL_STATE(776)] = 43264,
  [SMALL_STATE(777)] = 43277,
  [SMALL_STATE(778)] = 43290,
  [SMALL_STATE(779)] = 43303,
  [SMALL_STATE(780)] = 43316,
  [SMALL_STATE(781)] = 43327,
  [SMALL_STATE(782)] = 43336,
  [SMALL_STATE(783)] = 43345,
  [SMALL_STATE(784)] = 43354,
  [SMALL_STATE(785)] = 43367,
  [SMALL_STATE(786)] = 43380,
  [SMALL_STATE(787)] = 43393,
  [SMALL_STATE(788)] = 43406,
  [SMALL_STATE(789)] = 43417,
  [SMALL_STATE(790)] = 43430,
  [SMALL_STATE(791)] = 43439,
  [SMALL_STATE(792)] = 43450,
  [SMALL_STATE(793)] = 43459,
  [SMALL_STATE(794)] = 43468,
  [SMALL_STATE(795)] = 43479,
  [SMALL_STATE(796)] = 43492,
  [SMALL_STATE(797)] = 43503,
  [SMALL_STATE(798)] = 43516,
  [SMALL_STATE(799)] = 43529,
  [SMALL_STATE(800)] = 43542,
  [SMALL_STATE(801)] = 43555,
  [SMALL_STATE(802)] = 43566,
  [SMALL_STATE(803)] = 43579,
  [SMALL_STATE(804)] = 43588,
  [SMALL_STATE(805)] = 43599,
  [SMALL_STATE(806)] = 43612,
  [SMALL_STATE(807)] = 43623,
  [SMALL_STATE(808)] = 43636,
  [SMALL_STATE(809)] = 43647,
  [SMALL_STATE(810)] = 43660,
  [SMALL_STATE(811)] = 43669,
  [SMALL_STATE(812)] = 43682,
  [SMALL_STATE(813)] = 43695,
  [SMALL_STATE(814)] = 43706,
  [SMALL_STATE(815)] = 43719,
  [SMALL_STATE(816)] = 43728,
  [SMALL_STATE(817)] = 43739,
  [SMALL_STATE(818)] = 43748,
  [SMALL_STATE(819)] = 43761,
  [SMALL_STATE(820)] = 43774,
  [SMALL_STATE(821)] = 43785,
  [SMALL_STATE(822)] = 43798,
  [SMALL_STATE(823)] = 43809,
  [SMALL_STATE(824)] = 43818,
  [SMALL_STATE(825)] = 43829,
  [SMALL_STATE(826)] = 43842,
  [SMALL_STATE(827)] = 43855,
  [SMALL_STATE(828)] = 43868,
  [SMALL_STATE(829)] = 43879,
  [SMALL_STATE(830)] = 43890,
  [SMALL_STATE(831)] = 43903,
  [SMALL_STATE(832)] = 43914,
  [SMALL_STATE(833)] = 43925,
  [SMALL_STATE(834)] = 43938,
  [SMALL_STATE(835)] = 43949,
  [SMALL_STATE(836)] = 43960,
  [SMALL_STATE(837)] = 43971,
  [SMALL_STATE(838)] = 43982,
  [SMALL_STATE(839)] = 43995,
  [SMALL_STATE(840)] = 44008,
  [SMALL_STATE(841)] = 44021,
  [SMALL_STATE(842)] = 44034,
  [SMALL_STATE(843)] = 44043,
  [SMALL_STATE(844)] = 44056,
  [SMALL_STATE(845)] = 44067,
  [SMALL_STATE(846)] = 44080,
  [SMALL_STATE(847)] = 44093,
  [SMALL_STATE(848)] = 44106,
  [SMALL_STATE(849)] = 44119,
  [SMALL_STATE(850)] = 44130,
  [SMALL_STATE(851)] = 44140,
  [SMALL_STATE(852)] = 44148,
  [SMALL_STATE(853)] = 44158,
  [SMALL_STATE(854)] = 44168,
  [SMALL_STATE(855)] = 44178,
  [SMALL_STATE(856)] = 44188,
  [SMALL_STATE(857)] = 44198,
  [SMALL_STATE(858)] = 44208,
  [SMALL_STATE(859)] = 44218,
  [SMALL_STATE(860)] = 44226,
  [SMALL_STATE(861)] = 44236,
  [SMALL_STATE(862)] = 44246,
  [SMALL_STATE(863)] = 44256,
  [SMALL_STATE(864)] = 44266,
  [SMALL_STATE(865)] = 44276,
  [SMALL_STATE(866)] = 44286,
  [SMALL_STATE(867)] = 44294,
  [SMALL_STATE(868)] = 44304,
  [SMALL_STATE(869)] = 44312,
  [SMALL_STATE(870)] = 44322,
  [SMALL_STATE(871)] = 44332,
  [SMALL_STATE(872)] = 44342,
  [SMALL_STATE(873)] = 44350,
  [SMALL_STATE(874)] = 44360,
  [SMALL_STATE(875)] = 44370,
  [SMALL_STATE(876)] = 44378,
  [SMALL_STATE(877)] = 44386,
  [SMALL_STATE(878)] = 44394,
  [SMALL_STATE(879)] = 44402,
  [SMALL_STATE(880)] = 44410,
  [SMALL_STATE(881)] = 44418,
  [SMALL_STATE(882)] = 44426,
  [SMALL_STATE(883)] = 44434,
  [SMALL_STATE(884)] = 44442,
  [SMALL_STATE(885)] = 44450,
  [SMALL_STATE(886)] = 44460,
  [SMALL_STATE(887)] = 44468,
  [SMALL_STATE(888)] = 44476,
  [SMALL_STATE(889)] = 44486,
  [SMALL_STATE(890)] = 44493,
  [SMALL_STATE(891)] = 44500,
  [SMALL_STATE(892)] = 44507,
  [SMALL_STATE(893)] = 44514,
  [SMALL_STATE(894)] = 44521,
  [SMALL_STATE(895)] = 44528,
  [SMALL_STATE(896)] = 44535,
  [SMALL_STATE(897)] = 44542,
  [SMALL_STATE(898)] = 44549,
  [SMALL_STATE(899)] = 44556,
  [SMALL_STATE(900)] = 44563,
  [SMALL_STATE(901)] = 44570,
  [SMALL_STATE(902)] = 44577,
  [SMALL_STATE(903)] = 44584,
  [SMALL_STATE(904)] = 44591,
  [SMALL_STATE(905)] = 44598,
  [SMALL_STATE(906)] = 44605,
  [SMALL_STATE(907)] = 44612,
  [SMALL_STATE(908)] = 44619,
  [SMALL_STATE(909)] = 44626,
  [SMALL_STATE(910)] = 44633,
  [SMALL_STATE(911)] = 44640,
  [SMALL_STATE(912)] = 44647,
  [SMALL_STATE(913)] = 44654,
  [SMALL_STATE(914)] = 44661,
  [SMALL_STATE(915)] = 44668,
  [SMALL_STATE(916)] = 44675,
  [SMALL_STATE(917)] = 44682,
  [SMALL_STATE(918)] = 44689,
  [SMALL_STATE(919)] = 44696,
  [SMALL_STATE(920)] = 44703,
  [SMALL_STATE(921)] = 44710,
  [SMALL_STATE(922)] = 44717,
  [SMALL_STATE(923)] = 44724,
  [SMALL_STATE(924)] = 44731,
  [SMALL_STATE(925)] = 44738,
  [SMALL_STATE(926)] = 44745,
  [SMALL_STATE(927)] = 44752,
  [SMALL_STATE(928)] = 44759,
  [SMALL_STATE(929)] = 44766,
  [SMALL_STATE(930)] = 44773,
  [SMALL_STATE(931)] = 44780,
  [SMALL_STATE(932)] = 44787,
  [SMALL_STATE(933)] = 44794,
  [SMALL_STATE(934)] = 44801,
  [SMALL_STATE(935)] = 44808,
  [SMALL_STATE(936)] = 44815,
  [SMALL_STATE(937)] = 44822,
  [SMALL_STATE(938)] = 44829,
  [SMALL_STATE(939)] = 44836,
  [SMALL_STATE(940)] = 44843,
  [SMALL_STATE(941)] = 44850,
  [SMALL_STATE(942)] = 44857,
  [SMALL_STATE(943)] = 44864,
  [SMALL_STATE(944)] = 44871,
  [SMALL_STATE(945)] = 44878,
  [SMALL_STATE(946)] = 44885,
  [SMALL_STATE(947)] = 44892,
  [SMALL_STATE(948)] = 44899,
  [SMALL_STATE(949)] = 44906,
  [SMALL_STATE(950)] = 44913,
  [SMALL_STATE(951)] = 44920,
  [SMALL_STATE(952)] = 44927,
  [SMALL_STATE(953)] = 44934,
  [SMALL_STATE(954)] = 44941,
  [SMALL_STATE(955)] = 44948,
  [SMALL_STATE(956)] = 44955,
  [SMALL_STATE(957)] = 44962,
  [SMALL_STATE(958)] = 44969,
  [SMALL_STATE(959)] = 44976,
  [SMALL_STATE(960)] = 44983,
  [SMALL_STATE(961)] = 44990,
  [SMALL_STATE(962)] = 44997,
  [SMALL_STATE(963)] = 45004,
  [SMALL_STATE(964)] = 45011,
  [SMALL_STATE(965)] = 45018,
  [SMALL_STATE(966)] = 45025,
  [SMALL_STATE(967)] = 45032,
  [SMALL_STATE(968)] = 45039,
  [SMALL_STATE(969)] = 45046,
  [SMALL_STATE(970)] = 45053,
  [SMALL_STATE(971)] = 45060,
  [SMALL_STATE(972)] = 45067,
  [SMALL_STATE(973)] = 45074,
  [SMALL_STATE(974)] = 45081,
  [SMALL_STATE(975)] = 45088,
  [SMALL_STATE(976)] = 45095,
  [SMALL_STATE(977)] = 45102,
  [SMALL_STATE(978)] = 45109,
  [SMALL_STATE(979)] = 45116,
  [SMALL_STATE(980)] = 45123,
  [SMALL_STATE(981)] = 45130,
  [SMALL_STATE(982)] = 45137,
  [SMALL_STATE(983)] = 45144,
  [SMALL_STATE(984)] = 45151,
  [SMALL_STATE(985)] = 45158,
  [SMALL_STATE(986)] = 45165,
  [SMALL_STATE(987)] = 45172,
  [SMALL_STATE(988)] = 45179,
  [SMALL_STATE(989)] = 45186,
  [SMALL_STATE(990)] = 45193,
  [SMALL_STATE(991)] = 45200,
  [SMALL_STATE(992)] = 45207,
  [SMALL_STATE(993)] = 45214,
  [SMALL_STATE(994)] = 45221,
  [SMALL_STATE(995)] = 45228,
  [SMALL_STATE(996)] = 45235,
  [SMALL_STATE(997)] = 45242,
  [SMALL_STATE(998)] = 45249,
  [SMALL_STATE(999)] = 45256,
  [SMALL_STATE(1000)] = 45263,
  [SMALL_STATE(1001)] = 45270,
  [SMALL_STATE(1002)] = 45277,
  [SMALL_STATE(1003)] = 45284,
  [SMALL_STATE(1004)] = 45291,
  [SMALL_STATE(1005)] = 45298,
  [SMALL_STATE(1006)] = 45305,
  [SMALL_STATE(1007)] = 45312,
  [SMALL_STATE(1008)] = 45319,
  [SMALL_STATE(1009)] = 45326,
  [SMALL_STATE(1010)] = 45333,
  [SMALL_STATE(1011)] = 45340,
  [SMALL_STATE(1012)] = 45347,
  [SMALL_STATE(1013)] = 45354,
  [SMALL_STATE(1014)] = 45361,
  [SMALL_STATE(1015)] = 45368,
  [SMALL_STATE(1016)] = 45375,
  [SMALL_STATE(1017)] = 45382,
  [SMALL_STATE(1018)] = 45389,
  [SMALL_STATE(1019)] = 45396,
  [SMALL_STATE(1020)] = 45403,
  [SMALL_STATE(1021)] = 45410,
  [SMALL_STATE(1022)] = 45417,
  [SMALL_STATE(1023)] = 45424,
  [SMALL_STATE(1024)] = 45431,
  [SMALL_STATE(1025)] = 45438,
  [SMALL_STATE(1026)] = 45445,
  [SMALL_STATE(1027)] = 45452,
  [SMALL_STATE(1028)] = 45459,
  [SMALL_STATE(1029)] = 45466,
  [SMALL_STATE(1030)] = 45473,
  [SMALL_STATE(1031)] = 45480,
  [SMALL_STATE(1032)] = 45487,
  [SMALL_STATE(1033)] = 45494,
  [SMALL_STATE(1034)] = 45501,
  [SMALL_STATE(1035)] = 45508,
  [SMALL_STATE(1036)] = 45515,
  [SMALL_STATE(1037)] = 45522,
  [SMALL_STATE(1038)] = 45529,
  [SMALL_STATE(1039)] = 45536,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(217),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(727),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(730),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(1018),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(867),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(807),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(470),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(986),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(710),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(689),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(734),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(970),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(860),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(821),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(463),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(911),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(856),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(983),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(949),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(536),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(950),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(950),
  [97] = {.entry = {.count = 1, .reusable = false}}, SHIFT(951),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(951),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(952),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(953),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(962),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(715),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(640),
  [115] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_infix_expr, 1),
  [117] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_infix_expr, 1),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1007),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(973),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(1005),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(945),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(926),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(904),
  [141] = {.entry 