#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 920
#define LARGE_STATE_COUNT 351
#define SYMBOL_COUNT 203
#define ALIAS_COUNT 4
#define TOKEN_COUNT 91
#define EXTERNAL_TOKEN_COUNT 47
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 13
#define PRODUCTION_ID_COUNT 11

enum {
  sym__backslash_escape = 1,
  sym_entity_reference = 2,
  sym_numeric_character_reference = 3,
  anon_sym_LBRACK = 4,
  anon_sym_RBRACK = 5,
  anon_sym_LT = 6,
  anon_sym_GT = 7,
  anon_sym_BANG = 8,
  anon_sym_DQUOTE = 9,
  anon_sym_POUND = 10,
  anon_sym_DOLLAR = 11,
  anon_sym_PERCENT = 12,
  anon_sym_AMP = 13,
  anon_sym_SQUOTE = 14,
  anon_sym_STAR = 15,
  anon_sym_PLUS = 16,
  anon_sym_COMMA = 17,
  anon_sym_DASH = 18,
  anon_sym_DOT = 19,
  anon_sym_SLASH = 20,
  anon_sym_COLON = 21,
  anon_sym_SEMI = 22,
  anon_sym_EQ = 23,
  anon_sym_QMARK = 24,
  anon_sym_AT = 25,
  anon_sym_BSLASH = 26,
  anon_sym_CARET = 27,
  anon_sym__ = 28,
  anon_sym_BQUOTE = 29,
  anon_sym_LBRACE = 30,
  anon_sym_PIPE = 31,
  anon_sym_RBRACE = 32,
  anon_sym_TILDE = 33,
  anon_sym_LPAREN = 34,
  anon_sym_RPAREN = 35,
  sym__newline_token = 36,
  anon_sym_DASH_DASH_GT = 37,
  anon_sym_QMARK_GT = 38,
  anon_sym_RBRACK_RBRACK_GT = 39,
  aux_sym__word_token1 = 40,
  anon_sym_LBRACKx_RBRACK = 41,
  aux_sym__word_token2 = 42,
  sym__whitespace = 43,
  sym__line_ending = 44,
  sym__soft_line_ending = 45,
  sym__block_close = 46,
  sym_block_continuation = 47,
  sym__block_quote_start = 48,
  sym__indented_chunk_start = 49,
  sym_atx_h1_marker = 50,
  sym_atx_h2_marker = 51,
  sym_atx_h3_marker = 52,
  sym_atx_h4_marker = 53,
  sym_atx_h5_marker = 54,
  sym_atx_h6_marker = 55,
  sym_setext_h1_underline = 56,
  sym_setext_h2_underline = 57,
  sym__thematic_break = 58,
  sym__list_marker_minus = 59,
  sym__list_marker_plus = 60,
  sym__list_marker_star = 61,
  sym__list_marker_parenthesis = 62,
  sym__list_marker_dot = 63,
  sym__list_marker_minus_dont_interrupt = 64,
  sym__list_marker_plus_dont_interrupt = 65,
  sym__list_marker_star_dont_interrupt = 66,
  sym__list_marker_parenthesis_dont_interrupt = 67,
  sym__list_marker_dot_dont_interrupt = 68,
  sym__fenced_code_block_start_backtick = 69,
  sym__fenced_code_block_start_tilde = 70,
  sym__blank_line_start = 71,
  sym__fenced_code_block_end_backtick = 72,
  sym__fenced_code_block_end_tilde = 73,
  sym__html_block_1_start = 74,
  sym__html_block_1_end = 75,
  sym__html_block_2_start = 76,
  sym__html_block_3_start = 77,
  sym__html_block_4_start = 78,
  sym__html_block_5_start = 79,
  sym__html_block_6_start = 80,
  sym__html_block_7_start = 81,
  sym__close_block = 82,
  sym__no_indented_chunk = 83,
  sym__error = 84,
  sym__trigger_error = 85,
  sym__eof = 86,
  sym_minus_metadata = 87,
  sym_plus_metadata = 88,
  sym__pipe_table_start = 89,
  sym__pipe_table_line_ending = 90,
  sym_document = 91,
  sym_backslash_escape = 92,
  sym_link_label = 93,
  sym_link_destination = 94,
  sym__link_destination_parenthesis = 95,
  sym__text_no_angle = 96,
  sym_link_title = 97,
  sym__last_token_punctuation = 98,
  sym__block = 99,
  sym__block_not_section = 100,
  sym_section = 101,
  sym__section1 = 102,
  sym__section2 = 103,
  sym__section3 = 104,
  sym__section4 = 105,
  sym__section5 = 106,
  sym__section6 = 107,
  sym_thematic_break = 108,
  sym__atx_heading1 = 109,
  sym__atx_heading2 = 110,
  sym__atx_heading3 = 111,
  sym__atx_heading4 = 112,
  sym__atx_heading5 = 113,
  sym__atx_heading6 = 114,
  sym__setext_heading1 = 115,
  sym__setext_heading2 = 116,
  sym_indented_code_block = 117,
  sym__indented_chunk = 118,
  sym_fenced_code_block = 119,
  sym_code_fence_content = 120,
  sym_info_string = 121,
  sym_language = 122,
  sym_html_block = 123,
  sym__html_block_1 = 124,
  sym__html_block_2 = 125,
  sym__html_block_3 = 126,
  sym__html_block_4 = 127,
  sym__html_block_5 = 128,
  sym__html_block_6 = 129,
  sym__html_block_7 = 130,
  sym_link_reference_definition = 131,
  sym__text_inline_no_link = 132,
  sym_paragraph = 133,
  sym__blank_line = 134,
  sym_block_quote = 135,
  sym_list = 136,
  sym__list_plus = 137,
  sym__list_minus = 138,
  sym__list_star = 139,
  sym__list_dot = 140,
  sym__list_parenthesis = 141,
  sym_list_marker_plus = 142,
  sym_list_marker_minus = 143,
  sym_list_marker_star = 144,
  sym_list_marker_dot = 145,
  sym_list_marker_parenthesis = 146,
  sym__list_item_plus = 147,
  sym__list_item_minus = 148,
  sym__list_item_star = 149,
  sym__list_item_dot = 150,
  sym__list_item_parenthesis = 151,
  sym__list_item_content = 152,
  sym__newline = 153,
  sym__soft_line_break = 154,
  sym__line = 155,
  sym__word = 156,
  sym_task_list_marker_checked = 157,
  sym_task_list_marker_unchecked = 158,
  sym_pipe_table = 159,
  sym__pipe_table_newline = 160,
  sym_pipe_table_delimiter_row = 161,
  sym_pipe_table_delimiter_cell = 162,
  sym_pipe_table_row = 163,
  sym_pipe_table_cell = 164,
  aux_sym_document_repeat1 = 165,
  aux_sym_document_repeat2 = 166,
  aux_sym_link_label_repeat1 = 167,
  aux_sym_link_destination_repeat1 = 168,
  aux_sym_link_destination_repeat2 = 169,
  aux_sym_link_title_repeat1 = 170,
  aux_sym_link_title_repeat2 = 171,
  aux_sym_link_title_repeat3 = 172,
  aux_sym__section1_repeat1 = 173,
  aux_sym__section2_repeat1 = 174,
  aux_sym__section3_repeat1 = 175,
  aux_sym__section4_repeat1 = 176,
  aux_sym__section5_repeat1 = 177,
  aux_sym_indented_code_block_repeat1 = 178,
  aux_sym__indented_chunk_repeat1 = 179,
  aux_sym_code_fence_content_repeat1 = 180,
  aux_sym_info_string_repeat1 = 181,
  aux_sym_info_string_repeat2 = 182,
  aux_sym_language_repeat1 = 183,
  aux_sym__html_block_1_repeat1 = 184,
  aux_sym__html_block_2_repeat1 = 185,
  aux_sym__html_block_3_repeat1 = 186,
  aux_sym__html_block_4_repeat1 = 187,
  aux_sym__html_block_5_repeat1 = 188,
  aux_sym__html_block_6_repeat1 = 189,
  aux_sym_paragraph_repeat1 = 190,
  aux_sym_block_quote_repeat1 = 191,
  aux_sym__list_plus_repeat1 = 192,
  aux_sym__list_minus_repeat1 = 193,
  aux_sym__list_star_repeat1 = 194,
  aux_sym__list_dot_repeat1 = 195,
  aux_sym__list_parenthesis_repeat1 = 196,
  aux_sym__line_repeat1 = 197,
  aux_sym_pipe_table_repeat1 = 198,
  aux_sym_pipe_table_delimiter_row_repeat1 = 199,
  aux_sym_pipe_table_delimiter_cell_repeat1 = 200,
  aux_sym_pipe_table_row_repeat1 = 201,
  aux_sym_pipe_table_cell_repeat1 = 202,
  alias_sym_inline = 203,
  alias_sym_pipe_table_align_left = 204,
  alias_sym_pipe_table_align_right = 205,
  alias_sym_pipe_table_header = 206,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__backslash_escape] = "_backslash_escape",
  [sym_entity_reference] = "entity_reference",
  [sym_numeric_character_reference] = "numeric_character_reference",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_BANG] = "!",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_PERCENT] = "%",
  [anon_sym_AMP] = "&",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_STAR] = "*",
  [anon_sym_PLUS] = "+",
  [anon_sym_COMMA] = ",",
  [anon_sym_DASH] = "-",
  [anon_sym_DOT] = ".",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AT] = "@",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_CARET] = "^",
  [anon_sym__] = "_",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LBRACE] = "{",
  [anon_sym_PIPE] = "|",
  [anon_sym_RBRACE] = "}",
  [anon_sym_TILDE] = "~",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym__newline_token] = "_newline_token",
  [anon_sym_DASH_DASH_GT] = "-->",
  [anon_sym_QMARK_GT] = "\?>",
  [anon_sym_RBRACK_RBRACK_GT] = "]]>",
  [aux_sym__word_token1] = "_word_token1",
  [anon_sym_LBRACKx_RBRACK] = "[x]",
  [aux_sym__word_token2] = "_word_token2",
  [sym__whitespace] = "_whitespace",
  [sym__line_ending] = "_line_ending",
  [sym__soft_line_ending] = "_soft_line_ending",
  [sym__block_close] = "_block_close",
  [sym_block_continuation] = "block_continuation",
  [sym__block_quote_start] = "block_quote_marker",
  [sym__indented_chunk_start] = "_indented_chunk_start",
  [sym_atx_h1_marker] = "atx_h1_marker",
  [sym_atx_h2_marker] = "atx_h2_marker",
  [sym_atx_h3_marker] = "atx_h3_marker",
  [sym_atx_h4_marker] = "atx_h4_marker",
  [sym_atx_h5_marker] = "atx_h5_marker",
  [sym_atx_h6_marker] = "atx_h6_marker",
  [sym_setext_h1_underline] = "setext_h1_underline",
  [sym_setext_h2_underline] = "setext_h2_underline",
  [sym__thematic_break] = "_thematic_break",
  [sym__list_marker_minus] = "_list_marker_minus",
  [sym__list_marker_plus] = "_list_marker_plus",
  [sym__list_marker_star] = "_list_marker_star",
  [sym__list_marker_parenthesis] = "_list_marker_parenthesis",
  [sym__list_marker_dot] = "_list_marker_dot",
  [sym__list_marker_minus_dont_interrupt] = "_list_marker_minus_dont_interrupt",
  [sym__list_marker_plus_dont_interrupt] = "_list_marker_plus_dont_interrupt",
  [sym__list_marker_star_dont_interrupt] = "_list_marker_star_dont_interrupt",
  [sym__list_marker_parenthesis_dont_interrupt] = "_list_marker_parenthesis_dont_interrupt",
  [sym__list_marker_dot_dont_interrupt] = "_list_marker_dot_dont_interrupt",
  [sym__fenced_code_block_start_backtick] = "fenced_code_block_delimiter",
  [sym__fenced_code_block_start_tilde] = "fenced_code_block_delimiter",
  [sym__blank_line_start] = "_blank_line_start",
  [sym__fenced_code_block_end_backtick] = "fenced_code_block_delimiter",
  [sym__fenced_code_block_end_tilde] = "fenced_code_block_delimiter",
  [sym__html_block_1_start] = "_html_block_1_start",
  [sym__html_block_1_end] = "_html_block_1_end",
  [sym__html_block_2_start] = "_html_block_2_start",
  [sym__html_block_3_start] = "_html_block_3_start",
  [sym__html_block_4_start] = "_html_block_4_start",
  [sym__html_block_5_start] = "_html_block_5_start",
  [sym__html_block_6_start] = "_html_block_6_start",
  [sym__html_block_7_start] = "_html_block_7_start",
  [sym__close_block] = "_close_block",
  [sym__no_indented_chunk] = "_no_indented_chunk",
  [sym__error] = "_error",
  [sym__trigger_error] = "_trigger_error",
  [sym__eof] = "_eof",
  [sym_minus_metadata] = "minus_metadata",
  [sym_plus_metadata] = "plus_metadata",
  [sym__pipe_table_start] = "_pipe_table_start",
  [sym__pipe_table_line_ending] = "_pipe_table_line_ending",
  [sym_document] = "document",
  [sym_backslash_escape] = "backslash_escape",
  [sym_link_label] = "link_label",
  [sym_link_destination] = "link_destination",
  [sym__link_destination_parenthesis] = "_link_destination_parenthesis",
  [sym__text_no_angle] = "_text_no_angle",
  [sym_link_title] = "link_title",
  [sym__last_token_punctuation] = "_last_token_punctuation",
  [sym__block] = "_block",
  [sym__block_not_section] = "_block_not_section",
  [sym_section] = "section",
  [sym__section1] = "_section1",
  [sym__section2] = "_section2",
  [sym__section3] = "_section3",
  [sym__section4] = "_section4",
  [sym__section5] = "_section5",
  [sym__section6] = "_section6",
  [sym_thematic_break] = "thematic_break",
  [sym__atx_heading1] = "atx_heading",
  [sym__atx_heading2] = "atx_heading",
  [sym__atx_heading3] = "atx_heading",
  [sym__atx_heading4] = "atx_heading",
  [sym__atx_heading5] = "atx_heading",
  [sym__atx_heading6] = "atx_heading",
  [sym__setext_heading1] = "setext_heading",
  [sym__setext_heading2] = "setext_heading",
  [sym_indented_code_block] = "indented_code_block",
  [sym__indented_chunk] = "_indented_chunk",
  [sym_fenced_code_block] = "fenced_code_block",
  [sym_code_fence_content] = "code_fence_content",
  [sym_info_string] = "info_string",
  [sym_language] = "language",
  [sym_html_block] = "html_block",
  [sym__html_block_1] = "_html_block_1",
  [sym__html_block_2] = "_html_block_2",
  [sym__html_block_3] = "_html_block_3",
  [sym__html_block_4] = "_html_block_4",
  [sym__html_block_5] = "_html_block_5",
  [sym__html_block_6] = "_html_block_6",
  [sym__html_block_7] = "_html_block_7",
  [sym_link_reference_definition] = "link_reference_definition",
  [sym__text_inline_no_link] = "_text_inline_no_link",
  [sym_paragraph] = "paragraph",
  [sym__blank_line] = "_blank_line",
  [sym_block_quote] = "block_quote",
  [sym_list] = "list",
  [sym__list_plus] = "_list_plus",
  [sym__list_minus] = "_list_minus",
  [sym__list_star] = "_list_star",
  [sym__list_dot] = "_list_dot",
  [sym__list_parenthesis] = "_list_parenthesis",
  [sym_list_marker_plus] = "list_marker_plus",
  [sym_list_marker_minus] = "list_marker_minus",
  [sym_list_marker_star] = "list_marker_star",
  [sym_list_marker_dot] = "list_marker_dot",
  [sym_list_marker_parenthesis] = "list_marker_parenthesis",
  [sym__list_item_plus] = "list_item",
  [sym__list_item_minus] = "list_item",
  [sym__list_item_star] = "list_item",
  [sym__list_item_dot] = "list_item",
  [sym__list_item_parenthesis] = "list_item",
  [sym__list_item_content] = "_list_item_content",
  [sym__newline] = "_newline",
  [sym__soft_line_break] = "_soft_line_break",
  [sym__line] = "_line",
  [sym__word] = "_word",
  [sym_task_list_marker_checked] = "task_list_marker_checked",
  [sym_task_list_marker_unchecked] = "task_list_marker_unchecked",
  [sym_pipe_table] = "pipe_table",
  [sym__pipe_table_newline] = "_pipe_table_newline",
  [sym_pipe_table_delimiter_row] = "pipe_table_delimiter_row",
  [sym_pipe_table_delimiter_cell] = "pipe_table_delimiter_cell",
  [sym_pipe_table_row] = "pipe_table_row",
  [sym_pipe_table_cell] = "pipe_table_cell",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_document_repeat2] = "document_repeat2",
  [aux_sym_link_label_repeat1] = "link_label_repeat1",
  [aux_sym_link_destination_repeat1] = "link_destination_repeat1",
  [aux_sym_link_destination_repeat2] = "link_destination_repeat2",
  [aux_sym_link_title_repeat1] = "link_title_repeat1",
  [aux_sym_link_title_repeat2] = "link_title_repeat2",
  [aux_sym_link_title_repeat3] = "link_title_repeat3",
  [aux_sym__section1_repeat1] = "_section1_repeat1",
  [aux_sym__section2_repeat1] = "_section2_repeat1",
  [aux_sym__section3_repeat1] = "_section3_repeat1",
  [aux_sym__section4_repeat1] = "_section4_repeat1",
  [aux_sym__section5_repeat1] = "_section5_repeat1",
  [aux_sym_indented_code_block_repeat1] = "indented_code_block_repeat1",
  [aux_sym__indented_chunk_repeat1] = "_indented_chunk_repeat1",
  [aux_sym_code_fence_content_repeat1] = "code_fence_content_repeat1",
  [aux_sym_info_string_repeat1] = "info_string_repeat1",
  [aux_sym_info_string_repeat2] = "info_string_repeat2",
  [aux_sym_language_repeat1] = "language_repeat1",
  [aux_sym__html_block_1_repeat1] = "_html_block_1_repeat1",
  [aux_sym__html_block_2_repeat1] = "_html_block_2_repeat1",
  [aux_sym__html_block_3_repeat1] = "_html_block_3_repeat1",
  [aux_sym__html_block_4_repeat1] = "_html_block_4_repeat1",
  [aux_sym__html_block_5_repeat1] = "_html_block_5_repeat1",
  [aux_sym__html_block_6_repeat1] = "_html_block_6_repeat1",
  [aux_sym_paragraph_repeat1] = "paragraph_repeat1",
  [aux_sym_block_quote_repeat1] = "block_quote_repeat1",
  [aux_sym__list_plus_repeat1] = "_list_plus_repeat1",
  [aux_sym__list_minus_repeat1] = "_list_minus_repeat1",
  [aux_sym__list_star_repeat1] = "_list_star_repeat1",
  [aux_sym__list_dot_repeat1] = "_list_dot_repeat1",
  [aux_sym__list_parenthesis_repeat1] = "_list_parenthesis_repeat1",
  [aux_sym__line_repeat1] = "_line_repeat1",
  [aux_sym_pipe_table_repeat1] = "pipe_table_repeat1",
  [aux_sym_pipe_table_delimiter_row_repeat1] = "pipe_table_delimiter_row_repeat1",
  [aux_sym_pipe_table_delimiter_cell_repeat1] = "pipe_table_delimiter_cell_repeat1",
  [aux_sym_pipe_table_row_repeat1] = "pipe_table_row_repeat1",
  [aux_sym_pipe_table_cell_repeat1] = "pipe_table_cell_repeat1",
  [alias_sym_inline] = "inline",
  [alias_sym_pipe_table_align_left] = "pipe_table_align_left",
  [alias_sym_pipe_table_align_right] = "pipe_table_align_right",
  [alias_sym_pipe_table_header] = "pipe_table_header",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__backslash_escape] = sym__backslash_escape,
  [sym_entity_reference] = sym_entity_reference,
  [sym_numeric_character_reference] = sym_numeric_character_reference,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym__] = anon_sym__,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym__newline_token] = sym__newline_token,
  [anon_sym_DASH_DASH_GT] = anon_sym_DASH_DASH_GT,
  [anon_sym_QMARK_GT] = anon_sym_QMARK_GT,
  [anon_sym_RBRACK_RBRACK_GT] = anon_sym_RBRACK_RBRACK_GT,
  [aux_sym__word_token1] = aux_sym__word_token1,
  [anon_sym_LBRACKx_RBRACK] = anon_sym_LBRACKx_RBRACK,
  [aux_sym__word_token2] = aux_sym__word_token2,
  [sym__whitespace] = sym__whitespace,
  [sym__line_ending] = sym__line_ending,
  [sym__soft_line_ending] = sym__soft_line_ending,
  [sym__block_close] = sym__block_close,
  [sym_block_continuation] = sym_block_continuation,
  [sym__block_quote_start] = sym__block_quote_start,
  [sym__indented_chunk_start] = sym__indented_chunk_start,
  [sym_atx_h1_marker] = sym_atx_h1_marker,
  [sym_atx_h2_marker] = sym_atx_h2_marker,
  [sym_atx_h3_marker] = sym_atx_h3_marker,
  [sym_atx_h4_marker] = sym_atx_h4_marker,
  [sym_atx_h5_marker] = sym_atx_h5_marker,
  [sym_atx_h6_marker] = sym_atx_h6_marker,
  [sym_setext_h1_underline] = sym_setext_h1_underline,
  [sym_setext_h2_underline] = sym_setext_h2_underline,
  [sym__thematic_break] = sym__thematic_break,
  [sym__list_marker_minus] = sym__list_marker_minus,
  [sym__list_marker_plus] = sym__list_marker_plus,
  [sym__list_marker_star] = sym__list_marker_star,
  [sym__list_marker_parenthesis] = sym__list_marker_parenthesis,
  [sym__list_marker_dot] = sym__list_marker_dot,
  [sym__list_marker_minus_dont_interrupt] = sym__list_marker_minus_dont_interrupt,
  [sym__list_marker_plus_dont_interrupt] = sym__list_marker_plus_dont_interrupt,
  [sym__list_marker_star_dont_interrupt] = sym__list_marker_star_dont_interrupt,
  [sym__list_marker_parenthesis_dont_interrupt] = sym__list_marker_parenthesis_dont_interrupt,
  [sym__list_marker_dot_dont_interrupt] = sym__list_marker_dot_dont_interrupt,
  [sym__fenced_code_block_start_backtick] = sym__fenced_code_block_start_backtick,
  [sym__fenced_code_block_start_tilde] = sym__fenced_code_block_start_backtick,
  [sym__blank_line_start] = sym__blank_line_start,
  [sym__fenced_code_block_end_backtick] = sym__fenced_code_block_start_backtick,
  [sym__fenced_code_block_end_tilde] = sym__fenced_code_block_start_backtick,
  [sym__html_block_1_start] = sym__html_block_1_start,
  [sym__html_block_1_end] = sym__html_block_1_end,
  [sym__html_block_2_start] = sym__html_block_2_start,
  [sym__html_block_3_start] = sym__html_block_3_start,
  [sym__html_block_4_start] = sym__html_block_4_start,
  [sym__html_block_5_start] = sym__html_block_5_start,
  [sym__html_block_6_start] = sym__html_block_6_start,
  [sym__html_block_7_start] = sym__html_block_7_start,
  [sym__close_block] = sym__close_block,
  [sym__no_indented_chunk] = sym__no_indented_chunk,
  [sym__error] = sym__error,
  [sym__trigger_error] = sym__trigger_error,
  [sym__eof] = sym__eof,
  [sym_minus_metadata] = sym_minus_metadata,
  [sym_plus_metadata] = sym_plus_metadata,
  [sym__pipe_table_start] = sym__pipe_table_start,
  [sym__pipe_table_line_ending] = sym__pipe_table_line_ending,
  [sym_document] = sym_document,
  [sym_backslash_escape] = sym_backslash_escape,
  [sym_link_label] = sym_link_label,
  [sym_link_destination] = sym_link_destination,
  [sym__link_destination_parenthesis] = sym__link_destination_parenthesis,
  [sym__text_no_angle] = sym__text_no_angle,
  [sym_link_title] = sym_link_title,
  [sym__last_token_punctuation] = sym__last_token_punctuation,
  [sym__block] = sym__block,
  [sym__block_not_section] = sym__block_not_section,
  [sym_section] = sym_section,
  [sym__section1] = sym__section1,
  [sym__section2] = sym__section2,
  [sym__section3] = sym__section3,
  [sym__section4] = sym__section4,
  [sym__section5] = sym__section5,
  [sym__section6] = sym__section6,
  [sym_thematic_break] = sym_thematic_break,
  [sym__atx_heading1] = sym__atx_heading1,
  [sym__atx_heading2] = sym__atx_heading1,
  [sym__atx_heading3] = sym__atx_heading1,
  [sym__atx_heading4] = sym__atx_heading1,
  [sym__atx_heading5] = sym__atx_heading1,
  [sym__atx_heading6] = sym__atx_heading1,
  [sym__setext_heading1] = sym__setext_heading1,
  [sym__setext_heading2] = sym__setext_heading1,
  [sym_indented_code_block] = sym_indented_code_block,
  [sym__indented_chunk] = sym__indented_chunk,
  [sym_fenced_code_block] = sym_fenced_code_block,
  [sym_code_fence_content] = sym_code_fence_content,
  [sym_info_string] = sym_info_string,
  [sym_language] = sym_language,
  [sym_html_block] = sym_html_block,
  [sym__html_block_1] = sym__html_block_1,
  [sym__html_block_2] = sym__html_block_2,
  [sym__html_block_3] = sym__html_block_3,
  [sym__html_block_4] = sym__html_block_4,
  [sym__html_block_5] = sym__html_block_5,
  [sym__html_block_6] = sym__html_block_6,
  [sym__html_block_7] = sym__html_block_7,
  [sym_link_reference_definition] = sym_link_reference_definition,
  [sym__text_inline_no_link] = sym__text_inline_no_link,
  [sym_paragraph] = sym_paragraph,
  [sym__blank_line] = sym__blank_line,
  [sym_block_quote] = sym_block_quote,
  [sym_list] = sym_list,
  [sym__list_plus] = sym__list_plus,
  [sym__list_minus] = sym__list_minus,
  [sym__list_star] = sym__list_star,
  [sym__list_dot] = sym__list_dot,
  [sym__list_parenthesis] = sym__list_parenthesis,
  [sym_list_marker_plus] = sym_list_marker_plus,
  [sym_list_marker_minus] = sym_list_marker_minus,
  [sym_list_marker_star] = sym_list_marker_star,
  [sym_list_marker_dot] = sym_list_marker_dot,
  [sym_list_marker_parenthesis] = sym_list_marker_parenthesis,
  [sym__list_item_plus] = sym__list_item_plus,
  [sym__list_item_minus] = sym__list_item_plus,
  [sym__list_item_star] = sym__list_item_plus,
  [sym__list_item_dot] = sym__list_item_plus,
  [sym__list_item_parenthesis] = sym__list_item_plus,
  [sym__list_item_content] = sym__list_item_content,
  [sym__newline] = sym__newline,
  [sym__soft_line_break] = sym__soft_line_break,
  [sym__line] = sym__line,
  [sym__word] = sym__word,
  [sym_task_list_marker_checked] = sym_task_list_marker_checked,
  [sym_task_list_marker_unchecked] = sym_task_list_marker_unchecked,
  [sym_pipe_table] = sym_pipe_table,
  [sym__pipe_table_newline] = sym__pipe_table_newline,
  [sym_pipe_table_delimiter_row] = sym_pipe_table_delimiter_row,
  [sym_pipe_table_delimiter_cell] = sym_pipe_table_delimiter_cell,
  [sym_pipe_table_row] = sym_pipe_table_row,
  [sym_pipe_table_cell] = sym_pipe_table_cell,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_document_repeat2] = aux_sym_document_repeat2,
  [aux_sym_link_label_repeat1] = aux_sym_link_label_repeat1,
  [aux_sym_link_destination_repeat1] = aux_sym_link_destination_repeat1,
  [aux_sym_link_destination_repeat2] = aux_sym_link_destination_repeat2,
  [aux_sym_link_title_repeat1] = aux_sym_link_title_repeat1,
  [aux_sym_link_title_repeat2] = aux_sym_link_title_repeat2,
  [aux_sym_link_title_repeat3] = aux_sym_link_title_repeat3,
  [aux_sym__section1_repeat1] = aux_sym__section1_repeat1,
  [aux_sym__section2_repeat1] = aux_sym__section2_repeat1,
  [aux_sym__section3_repeat1] = aux_sym__section3_repeat1,
  [aux_sym__section4_repeat1] = aux_sym__section4_repeat1,
  [aux_sym__section5_repeat1] = aux_sym__section5_repeat1,
  [aux_sym_indented_code_block_repeat1] = aux_sym_indented_code_block_repeat1,
  [aux_sym__indented_chunk_repeat1] = aux_sym__indented_chunk_repeat1,
  [aux_sym_code_fence_content_repeat1] = aux_sym_code_fence_content_repeat1,
  [aux_sym_info_string_repeat1] = aux_sym_info_string_repeat1,
  [aux_sym_info_string_repeat2] = aux_sym_info_string_repeat2,
  [aux_sym_language_repeat1] = aux_sym_language_repeat1,
  [aux_sym__html_block_1_repeat1] = aux_sym__html_block_1_repeat1,
  [aux_sym__html_block_2_repeat1] = aux_sym__html_block_2_repeat1,
  [aux_sym__html_block_3_repeat1] = aux_sym__html_block_3_repeat1,
  [aux_sym__html_block_4_repeat1] = aux_sym__html_block_4_repeat1,
  [aux_sym__html_block_5_repeat1] = aux_sym__html_block_5_repeat1,
  [aux_sym__html_block_6_repeat1] = aux_sym__html_block_6_repeat1,
  [aux_sym_paragraph_repeat1] = aux_sym_paragraph_repeat1,
  [aux_sym_block_quote_repeat1] = aux_sym_block_quote_repeat1,
  [aux_sym__list_plus_repeat1] = aux_sym__list_plus_repeat1,
  [aux_sym__list_minus_repeat1] = aux_sym__list_minus_repeat1,
  [aux_sym__list_star_repeat1] = aux_sym__list_star_repeat1,
  [aux_sym__list_dot_repeat1] = aux_sym__list_dot_repeat1,
  [aux_sym__list_parenthesis_repeat1] = aux_sym__list_parenthesis_repeat1,
  [aux_sym__line_repeat1] = aux_sym__line_repeat1,
  [aux_sym_pipe_table_repeat1] = aux_sym_pipe_table_repeat1,
  [aux_sym_pipe_table_delimiter_row_repeat1] = aux_sym_pipe_table_delimiter_row_repeat1,
  [aux_sym_pipe_table_delimiter_cell_repeat1] = aux_sym_pipe_table_delimiter_cell_repeat1,
  [aux_sym_pipe_table_row_repeat1] = aux_sym_pipe_table_row_repeat1,
  [aux_sym_pipe_table_cell_repeat1] = aux_sym_pipe_table_cell_repeat1,
  [alias_sym_inline] = alias_sym_inline,
  [alias_sym_pipe_table_align_left] = alias_sym_pipe_table_align_left,
  [alias_sym_pipe_table_align_right] = alias_sym_pipe_table_align_right,
  [alias_sym_pipe_table_header] = alias_sym_pipe_table_header,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__backslash_escape] = {
    .visible = false,
    .named = true,
  },
  [sym_entity_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_numeric_character_reference] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym__newline_token] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DASH_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__word_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACKx_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__word_token2] = {
    .visible = false,
    .named = false,
  },
  [sym__whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym__line_ending] = {
    .visible = false,
    .named = true,
  },
  [sym__soft_line_ending] = {
    .visible = false,
    .named = true,
  },
  [sym__block_close] = {
    .visible = false,
    .named = true,
  },
  [sym_block_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym__block_quote_start] = {
    .visible = true,
    .named = true,
  },
  [sym__indented_chunk_start] = {
    .visible = false,
    .named = true,
  },
  [sym_atx_h1_marker] = {
    .visible = true,
    .named = true,
  },
  [sym_atx_h2_marker] = {
    .visible = true,
    .named = true,
  },
  [sym_atx_h3_marker] = {
    .visible = true,
    .named = true,
  },
  [sym_atx_h4_marker] = {
    .visible = true,
    .named = true,
  },
  [sym_atx_h5_marker] = {
    .visible = true,
    .named = true,
  },
  [sym_atx_h6_marker] = {
    .visible = true,
    .named = true,
  },
  [sym_setext_h1_underline] = {
    .visible = true,
    .named = true,
  },
  [sym_setext_h2_underline] = {
    .visible = true,
    .named = true,
  },
  [sym__thematic_break] = {
    .visible = false,
    .named = true,
  },
  [sym__list_marker_minus] = {
    .visible = false,
    .named = true,
  },
  [sym__list_marker_plus] = {
    .visible = false,
    .named = true,
  },
  [sym__list_marker_star] = {
    .visible = false,
    .named = true,
  },
  [sym__list_marker_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__list_marker_dot] = {
    .visible = false,
    .named = true,
  },
  [sym__list_marker_minus_dont_interrupt] = {
    .visible = false,
    .named = true,
  },
  [sym__list_marker_plus_dont_interrupt] = {
    .visible = false,
    .named = true,
  },
  [sym__list_marker_star_dont_interrupt] = {
    .visible = false,
    .named = true,
  },
  [sym__list_marker_parenthesis_dont_interrupt] = {
    .visible = false,
    .named = true,
  },
  [sym__list_marker_dot_dont_interrupt] = {
    .visible = false,
    .named = true,
  },
  [sym__fenced_code_block_start_backtick] = {
    .visible = true,
    .named = true,
  },
  [sym__fenced_code_block_start_tilde] = {
    .visible = true,
    .named = true,
  },
  [sym__blank_line_start] = {
    .visible = false,
    .named = true,
  },
  [sym__fenced_code_block_end_backtick] = {
    .visible = true,
    .named = true,
  },
  [sym__fenced_code_block_end_tilde] = {
    .visible = true,
    .named = true,
  },
  [sym__html_block_1_start] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_1_end] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_2_start] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_3_start] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_4_start] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_5_start] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_6_start] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_7_start] = {
    .visible = false,
    .named = true,
  },
  [sym__close_block] = {
    .visible = false,
    .named = true,
  },
  [sym__no_indented_chunk] = {
    .visible = false,
    .named = true,
  },
  [sym__error] = {
    .visible = false,
    .named = true,
  },
  [sym__trigger_error] = {
    .visible = false,
    .named = true,
  },
  [sym__eof] = {
    .visible = false,
    .named = true,
  },
  [sym_minus_metadata] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_metadata] = {
    .visible = true,
    .named = true,
  },
  [sym__pipe_table_start] = {
    .visible = false,
    .named = true,
  },
  [sym__pipe_table_line_ending] = {
    .visible = false,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_backslash_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_link_label] = {
    .visible = true,
    .named = true,
  },
  [sym_link_destination] = {
    .visible = true,
    .named = true,
  },
  [sym__link_destination_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__text_no_angle] = {
    .visible = false,
    .named = true,
  },
  [sym_link_title] = {
    .visible = true,
    .named = true,
  },
  [sym__last_token_punctuation] = {
    .visible = false,
    .named = true,
  },
  [sym__block] = {
    .visible = false,
    .named = true,
  },
  [sym__block_not_section] = {
    .visible = false,
    .named = true,
  },
  [sym_section] = {
    .visible = true,
    .named = true,
  },
  [sym__section1] = {
    .visible = false,
    .named = true,
  },
  [sym__section2] = {
    .visible = false,
    .named = true,
  },
  [sym__section3] = {
    .visible = false,
    .named = true,
  },
  [sym__section4] = {
    .visible = false,
    .named = true,
  },
  [sym__section5] = {
    .visible = false,
    .named = true,
  },
  [sym__section6] = {
    .visible = false,
    .named = true,
  },
  [sym_thematic_break] = {
    .visible = true,
    .named = true,
  },
  [sym__atx_heading1] = {
    .visible = true,
    .named = true,
  },
  [sym__atx_heading2] = {
    .visible = true,
    .named = true,
  },
  [sym__atx_heading3] = {
    .visible = true,
    .named = true,
  },
  [sym__atx_heading4] = {
    .visible = true,
    .named = true,
  },
  [sym__atx_heading5] = {
    .visible = true,
    .named = true,
  },
  [sym__atx_heading6] = {
    .visible = true,
    .named = true,
  },
  [sym__setext_heading1] = {
    .visible = true,
    .named = true,
  },
  [sym__setext_heading2] = {
    .visible = true,
    .named = true,
  },
  [sym_indented_code_block] = {
    .visible = true,
    .named = true,
  },
  [sym__indented_chunk] = {
    .visible = false,
    .named = true,
  },
  [sym_fenced_code_block] = {
    .visible = true,
    .named = true,
  },
  [sym_code_fence_content] = {
    .visible = true,
    .named = true,
  },
  [sym_info_string] = {
    .visible = true,
    .named = true,
  },
  [sym_language] = {
    .visible = true,
    .named = true,
  },
  [sym_html_block] = {
    .visible = true,
    .named = true,
  },
  [sym__html_block_1] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_2] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_3] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_4] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_5] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_6] = {
    .visible = false,
    .named = true,
  },
  [sym__html_block_7] = {
    .visible = false,
    .named = true,
  },
  [sym_link_reference_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__text_inline_no_link] = {
    .visible = false,
    .named = true,
  },
  [sym_paragraph] = {
    .visible = true,
    .named = true,
  },
  [sym__blank_line] = {
    .visible = false,
    .named = true,
  },
  [sym_block_quote] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__list_plus] = {
    .visible = false,
    .named = true,
  },
  [sym__list_minus] = {
    .visible = false,
    .named = true,
  },
  [sym__list_star] = {
    .visible = false,
    .named = true,
  },
  [sym__list_dot] = {
    .visible = false,
    .named = true,
  },
  [sym__list_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym_list_marker_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_star] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_list_marker_parenthesis] = {
    .visible = true,
    .named = true,
  },
  [sym__list_item_plus] = {
    .visible = true,
    .named = true,
  },
  [sym__list_item_minus] = {
    .visible = true,
    .named = true,
  },
  [sym__list_item_star] = {
    .visible = true,
    .named = true,
  },
  [sym__list_item_dot] = {
    .visible = true,
    .named = true,
  },
  [sym__list_item_parenthesis] = {
    .visible = true,
    .named = true,
  },
  [sym__list_item_content] = {
    .visible = false,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__soft_line_break] = {
    .visible = false,
    .named = true,
  },
  [sym__line] = {
    .visible = false,
    .named = true,
  },
  [sym__word] = {
    .visible = false,
    .named = true,
  },
  [sym_task_list_marker_checked] = {
    .visible = true,
    .named = true,
  },
  [sym_task_list_marker_unchecked] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe_table] = {
    .visible = true,
    .named = true,
  },
  [sym__pipe_table_newline] = {
    .visible = false,
    .named = true,
  },
  [sym_pipe_table_delimiter_row] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe_table_delimiter_cell] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe_table_row] = {
    .visible = true,
    .named = true,
  },
  [sym_pipe_table_cell] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_document_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_label_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_destination_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_destination_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section1_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section2_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section3_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section4_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section5_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_indented_code_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__indented_chunk_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_code_fence_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_info_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_info_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_language_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__html_block_1_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__html_block_2_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__html_block_3_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__html_block_4_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__html_block_5_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__html_block_6_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_paragraph_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_quote_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_plus_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_minus_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_star_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_dot_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_parenthesis_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pipe_table_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pipe_table_delimiter_row_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pipe_table_delimiter_cell_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pipe_table_row_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pipe_table_cell_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_inline] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pipe_table_align_left] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pipe_table_align_right] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pipe_table_header] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_heading_content = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_heading_content] = "heading_content",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [5] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_heading_content, 0, .inherited = true},
  [1] =
    {field_heading_content, 1},
  [2] =
    {field_heading_content, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = sym_section,
  },
  [3] = {
    [1] = sym_section,
  },
  [4] = {
    [0] = alias_sym_inline,
  },
  [5] = {
    [1] = alias_sym_inline,
  },
  [7] = {
    [0] = alias_sym_pipe_table_align_left,
  },
  [8] = {
    [1] = alias_sym_pipe_table_header,
  },
  [9] = {
    [1] = alias_sym_pipe_table_align_right,
  },
  [10] = {
    [0] = alias_sym_pipe_table_align_left,
    [2] = alias_sym_pipe_table_align_right,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__section2, 2,
    sym__section2,
    sym_section,
  sym__section3, 2,
    sym__section3,
    sym_section,
  sym__section4, 2,
    sym__section4,
    sym_section,
  sym__section5, 2,
    sym__section5,
    sym_section,
  sym__section6, 2,
    sym__section6,
    sym_section,
  sym__line, 2,
    sym__line,
    alias_sym_inline,
  sym_pipe_table_row, 2,
    sym_pipe_table_row,
    alias_sym_pipe_table_header,
  aux_sym_document_repeat1, 2,
    aux_sym_document_repeat1,
    sym_section,
  aux_sym_paragraph_repeat1, 2,
    aux_sym_paragraph_repeat1,
    alias_sym_inline,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(2031);
      if (lookahead == '\n') ADVANCE(2072);
      if (lookahead == '\r') ADVANCE(2073);
      if (lookahead == '!') ADVANCE(2040);
      if (lookahead == '"') ADVANCE(2041);
      if (lookahead == '#') ADVANCE(2042);
      if (lookahead == '$') ADVANCE(2043);
      if (lookahead == '%') ADVANCE(2044);
      if (lookahead == '&') ADVANCE(2046);
      if (lookahead == '\'') ADVANCE(2047);
      if (lookahead == '(') ADVANCE(2070);
      if (lookahead == ')') ADVANCE(2071);
      if (lookahead == '*') ADVANCE(2048);
      if (lookahead == '+') ADVANCE(2049);
      if (lookahead == ',') ADVANCE(2050);
      if (lookahead == '-') ADVANCE(2052);
      if (lookahead == '.') ADVANCE(2053);
      if (lookahead == '/') ADVANCE(2054);
      if (lookahead == ':') ADVANCE(2055);
      if (lookahead == ';') ADVANCE(2056);
      if (lookahead == '<') ADVANCE(2038);
      if (lookahead == '=') ADVANCE(2057);
      if (lookahead == '>') ADVANCE(2039);
      if (lookahead == '?') ADVANCE(2059);
      if (lookahead == '@') ADVANCE(2060);
      if (lookahead == '[') ADVANCE(2035);
      if (lookahead == '\\') ADVANCE(2062);
      if (lookahead == ']') ADVANCE(2037);
      if (lookahead == '^') ADVANCE(2063);
      if (lookahead == '_') ADVANCE(2064);
      if (lookahead == '`') ADVANCE(2065);
      if (lookahead == '{') ADVANCE(2066);
      if (lookahead == '|') ADVANCE(2067);
      if (lookahead == '}') ADVANCE(2068);
      if (lookahead == '~') ADVANCE(2069);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2080);
      if (lookahead != 0) ADVANCE(2077);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(2040);
      if (lookahead == '"') ADVANCE(2041);
      if (lookahead == '#') ADVANCE(2042);
      if (lookahead == '$') ADVANCE(2043);
      if (lookahead == '%') ADVANCE(2044);
      if (lookahead == '&') ADVANCE(2046);
      if (lookahead == '\'') ADVANCE(2047);
      if (lookahead == '(') ADVANCE(2070);
      if (lookahead == ')') ADVANCE(2071);
      if (lookahead == '*') ADVANCE(2048);
      if (lookahead == '+') ADVANCE(2049);
      if (lookahead == ',') ADVANCE(2050);
      if (lookahead == '-') ADVANCE(2051);
      if (lookahead == '.') ADVANCE(2053);
      if (lookahead == '/') ADVANCE(2054);
      if (lookahead == ':') ADVANCE(2055);
      if (lookahead == ';') ADVANCE(2056);
      if (lookahead == '<') ADVANCE(2038);
      if (lookahead == '=') ADVANCE(2057);
      if (lookahead == '>') ADVANCE(2039);
      if (lookahead == '?') ADVANCE(2058);
      if (lookahead == '@') ADVANCE(2060);
      if (lookahead == '[') ADVANCE(2035);
      if (lookahead == '\\') ADVANCE(2062);
      if (lookahead == ']') ADVANCE(2036);
      if (lookahead == '^') ADVANCE(2063);
      if (lookahead == '_') ADVANCE(2064);
      if (lookahead == '`') ADVANCE(2065);
      if (lookahead == '{') ADVANCE(2066);
      if (lookahead == '|') ADVANCE(2067);
      if (lookahead == '}') ADVANCE(2068);
      if (lookahead == '~') ADVANCE(2069);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2080);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(2077);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(2040);
      if (lookahead == '"') ADVANCE(2041);
      if (lookahead == '#') ADVANCE(2042);
      if (lookahead == '$') ADVANCE(2043);
      if (lookahead == '%') ADVANCE(2044);
      if (lookahead == '&') ADVANCE(2045);
      if (lookahead == '\'') ADVANCE(2047);
      if (lookahead == '(') ADVANCE(2070);
      if (lookahead == ')') ADVANCE(2071);
      if (lookahead == '*') ADVANCE(2048);
      if (lookahead == '+') ADVANCE(2049);
      if (lookahead == ',') ADVANCE(2050);
      if (lookahead == '-') ADVANCE(2052);
      if (lookahead == '.') ADVANCE(2053);
      if (lookahead == '/') ADVANCE(2054);
      if (lookahead == ':') ADVANCE(2055);
      if (lookahead == ';') ADVANCE(2056);
      if (lookahead == '<') ADVANCE(2038);
      if (lookahead == '=') ADVANCE(2057);
      if (lookahead == '>') ADVANCE(2039);
      if (lookahead == '?') ADVANCE(2058);
      if (lookahead == '@') ADVANCE(2060);
      if (lookahead == '[') ADVANCE(2035);
      if (lookahead == '\\') ADVANCE(2061);
      if (lookahead == ']') ADVANCE(2036);
      if (lookahead == '^') ADVANCE(2063);
      if (lookahead == '_') ADVANCE(2064);
      if (lookahead == '`') ADVANCE(2065);
      if (lookahead == '{') ADVANCE(2066);
      if (lookahead == '|') ADVANCE(2067);
      if (lookahead == '}') ADVANCE(2068);
      if (lookahead == '~') ADVANCE(2069);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2080);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(2077);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(2040);
      if (lookahead == '"') ADVANCE(2041);
      if (lookahead == '#') ADVANCE(2042);
      if (lookahead == '$') ADVANCE(2043);
      if (lookahead == '%') ADVANCE(2044);
      if (lookahead == '&') ADVANCE(2045);
      if (lookahead == '\'') ADVANCE(2047);
      if (lookahead == '(') ADVANCE(2070);
      if (lookahead == ')') ADVANCE(2071);
      if (lookahead == '*') ADVANCE(2048);
      if (lookahead == '+') ADVANCE(2049);
      if (lookahead == ',') ADVANCE(2050);
      if (lookahead == '-') ADVANCE(2051);
      if (lookahead == '.') ADVANCE(2053);
      if (lookahead == '/') ADVANCE(2054);
      if (lookahead == ':') ADVANCE(2055);
      if (lookahead == ';') ADVANCE(2056);
      if (lookahead == '<') ADVANCE(2038);
      if (lookahead == '=') ADVANCE(2057);
      if (lookahead == '>') ADVANCE(2039);
      if (lookahead == '?') ADVANCE(2059);
      if (lookahead == '@') ADVANCE(2060);
      if (lookahead == '[') ADVANCE(2035);
      if (lookahead == '\\') ADVANCE(2061);
      if (lookahead == ']') ADVANCE(2036);
      if (lookahead == '^') ADVANCE(2063);
      if (lookahead == '_') ADVANCE(2064);
      if (lookahead == '`') ADVANCE(2065);
      if (lookahead == '{') ADVANCE(2066);
      if (lookahead == '|') ADVANCE(2067);
      if (lookahead == '}') ADVANCE(2068);
      if (lookahead == '~') ADVANCE(2069);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2080);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(2077);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(2040);
      if (lookahead == '"') ADVANCE(2041);
      if (lookahead == '#') ADVANCE(2042);
      if (lookahead == '$') ADVANCE(2043);
      if (lookahead == '%') ADVANCE(2044);
      if (lookahead == '&') ADVANCE(2045);
      if (lookahead == '\'') ADVANCE(2047);
      if (lookahead == '(') ADVANCE(2070);
      if (lookahead == ')') ADVANCE(2071);
      if (lookahead == '*') ADVANCE(2048);
      if (lookahead == '+') ADVANCE(2049);
      if (lookahead == ',') ADVANCE(2050);
      if (lookahead == '-') ADVANCE(2051);
      if (lookahead == '.') ADVANCE(2053);
      if (lookahead == '/') ADVANCE(2054);
      if (lookahead == ':') ADVANCE(2055);
      if (lookahead == ';') ADVANCE(2056);
      if (lookahead == '<') ADVANCE(2038);
      if (lookahead == '=') ADVANCE(2057);
      if (lookahead == '>') ADVANCE(2039);
      if (lookahead == '?') ADVANCE(2058);
      if (lookahead == '@') ADVANCE(2060);
      if (lookahead == '[') ADVANCE(2035);
      if (lookahead == '\\') ADVANCE(2062);
      if (lookahead == ']') ADVANCE(2036);
      if (lookahead == '^') ADVANCE(2063);
      if (lookahead == '_') ADVANCE(2064);
      if (lookahead == '`') ADVANCE(2065);
      if (lookahead == '{') ADVANCE(2066);
      if (lookahead == '|') ADVANCE(2067);
      if (lookahead == '}') ADVANCE(2068);
      if (lookahead == '~') ADVANCE(2069);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2080);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(2077);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(2040);
      if (lookahead == '"') ADVANCE(2041);
      if (lookahead == '#') ADVANCE(2042);
      if (lookahead == '$') ADVANCE(2043);
      if (lookahead == '%') ADVANCE(2044);
      if (lookahead == '&') ADVANCE(2045);
      if (lookahead == '\'') ADVANCE(2047);
      if (lookahead == '(') ADVANCE(2070);
      if (lookahead == ')') ADVANCE(2071);
      if (lookahead == '*') ADVANCE(2048);
      if (lookahead == '+') ADVANCE(2049);
      if (lookahead == ',') ADVANCE(2050);
      if (lookahead == '-') ADVANCE(2051);
      if (lookahead == '.') ADVANCE(2053);
      if (lookahead == '/') ADVANCE(2054);
      if (lookahead == ':') ADVANCE(2055);
      if (lookahead == ';') ADVANCE(2056);
      if (lookahead == '<') ADVANCE(2038);
      if (lookahead == '=') ADVANCE(2057);
      if (lookahead == '>') ADVANCE(2039);
      if (lookahead == '?') ADVANCE(2058);
      if (lookahead == '@') ADVANCE(2060);
      if (lookahead == '[') ADVANCE(2035);
      if (lookahead == '\\') ADVANCE(2061);
      if (lookahead == ']') ADVANCE(2037);
      if (lookahead == '^') ADVANCE(2063);
      if (lookahead == '_') ADVANCE(2064);
      if (lookahead == '`') ADVANCE(2065);
      if (lookahead == '{') ADVANCE(2066);
      if (lookahead == '|') ADVANCE(2067);
      if (lookahead == '}') ADVANCE(2068);
      if (lookahead == '~') ADVANCE(2069);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2080);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(2077);
      END_STATE();
    case 6:
      if (lookahead == '1') ADVANCE(2005);
      if (lookahead == '3') ADVANCE(9);
      END_STATE();
    case 7:
      if (lookahead == '1') ADVANCE(2020);
      if (lookahead == ';') ADVANCE(2033);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(2027);
      if (lookahead == '2') ADVANCE(2006);
      if (lookahead == '3') ADVANCE(2023);
      if (lookahead == '4') ADVANCE(11);
      if (lookahead == '5') ADVANCE(2007);
      if (lookahead == '7') ADVANCE(12);
      END_STATE();
    case 9:
      if (lookahead == '4') ADVANCE(13);
      END_STATE();
    case 10:
      if (lookahead == '4') ADVANCE(13);
      if (lookahead == 'f') ADVANCE(1517);
      END_STATE();
    case 11:
      if (lookahead == '5') ADVANCE(13);
      END_STATE();
    case 12:
      if (lookahead == '8') ADVANCE(13);
      END_STATE();
    case 13:
      if (lookahead == ';') ADVANCE(2033);
      END_STATE();
    case 14:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'A') ADVANCE(443);
      if (lookahead == 'B') ADVANCE(433);
      if (lookahead == 'E') ADVANCE(136);
      if (lookahead == 'H') ADVANCE(396);
      if (lookahead == 'a') ADVANCE(668);
      if (lookahead == 'b') ADVANCE(434);
      if (lookahead == 'c') ADVANCE(460);
      if (lookahead == 'd') ADVANCE(652);
      if (lookahead == 'e') ADVANCE(133);
      if (lookahead == 'f') ADVANCE(1110);
      if (lookahead == 'g') ADVANCE(28);
      if (lookahead == 'h') ADVANCE(478);
      if (lookahead == 'j') ADVANCE(603);
      if (lookahead == 'l') ADVANCE(62);
      if (lookahead == 'm') ADVANCE(1093);
      if (lookahead == 'n') ADVANCE(315);
      if (lookahead == 'o') ADVANCE(404);
      if (lookahead == 'p') ADVANCE(482);
      if (lookahead == 'r') ADVANCE(437);
      if (lookahead == 's') ADVANCE(384);
      if (lookahead == 't') ADVANCE(88);
      if (lookahead == 'u') ADVANCE(1627);
      if (lookahead == 'v') ADVANCE(920);
      END_STATE();
    case 15:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'a') ADVANCE(1611);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'q') ADVANCE(1928);
      if (lookahead == 's') ADVANCE(827);
      if (lookahead == 'x') ADVANCE(1152);
      END_STATE();
    case 16:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'A') ADVANCE(1730);
      END_STATE();
    case 17:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'A') ADVANCE(1730);
      if (lookahead == 'V') ADVANCE(921);
      END_STATE();
    case 18:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'B') ADVANCE(396);
      END_STATE();
    case 19:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'B') ADVANCE(396);
      if (lookahead == 'D') ADVANCE(1501);
      END_STATE();
    case 20:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'B') ADVANCE(396);
      if (lookahead == 'E') ADVANCE(1589);
      END_STATE();
    case 21:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'B') ADVANCE(396);
      if (lookahead == 'L') ADVANCE(923);
      END_STATE();
    case 22:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'B') ADVANCE(396);
      if (lookahead == 'R') ADVANCE(1174);
      END_STATE();
    case 23:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'B') ADVANCE(396);
      if (lookahead == 'U') ADVANCE(1545);
      END_STATE();
    case 24:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'C') ADVANCE(1512);
      if (lookahead == 'D') ADVANCE(1486);
      if (lookahead == 'E') ADVANCE(1221);
      if (lookahead == 'G') ADVANCE(1746);
      if (lookahead == 'H') ADVANCE(1939);
      if (lookahead == 'L') ADVANCE(895);
      if (lookahead == 'N') ADVANCE(862);
      if (lookahead == 'P') ADVANCE(1707);
      if (lookahead == 'R') ADVANCE(896);
      if (lookahead == 'S') ADVANCE(1590);
      if (lookahead == 'T') ADVANCE(1099);
      if (lookahead == 'V') ADVANCE(935);
      END_STATE();
    case 25:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'C') ADVANCE(422);
      END_STATE();
    case 26:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'D') ADVANCE(1447);
      if (lookahead == 'E') ADVANCE(1589);
      END_STATE();
    case 27:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'D') ADVANCE(297);
      END_STATE();
    case 28:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(13);
      END_STATE();
    case 29:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(13);
      if (lookahead == 'a') ADVANCE(1526);
      if (lookahead == 'c') ADVANCE(1917);
      if (lookahead == 'e') ADVANCE(87);
      if (lookahead == 'i') ADVANCE(1348);
      if (lookahead == 'n') ADVANCE(314);
      if (lookahead == 'o') ADVANCE(731);
      if (lookahead == 's') ADVANCE(1104);
      if (lookahead == 'u') ADVANCE(1658);
      END_STATE();
    case 30:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(98);
      if (lookahead == 'm') ADVANCE(1924);
      if (lookahead == 'n') ADVANCE(2008);
      if (lookahead == 'p') ADVANCE(1297);
      if (lookahead == 'r') ADVANCE(433);
      if (lookahead == 's') ADVANCE(875);
      END_STATE();
    case 31:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'v') ADVANCE(2024);
      END_STATE();
    case 32:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(13);
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 33:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(13);
      if (lookahead == 'i') ADVANCE(730);
      if (lookahead == 'o') ADVANCE(1752);
      if (lookahead == 'p') ADVANCE(1678);
      END_STATE();
    case 34:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(152);
      if (lookahead == 'a') ADVANCE(670);
      if (lookahead == 'b') ADVANCE(1598);
      if (lookahead == 'c') ADVANCE(1140);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(153);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'g') ADVANCE(136);
      if (lookahead == 'i') ADVANCE(1333);
      if (lookahead == 'j') ADVANCE(603);
      if (lookahead == 'l') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(315);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'r') ADVANCE(387);
      if (lookahead == 's') ADVANCE(638);
      if (lookahead == 't') ADVANCE(89);
      if (lookahead == 'v') ADVANCE(920);
      END_STATE();
    case 35:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(1589);
      END_STATE();
    case 36:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(1589);
      if (lookahead == 'F') ADVANCE(1946);
      if (lookahead == 'G') ADVANCE(1739);
      if (lookahead == 'L') ADVANCE(821);
      if (lookahead == 'S') ADVANCE(1307);
      if (lookahead == 'T') ADVANCE(1167);
      END_STATE();
    case 37:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(1589);
      if (lookahead == 'F') ADVANCE(1946);
      if (lookahead == 'T') ADVANCE(1167);
      END_STATE();
    case 38:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(1589);
      if (lookahead == 'G') ADVANCE(1739);
      if (lookahead == 'L') ADVANCE(821);
      if (lookahead == 'S') ADVANCE(1307);
      if (lookahead == 'T') ADVANCE(1167);
      END_STATE();
    case 39:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(1589);
      if (lookahead == 'S') ADVANCE(1307);
      END_STATE();
    case 40:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E') ADVANCE(1589);
      if (lookahead == 'S') ADVANCE(1307);
      if (lookahead == 'T') ADVANCE(1167);
      END_STATE();
    case 41:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'G') ADVANCE(13);
      END_STATE();
    case 42:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'H') ADVANCE(13);
      END_STATE();
    case 43:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'I') ADVANCE(1429);
      if (lookahead == 'S') ADVANCE(1910);
      if (lookahead == 'U') ADVANCE(1410);
      END_STATE();
    case 44:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'J') ADVANCE(603);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(13);
      if (lookahead == 'a') ADVANCE(669);
      if (lookahead == 'c') ADVANCE(462);
      if (lookahead == 'e') ADVANCE(952);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'l') ADVANCE(113);
      if (lookahead == 'm') ADVANCE(1092);
      if (lookahead == 'o') ADVANCE(1377);
      if (lookahead == 's') ADVANCE(635);
      END_STATE();
    case 45:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'J') ADVANCE(603);
      if (lookahead == 'T' ||
          lookahead == 'g' ||
          lookahead == 't') ADVANCE(13);
      if (lookahead == 'a') ADVANCE(1349);
      if (lookahead == 'b') ADVANCE(1598);
      if (lookahead == 'c') ADVANCE(831);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'r') ADVANCE(847);
      if (lookahead == 's') ADVANCE(627);
      END_STATE();
    case 46:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'L') ADVANCE(821);
      END_STATE();
    case 47:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'N') ADVANCE(13);
      END_STATE();
    case 48:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'P') ADVANCE(13);
      END_STATE();
    case 49:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'P') ADVANCE(1297);
      END_STATE();
    case 50:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'T') ADVANCE(13);
      END_STATE();
    case 51:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'T') ADVANCE(1167);
      END_STATE();
    case 52:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'Y') ADVANCE(13);
      END_STATE();
    case 53:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(633);
      if (lookahead == 'p') ADVANCE(1263);
      END_STATE();
    case 54:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(984);
      if (lookahead == 'o') ADVANCE(1862);
      END_STATE();
    case 55:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(2028);
      END_STATE();
    case 56:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(627);
      if (lookahead == 'l') ADVANCE(13);
      END_STATE();
    case 57:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1599);
      END_STATE();
    case 58:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(641);
      if (lookahead == 'p') ADVANCE(13);
      END_STATE();
    case 59:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(158);
      if (lookahead == 's') ADVANCE(1105);
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 60:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1526);
      if (lookahead == 'b') ADVANCE(132);
      if (lookahead == 'c' ||
          lookahead == 'w') ADVANCE(13);
      if (lookahead == 'f') ADVANCE(1752);
      if (lookahead == 'h') ADVANCE(1188);
      if (lookahead == 'l') ADVANCE(1526);
      if (lookahead == 'p') ADVANCE(1207);
      if (lookahead == 's') ADVANCE(1104);
      if (lookahead == 't') ADVANCE(1207);
      END_STATE();
    case 61:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(699);
      if (lookahead == 'b' ||
          lookahead == 'e') ADVANCE(13);
      if (lookahead == 'c') ADVANCE(1082);
      if (lookahead == 'd') ADVANCE(2018);
      if (lookahead == 'm') ADVANCE(162);
      if (lookahead == 's') ADVANCE(1104);
      if (lookahead == 't') ADVANCE(1970);
      END_STATE();
    case 62:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'c') ADVANCE(1498);
      if (lookahead == 'h') ADVANCE(497);
      if (lookahead == 't') ADVANCE(1634);
      END_STATE();
    case 63:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'd') ADVANCE(128);
      if (lookahead == 'i') ADVANCE(986);
      if (lookahead == 'o') ADVANCE(1599);
      if (lookahead == 's') ADVANCE(1262);
      if (lookahead == 'v') ADVANCE(13);
      END_STATE();
    case 64:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1752);
      END_STATE();
    case 65:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1763);
      if (lookahead == 'c') ADVANCE(1082);
      if (lookahead == 'd') ADVANCE(1454);
      END_STATE();
    case 66:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1207);
      END_STATE();
    case 67:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1652);
      if (lookahead == 'e') ADVANCE(770);
      if (lookahead == 'i') ADVANCE(1666);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 68:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1212);
      if (lookahead == 'c') ADVANCE(1807);
      if (lookahead == 'g') ADVANCE(13);
      END_STATE();
    case 69:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1352);
      if (lookahead == 'b') ADVANCE(1721);
      if (lookahead == 'c') ADVANCE(426);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 70:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1352);
      if (lookahead == 'd' ||
          lookahead == 'v') ADVANCE(13);
      if (lookahead == 's') ADVANCE(1262);
      END_STATE();
    case 71:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(692);
      END_STATE();
    case 72:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1647);
      if (lookahead == 'c') ADVANCE(1039);
      if (lookahead == 'o') ADVANCE(1686);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 73:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1232);
      END_STATE();
    case 74:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1615);
      if (lookahead == 'f') ADVANCE(13);
      END_STATE();
    case 75:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1561);
      if (lookahead == 'c') ADVANCE(1937);
      if (lookahead == 'e') ADVANCE(1581);
      if (lookahead == 'n') ADVANCE(519);
      if (lookahead == 's') ADVANCE(1104);
      END_STATE();
    case 76:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1112);
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 77:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a') ADVANCE(1306);
      if (lookahead == 's') ADVANCE(1207);
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 78:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'b') ADVANCE(1447);
      if (lookahead == 'c') ADVANCE(1082);
      if (lookahead == 'f') ADVANCE(171);
      END_STATE();
    case 79:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'b') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(208);
      END_STATE();
    case 80:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'b') ADVANCE(13);
      if (lookahead == 'h') ADVANCE(1799);
      END_STATE();
    case 81:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'b') ADVANCE(57);
      END_STATE();
    case 82:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'b') ADVANCE(57);
      if (lookahead == 'd') ADVANCE(13);
      END_STATE();
    case 83:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'b') ADVANCE(132);
      if (lookahead == 'f') ADVANCE(1752);
      if (lookahead == 'h') ADVANCE(1188);
      if (lookahead == 'l') ADVANCE(1526);
      if (lookahead == 'p') ADVANCE(1207);
      if (lookahead == 's') ADVANCE(1104);
      if (lookahead == 't') ADVANCE(1207);
      END_STATE();
    case 84:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'b') ADVANCE(396);
      if (lookahead == 'e') ADVANCE(1581);
      END_STATE();
    case 85:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'b') ADVANCE(1674);
      if (lookahead == 'c') ADVANCE(426);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'o') ADVANCE(1599);
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 86:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(13);
      END_STATE();
    case 87:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(75);
      END_STATE();
    case 88:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(612);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'h') ADVANCE(1648);
      if (lookahead == 'i') ADVANCE(1346);
      if (lookahead == 'l') ADVANCE(433);
      if (lookahead == 'q') ADVANCE(1929);
      if (lookahead == 'r') ADVANCE(356);
      END_STATE();
    case 89:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(612);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'l') ADVANCE(355);
      if (lookahead == 'q') ADVANCE(1929);
      if (lookahead == 'r') ADVANCE(421);
      END_STATE();
    case 90:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 91:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(611);
      if (lookahead == 'd') ADVANCE(1491);
      if (lookahead == 'l') ADVANCE(123);
      END_STATE();
    case 92:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(611);
      if (lookahead == 'd') ADVANCE(1492);
      if (lookahead == 'g') ADVANCE(123);
      if (lookahead == 's') ADVANCE(518);
      END_STATE();
    case 93:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(449);
      if (lookahead == 'e') ADVANCE(1017);
      if (lookahead == 'l') ADVANCE(504);
      if (lookahead == 'p') ADVANCE(1659);
      END_STATE();
    case 94:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(1082);
      if (lookahead == 'w') ADVANCE(13);
      END_STATE();
    case 95:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(1917);
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 96:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(1917);
      if (lookahead == 'e' ||
          lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 97:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c') ADVANCE(539);
      if (lookahead == 'f') ADVANCE(1127);
      if (lookahead == 'o') ADVANCE(725);
      if (lookahead == 't') ADVANCE(93);
      END_STATE();
    case 98:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'd') ADVANCE(1447);
      END_STATE();
    case 99:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(178);
      if (lookahead == 'g') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(28);
      if (lookahead == 'n') ADVANCE(775);
      if (lookahead == 'p') ADVANCE(1297);
      if (lookahead == 'r') ADVANCE(433);
      END_STATE();
    case 100:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'd') ADVANCE(13);
      END_STATE();
    case 101:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'd') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(775);
      END_STATE();
    case 102:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'd') ADVANCE(1440);
      if (lookahead == 'l') ADVANCE(835);
      if (lookahead == 'r') ADVANCE(1135);
      END_STATE();
    case 103:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'd') ADVANCE(1440);
      if (lookahead == 'l') ADVANCE(835);
      if (lookahead == 'u') ADVANCE(1526);
      END_STATE();
    case 104:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'd') ADVANCE(1440);
      if (lookahead == 'l') ADVANCE(928);
      if (lookahead == 'q') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(1178);
      END_STATE();
    case 105:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'd') ADVANCE(1112);
      END_STATE();
    case 106:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(13);
      END_STATE();
    case 107:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(775);
      if (lookahead == 'm') ADVANCE(1782);
      if (lookahead == 'r') ADVANCE(1836);
      if (lookahead == 's') ADVANCE(1549);
      if (lookahead == 'z') ADVANCE(433);
      END_STATE();
    case 108:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 's') ADVANCE(863);
      END_STATE();
    case 109:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1599);
      END_STATE();
    case 110:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1582);
      if (lookahead == 'm') ADVANCE(1164);
      if (lookahead == 'p') ADVANCE(1297);
      if (lookahead == 's') ADVANCE(1596);
      END_STATE();
    case 111:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1807);
      END_STATE();
    case 112:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1010);
      END_STATE();
    case 113:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(955);
      END_STATE();
    case 114:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 115:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1581);
      END_STATE();
    case 116:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1581);
      if (lookahead == 'l') ADVANCE(796);
      END_STATE();
    case 117:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 118:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(701);
      if (lookahead == 'i') ADVANCE(1336);
      if (lookahead == 'o') ADVANCE(754);
      END_STATE();
    case 119:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 120:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1586);
      END_STATE();
    case 121:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1586);
      if (lookahead == 'n') ADVANCE(840);
      END_STATE();
    case 122:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(448);
      END_STATE();
    case 123:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1752);
      END_STATE();
    case 124:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1783);
      END_STATE();
    case 125:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(13);
      END_STATE();
    case 126:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1684);
      if (lookahead == 's') ADVANCE(811);
      END_STATE();
    case 127:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1640);
      if (lookahead == 's') ADVANCE(1526);
      END_STATE();
    case 128:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1650);
      if (lookahead == 'f' ||
          lookahead == 'm') ADVANCE(13);
      END_STATE();
    case 129:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e') ADVANCE(1639);
      END_STATE();
    case 130:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'f') ADVANCE(13);
      END_STATE();
    case 131:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'f') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(1436);
      if (lookahead == 'y') ADVANCE(188);
      END_STATE();
    case 132:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'f') ADVANCE(1752);
      END_STATE();
    case 133:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'f') ADVANCE(1812);
      if (lookahead == 'g') ADVANCE(13);
      if (lookahead == 'q') ADVANCE(179);
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 134:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'f') ADVANCE(1353);
      if (lookahead == 'l') ADVANCE(797);
      END_STATE();
    case 135:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'f') ADVANCE(1838);
      if (lookahead == 'q') ADVANCE(179);
      if (lookahead == 's') ADVANCE(187);
      END_STATE();
    case 136:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'g') ADVANCE(13);
      END_STATE();
    case 137:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'g') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(1828);
      if (lookahead == 'm') ADVANCE(1560);
      END_STATE();
    case 138:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'g') ADVANCE(1807);
      END_STATE();
    case 139:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'g') ADVANCE(775);
      END_STATE();
    case 140:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'h') ADVANCE(13);
      END_STATE();
    case 141:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'h') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(1478);
      END_STATE();
    case 142:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'h') ADVANCE(1437);
      END_STATE();
    case 143:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'i') ADVANCE(1085);
      if (lookahead == 'n') ADVANCE(967);
      if (lookahead == 'o') ADVANCE(1828);
      END_STATE();
    case 144:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'i') ADVANCE(749);
      if (lookahead == 'o') ADVANCE(1370);
      END_STATE();
    case 145:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'i') ADVANCE(1629);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 146:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'i') ADVANCE(1387);
      if (lookahead == 'p') ADVANCE(501);
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 147:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'i') ADVANCE(1866);
      END_STATE();
    case 148:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'i') ADVANCE(714);
      END_STATE();
    case 149:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'i') ADVANCE(1362);
      if (lookahead == 'n') ADVANCE(1095);
      END_STATE();
    case 150:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'i') ADVANCE(1289);
      END_STATE();
    case 151:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'i') ADVANCE(1426);
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 's') ADVANCE(98);
      END_STATE();
    case 152:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'l') ADVANCE(13);
      END_STATE();
    case 153:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 'q') ADVANCE(179);
      if (lookahead == 's') ADVANCE(91);
      END_STATE();
    case 154:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'l') ADVANCE(1807);
      END_STATE();
    case 155:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'l') ADVANCE(1478);
      END_STATE();
    case 156:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'l') ADVANCE(1478);
      if (lookahead == 'v') ADVANCE(13);
      END_STATE();
    case 157:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'l') ADVANCE(1869);
      if (lookahead == 'm') ADVANCE(422);
      END_STATE();
    case 158:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'l') ADVANCE(1248);
      END_STATE();
    case 159:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'm') ADVANCE(13);
      END_STATE();
    case 160:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'm') ADVANCE(127);
      END_STATE();
    case 161:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'm') ADVANCE(455);
      END_STATE();
    case 162:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'n') ADVANCE(13);
      END_STATE();
    case 163:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'n') ADVANCE(474);
      END_STATE();
    case 164:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(13);
      END_STATE();
    case 165:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(183);
      END_STATE();
    case 166:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(152);
      END_STATE();
    case 167:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(945);
      END_STATE();
    case 168:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(1975);
      END_STATE();
    case 169:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(1965);
      END_STATE();
    case 170:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(699);
      END_STATE();
    case 171:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(1653);
      END_STATE();
    case 172:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(1882);
      END_STATE();
    case 173:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(1392);
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 174:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'o') ADVANCE(1417);
      END_STATE();
    case 175:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'p') ADVANCE(13);
      END_STATE();
    case 176:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 177:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'p') ADVANCE(1678);
      END_STATE();
    case 178:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'q') ADVANCE(13);
      END_STATE();
    case 179:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'q') ADVANCE(13);
      if (lookahead == 's') ADVANCE(1292);
      END_STATE();
    case 180:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'q') ADVANCE(179);
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 181:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'q') ADVANCE(178);
      END_STATE();
    case 182:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'q') ADVANCE(1928);
      END_STATE();
    case 183:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 184:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'r') ADVANCE(414);
      if (lookahead == 's') ADVANCE(98);
      END_STATE();
    case 185:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'r') ADVANCE(1120);
      END_STATE();
    case 186:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'r') ADVANCE(1098);
      END_STATE();
    case 187:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 188:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(1599);
      END_STATE();
    case 189:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(100);
      if (lookahead == 'v') ADVANCE(13);
      END_STATE();
    case 190:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(82);
      END_STATE();
    case 191:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(1997);
      if (lookahead == 'v') ADVANCE(13);
      END_STATE();
    case 192:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(1312);
      END_STATE();
    case 193:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(1207);
      END_STATE();
    case 194:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(1870);
      END_STATE();
    case 195:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(811);
      if (lookahead == 'v') ADVANCE(13);
      END_STATE();
    case 196:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(865);
      END_STATE();
    case 197:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 's') ADVANCE(1932);
      END_STATE();
    case 198:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 199:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 200:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 't') ADVANCE(1437);
      END_STATE();
    case 201:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 202:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 't') ADVANCE(583);
      END_STATE();
    case 203:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 't') ADVANCE(1207);
      END_STATE();
    case 204:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 't') ADVANCE(681);
      if (lookahead == 'v') ADVANCE(13);
      END_STATE();
    case 205:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 206:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 't') ADVANCE(1461);
      END_STATE();
    case 207:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 't') ADVANCE(1120);
      END_STATE();
    case 208:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'u') ADVANCE(13);
      END_STATE();
    case 209:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'u') ADVANCE(1090);
      END_STATE();
    case 210:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'v') ADVANCE(13);
      END_STATE();
    case 211:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'v') ADVANCE(2024);
      END_STATE();
    case 212:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'v') ADVANCE(572);
      END_STATE();
    case 213:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'v') ADVANCE(877);
      END_STATE();
    case 214:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(13);
      if (lookahead == 'a') ADVANCE(699);
      if (lookahead == 'i') ADVANCE(730);
      if (lookahead == 'o') ADVANCE(1752);
      if (lookahead == 'p') ADVANCE(1672);
      END_STATE();
    case 215:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(13);
      if (lookahead == 'c') ADVANCE(116);
      if (lookahead == 'f') ADVANCE(1415);
      if (lookahead == 'm') ADVANCE(1071);
      if (lookahead == 's') ADVANCE(699);
      END_STATE();
    case 216:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(13);
      if (lookahead == 's') ADVANCE(878);
      END_STATE();
    case 217:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E' ||
          lookahead == 'v') ADVANCE(13);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 's') ADVANCE(210);
      END_STATE();
    case 218:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E' ||
          lookahead == 'y') ADVANCE(13);
      if (lookahead == 'a') ADVANCE(1527);
      if (lookahead == 'c') ADVANCE(1917);
      if (lookahead == 'e') ADVANCE(105);
      if (lookahead == 'i') ADVANCE(1666);
      if (lookahead == 'n') ADVANCE(314);
      if (lookahead == 'p') ADVANCE(1522);
      if (lookahead == 's') ADVANCE(1104);
      END_STATE();
    case 219:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'a' ||
          lookahead == 'h') ADVANCE(13);
      END_STATE();
    case 220:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'b' ||
          lookahead == 'e') ADVANCE(13);
      END_STATE();
    case 221:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'c' ||
          lookahead == 'w') ADVANCE(13);
      END_STATE();
    case 222:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e' ||
          lookahead == 'g') ADVANCE(13);
      END_STATE();
    case 223:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e' ||
          lookahead == 'l') ADVANCE(13);
      END_STATE();
    case 224:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'f' ||
          lookahead == 'v') ADVANCE(13);
      END_STATE();
    case 225:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'd' ||
          lookahead == 'e') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(775);
      END_STATE();
    case 226:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(13);
      END_STATE();
    case 227:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(1865);
      END_STATE();
    case 228:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E' ||
          lookahead == 'a' ||
          lookahead == 'j') ADVANCE(13);
      END_STATE();
    case 229:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'E' ||
          lookahead == 'd' ||
          lookahead == 'y') ADVANCE(13);
      if (lookahead == 'i') ADVANCE(1629);
      if (lookahead == 'u') ADVANCE(1844);
      END_STATE();
    case 230:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'D' ||
          lookahead == 'U' ||
          lookahead == 'd' ||
          lookahead == 'u') ADVANCE(13);
      END_STATE();
    case 231:
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'H' ||
          lookahead == 'L' ||
          lookahead == 'R' ||
          lookahead == 'h' ||
          lookahead == 'l' ||
          lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 232:
      if (lookahead == ';') ADVANCE(2034);
      END_STATE();
    case 233:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(234);
      END_STATE();
    case 234:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(232);
      END_STATE();
    case 235:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(233);
      END_STATE();
    case 236:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(235);
      END_STATE();
    case 237:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(236);
      END_STATE();
    case 238:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(237);
      END_STATE();
    case 239:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(232);
      END_STATE();
    case 240:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(239);
      END_STATE();
    case 241:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(240);
      END_STATE();
    case 242:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(241);
      END_STATE();
    case 243:
      if (lookahead == ';') ADVANCE(2034);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(242);
      END_STATE();
    case 244:
      if (lookahead == '>') ADVANCE(2074);
      END_STATE();
    case 245:
      if (lookahead == '>') ADVANCE(2076);
      END_STATE();
    case 246:
      if (lookahead == 'A') ADVANCE(360);
      if (lookahead == 'a') ADVANCE(674);
      if (lookahead == 'c') ADVANCE(1138);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(1227);
      if (lookahead == 'o') ADVANCE(1532);
      if (lookahead == 's') ADVANCE(648);
      if (lookahead == 'u') ADVANCE(1325);
      END_STATE();
    case 247:
      if (lookahead == 'A') ADVANCE(443);
      if (lookahead == 'B') ADVANCE(433);
      if (lookahead == 'H') ADVANCE(396);
      if (lookahead == 'a') ADVANCE(621);
      if (lookahead == 'b') ADVANCE(434);
      if (lookahead == 'c') ADVANCE(460);
      if (lookahead == 'd') ADVANCE(651);
      if (lookahead == 'e') ADVANCE(68);
      if (lookahead == 'f') ADVANCE(1110);
      if (lookahead == 'h') ADVANCE(479);
      if (lookahead == 'i') ADVANCE(1000);
      if (lookahead == 'l') ADVANCE(439);
      if (lookahead == 'm') ADVANCE(1510);
      if (lookahead == 'n') ADVANCE(1326);
      if (lookahead == 'o') ADVANCE(405);
      if (lookahead == 'p') ADVANCE(486);
      if (lookahead == 'r') ADVANCE(433);
      if (lookahead == 's') ADVANCE(385);
      if (lookahead == 't') ADVANCE(1066);
      if (lookahead == 'u') ADVANCE(1252);
      if (lookahead == 'x') ADVANCE(13);
      END_STATE();
    case 248:
      if (lookahead == 'A') ADVANCE(603);
      if (lookahead == 'I') ADVANCE(603);
      if (lookahead == 'U') ADVANCE(603);
      if (lookahead == 'a') ADVANCE(661);
      if (lookahead == 'c') ADVANCE(1140);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 'u') ADVANCE(1334);
      END_STATE();
    case 249:
      if (lookahead == 'A') ADVANCE(300);
      END_STATE();
    case 250:
      if (lookahead == 'A') ADVANCE(1424);
      if (lookahead == 'C') ADVANCE(937);
      if (lookahead == 'D') ADVANCE(1442);
      if (lookahead == 'F') ADVANCE(1251);
      if (lookahead == 'R') ADVANCE(1173);
      if (lookahead == 'T') ADVANCE(882);
      if (lookahead == 'U') ADVANCE(1540);
      if (lookahead == 'V') ADVANCE(916);
      if (lookahead == 'a') ADVANCE(1730);
      if (lookahead == 'r') ADVANCE(1166);
      END_STATE();
    case 251:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'B') ADVANCE(489);
      if (lookahead == 'D') ADVANCE(429);
      if (lookahead == 'a') ADVANCE(1384);
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'd') ADVANCE(429);
      if (lookahead == 'e') ADVANCE(788);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'l') ADVANCE(1865);
      if (lookahead == 'n') ADVANCE(1781);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'p') ADVANCE(1668);
      if (lookahead == 'r') ADVANCE(1865);
      if (lookahead == 's') ADVANCE(650);
      if (lookahead == 'z') ADVANCE(1113);
      END_STATE();
    case 252:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'E') ADVANCE(13);
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'd') ADVANCE(1599);
      if (lookahead == 'e') ADVANCE(135);
      if (lookahead == 's') ADVANCE(1104);
      if (lookahead == 't') ADVANCE(186);
      END_STATE();
    case 253:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'H') ADVANCE(396);
      if (lookahead == 'a') ADVANCE(983);
      if (lookahead == 'b') ADVANCE(1204);
      if (lookahead == 'c') ADVANCE(465);
      if (lookahead == 'd') ADVANCE(54);
      if (lookahead == 'e') ADVANCE(137);
      if (lookahead == 'f') ADVANCE(1111);
      if (lookahead == 'h') ADVANCE(472);
      if (lookahead == 'i') ADVANCE(444);
      if (lookahead == 'j') ADVANCE(603);
      if (lookahead == 'l') ADVANCE(617);
      if (lookahead == 'o') ADVANCE(1255);
      if (lookahead == 'r') ADVANCE(579);
      if (lookahead == 's') ADVANCE(619);
      if (lookahead == 't') ADVANCE(729);
      if (lookahead == 'u') ADVANCE(438);
      if (lookahead == 'w') ADVANCE(447);
      if (lookahead == 'z') ADVANCE(608);
      END_STATE();
    case 254:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'H') ADVANCE(396);
      if (lookahead == 'a') ADVANCE(662);
      if (lookahead == 'b') ADVANCE(1621);
      if (lookahead == 'c') ADVANCE(1119);
      if (lookahead == 'd') ADVANCE(435);
      if (lookahead == 'f') ADVANCE(1111);
      if (lookahead == 'g') ADVANCE(1660);
      if (lookahead == 'h') ADVANCE(473);
      if (lookahead == 'l') ADVANCE(710);
      if (lookahead == 'm') ADVANCE(56);
      if (lookahead == 'o') ADVANCE(987);
      if (lookahead == 'p') ADVANCE(544);
      if (lookahead == 'r') ADVANCE(709);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 't') ADVANCE(726);
      if (lookahead == 'u') ADVANCE(440);
      if (lookahead == 'w') ADVANCE(447);
      END_STATE();
    case 255:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'a') ADVANCE(1126);
      if (lookahead == 'b') ADVANCE(396);
      if (lookahead == 'c') ADVANCE(1138);
      if (lookahead == 'e') ADVANCE(526);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'k') ADVANCE(1753);
      if (lookahead == 'o') ADVANCE(441);
      if (lookahead == 's') ADVANCE(640);
      if (lookahead == 'y') ADVANCE(581);
      END_STATE();
    case 256:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'a') ADVANCE(1618);
      END_STATE();
    case 257:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'p') ADVANCE(396);
      END_STATE();
    case 258:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'a') ADVANCE(1611);
      if (lookahead == 'c') ADVANCE(198);
      if (lookahead == 'm') ADVANCE(1072);
      if (lookahead == 's') ADVANCE(1971);
      if (lookahead == 't') ADVANCE(1320);
      if (lookahead == 'x') ADVANCE(1807);
      END_STATE();
    case 259:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'a') ADVANCE(1611);
      if (lookahead == 'n') ADVANCE(1971);
      END_STATE();
    case 260:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'a') ADVANCE(1611);
      if (lookahead == 'n') ADVANCE(826);
      END_STATE();
    case 261:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'a') ADVANCE(1710);
      if (lookahead == 'i') ADVANCE(1003);
      if (lookahead == 't') ADVANCE(1693);
      END_STATE();
    case 262:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 't') ADVANCE(185);
      END_STATE();
    case 263:
      if (lookahead == 'A') ADVANCE(1618);
      if (lookahead == 't') ADVANCE(1688);
      END_STATE();
    case 264:
      if (lookahead == 'A') ADVANCE(1733);
      if (lookahead == 'D') ADVANCE(1501);
      if (lookahead == 'E') ADVANCE(1592);
      if (lookahead == 'T') ADVANCE(867);
      if (lookahead == 'a') ADVANCE(1730);
      if (lookahead == 'd') ADVANCE(1508);
      if (lookahead == 'p') ADVANCE(876);
      if (lookahead == 's') ADVANCE(1089);
      END_STATE();
    case 265:
      if (lookahead == 'A') ADVANCE(667);
      END_STATE();
    case 266:
      if (lookahead == 'A') ADVANCE(667);
      if (lookahead == 'D') ADVANCE(1445);
      if (lookahead == 'G') ADVANCE(1651);
      if (lookahead == 'T') ADVANCE(1167);
      END_STATE();
    case 267:
      if (lookahead == 'A') ADVANCE(1249);
      END_STATE();
    case 268:
      if (lookahead == 'A') ADVANCE(1425);
      if (lookahead == 'C') ADVANCE(937);
      if (lookahead == 'D') ADVANCE(1442);
      if (lookahead == 'F') ADVANCE(1251);
      if (lookahead == 'T') ADVANCE(882);
      if (lookahead == 'U') ADVANCE(1540);
      if (lookahead == 'V') ADVANCE(916);
      if (lookahead == 'a') ADVANCE(1730);
      END_STATE();
    case 269:
      if (lookahead == 'A') ADVANCE(1730);
      END_STATE();
    case 270:
      if (lookahead == 'A') ADVANCE(1730);
      if (lookahead == 'D') ADVANCE(1501);
      END_STATE();
    case 271:
      if (lookahead == 'A') ADVANCE(1730);
      if (lookahead == 'R') ADVANCE(1174);
      END_STATE();
    case 272:
      if (lookahead == 'A') ADVANCE(1730);
      if (lookahead == 'R') ADVANCE(1174);
      if (lookahead == 'T') ADVANCE(852);
      END_STATE();
    case 273:
      if (lookahead == 'A') ADVANCE(1730);
      if (lookahead == 'T') ADVANCE(852);
      END_STATE();
    case 274:
      if (lookahead == 'A') ADVANCE(1730);
      if (lookahead == 'V') ADVANCE(921);
      END_STATE();
    case 275:
      if (lookahead == 'A') ADVANCE(1734);
      if (lookahead == 'B') ADVANCE(1598);
      if (lookahead == 'L') ADVANCE(914);
      if (lookahead == 'R') ADVANCE(1172);
      if (lookahead == 'T') ADVANCE(867);
      if (lookahead == 'a') ADVANCE(1730);
      END_STATE();
    case 276:
      if (lookahead == 'B') ADVANCE(399);
      if (lookahead == 'P') ADVANCE(547);
      END_STATE();
    case 277:
      if (lookahead == 'B') ADVANCE(433);
      if (lookahead == 'E') ADVANCE(41);
      if (lookahead == 'a') ADVANCE(671);
      if (lookahead == 'c') ADVANCE(462);
      if (lookahead == 'e') ADVANCE(213);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(1437);
      if (lookahead == 'i') ADVANCE(981);
      if (lookahead == 'o') ADVANCE(1535);
      if (lookahead == 'r') ADVANCE(1166);
      if (lookahead == 's') ADVANCE(634);
      if (lookahead == 'u') ADVANCE(1242);
      END_STATE();
    case 278:
      if (lookahead == 'B') ADVANCE(396);
      END_STATE();
    case 279:
      if (lookahead == 'B') ADVANCE(396);
      if (lookahead == 'L') ADVANCE(1121);
      if (lookahead == 'S') ADVANCE(909);
      if (lookahead == 'T') ADVANCE(1167);
      END_STATE();
    case 280:
      if (lookahead == 'B') ADVANCE(1731);
      END_STATE();
    case 281:
      if (lookahead == 'B') ADVANCE(1723);
      if (lookahead == 'n') ADVANCE(282);
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 't') ADVANCE(24);
      END_STATE();
    case 282:
      if (lookahead == 'B') ADVANCE(1728);
      END_STATE();
    case 283:
      if (lookahead == 'C') ADVANCE(333);
      if (lookahead == 'c') ADVANCE(1987);
      END_STATE();
    case 284:
      if (lookahead == 'C') ADVANCE(422);
      END_STATE();
    case 285:
      if (lookahead == 'C') ADVANCE(1502);
      if (lookahead == 'T') ADVANCE(1153);
      END_STATE();
    case 286:
      if (lookahead == 'C') ADVANCE(1179);
      END_STATE();
    case 287:
      if (lookahead == 'C') ADVANCE(1274);
      END_STATE();
    case 288:
      if (lookahead == 'C') ADVANCE(1936);
      END_STATE();
    case 289:
      if (lookahead == 'C') ADVANCE(1518);
      END_STATE();
    case 290:
      if (lookahead == 'C') ADVANCE(1518);
      if (lookahead == 'D') ADVANCE(1444);
      if (lookahead == 'L') ADVANCE(926);
      if (lookahead == 'R') ADVANCE(1176);
      if (lookahead == 'U') ADVANCE(1541);
      if (lookahead == 'V') ADVANCE(935);
      END_STATE();
    case 291:
      if (lookahead == 'D') ADVANCE(1447);
      END_STATE();
    case 292:
      if (lookahead == 'D') ADVANCE(1447);
      if (lookahead == 'M') ADVANCE(1164);
      if (lookahead == 'P') ADVANCE(1297);
      if (lookahead == 'T') ADVANCE(1153);
      END_STATE();
    case 293:
      if (lookahead == 'D') ADVANCE(1447);
      if (lookahead == 'a') ADVANCE(1618);
      END_STATE();
    case 294:
      if (lookahead == 'D') ADVANCE(1447);
      if (lookahead == 'o') ADVANCE(1807);
      END_STATE();
    case 295:
      if (lookahead == 'D') ADVANCE(1447);
      if (lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 296:
      if (lookahead == 'D') ADVANCE(172);
      if (lookahead == 'J') ADVANCE(603);
      if (lookahead == 'S') ADVANCE(603);
      if (lookahead == 'Z') ADVANCE(603);
      if (lookahead == 'a') ADVANCE(985);
      if (lookahead == 'c') ADVANCE(465);
      if (lookahead == 'e') ADVANCE(1208);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(408);
      if (lookahead == 'o') ADVANCE(1533);
      if (lookahead == 's') ADVANCE(648);
      END_STATE();
    case 297:
      if (lookahead == 'D') ADVANCE(13);
      END_STATE();
    case 298:
      if (lookahead == 'D') ADVANCE(294);
      if (lookahead == 'a') ADVANCE(665);
      if (lookahead == 'c') ADVANCE(463);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'f') ADVANCE(295);
      if (lookahead == 'g') ADVANCE(184);
      if (lookahead == 'l') ADVANCE(151);
      if (lookahead == 'm') ADVANCE(395);
      if (lookahead == 'n') ADVANCE(970);
      if (lookahead == 'o') ADVANCE(987);
      if (lookahead == 'p') ADVANCE(476);
      if (lookahead == 'q') ADVANCE(658);
      if (lookahead == 'r') ADVANCE(293);
      if (lookahead == 's') ADVANCE(628);
      if (lookahead == 't') ADVANCE(219);
      if (lookahead == 'u') ADVANCE(1314);
      if (lookahead == 'x') ADVANCE(686);
      END_STATE();
    case 299:
      if (lookahead == 'D') ADVANCE(291);
      if (lookahead == 'a') ADVANCE(613);
      if (lookahead == 'c') ADVANCE(1503);
      if (lookahead == 'd') ADVANCE(429);
      if (lookahead == 'e') ADVANCE(511);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(1437);
      if (lookahead == 'i') ADVANCE(702);
      if (lookahead == 'l') ADVANCE(666);
      if (lookahead == 'n') ADVANCE(1557);
      if (lookahead == 'o') ADVANCE(766);
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 's') ADVANCE(647);
      if (lookahead == 'u') ADVANCE(157);
      END_STATE();
    case 300:
      if (lookahead == 'D') ADVANCE(313);
      END_STATE();
    case 301:
      if (lookahead == 'D') ADVANCE(2025);
      if (lookahead == 'H') ADVANCE(230);
      if (lookahead == 'U') ADVANCE(2025);
      if (lookahead == 'V') ADVANCE(231);
      if (lookahead == 'b') ADVANCE(1452);
      if (lookahead == 'd') ADVANCE(2025);
      if (lookahead == 'h') ADVANCE(230);
      if (lookahead == 'm') ADVANCE(1164);
      if (lookahead == 'p') ADVANCE(1297);
      if (lookahead == 't') ADVANCE(1153);
      if (lookahead == 'u') ADVANCE(2025);
      if (lookahead == 'v') ADVANCE(231);
      END_STATE();
    case 302:
      if (lookahead == 'D') ADVANCE(603);
      END_STATE();
    case 303:
      if (lookahead == 'D') ADVANCE(429);
      if (lookahead == 'H') ADVANCE(433);
      if (lookahead == 'a') ADVANCE(1526);
      if (lookahead == 'd') ADVANCE(429);
      if (lookahead == 'g') ADVANCE(2015);
      if (lookahead == 'i') ADVANCE(1371);
      if (lookahead == 'l') ADVANCE(262);
      if (lookahead == 'r') ADVANCE(263);
      if (lookahead == 's') ADVANCE(1104);
      END_STATE();
    case 304:
      if (lookahead == 'D') ADVANCE(429);
      if (lookahead == 'b') ADVANCE(396);
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'd') ADVANCE(432);
      if (lookahead == 'e') ADVANCE(778);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 'v') ADVANCE(746);
      END_STATE();
    case 305:
      if (lookahead == 'D') ADVANCE(429);
      if (lookahead == 'd') ADVANCE(429);
      END_STATE();
    case 306:
      if (lookahead == 'D') ADVANCE(1501);
      if (lookahead == 'L') ADVANCE(923);
      if (lookahead == 'R') ADVANCE(1174);
      if (lookahead == 'U') ADVANCE(1545);
      END_STATE();
    case 307:
      if (lookahead == 'D') ADVANCE(1103);
      END_STATE();
    case 308:
      if (lookahead == 'D') ADVANCE(869);
      END_STATE();
    case 309:
      if (lookahead == 'D') ADVANCE(1509);
      if (lookahead == 'E') ADVANCE(1589);
      END_STATE();
    case 310:
      if (lookahead == 'D') ADVANCE(1513);
      if (lookahead == 'T') ADVANCE(888);
      if (lookahead == 'V') ADVANCE(916);
      END_STATE();
    case 311:
      if (lookahead == 'D') ADVANCE(1523);
      if (lookahead == 'Q') ADVANCE(1947);
      END_STATE();
    case 312:
      if (lookahead == 'E') ADVANCE(1247);
      if (lookahead == 'M') ADVANCE(48);
      if (lookahead == 'a') ADVANCE(661);
      if (lookahead == 'b') ADVANCE(1598);
      if (lookahead == 'c') ADVANCE(1119);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'g') ADVANCE(1660);
      if (lookahead == 'l') ADVANCE(1528);
      if (lookahead == 'm') ADVANCE(391);
      if (lookahead == 'n') ADVANCE(730);
      if (lookahead == 'o') ADVANCE(987);
      if (lookahead == 'p') ADVANCE(1553);
      if (lookahead == 'r') ADVANCE(1094);
      if (lookahead == 's') ADVANCE(645);
      if (lookahead == 't') ADVANCE(1141);
      if (lookahead == 'u') ADVANCE(1313);
      END_STATE();
    case 313:
      if (lookahead == 'E') ADVANCE(13);
      END_STATE();
    case 314:
      if (lookahead == 'E') ADVANCE(13);
      if (lookahead == 'a') ADVANCE(1526);
      if (lookahead == 's') ADVANCE(1104);
      END_STATE();
    case 315:
      if (lookahead == 'E') ADVANCE(13);
      if (lookahead == 'a') ADVANCE(1544);
      if (lookahead == 'e') ADVANCE(181);
      if (lookahead == 's') ADVANCE(1104);
      END_STATE();
    case 316:
      if (lookahead == 'E') ADVANCE(13);
      if (lookahead == 'e') ADVANCE(180);
      if (lookahead == 's') ADVANCE(1104);
      if (lookahead == 't') ADVANCE(183);
      END_STATE();
    case 317:
      if (lookahead == 'E') ADVANCE(1220);
      if (lookahead == 'U') ADVANCE(1576);
      END_STATE();
    case 318:
      if (lookahead == 'E') ADVANCE(603);
      if (lookahead == 'J') ADVANCE(1253);
      if (lookahead == 'O') ADVANCE(603);
      if (lookahead == 'a') ADVANCE(661);
      if (lookahead == 'c') ADVANCE(1119);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'g') ADVANCE(1660);
      if (lookahead == 'm') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(1835);
      if (lookahead == 'o') ADVANCE(988);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 't') ADVANCE(1167);
      if (lookahead == 'u') ADVANCE(1196);
      END_STATE();
    case 319:
      if (lookahead == 'E') ADVANCE(1219);
      END_STATE();
    case 320:
      if (lookahead == 'E') ADVANCE(1253);
      if (lookahead == 'a') ADVANCE(661);
      if (lookahead == 'c') ADVANCE(1119);
      if (lookahead == 'd') ADVANCE(601);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'g') ADVANCE(1660);
      if (lookahead == 'm') ADVANCE(393);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'p') ADVANCE(839);
      if (lookahead == 'r') ADVANCE(13);
      if (lookahead == 's') ADVANCE(642);
      if (lookahead == 't') ADVANCE(1088);
      if (lookahead == 'u') ADVANCE(1313);
      if (lookahead == 'v') ADVANCE(854);
      END_STATE();
    case 321:
      if (lookahead == 'E') ADVANCE(1592);
      END_STATE();
    case 322:
      if (lookahead == 'E') ADVANCE(1589);
      END_STATE();
    case 323:
      if (lookahead == 'E') ADVANCE(1594);
      if (lookahead == 'F') ADVANCE(1946);
      if (lookahead == 'G') ADVANCE(1739);
      if (lookahead == 'L') ADVANCE(821);
      if (lookahead == 'S') ADVANCE(1307);
      if (lookahead == 'T') ADVANCE(1167);
      END_STATE();
    case 324:
      if (lookahead == 'E') ADVANCE(1595);
      if (lookahead == 'F') ADVANCE(1946);
      if (lookahead == 'G') ADVANCE(1739);
      if (lookahead == 'L') ADVANCE(821);
      if (lookahead == 'S') ADVANCE(1307);
      if (lookahead == 'T') ADVANCE(1167);
      END_STATE();
    case 325:
      if (lookahead == 'F') ADVANCE(368);
      END_STATE();
    case 326:
      if (lookahead == 'F') ADVANCE(1940);
      END_STATE();
    case 327:
      if (lookahead == 'G') ADVANCE(13);
      END_STATE();
    case 328:
      if (lookahead == 'G') ADVANCE(971);
      if (lookahead == 'L') ADVANCE(902);
      if (lookahead == 'R') ADVANCE(1166);
      if (lookahead == 'V') ADVANCE(305);
      if (lookahead == 'a') ADVANCE(585);
      if (lookahead == 'b') ADVANCE(1754);
      if (lookahead == 'c') ADVANCE(416);
      if (lookahead == 'd') ADVANCE(429);
      if (lookahead == 'e') ADVANCE(15);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'g') ADVANCE(316);
      if (lookahead == 'h') ADVANCE(257);
      if (lookahead == 'i') ADVANCE(189);
      if (lookahead == 'j') ADVANCE(603);
      if (lookahead == 'l') ADVANCE(252);
      if (lookahead == 'm') ADVANCE(1071);
      if (lookahead == 'o') ADVANCE(176);
      if (lookahead == 'p') ADVANCE(484);
      if (lookahead == 'r') ADVANCE(261);
      if (lookahead == 's') ADVANCE(620);
      if (lookahead == 't') ADVANCE(991);
      if (lookahead == 'u') ADVANCE(160);
      if (lookahead == 'v') ADVANCE(303);
      if (lookahead == 'w') ADVANCE(260);
      END_STATE();
    case 329:
      if (lookahead == 'G') ADVANCE(1739);
      END_STATE();
    case 330:
      if (lookahead == 'G') ADVANCE(1748);
      if (lookahead == 'L') ADVANCE(904);
      END_STATE();
    case 331:
      if (lookahead == 'H') ADVANCE(283);
      if (lookahead == 'O') ADVANCE(325);
      if (lookahead == 'a') ADVANCE(667);
      if (lookahead == 'c') ADVANCE(67);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(1504);
      if (lookahead == 'i') ADVANCE(989);
      if (lookahead == 'm') ADVANCE(509);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'q') ADVANCE(1625);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 't') ADVANCE(396);
      if (lookahead == 'u') ADVANCE(569);
      END_STATE();
    case 332:
      if (lookahead == 'H') ADVANCE(353);
      if (lookahead == 'R') ADVANCE(249);
      if (lookahead == 'S') ADVANCE(337);
      if (lookahead == 'a') ADVANCE(2012);
      if (lookahead == 'c') ADVANCE(462);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(810);
      if (lookahead == 'i') ADVANCE(1236);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'r') ADVANCE(1146);
      if (lookahead == 's') ADVANCE(648);
      END_STATE();
    case 333:
      if (lookahead == 'H') ADVANCE(603);
      END_STATE();
    case 334:
      if (lookahead == 'H') ADVANCE(603);
      if (lookahead == 'J') ADVANCE(603);
      if (lookahead == 'a') ADVANCE(1550);
      if (lookahead == 'c') ADVANCE(832);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      END_STATE();
    case 335:
      if (lookahead == 'H') ADVANCE(603);
      if (lookahead == 'O') ADVANCE(354);
      if (lookahead == 'a') ADVANCE(673);
      if (lookahead == 'c') ADVANCE(461);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(763);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(1072);
      if (lookahead == 'i') ADVANCE(1646);
      if (lookahead == 'l') ADVANCE(1451);
      if (lookahead == 'o') ADVANCE(1291);
      if (lookahead == 'r') ADVANCE(1453);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 'u') ADVANCE(1536);
      END_STATE();
    case 336:
      if (lookahead == 'H') ADVANCE(603);
      if (lookahead == 'a') ADVANCE(667);
      if (lookahead == 'c') ADVANCE(465);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(1656);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      END_STATE();
    case 337:
      if (lookahead == 'H') ADVANCE(603);
      if (lookahead == 'c') ADVANCE(1987);
      END_STATE();
    case 338:
      if (lookahead == 'H') ADVANCE(1948);
      END_STATE();
    case 339:
      if (lookahead == 'I') ADVANCE(13);
      END_STATE();
    case 340:
      if (lookahead == 'I') ADVANCE(1347);
      END_STATE();
    case 341:
      if (lookahead == 'I') ADVANCE(1414);
      END_STATE();
    case 342:
      if (lookahead == 'J') ADVANCE(603);
      if (lookahead == 'a') ADVANCE(667);
      if (lookahead == 'c') ADVANCE(462);
      if (lookahead == 'e') ADVANCE(992);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(281);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 't') ADVANCE(1141);
      if (lookahead == 'u') ADVANCE(13);
      END_STATE();
    case 343:
      if (lookahead == 'L') ADVANCE(821);
      END_STATE();
    case 344:
      if (lookahead == 'L') ADVANCE(1121);
      END_STATE();
    case 345:
      if (lookahead == 'L') ADVANCE(919);
      if (lookahead == 'R') ADVANCE(1174);
      END_STATE();
    case 346:
      if (lookahead == 'L') ADVANCE(919);
      if (lookahead == 'R') ADVANCE(1174);
      if (lookahead == 'l') ADVANCE(901);
      if (lookahead == 'r') ADVANCE(1166);
      END_STATE();
    case 347:
      if (lookahead == 'L') ADVANCE(923);
      if (lookahead == 'R') ADVANCE(1174);
      END_STATE();
    case 348:
      if (lookahead == 'M') ADVANCE(905);
      if (lookahead == 'T') ADVANCE(1054);
      if (lookahead == 'V') ADVANCE(893);
      END_STATE();
    case 349:
      if (lookahead == 'M') ADVANCE(1164);
      END_STATE();
    case 350:
      if (lookahead == 'N') ADVANCE(1447);
      if (lookahead == 'a') ADVANCE(657);
      if (lookahead == 'b') ADVANCE(1642);
      if (lookahead == 'c') ADVANCE(1468);
      if (lookahead == 'd') ADVANCE(1588);
      if (lookahead == 'e') ADVANCE(722);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(972);
      if (lookahead == 'k') ADVANCE(527);
      if (lookahead == 'l') ADVANCE(409);
      if (lookahead == 'n') ADVANCE(787);
      if (lookahead == 'o') ADVANCE(1534);
      if (lookahead == 'p') ADVANCE(1669);
      if (lookahead == 'r') ADVANCE(785);
      if (lookahead == 's') ADVANCE(629);
      if (lookahead == 'u') ADVANCE(1254);
      END_STATE();
    case 351:
      if (lookahead == 'N') ADVANCE(327);
      if (lookahead == 'T') ADVANCE(42);
      if (lookahead == 'a') ADVANCE(661);
      if (lookahead == 'c') ADVANCE(464);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'g') ADVANCE(1660);
      if (lookahead == 'l') ADVANCE(906);
      if (lookahead == 'm') ADVANCE(394);
      if (lookahead == 'o') ADVANCE(987);
      if (lookahead == 'p') ADVANCE(1803);
      if (lookahead == 'q') ADVANCE(1900);
      if (lookahead == 's') ADVANCE(637);
      if (lookahead == 't') ADVANCE(382);
      if (lookahead == 'u') ADVANCE(1313);
      if (lookahead == 'x') ADVANCE(1097);
      END_STATE();
    case 352:
      if (lookahead == 'O') ADVANCE(50);
      END_STATE();
    case 353:
      if (lookahead == 'O') ADVANCE(359);
      END_STATE();
    case 354:
      if (lookahead == 'P') ADVANCE(52);
      END_STATE();
    case 355:
      if (lookahead == 'P') ADVANCE(396);
      END_STATE();
    case 356:
      if (lookahead == 'P') ADVANCE(396);
      if (lookahead == 'i') ADVANCE(226);
      END_STATE();
    case 357:
      if (lookahead == 'P') ADVANCE(1297);
      END_STATE();
    case 358:
      if (lookahead == 'Q') ADVANCE(1947);
      END_STATE();
    case 359:
      if (lookahead == 'R') ADVANCE(47);
      END_STATE();
    case 360:
      if (lookahead == 'R') ADVANCE(302);
      END_STATE();
    case 361:
      if (lookahead == 'R') ADVANCE(1177);
      if (lookahead == 'T') ADVANCE(888);
      if (lookahead == 'V') ADVANCE(916);
      END_STATE();
    case 362:
      if (lookahead == 'S') ADVANCE(13);
      if (lookahead == 'a') ADVANCE(664);
      if (lookahead == 'c') ADVANCE(1119);
      if (lookahead == 'd') ADVANCE(430);
      if (lookahead == 'e') ADVANCE(1253);
      if (lookahead == 'f') ADVANCE(700);
      if (lookahead == 'g') ADVANCE(1479);
      if (lookahead == 'h') ADVANCE(576);
      if (lookahead == 'i') ADVANCE(1366);
      if (lookahead == 'l') ADVANCE(436);
      if (lookahead == 'm') ADVANCE(392);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'p') ADVANCE(397);
      if (lookahead == 'r') ADVANCE(63);
      if (lookahead == 's') ADVANCE(643);
      if (lookahead == 't') ADVANCE(1136);
      if (lookahead == 'u') ADVANCE(1313);
      if (lookahead == 'v') ADVANCE(574);
      END_STATE();
    case 363:
      if (lookahead == 'S') ADVANCE(1351);
      END_STATE();
    case 364:
      if (lookahead == 'S') ADVANCE(1351);
      if (lookahead == 'V') ADVANCE(891);
      END_STATE();
    case 365:
      if (lookahead == 'S') ADVANCE(1569);
      END_STATE();
    case 366:
      if (lookahead == 'S') ADVANCE(1910);
      END_STATE();
    case 367:
      if (lookahead == 'S') ADVANCE(1596);
      END_STATE();
    case 368:
      if (lookahead == 'T') ADVANCE(603);
      END_STATE();
    case 369:
      if (lookahead == 'T') ADVANCE(1068);
      END_STATE();
    case 370:
      if (lookahead == 'T') ADVANCE(1049);
      END_STATE();
    case 371:
      if (lookahead == 'T') ADVANCE(888);
      if (lookahead == 'V') ADVANCE(916);
      END_STATE();
    case 372:
      if (lookahead == 'T') ADVANCE(1750);
      END_STATE();
    case 373:
      if (lookahead == 'U') ADVANCE(352);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      END_STATE();
    case 374:
      if (lookahead == 'V') ADVANCE(935);
      END_STATE();
    case 375:
      if (lookahead == 'V') ADVANCE(921);
      END_STATE();
    case 376:
      if (lookahead == 'W') ADVANCE(1123);
      END_STATE();
    case 377:
      if (lookahead == ']') ADVANCE(2078);
      END_STATE();
    case 378:
      if (lookahead == ']') ADVANCE(2079);
      END_STATE();
    case 379:
      if (lookahead == 'a') ADVANCE(661);
      if (lookahead == 'b') ADVANCE(1598);
      if (lookahead == 'c') ADVANCE(229);
      if (lookahead == 'e') ADVANCE(1247);
      if (lookahead == 'f') ADVANCE(183);
      if (lookahead == 'g') ADVANCE(1660);
      if (lookahead == 'l') ADVANCE(786);
      if (lookahead == 'm') ADVANCE(58);
      if (lookahead == 'n') ADVANCE(734);
      if (lookahead == 'o') ADVANCE(987);
      if (lookahead == 'p') ADVANCE(214);
      if (lookahead == 'r') ADVANCE(1094);
      if (lookahead == 's') ADVANCE(646);
      if (lookahead == 't') ADVANCE(1141);
      if (lookahead == 'u') ADVANCE(1313);
      if (lookahead == 'w') ADVANCE(682);
      END_STATE();
    case 380:
      if (lookahead == 'a') ADVANCE(661);
      if (lookahead == 'c') ADVANCE(145);
      if (lookahead == 'e') ADVANCE(610);
      if (lookahead == 'f') ADVANCE(2016);
      if (lookahead == 'g') ADVANCE(1660);
      if (lookahead == 'i') ADVANCE(143);
      if (lookahead == 'j') ADVANCE(1253);
      if (lookahead == 'm') ADVANCE(388);
      if (lookahead == 'n') ADVANCE(97);
      if (lookahead == 'o') ADVANCE(607);
      if (lookahead == 'p') ADVANCE(1659);
      if (lookahead == 'q') ADVANCE(1915);
      if (lookahead == 's') ADVANCE(639);
      if (lookahead == 't') ADVANCE(150);
      if (lookahead == 'u') ADVANCE(1196);
      END_STATE();
    case 381:
      if (lookahead == 'a') ADVANCE(653);
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'e') ADVANCE(688);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'r') ADVANCE(784);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 'u') ADVANCE(1324);
      END_STATE();
    case 382:
      if (lookahead == 'a') ADVANCE(13);
      END_STATE();
    case 383:
      if (lookahead == 'a') ADVANCE(183);
      END_STATE();
    case 384:
      if (lookahead == 'a') ADVANCE(1588);
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(13);
      if (lookahead == 'i') ADVANCE(1318);
      if (lookahead == 'q') ADVANCE(568);
      if (lookahead == 't') ADVANCE(1670);
      END_STATE();
    case 385:
      if (lookahead == 'a') ADVANCE(1588);
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(13);
      if (lookahead == 'q') ADVANCE(568);
      END_STATE();
    case 386:
      if (lookahead == 'a') ADVANCE(672);
      if (lookahead == 'c') ADVANCE(411);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(756);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(605);
      if (lookahead == 'i') ADVANCE(1603);
      if (lookahead == 'l') ADVANCE(1905);
      if (lookahead == 'o') ADVANCE(1301);
      if (lookahead == 'r') ADVANCE(442);
      if (lookahead == 's') ADVANCE(649);
      if (lookahead == 't') ADVANCE(725);
      if (lookahead == 'u') ADVANCE(773);
      if (lookahead == 'w') ADVANCE(682);
      if (lookahead == 'y') ADVANCE(1244);
      END_STATE();
    case 387:
      if (lookahead == 'a') ADVANCE(1962);
      END_STATE();
    case 388:
      if (lookahead == 'a') ADVANCE(632);
      if (lookahead == 'o') ADVANCE(945);
      if (lookahead == 'p') ADVANCE(774);
      END_STATE();
    case 389:
      if (lookahead == 'a') ADVANCE(1261);
      if (lookahead == 'e') ADVANCE(1574);
      if (lookahead == 'i') ADVANCE(732);
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 390:
      if (lookahead == 'a') ADVANCE(224);
      END_STATE();
    case 391:
      if (lookahead == 'a') ADVANCE(627);
      END_STATE();
    case 392:
      if (lookahead == 'a') ADVANCE(627);
      if (lookahead == 'e') ADVANCE(980);
      if (lookahead == 'i') ADVANCE(694);
      END_STATE();
    case 393:
      if (lookahead == 'a') ADVANCE(627);
      if (lookahead == 'e') ADVANCE(980);
      if (lookahead == 'i') ADVANCE(693);
      END_STATE();
    case 394:
      if (lookahead == 'a') ADVANCE(627);
      if (lookahead == 'p') ADVANCE(1834);
      END_STATE();
    case 395:
      if (lookahead == 'a') ADVANCE(627);
      if (lookahead == 'p') ADVANCE(1843);
      if (lookahead == 's') ADVANCE(1539);
      END_STATE();
    case 396:
      if (lookahead == 'a') ADVANCE(1599);
      END_STATE();
    case 397:
      if (lookahead == 'a') ADVANCE(1599);
      if (lookahead == 'e') ADVANCE(1647);
      if (lookahead == 'l') ADVANCE(1914);
      END_STATE();
    case 398:
      if (lookahead == 'a') ADVANCE(1599);
      if (lookahead == 'f') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(1914);
      END_STATE();
    case 399:
      if (lookahead == 'a') ADVANCE(1599);
      if (lookahead == 'r') ADVANCE(477);
      END_STATE();
    case 400:
      if (lookahead == 'a') ADVANCE(663);
      if (lookahead == 'b') ADVANCE(1621);
      if (lookahead == 'c') ADVANCE(1119);
      if (lookahead == 'd') ADVANCE(601);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'g') ADVANCE(1660);
      if (lookahead == 'm') ADVANCE(391);
      if (lookahead == 'n') ADVANCE(744);
      if (lookahead == 'o') ADVANCE(987);
      if (lookahead == 'p') ADVANCE(264);
      if (lookahead == 'r') ADVANCE(1109);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 't') ADVANCE(1167);
      if (lookahead == 'u') ADVANCE(1313);
      END_STATE();
    case 401:
      if (lookahead == 'a') ADVANCE(1366);
      END_STATE();
    case 402:
      if (lookahead == 'a') ADVANCE(210);
      END_STATE();
    case 403:
      if (lookahead == 'a') ADVANCE(1724);
      if (lookahead == 'b') ADVANCE(1653);
      if (lookahead == 'c') ADVANCE(462);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(1302);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(816);
      if (lookahead == 'i') ADVANCE(1290);
      if (lookahead == 'o') ADVANCE(808);
      if (lookahead == 'p') ADVANCE(1669);
      if (lookahead == 'r') ADVANCE(514);
      if (lookahead == 's') ADVANCE(618);
      if (lookahead == 'w') ADVANCE(1076);
      END_STATE();
    case 404:
      if (lookahead == 'a') ADVANCE(1375);
      if (lookahead == 'b') ADVANCE(1653);
      if (lookahead == 'n') ADVANCE(978);
      if (lookahead == 'o') ADVANCE(1575);
      if (lookahead == 'p') ADVANCE(398);
      if (lookahead == 't') ADVANCE(1153);
      if (lookahead == 'w') ADVANCE(446);
      if (lookahead == 'z') ADVANCE(125);
      END_STATE();
    case 405:
      if (lookahead == 'a') ADVANCE(1375);
      if (lookahead == 'b') ADVANCE(1653);
      if (lookahead == 'p') ADVANCE(398);
      if (lookahead == 't') ADVANCE(1153);
      END_STATE();
    case 406:
      if (lookahead == 'a') ADVANCE(1807);
      END_STATE();
    case 407:
      if (lookahead == 'a') ADVANCE(1807);
      if (lookahead == 'l') ADVANCE(1101);
      if (lookahead == 't') ADVANCE(1381);
      END_STATE();
    case 408:
      if (lookahead == 'a') ADVANCE(716);
      if (lookahead == 'f') ADVANCE(956);
      END_STATE();
    case 409:
      if (lookahead == 'a') ADVANCE(683);
      if (lookahead == 'k') ADVANCE(6);
      if (lookahead == 'o') ADVANCE(676);
      END_STATE();
    case 410:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 411:
      if (lookahead == 'a') ADVANCE(1551);
      if (lookahead == 'e') ADVANCE(755);
      if (lookahead == 'i') ADVANCE(1666);
      if (lookahead == 'u') ADVANCE(1559);
      END_STATE();
    case 412:
      if (lookahead == 'a') ADVANCE(767);
      END_STATE();
    case 413:
      if (lookahead == 'a') ADVANCE(191);
      END_STATE();
    case 414:
      if (lookahead == 'a') ADVANCE(1960);
      END_STATE();
    case 415:
      if (lookahead == 'a') ADVANCE(623);
      if (lookahead == 'o') ADVANCE(1975);
      END_STATE();
    case 416:
      if (lookahead == 'a') ADVANCE(1527);
      if (lookahead == 'e') ADVANCE(770);
      if (lookahead == 'o') ADVANCE(1388);
      if (lookahead == 'u') ADVANCE(1526);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 417:
      if (lookahead == 'a') ADVANCE(198);
      END_STATE();
    case 418:
      if (lookahead == 'a') ADVANCE(622);
      if (lookahead == 'c') ADVANCE(1140);
      if (lookahead == 'e') ADVANCE(162);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(603);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 'u') ADVANCE(609);
      END_STATE();
    case 419:
      if (lookahead == 'a') ADVANCE(1649);
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(1072);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(1909);
      if (lookahead == 'o') ADVANCE(1137);
      if (lookahead == 'r') ADVANCE(118);
      if (lookahead == 's') ADVANCE(636);
      END_STATE();
    case 420:
      if (lookahead == 'a') ADVANCE(1550);
      END_STATE();
    case 421:
      if (lookahead == 'a') ADVANCE(1562);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(1583);
      if (lookahead == 'l') ADVANCE(821);
      if (lookahead == 's') ADVANCE(1104);
      END_STATE();
    case 422:
      if (lookahead == 'a') ADVANCE(1526);
      END_STATE();
    case 423:
      if (lookahead == 'a') ADVANCE(1526);
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'e') ADVANCE(751);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(1405);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 'u') ADVANCE(13);
      END_STATE();
    case 424:
      if (lookahead == 'a') ADVANCE(1526);
      if (lookahead == 'i') ADVANCE(1666);
      if (lookahead == 'u') ADVANCE(1526);
      END_STATE();
    case 425:
      if (lookahead == 'a') ADVANCE(1526);
      if (lookahead == 's') ADVANCE(1104);
      END_STATE();
    case 426:
      if (lookahead == 'a') ADVANCE(1526);
      if (lookahead == 'u') ADVANCE(1526);
      END_STATE();
    case 427:
      if (lookahead == 'a') ADVANCE(969);
      END_STATE();
    case 428:
      if (lookahead == 'a') ADVANCE(1309);
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'e') ADVANCE(1339);
      if (lookahead == 'f') ADVANCE(1134);
      if (lookahead == 'i') ADVANCE(1253);
      if (lookahead == 'j') ADVANCE(1253);
      if (lookahead == 'l') ADVANCE(407);
      if (lookahead == 'n') ADVANCE(1439);
      if (lookahead == 'o') ADVANCE(1530);
      if (lookahead == 'p') ADVANCE(517);
      if (lookahead == 'r') ADVANCE(415);
      if (lookahead == 's') ADVANCE(627);
      END_STATE();
    case 429:
      if (lookahead == 'a') ADVANCE(1773);
      END_STATE();
    case 430:
      if (lookahead == 'a') ADVANCE(1773);
      if (lookahead == 'b') ADVANCE(1287);
      if (lookahead == 'i') ADVANCE(1957);
      if (lookahead == 'o') ADVANCE(1807);
      if (lookahead == 's') ADVANCE(1489);
      END_STATE();
    case 431:
      if (lookahead == 'a') ADVANCE(1188);
      END_STATE();
    case 432:
      if (lookahead == 'a') ADVANCE(1776);
      END_STATE();
    case 433:
      if (lookahead == 'a') ADVANCE(1618);
      END_STATE();
    case 434:
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'b') ADVANCE(1653);
      if (lookahead == 'r') ADVANCE(467);
      END_STATE();
    case 435:
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'b') ADVANCE(1287);
      if (lookahead == 'h') ADVANCE(396);
      END_STATE();
    case 436:
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'c') ADVANCE(1083);
      if (lookahead == 'i') ADVANCE(1387);
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 437:
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'c') ADVANCE(1498);
      if (lookahead == 'h') ADVANCE(498);
      if (lookahead == 'm') ADVANCE(13);
      if (lookahead == 't') ADVANCE(1634);
      END_STATE();
    case 438:
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'h') ADVANCE(396);
      END_STATE();
    case 439:
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'h') ADVANCE(396);
      if (lookahead == 'm') ADVANCE(13);
      END_STATE();
    case 440:
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 441:
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'm') ADVANCE(1849);
      if (lookahead == 'o') ADVANCE(1191);
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 'r') ADVANCE(574);
      END_STATE();
    case 442:
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'o') ADVANCE(1778);
      END_STATE();
    case 443:
      if (lookahead == 'a') ADVANCE(1618);
      if (lookahead == 'r') ADVANCE(1599);
      if (lookahead == 't') ADVANCE(528);
      END_STATE();
    case 444:
      if (lookahead == 'a') ADVANCE(1316);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'g') ADVANCE(510);
      if (lookahead == 's') ADVANCE(1116);
      if (lookahead == 'v') ADVANCE(144);
      END_STATE();
    case 445:
      if (lookahead == 'a') ADVANCE(1998);
      END_STATE();
    case 446:
      if (lookahead == 'a') ADVANCE(1763);
      if (lookahead == 'b') ADVANCE(396);
      END_STATE();
    case 447:
      if (lookahead == 'a') ADVANCE(1386);
      END_STATE();
    case 448:
      if (lookahead == 'a') ADVANCE(1846);
      END_STATE();
    case 449:
      if (lookahead == 'a') ADVANCE(1207);
      END_STATE();
    case 450:
      if (lookahead == 'a') ADVANCE(1605);
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'e') ADVANCE(1606);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(1086);
      if (lookahead == 'i') ADVANCE(204);
      if (lookahead == 'l') ADVANCE(466);
      if (lookahead == 'm') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(1147);
      if (lookahead == 'r') ADVANCE(29);
      if (lookahead == 's') ADVANCE(636);
      if (lookahead == 'u') ADVANCE(1385);
      END_STATE();
    case 451:
      if (lookahead == 'a') ADVANCE(1840);
      if (lookahead == 'e') ADVANCE(1787);
      if (lookahead == 'o') ADVANCE(198);
      END_STATE();
    case 452:
      if (lookahead == 'a') ADVANCE(1031);
      END_STATE();
    case 453:
      if (lookahead == 'a') ADVANCE(1205);
      END_STATE();
    case 454:
      if (lookahead == 'a') ADVANCE(1230);
      if (lookahead == 'l') ADVANCE(1121);
      if (lookahead == 's') ADVANCE(1934);
      END_STATE();
    case 455:
      if (lookahead == 'a') ADVANCE(1653);
      END_STATE();
    case 456:
      if (lookahead == 'a') ADVANCE(1766);
      END_STATE();
    case 457:
      if (lookahead == 'a') ADVANCE(1353);
      END_STATE();
    case 458:
      if (lookahead == 'a') ADVANCE(611);
      END_STATE();
    case 459:
      if (lookahead == 'a') ADVANCE(1387);
      END_STATE();
    case 460:
      if (lookahead == 'a') ADVANCE(1652);
      if (lookahead == 'e') ADVANCE(771);
      if (lookahead == 'u') ADVANCE(567);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 461:
      if (lookahead == 'a') ADVANCE(1652);
      if (lookahead == 'e') ADVANCE(755);
      if (lookahead == 'i') ADVANCE(1666);
      if (lookahead == 'o') ADVANCE(1415);
      END_STATE();
    case 462:
      if (lookahead == 'a') ADVANCE(1652);
      if (lookahead == 'e') ADVANCE(770);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 463:
      if (lookahead == 'a') ADVANCE(1652);
      if (lookahead == 'i') ADVANCE(1629);
      if (lookahead == 'o') ADVANCE(1237);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 464:
      if (lookahead == 'a') ADVANCE(1652);
      if (lookahead == 'i') ADVANCE(1629);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 465:
      if (lookahead == 'a') ADVANCE(1652);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 466:
      if (lookahead == 'a') ADVANCE(1360);
      if (lookahead == 'u') ADVANCE(1757);
      END_STATE();
    case 467:
      if (lookahead == 'a') ADVANCE(625);
      if (lookahead == 'k') ADVANCE(779);
      END_STATE();
    case 468:
      if (lookahead == 'a') ADVANCE(1548);
      if (lookahead == 'u') ADVANCE(1548);
      END_STATE();
    case 469:
      if (lookahead == 'a') ADVANCE(736);
      END_STATE();
    case 470:
      if (lookahead == 'a') ADVANCE(1224);
      END_STATE();
    case 471:
      if (lookahead == 'a') ADVANCE(1224);
      if (lookahead == 'i') ADVANCE(1269);
      END_STATE();
    case 472:
      if (lookahead == 'a') ADVANCE(1608);
      END_STATE();
    case 473:
      if (lookahead == 'a') ADVANCE(1608);
      if (lookahead == 'b') ADVANCE(1238);
      END_STATE();
    case 474:
      if (lookahead == 'a') ADVANCE(1243);
      END_STATE();
    case 475:
      if (lookahead == 'a') ADVANCE(1243);
      if (lookahead == 'e') ADVANCE(1763);
      if (lookahead == 'i') ADVANCE(1959);
      END_STATE();
    case 476:
      if (lookahead == 'a') ADVANCE(1643);
      if (lookahead == 'l') ADVANCE(1914);
      if (lookahead == 's') ADVANCE(1079);
      END_STATE();
    case 477:
      if (lookahead == 'a') ADVANCE(626);
      END_STATE();
    case 478:
      if (lookahead == 'a') ADVANCE(1638);
      if (lookahead == 'b') ADVANCE(1238);
      END_STATE();
    case 479:
      if (lookahead == 'a') ADVANCE(1638);
      if (lookahead == 'o') ADVANCE(210);
      END_STATE();
    case 480:
      if (lookahead == 'a') ADVANCE(1570);
      END_STATE();
    case 481:
      if (lookahead == 'a') ADVANCE(711);
      END_STATE();
    case 482:
      if (lookahead == 'a') ADVANCE(1636);
      END_STATE();
    case 483:
      if (lookahead == 'a') ADVANCE(1235);
      END_STATE();
    case 484:
      if (lookahead == 'a') ADVANCE(1628);
      if (lookahead == 'o') ADVANCE(1303);
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 485:
      if (lookahead == 'a') ADVANCE(1231);
      END_STATE();
    case 486:
      if (lookahead == 'a') ADVANCE(1623);
      if (lookahead == 'p') ADVANCE(1522);
      END_STATE();
    case 487:
      if (lookahead == 'a') ADVANCE(1609);
      if (lookahead == 'r') ADVANCE(558);
      END_STATE();
    case 488:
      if (lookahead == 'a') ADVANCE(1214);
      END_STATE();
    case 489:
      if (lookahead == 'a') ADVANCE(1622);
      END_STATE();
    case 490:
      if (lookahead == 'a') ADVANCE(1222);
      END_STATE();
    case 491:
      if (lookahead == 'a') ADVANCE(1209);
      END_STATE();
    case 492:
      if (lookahead == 'a') ADVANCE(1215);
      END_STATE();
    case 493:
      if (lookahead == 'a') ADVANCE(1210);
      END_STATE();
    case 494:
      if (lookahead == 'a') ADVANCE(1676);
      END_STATE();
    case 495:
      if (lookahead == 'a') ADVANCE(1228);
      END_STATE();
    case 496:
      if (lookahead == 'a') ADVANCE(1216);
      END_STATE();
    case 497:
      if (lookahead == 'a') ADVANCE(1597);
      END_STATE();
    case 498:
      if (lookahead == 'a') ADVANCE(1626);
      END_STATE();
    case 499:
      if (lookahead == 'a') ADVANCE(1602);
      END_STATE();
    case 500:
      if (lookahead == 'a') ADVANCE(1680);
      END_STATE();
    case 501:
      if (lookahead == 'a') ADVANCE(1624);
      END_STATE();
    case 502:
      if (lookahead == 'a') ADVANCE(1864);
      END_STATE();
    case 503:
      if (lookahead == 'a') ADVANCE(1691);
      END_STATE();
    case 504:
      if (lookahead == 'a') ADVANCE(1664);
      END_STATE();
    case 505:
      if (lookahead == 'a') ADVANCE(1655);
      END_STATE();
    case 506:
      if (lookahead == 'a') ADVANCE(1661);
      END_STATE();
    case 507:
      if (lookahead == 'a') ADVANCE(667);
      if (lookahead == 'b') ADVANCE(1588);
      if (lookahead == 'c') ADVANCE(218);
      if (lookahead == 'd') ADVANCE(1476);
      if (lookahead == 'e') ADVANCE(258);
      if (lookahead == 'f') ADVANCE(1619);
      if (lookahead == 'h') ADVANCE(72);
      if (lookahead == 'i') ADVANCE(1008);
      if (lookahead == 'l') ADVANCE(433);
      if (lookahead == 'm') ADVANCE(389);
      if (lookahead == 'o') ADVANCE(953);
      if (lookahead == 'p') ADVANCE(412);
      if (lookahead == 'q') ADVANCE(655);
      if (lookahead == 'r') ADVANCE(433);
      if (lookahead == 's') ADVANCE(630);
      if (lookahead == 't') ADVANCE(487);
      if (lookahead == 'u') ADVANCE(570);
      if (lookahead == 'w') ADVANCE(259);
      if (lookahead == 'z') ADVANCE(1247);
      END_STATE();
    case 508:
      if (lookahead == 'a') ADVANCE(667);
      if (lookahead == 'c') ADVANCE(465);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(912);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(603);
      if (lookahead == 'i') ADVANCE(1002);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 'w') ADVANCE(1187);
      END_STATE();
    case 509:
      if (lookahead == 'a') ADVANCE(1259);
      END_STATE();
    case 510:
      if (lookahead == 'a') ADVANCE(1328);
      END_STATE();
    case 511:
      if (lookahead == 'a') ADVANCE(1785);
      END_STATE();
    case 512:
      if (lookahead == 'a') ADVANCE(1554);
      if (lookahead == 'c') ADVANCE(832);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'g') ADVANCE(1663);
      if (lookahead == 'h') ADVANCE(603);
      if (lookahead == 'j') ADVANCE(603);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      END_STATE();
    case 513:
      if (lookahead == 'a') ADVANCE(705);
      END_STATE();
    case 514:
      if (lookahead == 'a') ADVANCE(752);
      if (lookahead == 'i') ADVANCE(559);
      if (lookahead == 'p') ADVANCE(814);
      END_STATE();
    case 515:
      if (lookahead == 'a') ADVANCE(1712);
      END_STATE();
    case 516:
      if (lookahead == 'a') ADVANCE(1861);
      END_STATE();
    case 517:
      if (lookahead == 'a') ADVANCE(1679);
      END_STATE();
    case 518:
      if (lookahead == 'a') ADVANCE(1561);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(1584);
      if (lookahead == 'g') ADVANCE(1827);
      if (lookahead == 's') ADVANCE(1104);
      END_STATE();
    case 519:
      if (lookahead == 'a') ADVANCE(1561);
      if (lookahead == 'e') ADVANCE(1587);
      if (lookahead == 's') ADVANCE(1104);
      END_STATE();
    case 520:
      if (lookahead == 'a') ADVANCE(1561);
      if (lookahead == 's') ADVANCE(1104);
      END_STATE();
    case 521:
      if (lookahead == 'a') ADVANCE(691);
      END_STATE();
    case 522:
      if (lookahead == 'a') ADVANCE(1713);
      if (lookahead == 'l') ADVANCE(1989);
      if (lookahead == 'r') ADVANCE(783);
      if (lookahead == 'v') ADVANCE(932);
      END_STATE();
    case 523:
      if (lookahead == 'a') ADVANCE(1398);
      END_STATE();
    case 524:
      if (lookahead == 'a') ADVANCE(1249);
      if (lookahead == 'k') ADVANCE(210);
      END_STATE();
    case 525:
      if (lookahead == 'a') ADVANCE(1871);
      END_STATE();
    case 526:
      if (lookahead == 'a') ADVANCE(1725);
      if (lookahead == 'l') ADVANCE(1264);
      if (lookahead == 'r') ADVANCE(675);
      END_STATE();
    case 527:
      if (lookahead == 'a') ADVANCE(1675);
      END_STATE();
    case 528:
      if (lookahead == 'a') ADVANCE(1112);
      END_STATE();
    case 529:
      if (lookahead == 'a') ADVANCE(1112);
      if (lookahead == 'i') ADVANCE(1449);
      END_STATE();
    case 530:
      if (lookahead == 'a') ADVANCE(1925);
      END_STATE();
    case 531:
      if (lookahead == 'a') ADVANCE(1271);
      END_STATE();
    case 532:
      if (lookahead == 'a') ADVANCE(1716);
      END_STATE();
    case 533:
      if (lookahead == 'a') ADVANCE(1927);
      END_STATE();
    case 534:
      if (lookahead == 'a') ADVANCE(1879);
      END_STATE();
    case 535:
      if (lookahead == 'a') ADVANCE(1399);
      END_STATE();
    case 536:
      if (lookahead == 'a') ADVANCE(1718);
      END_STATE();
    case 537:
      if (lookahead == 'a') ADVANCE(1256);
      END_STATE();
    case 538:
      if (lookahead == 'a') ADVANCE(1708);
      END_STATE();
    case 539:
      if (lookahead == 'a') ADVANCE(1667);
      END_STATE();
    case 540:
      if (lookahead == 'a') ADVANCE(1714);
      END_STATE();
    case 541:
      if (lookahead == 'a') ADVANCE(1715);
      END_STATE();
    case 542:
      if (lookahead == 'a') ADVANCE(1306);
      END_STATE();
    case 543:
      if (lookahead == 'a') ADVANCE(1730);
      END_STATE();
    case 544:
      if (lookahead == 'a') ADVANCE(1730);
      if (lookahead == 'd') ADVANCE(1508);
      if (lookahead == 'h') ADVANCE(500);
      if (lookahead == 'l') ADVANCE(1914);
      if (lookahead == 's') ADVANCE(1081);
      if (lookahead == 'u') ADVANCE(1580);
      END_STATE();
    case 545:
      if (lookahead == 'a') ADVANCE(1730);
      if (lookahead == 'd') ADVANCE(1524);
      if (lookahead == 'h') ADVANCE(500);
      END_STATE();
    case 546:
      if (lookahead == 'a') ADVANCE(1730);
      if (lookahead == 'r') ADVANCE(1166);
      END_STATE();
    case 547:
      if (lookahead == 'a') ADVANCE(1741);
      END_STATE();
    case 548:
      if (lookahead == 'a') ADVANCE(1887);
      END_STATE();
    case 549:
      if (lookahead == 'a') ADVANCE(1735);
      if (lookahead == 'h') ADVANCE(560);
      if (lookahead == 'l') ADVANCE(924);
      if (lookahead == 'r') ADVANCE(1181);
      if (lookahead == 's') ADVANCE(1591);
      if (lookahead == 't') ADVANCE(1069);
      END_STATE();
    case 550:
      if (lookahead == 'a') ADVANCE(1735);
      if (lookahead == 'h') ADVANCE(560);
      if (lookahead == 'l') ADVANCE(944);
      if (lookahead == 'r') ADVANCE(1175);
      if (lookahead == 't') ADVANCE(1069);
      END_STATE();
    case 551:
      if (lookahead == 'a') ADVANCE(1889);
      END_STATE();
    case 552:
      if (lookahead == 'a') ADVANCE(1736);
      END_STATE();
    case 553:
      if (lookahead == 'a') ADVANCE(1736);
      if (lookahead == 'd') ADVANCE(2021);
      END_STATE();
    case 554:
      if (lookahead == 'a') ADVANCE(1737);
      END_STATE();
    case 555:
      if (lookahead == 'a') ADVANCE(1737);
      if (lookahead == 'h') ADVANCE(562);
      END_STATE();
    case 556:
      if (lookahead == 'a') ADVANCE(1891);
      END_STATE();
    case 557:
      if (lookahead == 'a') ADVANCE(1738);
      if (lookahead == 'h') ADVANCE(562);
      if (lookahead == 's') ADVANCE(1591);
      END_STATE();
    case 558:
      if (lookahead == 'a') ADVANCE(1171);
      if (lookahead == 'n') ADVANCE(1752);
      END_STATE();
    case 559:
      if (lookahead == 'a') ADVANCE(1420);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'm') ADVANCE(1164);
      if (lookahead == 'p') ADVANCE(1297);
      if (lookahead == 's') ADVANCE(567);
      if (lookahead == 't') ADVANCE(1149);
      END_STATE();
    case 560:
      if (lookahead == 'a') ADVANCE(1743);
      END_STATE();
    case 561:
      if (lookahead == 'a') ADVANCE(1427);
      END_STATE();
    case 562:
      if (lookahead == 'a') ADVANCE(1745);
      END_STATE();
    case 563:
      if (lookahead == 'a') ADVANCE(1428);
      END_STATE();
    case 564:
      if (lookahead == 'a') ADVANCE(1430);
      END_STATE();
    case 565:
      if (lookahead == 'a') ADVANCE(1431);
      END_STATE();
    case 566:
      if (lookahead == 'a') ADVANCE(1432);
      END_STATE();
    case 567:
      if (lookahead == 'b') ADVANCE(13);
      END_STATE();
    case 568:
      if (lookahead == 'b') ADVANCE(13);
      if (lookahead == 'u') ADVANCE(1438);
      END_STATE();
    case 569:
      if (lookahead == 'b') ADVANCE(196);
      if (lookahead == 'c') ADVANCE(713);
      if (lookahead == 'm') ADVANCE(13);
      if (lookahead == 'p') ADVANCE(126);
      END_STATE();
    case 570:
      if (lookahead == 'b') ADVANCE(30);
      if (lookahead == 'c') ADVANCE(624);
      if (lookahead == 'm') ADVANCE(13);
      if (lookahead == 'n') ADVANCE(969);
      if (lookahead == 'p') ADVANCE(2026);
      END_STATE();
    case 571:
      if (lookahead == 'b') ADVANCE(216);
      if (lookahead == 'c') ADVANCE(680);
      if (lookahead == 'p') ADVANCE(216);
      END_STATE();
    case 572:
      if (lookahead == 'b') ADVANCE(100);
      END_STATE();
    case 573:
      if (lookahead == 'b') ADVANCE(108);
      if (lookahead == 'p') ADVANCE(108);
      END_STATE();
    case 574:
      if (lookahead == 'b') ADVANCE(396);
      END_STATE();
    case 575:
      if (lookahead == 'b') ADVANCE(396);
      if (lookahead == 'g') ADVANCE(818);
      END_STATE();
    case 576:
      if (lookahead == 'b') ADVANCE(396);
      if (lookahead == 'm') ADVANCE(13);
      END_STATE();
    case 577:
      if (lookahead == 'b') ADVANCE(396);
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 578:
      if (lookahead == 'b') ADVANCE(396);
      if (lookahead == 't') ADVANCE(148);
      if (lookahead == 'y') ADVANCE(369);
      END_STATE();
    case 579:
      if (lookahead == 'b') ADVANCE(1203);
      if (lookahead == 'c') ADVANCE(1497);
      END_STATE();
    case 580:
      if (lookahead == 'b') ADVANCE(106);
      if (lookahead == 'p') ADVANCE(106);
      END_STATE();
    case 581:
      if (lookahead == 'b') ADVANCE(1943);
      if (lookahead == 'p') ADVANCE(1064);
      END_STATE();
    case 582:
      if (lookahead == 'b') ADVANCE(740);
      END_STATE();
    case 583:
      if (lookahead == 'b') ADVANCE(1653);
      END_STATE();
    case 584:
      if (lookahead == 'b') ADVANCE(775);
      if (lookahead == 'p') ADVANCE(775);
      END_STATE();
    case 585:
      if (lookahead == 'b') ADVANCE(1217);
      if (lookahead == 'c') ADVANCE(1944);
      if (lookahead == 'n') ADVANCE(969);
      if (lookahead == 'p') ADVANCE(33);
      if (lookahead == 't') ADVANCE(1933);
      END_STATE();
    case 586:
      if (lookahead == 'b') ADVANCE(1758);
      END_STATE();
    case 587:
      if (lookahead == 'b') ADVANCE(383);
      END_STATE();
    case 588:
      if (lookahead == 'b') ADVANCE(927);
      END_STATE();
    case 589:
      if (lookahead == 'b') ADVANCE(1361);
      if (lookahead == 'p') ADVANCE(1361);
      END_STATE();
    case 590:
      if (lookahead == 'b') ADVANCE(1802);
      if (lookahead == 'c') ADVANCE(712);
      if (lookahead == 'p') ADVANCE(879);
      END_STATE();
    case 591:
      if (lookahead == 'b') ADVANCE(1802);
      if (lookahead == 'p') ADVANCE(879);
      END_STATE();
    case 592:
      if (lookahead == 'b') ADVANCE(1273);
      END_STATE();
    case 593:
      if (lookahead == 'b') ADVANCE(1276);
      END_STATE();
    case 594:
      if (lookahead == 'b') ADVANCE(1719);
      END_STATE();
    case 595:
      if (lookahead == 'b') ADVANCE(1279);
      END_STATE();
    case 596:
      if (lookahead == 'b') ADVANCE(1280);
      END_STATE();
    case 597:
      if (lookahead == 'b') ADVANCE(1294);
      END_STATE();
    case 598:
      if (lookahead == 'b') ADVANCE(506);
      END_STATE();
    case 599:
      if (lookahead == 'b') ADVANCE(1285);
      END_STATE();
    case 600:
      if (lookahead == 'b') ADVANCE(1286);
      END_STATE();
    case 601:
      if (lookahead == 'b') ADVANCE(1287);
      END_STATE();
    case 602:
      if (lookahead == 'b') ADVANCE(1805);
      if (lookahead == 'p') ADVANCE(1805);
      END_STATE();
    case 603:
      if (lookahead == 'c') ADVANCE(1987);
      END_STATE();
    case 604:
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'e') ADVANCE(1962);
      END_STATE();
    case 605:
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'e') ADVANCE(685);
      if (lookahead == 'i') ADVANCE(13);
      END_STATE();
    case 606:
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(1298);
      if (lookahead == 'o') ADVANCE(1531);
      if (lookahead == 's') ADVANCE(627);
      END_STATE();
    case 607:
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'g') ADVANCE(1478);
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 608:
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'i') ADVANCE(1002);
      END_STATE();
    case 609:
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 610:
      if (lookahead == 'c') ADVANCE(1987);
      if (lookahead == 'x') ADVANCE(614);
      END_STATE();
    case 611:
      if (lookahead == 'c') ADVANCE(13);
      END_STATE();
    case 612:
      if (lookahead == 'c') ADVANCE(13);
      if (lookahead == 'i') ADVANCE(1599);
      END_STATE();
    case 613:
      if (lookahead == 'c') ADVANCE(183);
      if (lookahead == 'l') ADVANCE(780);
      if (lookahead == 'p') ADVANCE(194);
      if (lookahead == 'r') ADVANCE(1200);
      END_STATE();
    case 614:
      if (lookahead == 'c') ADVANCE(152);
      END_STATE();
    case 615:
      if (lookahead == 'c') ADVANCE(424);
      if (lookahead == 'd') ADVANCE(1865);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(256);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(256);
      if (lookahead == 'm') ADVANCE(422);
      if (lookahead == 'n') ADVANCE(1108);
      if (lookahead == 'o') ADVANCE(727);
      if (lookahead == 'r') ADVANCE(256);
      if (lookahead == 's') ADVANCE(644);
      if (lookahead == 'u') ADVANCE(1558);
      if (lookahead == 'v') ADVANCE(852);
      if (lookahead == 'w') ADVANCE(815);
      END_STATE();
    case 616:
      if (lookahead == 'c') ADVANCE(424);
      if (lookahead == 'o') ADVANCE(728);
      if (lookahead == 's') ADVANCE(1593);
      if (lookahead == 't') ADVANCE(1749);
      if (lookahead == 'u') ADVANCE(1557);
      if (lookahead == 'v') ADVANCE(852);
      if (lookahead == 'w') ADVANCE(815);
      END_STATE();
    case 617:
      if (lookahead == 'c') ADVANCE(1497);
      END_STATE();
    case 618:
      if (lookahead == 'c') ADVANCE(2019);
      if (lookahead == 'h') ADVANCE(603);
      if (lookahead == 't') ADVANCE(1670);
      END_STATE();
    case 619:
      if (lookahead == 'c') ADVANCE(2019);
      if (lookahead == 'o') ADVANCE(1207);
      if (lookahead == 't') ADVANCE(1670);
      END_STATE();
    case 620:
      if (lookahead == 'c') ADVANCE(96);
      if (lookahead == 'h') ADVANCE(1515);
      if (lookahead == 'i') ADVANCE(1329);
      if (lookahead == 'm') ADVANCE(1071);
      if (lookahead == 'p') ADVANCE(396);
      if (lookahead == 'q') ADVANCE(1786);
      if (lookahead == 'u') ADVANCE(571);
      END_STATE();
    case 621:
      if (lookahead == 'c') ADVANCE(781);
      if (lookahead == 'd') ADVANCE(1118);
      if (lookahead == 'e') ADVANCE(1330);
      if (lookahead == 'n') ADVANCE(979);
      if (lookahead == 'q') ADVANCE(1903);
      if (lookahead == 'r') ADVANCE(1612);
      if (lookahead == 't') ADVANCE(529);
      END_STATE();
    case 622:
      if (lookahead == 'c') ADVANCE(1912);
      END_STATE();
    case 623:
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 's') ADVANCE(1207);
      END_STATE();
    case 624:
      if (lookahead == 'c') ADVANCE(75);
      END_STATE();
    case 625:
      if (lookahead == 'c') ADVANCE(2014);
      END_STATE();
    case 626:
      if (lookahead == 'c') ADVANCE(776);
      END_STATE();
    case 627:
      if (lookahead == 'c') ADVANCE(1599);
      END_STATE();
    case 628:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'i') ADVANCE(1312);
      END_STATE();
    case 629:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'e') ADVANCE(1321);
      if (lookahead == 'i') ADVANCE(1322);
      if (lookahead == 'o') ADVANCE(1211);
      END_STATE();
    case 630:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'e') ADVANCE(1855);
      if (lookahead == 'm') ADVANCE(1161);
      if (lookahead == 't') ADVANCE(499);
      END_STATE();
    case 631:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'e') ADVANCE(1632);
      END_STATE();
    case 632:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'g') ADVANCE(777);
      if (lookahead == 't') ADVANCE(1032);
      END_STATE();
    case 633:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'g') ADVANCE(1131);
      END_STATE();
    case 634:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(13);
      END_STATE();
    case 635:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'h') ADVANCE(13);
      if (lookahead == 't') ADVANCE(1670);
      END_STATE();
    case 636:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(13);
      END_STATE();
    case 637:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(1312);
      END_STATE();
    case 638:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(1317);
      END_STATE();
    case 639:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(1359);
      END_STATE();
    case 640:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'l') ADVANCE(429);
      if (lookahead == 't') ADVANCE(1670);
      END_STATE();
    case 641:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'l') ADVANCE(969);
      END_STATE();
    case 642:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'l') ADVANCE(456);
      END_STATE();
    case 643:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'l') ADVANCE(456);
      if (lookahead == 'o') ADVANCE(1207);
      END_STATE();
    case 644:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'q') ADVANCE(696);
      END_STATE();
    case 645:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 's') ADVANCE(1114);
      END_STATE();
    case 646:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 't') ADVANCE(13);
      if (lookahead == 'y') ADVANCE(1337);
      END_STATE();
    case 647:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 't') ADVANCE(1567);
      END_STATE();
    case 648:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 't') ADVANCE(1670);
      END_STATE();
    case 649:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'u') ADVANCE(580);
      END_STATE();
    case 650:
      if (lookahead == 'c') ADVANCE(1599);
      if (lookahead == 'u') ADVANCE(589);
      END_STATE();
    case 651:
      if (lookahead == 'c') ADVANCE(382);
      if (lookahead == 'l') ADVANCE(761);
      if (lookahead == 'q') ADVANCE(1923);
      if (lookahead == 's') ADVANCE(1032);
      END_STATE();
    case 652:
      if (lookahead == 'c') ADVANCE(382);
      if (lookahead == 'q') ADVANCE(1923);
      if (lookahead == 'r') ADVANCE(762);
      if (lookahead == 's') ADVANCE(1032);
      END_STATE();
    case 653:
      if (lookahead == 'c') ADVANCE(1199);
      if (lookahead == 'r') ADVANCE(1958);
      END_STATE();
    case 654:
      if (lookahead == 'c') ADVANCE(1366);
      if (lookahead == 'i') ADVANCE(1436);
      if (lookahead == 'm') ADVANCE(1112);
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 't') ADVANCE(868);
      END_STATE();
    case 655:
      if (lookahead == 'c') ADVANCE(468);
      if (lookahead == 's') ADVANCE(1904);
      if (lookahead == 'u') ADVANCE(74);
      END_STATE();
    case 656:
      if (lookahead == 'c') ADVANCE(1807);
      END_STATE();
    case 657:
      if (lookahead == 'c') ADVANCE(1190);
      if (lookahead == 'r') ADVANCE(1961);
      END_STATE();
    case 658:
      if (lookahead == 'c') ADVANCE(1139);
      if (lookahead == 's') ADVANCE(1106);
      if (lookahead == 'u') ADVANCE(475);
      if (lookahead == 'v') ADVANCE(1574);
      END_STATE();
    case 659:
      if (lookahead == 'c') ADVANCE(1138);
      if (lookahead == 'e') ADVANCE(735);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(122);
      if (lookahead == 's') ADVANCE(627);
      END_STATE();
    case 660:
      if (lookahead == 'c') ADVANCE(1138);
      if (lookahead == 'e') ADVANCE(764);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      END_STATE();
    case 661:
      if (lookahead == 'c') ADVANCE(1911);
      END_STATE();
    case 662:
      if (lookahead == 'c') ADVANCE(1911);
      if (lookahead == 'r') ADVANCE(1599);
      END_STATE();
    case 663:
      if (lookahead == 'c') ADVANCE(1911);
      if (lookahead == 'r') ADVANCE(1635);
      END_STATE();
    case 664:
      if (lookahead == 'c') ADVANCE(1911);
      if (lookahead == 's') ADVANCE(1807);
      END_STATE();
    case 665:
      if (lookahead == 'c') ADVANCE(1911);
      if (lookahead == 's') ADVANCE(1861);
      END_STATE();
    case 666:
      if (lookahead == 'c') ADVANCE(1526);
      if (lookahead == 'd') ADVANCE(1599);
      END_STATE();
    case 667:
      if (lookahead == 'c') ADVANCE(1944);
      END_STATE();
    case 668:
      if (lookahead == 'c') ADVANCE(1944);
      if (lookahead == 'e') ADVANCE(1330);
      if (lookahead == 'g') ADVANCE(1717);
      if (lookahead == 'm') ADVANCE(582);
      if (lookahead == 'n') ADVANCE(977);
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 'q') ADVANCE(1903);
      if (lookahead == 'r') ADVANCE(1610);
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 669:
      if (lookahead == 'c') ADVANCE(1944);
      if (lookahead == 'm') ADVANCE(582);
      if (lookahead == 'n') ADVANCE(969);
      if (lookahead == 'p') ADVANCE(1296);
      if (lookahead == 'r') ADVANCE(1599);
      END_STATE();
    case 670:
      if (lookahead == 'c') ADVANCE(1944);
      if (lookahead == 'm') ADVANCE(1340);
      if (lookahead == 'p') ADVANCE(13);
      END_STATE();
    case 671:
      if (lookahead == 'c') ADVANCE(1944);
      if (lookahead == 'n') ADVANCE(969);
      if (lookahead == 'r') ADVANCE(1645);
      END_STATE();
    case 672:
      if (lookahead == 'c') ADVANCE(1944);
      if (lookahead == 'p') ADVANCE(69);
      if (lookahead == 'r') ADVANCE(812);
      END_STATE();
    case 673:
      if (lookahead == 'c') ADVANCE(1944);
      if (lookahead == 'p') ADVANCE(147);
      if (lookahead == 'y') ADVANCE(1257);
      END_STATE();
    case 674:
      if (lookahead == 'c') ADVANCE(838);
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 675:
      if (lookahead == 'c') ADVANCE(1478);
      END_STATE();
    case 676:
      if (lookahead == 'c') ADVANCE(1188);
      END_STATE();
    case 677:
      if (lookahead == 'c') ADVANCE(1197);
      END_STATE();
    case 678:
      if (lookahead == 'c') ADVANCE(1197);
      if (lookahead == 's') ADVANCE(789);
      END_STATE();
    case 679:
      if (lookahead == 'c') ADVANCE(1189);
      if (lookahead == 'n') ADVANCE(365);
      END_STATE();
    case 680:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 681:
      if (lookahead == 'c') ADVANCE(1065);
      END_STATE();
    case 682:
      if (lookahead == 'c') ADVANCE(1458);
      if (lookahead == 'i') ADVANCE(1366);
      END_STATE();
    case 683:
      if (lookahead == 'c') ADVANCE(1192);
      if (lookahead == 'n') ADVANCE(1188);
      END_STATE();
    case 684:
      if (lookahead == 'c') ADVANCE(422);
      END_STATE();
    case 685:
      if (lookahead == 'c') ADVANCE(1193);
      END_STATE();
    case 686:
      if (lookahead == 'c') ADVANCE(1207);
      if (lookahead == 'i') ADVANCE(1763);
      if (lookahead == 'p') ADVANCE(907);
      END_STATE();
    case 687:
      if (lookahead == 'c') ADVANCE(1202);
      if (lookahead == 'n') ADVANCE(1772);
      END_STATE();
    case 688:
      if (lookahead == 'c') ADVANCE(530);
      if (lookahead == 'r') ADVANCE(1390);
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 689:
      if (lookahead == 'c') ADVANCE(1194);
      if (lookahead == 'k') ADVANCE(1957);
      END_STATE();
    case 690:
      if (lookahead == 'c') ADVANCE(611);
      END_STATE();
    case 691:
      if (lookahead == 'c') ADVANCE(775);
      END_STATE();
    case 692:
      if (lookahead == 'c') ADVANCE(1046);
      END_STATE();
    case 693:
      if (lookahead == 'c') ADVANCE(1652);
      END_STATE();
    case 694:
      if (lookahead == 'c') ADVANCE(1652);
      if (lookahead == 'd') ADVANCE(13);
      if (lookahead == 'n') ADVANCE(1914);
      END_STATE();
    case 695:
      if (lookahead == 'c') ADVANCE(1772);
      END_STATE();
    case 696:
      if (lookahead == 'c') ADVANCE(1907);
      END_STATE();
    case 697:
      if (lookahead == 'c') ADVANCE(1806);
      END_STATE();
    case 698:
      if (lookahead == 'c') ADVANCE(449);
      END_STATE();
    case 699:
      if (lookahead == 'c') ADVANCE(1082);
      END_STATE();
    case 700:
      if (lookahead == 'c') ADVANCE(1082);
      if (lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 701:
      if (lookahead == 'c') ADVANCE(915);
      END_STATE();
    case 702:
      if (lookahead == 'c') ADVANCE(1641);
      if (lookahead == 'd') ADVANCE(65);
      if (lookahead == 'n') ADVANCE(1922);
      END_STATE();
    case 703:
      if (lookahead == 'c') ADVANCE(1893);
      END_STATE();
    case 704:
      if (lookahead == 'c') ADVANCE(1880);
      END_STATE();
    case 705:
      if (lookahead == 'c') ADVANCE(911);
      END_STATE();
    case 706:
      if (lookahead == 'c') ADVANCE(1864);
      END_STATE();
    case 707:
      if (lookahead == 'c') ADVANCE(1140);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'm') ADVANCE(448);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(631);
      if (lookahead == 'u') ADVANCE(1195);
      END_STATE();
    case 708:
      if (lookahead == 'c') ADVANCE(1140);
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(631);
      if (lookahead == 'u') ADVANCE(1195);
      END_STATE();
    case 709:
      if (lookahead == 'c') ADVANCE(1499);
      if (lookahead == 'i') ADVANCE(1374);
      if (lookahead == 't') ADVANCE(1634);
      END_STATE();
    case 710:
      if (lookahead == 'c') ADVANCE(1499);
      if (lookahead == 't') ADVANCE(1634);
      END_STATE();
    case 711:
      if (lookahead == 'c') ADVANCE(1201);
      END_STATE();
    case 712:
      if (lookahead == 'c') ADVANCE(881);
      END_STATE();
    case 713:
      if (lookahead == 'c') ADVANCE(881);
      if (lookahead == 'h') ADVANCE(370);
      END_STATE();
    case 714:
      if (lookahead == 'c') ADVANCE(488);
      END_STATE();
    case 715:
      if (lookahead == 'c') ADVANCE(1272);
      END_STATE();
    case 716:
      if (lookahead == 'c') ADVANCE(1696);
      if (lookahead == 'm') ADVANCE(1484);
      END_STATE();
    case 717:
      if (lookahead == 'c') ADVANCE(492);
      END_STATE();
    case 718:
      if (lookahead == 'c') ADVANCE(1879);
      END_STATE();
    case 719:
      if (lookahead == 'c') ADVANCE(1467);
      if (lookahead == 'e') ADVANCE(1525);
      if (lookahead == 'p') ADVANCE(1669);
      if (lookahead == 's') ADVANCE(1124);
      END_STATE();
    case 720:
      if (lookahead == 'c') ADVANCE(1256);
      END_STATE();
    case 721:
      if (lookahead == 'c') ADVANCE(495);
      END_STATE();
    case 722:
      if (lookahead == 'c') ADVANCE(533);
      if (lookahead == 'm') ADVANCE(1560);
      if (lookahead == 'p') ADVANCE(1767);
      if (lookahead == 'r') ADVANCE(1413);
      if (lookahead == 't') ADVANCE(2010);
      END_STATE();
    case 723:
      if (lookahead == 'c') ADVANCE(540);
      END_STATE();
    case 724:
      if (lookahead == 'c') ADVANCE(939);
      END_STATE();
    case 725:
      if (lookahead == 'd') ADVANCE(1447);
      END_STATE();
    case 726:
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'i') ADVANCE(1289);
      if (lookahead == 'r') ADVANCE(1078);
      END_STATE();
    case 727:
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'p') ADVANCE(946);
      if (lookahead == 't') ADVANCE(1149);
      END_STATE();
    case 728:
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'p') ADVANCE(1297);
      if (lookahead == 't') ADVANCE(1153);
      END_STATE();
    case 729:
      if (lookahead == 'd') ADVANCE(1447);
      if (lookahead == 'r') ADVANCE(1078);
      END_STATE();
    case 730:
      if (lookahead == 'd') ADVANCE(13);
      END_STATE();
    case 731:
      if (lookahead == 'd') ADVANCE(13);
      if (lookahead == 'f') ADVANCE(454);
      if (lookahead == 'p') ADVANCE(200);
      END_STATE();
    case 732:
      if (lookahead == 'd') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(775);
      END_STATE();
    case 733:
      if (lookahead == 'd') ADVANCE(13);
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 734:
      if (lookahead == 'd') ADVANCE(70);
      if (lookahead == 'g') ADVANCE(107);
      END_STATE();
    case 735:
      if (lookahead == 'd') ADVANCE(575);
      if (lookahead == 'i') ADVANCE(870);
      END_STATE();
    case 736:
      if (lookahead == 'd') ADVANCE(1293);
      END_STATE();
    case 737:
      if (lookahead == 'd') ADVANCE(364);
      END_STATE();
    case 738:
      if (lookahead == 'd') ADVANCE(340);
      END_STATE();
    case 739:
      if (lookahead == 'd') ADVANCE(330);
      END_STATE();
    case 740:
      if (lookahead == 'd') ADVANCE(382);
      END_STATE();
    case 741:
      if (lookahead == 'd') ADVANCE(603);
      if (lookahead == 'r') ADVANCE(94);
      END_STATE();
    case 742:
      if (lookahead == 'd') ADVANCE(139);
      END_STATE();
    case 743:
      if (lookahead == 'd') ADVANCE(55);
      END_STATE();
    case 744:
      if (lookahead == 'd') ADVANCE(854);
      if (lookahead == 'i') ADVANCE(1482);
      END_STATE();
    case 745:
      if (lookahead == 'd') ADVANCE(106);
      END_STATE();
    case 746:
      if (lookahead == 'd') ADVANCE(429);
      END_STATE();
    case 747:
      if (lookahead == 'd') ADVANCE(447);
      END_STATE();
    case 748:
      if (lookahead == 'd') ADVANCE(197);
      END_STATE();
    case 749:
      if (lookahead == 'd') ADVANCE(119);
      END_STATE();
    case 750:
      if (lookahead == 'd') ADVANCE(1115);
      END_STATE();
    case 751:
      if (lookahead == 'd') ADVANCE(1115);
      if (lookahead == 'l') ADVANCE(1305);
      END_STATE();
    case 752:
      if (lookahead == 'd') ADVANCE(775);
      END_STATE();
    case 753:
      if (lookahead == 'd') ADVANCE(1919);
      END_STATE();
    case 754:
      if (lookahead == 'd') ADVANCE(1919);
      if (lookahead == 'p') ADVANCE(1521);
      END_STATE();
    case 755:
      if (lookahead == 'd') ADVANCE(1073);
      END_STATE();
    case 756:
      if (lookahead == 'd') ADVANCE(1073);
      if (lookahead == 'm') ADVANCE(1560);
      if (lookahead == 'n') ADVANCE(201);
      END_STATE();
    case 757:
      if (lookahead == 'd') ADVANCE(1798);
      if (lookahead == 'u') ADVANCE(1042);
      END_STATE();
    case 758:
      if (lookahead == 'd') ADVANCE(790);
      END_STATE();
    case 759:
      if (lookahead == 'd') ADVANCE(1761);
      END_STATE();
    case 760:
      if (lookahead == 'd') ADVANCE(1854);
      END_STATE();
    case 761:
      if (lookahead == 'd') ADVANCE(1042);
      END_STATE();
    case 762:
      if (lookahead == 'd') ADVANCE(1042);
      if (lookahead == 'u') ADVANCE(1798);
      END_STATE();
    case 763:
      if (lookahead == 'd') ADVANCE(1148);
      if (lookahead == 'n') ADVANCE(1883);
      END_STATE();
    case 764:
      if (lookahead == 'd') ADVANCE(994);
      END_STATE();
    case 765:
      if (lookahead == 'd') ADVANCE(1440);
      if (lookahead == 'u') ADVANCE(1526);
      END_STATE();
    case 766:
      if (lookahead == 'd') ADVANCE(859);
      if (lookahead == 'p') ADVANCE(945);
      END_STATE();
    case 767:
      if (lookahead == 'd') ADVANCE(855);
      if (lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 768:
      if (lookahead == 'd') ADVANCE(872);
      END_STATE();
    case 769:
      if (lookahead == 'd') ADVANCE(1463);
      END_STATE();
    case 770:
      if (lookahead == 'd') ADVANCE(1112);
      END_STATE();
    case 771:
      if (lookahead == 'd') ADVANCE(1112);
      if (lookahead == 'i') ADVANCE(1207);
      END_STATE();
    case 772:
      if (lookahead == 'd') ADVANCE(874);
      END_STATE();
    case 773:
      if (lookahead == 'd') ADVANCE(494);
      if (lookahead == 'e') ADVANCE(1542);
      if (lookahead == 'l') ADVANCE(515);
      if (lookahead == 'p') ADVANCE(85);
      if (lookahead == 'r') ADVANCE(522);
      if (lookahead == 'v') ADVANCE(852);
      if (lookahead == 'w') ADVANCE(774);
      END_STATE();
    case 774:
      if (lookahead == 'e') ADVANCE(730);
      END_STATE();
    case 775:
      if (lookahead == 'e') ADVANCE(13);
      END_STATE();
    case 776:
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'k') ADVANCE(811);
      END_STATE();
    case 777:
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(1121);
      if (lookahead == 'p') ADVANCE(501);
      END_STATE();
    case 778:
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(578);
      END_STATE();
    case 779:
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 's') ADVANCE(1213);
      END_STATE();
    case 780:
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 781:
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'u') ADVANCE(1856);
      END_STATE();
    case 782:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 783:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 784:
      if (lookahead == 'e') ADVANCE(1962);
      END_STATE();
    case 785:
      if (lookahead == 'e') ADVANCE(1962);
      if (lookahead == 'v') ADVANCE(587);
      END_STATE();
    case 786:
      if (lookahead == 'e') ADVANCE(954);
      if (lookahead == 'p') ADVANCE(1035);
      END_STATE();
    case 787:
      if (lookahead == 'e') ADVANCE(182);
      if (lookahead == 'o') ADVANCE(1807);
      END_STATE();
    case 788:
      if (lookahead == 'e') ADVANCE(84);
      if (lookahead == 'l') ADVANCE(1264);
      if (lookahead == 'r') ADVANCE(577);
      END_STATE();
    case 789:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 790:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 791:
      if (lookahead == 'e') ADVANCE(16);
      END_STATE();
    case 792:
      if (lookahead == 'e') ADVANCE(10);
      END_STATE();
    case 793:
      if (lookahead == 'e') ADVANCE(292);
      END_STATE();
    case 794:
      if (lookahead == 'e') ADVANCE(290);
      END_STATE();
    case 795:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 796:
      if (lookahead == 'e') ADVANCE(553);
      END_STATE();
    case 797:
      if (lookahead == 'e') ADVANCE(1343);
      END_STATE();
    case 798:
      if (lookahead == 'e') ADVANCE(17);
      END_STATE();
    case 799:
      if (lookahead == 'e') ADVANCE(317);
      END_STATE();
    case 800:
      if (lookahead == 'e') ADVANCE(348);
      END_STATE();
    case 801:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 802:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 803:
      if (lookahead == 'e') ADVANCE(375);
      END_STATE();
    case 804:
      if (lookahead == 'e') ADVANCE(20);
      END_STATE();
    case 805:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 806:
      if (lookahead == 'e') ADVANCE(358);
      END_STATE();
    case 807:
      if (lookahead == 'e') ADVANCE(1599);
      END_STATE();
    case 808:
      if (lookahead == 'e') ADVANCE(382);
      if (lookahead == 'p') ADVANCE(78);
      if (lookahead == 's') ADVANCE(382);
      END_STATE();
    case 809:
      if (lookahead == 'e') ADVANCE(1366);
      END_STATE();
    case 810:
      if (lookahead == 'e') ADVANCE(1685);
      if (lookahead == 'i') ADVANCE(679);
      END_STATE();
    case 811:
      if (lookahead == 'e') ADVANCE(1807);
      END_STATE();
    case 812:
      if (lookahead == 'e') ADVANCE(1807);
      if (lookahead == 'o') ADVANCE(1353);
      END_STATE();
    case 813:
      if (lookahead == 'e') ADVANCE(280);
      END_STATE();
    case 814:
      if (lookahead == 'e') ADVANCE(2003);
      END_STATE();
    case 815:
      if (lookahead == 'e') ADVANCE(764);
      END_STATE();
    case 816:
      if (lookahead == 'e') ADVANCE(1701);
      if (lookahead == 'i') ADVANCE(687);
      if (lookahead == 'k') ADVANCE(425);
      if (lookahead == 'o') ADVANCE(1601);
      END_STATE();
    case 817:
      if (lookahead == 'e') ADVANCE(955);
      END_STATE();
    case 818:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 819:
      if (lookahead == 'e') ADVANCE(319);
      END_STATE();
    case 820:
      if (lookahead == 'e') ADVANCE(366);
      END_STATE();
    case 821:
      if (lookahead == 'e') ADVANCE(1778);
      END_STATE();
    case 822:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 823:
      if (lookahead == 'e') ADVANCE(1581);
      END_STATE();
    case 824:
      if (lookahead == 'e') ADVANCE(308);
      END_STATE();
    case 825:
      if (lookahead == 'e') ADVANCE(765);
      END_STATE();
    case 826:
      if (lookahead == 'e') ADVANCE(396);
      END_STATE();
    case 827:
      if (lookahead == 'e') ADVANCE(396);
      if (lookahead == 'i') ADVANCE(1312);
      END_STATE();
    case 828:
      if (lookahead == 'e') ADVANCE(959);
      END_STATE();
    case 829:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 830:
      if (lookahead == 'e') ADVANCE(289);
      END_STATE();
    case 831:
      if (lookahead == 'e') ADVANCE(770);
      if (lookahead == 'i') ADVANCE(1666);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 832:
      if (lookahead == 'e') ADVANCE(770);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 833:
      if (lookahead == 'e') ADVANCE(1999);
      END_STATE();
    case 834:
      if (lookahead == 'e') ADVANCE(1585);
      if (lookahead == 'v') ADVANCE(852);
      if (lookahead == 'w') ADVANCE(815);
      END_STATE();
    case 835:
      if (lookahead == 'e') ADVANCE(950);
      END_STATE();
    case 836:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 837:
      if (lookahead == 'e') ADVANCE(1587);
      END_STATE();
    case 838:
      if (lookahead == 'e') ADVANCE(1188);
      END_STATE();
    case 839:
      if (lookahead == 'e') ADVANCE(1356);
      END_STATE();
    case 840:
      if (lookahead == 'e') ADVANCE(1586);
      END_STATE();
    case 841:
      if (lookahead == 'e') ADVANCE(1828);
      END_STATE();
    case 842:
      if (lookahead == 'e') ADVANCE(1752);
      END_STATE();
    case 843:
      if (lookahead == 'e') ADVANCE(1763);
      END_STATE();
    case 844:
      if (lookahead == 'e') ADVANCE(1846);
      END_STATE();
    case 845:
      if (lookahead == 'e') ADVANCE(1207);
      END_STATE();
    case 846:
      if (lookahead == 'e') ADVANCE(737);
      END_STATE();
    case 847:
      if (lookahead == 'e') ADVANCE(548);
      END_STATE();
    case 848:
      if (lookahead == 'e') ADVANCE(739);
      END_STATE();
    case 849:
      if (lookahead == 'e') ADVANCE(1353);
      END_STATE();
    case 850:
      if (lookahead == 'e') ADVANCE(611);
      END_STATE();
    case 851:
      if (lookahead == 'e') ADVANCE(742);
      END_STATE();
    case 852:
      if (lookahead == 'e') ADVANCE(775);
      END_STATE();
    case 853:
      if (lookahead == 'e') ADVANCE(759);
      END_STATE();
    case 854:
      if (lookahead == 'e') ADVANCE(1607);
      END_STATE();
    case 855:
      if (lookahead == 'e') ADVANCE(1758);
      END_STATE();
    case 856:
      if (lookahead == 'e') ADVANCE(1525);
      if (lookahead == 'k') ADVANCE(420);
      if (lookahead == 'n') ADVANCE(1493);
      if (lookahead == 'p') ADVANCE(1041);
      if (lookahead == 'r') ADVANCE(142);
      if (lookahead == 's') ADVANCE(1087);
      if (lookahead == 't') ADVANCE(1058);
      END_STATE();
    case 857:
      if (lookahead == 'e') ADVANCE(1525);
      if (lookahead == 'p') ADVANCE(1040);
      END_STATE();
    case 858:
      if (lookahead == 'e') ADVANCE(1769);
      END_STATE();
    case 859:
      if (lookahead == 'e') ADVANCE(1243);
      END_STATE();
    case 860:
      if (lookahead == 'e') ADVANCE(718);
      END_STATE();
    case 861:
      if (lookahead == 'e') ADVANCE(1407);
      END_STATE();
    case 862:
      if (lookahead == 'e') ADVANCE(1800);
      END_STATE();
    case 863:
      if (lookahead == 'e') ADVANCE(1852);
      END_STATE();
    case 864:
      if (lookahead == 'e') ADVANCE(1771);
      END_STATE();
    case 865:
      if (lookahead == 'e') ADVANCE(1830);
      END_STATE();
    case 866:
      if (lookahead == 'e') ADVANCE(431);
      END_STATE();
    case 867:
      if (lookahead == 'e') ADVANCE(791);
      END_STATE();
    case 868:
      if (lookahead == 'e') ADVANCE(1379);
      END_STATE();
    case 869:
      if (lookahead == 'e') ADVANCE(1270);
      END_STATE();
    case 870:
      if (lookahead == 'e') ADVANCE(1647);
      END_STATE();
    case 871:
      if (lookahead == 'e') ADVANCE(469);
      END_STATE();
    case 872:
      if (lookahead == 'e') ADVANCE(1761);
      END_STATE();
    case 873:
      if (lookahead == 'e') ADVANCE(453);
      END_STATE();
    case 874:
      if (lookahead == 'e') ADVANCE(1762);
      END_STATE();
    case 875:
      if (lookahead == 'e') ADVANCE(1817);
      if (lookahead == 'i') ADVANCE(1312);
      if (lookahead == 'u') ADVANCE(2011);
      END_STATE();
    case 876:
      if (lookahead == 'e') ADVANCE(1613);
      END_STATE();
    case 877:
      if (lookahead == 'e') ADVANCE(1720);
      END_STATE();
    case 878:
      if (lookahead == 'e') ADVANCE(1853);
      END_STATE();
    case 879:
      if (lookahead == 'e') ADVANCE(1684);
      END_STATE();
    case 880:
      if (lookahead == 'e') ADVANCE(1860);
      END_STATE();
    case 881:
      if (lookahead == 'e') ADVANCE(853);
      END_STATE();
    case 882:
      if (lookahead == 'e') ADVANCE(798);
      if (lookahead == 'r') ADVANCE(1184);
      END_STATE();
    case 883:
      if (lookahead == 'e') ADVANCE(1600);
      END_STATE();
    case 884:
      if (lookahead == 'e') ADVANCE(1694);
      if (lookahead == 'i') ADVANCE(1366);
      END_STATE();
    case 885:
      if (lookahead == 'e') ADVANCE(1644);
      END_STATE();
    case 886:
      if (lookahead == 'e') ADVANCE(1722);
      END_STATE();
    case 887:
      if (lookahead == 'e') ADVANCE(1742);
      END_STATE();
    case 888:
      if (lookahead == 'e') ADVANCE(803);
      END_STATE();
    case 889:
      if (lookahead == 'e') ADVANCE(1657);
      END_STATE();
    case 890:
      if (lookahead == 'e') ADVANCE(929);
      END_STATE();
    case 891:
      if (lookahead == 'e') ADVANCE(1654);
      END_STATE();
    case 892:
      if (lookahead == 'e') ADVANCE(1617);
      END_STATE();
    case 893:
      if (lookahead == 'e') ADVANCE(1662);
      END_STATE();
    case 894:
      if (lookahead == 'e') ADVANCE(1620);
      END_STATE();
    case 895:
      if (lookahead == 'e') ADVANCE(960);
      END_STATE();
    case 896:
      if (lookahead == 'e') ADVANCE(1964);
      if (lookahead == 'i') ADVANCE(1007);
      END_STATE();
    case 897:
      if (lookahead == 'e') ADVANCE(1277);
      END_STATE();
    case 898:
      if (lookahead == 'e') ADVANCE(374);
      END_STATE();
    case 899:
      if (lookahead == 'e') ADVANCE(747);
      END_STATE();
    case 900:
      if (lookahead == 'e') ADVANCE(527);
      if (lookahead == 'w') ADVANCE(527);
      END_STATE();
    case 901:
      if (lookahead == 'e') ADVANCE(957);
      END_STATE();
    case 902:
      if (lookahead == 'e') ADVANCE(957);
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 903:
      if (lookahead == 'e') ADVANCE(849);
      END_STATE();
    case 904:
      if (lookahead == 'e') ADVANCE(1789);
      END_STATE();
    case 905:
      if (lookahead == 'e') ADVANCE(750);
      END_STATE();
    case 906:
      if (lookahead == 'e') ADVANCE(1342);
      END_STATE();
    case 907:
      if (lookahead == 'e') ADVANCE(703);
      if (lookahead == 'o') ADVANCE(1423);
      END_STATE();
    case 908:
      if (lookahead == 'e') ADVANCE(516);
      END_STATE();
    case 909:
      if (lookahead == 'e') ADVANCE(1578);
      END_STATE();
    case 910:
      if (lookahead == 'e') ADVANCE(1682);
      END_STATE();
    case 911:
      if (lookahead == 'e') ADVANCE(1875);
      END_STATE();
    case 912:
      if (lookahead == 'e') ADVANCE(1875);
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 913:
      if (lookahead == 'e') ADVANCE(598);
      END_STATE();
    case 914:
      if (lookahead == 'e') ADVANCE(961);
      END_STATE();
    case 915:
      if (lookahead == 'e') ADVANCE(768);
      END_STATE();
    case 916:
      if (lookahead == 'e') ADVANCE(704);
      END_STATE();
    case 917:
      if (lookahead == 'e') ADVANCE(1779);
      END_STATE();
    case 918:
      if (lookahead == 'e') ADVANCE(1565);
      END_STATE();
    case 919:
      if (lookahead == 'e') ADVANCE(962);
      END_STATE();
    case 920:
      if (lookahead == 'e') ADVANCE(1681);
      if (lookahead == 'n') ADVANCE(313);
      END_STATE();
    case 921:
      if (lookahead == 'e') ADVANCE(706);
      END_STATE();
    case 922:
      if (lookahead == 'e') ADVANCE(1433);
      END_STATE();
    case 923:
      if (lookahead == 'e') ADVANCE(963);
      END_STATE();
    case 924:
      if (lookahead == 'e') ADVANCE(964);
      END_STATE();
    case 925:
      if (lookahead == 'e') ADVANCE(1416);
      END_STATE();
    case 926:
      if (lookahead == 'e') ADVANCE(965);
      if (lookahead == 'o') ADVANCE(1393);
      END_STATE();
    case 927:
      if (lookahead == 'e') ADVANCE(1700);
      END_STATE();
    case 928:
      if (lookahead == 'e') ADVANCE(958);
      END_STATE();
    case 929:
      if (lookahead == 'e') ADVANCE(1894);
      END_STATE();
    case 930:
      if (lookahead == 'e') ADVANCE(1747);
      END_STATE();
    case 931:
      if (lookahead == 'e') ADVANCE(1401);
      END_STATE();
    case 932:
      if (lookahead == 'e') ADVANCE(552);
      END_STATE();
    case 933:
      if (lookahead == 'e') ADVANCE(1311);
      END_STATE();
    case 934:
      if (lookahead == 'e') ADVANCE(1009);
      END_STATE();
    case 935:
      if (lookahead == 'e') ADVANCE(1744);
      END_STATE();
    case 936:
      if (lookahead == 'e') ADVANCE(1881);
      END_STATE();
    case 937:
      if (lookahead == 'e') ADVANCE(1160);
      END_STATE();
    case 938:
      if (lookahead == 'e') ADVANCE(1727);
      END_STATE();
    case 939:
      if (lookahead == 'e') ADVANCE(772);
      END_STATE();
    case 940:
      if (lookahead == 'e') ADVANCE(551);
      END_STATE();
    case 941:
      if (lookahead == 'e') ADVANCE(1376);
      END_STATE();
    case 942:
      if (lookahead == 'e') ADVANCE(556);
      END_STATE();
    case 943:
      if (lookahead == 'e') ADVANCE(724);
      END_STATE();
    case 944:
      if (lookahead == 'e') ADVANCE(968);
      END_STATE();
    case 945:
      if (lookahead == 'f') ADVANCE(13);
      END_STATE();
    case 946:
      if (lookahead == 'f') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(1914);
      END_STATE();
    case 947:
      if (lookahead == 'f') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(1473);
      END_STATE();
    case 948:
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 's') ADVANCE(627);
      END_STATE();
    case 949:
      if (lookahead == 'f') ADVANCE(1599);
      if (lookahead == 'i') ADVANCE(1366);
      if (lookahead == 'o') ADVANCE(1529);
      if (lookahead == 'p') ADVANCE(1669);
      if (lookahead == 's') ADVANCE(627);
      if (lookahead == 'u') ADVANCE(451);
      END_STATE();
    case 950:
      if (lookahead == 'f') ADVANCE(1807);
      END_STATE();
    case 951:
      if (lookahead == 'f') ADVANCE(956);
      END_STATE();
    case 952:
      if (lookahead == 'f') ADVANCE(1810);
      if (lookahead == 's') ADVANCE(1755);
      END_STATE();
    case 953:
      if (lookahead == 'f') ADVANCE(1833);
      if (lookahead == 'l') ADVANCE(81);
      if (lookahead == 'p') ADVANCE(945);
      END_STATE();
    case 954:
      if (lookahead == 'f') ADVANCE(1774);
      if (lookahead == 'p') ADVANCE(1032);
      END_STATE();
    case 955:
      if (lookahead == 'f') ADVANCE(1898);
      END_STATE();
    case 956:
      if (lookahead == 'f') ADVANCE(930);
      END_STATE();
    case 957:
      if (lookahead == 'f') ADVANCE(1838);
      END_STATE();
    case 958:
      if (lookahead == 'f') ADVANCE(1852);
      END_STATE();
    case 959:
      if (lookahead == 'f') ADVANCE(1517);
      END_STATE();
    case 960:
      if (lookahead == 'f') ADVANCE(1841);
      if (lookahead == 's') ADVANCE(1760);
      END_STATE();
    case 961:
      if (lookahead == 'f') ADVANCE(1819);
      END_STATE();
    case 962:
      if (lookahead == 'f') ADVANCE(1821);
      END_STATE();
    case 963:
      if (lookahead == 'f') ADVANCE(1837);
      END_STATE();
    case 964:
      if (lookahead == 'f') ADVANCE(1877);
      END_STATE();
    case 965:
      if (lookahead == 'f') ADVANCE(1825);
      END_STATE();
    case 966:
      if (lookahead == 'f') ADVANCE(1477);
      END_STATE();
    case 967:
      if (lookahead == 'f') ADVANCE(1116);
      END_STATE();
    case 968:
      if (lookahead == 'f') ADVANCE(1897);
      END_STATE();
    case 969:
      if (lookahead == 'g') ADVANCE(13);
      END_STATE();
    case 970:
      if (lookahead == 'g') ADVANCE(13);
      if (lookahead == 's') ADVANCE(1526);
      END_STATE();
    case 971:
      if (lookahead == 'g') ADVANCE(13);
      if (lookahead == 't') ADVANCE(210);
      END_STATE();
    case 972:
      if (lookahead == 'g') ADVANCE(616);
      END_STATE();
    case 973:
      if (lookahead == 'g') ADVANCE(98);
      END_STATE();
    case 974:
      if (lookahead == 'g') ADVANCE(98);
      if (lookahead == 'i') ADVANCE(1366);
      END_STATE();
    case 975:
      if (lookahead == 'g') ADVANCE(346);
      END_STATE();
    case 976:
      if (lookahead == 'g') ADVANCE(365);
      END_STATE();
    case 977:
      if (lookahead == 'g') ADVANCE(101);
      END_STATE();
    case 978:
      if (lookahead == 'g') ADVANCE(1310);
      END_STATE();
    case 979:
      if (lookahead == 'g') ADVANCE(225);
      END_STATE();
    case 980:
      if (lookahead == 'g') ADVANCE(382);
      END_STATE();
    case 981:
      if (lookahead == 'g') ADVANCE(1048);
      END_STATE();
    case 982:
      if (lookahead == 'g') ADVANCE(2002);
      END_STATE();
    case 983:
      if (lookahead == 'g') ADVANCE(995);
      if (lookahead == 'l') ADVANCE(844);
      if (lookahead == 'r') ADVANCE(1599);
      if (lookahead == 's') ADVANCE(1036);
      END_STATE();
    case 984:
      if (lookahead == 'g') ADVANCE(995);
      if (lookahead == 'r') ADVANCE(1599);
      END_STATE();
    case 985:
      if (lookahead == 'g') ADVANCE(995);
      if (lookahead == 'r') ADVANCE(1599);
      if (lookahead == 's') ADVANCE(1038);
      END_STATE();
    case 986:
      if (lookahead == 'g') ADVANCE(1439);
      END_STATE();
    case 987:
      if (lookahead == 'g') ADVANCE(1478);
      if (lookahead == 'p') ADVANCE(945);
      END_STATE();
    case 988:
      if (lookahead == 'g') ADVANCE(1478);
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 989:
      if (lookahead == 'g') ADVANCE(1319);
      END_STATE();
    case 990:
      if (lookahead == 'g') ADVANCE(1037);
      END_STATE();
    case 991:
      if (lookahead == 'g') ADVANCE(1207);
      if (lookahead == 'i') ADVANCE(1239);
      if (lookahead == 'l') ADVANCE(969);
      if (lookahead == 'r') ADVANCE(1180);
      END_STATE();
    case 992:
      if (lookahead == 'g') ADVANCE(525);
      if (lookahead == 's') ADVANCE(1863);
      if (lookahead == 'w') ADVANCE(344);
      END_STATE();
    case 993:
      if (lookahead == 'g') ADVANCE(1353);
      END_STATE();
    case 994:
      if (lookahead == 'g') ADVANCE(775);
      END_STATE();
    case 995:
      if (lookahead == 'g') ADVANCE(807);
      END_STATE();
    case 996:
      if (lookahead == 'g') ADVANCE(811);
      END_STATE();
    case 997:
      if (lookahead == 'g') ADVANCE(1726);
      END_STATE();
    case 998:
      if (lookahead == 'g') ADVANCE(1726);
      if (lookahead == 'i') ADVANCE(1366);
      if (lookahead == 't') ADVANCE(1507);
      END_STATE();
    case 999:
      if (lookahead == 'g') ADVANCE(1624);
      END_STATE();
    case 1000:
      if (lookahead == 'g') ADVANCE(1051);
      if (lookahead == 'n') ADVANCE(969);
      if (lookahead == 's') ADVANCE(1150);
      END_STATE();
    case 1001:
      if (lookahead == 'g') ADVANCE(769);
      END_STATE();
    case 1002:
      if (lookahead == 'g') ADVANCE(1633);
      END_STATE();
    case 1003:
      if (lookahead == 'g') ADVANCE(1047);
      END_STATE();
    case 1004:
      if (lookahead == 'g') ADVANCE(1827);
      END_STATE();
    case 1005:
      if (lookahead == 'g') ADVANCE(1827);
      if (lookahead == 'l') ADVANCE(821);
      END_STATE();
    case 1006:
      if (lookahead == 'g') ADVANCE(1827);
      if (lookahead == 'q') ADVANCE(1004);
      END_STATE();
    case 1007:
      if (lookahead == 'g') ADVANCE(1052);
      END_STATE();
    case 1008:
      if (lookahead == 'g') ADVANCE(1345);
      if (lookahead == 'm') ADVANCE(99);
      END_STATE();
    case 1009:
      if (lookahead == 'g') ADVANCE(1677);
      END_STATE();
    case 1010:
      if (lookahead == 'g') ADVANCE(1677);
      if (lookahead == 'r') ADVANCE(1794);
      END_STATE();
    case 1011:
      if (lookahead == 'g') ADVANCE(1053);
      END_STATE();
    case 1012:
      if (lookahead == 'g') ADVANCE(1055);
      END_STATE();
    case 1013:
      if (lookahead == 'g') ADVANCE(1056);
      END_STATE();
    case 1014:
      if (lookahead == 'g') ADVANCE(1057);
      END_STATE();
    case 1015:
      if (lookahead == 'g') ADVANCE(1256);
      END_STATE();
    case 1016:
      if (lookahead == 'g') ADVANCE(1059);
      END_STATE();
    case 1017:
      if (lookahead == 'g') ADVANCE(889);
      if (lookahead == 'r') ADVANCE(698);
      END_STATE();
    case 1018:
      if (lookahead == 'g') ADVANCE(1060);
      END_STATE();
    case 1019:
      if (lookahead == 'g') ADVANCE(1061);
      END_STATE();
    case 1020:
      if (lookahead == 'g') ADVANCE(1278);
      END_STATE();
    case 1021:
      if (lookahead == 'g') ADVANCE(1050);
      END_STATE();
    case 1022:
      if (lookahead == 'g') ADVANCE(1280);
      END_STATE();
    case 1023:
      if (lookahead == 'g') ADVANCE(1281);
      END_STATE();
    case 1024:
      if (lookahead == 'g') ADVANCE(1282);
      END_STATE();
    case 1025:
      if (lookahead == 'g') ADVANCE(1295);
      END_STATE();
    case 1026:
      if (lookahead == 'g') ADVANCE(1283);
      END_STATE();
    case 1027:
      if (lookahead == 'g') ADVANCE(1284);
      END_STATE();
    case 1028:
      if (lookahead == 'g') ADVANCE(345);
      END_STATE();
    case 1029:
      if (lookahead == 'g') ADVANCE(543);
      END_STATE();
    case 1030:
      if (lookahead == 'g') ADVANCE(1070);
      END_STATE();
    case 1031:
      if (lookahead == 'h') ADVANCE(730);
      END_STATE();
    case 1032:
      if (lookahead == 'h') ADVANCE(13);
      END_STATE();
    case 1033:
      if (lookahead == 'h') ADVANCE(152);
      END_STATE();
    case 1034:
      if (lookahead == 'h') ADVANCE(365);
      END_STATE();
    case 1035:
      if (lookahead == 'h') ADVANCE(382);
      END_STATE();
    case 1036:
      if (lookahead == 'h') ADVANCE(210);
      END_STATE();
    case 1037:
      if (lookahead == 'h') ADVANCE(1807);
      END_STATE();
    case 1038:
      if (lookahead == 'h') ADVANCE(1957);
      END_STATE();
    case 1039:
      if (lookahead == 'h') ADVANCE(603);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 1040:
      if (lookahead == 'h') ADVANCE(1072);
      END_STATE();
    case 1041:
      if (lookahead == 'h') ADVANCE(1072);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(1506);
      END_STATE();
    case 1042:
      if (lookahead == 'h') ADVANCE(396);
      END_STATE();
    case 1043:
      if (lookahead == 'h') ADVANCE(1526);
      END_STATE();
    case 1044:
      if (lookahead == 'h') ADVANCE(1188);
      END_STATE();
    case 1045:
      if (lookahead == 'h') ADVANCE(1188);
      if (lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 1046:
      if (lookahead == 'h') ADVANCE(775);
      END_STATE();
    case 1047:
      if (lookahead == 'h') ADVANCE(1898);
      END_STATE();
    case 1048:
      if (lookahead == 'h') ADVANCE(1814);
      END_STATE();
    case 1049:
      if (lookahead == 'h') ADVANCE(406);
      END_STATE();
    case 1050:
      if (lookahead == 'h') ADVANCE(1852);
      END_STATE();
    case 1051:
      if (lookahead == 'h') ADVANCE(1816);
      END_STATE();
    case 1052:
      if (lookahead == 'h') ADVANCE(1841);
      END_STATE();
    case 1053:
      if (lookahead == 'h') ADVANCE(1829);
      END_STATE();
    case 1054:
      if (lookahead == 'h') ADVANCE(1075);
      END_STATE();
    case 1055:
      if (lookahead == 'h') ADVANCE(1820);
      END_STATE();
    case 1056:
      if (lookahead == 'h') ADVANCE(1822);
      END_STATE();
    case 1057:
      if (lookahead == 'h') ADVANCE(1837);
      END_STATE();
    case 1058:
      if (lookahead == 'h') ADVANCE(841);
      if (lookahead == 'r') ADVANCE(1183);
      END_STATE();
    case 1059:
      if (lookahead == 'h') ADVANCE(1824);
      END_STATE();
    case 1060:
      if (lookahead == 'h') ADVANCE(1826);
      END_STATE();
    case 1061:
      if (lookahead == 'h') ADVANCE(1823);
      END_STATE();
    case 1062:
      if (lookahead == 'h') ADVANCE(917);
      END_STATE();
    case 1063:
      if (lookahead == 'h') ADVANCE(1109);
      END_STATE();
    case 1064:
      if (lookahead == 'h') ADVANCE(849);
      END_STATE();
    case 1065:
      if (lookahead == 'h') ADVANCE(966);
      END_STATE();
    case 1066:
      if (lookahead == 'h') ADVANCE(1648);
      if (lookahead == 'i') ADVANCE(1346);
      if (lookahead == 'r') ADVANCE(1080);
      END_STATE();
    case 1067:
      if (lookahead == 'h') ADVANCE(871);
      END_STATE();
    case 1068:
      if (lookahead == 'h') ADVANCE(1133);
      END_STATE();
    case 1069:
      if (lookahead == 'h') ADVANCE(1729);
      END_STATE();
    case 1070:
      if (lookahead == 'h') ADVANCE(1897);
      END_STATE();
    case 1071:
      if (lookahead == 'i') ADVANCE(730);
      END_STATE();
    case 1072:
      if (lookahead == 'i') ADVANCE(13);
      END_STATE();
    case 1073:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 1074:
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 1075:
      if (lookahead == 'i') ADVANCE(679);
      END_STATE();
    case 1076:
      if (lookahead == 'i') ADVANCE(1985);
      if (lookahead == 'o') ADVANCE(1067);
      END_STATE();
    case 1077:
      if (lookahead == 'i') ADVANCE(2001);
      END_STATE();
    case 1078:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 1079:
      if (lookahead == 'i') ADVANCE(156);
      END_STATE();
    case 1080:
      if (lookahead == 'i') ADVANCE(227);
      END_STATE();
    case 1081:
      if (lookahead == 'i') ADVANCE(141);
      END_STATE();
    case 1082:
      if (lookahead == 'i') ADVANCE(1599);
      END_STATE();
    case 1083:
      if (lookahead == 'i') ADVANCE(1599);
      if (lookahead == 'r') ADVANCE(1453);
      END_STATE();
    case 1084:
      if (lookahead == 'i') ADVANCE(1366);
      END_STATE();
    case 1085:
      if (lookahead == 'i') ADVANCE(1366);
      if (lookahead == 'n') ADVANCE(1807);
      END_STATE();
    case 1086:
      if (lookahead == 'i') ADVANCE(210);
      if (lookahead == 'm') ADVANCE(1344);
      if (lookahead == 'o') ADVANCE(1387);
      END_STATE();
    case 1087:
      if (lookahead == 'i') ADVANCE(989);
      if (lookahead == 'u') ADVANCE(602);
      END_STATE();
    case 1088:
      if (lookahead == 'i') ADVANCE(1240);
      END_STATE();
    case 1089:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 1090:
      if (lookahead == 'i') ADVANCE(1807);
      END_STATE();
    case 1091:
      if (lookahead == 'i') ADVANCE(1957);
      END_STATE();
    case 1092:
      if (lookahead == 'i') ADVANCE(725);
      END_STATE();
    case 1093:
      if (lookahead == 'i') ADVANCE(725);
      if (lookahead == 'o') ADVANCE(1941);
      END_STATE();
    case 1094:
      if (lookahead == 'i') ADVANCE(1354);
      END_STATE();
    case 1095:
      if (lookahead == 'i') ADVANCE(211);
      END_STATE();
    case 1096:
      if (lookahead == 'i') ADVANCE(1801);
      END_STATE();
    case 1097:
      if (lookahead == 'i') ADVANCE(1801);
      if (lookahead == 'p') ADVANCE(1481);
      END_STATE();
    case 1098:
      if (lookahead == 'i') ADVANCE(106);
      END_STATE();
    case 1099:
      if (lookahead == 'i') ADVANCE(1236);
      END_STATE();
    case 1100:
      if (lookahead == 'i') ADVANCE(1526);
      END_STATE();
    case 1101:
      if (lookahead == 'i') ADVANCE(969);
      END_STATE();
    case 1102:
      if (lookahead == 'i') ADVANCE(969);
      if (lookahead == 'l') ADVANCE(1101);
      END_STATE();
    case 1103:
      if (lookahead == 'i') ADVANCE(951);
      END_STATE();
    case 1104:
      if (lookahead == 'i') ADVANCE(1312);
      END_STATE();
    case 1105:
      if (lookahead == 'i') ADVANCE(1312);
      if (lookahead == 'l') ADVANCE(13);
      END_STATE();
    case 1106:
      if (lookahead == 'i') ADVANCE(1312);
      if (lookahead == 'l') ADVANCE(523);
      END_STATE();
    case 1107:
      if (lookahead == 'i') ADVANCE(1478);
      END_STATE();
    case 1108:
      if (lookahead == 'i') ADVANCE(1752);
      END_STATE();
    case 1109:
      if (lookahead == 'i') ADVANCE(1374);
      END_STATE();
    case 1110:
      if (lookahead == 'i') ADVANCE(1777);
      if (lookahead == 'l') ADVANCE(1487);
      if (lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 1111:
      if (lookahead == 'i') ADVANCE(1777);
      if (lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 1112:
      if (lookahead == 'i') ADVANCE(1207);
      END_STATE();
    case 1113:
      if (lookahead == 'i') ADVANCE(982);
      END_STATE();
    case 1114:
      if (lookahead == 'i') ADVANCE(993);
      END_STATE();
    case 1115:
      if (lookahead == 'i') ADVANCE(1918);
      END_STATE();
    case 1116:
      if (lookahead == 'i') ADVANCE(1353);
      END_STATE();
    case 1117:
      if (lookahead == 'i') ADVANCE(1237);
      END_STATE();
    case 1118:
      if (lookahead == 'i') ADVANCE(611);
      END_STATE();
    case 1119:
      if (lookahead == 'i') ADVANCE(1629);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 1120:
      if (lookahead == 'i') ADVANCE(775);
      END_STATE();
    case 1121:
      if (lookahead == 'i') ADVANCE(1387);
      END_STATE();
    case 1122:
      if (lookahead == 'i') ADVANCE(537);
      END_STATE();
    case 1123:
      if (lookahead == 'i') ADVANCE(760);
      END_STATE();
    case 1124:
      if (lookahead == 'i') ADVANCE(1331);
      END_STATE();
    case 1125:
      if (lookahead == 'i') ADVANCE(1029);
      END_STATE();
    case 1126:
      if (lookahead == 'i') ADVANCE(1673);
      if (lookahead == 'l') ADVANCE(945);
      if (lookahead == 'm') ADVANCE(1128);
      if (lookahead == 'r') ADVANCE(741);
      END_STATE();
    case 1127:
      if (lookahead == 'i') ADVANCE(1378);
      END_STATE();
    case 1128:
      if (lookahead == 'i') ADVANCE(1223);
      END_STATE();
    case 1129:
      if (lookahead == 'i') ADVANCE(842);
      END_STATE();
    case 1130:
      if (lookahead == 'i') ADVANCE(1913);
      END_STATE();
    case 1131:
      if (lookahead == 'i') ADVANCE(1418);
      END_STATE();
    case 1132:
      if (lookahead == 'i') ADVANCE(1411);
      END_STATE();
    case 1133:
      if (lookahead == 'i') ADVANCE(1357);
      END_STATE();
    case 1134:
      if (lookahead == 'i') ADVANCE(1253);
      if (lookahead == 'l') ADVANCE(1102);
      if (lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 1135:
      if (lookahead == 'i') ADVANCE(990);
      END_STATE();
    case 1136:
      if (lookahead == 'i') ADVANCE(1241);
      END_STATE();
    case 1137:
      if (lookahead == 'i') ADVANCE(1389);
      if (lookahead == 'p') ADVANCE(945);
      END_STATE();
    case 1138:
      if (lookahead == 'i') ADVANCE(1666);
      END_STATE();
    case 1139:
      if (lookahead == 'i') ADVANCE(1666);
      if (lookahead == 'o') ADVANCE(1237);
      END_STATE();
    case 1140:
      if (lookahead == 'i') ADVANCE(1666);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 1141:
      if (lookahead == 'i') ADVANCE(1239);
      END_STATE();
    case 1142:
      if (lookahead == 'i') ADVANCE(594);
      END_STATE();
    case 1143:
      if (lookahead == 'i') ADVANCE(485);
      END_STATE();
    case 1144:
      if (lookahead == 'i') ADVANCE(1792);
      END_STATE();
    case 1145:
      if (lookahead == 'i') ADVANCE(1963);
      END_STATE();
    case 1146:
      if (lookahead == 'i') ADVANCE(1572);
      END_STATE();
    case 1147:
      if (lookahead == 'i') ADVANCE(1397);
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 'u') ADVANCE(1368);
      END_STATE();
    case 1148:
      if (lookahead == 'i') ADVANCE(1258);
      END_STATE();
    case 1149:
      if (lookahead == 'i') ADVANCE(1336);
      END_STATE();
    case 1150:
      if (lookahead == 'i') ADVANCE(1391);
      END_STATE();
    case 1151:
      if (lookahead == 'i') ADVANCE(1796);
      END_STATE();
    case 1152:
      if (lookahead == 'i') ADVANCE(1791);
      END_STATE();
    case 1153:
      if (lookahead == 'i') ADVANCE(1346);
      END_STATE();
    case 1154:
      if (lookahead == 'i') ADVANCE(1332);
      END_STATE();
    case 1155:
      if (lookahead == 'i') ADVANCE(1872);
      END_STATE();
    case 1156:
      if (lookahead == 'i') ADVANCE(1269);
      END_STATE();
    case 1157:
      if (lookahead == 'i') ADVANCE(1395);
      END_STATE();
    case 1158:
      if (lookahead == 'i') ADVANCE(886);
      END_STATE();
    case 1159:
      if (lookahead == 'i') ADVANCE(493);
      END_STATE();
    case 1160:
      if (lookahead == 'i') ADVANCE(1288);
      END_STATE();
    case 1161:
      if (lookahead == 'i') ADVANCE(1256);
      END_STATE();
    case 1162:
      if (lookahead == 'i') ADVANCE(1495);
      END_STATE();
    case 1163:
      if (lookahead == 'i') ADVANCE(1474);
      END_STATE();
    case 1164:
      if (lookahead == 'i') ADVANCE(1412);
      END_STATE();
    case 1165:
      if (lookahead == 'i') ADVANCE(1412);
      if (lookahead == 'n') ADVANCE(13);
      END_STATE();
    case 1166:
      if (lookahead == 'i') ADVANCE(1003);
      END_STATE();
    case 1167:
      if (lookahead == 'i') ADVANCE(1289);
      END_STATE();
    case 1168:
      if (lookahead == 'i') ADVANCE(717);
      END_STATE();
    case 1169:
      if (lookahead == 'i') ADVANCE(721);
      END_STATE();
    case 1170:
      if (lookahead == 'i') ADVANCE(595);
      END_STATE();
    case 1171:
      if (lookahead == 'i') ADVANCE(1011);
      END_STATE();
    case 1172:
      if (lookahead == 'i') ADVANCE(1012);
      END_STATE();
    case 1173:
      if (lookahead == 'i') ADVANCE(1013);
      END_STATE();
    case 1174:
      if (lookahead == 'i') ADVANCE(1014);
      END_STATE();
    case 1175:
      if (lookahead == 'i') ADVANCE(1016);
      END_STATE();
    case 1176:
      if (lookahead == 'i') ADVANCE(1018);
      END_STATE();
    case 1177:
      if (lookahead == 'i') ADVANCE(1019);
      END_STATE();
    case 1178:
      if (lookahead == 'i') ADVANCE(1021);
      END_STATE();
    case 1179:
      if (lookahead == 'i') ADVANCE(1740);
      END_STATE();
    case 1180:
      if (lookahead == 'i') ADVANCE(561);
      END_STATE();
    case 1181:
      if (lookahead == 'i') ADVANCE(1030);
      END_STATE();
    case 1182:
      if (lookahead == 'i') ADVANCE(563);
      END_STATE();
    case 1183:
      if (lookahead == 'i') ADVANCE(564);
      END_STATE();
    case 1184:
      if (lookahead == 'i') ADVANCE(565);
      END_STATE();
    case 1185:
      if (lookahead == 'i') ADVANCE(566);
      END_STATE();
    case 1186:
      if (lookahead == 'j') ADVANCE(13);
      END_STATE();
    case 1187:
      if (lookahead == 'j') ADVANCE(13);
      if (lookahead == 'n') ADVANCE(1186);
      END_STATE();
    case 1188:
      if (lookahead == 'k') ADVANCE(13);
      END_STATE();
    case 1189:
      if (lookahead == 'k') ADVANCE(365);
      END_STATE();
    case 1190:
      if (lookahead == 'k') ADVANCE(719);
      END_STATE();
    case 1191:
      if (lookahead == 'k') ADVANCE(1293);
      END_STATE();
    case 1192:
      if (lookahead == 'k') ADVANCE(1266);
      END_STATE();
    case 1193:
      if (lookahead == 'k') ADVANCE(161);
      END_STATE();
    case 1194:
      if (lookahead == 'k') ADVANCE(140);
      END_STATE();
    case 1195:
      if (lookahead == 'k') ADVANCE(603);
      END_STATE();
    case 1196:
      if (lookahead == 'k') ADVANCE(603);
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 1197:
      if (lookahead == 'k') ADVANCE(1979);
      END_STATE();
    case 1198:
      if (lookahead == 'k') ADVANCE(202);
      END_STATE();
    case 1199:
      if (lookahead == 'k') ADVANCE(1788);
      END_STATE();
    case 1200:
      if (lookahead == 'k') ADVANCE(807);
      END_STATE();
    case 1201:
      if (lookahead == 'k') ADVANCE(811);
      END_STATE();
    case 1202:
      if (lookahead == 'k') ADVANCE(520);
      END_STATE();
    case 1203:
      if (lookahead == 'k') ADVANCE(527);
      END_STATE();
    case 1204:
      if (lookahead == 'k') ADVANCE(527);
      if (lookahead == 'l') ADVANCE(458);
      END_STATE();
    case 1205:
      if (lookahead == 'k') ADVANCE(1157);
      END_STATE();
    case 1206:
      if (lookahead == 'l') ADVANCE(730);
      END_STATE();
    case 1207:
      if (lookahead == 'l') ADVANCE(13);
      END_STATE();
    case 1208:
      if (lookahead == 'l') ADVANCE(199);
      END_STATE();
    case 1209:
      if (lookahead == 'l') ADVANCE(344);
      END_STATE();
    case 1210:
      if (lookahead == 'l') ADVANCE(313);
      END_STATE();
    case 1211:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 1212:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 1213:
      if (lookahead == 'l') ADVANCE(2013);
      END_STATE();
    case 1214:
      if (lookahead == 'l') ADVANCE(279);
      END_STATE();
    case 1215:
      if (lookahead == 'l') ADVANCE(266);
      END_STATE();
    case 1216:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 1217:
      if (lookahead == 'l') ADVANCE(382);
      END_STATE();
    case 1218:
      if (lookahead == 'l') ADVANCE(1991);
      END_STATE();
    case 1219:
      if (lookahead == 'l') ADVANCE(906);
      END_STATE();
    case 1220:
      if (lookahead == 'l') ADVANCE(906);
      if (lookahead == 'q') ADVANCE(1931);
      END_STATE();
    case 1221:
      if (lookahead == 'l') ADVANCE(906);
      if (lookahead == 'q') ADVANCE(1930);
      if (lookahead == 'x') ADVANCE(1096);
      END_STATE();
    case 1222:
      if (lookahead == 'l') ADVANCE(329);
      END_STATE();
    case 1223:
      if (lookahead == 'l') ADVANCE(1807);
      END_STATE();
    case 1224:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 1225:
      if (lookahead == 'l') ADVANCE(322);
      END_STATE();
    case 1226:
      if (lookahead == 'l') ADVANCE(286);
      END_STATE();
    case 1227:
      if (lookahead == 'l') ADVANCE(588);
      END_STATE();
    case 1228:
      if (lookahead == 'l') ADVANCE(278);
      END_STATE();
    case 1229:
      if (lookahead == 'l') ADVANCE(367);
      END_STATE();
    case 1230:
      if (lookahead == 'l') ADVANCE(396);
      END_STATE();
    case 1231:
      if (lookahead == 'l') ADVANCE(297);
      END_STATE();
    case 1232:
      if (lookahead == 'l') ADVANCE(187);
      END_STATE();
    case 1233:
      if (lookahead == 'l') ADVANCE(429);
      END_STATE();
    case 1234:
      if (lookahead == 'l') ADVANCE(111);
      END_STATE();
    case 1235:
      if (lookahead == 'l') ADVANCE(307);
      END_STATE();
    case 1236:
      if (lookahead == 'l') ADVANCE(758);
      END_STATE();
    case 1237:
      if (lookahead == 'l') ADVANCE(1478);
      END_STATE();
    case 1238:
      if (lookahead == 'l') ADVANCE(1188);
      END_STATE();
    case 1239:
      if (lookahead == 'l') ADVANCE(745);
      END_STATE();
    case 1240:
      if (lookahead == 'l') ADVANCE(745);
      if (lookahead == 'm') ADVANCE(842);
      END_STATE();
    case 1241:
      if (lookahead == 'l') ADVANCE(745);
      if (lookahead == 'm') ADVANCE(864);
      END_STATE();
    case 1242:
      if (lookahead == 'l') ADVANCE(824);
      END_STATE();
    case 1243:
      if (lookahead == 'l') ADVANCE(1752);
      END_STATE();
    case 1244:
      if (lookahead == 'l') ADVANCE(697);
      END_STATE();
    case 1245:
      if (lookahead == 'l') ADVANCE(1108);
      END_STATE();
    case 1246:
      if (lookahead == 'l') ADVANCE(1990);
      END_STATE();
    case 1247:
      if (lookahead == 'l') ADVANCE(1074);
      END_STATE();
    case 1248:
      if (lookahead == 'l') ADVANCE(845);
      END_STATE();
    case 1249:
      if (lookahead == 'l') ADVANCE(1207);
      END_STATE();
    case 1250:
      if (lookahead == 'l') ADVANCE(2000);
      END_STATE();
    case 1251:
      if (lookahead == 'l') ADVANCE(1487);
      END_STATE();
    case 1252:
      if (lookahead == 'l') ADVANCE(1938);
      END_STATE();
    case 1253:
      if (lookahead == 'l') ADVANCE(1101);
      END_STATE();
    case 1254:
      if (lookahead == 'l') ADVANCE(1234);
      if (lookahead == 'm') ADVANCE(1538);
      END_STATE();
    case 1255:
      if (lookahead == 'l') ADVANCE(1230);
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 't') ADVANCE(110);
      if (lookahead == 'u') ADVANCE(593);
      if (lookahead == 'w') ADVANCE(1358);
      END_STATE();
    case 1256:
      if (lookahead == 'l') ADVANCE(775);
      END_STATE();
    case 1257:
      if (lookahead == 'l') ADVANCE(833);
      END_STATE();
    case 1258:
      if (lookahead == 'l') ADVANCE(1217);
      END_STATE();
    case 1259:
      if (lookahead == 'l') ADVANCE(1226);
      END_STATE();
    case 1260:
      if (lookahead == 'l') ADVANCE(846);
      END_STATE();
    case 1261:
      if (lookahead == 'l') ADVANCE(1308);
      if (lookahead == 's') ADVANCE(1043);
      END_STATE();
    case 1262:
      if (lookahead == 'l') ADVANCE(1505);
      END_STATE();
    case 1263:
      if (lookahead == 'l') ADVANCE(1129);
      END_STATE();
    case 1264:
      if (lookahead == 'l') ADVANCE(1100);
      END_STATE();
    case 1265:
      if (lookahead == 'l') ADVANCE(1225);
      END_STATE();
    case 1266:
      if (lookahead == 'l') ADVANCE(1456);
      if (lookahead == 's') ADVANCE(1596);
      if (lookahead == 't') ADVANCE(1751);
      END_STATE();
    case 1267:
      if (lookahead == 'l') ADVANCE(821);
      END_STATE();
    case 1268:
      if (lookahead == 'l') ADVANCE(821);
      if (lookahead == 'q') ADVANCE(1267);
      END_STATE();
    case 1269:
      if (lookahead == 'l') ADVANCE(1142);
      END_STATE();
    case 1270:
      if (lookahead == 'l') ADVANCE(445);
      END_STATE();
    case 1271:
      if (lookahead == 'l') ADVANCE(1229);
      END_STATE();
    case 1272:
      if (lookahead == 'l') ADVANCE(793);
      END_STATE();
    case 1273:
      if (lookahead == 'l') ADVANCE(794);
      END_STATE();
    case 1274:
      if (lookahead == 'l') ADVANCE(1490);
      END_STATE();
    case 1275:
      if (lookahead == 'l') ADVANCE(782);
      END_STATE();
    case 1276:
      if (lookahead == 'l') ADVANCE(913);
      END_STATE();
    case 1277:
      if (lookahead == 'l') ADVANCE(835);
      if (lookahead == 'r') ADVANCE(1135);
      END_STATE();
    case 1278:
      if (lookahead == 'l') ADVANCE(801);
      END_STATE();
    case 1279:
      if (lookahead == 'l') ADVANCE(802);
      END_STATE();
    case 1280:
      if (lookahead == 'l') ADVANCE(813);
      END_STATE();
    case 1281:
      if (lookahead == 'l') ADVANCE(933);
      END_STATE();
    case 1282:
      if (lookahead == 'l') ADVANCE(825);
      END_STATE();
    case 1283:
      if (lookahead == 'l') ADVANCE(804);
      END_STATE();
    case 1284:
      if (lookahead == 'l') ADVANCE(805);
      END_STATE();
    case 1285:
      if (lookahead == 'l') ADVANCE(806);
      END_STATE();
    case 1286:
      if (lookahead == 'l') ADVANCE(822);
      END_STATE();
    case 1287:
      if (lookahead == 'l') ADVANCE(458);
      END_STATE();
    case 1288:
      if (lookahead == 'l') ADVANCE(1109);
      END_STATE();
    case 1289:
      if (lookahead == 'l') ADVANCE(752);
      END_STATE();
    case 1290:
      if (lookahead == 'l') ADVANCE(752);
      if (lookahead == 'm') ADVANCE(836);
      if (lookahead == 'n') ADVANCE(1807);
      END_STATE();
    case 1291:
      if (lookahead == 'l') ADVANCE(1480);
      if (lookahead == 'n') ADVANCE(998);
      if (lookahead == 'p') ADVANCE(947);
      if (lookahead == 'u') ADVANCE(1419);
      END_STATE();
    case 1292:
      if (lookahead == 'l') ADVANCE(401);
      END_STATE();
    case 1293:
      if (lookahead == 'l') ADVANCE(817);
      if (lookahead == 'r') ADVANCE(1166);
      END_STATE();
    case 1294:
      if (lookahead == 'l') ADVANCE(898);
      END_STATE();
    case 1295:
      if (lookahead == 'l') ADVANCE(897);
      END_STATE();
    case 1296:
      if (lookahead == 'l') ADVANCE(513);
      END_STATE();
    case 1297:
      if (lookahead == 'l') ADVANCE(1914);
      END_STATE();
    case 1298:
      if (lookahead == 'l') ADVANCE(1260);
      END_STATE();
    case 1299:
      if (lookahead == 'l') ADVANCE(459);
      END_STATE();
    case 1300:
      if (lookahead == 'l') ADVANCE(1150);
      END_STATE();
    case 1301:
      if (lookahead == 'l') ADVANCE(1485);
      if (lookahead == 'm') ADVANCE(1341);
      if (lookahead == 'n') ADVANCE(974);
      if (lookahead == 'p') ADVANCE(131);
      END_STATE();
    case 1302:
      if (lookahead == 'l') ADVANCE(1698);
      END_STATE();
    case 1303:
      if (lookahead == 'l') ADVANCE(1084);
      END_STATE();
    case 1304:
      if (lookahead == 'l') ADVANCE(1245);
      END_STATE();
    case 1305:
      if (lookahead == 'l') ADVANCE(1132);
      END_STATE();
    case 1306:
      if (lookahead == 'l') ADVANCE(1248);
      END_STATE();
    case 1307:
      if (lookahead == 'l') ADVANCE(535);
      END_STATE();
    case 1308:
      if (lookahead == 'l') ADVANCE(1804);
      END_STATE();
    case 1309:
      if (lookahead == 'l') ADVANCE(1300);
      END_STATE();
    case 1310:
      if (lookahead == 'l') ADVANCE(901);
      if (lookahead == 'm') ADVANCE(480);
      if (lookahead == 'r') ADVANCE(1166);
      END_STATE();
    case 1311:
      if (lookahead == 'l') ADVANCE(928);
      if (lookahead == 'r') ADVANCE(1178);
      END_STATE();
    case 1312:
      if (lookahead == 'm') ADVANCE(13);
      END_STATE();
    case 1313:
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 1314:
      if (lookahead == 'm') ADVANCE(152);
      if (lookahead == 'r') ADVANCE(1437);
      END_STATE();
    case 1315:
      if (lookahead == 'm') ADVANCE(365);
      END_STATE();
    case 1316:
      if (lookahead == 'm') ADVANCE(173);
      END_STATE();
    case 1317:
      if (lookahead == 'm') ADVANCE(223);
      END_STATE();
    case 1318:
      if (lookahead == 'm') ADVANCE(222);
      END_STATE();
    case 1319:
      if (lookahead == 'm') ADVANCE(382);
      END_STATE();
    case 1320:
      if (lookahead == 'm') ADVANCE(1165);
      END_STATE();
    case 1321:
      if (lookahead == 'm') ADVANCE(1072);
      END_STATE();
    case 1322:
      if (lookahead == 'm') ADVANCE(106);
      END_STATE();
    case 1323:
      if (lookahead == 'm') ADVANCE(1526);
      END_STATE();
    case 1324:
      if (lookahead == 'm') ADVANCE(1556);
      END_STATE();
    case 1325:
      if (lookahead == 'm') ADVANCE(1537);
      END_STATE();
    case 1326:
      if (lookahead == 'm') ADVANCE(1071);
      END_STATE();
    case 1327:
      if (lookahead == 'm') ADVANCE(1071);
      if (lookahead == 'p') ADVANCE(532);
      END_STATE();
    case 1328:
      if (lookahead == 'm') ADVANCE(1319);
      END_STATE();
    case 1329:
      if (lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 1330:
      if (lookahead == 'm') ADVANCE(1560);
      END_STATE();
    case 1331:
      if (lookahead == 'm') ADVANCE(115);
      END_STATE();
    case 1332:
      if (lookahead == 'm') ADVANCE(422);
      END_STATE();
    case 1333:
      if (lookahead == 'm') ADVANCE(845);
      END_STATE();
    case 1334:
      if (lookahead == 'm') ADVANCE(1207);
      END_STATE();
    case 1335:
      if (lookahead == 'm') ADVANCE(1353);
      END_STATE();
    case 1336:
      if (lookahead == 'm') ADVANCE(775);
      END_STATE();
    case 1337:
      if (lookahead == 'm') ADVANCE(1552);
      END_STATE();
    case 1338:
      if (lookahead == 'm') ADVANCE(1547);
      END_STATE();
    case 1339:
      if (lookahead == 'm') ADVANCE(537);
      END_STATE();
    case 1340:
      if (lookahead == 'm') ADVANCE(410);
      END_STATE();
    case 1341:
      if (lookahead == 'm') ADVANCE(417);
      if (lookahead == 'p') ADVANCE(134);
      END_STATE();
    case 1342:
      if (lookahead == 'm') ADVANCE(809);
      END_STATE();
    case 1343:
      if (lookahead == 'm') ADVANCE(809);
      if (lookahead == 'x') ADVANCE(842);
      END_STATE();
    case 1344:
      if (lookahead == 'm') ADVANCE(406);
      END_STATE();
    case 1345:
      if (lookahead == 'm') ADVANCE(390);
      END_STATE();
    case 1346:
      if (lookahead == 'm') ADVANCE(842);
      END_STATE();
    case 1347:
      if (lookahead == 'm') ADVANCE(1568);
      END_STATE();
    case 1348:
      if (lookahead == 'm') ADVANCE(829);
      END_STATE();
    case 1349:
      if (lookahead == 'm') ADVANCE(1340);
      END_STATE();
    case 1350:
      if (lookahead == 'm') ADVANCE(1164);
      END_STATE();
    case 1351:
      if (lookahead == 'm') ADVANCE(531);
      END_STATE();
    case 1352:
      if (lookahead == 'n') ADVANCE(730);
      END_STATE();
    case 1353:
      if (lookahead == 'n') ADVANCE(13);
      END_STATE();
    case 1354:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 1355:
      if (lookahead == 'n') ADVANCE(275);
      END_STATE();
    case 1356:
      if (lookahead == 'n') ADVANCE(288);
      END_STATE();
    case 1357:
      if (lookahead == 'n') ADVANCE(365);
      END_STATE();
    case 1358:
      if (lookahead == 'n') ADVANCE(545);
      END_STATE();
    case 1359:
      if (lookahead == 'n') ADVANCE(217);
      END_STATE();
    case 1360:
      if (lookahead == 'n') ADVANCE(689);
      END_STATE();
    case 1361:
      if (lookahead == 'n') ADVANCE(2008);
      END_STATE();
    case 1362:
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 1363:
      if (lookahead == 'n') ADVANCE(371);
      END_STATE();
    case 1364:
      if (lookahead == 'n') ADVANCE(375);
      END_STATE();
    case 1365:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 1366:
      if (lookahead == 'n') ADVANCE(1807);
      END_STATE();
    case 1367:
      if (lookahead == 'n') ADVANCE(338);
      END_STATE();
    case 1368:
      if (lookahead == 'n') ADVANCE(100);
      END_STATE();
    case 1369:
      if (lookahead == 'n') ADVANCE(269);
      END_STATE();
    case 1370:
      if (lookahead == 'n') ADVANCE(1984);
      END_STATE();
    case 1371:
      if (lookahead == 'n') ADVANCE(967);
      END_STATE();
    case 1372:
      if (lookahead == 'n') ADVANCE(765);
      END_STATE();
    case 1373:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 1374:
      if (lookahead == 'n') ADVANCE(969);
      END_STATE();
    case 1375:
      if (lookahead == 'n') ADVANCE(969);
      if (lookahead == 'r') ADVANCE(1599);
      END_STATE();
    case 1376:
      if (lookahead == 'n') ADVANCE(1867);
      END_STATE();
    case 1377:
      if (lookahead == 'n') ADVANCE(975);
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 'w') ADVANCE(876);
      END_STATE();
    case 1378:
      if (lookahead == 'n') ADVANCE(207);
      END_STATE();
    case 1379:
      if (lookahead == 'n') ADVANCE(1188);
      END_STATE();
    case 1380:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 1381:
      if (lookahead == 'n') ADVANCE(1752);
      END_STATE();
    case 1382:
      if (lookahead == 'n') ADVANCE(738);
      END_STATE();
    case 1383:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 1384:
      if (lookahead == 'n') ADVANCE(999);
      if (lookahead == 'r') ADVANCE(856);
      END_STATE();
    case 1385:
      if (lookahead == 'n') ADVANCE(695);
      END_STATE();
    case 1386:
      if (lookahead == 'n') ADVANCE(1015);
      END_STATE();
    case 1387:
      if (lookahead == 'n') ADVANCE(775);
      END_STATE();
    case 1388:
      if (lookahead == 'n') ADVANCE(973);
      END_STATE();
    case 1389:
      if (lookahead == 'n') ADVANCE(723);
      END_STATE();
    case 1390:
      if (lookahead == 'n') ADVANCE(1483);
      END_STATE();
    case 1391:
      if (lookahead == 'n') ADVANCE(1001);
      END_STATE();
    case 1392:
      if (lookahead == 'n') ADVANCE(748);
      END_STATE();
    case 1393:
      if (lookahead == 'n') ADVANCE(1028);
      END_STATE();
    case 1394:
      if (lookahead == 'n') ADVANCE(807);
      END_STATE();
    case 1395:
      if (lookahead == 'n') ADVANCE(976);
      END_STATE();
    case 1396:
      if (lookahead == 'n') ADVANCE(718);
      END_STATE();
    case 1397:
      if (lookahead == 'n') ADVANCE(1885);
      END_STATE();
    case 1398:
      if (lookahead == 'n') ADVANCE(1818);
      END_STATE();
    case 1399:
      if (lookahead == 'n') ADVANCE(1832);
      END_STATE();
    case 1400:
      if (lookahead == 'n') ADVANCE(1857);
      END_STATE();
    case 1401:
      if (lookahead == 'n') ADVANCE(1859);
      END_STATE();
    case 1402:
      if (lookahead == 'n') ADVANCE(837);
      END_STATE();
    case 1403:
      if (lookahead == 'n') ADVANCE(840);
      END_STATE();
    case 1404:
      if (lookahead == 'n') ADVANCE(1277);
      END_STATE();
    case 1405:
      if (lookahead == 'n') ADVANCE(1916);
      END_STATE();
    case 1406:
      if (lookahead == 'n') ADVANCE(66);
      END_STATE();
    case 1407:
      if (lookahead == 'n') ADVANCE(994);
      END_STATE();
    case 1408:
      if (lookahead == 'n') ADVANCE(997);
      END_STATE();
    case 1409:
      if (lookahead == 'n') ADVANCE(922);
      END_STATE();
    case 1410:
      if (lookahead == 'n') ADVANCE(1107);
      END_STATE();
    case 1411:
      if (lookahead == 'n') ADVANCE(1875);
      END_STATE();
    case 1412:
      if (lookahead == 'n') ADVANCE(1914);
      END_STATE();
    case 1413:
      if (lookahead == 'n') ADVANCE(1488);
      END_STATE();
    case 1414:
      if (lookahead == 'n') ADVANCE(1876);
      END_STATE();
    case 1415:
      if (lookahead == 'n') ADVANCE(1084);
      END_STATE();
    case 1416:
      if (lookahead == 'n') ADVANCE(1874);
      END_STATE();
    case 1417:
      if (lookahead == 'n') ADVANCE(1894);
      END_STATE();
    case 1418:
      if (lookahead == 'n') ADVANCE(505);
      END_STATE();
    case 1419:
      if (lookahead == 'n') ADVANCE(1886);
      END_STATE();
    case 1420:
      if (lookahead == 'n') ADVANCE(1020);
      END_STATE();
    case 1421:
      if (lookahead == 'n') ADVANCE(1884);
      END_STATE();
    case 1422:
      if (lookahead == 'n') ADVANCE(1163);
      END_STATE();
    case 1423:
      if (lookahead == 'n') ADVANCE(925);
      END_STATE();
    case 1424:
      if (lookahead == 'n') ADVANCE(1022);
      if (lookahead == 'r') ADVANCE(1702);
      END_STATE();
    case 1425:
      if (lookahead == 'n') ADVANCE(1022);
      if (lookahead == 'r') ADVANCE(1706);
      END_STATE();
    case 1426:
      if (lookahead == 'n') ADVANCE(1888);
      END_STATE();
    case 1427:
      if (lookahead == 'n') ADVANCE(1023);
      END_STATE();
    case 1428:
      if (lookahead == 'n') ADVANCE(1024);
      END_STATE();
    case 1429:
      if (lookahead == 'n') ADVANCE(1890);
      END_STATE();
    case 1430:
      if (lookahead == 'n') ADVANCE(1025);
      END_STATE();
    case 1431:
      if (lookahead == 'n') ADVANCE(1026);
      END_STATE();
    case 1432:
      if (lookahead == 'n') ADVANCE(1027);
      END_STATE();
    case 1433:
      if (lookahead == 'n') ADVANCE(1895);
      END_STATE();
    case 1434:
      if (lookahead == 'n') ADVANCE(554);
      END_STATE();
    case 1435:
      if (lookahead == 'n') ADVANCE(543);
      END_STATE();
    case 1436:
      if (lookahead == 'o') ADVANCE(730);
      END_STATE();
    case 1437:
      if (lookahead == 'o') ADVANCE(13);
      END_STATE();
    case 1438:
      if (lookahead == 'o') ADVANCE(183);
      END_STATE();
    case 1439:
      if (lookahead == 'o') ADVANCE(945);
      END_STATE();
    case 1440:
      if (lookahead == 'o') ADVANCE(1975);
      END_STATE();
    case 1441:
      if (lookahead == 'o') ADVANCE(376);
      END_STATE();
    case 1442:
      if (lookahead == 'o') ADVANCE(1955);
      END_STATE();
    case 1443:
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 1444:
      if (lookahead == 'o') ADVANCE(1809);
      END_STATE();
    case 1445:
      if (lookahead == 'o') ADVANCE(1808);
      END_STATE();
    case 1446:
      if (lookahead == 'o') ADVANCE(1599);
      END_STATE();
    case 1447:
      if (lookahead == 'o') ADVANCE(1807);
      END_STATE();
    case 1448:
      if (lookahead == 'o') ADVANCE(1807);
      if (lookahead == 's') ADVANCE(1908);
      END_STATE();
    case 1449:
      if (lookahead == 'o') ADVANCE(163);
      END_STATE();
    case 1450:
      if (lookahead == 'o') ADVANCE(1986);
      END_STATE();
    case 1451:
      if (lookahead == 'o') ADVANCE(678);
      END_STATE();
    case 1452:
      if (lookahead == 'o') ADVANCE(1984);
      END_STATE();
    case 1453:
      if (lookahead == 'o') ADVANCE(1778);
      END_STATE();
    case 1454:
      if (lookahead == 'o') ADVANCE(198);
      END_STATE();
    case 1455:
      if (lookahead == 'o') ADVANCE(1965);
      END_STATE();
    case 1456:
      if (lookahead == 'o') ADVANCE(2004);
      END_STATE();
    case 1457:
      if (lookahead == 'o') ADVANCE(1526);
      END_STATE();
    case 1458:
      if (lookahead == 'o') ADVANCE(1415);
      END_STATE();
    case 1459:
      if (lookahead == 'o') ADVANCE(1966);
      END_STATE();
    case 1460:
      if (lookahead == 'o') ADVANCE(1967);
      END_STATE();
    case 1461:
      if (lookahead == 'o') ADVANCE(1312);
      END_STATE();
    case 1462:
      if (lookahead == 'o') ADVANCE(1188);
      END_STATE();
    case 1463:
      if (lookahead == 'o') ADVANCE(1862);
      END_STATE();
    case 1464:
      if (lookahead == 'o') ADVANCE(1968);
      END_STATE();
    case 1465:
      if (lookahead == 'o') ADVANCE(1980);
      END_STATE();
    case 1466:
      if (lookahead == 'o') ADVANCE(1752);
      END_STATE();
    case 1467:
      if (lookahead == 'o') ADVANCE(1374);
      END_STATE();
    case 1468:
      if (lookahead == 'o') ADVANCE(1374);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 1469:
      if (lookahead == 'o') ADVANCE(1981);
      END_STATE();
    case 1470:
      if (lookahead == 'o') ADVANCE(1974);
      END_STATE();
    case 1471:
      if (lookahead == 'o') ADVANCE(1969);
      END_STATE();
    case 1472:
      if (lookahead == 'o') ADVANCE(1207);
      if (lookahead == 'u') ADVANCE(567);
      END_STATE();
    case 1473:
      if (lookahead == 'o') ADVANCE(753);
      END_STATE();
    case 1474:
      if (lookahead == 'o') ADVANCE(1381);
      END_STATE();
    case 1475:
      if (lookahead == 'o') ADVANCE(1972);
      END_STATE();
    case 1476:
      if (lookahead == 'o') ADVANCE(1813);
      END_STATE();
    case 1477:
      if (lookahead == 'o') ADVANCE(1653);
      END_STATE();
    case 1478:
      if (lookahead == 'o') ADVANCE(1353);
      END_STATE();
    case 1479:
      if (lookahead == 'o') ADVANCE(1353);
      if (lookahead == 'r') ADVANCE(414);
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 1480:
      if (lookahead == 'o') ADVANCE(1373);
      END_STATE();
    case 1481:
      if (lookahead == 'o') ADVANCE(1409);
      END_STATE();
    case 1482:
      if (lookahead == 'o') ADVANCE(1365);
      END_STATE();
    case 1483:
      if (lookahead == 'o') ADVANCE(1951);
      END_STATE();
    case 1484:
      if (lookahead == 'o') ADVANCE(1352);
      END_STATE();
    case 1485:
      if (lookahead == 'o') ADVANCE(1380);
      END_STATE();
    case 1486:
      if (lookahead == 'o') ADVANCE(1953);
      END_STATE();
    case 1487:
      if (lookahead == 'o') ADVANCE(1446);
      END_STATE();
    case 1488:
      if (lookahead == 'o') ADVANCE(1899);
      END_STATE();
    case 1489:
      if (lookahead == 'o') ADVANCE(1206);
      END_STATE();
    case 1490:
      if (lookahead == 'o') ADVANCE(677);
      END_STATE();
    case 1491:
      if (lookahead == 'o') ADVANCE(1848);
      END_STATE();
    case 1492:
      if (lookahead == 'o') ADVANCE(1850);
      END_STATE();
    case 1493:
      if (lookahead == 'o') ADVANCE(1892);
      END_STATE();
    case 1494:
      if (lookahead == 'o') ADVANCE(1404);
      END_STATE();
    case 1495:
      if (lookahead == 'o') ADVANCE(1406);
      END_STATE();
    case 1496:
      if (lookahead == 'o') ADVANCE(1372);
      END_STATE();
    case 1497:
      if (lookahead == 'o') ADVANCE(1665);
      if (lookahead == 'r') ADVANCE(1457);
      END_STATE();
    case 1498:
      if (lookahead == 'o') ADVANCE(1690);
      END_STATE();
    case 1499:
      if (lookahead == 'o') ADVANCE(1692);
      if (lookahead == 'r') ADVANCE(1457);
      END_STATE();
    case 1500:
      if (lookahead == 'o') ADVANCE(1616);
      END_STATE();
    case 1501:
      if (lookahead == 'o') ADVANCE(1976);
      END_STATE();
    case 1502:
      if (lookahead == 'o') ADVANCE(1328);
      END_STATE();
    case 1503:
      if (lookahead == 'o') ADVANCE(1328);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 1504:
      if (lookahead == 'o') ADVANCE(1671);
      END_STATE();
    case 1505:
      if (lookahead == 'o') ADVANCE(1555);
      END_STATE();
    case 1506:
      if (lookahead == 'o') ADVANCE(1566);
      END_STATE();
    case 1507:
      if (lookahead == 'o') ADVANCE(1935);
      END_STATE();
    case 1508:
      if (lookahead == 'o') ADVANCE(1982);
      END_STATE();
    case 1509:
      if (lookahead == 'o') ADVANCE(1977);
      END_STATE();
    case 1510:
      if (lookahead == 'o') ADVANCE(1941);
      END_STATE();
    case 1511:
      if (lookahead == 'o') ADVANCE(1856);
      END_STATE();
    case 1512:
      if (lookahead == 'o') ADVANCE(1408);
      if (lookahead == 'u') ADVANCE(1546);
      END_STATE();
    case 1513:
      if (lookahead == 'o') ADVANCE(1978);
      END_STATE();
    case 1514:
      if (lookahead == 'o') ADVANCE(1421);
      END_STATE();
    case 1515:
      if (lookahead == 'o') ADVANCE(1686);
      END_STATE();
    case 1516:
      if (lookahead == 'o') ADVANCE(1494);
      END_STATE();
    case 1517:
      if (lookahead == 'o') ADVANCE(1667);
      END_STATE();
    case 1518:
      if (lookahead == 'o') ADVANCE(1400);
      END_STATE();
    case 1519:
      if (lookahead == 'o') ADVANCE(1474);
      END_STATE();
    case 1520:
      if (lookahead == 'o') ADVANCE(1496);
      END_STATE();
    case 1521:
      if (lookahead == 'o') ADVANCE(1732);
      END_STATE();
    case 1522:
      if (lookahead == 'o') ADVANCE(1303);
      END_STATE();
    case 1523:
      if (lookahead == 'o') ADVANCE(1956);
      END_STATE();
    case 1524:
      if (lookahead == 'o') ADVANCE(1983);
      END_STATE();
    case 1525:
      if (lookahead == 'p') ADVANCE(1803);
      END_STATE();
    case 1526:
      if (lookahead == 'p') ADVANCE(13);
      END_STATE();
    case 1527:
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(1478);
      END_STATE();
    case 1528:
      if (lookahead == 'p') ADVANCE(1035);
      END_STATE();
    case 1529:
      if (lookahead == 'p') ADVANCE(945);
      END_STATE();
    case 1530:
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 'r') ADVANCE(524);
      END_STATE();
    case 1531:
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 'r') ADVANCE(267);
      if (lookahead == 'u') ADVANCE(1683);
      END_STATE();
    case 1532:
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 'r') ADVANCE(1077);
      END_STATE();
    case 1533:
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 't') ADVANCE(26);
      if (lookahead == 'u') ADVANCE(592);
      if (lookahead == 'w') ADVANCE(1355);
      END_STATE();
    case 1534:
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 't') ADVANCE(206);
      if (lookahead == 'w') ADVANCE(1868);
      if (lookahead == 'x') ADVANCE(301);
      END_STATE();
    case 1535:
      if (lookahead == 'p') ADVANCE(945);
      if (lookahead == 'u') ADVANCE(1382);
      END_STATE();
    case 1536:
      if (lookahead == 'p') ADVANCE(25);
      END_STATE();
    case 1537:
      if (lookahead == 'p') ADVANCE(309);
      END_STATE();
    case 1538:
      if (lookahead == 'p') ADVANCE(32);
      END_STATE();
    case 1539:
      if (lookahead == 'p') ADVANCE(7);
      END_STATE();
    case 1540:
      if (lookahead == 'p') ADVANCE(310);
      END_STATE();
    case 1541:
      if (lookahead == 'p') ADVANCE(270);
      END_STATE();
    case 1542:
      if (lookahead == 'p') ADVANCE(1599);
      if (lookahead == 's') ADVANCE(611);
      END_STATE();
    case 1543:
      if (lookahead == 'p') ADVANCE(382);
      END_STATE();
    case 1544:
      if (lookahead == 'p') ADVANCE(177);
      END_STATE();
    case 1545:
      if (lookahead == 'p') ADVANCE(269);
      END_STATE();
    case 1546:
      if (lookahead == 'p') ADVANCE(284);
      END_STATE();
    case 1547:
      if (lookahead == 'p') ADVANCE(106);
      END_STATE();
    case 1548:
      if (lookahead == 'p') ADVANCE(187);
      END_STATE();
    case 1549:
      if (lookahead == 'p') ADVANCE(1032);
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 1550:
      if (lookahead == 'p') ADVANCE(1543);
      END_STATE();
    case 1551:
      if (lookahead == 'p') ADVANCE(1752);
      if (lookahead == 'r') ADVANCE(1478);
      END_STATE();
    case 1552:
      if (lookahead == 'p') ADVANCE(115);
      END_STATE();
    case 1553:
      if (lookahead == 'p') ADVANCE(1218);
      END_STATE();
    case 1554:
      if (lookahead == 'p') ADVANCE(1563);
      END_STATE();
    case 1555:
      if (lookahead == 'p') ADVANCE(775);
      END_STATE();
    case 1556:
      if (lookahead == 'p') ADVANCE(823);
      END_STATE();
    case 1557:
      if (lookahead == 'p') ADVANCE(1297);
      END_STATE();
    case 1558:
      if (lookahead == 'p') ADVANCE(1297);
      if (lookahead == 't') ADVANCE(1634);
      END_STATE();
    case 1559:
      if (lookahead == 'p') ADVANCE(1775);
      END_STATE();
    case 1560:
      if (lookahead == 'p') ADVANCE(1847);
      END_STATE();
    case 1561:
      if (lookahead == 'p') ADVANCE(1573);
      END_STATE();
    case 1562:
      if (lookahead == 'p') ADVANCE(1573);
      if (lookahead == 'r') ADVANCE(1599);
      END_STATE();
    case 1563:
      if (lookahead == 'p') ADVANCE(402);
      END_STATE();
    case 1564:
      if (lookahead == 'p') ADVANCE(1516);
      END_STATE();
    case 1565:
      if (lookahead == 'p') ADVANCE(1299);
      END_STATE();
    case 1566:
      if (lookahead == 'p') ADVANCE(1839);
      END_STATE();
    case 1567:
      if (lookahead == 'p') ADVANCE(1466);
      END_STATE();
    case 1568:
      if (lookahead == 'p') ADVANCE(1263);
      END_STATE();
    case 1569:
      if (lookahead == 'p') ADVANCE(521);
      END_STATE();
    case 1570:
      if (lookahead == 'p') ADVANCE(1793);
      END_STATE();
    case 1571:
      if (lookahead == 'p') ADVANCE(1698);
      if (lookahead == 's') ADVANCE(1926);
      END_STATE();
    case 1572:
      if (lookahead == 'p') ADVANCE(1275);
      END_STATE();
    case 1573:
      if (lookahead == 'p') ADVANCE(1678);
      END_STATE();
    case 1574:
      if (lookahead == 'p') ADVANCE(503);
      END_STATE();
    case 1575:
      if (lookahead == 'p') ADVANCE(552);
      END_STATE();
    case 1576:
      if (lookahead == 'p') ADVANCE(321);
      END_STATE();
    case 1577:
      if (lookahead == 'p') ADVANCE(1520);
      END_STATE();
    case 1578:
      if (lookahead == 'p') ADVANCE(536);
      END_STATE();
    case 1579:
      if (lookahead == 'p') ADVANCE(1519);
      END_STATE();
    case 1580:
      if (lookahead == 'p') ADVANCE(554);
      END_STATE();
    case 1581:
      if (lookahead == 'q') ADVANCE(13);
      END_STATE();
    case 1582:
      if (lookahead == 'q') ADVANCE(98);
      END_STATE();
    case 1583:
      if (lookahead == 'q') ADVANCE(1268);
      END_STATE();
    case 1584:
      if (lookahead == 'q') ADVANCE(1006);
      END_STATE();
    case 1585:
      if (lookahead == 'q') ADVANCE(1571);
      END_STATE();
    case 1586:
      if (lookahead == 'q') ADVANCE(178);
      END_STATE();
    case 1587:
      if (lookahead == 'q') ADVANCE(1581);
      END_STATE();
    case 1588:
      if (lookahead == 'q') ADVANCE(1902);
      END_STATE();
    case 1589:
      if (lookahead == 'q') ADVANCE(1921);
      END_STATE();
    case 1590:
      if (lookahead == 'q') ADVANCE(1954);
      if (lookahead == 'u') ADVANCE(590);
      END_STATE();
    case 1591:
      if (lookahead == 'q') ADVANCE(1942);
      END_STATE();
    case 1592:
      if (lookahead == 'q') ADVANCE(1931);
      END_STATE();
    case 1593:
      if (lookahead == 'q') ADVANCE(696);
      if (lookahead == 't') ADVANCE(396);
      END_STATE();
    case 1594:
      if (lookahead == 'q') ADVANCE(1945);
      END_STATE();
    case 1595:
      if (lookahead == 'q') ADVANCE(1949);
      END_STATE();
    case 1596:
      if (lookahead == 'q') ADVANCE(1952);
      END_STATE();
    case 1597:
      if (lookahead == 'r') ADVANCE(730);
      END_STATE();
    case 1598:
      if (lookahead == 'r') ADVANCE(784);
      END_STATE();
    case 1599:
      if (lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 1600:
      if (lookahead == 'r') ADVANCE(291);
      END_STATE();
    case 1601:
      if (lookahead == 'r') ADVANCE(162);
      END_STATE();
    case 1602:
      if (lookahead == 'r') ADVANCE(945);
      END_STATE();
    case 1603:
      if (lookahead == 'r') ADVANCE(215);
      END_STATE();
    case 1604:
      if (lookahead == 'r') ADVANCE(175);
      END_STATE();
    case 1605:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 1606:
      if (lookahead == 'r') ADVANCE(654);
      END_STATE();
    case 1607:
      if (lookahead == 'r') ADVANCE(276);
      END_STATE();
    case 1608:
      if (lookahead == 'r') ADVANCE(2017);
      END_STATE();
    case 1609:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 1610:
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 1611:
      if (lookahead == 'r') ADVANCE(1045);
      END_STATE();
    case 1612:
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 1613:
      if (lookahead == 'r') ADVANCE(347);
      END_STATE();
    case 1614:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 1615:
      if (lookahead == 'r') ADVANCE(2022);
      END_STATE();
    case 1616:
      if (lookahead == 'r') ADVANCE(18);
      END_STATE();
    case 1617:
      if (lookahead == 'r') ADVANCE(36);
      END_STATE();
    case 1618:
      if (lookahead == 'r') ADVANCE(1599);
      END_STATE();
    case 1619:
      if (lookahead == 'r') ADVANCE(168);
      END_STATE();
    case 1620:
      if (lookahead == 'r') ADVANCE(329);
      END_STATE();
    case 1621:
      if (lookahead == 'r') ADVANCE(604);
      END_STATE();
    case 1622:
      if (lookahead == 'r') ADVANCE(210);
      END_STATE();
    case 1623:
      if (lookahead == 'r') ADVANCE(138);
      END_STATE();
    case 1624:
      if (lookahead == 'r') ADVANCE(1807);
      END_STATE();
    case 1625:
      if (lookahead == 'r') ADVANCE(1807);
      if (lookahead == 'u') ADVANCE(538);
      END_STATE();
    case 1626:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 1627:
      if (lookahead == 'r') ADVANCE(757);
      END_STATE();
    case 1628:
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 1629:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 1630:
      if (lookahead == 'r') ADVANCE(73);
      END_STATE();
    case 1631:
      if (lookahead == 'r') ADVANCE(341);
      END_STATE();
    case 1632:
      if (lookahead == 'r') ADVANCE(603);
      END_STATE();
    case 1633:
      if (lookahead == 'r') ADVANCE(433);
      END_STATE();
    case 1634:
      if (lookahead == 'r') ADVANCE(1072);
      END_STATE();
    case 1635:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 1636:
      if (lookahead == 'r') ADVANCE(154);
      END_STATE();
    case 1637:
      if (lookahead == 'r') ADVANCE(159);
      END_STATE();
    case 1638:
      if (lookahead == 'r') ADVANCE(733);
      END_STATE();
    case 1639:
      if (lookahead == 'r') ADVANCE(725);
      END_STATE();
    case 1640:
      if (lookahead == 'r') ADVANCE(1437);
      END_STATE();
    case 1641:
      if (lookahead == 'r') ADVANCE(164);
      END_STATE();
    case 1642:
      if (lookahead == 'r') ADVANCE(1198);
      END_STATE();
    case 1643:
      if (lookahead == 'r') ADVANCE(193);
      END_STATE();
    case 1644:
      if (lookahead == 'r') ADVANCE(287);
      END_STATE();
    case 1645:
      if (lookahead == 'r') ADVANCE(203);
      END_STATE();
    case 1646:
      if (lookahead == 'r') ADVANCE(715);
      END_STATE();
    case 1647:
      if (lookahead == 'r') ADVANCE(1526);
      END_STATE();
    case 1648:
      if (lookahead == 'r') ADVANCE(852);
      END_STATE();
    case 1649:
      if (lookahead == 'r') ADVANCE(1867);
      END_STATE();
    case 1650:
      if (lookahead == 'r') ADVANCE(167);
      END_STATE();
    case 1651:
      if (lookahead == 'r') ADVANCE(387);
      END_STATE();
    case 1652:
      if (lookahead == 'r') ADVANCE(1478);
      END_STATE();
    case 1653:
      if (lookahead == 'r') ADVANCE(1188);
      END_STATE();
    case 1654:
      if (lookahead == 'r') ADVANCE(1994);
      END_STATE();
    case 1655:
      if (lookahead == 'r') ADVANCE(1996);
      END_STATE();
    case 1656:
      if (lookahead == 'r') ADVANCE(1441);
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 1657:
      if (lookahead == 'r') ADVANCE(1752);
      END_STATE();
    case 1658:
      if (lookahead == 'r') ADVANCE(845);
      END_STATE();
    case 1659:
      if (lookahead == 'r') ADVANCE(1436);
      END_STATE();
    case 1660:
      if (lookahead == 'r') ADVANCE(414);
      END_STATE();
    case 1661:
      if (lookahead == 'r') ADVANCE(1973);
      END_STATE();
    case 1662:
      if (lookahead == 'r') ADVANCE(1995);
      END_STATE();
    case 1663:
      if (lookahead == 'r') ADVANCE(903);
      END_STATE();
    case 1664:
      if (lookahead == 'r') ADVANCE(1044);
      END_STATE();
    case 1665:
      if (lookahead == 'r') ADVANCE(1353);
      END_STATE();
    case 1666:
      if (lookahead == 'r') ADVANCE(611);
      END_STATE();
    case 1667:
      if (lookahead == 'r') ADVANCE(775);
      END_STATE();
    case 1668:
      if (lookahead == 'r') ADVANCE(1457);
      END_STATE();
    case 1669:
      if (lookahead == 'r') ADVANCE(1149);
      END_STATE();
    case 1670:
      if (lookahead == 'r') ADVANCE(1462);
      END_STATE();
    case 1671:
      if (lookahead == 'r') ADVANCE(1815);
      END_STATE();
    case 1672:
      if (lookahead == 'r') ADVANCE(1450);
      END_STATE();
    case 1673:
      if (lookahead == 'r') ADVANCE(1772);
      END_STATE();
    case 1674:
      if (lookahead == 'r') ADVANCE(684);
      END_STATE();
    case 1675:
      if (lookahead == 'r') ADVANCE(1455);
      END_STATE();
    case 1676:
      if (lookahead == 'r') ADVANCE(1608);
      END_STATE();
    case 1677:
      if (lookahead == 'r') ADVANCE(449);
      END_STATE();
    case 1678:
      if (lookahead == 'r') ADVANCE(1452);
      END_STATE();
    case 1679:
      if (lookahead == 'r') ADVANCE(1885);
      END_STATE();
    case 1680:
      if (lookahead == 'r') ADVANCE(1564);
      END_STATE();
    case 1681:
      if (lookahead == 'r') ADVANCE(1878);
      END_STATE();
    case 1682:
      if (lookahead == 'r') ADVANCE(1794);
      END_STATE();
    case 1683:
      if (lookahead == 'r') ADVANCE(1158);
      END_STATE();
    case 1684:
      if (lookahead == 'r') ADVANCE(1802);
      END_STATE();
    case 1685:
      if (lookahead == 'r') ADVANCE(828);
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 1686:
      if (lookahead == 'r') ADVANCE(1831);
      END_STATE();
    case 1687:
      if (lookahead == 'r') ADVANCE(452);
      END_STATE();
    case 1688:
      if (lookahead == 'r') ADVANCE(1120);
      END_STATE();
    case 1689:
      if (lookahead == 'r') ADVANCE(1459);
      END_STATE();
    case 1690:
      if (lookahead == 'r') ADVANCE(1394);
      END_STATE();
    case 1691:
      if (lookahead == 'r') ADVANCE(1780);
      END_STATE();
    case 1692:
      if (lookahead == 'r') ADVANCE(1383);
      END_STATE();
    case 1693:
      if (lookahead == 'r') ADVANCE(1098);
      END_STATE();
    case 1694:
      if (lookahead == 'r') ADVANCE(1422);
      END_STATE();
    case 1695:
      if (lookahead == 'r') ADVANCE(1246);
      END_STATE();
    case 1696:
      if (lookahead == 'r') ADVANCE(1155);
      END_STATE();
    case 1697:
      if (lookahead == 'r') ADVANCE(1250);
      END_STATE();
    case 1698:
      if (lookahead == 'r') ADVANCE(850);
      END_STATE();
    case 1699:
      if (lookahead == 'r') ADVANCE(1460);
      END_STATE();
    case 1700:
      if (lookahead == 'r') ADVANCE(1811);
      END_STATE();
    case 1701:
      if (lookahead == 'r') ADVANCE(792);
      if (lookahead == 't') ADVANCE(413);
      END_STATE();
    case 1702:
      if (lookahead == 'r') ADVANCE(1464);
      END_STATE();
    case 1703:
      if (lookahead == 'r') ADVANCE(1465);
      END_STATE();
    case 1704:
      if (lookahead == 'r') ADVANCE(1469);
      END_STATE();
    case 1705:
      if (lookahead == 'r') ADVANCE(1470);
      END_STATE();
    case 1706:
      if (lookahead == 'r') ADVANCE(1471);
      END_STATE();
    case 1707:
      if (lookahead == 'r') ADVANCE(943);
      END_STATE();
    case 1708:
      if (lookahead == 'r') ADVANCE(795);
      END_STATE();
    case 1709:
      if (lookahead == 'r') ADVANCE(1475);
      END_STATE();
    case 1710:
      if (lookahead == 'r') ADVANCE(1614);
      END_STATE();
    case 1711:
      if (lookahead == 'r') ADVANCE(899);
      END_STATE();
    case 1712:
      if (lookahead == 'r') ADVANCE(1604);
      END_STATE();
    case 1713:
      if (lookahead == 'r') ADVANCE(1637);
      END_STATE();
    case 1714:
      if (lookahead == 'r') ADVANCE(918);
      END_STATE();
    case 1715:
      if (lookahead == 'r') ADVANCE(820);
      END_STATE();
    case 1716:
      if (lookahead == 'r') ADVANCE(542);
      END_STATE();
    case 1717:
      if (lookahead == 'r') ADVANCE(457);
      END_STATE();
    case 1718:
      if (lookahead == 'r') ADVANCE(502);
      END_STATE();
    case 1719:
      if (lookahead == 'r') ADVANCE(1130);
      END_STATE();
    case 1720:
      if (lookahead == 'r') ADVANCE(1795);
      END_STATE();
    case 1721:
      if (lookahead == 'r') ADVANCE(696);
      END_STATE();
    case 1722:
      if (lookahead == 'r') ADVANCE(1875);
      END_STATE();
    case 1723:
      if (lookahead == 'r') ADVANCE(866);
      END_STATE();
    case 1724:
      if (lookahead == 'r') ADVANCE(996);
      if (lookahead == 'u') ADVANCE(13);
      END_STATE();
    case 1725:
      if (lookahead == 'r') ADVANCE(1858);
      END_STATE();
    case 1726:
      if (lookahead == 'r') ADVANCE(1920);
      END_STATE();
    case 1727:
      if (lookahead == 'r') ADVANCE(1797);
      END_STATE();
    case 1728:
      if (lookahead == 'r') ADVANCE(873);
      END_STATE();
    case 1729:
      if (lookahead == 'r') ADVANCE(890);
      END_STATE();
    case 1730:
      if (lookahead == 'r') ADVANCE(1675);
      END_STATE();
    case 1731:
      if (lookahead == 'r') ADVANCE(481);
      END_STATE();
    case 1732:
      if (lookahead == 'r') ADVANCE(1873);
      END_STATE();
    case 1733:
      if (lookahead == 'r') ADVANCE(1689);
      END_STATE();
    case 1734:
      if (lookahead == 'r') ADVANCE(1699);
      END_STATE();
    case 1735:
      if (lookahead == 'r') ADVANCE(1703);
      END_STATE();
    case 1736:
      if (lookahead == 'r') ADVANCE(1704);
      END_STATE();
    case 1737:
      if (lookahead == 'r') ADVANCE(1705);
      END_STATE();
    case 1738:
      if (lookahead == 'r') ADVANCE(1709);
      END_STATE();
    case 1739:
      if (lookahead == 'r') ADVANCE(908);
      END_STATE();
    case 1740:
      if (lookahead == 'r') ADVANCE(720);
      END_STATE();
    case 1741:
      if (lookahead == 'r') ADVANCE(931);
      END_STATE();
    case 1742:
      if (lookahead == 'r') ADVANCE(324);
      END_STATE();
    case 1743:
      if (lookahead == 'r') ADVANCE(1577);
      END_STATE();
    case 1744:
      if (lookahead == 'r') ADVANCE(1896);
      END_STATE();
    case 1745:
      if (lookahead == 'r') ADVANCE(1579);
      END_STATE();
    case 1746:
      if (lookahead == 'r') ADVANCE(940);
      END_STATE();
    case 1747:
      if (lookahead == 'r') ADVANCE(941);
      END_STATE();
    case 1748:
      if (lookahead == 'r') ADVANCE(942);
      END_STATE();
    case 1749:
      if (lookahead == 'r') ADVANCE(1182);
      END_STATE();
    case 1750:
      if (lookahead == 'r') ADVANCE(1184);
      END_STATE();
    case 1751:
      if (lookahead == 'r') ADVANCE(1185);
      END_STATE();
    case 1752:
      if (lookahead == 's') ADVANCE(13);
      END_STATE();
    case 1753:
      if (lookahead == 's') ADVANCE(900);
      END_STATE();
    case 1754:
      if (lookahead == 's') ADVANCE(175);
      if (lookahead == 'u') ADVANCE(1338);
      END_STATE();
    case 1755:
      if (lookahead == 's') ADVANCE(323);
      END_STATE();
    case 1756:
      if (lookahead == 's') ADVANCE(349);
      END_STATE();
    case 1757:
      if (lookahead == 's') ADVANCE(61);
      END_STATE();
    case 1758:
      if (lookahead == 's') ADVANCE(209);
      END_STATE();
    case 1759:
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 1760:
      if (lookahead == 's') ADVANCE(38);
      END_STATE();
    case 1761:
      if (lookahead == 's') ADVANCE(40);
      END_STATE();
    case 1762:
      if (lookahead == 's') ADVANCE(39);
      END_STATE();
    case 1763:
      if (lookahead == 's') ADVANCE(1807);
      END_STATE();
    case 1764:
      if (lookahead == 's') ADVANCE(343);
      END_STATE();
    case 1765:
      if (lookahead == 's') ADVANCE(1472);
      END_STATE();
    case 1766:
      if (lookahead == 's') ADVANCE(140);
      END_STATE();
    case 1767:
      if (lookahead == 's') ADVANCE(1072);
      END_STATE();
    case 1768:
      if (lookahead == 's') ADVANCE(357);
      END_STATE();
    case 1769:
      if (lookahead == 's') ADVANCE(198);
      END_STATE();
    case 1770:
      if (lookahead == 's') ADVANCE(106);
      END_STATE();
    case 1771:
      if (lookahead == 's') ADVANCE(64);
      END_STATE();
    case 1772:
      if (lookahead == 's') ADVANCE(1526);
      END_STATE();
    case 1773:
      if (lookahead == 's') ADVANCE(1032);
      END_STATE();
    case 1774:
      if (lookahead == 's') ADVANCE(1997);
      END_STATE();
    case 1775:
      if (lookahead == 's') ADVANCE(192);
      END_STATE();
    case 1776:
      if (lookahead == 's') ADVANCE(1033);
      END_STATE();
    case 1777:
      if (lookahead == 's') ADVANCE(1037);
      END_STATE();
    case 1778:
      if (lookahead == 's') ADVANCE(1752);
      END_STATE();
    case 1779:
      if (lookahead == 's') ADVANCE(1108);
      END_STATE();
    case 1780:
      if (lookahead == 's') ADVANCE(1207);
      END_STATE();
    case 1781:
      if (lookahead == 's') ADVANCE(1901);
      END_STATE();
    case 1782:
      if (lookahead == 's') ADVANCE(743);
      END_STATE();
    case 1783:
      if (lookahead == 's') ADVANCE(775);
      END_STATE();
    case 1784:
      if (lookahead == 's') ADVANCE(823);
      END_STATE();
    case 1785:
      if (lookahead == 's') ADVANCE(1950);
      END_STATE();
    case 1786:
      if (lookahead == 's') ADVANCE(1906);
      END_STATE();
    case 1787:
      if (lookahead == 's') ADVANCE(1852);
      END_STATE();
    case 1788:
      if (lookahead == 's') ADVANCE(1233);
      END_STATE();
    case 1789:
      if (lookahead == 's') ADVANCE(1764);
      END_STATE();
    case 1790:
      if (lookahead == 's') ADVANCE(1842);
      END_STATE();
    case 1791:
      if (lookahead == 's') ADVANCE(1845);
      END_STATE();
    case 1792:
      if (lookahead == 's') ADVANCE(1170);
      END_STATE();
    case 1793:
      if (lookahead == 's') ADVANCE(1839);
      END_STATE();
    case 1794:
      if (lookahead == 's') ADVANCE(860);
      END_STATE();
    case 1795:
      if (lookahead == 's') ADVANCE(799);
      END_STATE();
    case 1796:
      if (lookahead == 's') ADVANCE(830);
      END_STATE();
    case 1797:
      if (lookahead == 's') ADVANCE(819);
      END_STATE();
    case 1798:
      if (lookahead == 's') ADVANCE(1042);
      END_STATE();
    case 1799:
      if (lookahead == 's') ADVANCE(1908);
      END_STATE();
    case 1800:
      if (lookahead == 's') ADVANCE(1863);
      END_STATE();
    case 1801:
      if (lookahead == 's') ADVANCE(1851);
      END_STATE();
    case 1802:
      if (lookahead == 's') ADVANCE(865);
      END_STATE();
    case 1803:
      if (lookahead == 's') ADVANCE(1117);
      END_STATE();
    case 1804:
      if (lookahead == 's') ADVANCE(880);
      END_STATE();
    case 1805:
      if (lookahead == 's') ADVANCE(936);
      END_STATE();
    case 1806:
      if (lookahead == 't') ADVANCE(1987);
      END_STATE();
    case 1807:
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 1808:
      if (lookahead == 't') ADVANCE(13);
      if (lookahead == 'u') ADVANCE(600);
      END_STATE();
    case 1809:
      if (lookahead == 't') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(1369);
      END_STATE();
    case 1810:
      if (lookahead == 't') ADVANCE(250);
      END_STATE();
    case 1811:
      if (lookahead == 't') ADVANCE(365);
      END_STATE();
    case 1812:
      if (lookahead == 't') ADVANCE(550);
      END_STATE();
    case 1813:
      if (lookahead == 't') ADVANCE(220);
      END_STATE();
    case 1814:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 1815:
      if (lookahead == 't') ADVANCE(306);
      END_STATE();
    case 1816:
      if (lookahead == 't') ADVANCE(549);
      END_STATE();
    case 1817:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 1818:
      if (lookahead == 't') ADVANCE(1005);
      END_STATE();
    case 1819:
      if (lookahead == 't') ADVANCE(361);
      END_STATE();
    case 1820:
      if (lookahead == 't') ADVANCE(371);
      END_STATE();
    case 1821:
      if (lookahead == 't') ADVANCE(271);
      END_STATE();
    case 1822:
      if (lookahead == 't') ADVANCE(274);
      END_STATE();
    case 1823:
      if (lookahead == 't') ADVANCE(375);
      END_STATE();
    case 1824:
      if (lookahead == 't') ADVANCE(557);
      END_STATE();
    case 1825:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 1826:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 1827:
      if (lookahead == 't') ADVANCE(1599);
      END_STATE();
    case 1828:
      if (lookahead == 't') ADVANCE(382);
      END_STATE();
    case 1829:
      if (lookahead == 't') ADVANCE(857);
      END_STATE();
    case 1830:
      if (lookahead == 't') ADVANCE(35);
      END_STATE();
    case 1831:
      if (lookahead == 't') ADVANCE(1327);
      END_STATE();
    case 1832:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 1833:
      if (lookahead == 't') ADVANCE(603);
      END_STATE();
    case 1834:
      if (lookahead == 't') ADVANCE(1988);
      END_STATE();
    case 1835:
      if (lookahead == 't') ADVANCE(112);
      if (lookahead == 'v') ADVANCE(1144);
      END_STATE();
    case 1836:
      if (lookahead == 't') ADVANCE(212);
      END_STATE();
    case 1837:
      if (lookahead == 't') ADVANCE(269);
      END_STATE();
    case 1838:
      if (lookahead == 't') ADVANCE(546);
      END_STATE();
    case 1839:
      if (lookahead == 't') ADVANCE(1437);
      END_STATE();
    case 1840:
      if (lookahead == 't') ADVANCE(884);
      END_STATE();
    case 1841:
      if (lookahead == 't') ADVANCE(372);
      END_STATE();
    case 1842:
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 1843:
      if (lookahead == 't') ADVANCE(1992);
      END_STATE();
    case 1844:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 1845:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 1846:
      if (lookahead == 't') ADVANCE(1032);
      END_STATE();
    case 1847:
      if (lookahead == 't') ADVANCE(1993);
      END_STATE();
    case 1848:
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 1849:
      if (lookahead == 't') ADVANCE(1037);
      END_STATE();
    case 1850:
      if (lookahead == 't') ADVANCE(165);
      END_STATE();
    case 1851:
      if (lookahead == 't') ADVANCE(1752);
      END_STATE();
    case 1852:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 1853:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 1854:
      if (lookahead == 't') ADVANCE(1034);
      END_STATE();
    case 1855:
      if (lookahead == 't') ADVANCE(1335);
      END_STATE();
    case 1856:
      if (lookahead == 't') ADVANCE(775);
      END_STATE();
    case 1857:
      if (lookahead == 't') ADVANCE(1507);
      END_STATE();
    case 1858:
      if (lookahead == 't') ADVANCE(1758);
      END_STATE();
    case 1859:
      if (lookahead == 't') ADVANCE(1062);
      END_STATE();
    case 1860:
      if (lookahead == 't') ADVANCE(1350);
      END_STATE();
    case 1861:
      if (lookahead == 't') ADVANCE(807);
      END_STATE();
    case 1862:
      if (lookahead == 't') ADVANCE(1784);
      END_STATE();
    case 1863:
      if (lookahead == 't') ADVANCE(848);
      END_STATE();
    case 1864:
      if (lookahead == 't') ADVANCE(1446);
      END_STATE();
    case 1865:
      if (lookahead == 't') ADVANCE(1634);
      END_STATE();
    case 1866:
      if (lookahead == 't') ADVANCE(483);
      END_STATE();
    case 1867:
      if (lookahead == 't') ADVANCE(1143);
      END_STATE();
    case 1868:
      if (lookahead == 't') ADVANCE(1120);
      END_STATE();
    case 1869:
      if (lookahead == 't') ADVANCE(1154);
      END_STATE();
    case 1870:
      if (lookahead == 't') ADVANCE(1443);
      END_STATE();
    case 1871:
      if (lookahead == 't') ADVANCE(1145);
      END_STATE();
    case 1872:
      if (lookahead == 't') ADVANCE(1168);
      END_STATE();
    case 1873:
      if (lookahead == 't') ADVANCE(1162);
      END_STATE();
    case 1874:
      if (lookahead == 't') ADVANCE(1122);
      END_STATE();
    case 1875:
      if (lookahead == 't') ADVANCE(1602);
      END_STATE();
    case 1876:
      if (lookahead == 't') ADVANCE(934);
      END_STATE();
    case 1877:
      if (lookahead == 't') ADVANCE(555);
      END_STATE();
    case 1878:
      if (lookahead == 't') ADVANCE(1402);
      END_STATE();
    case 1879:
      if (lookahead == 't') ADVANCE(1107);
      END_STATE();
    case 1880:
      if (lookahead == 't') ADVANCE(1500);
      END_STATE();
    case 1881:
      if (lookahead == 't') ADVANCE(1403);
      END_STATE();
    case 1882:
      if (lookahead == 't') ADVANCE(1687);
      END_STATE();
    case 1883:
      if (lookahead == 't') ADVANCE(883);
      END_STATE();
    case 1884:
      if (lookahead == 't') ADVANCE(491);
      END_STATE();
    case 1885:
      if (lookahead == 't') ADVANCE(1084);
      END_STATE();
    case 1886:
      if (lookahead == 't') ADVANCE(885);
      END_STATE();
    case 1887:
      if (lookahead == 't') ADVANCE(887);
      END_STATE();
    case 1888:
      if (lookahead == 't') ADVANCE(889);
      END_STATE();
    case 1889:
      if (lookahead == 't') ADVANCE(892);
      END_STATE();
    case 1890:
      if (lookahead == 't') ADVANCE(910);
      END_STATE();
    case 1891:
      if (lookahead == 't') ADVANCE(894);
      END_STATE();
    case 1892:
      if (lookahead == 't') ADVANCE(1063);
      END_STATE();
    case 1893:
      if (lookahead == 't') ADVANCE(534);
      END_STATE();
    case 1894:
      if (lookahead == 't') ADVANCE(1153);
      END_STATE();
    case 1895:
      if (lookahead == 't') ADVANCE(1159);
      END_STATE();
    case 1896:
      if (lookahead == 't') ADVANCE(1169);
      END_STATE();
    case 1897:
      if (lookahead == 't') ADVANCE(554);
      END_STATE();
    case 1898:
      if (lookahead == 't') ADVANCE(543);
      END_STATE();
    case 1899:
      if (lookahead == 'u') ADVANCE(13);
      END_STATE();
    case 1900:
      if (lookahead == 'u') ADVANCE(471);
      END_STATE();
    case 1901:
      if (lookahead == 'u') ADVANCE(2011);
      END_STATE();
    case 1902:
      if (lookahead == 'u') ADVANCE(1437);
      END_STATE();
    case 1903:
      if (lookahead == 'u') ADVANCE(164);
      END_STATE();
    case 1904:
      if (lookahead == 'u') ADVANCE(573);
      END_STATE();
    case 1905:
      if (lookahead == 'u') ADVANCE(586);
      END_STATE();
    case 1906:
      if (lookahead == 'u') ADVANCE(584);
      END_STATE();
    case 1907:
      if (lookahead == 'u') ADVANCE(1526);
      END_STATE();
    case 1908:
      if (lookahead == 'u') ADVANCE(567);
      END_STATE();
    case 1909:
      if (lookahead == 'u') ADVANCE(1756);
      END_STATE();
    case 1910:
      if (lookahead == 'u') ADVANCE(591);
      END_STATE();
    case 1911:
      if (lookahead == 'u') ADVANCE(1844);
      END_STATE();
    case 1912:
      if (lookahead == 'u') ADVANCE(1844);
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 1913:
      if (lookahead == 'u') ADVANCE(1312);
      END_STATE();
    case 1914:
      if (lookahead == 'u') ADVANCE(1752);
      END_STATE();
    case 1915:
      if (lookahead == 'u') ADVANCE(858);
      END_STATE();
    case 1916:
      if (lookahead == 'u') ADVANCE(1768);
      END_STATE();
    case 1917:
      if (lookahead == 'u') ADVANCE(775);
      END_STATE();
    case 1918:
      if (lookahead == 'u') ADVANCE(1315);
      END_STATE();
    case 1919:
      if (lookahead == 'u') ADVANCE(656);
      END_STATE();
    case 1920:
      if (lookahead == 'u') ADVANCE(809);
      END_STATE();
    case 1921:
      if (lookahead == 'u') ADVANCE(449);
      END_STATE();
    case 1922:
      if (lookahead == 'u') ADVANCE(1759);
      END_STATE();
    case 1923:
      if (lookahead == 'u') ADVANCE(1438);
      END_STATE();
    case 1924:
      if (lookahead == 'u') ADVANCE(1223);
      END_STATE();
    case 1925:
      if (lookahead == 'u') ADVANCE(1783);
      END_STATE();
    case 1926:
      if (lookahead == 'u') ADVANCE(690);
      END_STATE();
    case 1927:
      if (lookahead == 'u') ADVANCE(1770);
      END_STATE();
    case 1928:
      if (lookahead == 'u') ADVANCE(1091);
      END_STATE();
    case 1929:
      if (lookahead == 'u') ADVANCE(843);
      END_STATE();
    case 1930:
      if (lookahead == 'u') ADVANCE(470);
      END_STATE();
    case 1931:
      if (lookahead == 'u') ADVANCE(1156);
      END_STATE();
    case 1932:
      if (lookahead == 'u') ADVANCE(1090);
      END_STATE();
    case 1933:
      if (lookahead == 'u') ADVANCE(1630);
      END_STATE();
    case 1934:
      if (lookahead == 'u') ADVANCE(1602);
      END_STATE();
    case 1935:
      if (lookahead == 'u') ADVANCE(1631);
      END_STATE();
    case 1936:
      if (lookahead == 'u') ADVANCE(1695);
      END_STATE();
    case 1937:
      if (lookahead == 'u') ADVANCE(1697);
      END_STATE();
    case 1938:
      if (lookahead == 'u') ADVANCE(1042);
      END_STATE();
    case 1939:
      if (lookahead == 'u') ADVANCE(1325);
      END_STATE();
    case 1940:
      if (lookahead == 'u') ADVANCE(1396);
      END_STATE();
    case 1941:
      if (lookahead == 'u') ADVANCE(1790);
      END_STATE();
    case 1942:
      if (lookahead == 'u') ADVANCE(1125);
      END_STATE();
    case 1943:
      if (lookahead == 'u') ADVANCE(1249);
      END_STATE();
    case 1944:
      if (lookahead == 'u') ADVANCE(1856);
      END_STATE();
    case 1945:
      if (lookahead == 'u') ADVANCE(490);
      END_STATE();
    case 1946:
      if (lookahead == 'u') ADVANCE(1265);
      END_STATE();
    case 1947:
      if (lookahead == 'u') ADVANCE(1511);
      END_STATE();
    case 1948:
      if (lookahead == 'u') ADVANCE(1323);
      END_STATE();
    case 1949:
      if (lookahead == 'u') ADVANCE(496);
      END_STATE();
    case 1950:
      if (lookahead == 'u') ADVANCE(1711);
      END_STATE();
    case 1951:
      if (lookahead == 'u') ADVANCE(1304);
      END_STATE();
    case 1952:
      if (lookahead == 'u') ADVANCE(539);
      END_STATE();
    case 1953:
      if (lookahead == 'u') ADVANCE(597);
      END_STATE();
    case 1954:
      if (lookahead == 'u') ADVANCE(541);
      END_STATE();
    case 1955:
      if (lookahead == 'u') ADVANCE(596);
      if (lookahead == 'w') ADVANCE(1363);
      END_STATE();
    case 1956:
      if (lookahead == 'u') ADVANCE(599);
      END_STATE();
    case 1957:
      if (lookahead == 'v') ADVANCE(13);
      END_STATE();
    case 1958:
      if (lookahead == 'v') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(774);
      END_STATE();
    case 1959:
      if (lookahead == 'v') ADVANCE(27);
      END_STATE();
    case 1960:
      if (lookahead == 'v') ADVANCE(106);
      END_STATE();
    case 1961:
      if (lookahead == 'v') ADVANCE(852);
      if (lookahead == 'w') ADVANCE(851);
      END_STATE();
    case 1962:
      if (lookahead == 'v') ADVANCE(775);
      END_STATE();
    case 1963:
      if (lookahead == 'v') ADVANCE(800);
      END_STATE();
    case 1964:
      if (lookahead == 'v') ADVANCE(938);
      END_STATE();
    case 1965:
      if (lookahead == 'w') ADVANCE(13);
      END_STATE();
    case 1966:
      if (lookahead == 'w') ADVANCE(19);
      END_STATE();
    case 1967:
      if (lookahead == 'w') ADVANCE(23);
      END_STATE();
    case 1968:
      if (lookahead == 'w') ADVANCE(22);
      END_STATE();
    case 1969:
      if (lookahead == 'w') ADVANCE(21);
      END_STATE();
    case 1970:
      if (lookahead == 'w') ADVANCE(1437);
      END_STATE();
    case 1971:
      if (lookahead == 'w') ADVANCE(396);
      END_STATE();
    case 1972:
      if (lookahead == 'w') ADVANCE(187);
      END_STATE();
    case 1973:
      if (lookahead == 'w') ADVANCE(815);
      END_STATE();
    case 1974:
      if (lookahead == 'w') ADVANCE(1752);
      END_STATE();
    case 1975:
      if (lookahead == 'w') ADVANCE(1353);
      END_STATE();
    case 1976:
      if (lookahead == 'w') ADVANCE(1369);
      END_STATE();
    case 1977:
      if (lookahead == 'w') ADVANCE(1367);
      END_STATE();
    case 1978:
      if (lookahead == 'w') ADVANCE(1364);
      END_STATE();
    case 1979:
      if (lookahead == 'w') ADVANCE(1151);
      END_STATE();
    case 1980:
      if (lookahead == 'w') ADVANCE(205);
      END_STATE();
    case 1981:
      if (lookahead == 'w') ADVANCE(1277);
      END_STATE();
    case 1982:
      if (lookahead == 'w') ADVANCE(1435);
      END_STATE();
    case 1983:
      if (lookahead == 'w') ADVANCE(1434);
      END_STATE();
    case 1984:
      if (lookahead == 'x') ADVANCE(13);
      END_STATE();
    case 1985:
      if (lookahead == 'x') ADVANCE(1807);
      END_STATE();
    case 1986:
      if (lookahead == 'x') ADVANCE(115);
      END_STATE();
    case 1987:
      if (lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 1988:
      if (lookahead == 'y') ADVANCE(364);
      END_STATE();
    case 1989:
      if (lookahead == 'y') ADVANCE(834);
      END_STATE();
    case 1990:
      if (lookahead == 'y') ADVANCE(311);
      END_STATE();
    case 1991:
      if (lookahead == 'y') ADVANCE(326);
      END_STATE();
    case 1992:
      if (lookahead == 'y') ADVANCE(195);
      END_STATE();
    case 1993:
      if (lookahead == 'y') ADVANCE(1957);
      END_STATE();
    case 1994:
      if (lookahead == 'y') ADVANCE(363);
      END_STATE();
    case 1995:
      if (lookahead == 'y') ADVANCE(369);
      END_STATE();
    case 1996:
      if (lookahead == 'y') ADVANCE(339);
      END_STATE();
    case 1997:
      if (lookahead == 'y') ADVANCE(1312);
      END_STATE();
    case 1998:
      if (lookahead == 'y') ADVANCE(774);
      END_STATE();
    case 1999:
      if (lookahead == 'y') ADVANCE(1752);
      END_STATE();
    case 2000:
      if (lookahead == 'y') ADVANCE(823);
      END_STATE();
    case 2001:
      if (lookahead == 'z') ADVANCE(1514);
      END_STATE();
    case 2002:
      if (lookahead == 'z') ADVANCE(427);
      END_STATE();
    case 2003:
      if (lookahead == 'z') ADVANCE(1130);
      END_STATE();
    case 2004:
      if (lookahead == 'z') ADVANCE(861);
      END_STATE();
    case 2005:
      if (lookahead == '2' ||
          lookahead == '4') ADVANCE(13);
      END_STATE();
    case 2006:
      if (lookahead == '3' ||
          lookahead == '5') ADVANCE(13);
      END_STATE();
    case 2007:
      if (lookahead == '6' ||
          lookahead == '8') ADVANCE(13);
      END_STATE();
    case 2008:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(13);
      END_STATE();
    case 2009:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(2029);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 2010:
      if (lookahead == 'a' ||
          lookahead == 'h') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(903);
      END_STATE();
    case 2011:
      if (lookahead == 'b' ||
          lookahead == 'p') ADVANCE(13);
      END_STATE();
    case 2012:
      if (lookahead == 'b' ||
          lookahead == 'u') ADVANCE(13);
      END_STATE();
    case 2013:
      if (lookahead == 'd' ||
          lookahead == 'u') ADVANCE(13);
      END_STATE();
    case 2014:
      if (lookahead == 'e' ||
          lookahead == 'k') ADVANCE(13);
      END_STATE();
    case 2015:
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(13);
      END_STATE();
    case 2016:
      if (lookahead == 'f' ||
          lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 2017:
      if (lookahead == 'l' ||
          lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 2018:
      if (lookahead == 'o' ||
          lookahead == 'u') ADVANCE(13);
      END_STATE();
    case 2019:
      if (lookahead == 'r' ||
          lookahead == 'y') ADVANCE(13);
      END_STATE();
    case 2020:
      if (lookahead == '3' ||
          lookahead == '4') ADVANCE(13);
      END_STATE();
    case 2021:
      if (lookahead == 'R' ||
          lookahead == 'S') ADVANCE(13);
      if (lookahead == 'a') ADVANCE(1763);
      if (lookahead == 'c') ADVANCE(1138);
      if (lookahead == 'd') ADVANCE(429);
      END_STATE();
    case 2022:
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(13);
      END_STATE();
    case 2023:
      if (lookahead == '4' ||
          lookahead == '5' ||
          lookahead == '8') ADVANCE(13);
      if (lookahead == ';') ADVANCE(2033);
      END_STATE();
    case 2024:
      if (('a' <= lookahead && lookahead <= 'c')) ADVANCE(13);
      END_STATE();
    case 2025:
      if (lookahead == 'L' ||
          lookahead == 'R' ||
          lookahead == 'l' ||
          lookahead == 'r') ADVANCE(13);
      END_STATE();
    case 2026:
      if (('1' <= lookahead && lookahead <= '3') ||
          lookahead == 'E') ADVANCE(13);
      if (lookahead == ';') ADVANCE(2033);
      if (lookahead == 'd') ADVANCE(1448);
      if (lookahead == 'e') ADVANCE(98);
      if (lookahead == 'h') ADVANCE(1765);
      if (lookahead == 'l') ADVANCE(433);
      if (lookahead == 'm') ADVANCE(1924);
      if (lookahead == 'n') ADVANCE(2008);
      if (lookahead == 'p') ADVANCE(1297);
      if (lookahead == 's') ADVANCE(875);
      END_STATE();
    case 2027:
      if (('2' <= lookahead && lookahead <= '6') ||
          lookahead == '8') ADVANCE(13);
      if (lookahead == ';') ADVANCE(2033);
      END_STATE();
    case 2028:
      if (('a' <= lookahead && lookahead <= 'h')) ADVANCE(13);
      END_STATE();
    case 2029:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(243);
      END_STATE();
    case 2030:
      if (eof) ADVANCE(2031);
      if (lookahead == '!') ADVANCE(2040);
      if (lookahead == '"') ADVANCE(2041);
      if (lookahead == '#') ADVANCE(2042);
      if (lookahead == '$') ADVANCE(2043);
      if (lookahead == '%') ADVANCE(2044);
      if (lookahead == '&') ADVANCE(2045);
      if (lookahead == '\'') ADVANCE(2047);
      if (lookahead == '(') ADVANCE(2070);
      if (lookahead == ')') ADVANCE(2071);
      if (lookahead == '*') ADVANCE(2048);
      if (lookahead == '+') ADVANCE(2049);
      if (lookahead == ',') ADVANCE(2050);
      if (lookahead == '-') ADVANCE(2051);
      if (lookahead == '.') ADVANCE(2053);
      if (lookahead == '/') ADVANCE(2054);
      if (lookahead == ':') ADVANCE(2055);
      if (lookahead == ';') ADVANCE(2056);
      if (lookahead == '<') ADVANCE(2038);
      if (lookahead == '=') ADVANCE(2057);
      if (lookahead == '>') ADVANCE(2039);
      if (lookahead == '?') ADVANCE(2058);
      if (lookahead == '@') ADVANCE(2060);
      if (lookahead == '[') ADVANCE(2035);
      if (lookahead == '\\') ADVANCE(2061);
      if (lookahead == ']') ADVANCE(2036);
      if (lookahead == '^') ADVANCE(2063);
      if (lookahead == '_') ADVANCE(2064);
      if (lookahead == '`') ADVANCE(2065);
      if (lookahead == '{') ADVANCE(2066);
      if (lookahead == '|') ADVANCE(2067);
      if (lookahead == '}') ADVANCE(2068);
      if (lookahead == '~') ADVANCE(2069);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2080);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(2077);
      END_STATE();
    case 2031:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 2032:
      ACCEPT_TOKEN(sym__backslash_escape);
      END_STATE();
    case 2033:
      ACCEPT_TOKEN(sym_entity_reference);
      END_STATE();
    case 2034:
      ACCEPT_TOKEN(sym_numeric_character_reference);
      END_STATE();
    case 2035:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == 'x') ADVANCE(377);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(378);
      END_STATE();
    case 2036:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 2037:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      if (lookahead == ']') ADVANCE(245);
      END_STATE();
    case 2038:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 2039:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 2040:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 2041:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 2042:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 2043:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 2044:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 2045:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 2046:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '#') ADVANCE(2009);
      if (lookahead == 'A') ADVANCE(312);
      if (lookahead == 'B') ADVANCE(381);
      if (lookahead == 'C') ADVANCE(335);
      if (lookahead == 'D') ADVANCE(296);
      if (lookahead == 'E') ADVANCE(351);
      if (lookahead == 'F') ADVANCE(606);
      if (lookahead == 'G') ADVANCE(45);
      if (lookahead == 'H') ADVANCE(246);
      if (lookahead == 'I') ADVANCE(318);
      if (lookahead == 'J') ADVANCE(708);
      if (lookahead == 'K') ADVANCE(334);
      if (lookahead == 'L') ADVANCE(44);
      if (lookahead == 'M') ADVANCE(423);
      if (lookahead == 'N') ADVANCE(342);
      if (lookahead == 'O') ADVANCE(320);
      if (lookahead == 'P') ADVANCE(419);
      if (lookahead == 'Q') ADVANCE(373);
      if (lookahead == 'R') ADVANCE(277);
      if (lookahead == 'S') ADVANCE(331);
      if (lookahead == 'T') ADVANCE(332);
      if (lookahead == 'U') ADVANCE(400);
      if (lookahead == 'V') ADVANCE(304);
      if (lookahead == 'W') ADVANCE(660);
      if (lookahead == 'X') ADVANCE(948);
      if (lookahead == 'Y') ADVANCE(248);
      if (lookahead == 'Z') ADVANCE(336);
      if (lookahead == 'a') ADVANCE(379);
      if (lookahead == 'b') ADVANCE(350);
      if (lookahead == 'c') ADVANCE(386);
      if (lookahead == 'd') ADVANCE(253);
      if (lookahead == 'e') ADVANCE(298);
      if (lookahead == 'f') ADVANCE(428);
      if (lookahead == 'g') ADVANCE(34);
      if (lookahead == 'h') ADVANCE(255);
      if (lookahead == 'i') ADVANCE(380);
      if (lookahead == 'j') ADVANCE(707);
      if (lookahead == 'k') ADVANCE(512);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'm') ADVANCE(299);
      if (lookahead == 'n') ADVANCE(328);
      if (lookahead == 'o') ADVANCE(362);
      if (lookahead == 'p') ADVANCE(450);
      if (lookahead == 'q') ADVANCE(949);
      if (lookahead == 'r') ADVANCE(247);
      if (lookahead == 's') ADVANCE(507);
      if (lookahead == 't') ADVANCE(403);
      if (lookahead == 'u') ADVANCE(254);
      if (lookahead == 'v') ADVANCE(251);
      if (lookahead == 'w') ADVANCE(659);
      if (lookahead == 'x') ADVANCE(615);
      if (lookahead == 'y') ADVANCE(418);
      if (lookahead == 'z') ADVANCE(508);
      END_STATE();
    case 2047:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 2048:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 2049:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 2050:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 2051:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 2052:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(244);
      END_STATE();
    case 2053:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 2054:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 2055:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 2056:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 2057:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 2058:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 2059:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '>') ADVANCE(2075);
      END_STATE();
    case 2060:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 2061:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 2062:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (('!' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          ('[' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(2032);
      END_STATE();
    case 2063:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 2064:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 2065:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 2066:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 2067:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 2068:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 2069:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 2070:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 2071:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 2072:
      ACCEPT_TOKEN(sym__newline_token);
      END_STATE();
    case 2073:
      ACCEPT_TOKEN(sym__newline_token);
      if (lookahead == '\n') ADVANCE(2072);
      END_STATE();
    case 2074:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_GT);
      END_STATE();
    case 2075:
      ACCEPT_TOKEN(anon_sym_QMARK_GT);
      END_STATE();
    case 2076:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK_GT);
      END_STATE();
    case 2077:
      ACCEPT_TOKEN(aux_sym__word_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '/' < lookahead) &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(2077);
      END_STATE();
    case 2078:
      ACCEPT_TOKEN(anon_sym_LBRACKx_RBRACK);
      END_STATE();
    case 2079:
      ACCEPT_TOKEN(aux_sym__word_token2);
      END_STATE();
    case 2080:
      ACCEPT_TOKEN(sym__whitespace);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2080);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 2030, .external_lex_state = 2},
  [2] = {.lex_state = 2030, .external_lex_state = 3},
  [3] = {.lex_state = 2030, .external_lex_state = 3},
  [4] = {.lex_state = 2030, .external_lex_state = 3},
  [5] = {.lex_state = 2030, .external_lex_state = 3},
  [6] = {.lex_state = 2030, .external_lex_state = 3},
  [7] = {.lex_state = 2030, .external_lex_state = 3},
  [8] = {.lex_state = 2030, .external_lex_state = 3},
  [9] = {.lex_state = 2030, .external_lex_state = 3},
  [10] = {.lex_state = 2030, .external_lex_state = 3},
  [11] = {.lex_state = 2030, .external_lex_state = 3},
  [12] = {.lex_state = 2030, .external_lex_state = 4},
  [13] = {.lex_state = 2030, .external_lex_state = 4},
  [14] = {.lex_state = 2030, .external_lex_state = 4},
  [15] = {.lex_state = 2030, .external_lex_state = 4},
  [16] = {.lex_state = 2030, .external_lex_state = 4},
  [17] = {.lex_state = 2030, .external_lex_state = 4},
  [18] = {.lex_state = 2030, .external_lex_state = 4},
  [19] = {.lex_state = 2030, .external_lex_state = 4},
  [20] = {.lex_state = 2030, .external_lex_state = 4},
  [21] = {.lex_state = 2030, .external_lex_state = 4},
  [22] = {.lex_state = 2030, .external_lex_state = 5},
  [23] = {.lex_state = 2030, .external_lex_state = 5},
  [24] = {.lex_state = 2030, .external_lex_state = 4},
  [25] = {.lex_state = 2030, .external_lex_state = 6},
  [26] = {.lex_state = 2030, .external_lex_state = 6},
  [27] = {.lex_state = 2030, .external_lex_state = 6},
  [28] = {.lex_state = 2030, .external_lex_state = 4},
  [29] = {.lex_state = 2030, .external_lex_state = 6},
  [30] = {.lex_state = 2030, .external_lex_state = 4},
  [31] = {.lex_state = 2030, .external_lex_state = 6},
  [32] = {.lex_state = 2030, .external_lex_state = 6},
  [33] = {.lex_state = 2030, .external_lex_state = 6},
  [34] = {.lex_state = 2030, .external_lex_state = 6},
  [35] = {.lex_state = 2030, .external_lex_state = 6},
  [36] = {.lex_state = 2030, .external_lex_state = 6},
  [37] = {.lex_state = 2030, .external_lex_state = 4},
  [38] = {.lex_state = 2030, .external_lex_state = 6},
  [39] = {.lex_state = 2030, .external_lex_state = 6},
  [40] = {.lex_state = 2030, .external_lex_state = 4},
  [41] = {.lex_state = 2030, .external_lex_state = 4},
  [42] = {.lex_state = 2030, .external_lex_state = 6},
  [43] = {.lex_state = 2030, .external_lex_state = 6},
  [44] = {.lex_state = 2030, .external_lex_state = 6},
  [45] = {.lex_state = 2030, .external_lex_state = 4},
  [46] = {.lex_state = 2030, .external_lex_state = 4},
  [47] = {.lex_state = 2030, .external_lex_state = 6},
  [48] = {.lex_state = 2030, .external_lex_state = 4},
  [49] = {.lex_state = 2030, .external_lex_state = 4},
  [50] = {.lex_state = 2030, .external_lex_state = 6},
  [51] = {.lex_state = 2030, .external_lex_state = 4},
  [52] = {.lex_state = 2030, .external_lex_state = 6},
  [53] = {.lex_state = 2030, .external_lex_state = 6},
  [54] = {.lex_state = 2030, .external_lex_state = 4},
  [55] = {.lex_state = 2030, .external_lex_state = 6},
  [56] = {.lex_state = 2030, .external_lex_state = 6},
  [57] = {.lex_state = 2030, .external_lex_state = 4},
  [58] = {.lex_state = 2030, .external_lex_state = 4},
  [59] = {.lex_state = 2030, .external_lex_state = 6},
  [60] = {.lex_state = 2030, .external_lex_state = 4},
  [61] = {.lex_state = 2030, .external_lex_state = 4},
  [62] = {.lex_state = 2030, .external_lex_state = 6},
  [63] = {.lex_state = 2030, .external_lex_state = 4},
  [64] = {.lex_state = 2030, .external_lex_state = 6},
  [65] = {.lex_state = 2030, .external_lex_state = 4},
  [66] = {.lex_state = 2030, .external_lex_state = 6},
  [67] = {.lex_state = 2030, .external_lex_state = 4},
  [68] = {.lex_state = 2030, .external_lex_state = 4},
  [69] = {.lex_state = 2030, .external_lex_state = 6},
  [70] = {.lex_state = 2030, .external_lex_state = 4},
  [71] = {.lex_state = 2030, .external_lex_state = 6},
  [72] = {.lex_state = 2030, .external_lex_state = 6},
  [73] = {.lex_state = 2030, .external_lex_state = 6},
  [74] = {.lex_state = 2030, .external_lex_state = 4},
  [75] = {.lex_state = 2030, .external_lex_state = 4},
  [76] = {.lex_state = 2030, .external_lex_state = 4},
  [77] = {.lex_state = 2030, .external_lex_state = 4},
  [78] = {.lex_state = 2030, .external_lex_state = 4},
  [79] = {.lex_state = 2030, .external_lex_state = 4},
  [80] = {.lex_state = 2030, .external_lex_state = 4},
  [81] = {.lex_state = 2030, .external_lex_state = 4},
  [82] = {.lex_state = 2030, .external_lex_state = 7},
  [83] = {.lex_state = 2030, .external_lex_state = 4},
  [84] = {.lex_state = 2030, .external_lex_state = 6},
  [85] = {.lex_state = 2030, .external_lex_state = 6},
  [86] = {.lex_state = 2030, .external_lex_state = 6},
  [87] = {.lex_state = 2030, .external_lex_state = 6},
  [88] = {.lex_state = 2030, .external_lex_state = 6},
  [89] = {.lex_state = 2030, .external_lex_state = 6},
  [90] = {.lex_state = 2030, .external_lex_state = 6},
  [91] = {.lex_state = 2030, .external_lex_state = 4},
  [92] = {.lex_state = 2030, .external_lex_state = 8},
  [93] = {.lex_state = 2030, .external_lex_state = 6},
  [94] = {.lex_state = 2030, .external_lex_state = 4},
  [95] = {.lex_state = 2030, .external_lex_state = 6},
  [96] = {.lex_state = 2030, .external_lex_state = 6},
  [97] = {.lex_state = 2030, .external_lex_state = 4},
  [98] = {.lex_state = 2030, .external_lex_state = 4},
  [99] = {.lex_state = 2030, .external_lex_state = 6},
  [100] = {.lex_state = 2030, .external_lex_state = 6},
  [101] = {.lex_state = 2030, .external_lex_state = 9},
  [102] = {.lex_state = 2030, .external_lex_state = 10},
  [103] = {.lex_state = 2030, .external_lex_state = 9},
  [104] = {.lex_state = 2030, .external_lex_state = 11},
  [105] = {.lex_state = 2030, .external_lex_state = 9},
  [106] = {.lex_state = 2030, .external_lex_state = 9},
  [107] = {.lex_state = 2030, .external_lex_state = 11},
  [108] = {.lex_state = 2030, .external_lex_state = 12},
  [109] = {.lex_state = 2030, .external_lex_state = 13},
  [110] = {.lex_state = 2030, .external_lex_state = 9},
  [111] = {.lex_state = 2030, .external_lex_state = 14},
  [112] = {.lex_state = 2030, .external_lex_state = 11},
  [113] = {.lex_state = 2030, .external_lex_state = 13},
  [114] = {.lex_state = 2030, .external_lex_state = 14},
  [115] = {.lex_state = 2030, .external_lex_state = 14},
  [116] = {.lex_state = 2030, .external_lex_state = 11},
  [117] = {.lex_state = 2030, .external_lex_state = 11},
  [118] = {.lex_state = 2030, .external_lex_state = 13},
  [119] = {.lex_state = 2030, .external_lex_state = 3},
  [120] = {.lex_state = 2030, .external_lex_state = 5},
  [121] = {.lex_state = 2030, .external_lex_state = 5},
  [122] = {.lex_state = 2030, .external_lex_state = 3},
  [123] = {.lex_state = 2030, .external_lex_state = 5},
  [124] = {.lex_state = 2030, .external_lex_state = 3},
  [125] = {.lex_state = 2030, .external_lex_state = 3},
  [126] = {.lex_state = 2030, .external_lex_state = 3},
  [127] = {.lex_state = 2030, .external_lex_state = 3},
  [128] = {.lex_state = 2030, .external_lex_state = 3},
  [129] = {.lex_state = 2030, .external_lex_state = 3},
  [130] = {.lex_state = 2030, .external_lex_state = 3},
  [131] = {.lex_state = 2030, .external_lex_state = 11},
  [132] = {.lex_state = 2030, .external_lex_state = 3},
  [133] = {.lex_state = 2030, .external_lex_state = 3},
  [134] = {.lex_state = 2030, .external_lex_state = 3},
  [135] = {.lex_state = 2030, .external_lex_state = 5},
  [136] = {.lex_state = 2030, .external_lex_state = 3},
  [137] = {.lex_state = 2030, .external_lex_state = 5},
  [138] = {.lex_state = 2030, .external_lex_state = 5},
  [139] = {.lex_state = 2030, .external_lex_state = 9},
  [140] = {.lex_state = 2030, .external_lex_state = 3},
  [141] = {.lex_state = 2030, .external_lex_state = 3},
  [142] = {.lex_state = 2030, .external_lex_state = 5},
  [143] = {.lex_state = 2030, .external_lex_state = 3},
  [144] = {.lex_state = 2030, .external_lex_state = 3},
  [145] = {.lex_state = 2030, .external_lex_state = 6},
  [146] = {.lex_state = 2030, .external_lex_state = 5},
  [147] = {.lex_state = 2030, .external_lex_state = 5},
  [148] = {.lex_state = 2030, .external_lex_state = 5},
  [149] = {.lex_state = 2030, .external_lex_state = 5},
  [150] = {.lex_state = 2030, .external_lex_state = 5},
  [151] = {.lex_state = 2030, .external_lex_state = 3},
  [152] = {.lex_state = 2030, .external_lex_state = 3},
  [153] = {.lex_state = 2030, .external_lex_state = 5},
  [154] = {.lex_state = 2030, .external_lex_state = 5},
  [155] = {.lex_state = 2030, .external_lex_state = 5},
  [156] = {.lex_state = 2030, .external_lex_state = 5},
  [157] = {.lex_state = 2030, .external_lex_state = 3},
  [158] = {.lex_state = 2030, .external_lex_state = 3},
  [159] = {.lex_state = 2030, .external_lex_state = 5},
  [160] = {.lex_state = 2030, .external_lex_state = 5},
  [161] = {.lex_state = 2030, .external_lex_state = 3},
  [162] = {.lex_state = 2030, .external_lex_state = 5},
  [163] = {.lex_state = 2030, .external_lex_state = 5},
  [164] = {.lex_state = 2030, .external_lex_state = 5},
  [165] = {.lex_state = 2030, .external_lex_state = 5},
  [166] = {.lex_state = 2030, .external_lex_state = 5},
  [167] = {.lex_state = 2030, .external_lex_state = 3},
  [168] = {.lex_state = 2030, .external_lex_state = 5},
  [169] = {.lex_state = 2030, .external_lex_state = 3},
  [170] = {.lex_state = 2030, .external_lex_state = 5},
  [171] = {.lex_state = 2030, .external_lex_state = 5},
  [172] = {.lex_state = 2030, .external_lex_state = 3},
  [173] = {.lex_state = 2030, .external_lex_state = 5},
  [174] = {.lex_state = 2030, .external_lex_state = 3},
  [175] = {.lex_state = 2030, .external_lex_state = 5},
  [176] = {.lex_state = 2030, .external_lex_state = 5},
  [177] = {.lex_state = 2030, .external_lex_state = 3},
  [178] = {.lex_state = 2030, .external_lex_state = 5},
  [179] = {.lex_state = 2030, .external_lex_state = 3},
  [180] = {.lex_state = 2030, .external_lex_state = 3},
  [181] = {.lex_state = 2030, .external_lex_state = 5},
  [182] = {.lex_state = 2030, .external_lex_state = 3},
  [183] = {.lex_state = 2030, .external_lex_state = 3},
  [184] = {.lex_state = 2030, .external_lex_state = 6},
  [185] = {.lex_state = 2030, .external_lex_state = 6},
  [186] = {.lex_state = 2030, .external_lex_state = 6},
  [187] = {.lex_state = 2030, .external_lex_state = 6},
  [188] = {.lex_state = 2030, .external_lex_state = 6},
  [189] = {.lex_state = 2030, .external_lex_state = 6},
  [190] = {.lex_state = 2030, .external_lex_state = 6},
  [191] = {.lex_state = 2030, .external_lex_state = 4},
  [192] = {.lex_state = 2030, .external_lex_state = 6},
  [193] = {.lex_state = 2030, .external_lex_state = 4},
  [194] = {.lex_state = 2030, .external_lex_state = 6},
  [195] = {.lex_state = 2030, .external_lex_state = 4},
  [196] = {.lex_state = 2030, .external_lex_state = 4},
  [197] = {.lex_state = 2030, .external_lex_state = 4},
  [198] = {.lex_state = 2030, .external_lex_state = 4},
  [199] = {.lex_state = 2030, .external_lex_state = 4},
  [200] = {.lex_state = 2030, .external_lex_state = 4},
  [201] = {.lex_state = 2030, .external_lex_state = 6},
  [202] = {.lex_state = 2030, .external_lex_state = 6},
  [203] = {.lex_state = 2030, .external_lex_state = 6},
  [204] = {.lex_state = 2030, .external_lex_state = 6},
  [205] = {.lex_state = 2030, .external_lex_state = 4},
  [206] = {.lex_state = 2030, .external_lex_state = 6},
  [207] = {.lex_state = 2030, .external_lex_state = 6},
  [208] = {.lex_state = 2030, .external_lex_state = 6},
  [209] = {.lex_state = 2030, .external_lex_state = 6},
  [210] = {.lex_state = 2030, .external_lex_state = 6},
  [211] = {.lex_state = 2030, .external_lex_state = 6},
  [212] = {.lex_state = 2030, .external_lex_state = 4},
  [213] = {.lex_state = 2030, .external_lex_state = 6},
  [214] = {.lex_state = 2030, .external_lex_state = 6},
  [215] = {.lex_state = 2030, .external_lex_state = 4},
  [216] = {.lex_state = 2030, .external_lex_state = 6},
  [217] = {.lex_state = 2030, .external_lex_state = 6},
  [218] = {.lex_state = 2030, .external_lex_state = 4},
  [219] = {.lex_state = 2030, .external_lex_state = 6},
  [220] = {.lex_state = 2030, .external_lex_state = 6},
  [221] = {.lex_state = 2030, .external_lex_state = 4},
  [222] = {.lex_state = 2030, .external_lex_state = 6},
  [223] = {.lex_state = 2030, .external_lex_state = 6},
  [224] = {.lex_state = 2030, .external_lex_state = 4},
  [225] = {.lex_state = 2030, .external_lex_state = 6},
  [226] = {.lex_state = 2030, .external_lex_state = 6},
  [227] = {.lex_state = 2030, .external_lex_state = 4},
  [228] = {.lex_state = 2030, .external_lex_state = 6},
  [229] = {.lex_state = 2030, .external_lex_state = 4},
  [230] = {.lex_state = 2030, .external_lex_state = 6},
  [231] = {.lex_state = 2030, .external_lex_state = 3},
  [232] = {.lex_state = 2030, .external_lex_state = 3},
  [233] = {.lex_state = 2030, .external_lex_state = 6},
  [234] = {.lex_state = 2030, .external_lex_state = 6},
  [235] = {.lex_state = 2030, .external_lex_state = 6},
  [236] = {.lex_state = 2030, .external_lex_state = 6},
  [237] = {.lex_state = 2030, .external_lex_state = 6},
  [238] = {.lex_state = 2030, .external_lex_state = 6},
  [239] = {.lex_state = 2030, .external_lex_state = 6},
  [240] = {.lex_state = 2030, .external_lex_state = 6},
  [241] = {.lex_state = 2030, .external_lex_state = 6},
  [242] = {.lex_state = 2030, .external_lex_state = 6},
  [243] = {.lex_state = 2030, .external_lex_state = 6},
  [244] = {.lex_state = 2030, .external_lex_state = 3},
  [245] = {.lex_state = 2030, .external_lex_state = 6},
  [246] = {.lex_state = 2030, .external_lex_state = 3},
  [247] = {.lex_state = 2030, .external_lex_state = 3},
  [248] = {.lex_state = 2030, .external_lex_state = 6},
  [249] = {.lex_state = 2030, .external_lex_state = 6},
  [250] = {.lex_state = 2030, .external_lex_state = 6},
  [251] = {.lex_state = 2030, .external_lex_state = 6},
  [252] = {.lex_state = 2030, .external_lex_state = 6},
  [253] = {.lex_state = 2030, .external_lex_state = 6},
  [254] = {.lex_state = 2030, .external_lex_state = 4},
  [255] = {.lex_state = 2030, .external_lex_state = 4},
  [256] = {.lex_state = 2030, .external_lex_state = 6},
  [257] = {.lex_state = 2030, .external_lex_state = 6},
  [258] = {.lex_state = 2030, .external_lex_state = 4},
  [259] = {.lex_state = 2030, .external_lex_state = 6},
  [260] = {.lex_state = 2030, .external_lex_state = 4},
  [261] = {.lex_state = 2030, .external_lex_state = 6},
  [262] = {.lex_state = 2030, .external_lex_state = 6},
  [263] = {.lex_state = 2030, .external_lex_state = 6},
  [264] = {.lex_state = 2030, .external_lex_state = 6},
  [265] = {.lex_state = 2030, .external_lex_state = 6},
  [266] = {.lex_state = 2030, .external_lex_state = 6},
  [267] = {.lex_state = 2030, .external_lex_state = 4},
  [268] = {.lex_state = 2030, .external_lex_state = 4},
  [269] = {.lex_state = 2030, .external_lex_state = 4},
  [270] = {.lex_state = 2030, .external_lex_state = 6},
  [271] = {.lex_state = 2030, .external_lex_state = 4},
  [272] = {.lex_state = 2030, .external_lex_state = 4},
  [273] = {.lex_state = 2030, .external_lex_state = 6},
  [274] = {.lex_state = 2030, .external_lex_state = 4},
  [275] = {.lex_state = 2030, .external_lex_state = 4},
  [276] = {.lex_state = 2030, .external_lex_state = 4},
  [277] = {.lex_state = 2030, .external_lex_state = 6},
  [278] = {.lex_state = 2030, .external_lex_state = 4},
  [279] = {.lex_state = 2030, .external_lex_state = 6},
  [280] = {.lex_state = 2030, .external_lex_state = 4},
  [281] = {.lex_state = 2030, .external_lex_state = 4},
  [282] = {.lex_state = 2030, .external_lex_state = 4},
  [283] = {.lex_state = 2030, .external_lex_state = 4},
  [284] = {.lex_state = 2030, .external_lex_state = 4},
  [285] = {.lex_state = 2030, .external_lex_state = 6},
  [286] = {.lex_state = 2030, .external_lex_state = 4},
  [287] = {.lex_state = 2030, .external_lex_state = 4},
  [288] = {.lex_state = 2030, .external_lex_state = 4},
  [289] = {.lex_state = 2030, .external_lex_state = 6},
  [290] = {.lex_state = 2030, .external_lex_state = 6},
  [291] = {.lex_state = 2030, .external_lex_state = 6},
  [292] = {.lex_state = 2030, .external_lex_state = 4},
  [293] = {.lex_state = 2030, .external_lex_state = 4},
  [294] = {.lex_state = 2030, .external_lex_state = 4},
  [295] = {.lex_state = 2030, .external_lex_state = 4},
  [296] = {.lex_state = 2030, .external_lex_state = 4},
  [297] = {.lex_state = 2030, .external_lex_state = 6},
  [298] = {.lex_state = 2030, .external_lex_state = 6},
  [299] = {.lex_state = 2030, .external_lex_state = 6},
  [300] = {.lex_state = 2030, .external_lex_state = 6},
  [301] = {.lex_state = 2030, .external_lex_state = 6},
  [302] = {.lex_state = 2030, .external_lex_state = 6},
  [303] = {.lex_state = 2030, .external_lex_state = 6},
  [304] = {.lex_state = 2030, .external_lex_state = 6},
  [305] = {.lex_state = 2030, .external_lex_state = 4},
  [306] = {.lex_state = 2030, .external_lex_state = 6},
  [307] = {.lex_state = 2030, .external_lex_state = 6},
  [308] = {.lex_state = 2030, .external_lex_state = 6},
  [309] = {.lex_state = 2030, .external_lex_state = 6},
  [310] = {.lex_state = 2030, .external_lex_state = 4},
  [311] = {.lex_state = 2030, .external_lex_state = 6},
  [312] = {.lex_state = 2030, .external_lex_state = 6},
  [313] = {.lex_state = 2030, .external_lex_state = 4},
  [314] = {.lex_state = 2030, .external_lex_state = 4},
  [315] = {.lex_state = 2030, .external_lex_state = 4},
  [316] = {.lex_state = 2030, .external_lex_state = 4},
  [317] = {.lex_state = 2030, .external_lex_state = 4},
  [318] = {.lex_state = 2030, .external_lex_state = 4},
  [319] = {.lex_state = 2030, .external_lex_state = 4},
  [320] = {.lex_state = 2030, .external_lex_state = 4},
  [321] = {.lex_state = 2030, .external_lex_state = 4},
  [322] = {.lex_state = 2030, .external_lex_state = 4},
  [323] = {.lex_state = 2030, .external_lex_state = 4},
  [324] = {.lex_state = 2030, .external_lex_state = 4},
  [325] = {.lex_state = 2030, .external_lex_state = 4},
  [326] = {.lex_state = 2030, .external_lex_state = 4},
  [327] = {.lex_state = 2030, .external_lex_state = 4},
  [328] = {.lex_state = 2030, .external_lex_state = 4},
  [329] = {.lex_state = 2030, .external_lex_state = 4},
  [330] = {.lex_state = 2030, .external_lex_state = 4},
  [331] = {.lex_state = 2030, .external_lex_state = 4},
  [332] = {.lex_state = 2030, .external_lex_state = 4},
  [333] = {.lex_state = 2030, .external_lex_state = 4},
  [334] = {.lex_state = 2030, .external_lex_state = 4},
  [335] = {.lex_state = 2030, .external_lex_state = 4},
  [336] = {.lex_state = 2030, .external_lex_state = 4},
  [337] = {.lex_state = 2030, .external_lex_state = 4},
  [338] = {.lex_state = 2030, .external_lex_state = 4},
  [339] = {.lex_state = 2030, .external_lex_state = 6},
  [340] = {.lex_state = 2030, .external_lex_state = 4},
  [341] = {.lex_state = 2030, .external_lex_state = 4},
  [342] = {.lex_state = 2030, .external_lex_state = 6},
  [343] = {.lex_state = 2030, .external_lex_state = 4},
  [344] = {.lex_state = 2030, .external_lex_state = 4},
  [345] = {.lex_state = 2030, .external_lex_state = 4},
  [346] = {.lex_state = 2030, .external_lex_state = 4},
  [347] = {.lex_state = 2030, .external_lex_state = 4},
  [348] = {.lex_state = 2030, .external_lex_state = 4},
  [349] = {.lex_state = 2030, .external_lex_state = 4},
  [350] = {.lex_state = 2030, .external_lex_state = 4},
  [351] = {.lex_state = 2030, .external_lex_state = 15},
  [352] = {.lex_state = 2030, .external_lex_state = 15},
  [353] = {.lex_state = 1, .external_lex_state = 16},
  [354] = {.lex_state = 1, .external_lex_state = 17},
  [355] = {.lex_state = 1, .external_lex_state = 16},
  [356] = {.lex_state = 1, .external_lex_state = 17},
  [357] = {.lex_state = 1, .external_lex_state = 17},
  [358] = {.lex_state = 1, .external_lex_state = 17},
  [359] = {.lex_state = 1, .external_lex_state = 16},
  [360] = {.lex_state = 2030, .external_lex_state = 18},
  [361] = {.lex_state = 1, .external_lex_state = 17},
  [362] = {.lex_state = 1, .external_lex_state = 17},
  [363] = {.lex_state = 2030, .external_lex_state = 18},
  [364] = {.lex_state = 1, .external_lex_state = 17},
  [365] = {.lex_state = 2030, .external_lex_state = 19},
  [366] = {.lex_state = 2030, .external_lex_state = 19},
  [367] = {.lex_state = 2030, .external_lex_state = 19},
  [368] = {.lex_state = 1, .external_lex_state = 17},
  [369] = {.lex_state = 2030, .external_lex_state = 16},
  [370] = {.lex_state = 2030, .external_lex_state = 16},
  [371] = {.lex_state = 1, .external_lex_state = 16},
  [372] = {.lex_state = 1, .external_lex_state = 17},
  [373] = {.lex_state = 1, .external_lex_state = 17},
  [374] = {.lex_state = 1, .external_lex_state = 16},
  [375] = {.lex_state = 1, .external_lex_state = 16},
  [376] = {.lex_state = 2030, .external_lex_state = 19},
  [377] = {.lex_state = 2030, .external_lex_state = 19},
  [378] = {.lex_state = 2030, .external_lex_state = 18},
  [379] = {.lex_state = 2030, .external_lex_state = 18},
  [380] = {.lex_state = 2030, .external_lex_state = 19},
  [381] = {.lex_state = 1, .external_lex_state = 17},
  [382] = {.lex_state = 2030, .external_lex_state = 16},
  [383] = {.lex_state = 1, .external_lex_state = 17},
  [384] = {.lex_state = 2030, .external_lex_state = 18},
  [385] = {.lex_state = 2030, .external_lex_state = 18},
  [386] = {.lex_state = 1, .external_lex_state = 16},
  [387] = {.lex_state = 1, .external_lex_state = 17},
  [388] = {.lex_state = 2030, .external_lex_state = 20},
  [389] = {.lex_state = 1, .external_lex_state = 21},
  [390] = {.lex_state = 3, .external_lex_state = 22},
  [391] = {.lex_state = 1, .external_lex_state = 21},
  [392] = {.lex_state = 5, .external_lex_state = 22},
  [393] = {.lex_state = 5, .external_lex_state = 22},
  [394] = {.lex_state = 2030, .external_lex_state = 20},
  [395] = {.lex_state = 2, .external_lex_state = 22},
  [396] = {.lex_state = 2030, .external_lex_state = 20},
  [397] = {.lex_state = 2, .external_lex_state = 22},
  [398] = {.lex_state = 3, .external_lex_state = 22},
  [399] = {.lex_state = 1, .external_lex_state = 21},
  [400] = {.lex_state = 5, .external_lex_state = 22},
  [401] = {.lex_state = 1, .external_lex_state = 17},
  [402] = {.lex_state = 2030, .external_lex_state = 18},
  [403] = {.lex_state = 5, .external_lex_state = 22},
  [404] = {.lex_state = 1, .external_lex_state = 21},
  [405] = {.lex_state = 2030, .external_lex_state = 19},
  [406] = {.lex_state = 3, .external_lex_state = 22},
  [407] = {.lex_state = 1, .external_lex_state = 21},
  [408] = {.lex_state = 3, .external_lex_state = 22},
  [409] = {.lex_state = 2030, .external_lex_state = 16},
  [410] = {.lex_state = 4, .external_lex_state = 23},
  [411] = {.lex_state = 2030, .external_lex_state = 19},
  [412] = {.lex_state = 1, .external_lex_state = 21},
  [413] = {.lex_state = 1, .external_lex_state = 21},
  [414] = {.lex_state = 1, .external_lex_state = 21},
  [415] = {.lex_state = 1, .external_lex_state = 21},
  [416] = {.lex_state = 2, .external_lex_state = 22},
  [417] = {.lex_state = 5, .external_lex_state = 22},
  [418] = {.lex_state = 2030, .external_lex_state = 18},
  [419] = {.lex_state = 1, .external_lex_state = 21},
  [420] = {.lex_state = 2030, .external_lex_state = 20},
  [421] = {.lex_state = 1, .external_lex_state = 21},
  [422] = {.lex_state = 3, .external_lex_state = 22},
  [423] = {.lex_state = 2, .external_lex_state = 22},
  [424] = {.lex_state = 1, .external_lex_state = 21},
  [425] = {.lex_state = 2030, .external_lex_state = 20},
  [426] = {.lex_state = 2, .external_lex_state = 22},
  [427] = {.lex_state = 2030, .external_lex_state = 22},
  [428] = {.lex_state = 2030, .external_lex_state = 22},
  [429] = {.lex_state = 2030, .external_lex_state = 22},
  [430] = {.lex_state = 1, .external_lex_state = 21},
  [431] = {.lex_state = 4, .external_lex_state = 23},
  [432] = {.lex_state = 4, .external_lex_state = 23},
  [433] = {.lex_state = 2030, .external_lex_state = 22},
  [434] = {.lex_state = 2030, .external_lex_state = 22},
  [435] = {.lex_state = 2030, .external_lex_state = 22},
  [436] = {.lex_state = 2030, .external_lex_state = 22},
  [437] = {.lex_state = 2030, .external_lex_state = 21},
  [438] = {.lex_state = 2030, .external_lex_state = 22},
  [439] = {.lex_state = 2030, .external_lex_state = 22},
  [440] = {.lex_state = 1, .external_lex_state = 21},
  [441] = {.lex_state = 2030, .external_lex_state = 22},
  [442] = {.lex_state = 1, .external_lex_state = 21},
  [443] = {.lex_state = 2030, .external_lex_state = 22},
  [444] = {.lex_state = 4, .external_lex_state = 23},
  [445] = {.lex_state = 1, .external_lex_state = 21},
  [446] = {.lex_state = 4, .external_lex_state = 23},
  [447] = {.lex_state = 4, .external_lex_state = 23},
  [448] = {.lex_state = 1, .external_lex_state = 17},
  [449] = {.lex_state = 2030, .external_lex_state = 22},
  [450] = {.lex_state = 2030, .external_lex_state = 22},
  [451] = {.lex_state = 2030, .external_lex_state = 22},
  [452] = {.lex_state = 2030, .external_lex_state = 22},
  [453] = {.lex_state = 1, .external_lex_state = 21},
  [454] = {.lex_state = 1, .external_lex_state = 21},
  [455] = {.lex_state = 1, .external_lex_state = 21},
  [456] = {.lex_state = 2030, .external_lex_state = 22},
  [457] = {.lex_state = 1, .external_lex_state = 21},
  [458] = {.lex_state = 4, .external_lex_state = 23},
  [459] = {.lex_state = 4, .external_lex_state = 23},
  [460] = {.lex_state = 2030, .external_lex_state = 22},
  [461] = {.lex_state = 2030, .external_lex_state = 22},
  [462] = {.lex_state = 1, .external_lex_state = 17},
  [463] = {.lex_state = 2030, .external_lex_state = 22},
  [464] = {.lex_state = 1},
  [465] = {.lex_state = 1},
  [466] = {.lex_state = 1, .external_lex_state = 17},
  [467] = {.lex_state = 1},
  [468] = {.lex_state = 4, .external_lex_state = 23},
  [469] = {.lex_state = 1},
  [470] = {.lex_state = 4, .external_lex_state = 23},
  [471] = {.lex_state = 4, .external_lex_state = 23},
  [472] = {.lex_state = 1},
  [473] = {.lex_state = 1},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 1},
  [476] = {.lex_state = 1},
  [477] = {.lex_state = 4, .external_lex_state = 23},
  [478] = {.lex_state = 4, .external_lex_state = 23},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 4, .external_lex_state = 23},
  [481] = {.lex_state = 4, .external_lex_state = 23},
  [482] = {.lex_state = 1},
  [483] = {.lex_state = 4, .external_lex_state = 23},
  [484] = {.lex_state = 1},
  [485] = {.lex_state = 1},
  [486] = {.lex_state = 1},
  [487] = {.lex_state = 1, .external_lex_state = 17},
  [488] = {.lex_state = 2030, .external_lex_state = 19},
  [489] = {.lex_state = 4},
  [490] = {.lex_state = 2030, .external_lex_state = 20},
  [491] = {.lex_state = 1, .external_lex_state = 24},
  [492] = {.lex_state = 4, .external_lex_state = 17},
  [493] = {.lex_state = 2, .external_lex_state = 22},
  [494] = {.lex_state = 1},
  [495] = {.lex_state = 4, .external_lex_state = 17},
  [496] = {.lex_state = 2030, .external_lex_state = 17},
  [497] = {.lex_state = 2030, .external_lex_state = 17},
  [498] = {.lex_state = 2030, .external_lex_state = 17},
  [499] = {.lex_state = 3, .external_lex_state = 22},
  [500] = {.lex_state = 4, .external_lex_state = 17},
  [501] = {.lex_state = 5, .external_lex_state = 22},
  [502] = {.lex_state = 2030, .external_lex_state = 19},
  [503] = {.lex_state = 2030, .external_lex_state = 17},
  [504] = {.lex_state = 1, .external_lex_state = 16},
  [505] = {.lex_state = 3, .external_lex_state = 22},
  [506] = {.lex_state = 2030, .external_lex_state = 17},
  [507] = {.lex_state = 1},
  [508] = {.lex_state = 2030, .external_lex_state = 17},
  [509] = {.lex_state = 2030, .external_lex_state = 18},
  [510] = {.lex_state = 4, .external_lex_state = 17},
  [511] = {.lex_state = 2030, .external_lex_state = 20},
  [512] = {.lex_state = 2030, .external_lex_state = 17},
  [513] = {.lex_state = 2030, .external_lex_state = 17},
  [514] = {.lex_state = 2030, .external_lex_state = 18},
  [515] = {.lex_state = 2030, .external_lex_state = 17},
  [516] = {.lex_state = 4, .external_lex_state = 17},
  [517] = {.lex_state = 2030, .external_lex_state = 17},
  [518] = {.lex_state = 1},
  [519] = {.lex_state = 5, .external_lex_state = 22},
  [520] = {.lex_state = 2, .external_lex_state = 22},
  [521] = {.lex_state = 1, .external_lex_state = 16},
  [522] = {.lex_state = 1},
  [523] = {.lex_state = 4, .external_lex_state = 17},
  [524] = {.lex_state = 4, .external_lex_state = 17},
  [525] = {.lex_state = 1, .external_lex_state = 16},
  [526] = {.lex_state = 1},
  [527] = {.lex_state = 4, .external_lex_state = 25},
  [528] = {.lex_state = 2030, .external_lex_state = 17},
  [529] = {.lex_state = 1, .external_lex_state = 16},
  [530] = {.lex_state = 1, .external_lex_state = 21},
  [531] = {.lex_state = 1, .external_lex_state = 21},
  [532] = {.lex_state = 1},
  [533] = {.lex_state = 2030, .external_lex_state = 16},
  [534] = {.lex_state = 4},
  [535] = {.lex_state = 2030, .external_lex_state = 17},
  [536] = {.lex_state = 2030, .external_lex_state = 16},
  [537] = {.lex_state = 4, .external_lex_state = 23},
  [538] = {.lex_state = 1, .external_lex_state = 17},
  [539] = {.lex_state = 2030, .external_lex_state = 26},
  [540] = {.lex_state = 4, .external_lex_state = 17},
  [541] = {.lex_state = 1, .external_lex_state = 21},
  [542] = {.lex_state = 4, .external_lex_state = 17},
  [543] = {.lex_state = 1, .external_lex_state = 21},
  [544] = {.lex_state = 4, .external_lex_state = 17},
  [545] = {.lex_state = 4, .external_lex_state = 17},
  [546] = {.lex_state = 2030, .external_lex_state = 27},
  [547] = {.lex_state = 4, .external_lex_state = 23},
  [548] = {.lex_state = 1, .external_lex_state = 17},
  [549] = {.lex_state = 2030, .external_lex_state = 28},
  [550] = {.lex_state = 2030, .external_lex_state = 29},
  [551] = {.lex_state = 1, .external_lex_state = 21},
  [552] = {.lex_state = 4, .external_lex_state = 17},
  [553] = {.lex_state = 4, .external_lex_state = 17},
  [554] = {.lex_state = 2, .external_lex_state = 30},
  [555] = {.lex_state = 4, .external_lex_state = 23},
  [556] = {.lex_state = 4},
  [557] = {.lex_state = 2030, .external_lex_state = 22},
  [558] = {.lex_state = 5, .external_lex_state = 30},
  [559] = {.lex_state = 2030, .external_lex_state = 31},
  [560] = {.lex_state = 4, .external_lex_state = 17},
  [561] = {.lex_state = 1, .external_lex_state = 17},
  [562] = {.lex_state = 1, .external_lex_state = 21},
  [563] = {.lex_state = 3, .external_lex_state = 30},
  [564] = {.lex_state = 4, .external_lex_state = 23},
  [565] = {.lex_state = 2030, .external_lex_state = 32},
  [566] = {.lex_state = 4, .external_lex_state = 17},
  [567] = {.lex_state = 1, .external_lex_state = 21},
  [568] = {.lex_state = 4, .external_lex_state = 23},
  [569] = {.lex_state = 2030, .external_lex_state = 22},
  [570] = {.lex_state = 1, .external_lex_state = 21},
  [571] = {.lex_state = 1, .external_lex_state = 17},
  [572] = {.lex_state = 1, .external_lex_state = 21},
  [573] = {.lex_state = 2030, .external_lex_state = 33},
  [574] = {.lex_state = 4},
  [575] = {.lex_state = 2030, .external_lex_state = 17},
  [576] = {.lex_state = 1, .external_lex_state = 34},
  [577] = {.lex_state = 5, .external_lex_state = 22},
  [578] = {.lex_state = 2, .external_lex_state = 22},
  [579] = {.lex_state = 5, .external_lex_state = 22},
  [580] = {.lex_state = 2, .external_lex_state = 22},
  [581] = {.lex_state = 2030, .external_lex_state = 20},
  [582] = {.lex_state = 4},
  [583] = {.lex_state = 5, .external_lex_state = 22},
  [584] = {.lex_state = 4},
  [585] = {.lex_state = 2030, .external_lex_state = 17},
  [586] = {.lex_state = 2030, .external_lex_state = 18},
  [587] = {.lex_state = 3, .external_lex_state = 22},
  [588] = {.lex_state = 4},
  [589] = {.lex_state = 1, .external_lex_state = 21},
  [590] = {.lex_state = 2030, .external_lex_state = 16},
  [591] = {.lex_state = 3, .external_lex_state = 22},
  [592] = {.lex_state = 4},
  [593] = {.lex_state = 2030, .external_lex_state = 29},
  [594] = {.lex_state = 4},
  [595] = {.lex_state = 2030, .external_lex_state = 19},
  [596] = {.lex_state = 2030, .external_lex_state = 16},
  [597] = {.lex_state = 4},
  [598] = {.lex_state = 4},
  [599] = {.lex_state = 4},
  [600] = {.lex_state = 1, .external_lex_state = 21},
  [601] = {.lex_state = 2030, .external_lex_state = 16},
  [602] = {.lex_state = 1, .external_lex_state = 21},
  [603] = {.lex_state = 2030, .external_lex_state = 20},
  [604] = {.lex_state = 4},
  [605] = {.lex_state = 2030, .external_lex_state = 16},
  [606] = {.lex_state = 2030, .external_lex_state = 19},
  [607] = {.lex_state = 2, .external_lex_state = 22},
  [608] = {.lex_state = 3, .external_lex_state = 22},
  [609] = {.lex_state = 4},
  [610] = {.lex_state = 4},
  [611] = {.lex_state = 1},
  [612] = {.lex_state = 2030, .external_lex_state = 18},
  [613] = {.lex_state = 2030, .external_lex_state = 20},
  [614] = {.lex_state = 2030, .external_lex_state = 30},
  [615] = {.lex_state = 4},
  [616] = {.lex_state = 2030, .external_lex_state = 16},
  [617] = {.lex_state = 1},
  [618] = {.lex_state = 4, .external_lex_state = 17},
  [619] = {.lex_state = 4, .external_lex_state = 17},
  [620] = {.lex_state = 1},
  [621] = {.lex_state = 1},
  [622] = {.lex_state = 1},
  [623] = {.lex_state = 4, .external_lex_state = 17},
  [624] = {.lex_state = 2030, .external_lex_state = 22},
  [625] = {.lex_state = 2030, .external_lex_state = 22},
  [626] = {.lex_state = 2030, .external_lex_state = 22},
  [627] = {.lex_state = 4, .external_lex_state = 17},
  [628] = {.lex_state = 2030, .external_lex_state = 22},
  [629] = {.lex_state = 1},
  [630] = {.lex_state = 2030, .external_lex_state = 17},
  [631] = {.lex_state = 4},
  [632] = {.lex_state = 0, .external_lex_state = 35},
  [633] = {.lex_state = 0, .external_lex_state = 35},
  [634] = {.lex_state = 0, .external_lex_state = 35},
  [635] = {.lex_state = 0, .external_lex_state = 35},
  [636] = {.lex_state = 0, .external_lex_state = 35},
  [637] = {.lex_state = 2030, .external_lex_state = 23},
  [638] = {.lex_state = 2030, .external_lex_state = 23},
  [639] = {.lex_state = 2030, .external_lex_state = 23},
  [640] = {.lex_state = 2030, .external_lex_state = 23},
  [641] = {.lex_state = 2030, .external_lex_state = 23},
  [642] = {.lex_state = 2030},
  [643] = {.lex_state = 2030, .external_lex_state = 23},
  [644] = {.lex_state = 2030, .external_lex_state = 23},
  [645] = {.lex_state = 2030},
  [646] = {.lex_state = 0, .external_lex_state = 36},
  [647] = {.lex_state = 0, .external_lex_state = 36},
  [648] = {.lex_state = 0, .external_lex_state = 36},
  [649] = {.lex_state = 2030, .external_lex_state = 23},
  [650] = {.lex_state = 2030, .external_lex_state = 23},
  [651] = {.lex_state = 0, .external_lex_state = 36},
  [652] = {.lex_state = 0, .external_lex_state = 36},
  [653] = {.lex_state = 0, .external_lex_state = 36},
  [654] = {.lex_state = 0, .external_lex_state = 36},
  [655] = {.lex_state = 0, .external_lex_state = 36},
  [656] = {.lex_state = 0, .external_lex_state = 36},
  [657] = {.lex_state = 0, .external_lex_state = 35},
  [658] = {.lex_state = 0, .external_lex_state = 36},
  [659] = {.lex_state = 2030, .external_lex_state = 23},
  [660] = {.lex_state = 0, .external_lex_state = 37},
  [661] = {.lex_state = 0, .external_lex_state = 16},
  [662] = {.lex_state = 0, .external_lex_state = 37},
  [663] = {.lex_state = 0, .external_lex_state = 16},
  [664] = {.lex_state = 0, .external_lex_state = 16},
  [665] = {.lex_state = 2030},
  [666] = {.lex_state = 0, .external_lex_state = 37},
  [667] = {.lex_state = 0, .external_lex_state = 37},
  [668] = {.lex_state = 0, .external_lex_state = 37},
  [669] = {.lex_state = 0, .external_lex_state = 23},
  [670] = {.lex_state = 2030, .external_lex_state = 23},
  [671] = {.lex_state = 2030},
  [672] = {.lex_state = 0, .external_lex_state = 37},
  [673] = {.lex_state = 0, .external_lex_state = 37},
  [674] = {.lex_state = 0, .external_lex_state = 16},
  [675] = {.lex_state = 0, .external_lex_state = 23},
  [676] = {.lex_state = 0, .external_lex_state = 16},
  [677] = {.lex_state = 0, .external_lex_state = 16},
  [678] = {.lex_state = 0, .external_lex_state = 37},
  [679] = {.lex_state = 0, .external_lex_state = 38},
  [680] = {.lex_state = 0, .external_lex_state = 16},
  [681] = {.lex_state = 0, .external_lex_state = 16},
  [682] = {.lex_state = 0, .external_lex_state = 37},
  [683] = {.lex_state = 0, .external_lex_state = 23},
  [684] = {.lex_state = 0, .external_lex_state = 16},
  [685] = {.lex_state = 0, .external_lex_state = 37},
  [686] = {.lex_state = 2030, .external_lex_state = 23},
  [687] = {.lex_state = 0, .external_lex_state = 16},
  [688] = {.lex_state = 2030, .external_lex_state = 23},
  [689] = {.lex_state = 0, .external_lex_state = 23},
  [690] = {.lex_state = 0, .external_lex_state = 16},
  [691] = {.lex_state = 0, .external_lex_state = 23},
  [692] = {.lex_state = 0, .external_lex_state = 23},
  [693] = {.lex_state = 0, .external_lex_state = 23},
  [694] = {.lex_state = 2030},
  [695] = {.lex_state = 2030},
  [696] = {.lex_state = 0, .external_lex_state = 23},
  [697] = {.lex_state = 2030},
  [698] = {.lex_state = 0, .external_lex_state = 16},
  [699] = {.lex_state = 0, .external_lex_state = 23},
  [700] = {.lex_state = 0, .external_lex_state = 23},
  [701] = {.lex_state = 0, .external_lex_state = 37},
  [702] = {.lex_state = 0, .external_lex_state = 37},
  [703] = {.lex_state = 0, .external_lex_state = 23},
  [704] = {.lex_state = 0, .external_lex_state = 23},
  [705] = {.lex_state = 0, .external_lex_state = 16},
  [706] = {.lex_state = 0, .external_lex_state = 37},
  [707] = {.lex_state = 0, .external_lex_state = 16},
  [708] = {.lex_state = 0, .external_lex_state = 23},
  [709] = {.lex_state = 0, .external_lex_state = 16},
  [710] = {.lex_state = 0, .external_lex_state = 23},
  [711] = {.lex_state = 0, .external_lex_state = 16},
  [712] = {.lex_state = 0, .external_lex_state = 23},
  [713] = {.lex_state = 0, .external_lex_state = 23},
  [714] = {.lex_state = 0, .external_lex_state = 16},
  [715] = {.lex_state = 0, .external_lex_state = 16},
  [716] = {.lex_state = 2030, .external_lex_state = 34},
  [717] = {.lex_state = 0, .external_lex_state = 16},
  [718] = {.lex_state = 0, .external_lex_state = 37},
  [719] = {.lex_state = 0, .external_lex_state = 16},
  [720] = {.lex_state = 0, .external_lex_state = 16},
  [721] = {.lex_state = 0, .external_lex_state = 37},
  [722] = {.lex_state = 0, .external_lex_state = 16},
  [723] = {.lex_state = 0, .external_lex_state = 16},
  [724] = {.lex_state = 0, .external_lex_state = 16},
  [725] = {.lex_state = 0, .external_lex_state = 37},
  [726] = {.lex_state = 0, .external_lex_state = 23},
  [727] = {.lex_state = 0, .external_lex_state = 23},
  [728] = {.lex_state = 0, .external_lex_state = 23},
  [729] = {.lex_state = 0, .external_lex_state = 23},
  [730] = {.lex_state = 0, .external_lex_state = 37},
  [731] = {.lex_state = 0, .external_lex_state = 37},
  [732] = {.lex_state = 0, .external_lex_state = 37},
  [733] = {.lex_state = 0, .external_lex_state = 16},
  [734] = {.lex_state = 0, .external_lex_state = 37},
  [735] = {.lex_state = 0, .external_lex_state = 37},
  [736] = {.lex_state = 0, .external_lex_state = 37},
  [737] = {.lex_state = 0, .external_lex_state = 16},
  [738] = {.lex_state = 0, .external_lex_state = 37},
  [739] = {.lex_state = 2030},
  [740] = {.lex_state = 0, .external_lex_state = 23},
  [741] = {.lex_state = 2030},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 0, .external_lex_state = 23},
  [751] = {.lex_state = 0, .external_lex_state = 23},
  [752] = {.lex_state = 0, .external_lex_state = 23},
  [753] = {.lex_state = 0, .external_lex_state = 23},
  [754] = {.lex_state = 0, .external_lex_state = 16},
  [755] = {.lex_state = 0, .external_lex_state = 23},
  [756] = {.lex_state = 0, .external_lex_state = 23},
  [757] = {.lex_state = 0, .external_lex_state = 23},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0, .external_lex_state = 23},
  [760] = {.lex_state = 2030},
  [761] = {.lex_state = 0, .external_lex_state = 23},
  [762] = {.lex_state = 0, .external_lex_state = 16},
  [763] = {.lex_state = 0, .external_lex_state = 23},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0, .external_lex_state = 23},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0, .external_lex_state = 23},
  [770] = {.lex_state = 0, .external_lex_state = 23},
  [771] = {.lex_state = 0, .external_lex_state = 23},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0, .external_lex_state = 17},
  [774] = {.lex_state = 0, .external_lex_state = 16},
  [775] = {.lex_state = 0, .external_lex_state = 17},
  [776] = {.lex_state = 0, .external_lex_state = 39},
  [777] = {.lex_state = 0, .external_lex_state = 39},
  [778] = {.lex_state = 0, .external_lex_state = 39},
  [779] = {.lex_state = 0, .external_lex_state = 17},
  [780] = {.lex_state = 0, .external_lex_state = 39},
  [781] = {.lex_state = 0, .external_lex_state = 39},
  [782] = {.lex_state = 0, .external_lex_state = 39},
  [783] = {.lex_state = 0, .external_lex_state = 17},
  [784] = {.lex_state = 0, .external_lex_state = 39},
  [785] = {.lex_state = 0, .external_lex_state = 17},
  [786] = {.lex_state = 0, .external_lex_state = 17},
  [787] = {.lex_state = 0, .external_lex_state = 17},
  [788] = {.lex_state = 0, .external_lex_state = 39},
  [789] = {.lex_state = 0, .external_lex_state = 39},
  [790] = {.lex_state = 0, .external_lex_state = 23},
  [791] = {.lex_state = 0, .external_lex_state = 17},
  [792] = {.lex_state = 0, .external_lex_state = 16},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0, .external_lex_state = 17},
  [795] = {.lex_state = 0, .external_lex_state = 40},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0, .external_lex_state = 17},
  [798] = {.lex_state = 0, .external_lex_state = 17},
  [799] = {.lex_state = 0, .external_lex_state = 17},
  [800] = {.lex_state = 0, .external_lex_state = 17},
  [801] = {.lex_state = 0, .external_lex_state = 17},
  [802] = {.lex_state = 0, .external_lex_state = 17},
  [803] = {.lex_state = 0, .external_lex_state = 17},
  [804] = {.lex_state = 0, .external_lex_state = 41},
  [805] = {.lex_state = 0, .external_lex_state = 17},
  [806] = {.lex_state = 0, .external_lex_state = 42},
  [807] = {.lex_state = 0},
  [808] = {.lex_state = 2030},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0, .external_lex_state = 17},
  [811] = {.lex_state = 2030},
  [812] = {.lex_state = 0, .external_lex_state = 17},
  [813] = {.lex_state = 0, .external_lex_state = 17},
  [814] = {.lex_state = 0, .external_lex_state = 17},
  [815] = {.lex_state = 0, .external_lex_state = 17},
  [816] = {.lex_state = 0, .external_lex_state = 17},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 0, .external_lex_state = 41},
  [819] = {.lex_state = 0, .external_lex_state = 17},
  [820] = {.lex_state = 0, .external_lex_state = 40},
  [821] = {.lex_state = 0, .external_lex_state = 17},
  [822] = {.lex_state = 0, .external_lex_state = 17},
  [823] = {.lex_state = 0, .external_lex_state = 40},
  [824] = {.lex_state = 0, .external_lex_state = 17},
  [825] = {.lex_state = 0, .external_lex_state = 17},
  [826] = {.lex_state = 0, .external_lex_state = 43},
  [827] = {.lex_state = 0, .external_lex_state = 17},
  [828] = {.lex_state = 0, .external_lex_state = 17},
  [829] = {.lex_state = 0, .external_lex_state = 17},
  [830] = {.lex_state = 0, .external_lex_state = 41},
  [831] = {.lex_state = 0, .external_lex_state = 41},
  [832] = {.lex_state = 0, .external_lex_state = 40},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0, .external_lex_state = 17},
  [835] = {.lex_state = 0, .external_lex_state = 17},
  [836] = {.lex_state = 0, .external_lex_state = 41},
  [837] = {.lex_state = 0, .external_lex_state = 17},
  [838] = {.lex_state = 0, .external_lex_state = 40},
  [839] = {.lex_state = 0, .external_lex_state = 17},
  [840] = {.lex_state = 0, .external_lex_state = 17},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0, .external_lex_state = 17},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0, .external_lex_state = 17},
  [845] = {.lex_state = 0, .external_lex_state = 17},
  [846] = {.lex_state = 0, .external_lex_state = 17},
  [847] = {.lex_state = 0, .external_lex_state = 17},
  [848] = {.lex_state = 0, .external_lex_state = 17},
  [849] = {.lex_state = 0, .external_lex_state = 42},
  [850] = {.lex_state = 0, .external_lex_state = 17},
  [851] = {.lex_state = 0, .external_lex_state = 44},
  [852] = {.lex_state = 0, .external_lex_state = 17},
  [853] = {.lex_state = 0, .external_lex_state = 41},
  [854] = {.lex_state = 0, .external_lex_state = 17},
  [855] = {.lex_state = 0, .external_lex_state = 40},
  [856] = {.lex_state = 0, .external_lex_state = 17},
  [857] = {.lex_state = 0, .external_lex_state = 45},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0, .external_lex_state = 45},
  [860] = {.lex_state = 0, .external_lex_state = 46},
  [861] = {.lex_state = 0, .external_lex_state = 46},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0, .external_lex_state = 45},
  [864] = {.lex_state = 0, .external_lex_state = 46},
  [865] = {.lex_state = 0, .external_lex_state = 46},
  [866] = {.lex_state = 0, .external_lex_state = 46},
  [867] = {.lex_state = 0, .external_lex_state = 45},
  [868] = {.lex_state = 0, .external_lex_state = 45},
  [869] = {.lex_state = 0, .external_lex_state = 45},
  [870] = {.lex_state = 0, .external_lex_state = 45},
  [871] = {.lex_state = 0, .external_lex_state = 45},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0, .external_lex_state = 45},
  [874] = {.lex_state = 0, .external_lex_state = 45},
  [875] = {.lex_state = 0, .external_lex_state = 45},
  [876] = {.lex_state = 0, .external_lex_state = 45},
  [877] = {.lex_state = 0, .external_lex_state = 45},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0, .external_lex_state = 46},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0, .external_lex_state = 45},
  [882] = {.lex_state = 0, .external_lex_state = 46},
  [883] = {.lex_state = 0, .external_lex_state = 46},
  [884] = {.lex_state = 0, .external_lex_state = 45},
  [885] = {.lex_state = 0, .external_lex_state = 46},
  [886] = {.lex_state = 0, .external_lex_state = 46},
  [887] = {.lex_state = 0, .external_lex_state = 45},
  [888] = {.lex_state = 0, .external_lex_state = 47},
  [889] = {.lex_state = 0, .external_lex_state = 45},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0, .external_lex_state = 45},
  [892] = {.lex_state = 0, .external_lex_state = 45},
  [893] = {.lex_state = 0, .external_lex_state = 45},
  [894] = {.lex_state = 0, .external_lex_state = 45},
  [895] = {.lex_state = 0, .external_lex_state = 45},
  [896] = {.lex_state = 0, .external_lex_state = 45},
  [897] = {.lex_state = 0, .external_lex_state = 45},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0, .external_lex_state = 45},
  [901] = {.lex_state = 0, .external_lex_state = 45},
  [902] = {.lex_state = 0, .external_lex_state = 47},
  [903] = {.lex_state = 0, .external_lex_state = 47},
  [904] = {.lex_state = 0, .external_lex_state = 45},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0, .external_lex_state = 47},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0, .external_lex_state = 45},
  [909] = {.lex_state = 0, .external_lex_state = 45},
  [910] = {.lex_state = 0, .external_lex_state = 45},
  [911] = {.lex_state = 0, .external_lex_state = 46},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0, .external_lex_state = 46},
  [916] = {.lex_state = 0, .external_lex_state = 46},
  [917] = {.lex_state = 0, .external_lex_state = 46},
  [918] = {.lex_state = 0, .external_lex_state = 46},
  [919] = {.lex_state = 0, .external_lex_state = 46},
};

enum {
  ts_external_token__line_ending = 0,
  ts_external_token__soft_line_ending = 1,
  ts_external_token__block_close = 2,
  ts_external_token_block_continuation = 3,
  ts_external_token__block_quote_start = 4,
  ts_external_token__indented_chunk_start = 5,
  ts_external_token_atx_h1_marker = 6,
  ts_external_token_atx_h2_marker = 7,
  ts_external_token_atx_h3_marker = 8,
  ts_external_token_atx_h4_marker = 9,
  ts_external_token_atx_h5_marker = 10,
  ts_external_token_atx_h6_marker = 11,
  ts_external_token_setext_h1_underline = 12,
  ts_external_token_setext_h2_underline = 13,
  ts_external_token__thematic_break = 14,
  ts_external_token__list_marker_minus = 15,
  ts_external_token__list_marker_plus = 16,
  ts_external_token__list_marker_star = 17,
  ts_external_token__list_marker_parenthesis = 18,
  ts_external_token__list_marker_dot = 19,
  ts_external_token__list_marker_minus_dont_interrupt = 20,
  ts_external_token__list_marker_plus_dont_interrupt = 21,
  ts_external_token__list_marker_star_dont_interrupt = 22,
  ts_external_token__list_marker_parenthesis_dont_interrupt = 23,
  ts_external_token__list_marker_dot_dont_interrupt = 24,
  ts_external_token__fenced_code_block_start_backtick = 25,
  ts_external_token__fenced_code_block_start_tilde = 26,
  ts_external_token__blank_line_start = 27,
  ts_external_token__fenced_code_block_end_backtick = 28,
  ts_external_token__fenced_code_block_end_tilde = 29,
  ts_external_token__html_block_1_start = 30,
  ts_external_token__html_block_1_end = 31,
  ts_external_token__html_block_2_start = 32,
  ts_external_token__html_block_3_start = 33,
  ts_external_token__html_block_4_start = 34,
  ts_external_token__html_block_5_start = 35,
  ts_external_token__html_block_6_start = 36,
  ts_external_token__html_block_7_start = 37,
  ts_external_token__close_block = 38,
  ts_external_token__no_indented_chunk = 39,
  ts_external_token__error = 40,
  ts_external_token__trigger_error = 41,
  ts_external_token__eof = 42,
  ts_external_token_minus_metadata = 43,
  ts_external_token_plus_metadata = 44,
  ts_external_token__pipe_table_start = 45,
  ts_external_token__pipe_table_line_ending = 46,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__line_ending] = sym__line_ending,
  [ts_external_token__soft_line_ending] = sym__soft_line_ending,
  [ts_external_token__block_close] = sym__block_close,
  [ts_external_token_block_continuation] = sym_block_continuation,
  [ts_external_token__block_quote_start] = sym__block_quote_start,
  [ts_external_token__indented_chunk_start] = sym__indented_chunk_start,
  [ts_external_token_atx_h1_marker] = sym_atx_h1_marker,
  [ts_external_token_atx_h2_marker] = sym_atx_h2_marker,
  [ts_external_token_atx_h3_marker] = sym_atx_h3_marker,
  [ts_external_token_atx_h4_marker] = sym_atx_h4_marker,
  [ts_external_token_atx_h5_marker] = sym_atx_h5_marker,
  [ts_external_token_atx_h6_marker] = sym_atx_h6_marker,
  [ts_external_token_setext_h1_underline] = sym_setext_h1_underline,
  [ts_external_token_setext_h2_underline] = sym_setext_h2_underline,
  [ts_external_token__thematic_break] = sym__thematic_break,
  [ts_external_token__list_marker_minus] = sym__list_marker_minus,
  [ts_external_token__list_marker_plus] = sym__list_marker_plus,
  [ts_external_token__list_marker_star] = sym__list_marker_star,
  [ts_external_token__list_marker_parenthesis] = sym__list_marker_parenthesis,
  [ts_external_token__list_marker_dot] = sym__list_marker_dot,
  [ts_external_token__list_marker_minus_dont_interrupt] = sym__list_marker_minus_dont_interrupt,
  [ts_external_token__list_marker_plus_dont_interrupt] = sym__list_marker_plus_dont_interrupt,
  [ts_external_token__list_marker_star_dont_interrupt] = sym__list_marker_star_dont_interrupt,
  [ts_external_token__list_marker_parenthesis_dont_interrupt] = sym__list_marker_parenthesis_dont_interrupt,
  [ts_external_token__list_marker_dot_dont_interrupt] = sym__list_marker_dot_dont_interrupt,
  [ts_external_token__fenced_code_block_start_backtick] = sym__fenced_code_block_start_backtick,
  [ts_external_token__fenced_code_block_start_tilde] = sym__fenced_code_block_start_tilde,
  [ts_external_token__blank_line_start] = sym__blank_line_start,
  [ts_external_token__fenced_code_block_end_backtick] = sym__fenced_code_block_end_backtick,
  [ts_external_token__fenced_code_block_end_tilde] = sym__fenced_code_block_end_tilde,
  [ts_external_token__html_block_1_start] = sym__html_block_1_start,
  [ts_external_token__html_block_1_end] = sym__html_block_1_end,
  [ts_external_token__html_block_2_start] = sym__html_block_2_start,
  [ts_external_token__html_block_3_start] = sym__html_block_3_start,
  [ts_external_token__html_block_4_start] = sym__html_block_4_start,
  [ts_external_token__html_block_5_start] = sym__html_block_5_start,
  [ts_external_token__html_block_6_start] = sym__html_block_6_start,
  [ts_external_token__html_block_7_start] = sym__html_block_7_start,
  [ts_external_token__close_block] = sym__close_block,
  [ts_external_token__no_indented_chunk] = sym__no_indented_chunk,
  [ts_external_token__error] = sym__error,
  [ts_external_token__trigger_error] = sym__trigger_error,
  [ts_external_token__eof] = sym__eof,
  [ts_external_token_minus_metadata] = sym_minus_metadata,
  [ts_external_token_plus_metadata] = sym_plus_metadata,
  [ts_external_token__pipe_table_start] = sym__pipe_table_start,
  [ts_external_token__pipe_table_line_ending] = sym__pipe_table_line_ending,
};

static const bool ts_external_scanner_states[48][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token_setext_h1_underline] = true,
    [ts_external_token_setext_h2_underline] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__fenced_code_block_end_backtick] = true,
    [ts_external_token__fenced_code_block_end_tilde] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_1_end] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__close_block] = true,
    [ts_external_token__no_indented_chunk] = true,
    [ts_external_token__error] = true,
    [ts_external_token__trigger_error] = true,
    [ts_external_token__eof] = true,
    [ts_external_token_minus_metadata] = true,
    [ts_external_token_plus_metadata] = true,
    [ts_external_token__pipe_table_start] = true,
    [ts_external_token__pipe_table_line_ending] = true,
  },
  [2] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token_minus_metadata] = true,
    [ts_external_token_plus_metadata] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [3] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [4] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [5] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [6] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [7] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token_setext_h1_underline] = true,
    [ts_external_token_setext_h2_underline] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [8] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token_setext_h1_underline] = true,
    [ts_external_token_setext_h2_underline] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [9] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__no_indented_chunk] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [10] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__no_indented_chunk] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [11] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__no_indented_chunk] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [12] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__no_indented_chunk] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [13] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token_setext_h1_underline] = true,
    [ts_external_token_setext_h2_underline] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [14] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__block_quote_start] = true,
    [ts_external_token__indented_chunk_start] = true,
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
    [ts_external_token_setext_h1_underline] = true,
    [ts_external_token_setext_h2_underline] = true,
    [ts_external_token__thematic_break] = true,
    [ts_external_token__list_marker_minus] = true,
    [ts_external_token__list_marker_plus] = true,
    [ts_external_token__list_marker_star] = true,
    [ts_external_token__list_marker_parenthesis] = true,
    [ts_external_token__list_marker_dot] = true,
    [ts_external_token__list_marker_minus_dont_interrupt] = true,
    [ts_external_token__list_marker_plus_dont_interrupt] = true,
    [ts_external_token__list_marker_star_dont_interrupt] = true,
    [ts_external_token__list_marker_parenthesis_dont_interrupt] = true,
    [ts_external_token__list_marker_dot_dont_interrupt] = true,
    [ts_external_token__fenced_code_block_start_backtick] = true,
    [ts_external_token__fenced_code_block_start_tilde] = true,
    [ts_external_token__blank_line_start] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__pipe_table_start] = true,
  },
  [15] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__html_block_1_start] = true,
    [ts_external_token__html_block_2_start] = true,
    [ts_external_token__html_block_3_start] = true,
    [ts_external_token__html_block_4_start] = true,
    [ts_external_token__html_block_5_start] = true,
    [ts_external_token__html_block_6_start] = true,
    [ts_external_token__html_block_7_start] = true,
    [ts_external_token__eof] = true,
  },
  [16] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__eof] = true,
  },
  [17] = {
    [ts_external_token__line_ending] = true,
  },
  [18] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token__fenced_code_block_end_backtick] = true,
  },
  [19] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token__fenced_code_block_end_tilde] = true,
  },
  [20] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token__html_block_1_end] = true,
  },
  [21] = {
    [ts_external_token__soft_line_ending] = true,
  },
  [22] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
  },
  [23] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__eof] = true,
    [ts_external_token__pipe_table_line_ending] = true,
  },
  [24] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token_block_continuation] = true,
  },
  [25] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__eof] = true,
    [ts_external_token__pipe_table_line_ending] = true,
  },
  [26] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token__close_block] = true,
  },
  [27] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__html_block_1_end] = true,
  },
  [28] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__fenced_code_block_end_tilde] = true,
  },
  [29] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token__blank_line_start] = true,
  },
  [30] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token_block_continuation] = true,
  },
  [31] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__eof] = true,
  },
  [32] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__fenced_code_block_end_backtick] = true,
  },
  [33] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__block_close] = true,
    [ts_external_token_block_continuation] = true,
    [ts_external_token__blank_line_start] = true,
  },
  [34] = {
    [ts_external_token_block_continuation] = true,
  },
  [35] = {
    [ts_external_token_atx_h1_marker] = true,
    [ts_external_token_atx_h2_marker] = true,
    [ts_external_token_atx_h3_marker] = true,
    [ts_external_token_atx_h4_marker] = true,
    [ts_external_token_atx_h5_marker] = true,
    [ts_external_token_atx_h6_marker] = true,
  },
  [36] = {
    [ts_external_token__soft_line_ending] = true,
    [ts_external_token__no_indented_chunk] = true,
  },
  [37] = {
    [ts_external_token__no_indented_chunk] = true,
  },
  [38] = {
    [ts_external_token_block_continuation] = true,
    [ts_external_token__no_indented_chunk] = true,
  },
  [39] = {
    [ts_external_token__line_ending] = true,
    [ts_external_token__eof] = true,
  },
  [40] = {
    [ts_external_token__block_close] = true,
    [ts_external_token__fenced_code_block_end_tilde] = true,
  },
  [41] = {
    [ts_external_token__block_close] = true,
    [ts_external_token__fenced_code_block_end_backtick] = true,
  },
  [42] = {
    [ts_external_token__block_close] = true,
    [ts_external_token_block_continuation] = true,
  },
  [43] = {
    [ts_external_token_block_continuation] = true,
    [ts_external_token__trigger_error] = true,
  },
  [44] = {
    [ts_external_token_block_continuation] = true,
    [ts_external_token__close_block] = true,
  },
  [45] = {
    [ts_external_token__block_close] = true,
  },
  [46] = {
    [ts_external_token__close_block] = true,
  },
  [47] = {
    [ts_external_token__trigger_error] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__backslash_escape] = ACTIONS(1),
    [sym_entity_reference] = ACTIONS(1),
    [sym_numeric_character_reference] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym__newline_token] = ACTIONS(1),
    [anon_sym_DASH_DASH_GT] = ACTIONS(1),
    [anon_sym_QMARK_GT] = ACTIONS(1),
    [anon_sym_RBRACK_RBRACK_GT] = ACTIONS(1),
    [aux_sym__word_token1] = ACTIONS(1),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1),
    [aux_sym__word_token2] = ACTIONS(1),
    [sym__whitespace] = ACTIONS(1),
    [sym__line_ending] = ACTIONS(1),
    [sym__soft_line_ending] = ACTIONS(1),
    [sym__block_close] = ACTIONS(1),
    [sym_block_continuation] = ACTIONS(1),
    [sym__block_quote_start] = ACTIONS(1),
    [sym__indented_chunk_start] = ACTIONS(1),
    [sym_atx_h1_marker] = ACTIONS(1),
    [sym_atx_h2_marker] = ACTIONS(1),
    [sym_atx_h3_marker] = ACTIONS(1),
    [sym_atx_h4_marker] = ACTIONS(1),
    [sym_atx_h5_marker] = ACTIONS(1),
    [sym_atx_h6_marker] = ACTIONS(1),
    [sym_setext_h1_underline] = ACTIONS(1),
    [sym_setext_h2_underline] = ACTIONS(1),
    [sym__thematic_break] = ACTIONS(1),
    [sym__list_marker_minus] = ACTIONS(1),
    [sym__list_marker_plus] = ACTIONS(1),
    [sym__list_marker_star] = ACTIONS(1),
    [sym__list_marker_parenthesis] = ACTIONS(1),
    [sym__list_marker_dot] = ACTIONS(1),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1),
    [sym__blank_line_start] = ACTIONS(1),
    [sym__fenced_code_block_end_backtick] = ACTIONS(1),
    [sym__fenced_code_block_end_tilde] = ACTIONS(1),
    [sym__html_block_1_start] = ACTIONS(1),
    [sym__html_block_1_end] = ACTIONS(1),
    [sym__html_block_2_start] = ACTIONS(1),
    [sym__html_block_3_start] = ACTIONS(1),
    [sym__html_block_4_start] = ACTIONS(1),
    [sym__html_block_5_start] = ACTIONS(1),
    [sym__html_block_6_start] = ACTIONS(1),
    [sym__html_block_7_start] = ACTIONS(1),
    [sym__close_block] = ACTIONS(1),
    [sym__no_indented_chunk] = ACTIONS(1),
    [sym__error] = ACTIONS(1),
    [sym__trigger_error] = ACTIONS(1),
    [sym__eof] = ACTIONS(1),
    [sym_minus_metadata] = ACTIONS(1),
    [sym_plus_metadata] = ACTIONS(1),
    [sym__pipe_table_start] = ACTIONS(1),
    [sym__pipe_table_line_ending] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(907),
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(258),
    [sym_section] = STATE(635),
    [sym__section1] = STATE(657),
    [sym__section2] = STATE(657),
    [sym__section3] = STATE(657),
    [sym__section4] = STATE(657),
    [sym__section5] = STATE(657),
    [sym__section6] = STATE(657),
    [sym_thematic_break] = STATE(258),
    [sym__atx_heading1] = STATE(37),
    [sym__atx_heading2] = STATE(45),
    [sym__atx_heading3] = STATE(49),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(258),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(258),
    [sym_html_block] = STATE(258),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(258),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(258),
    [sym_block_quote] = STATE(258),
    [sym_list] = STATE(258),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(258),
    [aux_sym_document_repeat1] = STATE(24),
    [aux_sym_document_repeat2] = STATE(635),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(17),
    [sym_atx_h2_marker] = ACTIONS(19),
    [sym_atx_h3_marker] = ACTIONS(21),
    [sym_atx_h4_marker] = ACTIONS(23),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym_minus_metadata] = ACTIONS(61),
    [sym_plus_metadata] = ACTIONS(61),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [2] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(900),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym_block_continuation] = ACTIONS(71),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [3] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(868),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym_block_continuation] = ACTIONS(113),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [4] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(910),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym_block_continuation] = ACTIONS(115),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [5] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(869),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym_block_continuation] = ACTIONS(117),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [6] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(904),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym_block_continuation] = ACTIONS(119),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [7] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(901),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym_block_continuation] = ACTIONS(121),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [8] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(870),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym_block_continuation] = ACTIONS(123),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [9] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(871),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym_block_continuation] = ACTIONS(125),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [10] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(875),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym_block_continuation] = ACTIONS(127),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [11] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(909),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym_block_continuation] = ACTIONS(129),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [12] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(891),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [13] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(894),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [14] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(892),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [15] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(897),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [16] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(857),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [17] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(887),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [18] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(895),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [19] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(884),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [20] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(893),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [21] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(29),
    [sym__block_not_section] = STATE(29),
    [sym_section] = STATE(29),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(29),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(29),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(29),
    [sym_html_block] = STATE(29),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(29),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(145),
    [sym_block_quote] = STATE(29),
    [sym_list] = STATE(29),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__list_item_content] = STATE(873),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_task_list_marker_checked] = STATE(872),
    [sym_task_list_marker_unchecked] = STATE(872),
    [sym_pipe_table] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(29),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(65),
    [aux_sym__word_token2] = ACTIONS(67),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [22] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(26),
    [sym__block_not_section] = STATE(26),
    [sym_section] = STATE(26),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(26),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(26),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(26),
    [sym_html_block] = STATE(26),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(26),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(26),
    [sym_block_quote] = STATE(26),
    [sym_list] = STATE(26),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(26),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(131),
    [sym_block_continuation] = ACTIONS(133),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [23] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(25),
    [sym__block_not_section] = STATE(25),
    [sym_section] = STATE(25),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(25),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(25),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(25),
    [sym_html_block] = STATE(25),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(25),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(25),
    [sym_block_quote] = STATE(25),
    [sym_list] = STATE(25),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(25),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(25),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(135),
    [sym_block_continuation] = ACTIONS(137),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [24] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(258),
    [sym_section] = STATE(632),
    [sym__section1] = STATE(657),
    [sym__section2] = STATE(657),
    [sym__section3] = STATE(657),
    [sym__section4] = STATE(657),
    [sym__section5] = STATE(657),
    [sym__section6] = STATE(657),
    [sym_thematic_break] = STATE(258),
    [sym__atx_heading1] = STATE(37),
    [sym__atx_heading2] = STATE(45),
    [sym__atx_heading3] = STATE(49),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(258),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(258),
    [sym_html_block] = STATE(258),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(258),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(258),
    [sym_block_quote] = STATE(258),
    [sym_list] = STATE(258),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(258),
    [aux_sym_document_repeat1] = STATE(68),
    [aux_sym_document_repeat2] = STATE(632),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(139),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(17),
    [sym_atx_h2_marker] = ACTIONS(19),
    [sym_atx_h3_marker] = ACTIONS(21),
    [sym_atx_h4_marker] = ACTIONS(23),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [25] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(32),
    [sym__block_not_section] = STATE(32),
    [sym_section] = STATE(32),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(32),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(32),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(32),
    [sym_html_block] = STATE(32),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(32),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(32),
    [sym_block_quote] = STATE(32),
    [sym_list] = STATE(32),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(32),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(141),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [26] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(32),
    [sym__block_not_section] = STATE(32),
    [sym_section] = STATE(32),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(32),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(32),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(32),
    [sym_html_block] = STATE(32),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(32),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(32),
    [sym_block_quote] = STATE(32),
    [sym_list] = STATE(32),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(32),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(143),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [27] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(33),
    [sym__block_not_section] = STATE(33),
    [sym_section] = STATE(33),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(33),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(33),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(33),
    [sym_html_block] = STATE(33),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(33),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(33),
    [sym_block_quote] = STATE(33),
    [sym_list] = STATE(33),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(33),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(33),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(143),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [28] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(258),
    [sym_section] = STATE(636),
    [sym__section1] = STATE(657),
    [sym__section2] = STATE(657),
    [sym__section3] = STATE(657),
    [sym__section4] = STATE(657),
    [sym__section5] = STATE(657),
    [sym__section6] = STATE(657),
    [sym_thematic_break] = STATE(258),
    [sym__atx_heading1] = STATE(37),
    [sym__atx_heading2] = STATE(45),
    [sym__atx_heading3] = STATE(49),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(258),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(258),
    [sym_html_block] = STATE(258),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(258),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(258),
    [sym_block_quote] = STATE(258),
    [sym_list] = STATE(258),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(258),
    [aux_sym_document_repeat1] = STATE(68),
    [aux_sym_document_repeat2] = STATE(636),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(17),
    [sym_atx_h2_marker] = ACTIONS(19),
    [sym_atx_h3_marker] = ACTIONS(21),
    [sym_atx_h4_marker] = ACTIONS(23),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [29] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(32),
    [sym__block_not_section] = STATE(32),
    [sym_section] = STATE(32),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(32),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(32),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(32),
    [sym_html_block] = STATE(32),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(32),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(32),
    [sym_block_quote] = STATE(32),
    [sym_list] = STATE(32),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(32),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(147),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [30] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(258),
    [sym_section] = STATE(634),
    [sym__section1] = STATE(657),
    [sym__section2] = STATE(657),
    [sym__section3] = STATE(657),
    [sym__section4] = STATE(657),
    [sym__section5] = STATE(657),
    [sym__section6] = STATE(657),
    [sym_thematic_break] = STATE(258),
    [sym__atx_heading1] = STATE(37),
    [sym__atx_heading2] = STATE(45),
    [sym__atx_heading3] = STATE(49),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(258),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(258),
    [sym_html_block] = STATE(258),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(258),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(258),
    [sym_block_quote] = STATE(258),
    [sym_list] = STATE(258),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(258),
    [aux_sym_document_repeat1] = STATE(28),
    [aux_sym_document_repeat2] = STATE(634),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(149),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(17),
    [sym_atx_h2_marker] = ACTIONS(19),
    [sym_atx_h3_marker] = ACTIONS(21),
    [sym_atx_h4_marker] = ACTIONS(23),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [31] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(32),
    [sym__block_not_section] = STATE(32),
    [sym_section] = STATE(32),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(32),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(32),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(32),
    [sym_html_block] = STATE(32),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(32),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(32),
    [sym_block_quote] = STATE(32),
    [sym_list] = STATE(32),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(32),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(151),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [32] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(32),
    [sym__block_not_section] = STATE(32),
    [sym_section] = STATE(32),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(32),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(32),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(32),
    [sym_html_block] = STATE(32),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(32),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(32),
    [sym_block_quote] = STATE(32),
    [sym_list] = STATE(32),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(32),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(153),
    [anon_sym_RBRACK] = ACTIONS(156),
    [anon_sym_LT] = ACTIONS(156),
    [anon_sym_GT] = ACTIONS(156),
    [anon_sym_BANG] = ACTIONS(156),
    [anon_sym_DQUOTE] = ACTIONS(156),
    [anon_sym_POUND] = ACTIONS(156),
    [anon_sym_DOLLAR] = ACTIONS(156),
    [anon_sym_PERCENT] = ACTIONS(156),
    [anon_sym_AMP] = ACTIONS(156),
    [anon_sym_SQUOTE] = ACTIONS(156),
    [anon_sym_STAR] = ACTIONS(156),
    [anon_sym_PLUS] = ACTIONS(156),
    [anon_sym_COMMA] = ACTIONS(156),
    [anon_sym_DASH] = ACTIONS(156),
    [anon_sym_DOT] = ACTIONS(156),
    [anon_sym_SLASH] = ACTIONS(156),
    [anon_sym_COLON] = ACTIONS(156),
    [anon_sym_SEMI] = ACTIONS(156),
    [anon_sym_EQ] = ACTIONS(156),
    [anon_sym_QMARK] = ACTIONS(156),
    [anon_sym_AT] = ACTIONS(156),
    [anon_sym_BSLASH] = ACTIONS(156),
    [anon_sym_CARET] = ACTIONS(156),
    [anon_sym__] = ACTIONS(156),
    [anon_sym_BQUOTE] = ACTIONS(156),
    [anon_sym_LBRACE] = ACTIONS(156),
    [anon_sym_PIPE] = ACTIONS(156),
    [anon_sym_RBRACE] = ACTIONS(156),
    [anon_sym_TILDE] = ACTIONS(156),
    [anon_sym_LPAREN] = ACTIONS(156),
    [anon_sym_RPAREN] = ACTIONS(156),
    [aux_sym__word_token1] = ACTIONS(156),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(156),
    [aux_sym__word_token2] = ACTIONS(156),
    [sym__whitespace] = ACTIONS(159),
    [sym__soft_line_ending] = ACTIONS(162),
    [sym__block_close] = ACTIONS(165),
    [sym__block_quote_start] = ACTIONS(167),
    [sym__indented_chunk_start] = ACTIONS(170),
    [sym_atx_h1_marker] = ACTIONS(173),
    [sym_atx_h2_marker] = ACTIONS(176),
    [sym_atx_h3_marker] = ACTIONS(179),
    [sym_atx_h4_marker] = ACTIONS(182),
    [sym_atx_h5_marker] = ACTIONS(185),
    [sym_atx_h6_marker] = ACTIONS(188),
    [sym__thematic_break] = ACTIONS(191),
    [sym__list_marker_minus] = ACTIONS(194),
    [sym__list_marker_plus] = ACTIONS(197),
    [sym__list_marker_star] = ACTIONS(200),
    [sym__list_marker_parenthesis] = ACTIONS(203),
    [sym__list_marker_dot] = ACTIONS(206),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(194),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(197),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(200),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(203),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(206),
    [sym__fenced_code_block_start_backtick] = ACTIONS(209),
    [sym__fenced_code_block_start_tilde] = ACTIONS(212),
    [sym__blank_line_start] = ACTIONS(215),
    [sym__html_block_1_start] = ACTIONS(218),
    [sym__html_block_2_start] = ACTIONS(221),
    [sym__html_block_3_start] = ACTIONS(224),
    [sym__html_block_4_start] = ACTIONS(227),
    [sym__html_block_5_start] = ACTIONS(230),
    [sym__html_block_6_start] = ACTIONS(233),
    [sym__html_block_7_start] = ACTIONS(236),
    [sym__pipe_table_start] = ACTIONS(239),
  },
  [33] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(32),
    [sym__block_not_section] = STATE(32),
    [sym_section] = STATE(32),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(32),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(32),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(32),
    [sym_html_block] = STATE(32),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(32),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(32),
    [sym_block_quote] = STATE(32),
    [sym_list] = STATE(32),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(32),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(242),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [34] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(36),
    [sym__block_not_section] = STATE(36),
    [sym_section] = STATE(36),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(36),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(36),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(36),
    [sym_html_block] = STATE(36),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(36),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(36),
    [sym_block_quote] = STATE(36),
    [sym_list] = STATE(36),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(36),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(36),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(141),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [35] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(31),
    [sym__block_not_section] = STATE(31),
    [sym_section] = STATE(31),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(31),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(31),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(31),
    [sym_html_block] = STATE(31),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(31),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(31),
    [sym_block_quote] = STATE(31),
    [sym_list] = STATE(31),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(31),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(31),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(244),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [36] = {
    [sym_link_label] = STATE(912),
    [sym__block] = STATE(32),
    [sym__block_not_section] = STATE(32),
    [sym_section] = STATE(32),
    [sym__section1] = STATE(311),
    [sym__section2] = STATE(311),
    [sym__section3] = STATE(311),
    [sym__section4] = STATE(311),
    [sym__section5] = STATE(311),
    [sym__section6] = STATE(311),
    [sym_thematic_break] = STATE(32),
    [sym__atx_heading1] = STATE(42),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(32),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(32),
    [sym_html_block] = STATE(32),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(32),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(32),
    [sym_block_quote] = STATE(32),
    [sym_list] = STATE(32),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym_block_quote_repeat1] = STATE(32),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(246),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(77),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [37] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(40),
    [sym__section2] = STATE(324),
    [sym__section3] = STATE(324),
    [sym__section4] = STATE(324),
    [sym__section5] = STATE(324),
    [sym__section6] = STATE(324),
    [sym_thematic_break] = STATE(40),
    [sym__atx_heading2] = STATE(45),
    [sym__atx_heading3] = STATE(49),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(40),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(40),
    [sym_html_block] = STATE(40),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(40),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(40),
    [sym_block_quote] = STATE(40),
    [sym_list] = STATE(40),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(40),
    [aux_sym__section1_repeat1] = STATE(40),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(248),
    [sym_atx_h2_marker] = ACTIONS(19),
    [sym_atx_h3_marker] = ACTIONS(21),
    [sym_atx_h4_marker] = ACTIONS(23),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [38] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(38),
    [sym__section2] = STATE(290),
    [sym__section3] = STATE(290),
    [sym__section4] = STATE(290),
    [sym__section5] = STATE(290),
    [sym__section6] = STATE(290),
    [sym_thematic_break] = STATE(38),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(38),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(38),
    [sym_html_block] = STATE(38),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(38),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(38),
    [sym_block_quote] = STATE(38),
    [sym_list] = STATE(38),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(38),
    [aux_sym__section1_repeat1] = STATE(38),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(250),
    [anon_sym_RBRACK] = ACTIONS(253),
    [anon_sym_LT] = ACTIONS(253),
    [anon_sym_GT] = ACTIONS(253),
    [anon_sym_BANG] = ACTIONS(253),
    [anon_sym_DQUOTE] = ACTIONS(253),
    [anon_sym_POUND] = ACTIONS(253),
    [anon_sym_DOLLAR] = ACTIONS(253),
    [anon_sym_PERCENT] = ACTIONS(253),
    [anon_sym_AMP] = ACTIONS(253),
    [anon_sym_SQUOTE] = ACTIONS(253),
    [anon_sym_STAR] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(253),
    [anon_sym_COMMA] = ACTIONS(253),
    [anon_sym_DASH] = ACTIONS(253),
    [anon_sym_DOT] = ACTIONS(253),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_COLON] = ACTIONS(253),
    [anon_sym_SEMI] = ACTIONS(253),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_QMARK] = ACTIONS(253),
    [anon_sym_AT] = ACTIONS(253),
    [anon_sym_BSLASH] = ACTIONS(253),
    [anon_sym_CARET] = ACTIONS(253),
    [anon_sym__] = ACTIONS(253),
    [anon_sym_BQUOTE] = ACTIONS(253),
    [anon_sym_LBRACE] = ACTIONS(253),
    [anon_sym_PIPE] = ACTIONS(253),
    [anon_sym_RBRACE] = ACTIONS(253),
    [anon_sym_TILDE] = ACTIONS(253),
    [anon_sym_LPAREN] = ACTIONS(253),
    [anon_sym_RPAREN] = ACTIONS(253),
    [aux_sym__word_token1] = ACTIONS(253),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(253),
    [aux_sym__word_token2] = ACTIONS(253),
    [sym__whitespace] = ACTIONS(256),
    [sym__soft_line_ending] = ACTIONS(259),
    [sym__block_close] = ACTIONS(262),
    [sym__block_quote_start] = ACTIONS(264),
    [sym__indented_chunk_start] = ACTIONS(267),
    [sym_atx_h1_marker] = ACTIONS(262),
    [sym_atx_h2_marker] = ACTIONS(270),
    [sym_atx_h3_marker] = ACTIONS(273),
    [sym_atx_h4_marker] = ACTIONS(276),
    [sym_atx_h5_marker] = ACTIONS(279),
    [sym_atx_h6_marker] = ACTIONS(282),
    [sym__thematic_break] = ACTIONS(285),
    [sym__list_marker_minus] = ACTIONS(288),
    [sym__list_marker_plus] = ACTIONS(291),
    [sym__list_marker_star] = ACTIONS(294),
    [sym__list_marker_parenthesis] = ACTIONS(297),
    [sym__list_marker_dot] = ACTIONS(300),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(288),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(291),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(294),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(297),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(300),
    [sym__fenced_code_block_start_backtick] = ACTIONS(303),
    [sym__fenced_code_block_start_tilde] = ACTIONS(306),
    [sym__blank_line_start] = ACTIONS(309),
    [sym__html_block_1_start] = ACTIONS(312),
    [sym__html_block_2_start] = ACTIONS(315),
    [sym__html_block_3_start] = ACTIONS(318),
    [sym__html_block_4_start] = ACTIONS(321),
    [sym__html_block_5_start] = ACTIONS(324),
    [sym__html_block_6_start] = ACTIONS(327),
    [sym__html_block_7_start] = ACTIONS(330),
    [sym__pipe_table_start] = ACTIONS(333),
  },
  [39] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(38),
    [sym__section2] = STATE(290),
    [sym__section3] = STATE(290),
    [sym__section4] = STATE(290),
    [sym__section5] = STATE(290),
    [sym__section6] = STATE(290),
    [sym_thematic_break] = STATE(38),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(38),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(38),
    [sym_html_block] = STATE(38),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(38),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(38),
    [sym_block_quote] = STATE(38),
    [sym_list] = STATE(38),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(38),
    [aux_sym__section1_repeat1] = STATE(38),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(336),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(336),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [40] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(41),
    [sym__section2] = STATE(324),
    [sym__section3] = STATE(324),
    [sym__section4] = STATE(324),
    [sym__section5] = STATE(324),
    [sym__section6] = STATE(324),
    [sym_thematic_break] = STATE(41),
    [sym__atx_heading2] = STATE(45),
    [sym__atx_heading3] = STATE(49),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(41),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(41),
    [sym_html_block] = STATE(41),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(41),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(41),
    [sym_block_quote] = STATE(41),
    [sym_list] = STATE(41),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(41),
    [aux_sym__section1_repeat1] = STATE(41),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(336),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(336),
    [sym_atx_h2_marker] = ACTIONS(19),
    [sym_atx_h3_marker] = ACTIONS(21),
    [sym_atx_h4_marker] = ACTIONS(23),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [41] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(41),
    [sym__section2] = STATE(324),
    [sym__section3] = STATE(324),
    [sym__section4] = STATE(324),
    [sym__section5] = STATE(324),
    [sym__section6] = STATE(324),
    [sym_thematic_break] = STATE(41),
    [sym__atx_heading2] = STATE(45),
    [sym__atx_heading3] = STATE(49),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(41),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(41),
    [sym_html_block] = STATE(41),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(41),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(41),
    [sym_block_quote] = STATE(41),
    [sym_list] = STATE(41),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(41),
    [aux_sym__section1_repeat1] = STATE(41),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(262),
    [anon_sym_LBRACK] = ACTIONS(250),
    [anon_sym_RBRACK] = ACTIONS(253),
    [anon_sym_LT] = ACTIONS(253),
    [anon_sym_GT] = ACTIONS(253),
    [anon_sym_BANG] = ACTIONS(253),
    [anon_sym_DQUOTE] = ACTIONS(253),
    [anon_sym_POUND] = ACTIONS(253),
    [anon_sym_DOLLAR] = ACTIONS(253),
    [anon_sym_PERCENT] = ACTIONS(253),
    [anon_sym_AMP] = ACTIONS(253),
    [anon_sym_SQUOTE] = ACTIONS(253),
    [anon_sym_STAR] = ACTIONS(253),
    [anon_sym_PLUS] = ACTIONS(253),
    [anon_sym_COMMA] = ACTIONS(253),
    [anon_sym_DASH] = ACTIONS(253),
    [anon_sym_DOT] = ACTIONS(253),
    [anon_sym_SLASH] = ACTIONS(253),
    [anon_sym_COLON] = ACTIONS(253),
    [anon_sym_SEMI] = ACTIONS(253),
    [anon_sym_EQ] = ACTIONS(253),
    [anon_sym_QMARK] = ACTIONS(253),
    [anon_sym_AT] = ACTIONS(253),
    [anon_sym_BSLASH] = ACTIONS(253),
    [anon_sym_CARET] = ACTIONS(253),
    [anon_sym__] = ACTIONS(253),
    [anon_sym_BQUOTE] = ACTIONS(253),
    [anon_sym_LBRACE] = ACTIONS(253),
    [anon_sym_PIPE] = ACTIONS(253),
    [anon_sym_RBRACE] = ACTIONS(253),
    [anon_sym_TILDE] = ACTIONS(253),
    [anon_sym_LPAREN] = ACTIONS(253),
    [anon_sym_RPAREN] = ACTIONS(253),
    [aux_sym__word_token1] = ACTIONS(253),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(253),
    [aux_sym__word_token2] = ACTIONS(253),
    [sym__whitespace] = ACTIONS(338),
    [sym__soft_line_ending] = ACTIONS(259),
    [sym__block_quote_start] = ACTIONS(341),
    [sym__indented_chunk_start] = ACTIONS(344),
    [sym_atx_h1_marker] = ACTIONS(262),
    [sym_atx_h2_marker] = ACTIONS(347),
    [sym_atx_h3_marker] = ACTIONS(350),
    [sym_atx_h4_marker] = ACTIONS(353),
    [sym_atx_h5_marker] = ACTIONS(356),
    [sym_atx_h6_marker] = ACTIONS(359),
    [sym__thematic_break] = ACTIONS(362),
    [sym__list_marker_minus] = ACTIONS(288),
    [sym__list_marker_plus] = ACTIONS(291),
    [sym__list_marker_star] = ACTIONS(294),
    [sym__list_marker_parenthesis] = ACTIONS(297),
    [sym__list_marker_dot] = ACTIONS(300),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(288),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(291),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(294),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(297),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(300),
    [sym__fenced_code_block_start_backtick] = ACTIONS(365),
    [sym__fenced_code_block_start_tilde] = ACTIONS(368),
    [sym__blank_line_start] = ACTIONS(371),
    [sym__html_block_1_start] = ACTIONS(374),
    [sym__html_block_2_start] = ACTIONS(377),
    [sym__html_block_3_start] = ACTIONS(380),
    [sym__html_block_4_start] = ACTIONS(383),
    [sym__html_block_5_start] = ACTIONS(386),
    [sym__html_block_6_start] = ACTIONS(389),
    [sym__html_block_7_start] = ACTIONS(392),
    [sym__pipe_table_start] = ACTIONS(395),
  },
  [42] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(39),
    [sym__section2] = STATE(290),
    [sym__section3] = STATE(290),
    [sym__section4] = STATE(290),
    [sym__section5] = STATE(290),
    [sym__section6] = STATE(290),
    [sym_thematic_break] = STATE(39),
    [sym__atx_heading2] = STATE(43),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(39),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(39),
    [sym_html_block] = STATE(39),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(39),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(39),
    [sym_block_quote] = STATE(39),
    [sym_list] = STATE(39),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(39),
    [aux_sym__section1_repeat1] = STATE(39),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(248),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(248),
    [sym_atx_h2_marker] = ACTIONS(79),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [43] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(47),
    [sym__section3] = STATE(289),
    [sym__section4] = STATE(289),
    [sym__section5] = STATE(289),
    [sym__section6] = STATE(289),
    [sym_thematic_break] = STATE(47),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(47),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(47),
    [sym_html_block] = STATE(47),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(47),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(47),
    [sym_block_quote] = STATE(47),
    [sym_list] = STATE(47),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(47),
    [aux_sym__section2_repeat1] = STATE(47),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(398),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(398),
    [sym_atx_h2_marker] = ACTIONS(398),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [44] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(44),
    [sym__section3] = STATE(289),
    [sym__section4] = STATE(289),
    [sym__section5] = STATE(289),
    [sym__section6] = STATE(289),
    [sym_thematic_break] = STATE(44),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(44),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(44),
    [sym_html_block] = STATE(44),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(44),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(44),
    [sym_block_quote] = STATE(44),
    [sym_list] = STATE(44),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(44),
    [aux_sym__section2_repeat1] = STATE(44),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(400),
    [anon_sym_RBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(403),
    [anon_sym_GT] = ACTIONS(403),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(403),
    [anon_sym_POUND] = ACTIONS(403),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_PERCENT] = ACTIONS(403),
    [anon_sym_AMP] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(403),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_PLUS] = ACTIONS(403),
    [anon_sym_COMMA] = ACTIONS(403),
    [anon_sym_DASH] = ACTIONS(403),
    [anon_sym_DOT] = ACTIONS(403),
    [anon_sym_SLASH] = ACTIONS(403),
    [anon_sym_COLON] = ACTIONS(403),
    [anon_sym_SEMI] = ACTIONS(403),
    [anon_sym_EQ] = ACTIONS(403),
    [anon_sym_QMARK] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_BSLASH] = ACTIONS(403),
    [anon_sym_CARET] = ACTIONS(403),
    [anon_sym__] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(403),
    [anon_sym_PIPE] = ACTIONS(403),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_RPAREN] = ACTIONS(403),
    [aux_sym__word_token1] = ACTIONS(403),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(403),
    [aux_sym__word_token2] = ACTIONS(403),
    [sym__whitespace] = ACTIONS(406),
    [sym__soft_line_ending] = ACTIONS(409),
    [sym__block_close] = ACTIONS(412),
    [sym__block_quote_start] = ACTIONS(414),
    [sym__indented_chunk_start] = ACTIONS(417),
    [sym_atx_h1_marker] = ACTIONS(412),
    [sym_atx_h2_marker] = ACTIONS(412),
    [sym_atx_h3_marker] = ACTIONS(420),
    [sym_atx_h4_marker] = ACTIONS(423),
    [sym_atx_h5_marker] = ACTIONS(426),
    [sym_atx_h6_marker] = ACTIONS(429),
    [sym__thematic_break] = ACTIONS(432),
    [sym__list_marker_minus] = ACTIONS(435),
    [sym__list_marker_plus] = ACTIONS(438),
    [sym__list_marker_star] = ACTIONS(441),
    [sym__list_marker_parenthesis] = ACTIONS(444),
    [sym__list_marker_dot] = ACTIONS(447),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(435),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(438),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(441),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(444),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(447),
    [sym__fenced_code_block_start_backtick] = ACTIONS(450),
    [sym__fenced_code_block_start_tilde] = ACTIONS(453),
    [sym__blank_line_start] = ACTIONS(456),
    [sym__html_block_1_start] = ACTIONS(459),
    [sym__html_block_2_start] = ACTIONS(462),
    [sym__html_block_3_start] = ACTIONS(465),
    [sym__html_block_4_start] = ACTIONS(468),
    [sym__html_block_5_start] = ACTIONS(471),
    [sym__html_block_6_start] = ACTIONS(474),
    [sym__html_block_7_start] = ACTIONS(477),
    [sym__pipe_table_start] = ACTIONS(480),
  },
  [45] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(46),
    [sym__section3] = STATE(319),
    [sym__section4] = STATE(319),
    [sym__section5] = STATE(319),
    [sym__section6] = STATE(319),
    [sym_thematic_break] = STATE(46),
    [sym__atx_heading3] = STATE(49),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(46),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(46),
    [sym_html_block] = STATE(46),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(46),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(46),
    [sym_block_quote] = STATE(46),
    [sym_list] = STATE(46),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(46),
    [aux_sym__section2_repeat1] = STATE(46),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(398),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(398),
    [sym_atx_h2_marker] = ACTIONS(398),
    [sym_atx_h3_marker] = ACTIONS(21),
    [sym_atx_h4_marker] = ACTIONS(23),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [46] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(48),
    [sym__section3] = STATE(319),
    [sym__section4] = STATE(319),
    [sym__section5] = STATE(319),
    [sym__section6] = STATE(319),
    [sym_thematic_break] = STATE(48),
    [sym__atx_heading3] = STATE(49),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(48),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(48),
    [sym_html_block] = STATE(48),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(48),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(48),
    [sym_block_quote] = STATE(48),
    [sym_list] = STATE(48),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(48),
    [aux_sym__section2_repeat1] = STATE(48),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(483),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(483),
    [sym_atx_h2_marker] = ACTIONS(483),
    [sym_atx_h3_marker] = ACTIONS(21),
    [sym_atx_h4_marker] = ACTIONS(23),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [47] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(44),
    [sym__section3] = STATE(289),
    [sym__section4] = STATE(289),
    [sym__section5] = STATE(289),
    [sym__section6] = STATE(289),
    [sym_thematic_break] = STATE(44),
    [sym__atx_heading3] = STATE(53),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(44),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(44),
    [sym_html_block] = STATE(44),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(44),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(44),
    [sym_block_quote] = STATE(44),
    [sym_list] = STATE(44),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(44),
    [aux_sym__section2_repeat1] = STATE(44),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(483),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(483),
    [sym_atx_h2_marker] = ACTIONS(483),
    [sym_atx_h3_marker] = ACTIONS(81),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [48] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(48),
    [sym__section3] = STATE(319),
    [sym__section4] = STATE(319),
    [sym__section5] = STATE(319),
    [sym__section6] = STATE(319),
    [sym_thematic_break] = STATE(48),
    [sym__atx_heading3] = STATE(49),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(48),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(48),
    [sym_html_block] = STATE(48),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(48),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(48),
    [sym_block_quote] = STATE(48),
    [sym_list] = STATE(48),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(48),
    [aux_sym__section2_repeat1] = STATE(48),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(412),
    [anon_sym_LBRACK] = ACTIONS(400),
    [anon_sym_RBRACK] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(403),
    [anon_sym_GT] = ACTIONS(403),
    [anon_sym_BANG] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(403),
    [anon_sym_POUND] = ACTIONS(403),
    [anon_sym_DOLLAR] = ACTIONS(403),
    [anon_sym_PERCENT] = ACTIONS(403),
    [anon_sym_AMP] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(403),
    [anon_sym_STAR] = ACTIONS(403),
    [anon_sym_PLUS] = ACTIONS(403),
    [anon_sym_COMMA] = ACTIONS(403),
    [anon_sym_DASH] = ACTIONS(403),
    [anon_sym_DOT] = ACTIONS(403),
    [anon_sym_SLASH] = ACTIONS(403),
    [anon_sym_COLON] = ACTIONS(403),
    [anon_sym_SEMI] = ACTIONS(403),
    [anon_sym_EQ] = ACTIONS(403),
    [anon_sym_QMARK] = ACTIONS(403),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_BSLASH] = ACTIONS(403),
    [anon_sym_CARET] = ACTIONS(403),
    [anon_sym__] = ACTIONS(403),
    [anon_sym_BQUOTE] = ACTIONS(403),
    [anon_sym_LBRACE] = ACTIONS(403),
    [anon_sym_PIPE] = ACTIONS(403),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_RPAREN] = ACTIONS(403),
    [aux_sym__word_token1] = ACTIONS(403),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(403),
    [aux_sym__word_token2] = ACTIONS(403),
    [sym__whitespace] = ACTIONS(485),
    [sym__soft_line_ending] = ACTIONS(409),
    [sym__block_quote_start] = ACTIONS(488),
    [sym__indented_chunk_start] = ACTIONS(491),
    [sym_atx_h1_marker] = ACTIONS(412),
    [sym_atx_h2_marker] = ACTIONS(412),
    [sym_atx_h3_marker] = ACTIONS(494),
    [sym_atx_h4_marker] = ACTIONS(497),
    [sym_atx_h5_marker] = ACTIONS(500),
    [sym_atx_h6_marker] = ACTIONS(503),
    [sym__thematic_break] = ACTIONS(506),
    [sym__list_marker_minus] = ACTIONS(435),
    [sym__list_marker_plus] = ACTIONS(438),
    [sym__list_marker_star] = ACTIONS(441),
    [sym__list_marker_parenthesis] = ACTIONS(444),
    [sym__list_marker_dot] = ACTIONS(447),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(435),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(438),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(441),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(444),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(447),
    [sym__fenced_code_block_start_backtick] = ACTIONS(509),
    [sym__fenced_code_block_start_tilde] = ACTIONS(512),
    [sym__blank_line_start] = ACTIONS(515),
    [sym__html_block_1_start] = ACTIONS(518),
    [sym__html_block_2_start] = ACTIONS(521),
    [sym__html_block_3_start] = ACTIONS(524),
    [sym__html_block_4_start] = ACTIONS(527),
    [sym__html_block_5_start] = ACTIONS(530),
    [sym__html_block_6_start] = ACTIONS(533),
    [sym__html_block_7_start] = ACTIONS(536),
    [sym__pipe_table_start] = ACTIONS(539),
  },
  [49] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(51),
    [sym__section4] = STATE(260),
    [sym__section5] = STATE(260),
    [sym__section6] = STATE(260),
    [sym_thematic_break] = STATE(51),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(51),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(51),
    [sym_html_block] = STATE(51),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(51),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(51),
    [sym_block_quote] = STATE(51),
    [sym_list] = STATE(51),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(51),
    [aux_sym__section3_repeat1] = STATE(51),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(542),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(542),
    [sym_atx_h2_marker] = ACTIONS(542),
    [sym_atx_h3_marker] = ACTIONS(542),
    [sym_atx_h4_marker] = ACTIONS(23),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [50] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(52),
    [sym__section4] = STATE(285),
    [sym__section5] = STATE(285),
    [sym__section6] = STATE(285),
    [sym_thematic_break] = STATE(52),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(52),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(52),
    [sym_html_block] = STATE(52),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(52),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(52),
    [sym_block_quote] = STATE(52),
    [sym_list] = STATE(52),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(52),
    [aux_sym__section3_repeat1] = STATE(52),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(544),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(544),
    [sym_atx_h2_marker] = ACTIONS(544),
    [sym_atx_h3_marker] = ACTIONS(544),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [51] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(54),
    [sym__section4] = STATE(260),
    [sym__section5] = STATE(260),
    [sym__section6] = STATE(260),
    [sym_thematic_break] = STATE(54),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(54),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(54),
    [sym_html_block] = STATE(54),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(54),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(54),
    [sym_block_quote] = STATE(54),
    [sym_list] = STATE(54),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(54),
    [aux_sym__section3_repeat1] = STATE(54),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(544),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(544),
    [sym_atx_h2_marker] = ACTIONS(544),
    [sym_atx_h3_marker] = ACTIONS(544),
    [sym_atx_h4_marker] = ACTIONS(23),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [52] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(52),
    [sym__section4] = STATE(285),
    [sym__section5] = STATE(285),
    [sym__section6] = STATE(285),
    [sym_thematic_break] = STATE(52),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(52),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(52),
    [sym_html_block] = STATE(52),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(52),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(52),
    [sym_block_quote] = STATE(52),
    [sym_list] = STATE(52),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(52),
    [aux_sym__section3_repeat1] = STATE(52),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(546),
    [anon_sym_RBRACK] = ACTIONS(549),
    [anon_sym_LT] = ACTIONS(549),
    [anon_sym_GT] = ACTIONS(549),
    [anon_sym_BANG] = ACTIONS(549),
    [anon_sym_DQUOTE] = ACTIONS(549),
    [anon_sym_POUND] = ACTIONS(549),
    [anon_sym_DOLLAR] = ACTIONS(549),
    [anon_sym_PERCENT] = ACTIONS(549),
    [anon_sym_AMP] = ACTIONS(549),
    [anon_sym_SQUOTE] = ACTIONS(549),
    [anon_sym_STAR] = ACTIONS(549),
    [anon_sym_PLUS] = ACTIONS(549),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_DASH] = ACTIONS(549),
    [anon_sym_DOT] = ACTIONS(549),
    [anon_sym_SLASH] = ACTIONS(549),
    [anon_sym_COLON] = ACTIONS(549),
    [anon_sym_SEMI] = ACTIONS(549),
    [anon_sym_EQ] = ACTIONS(549),
    [anon_sym_QMARK] = ACTIONS(549),
    [anon_sym_AT] = ACTIONS(549),
    [anon_sym_BSLASH] = ACTIONS(549),
    [anon_sym_CARET] = ACTIONS(549),
    [anon_sym__] = ACTIONS(549),
    [anon_sym_BQUOTE] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_PIPE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(549),
    [anon_sym_TILDE] = ACTIONS(549),
    [anon_sym_LPAREN] = ACTIONS(549),
    [anon_sym_RPAREN] = ACTIONS(549),
    [aux_sym__word_token1] = ACTIONS(549),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(549),
    [aux_sym__word_token2] = ACTIONS(549),
    [sym__whitespace] = ACTIONS(552),
    [sym__soft_line_ending] = ACTIONS(555),
    [sym__block_close] = ACTIONS(558),
    [sym__block_quote_start] = ACTIONS(560),
    [sym__indented_chunk_start] = ACTIONS(563),
    [sym_atx_h1_marker] = ACTIONS(558),
    [sym_atx_h2_marker] = ACTIONS(558),
    [sym_atx_h3_marker] = ACTIONS(558),
    [sym_atx_h4_marker] = ACTIONS(566),
    [sym_atx_h5_marker] = ACTIONS(569),
    [sym_atx_h6_marker] = ACTIONS(572),
    [sym__thematic_break] = ACTIONS(575),
    [sym__list_marker_minus] = ACTIONS(578),
    [sym__list_marker_plus] = ACTIONS(581),
    [sym__list_marker_star] = ACTIONS(584),
    [sym__list_marker_parenthesis] = ACTIONS(587),
    [sym__list_marker_dot] = ACTIONS(590),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(578),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(581),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(584),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(587),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(590),
    [sym__fenced_code_block_start_backtick] = ACTIONS(593),
    [sym__fenced_code_block_start_tilde] = ACTIONS(596),
    [sym__blank_line_start] = ACTIONS(599),
    [sym__html_block_1_start] = ACTIONS(602),
    [sym__html_block_2_start] = ACTIONS(605),
    [sym__html_block_3_start] = ACTIONS(608),
    [sym__html_block_4_start] = ACTIONS(611),
    [sym__html_block_5_start] = ACTIONS(614),
    [sym__html_block_6_start] = ACTIONS(617),
    [sym__html_block_7_start] = ACTIONS(620),
    [sym__pipe_table_start] = ACTIONS(623),
  },
  [53] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(50),
    [sym__section4] = STATE(285),
    [sym__section5] = STATE(285),
    [sym__section6] = STATE(285),
    [sym_thematic_break] = STATE(50),
    [sym__atx_heading4] = STATE(59),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(50),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(50),
    [sym_html_block] = STATE(50),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(50),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(50),
    [sym_block_quote] = STATE(50),
    [sym_list] = STATE(50),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(50),
    [aux_sym__section3_repeat1] = STATE(50),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(542),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(542),
    [sym_atx_h2_marker] = ACTIONS(542),
    [sym_atx_h3_marker] = ACTIONS(542),
    [sym_atx_h4_marker] = ACTIONS(83),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [54] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(54),
    [sym__section4] = STATE(260),
    [sym__section5] = STATE(260),
    [sym__section6] = STATE(260),
    [sym_thematic_break] = STATE(54),
    [sym__atx_heading4] = STATE(60),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(54),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(54),
    [sym_html_block] = STATE(54),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(54),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(54),
    [sym_block_quote] = STATE(54),
    [sym_list] = STATE(54),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(54),
    [aux_sym__section3_repeat1] = STATE(54),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(558),
    [anon_sym_LBRACK] = ACTIONS(546),
    [anon_sym_RBRACK] = ACTIONS(549),
    [anon_sym_LT] = ACTIONS(549),
    [anon_sym_GT] = ACTIONS(549),
    [anon_sym_BANG] = ACTIONS(549),
    [anon_sym_DQUOTE] = ACTIONS(549),
    [anon_sym_POUND] = ACTIONS(549),
    [anon_sym_DOLLAR] = ACTIONS(549),
    [anon_sym_PERCENT] = ACTIONS(549),
    [anon_sym_AMP] = ACTIONS(549),
    [anon_sym_SQUOTE] = ACTIONS(549),
    [anon_sym_STAR] = ACTIONS(549),
    [anon_sym_PLUS] = ACTIONS(549),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_DASH] = ACTIONS(549),
    [anon_sym_DOT] = ACTIONS(549),
    [anon_sym_SLASH] = ACTIONS(549),
    [anon_sym_COLON] = ACTIONS(549),
    [anon_sym_SEMI] = ACTIONS(549),
    [anon_sym_EQ] = ACTIONS(549),
    [anon_sym_QMARK] = ACTIONS(549),
    [anon_sym_AT] = ACTIONS(549),
    [anon_sym_BSLASH] = ACTIONS(549),
    [anon_sym_CARET] = ACTIONS(549),
    [anon_sym__] = ACTIONS(549),
    [anon_sym_BQUOTE] = ACTIONS(549),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_PIPE] = ACTIONS(549),
    [anon_sym_RBRACE] = ACTIONS(549),
    [anon_sym_TILDE] = ACTIONS(549),
    [anon_sym_LPAREN] = ACTIONS(549),
    [anon_sym_RPAREN] = ACTIONS(549),
    [aux_sym__word_token1] = ACTIONS(549),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(549),
    [aux_sym__word_token2] = ACTIONS(549),
    [sym__whitespace] = ACTIONS(626),
    [sym__soft_line_ending] = ACTIONS(555),
    [sym__block_quote_start] = ACTIONS(629),
    [sym__indented_chunk_start] = ACTIONS(632),
    [sym_atx_h1_marker] = ACTIONS(558),
    [sym_atx_h2_marker] = ACTIONS(558),
    [sym_atx_h3_marker] = ACTIONS(558),
    [sym_atx_h4_marker] = ACTIONS(635),
    [sym_atx_h5_marker] = ACTIONS(638),
    [sym_atx_h6_marker] = ACTIONS(641),
    [sym__thematic_break] = ACTIONS(644),
    [sym__list_marker_minus] = ACTIONS(578),
    [sym__list_marker_plus] = ACTIONS(581),
    [sym__list_marker_star] = ACTIONS(584),
    [sym__list_marker_parenthesis] = ACTIONS(587),
    [sym__list_marker_dot] = ACTIONS(590),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(578),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(581),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(584),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(587),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(590),
    [sym__fenced_code_block_start_backtick] = ACTIONS(647),
    [sym__fenced_code_block_start_tilde] = ACTIONS(650),
    [sym__blank_line_start] = ACTIONS(653),
    [sym__html_block_1_start] = ACTIONS(656),
    [sym__html_block_2_start] = ACTIONS(659),
    [sym__html_block_3_start] = ACTIONS(662),
    [sym__html_block_4_start] = ACTIONS(665),
    [sym__html_block_5_start] = ACTIONS(668),
    [sym__html_block_6_start] = ACTIONS(671),
    [sym__html_block_7_start] = ACTIONS(674),
    [sym__pipe_table_start] = ACTIONS(677),
  },
  [55] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(56),
    [sym__section5] = STATE(279),
    [sym__section6] = STATE(279),
    [sym_thematic_break] = STATE(56),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(56),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(56),
    [sym_html_block] = STATE(56),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(56),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(56),
    [sym_block_quote] = STATE(56),
    [sym_list] = STATE(56),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(56),
    [aux_sym__section4_repeat1] = STATE(56),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(680),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(680),
    [sym_atx_h2_marker] = ACTIONS(680),
    [sym_atx_h3_marker] = ACTIONS(680),
    [sym_atx_h4_marker] = ACTIONS(680),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [56] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(56),
    [sym__section5] = STATE(279),
    [sym__section6] = STATE(279),
    [sym_thematic_break] = STATE(56),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(56),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(56),
    [sym_html_block] = STATE(56),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(56),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(56),
    [sym_block_quote] = STATE(56),
    [sym_list] = STATE(56),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(56),
    [aux_sym__section4_repeat1] = STATE(56),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(682),
    [anon_sym_RBRACK] = ACTIONS(685),
    [anon_sym_LT] = ACTIONS(685),
    [anon_sym_GT] = ACTIONS(685),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_DQUOTE] = ACTIONS(685),
    [anon_sym_POUND] = ACTIONS(685),
    [anon_sym_DOLLAR] = ACTIONS(685),
    [anon_sym_PERCENT] = ACTIONS(685),
    [anon_sym_AMP] = ACTIONS(685),
    [anon_sym_SQUOTE] = ACTIONS(685),
    [anon_sym_STAR] = ACTIONS(685),
    [anon_sym_PLUS] = ACTIONS(685),
    [anon_sym_COMMA] = ACTIONS(685),
    [anon_sym_DASH] = ACTIONS(685),
    [anon_sym_DOT] = ACTIONS(685),
    [anon_sym_SLASH] = ACTIONS(685),
    [anon_sym_COLON] = ACTIONS(685),
    [anon_sym_SEMI] = ACTIONS(685),
    [anon_sym_EQ] = ACTIONS(685),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(685),
    [anon_sym_BSLASH] = ACTIONS(685),
    [anon_sym_CARET] = ACTIONS(685),
    [anon_sym__] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(685),
    [anon_sym_LBRACE] = ACTIONS(685),
    [anon_sym_PIPE] = ACTIONS(685),
    [anon_sym_RBRACE] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(685),
    [anon_sym_LPAREN] = ACTIONS(685),
    [anon_sym_RPAREN] = ACTIONS(685),
    [aux_sym__word_token1] = ACTIONS(685),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(685),
    [aux_sym__word_token2] = ACTIONS(685),
    [sym__whitespace] = ACTIONS(688),
    [sym__soft_line_ending] = ACTIONS(691),
    [sym__block_close] = ACTIONS(694),
    [sym__block_quote_start] = ACTIONS(696),
    [sym__indented_chunk_start] = ACTIONS(699),
    [sym_atx_h1_marker] = ACTIONS(694),
    [sym_atx_h2_marker] = ACTIONS(694),
    [sym_atx_h3_marker] = ACTIONS(694),
    [sym_atx_h4_marker] = ACTIONS(694),
    [sym_atx_h5_marker] = ACTIONS(702),
    [sym_atx_h6_marker] = ACTIONS(705),
    [sym__thematic_break] = ACTIONS(708),
    [sym__list_marker_minus] = ACTIONS(711),
    [sym__list_marker_plus] = ACTIONS(714),
    [sym__list_marker_star] = ACTIONS(717),
    [sym__list_marker_parenthesis] = ACTIONS(720),
    [sym__list_marker_dot] = ACTIONS(723),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(711),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(714),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(717),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(720),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(723),
    [sym__fenced_code_block_start_backtick] = ACTIONS(726),
    [sym__fenced_code_block_start_tilde] = ACTIONS(729),
    [sym__blank_line_start] = ACTIONS(732),
    [sym__html_block_1_start] = ACTIONS(735),
    [sym__html_block_2_start] = ACTIONS(738),
    [sym__html_block_3_start] = ACTIONS(741),
    [sym__html_block_4_start] = ACTIONS(744),
    [sym__html_block_5_start] = ACTIONS(747),
    [sym__html_block_6_start] = ACTIONS(750),
    [sym__html_block_7_start] = ACTIONS(753),
    [sym__pipe_table_start] = ACTIONS(756),
  },
  [57] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(58),
    [sym__section5] = STATE(294),
    [sym__section6] = STATE(294),
    [sym_thematic_break] = STATE(58),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(58),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(58),
    [sym_html_block] = STATE(58),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(58),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(58),
    [sym_block_quote] = STATE(58),
    [sym_list] = STATE(58),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(58),
    [aux_sym__section4_repeat1] = STATE(58),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(680),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(680),
    [sym_atx_h2_marker] = ACTIONS(680),
    [sym_atx_h3_marker] = ACTIONS(680),
    [sym_atx_h4_marker] = ACTIONS(680),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [58] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(58),
    [sym__section5] = STATE(294),
    [sym__section6] = STATE(294),
    [sym_thematic_break] = STATE(58),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(58),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(58),
    [sym_html_block] = STATE(58),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(58),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(58),
    [sym_block_quote] = STATE(58),
    [sym_list] = STATE(58),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(58),
    [aux_sym__section4_repeat1] = STATE(58),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(694),
    [anon_sym_LBRACK] = ACTIONS(682),
    [anon_sym_RBRACK] = ACTIONS(685),
    [anon_sym_LT] = ACTIONS(685),
    [anon_sym_GT] = ACTIONS(685),
    [anon_sym_BANG] = ACTIONS(685),
    [anon_sym_DQUOTE] = ACTIONS(685),
    [anon_sym_POUND] = ACTIONS(685),
    [anon_sym_DOLLAR] = ACTIONS(685),
    [anon_sym_PERCENT] = ACTIONS(685),
    [anon_sym_AMP] = ACTIONS(685),
    [anon_sym_SQUOTE] = ACTIONS(685),
    [anon_sym_STAR] = ACTIONS(685),
    [anon_sym_PLUS] = ACTIONS(685),
    [anon_sym_COMMA] = ACTIONS(685),
    [anon_sym_DASH] = ACTIONS(685),
    [anon_sym_DOT] = ACTIONS(685),
    [anon_sym_SLASH] = ACTIONS(685),
    [anon_sym_COLON] = ACTIONS(685),
    [anon_sym_SEMI] = ACTIONS(685),
    [anon_sym_EQ] = ACTIONS(685),
    [anon_sym_QMARK] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(685),
    [anon_sym_BSLASH] = ACTIONS(685),
    [anon_sym_CARET] = ACTIONS(685),
    [anon_sym__] = ACTIONS(685),
    [anon_sym_BQUOTE] = ACTIONS(685),
    [anon_sym_LBRACE] = ACTIONS(685),
    [anon_sym_PIPE] = ACTIONS(685),
    [anon_sym_RBRACE] = ACTIONS(685),
    [anon_sym_TILDE] = ACTIONS(685),
    [anon_sym_LPAREN] = ACTIONS(685),
    [anon_sym_RPAREN] = ACTIONS(685),
    [aux_sym__word_token1] = ACTIONS(685),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(685),
    [aux_sym__word_token2] = ACTIONS(685),
    [sym__whitespace] = ACTIONS(759),
    [sym__soft_line_ending] = ACTIONS(691),
    [sym__block_quote_start] = ACTIONS(762),
    [sym__indented_chunk_start] = ACTIONS(765),
    [sym_atx_h1_marker] = ACTIONS(694),
    [sym_atx_h2_marker] = ACTIONS(694),
    [sym_atx_h3_marker] = ACTIONS(694),
    [sym_atx_h4_marker] = ACTIONS(694),
    [sym_atx_h5_marker] = ACTIONS(768),
    [sym_atx_h6_marker] = ACTIONS(771),
    [sym__thematic_break] = ACTIONS(774),
    [sym__list_marker_minus] = ACTIONS(711),
    [sym__list_marker_plus] = ACTIONS(714),
    [sym__list_marker_star] = ACTIONS(717),
    [sym__list_marker_parenthesis] = ACTIONS(720),
    [sym__list_marker_dot] = ACTIONS(723),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(711),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(714),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(717),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(720),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(723),
    [sym__fenced_code_block_start_backtick] = ACTIONS(777),
    [sym__fenced_code_block_start_tilde] = ACTIONS(780),
    [sym__blank_line_start] = ACTIONS(783),
    [sym__html_block_1_start] = ACTIONS(786),
    [sym__html_block_2_start] = ACTIONS(789),
    [sym__html_block_3_start] = ACTIONS(792),
    [sym__html_block_4_start] = ACTIONS(795),
    [sym__html_block_5_start] = ACTIONS(798),
    [sym__html_block_6_start] = ACTIONS(801),
    [sym__html_block_7_start] = ACTIONS(804),
    [sym__pipe_table_start] = ACTIONS(807),
  },
  [59] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(55),
    [sym__section5] = STATE(279),
    [sym__section6] = STATE(279),
    [sym_thematic_break] = STATE(55),
    [sym__atx_heading5] = STATE(64),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(55),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(55),
    [sym_html_block] = STATE(55),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(55),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(55),
    [sym_block_quote] = STATE(55),
    [sym_list] = STATE(55),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(55),
    [aux_sym__section4_repeat1] = STATE(55),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(810),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(810),
    [sym_atx_h2_marker] = ACTIONS(810),
    [sym_atx_h3_marker] = ACTIONS(810),
    [sym_atx_h4_marker] = ACTIONS(810),
    [sym_atx_h5_marker] = ACTIONS(85),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [60] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(57),
    [sym__section5] = STATE(294),
    [sym__section6] = STATE(294),
    [sym_thematic_break] = STATE(57),
    [sym__atx_heading5] = STATE(65),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(57),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(57),
    [sym_html_block] = STATE(57),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(57),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(57),
    [sym_block_quote] = STATE(57),
    [sym_list] = STATE(57),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(57),
    [aux_sym__section4_repeat1] = STATE(57),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(810),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(810),
    [sym_atx_h2_marker] = ACTIONS(810),
    [sym_atx_h3_marker] = ACTIONS(810),
    [sym_atx_h4_marker] = ACTIONS(810),
    [sym_atx_h5_marker] = ACTIONS(25),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [61] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(63),
    [sym__section6] = STATE(268),
    [sym_thematic_break] = STATE(63),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(63),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(63),
    [sym_html_block] = STATE(63),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(63),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(63),
    [sym_block_quote] = STATE(63),
    [sym_list] = STATE(63),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(63),
    [aux_sym__section5_repeat1] = STATE(63),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(812),
    [sym_atx_h2_marker] = ACTIONS(812),
    [sym_atx_h3_marker] = ACTIONS(812),
    [sym_atx_h4_marker] = ACTIONS(812),
    [sym_atx_h5_marker] = ACTIONS(812),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [62] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(62),
    [sym__section6] = STATE(277),
    [sym_thematic_break] = STATE(62),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(62),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(62),
    [sym_html_block] = STATE(62),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(62),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(62),
    [sym_block_quote] = STATE(62),
    [sym_list] = STATE(62),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(62),
    [aux_sym__section5_repeat1] = STATE(62),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(814),
    [anon_sym_RBRACK] = ACTIONS(817),
    [anon_sym_LT] = ACTIONS(817),
    [anon_sym_GT] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(817),
    [anon_sym_DQUOTE] = ACTIONS(817),
    [anon_sym_POUND] = ACTIONS(817),
    [anon_sym_DOLLAR] = ACTIONS(817),
    [anon_sym_PERCENT] = ACTIONS(817),
    [anon_sym_AMP] = ACTIONS(817),
    [anon_sym_SQUOTE] = ACTIONS(817),
    [anon_sym_STAR] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_COMMA] = ACTIONS(817),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_DOT] = ACTIONS(817),
    [anon_sym_SLASH] = ACTIONS(817),
    [anon_sym_COLON] = ACTIONS(817),
    [anon_sym_SEMI] = ACTIONS(817),
    [anon_sym_EQ] = ACTIONS(817),
    [anon_sym_QMARK] = ACTIONS(817),
    [anon_sym_AT] = ACTIONS(817),
    [anon_sym_BSLASH] = ACTIONS(817),
    [anon_sym_CARET] = ACTIONS(817),
    [anon_sym__] = ACTIONS(817),
    [anon_sym_BQUOTE] = ACTIONS(817),
    [anon_sym_LBRACE] = ACTIONS(817),
    [anon_sym_PIPE] = ACTIONS(817),
    [anon_sym_RBRACE] = ACTIONS(817),
    [anon_sym_TILDE] = ACTIONS(817),
    [anon_sym_LPAREN] = ACTIONS(817),
    [anon_sym_RPAREN] = ACTIONS(817),
    [aux_sym__word_token1] = ACTIONS(817),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(817),
    [aux_sym__word_token2] = ACTIONS(817),
    [sym__whitespace] = ACTIONS(820),
    [sym__soft_line_ending] = ACTIONS(823),
    [sym__block_close] = ACTIONS(826),
    [sym__block_quote_start] = ACTIONS(828),
    [sym__indented_chunk_start] = ACTIONS(831),
    [sym_atx_h1_marker] = ACTIONS(826),
    [sym_atx_h2_marker] = ACTIONS(826),
    [sym_atx_h3_marker] = ACTIONS(826),
    [sym_atx_h4_marker] = ACTIONS(826),
    [sym_atx_h5_marker] = ACTIONS(826),
    [sym_atx_h6_marker] = ACTIONS(834),
    [sym__thematic_break] = ACTIONS(837),
    [sym__list_marker_minus] = ACTIONS(840),
    [sym__list_marker_plus] = ACTIONS(843),
    [sym__list_marker_star] = ACTIONS(846),
    [sym__list_marker_parenthesis] = ACTIONS(849),
    [sym__list_marker_dot] = ACTIONS(852),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(840),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(843),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(846),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(849),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(852),
    [sym__fenced_code_block_start_backtick] = ACTIONS(855),
    [sym__fenced_code_block_start_tilde] = ACTIONS(858),
    [sym__blank_line_start] = ACTIONS(861),
    [sym__html_block_1_start] = ACTIONS(864),
    [sym__html_block_2_start] = ACTIONS(867),
    [sym__html_block_3_start] = ACTIONS(870),
    [sym__html_block_4_start] = ACTIONS(873),
    [sym__html_block_5_start] = ACTIONS(876),
    [sym__html_block_6_start] = ACTIONS(879),
    [sym__html_block_7_start] = ACTIONS(882),
    [sym__pipe_table_start] = ACTIONS(885),
  },
  [63] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(63),
    [sym__section6] = STATE(268),
    [sym_thematic_break] = STATE(63),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(63),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(63),
    [sym_html_block] = STATE(63),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(63),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(63),
    [sym_block_quote] = STATE(63),
    [sym_list] = STATE(63),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(63),
    [aux_sym__section5_repeat1] = STATE(63),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(826),
    [anon_sym_LBRACK] = ACTIONS(814),
    [anon_sym_RBRACK] = ACTIONS(817),
    [anon_sym_LT] = ACTIONS(817),
    [anon_sym_GT] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(817),
    [anon_sym_DQUOTE] = ACTIONS(817),
    [anon_sym_POUND] = ACTIONS(817),
    [anon_sym_DOLLAR] = ACTIONS(817),
    [anon_sym_PERCENT] = ACTIONS(817),
    [anon_sym_AMP] = ACTIONS(817),
    [anon_sym_SQUOTE] = ACTIONS(817),
    [anon_sym_STAR] = ACTIONS(817),
    [anon_sym_PLUS] = ACTIONS(817),
    [anon_sym_COMMA] = ACTIONS(817),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_DOT] = ACTIONS(817),
    [anon_sym_SLASH] = ACTIONS(817),
    [anon_sym_COLON] = ACTIONS(817),
    [anon_sym_SEMI] = ACTIONS(817),
    [anon_sym_EQ] = ACTIONS(817),
    [anon_sym_QMARK] = ACTIONS(817),
    [anon_sym_AT] = ACTIONS(817),
    [anon_sym_BSLASH] = ACTIONS(817),
    [anon_sym_CARET] = ACTIONS(817),
    [anon_sym__] = ACTIONS(817),
    [anon_sym_BQUOTE] = ACTIONS(817),
    [anon_sym_LBRACE] = ACTIONS(817),
    [anon_sym_PIPE] = ACTIONS(817),
    [anon_sym_RBRACE] = ACTIONS(817),
    [anon_sym_TILDE] = ACTIONS(817),
    [anon_sym_LPAREN] = ACTIONS(817),
    [anon_sym_RPAREN] = ACTIONS(817),
    [aux_sym__word_token1] = ACTIONS(817),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(817),
    [aux_sym__word_token2] = ACTIONS(817),
    [sym__whitespace] = ACTIONS(888),
    [sym__soft_line_ending] = ACTIONS(823),
    [sym__block_quote_start] = ACTIONS(891),
    [sym__indented_chunk_start] = ACTIONS(894),
    [sym_atx_h1_marker] = ACTIONS(826),
    [sym_atx_h2_marker] = ACTIONS(826),
    [sym_atx_h3_marker] = ACTIONS(826),
    [sym_atx_h4_marker] = ACTIONS(826),
    [sym_atx_h5_marker] = ACTIONS(826),
    [sym_atx_h6_marker] = ACTIONS(897),
    [sym__thematic_break] = ACTIONS(900),
    [sym__list_marker_minus] = ACTIONS(840),
    [sym__list_marker_plus] = ACTIONS(843),
    [sym__list_marker_star] = ACTIONS(846),
    [sym__list_marker_parenthesis] = ACTIONS(849),
    [sym__list_marker_dot] = ACTIONS(852),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(840),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(843),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(846),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(849),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(852),
    [sym__fenced_code_block_start_backtick] = ACTIONS(903),
    [sym__fenced_code_block_start_tilde] = ACTIONS(906),
    [sym__blank_line_start] = ACTIONS(909),
    [sym__html_block_1_start] = ACTIONS(912),
    [sym__html_block_2_start] = ACTIONS(915),
    [sym__html_block_3_start] = ACTIONS(918),
    [sym__html_block_4_start] = ACTIONS(921),
    [sym__html_block_5_start] = ACTIONS(924),
    [sym__html_block_6_start] = ACTIONS(927),
    [sym__html_block_7_start] = ACTIONS(930),
    [sym__pipe_table_start] = ACTIONS(933),
  },
  [64] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(66),
    [sym__section6] = STATE(277),
    [sym_thematic_break] = STATE(66),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(66),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(66),
    [sym_html_block] = STATE(66),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(66),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(66),
    [sym_block_quote] = STATE(66),
    [sym_list] = STATE(66),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(66),
    [aux_sym__section5_repeat1] = STATE(66),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(936),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(936),
    [sym_atx_h2_marker] = ACTIONS(936),
    [sym_atx_h3_marker] = ACTIONS(936),
    [sym_atx_h4_marker] = ACTIONS(936),
    [sym_atx_h5_marker] = ACTIONS(936),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [65] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(61),
    [sym__section6] = STATE(268),
    [sym_thematic_break] = STATE(61),
    [sym__atx_heading6] = STATE(70),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(61),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(61),
    [sym_html_block] = STATE(61),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(61),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(61),
    [sym_block_quote] = STATE(61),
    [sym_list] = STATE(61),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(61),
    [aux_sym__section5_repeat1] = STATE(61),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(936),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(936),
    [sym_atx_h2_marker] = ACTIONS(936),
    [sym_atx_h3_marker] = ACTIONS(936),
    [sym_atx_h4_marker] = ACTIONS(936),
    [sym_atx_h5_marker] = ACTIONS(936),
    [sym_atx_h6_marker] = ACTIONS(27),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [66] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(62),
    [sym__section6] = STATE(277),
    [sym_thematic_break] = STATE(62),
    [sym__atx_heading6] = STATE(72),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(62),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(62),
    [sym_html_block] = STATE(62),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(62),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(62),
    [sym_block_quote] = STATE(62),
    [sym_list] = STATE(62),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(62),
    [aux_sym__section5_repeat1] = STATE(62),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(812),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(812),
    [sym_atx_h2_marker] = ACTIONS(812),
    [sym_atx_h3_marker] = ACTIONS(812),
    [sym_atx_h4_marker] = ACTIONS(812),
    [sym_atx_h5_marker] = ACTIONS(812),
    [sym_atx_h6_marker] = ACTIONS(87),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [67] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(258),
    [sym_thematic_break] = STATE(258),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(258),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(258),
    [sym_html_block] = STATE(258),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(258),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(258),
    [sym_block_quote] = STATE(258),
    [sym_list] = STATE(258),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(258),
    [aux_sym_document_repeat1] = STATE(68),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(938),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(938),
    [sym_atx_h2_marker] = ACTIONS(938),
    [sym_atx_h3_marker] = ACTIONS(938),
    [sym_atx_h4_marker] = ACTIONS(938),
    [sym_atx_h5_marker] = ACTIONS(938),
    [sym_atx_h6_marker] = ACTIONS(938),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [68] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(258),
    [sym_thematic_break] = STATE(258),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(258),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(258),
    [sym_html_block] = STATE(258),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(258),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(258),
    [sym_block_quote] = STATE(258),
    [sym_list] = STATE(258),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(258),
    [aux_sym_document_repeat1] = STATE(68),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(940),
    [anon_sym_LBRACK] = ACTIONS(942),
    [anon_sym_RBRACK] = ACTIONS(945),
    [anon_sym_LT] = ACTIONS(945),
    [anon_sym_GT] = ACTIONS(945),
    [anon_sym_BANG] = ACTIONS(945),
    [anon_sym_DQUOTE] = ACTIONS(945),
    [anon_sym_POUND] = ACTIONS(945),
    [anon_sym_DOLLAR] = ACTIONS(945),
    [anon_sym_PERCENT] = ACTIONS(945),
    [anon_sym_AMP] = ACTIONS(945),
    [anon_sym_SQUOTE] = ACTIONS(945),
    [anon_sym_STAR] = ACTIONS(945),
    [anon_sym_PLUS] = ACTIONS(945),
    [anon_sym_COMMA] = ACTIONS(945),
    [anon_sym_DASH] = ACTIONS(945),
    [anon_sym_DOT] = ACTIONS(945),
    [anon_sym_SLASH] = ACTIONS(945),
    [anon_sym_COLON] = ACTIONS(945),
    [anon_sym_SEMI] = ACTIONS(945),
    [anon_sym_EQ] = ACTIONS(945),
    [anon_sym_QMARK] = ACTIONS(945),
    [anon_sym_AT] = ACTIONS(945),
    [anon_sym_BSLASH] = ACTIONS(945),
    [anon_sym_CARET] = ACTIONS(945),
    [anon_sym__] = ACTIONS(945),
    [anon_sym_BQUOTE] = ACTIONS(945),
    [anon_sym_LBRACE] = ACTIONS(945),
    [anon_sym_PIPE] = ACTIONS(945),
    [anon_sym_RBRACE] = ACTIONS(945),
    [anon_sym_TILDE] = ACTIONS(945),
    [anon_sym_LPAREN] = ACTIONS(945),
    [anon_sym_RPAREN] = ACTIONS(945),
    [aux_sym__word_token1] = ACTIONS(945),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(945),
    [aux_sym__word_token2] = ACTIONS(945),
    [sym__whitespace] = ACTIONS(948),
    [sym__soft_line_ending] = ACTIONS(951),
    [sym__block_quote_start] = ACTIONS(954),
    [sym__indented_chunk_start] = ACTIONS(957),
    [sym_atx_h1_marker] = ACTIONS(940),
    [sym_atx_h2_marker] = ACTIONS(940),
    [sym_atx_h3_marker] = ACTIONS(940),
    [sym_atx_h4_marker] = ACTIONS(940),
    [sym_atx_h5_marker] = ACTIONS(940),
    [sym_atx_h6_marker] = ACTIONS(940),
    [sym__thematic_break] = ACTIONS(960),
    [sym__list_marker_minus] = ACTIONS(963),
    [sym__list_marker_plus] = ACTIONS(966),
    [sym__list_marker_star] = ACTIONS(969),
    [sym__list_marker_parenthesis] = ACTIONS(972),
    [sym__list_marker_dot] = ACTIONS(975),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(963),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(966),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(969),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(972),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(975),
    [sym__fenced_code_block_start_backtick] = ACTIONS(978),
    [sym__fenced_code_block_start_tilde] = ACTIONS(981),
    [sym__blank_line_start] = ACTIONS(984),
    [sym__html_block_1_start] = ACTIONS(987),
    [sym__html_block_2_start] = ACTIONS(990),
    [sym__html_block_3_start] = ACTIONS(993),
    [sym__html_block_4_start] = ACTIONS(996),
    [sym__html_block_5_start] = ACTIONS(999),
    [sym__html_block_6_start] = ACTIONS(1002),
    [sym__html_block_7_start] = ACTIONS(1005),
    [sym__pipe_table_start] = ACTIONS(1008),
  },
  [69] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(312),
    [sym_thematic_break] = STATE(312),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(312),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(312),
    [sym_html_block] = STATE(312),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(312),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(312),
    [sym_block_quote] = STATE(312),
    [sym_list] = STATE(312),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(312),
    [aux_sym_document_repeat1] = STATE(69),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(942),
    [anon_sym_RBRACK] = ACTIONS(945),
    [anon_sym_LT] = ACTIONS(945),
    [anon_sym_GT] = ACTIONS(945),
    [anon_sym_BANG] = ACTIONS(945),
    [anon_sym_DQUOTE] = ACTIONS(945),
    [anon_sym_POUND] = ACTIONS(945),
    [anon_sym_DOLLAR] = ACTIONS(945),
    [anon_sym_PERCENT] = ACTIONS(945),
    [anon_sym_AMP] = ACTIONS(945),
    [anon_sym_SQUOTE] = ACTIONS(945),
    [anon_sym_STAR] = ACTIONS(945),
    [anon_sym_PLUS] = ACTIONS(945),
    [anon_sym_COMMA] = ACTIONS(945),
    [anon_sym_DASH] = ACTIONS(945),
    [anon_sym_DOT] = ACTIONS(945),
    [anon_sym_SLASH] = ACTIONS(945),
    [anon_sym_COLON] = ACTIONS(945),
    [anon_sym_SEMI] = ACTIONS(945),
    [anon_sym_EQ] = ACTIONS(945),
    [anon_sym_QMARK] = ACTIONS(945),
    [anon_sym_AT] = ACTIONS(945),
    [anon_sym_BSLASH] = ACTIONS(945),
    [anon_sym_CARET] = ACTIONS(945),
    [anon_sym__] = ACTIONS(945),
    [anon_sym_BQUOTE] = ACTIONS(945),
    [anon_sym_LBRACE] = ACTIONS(945),
    [anon_sym_PIPE] = ACTIONS(945),
    [anon_sym_RBRACE] = ACTIONS(945),
    [anon_sym_TILDE] = ACTIONS(945),
    [anon_sym_LPAREN] = ACTIONS(945),
    [anon_sym_RPAREN] = ACTIONS(945),
    [aux_sym__word_token1] = ACTIONS(945),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(945),
    [aux_sym__word_token2] = ACTIONS(945),
    [sym__whitespace] = ACTIONS(1011),
    [sym__soft_line_ending] = ACTIONS(951),
    [sym__block_close] = ACTIONS(940),
    [sym__block_quote_start] = ACTIONS(1014),
    [sym__indented_chunk_start] = ACTIONS(1017),
    [sym_atx_h1_marker] = ACTIONS(940),
    [sym_atx_h2_marker] = ACTIONS(940),
    [sym_atx_h3_marker] = ACTIONS(940),
    [sym_atx_h4_marker] = ACTIONS(940),
    [sym_atx_h5_marker] = ACTIONS(940),
    [sym_atx_h6_marker] = ACTIONS(940),
    [sym__thematic_break] = ACTIONS(1020),
    [sym__list_marker_minus] = ACTIONS(963),
    [sym__list_marker_plus] = ACTIONS(966),
    [sym__list_marker_star] = ACTIONS(969),
    [sym__list_marker_parenthesis] = ACTIONS(972),
    [sym__list_marker_dot] = ACTIONS(975),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(963),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(966),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(969),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(972),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(975),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1023),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1026),
    [sym__blank_line_start] = ACTIONS(1029),
    [sym__html_block_1_start] = ACTIONS(1032),
    [sym__html_block_2_start] = ACTIONS(1035),
    [sym__html_block_3_start] = ACTIONS(1038),
    [sym__html_block_4_start] = ACTIONS(1041),
    [sym__html_block_5_start] = ACTIONS(1044),
    [sym__html_block_6_start] = ACTIONS(1047),
    [sym__html_block_7_start] = ACTIONS(1050),
    [sym__pipe_table_start] = ACTIONS(1053),
  },
  [70] = {
    [sym_link_label] = STATE(905),
    [sym__block_not_section] = STATE(258),
    [sym_thematic_break] = STATE(258),
    [sym__setext_heading1] = STATE(335),
    [sym__setext_heading2] = STATE(274),
    [sym_indented_code_block] = STATE(258),
    [sym__indented_chunk] = STATE(97),
    [sym_fenced_code_block] = STATE(258),
    [sym_html_block] = STATE(258),
    [sym__html_block_1] = STATE(275),
    [sym__html_block_2] = STATE(275),
    [sym__html_block_3] = STATE(275),
    [sym__html_block_4] = STATE(275),
    [sym__html_block_5] = STATE(275),
    [sym__html_block_6] = STATE(275),
    [sym__html_block_7] = STATE(275),
    [sym_link_reference_definition] = STATE(258),
    [sym_paragraph] = STATE(111),
    [sym__blank_line] = STATE(258),
    [sym_block_quote] = STATE(258),
    [sym_list] = STATE(258),
    [sym__list_plus] = STATE(276),
    [sym__list_minus] = STATE(276),
    [sym__list_star] = STATE(276),
    [sym__list_dot] = STATE(276),
    [sym__list_parenthesis] = STATE(276),
    [sym_list_marker_plus] = STATE(10),
    [sym_list_marker_minus] = STATE(9),
    [sym_list_marker_star] = STATE(8),
    [sym_list_marker_dot] = STATE(5),
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_plus] = STATE(98),
    [sym__list_item_minus] = STATE(75),
    [sym__list_item_star] = STATE(94),
    [sym__list_item_dot] = STATE(83),
    [sym__list_item_parenthesis] = STATE(91),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(258),
    [aux_sym_document_repeat1] = STATE(67),
    [aux_sym_paragraph_repeat1] = STATE(369),
    [aux_sym__list_plus_repeat1] = STATE(98),
    [aux_sym__list_minus_repeat1] = STATE(75),
    [aux_sym__list_star_repeat1] = STATE(94),
    [aux_sym__list_dot_repeat1] = STATE(83),
    [aux_sym__list_parenthesis_repeat1] = STATE(91),
    [aux_sym__line_repeat1] = STATE(533),
    [ts_builtin_sym_end] = ACTIONS(1056),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(9),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_quote_start] = ACTIONS(13),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(1056),
    [sym_atx_h2_marker] = ACTIONS(1056),
    [sym_atx_h3_marker] = ACTIONS(1056),
    [sym_atx_h4_marker] = ACTIONS(1056),
    [sym_atx_h5_marker] = ACTIONS(1056),
    [sym_atx_h6_marker] = ACTIONS(1056),
    [sym__thematic_break] = ACTIONS(29),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(41),
    [sym__fenced_code_block_start_tilde] = ACTIONS(43),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(47),
    [sym__html_block_2_start] = ACTIONS(49),
    [sym__html_block_3_start] = ACTIONS(51),
    [sym__html_block_4_start] = ACTIONS(53),
    [sym__html_block_5_start] = ACTIONS(55),
    [sym__html_block_6_start] = ACTIONS(57),
    [sym__html_block_7_start] = ACTIONS(59),
    [sym__pipe_table_start] = ACTIONS(63),
  },
  [71] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(312),
    [sym_thematic_break] = STATE(312),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(312),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(312),
    [sym_html_block] = STATE(312),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(312),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(312),
    [sym_block_quote] = STATE(312),
    [sym_list] = STATE(312),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(312),
    [aux_sym_document_repeat1] = STATE(69),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(938),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(938),
    [sym_atx_h2_marker] = ACTIONS(938),
    [sym_atx_h3_marker] = ACTIONS(938),
    [sym_atx_h4_marker] = ACTIONS(938),
    [sym_atx_h5_marker] = ACTIONS(938),
    [sym_atx_h6_marker] = ACTIONS(938),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [72] = {
    [sym_link_label] = STATE(912),
    [sym__block_not_section] = STATE(312),
    [sym_thematic_break] = STATE(312),
    [sym__setext_heading1] = STATE(309),
    [sym__setext_heading2] = STATE(308),
    [sym_indented_code_block] = STATE(312),
    [sym__indented_chunk] = STATE(90),
    [sym_fenced_code_block] = STATE(312),
    [sym_html_block] = STATE(312),
    [sym__html_block_1] = STATE(307),
    [sym__html_block_2] = STATE(307),
    [sym__html_block_3] = STATE(307),
    [sym__html_block_4] = STATE(307),
    [sym__html_block_5] = STATE(307),
    [sym__html_block_6] = STATE(307),
    [sym__html_block_7] = STATE(307),
    [sym_link_reference_definition] = STATE(312),
    [sym_paragraph] = STATE(113),
    [sym__blank_line] = STATE(312),
    [sym_block_quote] = STATE(312),
    [sym_list] = STATE(312),
    [sym__list_plus] = STATE(306),
    [sym__list_minus] = STATE(306),
    [sym__list_star] = STATE(306),
    [sym__list_dot] = STATE(306),
    [sym__list_parenthesis] = STATE(306),
    [sym_list_marker_plus] = STATE(4),
    [sym_list_marker_minus] = STATE(11),
    [sym_list_marker_star] = STATE(6),
    [sym_list_marker_dot] = STATE(7),
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_plus] = STATE(88),
    [sym__list_item_minus] = STATE(87),
    [sym__list_item_star] = STATE(86),
    [sym__list_item_dot] = STATE(85),
    [sym__list_item_parenthesis] = STATE(84),
    [sym__soft_line_break] = STATE(605),
    [sym__line] = STATE(605),
    [sym__word] = STATE(533),
    [sym_pipe_table] = STATE(312),
    [aux_sym_document_repeat1] = STATE(71),
    [aux_sym_paragraph_repeat1] = STATE(370),
    [aux_sym__list_plus_repeat1] = STATE(88),
    [aux_sym__list_minus_repeat1] = STATE(87),
    [aux_sym__list_star_repeat1] = STATE(86),
    [aux_sym__list_dot_repeat1] = STATE(85),
    [aux_sym__list_parenthesis_repeat1] = STATE(84),
    [aux_sym__line_repeat1] = STATE(533),
    [anon_sym_LBRACK] = ACTIONS(5),
    [anon_sym_RBRACK] = ACTIONS(7),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_GT] = ACTIONS(7),
    [anon_sym_BANG] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(7),
    [anon_sym_DOLLAR] = ACTIONS(7),
    [anon_sym_PERCENT] = ACTIONS(7),
    [anon_sym_AMP] = ACTIONS(7),
    [anon_sym_SQUOTE] = ACTIONS(7),
    [anon_sym_STAR] = ACTIONS(7),
    [anon_sym_PLUS] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(7),
    [anon_sym_DOT] = ACTIONS(7),
    [anon_sym_SLASH] = ACTIONS(7),
    [anon_sym_COLON] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(7),
    [anon_sym_QMARK] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(7),
    [anon_sym_CARET] = ACTIONS(7),
    [anon_sym__] = ACTIONS(7),
    [anon_sym_BQUOTE] = ACTIONS(7),
    [anon_sym_LBRACE] = ACTIONS(7),
    [anon_sym_PIPE] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(7),
    [anon_sym_TILDE] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(7),
    [anon_sym_RPAREN] = ACTIONS(7),
    [aux_sym__word_token1] = ACTIONS(7),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(7),
    [aux_sym__word_token2] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(69),
    [sym__soft_line_ending] = ACTIONS(11),
    [sym__block_close] = ACTIONS(1056),
    [sym__block_quote_start] = ACTIONS(73),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(1056),
    [sym_atx_h2_marker] = ACTIONS(1056),
    [sym_atx_h3_marker] = ACTIONS(1056),
    [sym_atx_h4_marker] = ACTIONS(1056),
    [sym_atx_h5_marker] = ACTIONS(1056),
    [sym_atx_h6_marker] = ACTIONS(1056),
    [sym__thematic_break] = ACTIONS(89),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(91),
    [sym__fenced_code_block_start_tilde] = ACTIONS(93),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(97),
    [sym__html_block_2_start] = ACTIONS(99),
    [sym__html_block_3_start] = ACTIONS(101),
    [sym__html_block_4_start] = ACTIONS(103),
    [sym__html_block_5_start] = ACTIONS(105),
    [sym__html_block_6_start] = ACTIONS(107),
    [sym__html_block_7_start] = ACTIONS(109),
    [sym__pipe_table_start] = ACTIONS(111),
  },
  [73] = {
    [sym__indented_chunk] = STATE(73),
    [sym__blank_line] = STATE(73),
    [aux_sym_indented_code_block_repeat1] = STATE(73),
    [anon_sym_LBRACK] = ACTIONS(1058),
    [anon_sym_RBRACK] = ACTIONS(1060),
    [anon_sym_LT] = ACTIONS(1060),
    [anon_sym_GT] = ACTIONS(1060),
    [anon_sym_BANG] = ACTIONS(1060),
    [anon_sym_DQUOTE] = ACTIONS(1060),
    [anon_sym_POUND] = ACTIONS(1060),
    [anon_sym_DOLLAR] = ACTIONS(1060),
    [anon_sym_PERCENT] = ACTIONS(1060),
    [anon_sym_AMP] = ACTIONS(1060),
    [anon_sym_SQUOTE] = ACTIONS(1060),
    [anon_sym_STAR] = ACTIONS(1060),
    [anon_sym_PLUS] = ACTIONS(1060),
    [anon_sym_COMMA] = ACTIONS(1060),
    [anon_sym_DASH] = ACTIONS(1060),
    [anon_sym_DOT] = ACTIONS(1060),
    [anon_sym_SLASH] = ACTIONS(1060),
    [anon_sym_COLON] = ACTIONS(1060),
    [anon_sym_SEMI] = ACTIONS(1060),
    [anon_sym_EQ] = ACTIONS(1060),
    [anon_sym_QMARK] = ACTIONS(1060),
    [anon_sym_AT] = ACTIONS(1060),
    [anon_sym_BSLASH] = ACTIONS(1060),
    [anon_sym_CARET] = ACTIONS(1060),
    [anon_sym__] = ACTIONS(1060),
    [anon_sym_BQUOTE] = ACTIONS(1060),
    [anon_sym_LBRACE] = ACTIONS(1060),
    [anon_sym_PIPE] = ACTIONS(1060),
    [anon_sym_RBRACE] = ACTIONS(1060),
    [anon_sym_TILDE] = ACTIONS(1060),
    [anon_sym_LPAREN] = ACTIONS(1060),
    [anon_sym_RPAREN] = ACTIONS(1060),
    [aux_sym__word_token1] = ACTIONS(1060),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1060),
    [aux_sym__word_token2] = ACTIONS(1060),
    [sym__whitespace] = ACTIONS(1060),
    [sym__soft_line_ending] = ACTIONS(1060),
    [sym__block_close] = ACTIONS(1060),
    [sym__block_quote_start] = ACTIONS(1060),
    [sym__indented_chunk_start] = ACTIONS(1062),
    [sym_atx_h1_marker] = ACTIONS(1060),
    [sym_atx_h2_marker] = ACTIONS(1060),
    [sym_atx_h3_marker] = ACTIONS(1060),
    [sym_atx_h4_marker] = ACTIONS(1060),
    [sym_atx_h5_marker] = ACTIONS(1060),
    [sym_atx_h6_marker] = ACTIONS(1060),
    [sym__thematic_break] = ACTIONS(1060),
    [sym__list_marker_minus] = ACTIONS(1060),
    [sym__list_marker_plus] = ACTIONS(1060),
    [sym__list_marker_star] = ACTIONS(1060),
    [sym__list_marker_parenthesis] = ACTIONS(1060),
    [sym__list_marker_dot] = ACTIONS(1060),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1060),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1060),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1060),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1060),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1060),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1060),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1060),
    [sym__blank_line_start] = ACTIONS(1065),
    [sym__html_block_1_start] = ACTIONS(1060),
    [sym__html_block_2_start] = ACTIONS(1060),
    [sym__html_block_3_start] = ACTIONS(1060),
    [sym__html_block_4_start] = ACTIONS(1060),
    [sym__html_block_5_start] = ACTIONS(1060),
    [sym__html_block_6_start] = ACTIONS(1060),
    [sym__html_block_7_start] = ACTIONS(1060),
    [sym__pipe_table_start] = ACTIONS(1060),
  },
  [74] = {
    [sym_list_marker_star] = STATE(8),
    [sym__list_item_star] = STATE(74),
    [aux_sym__list_star_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(1068),
    [anon_sym_LBRACK] = ACTIONS(1070),
    [anon_sym_RBRACK] = ACTIONS(1068),
    [anon_sym_LT] = ACTIONS(1068),
    [anon_sym_GT] = ACTIONS(1068),
    [anon_sym_BANG] = ACTIONS(1068),
    [anon_sym_DQUOTE] = ACTIONS(1068),
    [anon_sym_POUND] = ACTIONS(1068),
    [anon_sym_DOLLAR] = ACTIONS(1068),
    [anon_sym_PERCENT] = ACTIONS(1068),
    [anon_sym_AMP] = ACTIONS(1068),
    [anon_sym_SQUOTE] = ACTIONS(1068),
    [anon_sym_STAR] = ACTIONS(1068),
    [anon_sym_PLUS] = ACTIONS(1068),
    [anon_sym_COMMA] = ACTIONS(1068),
    [anon_sym_DASH] = ACTIONS(1068),
    [anon_sym_DOT] = ACTIONS(1068),
    [anon_sym_SLASH] = ACTIONS(1068),
    [anon_sym_COLON] = ACTIONS(1068),
    [anon_sym_SEMI] = ACTIONS(1068),
    [anon_sym_EQ] = ACTIONS(1068),
    [anon_sym_QMARK] = ACTIONS(1068),
    [anon_sym_AT] = ACTIONS(1068),
    [anon_sym_BSLASH] = ACTIONS(1068),
    [anon_sym_CARET] = ACTIONS(1068),
    [anon_sym__] = ACTIONS(1068),
    [anon_sym_BQUOTE] = ACTIONS(1068),
    [anon_sym_LBRACE] = ACTIONS(1068),
    [anon_sym_PIPE] = ACTIONS(1068),
    [anon_sym_RBRACE] = ACTIONS(1068),
    [anon_sym_TILDE] = ACTIONS(1068),
    [anon_sym_LPAREN] = ACTIONS(1068),
    [anon_sym_RPAREN] = ACTIONS(1068),
    [aux_sym__word_token1] = ACTIONS(1068),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1068),
    [aux_sym__word_token2] = ACTIONS(1068),
    [sym__whitespace] = ACTIONS(1068),
    [sym__soft_line_ending] = ACTIONS(1068),
    [sym__block_quote_start] = ACTIONS(1068),
    [sym__indented_chunk_start] = ACTIONS(1068),
    [sym_atx_h1_marker] = ACTIONS(1068),
    [sym_atx_h2_marker] = ACTIONS(1068),
    [sym_atx_h3_marker] = ACTIONS(1068),
    [sym_atx_h4_marker] = ACTIONS(1068),
    [sym_atx_h5_marker] = ACTIONS(1068),
    [sym_atx_h6_marker] = ACTIONS(1068),
    [sym__thematic_break] = ACTIONS(1068),
    [sym__list_marker_minus] = ACTIONS(1068),
    [sym__list_marker_plus] = ACTIONS(1068),
    [sym__list_marker_star] = ACTIONS(1072),
    [sym__list_marker_parenthesis] = ACTIONS(1068),
    [sym__list_marker_dot] = ACTIONS(1068),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1068),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1068),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1072),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1068),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1068),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1068),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1068),
    [sym__blank_line_start] = ACTIONS(1068),
    [sym__html_block_1_start] = ACTIONS(1068),
    [sym__html_block_2_start] = ACTIONS(1068),
    [sym__html_block_3_start] = ACTIONS(1068),
    [sym__html_block_4_start] = ACTIONS(1068),
    [sym__html_block_5_start] = ACTIONS(1068),
    [sym__html_block_6_start] = ACTIONS(1068),
    [sym__html_block_7_start] = ACTIONS(1068),
    [sym__pipe_table_start] = ACTIONS(1068),
  },
  [75] = {
    [sym_list_marker_minus] = STATE(9),
    [sym__list_item_minus] = STATE(80),
    [aux_sym__list_minus_repeat1] = STATE(80),
    [ts_builtin_sym_end] = ACTIONS(1075),
    [anon_sym_LBRACK] = ACTIONS(1077),
    [anon_sym_RBRACK] = ACTIONS(1075),
    [anon_sym_LT] = ACTIONS(1075),
    [anon_sym_GT] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1075),
    [anon_sym_DQUOTE] = ACTIONS(1075),
    [anon_sym_POUND] = ACTIONS(1075),
    [anon_sym_DOLLAR] = ACTIONS(1075),
    [anon_sym_PERCENT] = ACTIONS(1075),
    [anon_sym_AMP] = ACTIONS(1075),
    [anon_sym_SQUOTE] = ACTIONS(1075),
    [anon_sym_STAR] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_COMMA] = ACTIONS(1075),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_DOT] = ACTIONS(1075),
    [anon_sym_SLASH] = ACTIONS(1075),
    [anon_sym_COLON] = ACTIONS(1075),
    [anon_sym_SEMI] = ACTIONS(1075),
    [anon_sym_EQ] = ACTIONS(1075),
    [anon_sym_QMARK] = ACTIONS(1075),
    [anon_sym_AT] = ACTIONS(1075),
    [anon_sym_BSLASH] = ACTIONS(1075),
    [anon_sym_CARET] = ACTIONS(1075),
    [anon_sym__] = ACTIONS(1075),
    [anon_sym_BQUOTE] = ACTIONS(1075),
    [anon_sym_LBRACE] = ACTIONS(1075),
    [anon_sym_PIPE] = ACTIONS(1075),
    [anon_sym_RBRACE] = ACTIONS(1075),
    [anon_sym_TILDE] = ACTIONS(1075),
    [anon_sym_LPAREN] = ACTIONS(1075),
    [anon_sym_RPAREN] = ACTIONS(1075),
    [aux_sym__word_token1] = ACTIONS(1075),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1075),
    [aux_sym__word_token2] = ACTIONS(1075),
    [sym__whitespace] = ACTIONS(1075),
    [sym__soft_line_ending] = ACTIONS(1075),
    [sym__block_quote_start] = ACTIONS(1075),
    [sym__indented_chunk_start] = ACTIONS(1075),
    [sym_atx_h1_marker] = ACTIONS(1075),
    [sym_atx_h2_marker] = ACTIONS(1075),
    [sym_atx_h3_marker] = ACTIONS(1075),
    [sym_atx_h4_marker] = ACTIONS(1075),
    [sym_atx_h5_marker] = ACTIONS(1075),
    [sym_atx_h6_marker] = ACTIONS(1075),
    [sym__thematic_break] = ACTIONS(1075),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(1075),
    [sym__list_marker_star] = ACTIONS(1075),
    [sym__list_marker_parenthesis] = ACTIONS(1075),
    [sym__list_marker_dot] = ACTIONS(1075),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1075),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1075),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1075),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1075),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1075),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1075),
    [sym__blank_line_start] = ACTIONS(1075),
    [sym__html_block_1_start] = ACTIONS(1075),
    [sym__html_block_2_start] = ACTIONS(1075),
    [sym__html_block_3_start] = ACTIONS(1075),
    [sym__html_block_4_start] = ACTIONS(1075),
    [sym__html_block_5_start] = ACTIONS(1075),
    [sym__html_block_6_start] = ACTIONS(1075),
    [sym__html_block_7_start] = ACTIONS(1075),
    [sym__pipe_table_start] = ACTIONS(1075),
  },
  [76] = {
    [sym__indented_chunk] = STATE(76),
    [sym__blank_line] = STATE(76),
    [aux_sym_indented_code_block_repeat1] = STATE(76),
    [ts_builtin_sym_end] = ACTIONS(1060),
    [anon_sym_LBRACK] = ACTIONS(1058),
    [anon_sym_RBRACK] = ACTIONS(1060),
    [anon_sym_LT] = ACTIONS(1060),
    [anon_sym_GT] = ACTIONS(1060),
    [anon_sym_BANG] = ACTIONS(1060),
    [anon_sym_DQUOTE] = ACTIONS(1060),
    [anon_sym_POUND] = ACTIONS(1060),
    [anon_sym_DOLLAR] = ACTIONS(1060),
    [anon_sym_PERCENT] = ACTIONS(1060),
    [anon_sym_AMP] = ACTIONS(1060),
    [anon_sym_SQUOTE] = ACTIONS(1060),
    [anon_sym_STAR] = ACTIONS(1060),
    [anon_sym_PLUS] = ACTIONS(1060),
    [anon_sym_COMMA] = ACTIONS(1060),
    [anon_sym_DASH] = ACTIONS(1060),
    [anon_sym_DOT] = ACTIONS(1060),
    [anon_sym_SLASH] = ACTIONS(1060),
    [anon_sym_COLON] = ACTIONS(1060),
    [anon_sym_SEMI] = ACTIONS(1060),
    [anon_sym_EQ] = ACTIONS(1060),
    [anon_sym_QMARK] = ACTIONS(1060),
    [anon_sym_AT] = ACTIONS(1060),
    [anon_sym_BSLASH] = ACTIONS(1060),
    [anon_sym_CARET] = ACTIONS(1060),
    [anon_sym__] = ACTIONS(1060),
    [anon_sym_BQUOTE] = ACTIONS(1060),
    [anon_sym_LBRACE] = ACTIONS(1060),
    [anon_sym_PIPE] = ACTIONS(1060),
    [anon_sym_RBRACE] = ACTIONS(1060),
    [anon_sym_TILDE] = ACTIONS(1060),
    [anon_sym_LPAREN] = ACTIONS(1060),
    [anon_sym_RPAREN] = ACTIONS(1060),
    [aux_sym__word_token1] = ACTIONS(1060),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1060),
    [aux_sym__word_token2] = ACTIONS(1060),
    [sym__whitespace] = ACTIONS(1060),
    [sym__soft_line_ending] = ACTIONS(1060),
    [sym__block_quote_start] = ACTIONS(1060),
    [sym__indented_chunk_start] = ACTIONS(1079),
    [sym_atx_h1_marker] = ACTIONS(1060),
    [sym_atx_h2_marker] = ACTIONS(1060),
    [sym_atx_h3_marker] = ACTIONS(1060),
    [sym_atx_h4_marker] = ACTIONS(1060),
    [sym_atx_h5_marker] = ACTIONS(1060),
    [sym_atx_h6_marker] = ACTIONS(1060),
    [sym__thematic_break] = ACTIONS(1060),
    [sym__list_marker_minus] = ACTIONS(1060),
    [sym__list_marker_plus] = ACTIONS(1060),
    [sym__list_marker_star] = ACTIONS(1060),
    [sym__list_marker_parenthesis] = ACTIONS(1060),
    [sym__list_marker_dot] = ACTIONS(1060),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1060),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1060),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1060),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1060),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1060),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1060),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1060),
    [sym__blank_line_start] = ACTIONS(1082),
    [sym__html_block_1_start] = ACTIONS(1060),
    [sym__html_block_2_start] = ACTIONS(1060),
    [sym__html_block_3_start] = ACTIONS(1060),
    [sym__html_block_4_start] = ACTIONS(1060),
    [sym__html_block_5_start] = ACTIONS(1060),
    [sym__html_block_6_start] = ACTIONS(1060),
    [sym__html_block_7_start] = ACTIONS(1060),
    [sym__pipe_table_start] = ACTIONS(1060),
  },
  [77] = {
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_parenthesis] = STATE(77),
    [aux_sym__list_parenthesis_repeat1] = STATE(77),
    [ts_builtin_sym_end] = ACTIONS(1085),
    [anon_sym_LBRACK] = ACTIONS(1087),
    [anon_sym_RBRACK] = ACTIONS(1085),
    [anon_sym_LT] = ACTIONS(1085),
    [anon_sym_GT] = ACTIONS(1085),
    [anon_sym_BANG] = ACTIONS(1085),
    [anon_sym_DQUOTE] = ACTIONS(1085),
    [anon_sym_POUND] = ACTIONS(1085),
    [anon_sym_DOLLAR] = ACTIONS(1085),
    [anon_sym_PERCENT] = ACTIONS(1085),
    [anon_sym_AMP] = ACTIONS(1085),
    [anon_sym_SQUOTE] = ACTIONS(1085),
    [anon_sym_STAR] = ACTIONS(1085),
    [anon_sym_PLUS] = ACTIONS(1085),
    [anon_sym_COMMA] = ACTIONS(1085),
    [anon_sym_DASH] = ACTIONS(1085),
    [anon_sym_DOT] = ACTIONS(1085),
    [anon_sym_SLASH] = ACTIONS(1085),
    [anon_sym_COLON] = ACTIONS(1085),
    [anon_sym_SEMI] = ACTIONS(1085),
    [anon_sym_EQ] = ACTIONS(1085),
    [anon_sym_QMARK] = ACTIONS(1085),
    [anon_sym_AT] = ACTIONS(1085),
    [anon_sym_BSLASH] = ACTIONS(1085),
    [anon_sym_CARET] = ACTIONS(1085),
    [anon_sym__] = ACTIONS(1085),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [anon_sym_LBRACE] = ACTIONS(1085),
    [anon_sym_PIPE] = ACTIONS(1085),
    [anon_sym_RBRACE] = ACTIONS(1085),
    [anon_sym_TILDE] = ACTIONS(1085),
    [anon_sym_LPAREN] = ACTIONS(1085),
    [anon_sym_RPAREN] = ACTIONS(1085),
    [aux_sym__word_token1] = ACTIONS(1085),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1085),
    [aux_sym__word_token2] = ACTIONS(1085),
    [sym__whitespace] = ACTIONS(1085),
    [sym__soft_line_ending] = ACTIONS(1085),
    [sym__block_quote_start] = ACTIONS(1085),
    [sym__indented_chunk_start] = ACTIONS(1085),
    [sym_atx_h1_marker] = ACTIONS(1085),
    [sym_atx_h2_marker] = ACTIONS(1085),
    [sym_atx_h3_marker] = ACTIONS(1085),
    [sym_atx_h4_marker] = ACTIONS(1085),
    [sym_atx_h5_marker] = ACTIONS(1085),
    [sym_atx_h6_marker] = ACTIONS(1085),
    [sym__thematic_break] = ACTIONS(1085),
    [sym__list_marker_minus] = ACTIONS(1085),
    [sym__list_marker_plus] = ACTIONS(1085),
    [sym__list_marker_star] = ACTIONS(1085),
    [sym__list_marker_parenthesis] = ACTIONS(1089),
    [sym__list_marker_dot] = ACTIONS(1085),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1085),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1085),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1085),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1089),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1085),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1085),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1085),
    [sym__blank_line_start] = ACTIONS(1085),
    [sym__html_block_1_start] = ACTIONS(1085),
    [sym__html_block_2_start] = ACTIONS(1085),
    [sym__html_block_3_start] = ACTIONS(1085),
    [sym__html_block_4_start] = ACTIONS(1085),
    [sym__html_block_5_start] = ACTIONS(1085),
    [sym__html_block_6_start] = ACTIONS(1085),
    [sym__html_block_7_start] = ACTIONS(1085),
    [sym__pipe_table_start] = ACTIONS(1085),
  },
  [78] = {
    [sym_list_marker_dot] = STATE(5),
    [sym__list_item_dot] = STATE(78),
    [aux_sym__list_dot_repeat1] = STATE(78),
    [ts_builtin_sym_end] = ACTIONS(1092),
    [anon_sym_LBRACK] = ACTIONS(1094),
    [anon_sym_RBRACK] = ACTIONS(1092),
    [anon_sym_LT] = ACTIONS(1092),
    [anon_sym_GT] = ACTIONS(1092),
    [anon_sym_BANG] = ACTIONS(1092),
    [anon_sym_DQUOTE] = ACTIONS(1092),
    [anon_sym_POUND] = ACTIONS(1092),
    [anon_sym_DOLLAR] = ACTIONS(1092),
    [anon_sym_PERCENT] = ACTIONS(1092),
    [anon_sym_AMP] = ACTIONS(1092),
    [anon_sym_SQUOTE] = ACTIONS(1092),
    [anon_sym_STAR] = ACTIONS(1092),
    [anon_sym_PLUS] = ACTIONS(1092),
    [anon_sym_COMMA] = ACTIONS(1092),
    [anon_sym_DASH] = ACTIONS(1092),
    [anon_sym_DOT] = ACTIONS(1092),
    [anon_sym_SLASH] = ACTIONS(1092),
    [anon_sym_COLON] = ACTIONS(1092),
    [anon_sym_SEMI] = ACTIONS(1092),
    [anon_sym_EQ] = ACTIONS(1092),
    [anon_sym_QMARK] = ACTIONS(1092),
    [anon_sym_AT] = ACTIONS(1092),
    [anon_sym_BSLASH] = ACTIONS(1092),
    [anon_sym_CARET] = ACTIONS(1092),
    [anon_sym__] = ACTIONS(1092),
    [anon_sym_BQUOTE] = ACTIONS(1092),
    [anon_sym_LBRACE] = ACTIONS(1092),
    [anon_sym_PIPE] = ACTIONS(1092),
    [anon_sym_RBRACE] = ACTIONS(1092),
    [anon_sym_TILDE] = ACTIONS(1092),
    [anon_sym_LPAREN] = ACTIONS(1092),
    [anon_sym_RPAREN] = ACTIONS(1092),
    [aux_sym__word_token1] = ACTIONS(1092),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1092),
    [aux_sym__word_token2] = ACTIONS(1092),
    [sym__whitespace] = ACTIONS(1092),
    [sym__soft_line_ending] = ACTIONS(1092),
    [sym__block_quote_start] = ACTIONS(1092),
    [sym__indented_chunk_start] = ACTIONS(1092),
    [sym_atx_h1_marker] = ACTIONS(1092),
    [sym_atx_h2_marker] = ACTIONS(1092),
    [sym_atx_h3_marker] = ACTIONS(1092),
    [sym_atx_h4_marker] = ACTIONS(1092),
    [sym_atx_h5_marker] = ACTIONS(1092),
    [sym_atx_h6_marker] = ACTIONS(1092),
    [sym__thematic_break] = ACTIONS(1092),
    [sym__list_marker_minus] = ACTIONS(1092),
    [sym__list_marker_plus] = ACTIONS(1092),
    [sym__list_marker_star] = ACTIONS(1092),
    [sym__list_marker_parenthesis] = ACTIONS(1092),
    [sym__list_marker_dot] = ACTIONS(1096),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1092),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1092),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1092),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1092),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1096),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1092),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1092),
    [sym__blank_line_start] = ACTIONS(1092),
    [sym__html_block_1_start] = ACTIONS(1092),
    [sym__html_block_2_start] = ACTIONS(1092),
    [sym__html_block_3_start] = ACTIONS(1092),
    [sym__html_block_4_start] = ACTIONS(1092),
    [sym__html_block_5_start] = ACTIONS(1092),
    [sym__html_block_6_start] = ACTIONS(1092),
    [sym__html_block_7_start] = ACTIONS(1092),
    [sym__pipe_table_start] = ACTIONS(1092),
  },
  [79] = {
    [sym__indented_chunk] = STATE(76),
    [sym__blank_line] = STATE(76),
    [aux_sym_indented_code_block_repeat1] = STATE(76),
    [ts_builtin_sym_end] = ACTIONS(1099),
    [anon_sym_LBRACK] = ACTIONS(1101),
    [anon_sym_RBRACK] = ACTIONS(1099),
    [anon_sym_LT] = ACTIONS(1099),
    [anon_sym_GT] = ACTIONS(1099),
    [anon_sym_BANG] = ACTIONS(1099),
    [anon_sym_DQUOTE] = ACTIONS(1099),
    [anon_sym_POUND] = ACTIONS(1099),
    [anon_sym_DOLLAR] = ACTIONS(1099),
    [anon_sym_PERCENT] = ACTIONS(1099),
    [anon_sym_AMP] = ACTIONS(1099),
    [anon_sym_SQUOTE] = ACTIONS(1099),
    [anon_sym_STAR] = ACTIONS(1099),
    [anon_sym_PLUS] = ACTIONS(1099),
    [anon_sym_COMMA] = ACTIONS(1099),
    [anon_sym_DASH] = ACTIONS(1099),
    [anon_sym_DOT] = ACTIONS(1099),
    [anon_sym_SLASH] = ACTIONS(1099),
    [anon_sym_COLON] = ACTIONS(1099),
    [anon_sym_SEMI] = ACTIONS(1099),
    [anon_sym_EQ] = ACTIONS(1099),
    [anon_sym_QMARK] = ACTIONS(1099),
    [anon_sym_AT] = ACTIONS(1099),
    [anon_sym_BSLASH] = ACTIONS(1099),
    [anon_sym_CARET] = ACTIONS(1099),
    [anon_sym__] = ACTIONS(1099),
    [anon_sym_BQUOTE] = ACTIONS(1099),
    [anon_sym_LBRACE] = ACTIONS(1099),
    [anon_sym_PIPE] = ACTIONS(1099),
    [anon_sym_RBRACE] = ACTIONS(1099),
    [anon_sym_TILDE] = ACTIONS(1099),
    [anon_sym_LPAREN] = ACTIONS(1099),
    [anon_sym_RPAREN] = ACTIONS(1099),
    [aux_sym__word_token1] = ACTIONS(1099),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1099),
    [aux_sym__word_token2] = ACTIONS(1099),
    [sym__whitespace] = ACTIONS(1099),
    [sym__soft_line_ending] = ACTIONS(1099),
    [sym__block_quote_start] = ACTIONS(1099),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(1099),
    [sym_atx_h2_marker] = ACTIONS(1099),
    [sym_atx_h3_marker] = ACTIONS(1099),
    [sym_atx_h4_marker] = ACTIONS(1099),
    [sym_atx_h5_marker] = ACTIONS(1099),
    [sym_atx_h6_marker] = ACTIONS(1099),
    [sym__thematic_break] = ACTIONS(1099),
    [sym__list_marker_minus] = ACTIONS(1099),
    [sym__list_marker_plus] = ACTIONS(1099),
    [sym__list_marker_star] = ACTIONS(1099),
    [sym__list_marker_parenthesis] = ACTIONS(1099),
    [sym__list_marker_dot] = ACTIONS(1099),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1099),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1099),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1099),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1099),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1099),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1099),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1099),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(1099),
    [sym__html_block_2_start] = ACTIONS(1099),
    [sym__html_block_3_start] = ACTIONS(1099),
    [sym__html_block_4_start] = ACTIONS(1099),
    [sym__html_block_5_start] = ACTIONS(1099),
    [sym__html_block_6_start] = ACTIONS(1099),
    [sym__html_block_7_start] = ACTIONS(1099),
    [sym__pipe_table_start] = ACTIONS(1099),
  },
  [80] = {
    [sym_list_marker_minus] = STATE(9),
    [sym__list_item_minus] = STATE(80),
    [aux_sym__list_minus_repeat1] = STATE(80),
    [ts_builtin_sym_end] = ACTIONS(1103),
    [anon_sym_LBRACK] = ACTIONS(1105),
    [anon_sym_RBRACK] = ACTIONS(1103),
    [anon_sym_LT] = ACTIONS(1103),
    [anon_sym_GT] = ACTIONS(1103),
    [anon_sym_BANG] = ACTIONS(1103),
    [anon_sym_DQUOTE] = ACTIONS(1103),
    [anon_sym_POUND] = ACTIONS(1103),
    [anon_sym_DOLLAR] = ACTIONS(1103),
    [anon_sym_PERCENT] = ACTIONS(1103),
    [anon_sym_AMP] = ACTIONS(1103),
    [anon_sym_SQUOTE] = ACTIONS(1103),
    [anon_sym_STAR] = ACTIONS(1103),
    [anon_sym_PLUS] = ACTIONS(1103),
    [anon_sym_COMMA] = ACTIONS(1103),
    [anon_sym_DASH] = ACTIONS(1103),
    [anon_sym_DOT] = ACTIONS(1103),
    [anon_sym_SLASH] = ACTIONS(1103),
    [anon_sym_COLON] = ACTIONS(1103),
    [anon_sym_SEMI] = ACTIONS(1103),
    [anon_sym_EQ] = ACTIONS(1103),
    [anon_sym_QMARK] = ACTIONS(1103),
    [anon_sym_AT] = ACTIONS(1103),
    [anon_sym_BSLASH] = ACTIONS(1103),
    [anon_sym_CARET] = ACTIONS(1103),
    [anon_sym__] = ACTIONS(1103),
    [anon_sym_BQUOTE] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1103),
    [anon_sym_PIPE] = ACTIONS(1103),
    [anon_sym_RBRACE] = ACTIONS(1103),
    [anon_sym_TILDE] = ACTIONS(1103),
    [anon_sym_LPAREN] = ACTIONS(1103),
    [anon_sym_RPAREN] = ACTIONS(1103),
    [aux_sym__word_token1] = ACTIONS(1103),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1103),
    [aux_sym__word_token2] = ACTIONS(1103),
    [sym__whitespace] = ACTIONS(1103),
    [sym__soft_line_ending] = ACTIONS(1103),
    [sym__block_quote_start] = ACTIONS(1103),
    [sym__indented_chunk_start] = ACTIONS(1103),
    [sym_atx_h1_marker] = ACTIONS(1103),
    [sym_atx_h2_marker] = ACTIONS(1103),
    [sym_atx_h3_marker] = ACTIONS(1103),
    [sym_atx_h4_marker] = ACTIONS(1103),
    [sym_atx_h5_marker] = ACTIONS(1103),
    [sym_atx_h6_marker] = ACTIONS(1103),
    [sym__thematic_break] = ACTIONS(1103),
    [sym__list_marker_minus] = ACTIONS(1107),
    [sym__list_marker_plus] = ACTIONS(1103),
    [sym__list_marker_star] = ACTIONS(1103),
    [sym__list_marker_parenthesis] = ACTIONS(1103),
    [sym__list_marker_dot] = ACTIONS(1103),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1107),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1103),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1103),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1103),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1103),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1103),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1103),
    [sym__blank_line_start] = ACTIONS(1103),
    [sym__html_block_1_start] = ACTIONS(1103),
    [sym__html_block_2_start] = ACTIONS(1103),
    [sym__html_block_3_start] = ACTIONS(1103),
    [sym__html_block_4_start] = ACTIONS(1103),
    [sym__html_block_5_start] = ACTIONS(1103),
    [sym__html_block_6_start] = ACTIONS(1103),
    [sym__html_block_7_start] = ACTIONS(1103),
    [sym__pipe_table_start] = ACTIONS(1103),
  },
  [81] = {
    [sym_list_marker_plus] = STATE(10),
    [sym__list_item_plus] = STATE(81),
    [aux_sym__list_plus_repeat1] = STATE(81),
    [ts_builtin_sym_end] = ACTIONS(1110),
    [anon_sym_LBRACK] = ACTIONS(1112),
    [anon_sym_RBRACK] = ACTIONS(1110),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1110),
    [anon_sym_BANG] = ACTIONS(1110),
    [anon_sym_DQUOTE] = ACTIONS(1110),
    [anon_sym_POUND] = ACTIONS(1110),
    [anon_sym_DOLLAR] = ACTIONS(1110),
    [anon_sym_PERCENT] = ACTIONS(1110),
    [anon_sym_AMP] = ACTIONS(1110),
    [anon_sym_SQUOTE] = ACTIONS(1110),
    [anon_sym_STAR] = ACTIONS(1110),
    [anon_sym_PLUS] = ACTIONS(1110),
    [anon_sym_COMMA] = ACTIONS(1110),
    [anon_sym_DASH] = ACTIONS(1110),
    [anon_sym_DOT] = ACTIONS(1110),
    [anon_sym_SLASH] = ACTIONS(1110),
    [anon_sym_COLON] = ACTIONS(1110),
    [anon_sym_SEMI] = ACTIONS(1110),
    [anon_sym_EQ] = ACTIONS(1110),
    [anon_sym_QMARK] = ACTIONS(1110),
    [anon_sym_AT] = ACTIONS(1110),
    [anon_sym_BSLASH] = ACTIONS(1110),
    [anon_sym_CARET] = ACTIONS(1110),
    [anon_sym__] = ACTIONS(1110),
    [anon_sym_BQUOTE] = ACTIONS(1110),
    [anon_sym_LBRACE] = ACTIONS(1110),
    [anon_sym_PIPE] = ACTIONS(1110),
    [anon_sym_RBRACE] = ACTIONS(1110),
    [anon_sym_TILDE] = ACTIONS(1110),
    [anon_sym_LPAREN] = ACTIONS(1110),
    [anon_sym_RPAREN] = ACTIONS(1110),
    [aux_sym__word_token1] = ACTIONS(1110),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1110),
    [aux_sym__word_token2] = ACTIONS(1110),
    [sym__whitespace] = ACTIONS(1110),
    [sym__soft_line_ending] = ACTIONS(1110),
    [sym__block_quote_start] = ACTIONS(1110),
    [sym__indented_chunk_start] = ACTIONS(1110),
    [sym_atx_h1_marker] = ACTIONS(1110),
    [sym_atx_h2_marker] = ACTIONS(1110),
    [sym_atx_h3_marker] = ACTIONS(1110),
    [sym_atx_h4_marker] = ACTIONS(1110),
    [sym_atx_h5_marker] = ACTIONS(1110),
    [sym_atx_h6_marker] = ACTIONS(1110),
    [sym__thematic_break] = ACTIONS(1110),
    [sym__list_marker_minus] = ACTIONS(1110),
    [sym__list_marker_plus] = ACTIONS(1114),
    [sym__list_marker_star] = ACTIONS(1110),
    [sym__list_marker_parenthesis] = ACTIONS(1110),
    [sym__list_marker_dot] = ACTIONS(1110),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1110),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1114),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1110),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1110),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1110),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1110),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1110),
    [sym__blank_line_start] = ACTIONS(1110),
    [sym__html_block_1_start] = ACTIONS(1110),
    [sym__html_block_2_start] = ACTIONS(1110),
    [sym__html_block_3_start] = ACTIONS(1110),
    [sym__html_block_4_start] = ACTIONS(1110),
    [sym__html_block_5_start] = ACTIONS(1110),
    [sym__html_block_6_start] = ACTIONS(1110),
    [sym__html_block_7_start] = ACTIONS(1110),
    [sym__pipe_table_start] = ACTIONS(1110),
  },
  [82] = {
    [anon_sym_LBRACK] = ACTIONS(1117),
    [anon_sym_RBRACK] = ACTIONS(1119),
    [anon_sym_LT] = ACTIONS(1119),
    [anon_sym_GT] = ACTIONS(1119),
    [anon_sym_BANG] = ACTIONS(1119),
    [anon_sym_DQUOTE] = ACTIONS(1119),
    [anon_sym_POUND] = ACTIONS(1119),
    [anon_sym_DOLLAR] = ACTIONS(1119),
    [anon_sym_PERCENT] = ACTIONS(1119),
    [anon_sym_AMP] = ACTIONS(1119),
    [anon_sym_SQUOTE] = ACTIONS(1119),
    [anon_sym_STAR] = ACTIONS(1119),
    [anon_sym_PLUS] = ACTIONS(1119),
    [anon_sym_COMMA] = ACTIONS(1119),
    [anon_sym_DASH] = ACTIONS(1119),
    [anon_sym_DOT] = ACTIONS(1119),
    [anon_sym_SLASH] = ACTIONS(1119),
    [anon_sym_COLON] = ACTIONS(1119),
    [anon_sym_SEMI] = ACTIONS(1119),
    [anon_sym_EQ] = ACTIONS(1119),
    [anon_sym_QMARK] = ACTIONS(1119),
    [anon_sym_AT] = ACTIONS(1119),
    [anon_sym_BSLASH] = ACTIONS(1119),
    [anon_sym_CARET] = ACTIONS(1119),
    [anon_sym__] = ACTIONS(1119),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [anon_sym_LBRACE] = ACTIONS(1119),
    [anon_sym_PIPE] = ACTIONS(1119),
    [anon_sym_RBRACE] = ACTIONS(1119),
    [anon_sym_TILDE] = ACTIONS(1119),
    [anon_sym_LPAREN] = ACTIONS(1119),
    [anon_sym_RPAREN] = ACTIONS(1119),
    [aux_sym__word_token1] = ACTIONS(1119),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1119),
    [aux_sym__word_token2] = ACTIONS(1119),
    [sym__whitespace] = ACTIONS(1119),
    [sym__soft_line_ending] = ACTIONS(1119),
    [sym__block_close] = ACTIONS(1119),
    [sym_block_continuation] = ACTIONS(1121),
    [sym__block_quote_start] = ACTIONS(1119),
    [sym__indented_chunk_start] = ACTIONS(1119),
    [sym_atx_h1_marker] = ACTIONS(1119),
    [sym_atx_h2_marker] = ACTIONS(1119),
    [sym_atx_h3_marker] = ACTIONS(1119),
    [sym_atx_h4_marker] = ACTIONS(1119),
    [sym_atx_h5_marker] = ACTIONS(1119),
    [sym_atx_h6_marker] = ACTIONS(1119),
    [sym_setext_h1_underline] = ACTIONS(1119),
    [sym_setext_h2_underline] = ACTIONS(1119),
    [sym__thematic_break] = ACTIONS(1119),
    [sym__list_marker_minus] = ACTIONS(1119),
    [sym__list_marker_plus] = ACTIONS(1119),
    [sym__list_marker_star] = ACTIONS(1119),
    [sym__list_marker_parenthesis] = ACTIONS(1119),
    [sym__list_marker_dot] = ACTIONS(1119),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1119),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1119),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1119),
    [sym__blank_line_start] = ACTIONS(1119),
    [sym__html_block_1_start] = ACTIONS(1119),
    [sym__html_block_2_start] = ACTIONS(1119),
    [sym__html_block_3_start] = ACTIONS(1119),
    [sym__html_block_4_start] = ACTIONS(1119),
    [sym__html_block_5_start] = ACTIONS(1119),
    [sym__html_block_6_start] = ACTIONS(1119),
    [sym__html_block_7_start] = ACTIONS(1119),
    [sym__pipe_table_start] = ACTIONS(1119),
  },
  [83] = {
    [sym_list_marker_dot] = STATE(5),
    [sym__list_item_dot] = STATE(78),
    [aux_sym__list_dot_repeat1] = STATE(78),
    [ts_builtin_sym_end] = ACTIONS(1123),
    [anon_sym_LBRACK] = ACTIONS(1125),
    [anon_sym_RBRACK] = ACTIONS(1123),
    [anon_sym_LT] = ACTIONS(1123),
    [anon_sym_GT] = ACTIONS(1123),
    [anon_sym_BANG] = ACTIONS(1123),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_POUND] = ACTIONS(1123),
    [anon_sym_DOLLAR] = ACTIONS(1123),
    [anon_sym_PERCENT] = ACTIONS(1123),
    [anon_sym_AMP] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1123),
    [anon_sym_STAR] = ACTIONS(1123),
    [anon_sym_PLUS] = ACTIONS(1123),
    [anon_sym_COMMA] = ACTIONS(1123),
    [anon_sym_DASH] = ACTIONS(1123),
    [anon_sym_DOT] = ACTIONS(1123),
    [anon_sym_SLASH] = ACTIONS(1123),
    [anon_sym_COLON] = ACTIONS(1123),
    [anon_sym_SEMI] = ACTIONS(1123),
    [anon_sym_EQ] = ACTIONS(1123),
    [anon_sym_QMARK] = ACTIONS(1123),
    [anon_sym_AT] = ACTIONS(1123),
    [anon_sym_BSLASH] = ACTIONS(1123),
    [anon_sym_CARET] = ACTIONS(1123),
    [anon_sym__] = ACTIONS(1123),
    [anon_sym_BQUOTE] = ACTIONS(1123),
    [anon_sym_LBRACE] = ACTIONS(1123),
    [anon_sym_PIPE] = ACTIONS(1123),
    [anon_sym_RBRACE] = ACTIONS(1123),
    [anon_sym_TILDE] = ACTIONS(1123),
    [anon_sym_LPAREN] = ACTIONS(1123),
    [anon_sym_RPAREN] = ACTIONS(1123),
    [aux_sym__word_token1] = ACTIONS(1123),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1123),
    [aux_sym__word_token2] = ACTIONS(1123),
    [sym__whitespace] = ACTIONS(1123),
    [sym__soft_line_ending] = ACTIONS(1123),
    [sym__block_quote_start] = ACTIONS(1123),
    [sym__indented_chunk_start] = ACTIONS(1123),
    [sym_atx_h1_marker] = ACTIONS(1123),
    [sym_atx_h2_marker] = ACTIONS(1123),
    [sym_atx_h3_marker] = ACTIONS(1123),
    [sym_atx_h4_marker] = ACTIONS(1123),
    [sym_atx_h5_marker] = ACTIONS(1123),
    [sym_atx_h6_marker] = ACTIONS(1123),
    [sym__thematic_break] = ACTIONS(1123),
    [sym__list_marker_minus] = ACTIONS(1123),
    [sym__list_marker_plus] = ACTIONS(1123),
    [sym__list_marker_star] = ACTIONS(1123),
    [sym__list_marker_parenthesis] = ACTIONS(1123),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1123),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1123),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1123),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1123),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1123),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1123),
    [sym__blank_line_start] = ACTIONS(1123),
    [sym__html_block_1_start] = ACTIONS(1123),
    [sym__html_block_2_start] = ACTIONS(1123),
    [sym__html_block_3_start] = ACTIONS(1123),
    [sym__html_block_4_start] = ACTIONS(1123),
    [sym__html_block_5_start] = ACTIONS(1123),
    [sym__html_block_6_start] = ACTIONS(1123),
    [sym__html_block_7_start] = ACTIONS(1123),
    [sym__pipe_table_start] = ACTIONS(1123),
  },
  [84] = {
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_parenthesis] = STATE(99),
    [aux_sym__list_parenthesis_repeat1] = STATE(99),
    [anon_sym_LBRACK] = ACTIONS(1127),
    [anon_sym_RBRACK] = ACTIONS(1129),
    [anon_sym_LT] = ACTIONS(1129),
    [anon_sym_GT] = ACTIONS(1129),
    [anon_sym_BANG] = ACTIONS(1129),
    [anon_sym_DQUOTE] = ACTIONS(1129),
    [anon_sym_POUND] = ACTIONS(1129),
    [anon_sym_DOLLAR] = ACTIONS(1129),
    [anon_sym_PERCENT] = ACTIONS(1129),
    [anon_sym_AMP] = ACTIONS(1129),
    [anon_sym_SQUOTE] = ACTIONS(1129),
    [anon_sym_STAR] = ACTIONS(1129),
    [anon_sym_PLUS] = ACTIONS(1129),
    [anon_sym_COMMA] = ACTIONS(1129),
    [anon_sym_DASH] = ACTIONS(1129),
    [anon_sym_DOT] = ACTIONS(1129),
    [anon_sym_SLASH] = ACTIONS(1129),
    [anon_sym_COLON] = ACTIONS(1129),
    [anon_sym_SEMI] = ACTIONS(1129),
    [anon_sym_EQ] = ACTIONS(1129),
    [anon_sym_QMARK] = ACTIONS(1129),
    [anon_sym_AT] = ACTIONS(1129),
    [anon_sym_BSLASH] = ACTIONS(1129),
    [anon_sym_CARET] = ACTIONS(1129),
    [anon_sym__] = ACTIONS(1129),
    [anon_sym_BQUOTE] = ACTIONS(1129),
    [anon_sym_LBRACE] = ACTIONS(1129),
    [anon_sym_PIPE] = ACTIONS(1129),
    [anon_sym_RBRACE] = ACTIONS(1129),
    [anon_sym_TILDE] = ACTIONS(1129),
    [anon_sym_LPAREN] = ACTIONS(1129),
    [anon_sym_RPAREN] = ACTIONS(1129),
    [aux_sym__word_token1] = ACTIONS(1129),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1129),
    [aux_sym__word_token2] = ACTIONS(1129),
    [sym__whitespace] = ACTIONS(1129),
    [sym__soft_line_ending] = ACTIONS(1129),
    [sym__block_close] = ACTIONS(1129),
    [sym__block_quote_start] = ACTIONS(1129),
    [sym__indented_chunk_start] = ACTIONS(1129),
    [sym_atx_h1_marker] = ACTIONS(1129),
    [sym_atx_h2_marker] = ACTIONS(1129),
    [sym_atx_h3_marker] = ACTIONS(1129),
    [sym_atx_h4_marker] = ACTIONS(1129),
    [sym_atx_h5_marker] = ACTIONS(1129),
    [sym_atx_h6_marker] = ACTIONS(1129),
    [sym__thematic_break] = ACTIONS(1129),
    [sym__list_marker_minus] = ACTIONS(1129),
    [sym__list_marker_plus] = ACTIONS(1129),
    [sym__list_marker_star] = ACTIONS(1129),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(1129),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1129),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1129),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1129),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1129),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1129),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1129),
    [sym__blank_line_start] = ACTIONS(1129),
    [sym__html_block_1_start] = ACTIONS(1129),
    [sym__html_block_2_start] = ACTIONS(1129),
    [sym__html_block_3_start] = ACTIONS(1129),
    [sym__html_block_4_start] = ACTIONS(1129),
    [sym__html_block_5_start] = ACTIONS(1129),
    [sym__html_block_6_start] = ACTIONS(1129),
    [sym__html_block_7_start] = ACTIONS(1129),
    [sym__pipe_table_start] = ACTIONS(1129),
  },
  [85] = {
    [sym_list_marker_dot] = STATE(7),
    [sym__list_item_dot] = STATE(100),
    [aux_sym__list_dot_repeat1] = STATE(100),
    [anon_sym_LBRACK] = ACTIONS(1125),
    [anon_sym_RBRACK] = ACTIONS(1123),
    [anon_sym_LT] = ACTIONS(1123),
    [anon_sym_GT] = ACTIONS(1123),
    [anon_sym_BANG] = ACTIONS(1123),
    [anon_sym_DQUOTE] = ACTIONS(1123),
    [anon_sym_POUND] = ACTIONS(1123),
    [anon_sym_DOLLAR] = ACTIONS(1123),
    [anon_sym_PERCENT] = ACTIONS(1123),
    [anon_sym_AMP] = ACTIONS(1123),
    [anon_sym_SQUOTE] = ACTIONS(1123),
    [anon_sym_STAR] = ACTIONS(1123),
    [anon_sym_PLUS] = ACTIONS(1123),
    [anon_sym_COMMA] = ACTIONS(1123),
    [anon_sym_DASH] = ACTIONS(1123),
    [anon_sym_DOT] = ACTIONS(1123),
    [anon_sym_SLASH] = ACTIONS(1123),
    [anon_sym_COLON] = ACTIONS(1123),
    [anon_sym_SEMI] = ACTIONS(1123),
    [anon_sym_EQ] = ACTIONS(1123),
    [anon_sym_QMARK] = ACTIONS(1123),
    [anon_sym_AT] = ACTIONS(1123),
    [anon_sym_BSLASH] = ACTIONS(1123),
    [anon_sym_CARET] = ACTIONS(1123),
    [anon_sym__] = ACTIONS(1123),
    [anon_sym_BQUOTE] = ACTIONS(1123),
    [anon_sym_LBRACE] = ACTIONS(1123),
    [anon_sym_PIPE] = ACTIONS(1123),
    [anon_sym_RBRACE] = ACTIONS(1123),
    [anon_sym_TILDE] = ACTIONS(1123),
    [anon_sym_LPAREN] = ACTIONS(1123),
    [anon_sym_RPAREN] = ACTIONS(1123),
    [aux_sym__word_token1] = ACTIONS(1123),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1123),
    [aux_sym__word_token2] = ACTIONS(1123),
    [sym__whitespace] = ACTIONS(1123),
    [sym__soft_line_ending] = ACTIONS(1123),
    [sym__block_close] = ACTIONS(1123),
    [sym__block_quote_start] = ACTIONS(1123),
    [sym__indented_chunk_start] = ACTIONS(1123),
    [sym_atx_h1_marker] = ACTIONS(1123),
    [sym_atx_h2_marker] = ACTIONS(1123),
    [sym_atx_h3_marker] = ACTIONS(1123),
    [sym_atx_h4_marker] = ACTIONS(1123),
    [sym_atx_h5_marker] = ACTIONS(1123),
    [sym_atx_h6_marker] = ACTIONS(1123),
    [sym__thematic_break] = ACTIONS(1123),
    [sym__list_marker_minus] = ACTIONS(1123),
    [sym__list_marker_plus] = ACTIONS(1123),
    [sym__list_marker_star] = ACTIONS(1123),
    [sym__list_marker_parenthesis] = ACTIONS(1123),
    [sym__list_marker_dot] = ACTIONS(39),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1123),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1123),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1123),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1123),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(39),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1123),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1123),
    [sym__blank_line_start] = ACTIONS(1123),
    [sym__html_block_1_start] = ACTIONS(1123),
    [sym__html_block_2_start] = ACTIONS(1123),
    [sym__html_block_3_start] = ACTIONS(1123),
    [sym__html_block_4_start] = ACTIONS(1123),
    [sym__html_block_5_start] = ACTIONS(1123),
    [sym__html_block_6_start] = ACTIONS(1123),
    [sym__html_block_7_start] = ACTIONS(1123),
    [sym__pipe_table_start] = ACTIONS(1123),
  },
  [86] = {
    [sym_list_marker_star] = STATE(6),
    [sym__list_item_star] = STATE(96),
    [aux_sym__list_star_repeat1] = STATE(96),
    [anon_sym_LBRACK] = ACTIONS(1131),
    [anon_sym_RBRACK] = ACTIONS(1133),
    [anon_sym_LT] = ACTIONS(1133),
    [anon_sym_GT] = ACTIONS(1133),
    [anon_sym_BANG] = ACTIONS(1133),
    [anon_sym_DQUOTE] = ACTIONS(1133),
    [anon_sym_POUND] = ACTIONS(1133),
    [anon_sym_DOLLAR] = ACTIONS(1133),
    [anon_sym_PERCENT] = ACTIONS(1133),
    [anon_sym_AMP] = ACTIONS(1133),
    [anon_sym_SQUOTE] = ACTIONS(1133),
    [anon_sym_STAR] = ACTIONS(1133),
    [anon_sym_PLUS] = ACTIONS(1133),
    [anon_sym_COMMA] = ACTIONS(1133),
    [anon_sym_DASH] = ACTIONS(1133),
    [anon_sym_DOT] = ACTIONS(1133),
    [anon_sym_SLASH] = ACTIONS(1133),
    [anon_sym_COLON] = ACTIONS(1133),
    [anon_sym_SEMI] = ACTIONS(1133),
    [anon_sym_EQ] = ACTIONS(1133),
    [anon_sym_QMARK] = ACTIONS(1133),
    [anon_sym_AT] = ACTIONS(1133),
    [anon_sym_BSLASH] = ACTIONS(1133),
    [anon_sym_CARET] = ACTIONS(1133),
    [anon_sym__] = ACTIONS(1133),
    [anon_sym_BQUOTE] = ACTIONS(1133),
    [anon_sym_LBRACE] = ACTIONS(1133),
    [anon_sym_PIPE] = ACTIONS(1133),
    [anon_sym_RBRACE] = ACTIONS(1133),
    [anon_sym_TILDE] = ACTIONS(1133),
    [anon_sym_LPAREN] = ACTIONS(1133),
    [anon_sym_RPAREN] = ACTIONS(1133),
    [aux_sym__word_token1] = ACTIONS(1133),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1133),
    [aux_sym__word_token2] = ACTIONS(1133),
    [sym__whitespace] = ACTIONS(1133),
    [sym__soft_line_ending] = ACTIONS(1133),
    [sym__block_close] = ACTIONS(1133),
    [sym__block_quote_start] = ACTIONS(1133),
    [sym__indented_chunk_start] = ACTIONS(1133),
    [sym_atx_h1_marker] = ACTIONS(1133),
    [sym_atx_h2_marker] = ACTIONS(1133),
    [sym_atx_h3_marker] = ACTIONS(1133),
    [sym_atx_h4_marker] = ACTIONS(1133),
    [sym_atx_h5_marker] = ACTIONS(1133),
    [sym_atx_h6_marker] = ACTIONS(1133),
    [sym__thematic_break] = ACTIONS(1133),
    [sym__list_marker_minus] = ACTIONS(1133),
    [sym__list_marker_plus] = ACTIONS(1133),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(1133),
    [sym__list_marker_dot] = ACTIONS(1133),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1133),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1133),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1133),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1133),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1133),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1133),
    [sym__blank_line_start] = ACTIONS(1133),
    [sym__html_block_1_start] = ACTIONS(1133),
    [sym__html_block_2_start] = ACTIONS(1133),
    [sym__html_block_3_start] = ACTIONS(1133),
    [sym__html_block_4_start] = ACTIONS(1133),
    [sym__html_block_5_start] = ACTIONS(1133),
    [sym__html_block_6_start] = ACTIONS(1133),
    [sym__html_block_7_start] = ACTIONS(1133),
    [sym__pipe_table_start] = ACTIONS(1133),
  },
  [87] = {
    [sym_list_marker_minus] = STATE(11),
    [sym__list_item_minus] = STATE(95),
    [aux_sym__list_minus_repeat1] = STATE(95),
    [anon_sym_LBRACK] = ACTIONS(1077),
    [anon_sym_RBRACK] = ACTIONS(1075),
    [anon_sym_LT] = ACTIONS(1075),
    [anon_sym_GT] = ACTIONS(1075),
    [anon_sym_BANG] = ACTIONS(1075),
    [anon_sym_DQUOTE] = ACTIONS(1075),
    [anon_sym_POUND] = ACTIONS(1075),
    [anon_sym_DOLLAR] = ACTIONS(1075),
    [anon_sym_PERCENT] = ACTIONS(1075),
    [anon_sym_AMP] = ACTIONS(1075),
    [anon_sym_SQUOTE] = ACTIONS(1075),
    [anon_sym_STAR] = ACTIONS(1075),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_COMMA] = ACTIONS(1075),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_DOT] = ACTIONS(1075),
    [anon_sym_SLASH] = ACTIONS(1075),
    [anon_sym_COLON] = ACTIONS(1075),
    [anon_sym_SEMI] = ACTIONS(1075),
    [anon_sym_EQ] = ACTIONS(1075),
    [anon_sym_QMARK] = ACTIONS(1075),
    [anon_sym_AT] = ACTIONS(1075),
    [anon_sym_BSLASH] = ACTIONS(1075),
    [anon_sym_CARET] = ACTIONS(1075),
    [anon_sym__] = ACTIONS(1075),
    [anon_sym_BQUOTE] = ACTIONS(1075),
    [anon_sym_LBRACE] = ACTIONS(1075),
    [anon_sym_PIPE] = ACTIONS(1075),
    [anon_sym_RBRACE] = ACTIONS(1075),
    [anon_sym_TILDE] = ACTIONS(1075),
    [anon_sym_LPAREN] = ACTIONS(1075),
    [anon_sym_RPAREN] = ACTIONS(1075),
    [aux_sym__word_token1] = ACTIONS(1075),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1075),
    [aux_sym__word_token2] = ACTIONS(1075),
    [sym__whitespace] = ACTIONS(1075),
    [sym__soft_line_ending] = ACTIONS(1075),
    [sym__block_close] = ACTIONS(1075),
    [sym__block_quote_start] = ACTIONS(1075),
    [sym__indented_chunk_start] = ACTIONS(1075),
    [sym_atx_h1_marker] = ACTIONS(1075),
    [sym_atx_h2_marker] = ACTIONS(1075),
    [sym_atx_h3_marker] = ACTIONS(1075),
    [sym_atx_h4_marker] = ACTIONS(1075),
    [sym_atx_h5_marker] = ACTIONS(1075),
    [sym_atx_h6_marker] = ACTIONS(1075),
    [sym__thematic_break] = ACTIONS(1075),
    [sym__list_marker_minus] = ACTIONS(31),
    [sym__list_marker_plus] = ACTIONS(1075),
    [sym__list_marker_star] = ACTIONS(1075),
    [sym__list_marker_parenthesis] = ACTIONS(1075),
    [sym__list_marker_dot] = ACTIONS(1075),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(31),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1075),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1075),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1075),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1075),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1075),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1075),
    [sym__blank_line_start] = ACTIONS(1075),
    [sym__html_block_1_start] = ACTIONS(1075),
    [sym__html_block_2_start] = ACTIONS(1075),
    [sym__html_block_3_start] = ACTIONS(1075),
    [sym__html_block_4_start] = ACTIONS(1075),
    [sym__html_block_5_start] = ACTIONS(1075),
    [sym__html_block_6_start] = ACTIONS(1075),
    [sym__html_block_7_start] = ACTIONS(1075),
    [sym__pipe_table_start] = ACTIONS(1075),
  },
  [88] = {
    [sym_list_marker_plus] = STATE(4),
    [sym__list_item_plus] = STATE(93),
    [aux_sym__list_plus_repeat1] = STATE(93),
    [anon_sym_LBRACK] = ACTIONS(1135),
    [anon_sym_RBRACK] = ACTIONS(1137),
    [anon_sym_LT] = ACTIONS(1137),
    [anon_sym_GT] = ACTIONS(1137),
    [anon_sym_BANG] = ACTIONS(1137),
    [anon_sym_DQUOTE] = ACTIONS(1137),
    [anon_sym_POUND] = ACTIONS(1137),
    [anon_sym_DOLLAR] = ACTIONS(1137),
    [anon_sym_PERCENT] = ACTIONS(1137),
    [anon_sym_AMP] = ACTIONS(1137),
    [anon_sym_SQUOTE] = ACTIONS(1137),
    [anon_sym_STAR] = ACTIONS(1137),
    [anon_sym_PLUS] = ACTIONS(1137),
    [anon_sym_COMMA] = ACTIONS(1137),
    [anon_sym_DASH] = ACTIONS(1137),
    [anon_sym_DOT] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1137),
    [anon_sym_COLON] = ACTIONS(1137),
    [anon_sym_SEMI] = ACTIONS(1137),
    [anon_sym_EQ] = ACTIONS(1137),
    [anon_sym_QMARK] = ACTIONS(1137),
    [anon_sym_AT] = ACTIONS(1137),
    [anon_sym_BSLASH] = ACTIONS(1137),
    [anon_sym_CARET] = ACTIONS(1137),
    [anon_sym__] = ACTIONS(1137),
    [anon_sym_BQUOTE] = ACTIONS(1137),
    [anon_sym_LBRACE] = ACTIONS(1137),
    [anon_sym_PIPE] = ACTIONS(1137),
    [anon_sym_RBRACE] = ACTIONS(1137),
    [anon_sym_TILDE] = ACTIONS(1137),
    [anon_sym_LPAREN] = ACTIONS(1137),
    [anon_sym_RPAREN] = ACTIONS(1137),
    [aux_sym__word_token1] = ACTIONS(1137),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1137),
    [aux_sym__word_token2] = ACTIONS(1137),
    [sym__whitespace] = ACTIONS(1137),
    [sym__soft_line_ending] = ACTIONS(1137),
    [sym__block_close] = ACTIONS(1137),
    [sym__block_quote_start] = ACTIONS(1137),
    [sym__indented_chunk_start] = ACTIONS(1137),
    [sym_atx_h1_marker] = ACTIONS(1137),
    [sym_atx_h2_marker] = ACTIONS(1137),
    [sym_atx_h3_marker] = ACTIONS(1137),
    [sym_atx_h4_marker] = ACTIONS(1137),
    [sym_atx_h5_marker] = ACTIONS(1137),
    [sym_atx_h6_marker] = ACTIONS(1137),
    [sym__thematic_break] = ACTIONS(1137),
    [sym__list_marker_minus] = ACTIONS(1137),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(1137),
    [sym__list_marker_parenthesis] = ACTIONS(1137),
    [sym__list_marker_dot] = ACTIONS(1137),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1137),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1137),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1137),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1137),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1137),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1137),
    [sym__blank_line_start] = ACTIONS(1137),
    [sym__html_block_1_start] = ACTIONS(1137),
    [sym__html_block_2_start] = ACTIONS(1137),
    [sym__html_block_3_start] = ACTIONS(1137),
    [sym__html_block_4_start] = ACTIONS(1137),
    [sym__html_block_5_start] = ACTIONS(1137),
    [sym__html_block_6_start] = ACTIONS(1137),
    [sym__html_block_7_start] = ACTIONS(1137),
    [sym__pipe_table_start] = ACTIONS(1137),
  },
  [89] = {
    [sym__indented_chunk] = STATE(73),
    [sym__blank_line] = STATE(73),
    [aux_sym_indented_code_block_repeat1] = STATE(73),
    [anon_sym_LBRACK] = ACTIONS(1101),
    [anon_sym_RBRACK] = ACTIONS(1099),
    [anon_sym_LT] = ACTIONS(1099),
    [anon_sym_GT] = ACTIONS(1099),
    [anon_sym_BANG] = ACTIONS(1099),
    [anon_sym_DQUOTE] = ACTIONS(1099),
    [anon_sym_POUND] = ACTIONS(1099),
    [anon_sym_DOLLAR] = ACTIONS(1099),
    [anon_sym_PERCENT] = ACTIONS(1099),
    [anon_sym_AMP] = ACTIONS(1099),
    [anon_sym_SQUOTE] = ACTIONS(1099),
    [anon_sym_STAR] = ACTIONS(1099),
    [anon_sym_PLUS] = ACTIONS(1099),
    [anon_sym_COMMA] = ACTIONS(1099),
    [anon_sym_DASH] = ACTIONS(1099),
    [anon_sym_DOT] = ACTIONS(1099),
    [anon_sym_SLASH] = ACTIONS(1099),
    [anon_sym_COLON] = ACTIONS(1099),
    [anon_sym_SEMI] = ACTIONS(1099),
    [anon_sym_EQ] = ACTIONS(1099),
    [anon_sym_QMARK] = ACTIONS(1099),
    [anon_sym_AT] = ACTIONS(1099),
    [anon_sym_BSLASH] = ACTIONS(1099),
    [anon_sym_CARET] = ACTIONS(1099),
    [anon_sym__] = ACTIONS(1099),
    [anon_sym_BQUOTE] = ACTIONS(1099),
    [anon_sym_LBRACE] = ACTIONS(1099),
    [anon_sym_PIPE] = ACTIONS(1099),
    [anon_sym_RBRACE] = ACTIONS(1099),
    [anon_sym_TILDE] = ACTIONS(1099),
    [anon_sym_LPAREN] = ACTIONS(1099),
    [anon_sym_RPAREN] = ACTIONS(1099),
    [aux_sym__word_token1] = ACTIONS(1099),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1099),
    [aux_sym__word_token2] = ACTIONS(1099),
    [sym__whitespace] = ACTIONS(1099),
    [sym__soft_line_ending] = ACTIONS(1099),
    [sym__block_close] = ACTIONS(1099),
    [sym__block_quote_start] = ACTIONS(1099),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(1099),
    [sym_atx_h2_marker] = ACTIONS(1099),
    [sym_atx_h3_marker] = ACTIONS(1099),
    [sym_atx_h4_marker] = ACTIONS(1099),
    [sym_atx_h5_marker] = ACTIONS(1099),
    [sym_atx_h6_marker] = ACTIONS(1099),
    [sym__thematic_break] = ACTIONS(1099),
    [sym__list_marker_minus] = ACTIONS(1099),
    [sym__list_marker_plus] = ACTIONS(1099),
    [sym__list_marker_star] = ACTIONS(1099),
    [sym__list_marker_parenthesis] = ACTIONS(1099),
    [sym__list_marker_dot] = ACTIONS(1099),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1099),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1099),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1099),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1099),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1099),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1099),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1099),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(1099),
    [sym__html_block_2_start] = ACTIONS(1099),
    [sym__html_block_3_start] = ACTIONS(1099),
    [sym__html_block_4_start] = ACTIONS(1099),
    [sym__html_block_5_start] = ACTIONS(1099),
    [sym__html_block_6_start] = ACTIONS(1099),
    [sym__html_block_7_start] = ACTIONS(1099),
    [sym__pipe_table_start] = ACTIONS(1099),
  },
  [90] = {
    [sym__indented_chunk] = STATE(89),
    [sym__blank_line] = STATE(89),
    [aux_sym_indented_code_block_repeat1] = STATE(89),
    [anon_sym_LBRACK] = ACTIONS(1139),
    [anon_sym_RBRACK] = ACTIONS(1141),
    [anon_sym_LT] = ACTIONS(1141),
    [anon_sym_GT] = ACTIONS(1141),
    [anon_sym_BANG] = ACTIONS(1141),
    [anon_sym_DQUOTE] = ACTIONS(1141),
    [anon_sym_POUND] = ACTIONS(1141),
    [anon_sym_DOLLAR] = ACTIONS(1141),
    [anon_sym_PERCENT] = ACTIONS(1141),
    [anon_sym_AMP] = ACTIONS(1141),
    [anon_sym_SQUOTE] = ACTIONS(1141),
    [anon_sym_STAR] = ACTIONS(1141),
    [anon_sym_PLUS] = ACTIONS(1141),
    [anon_sym_COMMA] = ACTIONS(1141),
    [anon_sym_DASH] = ACTIONS(1141),
    [anon_sym_DOT] = ACTIONS(1141),
    [anon_sym_SLASH] = ACTIONS(1141),
    [anon_sym_COLON] = ACTIONS(1141),
    [anon_sym_SEMI] = ACTIONS(1141),
    [anon_sym_EQ] = ACTIONS(1141),
    [anon_sym_QMARK] = ACTIONS(1141),
    [anon_sym_AT] = ACTIONS(1141),
    [anon_sym_BSLASH] = ACTIONS(1141),
    [anon_sym_CARET] = ACTIONS(1141),
    [anon_sym__] = ACTIONS(1141),
    [anon_sym_BQUOTE] = ACTIONS(1141),
    [anon_sym_LBRACE] = ACTIONS(1141),
    [anon_sym_PIPE] = ACTIONS(1141),
    [anon_sym_RBRACE] = ACTIONS(1141),
    [anon_sym_TILDE] = ACTIONS(1141),
    [anon_sym_LPAREN] = ACTIONS(1141),
    [anon_sym_RPAREN] = ACTIONS(1141),
    [aux_sym__word_token1] = ACTIONS(1141),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1141),
    [aux_sym__word_token2] = ACTIONS(1141),
    [sym__whitespace] = ACTIONS(1141),
    [sym__soft_line_ending] = ACTIONS(1141),
    [sym__block_close] = ACTIONS(1141),
    [sym__block_quote_start] = ACTIONS(1141),
    [sym__indented_chunk_start] = ACTIONS(75),
    [sym_atx_h1_marker] = ACTIONS(1141),
    [sym_atx_h2_marker] = ACTIONS(1141),
    [sym_atx_h3_marker] = ACTIONS(1141),
    [sym_atx_h4_marker] = ACTIONS(1141),
    [sym_atx_h5_marker] = ACTIONS(1141),
    [sym_atx_h6_marker] = ACTIONS(1141),
    [sym__thematic_break] = ACTIONS(1141),
    [sym__list_marker_minus] = ACTIONS(1141),
    [sym__list_marker_plus] = ACTIONS(1141),
    [sym__list_marker_star] = ACTIONS(1141),
    [sym__list_marker_parenthesis] = ACTIONS(1141),
    [sym__list_marker_dot] = ACTIONS(1141),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1141),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1141),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1141),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1141),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1141),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1141),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1141),
    [sym__blank_line_start] = ACTIONS(95),
    [sym__html_block_1_start] = ACTIONS(1141),
    [sym__html_block_2_start] = ACTIONS(1141),
    [sym__html_block_3_start] = ACTIONS(1141),
    [sym__html_block_4_start] = ACTIONS(1141),
    [sym__html_block_5_start] = ACTIONS(1141),
    [sym__html_block_6_start] = ACTIONS(1141),
    [sym__html_block_7_start] = ACTIONS(1141),
    [sym__pipe_table_start] = ACTIONS(1141),
  },
  [91] = {
    [sym_list_marker_parenthesis] = STATE(3),
    [sym__list_item_parenthesis] = STATE(77),
    [aux_sym__list_parenthesis_repeat1] = STATE(77),
    [ts_builtin_sym_end] = ACTIONS(1129),
    [anon_sym_LBRACK] = ACTIONS(1127),
    [anon_sym_RBRACK] = ACTIONS(1129),
    [anon_sym_LT] = ACTIONS(1129),
    [anon_sym_GT] = ACTIONS(1129),
    [anon_sym_BANG] = ACTIONS(1129),
    [anon_sym_DQUOTE] = ACTIONS(1129),
    [anon_sym_POUND] = ACTIONS(1129),
    [anon_sym_DOLLAR] = ACTIONS(1129),
    [anon_sym_PERCENT] = ACTIONS(1129),
    [anon_sym_AMP] = ACTIONS(1129),
    [anon_sym_SQUOTE] = ACTIONS(1129),
    [anon_sym_STAR] = ACTIONS(1129),
    [anon_sym_PLUS] = ACTIONS(1129),
    [anon_sym_COMMA] = ACTIONS(1129),
    [anon_sym_DASH] = ACTIONS(1129),
    [anon_sym_DOT] = ACTIONS(1129),
    [anon_sym_SLASH] = ACTIONS(1129),
    [anon_sym_COLON] = ACTIONS(1129),
    [anon_sym_SEMI] = ACTIONS(1129),
    [anon_sym_EQ] = ACTIONS(1129),
    [anon_sym_QMARK] = ACTIONS(1129),
    [anon_sym_AT] = ACTIONS(1129),
    [anon_sym_BSLASH] = ACTIONS(1129),
    [anon_sym_CARET] = ACTIONS(1129),
    [anon_sym__] = ACTIONS(1129),
    [anon_sym_BQUOTE] = ACTIONS(1129),
    [anon_sym_LBRACE] = ACTIONS(1129),
    [anon_sym_PIPE] = ACTIONS(1129),
    [anon_sym_RBRACE] = ACTIONS(1129),
    [anon_sym_TILDE] = ACTIONS(1129),
    [anon_sym_LPAREN] = ACTIONS(1129),
    [anon_sym_RPAREN] = ACTIONS(1129),
    [aux_sym__word_token1] = ACTIONS(1129),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1129),
    [aux_sym__word_token2] = ACTIONS(1129),
    [sym__whitespace] = ACTIONS(1129),
    [sym__soft_line_ending] = ACTIONS(1129),
    [sym__block_quote_start] = ACTIONS(1129),
    [sym__indented_chunk_start] = ACTIONS(1129),
    [sym_atx_h1_marker] = ACTIONS(1129),
    [sym_atx_h2_marker] = ACTIONS(1129),
    [sym_atx_h3_marker] = ACTIONS(1129),
    [sym_atx_h4_marker] = ACTIONS(1129),
    [sym_atx_h5_marker] = ACTIONS(1129),
    [sym_atx_h6_marker] = ACTIONS(1129),
    [sym__thematic_break] = ACTIONS(1129),
    [sym__list_marker_minus] = ACTIONS(1129),
    [sym__list_marker_plus] = ACTIONS(1129),
    [sym__list_marker_star] = ACTIONS(1129),
    [sym__list_marker_parenthesis] = ACTIONS(37),
    [sym__list_marker_dot] = ACTIONS(1129),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1129),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1129),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1129),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(37),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1129),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1129),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1129),
    [sym__blank_line_start] = ACTIONS(1129),
    [sym__html_block_1_start] = ACTIONS(1129),
    [sym__html_block_2_start] = ACTIONS(1129),
    [sym__html_block_3_start] = ACTIONS(1129),
    [sym__html_block_4_start] = ACTIONS(1129),
    [sym__html_block_5_start] = ACTIONS(1129),
    [sym__html_block_6_start] = ACTIONS(1129),
    [sym__html_block_7_start] = ACTIONS(1129),
    [sym__pipe_table_start] = ACTIONS(1129),
  },
  [92] = {
    [ts_builtin_sym_end] = ACTIONS(1119),
    [anon_sym_LBRACK] = ACTIONS(1117),
    [anon_sym_RBRACK] = ACTIONS(1119),
    [anon_sym_LT] = ACTIONS(1119),
    [anon_sym_GT] = ACTIONS(1119),
    [anon_sym_BANG] = ACTIONS(1119),
    [anon_sym_DQUOTE] = ACTIONS(1119),
    [anon_sym_POUND] = ACTIONS(1119),
    [anon_sym_DOLLAR] = ACTIONS(1119),
    [anon_sym_PERCENT] = ACTIONS(1119),
    [anon_sym_AMP] = ACTIONS(1119),
    [anon_sym_SQUOTE] = ACTIONS(1119),
    [anon_sym_STAR] = ACTIONS(1119),
    [anon_sym_PLUS] = ACTIONS(1119),
    [anon_sym_COMMA] = ACTIONS(1119),
    [anon_sym_DASH] = ACTIONS(1119),
    [anon_sym_DOT] = ACTIONS(1119),
    [anon_sym_SLASH] = ACTIONS(1119),
    [anon_sym_COLON] = ACTIONS(1119),
    [anon_sym_SEMI] = ACTIONS(1119),
    [anon_sym_EQ] = ACTIONS(1119),
    [anon_sym_QMARK] = ACTIONS(1119),
    [anon_sym_AT] = ACTIONS(1119),
    [anon_sym_BSLASH] = ACTIONS(1119),
    [anon_sym_CARET] = ACTIONS(1119),
    [anon_sym__] = ACTIONS(1119),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [anon_sym_LBRACE] = ACTIONS(1119),
    [anon_sym_PIPE] = ACTIONS(1119),
    [anon_sym_RBRACE] = ACTIONS(1119),
    [anon_sym_TILDE] = ACTIONS(1119),
    [anon_sym_LPAREN] = ACTIONS(1119),
    [anon_sym_RPAREN] = ACTIONS(1119),
    [aux_sym__word_token1] = ACTIONS(1119),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1119),
    [aux_sym__word_token2] = ACTIONS(1119),
    [sym__whitespace] = ACTIONS(1119),
    [sym__soft_line_ending] = ACTIONS(1119),
    [sym_block_continuation] = ACTIONS(1143),
    [sym__block_quote_start] = ACTIONS(1119),
    [sym__indented_chunk_start] = ACTIONS(1119),
    [sym_atx_h1_marker] = ACTIONS(1119),
    [sym_atx_h2_marker] = ACTIONS(1119),
    [sym_atx_h3_marker] = ACTIONS(1119),
    [sym_atx_h4_marker] = ACTIONS(1119),
    [sym_atx_h5_marker] = ACTIONS(1119),
    [sym_atx_h6_marker] = ACTIONS(1119),
    [sym_setext_h1_underline] = ACTIONS(1119),
    [sym_setext_h2_underline] = ACTIONS(1119),
    [sym__thematic_break] = ACTIONS(1119),
    [sym__list_marker_minus] = ACTIONS(1119),
    [sym__list_marker_plus] = ACTIONS(1119),
    [sym__list_marker_star] = ACTIONS(1119),
    [sym__list_marker_parenthesis] = ACTIONS(1119),
    [sym__list_marker_dot] = ACTIONS(1119),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1119),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1119),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1119),
    [sym__blank_line_start] = ACTIONS(1119),
    [sym__html_block_1_start] = ACTIONS(1119),
    [sym__html_block_2_start] = ACTIONS(1119),
    [sym__html_block_3_start] = ACTIONS(1119),
    [sym__html_block_4_start] = ACTIONS(1119),
    [sym__html_block_5_start] = ACTIONS(1119),
    [sym__html_block_6_start] = ACTIONS(1119),
    [sym__html_block_7_start] = ACTIONS(1119),
    [sym__pipe_table_start] = ACTIONS(1119),
  },
  [93] = {
    [sym_list_marker_plus] = STATE(4),
    [sym__list_item_plus] = STATE(93),
    [aux_sym__list_plus_repeat1] = STATE(93),
    [anon_sym_LBRACK] = ACTIONS(1112),
    [anon_sym_RBRACK] = ACTIONS(1110),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1110),
    [anon_sym_BANG] = ACTIONS(1110),
    [anon_sym_DQUOTE] = ACTIONS(1110),
    [anon_sym_POUND] = ACTIONS(1110),
    [anon_sym_DOLLAR] = ACTIONS(1110),
    [anon_sym_PERCENT] = ACTIONS(1110),
    [anon_sym_AMP] = ACTIONS(1110),
    [anon_sym_SQUOTE] = ACTIONS(1110),
    [anon_sym_STAR] = ACTIONS(1110),
    [anon_sym_PLUS] = ACTIONS(1110),
    [anon_sym_COMMA] = ACTIONS(1110),
    [anon_sym_DASH] = ACTIONS(1110),
    [anon_sym_DOT] = ACTIONS(1110),
    [anon_sym_SLASH] = ACTIONS(1110),
    [anon_sym_COLON] = ACTIONS(1110),
    [anon_sym_SEMI] = ACTIONS(1110),
    [anon_sym_EQ] = ACTIONS(1110),
    [anon_sym_QMARK] = ACTIONS(1110),
    [anon_sym_AT] = ACTIONS(1110),
    [anon_sym_BSLASH] = ACTIONS(1110),
    [anon_sym_CARET] = ACTIONS(1110),
    [anon_sym__] = ACTIONS(1110),
    [anon_sym_BQUOTE] = ACTIONS(1110),
    [anon_sym_LBRACE] = ACTIONS(1110),
    [anon_sym_PIPE] = ACTIONS(1110),
    [anon_sym_RBRACE] = ACTIONS(1110),
    [anon_sym_TILDE] = ACTIONS(1110),
    [anon_sym_LPAREN] = ACTIONS(1110),
    [anon_sym_RPAREN] = ACTIONS(1110),
    [aux_sym__word_token1] = ACTIONS(1110),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1110),
    [aux_sym__word_token2] = ACTIONS(1110),
    [sym__whitespace] = ACTIONS(1110),
    [sym__soft_line_ending] = ACTIONS(1110),
    [sym__block_close] = ACTIONS(1110),
    [sym__block_quote_start] = ACTIONS(1110),
    [sym__indented_chunk_start] = ACTIONS(1110),
    [sym_atx_h1_marker] = ACTIONS(1110),
    [sym_atx_h2_marker] = ACTIONS(1110),
    [sym_atx_h3_marker] = ACTIONS(1110),
    [sym_atx_h4_marker] = ACTIONS(1110),
    [sym_atx_h5_marker] = ACTIONS(1110),
    [sym_atx_h6_marker] = ACTIONS(1110),
    [sym__thematic_break] = ACTIONS(1110),
    [sym__list_marker_minus] = ACTIONS(1110),
    [sym__list_marker_plus] = ACTIONS(1114),
    [sym__list_marker_star] = ACTIONS(1110),
    [sym__list_marker_parenthesis] = ACTIONS(1110),
    [sym__list_marker_dot] = ACTIONS(1110),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1110),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1114),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1110),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1110),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1110),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1110),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1110),
    [sym__blank_line_start] = ACTIONS(1110),
    [sym__html_block_1_start] = ACTIONS(1110),
    [sym__html_block_2_start] = ACTIONS(1110),
    [sym__html_block_3_start] = ACTIONS(1110),
    [sym__html_block_4_start] = ACTIONS(1110),
    [sym__html_block_5_start] = ACTIONS(1110),
    [sym__html_block_6_start] = ACTIONS(1110),
    [sym__html_block_7_start] = ACTIONS(1110),
    [sym__pipe_table_start] = ACTIONS(1110),
  },
  [94] = {
    [sym_list_marker_star] = STATE(8),
    [sym__list_item_star] = STATE(74),
    [aux_sym__list_star_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(1133),
    [anon_sym_LBRACK] = ACTIONS(1131),
    [anon_sym_RBRACK] = ACTIONS(1133),
    [anon_sym_LT] = ACTIONS(1133),
    [anon_sym_GT] = ACTIONS(1133),
    [anon_sym_BANG] = ACTIONS(1133),
    [anon_sym_DQUOTE] = ACTIONS(1133),
    [anon_sym_POUND] = ACTIONS(1133),
    [anon_sym_DOLLAR] = ACTIONS(1133),
    [anon_sym_PERCENT] = ACTIONS(1133),
    [anon_sym_AMP] = ACTIONS(1133),
    [anon_sym_SQUOTE] = ACTIONS(1133),
    [anon_sym_STAR] = ACTIONS(1133),
    [anon_sym_PLUS] = ACTIONS(1133),
    [anon_sym_COMMA] = ACTIONS(1133),
    [anon_sym_DASH] = ACTIONS(1133),
    [anon_sym_DOT] = ACTIONS(1133),
    [anon_sym_SLASH] = ACTIONS(1133),
    [anon_sym_COLON] = ACTIONS(1133),
    [anon_sym_SEMI] = ACTIONS(1133),
    [anon_sym_EQ] = ACTIONS(1133),
    [anon_sym_QMARK] = ACTIONS(1133),
    [anon_sym_AT] = ACTIONS(1133),
    [anon_sym_BSLASH] = ACTIONS(1133),
    [anon_sym_CARET] = ACTIONS(1133),
    [anon_sym__] = ACTIONS(1133),
    [anon_sym_BQUOTE] = ACTIONS(1133),
    [anon_sym_LBRACE] = ACTIONS(1133),
    [anon_sym_PIPE] = ACTIONS(1133),
    [anon_sym_RBRACE] = ACTIONS(1133),
    [anon_sym_TILDE] = ACTIONS(1133),
    [anon_sym_LPAREN] = ACTIONS(1133),
    [anon_sym_RPAREN] = ACTIONS(1133),
    [aux_sym__word_token1] = ACTIONS(1133),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1133),
    [aux_sym__word_token2] = ACTIONS(1133),
    [sym__whitespace] = ACTIONS(1133),
    [sym__soft_line_ending] = ACTIONS(1133),
    [sym__block_quote_start] = ACTIONS(1133),
    [sym__indented_chunk_start] = ACTIONS(1133),
    [sym_atx_h1_marker] = ACTIONS(1133),
    [sym_atx_h2_marker] = ACTIONS(1133),
    [sym_atx_h3_marker] = ACTIONS(1133),
    [sym_atx_h4_marker] = ACTIONS(1133),
    [sym_atx_h5_marker] = ACTIONS(1133),
    [sym_atx_h6_marker] = ACTIONS(1133),
    [sym__thematic_break] = ACTIONS(1133),
    [sym__list_marker_minus] = ACTIONS(1133),
    [sym__list_marker_plus] = ACTIONS(1133),
    [sym__list_marker_star] = ACTIONS(35),
    [sym__list_marker_parenthesis] = ACTIONS(1133),
    [sym__list_marker_dot] = ACTIONS(1133),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1133),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1133),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(35),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1133),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1133),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1133),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1133),
    [sym__blank_line_start] = ACTIONS(1133),
    [sym__html_block_1_start] = ACTIONS(1133),
    [sym__html_block_2_start] = ACTIONS(1133),
    [sym__html_block_3_start] = ACTIONS(1133),
    [sym__html_block_4_start] = ACTIONS(1133),
    [sym__html_block_5_start] = ACTIONS(1133),
    [sym__html_block_6_start] = ACTIONS(1133),
    [sym__html_block_7_start] = ACTIONS(1133),
    [sym__pipe_table_start] = ACTIONS(1133),
  },
  [95] = {
    [sym_list_marker_minus] = STATE(11),
    [sym__list_item_minus] = STATE(95),
    [aux_sym__list_minus_repeat1] = STATE(95),
    [anon_sym_LBRACK] = ACTIONS(1105),
    [anon_sym_RBRACK] = ACTIONS(1103),
    [anon_sym_LT] = ACTIONS(1103),
    [anon_sym_GT] = ACTIONS(1103),
    [anon_sym_BANG] = ACTIONS(1103),
    [anon_sym_DQUOTE] = ACTIONS(1103),
    [anon_sym_POUND] = ACTIONS(1103),
    [anon_sym_DOLLAR] = ACTIONS(1103),
    [anon_sym_PERCENT] = ACTIONS(1103),
    [anon_sym_AMP] = ACTIONS(1103),
    [anon_sym_SQUOTE] = ACTIONS(1103),
    [anon_sym_STAR] = ACTIONS(1103),
    [anon_sym_PLUS] = ACTIONS(1103),
    [anon_sym_COMMA] = ACTIONS(1103),
    [anon_sym_DASH] = ACTIONS(1103),
    [anon_sym_DOT] = ACTIONS(1103),
    [anon_sym_SLASH] = ACTIONS(1103),
    [anon_sym_COLON] = ACTIONS(1103),
    [anon_sym_SEMI] = ACTIONS(1103),
    [anon_sym_EQ] = ACTIONS(1103),
    [anon_sym_QMARK] = ACTIONS(1103),
    [anon_sym_AT] = ACTIONS(1103),
    [anon_sym_BSLASH] = ACTIONS(1103),
    [anon_sym_CARET] = ACTIONS(1103),
    [anon_sym__] = ACTIONS(1103),
    [anon_sym_BQUOTE] = ACTIONS(1103),
    [anon_sym_LBRACE] = ACTIONS(1103),
    [anon_sym_PIPE] = ACTIONS(1103),
    [anon_sym_RBRACE] = ACTIONS(1103),
    [anon_sym_TILDE] = ACTIONS(1103),
    [anon_sym_LPAREN] = ACTIONS(1103),
    [anon_sym_RPAREN] = ACTIONS(1103),
    [aux_sym__word_token1] = ACTIONS(1103),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1103),
    [aux_sym__word_token2] = ACTIONS(1103),
    [sym__whitespace] = ACTIONS(1103),
    [sym__soft_line_ending] = ACTIONS(1103),
    [sym__block_close] = ACTIONS(1103),
    [sym__block_quote_start] = ACTIONS(1103),
    [sym__indented_chunk_start] = ACTIONS(1103),
    [sym_atx_h1_marker] = ACTIONS(1103),
    [sym_atx_h2_marker] = ACTIONS(1103),
    [sym_atx_h3_marker] = ACTIONS(1103),
    [sym_atx_h4_marker] = ACTIONS(1103),
    [sym_atx_h5_marker] = ACTIONS(1103),
    [sym_atx_h6_marker] = ACTIONS(1103),
    [sym__thematic_break] = ACTIONS(1103),
    [sym__list_marker_minus] = ACTIONS(1107),
    [sym__list_marker_plus] = ACTIONS(1103),
    [sym__list_marker_star] = ACTIONS(1103),
    [sym__list_marker_parenthesis] = ACTIONS(1103),
    [sym__list_marker_dot] = ACTIONS(1103),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1107),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1103),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1103),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1103),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1103),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1103),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1103),
    [sym__blank_line_start] = ACTIONS(1103),
    [sym__html_block_1_start] = ACTIONS(1103),
    [sym__html_block_2_start] = ACTIONS(1103),
    [sym__html_block_3_start] = ACTIONS(1103),
    [sym__html_block_4_start] = ACTIONS(1103),
    [sym__html_block_5_start] = ACTIONS(1103),
    [sym__html_block_6_start] = ACTIONS(1103),
    [sym__html_block_7_start] = ACTIONS(1103),
    [sym__pipe_table_start] = ACTIONS(1103),
  },
  [96] = {
    [sym_list_marker_star] = STATE(6),
    [sym__list_item_star] = STATE(96),
    [aux_sym__list_star_repeat1] = STATE(96),
    [anon_sym_LBRACK] = ACTIONS(1070),
    [anon_sym_RBRACK] = ACTIONS(1068),
    [anon_sym_LT] = ACTIONS(1068),
    [anon_sym_GT] = ACTIONS(1068),
    [anon_sym_BANG] = ACTIONS(1068),
    [anon_sym_DQUOTE] = ACTIONS(1068),
    [anon_sym_POUND] = ACTIONS(1068),
    [anon_sym_DOLLAR] = ACTIONS(1068),
    [anon_sym_PERCENT] = ACTIONS(1068),
    [anon_sym_AMP] = ACTIONS(1068),
    [anon_sym_SQUOTE] = ACTIONS(1068),
    [anon_sym_STAR] = ACTIONS(1068),
    [anon_sym_PLUS] = ACTIONS(1068),
    [anon_sym_COMMA] = ACTIONS(1068),
    [anon_sym_DASH] = ACTIONS(1068),
    [anon_sym_DOT] = ACTIONS(1068),
    [anon_sym_SLASH] = ACTIONS(1068),
    [anon_sym_COLON] = ACTIONS(1068),
    [anon_sym_SEMI] = ACTIONS(1068),
    [anon_sym_EQ] = ACTIONS(1068),
    [anon_sym_QMARK] = ACTIONS(1068),
    [anon_sym_AT] = ACTIONS(1068),
    [anon_sym_BSLASH] = ACTIONS(1068),
    [anon_sym_CARET] = ACTIONS(1068),
    [anon_sym__] = ACTIONS(1068),
    [anon_sym_BQUOTE] = ACTIONS(1068),
    [anon_sym_LBRACE] = ACTIONS(1068),
    [anon_sym_PIPE] = ACTIONS(1068),
    [anon_sym_RBRACE] = ACTIONS(1068),
    [anon_sym_TILDE] = ACTIONS(1068),
    [anon_sym_LPAREN] = ACTIONS(1068),
    [anon_sym_RPAREN] = ACTIONS(1068),
    [aux_sym__word_token1] = ACTIONS(1068),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1068),
    [aux_sym__word_token2] = ACTIONS(1068),
    [sym__whitespace] = ACTIONS(1068),
    [sym__soft_line_ending] = ACTIONS(1068),
    [sym__block_close] = ACTIONS(1068),
    [sym__block_quote_start] = ACTIONS(1068),
    [sym__indented_chunk_start] = ACTIONS(1068),
    [sym_atx_h1_marker] = ACTIONS(1068),
    [sym_atx_h2_marker] = ACTIONS(1068),
    [sym_atx_h3_marker] = ACTIONS(1068),
    [sym_atx_h4_marker] = ACTIONS(1068),
    [sym_atx_h5_marker] = ACTIONS(1068),
    [sym_atx_h6_marker] = ACTIONS(1068),
    [sym__thematic_break] = ACTIONS(1068),
    [sym__list_marker_minus] = ACTIONS(1068),
    [sym__list_marker_plus] = ACTIONS(1068),
    [sym__list_marker_star] = ACTIONS(1072),
    [sym__list_marker_parenthesis] = ACTIONS(1068),
    [sym__list_marker_dot] = ACTIONS(1068),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1068),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1068),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1072),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1068),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1068),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1068),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1068),
    [sym__blank_line_start] = ACTIONS(1068),
    [sym__html_block_1_start] = ACTIONS(1068),
    [sym__html_block_2_start] = ACTIONS(1068),
    [sym__html_block_3_start] = ACTIONS(1068),
    [sym__html_block_4_start] = ACTIONS(1068),
    [sym__html_block_5_start] = ACTIONS(1068),
    [sym__html_block_6_start] = ACTIONS(1068),
    [sym__html_block_7_start] = ACTIONS(1068),
    [sym__pipe_table_start] = ACTIONS(1068),
  },
  [97] = {
    [sym__indented_chunk] = STATE(79),
    [sym__blank_line] = STATE(79),
    [aux_sym_indented_code_block_repeat1] = STATE(79),
    [ts_builtin_sym_end] = ACTIONS(1141),
    [anon_sym_LBRACK] = ACTIONS(1139),
    [anon_sym_RBRACK] = ACTIONS(1141),
    [anon_sym_LT] = ACTIONS(1141),
    [anon_sym_GT] = ACTIONS(1141),
    [anon_sym_BANG] = ACTIONS(1141),
    [anon_sym_DQUOTE] = ACTIONS(1141),
    [anon_sym_POUND] = ACTIONS(1141),
    [anon_sym_DOLLAR] = ACTIONS(1141),
    [anon_sym_PERCENT] = ACTIONS(1141),
    [anon_sym_AMP] = ACTIONS(1141),
    [anon_sym_SQUOTE] = ACTIONS(1141),
    [anon_sym_STAR] = ACTIONS(1141),
    [anon_sym_PLUS] = ACTIONS(1141),
    [anon_sym_COMMA] = ACTIONS(1141),
    [anon_sym_DASH] = ACTIONS(1141),
    [anon_sym_DOT] = ACTIONS(1141),
    [anon_sym_SLASH] = ACTIONS(1141),
    [anon_sym_COLON] = ACTIONS(1141),
    [anon_sym_SEMI] = ACTIONS(1141),
    [anon_sym_EQ] = ACTIONS(1141),
    [anon_sym_QMARK] = ACTIONS(1141),
    [anon_sym_AT] = ACTIONS(1141),
    [anon_sym_BSLASH] = ACTIONS(1141),
    [anon_sym_CARET] = ACTIONS(1141),
    [anon_sym__] = ACTIONS(1141),
    [anon_sym_BQUOTE] = ACTIONS(1141),
    [anon_sym_LBRACE] = ACTIONS(1141),
    [anon_sym_PIPE] = ACTIONS(1141),
    [anon_sym_RBRACE] = ACTIONS(1141),
    [anon_sym_TILDE] = ACTIONS(1141),
    [anon_sym_LPAREN] = ACTIONS(1141),
    [anon_sym_RPAREN] = ACTIONS(1141),
    [aux_sym__word_token1] = ACTIONS(1141),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1141),
    [aux_sym__word_token2] = ACTIONS(1141),
    [sym__whitespace] = ACTIONS(1141),
    [sym__soft_line_ending] = ACTIONS(1141),
    [sym__block_quote_start] = ACTIONS(1141),
    [sym__indented_chunk_start] = ACTIONS(15),
    [sym_atx_h1_marker] = ACTIONS(1141),
    [sym_atx_h2_marker] = ACTIONS(1141),
    [sym_atx_h3_marker] = ACTIONS(1141),
    [sym_atx_h4_marker] = ACTIONS(1141),
    [sym_atx_h5_marker] = ACTIONS(1141),
    [sym_atx_h6_marker] = ACTIONS(1141),
    [sym__thematic_break] = ACTIONS(1141),
    [sym__list_marker_minus] = ACTIONS(1141),
    [sym__list_marker_plus] = ACTIONS(1141),
    [sym__list_marker_star] = ACTIONS(1141),
    [sym__list_marker_parenthesis] = ACTIONS(1141),
    [sym__list_marker_dot] = ACTIONS(1141),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1141),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1141),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1141),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1141),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1141),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1141),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1141),
    [sym__blank_line_start] = ACTIONS(45),
    [sym__html_block_1_start] = ACTIONS(1141),
    [sym__html_block_2_start] = ACTIONS(1141),
    [sym__html_block_3_start] = ACTIONS(1141),
    [sym__html_block_4_start] = ACTIONS(1141),
    [sym__html_block_5_start] = ACTIONS(1141),
    [sym__html_block_6_start] = ACTIONS(1141),
    [sym__html_block_7_start] = ACTIONS(1141),
    [sym__pipe_table_start] = ACTIONS(1141),
  },
  [98] = {
    [sym_list_marker_plus] = STATE(10),
    [sym__list_item_plus] = STATE(81),
    [aux_sym__list_plus_repeat1] = STATE(81),
    [ts_builtin_sym_end] = ACTIONS(1137),
    [anon_sym_LBRACK] = ACTIONS(1135),
    [anon_sym_RBRACK] = ACTIONS(1137),
    [anon_sym_LT] = ACTIONS(1137),
    [anon_sym_GT] = ACTIONS(1137),
    [anon_sym_BANG] = ACTIONS(1137),
    [anon_sym_DQUOTE] = ACTIONS(1137),
    [anon_sym_POUND] = ACTIONS(1137),
    [anon_sym_DOLLAR] = ACTIONS(1137),
    [anon_sym_PERCENT] = ACTIONS(1137),
    [anon_sym_AMP] = ACTIONS(1137),
    [anon_sym_SQUOTE] = ACTIONS(1137),
    [anon_sym_STAR] = ACTIONS(1137),
    [anon_sym_PLUS] = ACTIONS(1137),
    [anon_sym_COMMA] = ACTIONS(1137),
    [anon_sym_DASH] = ACTIONS(1137),
    [anon_sym_DOT] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1137),
    [anon_sym_COLON] = ACTIONS(1137),
    [anon_sym_SEMI] = ACTIONS(1137),
    [anon_sym_EQ] = ACTIONS(1137),
    [anon_sym_QMARK] = ACTIONS(1137),
    [anon_sym_AT] = ACTIONS(1137),
    [anon_sym_BSLASH] = ACTIONS(1137),
    [anon_sym_CARET] = ACTIONS(1137),
    [anon_sym__] = ACTIONS(1137),
    [anon_sym_BQUOTE] = ACTIONS(1137),
    [anon_sym_LBRACE] = ACTIONS(1137),
    [anon_sym_PIPE] = ACTIONS(1137),
    [anon_sym_RBRACE] = ACTIONS(1137),
    [anon_sym_TILDE] = ACTIONS(1137),
    [anon_sym_LPAREN] = ACTIONS(1137),
    [anon_sym_RPAREN] = ACTIONS(1137),
    [aux_sym__word_token1] = ACTIONS(1137),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1137),
    [aux_sym__word_token2] = ACTIONS(1137),
    [sym__whitespace] = ACTIONS(1137),
    [sym__soft_line_ending] = ACTIONS(1137),
    [sym__block_quote_start] = ACTIONS(1137),
    [sym__indented_chunk_start] = ACTIONS(1137),
    [sym_atx_h1_marker] = ACTIONS(1137),
    [sym_atx_h2_marker] = ACTIONS(1137),
    [sym_atx_h3_marker] = ACTIONS(1137),
    [sym_atx_h4_marker] = ACTIONS(1137),
    [sym_atx_h5_marker] = ACTIONS(1137),
    [sym_atx_h6_marker] = ACTIONS(1137),
    [sym__thematic_break] = ACTIONS(1137),
    [sym__list_marker_minus] = ACTIONS(1137),
    [sym__list_marker_plus] = ACTIONS(33),
    [sym__list_marker_star] = ACTIONS(1137),
    [sym__list_marker_parenthesis] = ACTIONS(1137),
    [sym__list_marker_dot] = ACTIONS(1137),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1137),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(33),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1137),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1137),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1137),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1137),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1137),
    [sym__blank_line_start] = ACTIONS(1137),
    [sym__html_block_1_start] = ACTIONS(1137),
    [sym__html_block_2_start] = ACTIONS(1137),
    [sym__html_block_3_start] = ACTIONS(1137),
    [sym__html_block_4_start] = ACTIONS(1137),
    [sym__html_block_5_start] = ACTIONS(1137),
    [sym__html_block_6_start] = ACTIONS(1137),
    [sym__html_block_7_start] = ACTIONS(1137),
    [sym__pipe_table_start] = ACTIONS(1137),
  },
  [99] = {
    [sym_list_marker_parenthesis] = STATE(2),
    [sym__list_item_parenthesis] = STATE(99),
    [aux_sym__list_parenthesis_repeat1] = STATE(99),
    [anon_sym_LBRACK] = ACTIONS(1087),
    [anon_sym_RBRACK] = ACTIONS(1085),
    [anon_sym_LT] = ACTIONS(1085),
    [anon_sym_GT] = ACTIONS(1085),
    [anon_sym_BANG] = ACTIONS(1085),
    [anon_sym_DQUOTE] = ACTIONS(1085),
    [anon_sym_POUND] = ACTIONS(1085),
    [anon_sym_DOLLAR] = ACTIONS(1085),
    [anon_sym_PERCENT] = ACTIONS(1085),
    [anon_sym_AMP] = ACTIONS(1085),
    [anon_sym_SQUOTE] = ACTIONS(1085),
    [anon_sym_STAR] = ACTIONS(1085),
    [anon_sym_PLUS] = ACTIONS(1085),
    [anon_sym_COMMA] = ACTIONS(1085),
    [anon_sym_DASH] = ACTIONS(1085),
    [anon_sym_DOT] = ACTIONS(1085),
    [anon_sym_SLASH] = ACTIONS(1085),
    [anon_sym_COLON] = ACTIONS(1085),
    [anon_sym_SEMI] = ACTIONS(1085),
    [anon_sym_EQ] = ACTIONS(1085),
    [anon_sym_QMARK] = ACTIONS(1085),
    [anon_sym_AT] = ACTIONS(1085),
    [anon_sym_BSLASH] = ACTIONS(1085),
    [anon_sym_CARET] = ACTIONS(1085),
    [anon_sym__] = ACTIONS(1085),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [anon_sym_LBRACE] = ACTIONS(1085),
    [anon_sym_PIPE] = ACTIONS(1085),
    [anon_sym_RBRACE] = ACTIONS(1085),
    [anon_sym_TILDE] = ACTIONS(1085),
    [anon_sym_LPAREN] = ACTIONS(1085),
    [anon_sym_RPAREN] = ACTIONS(1085),
    [aux_sym__word_token1] = ACTIONS(1085),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1085),
    [aux_sym__word_token2] = ACTIONS(1085),
    [sym__whitespace] = ACTIONS(1085),
    [sym__soft_line_ending] = ACTIONS(1085),
    [sym__block_close] = ACTIONS(1085),
    [sym__block_quote_start] = ACTIONS(1085),
    [sym__indented_chunk_start] = ACTIONS(1085),
    [sym_atx_h1_marker] = ACTIONS(1085),
    [sym_atx_h2_marker] = ACTIONS(1085),
    [sym_atx_h3_marker] = ACTIONS(1085),
    [sym_atx_h4_marker] = ACTIONS(1085),
    [sym_atx_h5_marker] = ACTIONS(1085),
    [sym_atx_h6_marker] = ACTIONS(1085),
    [sym__thematic_break] = ACTIONS(1085),
    [sym__list_marker_minus] = ACTIONS(1085),
    [sym__list_marker_plus] = ACTIONS(1085),
    [sym__list_marker_star] = ACTIONS(1085),
    [sym__list_marker_parenthesis] = ACTIONS(1089),
    [sym__list_marker_dot] = ACTIONS(1085),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1085),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1085),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1085),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1089),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1085),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1085),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1085),
    [sym__blank_line_start] = ACTIONS(1085),
    [sym__html_block_1_start] = ACTIONS(1085),
    [sym__html_block_2_start] = ACTIONS(1085),
    [sym__html_block_3_start] = ACTIONS(1085),
    [sym__html_block_4_start] = ACTIONS(1085),
    [sym__html_block_5_start] = ACTIONS(1085),
    [sym__html_block_6_start] = ACTIONS(1085),
    [sym__html_block_7_start] = ACTIONS(1085),
    [sym__pipe_table_start] = ACTIONS(1085),
  },
  [100] = {
    [sym_list_marker_dot] = STATE(7),
    [sym__list_item_dot] = STATE(100),
    [aux_sym__list_dot_repeat1] = STATE(100),
    [anon_sym_LBRACK] = ACTIONS(1094),
    [anon_sym_RBRACK] = ACTIONS(1092),
    [anon_sym_LT] = ACTIONS(1092),
    [anon_sym_GT] = ACTIONS(1092),
    [anon_sym_BANG] = ACTIONS(1092),
    [anon_sym_DQUOTE] = ACTIONS(1092),
    [anon_sym_POUND] = ACTIONS(1092),
    [anon_sym_DOLLAR] = ACTIONS(1092),
    [anon_sym_PERCENT] = ACTIONS(1092),
    [anon_sym_AMP] = ACTIONS(1092),
    [anon_sym_SQUOTE] = ACTIONS(1092),
    [anon_sym_STAR] = ACTIONS(1092),
    [anon_sym_PLUS] = ACTIONS(1092),
    [anon_sym_COMMA] = ACTIONS(1092),
    [anon_sym_DASH] = ACTIONS(1092),
    [anon_sym_DOT] = ACTIONS(1092),
    [anon_sym_SLASH] = ACTIONS(1092),
    [anon_sym_COLON] = ACTIONS(1092),
    [anon_sym_SEMI] = ACTIONS(1092),
    [anon_sym_EQ] = ACTIONS(1092),
    [anon_sym_QMARK] = ACTIONS(1092),
    [anon_sym_AT] = ACTIONS(1092),
    [anon_sym_BSLASH] = ACTIONS(1092),
    [anon_sym_CARET] = ACTIONS(1092),
    [anon_sym__] = ACTIONS(1092),
    [anon_sym_BQUOTE] = ACTIONS(1092),
    [anon_sym_LBRACE] = ACTIONS(1092),
    [anon_sym_PIPE] = ACTIONS(1092),
    [anon_sym_RBRACE] = ACTIONS(1092),
    [anon_sym_TILDE] = ACTIONS(1092),
    [anon_sym_LPAREN] = ACTIONS(1092),
    [anon_sym_RPAREN] = ACTIONS(1092),
    [aux_sym__word_token1] = ACTIONS(1092),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1092),
    [aux_sym__word_token2] = ACTIONS(1092),
    [sym__whitespace] = ACTIONS(1092),
    [sym__soft_line_ending] = ACTIONS(1092),
    [sym__block_close] = ACTIONS(1092),
    [sym__block_quote_start] = ACTIONS(1092),
    [sym__indented_chunk_start] = ACTIONS(1092),
    [sym_atx_h1_marker] = ACTIONS(1092),
    [sym_atx_h2_marker] = ACTIONS(1092),
    [sym_atx_h3_marker] = ACTIONS(1092),
    [sym_atx_h4_marker] = ACTIONS(1092),
    [sym_atx_h5_marker] = ACTIONS(1092),
    [sym_atx_h6_marker] = ACTIONS(1092),
    [sym__thematic_break] = ACTIONS(1092),
    [sym__list_marker_minus] = ACTIONS(1092),
    [sym__list_marker_plus] = ACTIONS(1092),
    [sym__list_marker_star] = ACTIONS(1092),
    [sym__list_marker_parenthesis] = ACTIONS(1092),
    [sym__list_marker_dot] = ACTIONS(1096),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1092),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1092),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1092),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1092),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1096),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1092),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1092),
    [sym__blank_line_start] = ACTIONS(1092),
    [sym__html_block_1_start] = ACTIONS(1092),
    [sym__html_block_2_start] = ACTIONS(1092),
    [sym__html_block_3_start] = ACTIONS(1092),
    [sym__html_block_4_start] = ACTIONS(1092),
    [sym__html_block_5_start] = ACTIONS(1092),
    [sym__html_block_6_start] = ACTIONS(1092),
    [sym__html_block_7_start] = ACTIONS(1092),
    [sym__pipe_table_start] = ACTIONS(1092),
  },
  [101] = {
    [sym_link_title] = STATE(723),
    [ts_builtin_sym_end] = ACTIONS(1145),
    [anon_sym_LBRACK] = ACTIONS(1147),
    [anon_sym_RBRACK] = ACTIONS(1145),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_GT] = ACTIONS(1145),
    [anon_sym_BANG] = ACTIONS(1145),
    [anon_sym_DQUOTE] = ACTIONS(1149),
    [anon_sym_POUND] = ACTIONS(1145),
    [anon_sym_DOLLAR] = ACTIONS(1145),
    [anon_sym_PERCENT] = ACTIONS(1145),
    [anon_sym_AMP] = ACTIONS(1145),
    [anon_sym_SQUOTE] = ACTIONS(1152),
    [anon_sym_STAR] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1145),
    [anon_sym_COMMA] = ACTIONS(1145),
    [anon_sym_DASH] = ACTIONS(1145),
    [anon_sym_DOT] = ACTIONS(1145),
    [anon_sym_SLASH] = ACTIONS(1145),
    [anon_sym_COLON] = ACTIONS(1145),
    [anon_sym_SEMI] = ACTIONS(1145),
    [anon_sym_EQ] = ACTIONS(1145),
    [anon_sym_QMARK] = ACTIONS(1145),
    [anon_sym_AT] = ACTIONS(1145),
    [anon_sym_BSLASH] = ACTIONS(1145),
    [anon_sym_CARET] = ACTIONS(1145),
    [anon_sym__] = ACTIONS(1145),
    [anon_sym_BQUOTE] = ACTIONS(1145),
    [anon_sym_LBRACE] = ACTIONS(1145),
    [anon_sym_PIPE] = ACTIONS(1145),
    [anon_sym_RBRACE] = ACTIONS(1145),
    [anon_sym_TILDE] = ACTIONS(1145),
    [anon_sym_LPAREN] = ACTIONS(1155),
    [anon_sym_RPAREN] = ACTIONS(1145),
    [aux_sym__word_token1] = ACTIONS(1145),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1145),
    [aux_sym__word_token2] = ACTIONS(1145),
    [sym__whitespace] = ACTIONS(1158),
    [sym__soft_line_ending] = ACTIONS(1145),
    [sym__block_quote_start] = ACTIONS(1145),
    [sym__indented_chunk_start] = ACTIONS(1145),
    [sym_atx_h1_marker] = ACTIONS(1145),
    [sym_atx_h2_marker] = ACTIONS(1145),
    [sym_atx_h3_marker] = ACTIONS(1145),
    [sym_atx_h4_marker] = ACTIONS(1145),
    [sym_atx_h5_marker] = ACTIONS(1145),
    [sym_atx_h6_marker] = ACTIONS(1145),
    [sym__thematic_break] = ACTIONS(1145),
    [sym__list_marker_minus] = ACTIONS(1145),
    [sym__list_marker_plus] = ACTIONS(1145),
    [sym__list_marker_star] = ACTIONS(1145),
    [sym__list_marker_parenthesis] = ACTIONS(1145),
    [sym__list_marker_dot] = ACTIONS(1145),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1145),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1145),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1145),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1145),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1145),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1145),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1145),
    [sym__blank_line_start] = ACTIONS(1145),
    [sym__html_block_1_start] = ACTIONS(1145),
    [sym__html_block_2_start] = ACTIONS(1145),
    [sym__html_block_3_start] = ACTIONS(1145),
    [sym__html_block_4_start] = ACTIONS(1145),
    [sym__html_block_5_start] = ACTIONS(1145),
    [sym__html_block_6_start] = ACTIONS(1145),
    [sym__html_block_7_start] = ACTIONS(1145),
    [sym__no_indented_chunk] = ACTIONS(1161),
    [sym__pipe_table_start] = ACTIONS(1145),
  },
  [102] = {
    [anon_sym_LBRACK] = ACTIONS(1163),
    [anon_sym_RBRACK] = ACTIONS(1165),
    [anon_sym_LT] = ACTIONS(1165),
    [anon_sym_GT] = ACTIONS(1165),
    [anon_sym_BANG] = ACTIONS(1165),
    [anon_sym_DQUOTE] = ACTIONS(1165),
    [anon_sym_POUND] = ACTIONS(1165),
    [anon_sym_DOLLAR] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(1165),
    [anon_sym_AMP] = ACTIONS(1165),
    [anon_sym_SQUOTE] = ACTIONS(1165),
    [anon_sym_STAR] = ACTIONS(1165),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_COMMA] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_DOT] = ACTIONS(1165),
    [anon_sym_SLASH] = ACTIONS(1165),
    [anon_sym_COLON] = ACTIONS(1165),
    [anon_sym_SEMI] = ACTIONS(1165),
    [anon_sym_EQ] = ACTIONS(1165),
    [anon_sym_QMARK] = ACTIONS(1165),
    [anon_sym_AT] = ACTIONS(1165),
    [anon_sym_BSLASH] = ACTIONS(1165),
    [anon_sym_CARET] = ACTIONS(1165),
    [anon_sym__] = ACTIONS(1165),
    [anon_sym_BQUOTE] = ACTIONS(1165),
    [anon_sym_LBRACE] = ACTIONS(1165),
    [anon_sym_PIPE] = ACTIONS(1165),
    [anon_sym_RBRACE] = ACTIONS(1165),
    [anon_sym_TILDE] = ACTIONS(1165),
    [anon_sym_LPAREN] = ACTIONS(1165),
    [anon_sym_RPAREN] = ACTIONS(1165),
    [aux_sym__word_token1] = ACTIONS(1165),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1165),
    [aux_sym__word_token2] = ACTIONS(1165),
    [sym__whitespace] = ACTIONS(1165),
    [sym__soft_line_ending] = ACTIONS(1165),
    [sym__block_close] = ACTIONS(1165),
    [sym_block_continuation] = ACTIONS(1167),
    [sym__block_quote_start] = ACTIONS(1165),
    [sym__indented_chunk_start] = ACTIONS(1165),
    [sym_atx_h1_marker] = ACTIONS(1165),
    [sym_atx_h2_marker] = ACTIONS(1165),
    [sym_atx_h3_marker] = ACTIONS(1165),
    [sym_atx_h4_marker] = ACTIONS(1165),
    [sym_atx_h5_marker] = ACTIONS(1165),
    [sym_atx_h6_marker] = ACTIONS(1165),
    [sym__thematic_break] = ACTIONS(1165),
    [sym__list_marker_minus] = ACTIONS(1165),
    [sym__list_marker_plus] = ACTIONS(1165),
    [sym__list_marker_star] = ACTIONS(1165),
    [sym__list_marker_parenthesis] = ACTIONS(1165),
    [sym__list_marker_dot] = ACTIONS(1165),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1165),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1165),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1165),
    [sym__blank_line_start] = ACTIONS(1165),
    [sym__html_block_1_start] = ACTIONS(1165),
    [sym__html_block_2_start] = ACTIONS(1165),
    [sym__html_block_3_start] = ACTIONS(1165),
    [sym__html_block_4_start] = ACTIONS(1165),
    [sym__html_block_5_start] = ACTIONS(1165),
    [sym__html_block_6_start] = ACTIONS(1165),
    [sym__html_block_7_start] = ACTIONS(1165),
    [sym__no_indented_chunk] = ACTIONS(1165),
    [sym__pipe_table_start] = ACTIONS(1165),
  },
  [103] = {
    [sym_link_title] = STATE(698),
    [ts_builtin_sym_end] = ACTIONS(1169),
    [anon_sym_LBRACK] = ACTIONS(1171),
    [anon_sym_RBRACK] = ACTIONS(1169),
    [anon_sym_LT] = ACTIONS(1169),
    [anon_sym_GT] = ACTIONS(1169),
    [anon_sym_BANG] = ACTIONS(1169),
    [anon_sym_DQUOTE] = ACTIONS(1173),
    [anon_sym_POUND] = ACTIONS(1169),
    [anon_sym_DOLLAR] = ACTIONS(1169),
    [anon_sym_PERCENT] = ACTIONS(1169),
    [anon_sym_AMP] = ACTIONS(1169),
    [anon_sym_SQUOTE] = ACTIONS(1176),
    [anon_sym_STAR] = ACTIONS(1169),
    [anon_sym_PLUS] = ACTIONS(1169),
    [anon_sym_COMMA] = ACTIONS(1169),
    [anon_sym_DASH] = ACTIONS(1169),
    [anon_sym_DOT] = ACTIONS(1169),
    [anon_sym_SLASH] = ACTIONS(1169),
    [anon_sym_COLON] = ACTIONS(1169),
    [anon_sym_SEMI] = ACTIONS(1169),
    [anon_sym_EQ] = ACTIONS(1169),
    [anon_sym_QMARK] = ACTIONS(1169),
    [anon_sym_AT] = ACTIONS(1169),
    [anon_sym_BSLASH] = ACTIONS(1169),
    [anon_sym_CARET] = ACTIONS(1169),
    [anon_sym__] = ACTIONS(1169),
    [anon_sym_BQUOTE] = ACTIONS(1169),
    [anon_sym_LBRACE] = ACTIONS(1169),
    [anon_sym_PIPE] = ACTIONS(1169),
    [anon_sym_RBRACE] = ACTIONS(1169),
    [anon_sym_TILDE] = ACTIONS(1169),
    [anon_sym_LPAREN] = ACTIONS(1179),
    [anon_sym_RPAREN] = ACTIONS(1169),
    [aux_sym__word_token1] = ACTIONS(1169),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1169),
    [aux_sym__word_token2] = ACTIONS(1169),
    [sym__whitespace] = ACTIONS(1182),
    [sym__soft_line_ending] = ACTIONS(1169),
    [sym__block_quote_start] = ACTIONS(1169),
    [sym__indented_chunk_start] = ACTIONS(1169),
    [sym_atx_h1_marker] = ACTIONS(1169),
    [sym_atx_h2_marker] = ACTIONS(1169),
    [sym_atx_h3_marker] = ACTIONS(1169),
    [sym_atx_h4_marker] = ACTIONS(1169),
    [sym_atx_h5_marker] = ACTIONS(1169),
    [sym_atx_h6_marker] = ACTIONS(1169),
    [sym__thematic_break] = ACTIONS(1169),
    [sym__list_marker_minus] = ACTIONS(1169),
    [sym__list_marker_plus] = ACTIONS(1169),
    [sym__list_marker_star] = ACTIONS(1169),
    [sym__list_marker_parenthesis] = ACTIONS(1169),
    [sym__list_marker_dot] = ACTIONS(1169),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1169),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1169),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1169),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1169),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1169),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1169),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1169),
    [sym__blank_line_start] = ACTIONS(1169),
    [sym__html_block_1_start] = ACTIONS(1169),
    [sym__html_block_2_start] = ACTIONS(1169),
    [sym__html_block_3_start] = ACTIONS(1169),
    [sym__html_block_4_start] = ACTIONS(1169),
    [sym__html_block_5_start] = ACTIONS(1169),
    [sym__html_block_6_start] = ACTIONS(1169),
    [sym__html_block_7_start] = ACTIONS(1169),
    [sym__no_indented_chunk] = ACTIONS(1185),
    [sym__pipe_table_start] = ACTIONS(1169),
  },
  [104] = {
    [sym_link_title] = STATE(711),
    [anon_sym_LBRACK] = ACTIONS(1187),
    [anon_sym_RBRACK] = ACTIONS(1189),
    [anon_sym_LT] = ACTIONS(1189),
    [anon_sym_GT] = ACTIONS(1189),
    [anon_sym_BANG] = ACTIONS(1189),
    [anon_sym_DQUOTE] = ACTIONS(1191),
    [anon_sym_POUND] = ACTIONS(1189),
    [anon_sym_DOLLAR] = ACTIONS(1189),
    [anon_sym_PERCENT] = ACTIONS(1189),
    [anon_sym_AMP] = ACTIONS(1189),
    [anon_sym_SQUOTE] = ACTIONS(1194),
    [anon_sym_STAR] = ACTIONS(1189),
    [anon_sym_PLUS] = ACTIONS(1189),
    [anon_sym_COMMA] = ACTIONS(1189),
    [anon_sym_DASH] = ACTIONS(1189),
    [anon_sym_DOT] = ACTIONS(1189),
    [anon_sym_SLASH] = ACTIONS(1189),
    [anon_sym_COLON] = ACTIONS(1189),
    [anon_sym_SEMI] = ACTIONS(1189),
    [anon_sym_EQ] = ACTIONS(1189),
    [anon_sym_QMARK] = ACTIONS(1189),
    [anon_sym_AT] = ACTIONS(1189),
    [anon_sym_BSLASH] = ACTIONS(1189),
    [anon_sym_CARET] = ACTIONS(1189),
    [anon_sym__] = ACTIONS(1189),
    [anon_sym_BQUOTE] = ACTIONS(1189),
    [anon_sym_LBRACE] = ACTIONS(1189),
    [anon_sym_PIPE] = ACTIONS(1189),
    [anon_sym_RBRACE] = ACTIONS(1189),
    [anon_sym_TILDE] = ACTIONS(1189),
    [anon_sym_LPAREN] = ACTIONS(1197),
    [anon_sym_RPAREN] = ACTIONS(1189),
    [aux_sym__word_token1] = ACTIONS(1189),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1189),
    [aux_sym__word_token2] = ACTIONS(1189),
    [sym__whitespace] = ACTIONS(1200),
    [sym__soft_line_ending] = ACTIONS(1189),
    [sym__block_close] = ACTIONS(1189),
    [sym__block_quote_start] = ACTIONS(1189),
    [sym__indented_chunk_start] = ACTIONS(1189),
    [sym_atx_h1_marker] = ACTIONS(1189),
    [sym_atx_h2_marker] = ACTIONS(1189),
    [sym_atx_h3_marker] = ACTIONS(1189),
    [sym_atx_h4_marker] = ACTIONS(1189),
    [sym_atx_h5_marker] = ACTIONS(1189),
    [sym_atx_h6_marker] = ACTIONS(1189),
    [sym__thematic_break] = ACTIONS(1189),
    [sym__list_marker_minus] = ACTIONS(1189),
    [sym__list_marker_plus] = ACTIONS(1189),
    [sym__list_marker_star] = ACTIONS(1189),
    [sym__list_marker_parenthesis] = ACTIONS(1189),
    [sym__list_marker_dot] = ACTIONS(1189),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1189),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1189),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1189),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1189),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1189),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1189),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1189),
    [sym__blank_line_start] = ACTIONS(1189),
    [sym__html_block_1_start] = ACTIONS(1189),
    [sym__html_block_2_start] = ACTIONS(1189),
    [sym__html_block_3_start] = ACTIONS(1189),
    [sym__html_block_4_start] = ACTIONS(1189),
    [sym__html_block_5_start] = ACTIONS(1189),
    [sym__html_block_6_start] = ACTIONS(1189),
    [sym__html_block_7_start] = ACTIONS(1189),
    [sym__no_indented_chunk] = ACTIONS(1203),
    [sym__pipe_table_start] = ACTIONS(1189),
  },
  [105] = {
    [sym_link_title] = STATE(733),
    [ts_builtin_sym_end] = ACTIONS(1205),
    [anon_sym_LBRACK] = ACTIONS(1207),
    [anon_sym_RBRACK] = ACTIONS(1205),
    [anon_sym_LT] = ACTIONS(1205),
    [anon_sym_GT] = ACTIONS(1205),
    [anon_sym_BANG] = ACTIONS(1205),
    [anon_sym_DQUOTE] = ACTIONS(1209),
    [anon_sym_POUND] = ACTIONS(1205),
    [anon_sym_DOLLAR] = ACTIONS(1205),
    [anon_sym_PERCENT] = ACTIONS(1205),
    [anon_sym_AMP] = ACTIONS(1205),
    [anon_sym_SQUOTE] = ACTIONS(1212),
    [anon_sym_STAR] = ACTIONS(1205),
    [anon_sym_PLUS] = ACTIONS(1205),
    [anon_sym_COMMA] = ACTIONS(1205),
    [anon_sym_DASH] = ACTIONS(1205),
    [anon_sym_DOT] = ACTIONS(1205),
    [anon_sym_SLASH] = ACTIONS(1205),
    [anon_sym_COLON] = ACTIONS(1205),
    [anon_sym_SEMI] = ACTIONS(1205),
    [anon_sym_EQ] = ACTIONS(1205),
    [anon_sym_QMARK] = ACTIONS(1205),
    [anon_sym_AT] = ACTIONS(1205),
    [anon_sym_BSLASH] = ACTIONS(1205),
    [anon_sym_CARET] = ACTIONS(1205),
    [anon_sym__] = ACTIONS(1205),
    [anon_sym_BQUOTE] = ACTIONS(1205),
    [anon_sym_LBRACE] = ACTIONS(1205),
    [anon_sym_PIPE] = ACTIONS(1205),
    [anon_sym_RBRACE] = ACTIONS(1205),
    [anon_sym_TILDE] = ACTIONS(1205),
    [anon_sym_LPAREN] = ACTIONS(1215),
    [anon_sym_RPAREN] = ACTIONS(1205),
    [aux_sym__word_token1] = ACTIONS(1205),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1205),
    [aux_sym__word_token2] = ACTIONS(1205),
    [sym__whitespace] = ACTIONS(1218),
    [sym__soft_line_ending] = ACTIONS(1205),
    [sym__block_quote_start] = ACTIONS(1205),
    [sym__indented_chunk_start] = ACTIONS(1205),
    [sym_atx_h1_marker] = ACTIONS(1205),
    [sym_atx_h2_marker] = ACTIONS(1205),
    [sym_atx_h3_marker] = ACTIONS(1205),
    [sym_atx_h4_marker] = ACTIONS(1205),
    [sym_atx_h5_marker] = ACTIONS(1205),
    [sym_atx_h6_marker] = ACTIONS(1205),
    [sym__thematic_break] = ACTIONS(1205),
    [sym__list_marker_minus] = ACTIONS(1205),
    [sym__list_marker_plus] = ACTIONS(1205),
    [sym__list_marker_star] = ACTIONS(1205),
    [sym__list_marker_parenthesis] = ACTIONS(1205),
    [sym__list_marker_dot] = ACTIONS(1205),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1205),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1205),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1205),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1205),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1205),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1205),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1205),
    [sym__blank_line_start] = ACTIONS(1205),
    [sym__html_block_1_start] = ACTIONS(1205),
    [sym__html_block_2_start] = ACTIONS(1205),
    [sym__html_block_3_start] = ACTIONS(1205),
    [sym__html_block_4_start] = ACTIONS(1205),
    [sym__html_block_5_start] = ACTIONS(1205),
    [sym__html_block_6_start] = ACTIONS(1205),
    [sym__html_block_7_start] = ACTIONS(1205),
    [sym__no_indented_chunk] = ACTIONS(1221),
    [sym__pipe_table_start] = ACTIONS(1205),
  },
  [106] = {
    [sym_link_title] = STATE(690),
    [ts_builtin_sym_end] = ACTIONS(1189),
    [anon_sym_LBRACK] = ACTIONS(1187),
    [anon_sym_RBRACK] = ACTIONS(1189),
    [anon_sym_LT] = ACTIONS(1189),
    [anon_sym_GT] = ACTIONS(1189),
    [anon_sym_BANG] = ACTIONS(1189),
    [anon_sym_DQUOTE] = ACTIONS(1191),
    [anon_sym_POUND] = ACTIONS(1189),
    [anon_sym_DOLLAR] = ACTIONS(1189),
    [anon_sym_PERCENT] = ACTIONS(1189),
    [anon_sym_AMP] = ACTIONS(1189),
    [anon_sym_SQUOTE] = ACTIONS(1194),
    [anon_sym_STAR] = ACTIONS(1189),
    [anon_sym_PLUS] = ACTIONS(1189),
    [anon_sym_COMMA] = ACTIONS(1189),
    [anon_sym_DASH] = ACTIONS(1189),
    [anon_sym_DOT] = ACTIONS(1189),
    [anon_sym_SLASH] = ACTIONS(1189),
    [anon_sym_COLON] = ACTIONS(1189),
    [anon_sym_SEMI] = ACTIONS(1189),
    [anon_sym_EQ] = ACTIONS(1189),
    [anon_sym_QMARK] = ACTIONS(1189),
    [anon_sym_AT] = ACTIONS(1189),
    [anon_sym_BSLASH] = ACTIONS(1189),
    [anon_sym_CARET] = ACTIONS(1189),
    [anon_sym__] = ACTIONS(1189),
    [anon_sym_BQUOTE] = ACTIONS(1189),
    [anon_sym_LBRACE] = ACTIONS(1189),
    [anon_sym_PIPE] = ACTIONS(1189),
    [anon_sym_RBRACE] = ACTIONS(1189),
    [anon_sym_TILDE] = ACTIONS(1189),
    [anon_sym_LPAREN] = ACTIONS(1197),
    [anon_sym_RPAREN] = ACTIONS(1189),
    [aux_sym__word_token1] = ACTIONS(1189),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1189),
    [aux_sym__word_token2] = ACTIONS(1189),
    [sym__whitespace] = ACTIONS(1223),
    [sym__soft_line_ending] = ACTIONS(1189),
    [sym__block_quote_start] = ACTIONS(1189),
    [sym__indented_chunk_start] = ACTIONS(1189),
    [sym_atx_h1_marker] = ACTIONS(1189),
    [sym_atx_h2_marker] = ACTIONS(1189),
    [sym_atx_h3_marker] = ACTIONS(1189),
    [sym_atx_h4_marker] = ACTIONS(1189),
    [sym_atx_h5_marker] = ACTIONS(1189),
    [sym_atx_h6_marker] = ACTIONS(1189),
    [sym__thematic_break] = ACTIONS(1189),
    [sym__list_marker_minus] = ACTIONS(1189),
    [sym__list_marker_plus] = ACTIONS(1189),
    [sym__list_marker_star] = ACTIONS(1189),
    [sym__list_marker_parenthesis] = ACTIONS(1189),
    [sym__list_marker_dot] = ACTIONS(1189),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1189),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1189),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1189),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1189),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1189),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1189),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1189),
    [sym__blank_line_start] = ACTIONS(1189),
    [sym__html_block_1_start] = ACTIONS(1189),
    [sym__html_block_2_start] = ACTIONS(1189),
    [sym__html_block_3_start] = ACTIONS(1189),
    [sym__html_block_4_start] = ACTIONS(1189),
    [sym__html_block_5_start] = ACTIONS(1189),
    [sym__html_block_6_start] = ACTIONS(1189),
    [sym__html_block_7_start] = ACTIONS(1189),
    [sym__no_indented_chunk] = ACTIONS(1226),
    [sym__pipe_table_start] = ACTIONS(1189),
  },
  [107] = {
    [sym_link_title] = STATE(709),
    [anon_sym_LBRACK] = ACTIONS(1228),
    [anon_sym_RBRACK] = ACTIONS(1230),
    [anon_sym_LT] = ACTIONS(1230),
    [anon_sym_GT] = ACTIONS(1230),
    [anon_sym_BANG] = ACTIONS(1230),
    [anon_sym_DQUOTE] = ACTIONS(1232),
    [anon_sym_POUND] = ACTIONS(1230),
    [anon_sym_DOLLAR] = ACTIONS(1230),
    [anon_sym_PERCENT] = ACTIONS(1230),
    [anon_sym_AMP] = ACTIONS(1230),
    [anon_sym_SQUOTE] = ACTIONS(1235),
    [anon_sym_STAR] = ACTIONS(1230),
    [anon_sym_PLUS] = ACTIONS(1230),
    [anon_sym_COMMA] = ACTIONS(1230),
    [anon_sym_DASH] = ACTIONS(1230),
    [anon_sym_DOT] = ACTIONS(1230),
    [anon_sym_SLASH] = ACTIONS(1230),
    [anon_sym_COLON] = ACTIONS(1230),
    [anon_sym_SEMI] = ACTIONS(1230),
    [anon_sym_EQ] = ACTIONS(1230),
    [anon_sym_QMARK] = ACTIONS(1230),
    [anon_sym_AT] = ACTIONS(1230),
    [anon_sym_BSLASH] = ACTIONS(1230),
    [anon_sym_CARET] = ACTIONS(1230),
    [anon_sym__] = ACTIONS(1230),
    [anon_sym_BQUOTE] = ACTIONS(1230),
    [anon_sym_LBRACE] = ACTIONS(1230),
    [anon_sym_PIPE] = ACTIONS(1230),
    [anon_sym_RBRACE] = ACTIONS(1230),
    [anon_sym_TILDE] = ACTIONS(1230),
    [anon_sym_LPAREN] = ACTIONS(1238),
    [anon_sym_RPAREN] = ACTIONS(1230),
    [aux_sym__word_token1] = ACTIONS(1230),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1230),
    [aux_sym__word_token2] = ACTIONS(1230),
    [sym__whitespace] = ACTIONS(1241),
    [sym__soft_line_ending] = ACTIONS(1230),
    [sym__block_close] = ACTIONS(1230),
    [sym__block_quote_start] = ACTIONS(1230),
    [sym__indented_chunk_start] = ACTIONS(1230),
    [sym_atx_h1_marker] = ACTIONS(1230),
    [sym_atx_h2_marker] = ACTIONS(1230),
    [sym_atx_h3_marker] = ACTIONS(1230),
    [sym_atx_h4_marker] = ACTIONS(1230),
    [sym_atx_h5_marker] = ACTIONS(1230),
    [sym_atx_h6_marker] = ACTIONS(1230),
    [sym__thematic_break] = ACTIONS(1230),
    [sym__list_marker_minus] = ACTIONS(1230),
    [sym__list_marker_plus] = ACTIONS(1230),
    [sym__list_marker_star] = ACTIONS(1230),
    [sym__list_marker_parenthesis] = ACTIONS(1230),
    [sym__list_marker_dot] = ACTIONS(1230),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1230),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1230),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1230),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1230),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1230),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1230),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1230),
    [sym__blank_line_start] = ACTIONS(1230),
    [sym__html_block_1_start] = ACTIONS(1230),
    [sym__html_block_2_start] = ACTIONS(1230),
    [sym__html_block_3_start] = ACTIONS(1230),
    [sym__html_block_4_start] = ACTIONS(1230),
    [sym__html_block_5_start] = ACTIONS(1230),
    [sym__html_block_6_start] = ACTIONS(1230),
    [sym__html_block_7_start] = ACTIONS(1230),
    [sym__no_indented_chunk] = ACTIONS(1244),
    [sym__pipe_table_start] = ACTIONS(1230),
  },
  [108] = {
    [ts_builtin_sym_end] = ACTIONS(1165),
    [anon_sym_LBRACK] = ACTIONS(1163),
    [anon_sym_RBRACK] = ACTIONS(1165),
    [anon_sym_LT] = ACTIONS(1165),
    [anon_sym_GT] = ACTIONS(1165),
    [anon_sym_BANG] = ACTIONS(1165),
    [anon_sym_DQUOTE] = ACTIONS(1165),
    [anon_sym_POUND] = ACTIONS(1165),
    [anon_sym_DOLLAR] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(1165),
    [anon_sym_AMP] = ACTIONS(1165),
    [anon_sym_SQUOTE] = ACTIONS(1165),
    [anon_sym_STAR] = ACTIONS(1165),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_COMMA] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_DOT] = ACTIONS(1165),
    [anon_sym_SLASH] = ACTIONS(1165),
    [anon_sym_COLON] = ACTIONS(1165),
    [anon_sym_SEMI] = ACTIONS(1165),
    [anon_sym_EQ] = ACTIONS(1165),
    [anon_sym_QMARK] = ACTIONS(1165),
    [anon_sym_AT] = ACTIONS(1165),
    [anon_sym_BSLASH] = ACTIONS(1165),
    [anon_sym_CARET] = ACTIONS(1165),
    [anon_sym__] = ACTIONS(1165),
    [anon_sym_BQUOTE] = ACTIONS(1165),
    [anon_sym_LBRACE] = ACTIONS(1165),
    [anon_sym_PIPE] = ACTIONS(1165),
    [anon_sym_RBRACE] = ACTIONS(1165),
    [anon_sym_TILDE] = ACTIONS(1165),
    [anon_sym_LPAREN] = ACTIONS(1165),
    [anon_sym_RPAREN] = ACTIONS(1165),
    [aux_sym__word_token1] = ACTIONS(1165),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1165),
    [aux_sym__word_token2] = ACTIONS(1165),
    [sym__whitespace] = ACTIONS(1165),
    [sym__soft_line_ending] = ACTIONS(1165),
    [sym_block_continuation] = ACTIONS(1246),
    [sym__block_quote_start] = ACTIONS(1165),
    [sym__indented_chunk_start] = ACTIONS(1165),
    [sym_atx_h1_marker] = ACTIONS(1165),
    [sym_atx_h2_marker] = ACTIONS(1165),
    [sym_atx_h3_marker] = ACTIONS(1165),
    [sym_atx_h4_marker] = ACTIONS(1165),
    [sym_atx_h5_marker] = ACTIONS(1165),
    [sym_atx_h6_marker] = ACTIONS(1165),
    [sym__thematic_break] = ACTIONS(1165),
    [sym__list_marker_minus] = ACTIONS(1165),
    [sym__list_marker_plus] = ACTIONS(1165),
    [sym__list_marker_star] = ACTIONS(1165),
    [sym__list_marker_parenthesis] = ACTIONS(1165),
    [sym__list_marker_dot] = ACTIONS(1165),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1165),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1165),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1165),
    [sym__blank_line_start] = ACTIONS(1165),
    [sym__html_block_1_start] = ACTIONS(1165),
    [sym__html_block_2_start] = ACTIONS(1165),
    [sym__html_block_3_start] = ACTIONS(1165),
    [sym__html_block_4_start] = ACTIONS(1165),
    [sym__html_block_5_start] = ACTIONS(1165),
    [sym__html_block_6_start] = ACTIONS(1165),
    [sym__html_block_7_start] = ACTIONS(1165),
    [sym__no_indented_chunk] = ACTIONS(1165),
    [sym__pipe_table_start] = ACTIONS(1165),
  },
  [109] = {
    [anon_sym_LBRACK] = ACTIONS(1248),
    [anon_sym_RBRACK] = ACTIONS(1250),
    [anon_sym_LT] = ACTIONS(1250),
    [anon_sym_GT] = ACTIONS(1250),
    [anon_sym_BANG] = ACTIONS(1250),
    [anon_sym_DQUOTE] = ACTIONS(1250),
    [anon_sym_POUND] = ACTIONS(1250),
    [anon_sym_DOLLAR] = ACTIONS(1250),
    [anon_sym_PERCENT] = ACTIONS(1250),
    [anon_sym_AMP] = ACTIONS(1250),
    [anon_sym_SQUOTE] = ACTIONS(1250),
    [anon_sym_STAR] = ACTIONS(1250),
    [anon_sym_PLUS] = ACTIONS(1250),
    [anon_sym_COMMA] = ACTIONS(1250),
    [anon_sym_DASH] = ACTIONS(1250),
    [anon_sym_DOT] = ACTIONS(1250),
    [anon_sym_SLASH] = ACTIONS(1250),
    [anon_sym_COLON] = ACTIONS(1250),
    [anon_sym_SEMI] = ACTIONS(1250),
    [anon_sym_EQ] = ACTIONS(1250),
    [anon_sym_QMARK] = ACTIONS(1250),
    [anon_sym_AT] = ACTIONS(1250),
    [anon_sym_BSLASH] = ACTIONS(1250),
    [anon_sym_CARET] = ACTIONS(1250),
    [anon_sym__] = ACTIONS(1250),
    [anon_sym_BQUOTE] = ACTIONS(1250),
    [anon_sym_LBRACE] = ACTIONS(1250),
    [anon_sym_PIPE] = ACTIONS(1250),
    [anon_sym_RBRACE] = ACTIONS(1250),
    [anon_sym_TILDE] = ACTIONS(1250),
    [anon_sym_LPAREN] = ACTIONS(1250),
    [anon_sym_RPAREN] = ACTIONS(1250),
    [aux_sym__word_token1] = ACTIONS(1250),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1250),
    [aux_sym__word_token2] = ACTIONS(1250),
    [sym__whitespace] = ACTIONS(1250),
    [sym__soft_line_ending] = ACTIONS(1250),
    [sym__block_close] = ACTIONS(1250),
    [sym__block_quote_start] = ACTIONS(1250),
    [sym__indented_chunk_start] = ACTIONS(1250),
    [sym_atx_h1_marker] = ACTIONS(1250),
    [sym_atx_h2_marker] = ACTIONS(1250),
    [sym_atx_h3_marker] = ACTIONS(1250),
    [sym_atx_h4_marker] = ACTIONS(1250),
    [sym_atx_h5_marker] = ACTIONS(1250),
    [sym_atx_h6_marker] = ACTIONS(1250),
    [sym_setext_h1_underline] = ACTIONS(1250),
    [sym_setext_h2_underline] = ACTIONS(1250),
    [sym__thematic_break] = ACTIONS(1250),
    [sym__list_marker_minus] = ACTIONS(1250),
    [sym__list_marker_plus] = ACTIONS(1250),
    [sym__list_marker_star] = ACTIONS(1250),
    [sym__list_marker_parenthesis] = ACTIONS(1250),
    [sym__list_marker_dot] = ACTIONS(1250),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1250),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1250),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1250),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1250),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1250),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1250),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1250),
    [sym__blank_line_start] = ACTIONS(1250),
    [sym__html_block_1_start] = ACTIONS(1250),
    [sym__html_block_2_start] = ACTIONS(1250),
    [sym__html_block_3_start] = ACTIONS(1250),
    [sym__html_block_4_start] = ACTIONS(1250),
    [sym__html_block_5_start] = ACTIONS(1250),
    [sym__html_block_6_start] = ACTIONS(1250),
    [sym__html_block_7_start] = ACTIONS(1250),
    [sym__pipe_table_start] = ACTIONS(1250),
  },
  [110] = {
    [sym_link_title] = STATE(737),
    [ts_builtin_sym_end] = ACTIONS(1230),
    [anon_sym_LBRACK] = ACTIONS(1228),
    [anon_sym_RBRACK] = ACTIONS(1230),
    [anon_sym_LT] = ACTIONS(1230),
    [anon_sym_GT] = ACTIONS(1230),
    [anon_sym_BANG] = ACTIONS(1230),
    [anon_sym_DQUOTE] = ACTIONS(1232),
    [anon_sym_POUND] = ACTIONS(1230),
    [anon_sym_DOLLAR] = ACTIONS(1230),
    [anon_sym_PERCENT] = ACTIONS(1230),
    [anon_sym_AMP] = ACTIONS(1230),
    [anon_sym_SQUOTE] = ACTIONS(1235),
    [anon_sym_STAR] = ACTIONS(1230),
    [anon_sym_PLUS] = ACTIONS(1230),
    [anon_sym_COMMA] = ACTIONS(1230),
    [anon_sym_DASH] = ACTIONS(1230),
    [anon_sym_DOT] = ACTIONS(1230),
    [anon_sym_SLASH] = ACTIONS(1230),
    [anon_sym_COLON] = ACTIONS(1230),
    [anon_sym_SEMI] = ACTIONS(1230),
    [anon_sym_EQ] = ACTIONS(1230),
    [anon_sym_QMARK] = ACTIONS(1230),
    [anon_sym_AT] = ACTIONS(1230),
    [anon_sym_BSLASH] = ACTIONS(1230),
    [anon_sym_CARET] = ACTIONS(1230),
    [anon_sym__] = ACTIONS(1230),
    [anon_sym_BQUOTE] = ACTIONS(1230),
    [anon_sym_LBRACE] = ACTIONS(1230),
    [anon_sym_PIPE] = ACTIONS(1230),
    [anon_sym_RBRACE] = ACTIONS(1230),
    [anon_sym_TILDE] = ACTIONS(1230),
    [anon_sym_LPAREN] = ACTIONS(1238),
    [anon_sym_RPAREN] = ACTIONS(1230),
    [aux_sym__word_token1] = ACTIONS(1230),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1230),
    [aux_sym__word_token2] = ACTIONS(1230),
    [sym__whitespace] = ACTIONS(1252),
    [sym__soft_line_ending] = ACTIONS(1230),
    [sym__block_quote_start] = ACTIONS(1230),
    [sym__indented_chunk_start] = ACTIONS(1230),
    [sym_atx_h1_marker] = ACTIONS(1230),
    [sym_atx_h2_marker] = ACTIONS(1230),
    [sym_atx_h3_marker] = ACTIONS(1230),
    [sym_atx_h4_marker] = ACTIONS(1230),
    [sym_atx_h5_marker] = ACTIONS(1230),
    [sym_atx_h6_marker] = ACTIONS(1230),
    [sym__thematic_break] = ACTIONS(1230),
    [sym__list_marker_minus] = ACTIONS(1230),
    [sym__list_marker_plus] = ACTIONS(1230),
    [sym__list_marker_star] = ACTIONS(1230),
    [sym__list_marker_parenthesis] = ACTIONS(1230),
    [sym__list_marker_dot] = ACTIONS(1230),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1230),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1230),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1230),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1230),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1230),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1230),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1230),
    [sym__blank_line_start] = ACTIONS(1230),
    [sym__html_block_1_start] = ACTIONS(1230),
    [sym__html_block_2_start] = ACTIONS(1230),
    [sym__html_block_3_start] = ACTIONS(1230),
    [sym__html_block_4_start] = ACTIONS(1230),
    [sym__html_block_5_start] = ACTIONS(1230),
    [sym__html_block_6_start] = ACTIONS(1230),
    [sym__html_block_7_start] = ACTIONS(1230),
    [sym__no_indented_chunk] = ACTIONS(1255),
    [sym__pipe_table_start] = ACTIONS(1230),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(1257),
    [anon_sym_LBRACK] = ACTIONS(1259),
    [anon_sym_RBRACK] = ACTIONS(1257),
    [anon_sym_LT] = ACTIONS(1257),
    [anon_sym_GT] = ACTIONS(1257),
    [anon_sym_BANG] = ACTIONS(1257),
    [anon_sym_DQUOTE] = ACTIONS(1257),
    [anon_sym_POUND] = ACTIONS(1257),
    [anon_sym_DOLLAR] = ACTIONS(1257),
    [anon_sym_PERCENT] = ACTIONS(1257),
    [anon_sym_AMP] = ACTIONS(1257),
    [anon_sym_SQUOTE] = ACTIONS(1257),
    [anon_sym_STAR] = ACTIONS(1257),
    [anon_sym_PLUS] = ACTIONS(1257),
    [anon_sym_COMMA] = ACTIONS(1257),
    [anon_sym_DASH] = ACTIONS(1257),
    [anon_sym_DOT] = ACTIONS(1257),
    [anon_sym_SLASH] = ACTIONS(1257),
    [anon_sym_COLON] = ACTIONS(1257),
    [anon_sym_SEMI] = ACTIONS(1257),
    [anon_sym_EQ] = ACTIONS(1257),
    [anon_sym_QMARK] = ACTIONS(1257),
    [anon_sym_AT] = ACTIONS(1257),
    [anon_sym_BSLASH] = ACTIONS(1257),
    [anon_sym_CARET] = ACTIONS(1257),
    [anon_sym__] = ACTIONS(1257),
    [anon_sym_BQUOTE] = ACTIONS(1257),
    [anon_sym_LBRACE] = ACTIONS(1257),
    [anon_sym_PIPE] = ACTIONS(1257),
    [anon_sym_RBRACE] = ACTIONS(1257),
    [anon_sym_TILDE] = ACTIONS(1257),
    [anon_sym_LPAREN] = ACTIONS(1257),
    [anon_sym_RPAREN] = ACTIONS(1257),
    [aux_sym__word_token1] = ACTIONS(1257),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1257),
    [aux_sym__word_token2] = ACTIONS(1257),
    [sym__whitespace] = ACTIONS(1257),
    [sym__soft_line_ending] = ACTIONS(1257),
    [sym__block_quote_start] = ACTIONS(1257),
    [sym__indented_chunk_start] = ACTIONS(1257),
    [sym_atx_h1_marker] = ACTIONS(1257),
    [sym_atx_h2_marker] = ACTIONS(1257),
    [sym_atx_h3_marker] = ACTIONS(1257),
    [sym_atx_h4_marker] = ACTIONS(1257),
    [sym_atx_h5_marker] = ACTIONS(1257),
    [sym_atx_h6_marker] = ACTIONS(1257),
    [sym_setext_h1_underline] = ACTIONS(1261),
    [sym_setext_h2_underline] = ACTIONS(1263),
    [sym__thematic_break] = ACTIONS(1257),
    [sym__list_marker_minus] = ACTIONS(1257),
    [sym__list_marker_plus] = ACTIONS(1257),
    [sym__list_marker_star] = ACTIONS(1257),
    [sym__list_marker_parenthesis] = ACTIONS(1257),
    [sym__list_marker_dot] = ACTIONS(1257),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1257),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1257),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1257),
    [sym__blank_line_start] = ACTIONS(1257),
    [sym__html_block_1_start] = ACTIONS(1257),
    [sym__html_block_2_start] = ACTIONS(1257),
    [sym__html_block_3_start] = ACTIONS(1257),
    [sym__html_block_4_start] = ACTIONS(1257),
    [sym__html_block_5_start] = ACTIONS(1257),
    [sym__html_block_6_start] = ACTIONS(1257),
    [sym__html_block_7_start] = ACTIONS(1257),
    [sym__pipe_table_start] = ACTIONS(1257),
  },
  [112] = {
    [sym_link_title] = STATE(714),
    [anon_sym_LBRACK] = ACTIONS(1147),
    [anon_sym_RBRACK] = ACTIONS(1145),
    [anon_sym_LT] = ACTIONS(1145),
    [anon_sym_GT] = ACTIONS(1145),
    [anon_sym_BANG] = ACTIONS(1145),
    [anon_sym_DQUOTE] = ACTIONS(1149),
    [anon_sym_POUND] = ACTIONS(1145),
    [anon_sym_DOLLAR] = ACTIONS(1145),
    [anon_sym_PERCENT] = ACTIONS(1145),
    [anon_sym_AMP] = ACTIONS(1145),
    [anon_sym_SQUOTE] = ACTIONS(1152),
    [anon_sym_STAR] = ACTIONS(1145),
    [anon_sym_PLUS] = ACTIONS(1145),
    [anon_sym_COMMA] = ACTIONS(1145),
    [anon_sym_DASH] = ACTIONS(1145),
    [anon_sym_DOT] = ACTIONS(1145),
    [anon_sym_SLASH] = ACTIONS(1145),
    [anon_sym_COLON] = ACTIONS(1145),
    [anon_sym_SEMI] = ACTIONS(1145),
    [anon_sym_EQ] = ACTIONS(1145),
    [anon_sym_QMARK] = ACTIONS(1145),
    [anon_sym_AT] = ACTIONS(1145),
    [anon_sym_BSLASH] = ACTIONS(1145),
    [anon_sym_CARET] = ACTIONS(1145),
    [anon_sym__] = ACTIONS(1145),
    [anon_sym_BQUOTE] = ACTIONS(1145),
    [anon_sym_LBRACE] = ACTIONS(1145),
    [anon_sym_PIPE] = ACTIONS(1145),
    [anon_sym_RBRACE] = ACTIONS(1145),
    [anon_sym_TILDE] = ACTIONS(1145),
    [anon_sym_LPAREN] = ACTIONS(1155),
    [anon_sym_RPAREN] = ACTIONS(1145),
    [aux_sym__word_token1] = ACTIONS(1145),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1145),
    [aux_sym__word_token2] = ACTIONS(1145),
    [sym__whitespace] = ACTIONS(1265),
    [sym__soft_line_ending] = ACTIONS(1145),
    [sym__block_close] = ACTIONS(1145),
    [sym__block_quote_start] = ACTIONS(1145),
    [sym__indented_chunk_start] = ACTIONS(1145),
    [sym_atx_h1_marker] = ACTIONS(1145),
    [sym_atx_h2_marker] = ACTIONS(1145),
    [sym_atx_h3_marker] = ACTIONS(1145),
    [sym_atx_h4_marker] = ACTIONS(1145),
    [sym_atx_h5_marker] = ACTIONS(1145),
    [sym_atx_h6_marker] = ACTIONS(1145),
    [sym__thematic_break] = ACTIONS(1145),
    [sym__list_marker_minus] = ACTIONS(1145),
    [sym__list_marker_plus] = ACTIONS(1145),
    [sym__list_marker_star] = ACTIONS(1145),
    [sym__list_marker_parenthesis] = ACTIONS(1145),
    [sym__list_marker_dot] = ACTIONS(1145),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1145),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1145),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1145),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1145),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1145),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1145),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1145),
    [sym__blank_line_start] = ACTIONS(1145),
    [sym__html_block_1_start] = ACTIONS(1145),
    [sym__html_block_2_start] = ACTIONS(1145),
    [sym__html_block_3_start] = ACTIONS(1145),
    [sym__html_block_4_start] = ACTIONS(1145),
    [sym__html_block_5_start] = ACTIONS(1145),
    [sym__html_block_6_start] = ACTIONS(1145),
    [sym__html_block_7_start] = ACTIONS(1145),
    [sym__no_indented_chunk] = ACTIONS(1268),
    [sym__pipe_table_start] = ACTIONS(1145),
  },
  [113] = {
    [anon_sym_LBRACK] = ACTIONS(1259),
    [anon_sym_RBRACK] = ACTIONS(1257),
    [anon_sym_LT] = ACTIONS(1257),
    [anon_sym_GT] = ACTIONS(1257),
    [anon_sym_BANG] = ACTIONS(1257),
    [anon_sym_DQUOTE] = ACTIONS(1257),
    [anon_sym_POUND] = ACTIONS(1257),
    [anon_sym_DOLLAR] = ACTIONS(1257),
    [anon_sym_PERCENT] = ACTIONS(1257),
    [anon_sym_AMP] = ACTIONS(1257),
    [anon_sym_SQUOTE] = ACTIONS(1257),
    [anon_sym_STAR] = ACTIONS(1257),
    [anon_sym_PLUS] = ACTIONS(1257),
    [anon_sym_COMMA] = ACTIONS(1257),
    [anon_sym_DASH] = ACTIONS(1257),
    [anon_sym_DOT] = ACTIONS(1257),
    [anon_sym_SLASH] = ACTIONS(1257),
    [anon_sym_COLON] = ACTIONS(1257),
    [anon_sym_SEMI] = ACTIONS(1257),
    [anon_sym_EQ] = ACTIONS(1257),
    [anon_sym_QMARK] = ACTIONS(1257),
    [anon_sym_AT] = ACTIONS(1257),
    [anon_sym_BSLASH] = ACTIONS(1257),
    [anon_sym_CARET] = ACTIONS(1257),
    [anon_sym__] = ACTIONS(1257),
    [anon_sym_BQUOTE] = ACTIONS(1257),
    [anon_sym_LBRACE] = ACTIONS(1257),
    [anon_sym_PIPE] = ACTIONS(1257),
    [anon_sym_RBRACE] = ACTIONS(1257),
    [anon_sym_TILDE] = ACTIONS(1257),
    [anon_sym_LPAREN] = ACTIONS(1257),
    [anon_sym_RPAREN] = ACTIONS(1257),
    [aux_sym__word_token1] = ACTIONS(1257),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1257),
    [aux_sym__word_token2] = ACTIONS(1257),
    [sym__whitespace] = ACTIONS(1257),
    [sym__soft_line_ending] = ACTIONS(1257),
    [sym__block_close] = ACTIONS(1257),
    [sym__block_quote_start] = ACTIONS(1257),
    [sym__indented_chunk_start] = ACTIONS(1257),
    [sym_atx_h1_marker] = ACTIONS(1257),
    [sym_atx_h2_marker] = ACTIONS(1257),
    [sym_atx_h3_marker] = ACTIONS(1257),
    [sym_atx_h4_marker] = ACTIONS(1257),
    [sym_atx_h5_marker] = ACTIONS(1257),
    [sym_atx_h6_marker] = ACTIONS(1257),
    [sym_setext_h1_underline] = ACTIONS(1270),
    [sym_setext_h2_underline] = ACTIONS(1272),
    [sym__thematic_break] = ACTIONS(1257),
    [sym__list_marker_minus] = ACTIONS(1257),
    [sym__list_marker_plus] = ACTIONS(1257),
    [sym__list_marker_star] = ACTIONS(1257),
    [sym__list_marker_parenthesis] = ACTIONS(1257),
    [sym__list_marker_dot] = ACTIONS(1257),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1257),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1257),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1257),
    [sym__blank_line_start] = ACTIONS(1257),
    [sym__html_block_1_start] = ACTIONS(1257),
    [sym__html_block_2_start] = ACTIONS(1257),
    [sym__html_block_3_start] = ACTIONS(1257),
    [sym__html_block_4_start] = ACTIONS(1257),
    [sym__html_block_5_start] = ACTIONS(1257),
    [sym__html_block_6_start] = ACTIONS(1257),
    [sym__html_block_7_start] = ACTIONS(1257),
    [sym__pipe_table_start] = ACTIONS(1257),
  },
  [114] = {
    [ts_builtin_sym_end] = ACTIONS(1274),
    [anon_sym_LBRACK] = ACTIONS(1276),
    [anon_sym_RBRACK] = ACTIONS(1274),
    [anon_sym_LT] = ACTIONS(1274),
    [anon_sym_GT] = ACTIONS(1274),
    [anon_sym_BANG] = ACTIONS(1274),
    [anon_sym_DQUOTE] = ACTIONS(1274),
    [anon_sym_POUND] = ACTIONS(1274),
    [anon_sym_DOLLAR] = ACTIONS(1274),
    [anon_sym_PERCENT] = ACTIONS(1274),
    [anon_sym_AMP] = ACTIONS(1274),
    [anon_sym_SQUOTE] = ACTIONS(1274),
    [anon_sym_STAR] = ACTIONS(1274),
    [anon_sym_PLUS] = ACTIONS(1274),
    [anon_sym_COMMA] = ACTIONS(1274),
    [anon_sym_DASH] = ACTIONS(1274),
    [anon_sym_DOT] = ACTIONS(1274),
    [anon_sym_SLASH] = ACTIONS(1274),
    [anon_sym_COLON] = ACTIONS(1274),
    [anon_sym_SEMI] = ACTIONS(1274),
    [anon_sym_EQ] = ACTIONS(1274),
    [anon_sym_QMARK] = ACTIONS(1274),
    [anon_sym_AT] = ACTIONS(1274),
    [anon_sym_BSLASH] = ACTIONS(1274),
    [anon_sym_CARET] = ACTIONS(1274),
    [anon_sym__] = ACTIONS(1274),
    [anon_sym_BQUOTE] = ACTIONS(1274),
    [anon_sym_LBRACE] = ACTIONS(1274),
    [anon_sym_PIPE] = ACTIONS(1274),
    [anon_sym_RBRACE] = ACTIONS(1274),
    [anon_sym_TILDE] = ACTIONS(1274),
    [anon_sym_LPAREN] = ACTIONS(1274),
    [anon_sym_RPAREN] = ACTIONS(1274),
    [aux_sym__word_token1] = ACTIONS(1274),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1274),
    [aux_sym__word_token2] = ACTIONS(1274),
    [sym__whitespace] = ACTIONS(1274),
    [sym__soft_line_ending] = ACTIONS(1274),
    [sym__block_quote_start] = ACTIONS(1274),
    [sym__indented_chunk_start] = ACTIONS(1274),
    [sym_atx_h1_marker] = ACTIONS(1274),
    [sym_atx_h2_marker] = ACTIONS(1274),
    [sym_atx_h3_marker] = ACTIONS(1274),
    [sym_atx_h4_marker] = ACTIONS(1274),
    [sym_atx_h5_marker] = ACTIONS(1274),
    [sym_atx_h6_marker] = ACTIONS(1274),
    [sym_setext_h1_underline] = ACTIONS(1274),
    [sym_setext_h2_underline] = ACTIONS(1274),
    [sym__thematic_break] = ACTIONS(1274),
    [sym__list_marker_minus] = ACTIONS(1274),
    [sym__list_marker_plus] = ACTIONS(1274),
    [sym__list_marker_star] = ACTIONS(1274),
    [sym__list_marker_parenthesis] = ACTIONS(1274),
    [sym__list_marker_dot] = ACTIONS(1274),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1274),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1274),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1274),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1274),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1274),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1274),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1274),
    [sym__blank_line_start] = ACTIONS(1274),
    [sym__html_block_1_start] = ACTIONS(1274),
    [sym__html_block_2_start] = ACTIONS(1274),
    [sym__html_block_3_start] = ACTIONS(1274),
    [sym__html_block_4_start] = ACTIONS(1274),
    [sym__html_block_5_start] = ACTIONS(1274),
    [sym__html_block_6_start] = ACTIONS(1274),
    [sym__html_block_7_start] = ACTIONS(1274),
    [sym__pipe_table_start] = ACTIONS(1274),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(1250),
    [anon_sym_LBRACK] = ACTIONS(1248),
    [anon_sym_RBRACK] = ACTIONS(1250),
    [anon_sym_LT] = ACTIONS(1250),
    [anon_sym_GT] = ACTIONS(1250),
    [anon_sym_BANG] = ACTIONS(1250),
    [anon_sym_DQUOTE] = ACTIONS(1250),
    [anon_sym_POUND] = ACTIONS(1250),
    [anon_sym_DOLLAR] = ACTIONS(1250),
    [anon_sym_PERCENT] = ACTIONS(1250),
    [anon_sym_AMP] = ACTIONS(1250),
    [anon_sym_SQUOTE] = ACTIONS(1250),
    [anon_sym_STAR] = ACTIONS(1250),
    [anon_sym_PLUS] = ACTIONS(1250),
    [anon_sym_COMMA] = ACTIONS(1250),
    [anon_sym_DASH] = ACTIONS(1250),
    [anon_sym_DOT] = ACTIONS(1250),
    [anon_sym_SLASH] = ACTIONS(1250),
    [anon_sym_COLON] = ACTIONS(1250),
    [anon_sym_SEMI] = ACTIONS(1250),
    [anon_sym_EQ] = ACTIONS(1250),
    [anon_sym_QMARK] = ACTIONS(1250),
    [anon_sym_AT] = ACTIONS(1250),
    [anon_sym_BSLASH] = ACTIONS(1250),
    [anon_sym_CARET] = ACTIONS(1250),
    [anon_sym__] = ACTIONS(1250),
    [anon_sym_BQUOTE] = ACTIONS(1250),
    [anon_sym_LBRACE] = ACTIONS(1250),
    [anon_sym_PIPE] = ACTIONS(1250),
    [anon_sym_RBRACE] = ACTIONS(1250),
    [anon_sym_TILDE] = ACTIONS(1250),
    [anon_sym_LPAREN] = ACTIONS(1250),
    [anon_sym_RPAREN] = ACTIONS(1250),
    [aux_sym__word_token1] = ACTIONS(1250),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1250),
    [aux_sym__word_token2] = ACTIONS(1250),
    [sym__whitespace] = ACTIONS(1250),
    [sym__soft_line_ending] = ACTIONS(1250),
    [sym__block_quote_start] = ACTIONS(1250),
    [sym__indented_chunk_start] = ACTIONS(1250),
    [sym_atx_h1_marker] = ACTIONS(1250),
    [sym_atx_h2_marker] = ACTIONS(1250),
    [sym_atx_h3_marker] = ACTIONS(1250),
    [sym_atx_h4_marker] = ACTIONS(1250),
    [sym_atx_h5_marker] = ACTIONS(1250),
    [sym_atx_h6_marker] = ACTIONS(1250),
    [sym_setext_h1_underline] = ACTIONS(1250),
    [sym_setext_h2_underline] = ACTIONS(1250),
    [sym__thematic_break] = ACTIONS(1250),
    [sym__list_marker_minus] = ACTIONS(1250),
    [sym__list_marker_plus] = ACTIONS(1250),
    [sym__list_marker_star] = ACTIONS(1250),
    [sym__list_marker_parenthesis] = ACTIONS(1250),
    [sym__list_marker_dot] = ACTIONS(1250),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1250),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1250),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1250),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1250),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1250),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1250),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1250),
    [sym__blank_line_start] = ACTIONS(1250),
    [sym__html_block_1_start] = ACTIONS(1250),
    [sym__html_block_2_start] = ACTIONS(1250),
    [sym__html_block_3_start] = ACTIONS(1250),
    [sym__html_block_4_start] = ACTIONS(1250),
    [sym__html_block_5_start] = ACTIONS(1250),
    [sym__html_block_6_start] = ACTIONS(1250),
    [sym__html_block_7_start] = ACTIONS(1250),
    [sym__pipe_table_start] = ACTIONS(1250),
  },
  [116] = {
    [sym_link_title] = STATE(705),
    [anon_sym_LBRACK] = ACTIONS(1171),
    [anon_sym_RBRACK] = ACTIONS(1169),
    [anon_sym_LT] = ACTIONS(1169),
    [anon_sym_GT] = ACTIONS(1169),
    [anon_sym_BANG] = ACTIONS(1169),
    [anon_sym_DQUOTE] = ACTIONS(1173),
    [anon_sym_POUND] = ACTIONS(1169),
    [anon_sym_DOLLAR] = ACTIONS(1169),
    [anon_sym_PERCENT] = ACTIONS(1169),
    [anon_sym_AMP] = ACTIONS(1169),
    [anon_sym_SQUOTE] = ACTIONS(1176),
    [anon_sym_STAR] = ACTIONS(1169),
    [anon_sym_PLUS] = ACTIONS(1169),
    [anon_sym_COMMA] = ACTIONS(1169),
    [anon_sym_DASH] = ACTIONS(1169),
    [anon_sym_DOT] = ACTIONS(1169),
    [anon_sym_SLASH] = ACTIONS(1169),
    [anon_sym_COLON] = ACTIONS(1169),
    [anon_sym_SEMI] = ACTIONS(1169),
    [anon_sym_EQ] = ACTIONS(1169),
    [anon_sym_QMARK] = ACTIONS(1169),
    [anon_sym_AT] = ACTIONS(1169),
    [anon_sym_BSLASH] = ACTIONS(1169),
    [anon_sym_CARET] = ACTIONS(1169),
    [anon_sym__] = ACTIONS(1169),
    [anon_sym_BQUOTE] = ACTIONS(1169),
    [anon_sym_LBRACE] = ACTIONS(1169),
    [anon_sym_PIPE] = ACTIONS(1169),
    [anon_sym_RBRACE] = ACTIONS(1169),
    [anon_sym_TILDE] = ACTIONS(1169),
    [anon_sym_LPAREN] = ACTIONS(1179),
    [anon_sym_RPAREN] = ACTIONS(1169),
    [aux_sym__word_token1] = ACTIONS(1169),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1169),
    [aux_sym__word_token2] = ACTIONS(1169),
    [sym__whitespace] = ACTIONS(1278),
    [sym__soft_line_ending] = ACTIONS(1169),
    [sym__block_close] = ACTIONS(1169),
    [sym__block_quote_start] = ACTIONS(1169),
    [sym__indented_chunk_start] = ACTIONS(1169),
    [sym_atx_h1_marker] = ACTIONS(1169),
    [sym_atx_h2_marker] = ACTIONS(1169),
    [sym_atx_h3_marker] = ACTIONS(1169),
    [sym_atx_h4_marker] = ACTIONS(1169),
    [sym_atx_h5_marker] = ACTIONS(1169),
    [sym_atx_h6_marker] = ACTIONS(1169),
    [sym__thematic_break] = ACTIONS(1169),
    [sym__list_marker_minus] = ACTIONS(1169),
    [sym__list_marker_plus] = ACTIONS(1169),
    [sym__list_marker_star] = ACTIONS(1169),
    [sym__list_marker_parenthesis] = ACTIONS(1169),
    [sym__list_marker_dot] = ACTIONS(1169),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1169),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1169),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1169),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1169),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1169),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1169),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1169),
    [sym__blank_line_start] = ACTIONS(1169),
    [sym__html_block_1_start] = ACTIONS(1169),
    [sym__html_block_2_start] = ACTIONS(1169),
    [sym__html_block_3_start] = ACTIONS(1169),
    [sym__html_block_4_start] = ACTIONS(1169),
    [sym__html_block_5_start] = ACTIONS(1169),
    [sym__html_block_6_start] = ACTIONS(1169),
    [sym__html_block_7_start] = ACTIONS(1169),
    [sym__no_indented_chunk] = ACTIONS(1281),
    [sym__pipe_table_start] = ACTIONS(1169),
  },
  [117] = {
    [sym_link_title] = STATE(707),
    [anon_sym_LBRACK] = ACTIONS(1207),
    [anon_sym_RBRACK] = ACTIONS(1205),
    [anon_sym_LT] = ACTIONS(1205),
    [anon_sym_GT] = ACTIONS(1205),
    [anon_sym_BANG] = ACTIONS(1205),
    [anon_sym_DQUOTE] = ACTIONS(1209),
    [anon_sym_POUND] = ACTIONS(1205),
    [anon_sym_DOLLAR] = ACTIONS(1205),
    [anon_sym_PERCENT] = ACTIONS(1205),
    [anon_sym_AMP] = ACTIONS(1205),
    [anon_sym_SQUOTE] = ACTIONS(1212),
    [anon_sym_STAR] = ACTIONS(1205),
    [anon_sym_PLUS] = ACTIONS(1205),
    [anon_sym_COMMA] = ACTIONS(1205),
    [anon_sym_DASH] = ACTIONS(1205),
    [anon_sym_DOT] = ACTIONS(1205),
    [anon_sym_SLASH] = ACTIONS(1205),
    [anon_sym_COLON] = ACTIONS(1205),
    [anon_sym_SEMI] = ACTIONS(1205),
    [anon_sym_EQ] = ACTIONS(1205),
    [anon_sym_QMARK] = ACTIONS(1205),
    [anon_sym_AT] = ACTIONS(1205),
    [anon_sym_BSLASH] = ACTIONS(1205),
    [anon_sym_CARET] = ACTIONS(1205),
    [anon_sym__] = ACTIONS(1205),
    [anon_sym_BQUOTE] = ACTIONS(1205),
    [anon_sym_LBRACE] = ACTIONS(1205),
    [anon_sym_PIPE] = ACTIONS(1205),
    [anon_sym_RBRACE] = ACTIONS(1205),
    [anon_sym_TILDE] = ACTIONS(1205),
    [anon_sym_LPAREN] = ACTIONS(1215),
    [anon_sym_RPAREN] = ACTIONS(1205),
    [aux_sym__word_token1] = ACTIONS(1205),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1205),
    [aux_sym__word_token2] = ACTIONS(1205),
    [sym__whitespace] = ACTIONS(1283),
    [sym__soft_line_ending] = ACTIONS(1205),
    [sym__block_close] = ACTIONS(1205),
    [sym__block_quote_start] = ACTIONS(1205),
    [sym__indented_chunk_start] = ACTIONS(1205),
    [sym_atx_h1_marker] = ACTIONS(1205),
    [sym_atx_h2_marker] = ACTIONS(1205),
    [sym_atx_h3_marker] = ACTIONS(1205),
    [sym_atx_h4_marker] = ACTIONS(1205),
    [sym_atx_h5_marker] = ACTIONS(1205),
    [sym_atx_h6_marker] = ACTIONS(1205),
    [sym__thematic_break] = ACTIONS(1205),
    [sym__list_marker_minus] = ACTIONS(1205),
    [sym__list_marker_plus] = ACTIONS(1205),
    [sym__list_marker_star] = ACTIONS(1205),
    [sym__list_marker_parenthesis] = ACTIONS(1205),
    [sym__list_marker_dot] = ACTIONS(1205),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1205),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1205),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1205),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1205),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1205),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1205),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1205),
    [sym__blank_line_start] = ACTIONS(1205),
    [sym__html_block_1_start] = ACTIONS(1205),
    [sym__html_block_2_start] = ACTIONS(1205),
    [sym__html_block_3_start] = ACTIONS(1205),
    [sym__html_block_4_start] = ACTIONS(1205),
    [sym__html_block_5_start] = ACTIONS(1205),
    [sym__html_block_6_start] = ACTIONS(1205),
    [sym__html_block_7_start] = ACTIONS(1205),
    [sym__no_indented_chunk] = ACTIONS(1286),
    [sym__pipe_table_start] = ACTIONS(1205),
  },
  [118] = {
    [anon_sym_LBRACK] = ACTIONS(1276),
    [anon_sym_RBRACK] = ACTIONS(1274),
    [anon_sym_LT] = ACTIONS(1274),
    [anon_sym_GT] = ACTIONS(1274),
    [anon_sym_BANG] = ACTIONS(1274),
    [anon_sym_DQUOTE] = ACTIONS(1274),
    [anon_sym_POUND] = ACTIONS(1274),
    [anon_sym_DOLLAR] = ACTIONS(1274),
    [anon_sym_PERCENT] = ACTIONS(1274),
    [anon_sym_AMP] = ACTIONS(1274),
    [anon_sym_SQUOTE] = ACTIONS(1274),
    [anon_sym_STAR] = ACTIONS(1274),
    [anon_sym_PLUS] = ACTIONS(1274),
    [anon_sym_COMMA] = ACTIONS(1274),
    [anon_sym_DASH] = ACTIONS(1274),
    [anon_sym_DOT] = ACTIONS(1274),
    [anon_sym_SLASH] = ACTIONS(1274),
    [anon_sym_COLON] = ACTIONS(1274),
    [anon_sym_SEMI] = ACTIONS(1274),
    [anon_sym_EQ] = ACTIONS(1274),
    [anon_sym_QMARK] = ACTIONS(1274),
    [anon_sym_AT] = ACTIONS(1274),
    [anon_sym_BSLASH] = ACTIONS(1274),
    [anon_sym_CARET] = ACTIONS(1274),
    [anon_sym__] = ACTIONS(1274),
    [anon_sym_BQUOTE] = ACTIONS(1274),
    [anon_sym_LBRACE] = ACTIONS(1274),
    [anon_sym_PIPE] = ACTIONS(1274),
    [anon_sym_RBRACE] = ACTIONS(1274),
    [anon_sym_TILDE] = ACTIONS(1274),
    [anon_sym_LPAREN] = ACTIONS(1274),
    [anon_sym_RPAREN] = ACTIONS(1274),
    [aux_sym__word_token1] = ACTIONS(1274),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1274),
    [aux_sym__word_token2] = ACTIONS(1274),
    [sym__whitespace] = ACTIONS(1274),
    [sym__soft_line_ending] = ACTIONS(1274),
    [sym__block_close] = ACTIONS(1274),
    [sym__block_quote_start] = ACTIONS(1274),
    [sym__indented_chunk_start] = ACTIONS(1274),
    [sym_atx_h1_marker] = ACTIONS(1274),
    [sym_atx_h2_marker] = ACTIONS(1274),
    [sym_atx_h3_marker] = ACTIONS(1274),
    [sym_atx_h4_marker] = ACTIONS(1274),
    [sym_atx_h5_marker] = ACTIONS(1274),
    [sym_atx_h6_marker] = ACTIONS(1274),
    [sym_setext_h1_underline] = ACTIONS(1274),
    [sym_setext_h2_underline] = ACTIONS(1274),
    [sym__thematic_break] = ACTIONS(1274),
    [sym__list_marker_minus] = ACTIONS(1274),
    [sym__list_marker_plus] = ACTIONS(1274),
    [sym__list_marker_star] = ACTIONS(1274),
    [sym__list_marker_parenthesis] = ACTIONS(1274),
    [sym__list_marker_dot] = ACTIONS(1274),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1274),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1274),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1274),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1274),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1274),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1274),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1274),
    [sym__blank_line_start] = ACTIONS(1274),
    [sym__html_block_1_start] = ACTIONS(1274),
    [sym__html_block_2_start] = ACTIONS(1274),
    [sym__html_block_3_start] = ACTIONS(1274),
    [sym__html_block_4_start] = ACTIONS(1274),
    [sym__html_block_5_start] = ACTIONS(1274),
    [sym__html_block_6_start] = ACTIONS(1274),
    [sym__html_block_7_start] = ACTIONS(1274),
    [sym__pipe_table_start] = ACTIONS(1274),
  },
  [119] = {
    [ts_builtin_sym_end] = ACTIONS(1288),
    [anon_sym_LBRACK] = ACTIONS(1290),
    [anon_sym_RBRACK] = ACTIONS(1288),
    [anon_sym_LT] = ACTIONS(1288),
    [anon_sym_GT] = ACTIONS(1288),
    [anon_sym_BANG] = ACTIONS(1288),
    [anon_sym_DQUOTE] = ACTIONS(1288),
    [anon_sym_POUND] = ACTIONS(1288),
    [anon_sym_DOLLAR] = ACTIONS(1288),
    [anon_sym_PERCENT] = ACTIONS(1288),
    [anon_sym_AMP] = ACTIONS(1288),
    [anon_sym_SQUOTE] = ACTIONS(1288),
    [anon_sym_STAR] = ACTIONS(1288),
    [anon_sym_PLUS] = ACTIONS(1288),
    [anon_sym_COMMA] = ACTIONS(1288),
    [anon_sym_DASH] = ACTIONS(1288),
    [anon_sym_DOT] = ACTIONS(1288),
    [anon_sym_SLASH] = ACTIONS(1288),
    [anon_sym_COLON] = ACTIONS(1288),
    [anon_sym_SEMI] = ACTIONS(1288),
    [anon_sym_EQ] = ACTIONS(1288),
    [anon_sym_QMARK] = ACTIONS(1288),
    [anon_sym_AT] = ACTIONS(1288),
    [anon_sym_BSLASH] = ACTIONS(1288),
    [anon_sym_CARET] = ACTIONS(1288),
    [anon_sym__] = ACTIONS(1288),
    [anon_sym_BQUOTE] = ACTIONS(1288),
    [anon_sym_LBRACE] = ACTIONS(1288),
    [anon_sym_PIPE] = ACTIONS(1288),
    [anon_sym_RBRACE] = ACTIONS(1288),
    [anon_sym_TILDE] = ACTIONS(1288),
    [anon_sym_LPAREN] = ACTIONS(1288),
    [anon_sym_RPAREN] = ACTIONS(1288),
    [aux_sym__word_token1] = ACTIONS(1288),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1288),
    [aux_sym__word_token2] = ACTIONS(1288),
    [sym__whitespace] = ACTIONS(1288),
    [sym__soft_line_ending] = ACTIONS(1288),
    [sym_block_continuation] = ACTIONS(1292),
    [sym__block_quote_start] = ACTIONS(1288),
    [sym__indented_chunk_start] = ACTIONS(1288),
    [sym_atx_h1_marker] = ACTIONS(1288),
    [sym_atx_h2_marker] = ACTIONS(1288),
    [sym_atx_h3_marker] = ACTIONS(1288),
    [sym_atx_h4_marker] = ACTIONS(1288),
    [sym_atx_h5_marker] = ACTIONS(1288),
    [sym_atx_h6_marker] = ACTIONS(1288),
    [sym__thematic_break] = ACTIONS(1288),
    [sym__list_marker_minus] = ACTIONS(1288),
    [sym__list_marker_plus] = ACTIONS(1288),
    [sym__list_marker_star] = ACTIONS(1288),
    [sym__list_marker_parenthesis] = ACTIONS(1288),
    [sym__list_marker_dot] = ACTIONS(1288),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1288),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1288),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1288),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1288),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1288),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1288),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1288),
    [sym__blank_line_start] = ACTIONS(1288),
    [sym__html_block_1_start] = ACTIONS(1288),
    [sym__html_block_2_start] = ACTIONS(1288),
    [sym__html_block_3_start] = ACTIONS(1288),
    [sym__html_block_4_start] = ACTIONS(1288),
    [sym__html_block_5_start] = ACTIONS(1288),
    [sym__html_block_6_start] = ACTIONS(1288),
    [sym__html_block_7_start] = ACTIONS(1288),
    [sym__pipe_table_start] = ACTIONS(1288),
  },
  [120] = {
    [anon_sym_LBRACK] = ACTIONS(1294),
    [anon_sym_RBRACK] = ACTIONS(1296),
    [anon_sym_LT] = ACTIONS(1296),
    [anon_sym_GT] = ACTIONS(1296),
    [anon_sym_BANG] = ACTIONS(1296),
    [anon_sym_DQUOTE] = ACTIONS(1296),
    [anon_sym_POUND] = ACTIONS(1296),
    [anon_sym_DOLLAR] = ACTIONS(1296),
    [anon_sym_PERCENT] = ACTIONS(1296),
    [anon_sym_AMP] = ACTIONS(1296),
    [anon_sym_SQUOTE] = ACTIONS(1296),
    [anon_sym_STAR] = ACTIONS(1296),
    [anon_sym_PLUS] = ACTIONS(1296),
    [anon_sym_COMMA] = ACTIONS(1296),
    [anon_sym_DASH] = ACTIONS(1296),
    [anon_sym_DOT] = ACTIONS(1296),
    [anon_sym_SLASH] = ACTIONS(1296),
    [anon_sym_COLON] = ACTIONS(1296),
    [anon_sym_SEMI] = ACTIONS(1296),
    [anon_sym_EQ] = ACTIONS(1296),
    [anon_sym_QMARK] = ACTIONS(1296),
    [anon_sym_AT] = ACTIONS(1296),
    [anon_sym_BSLASH] = ACTIONS(1296),
    [anon_sym_CARET] = ACTIONS(1296),
    [anon_sym__] = ACTIONS(1296),
    [anon_sym_BQUOTE] = ACTIONS(1296),
    [anon_sym_LBRACE] = ACTIONS(1296),
    [anon_sym_PIPE] = ACTIONS(1296),
    [anon_sym_RBRACE] = ACTIONS(1296),
    [anon_sym_TILDE] = ACTIONS(1296),
    [anon_sym_LPAREN] = ACTIONS(1296),
    [anon_sym_RPAREN] = ACTIONS(1296),
    [aux_sym__word_token1] = ACTIONS(1296),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1296),
    [aux_sym__word_token2] = ACTIONS(1296),
    [sym__whitespace] = ACTIONS(1296),
    [sym__soft_line_ending] = ACTIONS(1296),
    [sym__block_close] = ACTIONS(1296),
    [sym_block_continuation] = ACTIONS(1298),
    [sym__block_quote_start] = ACTIONS(1296),
    [sym__indented_chunk_start] = ACTIONS(1296),
    [sym_atx_h1_marker] = ACTIONS(1296),
    [sym_atx_h2_marker] = ACTIONS(1296),
    [sym_atx_h3_marker] = ACTIONS(1296),
    [sym_atx_h4_marker] = ACTIONS(1296),
    [sym_atx_h5_marker] = ACTIONS(1296),
    [sym_atx_h6_marker] = ACTIONS(1296),
    [sym__thematic_break] = ACTIONS(1296),
    [sym__list_marker_minus] = ACTIONS(1296),
    [sym__list_marker_plus] = ACTIONS(1296),
    [sym__list_marker_star] = ACTIONS(1296),
    [sym__list_marker_parenthesis] = ACTIONS(1296),
    [sym__list_marker_dot] = ACTIONS(1296),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1296),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1296),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1296),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1296),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1296),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1296),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1296),
    [sym__blank_line_start] = ACTIONS(1296),
    [sym__html_block_1_start] = ACTIONS(1296),
    [sym__html_block_2_start] = ACTIONS(1296),
    [sym__html_block_3_start] = ACTIONS(1296),
    [sym__html_block_4_start] = ACTIONS(1296),
    [sym__html_block_5_start] = ACTIONS(1296),
    [sym__html_block_6_start] = ACTIONS(1296),
    [sym__html_block_7_start] = ACTIONS(1296),
    [sym__pipe_table_start] = ACTIONS(1296),
  },
  [121] = {
    [anon_sym_LBRACK] = ACTIONS(1163),
    [anon_sym_RBRACK] = ACTIONS(1165),
    [anon_sym_LT] = ACTIONS(1165),
    [anon_sym_GT] = ACTIONS(1165),
    [anon_sym_BANG] = ACTIONS(1165),
    [anon_sym_DQUOTE] = ACTIONS(1165),
    [anon_sym_POUND] = ACTIONS(1165),
    [anon_sym_DOLLAR] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(1165),
    [anon_sym_AMP] = ACTIONS(1165),
    [anon_sym_SQUOTE] = ACTIONS(1165),
    [anon_sym_STAR] = ACTIONS(1165),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_COMMA] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_DOT] = ACTIONS(1165),
    [anon_sym_SLASH] = ACTIONS(1165),
    [anon_sym_COLON] = ACTIONS(1165),
    [anon_sym_SEMI] = ACTIONS(1165),
    [anon_sym_EQ] = ACTIONS(1165),
    [anon_sym_QMARK] = ACTIONS(1165),
    [anon_sym_AT] = ACTIONS(1165),
    [anon_sym_BSLASH] = ACTIONS(1165),
    [anon_sym_CARET] = ACTIONS(1165),
    [anon_sym__] = ACTIONS(1165),
    [anon_sym_BQUOTE] = ACTIONS(1165),
    [anon_sym_LBRACE] = ACTIONS(1165),
    [anon_sym_PIPE] = ACTIONS(1165),
    [anon_sym_RBRACE] = ACTIONS(1165),
    [anon_sym_TILDE] = ACTIONS(1165),
    [anon_sym_LPAREN] = ACTIONS(1165),
    [anon_sym_RPAREN] = ACTIONS(1165),
    [aux_sym__word_token1] = ACTIONS(1165),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1165),
    [aux_sym__word_token2] = ACTIONS(1165),
    [sym__whitespace] = ACTIONS(1165),
    [sym__soft_line_ending] = ACTIONS(1165),
    [sym__block_close] = ACTIONS(1165),
    [sym_block_continuation] = ACTIONS(1300),
    [sym__block_quote_start] = ACTIONS(1165),
    [sym__indented_chunk_start] = ACTIONS(1165),
    [sym_atx_h1_marker] = ACTIONS(1165),
    [sym_atx_h2_marker] = ACTIONS(1165),
    [sym_atx_h3_marker] = ACTIONS(1165),
    [sym_atx_h4_marker] = ACTIONS(1165),
    [sym_atx_h5_marker] = ACTIONS(1165),
    [sym_atx_h6_marker] = ACTIONS(1165),
    [sym__thematic_break] = ACTIONS(1165),
    [sym__list_marker_minus] = ACTIONS(1165),
    [sym__list_marker_plus] = ACTIONS(1165),
    [sym__list_marker_star] = ACTIONS(1165),
    [sym__list_marker_parenthesis] = ACTIONS(1165),
    [sym__list_marker_dot] = ACTIONS(1165),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1165),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1165),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1165),
    [sym__blank_line_start] = ACTIONS(1165),
    [sym__html_block_1_start] = ACTIONS(1165),
    [sym__html_block_2_start] = ACTIONS(1165),
    [sym__html_block_3_start] = ACTIONS(1165),
    [sym__html_block_4_start] = ACTIONS(1165),
    [sym__html_block_5_start] = ACTIONS(1165),
    [sym__html_block_6_start] = ACTIONS(1165),
    [sym__html_block_7_start] = ACTIONS(1165),
    [sym__pipe_table_start] = ACTIONS(1165),
  },
  [122] = {
    [ts_builtin_sym_end] = ACTIONS(1302),
    [anon_sym_LBRACK] = ACTIONS(1304),
    [anon_sym_RBRACK] = ACTIONS(1302),
    [anon_sym_LT] = ACTIONS(1302),
    [anon_sym_GT] = ACTIONS(1302),
    [anon_sym_BANG] = ACTIONS(1302),
    [anon_sym_DQUOTE] = ACTIONS(1302),
    [anon_sym_POUND] = ACTIONS(1302),
    [anon_sym_DOLLAR] = ACTIONS(1302),
    [anon_sym_PERCENT] = ACTIONS(1302),
    [anon_sym_AMP] = ACTIONS(1302),
    [anon_sym_SQUOTE] = ACTIONS(1302),
    [anon_sym_STAR] = ACTIONS(1302),
    [anon_sym_PLUS] = ACTIONS(1302),
    [anon_sym_COMMA] = ACTIONS(1302),
    [anon_sym_DASH] = ACTIONS(1302),
    [anon_sym_DOT] = ACTIONS(1302),
    [anon_sym_SLASH] = ACTIONS(1302),
    [anon_sym_COLON] = ACTIONS(1302),
    [anon_sym_SEMI] = ACTIONS(1302),
    [anon_sym_EQ] = ACTIONS(1302),
    [anon_sym_QMARK] = ACTIONS(1302),
    [anon_sym_AT] = ACTIONS(1302),
    [anon_sym_BSLASH] = ACTIONS(1302),
    [anon_sym_CARET] = ACTIONS(1302),
    [anon_sym__] = ACTIONS(1302),
    [anon_sym_BQUOTE] = ACTIONS(1302),
    [anon_sym_LBRACE] = ACTIONS(1302),
    [anon_sym_PIPE] = ACTIONS(1302),
    [anon_sym_RBRACE] = ACTIONS(1302),
    [anon_sym_TILDE] = ACTIONS(1302),
    [anon_sym_LPAREN] = ACTIONS(1302),
    [anon_sym_RPAREN] = ACTIONS(1302),
    [aux_sym__word_token1] = ACTIONS(1302),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1302),
    [aux_sym__word_token2] = ACTIONS(1302),
    [sym__whitespace] = ACTIONS(1302),
    [sym__soft_line_ending] = ACTIONS(1302),
    [sym_block_continuation] = ACTIONS(1306),
    [sym__block_quote_start] = ACTIONS(1302),
    [sym__indented_chunk_start] = ACTIONS(1302),
    [sym_atx_h1_marker] = ACTIONS(1302),
    [sym_atx_h2_marker] = ACTIONS(1302),
    [sym_atx_h3_marker] = ACTIONS(1302),
    [sym_atx_h4_marker] = ACTIONS(1302),
    [sym_atx_h5_marker] = ACTIONS(1302),
    [sym_atx_h6_marker] = ACTIONS(1302),
    [sym__thematic_break] = ACTIONS(1302),
    [sym__list_marker_minus] = ACTIONS(1302),
    [sym__list_marker_plus] = ACTIONS(1302),
    [sym__list_marker_star] = ACTIONS(1302),
    [sym__list_marker_parenthesis] = ACTIONS(1302),
    [sym__list_marker_dot] = ACTIONS(1302),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1302),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1302),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1302),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1302),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1302),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1302),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1302),
    [sym__blank_line_start] = ACTIONS(1302),
    [sym__html_block_1_start] = ACTIONS(1302),
    [sym__html_block_2_start] = ACTIONS(1302),
    [sym__html_block_3_start] = ACTIONS(1302),
    [sym__html_block_4_start] = ACTIONS(1302),
    [sym__html_block_5_start] = ACTIONS(1302),
    [sym__html_block_6_start] = ACTIONS(1302),
    [sym__html_block_7_start] = ACTIONS(1302),
    [sym__pipe_table_start] = ACTIONS(1302),
  },
  [123] = {
    [anon_sym_LBRACK] = ACTIONS(1117),
    [anon_sym_RBRACK] = ACTIONS(1119),
    [anon_sym_LT] = ACTIONS(1119),
    [anon_sym_GT] = ACTIONS(1119),
    [anon_sym_BANG] = ACTIONS(1119),
    [anon_sym_DQUOTE] = ACTIONS(1119),
    [anon_sym_POUND] = ACTIONS(1119),
    [anon_sym_DOLLAR] = ACTIONS(1119),
    [anon_sym_PERCENT] = ACTIONS(1119),
    [anon_sym_AMP] = ACTIONS(1119),
    [anon_sym_SQUOTE] = ACTIONS(1119),
    [anon_sym_STAR] = ACTIONS(1119),
    [anon_sym_PLUS] = ACTIONS(1119),
    [anon_sym_COMMA] = ACTIONS(1119),
    [anon_sym_DASH] = ACTIONS(1119),
    [anon_sym_DOT] = ACTIONS(1119),
    [anon_sym_SLASH] = ACTIONS(1119),
    [anon_sym_COLON] = ACTIONS(1119),
    [anon_sym_SEMI] = ACTIONS(1119),
    [anon_sym_EQ] = ACTIONS(1119),
    [anon_sym_QMARK] = ACTIONS(1119),
    [anon_sym_AT] = ACTIONS(1119),
    [anon_sym_BSLASH] = ACTIONS(1119),
    [anon_sym_CARET] = ACTIONS(1119),
    [anon_sym__] = ACTIONS(1119),
    [anon_sym_BQUOTE] = ACTIONS(1119),
    [anon_sym_LBRACE] = ACTIONS(1119),
    [anon_sym_PIPE] = ACTIONS(1119),
    [anon_sym_RBRACE] = ACTIONS(1119),
    [anon_sym_TILDE] = ACTIONS(1119),
    [anon_sym_LPAREN] = ACTIONS(1119),
    [anon_sym_RPAREN] = ACTIONS(1119),
    [aux_sym__word_token1] = ACTIONS(1119),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1119),
    [aux_sym__word_token2] = ACTIONS(1119),
    [sym__whitespace] = ACTIONS(1119),
    [sym__soft_line_ending] = ACTIONS(1119),
    [sym__block_close] = ACTIONS(1119),
    [sym_block_continuation] = ACTIONS(1308),
    [sym__block_quote_start] = ACTIONS(1119),
    [sym__indented_chunk_start] = ACTIONS(1119),
    [sym_atx_h1_marker] = ACTIONS(1119),
    [sym_atx_h2_marker] = ACTIONS(1119),
    [sym_atx_h3_marker] = ACTIONS(1119),
    [sym_atx_h4_marker] = ACTIONS(1119),
    [sym_atx_h5_marker] = ACTIONS(1119),
    [sym_atx_h6_marker] = ACTIONS(1119),
    [sym__thematic_break] = ACTIONS(1119),
    [sym__list_marker_minus] = ACTIONS(1119),
    [sym__list_marker_plus] = ACTIONS(1119),
    [sym__list_marker_star] = ACTIONS(1119),
    [sym__list_marker_parenthesis] = ACTIONS(1119),
    [sym__list_marker_dot] = ACTIONS(1119),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1119),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1119),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1119),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1119),
    [sym__blank_line_start] = ACTIONS(1119),
    [sym__html_block_1_start] = ACTIONS(1119),
    [sym__html_block_2_start] = ACTIONS(1119),
    [sym__html_block_3_start] = ACTIONS(1119),
    [sym__html_block_4_start] = ACTIONS(1119),
    [sym__html_block_5_start] = ACTIONS(1119),
    [sym__html_block_6_start] = ACTIONS(1119),
    [sym__html_block_7_start] = ACTIONS(1119),
    [sym__pipe_table_start] = ACTIONS(1119),
  },
  [124] = {
    [ts_builtin_sym_end] = ACTIONS(1310),
    [anon_sym_LBRACK] = ACTIONS(1312),
    [anon_sym_RBRACK] = ACTIONS(1310),
    [anon_sym_LT] = ACTIONS(1310),
    [anon_sym_GT] = ACTIONS(1310),
    [anon_sym_BANG] = ACTIONS(1310),
    [anon_sym_DQUOTE] = ACTIONS(1310),
    [anon_sym_POUND] = ACTIONS(1310),
    [anon_sym_DOLLAR] = ACTIONS(1310),
    [anon_sym_PERCENT] = ACTIONS(1310),
    [anon_sym_AMP] = ACTIONS(1310),
    [anon_sym_SQUOTE] = ACTIONS(1310),
    [anon_sym_STAR] = ACTIONS(1310),
    [anon_sym_PLUS] = ACTIONS(1310),
    [anon_sym_COMMA] = ACTIONS(1310),
    [anon_sym_DASH] = ACTIONS(1310),
    [anon_sym_DOT] = ACTIONS(1310),
    [anon_sym_SLASH] = ACTIONS(1310),
    [anon_sym_COLON] = ACTIONS(1310),
    [anon_sym_SEMI] = ACTIONS(1310),
    [anon_sym_EQ] = ACTIONS(1310),
    [anon_sym_QMARK] = ACTIONS(1310),
    [anon_sym_AT] = ACTIONS(1310),
    [anon_sym_BSLASH] = ACTIONS(1310),
    [anon_sym_CARET] = ACTIONS(1310),
    [anon_sym__] = ACTIONS(1310),
    [anon_sym_BQUOTE] = ACTIONS(1310),
    [anon_sym_LBRACE] = ACTIONS(1310),
    [anon_sym_PIPE] = ACTIONS(1310),
    [anon_sym_RBRACE] = ACTIONS(1310),
    [anon_sym_TILDE] = ACTIONS(1310),
    [anon_sym_LPAREN] = ACTIONS(1310),
    [anon_sym_RPAREN] = ACTIONS(1310),
    [aux_sym__word_token1] = ACTIONS(1310),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1310),
    [aux_sym__word_token2] = ACTIONS(1310),
    [sym__whitespace] = ACTIONS(1310),
    [sym__soft_line_ending] = ACTIONS(1310),
    [sym_block_continuation] = ACTIONS(1314),
    [sym__block_quote_start] = ACTIONS(1310),
    [sym__indented_chunk_start] = ACTIONS(1310),
    [sym_atx_h1_marker] = ACTIONS(1310),
    [sym_atx_h2_marker] = ACTIONS(1310),
    [sym_atx_h3_marker] = ACTIONS(1310),
    [sym_atx_h4_marker] = ACTIONS(1310),
    [sym_atx_h5_marker] = ACTIONS(1310),
    [sym_atx_h6_marker] = ACTIONS(1310),
    [sym__thematic_break] = ACTIONS(1310),
    [sym__list_marker_minus] = ACTIONS(1310),
    [sym__list_marker_plus] = ACTIONS(1310),
    [sym__list_marker_star] = ACTIONS(1310),
    [sym__list_marker_parenthesis] = ACTIONS(1310),
    [sym__list_marker_dot] = ACTIONS(1310),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1310),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1310),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1310),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1310),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1310),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1310),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1310),
    [sym__blank_line_start] = ACTIONS(1310),
    [sym__html_block_1_start] = ACTIONS(1310),
    [sym__html_block_2_start] = ACTIONS(1310),
    [sym__html_block_3_start] = ACTIONS(1310),
    [sym__html_block_4_start] = ACTIONS(1310),
    [sym__html_block_5_start] = ACTIONS(1310),
    [sym__html_block_6_start] = ACTIONS(1310),
    [sym__html_block_7_start] = ACTIONS(1310),
    [sym__pipe_table_start] = ACTIONS(1310),
  },
  [125] = {
    [ts_builtin_sym_end] = ACTIONS(1316),
    [anon_sym_LBRACK] = ACTIONS(1318),
    [anon_sym_RBRACK] = ACTIONS(1316),
    [anon_sym_LT] = ACTIONS(1316),
    [anon_sym_GT] = ACTIONS(1316),
    [anon_sym_BANG] = ACTIONS(1316),
    [anon_sym_DQUOTE] = ACTIONS(1316),
    [anon_sym_POUND] = ACTIONS(1316),
    [anon_sym_DOLLAR] = ACTIONS(1316),
    [anon_sym_PERCENT] = ACTIONS(1316),
    [anon_sym_AMP] = ACTIONS(1316),
    [anon_sym_SQUOTE] = ACTIONS(1316),
    [anon_sym_STAR] = ACTIONS(1316),
    [anon_sym_PLUS] = ACTIONS(1316),
    [anon_sym_COMMA] = ACTIONS(1316),
    [anon_sym_DASH] = ACTIONS(1316),
    [anon_sym_DOT] = ACTIONS(1316),
    [anon_sym_SLASH] = ACTIONS(1316),
    [anon_sym_COLON] = ACTIONS(1316),
    [anon_sym_SEMI] = ACTIONS(1316),
    [anon_sym_EQ] = ACTIONS(1316),
    [anon_sym_QMARK] = ACTIONS(1316),
    [anon_sym_AT] = ACTIONS(1316),
    [anon_sym_BSLASH] = ACTIONS(1316),
    [anon_sym_CARET] = ACTIONS(1316),
    [anon_sym__] = ACTIONS(1316),
    [anon_sym_BQUOTE] = ACTIONS(1316),
    [anon_sym_LBRACE] = ACTIONS(1316),
    [anon_sym_PIPE] = ACTIONS(1316),
    [anon_sym_RBRACE] = ACTIONS(1316),
    [anon_sym_TILDE] = ACTIONS(1316),
    [anon_sym_LPAREN] = ACTIONS(1316),
    [anon_sym_RPAREN] = ACTIONS(1316),
    [aux_sym__word_token1] = ACTIONS(1316),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1316),
    [aux_sym__word_token2] = ACTIONS(1316),
    [sym__whitespace] = ACTIONS(1316),
    [sym__soft_line_ending] = ACTIONS(1316),
    [sym_block_continuation] = ACTIONS(1320),
    [sym__block_quote_start] = ACTIONS(1316),
    [sym__indented_chunk_start] = ACTIONS(1316),
    [sym_atx_h1_marker] = ACTIONS(1316),
    [sym_atx_h2_marker] = ACTIONS(1316),
    [sym_atx_h3_marker] = ACTIONS(1316),
    [sym_atx_h4_marker] = ACTIONS(1316),
    [sym_atx_h5_marker] = ACTIONS(1316),
    [sym_atx_h6_marker] = ACTIONS(1316),
    [sym__thematic_break] = ACTIONS(1316),
    [sym__list_marker_minus] = ACTIONS(1316),
    [sym__list_marker_plus] = ACTIONS(1316),
    [sym__list_marker_star] = ACTIONS(1316),
    [sym__list_marker_parenthesis] = ACTIONS(1316),
    [sym__list_marker_dot] = ACTIONS(1316),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1316),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1316),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1316),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1316),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1316),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1316),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1316),
    [sym__blank_line_start] = ACTIONS(1316),
    [sym__html_block_1_start] = ACTIONS(1316),
    [sym__html_block_2_start] = ACTIONS(1316),
    [sym__html_block_3_start] = ACTIONS(1316),
    [sym__html_block_4_start] = ACTIONS(1316),
    [sym__html_block_5_start] = ACTIONS(1316),
    [sym__html_block_6_start] = ACTIONS(1316),
    [sym__html_block_7_start] = ACTIONS(1316),
    [sym__pipe_table_start] = ACTIONS(1316),
  },
  [126] = {
    [ts_builtin_sym_end] = ACTIONS(1322),
    [anon_sym_LBRACK] = ACTIONS(1324),
    [anon_sym_RBRACK] = ACTIONS(1322),
    [anon_sym_LT] = ACTIONS(1322),
    [anon_sym_GT] = ACTIONS(1322),
    [anon_sym_BANG] = ACTIONS(1322),
    [anon_sym_DQUOTE] = ACTIONS(1322),
    [anon_sym_POUND] = ACTIONS(1322),
    [anon_sym_DOLLAR] = ACTIONS(1322),
    [anon_sym_PERCENT] = ACTIONS(1322),
    [anon_sym_AMP] = ACTIONS(1322),
    [anon_sym_SQUOTE] = ACTIONS(1322),
    [anon_sym_STAR] = ACTIONS(1322),
    [anon_sym_PLUS] = ACTIONS(1322),
    [anon_sym_COMMA] = ACTIONS(1322),
    [anon_sym_DASH] = ACTIONS(1322),
    [anon_sym_DOT] = ACTIONS(1322),
    [anon_sym_SLASH] = ACTIONS(1322),
    [anon_sym_COLON] = ACTIONS(1322),
    [anon_sym_SEMI] = ACTIONS(1322),
    [anon_sym_EQ] = ACTIONS(1322),
    [anon_sym_QMARK] = ACTIONS(1322),
    [anon_sym_AT] = ACTIONS(1322),
    [anon_sym_BSLASH] = ACTIONS(1322),
    [anon_sym_CARET] = ACTIONS(1322),
    [anon_sym__] = ACTIONS(1322),
    [anon_sym_BQUOTE] = ACTIONS(1322),
    [anon_sym_LBRACE] = ACTIONS(1322),
    [anon_sym_PIPE] = ACTIONS(1322),
    [anon_sym_RBRACE] = ACTIONS(1322),
    [anon_sym_TILDE] = ACTIONS(1322),
    [anon_sym_LPAREN] = ACTIONS(1322),
    [anon_sym_RPAREN] = ACTIONS(1322),
    [aux_sym__word_token1] = ACTIONS(1322),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1322),
    [aux_sym__word_token2] = ACTIONS(1322),
    [sym__whitespace] = ACTIONS(1322),
    [sym__soft_line_ending] = ACTIONS(1322),
    [sym_block_continuation] = ACTIONS(1326),
    [sym__block_quote_start] = ACTIONS(1322),
    [sym__indented_chunk_start] = ACTIONS(1322),
    [sym_atx_h1_marker] = ACTIONS(1322),
    [sym_atx_h2_marker] = ACTIONS(1322),
    [sym_atx_h3_marker] = ACTIONS(1322),
    [sym_atx_h4_marker] = ACTIONS(1322),
    [sym_atx_h5_marker] = ACTIONS(1322),
    [sym_atx_h6_marker] = ACTIONS(1322),
    [sym__thematic_break] = ACTIONS(1322),
    [sym__list_marker_minus] = ACTIONS(1322),
    [sym__list_marker_plus] = ACTIONS(1322),
    [sym__list_marker_star] = ACTIONS(1322),
    [sym__list_marker_parenthesis] = ACTIONS(1322),
    [sym__list_marker_dot] = ACTIONS(1322),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1322),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1322),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1322),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1322),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1322),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1322),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1322),
    [sym__blank_line_start] = ACTIONS(1322),
    [sym__html_block_1_start] = ACTIONS(1322),
    [sym__html_block_2_start] = ACTIONS(1322),
    [sym__html_block_3_start] = ACTIONS(1322),
    [sym__html_block_4_start] = ACTIONS(1322),
    [sym__html_block_5_start] = ACTIONS(1322),
    [sym__html_block_6_start] = ACTIONS(1322),
    [sym__html_block_7_start] = ACTIONS(1322),
    [sym__pipe_table_start] = ACTIONS(1322),
  },
  [127] = {
    [ts_builtin_sym_end] = ACTIONS(1328),
    [anon_sym_LBRACK] = ACTIONS(1330),
    [anon_sym_RBRACK] = ACTIONS(1328),
    [anon_sym_LT] = ACTIONS(1328),
    [anon_sym_GT] = ACTIONS(1328),
    [anon_sym_BANG] = ACTIONS(1328),
    [anon_sym_DQUOTE] = ACTIONS(1328),
    [anon_sym_POUND] = ACTIONS(1328),
    [anon_sym_DOLLAR] = ACTIONS(1328),
    [anon_sym_PERCENT] = ACTIONS(1328),
    [anon_sym_AMP] = ACTIONS(1328),
    [anon_sym_SQUOTE] = ACTIONS(1328),
    [anon_sym_STAR] = ACTIONS(1328),
    [anon_sym_PLUS] = ACTIONS(1328),
    [anon_sym_COMMA] = ACTIONS(1328),
    [anon_sym_DASH] = ACTIONS(1328),
    [anon_sym_DOT] = ACTIONS(1328),
    [anon_sym_SLASH] = ACTIONS(1328),
    [anon_sym_COLON] = ACTIONS(1328),
    [anon_sym_SEMI] = ACTIONS(1328),
    [anon_sym_EQ] = ACTIONS(1328),
    [anon_sym_QMARK] = ACTIONS(1328),
    [anon_sym_AT] = ACTIONS(1328),
    [anon_sym_BSLASH] = ACTIONS(1328),
    [anon_sym_CARET] = ACTIONS(1328),
    [anon_sym__] = ACTIONS(1328),
    [anon_sym_BQUOTE] = ACTIONS(1328),
    [anon_sym_LBRACE] = ACTIONS(1328),
    [anon_sym_PIPE] = ACTIONS(1328),
    [anon_sym_RBRACE] = ACTIONS(1328),
    [anon_sym_TILDE] = ACTIONS(1328),
    [anon_sym_LPAREN] = ACTIONS(1328),
    [anon_sym_RPAREN] = ACTIONS(1328),
    [aux_sym__word_token1] = ACTIONS(1328),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1328),
    [aux_sym__word_token2] = ACTIONS(1328),
    [sym__whitespace] = ACTIONS(1328),
    [sym__soft_line_ending] = ACTIONS(1328),
    [sym_block_continuation] = ACTIONS(1332),
    [sym__block_quote_start] = ACTIONS(1328),
    [sym__indented_chunk_start] = ACTIONS(1328),
    [sym_atx_h1_marker] = ACTIONS(1328),
    [sym_atx_h2_marker] = ACTIONS(1328),
    [sym_atx_h3_marker] = ACTIONS(1328),
    [sym_atx_h4_marker] = ACTIONS(1328),
    [sym_atx_h5_marker] = ACTIONS(1328),
    [sym_atx_h6_marker] = ACTIONS(1328),
    [sym__thematic_break] = ACTIONS(1328),
    [sym__list_marker_minus] = ACTIONS(1328),
    [sym__list_marker_plus] = ACTIONS(1328),
    [sym__list_marker_star] = ACTIONS(1328),
    [sym__list_marker_parenthesis] = ACTIONS(1328),
    [sym__list_marker_dot] = ACTIONS(1328),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1328),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1328),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1328),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1328),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1328),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1328),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1328),
    [sym__blank_line_start] = ACTIONS(1328),
    [sym__html_block_1_start] = ACTIONS(1328),
    [sym__html_block_2_start] = ACTIONS(1328),
    [sym__html_block_3_start] = ACTIONS(1328),
    [sym__html_block_4_start] = ACTIONS(1328),
    [sym__html_block_5_start] = ACTIONS(1328),
    [sym__html_block_6_start] = ACTIONS(1328),
    [sym__html_block_7_start] = ACTIONS(1328),
    [sym__pipe_table_start] = ACTIONS(1328),
  },
  [128] = {
    [ts_builtin_sym_end] = ACTIONS(1334),
    [anon_sym_LBRACK] = ACTIONS(1336),
    [anon_sym_RBRACK] = ACTIONS(1334),
    [anon_sym_LT] = ACTIONS(1334),
    [anon_sym_GT] = ACTIONS(1334),
    [anon_sym_BANG] = ACTIONS(1334),
    [anon_sym_DQUOTE] = ACTIONS(1334),
    [anon_sym_POUND] = ACTIONS(1334),
    [anon_sym_DOLLAR] = ACTIONS(1334),
    [anon_sym_PERCENT] = ACTIONS(1334),
    [anon_sym_AMP] = ACTIONS(1334),
    [anon_sym_SQUOTE] = ACTIONS(1334),
    [anon_sym_STAR] = ACTIONS(1334),
    [anon_sym_PLUS] = ACTIONS(1334),
    [anon_sym_COMMA] = ACTIONS(1334),
    [anon_sym_DASH] = ACTIONS(1334),
    [anon_sym_DOT] = ACTIONS(1334),
    [anon_sym_SLASH] = ACTIONS(1334),
    [anon_sym_COLON] = ACTIONS(1334),
    [anon_sym_SEMI] = ACTIONS(1334),
    [anon_sym_EQ] = ACTIONS(1334),
    [anon_sym_QMARK] = ACTIONS(1334),
    [anon_sym_AT] = ACTIONS(1334),
    [anon_sym_BSLASH] = ACTIONS(1334),
    [anon_sym_CARET] = ACTIONS(1334),
    [anon_sym__] = ACTIONS(1334),
    [anon_sym_BQUOTE] = ACTIONS(1334),
    [anon_sym_LBRACE] = ACTIONS(1334),
    [anon_sym_PIPE] = ACTIONS(1334),
    [anon_sym_RBRACE] = ACTIONS(1334),
    [anon_sym_TILDE] = ACTIONS(1334),
    [anon_sym_LPAREN] = ACTIONS(1334),
    [anon_sym_RPAREN] = ACTIONS(1334),
    [aux_sym__word_token1] = ACTIONS(1334),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1334),
    [aux_sym__word_token2] = ACTIONS(1334),
    [sym__whitespace] = ACTIONS(1334),
    [sym__soft_line_ending] = ACTIONS(1334),
    [sym_block_continuation] = ACTIONS(1338),
    [sym__block_quote_start] = ACTIONS(1334),
    [sym__indented_chunk_start] = ACTIONS(1334),
    [sym_atx_h1_marker] = ACTIONS(1334),
    [sym_atx_h2_marker] = ACTIONS(1334),
    [sym_atx_h3_marker] = ACTIONS(1334),
    [sym_atx_h4_marker] = ACTIONS(1334),
    [sym_atx_h5_marker] = ACTIONS(1334),
    [sym_atx_h6_marker] = ACTIONS(1334),
    [sym__thematic_break] = ACTIONS(1334),
    [sym__list_marker_minus] = ACTIONS(1334),
    [sym__list_marker_plus] = ACTIONS(1334),
    [sym__list_marker_star] = ACTIONS(1334),
    [sym__list_marker_parenthesis] = ACTIONS(1334),
    [sym__list_marker_dot] = ACTIONS(1334),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1334),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1334),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1334),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1334),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1334),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1334),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1334),
    [sym__blank_line_start] = ACTIONS(1334),
    [sym__html_block_1_start] = ACTIONS(1334),
    [sym__html_block_2_start] = ACTIONS(1334),
    [sym__html_block_3_start] = ACTIONS(1334),
    [sym__html_block_4_start] = ACTIONS(1334),
    [sym__html_block_5_start] = ACTIONS(1334),
    [sym__html_block_6_start] = ACTIONS(1334),
    [sym__html_block_7_start] = ACTIONS(1334),
    [sym__pipe_table_start] = ACTIONS(1334),
  },
  [129] = {
    [ts_builtin_sym_end] = ACTIONS(1165),
    [anon_sym_LBRACK] = ACTIONS(1163),
    [anon_sym_RBRACK] = ACTIONS(1165),
    [anon_sym_LT] = ACTIONS(1165),
    [anon_sym_GT] = ACTIONS(1165),
    [anon_sym_BANG] = ACTIONS(1165),
    [anon_sym_DQUOTE] = ACTIONS(1165),
    [anon_sym_POUND] = ACTIONS(1165),
    [anon_sym_DOLLAR] = ACTIONS(1165),
    [anon_sym_PERCENT] = ACTIONS(1165),
    [anon_sym_AMP] = ACTIONS(1165),
    [anon_sym_SQUOTE] = ACTIONS(1165),
    [anon_sym_STAR] = ACTIONS(1165),
    [anon_sym_PLUS] = ACTIONS(1165),
    [anon_sym_COMMA] = ACTIONS(1165),
    [anon_sym_DASH] = ACTIONS(1165),
    [anon_sym_DOT] = ACTIONS(1165),
    [anon_sym_SLASH] = ACTIONS(1165),
    [anon_sym_COLON] = ACTIONS(1165),
    [anon_sym_SEMI] = ACTIONS(1165),
    [anon_sym_EQ] = ACTIONS(1165),
    [anon_sym_QMARK] = ACTIONS(1165),
    [anon_sym_AT] = ACTIONS(1165),
    [anon_sym_BSLASH] = ACTIONS(1165),
    [anon_sym_CARET] = ACTIONS(1165),
    [anon_sym__] = ACTIONS(1165),
    [anon_sym_BQUOTE] = ACTIONS(1165),
    [anon_sym_LBRACE] = ACTIONS(1165),
    [anon_sym_PIPE] = ACTIONS(1165),
    [anon_sym_RBRACE] = ACTIONS(1165),
    [anon_sym_TILDE] = ACTIONS(1165),
    [anon_sym_LPAREN] = ACTIONS(1165),
    [anon_sym_RPAREN] = ACTIONS(1165),
    [aux_sym__word_token1] = ACTIONS(1165),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1165),
    [aux_sym__word_token2] = ACTIONS(1165),
    [sym__whitespace] = ACTIONS(1165),
    [sym__soft_line_ending] = ACTIONS(1165),
    [sym_block_continuation] = ACTIONS(1340),
    [sym__block_quote_start] = ACTIONS(1165),
    [sym__indented_chunk_start] = ACTIONS(1165),
    [sym_atx_h1_marker] = ACTIONS(1165),
    [sym_atx_h2_marker] = ACTIONS(1165),
    [sym_atx_h3_marker] = ACTIONS(1165),
    [sym_atx_h4_marker] = ACTIONS(1165),
    [sym_atx_h5_marker] = ACTIONS(1165),
    [sym_atx_h6_marker] = ACTIONS(1165),
    [sym__thematic_break] = ACTIONS(1165),
    [sym__list_marker_minus] = ACTIONS(1165),
    [sym__list_marker_plus] = ACTIONS(1165),
    [sym__list_marker_star] = ACTIONS(1165),
    [sym__list_marker_parenthesis] = ACTIONS(1165),
    [sym__list_marker_dot] = ACTIONS(1165),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1165),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1165),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1165),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1165),
    [sym__blank_line_start] = ACTIONS(1165),
    [sym__html_block_1_start] = ACTIONS(1165),
    [sym__html_block_2_start] = ACTIONS(1165),
    [sym__html_block_3_start] = ACTIONS(1165),
    [sym__html_block_4_start] = ACTIONS(1165),
    [sym__html_block_5_start] = ACTIONS(1165),
    [sym__html_block_6_start] = ACTIONS(1165),
    [sym__html_block_7_start] = ACTIONS(1165),
    [sym__pipe_table_start] = ACTIONS(1165),
  },
  [130] = {
    [ts_builtin_sym_end] = ACTIONS(1342),
    [anon_sym_LBRACK] = ACTIONS(1344),
    [anon_sym_RBRACK] = ACTIONS(1342),
    [anon_sym_LT] = ACTIONS(1342),
    [anon_sym_GT] = ACTIONS(1342),
    [anon_sym_BANG] = ACTIONS(1342),
    [anon_sym_DQUOTE] = ACTIONS(1342),
    [anon_sym_POUND] = ACTIONS(1342),
    [anon_sym_DOLLAR] = ACTIONS(1342),
    [anon_sym_PERCENT] = ACTIONS(1342),
    [anon_sym_AMP] = ACTIONS(1342),
    [anon_sym_SQUOTE] = ACTIONS(1342),
    [anon_sym_STAR] = ACTIONS(1342),
    [anon_sym_PLUS] = ACTIONS(1342),
    [anon_sym_COMMA] = ACTIONS(1342),
    [anon_sym_DASH] = ACTIONS(1342),
    [anon_sym_DOT] = ACTIONS(1342),
    [anon_sym_SLASH] = ACTIONS(1342),
    [anon_sym_COLON] = ACTIONS(1342),
    [anon_sym_SEMI] = ACTIONS(1342),
    [anon_sym_EQ] = ACTIONS(1342),
    [anon_sym_QMARK] = ACTIONS(1342),
    [anon_sym_AT] = ACTIONS(1342),
    [anon_sym_BSLASH] = ACTIONS(1342),
    [anon_sym_CARET] = ACTIONS(1342),
    [anon_sym__] = ACTIONS(1342),
    [anon_sym_BQUOTE] = ACTIONS(1342),
    [anon_sym_LBRACE] = ACTIONS(1342),
    [anon_sym_PIPE] = ACTIONS(1342),
    [anon_sym_RBRACE] = ACTIONS(1342),
    [anon_sym_TILDE] = ACTIONS(1342),
    [anon_sym_LPAREN] = ACTIONS(1342),
    [anon_sym_RPAREN] = ACTIONS(1342),
    [aux_sym__word_token1] = ACTIONS(1342),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1342),
    [aux_sym__word_token2] = ACTIONS(1342),
    [sym__whitespace] = ACTIONS(1342),
    [sym__soft_line_ending] = ACTIONS(1342),
    [sym_block_continuation] = ACTIONS(1346),
    [sym__block_quote_start] = ACTIONS(1342),
    [sym__indented_chunk_start] = ACTIONS(1342),
    [sym_atx_h1_marker] = ACTIONS(1342),
    [sym_atx_h2_marker] = ACTIONS(1342),
    [sym_atx_h3_marker] = ACTIONS(1342),
    [sym_atx_h4_marker] = ACTIONS(1342),
    [sym_atx_h5_marker] = ACTIONS(1342),
    [sym_atx_h6_marker] = ACTIONS(1342),
    [sym__thematic_break] = ACTIONS(1342),
    [sym__list_marker_minus] = ACTIONS(1342),
    [sym__list_marker_plus] = ACTIONS(1342),
    [sym__list_marker_star] = ACTIONS(1342),
    [sym__list_marker_parenthesis] = ACTIONS(1342),
    [sym__list_marker_dot] = ACTIONS(1342),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1342),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1342),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1342),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1342),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1342),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1342),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1342),
    [sym__blank_line_start] = ACTIONS(1342),
    [sym__html_block_1_start] = ACTIONS(1342),
    [sym__html_block_2_start] = ACTIONS(1342),
    [sym__html_block_3_start] = ACTIONS(1342),
    [sym__html_block_4_start] = ACTIONS(1342),
    [sym__html_block_5_start] = ACTIONS(1342),
    [sym__html_block_6_start] = ACTIONS(1342),
    [sym__html_block_7_start] = ACTIONS(1342),
    [sym__pipe_table_start] = ACTIONS(1342),
  },
  [131] = {
    [anon_sym_LBRACK] = ACTIONS(1348),
    [anon_sym_RBRACK] = ACTIONS(1350),
    [anon_sym_LT] = ACTIONS(1350),
    [anon_sym_GT] = ACTIONS(1350),
    [anon_sym_BANG] = ACTIONS(1350),
    [anon_sym_DQUOTE] = ACTIONS(1350),
    [anon_sym_POUND] = ACTIONS(1350),
    [anon_sym_DOLLAR] = ACTIONS(1350),
    [anon_sym_PERCENT] = ACTIONS(1350),
    [anon_sym_AMP] = ACTIONS(1350),
    [anon_sym_SQUOTE] = ACTIONS(1350),
    [anon_sym_STAR] = ACTIONS(1350),
    [anon_sym_PLUS] = ACTIONS(1350),
    [anon_sym_COMMA] = ACTIONS(1350),
    [anon_sym_DASH] = ACTIONS(1350),
    [anon_sym_DOT] = ACTIONS(1350),
    [anon_sym_SLASH] = ACTIONS(1350),
    [anon_sym_COLON] = ACTIONS(1350),
    [anon_sym_SEMI] = ACTIONS(1350),
    [anon_sym_EQ] = ACTIONS(1350),
    [anon_sym_QMARK] = ACTIONS(1350),
    [anon_sym_AT] = ACTIONS(1350),
    [anon_sym_BSLASH] = ACTIONS(1350),
    [anon_sym_CARET] = ACTIONS(1350),
    [anon_sym__] = ACTIONS(1350),
    [anon_sym_BQUOTE] = ACTIONS(1350),
    [anon_sym_LBRACE] = ACTIONS(1350),
    [anon_sym_PIPE] = ACTIONS(1350),
    [anon_sym_RBRACE] = ACTIONS(1350),
    [anon_sym_TILDE] = ACTIONS(1350),
    [anon_sym_LPAREN] = ACTIONS(1350),
    [anon_sym_RPAREN] = ACTIONS(1350),
    [aux_sym__word_token1] = ACTIONS(1350),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1350),
    [aux_sym__word_token2] = ACTIONS(1350),
    [sym__whitespace] = ACTIONS(1350),
    [sym__soft_line_ending] = ACTIONS(1350),
    [sym__block_close] = ACTIONS(1350),
    [sym__block_quote_start] = ACTIONS(1350),
    [sym__indented_chunk_start] = ACTIONS(1350),
    [sym_atx_h1_marker] = ACTIONS(1350),
    [sym_atx_h2_marker] = ACTIONS(1350),
    [sym_atx_h3_marker] = ACTIONS(1350),
    [sym_atx_h4_marker] = ACTIONS(1350),
    [sym_atx_h5_marker] = ACTIONS(1350),
    [sym_atx_h6_marker] = ACTIONS(1350),
    [sym__thematic_break] = ACTIONS(1350),
    [sym__list_marker_minus] = ACTIONS(1350),
    [sym__list_marker_plus] = ACTIONS(1350),
    [sym__list_marker_star] = ACTIONS(1350),
    [sym__list_marker_parenthesis] = ACTIONS(1350),
    [sym__list_marker_dot] = ACTIONS(1350),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1350),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1350),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1350),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1350),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1350),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1350),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1350),
    [sym__blank_line_start] = ACTIONS(1350),
    [sym__html_block_1_start] = ACTIONS(1350),
    [sym__html_block_2_start] = ACTIONS(1350),
    [sym__html_block_3_start] = ACTIONS(1350),
    [sym__html_block_4_start] = ACTIONS(1350),
    [sym__html_block_5_start] = ACTIONS(1350),
    [sym__html_block_6_start] = ACTIONS(1350),
    [sym__html_block_7_start] = ACTIONS(1350),
    [sym__no_indented_chunk] = ACTIONS(1350),
    [sym__pipe_table_start] = ACTIONS(1350),
  },
  [132] = {
    [ts_builtin_sym_end] = ACTIONS(1352),
    [anon_sym_LBRACK] = ACTIONS(1354),
    [anon_sym_RBRACK] = ACTIONS(1352),
    [anon_sym_LT] = ACTIONS(1352),
    [anon_sym_GT] = ACTIONS(1352),
    [anon_sym_BANG] = ACTIONS(1352),
    [anon_sym_DQUOTE] = ACTIONS(1352),
    [anon_sym_POUND] = ACTIONS(1352),
    [anon_sym_DOLLAR] = ACTIONS(1352),
    [anon_sym_PERCENT] = ACTIONS(1352),
    [anon_sym_AMP] = ACTIONS(1352),
    [anon_sym_SQUOTE] = ACTIONS(1352),
    [anon_sym_STAR] = ACTIONS(1352),
    [anon_sym_PLUS] = ACTIONS(1352),
    [anon_sym_COMMA] = ACTIONS(1352),
    [anon_sym_DASH] = ACTIONS(1352),
    [anon_sym_DOT] = ACTIONS(1352),
    [anon_sym_SLASH] = ACTIONS(1352),
    [anon_sym_COLON] = ACTIONS(1352),
    [anon_sym_SEMI] = ACTIONS(1352),
    [anon_sym_EQ] = ACTIONS(1352),
    [anon_sym_QMARK] = ACTIONS(1352),
    [anon_sym_AT] = ACTIONS(1352),
    [anon_sym_BSLASH] = ACTIONS(1352),
    [anon_sym_CARET] = ACTIONS(1352),
    [anon_sym__] = ACTIONS(1352),
    [anon_sym_BQUOTE] = ACTIONS(1352),
    [anon_sym_LBRACE] = ACTIONS(1352),
    [anon_sym_PIPE] = ACTIONS(1352),
    [anon_sym_RBRACE] = ACTIONS(1352),
    [anon_sym_TILDE] = ACTIONS(1352),
    [anon_sym_LPAREN] = ACTIONS(1352),
    [anon_sym_RPAREN] = ACTIONS(1352),
    [aux_sym__word_token1] = ACTIONS(1352),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1352),
    [aux_sym__word_token2] = ACTIONS(1352),
    [sym__whitespace] = ACTIONS(1352),
    [sym__soft_line_ending] = ACTIONS(1352),
    [sym_block_continuation] = ACTIONS(1356),
    [sym__block_quote_start] = ACTIONS(1352),
    [sym__indented_chunk_start] = ACTIONS(1352),
    [sym_atx_h1_marker] = ACTIONS(1352),
    [sym_atx_h2_marker] = ACTIONS(1352),
    [sym_atx_h3_marker] = ACTIONS(1352),
    [sym_atx_h4_marker] = ACTIONS(1352),
    [sym_atx_h5_marker] = ACTIONS(1352),
    [sym_atx_h6_marker] = ACTIONS(1352),
    [sym__thematic_break] = ACTIONS(1352),
    [sym__list_marker_minus] = ACTIONS(1352),
    [sym__list_marker_plus] = ACTIONS(1352),
    [sym__list_marker_star] = ACTIONS(1352),
    [sym__list_marker_parenthesis] = ACTIONS(1352),
    [sym__list_marker_dot] = ACTIONS(1352),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1352),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1352),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1352),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1352),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1352),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1352),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1352),
    [sym__blank_line_start] = ACTIONS(1352),
    [sym__html_block_1_start] = ACTIONS(1352),
    [sym__html_block_2_start] = ACTIONS(1352),
    [sym__html_block_3_start] = ACTIONS(1352),
    [sym__html_block_4_start] = ACTIONS(1352),
    [sym__html_block_5_start] = ACTIONS(1352),
    [sym__html_block_6_start] = ACTIONS(1352),
    [sym__html_block_7_start] = ACTIONS(1352),
    [sym__pipe_table_start] = ACTIONS(1352),
  },
  [133] = {
    [ts_builtin_sym_end] = ACTIONS(1358),
    [anon_sym_LBRACK] = ACTIONS(1360),
    [anon_sym_RBRACK] = ACTIONS(1358),
    [anon_sym_LT] = ACTIONS(1358),
    [anon_sym_GT] = ACTIONS(1358),
    [anon_sym_BANG] = ACTIONS(1358),
    [anon_sym_DQUOTE] = ACTIONS(1358),
    [anon_sym_POUND] = ACTIONS(1358),
    [anon_sym_DOLLAR] = ACTIONS(1358),
    [anon_sym_PERCENT] = ACTIONS(1358),
    [anon_sym_AMP] = ACTIONS(1358),
    [anon_sym_SQUOTE] = ACTIONS(1358),
    [anon_sym_STAR] = ACTIONS(1358),
    [anon_sym_PLUS] = ACTIONS(1358),
    [anon_sym_COMMA] = ACTIONS(1358),
    [anon_sym_DASH] = ACTIONS(1358),
    [anon_sym_DOT] = ACTIONS(1358),
    [anon_sym_SLASH] = ACTIONS(1358),
    [anon_sym_COLON] = ACTIONS(1358),
    [anon_sym_SEMI] = ACTIONS(1358),
    [anon_sym_EQ] = ACTIONS(1358),
    [anon_sym_QMARK] = ACTIONS(1358),
    [anon_sym_AT] = ACTIONS(1358),
    [anon_sym_BSLASH] = ACTIONS(1358),
    [anon_sym_CARET] = ACTIONS(1358),
    [anon_sym__] = ACTIONS(1358),
    [anon_sym_BQUOTE] = ACTIONS(1358),
    [anon_sym_LBRACE] = ACTIONS(1358),
    [anon_sym_PIPE] = ACTIONS(1358),
    [anon_sym_RBRACE] = ACTIONS(1358),
    [anon_sym_TILDE] = ACTIONS(1358),
    [anon_sym_LPAREN] = ACTIONS(1358),
    [anon_sym_RPAREN] = ACTIONS(1358),
    [aux_sym__word_token1] = ACTIONS(1358),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1358),
    [aux_sym__word_token2] = ACTIONS(1358),
    [sym__whitespace] = ACTIONS(1358),
    [sym__soft_line_ending] = ACTIONS(1358),
    [sym_block_continuation] = ACTIONS(1362),
    [sym__block_quote_start] = ACTIONS(1358),
    [sym__indented_chunk_start] = ACTIONS(1358),
    [sym_atx_h1_marker] = ACTIONS(1358),
    [sym_atx_h2_marker] = ACTIONS(1358),
    [sym_atx_h3_marker] = ACTIONS(1358),
    [sym_atx_h4_marker] = ACTIONS(1358),
    [sym_atx_h5_marker] = ACTIONS(1358),
    [sym_atx_h6_marker] = ACTIONS(1358),
    [sym__thematic_break] = ACTIONS(1358),
    [sym__list_marker_minus] = ACTIONS(1358),
    [sym__list_marker_plus] = ACTIONS(1358),
    [sym__list_marker_star] = ACTIONS(1358),
    [sym__list_marker_parenthesis] = ACTIONS(1358),
    [sym__list_marker_dot] = ACTIONS(1358),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1358),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1358),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1358),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1358),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1358),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1358),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1358),
    [sym__blank_line_start] = ACTIONS(1358),
    [sym__html_block_1_start] = ACTIONS(1358),
    [sym__html_block_2_start] = ACTIONS(1358),
    [sym__html_block_3_start] = ACTIONS(1358),
    [sym__html_block_4_start] = ACTIONS(1358),
    [sym__html_block_5_start] = ACTIONS(1358),
    [sym__html_block_6_start] = ACTIONS(1358),
    [sym__html_block_7_start] = ACTIONS(1358),
    [sym__pipe_table_start] = ACTIONS(1358),
  },
  [134] = {
    [ts_builtin_sym_end] = ACTIONS(1364),
    [anon_sym_LBRACK] = ACTIONS(1366),
    [anon_sym_RBRACK] = ACTIONS(1364),
    [anon_sym_LT] = ACTIONS(1364),
    [anon_sym_GT] = ACTIONS(1364),
    [anon_sym_BANG] = ACTIONS(1364),
    [anon_sym_DQUOTE] = ACTIONS(1364),
    [anon_sym_POUND] = ACTIONS(1364),
    [anon_sym_DOLLAR] = ACTIONS(1364),
    [anon_sym_PERCENT] = ACTIONS(1364),
    [anon_sym_AMP] = ACTIONS(1364),
    [anon_sym_SQUOTE] = ACTIONS(1364),
    [anon_sym_STAR] = ACTIONS(1364),
    [anon_sym_PLUS] = ACTIONS(1364),
    [anon_sym_COMMA] = ACTIONS(1364),
    [anon_sym_DASH] = ACTIONS(1364),
    [anon_sym_DOT] = ACTIONS(1364),
    [anon_sym_SLASH] = ACTIONS(1364),
    [anon_sym_COLON] = ACTIONS(1364),
    [anon_sym_SEMI] = ACTIONS(1364),
    [anon_sym_EQ] = ACTIONS(1364),
    [anon_sym_QMARK] = ACTIONS(1364),
    [anon_sym_AT] = ACTIONS(1364),
    [anon_sym_BSLASH] = ACTIONS(1364),
    [anon_sym_CARET] = ACTIONS(1364),
    [anon_sym__] = ACTIONS(1364),
    [anon_sym_BQUOTE] = ACTIONS(1364),
    [anon_sym_LBRACE] = ACTIONS(1364),
    [anon_sym_PIPE] = ACTIONS(1364),
    [anon_sym_RBRACE] = ACTIONS(1364),
    [anon_sym_TILDE] = ACTIONS(1364),
    [anon_sym_LPAREN] = ACTIONS(1364),
    [anon_sym_RPAREN] = ACTIONS(1364),
    [aux_sym__word_token1] = ACTIONS(1364),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1364),
    [aux_sym__word_token2] = ACTIONS(1364),
    [sym__whitespace] = ACTIONS(1364),
    [sym__soft_line_ending] = ACTIONS(1364),
    [sym_block_continuation] = ACTIONS(1368),
    [sym__block_quote_start] = ACTIONS(1364),
    [sym__indented_chunk_start] = ACTIONS(1364),
    [sym_atx_h1_marker] = ACTIONS(1364),
    [sym_atx_h2_marker] = ACTIONS(1364),
    [sym_atx_h3_marker] = ACTIONS(1364),
    [sym_atx_h4_marker] = ACTIONS(1364),
    [sym_atx_h5_marker] = ACTIONS(1364),
    [sym_atx_h6_marker] = ACTIONS(1364),
    [sym__thematic_break] = ACTIONS(1364),
    [sym__list_marker_minus] = ACTIONS(1364),
    [sym__list_marker_plus] = ACTIONS(1364),
    [sym__list_marker_star] = ACTIONS(1364),
    [sym__list_marker_parenthesis] = ACTIONS(1364),
    [sym__list_marker_dot] = ACTIONS(1364),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1364),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1364),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1364),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1364),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1364),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1364),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1364),
    [sym__blank_line_start] = ACTIONS(1364),
    [sym__html_block_1_start] = ACTIONS(1364),
    [sym__html_block_2_start] = ACTIONS(1364),
    [sym__html_block_3_start] = ACTIONS(1364),
    [sym__html_block_4_start] = ACTIONS(1364),
    [sym__html_block_5_start] = ACTIONS(1364),
    [sym__html_block_6_start] = ACTIONS(1364),
    [sym__html_block_7_start] = ACTIONS(1364),
    [sym__pipe_table_start] = ACTIONS(1364),
  },
  [135] = {
    [anon_sym_LBRACK] = ACTIONS(1370),
    [anon_sym_RBRACK] = ACTIONS(1372),
    [anon_sym_LT] = ACTIONS(1372),
    [anon_sym_GT] = ACTIONS(1372),
    [anon_sym_BANG] = ACTIONS(1372),
    [anon_sym_DQUOTE] = ACTIONS(1372),
    [anon_sym_POUND] = ACTIONS(1372),
    [anon_sym_DOLLAR] = ACTIONS(1372),
    [anon_sym_PERCENT] = ACTIONS(1372),
    [anon_sym_AMP] = ACTIONS(1372),
    [anon_sym_SQUOTE] = ACTIONS(1372),
    [anon_sym_STAR] = ACTIONS(1372),
    [anon_sym_PLUS] = ACTIONS(1372),
    [anon_sym_COMMA] = ACTIONS(1372),
    [anon_sym_DASH] = ACTIONS(1372),
    [anon_sym_DOT] = ACTIONS(1372),
    [anon_sym_SLASH] = ACTIONS(1372),
    [anon_sym_COLON] = ACTIONS(1372),
    [anon_sym_SEMI] = ACTIONS(1372),
    [anon_sym_EQ] = ACTIONS(1372),
    [anon_sym_QMARK] = ACTIONS(1372),
    [anon_sym_AT] = ACTIONS(1372),
    [anon_sym_BSLASH] = ACTIONS(1372),
    [anon_sym_CARET] = ACTIONS(1372),
    [anon_sym__] = ACTIONS(1372),
    [anon_sym_BQUOTE] = ACTIONS(1372),
    [anon_sym_LBRACE] = ACTIONS(1372),
    [anon_sym_PIPE] = ACTIONS(1372),
    [anon_sym_RBRACE] = ACTIONS(1372),
    [anon_sym_TILDE] = ACTIONS(1372),
    [anon_sym_LPAREN] = ACTIONS(1372),
    [anon_sym_RPAREN] = ACTIONS(1372),
    [aux_sym__word_token1] = ACTIONS(1372),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1372),
    [aux_sym__word_token2] = ACTIONS(1372),
    [sym__whitespace] = ACTIONS(1372),
    [sym__soft_line_ending] = ACTIONS(1372),
    [sym__block_close] = ACTIONS(1372),
    [sym_block_continuation] = ACTIONS(1374),
    [sym__block_quote_start] = ACTIONS(1372),
    [sym__indented_chunk_start] = ACTIONS(1372),
    [sym_atx_h1_marker] = ACTIONS(1372),
    [sym_atx_h2_marker] = ACTIONS(1372),
    [sym_atx_h3_marker] = ACTIONS(1372),
    [sym_atx_h4_marker] = ACTIONS(1372),
    [sym_atx_h5_marker] = ACTIONS(1372),
    [sym_atx_h6_marker] = ACTIONS(1372),
    [sym__thematic_break] = ACTIONS(1372),
    [sym__list_marker_minus] = ACTIONS(1372),
    [sym__list_marker_plus] = ACTIONS(1372),
    [sym__list_marker_star] = ACTIONS(1372),
    [sym__list_marker_parenthesis] = ACTIONS(1372),
    [sym__list_marker_dot] = ACTIONS(1372),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1372),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1372),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1372),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1372),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1372),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1372),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1372),
    [sym__blank_line_start] = ACTIONS(1372),
    [sym__html_block_1_start] = ACTIONS(1372),
    [sym__html_block_2_start] = ACTIONS(1372),
    [sym__html_block_3_start] = ACTIONS(1372),
    [sym__html_block_4_start] = ACTIONS(1372),
    [sym__html_block_5_start] = ACTIONS(1372),
    [sym__html_block_6_start] = ACTIONS(1372),
    [sym__html_block_7_start] = ACTIONS(1372),
    [sym__pipe_table_start] = ACTIONS(1372),
  },
  [136] = {
    [ts_builtin_sym_end] = ACTIONS(1376),
    [anon_sym_LBRACK] = ACTIONS(1378),
    [anon_sym_RBRACK] = ACTIONS(1376),
    [anon_sym_LT] = ACTIONS(1376),
    [anon_sym_GT] = ACTIONS(1376),
    [anon_sym_BANG] = ACTIONS(1376),
    [anon_sym_DQUOTE] = ACTIONS(1376),
    [anon_sym_POUND] = ACTIONS(1376),
    [anon_sym_DOLLAR] = ACTIONS(1376),
    [anon_sym_PERCENT] = ACTIONS(1376),
    [anon_sym_AMP] = ACTIONS(1376),
    [anon_sym_SQUOTE] = ACTIONS(1376),
    [anon_sym_STAR] = ACTIONS(1376),
    [anon_sym_PLUS] = ACTIONS(1376),
    [anon_sym_COMMA] = ACTIONS(1376),
    [anon_sym_DASH] = ACTIONS(1376),
    [anon_sym_DOT] = ACTIONS(1376),
    [anon_sym_SLASH] = ACTIONS(1376),
    [anon_sym_COLON] = ACTIONS(1376),
    [anon_sym_SEMI] = ACTIONS(1376),
    [anon_sym_EQ] = ACTIONS(1376),
    [anon_sym_QMARK] = ACTIONS(1376),
    [anon_sym_AT] = ACTIONS(1376),
    [anon_sym_BSLASH] = ACTIONS(1376),
    [anon_sym_CARET] = ACTIONS(1376),
    [anon_sym__] = ACTIONS(1376),
    [anon_sym_BQUOTE] = ACTIONS(1376),
    [anon_sym_LBRACE] = ACTIONS(1376),
    [anon_sym_PIPE] = ACTIONS(1376),
    [anon_sym_RBRACE] = ACTIONS(1376),
    [anon_sym_TILDE] = ACTIONS(1376),
    [anon_sym_LPAREN] = ACTIONS(1376),
    [anon_sym_RPAREN] = ACTIONS(1376),
    [aux_sym__word_token1] = ACTIONS(1376),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1376),
    [aux_sym__word_token2] = ACTIONS(1376),
    [sym__whitespace] = ACTIONS(1376),
    [sym__soft_line_ending] = ACTIONS(1376),
    [sym_block_continuation] = ACTIONS(1380),
    [sym__block_quote_start] = ACTIONS(1376),
    [sym__indented_chunk_start] = ACTIONS(1376),
    [sym_atx_h1_marker] = ACTIONS(1376),
    [sym_atx_h2_marker] = ACTIONS(1376),
    [sym_atx_h3_marker] = ACTIONS(1376),
    [sym_atx_h4_marker] = ACTIONS(1376),
    [sym_atx_h5_marker] = ACTIONS(1376),
    [sym_atx_h6_marker] = ACTIONS(1376),
    [sym__thematic_break] = ACTIONS(1376),
    [sym__list_marker_minus] = ACTIONS(1376),
    [sym__list_marker_plus] = ACTIONS(1376),
    [sym__list_marker_star] = ACTIONS(1376),
    [sym__list_marker_parenthesis] = ACTIONS(1376),
    [sym__list_marker_dot] = ACTIONS(1376),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1376),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1376),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1376),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1376),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1376),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1376),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1376),
    [sym__blank_line_start] = ACTIONS(1376),
    [sym__html_block_1_start] = ACTIONS(1376),
    [sym__html_block_2_start] = ACTIONS(1376),
    [sym__html_block_3_start] = ACTIONS(1376),
    [sym__html_block_4_start] = ACTIONS(1376),
    [sym__html_block_5_start] = ACTIONS(1376),
    [sym__html_block_6_start] = ACTIONS(1376),
    [sym__html_block_7_start] = ACTIONS(1376),
    [sym__pipe_table_start] = ACTIONS(1376),
  },
  [137] = {
    [anon_sym_LBRACK] = ACTIONS(1382),
    [anon_sym_RBRACK] = ACTIONS(1384),
    [anon_sym_LT] = ACTIONS(1384),
    [anon_sym_GT] = ACTIONS(1384),
    [anon_sym_BANG] = ACTIONS(1384),
    [anon_sym_DQUOTE] = ACTIONS(1384),
    [anon_sym_POUND] = ACTIONS(1384),
    [anon_sym_DOLLAR] = ACTIONS(1384),
    [anon_sym_PERCENT] = ACTIONS(1384),
    [anon_sym_AMP] = ACTIONS(1384),
    [anon_sym_SQUOTE] = ACTIONS(1384),
    [anon_sym_STAR] = ACTIONS(1384),
    [anon_sym_PLUS] = ACTIONS(1384),
    [anon_sym_COMMA] = ACTIONS(1384),
    [anon_sym_DASH] = ACTIONS(1384),
    [anon_sym_DOT] = ACTIONS(1384),
    [anon_sym_SLASH] = ACTIONS(1384),
    [anon_sym_COLON] = ACTIONS(1384),
    [anon_sym_SEMI] = ACTIONS(1384),
    [anon_sym_EQ] = ACTIONS(1384),
    [anon_sym_QMARK] = ACTIONS(1384),
    [anon_sym_AT] = ACTIONS(1384),
    [anon_sym_BSLASH] = ACTIONS(1384),
    [anon_sym_CARET] = ACTIONS(1384),
    [anon_sym__] = ACTIONS(1384),
    [anon_sym_BQUOTE] = ACTIONS(1384),
    [anon_sym_LBRACE] = ACTIONS(1384),
    [anon_sym_PIPE] = ACTIONS(1384),
    [anon_sym_RBRACE] = ACTIONS(1384),
    [anon_sym_TILDE] = ACTIONS(1384),
    [anon_sym_LPAREN] = ACTIONS(1384),
    [anon_sym_RPAREN] = ACTIONS(1384),
    [aux_sym__word_token1] = ACTIONS(1384),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1384),
    [aux_sym__word_token2] = ACTIONS(1384),
    [sym__whitespace] = ACTIONS(1384),
    [sym__soft_line_ending] = ACTIONS(1384),
    [sym__block_close] = ACTIONS(1384),
    [sym_block_continuation] = ACTIONS(1386),
    [sym__block_quote_start] = ACTIONS(1384),
    [sym__indented_chunk_start] = ACTIONS(1384),
    [sym_atx_h1_marker] = ACTIONS(1384),
    [sym_atx_h2_marker] = ACTIONS(1384),
    [sym_atx_h3_marker] = ACTIONS(1384),
    [sym_atx_h4_marker] = ACTIONS(1384),
    [sym_atx_h5_marker] = ACTIONS(1384),
    [sym_atx_h6_marker] = ACTIONS(1384),
    [sym__thematic_break] = ACTIONS(1384),
    [sym__list_marker_minus] = ACTIONS(1384),
    [sym__list_marker_plus] = ACTIONS(1384),
    [sym__list_marker_star] = ACTIONS(1384),
    [sym__list_marker_parenthesis] = ACTIONS(1384),
    [sym__list_marker_dot] = ACTIONS(1384),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1384),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1384),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1384),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1384),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1384),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1384),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1384),
    [sym__blank_line_start] = ACTIONS(1384),
    [sym__html_block_1_start] = ACTIONS(1384),
    [sym__html_block_2_start] = ACTIONS(1384),
    [sym__html_block_3_start] = ACTIONS(1384),
    [sym__html_block_4_start] = ACTIONS(1384),
    [sym__html_block_5_start] = ACTIONS(1384),
    [sym__html_block_6_start] = ACTIONS(1384),
    [sym__html_block_7_start] = ACTIONS(1384),
    [sym__pipe_table_start] = ACTIONS(1384),
  },
  [138] = {
    [anon_sym_LBRACK] = ACTIONS(1388),
    [anon_sym_RBRACK] = ACTIONS(1390),
    [anon_sym_LT] = ACTIONS(1390),
    [anon_sym_GT] = ACTIONS(1390),
    [anon_sym_BANG] = ACTIONS(1390),
    [anon_sym_DQUOTE] = ACTIONS(1390),
    [anon_sym_POUND] = ACTIONS(1390),
    [anon_sym_DOLLAR] = ACTIONS(1390),
    [anon_sym_PERCENT] = ACTIONS(1390),
    [anon_sym_AMP] = ACTIONS(1390),
    [anon_sym_SQUOTE] = ACTIONS(1390),
    [anon_sym_STAR] = ACTIONS(1390),
    [anon_sym_PLUS] = ACTIONS(1390),
    [anon_sym_COMMA] = ACTIONS(1390),
    [anon_sym_DASH] = ACTIONS(1390),
    [anon_sym_DOT] = ACTIONS(1390),
    [anon_sym_SLASH] = ACTIONS(1390),
    [anon_sym_COLON] = ACTIONS(1390),
    [anon_sym_SEMI] = ACTIONS(1390),
    [anon_sym_EQ] = ACTIONS(1390),
    [anon_sym_QMARK] = ACTIONS(1390),
    [anon_sym_AT] = ACTIONS(1390),
    [anon_sym_BSLASH] = ACTIONS(1390),
    [anon_sym_CARET] = ACTIONS(1390),
    [anon_sym__] = ACTIONS(1390),
    [anon_sym_BQUOTE] = ACTIONS(1390),
    [anon_sym_LBRACE] = ACTIONS(1390),
    [anon_sym_PIPE] = ACTIONS(1390),
    [anon_sym_RBRACE] = ACTIONS(1390),
    [anon_sym_TILDE] = ACTIONS(1390),
    [anon_sym_LPAREN] = ACTIONS(1390),
    [anon_sym_RPAREN] = ACTIONS(1390),
    [aux_sym__word_token1] = ACTIONS(1390),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1390),
    [aux_sym__word_token2] = ACTIONS(1390),
    [sym__whitespace] = ACTIONS(1390),
    [sym__soft_line_ending] = ACTIONS(1390),
    [sym__block_close] = ACTIONS(1390),
    [sym_block_continuation] = ACTIONS(1392),
    [sym__block_quote_start] = ACTIONS(1390),
    [sym__indented_chunk_start] = ACTIONS(1390),
    [sym_atx_h1_marker] = ACTIONS(1390),
    [sym_atx_h2_marker] = ACTIONS(1390),
    [sym_atx_h3_marker] = ACTIONS(1390),
    [sym_atx_h4_marker] = ACTIONS(1390),
    [sym_atx_h5_marker] = ACTIONS(1390),
    [sym_atx_h6_marker] = ACTIONS(1390),
    [sym__thematic_break] = ACTIONS(1390),
    [sym__list_marker_minus] = ACTIONS(1390),
    [sym__list_marker_plus] = ACTIONS(1390),
    [sym__list_marker_star] = ACTIONS(1390),
    [sym__list_marker_parenthesis] = ACTIONS(1390),
    [sym__list_marker_dot] = ACTIONS(1390),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1390),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1390),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1390),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1390),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1390),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1390),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1390),
    [sym__blank_line_start] = ACTIONS(1390),
    [sym__html_block_1_start] = ACTIONS(1390),
    [sym__html_block_2_start] = ACTIONS(1390),
    [sym__html_block_3_start] = ACTIONS(1390),
    [sym__html_block_4_start] = ACTIONS(1390),
    [sym__html_block_5_start] = ACTIONS(1390),
    [sym__html_block_6_start] = ACTIONS(1390),
    [sym__html_block_7_start] = ACTIONS(1390),
    [sym__pipe_table_start] = ACTIONS(1390),
  },
  [139] = {
    [ts_builtin_sym_end] = ACTIONS(1350),
    [anon_sym_LBRACK] = ACTIONS(1348),
    [anon_sym_RBRACK] = ACTIONS(1350),
    [anon_sym_LT] = ACTIONS(1350),
    [anon_sym_GT] = ACTIONS(1350),
    [anon_sym_BANG] = ACTIONS(1350),
    [anon_sym_DQUOTE] = ACTIONS(1350),
    [anon_sym_POUND] = ACTIONS(1350),
    [anon_sym_DOLLAR] = ACTIONS(1350),
    [anon_sym_PERCENT] = ACTIONS(1350),
    [anon_sym_AMP] = ACTIONS(1350),
    [anon_sym_SQUOTE] = ACTIONS(1350),
    [anon_sym_STAR] = ACTIONS(1350),
    [anon_sym_PLUS] = ACTIONS(1350),
    [anon_sym_COMMA] = ACTIONS(1350),
    [anon_sym_DASH] = ACTIONS(1350),
    [anon_sym_DOT] = ACTIONS(1350),
    [anon_sym_SLASH] = ACTIONS(1350),
    [anon_sym_COLON] = ACTIONS(1350),
    [anon_sym_SEMI] = ACTIONS(1350),
    [anon_sym_EQ] = ACTIONS(1350),
    [anon_sym_QMARK] = ACTIONS(1350),
    [anon_sym_AT] = ACTIONS(1350),
    [anon_sym_BSLASH] = ACTIONS(1350),
    [anon_sym_CARET] = ACTIONS(1350),
    [anon_sym__] = ACTIONS(1350),
    [anon_sym_BQUOTE] = ACTIONS(1350),
    [anon_sym_LBRACE] = ACTIONS(1350),
    [anon_sym_PIPE] = ACTIONS(1350),
    [anon_sym_RBRACE] = ACTIONS(1350),
    [anon_sym_TILDE] = ACTIONS(1350),
    [anon_sym_LPAREN] = ACTIONS(1350),
    [anon_sym_RPAREN] = ACTIONS(1350),
    [aux_sym__word_token1] = ACTIONS(1350),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1350),
    [aux_sym__word_token2] = ACTIONS(1350),
    [sym__whitespace] = ACTIONS(1350),
    [sym__soft_line_ending] = ACTIONS(1350),
    [sym__block_quote_start] = ACTIONS(1350),
    [sym__indented_chunk_start] = ACTIONS(1350),
    [sym_atx_h1_marker] = ACTIONS(1350),
    [sym_atx_h2_marker] = ACTIONS(1350),
    [sym_atx_h3_marker] = ACTIONS(1350),
    [sym_atx_h4_marker] = ACTIONS(1350),
    [sym_atx_h5_marker] = ACTIONS(1350),
    [sym_atx_h6_marker] = ACTIONS(1350),
    [sym__thematic_break] = ACTIONS(1350),
    [sym__list_marker_minus] = ACTIONS(1350),
    [sym__list_marker_plus] = ACTIONS(1350),
    [sym__list_marker_star] = ACTIONS(1350),
    [sym__list_marker_parenthesis] = ACTIONS(1350),
    [sym__list_marker_dot] = ACTIONS(1350),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1350),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1350),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1350),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1350),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1350),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1350),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1350),
    [sym__blank_line_start] = ACTIONS(1350),
    [sym__html_block_1_start] = ACTIONS(1350),
    [sym__html_block_2_start] = ACTIONS(1350),
    [sym__html_block_3_start] = ACTIONS(1350),
    [sym__html_block_4_start] = ACTIONS(1350),
    [sym__html_block_5_start] = ACTIONS(1350),
    [sym__html_block_6_start] = ACTIONS(1350),
    [sym__html_block_7_start] = ACTIONS(1350),
    [sym__no_indented_chunk] = ACTIONS(1350),
    [sym__pipe_table_start] = ACTIONS(1350),
  },
  [140] = {
    [ts_builtin_sym_end] = ACTIONS(1394),
    [anon_sym_LBRACK] = ACTIONS(1396),
    [anon_sym_RBRACK] = ACTIONS(1394),
    [anon_sym_LT] = ACTIONS(1394),
    [anon_sym_GT] = ACTIONS(1394),
    [anon_sym_BANG] = ACTIONS(1394),
    [anon_sym_DQUOTE] = ACTIONS(1394),
    [anon_sym_POUND] = ACTIONS(1394),
    [anon_sym_DOLLAR] = ACTIONS(1394),
    [anon_sym_PERCENT] = ACTIONS(1394),
    [anon_sym_AMP] = ACTIONS(1394),
    [anon_sym_SQUOTE] = ACTIONS(1394),
    [anon_sym_STAR] = ACTIONS(1394),
    [anon_sym_PLUS] = ACTIONS(1394),
    [anon_sym_COMMA] = ACTIONS(1394),
    [anon_sym_DASH] = ACTIONS(1394),
    [anon_sym_DOT] = ACTIONS(1394),
    [anon_sym_SLASH] = ACTIONS(1394),
    [anon_sym_COLON] = ACTIONS(1394),
    [anon_sym_SEMI] = ACTIONS(1394),
    [anon_sym_EQ] = ACTIONS(1394),
    [anon_sym_QMARK] = ACTIONS(1394),
    [anon_sym_AT] = ACTIONS(1394),
    [anon_sym_BSLASH] = ACTIONS(1394),
    [anon_sym_CARET] = ACTIONS(1394),
    [anon_sym__] = ACTIONS(1394),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [anon_sym_LBRACE] = ACTIONS(1394),
    [anon_sym_PIPE] = ACTIONS(1394),
    [anon_sym_RBRACE] = ACTIONS(1394),
    [anon_sym_TILDE] = ACTIONS(1394),
    [anon_sym_LPAREN] = ACTIONS(1394),
    [anon_sym_RPAREN] = ACTIONS(1394),
    [aux_sym__word_token1] = ACTIONS(1394),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1394),
    [aux_sym__word_token2] = ACTIONS(1394),
    [sym__whitespace] = ACTIONS(1394),
    [sym__soft_line_ending] = ACTIONS(1394),
    [sym_block_continuation] = ACTIONS(1398),
    [sym__block_quote_start] = ACTIONS(1394),
    [sym__indented_chunk_start] = ACTIONS(1394),
    [sym_atx_h1_marker] = ACTIONS(1394),
    [sym_atx_h2_marker] = ACTIONS(1394),
    [sym_atx_h3_marker] = ACTIONS(1394),
    [sym_atx_h4_marker] = ACTIONS(1394),
    [sym_atx_h5_marker] = ACTIONS(1394),
    [sym_atx_h6_marker] = ACTIONS(1394),
    [sym__thematic_break] = ACTIONS(1394),
    [sym__list_marker_minus] = ACTIONS(1394),
    [sym__list_marker_plus] = ACTIONS(1394),
    [sym__list_marker_star] = ACTIONS(1394),
    [sym__list_marker_parenthesis] = ACTIONS(1394),
    [sym__list_marker_dot] = ACTIONS(1394),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1394),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1394),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1394),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1394),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1394),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1394),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1394),
    [sym__blank_line_start] = ACTIONS(1394),
    [sym__html_block_1_start] = ACTIONS(1394),
    [sym__html_block_2_start] = ACTIONS(1394),
    [sym__html_block_3_start] = ACTIONS(1394),
    [sym__html_block_4_start] = ACTIONS(1394),
    [sym__html_block_5_start] = ACTIONS(1394),
    [sym__html_block_6_start] = ACTIONS(1394),
    [sym__html_block_7_start] = ACTIONS(1394),
    [sym__pipe_table_start] = ACTIONS(1394),
  },
  [141] = {
    [ts_builtin_sym_end] = ACTIONS(1400),
    [anon_sym_LBRACK] = ACTIONS(1402),
    [anon_sym_RBRACK] = ACTIONS(1400),
    [anon_sym_LT] = ACTIONS(1400),
    [anon_sym_GT] = ACTIONS(1400),
    [anon_sym_BANG] = ACTIONS(1400),
    [anon_sym_DQUOTE] = ACTIONS(1400),
    [anon_sym_POUND] = ACTIONS(1400),
    [anon_sym_DOLLAR] = ACTIONS(1400),
    [anon_sym_PERCENT] = ACTIONS(1400),
    [anon_sym_AMP] = ACTIONS(1400),
    [anon_sym_SQUOTE] = ACTIONS(1400),
    [anon_sym_STAR] = ACTIONS(1400),
    [anon_sym_PLUS] = ACTIONS(1400),
    [anon_sym_COMMA] = ACTIONS(1400),
    [anon_sym_DASH] = ACTIONS(1400),
    [anon_sym_DOT] = ACTIONS(1400),
    [anon_sym_SLASH] = ACTIONS(1400),
    [anon_sym_COLON] = ACTIONS(1400),
    [anon_sym_SEMI] = ACTIONS(1400),
    [anon_sym_EQ] = ACTIONS(1400),
    [anon_sym_QMARK] = ACTIONS(1400),
    [anon_sym_AT] = ACTIONS(1400),
    [anon_sym_BSLASH] = ACTIONS(1400),
    [anon_sym_CARET] = ACTIONS(1400),
    [anon_sym__] = ACTIONS(1400),
    [anon_sym_BQUOTE] = ACTIONS(1400),
    [anon_sym_LBRACE] = ACTIONS(1400),
    [anon_sym_PIPE] = ACTIONS(1400),
    [anon_sym_RBRACE] = ACTIONS(1400),
    [anon_sym_TILDE] = ACTIONS(1400),
    [anon_sym_LPAREN] = ACTIONS(1400),
    [anon_sym_RPAREN] = ACTIONS(1400),
    [aux_sym__word_token1] = ACTIONS(1400),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1400),
    [aux_sym__word_token2] = ACTIONS(1400),
    [sym__whitespace] = ACTIONS(1400),
    [sym__soft_line_ending] = ACTIONS(1400),
    [sym_block_continuation] = ACTIONS(1404),
    [sym__block_quote_start] = ACTIONS(1400),
    [sym__indented_chunk_start] = ACTIONS(1400),
    [sym_atx_h1_marker] = ACTIONS(1400),
    [sym_atx_h2_marker] = ACTIONS(1400),
    [sym_atx_h3_marker] = ACTIONS(1400),
    [sym_atx_h4_marker] = ACTIONS(1400),
    [sym_atx_h5_marker] = ACTIONS(1400),
    [sym_atx_h6_marker] = ACTIONS(1400),
    [sym__thematic_break] = ACTIONS(1400),
    [sym__list_marker_minus] = ACTIONS(1400),
    [sym__list_marker_plus] = ACTIONS(1400),
    [sym__list_marker_star] = ACTIONS(1400),
    [sym__list_marker_parenthesis] = ACTIONS(1400),
    [sym__list_marker_dot] = ACTIONS(1400),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1400),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1400),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1400),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1400),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1400),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1400),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1400),
    [sym__blank_line_start] = ACTIONS(1400),
    [sym__html_block_1_start] = ACTIONS(1400),
    [sym__html_block_2_start] = ACTIONS(1400),
    [sym__html_block_3_start] = ACTIONS(1400),
    [sym__html_block_4_start] = ACTIONS(1400),
    [sym__html_block_5_start] = ACTIONS(1400),
    [sym__html_block_6_start] = ACTIONS(1400),
    [sym__html_block_7_start] = ACTIONS(1400),
    [sym__pipe_table_start] = ACTIONS(1400),
  },
  [142] = {
    [anon_sym_LBRACK] = ACTIONS(1406),
    [anon_sym_RBRACK] = ACTIONS(1408),
    [anon_sym_LT] = ACTIONS(1408),
    [anon_sym_GT] = ACTIONS(1408),
    [anon_sym_BANG] = ACTIONS(1408),
    [anon_sym_DQUOTE] = ACTIONS(1408),
    [anon_sym_POUND] = ACTIONS(1408),
    [anon_sym_DOLLAR] = ACTIONS(1408),
    [anon_sym_PERCENT] = ACTIONS(1408),
    [anon_sym_AMP] = ACTIONS(1408),
    [anon_sym_SQUOTE] = ACTIONS(1408),
    [anon_sym_STAR] = ACTIONS(1408),
    [anon_sym_PLUS] = ACTIONS(1408),
    [anon_sym_COMMA] = ACTIONS(1408),
    [anon_sym_DASH] = ACTIONS(1408),
    [anon_sym_DOT] = ACTIONS(1408),
    [anon_sym_SLASH] = ACTIONS(1408),
    [anon_sym_COLON] = ACTIONS(1408),
    [anon_sym_SEMI] = ACTIONS(1408),
    [anon_sym_EQ] = ACTIONS(1408),
    [anon_sym_QMARK] = ACTIONS(1408),
    [anon_sym_AT] = ACTIONS(1408),
    [anon_sym_BSLASH] = ACTIONS(1408),
    [anon_sym_CARET] = ACTIONS(1408),
    [anon_sym__] = ACTIONS(1408),
    [anon_sym_BQUOTE] = ACTIONS(1408),
    [anon_sym_LBRACE] = ACTIONS(1408),
    [anon_sym_PIPE] = ACTIONS(1408),
    [anon_sym_RBRACE] = ACTIONS(1408),
    [anon_sym_TILDE] = ACTIONS(1408),
    [anon_sym_LPAREN] = ACTIONS(1408),
    [anon_sym_RPAREN] = ACTIONS(1408),
    [aux_sym__word_token1] = ACTIONS(1408),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1408),
    [aux_sym__word_token2] = ACTIONS(1408),
    [sym__whitespace] = ACTIONS(1408),
    [sym__soft_line_ending] = ACTIONS(1408),
    [sym__block_close] = ACTIONS(1408),
    [sym_block_continuation] = ACTIONS(1410),
    [sym__block_quote_start] = ACTIONS(1408),
    [sym__indented_chunk_start] = ACTIONS(1408),
    [sym_atx_h1_marker] = ACTIONS(1408),
    [sym_atx_h2_marker] = ACTIONS(1408),
    [sym_atx_h3_marker] = ACTIONS(1408),
    [sym_atx_h4_marker] = ACTIONS(1408),
    [sym_atx_h5_marker] = ACTIONS(1408),
    [sym_atx_h6_marker] = ACTIONS(1408),
    [sym__thematic_break] = ACTIONS(1408),
    [sym__list_marker_minus] = ACTIONS(1408),
    [sym__list_marker_plus] = ACTIONS(1408),
    [sym__list_marker_star] = ACTIONS(1408),
    [sym__list_marker_parenthesis] = ACTIONS(1408),
    [sym__list_marker_dot] = ACTIONS(1408),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1408),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1408),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1408),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1408),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1408),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1408),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1408),
    [sym__blank_line_start] = ACTIONS(1408),
    [sym__html_block_1_start] = ACTIONS(1408),
    [sym__html_block_2_start] = ACTIONS(1408),
    [sym__html_block_3_start] = ACTIONS(1408),
    [sym__html_block_4_start] = ACTIONS(1408),
    [sym__html_block_5_start] = ACTIONS(1408),
    [sym__html_block_6_start] = ACTIONS(1408),
    [sym__html_block_7_start] = ACTIONS(1408),
    [sym__pipe_table_start] = ACTIONS(1408),
  },
  [143] = {
    [ts_builtin_sym_end] = ACTIONS(1412),
    [anon_sym_LBRACK] = ACTIONS(1414),
    [anon_sym_RBRACK] = ACTIONS(1412),
    [anon_sym_LT] = ACTIONS(1412),
    [anon_sym_GT] = ACTIONS(1412),
    [anon_sym_BANG] = ACTIONS(1412),
    [anon_sym_DQUOTE] = ACTIONS(1412),
    [anon_sym_POUND] = ACTIONS(1412),
    [anon_sym_DOLLAR] = ACTIONS(1412),
    [anon_sym_PERCENT] = ACTIONS(1412),
    [anon_sym_AMP] = ACTIONS(1412),
    [anon_sym_SQUOTE] = ACTIONS(1412),
    [anon_sym_STAR] = ACTIONS(1412),
    [anon_sym_PLUS] = ACTIONS(1412),
    [anon_sym_COMMA] = ACTIONS(1412),
    [anon_sym_DASH] = ACTIONS(1412),
    [anon_sym_DOT] = ACTIONS(1412),
    [anon_sym_SLASH] = ACTIONS(1412),
    [anon_sym_COLON] = ACTIONS(1412),
    [anon_sym_SEMI] = ACTIONS(1412),
    [anon_sym_EQ] = ACTIONS(1412),
    [anon_sym_QMARK] = ACTIONS(1412),
    [anon_sym_AT] = ACTIONS(1412),
    [anon_sym_BSLASH] = ACTIONS(1412),
    [anon_sym_CARET] = ACTIONS(1412),
    [anon_sym__] = ACTIONS(1412),
    [anon_sym_BQUOTE] = ACTIONS(1412),
    [anon_sym_LBRACE] = ACTIONS(1412),
    [anon_sym_PIPE] = ACTIONS(1412),
    [anon_sym_RBRACE] = ACTIONS(1412),
    [anon_sym_TILDE] = ACTIONS(1412),
    [anon_sym_LPAREN] = ACTIONS(1412),
    [anon_sym_RPAREN] = ACTIONS(1412),
    [aux_sym__word_token1] = ACTIONS(1412),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1412),
    [aux_sym__word_token2] = ACTIONS(1412),
    [sym__whitespace] = ACTIONS(1412),
    [sym__soft_line_ending] = ACTIONS(1412),
    [sym_block_continuation] = ACTIONS(1416),
    [sym__block_quote_start] = ACTIONS(1412),
    [sym__indented_chunk_start] = ACTIONS(1412),
    [sym_atx_h1_marker] = ACTIONS(1412),
    [sym_atx_h2_marker] = ACTIONS(1412),
    [sym_atx_h3_marker] = ACTIONS(1412),
    [sym_atx_h4_marker] = ACTIONS(1412),
    [sym_atx_h5_marker] = ACTIONS(1412),
    [sym_atx_h6_marker] = ACTIONS(1412),
    [sym__thematic_break] = ACTIONS(1412),
    [sym__list_marker_minus] = ACTIONS(1412),
    [sym__list_marker_plus] = ACTIONS(1412),
    [sym__list_marker_star] = ACTIONS(1412),
    [sym__list_marker_parenthesis] = ACTIONS(1412),
    [sym__list_marker_dot] = ACTIONS(1412),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1412),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1412),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1412),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1412),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1412),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1412),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1412),
    [sym__blank_line_start] = ACTIONS(1412),
    [sym__html_block_1_start] = ACTIONS(1412),
    [sym__html_block_2_start] = ACTIONS(1412),
    [sym__html_block_3_start] = ACTIONS(1412),
    [sym__html_block_4_start] = ACTIONS(1412),
    [sym__html_block_5_start] = ACTIONS(1412),
    [sym__html_block_6_start] = ACTIONS(1412),
    [sym__html_block_7_start] = ACTIONS(1412),
    [sym__pipe_table_start] = ACTIONS(1412),
  },
  [144] = {
    [ts_builtin_sym_end] = ACTIONS(1418),
    [anon_sym_LBRACK] = ACTIONS(1420),
    [anon_sym_RBRACK] = ACTIONS(1418),
    [anon_sym_LT] = ACTIONS(1418),
    [anon_sym_GT] = ACTIONS(1418),
    [anon_sym_BANG] = ACTIONS(1418),
    [anon_sym_DQUOTE] = ACTIONS(1418),
    [anon_sym_POUND] = ACTIONS(1418),
    [anon_sym_DOLLAR] = ACTIONS(1418),
    [anon_sym_PERCENT] = ACTIONS(1418),
    [anon_sym_AMP] = ACTIONS(1418),
    [anon_sym_SQUOTE] = ACTIONS(1418),
    [anon_sym_STAR] = ACTIONS(1418),
    [anon_sym_PLUS] = ACTIONS(1418),
    [anon_sym_COMMA] = ACTIONS(1418),
    [anon_sym_DASH] = ACTIONS(1418),
    [anon_sym_DOT] = ACTIONS(1418),
    [anon_sym_SLASH] = ACTIONS(1418),
    [anon_sym_COLON] = ACTIONS(1418),
    [anon_sym_SEMI] = ACTIONS(1418),
    [anon_sym_EQ] = ACTIONS(1418),
    [anon_sym_QMARK] = ACTIONS(1418),
    [anon_sym_AT] = ACTIONS(1418),
    [anon_sym_BSLASH] = ACTIONS(1418),
    [anon_sym_CARET] = ACTIONS(1418),
    [anon_sym__] = ACTIONS(1418),
    [anon_sym_BQUOTE] = ACTIONS(1418),
    [anon_sym_LBRACE] = ACTIONS(1418),
    [anon_sym_PIPE] = ACTIONS(1418),
    [anon_sym_RBRACE] = ACTIONS(1418),
    [anon_sym_TILDE] = ACTIONS(1418),
    [anon_sym_LPAREN] = ACTIONS(1418),
    [anon_sym_RPAREN] = ACTIONS(1418),
    [aux_sym__word_token1] = ACTIONS(1418),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1418),
    [aux_sym__word_token2] = ACTIONS(1418),
    [sym__whitespace] = ACTIONS(1418),
    [sym__soft_line_ending] = ACTIONS(1418),
    [sym_block_continuation] = ACTIONS(1422),
    [sym__block_quote_start] = ACTIONS(1418),
    [sym__indented_chunk_start] = ACTIONS(1418),
    [sym_atx_h1_marker] = ACTIONS(1418),
    [sym_atx_h2_marker] = ACTIONS(1418),
    [sym_atx_h3_marker] = ACTIONS(1418),
    [sym_atx_h4_marker] = ACTIONS(1418),
    [sym_atx_h5_marker] = ACTIONS(1418),
    [sym_atx_h6_marker] = ACTIONS(1418),
    [sym__thematic_break] = ACTIONS(1418),
    [sym__list_marker_minus] = ACTIONS(1418),
    [sym__list_marker_plus] = ACTIONS(1418),
    [sym__list_marker_star] = ACTIONS(1418),
    [sym__list_marker_parenthesis] = ACTIONS(1418),
    [sym__list_marker_dot] = ACTIONS(1418),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1418),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1418),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1418),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1418),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1418),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1418),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1418),
    [sym__blank_line_start] = ACTIONS(1418),
    [sym__html_block_1_start] = ACTIONS(1418),
    [sym__html_block_2_start] = ACTIONS(1418),
    [sym__html_block_3_start] = ACTIONS(1418),
    [sym__html_block_4_start] = ACTIONS(1418),
    [sym__html_block_5_start] = ACTIONS(1418),
    [sym__html_block_6_start] = ACTIONS(1418),
    [sym__html_block_7_start] = ACTIONS(1418),
    [sym__pipe_table_start] = ACTIONS(1418),
  },
  [145] = {
    [sym__blank_line] = STATE(879),
    [anon_sym_LBRACK] = ACTIONS(1259),
    [anon_sym_RBRACK] = ACTIONS(1257),
    [anon_sym_LT] = ACTIONS(1257),
    [anon_sym_GT] = ACTIONS(1257),
    [anon_sym_BANG] = ACTIONS(1257),
    [anon_sym_DQUOTE] = ACTIONS(1257),
    [anon_sym_POUND] = ACTIONS(1257),
    [anon_sym_DOLLAR] = ACTIONS(1257),
    [anon_sym_PERCENT] = ACTIONS(1257),
    [anon_sym_AMP] = ACTIONS(1257),
    [anon_sym_SQUOTE] = ACTIONS(1257),
    [anon_sym_STAR] = ACTIONS(1257),
    [anon_sym_PLUS] = ACTIONS(1257),
    [anon_sym_COMMA] = ACTIONS(1257),
    [anon_sym_DASH] = ACTIONS(1257),
    [anon_sym_DOT] = ACTIONS(1257),
    [anon_sym_SLASH] = ACTIONS(1257),
    [anon_sym_COLON] = ACTIONS(1257),
    [anon_sym_SEMI] = ACTIONS(1257),
    [anon_sym_EQ] = ACTIONS(1257),
    [anon_sym_QMARK] = ACTIONS(1257),
    [anon_sym_AT] = ACTIONS(1257),
    [anon_sym_BSLASH] = ACTIONS(1257),
    [anon_sym_CARET] = ACTIONS(1257),
    [anon_sym__] = ACTIONS(1257),
    [anon_sym_BQUOTE] = ACTIONS(1257),
    [anon_sym_LBRACE] = ACTIONS(1257),
    [anon_sym_PIPE] = ACTIONS(1257),
    [anon_sym_RBRACE] = ACTIONS(1257),
    [anon_sym_TILDE] = ACTIONS(1257),
    [anon_sym_LPAREN] = ACTIONS(1257),
    [anon_sym_RPAREN] = ACTIONS(1257),
    [aux_sym__word_token1] = ACTIONS(1257),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1257),
    [aux_sym__word_token2] = ACTIONS(1257),
    [sym__whitespace] = ACTIONS(1257),
    [sym__soft_line_ending] = ACTIONS(1257),
    [sym__block_close] = ACTIONS(1257),
    [sym__block_quote_start] = ACTIONS(1257),
    [sym__indented_chunk_start] = ACTIONS(1257),
    [sym_atx_h1_marker] = ACTIONS(1257),
    [sym_atx_h2_marker] = ACTIONS(1257),
    [sym_atx_h3_marker] = ACTIONS(1257),
    [sym_atx_h4_marker] = ACTIONS(1257),
    [sym_atx_h5_marker] = ACTIONS(1257),
    [sym_atx_h6_marker] = ACTIONS(1257),
    [sym__thematic_break] = ACTIONS(1257),
    [sym__list_marker_minus] = ACTIONS(1257),
    [sym__list_marker_plus] = ACTIONS(1257),
    [sym__list_marker_star] = ACTIONS(1257),
    [sym__list_marker_parenthesis] = ACTIONS(1257),
    [sym__list_marker_dot] = ACTIONS(1257),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1257),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1257),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1257),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1257),
    [sym__blank_line_start] = ACTIONS(1424),
    [sym__html_block_1_start] = ACTIONS(1257),
    [sym__html_block_2_start] = ACTIONS(1257),
    [sym__html_block_3_start] = ACTIONS(1257),
    [sym__html_block_4_start] = ACTIONS(1257),
    [sym__html_block_5_start] = ACTIONS(1257),
    [sym__html_block_6_start] = ACTIONS(1257),
    [sym__html_block_7_start] = ACTIONS(1257),
    [sym__pipe_table_start] = ACTIONS(1257),
  },
  [146] = {
    [anon_sym_LBRACK] = ACTIONS(1426),
    [anon_sym_RBRACK] = ACTIONS(1428),
    [anon_sym_LT] = ACTIONS(1428),
    [anon_sym_GT] = ACTIONS(1428),
    [anon_sym_BANG] = ACTIONS(1428),
    [anon_sym_DQUOTE] = ACTIONS(1428),
    [anon_sym_POUND] = ACTIONS(1428),
    [anon_sym_DOLLAR] = ACTIONS(1428),
    [anon_sym_PERCENT] = ACTIONS(1428),
    [anon_sym_AMP] = ACTIONS(1428),
    [anon_sym_SQUOTE] = ACTIONS(1428),
    [anon_sym_STAR] = ACTIONS(1428),
    [anon_sym_PLUS] = ACTIONS(1428),
    [anon_sym_COMMA] = ACTIONS(1428),
    [anon_sym_DASH] = ACTIONS(1428),
    [anon_sym_DOT] = ACTIONS(1428),
    [anon_sym_SLASH] = ACTIONS(1428),
    [anon_sym_COLON] = ACTIONS(1428),
    [anon_sym_SEMI] = ACTIONS(1428),
    [anon_sym_EQ] = ACTIONS(1428),
    [anon_sym_QMARK] = ACTIONS(1428),
    [anon_sym_AT] = ACTIONS(1428),
    [anon_sym_BSLASH] = ACTIONS(1428),
    [anon_sym_CARET] = ACTIONS(1428),
    [anon_sym__] = ACTIONS(1428),
    [anon_sym_BQUOTE] = ACTIONS(1428),
    [anon_sym_LBRACE] = ACTIONS(1428),
    [anon_sym_PIPE] = ACTIONS(1428),
    [anon_sym_RBRACE] = ACTIONS(1428),
    [anon_sym_TILDE] = ACTIONS(1428),
    [anon_sym_LPAREN] = ACTIONS(1428),
    [anon_sym_RPAREN] = ACTIONS(1428),
    [aux_sym__word_token1] = ACTIONS(1428),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1428),
    [aux_sym__word_token2] = ACTIONS(1428),
    [sym__whitespace] = ACTIONS(1428),
    [sym__soft_line_ending] = ACTIONS(1428),
    [sym__block_close] = ACTIONS(1428),
    [sym_block_continuation] = ACTIONS(1430),
    [sym__block_quote_start] = ACTIONS(1428),
    [sym__indented_chunk_start] = ACTIONS(1428),
    [sym_atx_h1_marker] = ACTIONS(1428),
    [sym_atx_h2_marker] = ACTIONS(1428),
    [sym_atx_h3_marker] = ACTIONS(1428),
    [sym_atx_h4_marker] = ACTIONS(1428),
    [sym_atx_h5_marker] = ACTIONS(1428),
    [sym_atx_h6_marker] = ACTIONS(1428),
    [sym__thematic_break] = ACTIONS(1428),
    [sym__list_marker_minus] = ACTIONS(1428),
    [sym__list_marker_plus] = ACTIONS(1428),
    [sym__list_marker_star] = ACTIONS(1428),
    [sym__list_marker_parenthesis] = ACTIONS(1428),
    [sym__list_marker_dot] = ACTIONS(1428),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1428),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1428),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1428),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1428),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1428),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1428),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1428),
    [sym__blank_line_start] = ACTIONS(1428),
    [sym__html_block_1_start] = ACTIONS(1428),
    [sym__html_block_2_start] = ACTIONS(1428),
    [sym__html_block_3_start] = ACTIONS(1428),
    [sym__html_block_4_start] = ACTIONS(1428),
    [sym__html_block_5_start] = ACTIONS(1428),
    [sym__html_block_6_start] = ACTIONS(1428),
    [sym__html_block_7_start] = ACTIONS(1428),
    [sym__pipe_table_start] = ACTIONS(1428),
  },
  [147] = {
    [anon_sym_LBRACK] = ACTIONS(1432),
    [anon_sym_RBRACK] = ACTIONS(1434),
    [anon_sym_LT] = ACTIONS(1434),
    [anon_sym_GT] = ACTIONS(1434),
    [anon_sym_BANG] = ACTIONS(1434),
    [anon_sym_DQUOTE] = ACTIONS(1434),
    [anon_sym_POUND] = ACTIONS(1434),
    [anon_sym_DOLLAR] = ACTIONS(1434),
    [anon_sym_PERCENT] = ACTIONS(1434),
    [anon_sym_AMP] = ACTIONS(1434),
    [anon_sym_SQUOTE] = ACTIONS(1434),
    [anon_sym_STAR] = ACTIONS(1434),
    [anon_sym_PLUS] = ACTIONS(1434),
    [anon_sym_COMMA] = ACTIONS(1434),
    [anon_sym_DASH] = ACTIONS(1434),
    [anon_sym_DOT] = ACTIONS(1434),
    [anon_sym_SLASH] = ACTIONS(1434),
    [anon_sym_COLON] = ACTIONS(1434),
    [anon_sym_SEMI] = ACTIONS(1434),
    [anon_sym_EQ] = ACTIONS(1434),
    [anon_sym_QMARK] = ACTIONS(1434),
    [anon_sym_AT] = ACTIONS(1434),
    [anon_sym_BSLASH] = ACTIONS(1434),
    [anon_sym_CARET] = ACTIONS(1434),
    [anon_sym__] = ACTIONS(1434),
    [anon_sym_BQUOTE] = ACTIONS(1434),
    [anon_sym_LBRACE] = ACTIONS(1434),
    [anon_sym_PIPE] = ACTIONS(1434),
    [anon_sym_RBRACE] = ACTIONS(1434),
    [anon_sym_TILDE] = ACTIONS(1434),
    [anon_sym_LPAREN] = ACTIONS(1434),
    [anon_sym_RPAREN] = ACTIONS(1434),
    [aux_sym__word_token1] = ACTIONS(1434),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1434),
    [aux_sym__word_token2] = ACTIONS(1434),
    [sym__whitespace] = ACTIONS(1434),
    [sym__soft_line_ending] = ACTIONS(1434),
    [sym__block_close] = ACTIONS(1434),
    [sym_block_continuation] = ACTIONS(1436),
    [sym__block_quote_start] = ACTIONS(1434),
    [sym__indented_chunk_start] = ACTIONS(1434),
    [sym_atx_h1_marker] = ACTIONS(1434),
    [sym_atx_h2_marker] = ACTIONS(1434),
    [sym_atx_h3_marker] = ACTIONS(1434),
    [sym_atx_h4_marker] = ACTIONS(1434),
    [sym_atx_h5_marker] = ACTIONS(1434),
    [sym_atx_h6_marker] = ACTIONS(1434),
    [sym__thematic_break] = ACTIONS(1434),
    [sym__list_marker_minus] = ACTIONS(1434),
    [sym__list_marker_plus] = ACTIONS(1434),
    [sym__list_marker_star] = ACTIONS(1434),
    [sym__list_marker_parenthesis] = ACTIONS(1434),
    [sym__list_marker_dot] = ACTIONS(1434),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1434),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1434),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1434),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1434),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1434),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1434),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1434),
    [sym__blank_line_start] = ACTIONS(1434),
    [sym__html_block_1_start] = ACTIONS(1434),
    [sym__html_block_2_start] = ACTIONS(1434),
    [sym__html_block_3_start] = ACTIONS(1434),
    [sym__html_block_4_start] = ACTIONS(1434),
    [sym__html_block_5_start] = ACTIONS(1434),
    [sym__html_block_6_start] = ACTIONS(1434),
    [sym__html_block_7_start] = ACTIONS(1434),
    [sym__pipe_table_start] = ACTIONS(1434),
  },
  [148] = {
    [anon_sym_LBRACK] = ACTIONS(1438),
    [anon_sym_RBRACK] = ACTIONS(1440),
    [anon_sym_LT] = ACTIONS(1440),
    [anon_sym_GT] = ACTIONS(1440),
    [anon_sym_BANG] = ACTIONS(1440),
    [anon_sym_DQUOTE] = ACTIONS(1440),
    [anon_sym_POUND] = ACTIONS(1440),
    [anon_sym_DOLLAR] = ACTIONS(1440),
    [anon_sym_PERCENT] = ACTIONS(1440),
    [anon_sym_AMP] = ACTIONS(1440),
    [anon_sym_SQUOTE] = ACTIONS(1440),
    [anon_sym_STAR] = ACTIONS(1440),
    [anon_sym_PLUS] = ACTIONS(1440),
    [anon_sym_COMMA] = ACTIONS(1440),
    [anon_sym_DASH] = ACTIONS(1440),
    [anon_sym_DOT] = ACTIONS(1440),
    [anon_sym_SLASH] = ACTIONS(1440),
    [anon_sym_COLON] = ACTIONS(1440),
    [anon_sym_SEMI] = ACTIONS(1440),
    [anon_sym_EQ] = ACTIONS(1440),
    [anon_sym_QMARK] = ACTIONS(1440),
    [anon_sym_AT] = ACTIONS(1440),
    [anon_sym_BSLASH] = ACTIONS(1440),
    [anon_sym_CARET] = ACTIONS(1440),
    [anon_sym__] = ACTIONS(1440),
    [anon_sym_BQUOTE] = ACTIONS(1440),
    [anon_sym_LBRACE] = ACTIONS(1440),
    [anon_sym_PIPE] = ACTIONS(1440),
    [anon_sym_RBRACE] = ACTIONS(1440),
    [anon_sym_TILDE] = ACTIONS(1440),
    [anon_sym_LPAREN] = ACTIONS(1440),
    [anon_sym_RPAREN] = ACTIONS(1440),
    [aux_sym__word_token1] = ACTIONS(1440),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1440),
    [aux_sym__word_token2] = ACTIONS(1440),
    [sym__whitespace] = ACTIONS(1440),
    [sym__soft_line_ending] = ACTIONS(1440),
    [sym__block_close] = ACTIONS(1440),
    [sym_block_continuation] = ACTIONS(1442),
    [sym__block_quote_start] = ACTIONS(1440),
    [sym__indented_chunk_start] = ACTIONS(1440),
    [sym_atx_h1_marker] = ACTIONS(1440),
    [sym_atx_h2_marker] = ACTIONS(1440),
    [sym_atx_h3_marker] = ACTIONS(1440),
    [sym_atx_h4_marker] = ACTIONS(1440),
    [sym_atx_h5_marker] = ACTIONS(1440),
    [sym_atx_h6_marker] = ACTIONS(1440),
    [sym__thematic_break] = ACTIONS(1440),
    [sym__list_marker_minus] = ACTIONS(1440),
    [sym__list_marker_plus] = ACTIONS(1440),
    [sym__list_marker_star] = ACTIONS(1440),
    [sym__list_marker_parenthesis] = ACTIONS(1440),
    [sym__list_marker_dot] = ACTIONS(1440),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1440),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1440),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1440),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1440),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1440),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1440),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1440),
    [sym__blank_line_start] = ACTIONS(1440),
    [sym__html_block_1_start] = ACTIONS(1440),
    [sym__html_block_2_start] = ACTIONS(1440),
    [sym__html_block_3_start] = ACTIONS(1440),
    [sym__html_block_4_start] = ACTIONS(1440),
    [sym__html_block_5_start] = ACTIONS(1440),
    [sym__html_block_6_start] = ACTIONS(1440),
    [sym__html_block_7_start] = ACTIONS(1440),
    [sym__pipe_table_start] = ACTIONS(1440),
  },
  [149] = {
    [anon_sym_LBRACK] = ACTIONS(1420),
    [anon_sym_RBRACK] = ACTIONS(1418),
    [anon_sym_LT] = ACTIONS(1418),
    [anon_sym_GT] = ACTIONS(1418),
    [anon_sym_BANG] = ACTIONS(1418),
    [anon_sym_DQUOTE] = ACTIONS(1418),
    [anon_sym_POUND] = ACTIONS(1418),
    [anon_sym_DOLLAR] = ACTIONS(1418),
    [anon_sym_PERCENT] = ACTIONS(1418),
    [anon_sym_AMP] = ACTIONS(1418),
    [anon_sym_SQUOTE] = ACTIONS(1418),
    [anon_sym_STAR] = ACTIONS(1418),
    [anon_sym_PLUS] = ACTIONS(1418),
    [anon_sym_COMMA] = ACTIONS(1418),
    [anon_sym_DASH] = ACTIONS(1418),
    [anon_sym_DOT] = ACTIONS(1418),
    [anon_sym_SLASH] = ACTIONS(1418),
    [anon_sym_COLON] = ACTIONS(1418),
    [anon_sym_SEMI] = ACTIONS(1418),
    [anon_sym_EQ] = ACTIONS(1418),
    [anon_sym_QMARK] = ACTIONS(1418),
    [anon_sym_AT] = ACTIONS(1418),
    [anon_sym_BSLASH] = ACTIONS(1418),
    [anon_sym_CARET] = ACTIONS(1418),
    [anon_sym__] = ACTIONS(1418),
    [anon_sym_BQUOTE] = ACTIONS(1418),
    [anon_sym_LBRACE] = ACTIONS(1418),
    [anon_sym_PIPE] = ACTIONS(1418),
    [anon_sym_RBRACE] = ACTIONS(1418),
    [anon_sym_TILDE] = ACTIONS(1418),
    [anon_sym_LPAREN] = ACTIONS(1418),
    [anon_sym_RPAREN] = ACTIONS(1418),
    [aux_sym__word_token1] = ACTIONS(1418),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1418),
    [aux_sym__word_token2] = ACTIONS(1418),
    [sym__whitespace] = ACTIONS(1418),
    [sym__soft_line_ending] = ACTIONS(1418),
    [sym__block_close] = ACTIONS(1418),
    [sym_block_continuation] = ACTIONS(1444),
    [sym__block_quote_start] = ACTIONS(1418),
    [sym__indented_chunk_start] = ACTIONS(1418),
    [sym_atx_h1_marker] = ACTIONS(1418),
    [sym_atx_h2_marker] = ACTIONS(1418),
    [sym_atx_h3_marker] = ACTIONS(1418),
    [sym_atx_h4_marker] = ACTIONS(1418),
    [sym_atx_h5_marker] = ACTIONS(1418),
    [sym_atx_h6_marker] = ACTIONS(1418),
    [sym__thematic_break] = ACTIONS(1418),
    [sym__list_marker_minus] = ACTIONS(1418),
    [sym__list_marker_plus] = ACTIONS(1418),
    [sym__list_marker_star] = ACTIONS(1418),
    [sym__list_marker_parenthesis] = ACTIONS(1418),
    [sym__list_marker_dot] = ACTIONS(1418),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1418),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1418),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1418),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1418),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1418),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1418),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1418),
    [sym__blank_line_start] = ACTIONS(1418),
    [sym__html_block_1_start] = ACTIONS(1418),
    [sym__html_block_2_start] = ACTIONS(1418),
    [sym__html_block_3_start] = ACTIONS(1418),
    [sym__html_block_4_start] = ACTIONS(1418),
    [sym__html_block_5_start] = ACTIONS(1418),
    [sym__html_block_6_start] = ACTIONS(1418),
    [sym__html_block_7_start] = ACTIONS(1418),
    [sym__pipe_table_start] = ACTIONS(1418),
  },
  [150] = {
    [anon_sym_LBRACK] = ACTIONS(1446),
    [anon_sym_RBRACK] = ACTIONS(1448),
    [anon_sym_LT] = ACTIONS(1448),
    [anon_sym_GT] = ACTIONS(1448),
    [anon_sym_BANG] = ACTIONS(1448),
    [anon_sym_DQUOTE] = ACTIONS(1448),
    [anon_sym_POUND] = ACTIONS(1448),
    [anon_sym_DOLLAR] = ACTIONS(1448),
    [anon_sym_PERCENT] = ACTIONS(1448),
    [anon_sym_AMP] = ACTIONS(1448),
    [anon_sym_SQUOTE] = ACTIONS(1448),
    [anon_sym_STAR] = ACTIONS(1448),
    [anon_sym_PLUS] = ACTIONS(1448),
    [anon_sym_COMMA] = ACTIONS(1448),
    [anon_sym_DASH] = ACTIONS(1448),
    [anon_sym_DOT] = ACTIONS(1448),
    [anon_sym_SLASH] = ACTIONS(1448),
    [anon_sym_COLON] = ACTIONS(1448),
    [anon_sym_SEMI] = ACTIONS(1448),
    [anon_sym_EQ] = ACTIONS(1448),
    [anon_sym_QMARK] = ACTIONS(1448),
    [anon_sym_AT] = ACTIONS(1448),
    [anon_sym_BSLASH] = ACTIONS(1448),
    [anon_sym_CARET] = ACTIONS(1448),
    [anon_sym__] = ACTIONS(1448),
    [anon_sym_BQUOTE] = ACTIONS(1448),
    [anon_sym_LBRACE] = ACTIONS(1448),
    [anon_sym_PIPE] = ACTIONS(1448),
    [anon_sym_RBRACE] = ACTIONS(1448),
    [anon_sym_TILDE] = ACTIONS(1448),
    [anon_sym_LPAREN] = ACTIONS(1448),
    [anon_sym_RPAREN] = ACTIONS(1448),
    [aux_sym__word_token1] = ACTIONS(1448),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1448),
    [aux_sym__word_token2] = ACTIONS(1448),
    [sym__whitespace] = ACTIONS(1448),
    [sym__soft_line_ending] = ACTIONS(1448),
    [sym__block_close] = ACTIONS(1448),
    [sym_block_continuation] = ACTIONS(1450),
    [sym__block_quote_start] = ACTIONS(1448),
    [sym__indented_chunk_start] = ACTIONS(1448),
    [sym_atx_h1_marker] = ACTIONS(1448),
    [sym_atx_h2_marker] = ACTIONS(1448),
    [sym_atx_h3_marker] = ACTIONS(1448),
    [sym_atx_h4_marker] = ACTIONS(1448),
    [sym_atx_h5_marker] = ACTIONS(1448),
    [sym_atx_h6_marker] = ACTIONS(1448),
    [sym__thematic_break] = ACTIONS(1448),
    [sym__list_marker_minus] = ACTIONS(1448),
    [sym__list_marker_plus] = ACTIONS(1448),
    [sym__list_marker_star] = ACTIONS(1448),
    [sym__list_marker_parenthesis] = ACTIONS(1448),
    [sym__list_marker_dot] = ACTIONS(1448),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1448),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1448),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1448),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1448),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1448),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1448),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1448),
    [sym__blank_line_start] = ACTIONS(1448),
    [sym__html_block_1_start] = ACTIONS(1448),
    [sym__html_block_2_start] = ACTIONS(1448),
    [sym__html_block_3_start] = ACTIONS(1448),
    [sym__html_block_4_start] = ACTIONS(1448),
    [sym__html_block_5_start] = ACTIONS(1448),
    [sym__html_block_6_start] = ACTIONS(1448),
    [sym__html_block_7_start] = ACTIONS(1448),
    [sym__pipe_table_start] = ACTIONS(1448),
  },
  [151] = {
    [ts_builtin_sym_end] = ACTIONS(1452),
    [anon_sym_LBRACK] = ACTIONS(1454),
    [anon_sym_RBRACK] = ACTIONS(1452),
    [anon_sym_LT] = ACTIONS(1452),
    [anon_sym_GT] = ACTIONS(1452),
    [anon_sym_BANG] = ACTIONS(1452),
    [anon_sym_DQUOTE] = ACTIONS(1452),
    [anon_sym_POUND] = ACTIONS(1452),
    [anon_sym_DOLLAR] = ACTIONS(1452),
    [anon_sym_PERCENT] = ACTIONS(1452),
    [anon_sym_AMP] = ACTIONS(1452),
    [anon_sym_SQUOTE] = ACTIONS(1452),
    [anon_sym_STAR] = ACTIONS(1452),
    [anon_sym_PLUS] = ACTIONS(1452),
    [anon_sym_COMMA] = ACTIONS(1452),
    [anon_sym_DASH] = ACTIONS(1452),
    [anon_sym_DOT] = ACTIONS(1452),
    [anon_sym_SLASH] = ACTIONS(1452),
    [anon_sym_COLON] = ACTIONS(1452),
    [anon_sym_SEMI] = ACTIONS(1452),
    [anon_sym_EQ] = ACTIONS(1452),
    [anon_sym_QMARK] = ACTIONS(1452),
    [anon_sym_AT] = ACTIONS(1452),
    [anon_sym_BSLASH] = ACTIONS(1452),
    [anon_sym_CARET] = ACTIONS(1452),
    [anon_sym__] = ACTIONS(1452),
    [anon_sym_BQUOTE] = ACTIONS(1452),
    [anon_sym_LBRACE] = ACTIONS(1452),
    [anon_sym_PIPE] = ACTIONS(1452),
    [anon_sym_RBRACE] = ACTIONS(1452),
    [anon_sym_TILDE] = ACTIONS(1452),
    [anon_sym_LPAREN] = ACTIONS(1452),
    [anon_sym_RPAREN] = ACTIONS(1452),
    [aux_sym__word_token1] = ACTIONS(1452),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1452),
    [aux_sym__word_token2] = ACTIONS(1452),
    [sym__whitespace] = ACTIONS(1452),
    [sym__soft_line_ending] = ACTIONS(1452),
    [sym_block_continuation] = ACTIONS(1456),
    [sym__block_quote_start] = ACTIONS(1452),
    [sym__indented_chunk_start] = ACTIONS(1452),
    [sym_atx_h1_marker] = ACTIONS(1452),
    [sym_atx_h2_marker] = ACTIONS(1452),
    [sym_atx_h3_marker] = ACTIONS(1452),
    [sym_atx_h4_marker] = ACTIONS(1452),
    [sym_atx_h5_marker] = ACTIONS(1452),
    [sym_atx_h6_marker] = ACTIONS(1452),
    [sym__thematic_break] = ACTIONS(1452),
    [sym__list_marker_minus] = ACTIONS(1452),
    [sym__list_marker_plus] = ACTIONS(1452),
    [sym__list_marker_star] = ACTIONS(1452),
    [sym__list_marker_parenthesis] = ACTIONS(1452),
    [sym__list_marker_dot] = ACTIONS(1452),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1452),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1452),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1452),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1452),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1452),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1452),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1452),
    [sym__blank_line_start] = ACTIONS(1452),
    [sym__html_block_1_start] = ACTIONS(1452),
    [sym__html_block_2_start] = ACTIONS(1452),
    [sym__html_block_3_start] = ACTIONS(1452),
    [sym__html_block_4_start] = ACTIONS(1452),
    [sym__html_block_5_start] = ACTIONS(1452),
    [sym__html_block_6_start] = ACTIONS(1452),
    [sym__html_block_7_start] = ACTIONS(1452),
    [sym__pipe_table_start] = ACTIONS(1452),
  },
  [152] = {
    [ts_builtin_sym_end] = ACTIONS(1458),
    [anon_sym_LBRACK] = ACTIONS(1460),
    [anon_sym_RBRACK] = ACTIONS(1458),
    [anon_sym_LT] = ACTIONS(1458),
    [anon_sym_GT] = ACTIONS(1458),
    [anon_sym_BANG] = ACTIONS(1458),
    [anon_sym_DQUOTE] = ACTIONS(1458),
    [anon_sym_POUND] = ACTIONS(1458),
    [anon_sym_DOLLAR] = ACTIONS(1458),
    [anon_sym_PERCENT] = ACTIONS(1458),
    [anon_sym_AMP] = ACTIONS(1458),
    [anon_sym_SQUOTE] = ACTIONS(1458),
    [anon_sym_STAR] = ACTIONS(1458),
    [anon_sym_PLUS] = ACTIONS(1458),
    [anon_sym_COMMA] = ACTIONS(1458),
    [anon_sym_DASH] = ACTIONS(1458),
    [anon_sym_DOT] = ACTIONS(1458),
    [anon_sym_SLASH] = ACTIONS(1458),
    [anon_sym_COLON] = ACTIONS(1458),
    [anon_sym_SEMI] = ACTIONS(1458),
    [anon_sym_EQ] = ACTIONS(1458),
    [anon_sym_QMARK] = ACTIONS(1458),
    [anon_sym_AT] = ACTIONS(1458),
    [anon_sym_BSLASH] = ACTIONS(1458),
    [anon_sym_CARET] = ACTIONS(1458),
    [anon_sym__] = ACTIONS(1458),
    [anon_sym_BQUOTE] = ACTIONS(1458),
    [anon_sym_LBRACE] = ACTIONS(1458),
    [anon_sym_PIPE] = ACTIONS(1458),
    [anon_sym_RBRACE] = ACTIONS(1458),
    [anon_sym_TILDE] = ACTIONS(1458),
    [anon_sym_LPAREN] = ACTIONS(1458),
    [anon_sym_RPAREN] = ACTIONS(1458),
    [aux_sym__word_token1] = ACTIONS(1458),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1458),
    [aux_sym__word_token2] = ACTIONS(1458),
    [sym__whitespace] = ACTIONS(1458),
    [sym__soft_line_ending] = ACTIONS(1458),
    [sym_block_continuation] = ACTIONS(1462),
    [sym__block_quote_start] = ACTIONS(1458),
    [sym__indented_chunk_start] = ACTIONS(1458),
    [sym_atx_h1_marker] = ACTIONS(1458),
    [sym_atx_h2_marker] = ACTIONS(1458),
    [sym_atx_h3_marker] = ACTIONS(1458),
    [sym_atx_h4_marker] = ACTIONS(1458),
    [sym_atx_h5_marker] = ACTIONS(1458),
    [sym_atx_h6_marker] = ACTIONS(1458),
    [sym__thematic_break] = ACTIONS(1458),
    [sym__list_marker_minus] = ACTIONS(1458),
    [sym__list_marker_plus] = ACTIONS(1458),
    [sym__list_marker_star] = ACTIONS(1458),
    [sym__list_marker_parenthesis] = ACTIONS(1458),
    [sym__list_marker_dot] = ACTIONS(1458),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1458),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1458),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1458),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1458),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1458),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1458),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1458),
    [sym__blank_line_start] = ACTIONS(1458),
    [sym__html_block_1_start] = ACTIONS(1458),
    [sym__html_block_2_start] = ACTIONS(1458),
    [sym__html_block_3_start] = ACTIONS(1458),
    [sym__html_block_4_start] = ACTIONS(1458),
    [sym__html_block_5_start] = ACTIONS(1458),
    [sym__html_block_6_start] = ACTIONS(1458),
    [sym__html_block_7_start] = ACTIONS(1458),
    [sym__pipe_table_start] = ACTIONS(1458),
  },
  [153] = {
    [anon_sym_LBRACK] = ACTIONS(1414),
    [anon_sym_RBRACK] = ACTIONS(1412),
    [anon_sym_LT] = ACTIONS(1412),
    [anon_sym_GT] = ACTIONS(1412),
    [anon_sym_BANG] = ACTIONS(1412),
    [anon_sym_DQUOTE] = ACTIONS(1412),
    [anon_sym_POUND] = ACTIONS(1412),
    [anon_sym_DOLLAR] = ACTIONS(1412),
    [anon_sym_PERCENT] = ACTIONS(1412),
    [anon_sym_AMP] = ACTIONS(1412),
    [anon_sym_SQUOTE] = ACTIONS(1412),
    [anon_sym_STAR] = ACTIONS(1412),
    [anon_sym_PLUS] = ACTIONS(1412),
    [anon_sym_COMMA] = ACTIONS(1412),
    [anon_sym_DASH] = ACTIONS(1412),
    [anon_sym_DOT] = ACTIONS(1412),
    [anon_sym_SLASH] = ACTIONS(1412),
    [anon_sym_COLON] = ACTIONS(1412),
    [anon_sym_SEMI] = ACTIONS(1412),
    [anon_sym_EQ] = ACTIONS(1412),
    [anon_sym_QMARK] = ACTIONS(1412),
    [anon_sym_AT] = ACTIONS(1412),
    [anon_sym_BSLASH] = ACTIONS(1412),
    [anon_sym_CARET] = ACTIONS(1412),
    [anon_sym__] = ACTIONS(1412),
    [anon_sym_BQUOTE] = ACTIONS(1412),
    [anon_sym_LBRACE] = ACTIONS(1412),
    [anon_sym_PIPE] = ACTIONS(1412),
    [anon_sym_RBRACE] = ACTIONS(1412),
    [anon_sym_TILDE] = ACTIONS(1412),
    [anon_sym_LPAREN] = ACTIONS(1412),
    [anon_sym_RPAREN] = ACTIONS(1412),
    [aux_sym__word_token1] = ACTIONS(1412),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1412),
    [aux_sym__word_token2] = ACTIONS(1412),
    [sym__whitespace] = ACTIONS(1412),
    [sym__soft_line_ending] = ACTIONS(1412),
    [sym__block_close] = ACTIONS(1412),
    [sym_block_continuation] = ACTIONS(1464),
    [sym__block_quote_start] = ACTIONS(1412),
    [sym__indented_chunk_start] = ACTIONS(1412),
    [sym_atx_h1_marker] = ACTIONS(1412),
    [sym_atx_h2_marker] = ACTIONS(1412),
    [sym_atx_h3_marker] = ACTIONS(1412),
    [sym_atx_h4_marker] = ACTIONS(1412),
    [sym_atx_h5_marker] = ACTIONS(1412),
    [sym_atx_h6_marker] = ACTIONS(1412),
    [sym__thematic_break] = ACTIONS(1412),
    [sym__list_marker_minus] = ACTIONS(1412),
    [sym__list_marker_plus] = ACTIONS(1412),
    [sym__list_marker_star] = ACTIONS(1412),
    [sym__list_marker_parenthesis] = ACTIONS(1412),
    [sym__list_marker_dot] = ACTIONS(1412),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1412),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1412),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1412),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1412),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1412),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1412),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1412),
    [sym__blank_line_start] = ACTIONS(1412),
    [sym__html_block_1_start] = ACTIONS(1412),
    [sym__html_block_2_start] = ACTIONS(1412),
    [sym__html_block_3_start] = ACTIONS(1412),
    [sym__html_block_4_start] = ACTIONS(1412),
    [sym__html_block_5_start] = ACTIONS(1412),
    [sym__html_block_6_start] = ACTIONS(1412),
    [sym__html_block_7_start] = ACTIONS(1412),
    [sym__pipe_table_start] = ACTIONS(1412),
  },
  [154] = {
    [anon_sym_LBRACK] = ACTIONS(1402),
    [anon_sym_RBRACK] = ACTIONS(1400),
    [anon_sym_LT] = ACTIONS(1400),
    [anon_sym_GT] = ACTIONS(1400),
    [anon_sym_BANG] = ACTIONS(1400),
    [anon_sym_DQUOTE] = ACTIONS(1400),
    [anon_sym_POUND] = ACTIONS(1400),
    [anon_sym_DOLLAR] = ACTIONS(1400),
    [anon_sym_PERCENT] = ACTIONS(1400),
    [anon_sym_AMP] = ACTIONS(1400),
    [anon_sym_SQUOTE] = ACTIONS(1400),
    [anon_sym_STAR] = ACTIONS(1400),
    [anon_sym_PLUS] = ACTIONS(1400),
    [anon_sym_COMMA] = ACTIONS(1400),
    [anon_sym_DASH] = ACTIONS(1400),
    [anon_sym_DOT] = ACTIONS(1400),
    [anon_sym_SLASH] = ACTIONS(1400),
    [anon_sym_COLON] = ACTIONS(1400),
    [anon_sym_SEMI] = ACTIONS(1400),
    [anon_sym_EQ] = ACTIONS(1400),
    [anon_sym_QMARK] = ACTIONS(1400),
    [anon_sym_AT] = ACTIONS(1400),
    [anon_sym_BSLASH] = ACTIONS(1400),
    [anon_sym_CARET] = ACTIONS(1400),
    [anon_sym__] = ACTIONS(1400),
    [anon_sym_BQUOTE] = ACTIONS(1400),
    [anon_sym_LBRACE] = ACTIONS(1400),
    [anon_sym_PIPE] = ACTIONS(1400),
    [anon_sym_RBRACE] = ACTIONS(1400),
    [anon_sym_TILDE] = ACTIONS(1400),
    [anon_sym_LPAREN] = ACTIONS(1400),
    [anon_sym_RPAREN] = ACTIONS(1400),
    [aux_sym__word_token1] = ACTIONS(1400),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1400),
    [aux_sym__word_token2] = ACTIONS(1400),
    [sym__whitespace] = ACTIONS(1400),
    [sym__soft_line_ending] = ACTIONS(1400),
    [sym__block_close] = ACTIONS(1400),
    [sym_block_continuation] = ACTIONS(1466),
    [sym__block_quote_start] = ACTIONS(1400),
    [sym__indented_chunk_start] = ACTIONS(1400),
    [sym_atx_h1_marker] = ACTIONS(1400),
    [sym_atx_h2_marker] = ACTIONS(1400),
    [sym_atx_h3_marker] = ACTIONS(1400),
    [sym_atx_h4_marker] = ACTIONS(1400),
    [sym_atx_h5_marker] = ACTIONS(1400),
    [sym_atx_h6_marker] = ACTIONS(1400),
    [sym__thematic_break] = ACTIONS(1400),
    [sym__list_marker_minus] = ACTIONS(1400),
    [sym__list_marker_plus] = ACTIONS(1400),
    [sym__list_marker_star] = ACTIONS(1400),
    [sym__list_marker_parenthesis] = ACTIONS(1400),
    [sym__list_marker_dot] = ACTIONS(1400),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1400),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1400),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1400),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1400),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1400),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1400),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1400),
    [sym__blank_line_start] = ACTIONS(1400),
    [sym__html_block_1_start] = ACTIONS(1400),
    [sym__html_block_2_start] = ACTIONS(1400),
    [sym__html_block_3_start] = ACTIONS(1400),
    [sym__html_block_4_start] = ACTIONS(1400),
    [sym__html_block_5_start] = ACTIONS(1400),
    [sym__html_block_6_start] = ACTIONS(1400),
    [sym__html_block_7_start] = ACTIONS(1400),
    [sym__pipe_table_start] = ACTIONS(1400),
  },
  [155] = {
    [anon_sym_LBRACK] = ACTIONS(1396),
    [anon_sym_RBRACK] = ACTIONS(1394),
    [anon_sym_LT] = ACTIONS(1394),
    [anon_sym_GT] = ACTIONS(1394),
    [anon_sym_BANG] = ACTIONS(1394),
    [anon_sym_DQUOTE] = ACTIONS(1394),
    [anon_sym_POUND] = ACTIONS(1394),
    [anon_sym_DOLLAR] = ACTIONS(1394),
    [anon_sym_PERCENT] = ACTIONS(1394),
    [anon_sym_AMP] = ACTIONS(1394),
    [anon_sym_SQUOTE] = ACTIONS(1394),
    [anon_sym_STAR] = ACTIONS(1394),
    [anon_sym_PLUS] = ACTIONS(1394),
    [anon_sym_COMMA] = ACTIONS(1394),
    [anon_sym_DASH] = ACTIONS(1394),
    [anon_sym_DOT] = ACTIONS(1394),
    [anon_sym_SLASH] = ACTIONS(1394),
    [anon_sym_COLON] = ACTIONS(1394),
    [anon_sym_SEMI] = ACTIONS(1394),
    [anon_sym_EQ] = ACTIONS(1394),
    [anon_sym_QMARK] = ACTIONS(1394),
    [anon_sym_AT] = ACTIONS(1394),
    [anon_sym_BSLASH] = ACTIONS(1394),
    [anon_sym_CARET] = ACTIONS(1394),
    [anon_sym__] = ACTIONS(1394),
    [anon_sym_BQUOTE] = ACTIONS(1394),
    [anon_sym_LBRACE] = ACTIONS(1394),
    [anon_sym_PIPE] = ACTIONS(1394),
    [anon_sym_RBRACE] = ACTIONS(1394),
    [anon_sym_TILDE] = ACTIONS(1394),
    [anon_sym_LPAREN] = ACTIONS(1394),
    [anon_sym_RPAREN] = ACTIONS(1394),
    [aux_sym__word_token1] = ACTIONS(1394),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1394),
    [aux_sym__word_token2] = ACTIONS(1394),
    [sym__whitespace] = ACTIONS(1394),
    [sym__soft_line_ending] = ACTIONS(1394),
    [sym__block_close] = ACTIONS(1394),
    [sym_block_continuation] = ACTIONS(1468),
    [sym__block_quote_start] = ACTIONS(1394),
    [sym__indented_chunk_start] = ACTIONS(1394),
    [sym_atx_h1_marker] = ACTIONS(1394),
    [sym_atx_h2_marker] = ACTIONS(1394),
    [sym_atx_h3_marker] = ACTIONS(1394),
    [sym_atx_h4_marker] = ACTIONS(1394),
    [sym_atx_h5_marker] = ACTIONS(1394),
    [sym_atx_h6_marker] = ACTIONS(1394),
    [sym__thematic_break] = ACTIONS(1394),
    [sym__list_marker_minus] = ACTIONS(1394),
    [sym__list_marker_plus] = ACTIONS(1394),
    [sym__list_marker_star] = ACTIONS(1394),
    [sym__list_marker_parenthesis] = ACTIONS(1394),
    [sym__list_marker_dot] = ACTIONS(1394),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1394),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1394),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1394),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1394),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1394),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1394),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1394),
    [sym__blank_line_start] = ACTIONS(1394),
    [sym__html_block_1_start] = ACTIONS(1394),
    [sym__html_block_2_start] = ACTIONS(1394),
    [sym__html_block_3_start] = ACTIONS(1394),
    [sym__html_block_4_start] = ACTIONS(1394),
    [sym__html_block_5_start] = ACTIONS(1394),
    [sym__html_block_6_start] = ACTIONS(1394),
    [sym__html_block_7_start] = ACTIONS(1394),
    [sym__pipe_table_start] = ACTIONS(1394),
  },
  [156] = {
    [anon_sym_LBRACK] = ACTIONS(1378),
    [anon_sym_RBRACK] = ACTIONS(1376),
    [anon_sym_LT] = ACTIONS(1376),
    [anon_sym_GT] = ACTIONS(1376),
    [anon_sym_BANG] = ACTIONS(1376),
    [anon_sym_DQUOTE] = ACTIONS(1376),
    [anon_sym_POUND] = ACTIONS(1376),
    [anon_sym_DOLLAR] = ACTIONS(1376),
    [anon_sym_PERCENT] = ACTIONS(1376),
    [anon_sym_AMP] = ACTIONS(1376),
    [anon_sym_SQUOTE] = ACTIONS(1376),
    [anon_sym_STAR] = ACTIONS(1376),
    [anon_sym_PLUS] = ACTIONS(1376),
    [anon_sym_COMMA] = ACTIONS(1376),
    [anon_sym_DASH] = ACTIONS(1376),
    [anon_sym_DOT] = ACTIONS(1376),
    [anon_sym_SLASH] = ACTIONS(1376),
    [anon_sym_COLON] = ACTIONS(1376),
    [anon_sym_SEMI] = ACTIONS(1376),
    [anon_sym_EQ] = ACTIONS(1376),
    [anon_sym_QMARK] = ACTIONS(1376),
    [anon_sym_AT] = ACTIONS(1376),
    [anon_sym_BSLASH] = ACTIONS(1376),
    [anon_sym_CARET] = ACTIONS(1376),
    [anon_sym__] = ACTIONS(1376),
    [anon_sym_BQUOTE] = ACTIONS(1376),
    [anon_sym_LBRACE] = ACTIONS(1376),
    [anon_sym_PIPE] = ACTIONS(1376),
    [anon_sym_RBRACE] = ACTIONS(1376),
    [anon_sym_TILDE] = ACTIONS(1376),
    [anon_sym_LPAREN] = ACTIONS(1376),
    [anon_sym_RPAREN] = ACTIONS(1376),
    [aux_sym__word_token1] = ACTIONS(1376),
    [anon_sym_LBRACKx_RBRACK] = ACTIONS(1376),
    [aux_sym__word_token2] = ACTIONS(1376),
    [sym__whitespace] = ACTIONS(1376),
    [sym__soft_line_ending] = ACTIONS(1376),
    [sym__block_close] = ACTIONS(1376),
    [sym_block_continuation] = ACTIONS(1470),
    [sym__block_quote_start] = ACTIONS(1376),
    [sym__indented_chunk_start] = ACTIONS(1376),
    [sym_atx_h1_marker] = ACTIONS(1376),
    [sym_atx_h2_marker] = ACTIONS(1376),
    [sym_atx_h3_marker] = ACTIONS(1376),
    [sym_atx_h4_marker] = ACTIONS(1376),
    [sym_atx_h5_marker] = ACTIONS(1376),
    [sym_atx_h6_marker] = ACTIONS(1376),
    [sym__thematic_break] = ACTIONS(1376),
    [sym__list_marker_minus] = ACTIONS(1376),
    [sym__list_marker_plus] = ACTIONS(1376),
    [sym__list_marker_star] = ACTIONS(1376),
    [sym__list_marker_parenthesis] = ACTIONS(1376),
    [sym__list_marker_dot] = ACTIONS(1376),
    [sym__list_marker_minus_dont_interrupt] = ACTIONS(1376),
    [sym__list_marker_plus_dont_interrupt] = ACTIONS(1376),
    [sym__list_marker_star_dont_interrupt] = ACTIONS(1376),
    [sym__list_marker_parenthesis_dont_interrupt] = ACTIONS(1376),
    [sym__list_marker_dot_dont_interrupt] = ACTIONS(1376),
    [sym__fenced_code_block_start_backtick] = ACTIONS(1376),
    [sym__fenced_code_block_start_tilde] = ACTIONS(1376),
    [sym__blank_line_start] = ACTIONS(1376),
    [sym__html_block_1_start] = ACTIONS(1376),
    [sym__html_block_2_start] = ACTIONS(1376),
    [sym__html_block_3_start] = ACTIONS(1376),
    [sym__html_block_4_start] = ACTIONS(1376),
    [sym__html_block_5_start] = ACTIONS(1376),
    [sym__html_block_6_start] = ACTIONS(1376),
    [sym__html_block_7_start] = ACTIONS(1376),
    [sym__pipe_table_start] = ACTIONS(1376),
  },
 