#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 235
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 125
#define ALIAS_COUNT 0
#define TOKEN_COUNT 67
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 20
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 50

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_return = 3,
  anon_sym_SEMI = 4,
  anon_sym_EQ = 5,
  anon_sym_COMMA = 6,
  anon_sym_COLON_COLON = 7,
  sym_break_statement = 8,
  anon_sym_goto = 9,
  anon_sym_do = 10,
  anon_sym_end = 11,
  anon_sym_while = 12,
  anon_sym_repeat = 13,
  anon_sym_until = 14,
  anon_sym_if = 15,
  anon_sym_then = 16,
  anon_sym_elseif = 17,
  anon_sym_else = 18,
  anon_sym_for = 19,
  anon_sym_in = 20,
  anon_sym_function = 21,
  anon_sym_local = 22,
  anon_sym_DOT = 23,
  anon_sym_COLON = 24,
  sym_nil = 25,
  sym_false = 26,
  sym_true = 27,
  sym_number = 28,
  sym_vararg_expression = 29,
  anon_sym_LPAREN = 30,
  anon_sym_RPAREN = 31,
  anon_sym_LBRACK = 32,
  anon_sym_RBRACK = 33,
  anon_sym_LBRACE = 34,
  anon_sym_RBRACE = 35,
  anon_sym_or = 36,
  anon_sym_and = 37,
  anon_sym_LT = 38,
  anon_sym_LT_EQ = 39,
  anon_sym_EQ_EQ = 40,
  anon_sym_TILDE_EQ = 41,
  anon_sym_GT_EQ = 42,
  anon_sym_GT = 43,
  anon_sym_PIPE = 44,
  anon_sym_TILDE = 45,
  anon_sym_AMP = 46,
  anon_sym_LT_LT = 47,
  anon_sym_GT_GT = 48,
  anon_sym_PLUS = 49,
  anon_sym_DASH = 50,
  anon_sym_STAR = 51,
  anon_sym_SLASH = 52,
  anon_sym_SLASH_SLASH = 53,
  anon_sym_PERCENT = 54,
  anon_sym_DOT_DOT = 55,
  anon_sym_CARET = 56,
  anon_sym_not = 57,
  anon_sym_POUND = 58,
  anon_sym_DASH_DASH = 59,
  aux_sym_comment_token1 = 60,
  sym__block_comment_start = 61,
  sym__block_comment_content = 62,
  sym__block_comment_end = 63,
  sym__string_start = 64,
  sym__string_content = 65,
  sym__string_end = 66,
  sym_chunk = 67,
  sym__block = 68,
  sym_statement = 69,
  sym_return_statement = 70,
  sym_empty_statement = 71,
  sym_assignment_statement = 72,
  sym__variable_assignment_varlist = 73,
  sym__variable_assignment_explist = 74,
  sym_label_statement = 75,
  sym_goto_statement = 76,
  sym_do_statement = 77,
  sym_while_statement = 78,
  sym_repeat_statement = 79,
  sym_if_statement = 80,
  sym_elseif_statement = 81,
  sym_else_statement = 82,
  sym_for_statement = 83,
  sym_for_generic_clause = 84,
  sym_for_numeric_clause = 85,
  sym_declaration = 86,
  sym_function_declaration = 87,
  sym__local_function_declaration = 88,
  sym__function_name = 89,
  sym__function_name_prefix_expression = 90,
  sym__function_name_dot_index_expression = 91,
  sym__function_name_method_index_expression = 92,
  sym_variable_declaration = 93,
  sym__local_variable_assignment = 94,
  sym__name_list = 95,
  sym__expression_list = 96,
  sym_expression = 97,
  sym_string = 98,
  sym_function_definition = 99,
  sym__function_body = 100,
  sym_parameters = 101,
  sym__parameter_list = 102,
  sym__prefix_expression = 103,
  sym_variable = 104,
  sym_bracket_index_expression = 105,
  sym_dot_index_expression = 106,
  sym_function_call = 107,
  sym_method_index_expression = 108,
  sym_arguments = 109,
  sym_parenthesized_expression = 110,
  sym_table_constructor = 111,
  sym__field_list = 112,
  sym__field_sep = 113,
  sym_field = 114,
  sym_binary_expression = 115,
  sym_unary_expression = 116,
  sym_comment = 117,
  aux_sym_chunk_repeat1 = 118,
  aux_sym__variable_assignment_varlist_repeat1 = 119,
  aux_sym__variable_assignment_explist_repeat1 = 120,
  aux_sym_if_statement_repeat1 = 121,
  aux_sym__name_list_repeat1 = 122,
  aux_sym__expression_list_repeat1 = 123,
  aux_sym__field_list_repeat1 = 124,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_return] = "return",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_COMMA] = ",",
  [anon_sym_COLON_COLON] = "::",
  [sym_break_statement] = "break_statement",
  [anon_sym_goto] = "goto",
  [anon_sym_do] = "do",
  [anon_sym_end] = "end",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_until] = "until",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_function] = "function",
  [anon_sym_local] = "local",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON] = ":",
  [sym_nil] = "nil",
  [sym_false] = "false",
  [sym_true] = "true",
  [sym_number] = "number",
  [sym_vararg_expression] = "vararg_expression",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_or] = "or",
  [anon_sym_and] = "and",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_PIPE] = "|",
  [anon_sym_TILDE] = "~",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_CARET] = "^",
  [anon_sym_not] = "not",
  [anon_sym_POUND] = "#",
  [anon_sym_DASH_DASH] = "comment_start",
  [aux_sym_comment_token1] = "comment_content",
  [sym__block_comment_start] = "comment_start",
  [sym__block_comment_content] = "comment_content",
  [sym__block_comment_end] = "comment_end",
  [sym__string_start] = "string_start",
  [sym__string_content] = "string_content",
  [sym__string_end] = "string_end",
  [sym_chunk] = "chunk",
  [sym__block] = "block",
  [sym_statement] = "statement",
  [sym_return_statement] = "return_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym__variable_assignment_varlist] = "variable_list",
  [sym__variable_assignment_explist] = "expression_list",
  [sym_label_statement] = "label_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_do_statement] = "do_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_if_statement] = "if_statement",
  [sym_elseif_statement] = "elseif_statement",
  [sym_else_statement] = "else_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_generic_clause] = "for_generic_clause",
  [sym_for_numeric_clause] = "for_numeric_clause",
  [sym_declaration] = "declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__local_function_declaration] = "function_declaration",
  [sym__function_name] = "_function_name",
  [sym__function_name_prefix_expression] = "_function_name_prefix_expression",
  [sym__function_name_dot_index_expression] = "dot_index_expression",
  [sym__function_name_method_index_expression] = "method_index_expression",
  [sym_variable_declaration] = "variable_declaration",
  [sym__local_variable_assignment] = "assignment_statement",
  [sym__name_list] = "variable_list",
  [sym__expression_list] = "expression_list",
  [sym_expression] = "expression",
  [sym_string] = "string",
  [sym_function_definition] = "function_definition",
  [sym__function_body] = "_function_body",
  [sym_parameters] = "parameters",
  [sym__parameter_list] = "_parameter_list",
  [sym__prefix_expression] = "_prefix_expression",
  [sym_variable] = "variable",
  [sym_bracket_index_expression] = "bracket_index_expression",
  [sym_dot_index_expression] = "dot_index_expression",
  [sym_function_call] = "function_call",
  [sym_method_index_expression] = "method_index_expression",
  [sym_arguments] = "arguments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_table_constructor] = "table_constructor",
  [sym__field_list] = "_field_list",
  [sym__field_sep] = "_field_sep",
  [sym_field] = "field",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_comment] = "comment",
  [aux_sym_chunk_repeat1] = "chunk_repeat1",
  [aux_sym__variable_assignment_varlist_repeat1] = "_variable_assignment_varlist_repeat1",
  [aux_sym__variable_assignment_explist_repeat1] = "_variable_assignment_explist_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym__name_list_repeat1] = "_name_list_repeat1",
  [aux_sym__expression_list_repeat1] = "_expression_list_repeat1",
  [aux_sym__field_list_repeat1] = "_field_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_break_statement] = sym_break_statement,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_local] = anon_sym_local,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_nil] = sym_nil,
  [sym_false] = sym_false,
  [sym_true] = sym_true,
  [sym_number] = sym_number,
  [sym_vararg_expression] = sym_vararg_expression,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_DASH_DASH] = sym__block_comment_start,
  [aux_sym_comment_token1] = sym__block_comment_content,
  [sym__block_comment_start] = sym__block_comment_start,
  [sym__block_comment_content] = sym__block_comment_content,
  [sym__block_comment_end] = sym__block_comment_end,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_end,
  [sym_chunk] = sym_chunk,
  [sym__block] = sym__block,
  [sym_statement] = sym_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym__variable_assignment_varlist] = sym__variable_assignment_varlist,
  [sym__variable_assignment_explist] = sym__variable_assignment_explist,
  [sym_label_statement] = sym_label_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elseif_statement] = sym_elseif_statement,
  [sym_else_statement] = sym_else_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_generic_clause] = sym_for_generic_clause,
  [sym_for_numeric_clause] = sym_for_numeric_clause,
  [sym_declaration] = sym_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__local_function_declaration] = sym_function_declaration,
  [sym__function_name] = sym__function_name,
  [sym__function_name_prefix_expression] = sym__function_name_prefix_expression,
  [sym__function_name_dot_index_expression] = sym_dot_index_expression,
  [sym__function_name_method_index_expression] = sym_method_index_expression,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym__local_variable_assignment] = sym_assignment_statement,
  [sym__name_list] = sym__variable_assignment_varlist,
  [sym__expression_list] = sym__variable_assignment_explist,
  [sym_expression] = sym_expression,
  [sym_string] = sym_string,
  [sym_function_definition] = sym_function_definition,
  [sym__function_body] = sym__function_body,
  [sym_parameters] = sym_parameters,
  [sym__parameter_list] = sym__parameter_list,
  [sym__prefix_expression] = sym__prefix_expression,
  [sym_variable] = sym_variable,
  [sym_bracket_index_expression] = sym_bracket_index_expression,
  [sym_dot_index_expression] = sym_dot_index_expression,
  [sym_function_call] = sym_function_call,
  [sym_method_index_expression] = sym_method_index_expression,
  [sym_arguments] = sym_arguments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_table_constructor] = sym_table_constructor,
  [sym__field_list] = sym__field_list,
  [sym__field_sep] = sym__field_sep,
  [sym_field] = sym_field,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_comment] = sym_comment,
  [aux_sym_chunk_repeat1] = aux_sym_chunk_repeat1,
  [aux_sym__variable_assignment_varlist_repeat1] = aux_sym__variable_assignment_varlist_repeat1,
  [aux_sym__variable_assignment_explist_repeat1] = aux_sym__variable_assignment_explist_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym__name_list_repeat1] = aux_sym__name_list_repeat1,
  [aux_sym__expression_list_repeat1] = aux_sym__expression_list_repeat1,
  [aux_sym__field_list_repeat1] = aux_sym__field_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_vararg_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = true,
    .named = false,
  },
  [sym__block_comment_start] = {
    .visible = true,
    .named = false,
  },
  [sym__block_comment_content] = {
    .visible = true,
    .named = false,
  },
  [sym__block_comment_end] = {
    .visible = true,
    .named = false,
  },
  [sym__string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = true,
    .named = false,
  },
  [sym__string_end] = {
    .visible = true,
    .named = false,
  },
  [sym_chunk] = {
    .visible = true,
    .named = true,
  },
  [sym__block] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_assignment_varlist] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_assignment_explist] = {
    .visible = true,
    .named = true,
  },
  [sym_label_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_else_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_generic_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_numeric_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__function_name] = {
    .visible = false,
    .named = true,
  },
  [sym__function_name_prefix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__function_name_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__function_name_method_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__local_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym__name_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__function_body] = {
    .visible = false,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym__prefix_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_variable] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_bracket_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_method_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_table_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym__field_list] = {
    .visible = false,
    .named = true,
  },
  [sym__field_sep] = {
    .visible = false,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_chunk_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_assignment_varlist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__variable_assignment_explist_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__name_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__field_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_clause = 4,
  field_condition = 5,
  field_consequence = 6,
  field_content = 7,
  field_end = 8,
  field_field = 9,
  field_left = 10,
  field_local_declaration = 11,
  field_method = 12,
  field_name = 13,
  field_operand = 14,
  field_parameters = 15,
  field_right = 16,
  field_start = 17,
  field_step = 18,
  field_table = 19,
  field_value = 20,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_clause] = "clause",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_content] = "content",
  [field_end] = "end",
  [field_field] = "field",
  [field_left] = "left",
  [field_local_declaration] = "local_declaration",
  [field_method] = "method",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_step] = "step",
  [field_table] = "table",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 4},
  [3] = {.index = 5, .length = 1},
  [4] = {.index = 6, .length = 1},
  [5] = {.index = 7, .length = 2},
  [6] = {.index = 9, .length = 2},
  [7] = {.index = 11, .length = 2},
  [8] = {.index = 13, .length = 2},
  [9] = {.index = 15, .length = 1},
  [10] = {.index = 16, .length = 2},
  [11] = {.index = 18, .length = 2},
  [12] = {.index = 20, .length = 3},
  [13] = {.index = 23, .length = 2},
  [14] = {.index = 25, .length = 1},
  [15] = {.index = 26, .length = 1},
  [16] = {.index = 27, .length = 1},
  [17] = {.index = 28, .length = 1},
  [18] = {.index = 29, .length = 3},
  [19] = {.index = 32, .length = 2},
  [20] = {.index = 34, .length = 2},
  [21] = {.index = 36, .length = 2},
  [22] = {.index = 38, .length = 1},
  [23] = {.index = 39, .length = 2},
  [24] = {.index = 41, .length = 1},
  [25] = {.index = 42, .length = 2},
  [26] = {.index = 44, .length = 1},
  [27] = {.index = 45, .length = 2},
  [28] = {.index = 47, .length = 1},
  [29] = {.index = 48, .length = 1},
  [30] = {.index = 49, .length = 1},
  [31] = {.index = 50, .length = 3},
  [32] = {.index = 53, .length = 2},
  [33] = {.index = 55, .length = 2},
  [34] = {.index = 57, .length = 2},
  [35] = {.index = 59, .length = 2},
  [36] = {.index = 61, .length = 2},
  [37] = {.index = 63, .length = 2},
  [38] = {.index = 65, .length = 2},
  [39] = {.index = 67, .length = 2},
  [40] = {.index = 69, .length = 2},
  [41] = {.index = 71, .length = 1},
  [42] = {.index = 72, .length = 2},
  [43] = {.index = 74, .length = 3},
  [44] = {.index = 77, .length = 3},
  [45] = {.index = 80, .length = 3},
  [46] = {.index = 83, .length = 3},
  [47] = {.index = 86, .length = 2},
  [48] = {.index = 88, .length = 4},
  [49] = {.index = 92, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_local_declaration, 0, .inherited = true},
  [1] =
    {field_body, 0, .inherited = true},
    {field_local_declaration, 0},
    {field_name, 0, .inherited = true},
    {field_parameters, 0, .inherited = true},
  [5] =
    {field_local_declaration, 0},
  [6] =
    {field_name, 0},
  [7] =
    {field_end, 1},
    {field_start, 0},
  [9] =
    {field_content, 1},
    {field_start, 0},
  [11] =
    {field_field, 0, .inherited = true},
    {field_table, 0, .inherited = true},
  [13] =
    {field_method, 0, .inherited = true},
    {field_table, 0, .inherited = true},
  [15] =
    {field_name, 1, .inherited = true},
  [16] =
    {field_arguments, 1},
    {field_name, 0},
  [18] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [20] =
    {field_content, 1},
    {field_end, 2},
    {field_start, 0},
  [23] =
    {field_body, 1, .inherited = true},
    {field_parameters, 1, .inherited = true},
  [25] =
    {field_value, 0},
  [26] =
    {field_operand, 1},
  [27] =
    {field_body, 1},
  [28] =
    {field_condition, 2},
  [29] =
    {field_body, 2, .inherited = true},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
  [32] =
    {field_name, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [34] =
    {field_field, 2},
    {field_table, 0},
  [36] =
    {field_method, 2},
    {field_table, 0},
  [38] =
    {field_name, 1},
  [39] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [41] =
    {field_parameters, 0},
  [42] =
    {field_left, 0},
    {field_right, 2},
  [44] =
    {field_condition, 1},
  [45] =
    {field_body, 1},
    {field_condition, 3},
  [47] =
    {field_alternative, 0},
  [48] =
    {field_clause, 1},
  [49] =
    {field_name, 0, .inherited = true},
  [50] =
    {field_body, 3, .inherited = true},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
  [53] =
    {field_value, 0},
    {field_value, 1, .inherited = true},
  [55] =
    {field_body, 1},
    {field_parameters, 0},
  [57] =
    {field_name, 0},
    {field_value, 2},
  [59] =
    {field_body, 3},
    {field_condition, 1},
  [61] =
    {field_condition, 1},
    {field_consequence, 3},
  [63] =
    {field_alternative, 3},
    {field_condition, 1},
  [65] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
  [67] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [69] =
    {field_body, 3},
    {field_clause, 1},
  [71] =
    {field_value, 1},
  [72] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [74] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [77] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [80] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
  [83] =
    {field_end, 4},
    {field_name, 0},
    {field_start, 2},
  [86] =
    {field_name, 1},
    {field_value, 4},
  [88] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [92] =
    {field_end, 4},
    {field_name, 0},
    {field_start, 2},
    {field_step, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(10);
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '%') ADVANCE(49);
      if (lookahead == '&') ADVANCE(41);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '*') ADVANCE(46);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == ',') ADVANCE(14);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '/') ADVANCE(47);
      if (lookahead == '0') ADVANCE(19);
      if (lookahead == ':') ADVANCE(18);
      if (lookahead == ';') ADVANCE(12);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == ']') ADVANCE(29);
      if (lookahead == '^') ADVANCE(51);
      if (lookahead == '{') ADVANCE(30);
      if (lookahead == '|') ADVANCE(38);
      if (lookahead == '}') ADVANCE(31);
      if (lookahead == '~') ADVANCE(40);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '\\' &&
          (lookahead < 127 || 159 < lookahead)) ADVANCE(53);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(11);
      END_STATE();
    case 2:
      if (lookahead == '.') ADVANCE(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 3:
      if (lookahead == '.') ADVANCE(25);
      END_STATE();
    case 4:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 5:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 6:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(21);
      END_STATE();
    case 7:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(23);
      END_STATE();
    case 8:
      if (eof) ADVANCE(10);
      if (lookahead == '#') ADVANCE(52);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(2);
      if (lookahead == '0') ADVANCE(19);
      if (lookahead == ';') ADVANCE(12);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '{') ADVANCE(30);
      if (lookahead == '}') ADVANCE(31);
      if (lookahead == '~') ADVANCE(39);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '"' &&
          (lookahead < '%' || '>' < lookahead) &&
          (lookahead < '\\' || '^' < lookahead) &&
          (lookahead < '|' || 159 < lookahead)) ADVANCE(53);
      END_STATE();
    case 9:
      if (eof) ADVANCE(10);
      if (lookahead == '#') ADVANCE(1);
      if (lookahead == '%') ADVANCE(49);
      if (lookahead == '&') ADVANCE(41);
      if (lookahead == '(') ADVANCE(26);
      if (lookahead == ')') ADVANCE(27);
      if (lookahead == '*') ADVANCE(46);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == ',') ADVANCE(14);
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '/') ADVANCE(47);
      if (lookahead == ':') ADVANCE(18);
      if (lookahead == ';') ADVANCE(12);
      if (lookahead == '<') ADVANCE(32);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(37);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == ']') ADVANCE(29);
      if (lookahead == '^') ADVANCE(51);
      if (lookahead == '{') ADVANCE(30);
      if (lookahead == '|') ADVANCE(38);
      if (lookahead == '}') ADVANCE(31);
      if (lookahead == '~') ADVANCE(40);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '"' &&
          (lookahead < '\'' || '9' < lookahead) &&
          lookahead != '\\' &&
          (lookahead < 127 || 159 < lookahead)) ADVANCE(53);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(11);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(34);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(50);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(15);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(4);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(20);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(20);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(7);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(21);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(23);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(24);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_vararg_expression);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(42);
      if (lookahead == '=') ADVANCE(33);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(36);
      if (lookahead == '>') ADVANCE(43);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(54);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(48);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead != 0 &&
          lookahead > ' ' &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '%' || '/' < lookahead) &&
          (lookahead < ':' || '>' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || 159 < lookahead)) ADVANCE(53);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(58);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(56);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(58);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '-') ADVANCE(55);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(58);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(58);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'd') ADVANCE(3);
      if (lookahead == 'e') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'g') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'n') ADVANCE(9);
      if (lookahead == 'o') ADVANCE(10);
      if (lookahead == 'r') ADVANCE(11);
      if (lookahead == 't') ADVANCE(12);
      if (lookahead == 'u') ADVANCE(13);
      if (lookahead == 'w') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(15);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(20);
      if (lookahead == 'o') ADVANCE(21);
      if (lookahead == 'u') ADVANCE(22);
      END_STATE();
    case 6:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(24);
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 12:
      if (lookahead == 'h') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      END_STATE();
    case 13:
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(34);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(35);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(38);
      END_STATE();
    case 20:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 21:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(41);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(43);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(45);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 30:
      if (lookahead == 'p') ADVANCE(46);
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(51);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 39:
      if (lookahead == 's') ADVANCE(54);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 41:
      if (lookahead == 'c') ADVANCE(55);
      END_STATE();
    case 42:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(57);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 47:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 48:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 52:
      if (lookahead == 'k') ADVANCE(64);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 65:
      if (lookahead == 'f') ADVANCE(73);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 67:
      if (lookahead == 'i') ADVANCE(74);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(78);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 9, .external_lex_state = 2},
  [2] = {.lex_state = 9, .external_lex_state = 3},
  [3] = {.lex_state = 9, .external_lex_state = 3},
  [4] = {.lex_state = 9, .external_lex_state = 3},
  [5] = {.lex_state = 9, .external_lex_state = 3},
  [6] = {.lex_state = 9, .external_lex_state = 3},
  [7] = {.lex_state = 9, .external_lex_state = 3},
  [8] = {.lex_state = 9, .external_lex_state = 3},
  [9] = {.lex_state = 9, .external_lex_state = 3},
  [10] = {.lex_state = 9, .external_lex_state = 3},
  [11] = {.lex_state = 9, .external_lex_state = 3},
  [12] = {.lex_state = 9, .external_lex_state = 3},
  [13] = {.lex_state = 9, .external_lex_state = 3},
  [14] = {.lex_state = 9, .external_lex_state = 3},
  [15] = {.lex_state = 9, .external_lex_state = 3},
  [16] = {.lex_state = 0, .external_lex_state = 2},
  [17] = {.lex_state = 0, .external_lex_state = 2},
  [18] = {.lex_state = 0, .external_lex_state = 2},
  [19] = {.lex_state = 0, .external_lex_state = 2},
  [20] = {.lex_state = 0, .external_lex_state = 2},
  [21] = {.lex_state = 0, .external_lex_state = 2},
  [22] = {.lex_state = 0, .external_lex_state = 2},
  [23] = {.lex_state = 0, .external_lex_state = 2},
  [24] = {.lex_state = 0, .external_lex_state = 2},
  [25] = {.lex_state = 0, .external_lex_state = 2},
  [26] = {.lex_state = 0, .external_lex_state = 2},
  [27] = {.lex_state = 0, .external_lex_state = 2},
  [28] = {.lex_state = 0, .external_lex_state = 2},
  [29] = {.lex_state = 0, .external_lex_state = 2},
  [30] = {.lex_state = 0, .external_lex_state = 2},
  [31] = {.lex_state = 0, .external_lex_state = 2},
  [32] = {.lex_state = 0, .external_lex_state = 2},
  [33] = {.lex_state = 0, .external_lex_state = 2},
  [34] = {.lex_state = 0, .external_lex_state = 2},
  [35] = {.lex_state = 0, .external_lex_state = 2},
  [36] = {.lex_state = 0, .external_lex_state = 2},
  [37] = {.lex_state = 0, .external_lex_state = 2},
  [38] = {.lex_state = 0, .external_lex_state = 2},
  [39] = {.lex_state = 0, .external_lex_state = 2},
  [40] = {.lex_state = 0, .external_lex_state = 2},
  [41] = {.lex_state = 0, .external_lex_state = 2},
  [42] = {.lex_state = 0, .external_lex_state = 2},
  [43] = {.lex_state = 0, .external_lex_state = 2},
  [44] = {.lex_state = 0, .external_lex_state = 2},
  [45] = {.lex_state = 0, .external_lex_state = 2},
  [46] = {.lex_state = 0, .external_lex_state = 2},
  [47] = {.lex_state = 0, .external_lex_state = 2},
  [48] = {.lex_state = 0, .external_lex_state = 2},
  [49] = {.lex_state = 0, .external_lex_state = 2},
  [50] = {.lex_state = 0, .external_lex_state = 2},
  [51] = {.lex_state = 0, .external_lex_state = 2},
  [52] = {.lex_state = 0, .external_lex_state = 2},
  [53] = {.lex_state = 8, .external_lex_state = 3},
  [54] = {.lex_state = 8, .external_lex_state = 3},
  [55] = {.lex_state = 8, .external_lex_state = 3},
  [56] = {.lex_state = 9, .external_lex_state = 3},
  [57] = {.lex_state = 0, .external_lex_state = 2},
  [58] = {.lex_state = 8, .external_lex_state = 3},
  [59] = {.lex_state = 0, .external_lex_state = 2},
  [60] = {.lex_state = 8, .external_lex_state = 3},
  [61] = {.lex_state = 8, .external_lex_state = 3},
  [62] = {.lex_state = 8, .external_lex_state = 3},
  [63] = {.lex_state = 8, .external_lex_state = 3},
  [64] = {.lex_state = 8, .external_lex_state = 3},
  [65] = {.lex_state = 8, .external_lex_state = 3},
  [66] = {.lex_state = 8, .external_lex_state = 3},
  [67] = {.lex_state = 8, .external_lex_state = 3},
  [68] = {.lex_state = 8, .external_lex_state = 3},
  [69] = {.lex_state = 8, .external_lex_state = 3},
  [70] = {.lex_state = 8, .external_lex_state = 3},
  [71] = {.lex_state = 8, .external_lex_state = 3},
  [72] = {.lex_state = 8, .external_lex_state = 3},
  [73] = {.lex_state = 8, .external_lex_state = 3},
  [74] = {.lex_state = 8, .external_lex_state = 3},
  [75] = {.lex_state = 8, .external_lex_state = 3},
  [76] = {.lex_state = 8, .external_lex_state = 3},
  [77] = {.lex_state = 8, .external_lex_state = 3},
  [78] = {.lex_state = 8, .external_lex_state = 3},
  [79] = {.lex_state = 8, .external_lex_state = 3},
  [80] = {.lex_state = 8, .external_lex_state = 3},
  [81] = {.lex_state = 8, .external_lex_state = 3},
  [82] = {.lex_state = 8, .external_lex_state = 3},
  [83] = {.lex_state = 8, .external_lex_state = 3},
  [84] = {.lex_state = 8, .external_lex_state = 3},
  [85] = {.lex_state = 8, .external_lex_state = 3},
  [86] = {.lex_state = 8, .external_lex_state = 3},
  [87] = {.lex_state = 8, .external_lex_state = 3},
  [88] = {.lex_state = 8, .external_lex_state = 3},
  [89] = {.lex_state = 8, .external_lex_state = 3},
  [90] = {.lex_state = 8, .external_lex_state = 3},
  [91] = {.lex_state = 8, .external_lex_state = 3},
  [92] = {.lex_state = 8, .external_lex_state = 3},
  [93] = {.lex_state = 8, .external_lex_state = 3},
  [94] = {.lex_state = 0, .external_lex_state = 2},
  [95] = {.lex_state = 9, .external_lex_state = 3},
  [96] = {.lex_state = 0, .external_lex_state = 2},
  [97] = {.lex_state = 0, .external_lex_state = 2},
  [98] = {.lex_state = 0, .external_lex_state = 2},
  [99] = {.lex_state = 0, .external_lex_state = 2},
  [100] = {.lex_state = 0, .external_lex_state = 2},
  [101] = {.lex_state = 0, .external_lex_state = 2},
  [102] = {.lex_state = 0, .external_lex_state = 2},
  [103] = {.lex_state = 0, .external_lex_state = 2},
  [104] = {.lex_state = 0, .external_lex_state = 2},
  [105] = {.lex_state = 0, .external_lex_state = 2},
  [106] = {.lex_state = 0, .external_lex_state = 2},
  [107] = {.lex_state = 0, .external_lex_state = 2},
  [108] = {.lex_state = 0, .external_lex_state = 2},
  [109] = {.lex_state = 0, .external_lex_state = 2},
  [110] = {.lex_state = 0, .external_lex_state = 2},
  [111] = {.lex_state = 0, .external_lex_state = 2},
  [112] = {.lex_state = 0, .external_lex_state = 2},
  [113] = {.lex_state = 0, .external_lex_state = 2},
  [114] = {.lex_state = 0, .external_lex_state = 2},
  [115] = {.lex_state = 0, .external_lex_state = 2},
  [116] = {.lex_state = 0, .external_lex_state = 2},
  [117] = {.lex_state = 0, .external_lex_state = 2},
  [118] = {.lex_state = 0, .external_lex_state = 2},
  [119] = {.lex_state = 0, .external_lex_state = 2},
  [120] = {.lex_state = 0, .external_lex_state = 2},
  [121] = {.lex_state = 0, .external_lex_state = 2},
  [122] = {.lex_state = 0, .external_lex_state = 2},
  [123] = {.lex_state = 0, .external_lex_state = 2},
  [124] = {.lex_state = 0, .external_lex_state = 2},
  [125] = {.lex_state = 0, .external_lex_state = 2},
  [126] = {.lex_state = 0, .external_lex_state = 2},
  [127] = {.lex_state = 0, .external_lex_state = 2},
  [128] = {.lex_state = 0, .external_lex_state = 2},
  [129] = {.lex_state = 0, .external_lex_state = 2},
  [130] = {.lex_state = 0, .external_lex_state = 2},
  [131] = {.lex_state = 0, .external_lex_state = 2},
  [132] = {.lex_state = 0, .external_lex_state = 2},
  [133] = {.lex_state = 0, .external_lex_state = 2},
  [134] = {.lex_state = 0, .external_lex_state = 2},
  [135] = {.lex_state = 0, .external_lex_state = 2},
  [136] = {.lex_state = 0, .external_lex_state = 2},
  [137] = {.lex_state = 0, .external_lex_state = 2},
  [138] = {.lex_state = 0, .external_lex_state = 2},
  [139] = {.lex_state = 0, .external_lex_state = 2},
  [140] = {.lex_state = 0, .external_lex_state = 2},
  [141] = {.lex_state = 0, .external_lex_state = 2},
  [142] = {.lex_state = 0, .external_lex_state = 2},
  [143] = {.lex_state = 8, .external_lex_state = 3},
  [144] = {.lex_state = 0, .external_lex_state = 2},
  [145] = {.lex_state = 0, .external_lex_state = 2},
  [146] = {.lex_state = 0, .external_lex_state = 2},
  [147] = {.lex_state = 0, .external_lex_state = 2},
  [148] = {.lex_state = 9, .external_lex_state = 3},
  [149] = {.lex_state = 0, .external_lex_state = 2},
  [150] = {.lex_state = 9, .external_lex_state = 3},
  [151] = {.lex_state = 9, .external_lex_state = 3},
  [152] = {.lex_state = 0, .external_lex_state = 3},
  [153] = {.lex_state = 0, .external_lex_state = 2},
  [154] = {.lex_state = 0, .external_lex_state = 2},
  [155] = {.lex_state = 9, .external_lex_state = 3},
  [156] = {.lex_state = 0, .external_lex_state = 2},
  [157] = {.lex_state = 0, .external_lex_state = 2},
  [158] = {.lex_state = 0, .external_lex_state = 2},
  [159] = {.lex_state = 0, .external_lex_state = 2},
  [160] = {.lex_state = 0, .external_lex_state = 2},
  [161] = {.lex_state = 0, .external_lex_state = 2},
  [162] = {.lex_state = 0, .external_lex_state = 2},
  [163] = {.lex_state = 0, .external_lex_state = 2},
  [164] = {.lex_state = 0, .external_lex_state = 2},
  [165] = {.lex_state = 0, .external_lex_state = 2},
  [166] = {.lex_state = 0, .external_lex_state = 2},
  [167] = {.lex_state = 0, .external_lex_state = 2},
  [168] = {.lex_state = 8, .external_lex_state = 2},
  [169] = {.lex_state = 0, .external_lex_state = 2},
  [170] = {.lex_state = 0, .external_lex_state = 2},
  [171] = {.lex_state = 0, .external_lex_state = 2},
  [172] = {.lex_state = 0, .external_lex_state = 2},
  [173] = {.lex_state = 0, .external_lex_state = 2},
  [174] = {.lex_state = 0, .external_lex_state = 3},
  [175] = {.lex_state = 9, .external_lex_state = 2},
  [176] = {.lex_state = 0, .external_lex_state = 2},
  [177] = {.lex_state = 0, .external_lex_state = 2},
  [178] = {.lex_state = 0, .external_lex_state = 2},
  [179] = {.lex_state = 0, .external_lex_state = 2},
  [180] = {.lex_state = 0, .external_lex_state = 2},
  [181] = {.lex_state = 0, .external_lex_state = 2},
  [182] = {.lex_state = 0, .external_lex_state = 2},
  [183] = {.lex_state = 9, .external_lex_state = 2},
  [184] = {.lex_state = 0, .external_lex_state = 2},
  [185] = {.lex_state = 9, .external_lex_state = 2},
  [186] = {.lex_state = 9, .external_lex_state = 2},
  [187] = {.lex_state = 0, .external_lex_state = 4},
  [188] = {.lex_state = 0, .external_lex_state = 5},
  [189] = {.lex_state = 0, .external_lex_state = 4},
  [190] = {.lex_state = 8, .external_lex_state = 2},
  [191] = {.lex_state = 8, .external_lex_state = 2},
  [192] = {.lex_state = 0, .external_lex_state = 2},
  [193] = {.lex_state = 0, .external_lex_state = 2},
  [194] = {.lex_state = 0, .external_lex_state = 6},
  [195] = {.lex_state = 0, .external_lex_state = 2},
  [196] = {.lex_state = 0, .external_lex_state = 2},
  [197] = {.lex_state = 0, .external_lex_state = 2},
  [198] = {.lex_state = 0, .external_lex_state = 2},
  [199] = {.lex_state = 0, .external_lex_state = 2},
  [200] = {.lex_state = 0, .external_lex_state = 2},
  [201] = {.lex_state = 0, .external_lex_state = 2},
  [202] = {.lex_state = 0, .external_lex_state = 2},
  [203] = {.lex_state = 0, .external_lex_state = 2},
  [204] = {.lex_state = 0, .external_lex_state = 2},
  [205] = {.lex_state = 0, .external_lex_state = 2},
  [206] = {.lex_state = 0, .external_lex_state = 2},
  [207] = {.lex_state = 0, .external_lex_state = 2},
  [208] = {.lex_state = 0, .external_lex_state = 2},
  [209] = {.lex_state = 0, .external_lex_state = 2},
  [210] = {.lex_state = 0, .external_lex_state = 2},
  [211] = {.lex_state = 0, .external_lex_state = 7},
  [212] = {.lex_state = 0, .external_lex_state = 2},
  [213] = {.lex_state = 0, .external_lex_state = 2},
  [214] = {.lex_state = 0, .external_lex_state = 2},
  [215] = {.lex_state = 56, .external_lex_state = 2},
  [216] = {.lex_state = 0, .external_lex_state = 2},
  [217] = {.lex_state = 0, .external_lex_state = 2},
  [218] = {.lex_state = 0, .external_lex_state = 2},
  [219] = {.lex_state = 0, .external_lex_state = 2},
  [220] = {.lex_state = 0, .external_lex_state = 2},
  [221] = {.lex_state = 0, .external_lex_state = 2},
  [222] = {.lex_state = 0, .external_lex_state = 2},
  [223] = {.lex_state = 0, .external_lex_state = 7},
  [224] = {.lex_state = 0, .external_lex_state = 2},
  [225] = {.lex_state = 0, .external_lex_state = 2},
  [226] = {.lex_state = 0, .external_lex_state = 2},
  [227] = {.lex_state = 0, .external_lex_state = 2},
  [228] = {.lex_state = 0, .external_lex_state = 2},
  [229] = {.lex_state = 0, .external_lex_state = 2},
  [230] = {.lex_state = 0, .external_lex_state = 2},
  [231] = {.lex_state = 0, .external_lex_state = 2},
  [232] = {(TSStateId)(-1)},
  [233] = {(TSStateId)(-1)},
  [234] = {(TSStateId)(-1)},
};

enum {
  ts_external_token__block_comment_start = 0,
  ts_external_token__block_comment_content = 1,
  ts_external_token__block_comment_end = 2,
  ts_external_token__string_start = 3,
  ts_external_token__string_content = 4,
  ts_external_token__string_end = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__block_comment_start] = sym__block_comment_start,
  [ts_external_token__block_comment_content] = sym__block_comment_content,
  [ts_external_token__block_comment_end] = sym__block_comment_end,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
};

static const bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_comment_content] = true,
    [ts_external_token__block_comment_end] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [2] = {
    [ts_external_token__block_comment_start] = true,
  },
  [3] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__string_start] = true,
  },
  [4] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
  },
  [5] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_comment_content] = true,
    [ts_external_token__block_comment_end] = true,
  },
  [6] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__block_comment_end] = true,
  },
  [7] = {
    [ts_external_token__block_comment_start] = true,
    [ts_external_token__string_end] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [sym__block_comment_start] = ACTIONS(5),
    [sym__block_comment_content] = ACTIONS(1),
    [sym__block_comment_end] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_chunk] = STATE(221),
    [sym_statement] = STATE(132),
    [sym_return_statement] = STATE(214),
    [sym_empty_statement] = STATE(121),
    [sym_assignment_statement] = STATE(121),
    [sym__variable_assignment_varlist] = STATE(193),
    [sym_label_statement] = STATE(121),
    [sym_goto_statement] = STATE(121),
    [sym_do_statement] = STATE(121),
    [sym_while_statement] = STATE(121),
    [sym_repeat_statement] = STATE(121),
    [sym_if_statement] = STATE(121),
    [sym_for_statement] = STATE(121),
    [sym_declaration] = STATE(138),
    [sym_function_declaration] = STATE(139),
    [sym__local_function_declaration] = STATE(140),
    [sym_variable_declaration] = STATE(141),
    [sym__prefix_expression] = STATE(148),
    [sym_variable] = STATE(150),
    [sym_bracket_index_expression] = STATE(3),
    [sym_dot_index_expression] = STATE(3),
    [sym_function_call] = STATE(95),
    [sym_method_index_expression] = STATE(152),
    [sym_parenthesized_expression] = STATE(155),
    [sym_comment] = STATE(1),
    [aux_sym_chunk_repeat1] = STATE(51),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [sym_hash_bang_line] = ACTIONS(11),
    [anon_sym_return] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(15),
    [anon_sym_COLON_COLON] = ACTIONS(17),
    [sym_break_statement] = ACTIONS(19),
    [anon_sym_goto] = ACTIONS(21),
    [anon_sym_do] = ACTIONS(23),
    [anon_sym_while] = ACTIONS(25),
    [anon_sym_repeat] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_function] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(35),
    [anon_sym_LPAREN] = ACTIONS(37),
    [anon_sym_DASH_DASH] = ACTIONS(3),
    [sym__block_comment_start] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(2), 1,
      sym_comment,
    ACTIONS(39), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(41), 26,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [65] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(3), 1,
      sym_comment,
    ACTIONS(43), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(45), 26,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [130] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(4), 1,
      sym_comment,
    ACTIONS(47), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(49), 26,
      anon_sym_return,
      anon_sym_EQ,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [195] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(5), 1,
      sym_comment,
    ACTIONS(55), 2,
      anon_sym_DOT,
      anon_sym_COLON,
    ACTIONS(57), 4,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
    ACTIONS(51), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(53), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [263] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(6), 1,
      sym_comment,
    ACTIONS(59), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(61), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [327] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(7), 1,
      sym_comment,
    ACTIONS(63), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(65), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [391] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(8), 1,
      sym_comment,
    ACTIONS(67), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(69), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [455] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(9), 1,
      sym_comment,
    ACTIONS(71), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(73), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [519] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(10), 1,
      sym_comment,
    ACTIONS(75), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(77), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [583] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(11), 1,
      sym_comment,
    ACTIONS(79), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(81), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [647] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(12), 1,
      sym_comment,
    ACTIONS(83), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(85), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [711] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(13), 1,
      sym_comment,
    ACTIONS(87), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(89), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [775] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(14), 1,
      sym_comment,
    ACTIONS(91), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(93), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [839] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(15), 1,
      sym_comment,
    ACTIONS(95), 25,
      sym__string_start,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(97), 25,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [903] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(16), 1,
      sym_comment,
    ACTIONS(79), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(81), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [962] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(17), 1,
      sym_comment,
    ACTIONS(63), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(65), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1021] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(103), 1,
      anon_sym_and,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(18), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(99), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(101), 17,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      sym_identifier,
  [1106] = 39,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_return,
    ACTIONS(131), 1,
      anon_sym_end,
    ACTIONS(133), 1,
      anon_sym_elseif,
    ACTIONS(135), 1,
      anon_sym_else,
    STATE(19), 1,
      sym_comment,
    STATE(37), 1,
      aux_sym_chunk_repeat1,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(156), 1,
      sym__block,
    STATE(157), 1,
      aux_sym_if_statement_repeat1,
    STATE(166), 1,
      sym_return_statement,
    STATE(178), 1,
      sym_elseif_statement,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(222), 1,
      sym_else_statement,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [1233] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(20), 1,
      sym_comment,
    ACTIONS(99), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(101), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1294] = 17,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(21), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(99), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(101), 18,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      sym_identifier,
  [1377] = 15,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(22), 1,
      sym_comment,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(99), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(101), 20,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      sym_identifier,
  [1456] = 13,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_comment,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(99), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(101), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1531] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(24), 1,
      sym_comment,
    ACTIONS(137), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(139), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1592] = 12,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(25), 1,
      sym_comment,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(99), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(101), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1665] = 11,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(26), 1,
      sym_comment,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(99), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(101), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1736] = 11,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(27), 1,
      sym_comment,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(99), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(101), 21,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      sym_identifier,
  [1807] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(28), 1,
      sym_comment,
    ACTIONS(75), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(77), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1866] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(29), 1,
      sym_comment,
    ACTIONS(51), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(53), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1925] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(30), 1,
      sym_comment,
    ACTIONS(99), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
    ACTIONS(101), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [1986] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(31), 1,
      sym_comment,
    ACTIONS(141), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(143), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2045] = 14,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(32), 1,
      sym_comment,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(99), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
    ACTIONS(101), 20,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      sym_identifier,
  [2122] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(33), 1,
      sym_comment,
    ACTIONS(71), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(73), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2181] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(34), 1,
      sym_comment,
    ACTIONS(145), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(147), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2240] = 8,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(127), 1,
      anon_sym_CARET,
    STATE(35), 1,
      sym_comment,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(99), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_DOT_DOT,
    ACTIONS(101), 22,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      sym_identifier,
  [2305] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(36), 1,
      sym_comment,
    ACTIONS(149), 22,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
    ACTIONS(151), 23,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_then,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
  [2364] = 33,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_return,
    STATE(37), 1,
      sym_comment,
    STATE(38), 1,
      aux_sym_chunk_repeat1,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(167), 1,
      sym_return_statement,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(153), 4,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2476] = 31,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(155), 1,
      ts_builtin_sym_end,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(162), 1,
      anon_sym_SEMI,
    ACTIONS(165), 1,
      anon_sym_COLON_COLON,
    ACTIONS(168), 1,
      sym_break_statement,
    ACTIONS(171), 1,
      anon_sym_goto,
    ACTIONS(174), 1,
      anon_sym_do,
    ACTIONS(177), 1,
      anon_sym_while,
    ACTIONS(180), 1,
      anon_sym_repeat,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(186), 1,
      anon_sym_for,
    ACTIONS(189), 1,
      anon_sym_function,
    ACTIONS(192), 1,
      anon_sym_local,
    ACTIONS(195), 1,
      anon_sym_LPAREN,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(38), 2,
      sym_comment,
      aux_sym_chunk_repeat1,
    ACTIONS(160), 5,
      anon_sym_return,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2584] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_return,
    STATE(37), 1,
      aux_sym_chunk_repeat1,
    STATE(39), 1,
      sym_comment,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(166), 1,
      sym_return_statement,
    STATE(176), 1,
      sym__block,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(198), 3,
      anon_sym_end,
      anon_sym_elseif,
      anon_sym_else,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2698] = 21,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(103), 1,
      anon_sym_and,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(204), 1,
      anon_sym_COMMA,
    ACTIONS(206), 1,
      anon_sym_or,
    STATE(40), 1,
      sym_comment,
    STATE(113), 1,
      aux_sym__variable_assignment_explist_repeat1,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(200), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(202), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [2786] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(103), 1,
      anon_sym_and,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(206), 1,
      anon_sym_or,
    STATE(41), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(208), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(210), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [2869] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_return,
    ACTIONS(212), 1,
      anon_sym_end,
    STATE(37), 1,
      aux_sym_chunk_repeat1,
    STATE(42), 1,
      sym_comment,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(166), 1,
      sym_return_statement,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(200), 1,
      sym__block,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [2981] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_return,
    ACTIONS(214), 1,
      anon_sym_end,
    STATE(37), 1,
      aux_sym_chunk_repeat1,
    STATE(43), 1,
      sym_comment,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(166), 1,
      sym_return_statement,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(213), 1,
      sym__block,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3093] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_return,
    ACTIONS(216), 1,
      anon_sym_until,
    STATE(37), 1,
      aux_sym_chunk_repeat1,
    STATE(44), 1,
      sym_comment,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(166), 1,
      sym_return_statement,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(197), 1,
      sym__block,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3205] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(103), 1,
      anon_sym_and,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(206), 1,
      anon_sym_or,
    STATE(45), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(218), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(220), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [3287] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_return,
    ACTIONS(222), 1,
      anon_sym_end,
    STATE(37), 1,
      aux_sym_chunk_repeat1,
    STATE(46), 1,
      sym_comment,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(166), 1,
      sym_return_statement,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(208), 1,
      sym__block,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3399] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_return,
    ACTIONS(224), 1,
      anon_sym_end,
    STATE(37), 1,
      aux_sym_chunk_repeat1,
    STATE(47), 1,
      sym_comment,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(166), 1,
      sym_return_statement,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(231), 1,
      sym__block,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3511] = 34,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_return,
    ACTIONS(226), 1,
      anon_sym_end,
    STATE(37), 1,
      aux_sym_chunk_repeat1,
    STATE(48), 1,
      sym_comment,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(166), 1,
      sym_return_statement,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(196), 1,
      sym__block,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3623] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(103), 1,
      anon_sym_and,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(206), 1,
      anon_sym_or,
    STATE(49), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(228), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(230), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [3705] = 33,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(232), 1,
      ts_builtin_sym_end,
    STATE(38), 1,
      aux_sym_chunk_repeat1,
    STATE(50), 1,
      sym_comment,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(218), 1,
      sym_return_statement,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3814] = 33,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(234), 1,
      ts_builtin_sym_end,
    STATE(38), 1,
      aux_sym_chunk_repeat1,
    STATE(51), 1,
      sym_comment,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(219), 1,
      sym_return_statement,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [3923] = 33,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(13), 1,
      anon_sym_return,
    ACTIONS(15), 1,
      anon_sym_SEMI,
    ACTIONS(17), 1,
      anon_sym_COLON_COLON,
    ACTIONS(19), 1,
      sym_break_statement,
    ACTIONS(21), 1,
      anon_sym_goto,
    ACTIONS(23), 1,
      anon_sym_do,
    ACTIONS(25), 1,
      anon_sym_while,
    ACTIONS(27), 1,
      anon_sym_repeat,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_for,
    ACTIONS(33), 1,
      anon_sym_function,
    ACTIONS(35), 1,
      anon_sym_local,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(234), 1,
      ts_builtin_sym_end,
    STATE(50), 1,
      aux_sym_chunk_repeat1,
    STATE(52), 1,
      sym_comment,
    STATE(95), 1,
      sym_function_call,
    STATE(132), 1,
      sym_statement,
    STATE(138), 1,
      sym_declaration,
    STATE(139), 1,
      sym_function_declaration,
    STATE(140), 1,
      sym__local_function_declaration,
    STATE(141), 1,
      sym_variable_declaration,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(150), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(155), 1,
      sym_parenthesized_expression,
    STATE(193), 1,
      sym__variable_assignment_varlist,
    STATE(219), 1,
      sym_return_statement,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(121), 9,
      sym_empty_statement,
      sym_assignment_statement,
      sym_label_statement,
      sym_goto_statement,
      sym_do_statement,
      sym_while_statement,
      sym_repeat_statement,
      sym_if_statement,
      sym_for_statement,
  [4032] = 21,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_SEMI,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(53), 1,
      sym_comment,
    STATE(59), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(154), 1,
      sym__expression_list,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    ACTIONS(238), 4,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_else,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4111] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    ACTIONS(254), 1,
      sym_identifier,
    ACTIONS(256), 1,
      anon_sym_LBRACK,
    ACTIONS(258), 1,
      anon_sym_RBRACE,
    STATE(54), 1,
      sym_comment,
    STATE(94), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(161), 1,
      sym_field,
    STATE(224), 1,
      sym__field_list,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4190] = 22,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    ACTIONS(254), 1,
      sym_identifier,
    ACTIONS(256), 1,
      anon_sym_LBRACK,
    ACTIONS(260), 1,
      anon_sym_RBRACE,
    STATE(55), 1,
      sym_comment,
    STATE(94), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(161), 1,
      sym_field,
    STATE(209), 1,
      sym__field_list,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4269] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(262), 1,
      anon_sym_EQ,
    STATE(56), 1,
      sym_comment,
    ACTIONS(45), 6,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_DASH,
      anon_sym_SLASH,
    ACTIONS(43), 24,
      sym__string_start,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_or,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT_DOT,
      anon_sym_CARET,
  [4316] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(266), 1,
      anon_sym_else,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    STATE(57), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(264), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_do,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [4388] = 21,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    ACTIONS(254), 1,
      sym_identifier,
    ACTIONS(256), 1,
      anon_sym_LBRACK,
    ACTIONS(272), 1,
      anon_sym_RBRACE,
    STATE(58), 1,
      sym_comment,
    STATE(94), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(172), 1,
      sym_field,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4464] = 21,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(276), 1,
      anon_sym_COMMA,
    ACTIONS(278), 1,
      anon_sym_else,
    STATE(59), 1,
      sym_comment,
    STATE(147), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(274), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_do,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [4540] = 21,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(236), 1,
      anon_sym_SEMI,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    ACTIONS(280), 1,
      ts_builtin_sym_end,
    STATE(59), 1,
      sym_expression,
    STATE(60), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(154), 1,
      sym__expression_list,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4616] = 21,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    ACTIONS(254), 1,
      sym_identifier,
    ACTIONS(256), 1,
      anon_sym_LBRACK,
    ACTIONS(282), 1,
      anon_sym_RBRACE,
    STATE(61), 1,
      sym_comment,
    STATE(94), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(172), 1,
      sym_field,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4692] = 20,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    ACTIONS(254), 1,
      sym_identifier,
    ACTIONS(256), 1,
      anon_sym_LBRACK,
    STATE(62), 1,
      sym_comment,
    STATE(94), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(172), 1,
      sym_field,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4765] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(59), 1,
      sym_expression,
    STATE(63), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(226), 1,
      sym__expression_list,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4835] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(40), 1,
      sym_expression,
    STATE(64), 1,
      sym_comment,
    STATE(128), 1,
      sym__variable_assignment_explist,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4905] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(40), 1,
      sym_expression,
    STATE(65), 1,
      sym_comment,
    STATE(126), 1,
      sym__variable_assignment_explist,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [4975] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    ACTIONS(284), 1,
      anon_sym_RPAREN,
    STATE(66), 1,
      sym_comment,
    STATE(96), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5045] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(67), 1,
      sym_comment,
    STATE(108), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5112] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(35), 1,
      sym_expression,
    STATE(68), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5179] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(45), 1,
      sym_expression,
    STATE(69), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5246] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(70), 1,
      sym_comment,
    STATE(111), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5313] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(71), 1,
      sym_comment,
    STATE(110), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5380] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(72), 1,
      sym_comment,
    STATE(103), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5447] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(73), 1,
      sym_comment,
    STATE(97), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5514] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(74), 1,
      sym_comment,
    STATE(107), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5581] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(75), 1,
      sym_comment,
    STATE(105), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5648] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(30), 1,
      sym_expression,
    STATE(76), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5715] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(27), 1,
      sym_expression,
    STATE(77), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5782] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(41), 1,
      sym_expression,
    STATE(78), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5849] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(20), 1,
      sym_expression,
    STATE(79), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5916] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(18), 1,
      sym_expression,
    STATE(80), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [5983] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(26), 1,
      sym_expression,
    STATE(81), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6050] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(25), 1,
      sym_expression,
    STATE(82), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6117] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(83), 1,
      sym_comment,
    STATE(106), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6184] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(23), 1,
      sym_expression,
    STATE(84), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6251] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(32), 1,
      sym_expression,
    STATE(85), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6318] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(22), 1,
      sym_expression,
    STATE(86), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6385] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(24), 1,
      sym_expression,
    STATE(87), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6452] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(88), 1,
      sym_comment,
    STATE(100), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6519] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(21), 1,
      sym_expression,
    STATE(89), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6586] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(90), 1,
      sym_comment,
    STATE(109), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6653] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(91), 1,
      sym_comment,
    STATE(99), 1,
      sym_expression,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6720] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(49), 1,
      sym_expression,
    STATE(92), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6787] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(240), 1,
      anon_sym_function,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(252), 1,
      sym__string_start,
    STATE(57), 1,
      sym_expression,
    STATE(93), 1,
      sym_comment,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(152), 1,
      sym_method_index_expression,
    ACTIONS(244), 2,
      sym_number,
      sym_vararg_expression,
    ACTIONS(248), 2,
      anon_sym_TILDE,
      anon_sym_POUND,
    ACTIONS(250), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    ACTIONS(242), 3,
      sym_nil,
      sym_false,
      sym_true,
    STATE(5), 3,
      sym_variable,
      sym_function_call,
      sym_parenthesized_expression,
    STATE(29), 5,
      sym_string,
      sym_function_definition,
      sym_table_constructor,
      sym_binary_expression,
      sym_unary_expression,
  [6854] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    STATE(94), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(286), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [6918] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(55), 1,
      anon_sym_COLON,
    STATE(95), 1,
      sym_comment,
    ACTIONS(288), 3,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
    ACTIONS(57), 5,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
    ACTIONS(290), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [6960] = 20,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(276), 1,
      anon_sym_COMMA,
    ACTIONS(292), 1,
      anon_sym_RPAREN,
    STATE(96), 1,
      sym_comment,
    STATE(180), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7028] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    STATE(97), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(294), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7092] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(300), 1,
      anon_sym_COMMA,
    STATE(98), 2,
      sym_comment,
      aux_sym__name_list_repeat1,
    ACTIONS(296), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(298), 16,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_in,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7132] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    STATE(99), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(303), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7196] = 19,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(305), 1,
      anon_sym_COMMA,
    ACTIONS(307), 1,
      anon_sym_do,
    STATE(100), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7261] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(101), 1,
      sym_comment,
    ACTIONS(309), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(311), 16,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_in,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7298] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(317), 1,
      anon_sym_COMMA,
    STATE(98), 1,
      aux_sym__name_list_repeat1,
    STATE(102), 1,
      sym_comment,
    ACTIONS(313), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(315), 16,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_in,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7339] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(319), 1,
      anon_sym_then,
    STATE(103), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7401] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(317), 1,
      anon_sym_COMMA,
    STATE(102), 1,
      aux_sym__name_list_repeat1,
    STATE(104), 1,
      sym_comment,
    ACTIONS(321), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(323), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7441] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(325), 1,
      anon_sym_then,
    STATE(105), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7503] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(327), 1,
      anon_sym_COMMA,
    STATE(106), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7565] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(329), 1,
      anon_sym_RBRACK,
    STATE(107), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7627] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(331), 1,
      anon_sym_RBRACK,
    STATE(108), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7689] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(333), 1,
      anon_sym_do,
    STATE(109), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7751] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(335), 1,
      anon_sym_RPAREN,
    STATE(110), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7813] = 18,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(109), 1,
      anon_sym_PIPE,
    ACTIONS(111), 1,
      anon_sym_TILDE,
    ACTIONS(113), 1,
      anon_sym_AMP,
    ACTIONS(117), 1,
      anon_sym_PLUS,
    ACTIONS(119), 1,
      anon_sym_DASH,
    ACTIONS(123), 1,
      anon_sym_SLASH,
    ACTIONS(125), 1,
      anon_sym_DOT_DOT,
    ACTIONS(127), 1,
      anon_sym_CARET,
    ACTIONS(268), 1,
      anon_sym_or,
    ACTIONS(270), 1,
      anon_sym_and,
    ACTIONS(337), 1,
      anon_sym_do,
    STATE(111), 1,
      sym_comment,
    ACTIONS(105), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(115), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(121), 3,
      anon_sym_STAR,
      anon_sym_SLASH_SLASH,
      anon_sym_PERCENT,
    ACTIONS(107), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [7875] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(343), 1,
      anon_sym_COMMA,
    STATE(112), 2,
      sym_comment,
      aux_sym__variable_assignment_explist_repeat1,
    ACTIONS(339), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(341), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7912] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(204), 1,
      anon_sym_COMMA,
    STATE(112), 1,
      aux_sym__variable_assignment_explist_repeat1,
    STATE(113), 1,
      sym_comment,
    ACTIONS(346), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(348), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7951] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(354), 1,
      anon_sym_EQ,
    STATE(114), 1,
      sym_comment,
    ACTIONS(350), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(352), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [7987] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(115), 1,
      sym_comment,
    ACTIONS(356), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(358), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8020] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(116), 1,
      sym_comment,
    ACTIONS(360), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(362), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8053] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(117), 1,
      sym_comment,
    ACTIONS(364), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(366), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8086] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(118), 1,
      sym_comment,
    ACTIONS(368), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(370), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8119] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(119), 1,
      sym_comment,
    ACTIONS(372), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(374), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8152] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(120), 1,
      sym_comment,
    ACTIONS(376), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(378), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8185] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(121), 1,
      sym_comment,
    ACTIONS(288), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(290), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8218] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(122), 1,
      sym_comment,
    ACTIONS(380), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(382), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8251] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(123), 1,
      sym_comment,
    ACTIONS(384), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(386), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8284] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(124), 1,
      sym_comment,
    ACTIONS(388), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(390), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8317] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(125), 1,
      sym_comment,
    ACTIONS(392), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(394), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8350] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(126), 1,
      sym_comment,
    ACTIONS(396), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(398), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8383] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(127), 1,
      sym_comment,
    ACTIONS(400), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(402), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8416] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(128), 1,
      sym_comment,
    ACTIONS(404), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(406), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8449] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(129), 1,
      sym_comment,
    ACTIONS(408), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(410), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8482] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(130), 1,
      sym_comment,
    ACTIONS(412), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(414), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8515] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(131), 1,
      sym_comment,
    ACTIONS(416), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(418), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8548] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(132), 1,
      sym_comment,
    ACTIONS(420), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(422), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8581] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(133), 1,
      sym_comment,
    ACTIONS(424), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(426), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8614] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(134), 1,
      sym_comment,
    ACTIONS(428), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(430), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8647] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(135), 1,
      sym_comment,
    ACTIONS(432), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(434), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8680] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(136), 1,
      sym_comment,
    ACTIONS(436), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(438), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8713] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(137), 1,
      sym_comment,
    ACTIONS(440), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(442), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8746] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(138), 1,
      sym_comment,
    ACTIONS(444), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(446), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8779] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(139), 1,
      sym_comment,
    ACTIONS(448), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(450), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8812] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(140), 1,
      sym_comment,
    ACTIONS(452), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(454), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8845] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(141), 1,
      sym_comment,
    ACTIONS(456), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(458), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8878] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(142), 1,
      sym_comment,
    ACTIONS(460), 4,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(462), 15,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_until,
      anon_sym_if,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8911] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(143), 1,
      sym_comment,
    ACTIONS(464), 7,
      anon_sym_function,
      sym_nil,
      sym_false,
      sym_true,
      anon_sym_DASH,
      anon_sym_not,
      sym_identifier,
    ACTIONS(466), 9,
      sym__string_start,
      sym_number,
      sym_vararg_expression,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_POUND,
  [8941] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(144), 1,
      sym_comment,
    ACTIONS(470), 3,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(468), 12,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_if,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8970] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(145), 1,
      sym_comment,
    ACTIONS(474), 3,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
    ACTIONS(472), 12,
      anon_sym_return,
      sym_break_statement,
      anon_sym_goto,
      anon_sym_do,
      anon_sym_end,
      anon_sym_while,
      anon_sym_repeat,
      anon_sym_if,
      anon_sym_for,
      anon_sym_function,
      anon_sym_local,
      sym_identifier,
  [8999] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(266), 1,
      anon_sym_else,
    ACTIONS(476), 1,
      anon_sym_COMMA,
    STATE(146), 2,
      sym_comment,
      aux_sym__expression_list_repeat1,
    ACTIONS(264), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_do,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
      anon_sym_RPAREN,
  [9025] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(276), 1,
      anon_sym_COMMA,
    ACTIONS(481), 1,
      anon_sym_else,
    STATE(146), 1,
      aux_sym__expression_list_repeat1,
    STATE(147), 1,
      sym_comment,
    ACTIONS(479), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_do,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9052] = 11,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(483), 1,
      anon_sym_DOT,
    ACTIONS(485), 1,
      anon_sym_COLON,
    ACTIONS(487), 1,
      anon_sym_LPAREN,
    ACTIONS(489), 1,
      anon_sym_LBRACK,
    ACTIONS(491), 1,
      anon_sym_LBRACE,
    ACTIONS(493), 1,
      sym__string_start,
    STATE(12), 1,
      sym_arguments,
    STATE(148), 1,
      sym_comment,
    STATE(13), 2,
      sym_string,
      sym_table_constructor,
  [9087] = 10,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(37), 1,
      anon_sym_LPAREN,
    ACTIONS(495), 1,
      sym_identifier,
    STATE(148), 1,
      sym__prefix_expression,
    STATE(149), 1,
      sym_comment,
    STATE(151), 1,
      sym_variable,
    STATE(152), 1,
      sym_method_index_expression,
    STATE(3), 2,
      sym_bracket_index_expression,
      sym_dot_index_expression,
    STATE(155), 2,
      sym_function_call,
      sym_parenthesized_expression,
  [9120] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(497), 1,
      anon_sym_EQ,
    ACTIONS(499), 1,
      anon_sym_COMMA,
    STATE(150), 1,
      sym_comment,
    STATE(181), 1,
      aux_sym__variable_assignment_varlist_repeat1,
    ACTIONS(57), 6,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [9147] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(151), 1,
      sym_comment,
    ACTIONS(501), 2,
      anon_sym_EQ,
      anon_sym_COMMA,
    ACTIONS(57), 6,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [9169] = 8,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(487), 1,
      anon_sym_LPAREN,
    ACTIONS(491), 1,
      anon_sym_LBRACE,
    ACTIONS(493), 1,
      sym__string_start,
    STATE(12), 1,
      sym_arguments,
    STATE(152), 1,
      sym_comment,
    STATE(13), 2,
      sym_string,
      sym_table_constructor,
  [9195] = 9,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(135), 1,
      anon_sym_else,
    ACTIONS(503), 1,
      anon_sym_end,
    ACTIONS(505), 1,
      anon_sym_elseif,
    STATE(153), 1,
      sym_comment,
    STATE(158), 1,
      aux_sym_if_statement_repeat1,
    STATE(178), 1,
      sym_elseif_statement,
    STATE(217), 1,
      sym_else_statement,
  [9223] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(509), 1,
      anon_sym_SEMI,
    ACTIONS(511), 1,
      anon_sym_else,
    STATE(154), 1,
      sym_comment,
    ACTIONS(507), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9245] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(155), 1,
      sym_comment,
    ACTIONS(57), 6,
      sym__string_start,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
  [9263] = 9,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(135), 1,
      anon_sym_else,
    ACTIONS(505), 1,
      anon_sym_elseif,
    ACTIONS(513), 1,
      anon_sym_end,
    STATE(153), 1,
      aux_sym_if_statement_repeat1,
    STATE(156), 1,
      sym_comment,
    STATE(178), 1,
      sym_elseif_statement,
    STATE(201), 1,
      sym_else_statement,
  [9291] = 9,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(135), 1,
      anon_sym_else,
    ACTIONS(505), 1,
      anon_sym_elseif,
    ACTIONS(515), 1,
      anon_sym_end,
    STATE(157), 1,
      sym_comment,
    STATE(158), 1,
      aux_sym_if_statement_repeat1,
    STATE(178), 1,
      sym_elseif_statement,
    STATE(203), 1,
      sym_else_statement,
  [9319] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(517), 1,
      anon_sym_end,
    ACTIONS(519), 1,
      anon_sym_elseif,
    ACTIONS(522), 1,
      anon_sym_else,
    STATE(178), 1,
      sym_elseif_statement,
    STATE(158), 2,
      sym_comment,
      aux_sym_if_statement_repeat1,
  [9342] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(527), 1,
      anon_sym_RBRACE,
    STATE(62), 1,
      sym__field_sep,
    ACTIONS(524), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    STATE(159), 2,
      sym_comment,
      aux_sym__field_list_repeat1,
  [9363] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(272), 1,
      anon_sym_RBRACE,
    STATE(61), 1,
      sym__field_sep,
    STATE(159), 1,
      aux_sym__field_list_repeat1,
    STATE(160), 1,
      sym_comment,
    ACTIONS(529), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [9386] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(531), 1,
      anon_sym_RBRACE,
    STATE(58), 1,
      sym__field_sep,
    STATE(160), 1,
      aux_sym__field_list_repeat1,
    STATE(161), 1,
      sym_comment,
    ACTIONS(529), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [9409] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(535), 1,
      anon_sym_else,
    STATE(162), 1,
      sym_comment,
    ACTIONS(533), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9428] = 8,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(537), 1,
      sym_identifier,
    STATE(163), 1,
      sym_comment,
    STATE(183), 1,
      sym__function_name_prefix_expression,
    STATE(184), 1,
      sym__function_name,
    STATE(185), 1,
      sym__function_name_dot_index_expression,
    STATE(192), 1,
      sym__function_name_method_index_expression,
  [9453] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(511), 1,
      anon_sym_else,
    STATE(164), 1,
      sym_comment,
    ACTIONS(507), 4,
      ts_builtin_sym_end,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9472] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(317), 1,
      anon_sym_COMMA,
    ACTIONS(321), 1,
      anon_sym_in,
    ACTIONS(539), 1,
      anon_sym_EQ,
    STATE(102), 1,
      aux_sym__name_list_repeat1,
    STATE(165), 1,
      sym_comment,
  [9494] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(153), 1,
      anon_sym_else,
    STATE(166), 1,
      sym_comment,
    ACTIONS(541), 3,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9512] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(545), 1,
      anon_sym_else,
    STATE(167), 1,
      sym_comment,
    ACTIONS(543), 3,
      anon_sym_end,
      anon_sym_until,
      anon_sym_elseif,
  [9530] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(547), 1,
      sym_identifier,
    ACTIONS(549), 1,
      sym_vararg_expression,
    ACTIONS(551), 1,
      anon_sym_RPAREN,
    STATE(168), 1,
      sym_comment,
    STATE(212), 1,
      sym__parameter_list,
  [9552] = 7,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(553), 1,
      sym_identifier,
    ACTIONS(555), 1,
      anon_sym_function,
    STATE(114), 1,
      sym__name_list,
    STATE(137), 1,
      sym__local_variable_assignment,
    STATE(169), 1,
      sym_comment,
  [9574] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(557), 1,
      sym_identifier,
    STATE(170), 1,
      sym_comment,
    STATE(199), 1,
      sym__name_list,
    STATE(198), 2,
      sym_for_generic_clause,
      sym_for_numeric_clause,
  [9594] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(559), 1,
      anon_sym_LPAREN,
    STATE(31), 1,
      sym__function_body,
    STATE(46), 1,
      sym_parameters,
    STATE(171), 1,
      sym_comment,
  [9613] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(172), 1,
      sym_comment,
    ACTIONS(527), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [9628] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(559), 1,
      anon_sym_LPAREN,
    STATE(46), 1,
      sym_parameters,
    STATE(118), 1,
      sym__function_body,
    STATE(173), 1,
      sym_comment,
  [9647] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(174), 1,
      sym_comment,
    ACTIONS(561), 3,
      sym__string_start,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
  [9662] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(175), 1,
      sym_comment,
    ACTIONS(563), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [9677] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(567), 1,
      anon_sym_else,
    STATE(176), 1,
      sym_comment,
    ACTIONS(565), 2,
      anon_sym_end,
      anon_sym_elseif,
  [9694] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(569), 1,
      anon_sym_EQ,
    ACTIONS(571), 1,
      anon_sym_COMMA,
    STATE(177), 2,
      sym_comment,
      aux_sym__variable_assignment_varlist_repeat1,
  [9711] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(576), 1,
      anon_sym_else,
    STATE(178), 1,
      sym_comment,
    ACTIONS(574), 2,
      anon_sym_end,
      anon_sym_elseif,
  [9728] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(578), 1,
      anon_sym_COMMA,
    ACTIONS(580), 1,
      anon_sym_RPAREN,
    STATE(179), 1,
      sym_comment,
    STATE(182), 1,
      aux_sym__name_list_repeat1,
  [9747] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(276), 1,
      anon_sym_COMMA,
    ACTIONS(582), 1,
      anon_sym_RPAREN,
    STATE(146), 1,
      aux_sym__expression_list_repeat1,
    STATE(180), 1,
      sym_comment,
  [9766] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(499), 1,
      anon_sym_COMMA,
    ACTIONS(584), 1,
      anon_sym_EQ,
    STATE(177), 1,
      aux_sym__variable_assignment_varlist_repeat1,
    STATE(181), 1,
      sym_comment,
  [9785] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(586), 1,
      anon_sym_COMMA,
    ACTIONS(588), 1,
      anon_sym_RPAREN,
    STATE(98), 1,
      aux_sym__name_list_repeat1,
    STATE(182), 1,
      sym_comment,
  [9804] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(590), 1,
      anon_sym_DOT,
    ACTIONS(592), 1,
      anon_sym_COLON,
    ACTIONS(594), 1,
      anon_sym_LPAREN,
    STATE(183), 1,
      sym_comment,
  [9823] = 6,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(559), 1,
      anon_sym_LPAREN,
    STATE(46), 1,
      sym_parameters,
    STATE(120), 1,
      sym__function_body,
    STATE(184), 1,
      sym_comment,
  [9842] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(185), 1,
      sym_comment,
    ACTIONS(596), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [9857] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    STATE(186), 1,
      sym_comment,
    ACTIONS(598), 3,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_LPAREN,
  [9872] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(600), 1,
      sym__string_content,
    ACTIONS(602), 1,
      sym__string_end,
    STATE(187), 1,
      sym_comment,
  [9888] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(604), 1,
      sym__block_comment_content,
    ACTIONS(606), 1,
      sym__block_comment_end,
    STATE(188), 1,
      sym_comment,
  [9904] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(608), 1,
      sym__string_content,
    ACTIONS(610), 1,
      sym__string_end,
    STATE(189), 1,
      sym_comment,
  [9920] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(614), 1,
      sym_vararg_expression,
    STATE(190), 1,
      sym_comment,
  [9936] = 5,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(612), 1,
      sym_identifier,
    ACTIONS(616), 1,
      sym_vararg_expression,
    STATE(191), 1,
      sym_comment,
  [9952] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(618), 1,
      anon_sym_LPAREN,
    STATE(192), 1,
      sym_comment,
  [9965] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(620), 1,
      anon_sym_EQ,
    STATE(193), 1,
      sym_comment,
  [9978] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(622), 1,
      sym__block_comment_end,
    STATE(194), 1,
      sym_comment,
  [9991] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(624), 1,
      anon_sym_EQ,
    STATE(195), 1,
      sym_comment,
  [10004] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(626), 1,
      anon_sym_end,
    STATE(196), 1,
      sym_comment,
  [10017] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(628), 1,
      anon_sym_until,
    STATE(197), 1,
      sym_comment,
  [10030] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(630), 1,
      anon_sym_do,
    STATE(198), 1,
      sym_comment,
  [10043] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(632), 1,
      anon_sym_in,
    STATE(199), 1,
      sym_comment,
  [10056] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(634), 1,
      anon_sym_end,
    STATE(200), 1,
      sym_comment,
  [10069] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(636), 1,
      anon_sym_end,
    STATE(201), 1,
      sym_comment,
  [10082] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(638), 1,
      anon_sym_COLON_COLON,
    STATE(202), 1,
      sym_comment,
  [10095] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(640), 1,
      anon_sym_end,
    STATE(203), 1,
      sym_comment,
  [10108] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(642), 1,
      sym_identifier,
    STATE(204), 1,
      sym_comment,
  [10121] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(644), 1,
      sym_identifier,
    STATE(205), 1,
      sym_comment,
  [10134] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(646), 1,
      sym_identifier,
    STATE(206), 1,
      sym_comment,
  [10147] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(612), 1,
      sym_identifier,
    STATE(207), 1,
      sym_comment,
  [10160] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(648), 1,
      anon_sym_end,
    STATE(208), 1,
      sym_comment,
  [10173] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(650), 1,
      anon_sym_RBRACE,
    STATE(209), 1,
      sym_comment,
  [10186] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(652), 1,
      anon_sym_RPAREN,
    STATE(210), 1,
      sym_comment,
  [10199] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(654), 1,
      sym__string_end,
    STATE(211), 1,
      sym_comment,
  [10212] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(656), 1,
      anon_sym_RPAREN,
    STATE(212), 1,
      sym_comment,
  [10225] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(658), 1,
      anon_sym_end,
    STATE(213), 1,
      sym_comment,
  [10238] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(234), 1,
      ts_builtin_sym_end,
    STATE(214), 1,
      sym_comment,
  [10251] = 4,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(660), 1,
      anon_sym_DASH_DASH,
    ACTIONS(662), 1,
      aux_sym_comment_token1,
    STATE(215), 1,
      sym_comment,
  [10264] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(664), 1,
      anon_sym_RPAREN,
    STATE(216), 1,
      sym_comment,
  [10277] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(666), 1,
      anon_sym_end,
    STATE(217), 1,
      sym_comment,
  [10290] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(668), 1,
      ts_builtin_sym_end,
    STATE(218), 1,
      sym_comment,
  [10303] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(232), 1,
      ts_builtin_sym_end,
    STATE(219), 1,
      sym_comment,
  [10316] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(670), 1,
      anon_sym_RPAREN,
    STATE(220), 1,
      sym_comment,
  [10329] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(672), 1,
      ts_builtin_sym_end,
    STATE(221), 1,
      sym_comment,
  [10342] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(674), 1,
      anon_sym_end,
    STATE(222), 1,
      sym_comment,
  [10355] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(676), 1,
      sym__string_end,
    STATE(223), 1,
      sym_comment,
  [10368] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(678), 1,
      anon_sym_RBRACE,
    STATE(224), 1,
      sym_comment,
  [10381] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(680), 1,
      anon_sym_LPAREN,
    STATE(225), 1,
      sym_comment,
  [10394] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(682), 1,
      anon_sym_do,
    STATE(226), 1,
      sym_comment,
  [10407] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(684), 1,
      sym_identifier,
    STATE(227), 1,
      sym_comment,
  [10420] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(686), 1,
      sym_identifier,
    STATE(228), 1,
      sym_comment,
  [10433] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(688), 1,
      sym_identifier,
    STATE(229), 1,
      sym_comment,
  [10446] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(690), 1,
      sym_identifier,
    STATE(230), 1,
      sym_comment,
  [10459] = 4,
    ACTIONS(3), 1,
      anon_sym_DASH_DASH,
    ACTIONS(5), 1,
      sym__block_comment_start,
    ACTIONS(692), 1,
      anon_sym_end,
    STATE(231), 1,
      sym_comment,
  [10472] = 1,
    ACTIONS(694), 1,
      ts_builtin_sym_end,
  [10476] = 1,
    ACTIONS(696), 1,
      ts_builtin_sym_end,
  [10480] = 1,
    ACTIONS(698), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 65,
  [SMALL_STATE(4)] = 130,
  [SMALL_STATE(5)] = 195,
  [SMALL_STATE(6)] = 263,
  [SMALL_STATE(7)] = 327,
  [SMALL_STATE(8)] = 391,
  [SMALL_STATE(9)] = 455,
  [SMALL_STATE(10)] = 519,
  [SMALL_STATE(11)] = 583,
  [SMALL_STATE(12)] = 647,
  [SMALL_STATE(13)] = 711,
  [SMALL_STATE(14)] = 775,
  [SMALL_STATE(15)] = 839,
  [SMALL_STATE(16)] = 903,
  [SMALL_STATE(17)] = 962,
  [SMALL_STATE(18)] = 1021,
  [SMALL_STATE(19)] = 1106,
  [SMALL_STATE(20)] = 1233,
  [SMALL_STATE(21)] = 1294,
  [SMALL_STATE(22)] = 1377,
  [SMALL_STATE(23)] = 1456,
  [SMALL_STATE(24)] = 1531,
  [SMALL_STATE(25)] = 1592,
  [SMALL_STATE(26)] = 1665,
  [SMALL_STATE(27)] = 1736,
  [SMALL_STATE(28)] = 1807,
  [SMALL_STATE(29)] = 1866,
  [SMALL_STATE(30)] = 1925,
  [SMALL_STATE(31)] = 1986,
  [SMALL_STATE(32)] = 2045,
  [SMALL_STATE(33)] = 2122,
  [SMALL_STATE(34)] = 2181,
  [SMALL_STATE(35)] = 2240,
  [SMALL_STATE(36)] = 2305,
  [SMALL_STATE(37)] = 2364,
  [SMALL_STATE(38)] = 2476,
  [SMALL_STATE(39)] = 2584,
  [SMALL_STATE(40)] = 2698,
  [SMALL_STATE(41)] = 2786,
  [SMALL_STATE(42)] = 2869,
  [SMALL_STATE(43)] = 2981,
  [SMALL_STATE(44)] = 3093,
  [SMALL_STATE(45)] = 3205,
  [SMALL_STATE(46)] = 3287,
  [SMALL_STATE(47)] = 3399,
  [SMALL_STATE(48)] = 3511,
  [SMALL_STATE(49)] = 3623,
  [SMALL_STATE(50)] = 3705,
  [SMALL_STATE(51)] = 3814,
  [SMALL_STATE(52)] = 3923,
  [SMALL_STATE(53)] = 4032,
  [SMALL_STATE(54)] = 4111,
  [SMALL_STATE(55)] = 4190,
  [SMALL_STATE(56)] = 4269,
  [SMALL_STATE(57)] = 4316,
  [SMALL_STATE(58)] = 4388,
  [SMALL_STATE(59)] = 4464,
  [SMALL_STATE(60)] = 4540,
  [SMALL_STATE(61)] = 4616,
  [SMALL_STATE(62)] = 4692,
  [SMALL_STATE(63)] = 4765,
  [SMALL_STATE(64)] = 4835,
  [SMALL_STATE(65)] = 4905,
  [SMALL_STATE(66)] = 4975,
  [SMALL_STATE(67)] = 5045,
  [SMALL_STATE(68)] = 5112,
  [SMALL_STATE(69)] = 5179,
  [SMALL_STATE(70)] = 5246,
  [SMALL_STATE(71)] = 5313,
  [SMALL_STATE(72)] = 5380,
  [SMALL_STATE(73)] = 5447,
  [SMALL_STATE(74)] = 5514,
  [SMALL_STATE(75)] = 5581,
  [SMALL_STATE(76)] = 5648,
  [SMALL_STATE(77)] = 5715,
  [SMALL_STATE(78)] = 5782,
  [SMALL_STATE(79)] = 5849,
  [SMALL_STATE(80)] = 5916,
  [SMALL_STATE(81)] = 5983,
  [SMALL_STATE(82)] = 6050,
  [SMALL_STATE(83)] = 6117,
  [SMALL_STATE(84)] = 6184,
  [SMALL_STATE(85)] = 6251,
  [SMALL_STATE(86)] = 6318,
  [SMALL_STATE(87)] = 6385,
  [SMALL_STATE(88)] = 6452,
  [SMALL_STATE(89)] = 6519,
  [SMALL_STATE(90)] = 6586,
  [SMALL_STATE(91)] = 6653,
  [SMALL_STATE(92)] = 6720,
  [SMALL_STATE(93)] = 6787,
  [SMALL_STATE(94)] = 6854,
  [SMALL_STATE(95)] = 6918,
  [SMALL_STATE(96)] = 6960,
  [SMALL_STATE(97)] = 7028,
  [SMALL_STATE(98)] = 7092,
  [SMALL_STATE(99)] = 7132,
  [SMALL_STATE(100)] = 7196,
  [SMALL_STATE(101)] = 7261,
  [SMALL_STATE(102)] = 7298,
  [SMALL_STATE(103)] = 7339,
  [SMALL_STATE(104)] = 7401,
  [SMALL_STATE(105)] = 7441,
  [SMALL_STATE(106)] = 7503,
  [SMALL_STATE(107)] = 7565,
  [SMALL_STATE(108)] = 7627,
  [SMALL_STATE(109)] = 7689,
  [SMALL_STATE(110)] = 7751,
  [SMALL_STATE(111)] = 7813,
  [SMALL_STATE(112)] = 7875,
  [SMALL_STATE(113)] = 7912,
  [SMALL_STATE(114)] = 7951,
  [SMALL_STATE(115)] = 7987,
  [SMALL_STATE(116)] = 8020,
  [SMALL_STATE(117)] = 8053,
  [SMALL_STATE(118)] = 8086,
  [SMALL_STATE(119)] = 8119,
  [SMALL_STATE(120)] = 8152,
  [SMALL_STATE(121)] = 8185,
  [SMALL_STATE(122)] = 8218,
  [SMALL_STATE(123)] = 8251,
  [SMALL_STATE(124)] = 8284,
  [SMALL_STATE(125)] = 8317,
  [SMALL_STATE(126)] = 8350,
  [SMALL_STATE(127)] = 8383,
  [SMALL_STATE(128)] = 8416,
  [SMALL_STATE(129)] = 8449,
  [SMALL_STATE(130)] = 8482,
  [SMALL_STATE(131)] = 8515,
  [SMALL_STATE(132)] = 8548,
  [SMALL_STATE(133)] = 8581,
  [SMALL_STATE(134)] = 8614,
  [SMALL_STATE(135)] = 8647,
  [SMALL_STATE(136)] = 8680,
  [SMALL_STATE(137)] = 8713,
  [SMALL_STATE(138)] = 8746,
  [SMALL_STATE(139)] = 8779,
  [SMALL_STATE(140)] = 8812,
  [SMALL_STATE(141)] = 8845,
  [SMALL_STATE(142)] = 8878,
  [SMALL_STATE(143)] = 8911,
  [SMALL_STATE(144)] = 8941,
  [SMALL_STATE(145)] = 8970,
  [SMALL_STATE(146)] = 8999,
  [SMALL_STATE(147)] = 9025,
  [SMALL_STATE(148)] = 9052,
  [SMALL_STATE(149)] = 9087,
  [SMALL_STATE(150)] = 9120,
  [SMALL_STATE(151)] = 9147,
  [SMALL_STATE(152)] = 9169,
  [SMALL_STATE(153)] = 9195,
  [SMALL_STATE(154)] = 9223,
  [SMALL_STATE(155)] = 9245,
  [SMALL_STATE(156)] = 9263,
  [SMALL_STATE(157)] = 9291,
  [SMALL_STATE(158)] = 9319,
  [SMALL_STATE(159)] = 9342,
  [SMALL_STATE(160)] = 9363,
  [SMALL_STATE(161)] = 9386,
  [SMALL_STATE(162)] = 9409,
  [SMALL_STATE(163)] = 9428,
  [SMALL_STATE(164)] = 9453,
  [SMALL_STATE(165)] = 9472,
  [SMALL_STATE(166)] = 9494,
  [SMALL_STATE(167)] = 9512,
  [SMALL_STATE(168)] = 9530,
  [SMALL_STATE(169)] = 9552,
  [SMALL_STATE(170)] = 9574,
  [SMALL_STATE(171)] = 9594,
  [SMALL_STATE(172)] = 9613,
  [SMALL_STATE(173)] = 9628,
  [SMALL_STATE(174)] = 9647,
  [SMALL_STATE(175)] = 9662,
  [SMALL_STATE(176)] = 9677,
  [SMALL_STATE(177)] = 9694,
  [SMALL_STATE(178)] = 9711,
  [SMALL_STATE(179)] = 9728,
  [SMALL_STATE(180)] = 9747,
  [SMALL_STATE(181)] = 9766,
  [SMALL_STATE(182)] = 9785,
  [SMALL_STATE(183)] = 9804,
  [SMALL_STATE(184)] = 9823,
  [SMALL_STATE(185)] = 9842,
  [SMALL_STATE(186)] = 9857,
  [SMALL_STATE(187)] = 9872,
  [SMALL_STATE(188)] = 9888,
  [SMALL_STATE(189)] = 9904,
  [SMALL_STATE(190)] = 9920,
  [SMALL_STATE(191)] = 9936,
  [SMALL_STATE(192)] = 9952,
  [SMALL_STATE(193)] = 9965,
  [SMALL_STATE(194)] = 9978,
  [SMALL_STATE(195)] = 9991,
  [SMALL_STATE(196)] = 10004,
  [SMALL_STATE(197)] = 10017,
  [SMALL_STATE(198)] = 10030,
  [SMALL_STATE(199)] = 10043,
  [SMALL_STATE(200)] = 10056,
  [SMALL_STATE(201)] = 10069,
  [SMALL_STATE(202)] = 10082,
  [SMALL_STATE(203)] = 10095,
  [SMALL_STATE(204)] = 10108,
  [SMALL_STATE(205)] = 10121,
  [SMALL_STATE(206)] = 10134,
  [SMALL_STATE(207)] = 10147,
  [SMALL_STATE(208)] = 10160,
  [SMALL_STATE(209)] = 10173,
  [SMALL_STATE(210)] = 10186,
  [SMALL_STATE(211)] = 10199,
  [SMALL_STATE(212)] = 10212,
  [SMALL_STATE(213)] = 10225,
  [SMALL_STATE(214)] = 10238,
  [SMALL_STATE(215)] = 10251,
  [SMALL_STATE(216)] = 10264,
  [SMALL_STATE(217)] = 10277,
  [SMALL_STATE(218)] = 10290,
  [SMALL_STATE(219)] = 10303,
  [SMALL_STATE(220)] = 10316,
  [SMALL_STATE(221)] = 10329,
  [SMALL_STATE(222)] = 10342,
  [SMALL_STATE(223)] = 10355,
  [SMALL_STATE(224)] = 10368,
  [SMALL_STATE(225)] = 10381,
  [SMALL_STATE(226)] = 10394,
  [SMALL_STATE(227)] = 10407,
  [SMALL_STATE(228)] = 10420,
  [SMALL_STATE(229)] = 10433,
  [SMALL_STATE(230)] = 10446,
  [SMALL_STATE(231)] = 10459,
  [SMALL_STATE(232)] = 10472,
  [SMALL_STATE(233)] = 10476,
  [SMALL_STATE(234)] = 10480,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 0),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [39] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dot_index_expression, 3, .production_id = 20),
  [41] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dot_index_expression, 3, .production_id = 20),
  [43] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1),
  [45] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 1),
  [47] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bracket_index_expression, 4, .production_id = 20),
  [49] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bracket_index_expression, 4, .production_id = 20),
  [51] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1),
  [53] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1),
  [55] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__prefix_expression, 1),
  [57] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__prefix_expression, 1),
  [59] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [61] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 3),
  [65] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 3),
  [67] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [69] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [71] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, .production_id = 12),
  [73] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, .production_id = 12),
  [75] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table_constructor, 2),
  [77] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table_constructor, 2),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, .production_id = 5),
  [81] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, .production_id = 5),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, .production_id = 10),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, .production_id = 10),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 1),
  [89] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 1),
  [91] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 25),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 25),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [131] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [135] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 15),
  [139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 15),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 2, .production_id = 13),
  [143] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_definition, 2, .production_id = 13),
  [145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 3, .production_id = 33),
  [147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 3, .production_id = 33),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_body, 2, .production_id = 24),
  [151] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_body, 2, .production_id = 24),
  [153] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block, 1),
  [155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2),
  [157] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(3),
  [160] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2),
  [162] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(117),
  [165] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(229),
  [168] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(121),
  [171] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(227),
  [174] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(43),
  [177] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(90),
  [180] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(44),
  [183] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(72),
  [186] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(170),
  [189] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(163),
  [192] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(169),
  [195] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 2), SHIFT_REPEAT(71),
  [198] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 3, .production_id = 26),
  [200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_explist, 1, .production_id = 14),
  [202] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_assignment_explist, 1, .production_id = 14),
  [204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [208] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 41),
  [210] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 41),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_statement, 1),
  [214] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 4, .production_id = 27),
  [220] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 4, .production_id = 27),
  [222] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [224] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [226] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_repeat_statement, 3, .production_id = 17),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_repeat_statement, 3, .production_id = 17),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 2),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 1),
  [236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [238] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 1),
  [240] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [242] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [250] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [254] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [262] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__expression_list_repeat1, 2),
  [266] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__expression_list_repeat1, 2),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 2),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_list, 1),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [278] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression_list, 1),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 1),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 3),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 1, .production_id = 14),
  [288] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [290] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 3, .production_id = 34),
  [296] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 23),
  [298] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 23),
  [300] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 23), SHIFT_REPEAT(207),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 5, .production_id = 47),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_clause, 5, .production_id = 46),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 22),
  [311] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__name_list_repeat1, 2, .production_id = 22),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__name_list, 2, .production_id = 11),
  [315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__name_list, 2, .production_id = 11),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__name_list, 1, .production_id = 4),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__name_list, 1, .production_id = 4),
  [325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_numeric_clause, 7, .production_id = 49),
  [339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 42),
  [341] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 42),
  [343] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__variable_assignment_explist_repeat1, 2, .production_id = 42), SHIFT_REPEAT(78),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_explist, 2, .production_id = 32),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_assignment_explist, 2, .production_id = 32),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration, 2, .production_id = 9),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_declaration, 2, .production_id = 9),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 4, .production_id = 29),
  [358] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 4, .production_id = 29),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, .production_id = 48),
  [362] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, .production_id = 48),
  [364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_empty_statement, 1),
  [366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_empty_statement, 1),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_function_declaration, 4, .production_id = 31),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_function_declaration, 4, .production_id = 31),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 3, .production_id = 16),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 3, .production_id = 16),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 3, .production_id = 18),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration, 3, .production_id = 18),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_goto_statement, 2),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_goto_statement, 2),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_do_statement, 2),
  [386] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_do_statement, 2),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_label_statement, 3),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_label_statement, 3),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 37),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 37),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 3, .production_id = 19),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_statement, 3, .production_id = 19),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 4, .production_id = 26),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 4, .production_id = 26),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__local_variable_assignment, 3, .production_id = 19),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__local_variable_assignment, 3, .production_id = 19),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 38),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 38),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5, .production_id = 36),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5, .production_id = 36),
  [416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 4, .production_id = 26),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 4, .production_id = 26),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_chunk_repeat1, 1),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_chunk_repeat1, 1),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 5, .production_id = 35),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 5, .production_id = 35),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 45),
  [430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 45),
  [432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 44),
  [434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 44),
  [436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 6, .production_id = 43),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 6, .production_id = 43),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_declaration, 2),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_declaration, 2),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1, .production_id = 1),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1, .production_id = 1),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1, .production_id = 2),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1, .production_id = 2),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 1, .production_id = 3),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 1, .production_id = 3),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 5, .production_id = 40),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 5, .production_id = 40),
  [464] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__field_sep, 1),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_sep, 1),
  [468] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 2),
  [470] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 2),
  [472] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters, 3, .production_id = 9),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 3, .production_id = 9),
  [476] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_list_repeat1, 2), SHIFT_REPEAT(93),
  [479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_list, 2),
  [481] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression_list, 2),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_varlist, 1, .production_id = 4),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [501] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 22),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [507] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [511] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 2),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 39),
  [519] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 39), SHIFT_REPEAT(75),
  [522] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, .production_id = 39),
  [524] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__field_list_repeat1, 2), SHIFT_REPEAT(143),
  [527] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__field_list_repeat1, 2),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [531] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_list, 1),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 3),
  [535] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 3),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block, 1),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block, 2),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__block, 2),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [553] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [555] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [561] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_index_expression, 3, .production_id = 21),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_dot_index_expression, 3, .production_id = 20),
  [565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_statement, 4, .production_id = 36),
  [567] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_statement, 4, .production_id = 36),
  [569] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 23),
  [571] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__variable_assignment_varlist_repeat1, 2, .production_id = 23), SHIFT_REPEAT(149),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 28),
  [576] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 1, .production_id = 28),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 1, .production_id = 4),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_assignment_varlist, 2, .production_id = 11),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 2, .production_id = 11),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name, 1),
  [596] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_prefix_expression, 1, .production_id = 7),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_prefix_expression, 1),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name, 1, .production_id = 8),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_statement, 2, .production_id = 16),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 3, .production_id = 4),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [660] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [662] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 1),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_chunk, 3),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_list, 4, .production_id = 11),
  [672] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_name_method_index_expression, 3, .production_id = 21),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_generic_clause, 3, .production_id = 30),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [694] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2, .production_id = 6),
  [696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2, .production_id = 5),
  [698] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 3, .production_id = 12),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_lua_external_scanner_create(void);
void tree_sitter_lua_external_scanner_destroy(void *);
bool tree_sitter_lua_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_lua_external_scanner_serialize(void *, char *);
void tree_sitter_lua_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_lua(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_lua_external_scanner_create,
      tree_sitter_lua_external_scanner_destroy,
      tree_sitter_lua_external_scanner_scan,
      tree_sitter_lua_external_scanner_serialize,
      tree_sitter_lua_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
