#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1431
#define LARGE_STATE_COUNT 6
#define SYMBOL_COUNT 271
#define ALIAS_COUNT 1
#define TOKEN_COUNT 95
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 76

enum {
  sym_module_comment = 1,
  sym_statement_comment = 2,
  sym_comment = 3,
  anon_sym_if = 4,
  anon_sym_LBRACE = 5,
  anon_sym_RBRACE = 6,
  anon_sym_erlang = 7,
  anon_sym_javascript = 8,
  anon_sym_AT = 9,
  anon_sym_LPAREN = 10,
  anon_sym_COMMA = 11,
  anon_sym_RPAREN = 12,
  anon_sym_COLON = 13,
  anon_sym_import = 14,
  anon_sym_DOT = 15,
  anon_sym_as = 16,
  anon_sym_SLASH = 17,
  anon_sym_const = 18,
  anon_sym_EQ = 19,
  anon_sym_POUND = 20,
  anon_sym_LBRACK = 21,
  anon_sym_RBRACK = 22,
  anon_sym_LT_LT = 23,
  anon_sym_GT_GT = 24,
  anon_sym_DASH = 25,
  anon_sym_size = 26,
  anon_sym_fn = 27,
  anon_sym_DASH_GT = 28,
  anon_sym_external = 29,
  anon_sym_type = 30,
  anon_sym_try = 31,
  anon_sym_PIPE_PIPE = 32,
  anon_sym_AMP_AMP = 33,
  anon_sym_EQ_EQ = 34,
  anon_sym_BANG_EQ = 35,
  anon_sym_LT = 36,
  anon_sym_LT_EQ = 37,
  anon_sym_LT_DOT = 38,
  anon_sym_LT_EQ_DOT = 39,
  anon_sym_GT = 40,
  anon_sym_GT_EQ = 41,
  anon_sym_GT_DOT = 42,
  anon_sym_GT_EQ_DOT = 43,
  anon_sym_PIPE_GT = 44,
  anon_sym_PLUS = 45,
  anon_sym_PLUS_DOT = 46,
  anon_sym_DASH_DOT = 47,
  anon_sym_STAR = 48,
  anon_sym_STAR_DOT = 49,
  anon_sym_SLASH_DOT = 50,
  anon_sym_PERCENT = 51,
  anon_sym_LT_GT = 52,
  anon_sym_todo = 53,
  anon_sym_panic = 54,
  anon_sym_DOT_DOT = 55,
  anon_sym_case = 56,
  anon_sym_PIPE = 57,
  anon_sym_let = 58,
  anon_sym_assert = 59,
  anon_sym_use = 60,
  anon_sym_LT_DASH = 61,
  anon_sym_BANG = 62,
  sym_visibility_modifier = 63,
  sym_opacity_modifier = 64,
  anon_sym_DQUOTE = 65,
  anon_sym_DQUOTE2 = 66,
  sym_escape_sequence = 67,
  sym_float = 68,
  sym__hex = 69,
  sym__decimal = 70,
  sym__octal = 71,
  sym__binary = 72,
  anon_sym_binary = 73,
  anon_sym_bytes = 74,
  anon_sym_int = 75,
  anon_sym_float = 76,
  anon_sym_bit_string = 77,
  anon_sym_bits = 78,
  anon_sym_utf8 = 79,
  anon_sym_utf16 = 80,
  anon_sym_utf32 = 81,
  anon_sym_utf8_codepoint = 82,
  anon_sym_utf16_codepoint = 83,
  anon_sym_utf32_codepoint = 84,
  anon_sym_signed = 85,
  anon_sym_unsigned = 86,
  anon_sym_big = 87,
  anon_sym_little = 88,
  anon_sym_native = 89,
  anon_sym_unit = 90,
  sym__discard_name = 91,
  sym__name = 92,
  sym__upname = 93,
  sym_quoted_content = 94,
  sym_source_file = 95,
  sym__module_statement = 96,
  sym_target_group = 97,
  sym_target = 98,
  sym_attribute = 99,
  sym__attribute_arguments = 100,
  sym_attribute_value = 101,
  sym_import = 102,
  sym_module = 103,
  sym_unqualified_imports = 104,
  sym_unqualified_import = 105,
  sym_constant = 106,
  sym__constant_value = 107,
  sym_constant_tuple = 108,
  sym_constant_list = 109,
  sym__constant_bit_string = 110,
  sym_constant_bit_string_segment = 111,
  sym_constant_bit_string_segment_options = 112,
  sym__constant_bit_string_segment_option = 113,
  sym__constant_bit_string_named_segment_option = 114,
  sym__constant_bit_string_segment_option_size = 115,
  sym_constant_record = 116,
  sym_constant_record_arguments = 117,
  sym_constant_record_argument = 118,
  sym_constant_field_access = 119,
  sym__constant_type = 120,
  sym__constant_type_annotation = 121,
  sym_constant_tuple_type = 122,
  sym_constant_function_type = 123,
  sym_constant_function_parameter_types = 124,
  sym_constant_type = 125,
  sym_constant_type_arguments = 126,
  sym_constant_type_argument = 127,
  sym_external_type = 128,
  sym_external_function = 129,
  sym_external_function_parameters = 130,
  sym_external_function_parameter = 131,
  sym_external_function_body = 132,
  sym_function = 133,
  sym_function_parameters = 134,
  sym_function_parameter = 135,
  sym__labeled_discard_param = 136,
  sym__discard_param = 137,
  sym__labeled_name_param = 138,
  sym__name_param = 139,
  aux_sym__statement_seq = 140,
  sym_try = 141,
  sym__statement = 142,
  sym__expression = 143,
  sym_binary_expression = 144,
  sym__expression_unit = 145,
  sym_record = 146,
  sym_todo = 147,
  sym_panic = 148,
  sym_tuple = 149,
  sym_list = 150,
  sym__expression_bit_string = 151,
  sym_expression_bit_string_segment = 152,
  sym_expression_bit_string_segment_options = 153,
  sym__expression_bit_string_segment_option = 154,
  sym__expression_bit_string_named_segment_option = 155,
  sym__expression_bit_string_segment_option_size = 156,
  sym_anonymous_function = 157,
  sym_anonymous_function_parameters = 158,
  sym_anonymous_function_parameter = 159,
  sym_block = 160,
  sym_case = 161,
  sym_case_subjects = 162,
  sym_case_clauses = 163,
  sym_case_clause = 164,
  sym_case_clause_patterns = 165,
  sym_case_clause_pattern = 166,
  sym_case_clause_guard = 167,
  sym__case_clause_guard_expression = 168,
  sym__case_clause_guard_binary_expression = 169,
  sym__case_clause_guard_unit = 170,
  sym__case_clause_tuple_access = 171,
  sym_let_assert = 172,
  sym_let = 173,
  sym_use = 174,
  sym_use_assignments = 175,
  sym_use_assignment = 176,
  sym_assert = 177,
  sym_boolean_negation = 178,
  sym_integer_negation = 179,
  sym__assignment = 180,
  sym_record_update = 181,
  sym_record_update_arguments = 182,
  sym_record_update_argument = 183,
  sym__maybe_tuple_expression = 184,
  sym_tuple_access = 185,
  sym__maybe_record_expression = 186,
  sym_field_access = 187,
  sym__maybe_function_expression = 188,
  sym_arguments = 189,
  sym_argument = 190,
  sym_hole = 191,
  sym_function_call = 192,
  sym__pattern_expression = 193,
  sym__pattern_binary_expression = 194,
  sym__pattern = 195,
  sym_record_pattern = 196,
  sym_record_pattern_arguments = 197,
  sym_record_pattern_argument = 198,
  sym_pattern_spread = 199,
  sym_tuple_pattern = 200,
  sym__pattern_bit_string = 201,
  sym_pattern_bit_string_segment = 202,
  sym_pattern_bit_string_segment_options = 203,
  sym__pattern_bit_string_segment_option = 204,
  sym__pattern_bit_string_named_segment_option = 205,
  sym__pattern_bit_string_segment_option_size = 206,
  sym__pattern_bit_string_segment_argument = 207,
  sym_list_pattern = 208,
  sym_list_pattern_tail = 209,
  sym_type_definition = 210,
  sym_data_constructors = 211,
  sym_data_constructor = 212,
  sym_data_constructor_arguments = 213,
  sym_data_constructor_argument = 214,
  sym_type_alias = 215,
  sym_string = 216,
  sym_integer = 217,
  sym__bit_string_segment_option = 218,
  sym__type = 219,
  sym__type_annotation = 220,
  sym_type_hole = 221,
  sym_tuple_type = 222,
  sym_function_type = 223,
  sym_function_parameter_types = 224,
  sym_type = 225,
  sym_type_arguments = 226,
  sym_type_argument = 227,
  sym_type_var = 228,
  sym_type_name = 229,
  sym_type_parameters = 230,
  sym_type_parameter = 231,
  sym_identifier = 232,
  sym_label = 233,
  sym_discard = 234,
  sym_type_identifier = 235,
  sym_remote_type_identifier = 236,
  sym_constructor_name = 237,
  sym_remote_constructor_name = 238,
  aux_sym_source_file_repeat1 = 239,
  aux_sym_target_group_repeat1 = 240,
  aux_sym__attribute_arguments_repeat1 = 241,
  aux_sym_module_repeat1 = 242,
  aux_sym_unqualified_imports_repeat1 = 243,
  aux_sym_constant_tuple_repeat1 = 244,
  aux_sym__constant_bit_string_repeat1 = 245,
  aux_sym_constant_bit_string_segment_options_repeat1 = 246,
  aux_sym_constant_record_arguments_repeat1 = 247,
  aux_sym_constant_tuple_type_repeat1 = 248,
  aux_sym_constant_type_arguments_repeat1 = 249,
  aux_sym_external_function_parameters_repeat1 = 250,
  aux_sym_function_parameters_repeat1 = 251,
  aux_sym_tuple_repeat1 = 252,
  aux_sym__expression_bit_string_repeat1 = 253,
  aux_sym_expression_bit_string_segment_options_repeat1 = 254,
  aux_sym_anonymous_function_parameters_repeat1 = 255,
  aux_sym_case_clauses_repeat1 = 256,
  aux_sym_case_clause_patterns_repeat1 = 257,
  aux_sym_case_clause_pattern_repeat1 = 258,
  aux_sym_use_assignments_repeat1 = 259,
  aux_sym_record_update_arguments_repeat1 = 260,
  aux_sym_arguments_repeat1 = 261,
  aux_sym_record_pattern_arguments_repeat1 = 262,
  aux_sym__pattern_bit_string_repeat1 = 263,
  aux_sym_pattern_bit_string_segment_options_repeat1 = 264,
  aux_sym_data_constructors_repeat1 = 265,
  aux_sym_data_constructor_arguments_repeat1 = 266,
  aux_sym_string_repeat1 = 267,
  aux_sym_tuple_type_repeat1 = 268,
  aux_sym_type_arguments_repeat1 = 269,
  aux_sym_type_parameters_repeat1 = 270,
  alias_sym_function_body = 271,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_module_comment] = "module_comment",
  [sym_statement_comment] = "statement_comment",
  [sym_comment] = "comment",
  [anon_sym_if] = "if",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_erlang] = "erlang",
  [anon_sym_javascript] = "javascript",
  [anon_sym_AT] = "@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COLON] = ":",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_as] = "as",
  [anon_sym_SLASH] = "/",
  [anon_sym_const] = "const",
  [anon_sym_EQ] = "=",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_DASH] = "-",
  [anon_sym_size] = "size",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_external] = "external",
  [anon_sym_type] = "type",
  [anon_sym_try] = "try",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT_DOT] = "<.",
  [anon_sym_LT_EQ_DOT] = "<=.",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT_DOT] = ">.",
  [anon_sym_GT_EQ_DOT] = ">=.",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_PLUS] = "+",
  [anon_sym_PLUS_DOT] = "+.",
  [anon_sym_DASH_DOT] = "-.",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_DOT] = "*.",
  [anon_sym_SLASH_DOT] = "/.",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_todo] = "todo",
  [anon_sym_panic] = "panic",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_case] = "case",
  [anon_sym_PIPE] = "|",
  [anon_sym_let] = "let",
  [anon_sym_assert] = "assert",
  [anon_sym_use] = "use",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_BANG] = "!",
  [sym_visibility_modifier] = "visibility_modifier",
  [sym_opacity_modifier] = "opacity_modifier",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE2] = "\"",
  [sym_escape_sequence] = "escape_sequence",
  [sym_float] = "float",
  [sym__hex] = "_hex",
  [sym__decimal] = "_decimal",
  [sym__octal] = "_octal",
  [sym__binary] = "_binary",
  [anon_sym_binary] = "binary",
  [anon_sym_bytes] = "bytes",
  [anon_sym_int] = "int",
  [anon_sym_float] = "float",
  [anon_sym_bit_string] = "bit_string",
  [anon_sym_bits] = "bits",
  [anon_sym_utf8] = "utf8",
  [anon_sym_utf16] = "utf16",
  [anon_sym_utf32] = "utf32",
  [anon_sym_utf8_codepoint] = "utf8_codepoint",
  [anon_sym_utf16_codepoint] = "utf16_codepoint",
  [anon_sym_utf32_codepoint] = "utf32_codepoint",
  [anon_sym_signed] = "signed",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_big] = "big",
  [anon_sym_little] = "little",
  [anon_sym_native] = "native",
  [anon_sym_unit] = "unit",
  [sym__discard_name] = "_discard_name",
  [sym__name] = "_name",
  [sym__upname] = "_upname",
  [sym_quoted_content] = "quoted_content",
  [sym_source_file] = "source_file",
  [sym__module_statement] = "_module_statement",
  [sym_target_group] = "target_group",
  [sym_target] = "target",
  [sym_attribute] = "attribute",
  [sym__attribute_arguments] = "arguments",
  [sym_attribute_value] = "attribute_value",
  [sym_import] = "import",
  [sym_module] = "module",
  [sym_unqualified_imports] = "unqualified_imports",
  [sym_unqualified_import] = "unqualified_import",
  [sym_constant] = "constant",
  [sym__constant_value] = "_constant_value",
  [sym_constant_tuple] = "tuple",
  [sym_constant_list] = "list",
  [sym__constant_bit_string] = "bit_string",
  [sym_constant_bit_string_segment] = "bit_string_segment",
  [sym_constant_bit_string_segment_options] = "bit_string_segment_options",
  [sym__constant_bit_string_segment_option] = "_constant_bit_string_segment_option",
  [sym__constant_bit_string_named_segment_option] = "_constant_bit_string_named_segment_option",
  [sym__constant_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_constant_record] = "record",
  [sym_constant_record_arguments] = "arguments",
  [sym_constant_record_argument] = "argument",
  [sym_constant_field_access] = "field_access",
  [sym__constant_type] = "_constant_type",
  [sym__constant_type_annotation] = "_constant_type_annotation",
  [sym_constant_tuple_type] = "tuple_type",
  [sym_constant_function_type] = "function_type",
  [sym_constant_function_parameter_types] = "function_parameter_types",
  [sym_constant_type] = "type",
  [sym_constant_type_arguments] = "type_arguments",
  [sym_constant_type_argument] = "type_argument",
  [sym_external_type] = "external_type",
  [sym_external_function] = "external_function",
  [sym_external_function_parameters] = "function_parameters",
  [sym_external_function_parameter] = "function_parameter",
  [sym_external_function_body] = "external_function_body",
  [sym_function] = "function",
  [sym_function_parameters] = "function_parameters",
  [sym_function_parameter] = "function_parameter",
  [sym__labeled_discard_param] = "_labeled_discard_param",
  [sym__discard_param] = "_discard_param",
  [sym__labeled_name_param] = "_labeled_name_param",
  [sym__name_param] = "_name_param",
  [aux_sym__statement_seq] = "_statement_seq",
  [sym_try] = "try",
  [sym__statement] = "_statement",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expression_unit] = "_expression_unit",
  [sym_record] = "record",
  [sym_todo] = "todo",
  [sym_panic] = "panic",
  [sym_tuple] = "tuple",
  [sym_list] = "list",
  [sym__expression_bit_string] = "bit_string",
  [sym_expression_bit_string_segment] = "bit_string_segment",
  [sym_expression_bit_string_segment_options] = "bit_string_segment_options",
  [sym__expression_bit_string_segment_option] = "_expression_bit_string_segment_option",
  [sym__expression_bit_string_named_segment_option] = "_expression_bit_string_named_segment_option",
  [sym__expression_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym_anonymous_function] = "anonymous_function",
  [sym_anonymous_function_parameters] = "function_parameters",
  [sym_anonymous_function_parameter] = "function_parameter",
  [sym_block] = "block",
  [sym_case] = "case",
  [sym_case_subjects] = "case_subjects",
  [sym_case_clauses] = "case_clauses",
  [sym_case_clause] = "case_clause",
  [sym_case_clause_patterns] = "case_clause_patterns",
  [sym_case_clause_pattern] = "case_clause_pattern",
  [sym_case_clause_guard] = "case_clause_guard",
  [sym__case_clause_guard_expression] = "_case_clause_guard_expression",
  [sym__case_clause_guard_binary_expression] = "binary_expression",
  [sym__case_clause_guard_unit] = "_case_clause_guard_unit",
  [sym__case_clause_tuple_access] = "tuple_access",
  [sym_let_assert] = "let_assert",
  [sym_let] = "let",
  [sym_use] = "use",
  [sym_use_assignments] = "use_assignments",
  [sym_use_assignment] = "use_assignment",
  [sym_assert] = "assert",
  [sym_boolean_negation] = "boolean_negation",
  [sym_integer_negation] = "integer_negation",
  [sym__assignment] = "_assignment",
  [sym_record_update] = "record_update",
  [sym_record_update_arguments] = "record_update_arguments",
  [sym_record_update_argument] = "record_update_argument",
  [sym__maybe_tuple_expression] = "_maybe_tuple_expression",
  [sym_tuple_access] = "tuple_access",
  [sym__maybe_record_expression] = "_maybe_record_expression",
  [sym_field_access] = "field_access",
  [sym__maybe_function_expression] = "_maybe_function_expression",
  [sym_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_hole] = "hole",
  [sym_function_call] = "function_call",
  [sym__pattern_expression] = "_pattern_expression",
  [sym__pattern_binary_expression] = "binary_expression",
  [sym__pattern] = "_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym_record_pattern_arguments] = "record_pattern_arguments",
  [sym_record_pattern_argument] = "record_pattern_argument",
  [sym_pattern_spread] = "pattern_spread",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym__pattern_bit_string] = "bit_string_pattern",
  [sym_pattern_bit_string_segment] = "bit_string_segment",
  [sym_pattern_bit_string_segment_options] = "bit_string_segment_options",
  [sym__pattern_bit_string_segment_option] = "_pattern_bit_string_segment_option",
  [sym__pattern_bit_string_named_segment_option] = "_pattern_bit_string_named_segment_option",
  [sym__pattern_bit_string_segment_option_size] = "bit_string_segment_option",
  [sym__pattern_bit_string_segment_argument] = "_pattern_bit_string_segment_argument",
  [sym_list_pattern] = "list_pattern",
  [sym_list_pattern_tail] = "list_pattern_tail",
  [sym_type_definition] = "type_definition",
  [sym_data_constructors] = "data_constructors",
  [sym_data_constructor] = "data_constructor",
  [sym_data_constructor_arguments] = "data_constructor_arguments",
  [sym_data_constructor_argument] = "data_constructor_argument",
  [sym_type_alias] = "type_alias",
  [sym_string] = "string",
  [sym_integer] = "integer",
  [sym__bit_string_segment_option] = "bit_string_segment_option",
  [sym__type] = "_type",
  [sym__type_annotation] = "_type_annotation",
  [sym_type_hole] = "type_hole",
  [sym_tuple_type] = "tuple_type",
  [sym_function_type] = "function_type",
  [sym_function_parameter_types] = "function_parameter_types",
  [sym_type] = "type",
  [sym_type_arguments] = "type_arguments",
  [sym_type_argument] = "type_argument",
  [sym_type_var] = "type_var",
  [sym_type_name] = "type_name",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_identifier] = "identifier",
  [sym_label] = "label",
  [sym_discard] = "discard",
  [sym_type_identifier] = "type_identifier",
  [sym_remote_type_identifier] = "remote_type_identifier",
  [sym_constructor_name] = "constructor_name",
  [sym_remote_constructor_name] = "remote_constructor_name",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_target_group_repeat1] = "target_group_repeat1",
  [aux_sym__attribute_arguments_repeat1] = "_attribute_arguments_repeat1",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym_unqualified_imports_repeat1] = "unqualified_imports_repeat1",
  [aux_sym_constant_tuple_repeat1] = "constant_tuple_repeat1",
  [aux_sym__constant_bit_string_repeat1] = "_constant_bit_string_repeat1",
  [aux_sym_constant_bit_string_segment_options_repeat1] = "constant_bit_string_segment_options_repeat1",
  [aux_sym_constant_record_arguments_repeat1] = "constant_record_arguments_repeat1",
  [aux_sym_constant_tuple_type_repeat1] = "constant_tuple_type_repeat1",
  [aux_sym_constant_type_arguments_repeat1] = "constant_type_arguments_repeat1",
  [aux_sym_external_function_parameters_repeat1] = "external_function_parameters_repeat1",
  [aux_sym_function_parameters_repeat1] = "function_parameters_repeat1",
  [aux_sym_tuple_repeat1] = "tuple_repeat1",
  [aux_sym__expression_bit_string_repeat1] = "_expression_bit_string_repeat1",
  [aux_sym_expression_bit_string_segment_options_repeat1] = "expression_bit_string_segment_options_repeat1",
  [aux_sym_anonymous_function_parameters_repeat1] = "anonymous_function_parameters_repeat1",
  [aux_sym_case_clauses_repeat1] = "case_clauses_repeat1",
  [aux_sym_case_clause_patterns_repeat1] = "case_clause_patterns_repeat1",
  [aux_sym_case_clause_pattern_repeat1] = "case_clause_pattern_repeat1",
  [aux_sym_use_assignments_repeat1] = "use_assignments_repeat1",
  [aux_sym_record_update_arguments_repeat1] = "record_update_arguments_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_record_pattern_arguments_repeat1] = "record_pattern_arguments_repeat1",
  [aux_sym__pattern_bit_string_repeat1] = "_pattern_bit_string_repeat1",
  [aux_sym_pattern_bit_string_segment_options_repeat1] = "pattern_bit_string_segment_options_repeat1",
  [aux_sym_data_constructors_repeat1] = "data_constructors_repeat1",
  [aux_sym_data_constructor_arguments_repeat1] = "data_constructor_arguments_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [alias_sym_function_body] = "function_body",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_module_comment] = sym_module_comment,
  [sym_statement_comment] = sym_statement_comment,
  [sym_comment] = sym_comment,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_erlang] = anon_sym_erlang,
  [anon_sym_javascript] = anon_sym_javascript,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_size] = anon_sym_size,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT_DOT] = anon_sym_LT_DOT,
  [anon_sym_LT_EQ_DOT] = anon_sym_LT_EQ_DOT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT_DOT] = anon_sym_GT_DOT,
  [anon_sym_GT_EQ_DOT] = anon_sym_GT_EQ_DOT,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PLUS_DOT] = anon_sym_PLUS_DOT,
  [anon_sym_DASH_DOT] = anon_sym_DASH_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_DOT] = anon_sym_STAR_DOT,
  [anon_sym_SLASH_DOT] = anon_sym_SLASH_DOT,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_todo] = anon_sym_todo,
  [anon_sym_panic] = anon_sym_panic,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [sym_visibility_modifier] = sym_visibility_modifier,
  [sym_opacity_modifier] = sym_opacity_modifier,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_float] = sym_float,
  [sym__hex] = sym__hex,
  [sym__decimal] = sym__decimal,
  [sym__octal] = sym__octal,
  [sym__binary] = sym__binary,
  [anon_sym_binary] = anon_sym_binary,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_bit_string] = anon_sym_bit_string,
  [anon_sym_bits] = anon_sym_bits,
  [anon_sym_utf8] = anon_sym_utf8,
  [anon_sym_utf16] = anon_sym_utf16,
  [anon_sym_utf32] = anon_sym_utf32,
  [anon_sym_utf8_codepoint] = anon_sym_utf8_codepoint,
  [anon_sym_utf16_codepoint] = anon_sym_utf16_codepoint,
  [anon_sym_utf32_codepoint] = anon_sym_utf32_codepoint,
  [anon_sym_signed] = anon_sym_signed,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_big] = anon_sym_big,
  [anon_sym_little] = anon_sym_little,
  [anon_sym_native] = anon_sym_native,
  [anon_sym_unit] = anon_sym_unit,
  [sym__discard_name] = sym__discard_name,
  [sym__name] = sym__name,
  [sym__upname] = sym__upname,
  [sym_quoted_content] = sym_quoted_content,
  [sym_source_file] = sym_source_file,
  [sym__module_statement] = sym__module_statement,
  [sym_target_group] = sym_target_group,
  [sym_target] = sym_target,
  [sym_attribute] = sym_attribute,
  [sym__attribute_arguments] = sym_arguments,
  [sym_attribute_value] = sym_attribute_value,
  [sym_import] = sym_import,
  [sym_module] = sym_module,
  [sym_unqualified_imports] = sym_unqualified_imports,
  [sym_unqualified_import] = sym_unqualified_import,
  [sym_constant] = sym_constant,
  [sym__constant_value] = sym__constant_value,
  [sym_constant_tuple] = sym_tuple,
  [sym_constant_list] = sym_list,
  [sym__constant_bit_string] = sym__constant_bit_string,
  [sym_constant_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_constant_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__constant_bit_string_segment_option] = sym__constant_bit_string_segment_option,
  [sym__constant_bit_string_named_segment_option] = sym__constant_bit_string_named_segment_option,
  [sym__constant_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_constant_record] = sym_record,
  [sym_constant_record_arguments] = sym_arguments,
  [sym_constant_record_argument] = sym_argument,
  [sym_constant_field_access] = sym_field_access,
  [sym__constant_type] = sym__constant_type,
  [sym__constant_type_annotation] = sym__constant_type_annotation,
  [sym_constant_tuple_type] = sym_tuple_type,
  [sym_constant_function_type] = sym_function_type,
  [sym_constant_function_parameter_types] = sym_function_parameter_types,
  [sym_constant_type] = sym_type,
  [sym_constant_type_arguments] = sym_type_arguments,
  [sym_constant_type_argument] = sym_type_argument,
  [sym_external_type] = sym_external_type,
  [sym_external_function] = sym_external_function,
  [sym_external_function_parameters] = sym_function_parameters,
  [sym_external_function_parameter] = sym_function_parameter,
  [sym_external_function_body] = sym_external_function_body,
  [sym_function] = sym_function,
  [sym_function_parameters] = sym_function_parameters,
  [sym_function_parameter] = sym_function_parameter,
  [sym__labeled_discard_param] = sym__labeled_discard_param,
  [sym__discard_param] = sym__discard_param,
  [sym__labeled_name_param] = sym__labeled_name_param,
  [sym__name_param] = sym__name_param,
  [aux_sym__statement_seq] = aux_sym__statement_seq,
  [sym_try] = sym_try,
  [sym__statement] = sym__statement,
  [sym__expression] = sym__expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expression_unit] = sym__expression_unit,
  [sym_record] = sym_record,
  [sym_todo] = sym_todo,
  [sym_panic] = sym_panic,
  [sym_tuple] = sym_tuple,
  [sym_list] = sym_list,
  [sym__expression_bit_string] = sym__constant_bit_string,
  [sym_expression_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_expression_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__expression_bit_string_segment_option] = sym__expression_bit_string_segment_option,
  [sym__expression_bit_string_named_segment_option] = sym__expression_bit_string_named_segment_option,
  [sym__expression_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym_anonymous_function] = sym_anonymous_function,
  [sym_anonymous_function_parameters] = sym_function_parameters,
  [sym_anonymous_function_parameter] = sym_function_parameter,
  [sym_block] = sym_block,
  [sym_case] = sym_case,
  [sym_case_subjects] = sym_case_subjects,
  [sym_case_clauses] = sym_case_clauses,
  [sym_case_clause] = sym_case_clause,
  [sym_case_clause_patterns] = sym_case_clause_patterns,
  [sym_case_clause_pattern] = sym_case_clause_pattern,
  [sym_case_clause_guard] = sym_case_clause_guard,
  [sym__case_clause_guard_expression] = sym__case_clause_guard_expression,
  [sym__case_clause_guard_binary_expression] = sym_binary_expression,
  [sym__case_clause_guard_unit] = sym__case_clause_guard_unit,
  [sym__case_clause_tuple_access] = sym_tuple_access,
  [sym_let_assert] = sym_let_assert,
  [sym_let] = sym_let,
  [sym_use] = sym_use,
  [sym_use_assignments] = sym_use_assignments,
  [sym_use_assignment] = sym_use_assignment,
  [sym_assert] = sym_assert,
  [sym_boolean_negation] = sym_boolean_negation,
  [sym_integer_negation] = sym_integer_negation,
  [sym__assignment] = sym__assignment,
  [sym_record_update] = sym_record_update,
  [sym_record_update_arguments] = sym_record_update_arguments,
  [sym_record_update_argument] = sym_record_update_argument,
  [sym__maybe_tuple_expression] = sym__maybe_tuple_expression,
  [sym_tuple_access] = sym_tuple_access,
  [sym__maybe_record_expression] = sym__maybe_record_expression,
  [sym_field_access] = sym_field_access,
  [sym__maybe_function_expression] = sym__maybe_function_expression,
  [sym_arguments] = sym_arguments,
  [sym_argument] = sym_argument,
  [sym_hole] = sym_hole,
  [sym_function_call] = sym_function_call,
  [sym__pattern_expression] = sym__pattern_expression,
  [sym__pattern_binary_expression] = sym_binary_expression,
  [sym__pattern] = sym__pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym_record_pattern_arguments] = sym_record_pattern_arguments,
  [sym_record_pattern_argument] = sym_record_pattern_argument,
  [sym_pattern_spread] = sym_pattern_spread,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym__pattern_bit_string] = sym__pattern_bit_string,
  [sym_pattern_bit_string_segment] = sym_constant_bit_string_segment,
  [sym_pattern_bit_string_segment_options] = sym_constant_bit_string_segment_options,
  [sym__pattern_bit_string_segment_option] = sym__pattern_bit_string_segment_option,
  [sym__pattern_bit_string_named_segment_option] = sym__pattern_bit_string_named_segment_option,
  [sym__pattern_bit_string_segment_option_size] = sym__constant_bit_string_segment_option_size,
  [sym__pattern_bit_string_segment_argument] = sym__pattern_bit_string_segment_argument,
  [sym_list_pattern] = sym_list_pattern,
  [sym_list_pattern_tail] = sym_list_pattern_tail,
  [sym_type_definition] = sym_type_definition,
  [sym_data_constructors] = sym_data_constructors,
  [sym_data_constructor] = sym_data_constructor,
  [sym_data_constructor_arguments] = sym_data_constructor_arguments,
  [sym_data_constructor_argument] = sym_data_constructor_argument,
  [sym_type_alias] = sym_type_alias,
  [sym_string] = sym_string,
  [sym_integer] = sym_integer,
  [sym__bit_string_segment_option] = sym__constant_bit_string_segment_option_size,
  [sym__type] = sym__type,
  [sym__type_annotation] = sym__type_annotation,
  [sym_type_hole] = sym_type_hole,
  [sym_tuple_type] = sym_tuple_type,
  [sym_function_type] = sym_function_type,
  [sym_function_parameter_types] = sym_function_parameter_types,
  [sym_type] = sym_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_type_argument] = sym_type_argument,
  [sym_type_var] = sym_type_var,
  [sym_type_name] = sym_type_name,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_identifier] = sym_identifier,
  [sym_label] = sym_label,
  [sym_discard] = sym_discard,
  [sym_type_identifier] = sym_type_identifier,
  [sym_remote_type_identifier] = sym_remote_type_identifier,
  [sym_constructor_name] = sym_constructor_name,
  [sym_remote_constructor_name] = sym_remote_constructor_name,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_target_group_repeat1] = aux_sym_target_group_repeat1,
  [aux_sym__attribute_arguments_repeat1] = aux_sym__attribute_arguments_repeat1,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym_unqualified_imports_repeat1] = aux_sym_unqualified_imports_repeat1,
  [aux_sym_constant_tuple_repeat1] = aux_sym_constant_tuple_repeat1,
  [aux_sym__constant_bit_string_repeat1] = aux_sym__constant_bit_string_repeat1,
  [aux_sym_constant_bit_string_segment_options_repeat1] = aux_sym_constant_bit_string_segment_options_repeat1,
  [aux_sym_constant_record_arguments_repeat1] = aux_sym_constant_record_arguments_repeat1,
  [aux_sym_constant_tuple_type_repeat1] = aux_sym_constant_tuple_type_repeat1,
  [aux_sym_constant_type_arguments_repeat1] = aux_sym_constant_type_arguments_repeat1,
  [aux_sym_external_function_parameters_repeat1] = aux_sym_external_function_parameters_repeat1,
  [aux_sym_function_parameters_repeat1] = aux_sym_function_parameters_repeat1,
  [aux_sym_tuple_repeat1] = aux_sym_tuple_repeat1,
  [aux_sym__expression_bit_string_repeat1] = aux_sym__expression_bit_string_repeat1,
  [aux_sym_expression_bit_string_segment_options_repeat1] = aux_sym_expression_bit_string_segment_options_repeat1,
  [aux_sym_anonymous_function_parameters_repeat1] = aux_sym_anonymous_function_parameters_repeat1,
  [aux_sym_case_clauses_repeat1] = aux_sym_case_clauses_repeat1,
  [aux_sym_case_clause_patterns_repeat1] = aux_sym_case_clause_patterns_repeat1,
  [aux_sym_case_clause_pattern_repeat1] = aux_sym_case_clause_pattern_repeat1,
  [aux_sym_use_assignments_repeat1] = aux_sym_use_assignments_repeat1,
  [aux_sym_record_update_arguments_repeat1] = aux_sym_record_update_arguments_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_record_pattern_arguments_repeat1] = aux_sym_record_pattern_arguments_repeat1,
  [aux_sym__pattern_bit_string_repeat1] = aux_sym__pattern_bit_string_repeat1,
  [aux_sym_pattern_bit_string_segment_options_repeat1] = aux_sym_pattern_bit_string_segment_options_repeat1,
  [aux_sym_data_constructors_repeat1] = aux_sym_data_constructors_repeat1,
  [aux_sym_data_constructor_arguments_repeat1] = aux_sym_data_constructor_arguments_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [alias_sym_function_body] = alias_sym_function_body,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_module_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_erlang] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_javascript] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_size] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_todo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_panic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [sym_visibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_opacity_modifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__hex] = {
    .visible = false,
    .named = true,
  },
  [sym__decimal] = {
    .visible = false,
    .named = true,
  },
  [sym__octal] = {
    .visible = false,
    .named = true,
  },
  [sym__binary] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bit_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf8_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf16_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utf32_codepoint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_big] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_little] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_native] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unit] = {
    .visible = true,
    .named = false,
  },
  [sym__discard_name] = {
    .visible = false,
    .named = true,
  },
  [sym__name] = {
    .visible = false,
    .named = true,
  },
  [sym__upname] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_content] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__module_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_target_group] = {
    .visible = true,
    .named = true,
  },
  [sym_target] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_unqualified_import] = {
    .visible = true,
    .named = true,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_value] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_list] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_record_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__constant_type] = {
    .visible = false,
    .named = true,
  },
  [sym__constant_type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_external_type] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__labeled_discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__discard_param] = {
    .visible = false,
    .named = true,
  },
  [sym__labeled_name_param] = {
    .visible = false,
    .named = true,
  },
  [sym__name_param] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__statement_seq] = {
    .visible = false,
    .named = false,
  },
  [sym_try] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_unit] = {
    .visible = false,
    .named = true,
  },
  [sym_record] = {
    .visible = true,
    .named = true,
  },
  [sym_todo] = {
    .visible = true,
    .named = true,
  },
  [sym_panic] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_subjects] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clauses] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_patterns] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause_guard] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_guard_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__case_clause_guard_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__case_clause_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym_let_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_use] = {
    .visible = true,
    .named = true,
  },
  [sym_use_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_use_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_negation] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_negation] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [sym_record_update] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_update_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_tuple_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_record_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_field_access] = {
    .visible = true,
    .named = true,
  },
  [sym__maybe_function_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_spread] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_bit_string_segment_options] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_named_segment_option] = {
    .visible = false,
    .named = true,
  },
  [sym__pattern_bit_string_segment_option_size] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_bit_string_segment_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern_tail] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructors] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_data_constructor_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym__bit_string_segment_option] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_annotation] = {
    .visible = false,
    .named = true,
  },
  [sym_type_hole] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_types] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_var] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_discard] = {
    .visible = true,
    .named = true,
  },
  [sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_constructor_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_target_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unqualified_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__constant_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_record_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_external_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_update_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pattern_bit_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_bit_string_segment_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_data_constructor_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_function_body] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_arguments = 2,
  field_assign = 3,
  field_assignments = 4,
  field_body = 5,
  field_clauses = 6,
  field_constructor = 7,
  field_field = 8,
  field_function = 9,
  field_guard = 10,
  field_imports = 11,
  field_index = 12,
  field_label = 13,
  field_left = 14,
  field_message = 15,
  field_module = 16,
  field_name = 17,
  field_operator = 18,
  field_options = 19,
  field_parameter_types = 20,
  field_parameters = 21,
  field_pattern = 22,
  field_patterns = 23,
  field_record = 24,
  field_return_type = 25,
  field_right = 26,
  field_spread = 27,
  field_subjects = 28,
  field_target = 29,
  field_tuple = 30,
  field_type = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_arguments] = "arguments",
  [field_assign] = "assign",
  [field_assignments] = "assignments",
  [field_body] = "body",
  [field_clauses] = "clauses",
  [field_constructor] = "constructor",
  [field_field] = "field",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_imports] = "imports",
  [field_index] = "index",
  [field_label] = "label",
  [field_left] = "left",
  [field_message] = "message",
  [field_module] = "module",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_options] = "options",
  [field_parameter_types] = "parameter_types",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_patterns] = "patterns",
  [field_record] = "record",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_spread] = "spread",
  [field_subjects] = "subjects",
  [field_target] = "target",
  [field_tuple] = "tuple",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 3},
  [5] = {.index = 6, .length = 4},
  [6] = {.index = 10, .length = 1},
  [7] = {.index = 11, .length = 2},
  [8] = {.index = 13, .length = 2},
  [9] = {.index = 15, .length = 2},
  [10] = {.index = 17, .length = 1},
  [11] = {.index = 18, .length = 2},
  [12] = {.index = 20, .length = 2},
  [13] = {.index = 22, .length = 1},
  [14] = {.index = 23, .length = 4},
  [15] = {.index = 27, .length = 1},
  [16] = {.index = 28, .length = 2},
  [17] = {.index = 30, .length = 3},
  [18] = {.index = 33, .length = 2},
  [19] = {.index = 35, .length = 2},
  [20] = {.index = 37, .length = 2},
  [21] = {.index = 39, .length = 1},
  [22] = {.index = 40, .length = 2},
  [23] = {.index = 42, .length = 2},
  [24] = {.index = 44, .length = 1},
  [25] = {.index = 45, .length = 2},
  [26] = {.index = 47, .length = 3},
  [27] = {.index = 50, .length = 2},
  [28] = {.index = 52, .length = 2},
  [29] = {.index = 54, .length = 1},
  [30] = {.index = 55, .length = 2},
  [31] = {.index = 57, .length = 3},
  [32] = {.index = 60, .length = 2},
  [33] = {.index = 62, .length = 1},
  [34] = {.index = 63, .length = 3},
  [35] = {.index = 66, .length = 2},
  [36] = {.index = 68, .length = 3},
  [37] = {.index = 71, .length = 1},
  [38] = {.index = 72, .length = 2},
  [39] = {.index = 74, .length = 3},
  [40] = {.index = 77, .length = 2},
  [41] = {.index = 79, .length = 2},
  [42] = {.index = 81, .length = 1},
  [43] = {.index = 82, .length = 1},
  [44] = {.index = 83, .length = 2},
  [45] = {.index = 85, .length = 2},
  [46] = {.index = 87, .length = 4},
  [47] = {.index = 91, .length = 4},
  [48] = {.index = 95, .length = 2},
  [49] = {.index = 97, .length = 4},
  [50] = {.index = 101, .length = 2},
  [51] = {.index = 103, .length = 2},
  [52] = {.index = 105, .length = 3},
  [53] = {.index = 108, .length = 1},
  [54] = {.index = 109, .length = 1},
  [55] = {.index = 110, .length = 3},
  [56] = {.index = 113, .length = 2},
  [57] = {.index = 115, .length = 3},
  [58] = {.index = 118, .length = 2},
  [59] = {.index = 120, .length = 2},
  [60] = {.index = 122, .length = 3},
  [61] = {.index = 125, .length = 2},
  [62] = {.index = 127, .length = 2},
  [63] = {.index = 129, .length = 2},
  [64] = {.index = 131, .length = 1},
  [65] = {.index = 132, .length = 3},
  [66] = {.index = 135, .length = 3},
  [67] = {.index = 138, .length = 2},
  [68] = {.index = 140, .length = 3},
  [69] = {.index = 143, .length = 3},
  [70] = {.index = 146, .length = 3},
  [71] = {.index = 149, .length = 4},
  [72] = {.index = 153, .length = 4},
  [73] = {.index = 157, .length = 3},
  [74] = {.index = 153, .length = 4},
  [75] = {.index = 160, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_module, 1},
  [2] =
    {field_value, 0},
  [3] =
    {field_left, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
    {field_right, 0, .inherited = true},
  [6] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [10] =
    {field_assign, 0, .inherited = true},
  [11] =
    {field_arguments, 1},
    {field_function, 0},
  [13] =
    {field_arguments, 1},
    {field_name, 0},
  [15] =
    {field_arguments, 2},
    {field_name, 1},
  [17] =
    {field_name, 0, .inherited = true},
  [18] =
    {field_name, 0},
    {field_parameters, 1},
  [20] =
    {field_assign, 0, .inherited = true},
    {field_value, 0},
  [22] =
    {field_message, 2},
  [23] =
    {field_assign, 2, .inherited = true},
    {field_pattern, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [27] =
    {field_value, 2},
  [28] =
    {field_assign, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [30] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [33] =
    {field_index, 2},
    {field_tuple, 0},
  [35] =
    {field_field, 2},
    {field_record, 0},
  [37] =
    {field_module, 0},
    {field_name, 2},
  [39] =
    {field_target, 1},
  [40] =
    {field_imports, 3},
    {field_module, 1},
  [42] =
    {field_alias, 3},
    {field_module, 1},
  [44] =
    {field_type, 1},
  [45] =
    {field_name, 1},
    {field_value, 3},
  [47] =
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [50] =
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [52] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [54] =
    {field_assign, 1, .inherited = true},
  [55] =
    {field_assign, 1},
    {field_assign, 2},
  [57] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1},
    {field_value, 3},
  [60] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
  [62] =
    {field_subjects, 1},
  [63] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_value, 2},
  [66] =
    {field_assignments, 1},
    {field_value, 3},
  [68] =
    {field_name, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [71] =
    {field_spread, 3},
  [72] =
    {field_body, 3},
    {field_parameters, 1},
  [74] =
    {field_label, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [77] =
    {field_label, 0},
    {field_name, 1},
  [79] =
    {field_name, 1},
    {field_parameters, 2},
  [81] =
    {field_type, 0},
  [82] =
    {field_assign, 2, .inherited = true},
  [83] =
    {field_assign, 1, .inherited = true},
    {field_assign, 2, .inherited = true},
  [85] =
    {field_assign, 0, .inherited = true},
    {field_assign, 1, .inherited = true},
  [87] =
    {field_assign, 0, .inherited = true},
    {field_options, 1},
    {field_options, 2},
    {field_value, 0},
  [91] =
    {field_assign, 1, .inherited = true},
    {field_pattern, 1},
    {field_type, 2, .inherited = true},
    {field_value, 4},
  [95] =
    {field_clauses, 3},
    {field_subjects, 1},
  [97] =
    {field_assign, 0, .inherited = true},
    {field_pattern, 0},
    {field_type, 1, .inherited = true},
    {field_value, 3},
  [101] =
    {field_name, 2},
    {field_value, 4},
  [103] =
    {field_label, 0},
    {field_value, 2},
  [105] =
    {field_alias, 5},
    {field_imports, 3},
    {field_module, 1},
  [108] =
    {field_return_type, 2},
  [109] =
    {field_spread, 4},
  [110] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [113] =
    {field_assign, 2, .inherited = true},
    {field_assign, 3, .inherited = true},
  [115] =
    {field_assign, 2, .inherited = true},
    {field_label, 0},
    {field_pattern, 2},
  [118] =
    {field_index, 0, .inherited = true},
    {field_tuple, 0, .inherited = true},
  [120] =
    {field_patterns, 0},
    {field_value, 2},
  [122] =
    {field_name, 2},
    {field_type, 3, .inherited = true},
    {field_value, 5},
  [125] =
    {field_name, 2},
    {field_parameters, 3},
  [127] =
    {field_alias, 2},
    {field_name, 0},
  [129] =
    {field_parameter_types, 1},
    {field_return_type, 3},
  [131] =
    {field_spread, 5},
  [132] =
    {field_body, 5},
    {field_parameters, 1},
    {field_return_type, 3},
  [135] =
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [138] =
    {field_name, 0},
    {field_type, 2},
  [140] =
    {field_guard, 1},
    {field_patterns, 0},
    {field_value, 3},
  [143] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [146] =
    {field_arguments, 5},
    {field_constructor, 0},
    {field_spread, 3},
  [149] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [153] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [157] =
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [160] =
    {field_body, 8},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [38] = {
    [3] = alias_sym_function_body,
  },
  [55] = {
    [4] = alias_sym_function_body,
  },
  [65] = {
    [5] = alias_sym_function_body,
  },
  [69] = {
    [5] = alias_sym_function_body,
  },
  [71] = {
    [6] = alias_sym_function_body,
  },
  [74] = {
    [7] = alias_sym_function_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__statement_seq, 2,
    aux_sym__statement_seq,
    alias_sym_function_body,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(165);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(161)
      if (lookahead == '\r') SKIP(161)
      if (lookahead == '!') ADVANCE(253);
      if (lookahead == '"') ADVANCE(259);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(203);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(195);
      if (lookahead == '>') ADVANCE(228);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '\\') ADVANCE(157);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '_') ADVANCE(306);
      if (lookahead == 'a') ADVANCE(417);
      if (lookahead == 'b') ADVANCE(363);
      if (lookahead == 'c') ADVANCE(315);
      if (lookahead == 'e') ADVANCE(410);
      if (lookahead == 'f') ADVANCE(374);
      if (lookahead == 'i') ADVANCE(354);
      if (lookahead == 'j') ADVANCE(313);
      if (lookahead == 'l') ADVANCE(346);
      if (lookahead == 'n') ADVANCE(323);
      if (lookahead == 'o') ADVANCE(403);
      if (lookahead == 'p') ADVANCE(317);
      if (lookahead == 's') ADVANCE(364);
      if (lookahead == 't') ADVANCE(390);
      if (lookahead == 'u') ADVANCE(379);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '|') ADVANCE(246);
      if (lookahead == '}') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 1:
      if (lookahead == '&') ADVANCE(218);
      END_STATE();
    case 2:
      if (lookahead == '-') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(262);
      END_STATE();
    case 3:
      if (lookahead == '-') ADVANCE(251);
      if (lookahead == '<') ADVANCE(199);
      END_STATE();
    case 4:
      if (lookahead == '-') ADVANCE(251);
      if (lookahead == '>') ADVANCE(240);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(243);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '/') ADVANCE(169);
      END_STATE();
    case 8:
      if (lookahead == '1') ADVANCE(10);
      if (lookahead == '3') ADVANCE(9);
      if (lookahead == '8') ADVANCE(282);
      END_STATE();
    case 9:
      if (lookahead == '2') ADVANCE(286);
      END_STATE();
    case 10:
      if (lookahead == '6') ADVANCE(284);
      END_STATE();
    case 11:
      if (lookahead == '<') ADVANCE(199);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(220);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(219);
      END_STATE();
    case 14:
      if (lookahead == '>') ADVANCE(211);
      END_STATE();
    case 15:
      if (lookahead == '>') ADVANCE(200);
      END_STATE();
    case 16:
      if (lookahead == '>') ADVANCE(232);
      if (lookahead == '|') ADVANCE(217);
      END_STATE();
    case 17:
      if (lookahead == '_') ADVANCE(111);
      if (lookahead == 's') ADVANCE(280);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(76);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(109);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(124);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 26:
      if (lookahead == 'b') ADVANCE(254);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(86);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(91);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(92);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(294);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(296);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(45);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 'd') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(207);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(300);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(302);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(256);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(103);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 48:
      if (lookahead == 'f') ADVANCE(8);
      END_STATE();
    case 49:
      if (lookahead == 'f') ADVANCE(171);
      END_STATE();
    case 50:
      if (lookahead == 'f') ADVANCE(171);
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 51:
      if (lookahead == 'g') ADVANCE(298);
      if (lookahead == 'n') ADVANCE(20);
      if (lookahead == 't') ADVANCE(17);
      END_STATE();
    case 52:
      if (lookahead == 'g') ADVANCE(175);
      END_STATE();
    case 53:
      if (lookahead == 'g') ADVANCE(278);
      END_STATE();
    case 54:
      if (lookahead == 'g') ADVANCE(78);
      if (lookahead == 'z') ADVANCE(36);
      END_STATE();
    case 55:
      if (lookahead == 'g') ADVANCE(80);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(51);
      if (lookahead == 'y') ADVANCE(112);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 59:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(126);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(77);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(114);
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(81);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(212);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(87);
      if (lookahead == 'n') ADVANCE(209);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(21);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 71:
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 72:
      if (lookahead == 'm') ADVANCE(93);
      if (lookahead == 'n') ADVANCE(113);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(209);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(63);
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 80:
      if (lookahead == 'n') ADVANCE(43);
      END_STATE();
    case 81:
      if (lookahead == 'n') ADVANCE(119);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(120);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(106);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 89:
      if (lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 90:
      if (lookahead == 'o') ADVANCE(66);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 92:
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(85);
      END_STATE();
    case 94:
      if (lookahead == 'p') ADVANCE(19);
      END_STATE();
    case 95:
      if (lookahead == 'p') ADVANCE(37);
      END_STATE();
    case 96:
      if (lookahead == 'p') ADVANCE(88);
      END_STATE();
    case 97:
      if (lookahead == 'p') ADVANCE(118);
      END_STATE();
    case 98:
      if (lookahead == 'p') ADVANCE(89);
      END_STATE();
    case 99:
      if (lookahead == 'p') ADVANCE(90);
      END_STATE();
    case 100:
      if (lookahead == 'q') ADVANCE(128);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 'x') ADVANCE(123);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(132);
      END_STATE();
    case 103:
      if (lookahead == 'r') ADVANCE(79);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 105:
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 106:
      if (lookahead == 'r') ADVANCE(117);
      END_STATE();
    case 107:
      if (lookahead == 's') ADVANCE(188);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(272);
      END_STATE();
    case 109:
      if (lookahead == 's') ADVANCE(28);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 111:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(274);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(304);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(192);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(276);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(184);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 119:
      if (lookahead == 't') ADVANCE(288);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(290);
      END_STATE();
    case 121:
      if (lookahead == 't') ADVANCE(292);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 123:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 127:
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 129:
      if (lookahead == 'v') ADVANCE(23);
      END_STATE();
    case 130:
      if (lookahead == 'v') ADVANCE(40);
      END_STATE();
    case 131:
      if (lookahead == 'x') ADVANCE(123);
      END_STATE();
    case 132:
      if (lookahead == 'y') ADVANCE(270);
      END_STATE();
    case 133:
      if (lookahead == 'y') ADVANCE(95);
      END_STATE();
    case 134:
      if (lookahead == '|') ADVANCE(217);
      END_STATE();
    case 135:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(135)
      if (lookahead == '\r') SKIP(135)
      if (lookahead == '!') ADVANCE(253);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(195);
      if (lookahead == '>') ADVANCE(228);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '_') ADVANCE(308);
      if (lookahead == 'a') ADVANCE(426);
      if (lookahead == 'c') ADVANCE(316);
      if (lookahead == 'f') ADVANCE(378);
      if (lookahead == 'l') ADVANCE(347);
      if (lookahead == 'p') ADVANCE(318);
      if (lookahead == 't') ADVANCE(391);
      if (lookahead == 'u') ADVANCE(418);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 136:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(136)
      if (lookahead == '\r') SKIP(136)
      if (lookahead == '!') ADVANCE(252);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(206);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(3);
      if (lookahead == '=') ADVANCE(194);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '_') ADVANCE(306);
      if (lookahead == 'a') ADVANCE(426);
      if (lookahead == 'c') ADVANCE(316);
      if (lookahead == 'f') ADVANCE(378);
      if (lookahead == 'p') ADVANCE(318);
      if (lookahead == 't') ADVANCE(392);
      if (lookahead == '{') ADVANCE(173);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 137:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(137)
      if (lookahead == '\r') SKIP(137)
      if (lookahead == '!') ADVANCE(252);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '-') ADVANCE(206);
      if (lookahead == '.') ADVANCE(5);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '_') ADVANCE(308);
      if (lookahead == 'a') ADVANCE(426);
      if (lookahead == 'c') ADVANCE(316);
      if (lookahead == 'f') ADVANCE(378);
      if (lookahead == 'p') ADVANCE(318);
      if (lookahead == 't') ADVANCE(392);
      if (lookahead == '{') ADVANCE(173);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 138:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(138)
      if (lookahead == '\r') SKIP(138)
      if (lookahead == '!') ADVANCE(253);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(227);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '_') ADVANCE(308);
      if (lookahead == 'a') ADVANCE(417);
      if (lookahead == 'c') ADVANCE(316);
      if (lookahead == 'f') ADVANCE(378);
      if (lookahead == 'l') ADVANCE(347);
      if (lookahead == 'p') ADVANCE(318);
      if (lookahead == 't') ADVANCE(391);
      if (lookahead == 'u') ADVANCE(418);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 139:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(140)
      if (lookahead == '\r') SKIP(140)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(259);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(202);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(266);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(223);
      if (lookahead == '=') ADVANCE(195);
      if (lookahead == '>') ADVANCE(228);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == '\\') ADVANCE(157);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'b') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'j') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 's') ADVANCE(57);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == 'u') ADVANCE(74);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(267);
      END_STATE();
    case 140:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(140)
      if (lookahead == '\r') SKIP(140)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(202);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(266);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(223);
      if (lookahead == '=') ADVANCE(195);
      if (lookahead == '>') ADVANCE(228);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'b') ADVANCE(56);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(101);
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 'j') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 's') ADVANCE(57);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == 'u') ADVANCE(74);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(267);
      END_STATE();
    case 141:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(141)
      if (lookahead == '\r') SKIP(141)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(202);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(223);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(228);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(174);
      END_STATE();
    case 142:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(142)
      if (lookahead == '\r') SKIP(142)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(228);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '_') ADVANCE(306);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(143)
      if (lookahead == '\r') SKIP(143)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(227);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '_') ADVANCE(306);
      if (lookahead == 'a') ADVANCE(420);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 144:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(144)
      if (lookahead == '\r') SKIP(144)
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '-') ADVANCE(206);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(3);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '_') ADVANCE(306);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(145)
      if (lookahead == '\r') SKIP(145)
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '-') ADVANCE(205);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '_') ADVANCE(306);
      if (lookahead == 'i') ADVANCE(356);
      if (lookahead == '|') ADVANCE(245);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 146:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(146)
      if (lookahead == '\r') SKIP(146)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == '.') ADVANCE(186);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(222);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(228);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == '|') ADVANCE(134);
      if (lookahead == '}') ADVANCE(174);
      END_STATE();
    case 147:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(147)
      if (lookahead == '\r') SKIP(147)
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '-') ADVANCE(206);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '_') ADVANCE(308);
      if (lookahead == '{') ADVANCE(173);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 148:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(148)
      if (lookahead == '\r') SKIP(148)
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '-') ADVANCE(206);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '_') ADVANCE(306);
      if (lookahead == 'a') ADVANCE(426);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 149:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(149)
      if (lookahead == '\r') SKIP(149)
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(201);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(4);
      if (lookahead == '=') ADVANCE(194);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'c') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(73);
      if (lookahead == 'i') ADVANCE(71);
      if (lookahead == 'o') ADVANCE(94);
      if (lookahead == 'p') ADVANCE(127);
      if (lookahead == 't') ADVANCE(133);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '}') ADVANCE(174);
      END_STATE();
    case 150:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(150)
      if (lookahead == '\r') SKIP(150)
      if (lookahead == '!') ADVANCE(12);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '<') ADVANCE(223);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(227);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'i') ADVANCE(49);
      if (lookahead == '|') ADVANCE(247);
      END_STATE();
    case 151:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(151)
      if (lookahead == '\r') SKIP(151)
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '_') ADVANCE(307);
      if (lookahead == 'f') ADVANCE(378);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 152:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(152)
      if (lookahead == '\r') SKIP(152)
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(4);
      if (lookahead == '=') ADVANCE(194);
      if (lookahead == '>') ADVANCE(15);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == 'a') ADVANCE(107);
      if (lookahead == 'i') ADVANCE(49);
      if (lookahead == '|') ADVANCE(245);
      END_STATE();
    case 153:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(153)
      if (lookahead == '\r') SKIP(153)
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '_') ADVANCE(307);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 154:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(154)
      if (lookahead == '\r') SKIP(154)
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '-') ADVANCE(201);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(266);
      if (lookahead == '}') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(267);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 155:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(155)
      if (lookahead == '\r') SKIP(155)
      if (lookahead == '!') ADVANCE(253);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '.') ADVANCE(186);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(228);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '_') ADVANCE(308);
      if (lookahead == 'a') ADVANCE(426);
      if (lookahead == 'c') ADVANCE(316);
      if (lookahead == 'f') ADVANCE(378);
      if (lookahead == 'l') ADVANCE(347);
      if (lookahead == 'p') ADVANCE(318);
      if (lookahead == 't') ADVANCE(391);
      if (lookahead == 'u') ADVANCE(418);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '|') ADVANCE(16);
      if (lookahead == '}') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 156:
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(269);
      END_STATE();
    case 157:
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == 'e' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(260);
      END_STATE();
    case 158:
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(268);
      END_STATE();
    case 159:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(262);
      END_STATE();
    case 160:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(263);
      END_STATE();
    case 161:
      if (eof) ADVANCE(165);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(161)
      if (lookahead == '\r') SKIP(161)
      if (lookahead == '!') ADVANCE(253);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == ')') ADVANCE(182);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == ',') ADVANCE(181);
      if (lookahead == '-') ADVANCE(203);
      if (lookahead == '.') ADVANCE(187);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == ':') ADVANCE(183);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(195);
      if (lookahead == '>') ADVANCE(228);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == ']') ADVANCE(198);
      if (lookahead == '_') ADVANCE(306);
      if (lookahead == 'a') ADVANCE(417);
      if (lookahead == 'b') ADVANCE(363);
      if (lookahead == 'c') ADVANCE(315);
      if (lookahead == 'e') ADVANCE(410);
      if (lookahead == 'f') ADVANCE(374);
      if (lookahead == 'i') ADVANCE(354);
      if (lookahead == 'j') ADVANCE(313);
      if (lookahead == 'l') ADVANCE(346);
      if (lookahead == 'n') ADVANCE(323);
      if (lookahead == 'o') ADVANCE(403);
      if (lookahead == 'p') ADVANCE(317);
      if (lookahead == 's') ADVANCE(364);
      if (lookahead == 't') ADVANCE(390);
      if (lookahead == 'u') ADVANCE(379);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '|') ADVANCE(246);
      if (lookahead == '}') ADVANCE(174);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('d' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 162:
      if (eof) ADVANCE(165);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(162)
      if (lookahead == '\r') SKIP(162)
      if (lookahead == '!') ADVANCE(253);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '.') ADVANCE(186);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(227);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '_') ADVANCE(308);
      if (lookahead == 'a') ADVANCE(426);
      if (lookahead == 'c') ADVANCE(315);
      if (lookahead == 'e') ADVANCE(447);
      if (lookahead == 'f') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(355);
      if (lookahead == 'l') ADVANCE(347);
      if (lookahead == 'o') ADVANCE(403);
      if (lookahead == 'p') ADVANCE(317);
      if (lookahead == 't') ADVANCE(390);
      if (lookahead == 'u') ADVANCE(418);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 163:
      if (eof) ADVANCE(165);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(163)
      if (lookahead == '\r') SKIP(163)
      if (lookahead == '!') ADVANCE(252);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == '-') ADVANCE(206);
      if (lookahead == '/') ADVANCE(7);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(11);
      if (lookahead == '=') ADVANCE(194);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '_') ADVANCE(308);
      if (lookahead == 'a') ADVANCE(426);
      if (lookahead == 'c') ADVANCE(315);
      if (lookahead == 'e') ADVANCE(447);
      if (lookahead == 'f') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(355);
      if (lookahead == 'l') ADVANCE(347);
      if (lookahead == 'o') ADVANCE(403);
      if (lookahead == 'p') ADVANCE(317);
      if (lookahead == 't') ADVANCE(390);
      if (lookahead == 'u') ADVANCE(418);
      if (lookahead == '{') ADVANCE(173);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 164:
      if (eof) ADVANCE(165);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == ' ') SKIP(164)
      if (lookahead == '\r') SKIP(164)
      if (lookahead == '!') ADVANCE(253);
      if (lookahead == '"') ADVANCE(258);
      if (lookahead == '#') ADVANCE(196);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(1);
      if (lookahead == '(') ADVANCE(180);
      if (lookahead == '*') ADVANCE(236);
      if (lookahead == '+') ADVANCE(233);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '.') ADVANCE(186);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '0') ADVANCE(264);
      if (lookahead == '<') ADVANCE(221);
      if (lookahead == '=') ADVANCE(13);
      if (lookahead == '>') ADVANCE(227);
      if (lookahead == '@') ADVANCE(179);
      if (lookahead == '[') ADVANCE(197);
      if (lookahead == '_') ADVANCE(308);
      if (lookahead == 'a') ADVANCE(417);
      if (lookahead == 'c') ADVANCE(315);
      if (lookahead == 'e') ADVANCE(447);
      if (lookahead == 'f') ADVANCE(378);
      if (lookahead == 'i') ADVANCE(355);
      if (lookahead == 'l') ADVANCE(347);
      if (lookahead == 'o') ADVANCE(403);
      if (lookahead == 'p') ADVANCE(317);
      if (lookahead == 't') ADVANCE(390);
      if (lookahead == 'u') ADVANCE(418);
      if (lookahead == '{') ADVANCE(173);
      if (lookahead == '|') ADVANCE(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(265);
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(451);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_module_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead == '/') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(168);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_statement_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(168);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '/') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(170);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(170);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_erlang);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_erlang);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_javascript);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_javascript);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(243);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(338);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_as);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '.') ADVANCE(238);
      if (lookahead == '/') ADVANCE(169);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_const);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(219);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(235);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(235);
      if (lookahead == '>') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(235);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(6);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_size);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_size);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_fn);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_external);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_type);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_try);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(225);
      if (lookahead == '<') ADVANCE(199);
      if (lookahead == '=') ADVANCE(224);
      if (lookahead == '>') ADVANCE(240);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(225);
      if (lookahead == '=') ADVANCE(224);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '.') ADVANCE(225);
      if (lookahead == '=') ADVANCE(224);
      if (lookahead == '>') ADVANCE(240);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '.') ADVANCE(226);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_LT_DOT);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_LT_EQ_DOT);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(230);
      if (lookahead == '=') ADVANCE(229);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '.') ADVANCE(230);
      if (lookahead == '=') ADVANCE(229);
      if (lookahead == '>') ADVANCE(200);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      if (lookahead == '.') ADVANCE(231);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_GT_DOT);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_GT_EQ_DOT);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(234);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_PLUS_DOT);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_DASH_DOT);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '.') ADVANCE(237);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_STAR_DOT);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_SLASH_DOT);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_todo);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_panic);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(232);
      if (lookahead == '|') ADVANCE(217);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(217);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_assert);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_use);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(220);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_visibility_modifier);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_visibility_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_opacity_modifier);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_opacity_modifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'e') ADVANCE(2);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(261);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(262);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym__hex);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(263);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(261);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(156);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(158);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(265);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == '.') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(265);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym__decimal);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(156);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(158);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(267);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym__decimal);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(267);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym__octal);
      if (('0' <= lookahead && lookahead <= '7') ||
          lookahead == '_') ADVANCE(268);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym__binary);
      if (lookahead == '0' ||
          lookahead == '1' ||
          lookahead == '_') ADVANCE(269);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_binary);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_bytes);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_bytes);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_int);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_bit_string);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_bit_string);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_bits);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_bits);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_utf8);
      if (lookahead == '_') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(29);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_utf16);
      if (lookahead == '_') ADVANCE(329);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(30);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_utf32);
      if (lookahead == '_') ADVANCE(330);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_utf8_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_utf16_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_utf32_codepoint);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_signed);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_signed);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_unsigned);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_big);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_big);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_little);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_little);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_native);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_native);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_unit);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_unit);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym__discard_name);
      if (lookahead == '.') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(306);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym__discard_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(307);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '.') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(308);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '1') ADVANCE(311);
      if (lookahead == '3') ADVANCE(310);
      if (lookahead == '8') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '2') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '6') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == '_') ADVANCE(425);
      if (lookahead == 's') ADVANCE(281);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(409);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(423);
      if (lookahead == 'o') ADVANCE(381);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(423);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(382);
      if (lookahead == 'u') ADVANCE(325);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(382);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(411);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(375);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(380);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(422);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(438);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'a') ADVANCE(431);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'b') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(394);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(414);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(400);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'c') ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(393);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(351);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(352);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'd') ADVANCE(353);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(415);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(301);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(303);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(428);
      if (lookahead == 'i') ADVANCE(443);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(428);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(332);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(413);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(419);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(404);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(407);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'e') ADVANCE(408);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(172);
      if (lookahead == 'm') ADVANCE(402);
      if (lookahead == 'n') ADVANCE(427);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(172);
      if (lookahead == 'm') ADVANCE(402);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'f') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(299);
      if (lookahead == 'n') ADVANCE(319);
      if (lookahead == 't') ADVANCE(312);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(279);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(385);
      if (lookahead == 'z') ADVANCE(340);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(450);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'g') ADVANCE(386);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(358);
      if (lookahead == 'y') ADVANCE(440);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(361);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(362);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(406);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(383);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(429);
      if (lookahead == 's') ADVANCE(366);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'i') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(396);
      if (lookahead == 'n') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(321);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'l') ADVANCE(342);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(370);
      if (lookahead == 's') ADVANCE(337);
      if (lookahead == 't') ADVANCE(357);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(359);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(424);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(365);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(360);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(320);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(348);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(435);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(436);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'n') ADVANCE(437);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(333);
      if (lookahead == 'r') ADVANCE(448);
      if (lookahead == 'y') ADVANCE(405);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(333);
      if (lookahead == 'r') ADVANCE(448);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(333);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(334);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(416);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(324);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(371);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(372);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(373);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'o') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(395);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(397);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(341);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(434);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(398);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'p') ADVANCE(399);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'q') ADVANCE(444);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(376);
      if (lookahead == 'x') ADVANCE(442);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(449);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(369);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(384);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(368);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(432);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'r') ADVANCE(433);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(338);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(328);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(430);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(441);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 's') ADVANCE(421);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(277);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(249);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(289);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(293);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(367);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(377);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(350);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(349);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 't') ADVANCE(439);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'u') ADVANCE(344);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(322);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'v') ADVANCE(343);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'x') ADVANCE(442);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym__name);
      if (lookahead == 'y') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym__name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(450);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym__upname);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(451);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 162},
  [2] = {.lex_state = 162},
  [3] = {.lex_state = 162},
  [4] = {.lex_state = 162},
  [5] = {.lex_state = 162},
  [6] = {.lex_state = 135},
  [7] = {.lex_state = 135},
  [8] = {.lex_state = 135},
  [9] = {.lex_state = 135},
  [10] = {.lex_state = 135},
  [11] = {.lex_state = 135},
  [12] = {.lex_state = 135},
  [13] = {.lex_state = 135},
  [14] = {.lex_state = 135},
  [15] = {.lex_state = 135},
  [16] = {.lex_state = 135},
  [17] = {.lex_state = 135},
  [18] = {.lex_state = 162},
  [19] = {.lex_state = 135},
  [20] = {.lex_state = 135},
  [21] = {.lex_state = 135},
  [22] = {.lex_state = 135},
  [23] = {.lex_state = 135},
  [24] = {.lex_state = 135},
  [25] = {.lex_state = 135},
  [26] = {.lex_state = 135},
  [27] = {.lex_state = 135},
  [28] = {.lex_state = 135},
  [29] = {.lex_state = 135},
  [30] = {.lex_state = 135},
  [31] = {.lex_state = 135},
  [32] = {.lex_state = 135},
  [33] = {.lex_state = 135},
  [34] = {.lex_state = 135},
  [35] = {.lex_state = 135},
  [36] = {.lex_state = 162},
  [37] = {.lex_state = 162},
  [38] = {.lex_state = 135},
  [39] = {.lex_state = 135},
  [40] = {.lex_state = 162},
  [41] = {.lex_state = 162},
  [42] = {.lex_state = 135},
  [43] = {.lex_state = 135},
  [44] = {.lex_state = 162},
  [45] = {.lex_state = 162},
  [46] = {.lex_state = 135},
  [47] = {.lex_state = 162},
  [48] = {.lex_state = 162},
  [49] = {.lex_state = 162},
  [50] = {.lex_state = 162},
  [51] = {.lex_state = 135},
  [52] = {.lex_state = 162},
  [53] = {.lex_state = 162},
  [54] = {.lex_state = 135},
  [55] = {.lex_state = 162},
  [56] = {.lex_state = 162},
  [57] = {.lex_state = 162},
  [58] = {.lex_state = 135},
  [59] = {.lex_state = 135},
  [60] = {.lex_state = 162},
  [61] = {.lex_state = 135},
  [62] = {.lex_state = 162},
  [63] = {.lex_state = 135},
  [64] = {.lex_state = 164},
  [65] = {.lex_state = 162},
  [66] = {.lex_state = 135},
  [67] = {.lex_state = 162},
  [68] = {.lex_state = 164},
  [69] = {.lex_state = 162},
  [70] = {.lex_state = 135},
  [71] = {.lex_state = 162},
  [72] = {.lex_state = 162},
  [73] = {.lex_state = 162},
  [74] = {.lex_state = 162},
  [75] = {.lex_state = 162},
  [76] = {.lex_state = 162},
  [77] = {.lex_state = 162},
  [78] = {.lex_state = 162},
  [79] = {.lex_state = 162},
  [80] = {.lex_state = 162},
  [81] = {.lex_state = 162},
  [82] = {.lex_state = 162},
  [83] = {.lex_state = 162},
  [84] = {.lex_state = 162},
  [85] = {.lex_state = 162},
  [86] = {.lex_state = 162},
  [87] = {.lex_state = 162},
  [88] = {.lex_state = 162},
  [89] = {.lex_state = 162},
  [90] = {.lex_state = 162},
  [91] = {.lex_state = 162},
  [92] = {.lex_state = 162},
  [93] = {.lex_state = 162},
  [94] = {.lex_state = 162},
  [95] = {.lex_state = 162},
  [96] = {.lex_state = 162},
  [97] = {.lex_state = 162},
  [98] = {.lex_state = 162},
  [99] = {.lex_state = 162},
  [100] = {.lex_state = 162},
  [101] = {.lex_state = 162},
  [102] = {.lex_state = 162},
  [103] = {.lex_state = 162},
  [104] = {.lex_state = 162},
  [105] = {.lex_state = 162},
  [106] = {.lex_state = 162},
  [107] = {.lex_state = 162},
  [108] = {.lex_state = 162},
  [109] = {.lex_state = 162},
  [110] = {.lex_state = 162},
  [111] = {.lex_state = 162},
  [112] = {.lex_state = 162},
  [113] = {.lex_state = 162},
  [114] = {.lex_state = 155},
  [115] = {.lex_state = 136},
  [116] = {.lex_state = 136},
  [117] = {.lex_state = 136},
  [118] = {.lex_state = 136},
  [119] = {.lex_state = 155},
  [120] = {.lex_state = 155},
  [121] = {.lex_state = 155},
  [122] = {.lex_state = 136},
  [123] = {.lex_state = 136},
  [124] = {.lex_state = 136},
  [125] = {.lex_state = 136},
  [126] = {.lex_state = 136},
  [127] = {.lex_state = 155},
  [128] = {.lex_state = 136},
  [129] = {.lex_state = 136},
  [130] = {.lex_state = 136},
  [131] = {.lex_state = 136},
  [132] = {.lex_state = 136},
  [133] = {.lex_state = 136},
  [134] = {.lex_state = 136},
  [135] = {.lex_state = 155},
  [136] = {.lex_state = 155},
  [137] = {.lex_state = 155},
  [138] = {.lex_state = 155},
  [139] = {.lex_state = 155},
  [140] = {.lex_state = 155},
  [141] = {.lex_state = 155},
  [142] = {.lex_state = 155},
  [143] = {.lex_state = 155},
  [144] = {.lex_state = 155},
  [145] = {.lex_state = 136},
  [146] = {.lex_state = 155},
  [147] = {.lex_state = 155},
  [148] = {.lex_state = 155},
  [149] = {.lex_state = 155},
  [150] = {.lex_state = 155},
  [151] = {.lex_state = 155},
  [152] = {.lex_state = 155},
  [153] = {.lex_state = 155},
  [154] = {.lex_state = 155},
  [155] = {.lex_state = 155},
  [156] = {.lex_state = 155},
  [157] = {.lex_state = 155},
  [158] = {.lex_state = 155},
  [159] = {.lex_state = 155},
  [160] = {.lex_state = 155},
  [161] = {.lex_state = 155},
  [162] = {.lex_state = 137},
  [163] = {.lex_state = 155},
  [164] = {.lex_state = 155},
  [165] = {.lex_state = 155},
  [166] = {.lex_state = 155},
  [167] = {.lex_state = 155},
  [168] = {.lex_state = 155},
  [169] = {.lex_state = 137},
  [170] = {.lex_state = 137},
  [171] = {.lex_state = 137},
  [172] = {.lex_state = 137},
  [173] = {.lex_state = 155},
  [174] = {.lex_state = 137},
  [175] = {.lex_state = 137},
  [176] = {.lex_state = 137},
  [177] = {.lex_state = 155},
  [178] = {.lex_state = 155},
  [179] = {.lex_state = 155},
  [180] = {.lex_state = 136},
  [181] = {.lex_state = 155},
  [182] = {.lex_state = 155},
  [183] = {.lex_state = 155},
  [184] = {.lex_state = 155},
  [185] = {.lex_state = 155},
  [186] = {.lex_state = 137},
  [187] = {.lex_state = 137},
  [188] = {.lex_state = 137},
  [189] = {.lex_state = 137},
  [190] = {.lex_state = 137},
  [191] = {.lex_state = 137},
  [192] = {.lex_state = 137},
  [193] = {.lex_state = 137},
  [194] = {.lex_state = 137},
  [195] = {.lex_state = 137},
  [196] = {.lex_state = 137},
  [197] = {.lex_state = 137},
  [198] = {.lex_state = 137},
  [199] = {.lex_state = 138},
  [200] = {.lex_state = 137},
  [201] = {.lex_state = 137},
  [202] = {.lex_state = 155},
  [203] = {.lex_state = 137},
  [204] = {.lex_state = 137},
  [205] = {.lex_state = 137},
  [206] = {.lex_state = 137},
  [207] = {.lex_state = 137},
  [208] = {.lex_state = 137},
  [209] = {.lex_state = 137},
  [210] = {.lex_state = 137},
  [211] = {.lex_state = 137},
  [212] = {.lex_state = 137},
  [213] = {.lex_state = 137},
  [214] = {.lex_state = 137},
  [215] = {.lex_state = 137},
  [216] = {.lex_state = 137},
  [217] = {.lex_state = 137},
  [218] = {.lex_state = 137},
  [219] = {.lex_state = 137},
  [220] = {.lex_state = 137},
  [221] = {.lex_state = 137},
  [222] = {.lex_state = 137},
  [223] = {.lex_state = 137},
  [224] = {.lex_state = 137},
  [225] = {.lex_state = 137},
  [226] = {.lex_state = 138},
  [227] = {.lex_state = 137},
  [228] = {.lex_state = 137},
  [229] = {.lex_state = 137},
  [230] = {.lex_state = 137},
  [231] = {.lex_state = 137},
  [232] = {.lex_state = 137},
  [233] = {.lex_state = 137},
  [234] = {.lex_state = 137},
  [235] = {.lex_state = 137},
  [236] = {.lex_state = 137},
  [237] = {.lex_state = 137},
  [238] = {.lex_state = 137},
  [239] = {.lex_state = 137},
  [240] = {.lex_state = 137},
  [241] = {.lex_state = 137},
  [242] = {.lex_state = 137},
  [243] = {.lex_state = 137},
  [244] = {.lex_state = 137},
  [245] = {.lex_state = 137},
  [246] = {.lex_state = 137},
  [247] = {.lex_state = 137},
  [248] = {.lex_state = 137},
  [249] = {.lex_state = 137},
  [250] = {.lex_state = 137},
  [251] = {.lex_state = 137},
  [252] = {.lex_state = 137},
  [253] = {.lex_state = 137},
  [254] = {.lex_state = 137},
  [255] = {.lex_state = 137},
  [256] = {.lex_state = 137},
  [257] = {.lex_state = 137},
  [258] = {.lex_state = 137},
  [259] = {.lex_state = 137},
  [260] = {.lex_state = 137},
  [261] = {.lex_state = 137},
  [262] = {.lex_state = 137},
  [263] = {.lex_state = 137},
  [264] = {.lex_state = 137},
  [265] = {.lex_state = 137},
  [266] = {.lex_state = 137},
  [267] = {.lex_state = 137},
  [268] = {.lex_state = 137},
  [269] = {.lex_state = 137},
  [270] = {.lex_state = 137},
  [271] = {.lex_state = 137},
  [272] = {.lex_state = 137},
  [273] = {.lex_state = 137},
  [274] = {.lex_state = 137},
  [275] = {.lex_state = 137},
  [276] = {.lex_state = 137},
  [277] = {.lex_state = 137},
  [278] = {.lex_state = 137},
  [279] = {.lex_state = 137},
  [280] = {.lex_state = 137},
  [281] = {.lex_state = 137},
  [282] = {.lex_state = 137},
  [283] = {.lex_state = 137},
  [284] = {.lex_state = 137},
  [285] = {.lex_state = 137},
  [286] = {.lex_state = 137},
  [287] = {.lex_state = 137},
  [288] = {.lex_state = 137},
  [289] = {.lex_state = 137},
  [290] = {.lex_state = 137},
  [291] = {.lex_state = 137},
  [292] = {.lex_state = 137},
  [293] = {.lex_state = 137},
  [294] = {.lex_state = 137},
  [295] = {.lex_state = 137},
  [296] = {.lex_state = 155},
  [297] = {.lex_state = 155},
  [298] = {.lex_state = 155},
  [299] = {.lex_state = 155},
  [300] = {.lex_state = 155},
  [301] = {.lex_state = 155},
  [302] = {.lex_state = 155},
  [303] = {.lex_state = 137},
  [304] = {.lex_state = 155},
  [305] = {.lex_state = 155},
  [306] = {.lex_state = 155},
  [307] = {.lex_state = 155},
  [308] = {.lex_state = 155},
  [309] = {.lex_state = 155},
  [310] = {.lex_state = 155},
  [311] = {.lex_state = 155},
  [312] = {.lex_state = 155},
  [313] = {.lex_state = 137},
  [314] = {.lex_state = 137},
  [315] = {.lex_state = 137},
  [316] = {.lex_state = 137},
  [317] = {.lex_state = 137},
  [318] = {.lex_state = 137},
  [319] = {.lex_state = 137},
  [320] = {.lex_state = 137},
  [321] = {.lex_state = 137},
  [322] = {.lex_state = 137},
  [323] = {.lex_state = 139},
  [324] = {.lex_state = 139},
  [325] = {.lex_state = 139},
  [326] = {.lex_state = 139},
  [327] = {.lex_state = 139},
  [328] = {.lex_state = 139},
  [329] = {.lex_state = 141},
  [330] = {.lex_state = 142},
  [331] = {.lex_state = 142},
  [332] = {.lex_state = 142},
  [333] = {.lex_state = 142},
  [334] = {.lex_state = 142},
  [335] = {.lex_state = 142},
  [336] = {.lex_state = 142},
  [337] = {.lex_state = 142},
  [338] = {.lex_state = 142},
  [339] = {.lex_state = 142},
  [340] = {.lex_state = 142},
  [341] = {.lex_state = 142},
  [342] = {.lex_state = 142},
  [343] = {.lex_state = 142},
  [344] = {.lex_state = 142},
  [345] = {.lex_state = 143},
  [346] = {.lex_state = 142},
  [347] = {.lex_state = 142},
  [348] = {.lex_state = 142},
  [349] = {.lex_state = 142},
  [350] = {.lex_state = 142},
  [351] = {.lex_state = 142},
  [352] = {.lex_state = 142},
  [353] = {.lex_state = 142},
  [354] = {.lex_state = 142},
  [355] = {.lex_state = 142},
  [356] = {.lex_state = 143},
  [357] = {.lex_state = 142},
  [358] = {.lex_state = 142},
  [359] = {.lex_state = 142},
  [360] = {.lex_state = 142},
  [361] = {.lex_state = 142},
  [362] = {.lex_state = 142},
  [363] = {.lex_state = 142},
  [364] = {.lex_state = 142},
  [365] = {.lex_state = 142},
  [366] = {.lex_state = 142},
  [367] = {.lex_state = 142},
  [368] = {.lex_state = 142},
  [369] = {.lex_state = 142},
  [370] = {.lex_state = 142},
  [371] = {.lex_state = 142},
  [372] = {.lex_state = 142},
  [373] = {.lex_state = 142},
  [374] = {.lex_state = 142},
  [375] = {.lex_state = 142},
  [376] = {.lex_state = 142},
  [377] = {.lex_state = 142},
  [378] = {.lex_state = 142},
  [379] = {.lex_state = 142},
  [380] = {.lex_state = 142},
  [381] = {.lex_state = 142},
  [382] = {.lex_state = 142},
  [383] = {.lex_state = 142},
  [384] = {.lex_state = 142},
  [385] = {.lex_state = 142},
  [386] = {.lex_state = 142},
  [387] = {.lex_state = 142},
  [388] = {.lex_state = 142},
  [389] = {.lex_state = 142},
  [390] = {.lex_state = 142},
  [391] = {.lex_state = 142},
  [392] = {.lex_state = 142},
  [393] = {.lex_state = 164},
  [394] = {.lex_state = 164},
  [395] = {.lex_state = 164},
  [396] = {.lex_state = 163},
  [397] = {.lex_state = 164},
  [398] = {.lex_state = 162},
  [399] = {.lex_state = 163},
  [400] = {.lex_state = 162},
  [401] = {.lex_state = 164},
  [402] = {.lex_state = 141},
  [403] = {.lex_state = 141},
  [404] = {.lex_state = 163},
  [405] = {.lex_state = 164},
  [406] = {.lex_state = 163},
  [407] = {.lex_state = 141},
  [408] = {.lex_state = 141},
  [409] = {.lex_state = 162},
  [410] = {.lex_state = 163},
  [411] = {.lex_state = 141},
  [412] = {.lex_state = 163},
  [413] = {.lex_state = 141},
  [414] = {.lex_state = 141},
  [415] = {.lex_state = 164},
  [416] = {.lex_state = 141},
  [417] = {.lex_state = 164},
  [418] = {.lex_state = 141},
  [419] = {.lex_state = 164},
  [420] = {.lex_state = 141},
  [421] = {.lex_state = 142},
  [422] = {.lex_state = 142},
  [423] = {.lex_state = 141},
  [424] = {.lex_state = 141},
  [425] = {.lex_state = 141},
  [426] = {.lex_state = 162},
  [427] = {.lex_state = 142},
  [428] = {.lex_state = 142},
  [429] = {.lex_state = 141},
  [430] = {.lex_state = 163},
  [431] = {.lex_state = 163},
  [432] = {.lex_state = 164},
  [433] = {.lex_state = 141},
  [434] = {.lex_state = 163},
  [435] = {.lex_state = 163},
  [436] = {.lex_state = 162},
  [437] = {.lex_state = 162},
  [438] = {.lex_state = 162},
  [439] = {.lex_state = 162},
  [440] = {.lex_state = 162},
  [441] = {.lex_state = 142},
  [442] = {.lex_state = 162},
  [443] = {.lex_state = 141},
  [444] = {.lex_state = 162},
  [445] = {.lex_state = 162},
  [446] = {.lex_state = 162},
  [447] = {.lex_state = 162},
  [448] = {.lex_state = 142},
  [449] = {.lex_state = 162},
  [450] = {.lex_state = 162},
  [451] = {.lex_state = 162},
  [452] = {.lex_state = 162},
  [453] = {.lex_state = 162},
  [454] = {.lex_state = 162},
  [455] = {.lex_state = 162},
  [456] = {.lex_state = 162},
  [457] = {.lex_state = 162},
  [458] = {.lex_state = 142},
  [459] = {.lex_state = 162},
  [460] = {.lex_state = 162},
  [461] = {.lex_state = 162},
  [462] = {.lex_state = 162},
  [463] = {.lex_state = 162},
  [464] = {.lex_state = 162},
  [465] = {.lex_state = 162},
  [466] = {.lex_state = 139},
  [467] = {.lex_state = 162},
  [468] = {.lex_state = 142},
  [469] = {.lex_state = 162},
  [470] = {.lex_state = 162},
  [471] = {.lex_state = 162},
  [472] = {.lex_state = 162},
  [473] = {.lex_state = 162},
  [474] = {.lex_state = 162},
  [475] = {.lex_state = 162},
  [476] = {.lex_state = 141},
  [477] = {.lex_state = 141},
  [478] = {.lex_state = 141},
  [479] = {.lex_state = 162},
  [480] = {.lex_state = 139},
  [481] = {.lex_state = 162},
  [482] = {.lex_state = 162},
  [483] = {.lex_state = 141},
  [484] = {.lex_state = 162},
  [485] = {.lex_state = 162},
  [486] = {.lex_state = 141},
  [487] = {.lex_state = 162},
  [488] = {.lex_state = 162},
  [489] = {.lex_state = 142},
  [490] = {.lex_state = 162},
  [491] = {.lex_state = 162},
  [492] = {.lex_state = 141},
  [493] = {.lex_state = 141},
  [494] = {.lex_state = 162},
  [495] = {.lex_state = 162},
  [496] = {.lex_state = 162},
  [497] = {.lex_state = 162},
  [498] = {.lex_state = 139},
  [499] = {.lex_state = 162},
  [500] = {.lex_state = 139},
  [501] = {.lex_state = 162},
  [502] = {.lex_state = 162},
  [503] = {.lex_state = 139},
  [504] = {.lex_state = 162},
  [505] = {.lex_state = 139},
  [506] = {.lex_state = 141},
  [507] = {.lex_state = 141},
  [508] = {.lex_state = 141},
  [509] = {.lex_state = 162},
  [510] = {.lex_state = 162},
  [511] = {.lex_state = 162},
  [512] = {.lex_state = 162},
  [513] = {.lex_state = 162},
  [514] = {.lex_state = 141},
  [515] = {.lex_state = 162},
  [516] = {.lex_state = 162},
  [517] = {.lex_state = 162},
  [518] = {.lex_state = 162},
  [519] = {.lex_state = 162},
  [520] = {.lex_state = 162},
  [521] = {.lex_state = 162},
  [522] = {.lex_state = 162},
  [523] = {.lex_state = 141},
  [524] = {.lex_state = 141},
  [525] = {.lex_state = 141},
  [526] = {.lex_state = 139},
  [527] = {.lex_state = 141},
  [528] = {.lex_state = 141},
  [529] = {.lex_state = 141},
  [530] = {.lex_state = 141},
  [531] = {.lex_state = 141},
  [532] = {.lex_state = 141},
  [533] = {.lex_state = 141},
  [534] = {.lex_state = 141},
  [535] = {.lex_state = 141},
  [536] = {.lex_state = 141},
  [537] = {.lex_state = 141},
  [538] = {.lex_state = 141},
  [539] = {.lex_state = 141},
  [540] = {.lex_state = 141},
  [541] = {.lex_state = 141},
  [542] = {.lex_state = 141},
  [543] = {.lex_state = 141},
  [544] = {.lex_state = 141},
  [545] = {.lex_state = 141},
  [546] = {.lex_state = 141},
  [547] = {.lex_state = 141},
  [548] = {.lex_state = 141},
  [549] = {.lex_state = 139},
  [550] = {.lex_state = 141},
  [551] = {.lex_state = 141},
  [552] = {.lex_state = 139},
  [553] = {.lex_state = 141},
  [554] = {.lex_state = 142},
  [555] = {.lex_state = 139},
  [556] = {.lex_state = 144},
  [557] = {.lex_state = 145},
  [558] = {.lex_state = 139},
  [559] = {.lex_state = 146},
  [560] = {.lex_state = 139},
  [561] = {.lex_state = 145},
  [562] = {.lex_state = 144},
  [563] = {.lex_state = 145},
  [564] = {.lex_state = 142},
  [565] = {.lex_state = 145},
  [566] = {.lex_state = 142},
  [567] = {.lex_state = 147},
  [568] = {.lex_state = 147},
  [569] = {.lex_state = 147},
  [570] = {.lex_state = 141},
  [571] = {.lex_state = 147},
  [572] = {.lex_state = 147},
  [573] = {.lex_state = 148},
  [574] = {.lex_state = 147},
  [575] = {.lex_state = 147},
  [576] = {.lex_state = 144},
  [577] = {.lex_state = 142},
  [578] = {.lex_state = 142},
  [579] = {.lex_state = 148},
  [580] = {.lex_state = 142},
  [581] = {.lex_state = 147},
  [582] = {.lex_state = 144},
  [583] = {.lex_state = 147},
  [584] = {.lex_state = 147},
  [585] = {.lex_state = 142},
  [586] = {.lex_state = 146},
  [587] = {.lex_state = 142},
  [588] = {.lex_state = 146},
  [589] = {.lex_state = 142},
  [590] = {.lex_state = 142},
  [591] = {.lex_state = 146},
  [592] = {.lex_state = 141},
  [593] = {.lex_state = 142},
  [594] = {.lex_state = 146},
  [595] = {.lex_state = 146},
  [596] = {.lex_state = 146},
  [597] = {.lex_state = 146},
  [598] = {.lex_state = 146},
  [599] = {.lex_state = 146},
  [600] = {.lex_state = 146},
  [601] = {.lex_state = 142},
  [602] = {.lex_state = 142},
  [603] = {.lex_state = 141},
  [604] = {.lex_state = 142},
  [605] = {.lex_state = 146},
  [606] = {.lex_state = 146},
  [607] = {.lex_state = 146},
  [608] = {.lex_state = 146},
  [609] = {.lex_state = 142},
  [610] = {.lex_state = 146},
  [611] = {.lex_state = 142},
  [612] = {.lex_state = 146},
  [613] = {.lex_state = 141},
  [614] = {.lex_state = 142},
  [615] = {.lex_state = 142},
  [616] = {.lex_state = 146},
  [617] = {.lex_state = 142},
  [618] = {.lex_state = 142},
  [619] = {.lex_state = 146},
  [620] = {.lex_state = 141},
  [621] = {.lex_state = 147},
  [622] = {.lex_state = 142},
  [623] = {.lex_state = 147},
  [624] = {.lex_state = 147},
  [625] = {.lex_state = 142},
  [626] = {.lex_state = 141},
  [627] = {.lex_state = 147},
  [628] = {.lex_state = 141},
  [629] = {.lex_state = 147},
  [630] = {.lex_state = 141},
  [631] = {.lex_state = 147},
  [632] = {.lex_state = 142},
  [633] = {.lex_state = 147},
  [634] = {.lex_state = 142},
  [635] = {.lex_state = 147},
  [636] = {.lex_state = 142},
  [637] = {.lex_state = 147},
  [638] = {.lex_state = 141},
  [639] = {.lex_state = 141},
  [640] = {.lex_state = 147},
  [641] = {.lex_state = 141},
  [642] = {.lex_state = 141},
  [643] = {.lex_state = 147},
  [644] = {.lex_state = 147},
  [645] = {.lex_state = 147},
  [646] = {.lex_state = 147},
  [647] = {.lex_state = 147},
  [648] = {.lex_state = 147},
  [649] = {.lex_state = 147},
  [650] = {.lex_state = 147},
  [651] = {.lex_state = 141},
  [652] = {.lex_state = 142},
  [653] = {.lex_state = 142},
  [654] = {.lex_state = 147},
  [655] = {.lex_state = 142},
  [656] = {.lex_state = 147},
  [657] = {.lex_state = 141},
  [658] = {.lex_state = 147},
  [659] = {.lex_state = 147},
  [660] = {.lex_state = 147},
  [661] = {.lex_state = 141},
  [662] = {.lex_state = 141},
  [663] = {.lex_state = 141},
  [664] = {.lex_state = 141},
  [665] = {.lex_state = 147},
  [666] = {.lex_state = 141},
  [667] = {.lex_state = 141},
  [668] = {.lex_state = 141},
  [669] = {.lex_state = 147},
  [670] = {.lex_state = 147},
  [671] = {.lex_state = 141},
  [672] = {.lex_state = 147},
  [673] = {.lex_state = 147},
  [674] = {.lex_state = 141},
  [675] = {.lex_state = 141},
  [676] = {.lex_state = 147},
  [677] = {.lex_state = 147},
  [678] = {.lex_state = 147},
  [679] = {.lex_state = 141},
  [680] = {.lex_state = 141},
  [681] = {.lex_state = 147},
  [682] = {.lex_state = 147},
  [683] = {.lex_state = 141},
  [684] = {.lex_state = 141},
  [685] = {.lex_state = 141},
  [686] = {.lex_state = 141},
  [687] = {.lex_state = 147},
  [688] = {.lex_state = 147},
  [689] = {.lex_state = 147},
  [690] = {.lex_state = 135},
  [691] = {.lex_state = 147},
  [692] = {.lex_state = 147},
  [693] = {.lex_state = 147},
  [694] = {.lex_state = 147},
  [695] = {.lex_state = 135},
  [696] = {.lex_state = 135},
  [697] = {.lex_state = 147},
  [698] = {.lex_state = 147},
  [699] = {.lex_state = 147},
  [700] = {.lex_state = 147},
  [701] = {.lex_state = 149},
  [702] = {.lex_state = 139},
  [703] = {.lex_state = 139},
  [704] = {.lex_state = 139},
  [705] = {.lex_state = 150},
  [706] = {.lex_state = 151},
  [707] = {.lex_state = 151},
  [708] = {.lex_state = 151},
  [709] = {.lex_state = 149},
  [710] = {.lex_state = 151},
  [711] = {.lex_state = 151},
  [712] = {.lex_state = 149},
  [713] = {.lex_state = 151},
  [714] = {.lex_state = 151},
  [715] = {.lex_state = 151},
  [716] = {.lex_state = 149},
  [717] = {.lex_state = 151},
  [718] = {.lex_state = 151},
  [719] = {.lex_state = 151},
  [720] = {.lex_state = 151},
  [721] = {.lex_state = 151},
  [722] = {.lex_state = 151},
  [723] = {.lex_state = 151},
  [724] = {.lex_state = 151},
  [725] = {.lex_state = 151},
  [726] = {.lex_state = 151},
  [727] = {.lex_state = 151},
  [728] = {.lex_state = 151},
  [729] = {.lex_state = 151},
  [730] = {.lex_state = 151},
  [731] = {.lex_state = 151},
  [732] = {.lex_state = 151},
  [733] = {.lex_state = 149},
  [734] = {.lex_state = 152},
  [735] = {.lex_state = 151},
  [736] = {.lex_state = 151},
  [737] = {.lex_state = 151},
  [738] = {.lex_state = 151},
  [739] = {.lex_state = 151},
  [740] = {.lex_state = 151},
  [741] = {.lex_state = 151},
  [742] = {.lex_state = 149},
  [743] = {.lex_state = 151},
  [744] = {.lex_state = 141},
  [745] = {.lex_state = 151},
  [746] = {.lex_state = 146},
  [747] = {.lex_state = 149},
  [748] = {.lex_state = 146},
  [749] = {.lex_state = 146},
  [750] = {.lex_state = 146},
  [751] = {.lex_state = 146},
  [752] = {.lex_state = 149},
  [753] = {.lex_state = 149},
  [754] = {.lex_state = 149},
  [755] = {.lex_state = 151},
  [756] = {.lex_state = 146},
  [757] = {.lex_state = 151},
  [758] = {.lex_state = 151},
  [759] = {.lex_state = 151},
  [760] = {.lex_state = 151},
  [761] = {.lex_state = 149},
  [762] = {.lex_state = 151},
  [763] = {.lex_state = 151},
  [764] = {.lex_state = 149},
  [765] = {.lex_state = 151},
  [766] = {.lex_state = 151},
  [767] = {.lex_state = 151},
  [768] = {.lex_state = 151},
  [769] = {.lex_state = 151},
  [770] = {.lex_state = 151},
  [771] = {.lex_state = 151},
  [772] = {.lex_state = 151},
  [773] = {.lex_state = 149},
  [774] = {.lex_state = 151},
  [775] = {.lex_state = 151},
  [776] = {.lex_state = 151},
  [777] = {.lex_state = 149},
  [778] = {.lex_state = 151},
  [779] = {.lex_state = 151},
  [780] = {.lex_state = 151},
  [781] = {.lex_state = 151},
  [782] = {.lex_state = 149},
  [783] = {.lex_state = 151},
  [784] = {.lex_state = 151},
  [785] = {.lex_state = 149},
  [786] = {.lex_state = 151},
  [787] = {.lex_state = 149},
  [788] = {.lex_state = 146},
  [789] = {.lex_state = 146},
  [790] = {.lex_state = 146},
  [791] = {.lex_state = 151},
  [792] = {.lex_state = 151},
  [793] = {.lex_state = 152},
  [794] = {.lex_state = 151},
  [795] = {.lex_state = 152},
  [796] = {.lex_state = 152},
  [797] = {.lex_state = 152},
  [798] = {.lex_state = 152},
  [799] = {.lex_state = 141},
  [800] = {.lex_state = 139},
  [801] = {.lex_state = 151},
  [802] = {.lex_state = 146},
  [803] = {.lex_state = 152},
  [804] = {.lex_state = 152},
  [805] = {.lex_state = 152},
  [806] = {.lex_state = 152},
  [807] = {.lex_state = 141},
  [808] = {.lex_state = 141},
  [809] = {.lex_state = 141},
  [810] = {.lex_state = 152},
  [811] = {.lex_state = 149},
  [812] = {.lex_state = 152},
  [813] = {.lex_state = 152},
  [814] = {.lex_state = 151},
  [815] = {.lex_state = 152},
  [816] = {.lex_state = 139},
  [817] = {.lex_state = 152},
  [818] = {.lex_state = 152},
  [819] = {.lex_state = 152},
  [820] = {.lex_state = 151},
  [821] = {.lex_state = 152},
  [822] = {.lex_state = 152},
  [823] = {.lex_state = 146},
  [824] = {.lex_state = 152},
  [825] = {.lex_state = 146},
  [826] = {.lex_state = 146},
  [827] = {.lex_state = 152},
  [828] = {.lex_state = 152},
  [829] = {.lex_state = 146},
  [830] = {.lex_state = 146},
  [831] = {.lex_state = 146},
  [832] = {.lex_state = 146},
  [833] = {.lex_state = 152},
  [834] = {.lex_state = 152},
  [835] = {.lex_state = 152},
  [836] = {.lex_state = 139},
  [837] = {.lex_state = 152},
  [838] = {.lex_state = 152},
  [839] = {.lex_state = 152},
  [840] = {.lex_state = 152},
  [841] = {.lex_state = 139},
  [842] = {.lex_state = 149},
  [843] = {.lex_state = 149},
  [844] = {.lex_state = 149},
  [845] = {.lex_state = 152},
  [846] = {.lex_state = 153},
  [847] = {.lex_state = 149},
  [848] = {.lex_state = 139},
  [849] = {.lex_state = 149},
  [850] = {.lex_state = 149},
  [851] = {.lex_state = 153},
  [852] = {.lex_state = 149},
  [853] = {.lex_state = 153},
  [854] = {.lex_state = 154},
  [855] = {.lex_state = 139},
  [856] = {.lex_state = 139},
  [857] = {.lex_state = 139},
  [858] = {.lex_state = 149},
  [859] = {.lex_state = 139},
  [860] = {.lex_state = 153},
  [861] = {.lex_state = 154},
  [862] = {.lex_state = 139},
  [863] = {.lex_state = 139},
  [864] = {.lex_state = 152},
  [865] = {.lex_state = 139},
  [866] = {.lex_state = 139},
  [867] = {.lex_state = 139},
  [868] = {.lex_state = 139},
  [869] = {.lex_state = 139},
  [870] = {.lex_state = 139},
  [871] = {.lex_state = 139},
  [872] = {.lex_state = 152},
  [873] = {.lex_state = 139},
  [874] = {.lex_state = 139},
  [875] = {.lex_state = 139},
  [876] = {.lex_state = 139},
  [877] = {.lex_state = 139},
  [878] = {.lex_state = 139},
  [879] = {.lex_state = 152},
  [880] = {.lex_state = 139},
  [881] = {.lex_state = 152},
  [882] = {.lex_state = 149},
  [883] = {.lex_state = 139},
  [884] = {.lex_state = 139},
  [885] = {.lex_state = 139},
  [886] = {.lex_state = 154},
  [887] = {.lex_state = 139},
  [888] = {.lex_state = 139},
  [889] = {.lex_state = 139},
  [890] = {.lex_state = 139},
  [891] = {.lex_state = 139},
  [892] = {.lex_state = 139},
  [893] = {.lex_state = 139},
  [894] = {.lex_state = 139},
  [895] = {.lex_state = 139},
  [896] = {.lex_state = 139},
  [897] = {.lex_state = 139},
  [898] = {.lex_state = 139},
  [899] = {.lex_state = 152},
  [900] = {.lex_state = 152},
  [901] = {.lex_state = 153},
  [902] = {.lex_state = 153},
  [903] = {.lex_state = 153},
  [904] = {.lex_state = 152},
  [905] = {.lex_state = 152},
  [906] = {.lex_state = 153},
  [907] = {.lex_state = 154},
  [908] = {.lex_state = 154},
  [909] = {.lex_state = 154},
  [910] = {.lex_state = 154},
  [911] = {.lex_state = 139},
  [912] = {.lex_state = 154},
  [913] = {.lex_state = 154},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 139},
  [916] = {.lex_state = 139},
  [917] = {.lex_state = 154},
  [918] = {.lex_state = 154},
  [919] = {.lex_state = 154},
  [920] = {.lex_state = 154},
  [921] = {.lex_state = 154},
  [922] = {.lex_state = 154},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 154},
  [925] = {.lex_state = 139},
  [926] = {.lex_state = 139},
  [927] = {.lex_state = 154},
  [928] = {.lex_state = 154},
  [929] = {.lex_state = 154},
  [930] = {.lex_state = 139},
  [931] = {.lex_state = 152},
  [932] = {.lex_state = 154},
  [933] = {.lex_state = 154},
  [934] = {.lex_state = 139},
  [935] = {.lex_state = 153},
  [936] = {.lex_state = 139},
  [937] = {.lex_state = 139},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 152},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 152},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 153},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 149},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 139},
  [953] = {.lex_state = 152},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 136},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 154},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 154},
  [960] = {.lex_state = 139, .external_lex_state = 1},
  [961] = {.lex_state = 139, .external_lex_state = 1},
  [962] = {.lex_state = 139},
  [963] = {.lex_state = 139},
  [964] = {.lex_state = 136},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 139, .external_lex_state = 1},
  [967] = {.lex_state = 139},
  [968] = {.lex_state = 139, .external_lex_state = 1},
  [969] = {.lex_state = 139, .external_lex_state = 1},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 139},
  [974] = {.lex_state = 139, .external_lex_state = 1},
  [975] = {.lex_state = 139},
  [976] = {.lex_state = 139, .external_lex_state = 1},
  [977] = {.lex_state = 139, .external_lex_state = 1},
  [978] = {.lex_state = 139},
  [979] = {.lex_state = 154},
  [980] = {.lex_state = 139},
  [981] = {.lex_state = 139},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 154},
  [984] = {.lex_state = 139},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 139, .external_lex_state = 1},
  [987] = {.lex_state = 139},
  [988] = {.lex_state = 139},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 139, .external_lex_state = 1},
  [992] = {.lex_state = 139, .external_lex_state = 1},
  [993] = {.lex_state = 152},
  [994] = {.lex_state = 139},
  [995] = {.lex_state = 139, .external_lex_state = 1},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 153},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 139},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 139},
  [1003] = {.lex_state = 154},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 154},
  [1006] = {.lex_state = 136},
  [1007] = {.lex_state = 154},
  [1008] = {.lex_state = 152},
  [1009] = {.lex_state = 139, .external_lex_state = 1},
  [1010] = {.lex_state = 152},
  [1011] = {.lex_state = 154},
  [1012] = {.lex_state = 139},
  [1013] = {.lex_state = 154},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 154},
  [1016] = {.lex_state = 154},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 154},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 154},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 136},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 139},
  [1037] = {.lex_state = 162},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 139},
  [1047] = {.lex_state = 136},
  [1048] = {.lex_state = 139},
  [1049] = {.lex_state = 136},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 136},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 136},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 136},
  [1057] = {.lex_state = 139},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 139},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 136},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 139},
  [1074] = {.lex_state = 136},
  [1075] = {.lex_state = 136},
  [1076] = {.lex_state = 136},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 146},
  [1079] = {.lex_state = 136},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 152},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 136},
  [1088] = {.lex_state = 136},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 139},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 139},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 154},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 139},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 136},
  [1107] = {.lex_state = 154},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 136},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 136},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 162},
  [1119] = {.lex_state = 136},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 136},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 136},
  [1128] = {.lex_state = 136},
  [1129] = {.lex_state = 162},
  [1130] = {.lex_state = 136},
  [1131] = {.lex_state = 162},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 136},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 154},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 154},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 136},
  [1156] = {.lex_state = 154},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 139},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 136},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 139},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 136},
  [1177] = {.lex_state = 154},
  [1178] = {.lex_state = 154},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 136},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 154},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 154},
  [1185] = {.lex_state = 0},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 0},
  [1189] = {.lex_state = 0},
  [1190] = {.lex_state = 154},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 136},
  [1193] = {.lex_state = 154},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 154},
  [1200] = {.lex_state = 154},
  [1201] = {.lex_state = 0},
  [1202] = {.lex_state = 0},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 0},
  [1205] = {.lex_state = 154},
  [1206] = {.lex_state = 0},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 139},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 162},
  [1217] = {.lex_state = 136},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 154},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 139},
  [1224] = {.lex_state = 154},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 0},
  [1228] = {.lex_state = 0},
  [1229] = {.lex_state = 136},
  [1230] = {.lex_state = 0},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 154},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 162},
  [1235] = {.lex_state = 0},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 162},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 154},
  [1246] = {.lex_state = 162},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 0},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 0},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 0},
  [1258] = {.lex_state = 154},
  [1259] = {.lex_state = 154},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 0},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 154},
  [1264] = {.lex_state = 0},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 0},
  [1270] = {.lex_state = 154},
  [1271] = {.lex_state = 0},
  [1272] = {.lex_state = 0},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 0},
  [1276] = {.lex_state = 0},
  [1277] = {.lex_state = 154},
  [1278] = {.lex_state = 154},
  [1279] = {.lex_state = 162},
  [1280] = {.lex_state = 0},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 139},
  [1284] = {.lex_state = 154},
  [1285] = {.lex_state = 154},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 0},
  [1288] = {.lex_state = 154},
  [1289] = {.lex_state = 0},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 0},
  [1292] = {.lex_state = 0},
  [1293] = {.lex_state = 0},
  [1294] = {.lex_state = 0},
  [1295] = {.lex_state = 154},
  [1296] = {.lex_state = 0},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 0},
  [1299] = {.lex_state = 162},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 154},
  [1302] = {.lex_state = 0},
  [1303] = {.lex_state = 154},
  [1304] = {.lex_state = 136},
  [1305] = {.lex_state = 154},
  [1306] = {.lex_state = 0},
  [1307] = {.lex_state = 139},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 154},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 0},
  [1314] = {.lex_state = 139},
  [1315] = {.lex_state = 0},
  [1316] = {.lex_state = 0},
  [1317] = {.lex_state = 136},
  [1318] = {.lex_state = 136},
  [1319] = {.lex_state = 0},
  [1320] = {.lex_state = 0},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 0},
  [1324] = {.lex_state = 0},
  [1325] = {.lex_state = 0},
  [1326] = {.lex_state = 0},
  [1327] = {.lex_state = 0},
  [1328] = {.lex_state = 0},
  [1329] = {.lex_state = 0},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 0},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 0},
  [1334] = {.lex_state = 154},
  [1335] = {.lex_state = 0},
  [1336] = {.lex_state = 0},
  [1337] = {.lex_state = 136},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 0},
  [1340] = {.lex_state = 0},
  [1341] = {.lex_state = 0},
  [1342] = {.lex_state = 0},
  [1343] = {.lex_state = 0},
  [1344] = {.lex_state = 0},
  [1345] = {.lex_state = 0},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 0},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 0},
  [1352] = {.lex_state = 0},
  [1353] = {.lex_state = 0},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 136},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 0},
  [1361] = {.lex_state = 0},
  [1362] = {.lex_state = 0},
  [1363] = {.lex_state = 136},
  [1364] = {.lex_state = 0},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 136},
  [1367] = {.lex_state = 0},
  [1368] = {.lex_state = 0},
  [1369] = {.lex_state = 136},
  [1370] = {.lex_state = 0},
  [1371] = {.lex_state = 136},
  [1372] = {.lex_state = 0},
  [1373] = {.lex_state = 0},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 0},
  [1376] = {.lex_state = 0},
  [1377] = {.lex_state = 0},
  [1378] = {.lex_state = 0},
  [1379] = {.lex_state = 0},
  [1380] = {.lex_state = 136},
  [1381] = {.lex_state = 0},
  [1382] = {.lex_state = 0},
  [1383] = {.lex_state = 0},
  [1384] = {.lex_state = 0},
  [1385] = {.lex_state = 0},
  [1386] = {.lex_state = 0},
  [1387] = {.lex_state = 0},
  [1388] = {.lex_state = 136},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 0},
  [1392] = {.lex_state = 0},
  [1393] = {.lex_state = 0},
  [1394] = {.lex_state = 139},
  [1395] = {.lex_state = 139},
  [1396] = {.lex_state = 0},
  [1397] = {.lex_state = 136},
  [1398] = {.lex_state = 139},
  [1399] = {.lex_state = 136},
  [1400] = {.lex_state = 0},
  [1401] = {.lex_state = 0},
  [1402] = {.lex_state = 0},
  [1403] = {.lex_state = 0},
  [1404] = {.lex_state = 0},
  [1405] = {.lex_state = 154},
  [1406] = {.lex_state = 0},
  [1407] = {.lex_state = 0},
  [1408] = {.lex_state = 0},
  [1409] = {.lex_state = 0},
  [1410] = {.lex_state = 136},
  [1411] = {.lex_state = 0},
  [1412] = {.lex_state = 0},
  [1413] = {.lex_state = 0},
  [1414] = {.lex_state = 0},
  [1415] = {.lex_state = 0},
  [1416] = {.lex_state = 136},
  [1417] = {.lex_state = 0},
  [1418] = {.lex_state = 0},
  [1419] = {.lex_state = 0},
  [1420] = {.lex_state = 0},
  [1421] = {.lex_state = 136},
  [1422] = {.lex_state = 0},
  [1423] = {.lex_state = 0},
  [1424] = {.lex_state = 0},
  [1425] = {.lex_state = 0},
  [1426] = {.lex_state = 0},
  [1427] = {.lex_state = 136},
  [1428] = {.lex_state = 136},
  [1429] = {.lex_state = 0},
  [1430] = {.lex_state = 0},
};

enum {
  ts_external_token_quoted_content = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_quoted_content] = sym_quoted_content,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_quoted_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_erlang] = ACTIONS(1),
    [anon_sym_javascript] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_size] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT_DOT] = ACTIONS(1),
    [anon_sym_LT_EQ_DOT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_DOT] = ACTIONS(1),
    [anon_sym_GT_EQ_DOT] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PLUS_DOT] = ACTIONS(1),
    [anon_sym_DASH_DOT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_DOT] = ACTIONS(1),
    [anon_sym_SLASH_DOT] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_todo] = ACTIONS(1),
    [anon_sym_panic] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_visibility_modifier] = ACTIONS(1),
    [sym_opacity_modifier] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym__hex] = ACTIONS(1),
    [sym__decimal] = ACTIONS(1),
    [sym__octal] = ACTIONS(1),
    [sym__binary] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_bit_string] = ACTIONS(1),
    [anon_sym_bits] = ACTIONS(1),
    [anon_sym_utf8] = ACTIONS(1),
    [anon_sym_utf16] = ACTIONS(1),
    [anon_sym_utf32] = ACTIONS(1),
    [anon_sym_utf8_codepoint] = ACTIONS(1),
    [anon_sym_utf16_codepoint] = ACTIONS(1),
    [anon_sym_utf32_codepoint] = ACTIONS(1),
    [anon_sym_signed] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_big] = ACTIONS(1),
    [anon_sym_little] = ACTIONS(1),
    [anon_sym_native] = ACTIONS(1),
    [anon_sym_unit] = ACTIONS(1),
    [sym__discard_name] = ACTIONS(1),
    [sym__name] = ACTIONS(1),
    [sym__upname] = ACTIONS(1),
    [sym_quoted_content] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1391),
    [sym__module_statement] = STATE(2),
    [sym_target_group] = STATE(2),
    [sym_attribute] = STATE(2),
    [sym_import] = STATE(2),
    [sym_constant] = STATE(2),
    [sym_external_type] = STATE(2),
    [sym_external_function] = STATE(2),
    [sym_function] = STATE(2),
    [aux_sym__statement_seq] = STATE(4),
    [sym_try] = STATE(461),
    [sym__statement] = STATE(461),
    [sym__expression] = STATE(105),
    [sym_binary_expression] = STATE(105),
    [sym__expression_unit] = STATE(105),
    [sym_record] = STATE(67),
    [sym_todo] = STATE(105),
    [sym_panic] = STATE(105),
    [sym_tuple] = STATE(79),
    [sym_list] = STATE(105),
    [sym__expression_bit_string] = STATE(105),
    [sym_anonymous_function] = STATE(73),
    [sym_block] = STATE(47),
    [sym_case] = STATE(47),
    [sym_let_assert] = STATE(461),
    [sym_let] = STATE(461),
    [sym_use] = STATE(461),
    [sym_assert] = STATE(105),
    [sym_boolean_negation] = STATE(105),
    [sym_integer_negation] = STATE(105),
    [sym_record_update] = STATE(67),
    [sym__maybe_tuple_expression] = STATE(1390),
    [sym_tuple_access] = STATE(47),
    [sym__maybe_record_expression] = STATE(1389),
    [sym_field_access] = STATE(47),
    [sym__maybe_function_expression] = STATE(1231),
    [sym_function_call] = STATE(47),
    [sym_type_definition] = STATE(2),
    [sym_type_alias] = STATE(2),
    [sym_string] = STATE(105),
    [sym_integer] = STATE(105),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(18),
    [sym_remote_constructor_name] = STATE(18),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_POUND] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(21),
    [anon_sym_LT_LT] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_fn] = ACTIONS(27),
    [anon_sym_external] = ACTIONS(29),
    [anon_sym_type] = ACTIONS(31),
    [anon_sym_try] = ACTIONS(33),
    [anon_sym_todo] = ACTIONS(35),
    [anon_sym_panic] = ACTIONS(37),
    [anon_sym_case] = ACTIONS(39),
    [anon_sym_let] = ACTIONS(41),
    [anon_sym_assert] = ACTIONS(43),
    [anon_sym_use] = ACTIONS(45),
    [anon_sym_BANG] = ACTIONS(47),
    [sym_visibility_modifier] = ACTIONS(49),
    [sym_opacity_modifier] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [sym__hex] = ACTIONS(57),
    [sym__decimal] = ACTIONS(59),
    [sym__octal] = ACTIONS(57),
    [sym__binary] = ACTIONS(57),
    [sym__name] = ACTIONS(61),
    [sym__upname] = ACTIONS(63),
  },
  [2] = {
    [sym__module_statement] = STATE(3),
    [sym_target_group] = STATE(3),
    [sym_attribute] = STATE(3),
    [sym_import] = STATE(3),
    [sym_constant] = STATE(3),
    [sym_external_type] = STATE(3),
    [sym_external_function] = STATE(3),
    [sym_function] = STATE(3),
    [aux_sym__statement_seq] = STATE(4),
    [sym_try] = STATE(461),
    [sym__statement] = STATE(461),
    [sym__expression] = STATE(105),
    [sym_binary_expression] = STATE(105),
    [sym__expression_unit] = STATE(105),
    [sym_record] = STATE(67),
    [sym_todo] = STATE(105),
    [sym_panic] = STATE(105),
    [sym_tuple] = STATE(79),
    [sym_list] = STATE(105),
    [sym__expression_bit_string] = STATE(105),
    [sym_anonymous_function] = STATE(73),
    [sym_block] = STATE(47),
    [sym_case] = STATE(47),
    [sym_let_assert] = STATE(461),
    [sym_let] = STATE(461),
    [sym_use] = STATE(461),
    [sym_assert] = STATE(105),
    [sym_boolean_negation] = STATE(105),
    [sym_integer_negation] = STATE(105),
    [sym_record_update] = STATE(67),
    [sym__maybe_tuple_expression] = STATE(1390),
    [sym_tuple_access] = STATE(47),
    [sym__maybe_record_expression] = STATE(1389),
    [sym_field_access] = STATE(47),
    [sym__maybe_function_expression] = STATE(1231),
    [sym_function_call] = STATE(47),
    [sym_type_definition] = STATE(3),
    [sym_type_alias] = STATE(3),
    [sym_string] = STATE(105),
    [sym_integer] = STATE(105),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(18),
    [sym_remote_constructor_name] = STATE(18),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(65),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_POUND] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(21),
    [anon_sym_LT_LT] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(25),
    [anon_sym_fn] = ACTIONS(27),
    [anon_sym_external] = ACTIONS(29),
    [anon_sym_type] = ACTIONS(31),
    [anon_sym_try] = ACTIONS(33),
    [anon_sym_todo] = ACTIONS(35),
    [anon_sym_panic] = ACTIONS(37),
    [anon_sym_case] = ACTIONS(39),
    [anon_sym_let] = ACTIONS(41),
    [anon_sym_assert] = ACTIONS(43),
    [anon_sym_use] = ACTIONS(45),
    [anon_sym_BANG] = ACTIONS(47),
    [sym_visibility_modifier] = ACTIONS(49),
    [sym_opacity_modifier] = ACTIONS(51),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [sym__hex] = ACTIONS(57),
    [sym__decimal] = ACTIONS(59),
    [sym__octal] = ACTIONS(57),
    [sym__binary] = ACTIONS(57),
    [sym__name] = ACTIONS(61),
    [sym__upname] = ACTIONS(63),
  },
  [3] = {
    [sym__module_statement] = STATE(3),
    [sym_target_group] = STATE(3),
    [sym_attribute] = STATE(3),
    [sym_import] = STATE(3),
    [sym_constant] = STATE(3),
    [sym_external_type] = STATE(3),
    [sym_external_function] = STATE(3),
    [sym_function] = STATE(3),
    [aux_sym__statement_seq] = STATE(4),
    [sym_try] = STATE(461),
    [sym__statement] = STATE(461),
    [sym__expression] = STATE(105),
    [sym_binary_expression] = STATE(105),
    [sym__expression_unit] = STATE(105),
    [sym_record] = STATE(67),
    [sym_todo] = STATE(105),
    [sym_panic] = STATE(105),
    [sym_tuple] = STATE(79),
    [sym_list] = STATE(105),
    [sym__expression_bit_string] = STATE(105),
    [sym_anonymous_function] = STATE(73),
    [sym_block] = STATE(47),
    [sym_case] = STATE(47),
    [sym_let_assert] = STATE(461),
    [sym_let] = STATE(461),
    [sym_use] = STATE(461),
    [sym_assert] = STATE(105),
    [sym_boolean_negation] = STATE(105),
    [sym_integer_negation] = STATE(105),
    [sym_record_update] = STATE(67),
    [sym__maybe_tuple_expression] = STATE(1390),
    [sym_tuple_access] = STATE(47),
    [sym__maybe_record_expression] = STATE(1389),
    [sym_field_access] = STATE(47),
    [sym__maybe_function_expression] = STATE(1231),
    [sym_function_call] = STATE(47),
    [sym_type_definition] = STATE(3),
    [sym_type_alias] = STATE(3),
    [sym_string] = STATE(105),
    [sym_integer] = STATE(105),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(18),
    [sym_remote_constructor_name] = STATE(18),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(67),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(72),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_import] = ACTIONS(78),
    [anon_sym_const] = ACTIONS(81),
    [anon_sym_POUND] = ACTIONS(84),
    [anon_sym_LBRACK] = ACTIONS(87),
    [anon_sym_LT_LT] = ACTIONS(90),
    [anon_sym_DASH] = ACTIONS(93),
    [anon_sym_fn] = ACTIONS(96),
    [anon_sym_external] = ACTIONS(99),
    [anon_sym_type] = ACTIONS(102),
    [anon_sym_try] = ACTIONS(105),
    [anon_sym_todo] = ACTIONS(108),
    [anon_sym_panic] = ACTIONS(111),
    [anon_sym_case] = ACTIONS(114),
    [anon_sym_let] = ACTIONS(117),
    [anon_sym_assert] = ACTIONS(120),
    [anon_sym_use] = ACTIONS(123),
    [anon_sym_BANG] = ACTIONS(126),
    [sym_visibility_modifier] = ACTIONS(129),
    [sym_opacity_modifier] = ACTIONS(132),
    [anon_sym_DQUOTE] = ACTIONS(135),
    [sym_float] = ACTIONS(138),
    [sym__hex] = ACTIONS(141),
    [sym__decimal] = ACTIONS(144),
    [sym__octal] = ACTIONS(141),
    [sym__binary] = ACTIONS(141),
    [sym__name] = ACTIONS(147),
    [sym__upname] = ACTIONS(150),
  },
  [4] = {
    [aux_sym__statement_seq] = STATE(5),
    [sym_try] = STATE(461),
    [sym__statement] = STATE(461),
    [sym__expression] = STATE(105),
    [sym_binary_expression] = STATE(105),
    [sym__expression_unit] = STATE(105),
    [sym_record] = STATE(67),
    [sym_todo] = STATE(105),
    [sym_panic] = STATE(105),
    [sym_tuple] = STATE(79),
    [sym_list] = STATE(105),
    [sym__expression_bit_string] = STATE(105),
    [sym_anonymous_function] = STATE(73),
    [sym_block] = STATE(47),
    [sym_case] = STATE(47),
    [sym_let_assert] = STATE(461),
    [sym_let] = STATE(461),
    [sym_use] = STATE(461),
    [sym_assert] = STATE(105),
    [sym_boolean_negation] = STATE(105),
    [sym_integer_negation] = STATE(105),
    [sym_record_update] = STATE(67),
    [sym__maybe_tuple_expression] = STATE(1390),
    [sym_tuple_access] = STATE(47),
    [sym__maybe_record_expression] = STATE(1389),
    [sym_field_access] = STATE(47),
    [sym__maybe_function_expression] = STATE(1231),
    [sym_function_call] = STATE(47),
    [sym_string] = STATE(105),
    [sym_integer] = STATE(105),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(18),
    [sym_remote_constructor_name] = STATE(18),
    [ts_builtin_sym_end] = ACTIONS(153),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(155),
    [anon_sym_LBRACE] = ACTIONS(157),
    [anon_sym_AT] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_const] = ACTIONS(155),
    [anon_sym_POUND] = ACTIONS(160),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_LT_LT] = ACTIONS(166),
    [anon_sym_DASH] = ACTIONS(169),
    [anon_sym_fn] = ACTIONS(172),
    [anon_sym_external] = ACTIONS(155),
    [anon_sym_type] = ACTIONS(155),
    [anon_sym_try] = ACTIONS(175),
    [anon_sym_todo] = ACTIONS(178),
    [anon_sym_panic] = ACTIONS(181),
    [anon_sym_case] = ACTIONS(184),
    [anon_sym_let] = ACTIONS(187),
    [anon_sym_assert] = ACTIONS(190),
    [anon_sym_use] = ACTIONS(193),
    [anon_sym_BANG] = ACTIONS(196),
    [sym_visibility_modifier] = ACTIONS(155),
    [sym_opacity_modifier] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(199),
    [sym_float] = ACTIONS(202),
    [sym__hex] = ACTIONS(205),
    [sym__decimal] = ACTIONS(208),
    [sym__octal] = ACTIONS(205),
    [sym__binary] = ACTIONS(205),
    [sym__name] = ACTIONS(211),
    [sym__upname] = ACTIONS(214),
  },
  [5] = {
    [aux_sym__statement_seq] = STATE(5),
    [sym_try] = STATE(461),
    [sym__statement] = STATE(461),
    [sym__expression] = STATE(105),
    [sym_binary_expression] = STATE(105),
    [sym__expression_unit] = STATE(105),
    [sym_record] = STATE(67),
    [sym_todo] = STATE(105),
    [sym_panic] = STATE(105),
    [sym_tuple] = STATE(79),
    [sym_list] = STATE(105),
    [sym__expression_bit_string] = STATE(105),
    [sym_anonymous_function] = STATE(73),
    [sym_block] = STATE(47),
    [sym_case] = STATE(47),
    [sym_let_assert] = STATE(461),
    [sym_let] = STATE(461),
    [sym_use] = STATE(461),
    [sym_assert] = STATE(105),
    [sym_boolean_negation] = STATE(105),
    [sym_integer_negation] = STATE(105),
    [sym_record_update] = STATE(67),
    [sym__maybe_tuple_expression] = STATE(1390),
    [sym_tuple_access] = STATE(47),
    [sym__maybe_record_expression] = STATE(1389),
    [sym_field_access] = STATE(47),
    [sym__maybe_function_expression] = STATE(1231),
    [sym_function_call] = STATE(47),
    [sym_string] = STATE(105),
    [sym_integer] = STATE(105),
    [sym_identifier] = STATE(40),
    [sym_constructor_name] = STATE(18),
    [sym_remote_constructor_name] = STATE(18),
    [ts_builtin_sym_end] = ACTIONS(217),
    [sym_module_comment] = ACTIONS(3),
    [sym_statement_comment] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_if] = ACTIONS(219),
    [anon_sym_LBRACE] = ACTIONS(221),
    [anon_sym_AT] = ACTIONS(217),
    [anon_sym_import] = ACTIONS(219),
    [anon_sym_const] = ACTIONS(219),
    [anon_sym_POUND] = ACTIONS(224),
    [anon_sym_LBRACK] = ACTIONS(227),
    [anon_sym_LT_LT] = ACTIONS(230),
    [anon_sym_DASH] = ACTIONS(233),
    [anon_sym_fn] = ACTIONS(236),
    [anon_sym_external] = ACTIONS(219),
    [anon_sym_type] = ACTIONS(219),
    [anon_sym_try] = ACTIONS(239),
    [anon_sym_todo] = ACTIONS(242),
    [anon_sym_panic] = ACTIONS(245),
    [anon_sym_case] = ACTIONS(248),
    [anon_sym_let] = ACTIONS(251),
    [anon_sym_assert] = ACTIONS(254),
    [anon_sym_use] = ACTIONS(257),
    [anon_sym_BANG] = ACTIONS(260),
    [sym_visibility_modifier] = ACTIONS(219),
    [sym_opacity_modifier] = ACTIONS(219),
    [anon_sym_DQUOTE] = ACTIONS(263),
    [sym_float] = ACTIONS(266),
    [sym__hex] = ACTIONS(269),
    [sym__decimal] = ACTIONS(272),
    [sym__octal] = ACTIONS(269),
    [sym__binary] = ACTIONS(269),
    [sym__name] = ACTIONS(275),
    [sym__upname] = ACTIONS(278),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(283), 1,
      anon_sym_RBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [130] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(323), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [260] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(325), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [390] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(327), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [520] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(329), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [650] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(331), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [780] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(333), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [910] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(335), 1,
      anon_sym_RBRACE,
    STATE(25), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1040] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(337), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1170] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(339), 1,
      anon_sym_RBRACE,
    STATE(11), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1300] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(341), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1430] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(343), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1560] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(349), 1,
      anon_sym_LPAREN,
    STATE(77), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(347), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(345), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [1632] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(351), 1,
      anon_sym_RBRACE,
    STATE(17), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1762] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(353), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [1892] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(355), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2022] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(357), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2152] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(359), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2282] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(361), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2412] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(363), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2542] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(365), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2672] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(367), 1,
      anon_sym_RBRACE,
    STATE(23), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2802] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(369), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [2932] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(371), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3062] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(373), 1,
      anon_sym_RBRACE,
    STATE(35), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3192] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(375), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3322] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(377), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3452] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(379), 1,
      anon_sym_RBRACE,
    STATE(26), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3582] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(217), 1,
      anon_sym_RBRACE,
    ACTIONS(381), 1,
      anon_sym_LBRACE,
    ACTIONS(384), 1,
      anon_sym_POUND,
    ACTIONS(387), 1,
      anon_sym_LBRACK,
    ACTIONS(390), 1,
      anon_sym_LT_LT,
    ACTIONS(393), 1,
      anon_sym_DASH,
    ACTIONS(396), 1,
      anon_sym_fn,
    ACTIONS(399), 1,
      anon_sym_try,
    ACTIONS(402), 1,
      anon_sym_todo,
    ACTIONS(405), 1,
      anon_sym_panic,
    ACTIONS(408), 1,
      anon_sym_case,
    ACTIONS(411), 1,
      anon_sym_let,
    ACTIONS(414), 1,
      anon_sym_assert,
    ACTIONS(417), 1,
      anon_sym_use,
    ACTIONS(420), 1,
      anon_sym_BANG,
    ACTIONS(423), 1,
      anon_sym_DQUOTE,
    ACTIONS(426), 1,
      sym_float,
    ACTIONS(432), 1,
      sym__decimal,
    ACTIONS(435), 1,
      sym__name,
    ACTIONS(438), 1,
      sym__upname,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(429), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3712] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(441), 1,
      anon_sym_RBRACE,
    STATE(34), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [3842] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(445), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(443), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3909] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(449), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(447), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [3976] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(10), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4103] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(9), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4230] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(451), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4301] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(463), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(461), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4368] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(7), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4495] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(32), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4622] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(467), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(465), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4689] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(471), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(469), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4756] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(14), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [4883] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(451), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [4954] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(478), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(476), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5021] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(482), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(480), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5088] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(484), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5155] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(12), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5282] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(490), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(488), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5349] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(494), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(492), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5416] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(16), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5543] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(496), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5610] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(502), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(500), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5677] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(506), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(504), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [5744] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(31), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5871] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(21), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [5998] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(508), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6065] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(28), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6192] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(514), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(512), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6259] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(24), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6386] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(520), 1,
      anon_sym_LPAREN,
    ACTIONS(522), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(518), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(516), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6457] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(526), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(524), 29,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6524] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(295), 1,
      anon_sym_try,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(303), 1,
      anon_sym_let,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(307), 1,
      anon_sym_use,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym_float,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    STATE(22), 1,
      aux_sym__statement_seq,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(695), 5,
      sym_try,
      sym__statement,
      sym_let_assert,
      sym_let,
      sym_use,
    STATE(299), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [6651] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(528), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(451), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6719] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(534), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(530), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6787] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(538), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(536), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6853] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(502), 21,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(500), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6919] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(542), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(540), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [6985] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(546), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(544), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7051] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(451), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7119] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(550), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(548), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7185] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(554), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(552), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7251] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(558), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(556), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7317] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(562), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(560), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7383] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(566), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(564), 28,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7449] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(568), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(451), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7517] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(572), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(570), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7582] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(584), 1,
      anon_sym_AMP_AMP,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(574), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(576), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7667] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(584), 1,
      anon_sym_AMP_AMP,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(598), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(600), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7752] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(584), 1,
      anon_sym_AMP_AMP,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(602), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(604), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [7837] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(608), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(606), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7902] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(612), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(610), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [7967] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(584), 1,
      anon_sym_AMP_AMP,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(614), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(616), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8052] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(584), 1,
      anon_sym_AMP_AMP,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(618), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(620), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8137] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(584), 1,
      anon_sym_AMP_AMP,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(622), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(624), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8222] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(584), 1,
      anon_sym_AMP_AMP,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(626), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(628), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8307] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(630), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8372] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(634), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8437] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(584), 1,
      anon_sym_AMP_AMP,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(640), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8522] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(644), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(642), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8587] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(648), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(646), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [8652] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 21,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(652), 22,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8725] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 20,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(652), 22,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8800] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 16,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(652), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8879] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(652), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [8960] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(654), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9025] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(660), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(658), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9090] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(664), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(662), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9155] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(584), 1,
      anon_sym_AMP_AMP,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(652), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9238] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(666), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9303] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(670), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9368] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(582), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(584), 1,
      anon_sym_AMP_AMP,
    ACTIONS(592), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(580), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(586), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(594), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(588), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(590), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(674), 12,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(676), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9453] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(680), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(678), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9518] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(682), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9583] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(578), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(596), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 23,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(652), 24,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [9652] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(650), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9717] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(689), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(686), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9782] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(694), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(692), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9847] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(698), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(696), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9912] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(702), 26,
      anon_sym_if,
      anon_sym_import,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
    ACTIONS(700), 27,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [9977] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(496), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10041] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(706), 1,
      anon_sym_RPAREN,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(722), 1,
      anon_sym_DOT_DOT,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1067), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10167] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(744), 1,
      anon_sym_RPAREN,
    ACTIONS(746), 1,
      anon_sym_DOT_DOT,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1102), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10293] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(748), 1,
      anon_sym_RPAREN,
    ACTIONS(750), 1,
      anon_sym_DOT_DOT,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1157), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10419] = 35,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(752), 1,
      anon_sym_RPAREN,
    ACTIONS(754), 1,
      anon_sym_DOT_DOT,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1140), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10545] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(506), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(504), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10609] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(490), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(488), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10673] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(467), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(465), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [10737] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(756), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1206), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10860] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(758), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1206), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [10983] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(744), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1102), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11106] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(748), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1157), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11229] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(760), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1206), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11352] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(762), 1,
      anon_sym_LPAREN,
    STATE(157), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(347), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(345), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [11419] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(764), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1206), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11542] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(706), 1,
      anon_sym_RPAREN,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1067), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11665] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(766), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1206), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11788] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(768), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1206), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [11911] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(770), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1206), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12034] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(752), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1140), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12157] = 34,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(772), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1206), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [12280] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(449), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(447), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12342] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(494), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(492), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12404] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(694), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(692), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12466] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(774), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(451), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12532] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(484), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12594] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(526), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(524), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12656] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(451), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12722] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(471), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(469), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12784] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(680), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(678), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12846] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(463), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(461), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [12908] = 33,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(732), 1,
      sym_float,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1206), 1,
      sym_argument,
    STATE(1209), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1411), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(641), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [13028] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(445), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(443), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13090] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(514), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(512), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13152] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(478), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(476), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13214] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(482), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(480), 31,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13276] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(546), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(544), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13337] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(554), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(552), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13398] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(566), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(564), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13459] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(528), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(451), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13522] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(550), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(548), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13583] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(568), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(451), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13646] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(558), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(556), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13707] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(562), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(560), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13768] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(542), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(540), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13829] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(538), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(536), 30,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13890] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(451), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [13953] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(698), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(696), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14013] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(778), 1,
      anon_sym_RBRACK,
    ACTIONS(780), 1,
      anon_sym_DOT_DOT,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14127] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(666), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14187] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(630), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14247] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(682), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14307] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(612), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(610), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14367] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(648), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(646), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14427] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(634), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [14487] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(786), 1,
      anon_sym_RBRACK,
    ACTIONS(788), 1,
      anon_sym_DOT_DOT,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14601] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(790), 1,
      anon_sym_RBRACK,
    ACTIONS(792), 1,
      anon_sym_DOT_DOT,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14715] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(794), 1,
      anon_sym_RBRACK,
    ACTIONS(796), 1,
      anon_sym_DOT_DOT,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14829] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(798), 1,
      anon_sym_RBRACK,
    ACTIONS(800), 1,
      anon_sym_DOT_DOT,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [14943] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(644), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(642), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15003] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(802), 1,
      anon_sym_RBRACK,
    ACTIONS(804), 1,
      anon_sym_DOT_DOT,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15117] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(806), 1,
      anon_sym_RBRACK,
    ACTIONS(808), 1,
      anon_sym_DOT_DOT,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15231] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(810), 1,
      anon_sym_RBRACK,
    ACTIONS(812), 1,
      anon_sym_DOT_DOT,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15345] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(660), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(658), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15405] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(664), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(662), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15465] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(608), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(606), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15525] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(738), 1,
      sym__discard_name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(814), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1181), 1,
      sym_hole,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(651), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [15639] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(654), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15699] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(572), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(570), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15759] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(670), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15819] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(702), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(700), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15879] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(689), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(686), 29,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [15939] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(816), 1,
      anon_sym_RBRACK,
    ACTIONS(818), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(603), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16050] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(820), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16161] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(822), 1,
      anon_sym_RPAREN,
    ACTIONS(824), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(638), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16272] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(826), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16383] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(828), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1320), 1,
      sym_case_subjects,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(639), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16494] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(830), 1,
      anon_sym_RPAREN,
    ACTIONS(832), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(628), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16605] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(828), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1376), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(639), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16716] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(834), 1,
      anon_sym_RBRACK,
    ACTIONS(836), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(620), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16827] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(838), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [16938] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(840), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17049] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(842), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17160] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(844), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17271] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(846), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17382] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    ACTIONS(850), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(518), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(516), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17445] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(852), 1,
      anon_sym_RBRACK,
    ACTIONS(854), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(592), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17556] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(828), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    STATE(1387), 1,
      sym_case_subjects,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(639), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17667] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(508), 28,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [17726] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(856), 1,
      anon_sym_RPAREN,
    ACTIONS(858), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(626), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17837] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(828), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1345), 1,
      sym_case_subjects,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(639), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [17948] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(860), 1,
      anon_sym_RBRACK,
    ACTIONS(862), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(613), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18059] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(864), 1,
      anon_sym_RPAREN,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18170] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(866), 1,
      anon_sym_RPAREN,
    ACTIONS(868), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(630), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18281] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(870), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(674), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18389] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(896), 1,
      sym_float,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(368), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18497] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(906), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(683), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18605] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(908), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(382), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18713] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(910), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(302), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18821] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(914), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(83), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [18929] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(916), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(661), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19037] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(918), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(664), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19145] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(920), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(662), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19253] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(922), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(92), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19361] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(924), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(530), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19469] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(926), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(671), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19577] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(928), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(668), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19685] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(930), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(312), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19793] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(932), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(310), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [19901] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(934), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(539), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20009] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(936), 1,
      anon_sym_GT_GT,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1186), 1,
      sym_expression_bit_string_segment,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20121] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(948), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(537), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20229] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(950), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(530), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [20289] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(952), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(540), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20397] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(954), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(542), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20505] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(956), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(546), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20613] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(958), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(548), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20721] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(960), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(551), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20829] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(962), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(545), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [20937] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(964), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(300), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21045] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(966), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(523), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21153] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(968), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(685), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21261] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(970), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(296), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21369] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(972), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(550), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21477] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(974), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(667), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21585] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(976), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(311), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21693] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(978), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(87), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21801] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(980), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(81), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [21909] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(982), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(86), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22017] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(984), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1186), 1,
      sym_expression_bit_string_segment,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22129] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(986), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1186), 1,
      sym_expression_bit_string_segment,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22241] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(988), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(380), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22349] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(990), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(391), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22457] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(992), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1030), 1,
      sym_expression_bit_string_segment,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22569] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(994), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(306), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22677] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(996), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(392), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22785] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(998), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1186), 1,
      sym_expression_bit_string_segment,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [22897] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(1000), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(307), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23005] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(1002), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(387), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23113] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(1004), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(385), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23221] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(1006), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1186), 1,
      sym_expression_bit_string_segment,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23333] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1008), 1,
      anon_sym_LBRACE,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23441] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1011), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(675), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23549] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1013), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(684), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23657] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(1015), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(374), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23765] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1017), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(82), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23873] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(1019), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(370), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [23981] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(1021), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1110), 1,
      sym_expression_bit_string_segment,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24093] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(1023), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(390), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24201] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1025), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(686), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24309] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(1027), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(297), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24417] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1029), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(680), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24525] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24633] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(1031), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(298), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24741] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(1033), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(301), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24849] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1035), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(679), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [24957] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(1037), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(309), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25065] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(1039), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1126), 1,
      sym_expression_bit_string_segment,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25177] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1041), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(109), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25285] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(1043), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1186), 1,
      sym_expression_bit_string_segment,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25397] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1045), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(108), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25505] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1047), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(102), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25613] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1049), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(98), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25721] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(1051), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(383), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25829] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1053), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(97), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [25937] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1055), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(96), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26045] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1057), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(95), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26153] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(1059), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(308), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26261] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(1061), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1077), 1,
      sym_expression_bit_string_segment,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26373] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1063), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(642), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26481] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(1065), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(305), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26589] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(1067), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(304), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26697] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1069), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(657), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26805] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1071), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(663), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [26913] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1073), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(88), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27021] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(1075), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1186), 1,
      sym_expression_bit_string_segment,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27133] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(1077), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(366), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27241] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(1079), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(369), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27349] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1081), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(666), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27457] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(782), 1,
      sym_float,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1083), 1,
      anon_sym_LBRACE,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(570), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27565] = 31,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    ACTIONS(1086), 1,
      anon_sym_GT_GT,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1186), 1,
      sym_expression_bit_string_segment,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27677] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1088), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(89), 12,
      sym__expression,
      sym_binary_expression,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [27785] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1094), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1096), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(618), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(620), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [27862] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(652), 15,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27927] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(652), 15,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 19,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [27994] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1094), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1096), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(674), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(676), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [28071] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1094), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1096), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(626), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(628), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [28148] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(652), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 15,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28219] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(652), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28292] = 30,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(946), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1186), 1,
      sym_expression_bit_string_segment,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(1028), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [28401] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1096), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(652), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 12,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28476] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(652), 17,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 22,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28537] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1094), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1096), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(598), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(600), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [28614] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1094), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1096), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(622), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(624), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [28691] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 19,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
    ACTIONS(650), 26,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [28748] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1094), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1096), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(574), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(576), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [28825] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1094), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1096), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(640), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [28902] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1094), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1096), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(614), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(616), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [28979] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1094), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1096), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1104), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1090), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1092), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1098), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1106), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1100), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1102), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1108), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(602), 11,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(604), 11,
      anon_sym_fn,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      anon_sym_BANG,
      sym__decimal,
      sym__name,
  [29056] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1110), 1,
      sym_float,
    ACTIONS(1114), 1,
      sym__decimal,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1112), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(532), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29162] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(1116), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(181), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29268] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(900), 1,
      sym__decimal,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(1118), 1,
      sym_float,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(898), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(381), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29374] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(872), 1,
      anon_sym_LBRACE,
    ACTIONS(874), 1,
      anon_sym_POUND,
    ACTIONS(876), 1,
      anon_sym_LBRACK,
    ACTIONS(878), 1,
      anon_sym_LT_LT,
    ACTIONS(880), 1,
      anon_sym_DASH,
    ACTIONS(882), 1,
      anon_sym_fn,
    ACTIONS(884), 1,
      anon_sym_todo,
    ACTIONS(886), 1,
      anon_sym_panic,
    ACTIONS(888), 1,
      anon_sym_case,
    ACTIONS(890), 1,
      anon_sym_assert,
    ACTIONS(892), 1,
      anon_sym_BANG,
    ACTIONS(894), 1,
      anon_sym_DQUOTE,
    ACTIONS(902), 1,
      sym__name,
    ACTIONS(904), 1,
      sym__upname,
    ACTIONS(1120), 1,
      sym_float,
    ACTIONS(1124), 1,
      sym__decimal,
    STATE(332), 1,
      sym_identifier,
    STATE(350), 1,
      sym_anonymous_function,
    STATE(352), 1,
      sym_tuple,
    STATE(1293), 1,
      sym__maybe_function_expression,
    STATE(1330), 1,
      sym__maybe_tuple_expression,
    STATE(1385), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(330), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(354), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1122), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(349), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(386), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29480] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1126), 1,
      sym_float,
    ACTIONS(1130), 1,
      sym__decimal,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1128), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(112), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29586] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(317), 1,
      sym__decimal,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(1116), 1,
      sym_float,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(315), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(181), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29692] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(938), 1,
      anon_sym_DASH,
    ACTIONS(940), 1,
      anon_sym_todo,
    ACTIONS(942), 1,
      anon_sym_assert,
    ACTIONS(944), 1,
      anon_sym_BANG,
    ACTIONS(1132), 1,
      sym_float,
    ACTIONS(1136), 1,
      sym__decimal,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1329), 1,
      sym__maybe_tuple_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1134), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(161), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29798] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(704), 1,
      anon_sym_LBRACE,
    ACTIONS(708), 1,
      anon_sym_POUND,
    ACTIONS(710), 1,
      anon_sym_LBRACK,
    ACTIONS(712), 1,
      anon_sym_LT_LT,
    ACTIONS(714), 1,
      anon_sym_DASH,
    ACTIONS(716), 1,
      anon_sym_fn,
    ACTIONS(718), 1,
      anon_sym_todo,
    ACTIONS(720), 1,
      anon_sym_panic,
    ACTIONS(724), 1,
      anon_sym_case,
    ACTIONS(726), 1,
      anon_sym_assert,
    ACTIONS(728), 1,
      anon_sym_BANG,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1138), 1,
      sym_float,
    STATE(433), 1,
      sym_identifier,
    STATE(506), 1,
      sym_anonymous_function,
    STATE(507), 1,
      sym_tuple,
    STATE(1251), 1,
      sym__maybe_function_expression,
    STATE(1365), 1,
      sym__maybe_tuple_expression,
    STATE(1373), 1,
      sym__maybe_record_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(403), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(508), 2,
      sym_record,
      sym_record_update,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(408), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(534), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [29904] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(11), 1,
      anon_sym_LBRACE,
    ACTIONS(19), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_LT_LT,
    ACTIONS(25), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_todo,
    ACTIONS(37), 1,
      anon_sym_panic,
    ACTIONS(39), 1,
      anon_sym_case,
    ACTIONS(43), 1,
      anon_sym_assert,
    ACTIONS(47), 1,
      anon_sym_BANG,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym__decimal,
    ACTIONS(61), 1,
      sym__name,
    ACTIONS(63), 1,
      sym__upname,
    ACTIONS(912), 1,
      anon_sym_fn,
    ACTIONS(1140), 1,
      sym_float,
    STATE(40), 1,
      sym_identifier,
    STATE(73), 1,
      sym_anonymous_function,
    STATE(79), 1,
      sym_tuple,
    STATE(1231), 1,
      sym__maybe_function_expression,
    STATE(1389), 1,
      sym__maybe_record_expression,
    STATE(1390), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(18), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(67), 2,
      sym_record,
      sym_record_update,
    ACTIONS(57), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(47), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(99), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30010] = 29,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(281), 1,
      anon_sym_LBRACE,
    ACTIONS(285), 1,
      anon_sym_POUND,
    ACTIONS(287), 1,
      anon_sym_LBRACK,
    ACTIONS(289), 1,
      anon_sym_LT_LT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    ACTIONS(293), 1,
      anon_sym_fn,
    ACTIONS(297), 1,
      anon_sym_todo,
    ACTIONS(299), 1,
      anon_sym_panic,
    ACTIONS(301), 1,
      anon_sym_case,
    ACTIONS(305), 1,
      anon_sym_assert,
    ACTIONS(309), 1,
      anon_sym_BANG,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(319), 1,
      sym__name,
    ACTIONS(321), 1,
      sym__upname,
    ACTIONS(1132), 1,
      sym_float,
    ACTIONS(1136), 1,
      sym__decimal,
    STATE(138), 1,
      sym_identifier,
    STATE(155), 1,
      sym_tuple,
    STATE(160), 1,
      sym_anonymous_function,
    STATE(1175), 1,
      sym__maybe_function_expression,
    STATE(1342), 1,
      sym__maybe_record_expression,
    STATE(1379), 1,
      sym__maybe_tuple_expression,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(127), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    STATE(153), 2,
      sym_record,
      sym_record_update,
    ACTIONS(1134), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(141), 5,
      sym_block,
      sym_case,
      sym_tuple_access,
      sym_field_access,
      sym_function_call,
    STATE(161), 10,
      sym__expression_unit,
      sym_todo,
      sym_panic,
      sym_list,
      sym__expression_bit_string,
      sym_assert,
      sym_boolean_negation,
      sym_integer_negation,
      sym_string,
      sym_integer,
  [30116] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(506), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(504), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [30171] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(467), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(465), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [30226] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(502), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(500), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [30281] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 10,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(496), 33,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [30336] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(694), 9,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(692), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [30389] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(680), 9,
      anon_sym_SLASH,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(678), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [30442] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(490), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(488), 32,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [30495] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1142), 1,
      anon_sym_LPAREN,
    STATE(353), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(347), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(345), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30550] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(498), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(496), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30600] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(1144), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(451), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30654] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(484), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30704] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(449), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(447), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30754] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(494), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(492), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30804] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(506), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(504), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30854] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(502), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(500), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30904] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(482), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(480), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [30954] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(463), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(461), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31004] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(471), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(469), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31054] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(478), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(476), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31104] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(445), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(443), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31154] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(490), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(488), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31204] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(526), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(524), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31254] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1148), 1,
      anon_sym_LPAREN,
    ACTIONS(1150), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(518), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(516), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31308] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(508), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31358] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(467), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(465), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31408] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(514), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(512), 27,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31458] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(473), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(451), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31512] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(451), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31563] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(546), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(544), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31612] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(568), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(451), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31663] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(562), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(560), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31712] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(528), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(451), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31763] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(550), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(548), 26,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31812] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1152), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(530), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31863] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(538), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(536), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31912] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(542), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(540), 26,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [31961] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(558), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(556), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32010] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(566), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(564), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32059] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(554), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(552), 26,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32108] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(608), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(606), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32156] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(689), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(686), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32204] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(612), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(610), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32252] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(630), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32300] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1160), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1162), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1170), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1164), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1176), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1166), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1168), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1154), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32368] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(694), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(692), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32416] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(652), 9,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(650), 21,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32468] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1160), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1162), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1170), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1164), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(624), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1166), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1168), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(622), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32536] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1170), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(652), 7,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(650), 18,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32594] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(680), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(678), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32642] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(664), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(662), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32690] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(572), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(570), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32738] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1170), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(652), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1166), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1168), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 14,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32800] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(666), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32848] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(702), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(700), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32896] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(670), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32944] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(682), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [32992] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(660), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(658), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33040] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1160), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1162), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1170), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1164), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(604), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1166), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1168), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(602), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33108] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(654), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33156] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1160), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1162), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1170), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1164), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1180), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1166), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1168), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1178), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33224] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1160), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1162), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1170), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1164), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(616), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1166), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1168), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(614), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33292] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(648), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(646), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33340] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1170), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1164), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(652), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1166), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1168), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 12,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33404] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(698), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(696), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33452] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1162), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1170), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1164), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(652), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1166), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1168), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 11,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33518] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(644), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(642), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33566] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(634), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33614] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(652), 7,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(650), 19,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33670] = 14,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1160), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1162), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1170), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1156), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1158), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1164), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1172), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(640), 3,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(1166), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1168), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1174), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 10,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33738] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 11,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym__decimal,
      sym__discard_name,
      sym__name,
    ACTIONS(650), 25,
      anon_sym_RBRACE,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
  [33786] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1186), 1,
      anon_sym_SLASH,
    STATE(393), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1182), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1184), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33837] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1193), 1,
      anon_sym_SLASH,
    STATE(395), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1189), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1191), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33888] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1193), 1,
      anon_sym_SLASH,
    STATE(393), 1,
      aux_sym_module_repeat1,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1195), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1197), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33939] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1203), 1,
      anon_sym_LPAREN,
    STATE(435), 1,
      sym_type_parameters,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1199), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1201), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [33989] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1182), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1184), 20,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_SLASH,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34035] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    STATE(440), 1,
      sym_constant_record_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1205), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1207), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34084] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1211), 15,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1213), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34129] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    STATE(451), 1,
      sym_type_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1215), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1217), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34178] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1225), 1,
      anon_sym_DOT,
    ACTIONS(1227), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1221), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1223), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34227] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(510), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(508), 24,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [34272] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1229), 1,
      anon_sym_LPAREN,
    STATE(478), 1,
      sym_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(347), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(345), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [34321] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1231), 15,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1233), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34366] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1235), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1237), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34410] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1239), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1241), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34454] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(445), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(443), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [34498] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(1243), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(451), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [34546] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(500), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1246), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1248), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34592] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1254), 1,
      anon_sym_LBRACE,
    ACTIONS(1256), 1,
      anon_sym_EQ,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1250), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1252), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34640] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(471), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(469), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [34684] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1258), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1260), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34728] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(463), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(461), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [34772] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1262), 1,
      anon_sym_LPAREN,
    ACTIONS(1264), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(518), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(516), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [34820] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1270), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1266), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1268), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34866] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(478), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(476), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [34910] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1272), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1274), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [34954] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(482), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(480), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [34998] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1276), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1278), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35042] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(526), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(524), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [35086] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1280), 1,
      anon_sym_RBRACE,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1292), 1,
      sym_float,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(943), 1,
      sym__pattern,
    STATE(1008), 1,
      sym_case_clause_pattern,
    STATE(1078), 1,
      sym_case_clause_patterns,
    STATE(1319), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(458), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(931), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [35168] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1292), 1,
      sym_float,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1304), 1,
      anon_sym_RBRACE,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(943), 1,
      sym__pattern,
    STATE(1008), 1,
      sym_case_clause_pattern,
    STATE(1078), 1,
      sym_case_clause_patterns,
    STATE(1346), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(458), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(931), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [35250] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(514), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(512), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [35294] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(449), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(447), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [35338] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(494), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(492), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [35382] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1310), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1306), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1308), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35428] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1292), 1,
      sym_float,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1312), 1,
      anon_sym_RBRACE,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(943), 1,
      sym__pattern,
    STATE(1008), 1,
      sym_case_clause_pattern,
    STATE(1078), 1,
      sym_case_clause_patterns,
    STATE(1412), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(458), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(931), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [35510] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1292), 1,
      sym_float,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1314), 1,
      anon_sym_RBRACE,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(943), 1,
      sym__pattern,
    STATE(1008), 1,
      sym_case_clause_pattern,
    STATE(1078), 1,
      sym_case_clause_patterns,
    STATE(1429), 1,
      sym_case_clauses,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(458), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(931), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [35592] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(486), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(484), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [35636] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1316), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1318), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35680] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1320), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1322), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35724] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1324), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1326), 19,
      anon_sym_if,
      anon_sym_import,
      anon_sym_as,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35768] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(1328), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(451), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [35816] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1336), 1,
      anon_sym_LBRACE,
    ACTIONS(1338), 1,
      anon_sym_EQ,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1332), 12,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1334), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35864] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1340), 14,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1342), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35908] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1344), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1346), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35951] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1348), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1350), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [35994] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1352), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1354), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36037] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1356), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1358), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36080] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1360), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1362), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36123] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1364), 1,
      anon_sym_RPAREN,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1368), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1370), 1,
      sym_float,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(1083), 1,
      sym__pattern,
    STATE(1121), 1,
      sym_record_pattern_argument,
    STATE(1331), 1,
      sym_label,
    STATE(1374), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36204] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1372), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1374), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36247] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(566), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(564), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [36290] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1376), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1378), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36333] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1380), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1382), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36376] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1384), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1386), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36419] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1388), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1390), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36462] = 22,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1392), 1,
      anon_sym_RBRACE,
    ACTIONS(1394), 1,
      anon_sym_POUND,
    ACTIONS(1397), 1,
      anon_sym_LBRACK,
    ACTIONS(1400), 1,
      anon_sym_LT_LT,
    ACTIONS(1403), 1,
      anon_sym_DASH,
    ACTIONS(1406), 1,
      anon_sym_DQUOTE,
    ACTIONS(1409), 1,
      sym_float,
    ACTIONS(1415), 1,
      sym__decimal,
    ACTIONS(1418), 1,
      sym__discard_name,
    ACTIONS(1421), 1,
      sym__name,
    ACTIONS(1424), 1,
      sym__upname,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(943), 1,
      sym__pattern,
    STATE(1008), 1,
      sym_case_clause_pattern,
    STATE(1078), 1,
      sym_case_clause_patterns,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(448), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1412), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(931), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [36541] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1427), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1429), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36584] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1431), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1433), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36627] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1435), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1437), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36670] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1439), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1441), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36713] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1443), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1445), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36756] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1447), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1449), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36799] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1451), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1453), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36842] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1455), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1457), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36885] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1459), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1461), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [36928] = 22,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1292), 1,
      sym_float,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1463), 1,
      anon_sym_RBRACE,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(943), 1,
      sym__pattern,
    STATE(1008), 1,
      sym_case_clause_pattern,
    STATE(1078), 1,
      sym_case_clause_patterns,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(448), 2,
      sym_case_clause,
      aux_sym_case_clauses_repeat1,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(931), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37007] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1465), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1467), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37050] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1469), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1471), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37093] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1473), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1475), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37136] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1477), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1479), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37179] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1481), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1483), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37222] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1485), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1487), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37265] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1489), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1491), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37308] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1497), 1,
      anon_sym_size,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1493), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1046), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [37365] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1505), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1507), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37408] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1368), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1370), 1,
      sym_float,
    ACTIONS(1509), 1,
      anon_sym_RPAREN,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(1083), 1,
      sym__pattern,
    STATE(1121), 1,
      sym_record_pattern_argument,
    STATE(1331), 1,
      sym_label,
    STATE(1401), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [37489] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1511), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1513), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37532] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1515), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1517), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37575] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1519), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1521), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37618] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1523), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1525), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37661] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1527), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1529), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37704] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1531), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1533), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37747] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1535), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1537), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37790] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(558), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(556), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37833] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(538), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(536), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37876] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(562), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(560), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [37919] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1539), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1541), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [37962] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(1545), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1543), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1158), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [38019] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1547), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1549), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38062] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1551), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1553), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38105] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(542), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(540), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38148] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1555), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1557), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38191] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1559), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1561), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38234] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(554), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(552), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38277] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1563), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1565), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38320] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1567), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1569), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38363] = 23,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1368), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1370), 1,
      sym_float,
    ACTIONS(1571), 1,
      anon_sym_RPAREN,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(944), 1,
      sym_record_pattern_argument,
    STATE(1083), 1,
      sym__pattern,
    STATE(1331), 1,
      sym_label,
    STATE(1340), 1,
      sym_pattern_spread,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [38444] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1573), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1575), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38487] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1577), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1579), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38530] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(550), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(548), 23,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38573] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(546), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(544), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [38616] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1581), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1583), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38659] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1585), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1587), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38702] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1589), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1591), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38745] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1593), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1595), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38788] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(1545), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1597), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1158), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [38845] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1599), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1601), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38888] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(1605), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1603), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1048), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [38945] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1607), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1609), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [38988] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1611), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1613), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39031] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1497), 1,
      anon_sym_size,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1615), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1046), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [39088] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1617), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1619), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39131] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(1605), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1621), 2,
      anon_sym_COMMA,
      anon_sym_GT_GT,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1048), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [39188] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(455), 1,
      anon_sym_LPAREN,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(451), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39233] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1623), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(451), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39278] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1625), 1,
      anon_sym_DOT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(453), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(451), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39323] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1627), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1629), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39366] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1631), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1633), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39409] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1635), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1637), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39452] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1250), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1252), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39495] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1639), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1641), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39538] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1643), 1,
      anon_sym_as,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(532), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(530), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [39583] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1645), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1647), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39626] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1649), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1651), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39669] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1653), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1655), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39712] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1657), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1659), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39755] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1661), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1663), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39798] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1665), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1667), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39841] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1669), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1671), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39884] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1673), 13,
      ts_builtin_sym_end,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_LT_LT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      sym_float,
      sym__hex,
      sym__octal,
      sym__binary,
      sym__upname,
    ACTIONS(1675), 18,
      anon_sym_if,
      anon_sym_import,
      anon_sym_const,
      anon_sym_DASH,
      anon_sym_fn,
      anon_sym_external,
      anon_sym_type,
      anon_sym_try,
      anon_sym_todo,
      anon_sym_panic,
      anon_sym_case,
      anon_sym_let,
      anon_sym_assert,
      anon_sym_use,
      sym_visibility_modifier,
      sym_opacity_modifier,
      sym__decimal,
      sym__name,
  [39927] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1681), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1691), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1679), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1685), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1693), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1687), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1689), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(638), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [39987] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(632), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(630), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40029] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(608), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(606), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40071] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(1605), 1,
      anon_sym_size,
    STATE(1185), 1,
      sym_expression_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(984), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [40127] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(636), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(634), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40169] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(644), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(642), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40211] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(702), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(700), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40253] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1681), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1691), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1679), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1685), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1693), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1687), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1689), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(614), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [40313] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(689), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(686), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40355] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(698), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(696), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40397] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(648), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(646), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40439] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(656), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(654), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40481] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(572), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(570), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40523] = 5,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(488), 1,
      anon_sym_COLON,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(502), 9,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(500), 20,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40567] = 8,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1679), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1693), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(652), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 16,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_DOT_DOT,
  [40617] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(660), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(658), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40659] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1681), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1691), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1679), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1685), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1693), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1687), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1689), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(622), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [40719] = 9,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1691), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1679), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1693), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(652), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 15,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_DOT_DOT,
  [40771] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(664), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(662), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40813] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1691), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1679), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1693), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1687), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1689), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 11,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DOT_DOT,
  [40867] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(668), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(666), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40909] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(684), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(682), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40951] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(652), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(650), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [40993] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1691), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1679), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1685), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1693), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1687), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1689), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 9,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_DOT_DOT,
  [41049] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(612), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(610), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41091] = 12,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1691), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1679), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1685), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1693), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1687), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1689), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(650), 8,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_DOT,
  [41149] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(1545), 1,
      anon_sym_size,
    STATE(1265), 1,
      sym_pattern_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1002), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [41205] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1681), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1691), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1679), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1685), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1693), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1687), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1689), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(602), 7,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_DOT_DOT,
  [41265] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(652), 6,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
    ACTIONS(650), 18,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_DOT_DOT,
  [41311] = 11,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1497), 1,
      anon_sym_size,
    ACTIONS(1503), 1,
      anon_sym_unit,
    STATE(1286), 1,
      sym_constant_bit_string_segment_options,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(981), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [41367] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(672), 8,
      anon_sym_SLASH,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_PLUS,
      anon_sym_STAR,
    ACTIONS(670), 22,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      anon_sym_PIPE_GT,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
      anon_sym_DOT_DOT,
  [41409] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1370), 1,
      sym_float,
    ACTIONS(1697), 1,
      anon_sym_RBRACK,
    ACTIONS(1699), 1,
      anon_sym_DOT_DOT,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(905), 1,
      sym__pattern,
    STATE(1338), 1,
      sym_list_pattern_tail,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [41484] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(1545), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1158), 5,
      sym__pattern_bit_string_segment_option,
      sym__pattern_bit_string_named_segment_option,
      sym__pattern_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [41537] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1701), 1,
      anon_sym_LT_DASH,
    ACTIONS(1703), 1,
      sym_float,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(964), 1,
      sym__pattern,
    STATE(1056), 1,
      sym_use_assignment,
    STATE(1317), 1,
      sym_use_assignments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(950), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [41612] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1292), 1,
      sym_float,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1705), 1,
      anon_sym_if,
    ACTIONS(1707), 1,
      anon_sym_DASH_GT,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(943), 1,
      sym__pattern,
    STATE(1082), 1,
      sym_case_clause_pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(931), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [41687] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1497), 1,
      anon_sym_size,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1046), 5,
      sym__constant_bit_string_segment_option,
      sym__constant_bit_string_named_segment_option,
      sym__constant_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [41740] = 6,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1709), 1,
      anon_sym_LPAREN,
    STATE(610), 1,
      sym_constant_record_arguments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1207), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1205), 23,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_type,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [41785] = 10,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(1495), 1,
      anon_sym_DASH,
    ACTIONS(1503), 1,
      anon_sym_unit,
    ACTIONS(1605), 1,
      anon_sym_size,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    ACTIONS(1501), 3,
      anon_sym_utf8,
      anon_sym_utf16,
      anon_sym_utf32,
    STATE(1048), 5,
      sym__expression_bit_string_segment_option,
      sym__expression_bit_string_named_segment_option,
      sym__expression_bit_string_segment_option_size,
      sym_integer,
      sym__bit_string_segment_option,
    ACTIONS(1499), 14,
      anon_sym_binary,
      anon_sym_bytes,
      anon_sym_int,
      anon_sym_float,
      anon_sym_bit_string,
      anon_sym_bits,
      anon_sym_utf8_codepoint,
      anon_sym_utf16_codepoint,
      anon_sym_utf32_codepoint,
      anon_sym_signed,
      anon_sym_unsigned,
      anon_sym_big,
      anon_sym_little,
      anon_sym_native,
  [41838] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1292), 1,
      sym_float,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1711), 1,
      anon_sym_if,
    ACTIONS(1713), 1,
      anon_sym_DASH_GT,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(943), 1,
      sym__pattern,
    STATE(1082), 1,
      sym_case_clause_pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(931), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [41913] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1703), 1,
      sym_float,
    ACTIONS(1715), 1,
      anon_sym_LT_DASH,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(964), 1,
      sym__pattern,
    STATE(1056), 1,
      sym_use_assignment,
    STATE(1397), 1,
      sym_use_assignments,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(950), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [41988] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1292), 1,
      sym_float,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1717), 1,
      anon_sym_if,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(905), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1719), 2,
      anon_sym_DASH_GT,
      anon_sym_PIPE,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(931), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [42061] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1370), 1,
      sym_float,
    ACTIONS(1699), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1721), 1,
      anon_sym_RBRACK,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(958), 1,
      sym__pattern,
    STATE(1364), 1,
      sym_list_pattern_tail,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [42136] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1292), 1,
      sym_float,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1723), 1,
      anon_sym_if,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(905), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1725), 2,
      anon_sym_DASH_GT,
      anon_sym_PIPE,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(931), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [42209] = 21,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1370), 1,
      sym_float,
    ACTIONS(1699), 1,
      anon_sym_DOT_DOT,
    ACTIONS(1727), 1,
      anon_sym_RBRACK,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(905), 1,
      sym__pattern,
    STATE(1324), 1,
      sym_list_pattern_tail,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [42284] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1731), 1,
      anon_sym_POUND,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    ACTIONS(1735), 1,
      anon_sym_LT_LT,
    ACTIONS(1737), 1,
      anon_sym_DASH,
    ACTIONS(1739), 1,
      sym_float,
    STATE(744), 1,
      sym_identifier,
    STATE(788), 1,
      sym__case_clause_guard_binary_expression,
    STATE(789), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(559), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(808), 10,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [42352] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1731), 1,
      anon_sym_POUND,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    ACTIONS(1735), 1,
      anon_sym_LT_LT,
    ACTIONS(1737), 1,
      anon_sym_DASH,
    ACTIONS(1741), 1,
      sym_float,
    STATE(744), 1,
      sym_identifier,
    STATE(788), 1,
      sym__case_clause_guard_binary_expression,
    STATE(789), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(559), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(809), 10,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [42420] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1731), 1,
      anon_sym_POUND,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    ACTIONS(1735), 1,
      anon_sym_LT_LT,
    ACTIONS(1737), 1,
      anon_sym_DASH,
    ACTIONS(1743), 1,
      sym_float,
    STATE(744), 1,
      sym_identifier,
    STATE(788), 1,
      sym__case_clause_guard_binary_expression,
    STATE(789), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(559), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(807), 10,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [42488] = 13,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1681), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1683), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1691), 1,
      anon_sym_PIPE_GT,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1677), 2,
      anon_sym_SLASH,
      anon_sym_STAR,
    ACTIONS(1679), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(1685), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1693), 2,
      anon_sym_PLUS_DOT,
      anon_sym_DASH_DOT,
    ACTIONS(1687), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1689), 4,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
    ACTIONS(1695), 4,
      anon_sym_STAR_DOT,
      anon_sym_SLASH_DOT,
      anon_sym_PERCENT,
      anon_sym_LT_GT,
    ACTIONS(1745), 5,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_DOT_DOT,
  [42546] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1731), 1,
      anon_sym_POUND,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    ACTIONS(1735), 1,
      anon_sym_LT_LT,
    ACTIONS(1747), 1,
      anon_sym_DQUOTE,
    ACTIONS(1749), 1,
      sym_float,
    ACTIONS(1753), 1,
      sym__decimal,
    ACTIONS(1755), 1,
      sym__name,
    ACTIONS(1757), 1,
      sym__upname,
    STATE(788), 1,
      sym__case_clause_guard_binary_expression,
    STATE(789), 1,
      sym__case_clause_tuple_access,
    STATE(790), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(559), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1751), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(802), 10,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [42614] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1731), 1,
      anon_sym_POUND,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    ACTIONS(1735), 1,
      anon_sym_LT_LT,
    ACTIONS(1737), 1,
      anon_sym_DASH,
    ACTIONS(1759), 1,
      sym_float,
    STATE(744), 1,
      sym_identifier,
    STATE(788), 1,
      sym__case_clause_guard_binary_expression,
    STATE(789), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(559), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(749), 10,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [42682] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1370), 1,
      sym_float,
    ACTIONS(1761), 1,
      anon_sym_assert,
    STATE(690), 1,
      sym__assignment,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(1133), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [42754] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1731), 1,
      anon_sym_POUND,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    ACTIONS(1735), 1,
      anon_sym_LT_LT,
    ACTIONS(1747), 1,
      anon_sym_DQUOTE,
    ACTIONS(1753), 1,
      sym__decimal,
    ACTIONS(1755), 1,
      sym__name,
    ACTIONS(1757), 1,
      sym__upname,
    ACTIONS(1763), 1,
      sym_float,
    STATE(788), 1,
      sym__case_clause_guard_binary_expression,
    STATE(789), 1,
      sym__case_clause_tuple_access,
    STATE(790), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(559), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1751), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(829), 10,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [42822] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1731), 1,
      anon_sym_POUND,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    ACTIONS(1735), 1,
      anon_sym_LT_LT,
    ACTIONS(1747), 1,
      anon_sym_DQUOTE,
    ACTIONS(1753), 1,
      sym__decimal,
    ACTIONS(1755), 1,
      sym__name,
    ACTIONS(1757), 1,
      sym__upname,
    ACTIONS(1765), 1,
      sym_float,
    STATE(788), 1,
      sym__case_clause_guard_binary_expression,
    STATE(789), 1,
      sym__case_clause_tuple_access,
    STATE(790), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(559), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1751), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(830), 10,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [42890] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1703), 1,
      sym_float,
    ACTIONS(1767), 1,
      anon_sym_LT_DASH,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(964), 1,
      sym__pattern,
    STATE(1176), 1,
      sym_use_assignment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(950), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [42962] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1370), 1,
      sym_float,
    ACTIONS(1769), 1,
      anon_sym_GT_GT,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(1115), 1,
      sym__pattern,
    STATE(1116), 1,
      sym_pattern_bit_string_segment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [43034] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1370), 1,
      sym_float,
    ACTIONS(1771), 1,
      anon_sym_GT_GT,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(1115), 1,
      sym__pattern,
    STATE(1261), 1,
      sym_pattern_bit_string_segment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [43106] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1370), 1,
      sym_float,
    ACTIONS(1773), 1,
      anon_sym_assert,
    STATE(496), 1,
      sym__assignment,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(1054), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [43178] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(740), 1,
      sym__name,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1370), 1,
      sym_float,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(1083), 1,
      sym__pattern,
    STATE(1121), 1,
      sym_record_pattern_argument,
    STATE(1331), 1,
      sym_label,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [43250] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1731), 1,
      anon_sym_POUND,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    ACTIONS(1735), 1,
      anon_sym_LT_LT,
    ACTIONS(1747), 1,
      anon_sym_DQUOTE,
    ACTIONS(1753), 1,
      sym__decimal,
    ACTIONS(1755), 1,
      sym__name,
    ACTIONS(1757), 1,
      sym__upname,
    ACTIONS(1775), 1,
      sym_float,
    STATE(788), 1,
      sym__case_clause_guard_binary_expression,
    STATE(789), 1,
      sym__case_clause_tuple_access,
    STATE(790), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(559), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1751), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(831), 10,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [43318] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1703), 1,
      sym_float,
    ACTIONS(1777), 1,
      anon_sym_LT_DASH,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(964), 1,
      sym__pattern,
    STATE(1176), 1,
      sym_use_assignment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(950), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [43390] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1731), 1,
      anon_sym_POUND,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    ACTIONS(1735), 1,
      anon_sym_LT_LT,
    ACTIONS(1737), 1,
      anon_sym_DASH,
    ACTIONS(1779), 1,
      sym_float,
    STATE(744), 1,
      sym_identifier,
    STATE(788), 1,
      sym__case_clause_guard_binary_expression,
    STATE(789), 1,
      sym__case_clause_tuple_access,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(559), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(799), 10,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [43458] = 18,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1288), 1,
      anon_sym_DASH,
    ACTIONS(1729), 1,
      anon_sym_LBRACE,
    ACTIONS(1731), 1,
      anon_sym_POUND,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    ACTIONS(1735), 1,
      anon_sym_LT_LT,
    ACTIONS(1747), 1,
      anon_sym_DQUOTE,
    ACTIONS(1753), 1,
      sym__decimal,
    ACTIONS(1755), 1,
      sym__name,
    ACTIONS(1757), 1,
      sym__upname,
    ACTIONS(1759), 1,
      sym_float,
    STATE(788), 1,
      sym__case_clause_guard_binary_expression,
    STATE(789), 1,
      sym__case_clause_tuple_access,
    STATE(790), 1,
      sym_identifier,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(559), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1751), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(749), 10,
      sym__constant_value,
      sym_constant_tuple,
      sym_constant_list,
      sym__constant_bit_string,
      sym_constant_record,
      sym_constant_field_access,
      sym__case_clause_guard_expression,
      sym__case_clause_guard_unit,
      sym_string,
      sym_integer,
  [43526] = 20,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1370), 1,
      sym_float,
    ACTIONS(1781), 1,
      anon_sym_GT_GT,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(1115), 1,
      sym__pattern,
    STATE(1261), 1,
      sym_pattern_bit_string_segment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [43598] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1561), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1559), 23,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_type,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [43637] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1370), 1,
      sym_float,
    STATE(533), 1,
      sym__assignment,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(858), 1,
      sym_identifier,
    STATE(1109), 1,
      sym__pattern,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(734), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(882), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [43706] = 4,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    ACTIONS(1565), 4,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(1563), 23,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_import,
      anon_sym_const,
      anon_sym_RBRACK,
      anon_sym_GT_GT,
      anon_sym_fn,
      anon_sym_DASH_GT,
      anon_sym_external,
      anon_sym_type,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_DOT,
      anon_sym_LT_EQ_DOT,
      anon_sym_GT_DOT,
      anon_sym_GT_EQ_DOT,
      sym_visibility_modifier,
      sym_opacity_modifier,
  [43745] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTIONS(1286), 1,
      anon_sym_LT_LT,
    ACTIONS(1290), 1,
      anon_sym_DQUOTE,
    ACTIONS(1296), 1,
      sym__decimal,
    ACTIONS(1298), 1,
      sym__discard_name,
    ACTIONS(1300), 1,
      sym__name,
    ACTIONS(1302), 1,
      sym__upname,
    ACTIONS(1366), 1,
      anon_sym_DASH,
    ACTIONS(1703), 1,
      sym_float,
    STATE(824), 1,
      sym__pattern_binary_expression,
    STATE(881), 1,
      sym_identifier,
    STATE(964), 1,
      sym__pattern,
    STATE(1176), 1,
      sym_use_assignment,
    ACTIONS(5), 2,
      sym_statement_comment,
      sym_comment,
    STATE(734), 2,
      sym_constructor_name,
      sym_remote_constructor_name,
    ACTIONS(1294), 3,
      sym__hex,
      sym__octal,
      sym__binary,
    STATE(950), 8,
      sym__pattern_expression,
      sym_record_pattern,
      sym_tuple_pattern,
      sym__pattern_bit_string,
      sym_list_pattern,
      sym_string,
      sym_integer,
      sym_discard,
  [43814] = 19,
    ACTIONS(3), 1,
      sym_module_comment,
    ACTIONS(730), 1,
      anon_sym_DQUOTE,
    ACTIONS(736), 1,
      sym__decimal,
    ACTIONS(742), 1,
      sym__upname,
    ACTIONS(784), 1,
      sym__name,
    ACTIONS(1282), 1,
      anon_sym_POUND,
    ACTIONS(1284), 1,
      anon_sym_LBRACK,
    ACTION