#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 9261
#define LARGE_STATE_COUNT 4570
#define SYMBOL_COUNT 413
#define ALIAS_COUNT 3
#define TOKEN_COUNT 190
#define EXTERNAL_TOKEN_COUNT 4
#define FIELD_COUNT 12
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 25

enum {
  anon_sym_namespace = 1,
  anon_sym_global = 2,
  anon_sym_module = 3,
  anon_sym_EQ = 4,
  anon_sym_POUNDnowarn = 5,
  anon_sym_POUNDr = 6,
  anon_sym_POUNDload = 7,
  anon_sym_open = 8,
  anon_sym_LBRACK_LT = 9,
  anon_sym_SEMI = 10,
  anon_sym_GT_RBRACK = 11,
  anon_sym_COLON = 12,
  anon_sym_assembly = 13,
  anon_sym_return = 14,
  anon_sym_field = 15,
  anon_sym_property = 16,
  anon_sym_param = 17,
  anon_sym_type = 18,
  anon_sym_constructor = 19,
  anon_sym_event = 20,
  anon_sym_do = 21,
  anon_sym_and = 22,
  anon_sym_let = 23,
  anon_sym_let_BANG = 24,
  anon_sym_rec = 25,
  anon_sym_inline = 26,
  anon_sym_mutable = 27,
  anon_sym_private = 28,
  anon_sym_internal = 29,
  anon_sym_public = 30,
  anon_sym_null = 31,
  anon_sym__ = 32,
  anon_sym_LPAREN = 33,
  anon_sym_RPAREN = 34,
  anon_sym_COMMA = 35,
  anon_sym_as = 36,
  anon_sym_COLON_COLON = 37,
  anon_sym_PIPE = 38,
  anon_sym_AMP = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_LBRACK_PIPE = 42,
  anon_sym_PIPE_RBRACK = 43,
  anon_sym_LBRACE = 44,
  anon_sym_LPAREN2 = 45,
  anon_sym_RBRACE = 46,
  anon_sym_with = 47,
  anon_sym_new = 48,
  anon_sym_lazy = 49,
  anon_sym_assert = 50,
  anon_sym_upcast = 51,
  anon_sym_downcast = 52,
  anon_sym_PERCENT = 53,
  anon_sym_PERCENT_PERCENT = 54,
  anon_sym_return_BANG = 55,
  anon_sym_yield = 56,
  anon_sym_yield_BANG = 57,
  anon_sym_LT_AT = 58,
  anon_sym_AT_GT = 59,
  anon_sym_LT_AT_AT = 60,
  anon_sym_AT_AT_GT = 61,
  anon_sym_COLON_GT = 62,
  anon_sym_COLON_QMARK = 63,
  anon_sym_COLON_QMARK_GT = 64,
  anon_sym_begin = 65,
  anon_sym_end = 66,
  anon_sym_for = 67,
  anon_sym_in = 68,
  anon_sym_to = 69,
  anon_sym_downto = 70,
  anon_sym_done = 71,
  anon_sym_while = 72,
  anon_sym_else = 73,
  anon_sym_elif = 74,
  anon_sym_then = 75,
  anon_sym_if = 76,
  anon_sym_fun = 77,
  anon_sym_DASH_GT = 78,
  anon_sym_try = 79,
  anon_sym_finally = 80,
  anon_sym_match = 81,
  anon_sym_match_BANG = 82,
  anon_sym_function = 83,
  anon_sym_LT_DASH = 84,
  anon_sym_DOT = 85,
  anon_sym_LBRACK2 = 86,
  anon_sym_LT = 87,
  anon_sym_GT = 88,
  anon_sym_use = 89,
  anon_sym_use_BANG = 90,
  anon_sym_do_BANG = 91,
  anon_sym_DOT_DOT = 92,
  anon_sym_STAR = 93,
  anon_sym_LT2 = 94,
  anon_sym_POUND = 95,
  anon_sym_POUND2 = 96,
  anon_sym_unit = 97,
  anon_sym_SQUOTET = 98,
  anon_sym_struct = 99,
  anon_sym_not = 100,
  anon_sym_enum = 101,
  anon_sym_unmanaged = 102,
  anon_sym_equality = 103,
  anon_sym_comparison = 104,
  anon_sym_delegate = 105,
  anon_sym_when = 106,
  anon_sym_SQUOTE = 107,
  anon_sym_CARET = 108,
  anon_sym_or = 109,
  anon_sym_static = 110,
  anon_sym_member = 111,
  anon_sym_get = 112,
  anon_sym_set = 113,
  anon_sym_QMARK = 114,
  anon_sym_interface = 115,
  anon_sym_id = 116,
  anon_sym_of = 117,
  anon_sym_abstract = 118,
  anon_sym_override = 119,
  anon_sym_default = 120,
  anon_sym_val = 121,
  anon_sym_DOT2 = 122,
  anon_sym_inherit = 123,
  sym__escape_char = 124,
  sym__non_escape_char = 125,
  sym__simple_char_char = 126,
  sym__hex_digit_imm = 127,
  sym__digit_char_imm = 128,
  anon_sym_BSLASHu = 129,
  anon_sym_BSLASHU = 130,
  anon_sym_BSLASH = 131,
  sym__simple_string_char = 132,
  anon_sym_BSLASH2 = 133,
  anon_sym_SQUOTE2 = 134,
  anon_sym_DQUOTE = 135,
  anon_sym_DQUOTE2 = 136,
  anon_sym_AT_DQUOTE = 137,
  anon_sym_SQUOTEB = 138,
  anon_sym_DQUOTEB = 139,
  aux_sym__simple_or_escape_char_token1 = 140,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 141,
  anon_sym_DQUOTE_DQUOTE_DQUOTE2 = 142,
  anon_sym_false = 143,
  anon_sym_true = 144,
  anon_sym_LPAREN_STAR_RPAREN = 145,
  anon_sym_DOT_DOT_DOT_DOT = 146,
  anon_sym_PLUS = 147,
  anon_sym_DASH = 148,
  anon_sym_PLUS_DOT = 149,
  anon_sym_DASH_DOT = 150,
  anon_sym_AMP_AMP = 151,
  anon_sym_TILDE = 152,
  anon_sym_PIPE_PIPE = 153,
  anon_sym_BANG_EQ = 154,
  anon_sym_COLON_EQ = 155,
  anon_sym_DOLLAR = 156,
  anon_sym_QMARK_LT_DASH = 157,
  aux_sym_symbolic_op_token1 = 158,
  sym__octaldigit_imm = 159,
  sym__bitdigit_imm = 160,
  aux_sym_int_token1 = 161,
  aux_sym_xint_token1 = 162,
  aux_sym_xint_token2 = 163,
  aux_sym_xint_token3 = 164,
  anon_sym_y = 165,
  anon_sym_uy = 166,
  anon_sym_s = 167,
  anon_sym_us = 168,
  anon_sym_l = 169,
  aux_sym_uint32_token1 = 170,
  anon_sym_n = 171,
  anon_sym_un = 172,
  anon_sym_L = 173,
  aux_sym_uint64_token1 = 174,
  anon_sym_f = 175,
  anon_sym_lf = 176,
  anon_sym_LF = 177,
  aux_sym_bignum_token1 = 178,
  aux_sym_decimal_token1 = 179,
  sym_float = 180,
  anon_sym_LPAREN_STAR = 181,
  anon_sym_STAR_RPAREN = 182,
  sym_line_comment = 183,
  aux_sym_identifier_token1 = 184,
  aux_sym_identifier_token2 = 185,
  sym__virtual_open_section = 186,
  sym__virtual_end_section = 187,
  sym__virtual_end_decl = 188,
  sym_block_comment_content = 189,
  sym_file = 190,
  sym_namespace = 191,
  sym_named_module = 192,
  sym_module_abbrev = 193,
  sym_module_defn = 194,
  sym_compiler_directive_decl = 195,
  sym_fsi_directive_decl = 196,
  sym_import_decl = 197,
  sym_attributes = 198,
  sym_attribute_set = 199,
  sym_attribute = 200,
  sym_attribute_target = 201,
  sym_object_construction = 202,
  sym_value_declaration = 203,
  sym_do = 204,
  sym__function_or_value_defns = 205,
  sym_function_or_value_defn = 206,
  sym__function_or_value_defn_body = 207,
  sym_function_declaration_left = 208,
  sym_value_declaration_left = 209,
  sym__pattern = 210,
  sym_attribute_pattern = 211,
  sym_paren_pattern = 212,
  sym_repeat_pattern = 213,
  sym_identifier_pattern = 214,
  sym_as_pattern = 215,
  sym_cons_pattern = 216,
  sym_disjunct_pattern = 217,
  sym_conjunct_pattern = 218,
  sym_typed_pattern = 219,
  sym_argument_patterns = 220,
  sym_field_pattern = 221,
  sym__atomic_pattern = 222,
  sym_list_pattern = 223,
  sym_array_pattern = 224,
  sym_record_pattern = 225,
  sym__pattern_param = 226,
  sym__seq_infix = 227,
  sym__expressions = 228,
  sym__expression_inner = 229,
  sym_application_expression = 230,
  sym_call_expression = 231,
  sym_tuple_expression = 232,
  sym_brace_expression = 233,
  sym_with_field_expression = 234,
  sym_field_expression = 235,
  sym_object_expression = 236,
  sym_prefixed_expression = 237,
  sym_return_expression = 238,
  sym_yield_expression = 239,
  sym_ce_expression = 240,
  sym_infix_expression = 241,
  sym_literal_expression = 242,
  sym_typecast_expression = 243,
  sym_begin_end_expression = 244,
  sym_paren_expression = 245,
  sym_for_expression = 246,
  sym_while_expression = 247,
  sym__else_expression = 248,
  sym_elif_expression = 249,
  sym_if_expression = 250,
  sym_fun_expression = 251,
  sym_try_expression = 252,
  sym_match_expression = 253,
  sym_function_expression = 254,
  sym_object_instantiation_expression = 255,
  sym_mutate_expression = 256,
  sym_index_expression = 257,
  sym_dot_expression = 258,
  sym_typed_expression = 259,
  sym_declaration_expression = 260,
  sym_do_expression = 261,
  sym__list_elements = 262,
  sym__list_element = 263,
  sym_list_expression = 264,
  sym_array_expression = 265,
  sym_range_expression = 266,
  sym_rule = 267,
  sym_rules = 268,
  sym__comp_or_range_expression = 269,
  sym_short_comp_expression = 270,
  sym_slice_ranges = 271,
  sym__slice_range_special = 272,
  sym_slice_range = 273,
  sym_type = 274,
  sym_types = 275,
  sym_type_attribute = 276,
  sym_type_attributes = 277,
  sym_constraint = 278,
  sym_type_argument_constraints = 279,
  sym_type_argument = 280,
  sym_type_argument_defn = 281,
  sym_static_type_argument = 282,
  sym_type_arguments = 283,
  sym_trait_member_constraint = 284,
  sym_member_signature = 285,
  sym_type_definition = 286,
  sym__type_defn_body = 287,
  sym_type_name = 288,
  sym_type_extension = 289,
  sym_delegate_type_defn = 290,
  sym_delegate_signature = 291,
  sym_type_abbrev_defn = 292,
  sym__class_type_body_inner = 293,
  sym__class_type_body = 294,
  sym_record_type_defn = 295,
  sym_record_fields = 296,
  sym_record_field = 297,
  sym_enum_type_defn = 298,
  sym_enum_type_cases = 299,
  sym_enum_type_case = 300,
  sym_union_type_defn = 301,
  sym_union_type_cases = 302,
  sym_union_type_case = 303,
  sym_union_type_fields = 304,
  sym_union_type_field = 305,
  sym_anon_type_defn = 306,
  sym_primary_constr_args = 307,
  sym_simple_pattern = 308,
  sym__class_function_or_value_defn = 309,
  sym_type_extension_elements = 310,
  sym__type_defn_elements = 311,
  sym__interface_implementations = 312,
  sym_interface_implementation = 313,
  sym__member_defns = 314,
  sym__object_members = 315,
  sym_member_defn = 316,
  sym_property_or_ident = 317,
  sym__method_defn = 318,
  sym__property_defn = 319,
  sym_method_or_prop_defn = 320,
  sym_additional_constr_defn = 321,
  sym_class_inherits_decl = 322,
  sym_as_defn = 323,
  sym_field_initializer = 324,
  sym_field_initializers = 325,
  sym__unicodegraph_short = 326,
  sym__unicodegraph_long = 327,
  sym__trigraph = 328,
  sym__char_char = 329,
  sym__string_char = 330,
  sym_char = 331,
  sym_string = 332,
  sym__verbatim_string_char = 333,
  sym_verbatim_string = 334,
  sym_bytechar = 335,
  sym_bytearray = 336,
  sym_verbatim_bytearray = 337,
  sym__simple_or_escape_char = 338,
  sym_triple_quoted_string = 339,
  sym_unit = 340,
  sym_const = 341,
  sym_long_identifier_or_op = 342,
  sym_long_identifier = 343,
  sym__identifier_or_op = 344,
  sym_op_name = 345,
  sym_range_op_name = 346,
  sym_active_pattern_op_name = 347,
  sym_prefix_op = 348,
  sym_infix_op = 349,
  sym_symbolic_op = 350,
  sym_int = 351,
  sym_xint = 352,
  sym_sbyte = 353,
  sym_byte = 354,
  sym_int16 = 355,
  sym_uint16 = 356,
  sym_int32 = 357,
  sym_uint32 = 358,
  sym_nativeint = 359,
  sym_unativeint = 360,
  sym_int64 = 361,
  sym_uint64 = 362,
  sym_ieee32 = 363,
  sym_ieee64 = 364,
  sym_bignum = 365,
  sym_decimal = 366,
  sym_block_comment = 367,
  sym_identifier = 368,
  aux_sym_file_repeat1 = 369,
  aux_sym_compiler_directive_decl_repeat1 = 370,
  aux_sym_attributes_repeat1 = 371,
  aux_sym_attribute_set_repeat1 = 372,
  aux_sym__function_or_value_defns_repeat1 = 373,
  aux_sym_repeat_pattern_repeat1 = 374,
  aux_sym_argument_patterns_repeat1 = 375,
  aux_sym_list_pattern_repeat1 = 376,
  aux_sym_record_pattern_repeat1 = 377,
  aux_sym__seq_infix_repeat1 = 378,
  aux_sym__seq_expressions_repeat1 = 379,
  aux_sym_application_expression_repeat1 = 380,
  aux_sym_tuple_expression_repeat1 = 381,
  aux_sym_if_expression_repeat1 = 382,
  aux_sym__list_elements_repeat1 = 383,
  aux_sym_rules_repeat1 = 384,
  aux_sym_slice_ranges_repeat1 = 385,
  aux_sym_type_repeat1 = 386,
  aux_sym_type_repeat2 = 387,
  aux_sym_types_repeat1 = 388,
  aux_sym_type_attributes_repeat1 = 389,
  aux_sym_type_argument_constraints_repeat1 = 390,
  aux_sym_static_type_argument_repeat1 = 391,
  aux_sym_type_arguments_repeat1 = 392,
  aux_sym_type_definition_repeat1 = 393,
  aux_sym__class_type_body_repeat1 = 394,
  aux_sym_record_fields_repeat1 = 395,
  aux_sym_enum_type_cases_repeat1 = 396,
  aux_sym_union_type_cases_repeat1 = 397,
  aux_sym_union_type_fields_repeat1 = 398,
  aux_sym_primary_constr_args_repeat1 = 399,
  aux_sym__interface_implementations_repeat1 = 400,
  aux_sym__member_defns_repeat1 = 401,
  aux_sym_field_initializers_repeat1 = 402,
  aux_sym_string_repeat1 = 403,
  aux_sym_verbatim_string_repeat1 = 404,
  aux_sym_triple_quoted_string_repeat1 = 405,
  aux_sym_long_identifier_repeat1 = 406,
  aux_sym_active_pattern_op_name_repeat1 = 407,
  aux_sym_prefix_op_repeat1 = 408,
  aux_sym_int_repeat1 = 409,
  aux_sym_xint_repeat1 = 410,
  aux_sym_xint_repeat2 = 411,
  aux_sym_xint_repeat3 = 412,
  alias_sym_const_pattern = 413,
  alias_sym_null_pattern = 414,
  alias_sym_wildcard_pattern = 415,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_namespace] = "namespace",
  [anon_sym_global] = "global",
  [anon_sym_module] = "module",
  [anon_sym_EQ] = "=",
  [anon_sym_POUNDnowarn] = "#nowarn",
  [anon_sym_POUNDr] = "#r",
  [anon_sym_POUNDload] = "#load",
  [anon_sym_open] = "open",
  [anon_sym_LBRACK_LT] = "[<",
  [anon_sym_SEMI] = ";",
  [anon_sym_GT_RBRACK] = ">]",
  [anon_sym_COLON] = ":",
  [anon_sym_assembly] = "assembly",
  [anon_sym_return] = "return",
  [anon_sym_field] = "field",
  [anon_sym_property] = "property",
  [anon_sym_param] = "param",
  [anon_sym_type] = "type",
  [anon_sym_constructor] = "constructor",
  [anon_sym_event] = "event",
  [anon_sym_do] = "do",
  [anon_sym_and] = "and",
  [anon_sym_let] = "let",
  [anon_sym_let_BANG] = "let!",
  [anon_sym_rec] = "rec",
  [anon_sym_inline] = "inline",
  [anon_sym_mutable] = "mutable",
  [anon_sym_private] = "private",
  [anon_sym_internal] = "internal",
  [anon_sym_public] = "public",
  [anon_sym_null] = "null",
  [anon_sym__] = "_",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_PIPE] = "[|",
  [anon_sym_PIPE_RBRACK] = "|]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_RBRACE] = "}",
  [anon_sym_with] = "with",
  [anon_sym_new] = "new",
  [anon_sym_lazy] = "lazy",
  [anon_sym_assert] = "assert",
  [anon_sym_upcast] = "upcast",
  [anon_sym_downcast] = "downcast",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PERCENT_PERCENT] = "%%",
  [anon_sym_return_BANG] = "return!",
  [anon_sym_yield] = "yield",
  [anon_sym_yield_BANG] = "yield!",
  [anon_sym_LT_AT] = "<@",
  [anon_sym_AT_GT] = "@>",
  [anon_sym_LT_AT_AT] = "<@@",
  [anon_sym_AT_AT_GT] = "@@>",
  [anon_sym_COLON_GT] = ":>",
  [anon_sym_COLON_QMARK] = ":\?",
  [anon_sym_COLON_QMARK_GT] = ":\?>",
  [anon_sym_begin] = "begin",
  [anon_sym_end] = "end",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_to] = "to",
  [anon_sym_downto] = "downto",
  [anon_sym_done] = "done",
  [anon_sym_while] = "while",
  [anon_sym_else] = "else",
  [anon_sym_elif] = "elif",
  [anon_sym_then] = "then",
  [anon_sym_if] = "if",
  [anon_sym_fun] = "fun",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_try] = "try",
  [anon_sym_finally] = "finally",
  [anon_sym_match] = "match",
  [anon_sym_match_BANG] = "match!",
  [anon_sym_function] = "function",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACK2] = "[",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_use] = "use",
  [anon_sym_use_BANG] = "use!",
  [anon_sym_do_BANG] = "do!",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_STAR] = "*",
  [anon_sym_LT2] = "<",
  [anon_sym_POUND] = "#",
  [anon_sym_POUND2] = "#",
  [anon_sym_unit] = "unit",
  [anon_sym_SQUOTET] = "'T",
  [anon_sym_struct] = "struct",
  [anon_sym_not] = "not",
  [anon_sym_enum] = "enum",
  [anon_sym_unmanaged] = "unmanaged",
  [anon_sym_equality] = "equality",
  [anon_sym_comparison] = "comparison",
  [anon_sym_delegate] = "delegate",
  [anon_sym_when] = "when",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_CARET] = "^",
  [anon_sym_or] = "or",
  [anon_sym_static] = "static",
  [anon_sym_member] = "member",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_QMARK] = "\?",
  [anon_sym_interface] = "interface",
  [anon_sym_id] = "id",
  [anon_sym_of] = "of",
  [anon_sym_abstract] = "abstract",
  [anon_sym_override] = "override",
  [anon_sym_default] = "default",
  [anon_sym_val] = "val",
  [anon_sym_DOT2] = ".",
  [anon_sym_inherit] = "inherit",
  [sym__escape_char] = "_escape_char",
  [sym__non_escape_char] = "_non_escape_char",
  [sym__simple_char_char] = "_simple_char_char",
  [sym__hex_digit_imm] = "_hex_digit_imm",
  [sym__digit_char_imm] = "_digit_char_imm",
  [anon_sym_BSLASHu] = "\\u",
  [anon_sym_BSLASHU] = "\\U",
  [anon_sym_BSLASH] = "\\",
  [sym__simple_string_char] = "_simple_string_char",
  [anon_sym_BSLASH2] = "\\",
  [anon_sym_SQUOTE2] = "'",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE2] = "\"",
  [anon_sym_AT_DQUOTE] = "@\"",
  [anon_sym_SQUOTEB] = "'B",
  [anon_sym_DQUOTEB] = "\"B",
  [aux_sym__simple_or_escape_char_token1] = "_simple_or_escape_char_token1",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE2] = "\"\"\"",
  [anon_sym_false] = "false",
  [anon_sym_true] = "true",
  [anon_sym_LPAREN_STAR_RPAREN] = "(*)",
  [anon_sym_DOT_DOT_DOT_DOT] = ".. ..",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS_DOT] = "+.",
  [anon_sym_DASH_DOT] = "-.",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_TILDE] = "~",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_QMARK_LT_DASH] = "\?<-",
  [aux_sym_symbolic_op_token1] = "symbolic_op_token1",
  [sym__octaldigit_imm] = "_octaldigit_imm",
  [sym__bitdigit_imm] = "_bitdigit_imm",
  [aux_sym_int_token1] = "int_token1",
  [aux_sym_xint_token1] = "xint_token1",
  [aux_sym_xint_token2] = "xint_token2",
  [aux_sym_xint_token3] = "xint_token3",
  [anon_sym_y] = "y",
  [anon_sym_uy] = "uy",
  [anon_sym_s] = "s",
  [anon_sym_us] = "us",
  [anon_sym_l] = "l",
  [aux_sym_uint32_token1] = "uint32_token1",
  [anon_sym_n] = "n",
  [anon_sym_un] = "un",
  [anon_sym_L] = "L",
  [aux_sym_uint64_token1] = "uint64_token1",
  [anon_sym_f] = "f",
  [anon_sym_lf] = "lf",
  [anon_sym_LF] = "LF",
  [aux_sym_bignum_token1] = "bignum_token1",
  [aux_sym_decimal_token1] = "decimal_token1",
  [sym_float] = "float",
  [anon_sym_LPAREN_STAR] = "(*",
  [anon_sym_STAR_RPAREN] = "*)",
  [sym_line_comment] = "line_comment",
  [aux_sym_identifier_token1] = "identifier_token1",
  [aux_sym_identifier_token2] = "identifier_token2",
  [sym__virtual_open_section] = "_virtual_open_section",
  [sym__virtual_end_section] = "_virtual_end_section",
  [sym__virtual_end_decl] = "_virtual_end_decl",
  [sym_block_comment_content] = "block_comment_content",
  [sym_file] = "file",
  [sym_namespace] = "namespace",
  [sym_named_module] = "named_module",
  [sym_module_abbrev] = "module_abbrev",
  [sym_module_defn] = "module_defn",
  [sym_compiler_directive_decl] = "compiler_directive_decl",
  [sym_fsi_directive_decl] = "fsi_directive_decl",
  [sym_import_decl] = "import_decl",
  [sym_attributes] = "attributes",
  [sym_attribute_set] = "attribute_set",
  [sym_attribute] = "attribute",
  [sym_attribute_target] = "attribute_target",
  [sym_object_construction] = "object_construction",
  [sym_value_declaration] = "value_declaration",
  [sym_do] = "do",
  [sym__function_or_value_defns] = "_function_or_value_defns",
  [sym_function_or_value_defn] = "function_or_value_defn",
  [sym__function_or_value_defn_body] = "_function_or_value_defn_body",
  [sym_function_declaration_left] = "function_declaration_left",
  [sym_value_declaration_left] = "value_declaration_left",
  [sym__pattern] = "_pattern",
  [sym_attribute_pattern] = "attribute_pattern",
  [sym_paren_pattern] = "paren_pattern",
  [sym_repeat_pattern] = "repeat_pattern",
  [sym_identifier_pattern] = "identifier_pattern",
  [sym_as_pattern] = "as_pattern",
  [sym_cons_pattern] = "cons_pattern",
  [sym_disjunct_pattern] = "disjunct_pattern",
  [sym_conjunct_pattern] = "conjunct_pattern",
  [sym_typed_pattern] = "typed_pattern",
  [sym_argument_patterns] = "argument_patterns",
  [sym_field_pattern] = "field_pattern",
  [sym__atomic_pattern] = "_atomic_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_array_pattern] = "array_pattern",
  [sym_record_pattern] = "record_pattern",
  [sym__pattern_param] = "_pattern_param",
  [sym__seq_infix] = "infix_expression",
  [sym__expressions] = "_expressions",
  [sym__expression_inner] = "_expression_inner",
  [sym_application_expression] = "application_expression",
  [sym_call_expression] = "call_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_brace_expression] = "brace_expression",
  [sym_with_field_expression] = "with_field_expression",
  [sym_field_expression] = "field_expression",
  [sym_object_expression] = "object_expression",
  [sym_prefixed_expression] = "prefixed_expression",
  [sym_return_expression] = "return_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_ce_expression] = "ce_expression",
  [sym_infix_expression] = "infix_expression",
  [sym_literal_expression] = "literal_expression",
  [sym_typecast_expression] = "typecast_expression",
  [sym_begin_end_expression] = "begin_end_expression",
  [sym_paren_expression] = "paren_expression",
  [sym_for_expression] = "for_expression",
  [sym_while_expression] = "while_expression",
  [sym__else_expression] = "_else_expression",
  [sym_elif_expression] = "elif_expression",
  [sym_if_expression] = "if_expression",
  [sym_fun_expression] = "fun_expression",
  [sym_try_expression] = "try_expression",
  [sym_match_expression] = "match_expression",
  [sym_function_expression] = "function_expression",
  [sym_object_instantiation_expression] = "object_instantiation_expression",
  [sym_mutate_expression] = "mutate_expression",
  [sym_index_expression] = "index_expression",
  [sym_dot_expression] = "dot_expression",
  [sym_typed_expression] = "typed_expression",
  [sym_declaration_expression] = "declaration_expression",
  [sym_do_expression] = "do_expression",
  [sym__list_elements] = "_list_elements",
  [sym__list_element] = "_list_element",
  [sym_list_expression] = "list_expression",
  [sym_array_expression] = "array_expression",
  [sym_range_expression] = "range_expression",
  [sym_rule] = "rule",
  [sym_rules] = "rules",
  [sym__comp_or_range_expression] = "_comp_or_range_expression",
  [sym_short_comp_expression] = "short_comp_expression",
  [sym_slice_ranges] = "slice_ranges",
  [sym__slice_range_special] = "_slice_range_special",
  [sym_slice_range] = "slice_range",
  [sym_type] = "type",
  [sym_types] = "types",
  [sym_type_attribute] = "type_attribute",
  [sym_type_attributes] = "type_attributes",
  [sym_constraint] = "constraint",
  [sym_type_argument_constraints] = "type_argument_constraints",
  [sym_type_argument] = "type_argument",
  [sym_type_argument_defn] = "type_argument_defn",
  [sym_static_type_argument] = "static_type_argument",
  [sym_type_arguments] = "type_arguments",
  [sym_trait_member_constraint] = "trait_member_constraint",
  [sym_member_signature] = "member_signature",
  [sym_type_definition] = "type_definition",
  [sym__type_defn_body] = "_type_defn_body",
  [sym_type_name] = "type_name",
  [sym_type_extension] = "type_extension",
  [sym_delegate_type_defn] = "delegate_type_defn",
  [sym_delegate_signature] = "delegate_signature",
  [sym_type_abbrev_defn] = "type_abbrev_defn",
  [sym__class_type_body_inner] = "_class_type_body_inner",
  [sym__class_type_body] = "_class_type_body",
  [sym_record_type_defn] = "record_type_defn",
  [sym_record_fields] = "record_fields",
  [sym_record_field] = "record_field",
  [sym_enum_type_defn] = "enum_type_defn",
  [sym_enum_type_cases] = "enum_type_cases",
  [sym_enum_type_case] = "enum_type_case",
  [sym_union_type_defn] = "union_type_defn",
  [sym_union_type_cases] = "union_type_cases",
  [sym_union_type_case] = "union_type_case",
  [sym_union_type_fields] = "union_type_fields",
  [sym_union_type_field] = "union_type_field",
  [sym_anon_type_defn] = "anon_type_defn",
  [sym_primary_constr_args] = "primary_constr_args",
  [sym_simple_pattern] = "simple_pattern",
  [sym__class_function_or_value_defn] = "_class_function_or_value_defn",
  [sym_type_extension_elements] = "type_extension_elements",
  [sym__type_defn_elements] = "_type_defn_elements",
  [sym__interface_implementations] = "_interface_implementations",
  [sym_interface_implementation] = "interface_implementation",
  [sym__member_defns] = "_member_defns",
  [sym__object_members] = "_object_members",
  [sym_member_defn] = "member_defn",
  [sym_property_or_ident] = "property_or_ident",
  [sym__method_defn] = "_method_defn",
  [sym__property_defn] = "_property_defn",
  [sym_method_or_prop_defn] = "method_or_prop_defn",
  [sym_additional_constr_defn] = "additional_constr_defn",
  [sym_class_inherits_decl] = "class_inherits_decl",
  [sym_as_defn] = "as_defn",
  [sym_field_initializer] = "field_initializer",
  [sym_field_initializers] = "field_initializers",
  [sym__unicodegraph_short] = "_unicodegraph_short",
  [sym__unicodegraph_long] = "_unicodegraph_long",
  [sym__trigraph] = "_trigraph",
  [sym__char_char] = "_char_char",
  [sym__string_char] = "_string_char",
  [sym_char] = "char",
  [sym_string] = "string",
  [sym__verbatim_string_char] = "_verbatim_string_char",
  [sym_verbatim_string] = "verbatim_string",
  [sym_bytechar] = "bytechar",
  [sym_bytearray] = "bytearray",
  [sym_verbatim_bytearray] = "verbatim_bytearray",
  [sym__simple_or_escape_char] = "_simple_or_escape_char",
  [sym_triple_quoted_string] = "triple_quoted_string",
  [sym_unit] = "unit",
  [sym_const] = "const",
  [sym_long_identifier_or_op] = "long_identifier_or_op",
  [sym_long_identifier] = "long_identifier",
  [sym__identifier_or_op] = "_identifier_or_op",
  [sym_op_name] = "op_name",
  [sym_range_op_name] = "range_op_name",
  [sym_active_pattern_op_name] = "active_pattern_op_name",
  [sym_prefix_op] = "prefix_op",
  [sym_infix_op] = "infix_op",
  [sym_symbolic_op] = "symbolic_op",
  [sym_int] = "int",
  [sym_xint] = "xint",
  [sym_sbyte] = "sbyte",
  [sym_byte] = "byte",
  [sym_int16] = "int16",
  [sym_uint16] = "uint16",
  [sym_int32] = "int32",
  [sym_uint32] = "uint32",
  [sym_nativeint] = "nativeint",
  [sym_unativeint] = "unativeint",
  [sym_int64] = "int64",
  [sym_uint64] = "uint64",
  [sym_ieee32] = "ieee32",
  [sym_ieee64] = "ieee64",
  [sym_bignum] = "bignum",
  [sym_decimal] = "decimal",
  [sym_block_comment] = "block_comment",
  [sym_identifier] = "identifier",
  [aux_sym_file_repeat1] = "file_repeat1",
  [aux_sym_compiler_directive_decl_repeat1] = "compiler_directive_decl_repeat1",
  [aux_sym_attributes_repeat1] = "attributes_repeat1",
  [aux_sym_attribute_set_repeat1] = "attribute_set_repeat1",
  [aux_sym__function_or_value_defns_repeat1] = "_function_or_value_defns_repeat1",
  [aux_sym_repeat_pattern_repeat1] = "repeat_pattern_repeat1",
  [aux_sym_argument_patterns_repeat1] = "argument_patterns_repeat1",
  [aux_sym_list_pattern_repeat1] = "list_pattern_repeat1",
  [aux_sym_record_pattern_repeat1] = "record_pattern_repeat1",
  [aux_sym__seq_infix_repeat1] = "_seq_infix_repeat1",
  [aux_sym__seq_expressions_repeat1] = "_seq_expressions_repeat1",
  [aux_sym_application_expression_repeat1] = "application_expression_repeat1",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_if_expression_repeat1] = "if_expression_repeat1",
  [aux_sym__list_elements_repeat1] = "_list_elements_repeat1",
  [aux_sym_rules_repeat1] = "rules_repeat1",
  [aux_sym_slice_ranges_repeat1] = "slice_ranges_repeat1",
  [aux_sym_type_repeat1] = "type_repeat1",
  [aux_sym_type_repeat2] = "type_repeat2",
  [aux_sym_types_repeat1] = "types_repeat1",
  [aux_sym_type_attributes_repeat1] = "type_attributes_repeat1",
  [aux_sym_type_argument_constraints_repeat1] = "type_argument_constraints_repeat1",
  [aux_sym_static_type_argument_repeat1] = "static_type_argument_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_type_definition_repeat1] = "type_definition_repeat1",
  [aux_sym__class_type_body_repeat1] = "_class_type_body_repeat1",
  [aux_sym_record_fields_repeat1] = "record_fields_repeat1",
  [aux_sym_enum_type_cases_repeat1] = "enum_type_cases_repeat1",
  [aux_sym_union_type_cases_repeat1] = "union_type_cases_repeat1",
  [aux_sym_union_type_fields_repeat1] = "union_type_fields_repeat1",
  [aux_sym_primary_constr_args_repeat1] = "primary_constr_args_repeat1",
  [aux_sym__interface_implementations_repeat1] = "_interface_implementations_repeat1",
  [aux_sym__member_defns_repeat1] = "_member_defns_repeat1",
  [aux_sym_field_initializers_repeat1] = "field_initializers_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_verbatim_string_repeat1] = "verbatim_string_repeat1",
  [aux_sym_triple_quoted_string_repeat1] = "triple_quoted_string_repeat1",
  [aux_sym_long_identifier_repeat1] = "long_identifier_repeat1",
  [aux_sym_active_pattern_op_name_repeat1] = "active_pattern_op_name_repeat1",
  [aux_sym_prefix_op_repeat1] = "prefix_op_repeat1",
  [aux_sym_int_repeat1] = "int_repeat1",
  [aux_sym_xint_repeat1] = "xint_repeat1",
  [aux_sym_xint_repeat2] = "xint_repeat2",
  [aux_sym_xint_repeat3] = "xint_repeat3",
  [alias_sym_const_pattern] = "const_pattern",
  [alias_sym_null_pattern] = "null_pattern",
  [alias_sym_wildcard_pattern] = "wildcard_pattern",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_POUNDnowarn] = anon_sym_POUNDnowarn,
  [anon_sym_POUNDr] = anon_sym_POUNDr,
  [anon_sym_POUNDload] = anon_sym_POUNDload,
  [anon_sym_open] = anon_sym_open,
  [anon_sym_LBRACK_LT] = anon_sym_LBRACK_LT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_GT_RBRACK] = anon_sym_GT_RBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_assembly] = anon_sym_assembly,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_field] = anon_sym_field,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_constructor] = anon_sym_constructor,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_let_BANG] = anon_sym_let_BANG,
  [anon_sym_rec] = anon_sym_rec,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym_mutable] = anon_sym_mutable,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_internal] = anon_sym_internal,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_null] = anon_sym_null,
  [anon_sym__] = anon_sym__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACK_PIPE] = anon_sym_LBRACK_PIPE,
  [anon_sym_PIPE_RBRACK] = anon_sym_PIPE_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_lazy] = anon_sym_lazy,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_upcast] = anon_sym_upcast,
  [anon_sym_downcast] = anon_sym_downcast,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PERCENT_PERCENT] = anon_sym_PERCENT_PERCENT,
  [anon_sym_return_BANG] = anon_sym_return_BANG,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_yield_BANG] = anon_sym_yield_BANG,
  [anon_sym_LT_AT] = anon_sym_LT_AT,
  [anon_sym_AT_GT] = anon_sym_AT_GT,
  [anon_sym_LT_AT_AT] = anon_sym_LT_AT_AT,
  [anon_sym_AT_AT_GT] = anon_sym_AT_AT_GT,
  [anon_sym_COLON_GT] = anon_sym_COLON_GT,
  [anon_sym_COLON_QMARK] = anon_sym_COLON_QMARK,
  [anon_sym_COLON_QMARK_GT] = anon_sym_COLON_QMARK_GT,
  [anon_sym_begin] = anon_sym_begin,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_to] = anon_sym_to,
  [anon_sym_downto] = anon_sym_downto,
  [anon_sym_done] = anon_sym_done,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_fun] = anon_sym_fun,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_match_BANG] = anon_sym_match_BANG,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACK2] = anon_sym_LBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_use] = anon_sym_use,
  [anon_sym_use_BANG] = anon_sym_use_BANG,
  [anon_sym_do_BANG] = anon_sym_do_BANG,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_LT2] = anon_sym_LT,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_POUND2] = anon_sym_POUND,
  [anon_sym_unit] = anon_sym_unit,
  [anon_sym_SQUOTET] = anon_sym_SQUOTET,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_unmanaged] = anon_sym_unmanaged,
  [anon_sym_equality] = anon_sym_equality,
  [anon_sym_comparison] = anon_sym_comparison,
  [anon_sym_delegate] = anon_sym_delegate,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_member] = anon_sym_member,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_id] = anon_sym_id,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_val] = anon_sym_val,
  [anon_sym_DOT2] = anon_sym_DOT,
  [anon_sym_inherit] = anon_sym_inherit,
  [sym__escape_char] = sym__escape_char,
  [sym__non_escape_char] = sym__non_escape_char,
  [sym__simple_char_char] = sym__simple_char_char,
  [sym__hex_digit_imm] = sym__hex_digit_imm,
  [sym__digit_char_imm] = sym__digit_char_imm,
  [anon_sym_BSLASHu] = anon_sym_BSLASHu,
  [anon_sym_BSLASHU] = anon_sym_BSLASHU,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [sym__simple_string_char] = sym__simple_string_char,
  [anon_sym_BSLASH2] = anon_sym_BSLASH,
  [anon_sym_SQUOTE2] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [anon_sym_AT_DQUOTE] = anon_sym_AT_DQUOTE,
  [anon_sym_SQUOTEB] = anon_sym_SQUOTEB,
  [anon_sym_DQUOTEB] = anon_sym_DQUOTEB,
  [aux_sym__simple_or_escape_char_token1] = aux_sym__simple_or_escape_char_token1,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE2] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_LPAREN_STAR_RPAREN] = anon_sym_LPAREN_STAR_RPAREN,
  [anon_sym_DOT_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT_DOT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS_DOT] = anon_sym_PLUS_DOT,
  [anon_sym_DASH_DOT] = anon_sym_DASH_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_QMARK_LT_DASH] = anon_sym_QMARK_LT_DASH,
  [aux_sym_symbolic_op_token1] = aux_sym_symbolic_op_token1,
  [sym__octaldigit_imm] = sym__octaldigit_imm,
  [sym__bitdigit_imm] = sym__bitdigit_imm,
  [aux_sym_int_token1] = aux_sym_int_token1,
  [aux_sym_xint_token1] = aux_sym_xint_token1,
  [aux_sym_xint_token2] = aux_sym_xint_token2,
  [aux_sym_xint_token3] = aux_sym_xint_token3,
  [anon_sym_y] = anon_sym_y,
  [anon_sym_uy] = anon_sym_uy,
  [anon_sym_s] = anon_sym_s,
  [anon_sym_us] = anon_sym_us,
  [anon_sym_l] = anon_sym_l,
  [aux_sym_uint32_token1] = aux_sym_uint32_token1,
  [anon_sym_n] = anon_sym_n,
  [anon_sym_un] = anon_sym_un,
  [anon_sym_L] = anon_sym_L,
  [aux_sym_uint64_token1] = aux_sym_uint64_token1,
  [anon_sym_f] = anon_sym_f,
  [anon_sym_lf] = anon_sym_lf,
  [anon_sym_LF] = anon_sym_LF,
  [aux_sym_bignum_token1] = aux_sym_bignum_token1,
  [aux_sym_decimal_token1] = aux_sym_decimal_token1,
  [sym_float] = sym_float,
  [anon_sym_LPAREN_STAR] = anon_sym_LPAREN_STAR,
  [anon_sym_STAR_RPAREN] = anon_sym_STAR_RPAREN,
  [sym_line_comment] = sym_line_comment,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [aux_sym_identifier_token2] = aux_sym_identifier_token2,
  [sym__virtual_open_section] = sym__virtual_open_section,
  [sym__virtual_end_section] = sym__virtual_end_section,
  [sym__virtual_end_decl] = sym__virtual_end_decl,
  [sym_block_comment_content] = sym_block_comment_content,
  [sym_file] = sym_file,
  [sym_namespace] = sym_namespace,
  [sym_named_module] = sym_named_module,
  [sym_module_abbrev] = sym_module_abbrev,
  [sym_module_defn] = sym_module_defn,
  [sym_compiler_directive_decl] = sym_compiler_directive_decl,
  [sym_fsi_directive_decl] = sym_fsi_directive_decl,
  [sym_import_decl] = sym_import_decl,
  [sym_attributes] = sym_attributes,
  [sym_attribute_set] = sym_attribute_set,
  [sym_attribute] = sym_attribute,
  [sym_attribute_target] = sym_attribute_target,
  [sym_object_construction] = sym_object_construction,
  [sym_value_declaration] = sym_value_declaration,
  [sym_do] = sym_do,
  [sym__function_or_value_defns] = sym__function_or_value_defns,
  [sym_function_or_value_defn] = sym_function_or_value_defn,
  [sym__function_or_value_defn_body] = sym__function_or_value_defn_body,
  [sym_function_declaration_left] = sym_function_declaration_left,
  [sym_value_declaration_left] = sym_value_declaration_left,
  [sym__pattern] = sym__pattern,
  [sym_attribute_pattern] = sym_attribute_pattern,
  [sym_paren_pattern] = sym_paren_pattern,
  [sym_repeat_pattern] = sym_repeat_pattern,
  [sym_identifier_pattern] = sym_identifier_pattern,
  [sym_as_pattern] = sym_as_pattern,
  [sym_cons_pattern] = sym_cons_pattern,
  [sym_disjunct_pattern] = sym_disjunct_pattern,
  [sym_conjunct_pattern] = sym_conjunct_pattern,
  [sym_typed_pattern] = sym_typed_pattern,
  [sym_argument_patterns] = sym_argument_patterns,
  [sym_field_pattern] = sym_field_pattern,
  [sym__atomic_pattern] = sym__atomic_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_array_pattern] = sym_array_pattern,
  [sym_record_pattern] = sym_record_pattern,
  [sym__pattern_param] = sym__pattern_param,
  [sym__seq_infix] = sym_infix_expression,
  [sym__expressions] = sym__expressions,
  [sym__expression_inner] = sym__expression_inner,
  [sym_application_expression] = sym_application_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_brace_expression] = sym_brace_expression,
  [sym_with_field_expression] = sym_with_field_expression,
  [sym_field_expression] = sym_field_expression,
  [sym_object_expression] = sym_object_expression,
  [sym_prefixed_expression] = sym_prefixed_expression,
  [sym_return_expression] = sym_return_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_ce_expression] = sym_ce_expression,
  [sym_infix_expression] = sym_infix_expression,
  [sym_literal_expression] = sym_literal_expression,
  [sym_typecast_expression] = sym_typecast_expression,
  [sym_begin_end_expression] = sym_begin_end_expression,
  [sym_paren_expression] = sym_paren_expression,
  [sym_for_expression] = sym_for_expression,
  [sym_while_expression] = sym_while_expression,
  [sym__else_expression] = sym__else_expression,
  [sym_elif_expression] = sym_elif_expression,
  [sym_if_expression] = sym_if_expression,
  [sym_fun_expression] = sym_fun_expression,
  [sym_try_expression] = sym_try_expression,
  [sym_match_expression] = sym_match_expression,
  [sym_function_expression] = sym_function_expression,
  [sym_object_instantiation_expression] = sym_object_instantiation_expression,
  [sym_mutate_expression] = sym_mutate_expression,
  [sym_index_expression] = sym_index_expression,
  [sym_dot_expression] = sym_dot_expression,
  [sym_typed_expression] = sym_typed_expression,
  [sym_declaration_expression] = sym_declaration_expression,
  [sym_do_expression] = sym_do_expression,
  [sym__list_elements] = sym__list_elements,
  [sym__list_element] = sym__list_element,
  [sym_list_expression] = sym_list_expression,
  [sym_array_expression] = sym_array_expression,
  [sym_range_expression] = sym_range_expression,
  [sym_rule] = sym_rule,
  [sym_rules] = sym_rules,
  [sym__comp_or_range_expression] = sym__comp_or_range_expression,
  [sym_short_comp_expression] = sym_short_comp_expression,
  [sym_slice_ranges] = sym_slice_ranges,
  [sym__slice_range_special] = sym__slice_range_special,
  [sym_slice_range] = sym_slice_range,
  [sym_type] = sym_type,
  [sym_types] = sym_types,
  [sym_type_attribute] = sym_type_attribute,
  [sym_type_attributes] = sym_type_attributes,
  [sym_constraint] = sym_constraint,
  [sym_type_argument_constraints] = sym_type_argument_constraints,
  [sym_type_argument] = sym_type_argument,
  [sym_type_argument_defn] = sym_type_argument_defn,
  [sym_static_type_argument] = sym_static_type_argument,
  [sym_type_arguments] = sym_type_arguments,
  [sym_trait_member_constraint] = sym_trait_member_constraint,
  [sym_member_signature] = sym_member_signature,
  [sym_type_definition] = sym_type_definition,
  [sym__type_defn_body] = sym__type_defn_body,
  [sym_type_name] = sym_type_name,
  [sym_type_extension] = sym_type_extension,
  [sym_delegate_type_defn] = sym_delegate_type_defn,
  [sym_delegate_signature] = sym_delegate_signature,
  [sym_type_abbrev_defn] = sym_type_abbrev_defn,
  [sym__class_type_body_inner] = sym__class_type_body_inner,
  [sym__class_type_body] = sym__class_type_body,
  [sym_record_type_defn] = sym_record_type_defn,
  [sym_record_fields] = sym_record_fields,
  [sym_record_field] = sym_record_field,
  [sym_enum_type_defn] = sym_enum_type_defn,
  [sym_enum_type_cases] = sym_enum_type_cases,
  [sym_enum_type_case] = sym_enum_type_case,
  [sym_union_type_defn] = sym_union_type_defn,
  [sym_union_type_cases] = sym_union_type_cases,
  [sym_union_type_case] = sym_union_type_case,
  [sym_union_type_fields] = sym_union_type_fields,
  [sym_union_type_field] = sym_union_type_field,
  [sym_anon_type_defn] = sym_anon_type_defn,
  [sym_primary_constr_args] = sym_primary_constr_args,
  [sym_simple_pattern] = sym_simple_pattern,
  [sym__class_function_or_value_defn] = sym__class_function_or_value_defn,
  [sym_type_extension_elements] = sym_type_extension_elements,
  [sym__type_defn_elements] = sym__type_defn_elements,
  [sym__interface_implementations] = sym__interface_implementations,
  [sym_interface_implementation] = sym_interface_implementation,
  [sym__member_defns] = sym__member_defns,
  [sym__object_members] = sym__object_members,
  [sym_member_defn] = sym_member_defn,
  [sym_property_or_ident] = sym_property_or_ident,
  [sym__method_defn] = sym__method_defn,
  [sym__property_defn] = sym__property_defn,
  [sym_method_or_prop_defn] = sym_method_or_prop_defn,
  [sym_additional_constr_defn] = sym_additional_constr_defn,
  [sym_class_inherits_decl] = sym_class_inherits_decl,
  [sym_as_defn] = sym_as_defn,
  [sym_field_initializer] = sym_field_initializer,
  [sym_field_initializers] = sym_field_initializers,
  [sym__unicodegraph_short] = sym__unicodegraph_short,
  [sym__unicodegraph_long] = sym__unicodegraph_long,
  [sym__trigraph] = sym__trigraph,
  [sym__char_char] = sym__char_char,
  [sym__string_char] = sym__string_char,
  [sym_char] = sym_char,
  [sym_string] = sym_string,
  [sym__verbatim_string_char] = sym__verbatim_string_char,
  [sym_verbatim_string] = sym_verbatim_string,
  [sym_bytechar] = sym_bytechar,
  [sym_bytearray] = sym_bytearray,
  [sym_verbatim_bytearray] = sym_verbatim_bytearray,
  [sym__simple_or_escape_char] = sym__simple_or_escape_char,
  [sym_triple_quoted_string] = sym_triple_quoted_string,
  [sym_unit] = sym_unit,
  [sym_const] = sym_const,
  [sym_long_identifier_or_op] = sym_long_identifier_or_op,
  [sym_long_identifier] = sym_long_identifier,
  [sym__identifier_or_op] = sym__identifier_or_op,
  [sym_op_name] = sym_op_name,
  [sym_range_op_name] = sym_range_op_name,
  [sym_active_pattern_op_name] = sym_active_pattern_op_name,
  [sym_prefix_op] = sym_prefix_op,
  [sym_infix_op] = sym_infix_op,
  [sym_symbolic_op] = sym_symbolic_op,
  [sym_int] = sym_int,
  [sym_xint] = sym_xint,
  [sym_sbyte] = sym_sbyte,
  [sym_byte] = sym_byte,
  [sym_int16] = sym_int16,
  [sym_uint16] = sym_uint16,
  [sym_int32] = sym_int32,
  [sym_uint32] = sym_uint32,
  [sym_nativeint] = sym_nativeint,
  [sym_unativeint] = sym_unativeint,
  [sym_int64] = sym_int64,
  [sym_uint64] = sym_uint64,
  [sym_ieee32] = sym_ieee32,
  [sym_ieee64] = sym_ieee64,
  [sym_bignum] = sym_bignum,
  [sym_decimal] = sym_decimal,
  [sym_block_comment] = sym_block_comment,
  [sym_identifier] = sym_identifier,
  [aux_sym_file_repeat1] = aux_sym_file_repeat1,
  [aux_sym_compiler_directive_decl_repeat1] = aux_sym_compiler_directive_decl_repeat1,
  [aux_sym_attributes_repeat1] = aux_sym_attributes_repeat1,
  [aux_sym_attribute_set_repeat1] = aux_sym_attribute_set_repeat1,
  [aux_sym__function_or_value_defns_repeat1] = aux_sym__function_or_value_defns_repeat1,
  [aux_sym_repeat_pattern_repeat1] = aux_sym_repeat_pattern_repeat1,
  [aux_sym_argument_patterns_repeat1] = aux_sym_argument_patterns_repeat1,
  [aux_sym_list_pattern_repeat1] = aux_sym_list_pattern_repeat1,
  [aux_sym_record_pattern_repeat1] = aux_sym_record_pattern_repeat1,
  [aux_sym__seq_infix_repeat1] = aux_sym__seq_infix_repeat1,
  [aux_sym__seq_expressions_repeat1] = aux_sym__seq_expressions_repeat1,
  [aux_sym_application_expression_repeat1] = aux_sym_application_expression_repeat1,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_if_expression_repeat1] = aux_sym_if_expression_repeat1,
  [aux_sym__list_elements_repeat1] = aux_sym__list_elements_repeat1,
  [aux_sym_rules_repeat1] = aux_sym_rules_repeat1,
  [aux_sym_slice_ranges_repeat1] = aux_sym_slice_ranges_repeat1,
  [aux_sym_type_repeat1] = aux_sym_type_repeat1,
  [aux_sym_type_repeat2] = aux_sym_type_repeat2,
  [aux_sym_types_repeat1] = aux_sym_types_repeat1,
  [aux_sym_type_attributes_repeat1] = aux_sym_type_attributes_repeat1,
  [aux_sym_type_argument_constraints_repeat1] = aux_sym_type_argument_constraints_repeat1,
  [aux_sym_static_type_argument_repeat1] = aux_sym_static_type_argument_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_type_definition_repeat1] = aux_sym_type_definition_repeat1,
  [aux_sym__class_type_body_repeat1] = aux_sym__class_type_body_repeat1,
  [aux_sym_record_fields_repeat1] = aux_sym_record_fields_repeat1,
  [aux_sym_enum_type_cases_repeat1] = aux_sym_enum_type_cases_repeat1,
  [aux_sym_union_type_cases_repeat1] = aux_sym_union_type_cases_repeat1,
  [aux_sym_union_type_fields_repeat1] = aux_sym_union_type_fields_repeat1,
  [aux_sym_primary_constr_args_repeat1] = aux_sym_primary_constr_args_repeat1,
  [aux_sym__interface_implementations_repeat1] = aux_sym__interface_implementations_repeat1,
  [aux_sym__member_defns_repeat1] = aux_sym__member_defns_repeat1,
  [aux_sym_field_initializers_repeat1] = aux_sym_field_initializers_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_verbatim_string_repeat1] = aux_sym_verbatim_string_repeat1,
  [aux_sym_triple_quoted_string_repeat1] = aux_sym_triple_quoted_string_repeat1,
  [aux_sym_long_identifier_repeat1] = aux_sym_long_identifier_repeat1,
  [aux_sym_active_pattern_op_name_repeat1] = aux_sym_active_pattern_op_name_repeat1,
  [aux_sym_prefix_op_repeat1] = aux_sym_prefix_op_repeat1,
  [aux_sym_int_repeat1] = aux_sym_int_repeat1,
  [aux_sym_xint_repeat1] = aux_sym_xint_repeat1,
  [aux_sym_xint_repeat2] = aux_sym_xint_repeat2,
  [aux_sym_xint_repeat3] = aux_sym_xint_repeat3,
  [alias_sym_const_pattern] = alias_sym_const_pattern,
  [alias_sym_null_pattern] = alias_sym_null_pattern,
  [alias_sym_wildcard_pattern] = alias_sym_wildcard_pattern,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDnowarn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_open] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assembly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_field] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constructor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mutable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_internal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lazy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_upcast] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_downcast] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_AT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_QMARK_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_to] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_downto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_done] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unmanaged] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_equality] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_comparison] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delegate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_member] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_id] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_val] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inherit] = {
    .visible = true,
    .named = false,
  },
  [sym__escape_char] = {
    .visible = false,
    .named = true,
  },
  [sym__non_escape_char] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_char_char] = {
    .visible = false,
    .named = true,
  },
  [sym__hex_digit_imm] = {
    .visible = false,
    .named = true,
  },
  [sym__digit_char_imm] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BSLASHu] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHU] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [sym__simple_string_char] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BSLASH2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTEB] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTEB] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__simple_or_escape_char_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_STAR_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_symbolic_op_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__octaldigit_imm] = {
    .visible = false,
    .named = true,
  },
  [sym__bitdigit_imm] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_int_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_xint_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_xint_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_xint_token3] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_y] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_s] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_us] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_l] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_uint32_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_n] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_un] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_L] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_uint64_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_f] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_bignum_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decimal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_token2] = {
    .visible = false,
    .named = false,
  },
  [sym__virtual_open_section] = {
    .visible = false,
    .named = true,
  },
  [sym__virtual_end_section] = {
    .visible = false,
    .named = true,
  },
  [sym__virtual_end_decl] = {
    .visible = false,
    .named = true,
  },
  [sym_block_comment_content] = {
    .visible = true,
    .named = true,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace] = {
    .visible = true,
    .named = true,
  },
  [sym_named_module] = {
    .visible = true,
    .named = true,
  },
  [sym_module_abbrev] = {
    .visible = true,
    .named = true,
  },
  [sym_module_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_compiler_directive_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_fsi_directive_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_import_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_set] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_target] = {
    .visible = true,
    .named = true,
  },
  [sym_object_construction] = {
    .visible = true,
    .named = true,
  },
  [sym_value_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_do] = {
    .visible = true,
    .named = true,
  },
  [sym__function_or_value_defns] = {
    .visible = false,
    .named = true,
  },
  [sym_function_or_value_defn] = {
    .visible = true,
    .named = true,
  },
  [sym__function_or_value_defn_body] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration_left] = {
    .visible = true,
    .named = true,
  },
  [sym_value_declaration_left] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_attribute_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_cons_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunct_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunct_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_patterns] = {
    .visible = true,
    .named = true,
  },
  [sym_field_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__atomic_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_record_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern_param] = {
    .visible = false,
    .named = true,
  },
  [sym__seq_infix] = {
    .visible = true,
    .named = true,
  },
  [sym__expressions] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_inner] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_application_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_brace_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_with_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_prefixed_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_return_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ce_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_typecast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_begin_end_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_for_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_while_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__else_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_elif_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_fun_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_try_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_mutate_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_do_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__list_elements] = {
    .visible = false,
    .named = true,
  },
  [sym__list_element] = {
    .visible = false,
    .named = true,
  },
  [sym_list_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_range_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_rules] = {
    .visible = true,
    .named = true,
  },
  [sym__comp_or_range_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_short_comp_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_ranges] = {
    .visible = true,
    .named = true,
  },
  [sym__slice_range_special] = {
    .visible = false,
    .named = true,
  },
  [sym_slice_range] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_types] = {
    .visible = true,
    .named = true,
  },
  [sym_type_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_type_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument_constraints] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_argument_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_static_type_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_member_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_member_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__type_defn_body] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_extension] = {
    .visible = true,
    .named = true,
  },
  [sym_delegate_type_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_delegate_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_abbrev_defn] = {
    .visible = true,
    .named = true,
  },
  [sym__class_type_body_inner] = {
    .visible = false,
    .named = true,
  },
  [sym__class_type_body] = {
    .visible = false,
    .named = true,
  },
  [sym_record_type_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_record_fields] = {
    .visible = true,
    .named = true,
  },
  [sym_record_field] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_type_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_type_cases] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_type_case] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type_cases] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type_case] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type_fields] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type_field] = {
    .visible = true,
    .named = true,
  },
  [sym_anon_type_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_constr_args] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__class_function_or_value_defn] = {
    .visible = false,
    .named = true,
  },
  [sym_type_extension_elements] = {
    .visible = true,
    .named = true,
  },
  [sym__type_defn_elements] = {
    .visible = false,
    .named = true,
  },
  [sym__interface_implementations] = {
    .visible = false,
    .named = true,
  },
  [sym_interface_implementation] = {
    .visible = true,
    .named = true,
  },
  [sym__member_defns] = {
    .visible = false,
    .named = true,
  },
  [sym__object_members] = {
    .visible = false,
    .named = true,
  },
  [sym_member_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_property_or_ident] = {
    .visible = true,
    .named = true,
  },
  [sym__method_defn] = {
    .visible = false,
    .named = true,
  },
  [sym__property_defn] = {
    .visible = false,
    .named = true,
  },
  [sym_method_or_prop_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_additional_constr_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_class_inherits_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_as_defn] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_field_initializers] = {
    .visible = true,
    .named = true,
  },
  [sym__unicodegraph_short] = {
    .visible = false,
    .named = true,
  },
  [sym__unicodegraph_long] = {
    .visible = false,
    .named = true,
  },
  [sym__trigraph] = {
    .visible = false,
    .named = true,
  },
  [sym__char_char] = {
    .visible = false,
    .named = true,
  },
  [sym__string_char] = {
    .visible = false,
    .named = true,
  },
  [sym_char] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_string_char] = {
    .visible = false,
    .named = true,
  },
  [sym_verbatim_string] = {
    .visible = true,
    .named = true,
  },
  [sym_bytechar] = {
    .visible = true,
    .named = true,
  },
  [sym_bytearray] = {
    .visible = true,
    .named = true,
  },
  [sym_verbatim_bytearray] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_or_escape_char] = {
    .visible = false,
    .named = true,
  },
  [sym_triple_quoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_const] = {
    .visible = true,
    .named = true,
  },
  [sym_long_identifier_or_op] = {
    .visible = true,
    .named = true,
  },
  [sym_long_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier_or_op] = {
    .visible = false,
    .named = true,
  },
  [sym_op_name] = {
    .visible = true,
    .named = true,
  },
  [sym_range_op_name] = {
    .visible = true,
    .named = true,
  },
  [sym_active_pattern_op_name] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_symbolic_op] = {
    .visible = true,
    .named = true,
  },
  [sym_int] = {
    .visible = true,
    .named = true,
  },
  [sym_xint] = {
    .visible = true,
    .named = true,
  },
  [sym_sbyte] = {
    .visible = true,
    .named = true,
  },
  [sym_byte] = {
    .visible = true,
    .named = true,
  },
  [sym_int16] = {
    .visible = true,
    .named = true,
  },
  [sym_uint16] = {
    .visible = true,
    .named = true,
  },
  [sym_int32] = {
    .visible = true,
    .named = true,
  },
  [sym_uint32] = {
    .visible = true,
    .named = true,
  },
  [sym_nativeint] = {
    .visible = true,
    .named = true,
  },
  [sym_unativeint] = {
    .visible = true,
    .named = true,
  },
  [sym_int64] = {
    .visible = true,
    .named = true,
  },
  [sym_uint64] = {
    .visible = true,
    .named = true,
  },
  [sym_ieee32] = {
    .visible = true,
    .named = true,
  },
  [sym_ieee64] = {
    .visible = true,
    .named = true,
  },
  [sym_bignum] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_compiler_directive_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_set_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_or_value_defns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_repeat_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__seq_infix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__seq_expressions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_application_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rules_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_slice_ranges_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_types_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_argument_constraints_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_static_type_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__class_type_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_fields_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_type_cases_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_type_cases_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_type_fields_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_primary_constr_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__interface_implementations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__member_defns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_initializers_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_verbatim_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_triple_quoted_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_long_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_active_pattern_op_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_prefix_op_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_int_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_xint_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_xint_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_xint_repeat3] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_const_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_null_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_wildcard_pattern] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_assignee = 1,
  field_base = 2,
  field_body = 3,
  field_else_branch = 4,
  field_field = 5,
  field_guard = 6,
  field_in = 7,
  field_index = 8,
  field_instance = 9,
  field_name = 10,
  field_then = 11,
  field_value = 12,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_assignee] = "assignee",
  [field_base] = "base",
  [field_body] = "body",
  [field_else_branch] = "else_branch",
  [field_field] = "field",
  [field_guard] = "guard",
  [field_in] = "in",
  [field_index] = "index",
  [field_instance] = "instance",
  [field_name] = "name",
  [field_then] = "then",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
  [8] = {.index = 3, .length = 1},
  [9] = {.index = 4, .length = 2},
  [10] = {.index = 6, .length = 2},
  [11] = {.index = 8, .length = 2},
  [13] = {.index = 10, .length = 2},
  [14] = {.index = 12, .length = 1},
  [15] = {.index = 13, .length = 1},
  [16] = {.index = 14, .length = 1},
  [17] = {.index = 15, .length = 3},
  [18] = {.index = 18, .length = 3},
  [19] = {.index = 21, .length = 1},
  [20] = {.index = 22, .length = 1},
  [21] = {.index = 23, .length = 1},
  [22] = {.index = 24, .length = 1},
  [23] = {.index = 25, .length = 1},
  [24] = {.index = 26, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
  [1] =
    {field_body, 1, .inherited = true},
  [2] =
    {field_name, 2},
  [3] =
    {field_body, 2, .inherited = true},
  [4] =
    {field_body, 0, .inherited = true},
    {field_body, 1, .inherited = true},
  [6] =
    {field_assignee, 0},
    {field_value, 2},
  [8] =
    {field_base, 0},
    {field_field, 2},
  [10] =
    {field_guard, 1},
    {field_then, 3},
  [12] =
    {field_in, 2},
  [13] =
    {field_instance, 0},
  [14] =
    {field_body, 3},
  [15] =
    {field_else_branch, 4, .inherited = true},
    {field_guard, 1},
    {field_then, 3},
  [18] =
    {field_else_branch, 5, .inherited = true},
    {field_guard, 1},
    {field_then, 3},
  [21] =
    {field_index, 3},
  [22] =
    {field_body, 3, .inherited = true},
  [23] =
    {field_index, 4},
  [24] =
    {field_else_branch, 2},
  [25] =
    {field_in, 7},
  [26] =
    {field_guard, 1},
    {field_then, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = alias_sym_null_pattern,
  },
  [3] = {
    [0] = alias_sym_wildcard_pattern,
  },
  [5] = {
    [0] = alias_sym_const_pattern,
  },
  [7] = {
    [0] = sym_long_identifier,
  },
  [12] = {
    [0] = sym_long_identifier,
    [1] = sym_long_identifier,
    [2] = sym_long_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_const, 2,
    sym_const,
    alias_sym_const_pattern,
  sym_long_identifier, 2,
    sym_long_identifier,
    sym_long_identifier,
  sym__identifier_or_op, 2,
    sym__identifier_or_op,
    sym_long_identifier,
  0,
};

static inline bool aux_sym_identifier_token1_character_set_1(int32_t c) {
  return (c < 43520
    ? (c < 4197
      ? (c < 2730
        ? (c < 2036
          ? (c < 1015
            ? (c < 750
              ? (c < 216
                ? (c < 181
                  ? (c < 170
                    ? (c >= 'A' && c <= 'z')
                    : c <= 170)
                  : (c <= 181 || (c < 192
                    ? c == 186
                    : c <= 214)))
                : (c <= 246 || (c < 736
                  ? (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)
                  : (c <= 740 || c == 748))))
              : (c <= 750 || (c < 902
                ? (c < 891
                  ? (c < 886
                    ? (c >= 880 && c <= 884)
                    : c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 910
                  ? (c < 908
                    ? (c >= 904 && c <= 906)
                    : c <= 908)
                  : (c <= 929 || (c >= 931 && c <= 1013)))))))
            : (c <= 1153 || (c < 1749
              ? (c < 1488
                ? (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c >= 1376 && c <= 1416)))
                : (c <= 1514 || (c < 1646
                  ? (c < 1568
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1610)
                  : (c <= 1647 || (c >= 1649 && c <= 1747)))))
              : (c <= 1749 || (c < 1808
                ? (c < 1786
                  ? (c < 1774
                    ? (c >= 1765 && c <= 1766)
                    : c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1969
                  ? (c < 1869
                    ? (c >= 1810 && c <= 1839)
                    : c <= 1957)
                  : (c <= 1969 || (c >= 1994 && c <= 2026)))))))))
          : (c <= 2037 || (c < 2486
            ? (c < 2308
              ? (c < 2112
                ? (c < 2074
                  ? (c < 2048
                    ? c == 2042
                    : c <= 2069)
                  : (c <= 2074 || (c < 2088
                    ? c == 2084
                    : c <= 2088)))
                : (c <= 2136 || (c < 2185
                  ? (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)
                  : (c <= 2190 || (c >= 2208 && c <= 2249)))))
              : (c <= 2361 || (c < 2437
                ? (c < 2392
                  ? (c < 2384
                    ? c == 2365
                    : c <= 2384)
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2474
                  ? (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)
                  : (c <= 2480 || c == 2482))))))
            : (c <= 2489 || (c < 2602
              ? (c < 2544
                ? (c < 2524
                  ? (c < 2510
                    ? c == 2493
                    : c <= 2510)
                  : (c <= 2525 || (c >= 2527 && c <= 2529)))
                : (c <= 2545 || (c < 2575
                  ? (c < 2565
                    ? c == 2556
                    : c <= 2570)
                  : (c <= 2576 || (c >= 2579 && c <= 2600)))))
              : (c <= 2608 || (c < 2654
                ? (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c >= 2649 && c <= 2652)))
                : (c <= 2654 || (c < 2703
                  ? (c < 2693
                    ? (c >= 2674 && c <= 2676)
                    : c <= 2701)
                  : (c <= 2705 || (c >= 2707 && c <= 2728)))))))))))
        : (c <= 2736 || (c < 3253
          ? (c < 2969
            ? (c < 2866
              ? (c < 2809
                ? (c < 2749
                  ? (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)
                  : (c <= 2749 || (c < 2784
                    ? c == 2768
                    : c <= 2785)))
                : (c <= 2809 || (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c >= 2858 && c <= 2864)))))
              : (c <= 2867 || (c < 2929
                ? (c < 2908
                  ? (c < 2877
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2877)
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2958
                  ? (c < 2949
                    ? c == 2947
                    : c <= 2954)
                  : (c <= 2960 || (c >= 2962 && c <= 2965)))))))
            : (c <= 2970 || (c < 3114
              ? (c < 2990
                ? (c < 2979
                  ? (c < 2974
                    ? c == 2972
                    : c <= 2975)
                  : (c <= 2980 || (c >= 2984 && c <= 2986)))
                : (c <= 3001 || (c < 3086
                  ? (c < 3077
                    ? c == 3024
                    : c <= 3084)
                  : (c <= 3088 || (c >= 3090 && c <= 3112)))))
              : (c <= 3129 || (c < 3200
                ? (c < 3165
                  ? (c < 3160
                    ? c == 3133
                    : c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3218
                  ? (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)
                  : (c <= 3240 || (c >= 3242 && c <= 3251)))))))))
          : (c <= 3257 || (c < 3713
            ? (c < 3423
              ? (c < 3342
                ? (c < 3296
                  ? (c < 3293
                    ? c == 3261
                    : c <= 3294)
                  : (c <= 3297 || (c < 3332
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3406
                  ? (c < 3389
                    ? (c >= 3346 && c <= 3386)
                    : c <= 3389)
                  : (c <= 3406 || (c >= 3412 && c <= 3414)))))
              : (c <= 3425 || (c < 3517
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3478)
                  : (c <= 3505 || (c >= 3507 && c <= 3515)))
                : (c <= 3517 || (c < 3634
                  ? (c < 3585
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3632)
                  : (c <= 3634 || (c >= 3648 && c <= 3654)))))))
            : (c <= 3714 || (c < 3804
              ? (c < 3751
                ? (c < 3724
                  ? (c < 3718
                    ? c == 3716
                    : c <= 3722)
                  : (c <= 3747 || c == 3749))
                : (c <= 3760 || (c < 3776
                  ? (c < 3773
                    ? c == 3762
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))))
              : (c <= 3807 || (c < 4096
                ? (c < 3913
                  ? (c < 3904
                    ? c == 3840
                    : c <= 3911)
                  : (c <= 3948 || (c >= 3976 && c <= 3980)))
                : (c <= 4138 || (c < 4186
                  ? (c < 4176
                    ? c == 4159
                    : c <= 4181)
                  : (c <= 4189 || c == 4193))))))))))))
      : (c <= 4198 || (c < 8144
        ? (c < 6272
          ? (c < 4824
            ? (c < 4696
              ? (c < 4301
                ? (c < 4238
                  ? (c < 4213
                    ? (c >= 4206 && c <= 4208)
                    : c <= 4225)
                  : (c <= 4238 || (c < 4295
                    ? (c >= 4256 && c <= 4293)
                    : c <= 4295)))
                : (c <= 4301 || (c < 4682
                  ? (c < 4348
                    ? (c >= 4304 && c <= 4346)
                    : c <= 4680)
                  : (c <= 4685 || (c >= 4688 && c <= 4694)))))
              : (c <= 4696 || (c < 4786
                ? (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c >= 4752 && c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c >= 4808 && c <= 4822)))))))
            : (c <= 4880 || (c < 5870
              ? (c < 5112
                ? (c < 4992
                  ? (c < 4888
                    ? (c >= 4882 && c <= 4885)
                    : c <= 4954)
                  : (c <= 5007 || (c >= 5024 && c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c >= 5792 && c <= 5866)))))
              : (c <= 5880 || (c < 5998
                ? (c < 5952
                  ? (c < 5919
                    ? (c >= 5888 && c <= 5905)
                    : c <= 5937)
                  : (c <= 5969 || (c >= 5984 && c <= 5996)))
                : (c <= 6000 || (c < 6108
                  ? (c < 6103
                    ? (c >= 6016 && c <= 6067)
                    : c <= 6103)
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))))))))
          : (c <= 6312 || (c < 7357
            ? (c < 6917
              ? (c < 6528
                ? (c < 6400
                  ? (c < 6320
                    ? c == 6314
                    : c <= 6389)
                  : (c <= 6430 || (c < 6512
                    ? (c >= 6480 && c <= 6509)
                    : c <= 6516)))
                : (c <= 6571 || (c < 6688
                  ? (c < 6656
                    ? (c >= 6576 && c <= 6601)
                    : c <= 6678)
                  : (c <= 6740 || c == 6823))))
              : (c <= 6963 || (c < 7168
                ? (c < 7086
                  ? (c < 7043
                    ? (c >= 6981 && c <= 6988)
                    : c <= 7072)
                  : (c <= 7087 || (c >= 7098 && c <= 7141)))
                : (c <= 7203 || (c < 7296
                  ? (c < 7258
                    ? (c >= 7245 && c <= 7247)
                    : c <= 7293)
                  : (c <= 7304 || (c >= 7312 && c <= 7354)))))))
            : (c <= 7359 || (c < 8016
              ? (c < 7424
                ? (c < 7413
                  ? (c < 7406
                    ? (c >= 7401 && c <= 7404)
                    : c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7680 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c >= 8008 && c <= 8013)))))
              : (c <= 8023 || (c < 8064
                ? (c < 8029
                  ? (c < 8027
                    ? c == 8025
                    : c <= 8027)
                  : (c <= 8029 || (c >= 8031 && c <= 8061)))
                : (c <= 8116 || (c < 8130
                  ? (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)
                  : (c <= 8132 || (c >= 8134 && c <= 8140)))))))))))
        : (c <= 8147 || (c < 12344
          ? (c < 11264
            ? (c < 8469
              ? (c < 8319
                ? (c < 8178
                  ? (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)
                  : (c <= 8180 || (c < 8305
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8305)))
                : (c <= 8319 || (c < 8455
                  ? (c < 8450
                    ? (c >= 8336 && c <= 8348)
                    : c <= 8450)
                  : (c <= 8455 || (c >= 8458 && c <= 8467)))))
              : (c <= 8469 || (c < 8490
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || c == 8488))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c >= 8544 && c <= 8584)))))))
            : (c <= 11492 || (c < 11688
              ? (c < 11565
                ? (c < 11520
                  ? (c < 11506
                    ? (c >= 11499 && c <= 11502)
                    : c <= 11507)
                  : (c <= 11557 || c == 11559))
                : (c <= 11565 || (c < 11648
                  ? (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))))
              : (c <= 11694 || (c < 11728
                ? (c < 11712
                  ? (c < 11704
                    ? (c >= 11696 && c <= 11702)
                    : c <= 11710)
                  : (c <= 11718 || (c >= 11720 && c <= 11726)))
                : (c <= 11734 || (c < 12321
                  ? (c < 12293
                    ? (c >= 11736 && c <= 11742)
                    : c <= 12295)
                  : (c <= 12329 || (c >= 12337 && c <= 12341)))))))))
          : (c <= 12348 || (c < 42960
            ? (c < 42192
              ? (c < 12593
                ? (c < 12449
                  ? (c < 12445
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12447)
                  : (c <= 12538 || (c < 12549
                    ? (c >= 12540 && c <= 12543)
                    : c <= 12591)))
                : (c <= 12686 || (c < 13312
                  ? (c < 12784
                    ? (c >= 12704 && c <= 12735)
                    : c <= 12799)
                  : (c <= 19903 || (c >= 19968 && c <= 42124)))))
              : (c <= 42237 || (c < 42623
                ? (c < 42538
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42786
                  ? (c < 42775
                    ? (c >= 42656 && c <= 42735)
                    : c <= 42783)
                  : (c <= 42888 || (c >= 42891 && c <= 42954)))))))
            : (c <= 42961 || (c < 43259
              ? (c < 43015
                ? (c < 42994
                  ? (c < 42965
                    ? c == 42963
                    : c <= 42969)
                  : (c <= 43009 || (c >= 43011 && c <= 43013)))
                : (c <= 43018 || (c < 43138
                  ? (c < 43072
                    ? (c >= 43020 && c <= 43042)
                    : c <= 43123)
                  : (c <= 43187 || (c >= 43250 && c <= 43255)))))
              : (c <= 43259 || (c < 43396
                ? (c < 43312
                  ? (c < 43274
                    ? (c >= 43261 && c <= 43262)
                    : c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43494
                  ? (c < 43488
                    ? c == 43471
                    : c <= 43492)
                  : (c <= 43503 || (c >= 43514 && c <= 43518)))))))))))))))
    : (c <= 43560 || (c < 70751
      ? (c < 66964
        ? (c < 65008
          ? (c < 43888
            ? (c < 43739
              ? (c < 43697
                ? (c < 43616
                  ? (c < 43588
                    ? (c >= 43584 && c <= 43586)
                    : c <= 43595)
                  : (c <= 43638 || (c < 43646
                    ? c == 43642
                    : c <= 43695)))
                : (c <= 43697 || (c < 43712
                  ? (c < 43705
                    ? (c >= 43701 && c <= 43702)
                    : c <= 43709)
                  : (c <= 43712 || c == 43714))))
              : (c <= 43741 || (c < 43793
                ? (c < 43777
                  ? (c < 43762
                    ? (c >= 43744 && c <= 43754)
                    : c <= 43764)
                  : (c <= 43782 || (c >= 43785 && c <= 43790)))
                : (c <= 43798 || (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))))))
            : (c <= 44002 || (c < 64298
              ? (c < 64112
                ? (c < 55243
                  ? (c < 55216
                    ? (c >= 44032 && c <= 55203)
                    : c <= 55238)
                  : (c <= 55291 || (c >= 63744 && c <= 64109)))
                : (c <= 64217 || (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64285 || (c >= 64287 && c <= 64296)))))
              : (c <= 64310 || (c < 64326
                ? (c < 64320
                  ? (c < 64318
                    ? (c >= 64312 && c <= 64316)
                    : c <= 64318)
                  : (c <= 64321 || (c >= 64323 && c <= 64324)))
                : (c <= 64433 || (c < 64848
                  ? (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)
                  : (c <= 64911 || (c >= 64914 && c <= 64967)))))))))
          : (c <= 65017 || (c < 65616
            ? (c < 65440
              ? (c < 65149
                ? (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65345
                  ? (c < 65313
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65338)
                  : (c <= 65370 || (c >= 65382 && c <= 65437)))))
              : (c <= 65470 || (c < 65536
                ? (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c >= 65498 && c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))))))
            : (c <= 65629 || (c < 66504
              ? (c < 66304
                ? (c < 66176
                  ? (c < 65856
                    ? (c >= 65664 && c <= 65786)
                    : c <= 65908)
                  : (c <= 66204 || (c >= 66208 && c <= 66256)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66421)
                  : (c <= 66461 || (c >= 66464 && c <= 66499)))))
              : (c <= 66511 || (c < 66816
                ? (c < 66736
                  ? (c < 66560
                    ? (c >= 66513 && c <= 66517)
                    : c <= 66717)
                  : (c <= 66771 || (c >= 66776 && c <= 66811)))
                : (c <= 66855 || (c < 66940
                  ? (c < 66928
                    ? (c >= 66864 && c <= 66915)
                    : c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))))))))))
        : (c <= 66965 || (c < 69248
          ? (c < 67840
            ? (c < 67584
              ? (c < 67392
                ? (c < 66995
                  ? (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)
                  : (c <= 67001 || (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)))
                : (c <= 67413 || (c < 67463
                  ? (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)
                  : (c <= 67504 || (c >= 67506 && c <= 67514)))))
              : (c <= 67589 || (c < 67647
                ? (c < 67639
                  ? (c < 67594
                    ? c == 67592
                    : c <= 67637)
                  : (c <= 67640 || c == 67644))
                : (c <= 67669 || (c < 67808
                  ? (c < 67712
                    ? (c >= 67680 && c <= 67702)
                    : c <= 67742)
                  : (c <= 67826 || (c >= 67828 && c <= 67829)))))))
            : (c <= 67861 || (c < 68288
              ? (c < 68112
                ? (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || c == 68096))
                : (c <= 68115 || (c < 68192
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68220 || (c >= 68224 && c <= 68252)))))
              : (c <= 68295 || (c < 68480
                ? (c < 68416
                  ? (c < 68352
                    ? (c >= 68297 && c <= 68324)
                    : c <= 68405)
                  : (c <= 68437 || (c >= 68448 && c <= 68466)))
                : (c <= 68497 || (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c >= 68864 && c <= 68899)))))))))
          : (c <= 69289 || (c < 70108
            ? (c < 69763
              ? (c < 69552
                ? (c < 69415
                  ? (c < 69376
                    ? (c >= 69296 && c <= 69297)
                    : c <= 69404)
                  : (c <= 69415 || (c < 69488
                    ? (c >= 69424 && c <= 69445)
                    : c <= 69505)))
                : (c <= 69572 || (c < 69745
                  ? (c < 69635
                    ? (c >= 69600 && c <= 69622)
                    : c <= 69687)
                  : (c <= 69746 || c == 69749))))
              : (c <= 69807 || (c < 69968
                ? (c < 69956
                  ? (c < 69891
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69926)
                  : (c <= 69956 || c == 69959))
                : (c <= 70002 || (c < 70081
                  ? (c < 70019
                    ? c == 70006
                    : c <= 70066)
                  : (c <= 70084 || c == 70106))))))
            : (c <= 70108 || (c < 70415
              ? (c < 70282
                ? (c < 70272
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70187)
                  : (c <= 70278 || c == 70280))
                : (c <= 70285 || (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70366 || (c >= 70405 && c <= 70412)))))
              : (c <= 70416 || (c < 70461
                ? (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c >= 70453 && c <= 70457)))
                : (c <= 70461 || (c < 70656
                  ? (c < 70493
                    ? c == 70480
                    : c <= 70497)
                  : (c <= 70708 || (c >= 70727 && c <= 70730)))))))))))))
      : (c <= 70753 || (c < 119966
        ? (c < 73063
          ? (c < 72096
            ? (c < 71488
              ? (c < 71168
                ? (c < 70855
                  ? (c < 70852
                    ? (c >= 70784 && c <= 70831)
                    : c <= 70853)
                  : (c <= 70855 || (c < 71128
                    ? (c >= 71040 && c <= 71086)
                    : c <= 71131)))
                : (c <= 71215 || (c < 71352
                  ? (c < 71296
                    ? c == 71236
                    : c <= 71338)
                  : (c <= 71352 || (c >= 71424 && c <= 71450)))))
              : (c <= 71494 || (c < 71948
                ? (c < 71935
                  ? (c < 71840
                    ? (c >= 71680 && c <= 71723)
                    : c <= 71903)
                  : (c <= 71942 || c == 71945))
                : (c <= 71955 || (c < 71999
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71983)
                  : (c <= 71999 || c == 72001))))))
            : (c <= 72103 || (c < 72368
              ? (c < 72203
                ? (c < 72163
                  ? (c < 72161
                    ? (c >= 72106 && c <= 72144)
                    : c <= 72161)
                  : (c <= 72163 || c == 72192))
                : (c <= 72242 || (c < 72284
                  ? (c < 72272
                    ? c == 72250
                    : c <= 72272)
                  : (c <= 72329 || c == 72349))))
              : (c <= 72440 || (c < 72960
                ? (c < 72768
                  ? (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72750)
                  : (c <= 72768 || (c >= 72818 && c <= 72847)))
                : (c <= 72966 || (c < 73030
                  ? (c < 72971
                    ? (c >= 72968 && c <= 72969)
                    : c <= 73008)
                  : (c <= 73030 || (c >= 73056 && c <= 73061)))))))))
          : (c <= 73064 || (c < 94032
            ? (c < 92160
              ? (c < 74752
                ? (c < 73440
                  ? (c < 73112
                    ? (c >= 73066 && c <= 73097)
                    : c <= 73112)
                  : (c <= 73458 || (c < 73728
                    ? c == 73648
                    : c <= 74649)))
                : (c <= 74862 || (c < 77824
                  ? (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)
                  : (c <= 78894 || (c >= 82944 && c <= 83526)))))
              : (c <= 92728 || (c < 92992
                ? (c < 92880
                  ? (c < 92784
                    ? (c >= 92736 && c <= 92766)
                    : c <= 92862)
                  : (c <= 92909 || (c >= 92928 && c <= 92975)))
                : (c <= 92995 || (c < 93760
                  ? (c < 93053
                    ? (c >= 93027 && c <= 93047)
                    : c <= 93071)
                  : (c <= 93823 || (c >= 93952 && c <= 94026)))))))
            : (c <= 94032 || (c < 110592
              ? (c < 100352
                ? (c < 94179
                  ? (c < 94176
                    ? (c >= 94099 && c <= 94111)
                    : c <= 94177)
                  : (c <= 94179 || (c >= 94208 && c <= 100343)))
                : (c <= 101589 || (c < 110581
                  ? (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)
                  : (c <= 110587 || (c >= 110589 && c <= 110590)))))
              : (c <= 110882 || (c < 113776
                ? (c < 110960
                  ? (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)
                  : (c <= 111355 || (c >= 113664 && c <= 113770)))
                : (c <= 113788 || (c < 119808
                  ? (c < 113808
                    ? (c >= 113792 && c <= 113800)
                    : c <= 113817)
                  : (c <= 119892 || (c >= 119894 && c <= 119964)))))))))))
        : (c <= 119967 || (c < 126464
          ? (c < 120598
            ? (c < 120094
              ? (c < 119997
                ? (c < 119977
                  ? (c < 119973
                    ? c == 119970
                    : c <= 119974)
                  : (c <= 119980 || (c < 119995
                    ? (c >= 119982 && c <= 119993)
                    : c <= 119995)))
                : (c <= 120003 || (c < 120077
                  ? (c < 120071
                    ? (c >= 120005 && c <= 120069)
                    : c <= 120074)
                  : (c <= 120084 || (c >= 120086 && c <= 120092)))))
              : (c <= 120121 || (c < 120146
                ? (c < 120134
                  ? (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)
                  : (c <= 120134 || (c >= 120138 && c <= 120144)))
                : (c <= 120485 || (c < 120540
                  ? (c < 120514
                    ? (c >= 120488 && c <= 120512)
                    : c <= 120538)
                  : (c <= 120570 || (c >= 120572 && c <= 120596)))))))
            : (c <= 120628 || (c < 123214
              ? (c < 120746
                ? (c < 120688
                  ? (c < 120656
                    ? (c >= 120630 && c <= 120654)
                    : c <= 120686)
                  : (c <= 120712 || (c >= 120714 && c <= 120744)))
                : (c <= 120770 || (c < 123136
                  ? (c < 122624
                    ? (c >= 120772 && c <= 120779)
                    : c <= 122654)
                  : (c <= 123180 || (c >= 123191 && c <= 123197)))))
              : (c <= 123214 || (c < 124909
                ? (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123565)
                    : c <= 123627)
                  : (c <= 124902 || (c >= 124904 && c <= 124907)))
                : (c <= 124910 || (c < 125184
                  ? (c < 124928
                    ? (c >= 124912 && c <= 124926)
                    : c <= 125124)
                  : (c <= 125251 || c == 125259))))))))
          : (c <= 126467 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126500
                  ? (c < 126497
                    ? (c >= 126469 && c <= 126495)
                    : c <= 126498)
                  : (c <= 126500 || c == 126503))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_2(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'c'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_3(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Y')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_4(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_5(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'b'
                    ? (c >= 'A' && c <= 'Y')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_6(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'b'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_7(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_8(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= 'Y')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_9(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '\''
                    : c <= '9')
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_10(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '\''
                    : c <= '9')
                  : (c <= 'Z' || (c < 'b'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool aux_sym_identifier_token1_character_set_11(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '\''
                    : c <= '9')
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : c <= 'y')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(959);
      if (lookahead == '!') ADVANCE(531);
      if (lookahead == '"') ADVANCE(1195);
      if (lookahead == '#') ADVANCE(1129);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1055);
      if (lookahead == '&') ADVANCE(1033);
      if (lookahead == '\'') ADVANCE(1191);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1123);
      if (lookahead == '+') ADVANCE(1210);
      if (lookahead == ',') ADVANCE(1022);
      if (lookahead == '-') ADVANCE(1212);
      if (lookahead == '.') ADVANCE(1105);
      if (lookahead == '/') ADVANCE(528);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1111);
      if (lookahead == '=') ADVANCE(965);
      if (lookahead == '>') ADVANCE(1113);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(454);
      if (lookahead == 'L') ADVANCE(1284);
      if (lookahead == 'M') ADVANCE(1293);
      if (lookahead == 'U') ADVANCE(536);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1143);
      if (lookahead == '_') ADVANCE(1016);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'f') ADVANCE(1288);
      if (lookahead == 'g') ADVANCE(597);
      if (lookahead == 'i') ADVANCE(588);
      if (lookahead == 'l') ADVANCE(1266);
      if (lookahead == 'm') ADVANCE(1295);
      if (lookahead == 'n') ADVANCE(1277);
      if (lookahead == 'o') ADVANCE(630);
      if (lookahead == 'p') ADVANCE(551);
      if (lookahead == 'r') ADVANCE(600);
      if (lookahead == 's') ADVANCE(1259);
      if (lookahead == 't') ADVANCE(640);
      if (lookahead == 'u') ADVANCE(1271);
      if (lookahead == 'v') ADVANCE(555);
      if (lookahead == 'w') ADVANCE(637);
      if (lookahead == 'y') ADVANCE(1255);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1030);
      if (lookahead == '}') ADVANCE(1044);
      if (lookahead == '~') ADVANCE(1221);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(1178);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(1178);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1291);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(1178);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(943)
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(1178);
      END_STATE();
    case 1:
      if (lookahead == '\r') SKIP(677)
      if (lookahead == 'U') ADVANCE(1183);
      if (lookahead == 'n') SKIP(172)
      if (lookahead == 'u') ADVANCE(1182);
      END_STATE();
    case 2:
      if (lookahead == '\r') SKIP(677)
      if (lookahead == 'n') SKIP(172)
      END_STATE();
    case 3:
      if (lookahead == '\r') SKIP(686)
      if (lookahead == 'n') SKIP(341)
      END_STATE();
    case 4:
      if (lookahead == '\r') SKIP(687)
      if (lookahead == 'n') SKIP(342)
      END_STATE();
    case 5:
      if (lookahead == '\r') SKIP(688)
      if (lookahead == 'n') SKIP(417)
      END_STATE();
    case 6:
      if (lookahead == '\r') SKIP(738)
      if (lookahead == 'n') SKIP(418)
      END_STATE();
    case 7:
      if (lookahead == '\r') SKIP(761)
      if (lookahead == 'n') SKIP(393)
      END_STATE();
    case 8:
      if (lookahead == '\r') SKIP(782)
      if (lookahead == 'n') SKIP(437)
      END_STATE();
    case 9:
      if (lookahead == '\r') SKIP(753)
      if (lookahead == 'n') SKIP(445)
      END_STATE();
    case 10:
      if (lookahead == '\r') SKIP(762)
      if (lookahead == 'n') SKIP(419)
      END_STATE();
    case 11:
      if (lookahead == '\r') SKIP(775)
      if (lookahead == 'n') SKIP(420)
      END_STATE();
    case 12:
      if (lookahead == '\r') SKIP(783)
      if (lookahead == 'n') SKIP(421)
      END_STATE();
    case 13:
      if (lookahead == '\r') SKIP(739)
      if (lookahead == 'n') SKIP(438)
      END_STATE();
    case 14:
      if (lookahead == '\r') SKIP(763)
      if (lookahead == 'n') SKIP(394)
      END_STATE();
    case 15:
      if (lookahead == '\r') SKIP(689)
      if (lookahead == 'n') SKIP(422)
      END_STATE();
    case 16:
      if (lookahead == '\r') SKIP(740)
      if (lookahead == 'n') SKIP(423)
      END_STATE();
    case 17:
      if (lookahead == '\r') SKIP(788)
      if (lookahead == 'n') SKIP(424)
      END_STATE();
    case 18:
      if (lookahead == '\r') SKIP(754)
      if (lookahead == 'n') SKIP(446)
      END_STATE();
    case 19:
      if (lookahead == '\r') SKIP(764)
      if (lookahead == 'n') SKIP(425)
      END_STATE();
    case 20:
      if (lookahead == '\r') SKIP(776)
      if (lookahead == 'n') SKIP(426)
      END_STATE();
    case 21:
      if (lookahead == '\r') SKIP(741)
      if (lookahead == 'n') SKIP(466)
      END_STATE();
    case 22:
      if (lookahead == '\r') SKIP(690)
      if (lookahead == 'n') SKIP(465)
      END_STATE();
    case 23:
      if (lookahead == '\r') SKIP(691)
      if (lookahead == 'n') SKIP(449)
      END_STATE();
    case 24:
      if (lookahead == '\r') SKIP(692)
      if (lookahead == 'n') SKIP(469)
      END_STATE();
    case 25:
      if (lookahead == '\r') SKIP(693)
      if (lookahead == 'n') SKIP(459)
      END_STATE();
    case 26:
      if (lookahead == '\r') SKIP(694)
      if (lookahead == 'n') SKIP(460)
      END_STATE();
    case 27:
      if (lookahead == '\r') SKIP(742)
      if (lookahead == 'n') SKIP(329)
      END_STATE();
    case 28:
      if (lookahead == '\r') SKIP(743)
      if (lookahead == 'n') SKIP(330)
      END_STATE();
    case 29:
      if (lookahead == '\r') SKIP(695)
      if (lookahead == 'n') SKIP(373)
      END_STATE();
    case 30:
      if (lookahead == '\r') SKIP(744)
      if (lookahead == 'n') SKIP(374)
      END_STATE();
    case 31:
      if (lookahead == '\r') SKIP(767)
      if (lookahead == 'n') SKIP(345)
      END_STATE();
    case 32:
      if (lookahead == '\r') SKIP(757)
      if (lookahead == 'n') SKIP(375)
      END_STATE();
    case 33:
      if (lookahead == '\r') SKIP(768)
      if (lookahead == 'n') SKIP(376)
      END_STATE();
    case 34:
      if (lookahead == '\r') SKIP(779)
      if (lookahead == 'n') SKIP(377)
      END_STATE();
    case 35:
      if (lookahead == '\r') SKIP(696)
      if (lookahead == 'n') SKIP(378)
      END_STATE();
    case 36:
      if (lookahead == '\r') SKIP(758)
      if (lookahead == 'n') SKIP(346)
      END_STATE();
    case 37:
      if (lookahead == '\r') SKIP(755)
      if (lookahead == 'n') SKIP(335)
      END_STATE();
    case 38:
      if (lookahead == '\r') SKIP(745)
      if (lookahead == 'n') SKIP(379)
      END_STATE();
    case 39:
      if (lookahead == '\r') SKIP(759)
      if (lookahead == 'n') SKIP(380)
      END_STATE();
    case 40:
      if (lookahead == '\r') SKIP(785)
      if (lookahead == 'n') SKIP(381)
      END_STATE();
    case 41:
      if (lookahead == '\r') SKIP(765)
      if (lookahead == 'n') SKIP(333)
      END_STATE();
    case 42:
      if (lookahead == '\r') SKIP(769)
      if (lookahead == 'n') SKIP(382)
      END_STATE();
    case 43:
      if (lookahead == '\r') SKIP(756)
      if (lookahead == 'n') SKIP(336)
      END_STATE();
    case 44:
      if (lookahead == '\r') SKIP(777)
      if (lookahead == 'n') SKIP(331)
      END_STATE();
    case 45:
      if (lookahead == '\r') SKIP(803)
      if (lookahead == 'n') SKIP(359)
      END_STATE();
    case 46:
      if (lookahead == '\r') SKIP(766)
      if (lookahead == 'n') SKIP(334)
      END_STATE();
    case 47:
      if (lookahead == '\r') SKIP(808)
      if (lookahead == 'n') SKIP(371)
      END_STATE();
    case 48:
      if (lookahead == '\r') SKIP(816)
      if (lookahead == 'n') SKIP(360)
      END_STATE();
    case 49:
      if (lookahead == '\r') SKIP(821)
      if (lookahead == 'n') SKIP(361)
      END_STATE();
    case 50:
      if (lookahead == '\r') SKIP(825)
      if (lookahead == 'n') SKIP(369)
      END_STATE();
    case 51:
      if (lookahead == '\r') SKIP(829)
      if (lookahead == 'n') SKIP(362)
      END_STATE();
    case 52:
      if (lookahead == '\r') SKIP(833)
      if (lookahead == 'n') SKIP(349)
      END_STATE();
    case 53:
      if (lookahead == '\r') SKIP(837)
      if (lookahead == 'n') SKIP(363)
      END_STATE();
    case 54:
      if (lookahead == '\r') SKIP(778)
      if (lookahead == 'n') SKIP(332)
      END_STATE();
    case 55:
      if (lookahead == '\r') SKIP(840)
      if (lookahead == 'n') SKIP(350)
      END_STATE();
    case 56:
      if (lookahead == '\r') SKIP(791)
      if (lookahead == 'n') SKIP(372)
      END_STATE();
    case 57:
      if (lookahead == '\r') SKIP(842)
      if (lookahead == 'n') SKIP(351)
      END_STATE();
    case 58:
      if (lookahead == '\r') SKIP(844)
      if (lookahead == 'n') SKIP(352)
      END_STATE();
    case 59:
      if (lookahead == '\r') SKIP(846)
      if (lookahead == 'n') SKIP(353)
      END_STATE();
    case 60:
      if (lookahead == '\r') SKIP(800)
      if (lookahead == 'n') SKIP(364)
      END_STATE();
    case 61:
      if (lookahead == '\r') SKIP(848)
      if (lookahead == 'n') SKIP(347)
      END_STATE();
    case 62:
      if (lookahead == '\r') SKIP(790)
      if (lookahead == 'n') SKIP(383)
      END_STATE();
    case 63:
      if (lookahead == '\r') SKIP(795)
      if (lookahead == 'n') SKIP(384)
      END_STATE();
    case 64:
      if (lookahead == '\r') SKIP(805)
      if (lookahead == 'n') SKIP(354)
      END_STATE();
    case 65:
      if (lookahead == '\r') SKIP(851)
      if (lookahead == 'n') SKIP(365)
      END_STATE();
    case 66:
      if (lookahead == '\r') SKIP(751)
      if (lookahead == 'n') SKIP(337)
      END_STATE();
    case 67:
      if (lookahead == '\r') SKIP(810)
      if (lookahead == 'n') SKIP(370)
      END_STATE();
    case 68:
      if (lookahead == '\r') SKIP(817)
      if (lookahead == 'n') SKIP(366)
      END_STATE();
    case 69:
      if (lookahead == '\r') SKIP(822)
      if (lookahead == 'n') SKIP(367)
      END_STATE();
    case 70:
      if (lookahead == '\r') SKIP(799)
      if (lookahead == 'n') SKIP(385)
      END_STATE();
    case 71:
      if (lookahead == '\r') SKIP(804)
      if (lookahead == 'n') SKIP(386)
      END_STATE();
    case 72:
      if (lookahead == '\r') SKIP(809)
      if (lookahead == 'n') SKIP(387)
      END_STATE();
    case 73:
      if (lookahead == '\r') SKIP(773)
      if (lookahead == 'n') SKIP(339)
      END_STATE();
    case 74:
      if (lookahead == '\r') SKIP(736)
      if (lookahead == 'n') SKIP(343)
      END_STATE();
    case 75:
      if (lookahead == '\r') SKIP(826)
      if (lookahead == 'n') SKIP(355)
      END_STATE();
    case 76:
      if (lookahead == '\r') SKIP(855)
      if (lookahead == 'n') SKIP(356)
      END_STATE();
    case 77:
      if (lookahead == '\r') SKIP(830)
      if (lookahead == 'n') SKIP(368)
      END_STATE();
    case 78:
      if (lookahead == '\r') SKIP(834)
      if (lookahead == 'n') SKIP(357)
      END_STATE();
    case 79:
      if (lookahead == '\r') SKIP(835)
      if (lookahead == 'n') SKIP(348)
      END_STATE();
    case 80:
      if (lookahead == '\r') SKIP(780)
      if (lookahead == 'n') SKIP(388)
      END_STATE();
    case 81:
      if (lookahead == '\r') SKIP(752)
      if (lookahead == 'n') SKIP(340)
      END_STATE();
    case 82:
      if (lookahead == '\r') SKIP(838)
      if (lookahead == 'n') SKIP(358)
      END_STATE();
    case 83:
      if (lookahead == '\r') SKIP(813)
      if (lookahead == 'n') SKIP(389)
      END_STATE();
    case 84:
      if (lookahead == '\r') SKIP(786)
      if (lookahead == 'n') SKIP(390)
      END_STATE();
    case 85:
      if (lookahead == '\r') SKIP(792)
      if (lookahead == 'n') SKIP(391)
      END_STATE();
    case 86:
      if (lookahead == '\r') SKIP(774)
      if (lookahead == 'n') SKIP(338)
      END_STATE();
    case 87:
      if (lookahead == '\r') SKIP(814)
      if (lookahead == 'n') SKIP(405)
      END_STATE();
    case 88:
      if (lookahead == '\r') SKIP(818)
      if (lookahead == 'n') SKIP(415)
      END_STATE();
    case 89:
      if (lookahead == '\r') SKIP(823)
      if (lookahead == 'n') SKIP(406)
      END_STATE();
    case 90:
      if (lookahead == '\r') SKIP(827)
      if (lookahead == 'n') SKIP(443)
      END_STATE();
    case 91:
      if (lookahead == '\r') SKIP(737)
      if (lookahead == 'n') SKIP(344)
      END_STATE();
    case 92:
      if (lookahead == '\r') SKIP(796)
      if (lookahead == 'n') SKIP(392)
      END_STATE();
    case 93:
      if (lookahead == '\r') SKIP(831)
      if (lookahead == 'n') SKIP(395)
      END_STATE();
    case 94:
      if (lookahead == '\r') SKIP(836)
      if (lookahead == 'n') SKIP(396)
      END_STATE();
    case 95:
      if (lookahead == '\r') SKIP(841)
      if (lookahead == 'n') SKIP(407)
      END_STATE();
    case 96:
      if (lookahead == '\r') SKIP(845)
      if (lookahead == 'n') SKIP(408)
      END_STATE();
    case 97:
      if (lookahead == '\r') SKIP(849)
      if (lookahead == 'n') SKIP(397)
      END_STATE();
    case 98:
      if (lookahead == '\r') SKIP(793)
      if (lookahead == 'n') SKIP(427)
      END_STATE();
    case 99:
      if (lookahead == '\r') SKIP(852)
      if (lookahead == 'n') SKIP(439)
      END_STATE();
    case 100:
      if (lookahead == '\r') SKIP(854)
      if (lookahead == 'n') SKIP(409)
      END_STATE();
    case 101:
      if (lookahead == '\r') SKIP(797)
      if (lookahead == 'n') SKIP(428)
      END_STATE();
    case 102:
      if (lookahead == '\r') SKIP(856)
      if (lookahead == 'n') SKIP(441)
      END_STATE();
    case 103:
      if (lookahead == '\r') SKIP(857)
      if (lookahead == 'n') SKIP(398)
      END_STATE();
    case 104:
      if (lookahead == '\r') SKIP(746)
      if (lookahead == 'n') SKIP(440)
      END_STATE();
    case 105:
      if (lookahead == '\r') SKIP(858)
      if (lookahead == 'n') SKIP(399)
      END_STATE();
    case 106:
      if (lookahead == '\r') SKIP(807)
      if (lookahead == 'n') SKIP(400)
      END_STATE();
    case 107:
      if (lookahead == '\r') SKIP(801)
      if (lookahead == 'n') SKIP(447)
      END_STATE();
    case 108:
      if (lookahead == '\r') SKIP(812)
      if (lookahead == 'n') SKIP(416)
      END_STATE();
    case 109:
      if (lookahead == '\r') SKIP(820)
      if (lookahead == 'n') SKIP(401)
      END_STATE();
    case 110:
      if (lookahead == '\r') SKIP(806)
      if (lookahead == 'n') SKIP(429)
      END_STATE();
    case 111:
      if (lookahead == '\r') SKIP(824)
      if (lookahead == 'n') SKIP(410)
      END_STATE();
    case 112:
      if (lookahead == '\r') SKIP(811)
      if (lookahead == 'n') SKIP(430)
      END_STATE();
    case 113:
      if (lookahead == '\r') SKIP(828)
      if (lookahead == 'n') SKIP(444)
      END_STATE();
    case 114:
      if (lookahead == '\r') SKIP(815)
      if (lookahead == 'n') SKIP(431)
      END_STATE();
    case 115:
      if (lookahead == '\r') SKIP(832)
      if (lookahead == 'n') SKIP(402)
      END_STATE();
    case 116:
      if (lookahead == '\r') SKIP(784)
      if (lookahead == 'n') SKIP(432)
      END_STATE();
    case 117:
      if (lookahead == '\r') SKIP(839)
      if (lookahead == 'n') SKIP(411)
      END_STATE();
    case 118:
      if (lookahead == '\r') SKIP(843)
      if (lookahead == 'n') SKIP(412)
      END_STATE();
    case 119:
      if (lookahead == '\r') SKIP(847)
      if (lookahead == 'n') SKIP(442)
      END_STATE();
    case 120:
      if (lookahead == '\r') SKIP(850)
      if (lookahead == 'n') SKIP(403)
      END_STATE();
    case 121:
      if (lookahead == '\r') SKIP(859)
      if (lookahead == 'n') SKIP(413)
      END_STATE();
    case 122:
      if (lookahead == '\r') SKIP(860)
      if (lookahead == 'n') SKIP(404)
      END_STATE();
    case 123:
      if (lookahead == '\r') SKIP(853)
      if (lookahead == 'n') SKIP(414)
      END_STATE();
    case 124:
      if (lookahead == '\r') SKIP(819)
      if (lookahead == 'n') SKIP(433)
      END_STATE();
    case 125:
      if (lookahead == '\r') SKIP(789)
      if (lookahead == 'n') SKIP(448)
      END_STATE();
    case 126:
      if (lookahead == '\r') SKIP(794)
      if (lookahead == 'n') SKIP(434)
      END_STATE();
    case 127:
      if (lookahead == '\r') SKIP(798)
      if (lookahead == 'n') SKIP(435)
      END_STATE();
    case 128:
      if (lookahead == '\r') SKIP(802)
      if (lookahead == 'n') SKIP(436)
      END_STATE();
    case 129:
      if (lookahead == '\r') SKIP(697)
      if (lookahead == 'n') SKIP(489)
      END_STATE();
    case 130:
      if (lookahead == '\r') SKIP(698)
      if (lookahead == 'n') SKIP(490)
      END_STATE();
    case 131:
      if (lookahead == '\r') SKIP(699)
      if (lookahead == 'n') SKIP(470)
      END_STATE();
    case 132:
      if (lookahead == '\r') SKIP(747)
      if (lookahead == 'n') SKIP(464)
      END_STATE();
    case 133:
      if (lookahead == '\r') SKIP(700)
      if (lookahead == 'n') SKIP(477)
      END_STATE();
    case 134:
      if (lookahead == '\r') SKIP(701)
      if (lookahead == 'n') SKIP(462)
      END_STATE();
    case 135:
      if (lookahead == '\r') SKIP(770)
      if (lookahead == 'n') SKIP(463)
      END_STATE();
    case 136:
      if (lookahead == '\r') SKIP(749)
      if (lookahead == 'n') SKIP(468)
      END_STATE();
    case 137:
      if (lookahead == '\r') SKIP(748)
      if (lookahead == 'n') SKIP(461)
      END_STATE();
    case 138:
      if (lookahead == '\r') SKIP(702)
      if (lookahead == 'n') SKIP(467)
      END_STATE();
    case 139:
      if (lookahead == '\r') SKIP(703)
      if (lookahead == 'n') SKIP(487)
      END_STATE();
    case 140:
      if (lookahead == '\r') SKIP(704)
      if (lookahead == 'n') SKIP(488)
      END_STATE();
    case 141:
      if (lookahead == '\r') SKIP(705)
      if (lookahead == 'n') SKIP(491)
      END_STATE();
    case 142:
      if (lookahead == '\r') SKIP(706)
      if (lookahead == 'n') SKIP(485)
      END_STATE();
    case 143:
      if (lookahead == '\r') SKIP(707)
      if (lookahead == 'n') SKIP(481)
      END_STATE();
    case 144:
      if (lookahead == '\r') SKIP(708)
      if (lookahead == 'n') SKIP(472)
      END_STATE();
    case 145:
      if (lookahead == '\r') SKIP(709)
      if (lookahead == 'n') SKIP(479)
      END_STATE();
    case 146:
      if (lookahead == '\r') SKIP(710)
      if (lookahead == 'n') SKIP(474)
      END_STATE();
    case 147:
      if (lookahead == '\r') SKIP(711)
      if (lookahead == 'n') SKIP(486)
      END_STATE();
    case 148:
      if (lookahead == '\r') SKIP(713)
      if (lookahead == 'n') SKIP(483)
      END_STATE();
    case 149:
      if (lookahead == '\r') SKIP(714)
      if (lookahead == 'n') SKIP(510)
      END_STATE();
    case 150:
      if (lookahead == '\r') SKIP(715)
      if (lookahead == 'n') SKIP(500)
      END_STATE();
    case 151:
      if (lookahead == '\r') SKIP(716)
      if (lookahead == 'n') SKIP(511)
      END_STATE();
    case 152:
      if (lookahead == '\r') SKIP(717)
      if (lookahead == 'n') SKIP(501)
      END_STATE();
    case 153:
      if (lookahead == '\r') SKIP(718)
      if (lookahead == 'n') SKIP(504)
      END_STATE();
    case 154:
      if (lookahead == '\r') SKIP(719)
      if (lookahead == 'n') SKIP(502)
      END_STATE();
    case 155:
      if (lookahead == '\r') SKIP(720)
      if (lookahead == 'n') SKIP(515)
      END_STATE();
    case 156:
      if (lookahead == '\r') SKIP(721)
      if (lookahead == 'n') SKIP(451)
      END_STATE();
    case 157:
      if (lookahead == '\r') SKIP(722)
      if (lookahead == 'n') SKIP(509)
      END_STATE();
    case 158:
      if (lookahead == '\r') SKIP(723)
      if (lookahead == 'n') SKIP(507)
      END_STATE();
    case 159:
      if (lookahead == '\r') SKIP(724)
      if (lookahead == 'n') SKIP(506)
      END_STATE();
    case 160:
      if (lookahead == '\r') SKIP(725)
      if (lookahead == 'n') SKIP(513)
      END_STATE();
    case 161:
      if (lookahead == '\r') SKIP(726)
      if (lookahead == 'n') SKIP(514)
      END_STATE();
    case 162:
      if (lookahead == '\r') SKIP(727)
      if (lookahead == 'n') SKIP(512)
      END_STATE();
    case 163:
      if (lookahead == '\r') SKIP(728)
      if (lookahead == 'n') SKIP(520)
      END_STATE();
    case 164:
      if (lookahead == '\r') SKIP(729)
      if (lookahead == 'n') SKIP(505)
      END_STATE();
    case 165:
      if (lookahead == '\r') SKIP(730)
      if (lookahead == 'n') SKIP(542)
      END_STATE();
    case 166:
      if (lookahead == '\r') SKIP(731)
      if (lookahead == 'n') SKIP(538)
      END_STATE();
    case 167:
      if (lookahead == '\r') SKIP(732)
      if (lookahead == 'n') SKIP(518)
      END_STATE();
    case 168:
      if (lookahead == '\r') SKIP(733)
      if (lookahead == 'n') SKIP(543)
      END_STATE();
    case 169:
      if (lookahead == '\r') SKIP(750)
      if (lookahead == 'n') SKIP(516)
      END_STATE();
    case 170:
      if (lookahead == '\r') SKIP(734)
      if (lookahead == 'n') SKIP(544)
      END_STATE();
    case 171:
      if (lookahead == '\r') SKIP(735)
      if (lookahead == 'n') SKIP(545)
      END_STATE();
    case 172:
      if (lookahead == '!') ADVANCE(531);
      if (lookahead == '"') ADVANCE(1193);
      if (lookahead == '#') ADVANCE(1130);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1055);
      if (lookahead == '&') ADVANCE(1033);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1123);
      if (lookahead == '+') ADVANCE(1210);
      if (lookahead == ',') ADVANCE(1022);
      if (lookahead == '-') ADVANCE(1212);
      if (lookahead == '.') ADVANCE(1168);
      if (lookahead == '/') ADVANCE(528);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1126);
      if (lookahead == '=') ADVANCE(965);
      if (lookahead == '>') ADVANCE(1113);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(454);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1143);
      if (lookahead == '_') ADVANCE(1016);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'g') ADVANCE(597);
      if (lookahead == 'i') ADVANCE(588);
      if (lookahead == 'l') ADVANCE(550);
      if (lookahead == 'm') ADVANCE(556);
      if (lookahead == 'n') ADVANCE(599);
      if (lookahead == 'o') ADVANCE(630);
      if (lookahead == 'p') ADVANCE(551);
      if (lookahead == 'r') ADVANCE(600);
      if (lookahead == 't') ADVANCE(640);
      if (lookahead == 'u') ADVANCE(679);
      if (lookahead == 'v') ADVANCE(555);
      if (lookahead == 'w') ADVANCE(637);
      if (lookahead == 'y') ADVANCE(649);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1030);
      if (lookahead == '}') ADVANCE(1044);
      if (lookahead == '~') ADVANCE(1221);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(172)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1247);
      END_STATE();
    case 173:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(27)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(329)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 174:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(28)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(330)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 175:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(37)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(335)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 176:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(41)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(333)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 177:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(43)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(336)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 178:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(44)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(331)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 179:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(46)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(334)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 180:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(54)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(332)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 181:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(3)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(341)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 182:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(342)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 183:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(3)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(341)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 184:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(342)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 185:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(73)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(339)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 186:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(74)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(343)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 187:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(81)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(340)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 188:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(91)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(344)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 189:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(3)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(341)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 190:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(342)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 191:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(66)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(337)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 192:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(86)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(338)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 193:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(29)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(373)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 194:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(30)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(374)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 195:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(32)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(375)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 196:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(33)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(376)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 197:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(34)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(377)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 198:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(35)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(378)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 199:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(38)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(379)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 200:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(39)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(380)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 201:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(40)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(381)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 202:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(42)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(382)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 203:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(45)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(359)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 204:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(48)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(360)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 205:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(49)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(361)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 206:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(51)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(362)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 207:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(52)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(349)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 208:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(53)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(363)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 209:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(55)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(350)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 210:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(57)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(351)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 211:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(58)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(352)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 212:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(59)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(353)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 213:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(60)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(364)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 214:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(62)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(383)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 215:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(63)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(384)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 216:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(64)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(354)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 217:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(65)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(365)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 218:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(68)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(366)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 219:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(69)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(367)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 220:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(70)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(385)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 221:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(71)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(386)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 222:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(72)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(387)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 223:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(75)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(355)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 224:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(76)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(356)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 225:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(77)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(368)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 226:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(78)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(357)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 227:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(80)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(388)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 228:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(82)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(358)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 229:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(83)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(389)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 230:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(84)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(390)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 231:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(85)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(391)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 232:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(92)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(392)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 233:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(31)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(345)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 234:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(36)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(346)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 235:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(47)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(371)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 236:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(50)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(369)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 237:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(56)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(372)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 238:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(61)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(347)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 239:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(67)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(370)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 240:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1109);
      if (lookahead == '\\') SKIP(79)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(348)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 241:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(5)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(417)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 242:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(418)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 243:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(419)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 244:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(11)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(420)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 245:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(12)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(421)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 246:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(15)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(422)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 247:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(16)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(423)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 248:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(17)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(424)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 249:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(19)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(425)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 250:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(20)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(426)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 251:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(5)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(417)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 252:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(418)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 253:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(419)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 254:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(11)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(420)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 255:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(12)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(421)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 256:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(15)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(422)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 257:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(16)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(423)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 258:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(17)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(424)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 259:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(19)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(425)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 260:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(20)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(426)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 261:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(87)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(405)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 262:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(89)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(406)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 263:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(95)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(407)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 264:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(96)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(408)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 265:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(98)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(427)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 266:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(100)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(409)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 267:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(101)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1460);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(428)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 268:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(110)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(429)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 269:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(111)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(410)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 270:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(112)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(430)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 271:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(114)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(431)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 272:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(116)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(432)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 273:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(117)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(411)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 274:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(118)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(412)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 275:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(121)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(413)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 276:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(123)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(414)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 277:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(124)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(433)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 278:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(126)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(434)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 279:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(127)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1460);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(435)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 280:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(128)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(436)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 281:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(5)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(417)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 282:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(418)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 283:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(419)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 284:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(11)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(420)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 285:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(12)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(421)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 286:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(15)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(422)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 287:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(16)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(423)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 288:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(17)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(424)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 289:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(19)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(425)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 290:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(20)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(426)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 291:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(7)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(393)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 292:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(14)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(394)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 293:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(7)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(393)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 294:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(14)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(394)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 295:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(88)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(415)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 296:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(93)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1460);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(395)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 297:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(94)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(396)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 298:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(97)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(397)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 299:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(103)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(398)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 300:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(105)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(399)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 301:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(106)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(400)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 302:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(108)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(416)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 303:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(109)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1460);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(401)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 304:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(115)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(402)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 305:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(120)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(403)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 306:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(122)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(404)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 307:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(7)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(393)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 308:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(14)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(394)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 309:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(9)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(445)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 310:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(18)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(446)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 311:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(9)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(445)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 312:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(18)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(446)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 313:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(102)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(441)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 314:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(107)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(447)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 315:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(119)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(442)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 316:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(125)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(448)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 317:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(9)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(445)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 318:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1107);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(18)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(446)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 319:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(437)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 320:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(13)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(438)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 321:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(437)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 322:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(13)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(438)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 323:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(90)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(443)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 324:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(99)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(439)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 325:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(104)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(440)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 326:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(113)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(444)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 327:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(437)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 328:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1043);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1106);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1180);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1112);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == 'L') ADVANCE(1285);
      if (lookahead == 'M') ADVANCE(1296);
      if (lookahead == 'U') ADVANCE(1303);
      if (lookahead == '[') ADVANCE(1110);
      if (lookahead == '\\') SKIP(13)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1267);
      if (lookahead == 'm') ADVANCE(1294);
      if (lookahead == 'n') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 's') ADVANCE(1260);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1273);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1254);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == 'G' ||
          lookahead == 'I' ||
          lookahead == 'N' ||
          lookahead == 'Q' ||
          lookahead == 'R' ||
          lookahead == 'Z') ADVANCE(1292);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(438)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1181);
      if (aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(1538);
      END_STATE();
    case 329:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1243);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(27)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(329)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 330:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1243);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(28)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(330)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 331:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1243);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(44)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(331)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 332:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1243);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(54)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(332)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 333:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(41)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(333)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 334:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(46)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(334)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 335:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(37)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(335)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 336:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(43)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(336)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 337:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(66)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(337)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 338:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(86)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(338)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 339:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(73)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(339)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 340:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(81)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(340)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 341:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(3)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (('*' <= lookahead && lookahead <= '.') ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(341)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 342:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (('*' <= lookahead && lookahead <= '.') ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(342)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 343:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(74)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (('*' <= lookahead && lookahead <= '.') ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(343)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 344:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == ')') ADVANCE(1021);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == ';') ADVANCE(973);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1241);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(91)
      if (lookahead == ']') ADVANCE(1038);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1239);
      if (lookahead == '~') ADVANCE(1222);
      if (('*' <= lookahead && lookahead <= '.') ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(344)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(1538);
      END_STATE();
    case 345:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(31)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(345)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 346:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(36)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(346)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 347:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(61)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(347)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 348:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(79)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(348)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 349:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(52)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(349)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 350:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(55)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(350)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 351:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(57)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(351)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 352:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(58)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(352)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 353:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(59)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(353)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 354:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(64)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(354)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 355:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(75)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(355)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 356:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(76)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(356)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 357:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(78)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(357)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 358:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(82)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(358)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 359:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(45)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(359)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 360:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(48)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(360)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 361:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(49)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(361)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 362:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(51)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(362)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 363:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(53)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(363)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 364:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(60)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(364)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 365:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(65)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(365)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 366:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(68)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(366)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 367:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(69)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(367)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 368:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1171);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(77)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(368)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 369:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1170);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(50)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(369)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 370:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1170);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(67)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(370)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 371:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1170);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(47)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(371)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 372:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '.') ADVANCE(1170);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '>') ADVANCE(1243);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(56)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(372)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 373:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(29)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(373)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 374:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(30)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(374)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 375:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(32)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(375)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 376:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(33)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(376)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 377:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(34)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(377)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 378:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(35)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(378)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 379:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(38)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(379)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 380:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(39)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(380)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 381:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(40)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(381)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 382:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(42)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(382)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 383:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(62)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(383)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 384:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(63)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(384)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 385:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(70)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(385)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 386:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(71)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(386)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 387:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(72)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(387)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 388:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(80)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(388)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 389:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(83)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1439);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(389)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 390:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(84)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1459);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(390)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 391:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(85)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(391)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 392:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '*') ADVANCE(1124);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1213);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1127);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1036);
      if (lookahead == '\\') SKIP(92)
      if (lookahead == '^') ADVANCE(1144);
      if (lookahead == '_') ADVANCE(1017);
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '.' ||
          lookahead == '>') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(392)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(1538);
      END_STATE();
    case 393:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(7)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(393)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 394:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(14)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1449);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(394)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 395:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(93)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1460);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1450);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(395)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 396:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(94)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1485);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(396)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 397:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(97)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1392);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(397)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 398:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(103)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1408);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1394);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(398)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(1249);
      if (aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(1538);
      END_STATE();
    case 399:
      if (lookahead == '!') ADVANCE(1235);
      if (lookahead == '"') ADVANCE(1194);
      if (lookahead == '$') ADVANCE(1228);
      if (lookahead == '%') ADVANCE(1056);
      if (lookahead == '&') ADVANCE(1034);
      if (lookahead == '\'') ADVANCE(1142);
      if (lookahead == '(') ADVANCE(1019);
      if (lookahead == '+') ADVANCE(1211);
      if (lookahead == ',') ADVANCE(1023);
      if (lookahead == '-') ADVANCE(1214);
      if (lookahead == '.') ADVANCE(1232);
      if (lookahead == '/') ADVANCE(1234);
      if (lookahead == '0') ADVANCE(1248);
      if (lookahead == ':') ADVANCE(977);
      if (lookahead == '<') ADVANCE(1231);
      if (lookahead == '=') ADVANCE(966);
      if (lookahead == '?') ADVANCE(1153);
      if (lookahead == '@') ADVANCE(1230);
      if (lookahead == '[') ADVANCE(1037);
      if (lookahead == '\\') SKIP(105)
      if (lookahead == '`') ADVANCE(547);
      if (lookahead == 'a') ADVANCE(1487);
      if (lookahead == 'b') ADVANCE(1344);
      if (lookahead == 'd') ADVANCE(1452);
      if (lookahead == 'e') ADVANCE(1407);
      if (lookahead == 'f') ADVANCE(1305);
      if (lookahead == 'i') ADVANCE(1382);
      if (lookahead == 'l') ADVANCE(1304);
      if (lookahead == 'm') ADVANCE(1307);
      if (lookahead == 'n') ADVANCE(1346);
      if (lookahead == 'o') ADVANCE(1466);
      if (lookahead == 'r') ADVANCE(1365);
      if (lookahead == 't') ADVANCE(1467);
      if (lookahead == 'u') ADVANCE(1462);
      if (lookahead == 'w') ADVANCE(1393);
      if (lookahead == 'y') ADVANCE(1399);
      if (lookahead == '{') ADVANCE(1041);
      if (lookahead == '|') ADVANCE(1242);
      if (lookahead == '~') ADVANCE(1222);
      if (lookahead == '*' ||
          lookahead == '>' ||
          lookahead == '^') ADVANCE(1243);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(399)
      if ((