#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1675
#define LARGE_STATE_COUNT 245
#define SYMBOL_COUNT 163
#define ALIAS_COUNT 3
#define TOKEN_COUNT 89
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 22
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 68

enum {
  anon_sym_COMMA = 1,
  anon_sym_POUND_BANG = 2,
  aux_sym_shebang_token1 = 3,
  anon_sym_LF = 4,
  anon_sym_DOT = 5,
  anon_sym_SEMI = 6,
  anon_sym_DASH = 7,
  anon_sym_define = 8,
  anon_sym_LPAREN = 9,
  anon_sym_RPAREN = 10,
  anon_sym_spec = 11,
  anon_sym_callback = 12,
  anon_sym_COLON = 13,
  anon_sym_when = 14,
  anon_sym_if = 15,
  anon_sym_LT_LT = 16,
  anon_sym_GT_GT = 17,
  anon_sym_LBRACE = 18,
  anon_sym_RBRACE = 19,
  anon_sym_LBRACK = 20,
  anon_sym_RBRACK = 21,
  anon_sym_POUND = 22,
  anon_sym_PLUS = 23,
  anon_sym_not = 24,
  anon_sym_bnot = 25,
  anon_sym_catch = 26,
  anon_sym_SLASH = 27,
  anon_sym_STAR = 28,
  anon_sym_div = 29,
  anon_sym_rem = 30,
  anon_sym_band = 31,
  anon_sym_and = 32,
  anon_sym_bor = 33,
  anon_sym_bxor = 34,
  anon_sym_bsl = 35,
  anon_sym_bsr = 36,
  anon_sym_or = 37,
  anon_sym_xor = 38,
  anon_sym_PLUS_PLUS = 39,
  anon_sym_DASH_DASH = 40,
  anon_sym_EQ_EQ = 41,
  anon_sym_SLASH_EQ = 42,
  anon_sym_EQ_LT = 43,
  anon_sym_LT = 44,
  anon_sym_GT_EQ = 45,
  anon_sym_GT = 46,
  anon_sym_EQ_COLON_EQ = 47,
  anon_sym_EQ_SLASH_EQ = 48,
  anon_sym_andalso = 49,
  anon_sym_orelse = 50,
  anon_sym_EQ = 51,
  anon_sym_BANG = 52,
  anon_sym_QMARK_EQ = 53,
  anon_sym_DOT_DOT = 54,
  anon_sym_PIPE_PIPE = 55,
  anon_sym_COLON_COLON = 56,
  anon_sym_PIPE = 57,
  anon_sym_LT_DASH = 58,
  anon_sym_LT_EQ = 59,
  anon_sym_EQ_GT = 60,
  anon_sym_COLON_EQ = 61,
  anon_sym_fun = 62,
  anon_sym_end = 63,
  anon_sym_DASH_GT = 64,
  anon_sym_begin = 65,
  anon_sym_case = 66,
  anon_sym_of = 67,
  anon_sym_receive = 68,
  anon_sym_after = 69,
  anon_sym_try = 70,
  anon_sym_maybe = 71,
  anon_sym_else = 72,
  anon_sym_DOLLAR = 73,
  aux_sym_character_token1 = 74,
  aux_sym_integer_token1 = 75,
  aux_sym_integer_token2 = 76,
  sym_float = 77,
  sym__atom = 78,
  anon_sym_SQUOTE = 79,
  sym_variable = 80,
  anon_sym_QMARK = 81,
  anon_sym_QMARK2 = 82,
  anon_sym_DQUOTE = 83,
  sym_escape_sequence = 84,
  sym_quoted_content = 85,
  sym_tripledot = 86,
  aux_sym_comment_token1 = 87,
  aux_sym_comment_token2 = 88,
  sym_source = 89,
  sym_shebang = 90,
  sym__statement = 91,
  sym__terminator = 92,
  sym_function = 93,
  sym__macro_declaration = 94,
  sym__macro_arguments = 95,
  sym__semicolon_separated_expressions = 96,
  sym__spec = 97,
  sym_attribute = 98,
  sym__expression_without_call = 99,
  sym__expression = 100,
  sym_parenthesized_expression = 101,
  sym_bitstring = 102,
  sym_tuple = 103,
  sym_list = 104,
  sym_map = 105,
  sym__map_body = 106,
  sym_map_update = 107,
  sym_record = 108,
  sym__record_body = 109,
  sym_unary_operator = 110,
  sym_binary_operator = 111,
  sym__literal = 112,
  sym_anonymous_function = 113,
  sym_stab_clause = 114,
  sym__named_stab_clause = 115,
  sym__anonymous_stab_clause = 116,
  sym_clause = 117,
  sym_guard = 118,
  sym_arguments = 119,
  sym__body = 120,
  sym_body = 121,
  sym__items = 122,
  sym_call = 123,
  sym__qualified_function = 124,
  sym__unqualified_function = 125,
  sym_function_capture = 126,
  sym_function_type = 127,
  sym_block = 128,
  sym_if = 129,
  sym__if_clause = 130,
  sym_case = 131,
  sym_receive = 132,
  sym_after = 133,
  sym__body_after = 134,
  sym_try = 135,
  sym_maybe = 136,
  sym_character = 137,
  sym__number = 138,
  sym_integer = 139,
  sym__identifier = 140,
  sym_atom = 141,
  sym__quoted_atom = 142,
  sym_macro = 143,
  sym__macro_constant = 144,
  sym__macro_call = 145,
  sym__strings = 146,
  sym_string = 147,
  sym_comment = 148,
  sym_line_comment = 149,
  sym_comment_content = 150,
  aux_sym_source_repeat1 = 151,
  aux_sym_source_repeat2 = 152,
  aux_sym_function_repeat1 = 153,
  aux_sym__semicolon_separated_expressions_repeat1 = 154,
  aux_sym__spec_repeat1 = 155,
  aux_sym_anonymous_function_repeat1 = 156,
  aux_sym_guard_repeat1 = 157,
  aux_sym_if_repeat1 = 158,
  aux_sym_case_repeat1 = 159,
  aux_sym__quoted_atom_repeat1 = 160,
  aux_sym__strings_repeat1 = 161,
  aux_sym_string_repeat1 = 162,
  alias_sym_function_clause = 163,
  alias_sym_map_content = 164,
  alias_sym_record_content = 165,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_COMMA] = ",",
  [anon_sym_POUND_BANG] = "#!",
  [aux_sym_shebang_token1] = "shebang_token1",
  [anon_sym_LF] = "\n",
  [anon_sym_DOT] = ".",
  [anon_sym_SEMI] = ";",
  [anon_sym_DASH] = "-",
  [anon_sym_define] = "atom",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_spec] = "atom",
  [anon_sym_callback] = "atom",
  [anon_sym_COLON] = ":",
  [anon_sym_when] = "when",
  [anon_sym_if] = "if",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_POUND] = "#",
  [anon_sym_PLUS] = "+",
  [anon_sym_not] = "not",
  [anon_sym_bnot] = "bnot",
  [anon_sym_catch] = "catch",
  [anon_sym_SLASH] = "/",
  [anon_sym_STAR] = "*",
  [anon_sym_div] = "div",
  [anon_sym_rem] = "rem",
  [anon_sym_band] = "band",
  [anon_sym_and] = "and",
  [anon_sym_bor] = "bor",
  [anon_sym_bxor] = "bxor",
  [anon_sym_bsl] = "bsl",
  [anon_sym_bsr] = "bsr",
  [anon_sym_or] = "or",
  [anon_sym_xor] = "xor",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_EQ_LT] = "=<",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_EQ_COLON_EQ] = "=:=",
  [anon_sym_EQ_SLASH_EQ] = "=/=",
  [anon_sym_andalso] = "andalso",
  [anon_sym_orelse] = "orelse",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG] = "!",
  [anon_sym_QMARK_EQ] = "\?=",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_PIPE] = "|",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_fun] = "fun",
  [anon_sym_end] = "end",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_begin] = "begin",
  [anon_sym_case] = "case",
  [anon_sym_of] = "of",
  [anon_sym_receive] = "receive",
  [anon_sym_after] = "after",
  [anon_sym_try] = "try",
  [anon_sym_maybe] = "maybe",
  [anon_sym_else] = "else",
  [anon_sym_DOLLAR] = "$",
  [aux_sym_character_token1] = "character_token1",
  [aux_sym_integer_token1] = "integer_token1",
  [aux_sym_integer_token2] = "integer_token2",
  [sym_float] = "float",
  [sym__atom] = "_atom",
  [anon_sym_SQUOTE] = "'",
  [sym_variable] = "variable",
  [anon_sym_QMARK] = "\?",
  [anon_sym_QMARK2] = "\?",
  [anon_sym_DQUOTE] = "\"",
  [sym_escape_sequence] = "escape_sequence",
  [sym_quoted_content] = "quoted_content",
  [sym_tripledot] = "tripledot",
  [aux_sym_comment_token1] = "comment_token1",
  [aux_sym_comment_token2] = "comment_content",
  [sym_source] = "source",
  [sym_shebang] = "shebang",
  [sym__statement] = "_statement",
  [sym__terminator] = "_terminator",
  [sym_function] = "function",
  [sym__macro_declaration] = "attribute",
  [sym__macro_arguments] = "arguments",
  [sym__semicolon_separated_expressions] = "body",
  [sym__spec] = "attribute",
  [sym_attribute] = "attribute",
  [sym__expression_without_call] = "_expression_without_call",
  [sym__expression] = "_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_bitstring] = "bitstring",
  [sym_tuple] = "tuple",
  [sym_list] = "list",
  [sym_map] = "map",
  [sym__map_body] = "_map_body",
  [sym_map_update] = "map_update",
  [sym_record] = "record",
  [sym__record_body] = "_record_body",
  [sym_unary_operator] = "unary_operator",
  [sym_binary_operator] = "binary_operator",
  [sym__literal] = "_literal",
  [sym_anonymous_function] = "anonymous_function",
  [sym_stab_clause] = "stab_clause",
  [sym__named_stab_clause] = "_named_stab_clause",
  [sym__anonymous_stab_clause] = "_anonymous_stab_clause",
  [sym_clause] = "clause",
  [sym_guard] = "guard",
  [sym_arguments] = "arguments",
  [sym__body] = "_body",
  [sym_body] = "body",
  [sym__items] = "_items",
  [sym_call] = "call",
  [sym__qualified_function] = "_qualified_function",
  [sym__unqualified_function] = "_unqualified_function",
  [sym_function_capture] = "function_capture",
  [sym_function_type] = "function_type",
  [sym_block] = "block",
  [sym_if] = "if",
  [sym__if_clause] = "clause",
  [sym_case] = "case",
  [sym_receive] = "receive",
  [sym_after] = "after",
  [sym__body_after] = "after",
  [sym_try] = "try",
  [sym_maybe] = "maybe",
  [sym_character] = "character",
  [sym__number] = "_number",
  [sym_integer] = "integer",
  [sym__identifier] = "_identifier",
  [sym_atom] = "atom",
  [sym__quoted_atom] = "_quoted_atom",
  [sym_macro] = "macro",
  [sym__macro_constant] = "_macro_constant",
  [sym__macro_call] = "_macro_call",
  [sym__strings] = "_strings",
  [sym_string] = "string",
  [sym_comment] = "comment",
  [sym_line_comment] = "line_comment",
  [sym_comment_content] = "comment_content",
  [aux_sym_source_repeat1] = "source_repeat1",
  [aux_sym_source_repeat2] = "source_repeat2",
  [aux_sym_function_repeat1] = "function_repeat1",
  [aux_sym__semicolon_separated_expressions_repeat1] = "_semicolon_separated_expressions_repeat1",
  [aux_sym__spec_repeat1] = "_spec_repeat1",
  [aux_sym_anonymous_function_repeat1] = "anonymous_function_repeat1",
  [aux_sym_guard_repeat1] = "guard_repeat1",
  [aux_sym_if_repeat1] = "if_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym__quoted_atom_repeat1] = "_quoted_atom_repeat1",
  [aux_sym__strings_repeat1] = "_strings_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [alias_sym_function_clause] = "function_clause",
  [alias_sym_map_content] = "map_content",
  [alias_sym_record_content] = "record_content",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_POUND_BANG] = anon_sym_POUND_BANG,
  [aux_sym_shebang_token1] = aux_sym_shebang_token1,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_define] = sym_atom,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_spec] = sym_atom,
  [anon_sym_callback] = sym_atom,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_bnot] = anon_sym_bnot,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_div] = anon_sym_div,
  [anon_sym_rem] = anon_sym_rem,
  [anon_sym_band] = anon_sym_band,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_bor] = anon_sym_bor,
  [anon_sym_bxor] = anon_sym_bxor,
  [anon_sym_bsl] = anon_sym_bsl,
  [anon_sym_bsr] = anon_sym_bsr,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_EQ_LT] = anon_sym_EQ_LT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_EQ_COLON_EQ] = anon_sym_EQ_COLON_EQ,
  [anon_sym_EQ_SLASH_EQ] = anon_sym_EQ_SLASH_EQ,
  [anon_sym_andalso] = anon_sym_andalso,
  [anon_sym_orelse] = anon_sym_orelse,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_QMARK_EQ] = anon_sym_QMARK_EQ,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_fun] = anon_sym_fun,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_begin] = anon_sym_begin,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_receive] = anon_sym_receive,
  [anon_sym_after] = anon_sym_after,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_maybe] = anon_sym_maybe,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_character_token1] = aux_sym_character_token1,
  [aux_sym_integer_token1] = aux_sym_integer_token1,
  [aux_sym_integer_token2] = aux_sym_integer_token2,
  [sym_float] = sym_float,
  [sym__atom] = sym__atom,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_variable] = sym_variable,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_QMARK2] = anon_sym_QMARK,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_quoted_content] = sym_quoted_content,
  [sym_tripledot] = sym_tripledot,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [aux_sym_comment_token2] = sym_comment_content,
  [sym_source] = sym_source,
  [sym_shebang] = sym_shebang,
  [sym__statement] = sym__statement,
  [sym__terminator] = sym__terminator,
  [sym_function] = sym_function,
  [sym__macro_declaration] = sym_attribute,
  [sym__macro_arguments] = sym_arguments,
  [sym__semicolon_separated_expressions] = sym_body,
  [sym__spec] = sym_attribute,
  [sym_attribute] = sym_attribute,
  [sym__expression_without_call] = sym__expression_without_call,
  [sym__expression] = sym__expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_bitstring] = sym_bitstring,
  [sym_tuple] = sym_tuple,
  [sym_list] = sym_list,
  [sym_map] = sym_map,
  [sym__map_body] = sym__map_body,
  [sym_map_update] = sym_map_update,
  [sym_record] = sym_record,
  [sym__record_body] = sym__record_body,
  [sym_unary_operator] = sym_unary_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym__literal] = sym__literal,
  [sym_anonymous_function] = sym_anonymous_function,
  [sym_stab_clause] = sym_stab_clause,
  [sym__named_stab_clause] = sym__named_stab_clause,
  [sym__anonymous_stab_clause] = sym__anonymous_stab_clause,
  [sym_clause] = sym_clause,
  [sym_guard] = sym_guard,
  [sym_arguments] = sym_arguments,
  [sym__body] = sym__body,
  [sym_body] = sym_body,
  [sym__items] = sym__items,
  [sym_call] = sym_call,
  [sym__qualified_function] = sym__qualified_function,
  [sym__unqualified_function] = sym__unqualified_function,
  [sym_function_capture] = sym_function_capture,
  [sym_function_type] = sym_function_type,
  [sym_block] = sym_block,
  [sym_if] = sym_if,
  [sym__if_clause] = sym_clause,
  [sym_case] = sym_case,
  [sym_receive] = sym_receive,
  [sym_after] = sym_after,
  [sym__body_after] = sym_after,
  [sym_try] = sym_try,
  [sym_maybe] = sym_maybe,
  [sym_character] = sym_character,
  [sym__number] = sym__number,
  [sym_integer] = sym_integer,
  [sym__identifier] = sym__identifier,
  [sym_atom] = sym_atom,
  [sym__quoted_atom] = sym__quoted_atom,
  [sym_macro] = sym_macro,
  [sym__macro_constant] = sym__macro_constant,
  [sym__macro_call] = sym__macro_call,
  [sym__strings] = sym__strings,
  [sym_string] = sym_string,
  [sym_comment] = sym_comment,
  [sym_line_comment] = sym_line_comment,
  [sym_comment_content] = sym_comment_content,
  [aux_sym_source_repeat1] = aux_sym_source_repeat1,
  [aux_sym_source_repeat2] = aux_sym_source_repeat2,
  [aux_sym_function_repeat1] = aux_sym_function_repeat1,
  [aux_sym__semicolon_separated_expressions_repeat1] = aux_sym__semicolon_separated_expressions_repeat1,
  [aux_sym__spec_repeat1] = aux_sym__spec_repeat1,
  [aux_sym_anonymous_function_repeat1] = aux_sym_anonymous_function_repeat1,
  [aux_sym_guard_repeat1] = aux_sym_guard_repeat1,
  [aux_sym_if_repeat1] = aux_sym_if_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym__quoted_atom_repeat1] = aux_sym__quoted_atom_repeat1,
  [aux_sym__strings_repeat1] = aux_sym__strings_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [alias_sym_function_clause] = alias_sym_function_clause,
  [alias_sym_map_content] = alias_sym_map_content,
  [alias_sym_record_content] = alias_sym_record_content,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shebang_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_define] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_spec] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_callback] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_band] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bxor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bsl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bsr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_andalso] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_orelse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_receive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_after] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_maybe] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_character_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_integer_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__atom] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_content] = {
    .visible = true,
    .named = true,
  },
  [sym_tripledot] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comment_token2] = {
    .visible = true,
    .named = true,
  },
  [sym_source] = {
    .visible = true,
    .named = true,
  },
  [sym_shebang] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__terminator] = {
    .visible = false,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym__macro_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__macro_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__semicolon_separated_expressions] = {
    .visible = true,
    .named = true,
  },
  [sym__spec] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_without_call] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bitstring] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_map] = {
    .visible = true,
    .named = true,
  },
  [sym__map_body] = {
    .visible = false,
    .named = true,
  },
  [sym_map_update] = {
    .visible = true,
    .named = true,
  },
  [sym_record] = {
    .visible = true,
    .named = true,
  },
  [sym__record_body] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_anonymous_function] = {
    .visible = true,
    .named = true,
  },
  [sym_stab_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__named_stab_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__anonymous_stab_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_guard] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__body] = {
    .visible = false,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym__items] = {
    .visible = false,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym__qualified_function] = {
    .visible = false,
    .named = true,
  },
  [sym__unqualified_function] = {
    .visible = false,
    .named = true,
  },
  [sym_function_capture] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym__if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_receive] = {
    .visible = true,
    .named = true,
  },
  [sym_after] = {
    .visible = true,
    .named = true,
  },
  [sym__body_after] = {
    .visible = true,
    .named = true,
  },
  [sym_try] = {
    .visible = true,
    .named = true,
  },
  [sym_maybe] = {
    .visible = true,
    .named = true,
  },
  [sym_character] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym__quoted_atom] = {
    .visible = false,
    .named = true,
  },
  [sym_macro] = {
    .visible = true,
    .named = true,
  },
  [sym__macro_constant] = {
    .visible = false,
    .named = true,
  },
  [sym__macro_call] = {
    .visible = false,
    .named = true,
  },
  [sym__strings] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_content] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_source_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__semicolon_separated_expressions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__spec_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anonymous_function_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_guard_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__quoted_atom_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__strings_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_function_clause] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_map_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_record_content] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_after = 1,
  field_arguments = 2,
  field_arity = 3,
  field_body = 4,
  field_catch = 5,
  field_else = 6,
  field_field = 7,
  field_function = 8,
  field_guard = 9,
  field_left = 10,
  field_left_paren = 11,
  field_module = 12,
  field_name = 13,
  field_of = 14,
  field_operand = 15,
  field_operator = 16,
  field_pattern = 17,
  field_quoted_end = 18,
  field_quoted_start = 19,
  field_right = 20,
  field_right_paren = 21,
  field_subject = 22,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_after] = "after",
  [field_arguments] = "arguments",
  [field_arity] = "arity",
  [field_body] = "body",
  [field_catch] = "catch",
  [field_else] = "else",
  [field_field] = "field",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_left] = "left",
  [field_left_paren] = "left_paren",
  [field_module] = "module",
  [field_name] = "name",
  [field_of] = "of",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_pattern] = "pattern",
  [field_quoted_end] = "quoted_end",
  [field_quoted_start] = "quoted_start",
  [field_right] = "right",
  [field_right_paren] = "right_paren",
  [field_subject] = "subject",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 4},
  [3] = {.index = 5, .length = 2},
  [4] = {.index = 7, .length = 1},
  [5] = {.index = 8, .length = 2},
  [6] = {.index = 10, .length = 1},
  [7] = {.index = 11, .length = 2},
  [8] = {.index = 13, .length = 2},
  [9] = {.index = 15, .length = 1},
  [10] = {.index = 1, .length = 4},
  [11] = {.index = 16, .length = 3},
  [12] = {.index = 19, .length = 2},
  [13] = {.index = 21, .length = 2},
  [14] = {.index = 23, .length = 2},
  [15] = {.index = 25, .length = 1},
  [16] = {.index = 26, .length = 2},
  [17] = {.index = 10, .length = 1},
  [18] = {.index = 28, .length = 2},
  [19] = {.index = 30, .length = 1},
  [20] = {.index = 31, .length = 2},
  [21] = {.index = 33, .length = 1},
  [22] = {.index = 34, .length = 3},
  [23] = {.index = 37, .length = 5},
  [24] = {.index = 42, .length = 2},
  [25] = {.index = 44, .length = 2},
  [26] = {.index = 46, .length = 4},
  [28] = {.index = 50, .length = 3},
  [29] = {.index = 53, .length = 2},
  [30] = {.index = 55, .length = 2},
  [31] = {.index = 57, .length = 3},
  [32] = {.index = 60, .length = 2},
  [33] = {.index = 62, .length = 2},
  [34] = {.index = 64, .length = 3},
  [35] = {.index = 67, .length = 4},
  [36] = {.index = 71, .length = 5},
  [37] = {.index = 10, .length = 1},
  [38] = {.index = 76, .length = 2},
  [39] = {.index = 15, .length = 1},
  [40] = {.index = 78, .length = 3},
  [41] = {.index = 81, .length = 3},
  [42] = {.index = 84, .length = 2},
  [43] = {.index = 86, .length = 4},
  [44] = {.index = 90, .length = 4},
  [45] = {.index = 94, .length = 4},
  [46] = {.index = 98, .length = 4},
  [47] = {.index = 102, .length = 4},
  [48] = {.index = 106, .length = 3},
  [49] = {.index = 109, .length = 5},
  [50] = {.index = 114, .length = 6},
  [51] = {.index = 120, .length = 7},
  [52] = {.index = 127, .length = 4},
  [53] = {.index = 10, .length = 1},
  [54] = {.index = 131, .length = 2},
  [56] = {.index = 76, .length = 2},
  [57] = {.index = 133, .length = 5},
  [58] = {.index = 138, .length = 5},
  [59] = {.index = 143, .length = 5},
  [60] = {.index = 148, .length = 6},
  [61] = {.index = 154, .length = 6},
  [62] = {.index = 160, .length = 6},
  [63] = {.index = 131, .length = 2},
  [64] = {.index = 166, .length = 7},
  [65] = {.index = 173, .length = 7},
  [66] = {.index = 180, .length = 7},
  [67] = {.index = 187, .length = 8},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_function, 0},
  [1] =
    {field_body, 0, .inherited = true},
    {field_guard, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [5] =
    {field_quoted_end, 0, .inherited = true},
    {field_quoted_start, 0, .inherited = true},
  [7] =
    {field_name, 0, .inherited = true},
  [8] =
    {field_arguments, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [10] =
    {field_name, 1},
  [11] =
    {field_operand, 1},
    {field_operator, 0},
  [13] =
    {field_field, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [15] =
    {field_name, 0},
  [16] =
    {field_body, 0, .inherited = true},
    {field_guard, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [19] =
    {field_quoted_end, 1},
    {field_quoted_start, 0},
  [21] =
    {field_module, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [23] =
    {field_function, 0, .inherited = true},
    {field_module, 0, .inherited = true},
  [25] =
    {field_function, 0, .inherited = true},
  [26] =
    {field_arguments, 1},
    {field_name, 0, .inherited = true},
  [28] =
    {field_left_paren, 0},
    {field_right_paren, 1},
  [30] =
    {field_subject, 1},
  [31] =
    {field_quoted_end, 2},
    {field_quoted_start, 0},
  [33] =
    {field_name, 2},
  [34] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [37] =
    {field_field, 2, .inherited = true},
    {field_left, 0},
    {field_name, 2, .inherited = true},
    {field_operator, 1},
    {field_right, 2},
  [42] =
    {field_function, 2},
    {field_module, 0},
  [44] =
    {field_field, 2, .inherited = true},
    {field_name, 2, .inherited = true},
  [46] =
    {field_body, 1, .inherited = true},
    {field_guard, 1, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_pattern, 1, .inherited = true},
  [50] =
    {field_field, 1},
    {field_field, 2},
    {field_name, 0},
  [53] =
    {field_left_paren, 0},
    {field_right_paren, 2},
  [55] =
    {field_body, 2},
    {field_pattern, 0},
  [57] =
    {field_arity, 3},
    {field_function, 1, .inherited = true},
    {field_module, 1, .inherited = true},
  [60] =
    {field_arity, 3},
    {field_function, 1, .inherited = true},
  [62] =
    {field_after, 2},
    {field_subject, 1},
  [64] =
    {field_body, 3},
    {field_name, 0},
    {field_pattern, 1},
  [67] =
    {field_body, 3},
    {field_name, 0},
    {field_name, 0, .inherited = true},
    {field_pattern, 1},
  [71] =
    {field_arguments, 0, .inherited = true},
    {field_body, 3},
    {field_name, 0},
    {field_name, 0, .inherited = true},
    {field_pattern, 1},
  [76] =
    {field_module, 2},
    {field_name, 1},
  [78] =
    {field_catch, 2},
    {field_catch, 3},
    {field_subject, 1},
  [81] =
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [84] =
    {field_else, 2},
    {field_else, 3},
  [86] =
    {field_body, 4},
    {field_guard, 1},
    {field_guard, 2},
    {field_pattern, 0},
  [90] =
    {field_after, 4},
    {field_catch, 2},
    {field_catch, 3},
    {field_subject, 1},
  [94] =
    {field_catch, 2},
    {field_catch, 3},
    {field_catch, 4},
    {field_subject, 1},
  [98] =
    {field_after, 4},
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [102] =
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
  [106] =
    {field_else, 2},
    {field_else, 3},
    {field_else, 4},
  [109] =
    {field_body, 5},
    {field_guard, 2},
    {field_guard, 3},
    {field_name, 0},
    {field_pattern, 1},
  [114] =
    {field_body, 5},
    {field_guard, 2},
    {field_guard, 3},
    {field_name, 0},
    {field_name, 0, .inherited = true},
    {field_pattern, 1},
  [120] =
    {field_arguments, 0, .inherited = true},
    {field_body, 5},
    {field_guard, 2},
    {field_guard, 3},
    {field_name, 0},
    {field_name, 0, .inherited = true},
    {field_pattern, 1},
  [127] =
    {field_body, 3, .inherited = true},
    {field_guard, 3, .inherited = true},
    {field_name, 3, .inherited = true},
    {field_pattern, 3, .inherited = true},
  [131] =
    {field_module, 3},
    {field_name, 1},
  [133] =
    {field_after, 5},
    {field_catch, 2},
    {field_catch, 3},
    {field_catch, 4},
    {field_subject, 1},
  [138] =
    {field_catch, 4},
    {field_catch, 5},
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [143] =
    {field_after, 5},
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
  [148] =
    {field_after, 6},
    {field_catch, 4},
    {field_catch, 5},
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [154] =
    {field_catch, 4},
    {field_catch, 5},
    {field_catch, 6},
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [160] =
    {field_catch, 5},
    {field_catch, 6},
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
  [166] =
    {field_after, 7},
    {field_catch, 4},
    {field_catch, 5},
    {field_catch, 6},
    {field_of, 2},
    {field_of, 3},
    {field_subject, 1},
  [173] =
    {field_after, 7},
    {field_catch, 5},
    {field_catch, 6},
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
  [180] =
    {field_catch, 5},
    {field_catch, 6},
    {field_catch, 7},
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
  [187] =
    {field_after, 8},
    {field_catch, 5},
    {field_catch, 6},
    {field_catch, 7},
    {field_of, 2},
    {field_of, 3},
    {field_of, 4},
    {field_subject, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = alias_sym_function_clause,
  },
  [17] = {
    [2] = sym_arguments,
  },
  [23] = {
    [2] = sym_record,
  },
  [26] = {
    [1] = alias_sym_function_clause,
  },
  [27] = {
    [1] = alias_sym_map_content,
  },
  [35] = {
    [0] = sym_macro,
  },
  [36] = {
    [0] = sym_macro,
  },
  [37] = {
    [4] = sym_guard,
  },
  [39] = {
    [2] = alias_sym_record_content,
  },
  [50] = {
    [0] = sym_macro,
  },
  [51] = {
    [0] = sym_macro,
  },
  [52] = {
    [3] = sym_function,
  },
  [53] = {
    [5] = sym_guard,
  },
  [55] = {
    [3] = sym_guard,
  },
  [56] = {
    [6] = sym_guard,
  },
  [63] = {
    [7] = sym_guard,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__record_body, 2,
    sym__record_body,
    sym_record,
  sym__named_stab_clause, 3,
    sym__named_stab_clause,
    alias_sym_function_clause,
    sym_function,
  sym__items, 5,
    sym__items,
    alias_sym_map_content,
    alias_sym_record_content,
    sym_arguments,
    sym_guard,
  sym__macro_constant, 2,
    sym__macro_constant,
    sym_macro,
  sym__macro_call, 2,
    sym__macro_call,
    sym_macro,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 5,
  [6] = 2,
  [7] = 2,
  [8] = 4,
  [9] = 2,
  [10] = 2,
  [11] = 2,
  [12] = 2,
  [13] = 2,
  [14] = 2,
  [15] = 2,
  [16] = 2,
  [17] = 4,
  [18] = 2,
  [19] = 2,
  [20] = 2,
  [21] = 2,
  [22] = 2,
  [23] = 2,
  [24] = 2,
  [25] = 2,
  [26] = 2,
  [27] = 2,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 36,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 34,
  [48] = 39,
  [49] = 32,
  [50] = 37,
  [51] = 29,
  [52] = 38,
  [53] = 33,
  [54] = 30,
  [55] = 29,
  [56] = 29,
  [57] = 31,
  [58] = 32,
  [59] = 31,
  [60] = 35,
  [61] = 38,
  [62] = 35,
  [63] = 34,
  [64] = 37,
  [65] = 33,
  [66] = 45,
  [67] = 39,
  [68] = 30,
  [69] = 36,
  [70] = 39,
  [71] = 37,
  [72] = 38,
  [73] = 33,
  [74] = 35,
  [75] = 32,
  [76] = 76,
  [77] = 29,
  [78] = 31,
  [79] = 29,
  [80] = 44,
  [81] = 36,
  [82] = 46,
  [83] = 34,
  [84] = 30,
  [85] = 45,
  [86] = 39,
  [87] = 87,
  [88] = 30,
  [89] = 36,
  [90] = 31,
  [91] = 91,
  [92] = 92,
  [93] = 35,
  [94] = 91,
  [95] = 46,
  [96] = 44,
  [97] = 38,
  [98] = 37,
  [99] = 37,
  [100] = 38,
  [101] = 33,
  [102] = 32,
  [103] = 34,
  [104] = 36,
  [105] = 34,
  [106] = 32,
  [107] = 33,
  [108] = 35,
  [109] = 30,
  [110] = 39,
  [111] = 31,
  [112] = 29,
  [113] = 32,
  [114] = 114,
  [115] = 115,
  [116] = 38,
  [117] = 33,
  [118] = 35,
  [119] = 34,
  [120] = 37,
  [121] = 36,
  [122] = 30,
  [123] = 39,
  [124] = 115,
  [125] = 115,
  [126] = 126,
  [127] = 127,
  [128] = 31,
  [129] = 126,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 134,
  [142] = 142,
  [143] = 137,
  [144] = 138,
  [145] = 139,
  [146] = 134,
  [147] = 147,
  [148] = 142,
  [149] = 149,
  [150] = 136,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 136,
  [156] = 135,
  [157] = 142,
  [158] = 134,
  [159] = 131,
  [160] = 160,
  [161] = 153,
  [162] = 152,
  [163] = 151,
  [164] = 131,
  [165] = 147,
  [166] = 149,
  [167] = 131,
  [168] = 131,
  [169] = 147,
  [170] = 170,
  [171] = 151,
  [172] = 137,
  [173] = 138,
  [174] = 139,
  [175] = 134,
  [176] = 132,
  [177] = 142,
  [178] = 136,
  [179] = 179,
  [180] = 133,
  [181] = 181,
  [182] = 142,
  [183] = 149,
  [184] = 153,
  [185] = 133,
  [186] = 147,
  [187] = 147,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 154,
  [192] = 192,
  [193] = 179,
  [194] = 194,
  [195] = 152,
  [196] = 135,
  [197] = 140,
  [198] = 198,
  [199] = 139,
  [200] = 200,
  [201] = 201,
  [202] = 138,
  [203] = 151,
  [204] = 204,
  [205] = 205,
  [206] = 192,
  [207] = 181,
  [208] = 151,
  [209] = 136,
  [210] = 205,
  [211] = 137,
  [212] = 131,
  [213] = 131,
  [214] = 149,
  [215] = 215,
  [216] = 131,
  [217] = 217,
  [218] = 218,
  [219] = 170,
  [220] = 194,
  [221] = 137,
  [222] = 217,
  [223] = 223,
  [224] = 138,
  [225] = 204,
  [226] = 200,
  [227] = 198,
  [228] = 154,
  [229] = 189,
  [230] = 188,
  [231] = 190,
  [232] = 131,
  [233] = 139,
  [234] = 149,
  [235] = 223,
  [236] = 140,
  [237] = 179,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 239,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 245,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 246,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 245,
  [264] = 247,
  [265] = 248,
  [266] = 245,
  [267] = 250,
  [268] = 251,
  [269] = 252,
  [270] = 246,
  [271] = 254,
  [272] = 255,
  [273] = 256,
  [274] = 250,
  [275] = 257,
  [276] = 258,
  [277] = 259,
  [278] = 260,
  [279] = 261,
  [280] = 247,
  [281] = 248,
  [282] = 245,
  [283] = 250,
  [284] = 251,
  [285] = 252,
  [286] = 246,
  [287] = 254,
  [288] = 255,
  [289] = 256,
  [290] = 257,
  [291] = 258,
  [292] = 260,
  [293] = 259,
  [294] = 259,
  [295] = 260,
  [296] = 261,
  [297] = 247,
  [298] = 248,
  [299] = 245,
  [300] = 250,
  [301] = 251,
  [302] = 252,
  [303] = 258,
  [304] = 246,
  [305] = 254,
  [306] = 255,
  [307] = 256,
  [308] = 257,
  [309] = 257,
  [310] = 258,
  [311] = 259,
  [312] = 256,
  [313] = 260,
  [314] = 261,
  [315] = 247,
  [316] = 248,
  [317] = 245,
  [318] = 255,
  [319] = 319,
  [320] = 262,
  [321] = 250,
  [322] = 251,
  [323] = 252,
  [324] = 246,
  [325] = 254,
  [326] = 255,
  [327] = 256,
  [328] = 257,
  [329] = 250,
  [330] = 258,
  [331] = 331,
  [332] = 259,
  [333] = 260,
  [334] = 261,
  [335] = 247,
  [336] = 248,
  [337] = 245,
  [338] = 250,
  [339] = 251,
  [340] = 252,
  [341] = 246,
  [342] = 254,
  [343] = 254,
  [344] = 246,
  [345] = 255,
  [346] = 256,
  [347] = 257,
  [348] = 258,
  [349] = 252,
  [350] = 259,
  [351] = 260,
  [352] = 261,
  [353] = 247,
  [354] = 248,
  [355] = 245,
  [356] = 250,
  [357] = 251,
  [358] = 251,
  [359] = 252,
  [360] = 246,
  [361] = 254,
  [362] = 255,
  [363] = 363,
  [364] = 364,
  [365] = 255,
  [366] = 256,
  [367] = 257,
  [368] = 258,
  [369] = 259,
  [370] = 260,
  [371] = 261,
  [372] = 247,
  [373] = 248,
  [374] = 248,
  [375] = 250,
  [376] = 251,
  [377] = 252,
  [378] = 246,
  [379] = 254,
  [380] = 331,
  [381] = 245,
  [382] = 363,
  [383] = 364,
  [384] = 251,
  [385] = 252,
  [386] = 246,
  [387] = 364,
  [388] = 363,
  [389] = 254,
  [390] = 331,
  [391] = 257,
  [392] = 258,
  [393] = 259,
  [394] = 248,
  [395] = 395,
  [396] = 260,
  [397] = 395,
  [398] = 261,
  [399] = 247,
  [400] = 256,
  [401] = 255,
  [402] = 364,
  [403] = 363,
  [404] = 255,
  [405] = 256,
  [406] = 257,
  [407] = 255,
  [408] = 258,
  [409] = 259,
  [410] = 260,
  [411] = 261,
  [412] = 247,
  [413] = 261,
  [414] = 260,
  [415] = 256,
  [416] = 247,
  [417] = 248,
  [418] = 245,
  [419] = 250,
  [420] = 251,
  [421] = 331,
  [422] = 254,
  [423] = 246,
  [424] = 252,
  [425] = 257,
  [426] = 251,
  [427] = 259,
  [428] = 258,
  [429] = 252,
  [430] = 331,
  [431] = 254,
  [432] = 246,
  [433] = 252,
  [434] = 251,
  [435] = 250,
  [436] = 245,
  [437] = 248,
  [438] = 247,
  [439] = 261,
  [440] = 260,
  [441] = 259,
  [442] = 258,
  [443] = 257,
  [444] = 250,
  [445] = 258,
  [446] = 246,
  [447] = 245,
  [448] = 248,
  [449] = 259,
  [450] = 260,
  [451] = 255,
  [452] = 261,
  [453] = 257,
  [454] = 256,
  [455] = 254,
  [456] = 247,
  [457] = 261,
  [458] = 363,
  [459] = 260,
  [460] = 259,
  [461] = 258,
  [462] = 256,
  [463] = 255,
  [464] = 257,
  [465] = 256,
  [466] = 257,
  [467] = 258,
  [468] = 259,
  [469] = 260,
  [470] = 256,
  [471] = 261,
  [472] = 247,
  [473] = 248,
  [474] = 247,
  [475] = 245,
  [476] = 250,
  [477] = 248,
  [478] = 245,
  [479] = 250,
  [480] = 251,
  [481] = 252,
  [482] = 246,
  [483] = 254,
  [484] = 331,
  [485] = 255,
  [486] = 363,
  [487] = 364,
  [488] = 255,
  [489] = 256,
  [490] = 257,
  [491] = 251,
  [492] = 255,
  [493] = 252,
  [494] = 246,
  [495] = 254,
  [496] = 364,
  [497] = 363,
  [498] = 331,
  [499] = 258,
  [500] = 259,
  [501] = 254,
  [502] = 246,
  [503] = 252,
  [504] = 251,
  [505] = 250,
  [506] = 245,
  [507] = 248,
  [508] = 364,
  [509] = 255,
  [510] = 247,
  [511] = 261,
  [512] = 260,
  [513] = 259,
  [514] = 258,
  [515] = 257,
  [516] = 256,
  [517] = 255,
  [518] = 364,
  [519] = 363,
  [520] = 256,
  [521] = 331,
  [522] = 254,
  [523] = 257,
  [524] = 258,
  [525] = 363,
  [526] = 260,
  [527] = 364,
  [528] = 261,
  [529] = 246,
  [530] = 259,
  [531] = 260,
  [532] = 261,
  [533] = 257,
  [534] = 256,
  [535] = 364,
  [536] = 247,
  [537] = 363,
  [538] = 247,
  [539] = 248,
  [540] = 248,
  [541] = 245,
  [542] = 250,
  [543] = 331,
  [544] = 251,
  [545] = 245,
  [546] = 252,
  [547] = 254,
  [548] = 246,
  [549] = 250,
  [550] = 246,
  [551] = 251,
  [552] = 254,
  [553] = 331,
  [554] = 255,
  [555] = 256,
  [556] = 257,
  [557] = 258,
  [558] = 252,
  [559] = 251,
  [560] = 250,
  [561] = 252,
  [562] = 259,
  [563] = 245,
  [564] = 248,
  [565] = 260,
  [566] = 247,
  [567] = 261,
  [568] = 260,
  [569] = 261,
  [570] = 247,
  [571] = 259,
  [572] = 258,
  [573] = 573,
  [574] = 248,
  [575] = 257,
  [576] = 245,
  [577] = 250,
  [578] = 256,
  [579] = 255,
  [580] = 364,
  [581] = 258,
  [582] = 259,
  [583] = 260,
  [584] = 261,
  [585] = 247,
  [586] = 248,
  [587] = 245,
  [588] = 250,
  [589] = 251,
  [590] = 252,
  [591] = 246,
  [592] = 254,
  [593] = 331,
  [594] = 331,
  [595] = 254,
  [596] = 246,
  [597] = 252,
  [598] = 251,
  [599] = 250,
  [600] = 245,
  [601] = 248,
  [602] = 251,
  [603] = 247,
  [604] = 261,
  [605] = 260,
  [606] = 259,
  [607] = 258,
  [608] = 252,
  [609] = 261,
  [610] = 257,
  [611] = 611,
  [612] = 254,
  [613] = 256,
  [614] = 255,
  [615] = 331,
  [616] = 319,
  [617] = 363,
  [618] = 618,
  [619] = 619,
  [620] = 29,
  [621] = 39,
  [622] = 31,
  [623] = 38,
  [624] = 35,
  [625] = 34,
  [626] = 39,
  [627] = 33,
  [628] = 37,
  [629] = 33,
  [630] = 32,
  [631] = 36,
  [632] = 32,
  [633] = 30,
  [634] = 37,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 641,
  [643] = 643,
  [644] = 643,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 648,
  [690] = 649,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 619,
  [713] = 618,
  [714] = 619,
  [715] = 618,
  [716] = 29,
  [717] = 34,
  [718] = 32,
  [719] = 30,
  [720] = 31,
  [721] = 38,
  [722] = 35,
  [723] = 36,
  [724] = 33,
  [725] = 39,
  [726] = 37,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 635,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 637,
  [738] = 636,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 739,
  [750] = 639,
  [751] = 640,
  [752] = 641,
  [753] = 32,
  [754] = 747,
  [755] = 648,
  [756] = 756,
  [757] = 736,
  [758] = 641,
  [759] = 678,
  [760] = 688,
  [761] = 648,
  [762] = 33,
  [763] = 643,
  [764] = 727,
  [765] = 731,
  [766] = 732,
  [767] = 735,
  [768] = 641,
  [769] = 728,
  [770] = 739,
  [771] = 639,
  [772] = 740,
  [773] = 742,
  [774] = 743,
  [775] = 775,
  [776] = 776,
  [777] = 638,
  [778] = 747,
  [779] = 37,
  [780] = 780,
  [781] = 744,
  [782] = 736,
  [783] = 727,
  [784] = 731,
  [785] = 732,
  [786] = 735,
  [787] = 728,
  [788] = 734,
  [789] = 730,
  [790] = 748,
  [791] = 739,
  [792] = 745,
  [793] = 746,
  [794] = 775,
  [795] = 740,
  [796] = 742,
  [797] = 734,
  [798] = 730,
  [799] = 748,
  [800] = 743,
  [801] = 744,
  [802] = 745,
  [803] = 746,
  [804] = 643,
  [805] = 641,
  [806] = 747,
  [807] = 736,
  [808] = 727,
  [809] = 731,
  [810] = 732,
  [811] = 735,
  [812] = 728,
  [813] = 740,
  [814] = 742,
  [815] = 648,
  [816] = 743,
  [817] = 648,
  [818] = 729,
  [819] = 688,
  [820] = 678,
  [821] = 39,
  [822] = 746,
  [823] = 745,
  [824] = 646,
  [825] = 744,
  [826] = 743,
  [827] = 638,
  [828] = 736,
  [829] = 742,
  [830] = 747,
  [831] = 740,
  [832] = 739,
  [833] = 728,
  [834] = 735,
  [835] = 732,
  [836] = 731,
  [837] = 727,
  [838] = 736,
  [839] = 747,
  [840] = 840,
  [841] = 776,
  [842] = 702,
  [843] = 701,
  [844] = 700,
  [845] = 699,
  [846] = 698,
  [847] = 697,
  [848] = 695,
  [849] = 694,
  [850] = 693,
  [851] = 692,
  [852] = 691,
  [853] = 687,
  [854] = 686,
  [855] = 685,
  [856] = 684,
  [857] = 647,
  [858] = 731,
  [859] = 683,
  [860] = 732,
  [861] = 735,
  [862] = 728,
  [863] = 739,
  [864] = 740,
  [865] = 742,
  [866] = 656,
  [867] = 645,
  [868] = 746,
  [869] = 745,
  [870] = 744,
  [871] = 743,
  [872] = 742,
  [873] = 747,
  [874] = 740,
  [875] = 736,
  [876] = 727,
  [877] = 731,
  [878] = 732,
  [879] = 735,
  [880] = 728,
  [881] = 739,
  [882] = 740,
  [883] = 742,
  [884] = 743,
  [885] = 744,
  [886] = 739,
  [887] = 745,
  [888] = 746,
  [889] = 728,
  [890] = 744,
  [891] = 735,
  [892] = 732,
  [893] = 731,
  [894] = 727,
  [895] = 736,
  [896] = 747,
  [897] = 682,
  [898] = 680,
  [899] = 679,
  [900] = 675,
  [901] = 746,
  [902] = 638,
  [903] = 727,
  [904] = 640,
  [905] = 745,
  [906] = 646,
  [907] = 640,
  [908] = 743,
  [909] = 729,
  [910] = 653,
  [911] = 744,
  [912] = 745,
  [913] = 744,
  [914] = 746,
  [915] = 743,
  [916] = 742,
  [917] = 740,
  [918] = 739,
  [919] = 728,
  [920] = 735,
  [921] = 732,
  [922] = 731,
  [923] = 727,
  [924] = 736,
  [925] = 747,
  [926] = 674,
  [927] = 673,
  [928] = 681,
  [929] = 672,
  [930] = 671,
  [931] = 775,
  [932] = 745,
  [933] = 670,
  [934] = 669,
  [935] = 668,
  [936] = 667,
  [937] = 937,
  [938] = 746,
  [939] = 776,
  [940] = 748,
  [941] = 730,
  [942] = 734,
  [943] = 741,
  [944] = 734,
  [945] = 705,
  [946] = 706,
  [947] = 707,
  [948] = 748,
  [949] = 730,
  [950] = 734,
  [951] = 710,
  [952] = 711,
  [953] = 730,
  [954] = 709,
  [955] = 708,
  [956] = 704,
  [957] = 703,
  [958] = 696,
  [959] = 748,
  [960] = 649,
  [961] = 677,
  [962] = 676,
  [963] = 649,
  [964] = 666,
  [965] = 650,
  [966] = 665,
  [967] = 664,
  [968] = 651,
  [969] = 652,
  [970] = 663,
  [971] = 662,
  [972] = 661,
  [973] = 660,
  [974] = 659,
  [975] = 658,
  [976] = 654,
  [977] = 657,
  [978] = 655,
  [979] = 732,
  [980] = 747,
  [981] = 734,
  [982] = 730,
  [983] = 748,
  [984] = 734,
  [985] = 730,
  [986] = 748,
  [987] = 741,
  [988] = 746,
  [989] = 745,
  [990] = 744,
  [991] = 743,
  [992] = 742,
  [993] = 740,
  [994] = 739,
  [995] = 728,
  [996] = 996,
  [997] = 735,
  [998] = 732,
  [999] = 747,
  [1000] = 731,
  [1001] = 736,
  [1002] = 727,
  [1003] = 731,
  [1004] = 732,
  [1005] = 735,
  [1006] = 728,
  [1007] = 739,
  [1008] = 740,
  [1009] = 742,
  [1010] = 743,
  [1011] = 744,
  [1012] = 727,
  [1013] = 745,
  [1014] = 746,
  [1015] = 736,
  [1016] = 747,
  [1017] = 741,
  [1018] = 746,
  [1019] = 745,
  [1020] = 744,
  [1021] = 743,
  [1022] = 742,
  [1023] = 740,
  [1024] = 739,
  [1025] = 728,
  [1026] = 735,
  [1027] = 732,
  [1028] = 731,
  [1029] = 727,
  [1030] = 736,
  [1031] = 747,
  [1032] = 775,
  [1033] = 775,
  [1034] = 734,
  [1035] = 730,
  [1036] = 748,
  [1037] = 775,
  [1038] = 776,
  [1039] = 775,
  [1040] = 746,
  [1041] = 745,
  [1042] = 744,
  [1043] = 743,
  [1044] = 742,
  [1045] = 740,
  [1046] = 739,
  [1047] = 728,
  [1048] = 735,
  [1049] = 732,
  [1050] = 731,
  [1051] = 727,
  [1052] = 736,
  [1053] = 776,
  [1054] = 734,
  [1055] = 747,
  [1056] = 736,
  [1057] = 730,
  [1058] = 748,
  [1059] = 727,
  [1060] = 731,
  [1061] = 735,
  [1062] = 728,
  [1063] = 739,
  [1064] = 740,
  [1065] = 742,
  [1066] = 743,
  [1067] = 775,
  [1068] = 744,
  [1069] = 1069,
  [1070] = 745,
  [1071] = 746,
  [1072] = 746,
  [1073] = 745,
  [1074] = 744,
  [1075] = 743,
  [1076] = 742,
  [1077] = 740,
  [1078] = 739,
  [1079] = 728,
  [1080] = 735,
  [1081] = 732,
  [1082] = 731,
  [1083] = 727,
  [1084] = 736,
  [1085] = 775,
  [1086] = 747,
  [1087] = 746,
  [1088] = 745,
  [1089] = 744,
  [1090] = 743,
  [1091] = 742,
  [1092] = 740,
  [1093] = 739,
  [1094] = 728,
  [1095] = 735,
  [1096] = 732,
  [1097] = 731,
  [1098] = 727,
  [1099] = 736,
  [1100] = 747,
  [1101] = 728,
  [1102] = 736,
  [1103] = 746,
  [1104] = 776,
  [1105] = 1105,
  [1106] = 776,
  [1107] = 776,
  [1108] = 745,
  [1109] = 744,
  [1110] = 743,
  [1111] = 742,
  [1112] = 740,
  [1113] = 739,
  [1114] = 728,
  [1115] = 735,
  [1116] = 741,
  [1117] = 732,
  [1118] = 731,
  [1119] = 727,
  [1120] = 747,
  [1121] = 736,
  [1122] = 727,
  [1123] = 731,
  [1124] = 732,
  [1125] = 776,
  [1126] = 735,
  [1127] = 728,
  [1128] = 739,
  [1129] = 740,
  [1130] = 742,
  [1131] = 743,
  [1132] = 744,
  [1133] = 745,
  [1134] = 746,
  [1135] = 776,
  [1136] = 735,
  [1137] = 731,
  [1138] = 727,
  [1139] = 746,
  [1140] = 732,
  [1141] = 736,
  [1142] = 731,
  [1143] = 727,
  [1144] = 736,
  [1145] = 746,
  [1146] = 745,
  [1147] = 747,
  [1148] = 747,
  [1149] = 747,
  [1150] = 744,
  [1151] = 744,
  [1152] = 741,
  [1153] = 776,
  [1154] = 776,
  [1155] = 743,
  [1156] = 743,
  [1157] = 745,
  [1158] = 742,
  [1159] = 742,
  [1160] = 740,
  [1161] = 740,
  [1162] = 739,
  [1163] = 728,
  [1164] = 739,
  [1165] = 735,
  [1166] = 732,
  [1167] = 736,
  [1168] = 732,
  [1169] = 748,
  [1170] = 744,
  [1171] = 734,
  [1172] = 727,
  [1173] = 730,
  [1174] = 743,
  [1175] = 747,
  [1176] = 776,
  [1177] = 742,
  [1178] = 740,
  [1179] = 745,
  [1180] = 739,
  [1181] = 728,
  [1182] = 746,
  [1183] = 735,
  [1184] = 731,
  [1185] = 743,
  [1186] = 1186,
  [1187] = 745,
  [1188] = 1188,
  [1189] = 739,
  [1190] = 747,
  [1191] = 1191,
  [1192] = 740,
  [1193] = 742,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 746,
  [1197] = 1186,
  [1198] = 728,
  [1199] = 732,
  [1200] = 744,
  [1201] = 1195,
  [1202] = 735,
  [1203] = 736,
  [1204] = 1188,
  [1205] = 727,
  [1206] = 731,
  [1207] = 1207,
  [1208] = 1207,
  [1209] = 1207,
  [1210] = 1207,
  [1211] = 1207,
  [1212] = 1207,
  [1213] = 1207,
  [1214] = 1207,
  [1215] = 1207,
  [1216] = 1207,
  [1217] = 1207,
  [1218] = 1207,
  [1219] = 1207,
  [1220] = 1207,
  [1221] = 1207,
  [1222] = 1207,
  [1223] = 1207,
  [1224] = 1207,
  [1225] = 1207,
  [1226] = 1207,
  [1227] = 1207,
  [1228] = 1207,
  [1229] = 1229,
  [1230] = 1230,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1237,
  [1239] = 1237,
  [1240] = 1237,
  [1241] = 1237,
  [1242] = 1237,
  [1243] = 1237,
  [1244] = 1237,
  [1245] = 1237,
  [1246] = 1237,
  [1247] = 1237,
  [1248] = 1237,
  [1249] = 1237,
  [1250] = 1237,
  [1251] = 1237,
  [1252] = 1237,
  [1253] = 1237,
  [1254] = 1237,
  [1255] = 1237,
  [1256] = 1237,
  [1257] = 1237,
  [1258] = 1237,
  [1259] = 1259,
  [1260] = 1260,
  [1261] = 1261,
  [1262] = 1260,
  [1263] = 1260,
  [1264] = 1264,
  [1265] = 1264,
  [1266] = 1264,
  [1267] = 1267,
  [1268] = 1268,
  [1269] = 1269,
  [1270] = 1268,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1272,
  [1274] = 1268,
  [1275] = 1275,
  [1276] = 1275,
  [1277] = 1275,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1279,
  [1281] = 1279,
  [1282] = 1278,
  [1283] = 1283,
  [1284] = 1284,
  [1285] = 1285,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1287,
  [1289] = 1286,
  [1290] = 1286,
  [1291] = 1286,
  [1292] = 1292,
  [1293] = 1292,
  [1294] = 1286,
  [1295] = 1284,
  [1296] = 1284,
  [1297] = 1286,
  [1298] = 1298,
  [1299] = 1298,
  [1300] = 1286,
  [1301] = 1286,
  [1302] = 1286,
  [1303] = 1286,
  [1304] = 1286,
  [1305] = 1305,
  [1306] = 1306,
  [1307] = 1307,
  [1308] = 1308,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1311,
  [1312] = 1298,
  [1313] = 1285,
  [1314] = 1314,
  [1315] = 1315,
  [1316] = 1316,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1319,
  [1320] = 1298,
  [1321] = 1314,
  [1322] = 1298,
  [1323] = 1314,
  [1324] = 1314,
  [1325] = 1325,
  [1326] = 1307,
  [1327] = 1327,
  [1328] = 1325,
  [1329] = 1329,
  [1330] = 1310,
  [1331] = 1331,
  [1332] = 44,
  [1333] = 1333,
  [1334] = 1309,
  [1335] = 1314,
  [1336] = 1314,
  [1337] = 1337,
  [1338] = 1284,
  [1339] = 1284,
  [1340] = 1314,
  [1341] = 1329,
  [1342] = 1333,
  [1343] = 44,
  [1344] = 1284,
  [1345] = 1331,
  [1346] = 1346,
  [1347] = 1347,
  [1348] = 44,
  [1349] = 1349,
  [1350] = 1305,
  [1351] = 1346,
  [1352] = 1284,
  [1353] = 1314,
  [1354] = 1314,
  [1355] = 1355,
  [1356] = 1314,
  [1357] = 1314,
  [1358] = 1358,
  [1359] = 1298,
  [1360] = 1358,
  [1361] = 1361,
  [1362] = 1361,
  [1363] = 45,
  [1364] = 1361,
  [1365] = 46,
  [1366] = 1358,
  [1367] = 1361,
  [1368] = 1358,
  [1369] = 1284,
  [1370] = 1370,
  [1371] = 1371,
  [1372] = 1285,
  [1373] = 1361,
  [1374] = 1284,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 1311,
  [1378] = 1378,
  [1379] = 1298,
  [1380] = 1380,
  [1381] = 1358,
  [1382] = 1361,
  [1383] = 1284,
  [1384] = 44,
  [1385] = 1385,
  [1386] = 1386,
  [1387] = 1358,
  [1388] = 1284,
  [1389] = 1389,
  [1390] = 729,
  [1391] = 1285,
  [1392] = 1361,
  [1393] = 45,
  [1394] = 46,
  [1395] = 1361,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1358,
  [1399] = 1358,
  [1400] = 1284,
  [1401] = 1361,
  [1402] = 1298,
  [1403] = 1385,
  [1404] = 1386,
  [1405] = 1361,
  [1406] = 1285,
  [1407] = 1358,
  [1408] = 1298,
  [1409] = 1361,
  [1410] = 1358,
  [1411] = 46,
  [1412] = 45,
  [1413] = 1284,
  [1414] = 1358,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 1417,
  [1418] = 1418,
  [1419] = 44,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1422,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1426,
  [1427] = 1427,
  [1428] = 1424,
  [1429] = 1429,
  [1430] = 1430,
  [1431] = 1431,
  [1432] = 1432,
  [1433] = 1433,
  [1434] = 1434,
  [1435] = 1435,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 1438,
  [1439] = 1439,
  [1440] = 1440,
  [1441] = 1431,
  [1442] = 1285,
  [1443] = 1443,
  [1444] = 1418,
  [1445] = 1445,
  [1446] = 1446,
  [1447] = 1447,
  [1448] = 1448,
  [1449] = 1449,
  [1450] = 46,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1430,
  [1454] = 1454,
  [1455] = 1455,
  [1456] = 1421,
  [1457] = 1457,
  [1458] = 1431,
  [1459] = 1459,
  [1460] = 1460,
  [1461] = 1455,
  [1462] = 45,
  [1463] = 729,
  [1464] = 1464,
  [1465] = 1422,
  [1466] = 1466,
  [1467] = 1452,
  [1468] = 1311,
  [1469] = 1469,
  [1470] = 1454,
  [1471] = 1459,
  [1472] = 1472,
  [1473] = 1473,
  [1474] = 1464,
  [1475] = 1445,
  [1476] = 1451,
  [1477] = 1477,
  [1478] = 1469,
  [1479] = 1427,
  [1480] = 1480,
  [1481] = 29,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1484,
  [1485] = 1485,
  [1486] = 1484,
  [1487] = 1487,
  [1488] = 1488,
  [1489] = 1489,
  [1490] = 1490,
  [1491] = 1491,
  [1492] = 1492,
  [1493] = 1483,
  [1494] = 1482,
  [1495] = 1495,
  [1496] = 1484,
  [1497] = 1497,
  [1498] = 1482,
  [1499] = 1499,
  [1500] = 1488,
  [1501] = 1501,
  [1502] = 1502,
  [1503] = 1483,
  [1504] = 1501,
  [1505] = 1502,
  [1506] = 1501,
  [1507] = 1499,
  [1508] = 1499,
  [1509] = 1509,
  [1510] = 1488,
  [1511] = 1492,
  [1512] = 1512,
  [1513] = 1489,
  [1514] = 1514,
  [1515] = 1484,
  [1516] = 1516,
  [1517] = 1501,
  [1518] = 1487,
  [1519] = 1512,
  [1520] = 1499,
  [1521] = 1492,
  [1522] = 1522,
  [1523] = 1492,
  [1524] = 1499,
  [1525] = 1502,
  [1526] = 1526,
  [1527] = 1492,
  [1528] = 1501,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1530,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1530,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1530,
  [1539] = 1533,
  [1540] = 1540,
  [1541] = 1541,
  [1542] = 1533,
  [1543] = 1530,
  [1544] = 1532,
  [1545] = 1533,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 1530,
  [1552] = 1533,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1530,
  [1556] = 1556,
  [1557] = 1557,
  [1558] = 1530,
  [1559] = 1533,
  [1560] = 1560,
  [1561] = 1533,
  [1562] = 1550,
  [1563] = 1550,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1533,
  [1567] = 1530,
  [1568] = 1568,
  [1569] = 1530,
  [1570] = 1533,
  [1571] = 1571,
  [1572] = 1572,
  [1573] = 1573,
  [1574] = 1550,
  [1575] = 1535,
  [1576] = 1576,
  [1577] = 1536,
  [1578] = 1578,
  [1579] = 1537,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1576,
  [1585] = 1578,
  [1586] = 1586,
  [1587] = 1587,
  [1588] = 1533,
  [1589] = 1530,
  [1590] = 1549,
  [1591] = 1591,
  [1592] = 1580,
  [1593] = 1593,
  [1594] = 1533,
  [1595] = 1581,
  [1596] = 1533,
  [1597] = 1530,
  [1598] = 1598,
  [1599] = 1533,
  [1600] = 1530,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 1540,
  [1604] = 1549,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1541,
  [1608] = 1553,
  [1609] = 1530,
  [1610] = 1533,
  [1611] = 1611,
  [1612] = 1530,
  [1613] = 1613,
  [1614] = 1573,
  [1615] = 1533,
  [1616] = 1550,
  [1617] = 1602,
  [1618] = 1618,
  [1619] = 1619,
  [1620] = 1560,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1613,
  [1627] = 1546,
  [1628] = 1628,
  [1629] = 1533,
  [1630] = 1530,
  [1631] = 1550,
  [1632] = 1611,
  [1633] = 1606,
  [1634] = 1591,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1568,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1587,
  [1641] = 1530,
  [1642] = 1533,
  [1643] = 1586,
  [1644] = 1229,
  [1645] = 1645,
  [1646] = 1550,
  [1647] = 1647,
  [1648] = 1550,
  [1649] = 1530,
  [1650] = 1530,
  [1651] = 1533,
  [1652] = 1550,
  [1653] = 1533,
  [1654] = 1582,
  [1655] = 1530,
  [1656] = 1530,
  [1657] = 1657,
  [1658] = 1533,
  [1659] = 1576,
  [1660] = 1549,
  [1661] = 1582,
  [1662] = 1657,
  [1663] = 1581,
  [1664] = 1581,
  [1665] = 1582,
  [1666] = 1549,
  [1667] = 1580,
  [1668] = 1533,
  [1669] = 1533,
  [1670] = 1530,
  [1671] = 1647,
  [1672] = 1581,
  [1673] = 1582,
  [1674] = 1674,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(81);
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(114);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(116);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(149);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(153);
      if (lookahead == '?') ADVANCE(287);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == 'a') ADVANCE(230);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(200);
      if (lookahead == 'd') ADVANCE(223);
      if (lookahead == 'e') ADVANCE(243);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'o') ADVANCE(233);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 's') ADVANCE(261);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == 'w') ADVANCE(237);
      if (lookahead == 'x') ADVANCE(258);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if (lookahead == '}') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(79)
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(116);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(149);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(153);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'o') ADVANCE(262);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == 'w') ADVANCE(237);
      if (lookahead == 'x') ADVANCE(258);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if (lookahead == '}') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('e' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(116);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(149);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(152);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == 'a') ADVANCE(230);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(253);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'o') ADVANCE(262);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == 'w') ADVANCE(237);
      if (lookahead == 'x') ADVANCE(258);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(116);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(149);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(152);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(253);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'o') ADVANCE(262);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == 'w') ADVANCE(237);
      if (lookahead == 'x') ADVANCE(258);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(3)
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(116);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == '<') ADVANCE(149);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(152);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == 'a') ADVANCE(230);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(253);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'o') ADVANCE(233);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == 'w') ADVANCE(237);
      if (lookahead == 'x') ADVANCE(258);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(4)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(116);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == '<') ADVANCE(149);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(152);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'e') ADVANCE(243);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'o') ADVANCE(262);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == 'w') ADVANCE(237);
      if (lookahead == 'x') ADVANCE(258);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(116);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == '<') ADVANCE(149);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(152);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'o') ADVANCE(233);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == 'w') ADVANCE(237);
      if (lookahead == 'x') ADVANCE(258);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('e' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(115);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(94);
      if (lookahead == '.') ADVANCE(88);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(150);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(153);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == 'a') ADVANCE(40);
      if (lookahead == 'b') ADVANCE(29);
      if (lookahead == 'c') ADVANCE(30);
      if (lookahead == 'd') ADVANCE(44);
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 'o') ADVANCE(41);
      if (lookahead == 'r') ADVANCE(35);
      if (lookahead == 'w') ADVANCE(43);
      if (lookahead == 'x') ADVANCE(54);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if (lookahead == '}') ADVANCE(110);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(7)
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(115);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(94);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(150);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(153);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == 'a') ADVANCE(40);
      if (lookahead == 'b') ADVANCE(29);
      if (lookahead == 'c') ADVANCE(30);
      if (lookahead == 'd') ADVANCE(44);
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 'o') ADVANCE(41);
      if (lookahead == 'r') ADVANCE(35);
      if (lookahead == 'w') ADVANCE(43);
      if (lookahead == 'x') ADVANCE(54);
      if (lookahead == '|') ADVANCE(167);
      if (lookahead == '}') ADVANCE(110);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(8)
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == '-') ADVANCE(97);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '<') ADVANCE(23);
      if (lookahead == '?') ADVANCE(284);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == 'a') ADVANCE(231);
      if (lookahead == 'b') ADVANCE(215);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'e') ADVANCE(253);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'r') ADVANCE(228);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == '{') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('d' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(9)
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == '-') ADVANCE(97);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '<') ADVANCE(23);
      if (lookahead == '?') ADVANCE(284);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == 'b') ADVANCE(215);
      if (lookahead == 'c') ADVANCE(200);
      if (lookahead == 'd') ADVANCE(224);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'r') ADVANCE(228);
      if (lookahead == 's') ADVANCE(261);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == '{') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(10)
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == '-') ADVANCE(97);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '<') ADVANCE(23);
      if (lookahead == '?') ADVANCE(284);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == 'b') ADVANCE(215);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'e') ADVANCE(253);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'r') ADVANCE(228);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == '{') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '%') ADVANCE(297);
      if (lookahead == '\'') ADVANCE(294);
      if (lookahead == '\\') ADVANCE(298);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(295);
      if (lookahead != 0) ADVANCE(299);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(294);
      if (lookahead == '%') ADVANCE(297);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '\\') ADVANCE(298);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(296);
      if (lookahead != 0) ADVANCE(299);
      END_STATE();
    case 14:
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '?') ADVANCE(284);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(192);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(193);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '?') ADVANCE(284);
      if (lookahead == 'c') ADVANCE(204);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '?') ADVANCE(284);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(16)
      END_STATE();
    case 17:
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '?') ADVANCE(286);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(18)
      END_STATE();
    case 18:
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(18)
      END_STATE();
    case 19:
      if (lookahead == '%') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(28);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(188);
      if (lookahead != 0) ADVANCE(188);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(164);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(300);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(21);
      END_STATE();
    case 23:
      if (lookahead == '<') ADVANCE(107);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(155);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(154);
      END_STATE();
    case 27:
      if (lookahead == '>') ADVANCE(108);
      END_STATE();
    case 28:
      if (lookahead == '^') ADVANCE(293);
      if (lookahead == 'x') ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(292);
      if ((' ' <= lookahead && lookahead <= 127)) ADVANCE(289);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(57);
      if (lookahead == 's') ADVANCE(46);
      if (lookahead == 'x') ADVANCE(55);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 31:
      if (lookahead == 'c') ADVANCE(42);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(130);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(173);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(128);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 40:
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 41:
      if (lookahead == 'f') ADVANCE(178);
      if (lookahead == 'r') ADVANCE(140);
      END_STATE();
    case 42:
      if (lookahead == 'h') ADVANCE(120);
      END_STATE();
    case 43:
      if (lookahead == 'h') ADVANCE(38);
      END_STATE();
    case 44:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(62);
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(136);
      if (lookahead == 'r') ADVANCE(138);
      END_STATE();
    case 47:
      if (lookahead == 'l') ADVANCE(61);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 49:
      if (lookahead == 'm') ADVANCE(126);
      END_STATE();
    case 50:
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 51:
      if (lookahead == 'n') ADVANCE(104);
      END_STATE();
    case 52:
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 53:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 54:
      if (lookahead == 'o') ADVANCE(58);
      END_STATE();
    case 55:
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(140);
      END_STATE();
    case 57:
      if (lookahead == 'r') ADVANCE(132);
      END_STATE();
    case 58:
      if (lookahead == 'r') ADVANCE(142);
      END_STATE();
    case 59:
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 60:
      if (lookahead == 'r') ADVANCE(181);
      END_STATE();
    case 61:
      if (lookahead == 's') ADVANCE(53);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 66:
      if (lookahead == 'v') ADVANCE(124);
      END_STATE();
    case 67:
      if (lookahead == '}') ADVANCE(289);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 68:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(192);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 71:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 72:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(197);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(289);
      END_STATE();
    case 74:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 75:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(196);
      END_STATE();
    case 76:
      if (eof) ADVANCE(81);
      if (lookahead == '\n') ADVANCE(87);
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(116);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(149);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(152);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == 'a') ADVANCE(249);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'o') ADVANCE(262);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == 'w') ADVANCE(237);
      if (lookahead == 'x') ADVANCE(258);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('e' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(76)
      END_STATE();
    case 77:
      if (eof) ADVANCE(81);
      if (lookahead == '\n') ADVANCE(87);
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(115);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(94);
      if (lookahead == '.') ADVANCE(88);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == '<') ADVANCE(150);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(152);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'b') ADVANCE(29);
      if (lookahead == 'd') ADVANCE(44);
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(35);
      if (lookahead == 'w') ADVANCE(43);
      if (lookahead == 'x') ADVANCE(54);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(77)
      END_STATE();
    case 78:
      if (eof) ADVANCE(81);
      if (lookahead == '\n') ADVANCE(87);
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '#') ADVANCE(113);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(115);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == '<') ADVANCE(150);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(152);
      if (lookahead == '?') ADVANCE(24);
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'b') ADVANCE(29);
      if (lookahead == 'd') ADVANCE(44);
      if (lookahead == 'o') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(35);
      if (lookahead == 'w') ADVANCE(43);
      if (lookahead == 'x') ADVANCE(54);
      if (lookahead == '|') ADVANCE(167);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(78)
      END_STATE();
    case 79:
      if (eof) ADVANCE(81);
      if (lookahead == '!') ADVANCE(161);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(114);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '+') ADVANCE(116);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(89);
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(92);
      if (lookahead == '<') ADVANCE(149);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '>') ADVANCE(153);
      if (lookahead == '?') ADVANCE(285);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == 'a') ADVANCE(230);
      if (lookahead == 'b') ADVANCE(199);
      if (lookahead == 'c') ADVANCE(200);
      if (lookahead == 'd') ADVANCE(223);
      if (lookahead == 'e') ADVANCE(243);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'o') ADVANCE(233);
      if (lookahead == 'r') ADVANCE(216);
      if (lookahead == 's') ADVANCE(261);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == 'w') ADVANCE(237);
      if (lookahead == 'x') ADVANCE(258);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(167);
      if (lookahead == '}') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('g' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(79)
      END_STATE();
    case 80:
      if (eof) ADVANCE(81);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '#') ADVANCE(114);
      if (lookahead == '$') ADVANCE(187);
      if (lookahead == '%') ADVANCE(301);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '(') ADVANCE(99);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '+') ADVANCE(117);
      if (lookahead == '-') ADVANCE(97);
      if (lookahead == '.') ADVANCE(90);
      if (lookahead == '<') ADVANCE(23);
      if (lookahead == '>') ADVANCE(27);
      if (lookahead == '?') ADVANCE(284);
      if (lookahead == '[') ADVANCE(111);
      if (lookahead == ']') ADVANCE(112);
      if (lookahead == 'b') ADVANCE(215);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'f') ADVANCE(276);
      if (lookahead == 'i') ADVANCE(232);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'n') ADVANCE(257);
      if (lookahead == 'r') ADVANCE(228);
      if (lookahead == 't') ADVANCE(267);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '}') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(283);
      if (('a' <= lookahead && lookahead <= 'z') ||
          (224 <= lookahead && lookahead <= 246) ||
          (248 <= lookahead && lookahead <= 255)) ADVANCE(281);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) SKIP(80)
      END_STATE();
    case 81:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_shebang_token1);
      if (lookahead == '%') ADVANCE(85);
      if ((1 <= lookahead && lookahead <= '\t') ||
          (11 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(84);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(86);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_shebang_token1);
      if (lookahead == '%') ADVANCE(85);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(86);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_shebang_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(164);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(21);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(163);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(145);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '>') ADVANCE(175);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(145);
      if (lookahead == '>') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_define);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_spec);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_callback);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(166);
      if (lookahead == '=') ADVANCE(171);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_when);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(83);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(144);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (('0' <= lookahead && lookahead <= '3')) ADVANCE(190);
      if (('4' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_not);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_bnot);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_catch);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_div);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_div);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_rem);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_rem);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_band);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_band);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == 'a') ADVANCE(47);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_and);
      if (lookahead == 'a') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_bor);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_bor);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_bxor);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_bxor);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_bsl);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_bsl);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_bsr);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_bsr);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'e') ADVANCE(248);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_xor);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_xor);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_EQ_LT);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(168);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(169);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(168);
      if (lookahead == '=') ADVANCE(169);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(151);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(151);
      if (lookahead == '>') ADVANCE(108);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_EQ_COLON_EQ);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_EQ_SLASH_EQ);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_andalso);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_andalso);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_orelse);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_orelse);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '<') ADVANCE(148);
      if (lookahead == '=') ADVANCE(146);
      if (lookahead == '>') ADVANCE(170);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_QMARK_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(300);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(165);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_fun);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_end);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_begin);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_of);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_receive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_after);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_after);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_try);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_maybe);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_character_token1);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == '%') ADVANCE(301);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (lookahead == '#') ADVANCE(75);
      if (lookahead == '.') ADVANCE(72);
      if (lookahead == '_') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(191);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (lookahead == '#') ADVANCE(75);
      if (lookahead == '.') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(194);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (lookahead == '#') ADVANCE(75);
      if (lookahead == '_') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (lookahead == '#') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(195);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (lookahead == '.') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym_integer_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(195);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_integer_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'a') ADVANCE(254);
      if (lookahead == 'e') ADVANCE(235);
      if (lookahead == 'n') ADVANCE(259);
      if (lookahead == 'o') ADVANCE(263);
      if (lookahead == 's') ADVANCE(244);
      if (lookahead == 'x') ADVANCE(260);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'a') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'a') ADVANCE(279);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'a') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'a') ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'a') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'b') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'b') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'c') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'c') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'c') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'c') ADVANCE(225);
      if (lookahead == 'm') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'c') ADVANCE(225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'd') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'd') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'd') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(235);
      if (lookahead == 'n') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(234);
      if (lookahead == 'i') ADVANCE(277);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'e') ADVANCE(266);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'f') ADVANCE(275);
      if (lookahead == 'n') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'f') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'f') ADVANCE(106);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'f') ADVANCE(179);
      if (lookahead == 'r') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'f') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'g') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'h') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'h') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'i') ADVANCE(277);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'i') ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'i') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'i') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'k') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'l') ADVANCE(271);
      if (lookahead == 'n') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'l') ADVANCE(137);
      if (lookahead == 'r') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'l') ADVANCE(247);
      if (lookahead == 's') ADVANCE(217);
      if (lookahead == 't') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'l') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'l') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'l') ADVANCE(272);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'n') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'n') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'n') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'n') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'n') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'n') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'n') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'o') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'o') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'o') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'o') ADVANCE(274);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'o') ADVANCE(265);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'p') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'r') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'r') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'r') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'r') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'r') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'r') ADVANCE(280);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 's') ADVANCE(256);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 's') ADVANCE(217);
      if (lookahead == 't') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 's') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 's') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 's') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 't') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 't') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 't') ADVANCE(229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'u') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'v') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'v') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'y') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym__atom);
      if (lookahead == 'y') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym__atom);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          (192 <= lookahead && lookahead <= 255)) ADVANCE(281);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_variable);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('@' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(283);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_QMARK2);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_QMARK2);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '{') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(289);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(291);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(289);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_quoted_content);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '"') ADVANCE(288);
      if (lookahead == '%') ADVANCE(297);
      if (lookahead == '\'') ADVANCE(294);
      if (lookahead == '\\') ADVANCE(298);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(295);
      if (lookahead != 0) ADVANCE(299);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '"') ADVANCE(294);
      if (lookahead == '%') ADVANCE(297);
      if (lookahead == '\'') ADVANCE(282);
      if (lookahead == '\\') ADVANCE(298);
      if ((1 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(296);
      if (lookahead != 0) ADVANCE(299);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '%') ADVANCE(297);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(299);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead == '^') ADVANCE(293);
      if (lookahead == 'x') ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(292);
      if ((' ' <= lookahead && lookahead <= 127)) ADVANCE(289);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_quoted_content);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(299);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_tripledot);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '%') ADVANCE(301);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '%') ADVANCE(302);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(304);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(aux_sym_comment_token2);
      if (lookahead == '%') ADVANCE(302);
      if ((1 <= lookahead && lookahead <= '\t') ||
          lookahead == 11 ||
          lookahead == '\f' ||
          (14 <= lookahead && lookahead <= ' ') ||
          (128 <= lookahead && lookahead <= 160)) ADVANCE(303);
      if (lookahead != 0 &&
          (lookahead < '\n' || '\r' < lookahead)) ADVANCE(304);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(aux_sym_comment_token2);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(304);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 80},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 76},
  [5] = {.lex_state = 76},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 4},
  [8] = {.lex_state = 1},
  [9] = {.lex_state = 4},
  [10] = {.lex_state = 76},
  [11] = {.lex_state = 1},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 1},
  [15] = {.lex_state = 2},
  [16] = {.lex_state = 76},
  [17] = {.lex_state = 1},
  [18] = {.lex_state = 3},
  [19] = {.lex_state = 3},
  [20] = {.lex_state = 1},
  [21] = {.lex_state = 1},
  [22] = {.lex_state = 5},
  [23] = {.lex_state = 1},
  [24] = {.lex_state = 5},
  [25] = {.lex_state = 1},
  [26] = {.lex_state = 6},
  [27] = {.lex_state = 6},
  [28] = {.lex_state = 80},
  [29] = {.lex_state = 1},
  [30] = {.lex_state = 1},
  [31] = {.lex_state = 1},
  [32] = {.lex_state = 1},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 1},
  [36] = {.lex_state = 1},
  [37] = {.lex_state = 1},
  [38] = {.lex_state = 1},
  [39] = {.lex_state = 1},
  [40] = {.lex_state = 80},
  [41] = {.lex_state = 80},
  [42] = {.lex_state = 80},
  [43] = {.lex_state = 76},
  [44] = {.lex_state = 76},
  [45] = {.lex_state = 76},
  [46] = {.lex_state = 76},
  [47] = {.lex_state = 76},
  [48] = {.lex_state = 76},
  [49] = {.lex_state = 76},
  [50] = {.lex_state = 76},
  [51] = {.lex_state = 2},
  [52] = {.lex_state = 76},
  [53] = {.lex_state = 76},
  [54] = {.lex_state = 76},
  [55] = {.lex_state = 76},
  [56] = {.lex_state = 4},
  [57] = {.lex_state = 4},
  [58] = {.lex_state = 4},
  [59] = {.lex_state = 2},
  [60] = {.lex_state = 2},
  [61] = {.lex_state = 2},
  [62] = {.lex_state = 76},
  [63] = {.lex_state = 4},
  [64] = {.lex_state = 4},
  [65] = {.lex_state = 4},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 4},
  [68] = {.lex_state = 4},
  [69] = {.lex_state = 2},
  [70] = {.lex_state = 2},
  [71] = {.lex_state = 2},
  [72] = {.lex_state = 4},
  [73] = {.lex_state = 2},
  [74] = {.lex_state = 4},
  [75] = {.lex_state = 2},
  [76] = {.lex_state = 80},
  [77] = {.lex_state = 5},
  [78] = {.lex_state = 76},
  [79] = {.lex_state = 3},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 4},
  [82] = {.lex_state = 1},
  [83] = {.lex_state = 2},
  [84] = {.lex_state = 2},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 5},
  [87] = {.lex_state = 80},
  [88] = {.lex_state = 3},
  [89] = {.lex_state = 3},
  [90] = {.lex_state = 3},
  [91] = {.lex_state = 9},
  [92] = {.lex_state = 80},
  [93] = {.lex_state = 3},
  [94] = {.lex_state = 9},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 3},
  [98] = {.lex_state = 3},
  [99] = {.lex_state = 5},
  [100] = {.lex_state = 5},
  [101] = {.lex_state = 5},
  [102] = {.lex_state = 5},
  [103] = {.lex_state = 5},
  [104] = {.lex_state = 5},
  [105] = {.lex_state = 3},
  [106] = {.lex_state = 3},
  [107] = {.lex_state = 3},
  [108] = {.lex_state = 5},
  [109] = {.lex_state = 5},
  [110] = {.lex_state = 3},
  [111] = {.lex_state = 5},
  [112] = {.lex_state = 6},
  [113] = {.lex_state = 6},
  [114] = {.lex_state = 80},
  [115] = {.lex_state = 80},
  [116] = {.lex_state = 6},
  [117] = {.lex_state = 6},
  [118] = {.lex_state = 6},
  [119] = {.lex_state = 6},
  [120] = {.lex_state = 6},
  [121] = {.lex_state = 6},
  [122] = {.lex_state = 6},
  [123] = {.lex_state = 6},
  [124] = {.lex_state = 80},
  [125] = {.lex_state = 80},
  [126] = {.lex_state = 80},
  [127] = {.lex_state = 10},
  [128] = {.lex_state = 6},
  [129] = {.lex_state = 80},
  [130] = {.lex_state = 80},
  [131] = {.lex_state = 80},
  [132] = {.lex_state = 80},
  [133] = {.lex_state = 80},
  [134] = {.lex_state = 80},
  [135] = {.lex_state = 80},
  [136] = {.lex_state = 80},
  [137] = {.lex_state = 80},
  [138] = {.lex_state = 80},
  [139] = {.lex_state = 80},
  [140] = {.lex_state = 80},
  [141] = {.lex_state = 80},
  [142] = {.lex_state = 80},
  [143] = {.lex_state = 80},
  [144] = {.lex_state = 80},
  [145] = {.lex_state = 80},
  [146] = {.lex_state = 80},
  [147] = {.lex_state = 80},
  [148] = {.lex_state = 80},
  [149] = {.lex_state = 80},
  [150] = {.lex_state = 80},
  [151] = {.lex_state = 80},
  [152] = {.lex_state = 80},
  [153] = {.lex_state = 80},
  [154] = {.lex_state = 80},
  [155] = {.lex_state = 80},
  [156] = {.lex_state = 80},
  [157] = {.lex_state = 80},
  [158] = {.lex_state = 80},
  [159] = {.lex_state = 80},
  [160] = {.lex_state = 80},
  [161] = {.lex_state = 80},
  [162] = {.lex_state = 80},
  [163] = {.lex_state = 80},
  [164] = {.lex_state = 80},
  [165] = {.lex_state = 80},
  [166] = {.lex_state = 80},
  [167] = {.lex_state = 80},
  [168] = {.lex_state = 80},
  [169] = {.lex_state = 80},
  [170] = {.lex_state = 80},
  [171] = {.lex_state = 80},
  [172] = {.lex_state = 80},
  [173] = {.lex_state = 80},
  [174] = {.lex_state = 80},
  [175] = {.lex_state = 80},
  [176] = {.lex_state = 80},
  [177] = {.lex_state = 80},
  [178] = {.lex_state = 80},
  [179] = {.lex_state = 80},
  [180] = {.lex_state = 80},
  [181] = {.lex_state = 80},
  [182] = {.lex_state = 80},
  [183] = {.lex_state = 80},
  [184] = {.lex_state = 80},
  [185] = {.lex_state = 80},
  [186] = {.lex_state = 80},
  [187] = {.lex_state = 80},
  [188] = {.lex_state = 80},
  [189] = {.lex_state = 80},
  [190] = {.lex_state = 80},
  [191] = {.lex_state = 80},
  [192] = {.lex_state = 80},
  [193] = {.lex_state = 80},
  [194] = {.lex_state = 11},
  [195] = {.lex_state = 80},
  [196] = {.lex_state = 80},
  [197] = {.lex_state = 80},
  [198] = {.lex_state = 80},
  [199] = {.lex_state = 80},
  [200] = {.lex_state = 80},
  [201] = {.lex_state = 80},
  [202] = {.lex_state = 80},
  [203] = {.lex_state = 80},
  [204] = {.lex_state = 80},
  [205] = {.lex_state = 80},
  [206] = {.lex_state = 80},
  [207] = {.lex_state = 80},
  [208] = {.lex_state = 80},
  [209] = {.lex_state = 80},
  [210] = {.lex_state = 80},
  [211] = {.lex_state = 80},
  [212] = {.lex_state = 80},
  [213] = {.lex_state = 80},
  [214] = {.lex_state = 80},
  [215] = {.lex_state = 80},
  [216] = {.lex_state = 80},
  [217] = {.lex_state = 80},
  [218] = {.lex_state = 80},
  [219] = {.lex_state = 80},
  [220] = {.lex_state = 11},
  [221] = {.lex_state = 80},
  [222] = {.lex_state = 80},
  [223] = {.lex_state = 80},
  [224] = {.lex_state = 80},
  [225] = {.lex_state = 80},
  [226] = {.lex_state = 80},
  [227] = {.lex_state = 80},
  [228] = {.lex_state = 80},
  [229] = {.lex_state = 80},
  [230] = {.lex_state = 80},
  [231] = {.lex_state = 80},
  [232] = {.lex_state = 80},
  [233] = {.lex_state = 80},
  [234] = {.lex_state = 80},
  [235] = {.lex_state = 80},
  [236] = {.lex_state = 80},
  [237] = {.lex_state = 80},
  [238] = {.lex_state = 80},
  [239] = {.lex_state = 80},
  [240] = {.lex_state = 80},
  [241] = {.lex_state = 80},
  [242] = {.lex_state = 80},
  [243] = {.lex_state = 80},
  [244] = {.lex_state = 80},
  [245] = {.lex_state = 80},
  [246] = {.lex_state = 80},
  [247] = {.lex_state = 80},
  [248] = {.lex_state = 80},
  [249] = {.lex_state = 80},
  [250] = {.lex_state = 80},
  [251] = {.lex_state = 80},
  [252] = {.lex_state = 80},
  [253] = {.lex_state = 80},
  [254] = {.lex_state = 80},
  [255] = {.lex_state = 80},
  [256] = {.lex_state = 80},
  [257] = {.lex_state = 80},
  [258] = {.lex_state = 80},
  [259] = {.lex_state = 80},
  [260] = {.lex_state = 80},
  [261] = {.lex_state = 80},
  [262] = {.lex_state = 80},
  [263] = {.lex_state = 80},
  [264] = {.lex_state = 80},
  [265] = {.lex_state = 80},
  [266] = {.lex_state = 80},
  [267] = {.lex_state = 80},
  [268] = {.lex_state = 80},
  [269] = {.lex_state = 80},
  [270] = {.lex_state = 80},
  [271] = {.lex_state = 80},
  [272] = {.lex_state = 80},
  [273] = {.lex_state = 80},
  [274] = {.lex_state = 80},
  [275] = {.lex_state = 80},
  [276] = {.lex_state = 80},
  [277] = {.lex_state = 80},
  [278] = {.lex_state = 80},
  [279] = {.lex_state = 80},
  [280] = {.lex_state = 80},
  [281] = {.lex_state = 80},
  [282] = {.lex_state = 80},
  [283] = {.lex_state = 80},
  [284] = {.lex_state = 80},
  [285] = {.lex_state = 80},
  [286] = {.lex_state = 80},
  [287] = {.lex_state = 80},
  [288] = {.lex_state = 80},
  [289] = {.lex_state = 80},
  [290] = {.lex_state = 80},
  [291] = {.lex_state = 80},
  [292] = {.lex_state = 80},
  [293] = {.lex_state = 80},
  [294] = {.lex_state = 80},
  [295] = {.lex_state = 80},
  [296] = {.lex_state = 80},
  [297] = {.lex_state = 80},
  [298] = {.lex_state = 80},
  [299] = {.lex_state = 80},
  [300] = {.lex_state = 80},
  [301] = {.lex_state = 80},
  [302] = {.lex_state = 80},
  [303] = {.lex_state = 80},
  [304] = {.lex_state = 80},
  [305] = {.lex_state = 80},
  [306] = {.lex_state = 80},
  [307] = {.lex_state = 80},
  [308] = {.lex_state = 80},
  [309] = {.lex_state = 80},
  [310] = {.lex_state = 80},
  [311] = {.lex_state = 80},
  [312] = {.lex_state = 80},
  [313] = {.lex_state = 80},
  [314] = {.lex_state = 80},
  [315] = {.lex_state = 80},
  [316] = {.lex_state = 80},
  [317] = {.lex_state = 80},
  [318] = {.lex_state = 80},
  [319] = {.lex_state = 80},
  [320] = {.lex_state = 80},
  [321] = {.lex_state = 80},
  [322] = {.lex_state = 80},
  [323] = {.lex_state = 80},
  [324] = {.lex_state = 80},
  [325] = {.lex_state = 80},
  [326] = {.lex_state = 80},
  [327] = {.lex_state = 80},
  [328] = {.lex_state = 80},
  [329] = {.lex_state = 80},
  [330] = {.lex_state = 80},
  [331] = {.lex_state = 80},
  [332] = {.lex_state = 80},
  [333] = {.lex_state = 80},
  [334] = {.lex_state = 80},
  [335] = {.lex_state = 80},
  [336] = {.lex_state = 80},
  [337] = {.lex_state = 80},
  [338] = {.lex_state = 80},
  [339] = {.lex_state = 80},
  [340] = {.lex_state = 80},
  [341] = {.lex_state = 80},
  [342] = {.lex_state = 80},
  [343] = {.lex_state = 80},
  [344] = {.lex_state = 80},
  [345] = {.lex_state = 80},
  [346] = {.lex_state = 80},
  [347] = {.lex_state = 80},
  [348] = {.lex_state = 80},
  [349] = {.lex_state = 80},
  [350] = {.lex_state = 80},
  [351] = {.lex_state = 80},
  [352] = {.lex_state = 80},
  [353] = {.lex_state = 80},
  [354] = {.lex_state = 80},
  [355] = {.lex_state = 80},
  [356] = {.lex_state = 80},
  [357] = {.lex_state = 80},
  [358] = {.lex_state = 80},
  [359] = {.lex_state = 80},
  [360] = {.lex_state = 80},
  [361] = {.lex_state = 80},
  [362] = {.lex_state = 80},
  [363] = {.lex_state = 80},
  [364] = {.lex_state = 80},
  [365] = {.lex_state = 80},
  [366] = {.lex_state = 80},
  [367] = {.lex_state = 80},
  [368] = {.lex_state = 80},
  [369] = {.lex_state = 80},
  [370] = {.lex_state = 80},
  [371] = {.lex_state = 80},
  [372] = {.lex_state = 80},
  [373] = {.lex_state = 80},
  [374] = {.lex_state = 80},
  [375] = {.lex_state = 80},
  [376] = {.lex_state = 80},
  [377] = {.lex_state = 80},
  [378] = {.lex_state = 80},
  [379] = {.lex_state = 80},
  [380] = {.lex_state = 80},
  [381] = {.lex_state = 80},
  [382] = {.lex_state = 80},
  [383] = {.lex_state = 80},
  [384] = {.lex_state = 80},
  [385] = {.lex_state = 80},
  [386] = {.lex_state = 80},
  [387] = {.lex_state = 80},
  [388] = {.lex_state = 80},
  [389] = {.lex_state = 80},
  [390] = {.lex_state = 80},
  [391] = {.lex_state = 80},
  [392] = {.lex_state = 80},
  [393] = {.lex_state = 80},
  [394] = {.lex_state = 80},
  [395] = {.lex_state = 80},
  [396] = {.lex_state = 80},
  [397] = {.lex_state = 80},
  [398] = {.lex_state = 80},
  [399] = {.lex_state = 80},
  [400] = {.lex_state = 80},
  [401] = {.lex_state = 80},
  [402] = {.lex_state = 80},
  [403] = {.lex_state = 80},
  [404] = {.lex_state = 80},
  [405] = {.lex_state = 80},
  [406] = {.lex_state = 80},
  [407] = {.lex_state = 80},
  [408] = {.lex_state = 80},
  [409] = {.lex_state = 80},
  [410] = {.lex_state = 80},
  [411] = {.lex_state = 80},
  [412] = {.lex_state = 80},
  [413] = {.lex_state = 80},
  [414] = {.lex_state = 80},
  [415] = {.lex_state = 80},
  [416] = {.lex_state = 80},
  [417] = {.lex_state = 80},
  [418] = {.lex_state = 80},
  [419] = {.lex_state = 80},
  [420] = {.lex_state = 80},
  [421] = {.lex_state = 80},
  [422] = {.lex_state = 80},
  [423] = {.lex_state = 80},
  [424] = {.lex_state = 80},
  [425] = {.lex_state = 80},
  [426] = {.lex_state = 80},
  [427] = {.lex_state = 80},
  [428] = {.lex_state = 80},
  [429] = {.lex_state = 80},
  [430] = {.lex_state = 80},
  [431] = {.lex_state = 80},
  [432] = {.lex_state = 80},
  [433] = {.lex_state = 80},
  [434] = {.lex_state = 80},
  [435] = {.lex_state = 80},
  [436] = {.lex_state = 80},
  [437] = {.lex_state = 80},
  [438] = {.lex_state = 80},
  [439] = {.lex_state = 80},
  [440] = {.lex_state = 80},
  [441] = {.lex_state = 80},
  [442] = {.lex_state = 80},
  [443] = {.lex_state = 80},
  [444] = {.lex_state = 80},
  [445] = {.lex_state = 80},
  [446] = {.lex_state = 80},
  [447] = {.lex_state = 80},
  [448] = {.lex_state = 80},
  [449] = {.lex_state = 80},
  [450] = {.lex_state = 80},
  [451] = {.lex_state = 80},
  [452] = {.lex_state = 80},
  [453] = {.lex_state = 80},
  [454] = {.lex_state = 80},
  [455] = {.lex_state = 80},
  [456] = {.lex_state = 80},
  [457] = {.lex_state = 80},
  [458] = {.lex_state = 80},
  [459] = {.lex_state = 80},
  [460] = {.lex_state = 80},
  [461] = {.lex_state = 80},
  [462] = {.lex_state = 80},
  [463] = {.lex_state = 80},
  [464] = {.lex_state = 80},
  [465] = {.lex_state = 80},
  [466] = {.lex_state = 80},
  [467] = {.lex_state = 80},
  [468] = {.lex_state = 80},
  [469] = {.lex_state = 80},
  [470] = {.lex_state = 80},
  [471] = {.lex_state = 80},
  [472] = {.lex_state = 80},
  [473] = {.lex_state = 80},
  [474] = {.lex_state = 80},
  [475] = {.lex_state = 80},
  [476] = {.lex_state = 80},
  [477] = {.lex_state = 80},
  [478] = {.lex_state = 80},
  [479] = {.lex_state = 80},
  [480] = {.lex_state = 80},
  [481] = {.lex_state = 80},
  [482] = {.lex_state = 80},
  [483] = {.lex_state = 80},
  [484] = {.lex_state = 80},
  [485] = {.lex_state = 80},
  [486] = {.lex_state = 80},
  [487] = {.lex_state = 80},
  [488] = {.lex_state = 80},
  [489] = {.lex_state = 80},
  [490] = {.lex_state = 80},
  [491] = {.lex_state = 80},
  [492] = {.lex_state = 80},
  [493] = {.lex_state = 80},
  [494] = {.lex_state = 80},
  [495] = {.lex_state = 80},
  [496] = {.lex_state = 80},
  [497] = {.lex_state = 80},
  [498] = {.lex_state = 80},
  [499] = {.lex_state = 80},
  [500] = {.lex_state = 80},
  [501] = {.lex_state = 80},
  [502] = {.lex_state = 80},
  [503] = {.lex_state = 80},
  [504] = {.lex_state = 80},
  [505] = {.lex_state = 80},
  [506] = {.lex_state = 80},
  [507] = {.lex_state = 80},
  [508] = {.lex_state = 80},
  [509] = {.lex_state = 80},
  [510] = {.lex_state = 80},
  [511] = {.lex_state = 80},
  [512] = {.lex_state = 80},
  [513] = {.lex_state = 80},
  [514] = {.lex_state = 80},
  [515] = {.lex_state = 80},
  [516] = {.lex_state = 80},
  [517] = {.lex_state = 80},
  [518] = {.lex_state = 80},
  [519] = {.lex_state = 80},
  [520] = {.lex_state = 80},
  [521] = {.lex_state = 80},
  [522] = {.lex_state = 80},
  [523] = {.lex_state = 80},
  [524] = {.lex_state = 80},
  [525] = {.lex_state = 80},
  [526] = {.lex_state = 80},
  [527] = {.lex_state = 80},
  [528] = {.lex_state = 80},
  [529] = {.lex_state = 80},
  [530] = {.lex_state = 80},
  [531] = {.lex_state = 80},
  [532] = {.lex_state = 80},
  [533] = {.lex_state = 80},
  [534] = {.lex_state = 80},
  [535] = {.lex_state = 80},
  [536] = {.lex_state = 80},
  [537] = {.lex_state = 80},
  [538] = {.lex_state = 80},
  [539] = {.lex_state = 80},
  [540] = {.lex_state = 80},
  [541] = {.lex_state = 80},
  [542] = {.lex_state = 80},
  [543] = {.lex_state = 80},
  [544] = {.lex_state = 80},
  [545] = {.lex_state = 80},
  [546] = {.lex_state = 80},
  [547] = {.lex_state = 80},
  [548] = {.lex_state = 80},
  [549] = {.lex_state = 80},
  [550] = {.lex_state = 80},
  [551] = {.lex_state = 80},
  [552] = {.lex_state = 80},
  [553] = {.lex_state = 80},
  [554] = {.lex_state = 80},
  [555] = {.lex_state = 80},
  [556] = {.lex_state = 80},
  [557] = {.lex_state = 80},
  [558] = {.lex_state = 80},
  [559] = {.lex_state = 80},
  [560] = {.lex_state = 80},
  [561] = {.lex_state = 80},
  [562] = {.lex_state = 80},
  [563] = {.lex_state = 80},
  [564] = {.lex_state = 80},
  [565] = {.lex_state = 80},
  [566] = {.lex_state = 80},
  [567] = {.lex_state = 80},
  [568] = {.lex_state = 80},
  [569] = {.lex_state = 80},
  [570] = {.lex_state = 80},
  [571] = {.lex_state = 80},
  [572] = {.lex_state = 80},
  [573] = {.lex_state = 80},
  [574] = {.lex_state = 80},
  [575] = {.lex_state = 80},
  [576] = {.lex_state = 80},
  [577] = {.lex_state = 80},
  [578] = {.lex_state = 80},
  [579] = {.lex_state = 80},
  [580] = {.lex_state = 80},
  [581] = {.lex_state = 80},
  [582] = {.lex_state = 80},
  [583] = {.lex_state = 80},
  [584] = {.lex_state = 80},
  [585] = {.lex_state = 80},
  [586] = {.lex_state = 80},
  [587] = {.lex_state = 80},
  [588] = {.lex_state = 80},
  [589] = {.lex_state = 80},
  [590] = {.lex_state = 80},
  [591] = {.lex_state = 80},
  [592] = {.lex_state = 80},
  [593] = {.lex_state = 80},
  [594] = {.lex_state = 80},
  [595] = {.lex_state = 80},
  [596] = {.lex_state = 80},
  [597] = {.lex_state = 80},
  [598] = {.lex_state = 80},
  [599] = {.lex_state = 80},
  [600] = {.lex_state = 80},
  [601] = {.lex_state = 80},
  [602] = {.lex_state = 80},
  [603] = {.lex_state = 80},
  [604] = {.lex_state = 80},
  [605] = {.lex_state = 80},
  [606] = {.lex_state = 80},
  [607] = {.lex_state = 80},
  [608] = {.lex_state = 80},
  [609] = {.lex_state = 80},
  [610] = {.lex_state = 80},
  [611] = {.lex_state = 80},
  [612] = {.lex_state = 80},
  [613] = {.lex_state = 80},
  [614] = {.lex_state = 80},
  [615] = {.lex_state = 80},
  [616] = {.lex_state = 80},
  [617] = {.lex_state = 80},
  [618] = {.lex_state = 7},
  [619] = {.lex_state = 7},
  [620] = {.lex_state = 7},
  [621] = {.lex_state = 8},
  [622] = {.lex_state = 7},
  [623] = {.lex_state = 7},
  [624] = {.lex_state = 7},
  [625] = {.lex_state = 7},
  [626] = {.lex_state = 7},
  [627] = {.lex_state = 8},
  [628] = {.lex_state = 7},
  [629] = {.lex_state = 7},
  [630] = {.lex_state = 7},
  [631] = {.lex_state = 7},
  [632] = {.lex_state = 8},
  [633] = {.lex_state = 7},
  [634] = {.lex_state = 8},
  [635] = {.lex_state = 7},
  [636] = {.lex_state = 7},
  [637] = {.lex_state = 7},
  [638] = {.lex_state = 8},
  [639] = {.lex_state = 7},
  [640] = {.lex_state = 8},
  [641] = {.lex_state = 7},
  [642] = {.lex_state = 7},
  [643] = {.lex_state = 8},
  [644] = {.lex_state = 7},
  [645] = {.lex_state = 7},
  [646] = {.lex_state = 7},
  [647] = {.lex_state = 7},
  [648] = {.lex_state = 8},
  [649] = {.lex_state = 7},
  [650] = {.lex_state = 7},
  [651] = {.lex_state = 7},
  [652] = {.lex_state = 7},
  [653] = {.lex_state = 7},
  [654] = {.lex_state = 7},
  [655] = {.lex_state = 7},
  [656] = {.lex_state = 7},
  [657] = {.lex_state = 7},
  [658] = {.lex_state = 7},
  [659] = {.lex_state = 7},
  [660] = {.lex_state = 7},
  [661] = {.lex_state = 7},
  [662] = {.lex_state = 7},
  [663] = {.lex_state = 7},
  [664] = {.lex_state = 7},
  [665] = {.lex_state = 7},
  [666] = {.lex_state = 7},
  [667] = {.lex_state = 7},
  [668] = {.lex_state = 7},
  [669] = {.lex_state = 7},
  [670] = {.lex_state = 7},
  [671] = {.lex_state = 7},
  [672] = {.lex_state = 7},
  [673] = {.lex_state = 7},
  [674] = {.lex_state = 7},
  [675] = {.lex_state = 7},
  [676] = {.lex_state = 7},
  [677] = {.lex_state = 7},
  [678] = {.lex_state = 8},
  [679] = {.lex_state = 7},
  [680] = {.lex_state = 7},
  [681] = {.lex_state = 7},
  [682] = {.lex_state = 7},
  [683] = {.lex_state = 7},
  [684] = {.lex_state = 7},
  [685] = {.lex_state = 7},
  [686] = {.lex_state = 7},
  [687] = {.lex_state = 7},
  [688] = {.lex_state = 8},
  [689] = {.lex_state = 8},
  [690] = {.lex_state = 7},
  [691] = {.lex_state = 7},
  [692] = {.lex_state = 7},
  [693] = {.lex_state = 7},
  [694] = {.lex_state = 7},
  [695] = {.lex_state = 7},
  [696] = {.lex_state = 7},
  [697] = {.lex_state = 7},
  [698] = {.lex_state = 7},
  [699] = {.lex_state = 7},
  [700] = {.lex_state = 7},
  [701] = {.lex_state = 7},
  [702] = {.lex_state = 7},
  [703] = {.lex_state = 7},
  [704] = {.lex_state = 7},
  [705] = {.lex_state = 7},
  [706] = {.lex_state = 7},
  [707] = {.lex_state = 7},
  [708] = {.lex_state = 7},
  [709] = {.lex_state = 7},
  [710] = {.lex_state = 7},
  [711] = {.lex_state = 7},
  [712] = {.lex_state = 77},
  [713] = {.lex_state = 7},
  [714] = {.lex_state = 7},
  [715] = {.lex_state = 77},
  [716] = {.lex_state = 77},
  [717] = {.lex_state = 77},
  [718] = {.lex_state = 77},
  [719] = {.lex_state = 77},
  [720] = {.lex_state = 77},
  [721] = {.lex_state = 77},
  [722] = {.lex_state = 77},
  [723] = {.lex_state = 77},
  [724] = {.lex_state = 77},
  [725] = {.lex_state = 77},
  [726] = {.lex_state = 77},
  [727] = {.lex_state = 7},
  [728] = {.lex_state = 7},
  [729] = {.lex_state = 78},
  [730] = {.lex_state = 7},
  [731] = {.lex_state = 7},
  [732] = {.lex_state = 7},
  [733] = {.lex_state = 77},
  [734] = {.lex_state = 7},
  [735] = {.lex_state = 7},
  [736] = {.lex_state = 7},
  [737] = {.lex_state = 77},
  [738] = {.lex_state = 77},
  [739] = {.lex_state = 7},
  [740] = {.lex_state = 7},
  [741] = {.lex_state = 7},
  [742] = {.lex_state = 7},
  [743] = {.lex_state = 7},
  [744] = {.lex_state = 7},
  [745] = {.lex_state = 7},
  [746] = {.lex_state = 7},
  [747] = {.lex_state = 7},
  [748] = {.lex_state = 7},
  [749] = {.lex_state = 7},
  [750] = {.lex_state = 7},
  [751] = {.lex_state = 78},
  [752] = {.lex_state = 77},
  [753] = {.lex_state = 78},
  [754] = {.lex_state = 7},
  [755] = {.lex_state = 78},
  [756] = {.lex_state = 77},
  [757] = {.lex_state = 7},
  [758] = {.lex_state = 77},
  [759] = {.lex_state = 78},
  [760] = {.lex_state = 78},
  [761] = {.lex_state = 78},
  [762] = {.lex_state = 78},
  [763] = {.lex_state = 78},
  [764] = {.lex_state = 7},
  [765] = {.lex_state = 7},
  [766] = {.lex_state = 7},
  [767] = {.lex_state = 7},
  [768] = {.lex_state = 77},
  [769] = {.lex_state = 7},
  [770] = {.lex_state = 7},
  [771] = {.lex_state = 77},
  [772] = {.lex_state = 7},
  [773] = {.lex_state = 7},
  [774] = {.lex_state = 7},
  [775] = {.lex_state = 7},
  [776] = {.lex_state = 7},
  [777] = {.lex_state = 78},
  [778] = {.lex_state = 7},
  [779] = {.lex_state = 78},
  [780] = {.lex_state = 77},
  [781] = {.lex_state = 7},
  [782] = {.lex_state = 7},
  [783] = {.lex_state = 7},
  [784] = {.lex_state = 7},
  [785] = {.lex_state = 7},
  [786] = {.lex_state = 7},
  [787] = {.lex_state = 7},
  [788] = {.lex_state = 7},
  [789] = {.lex_state = 7},
  [790] = {.lex_state = 7},
  [791] = {.lex_state = 7},
  [792] = {.lex_state = 7},
  [793] = {.lex_state = 7},
  [794] = {.lex_state = 7},
  [795] = {.lex_state = 7},
  [796] = {.lex_state = 7},
  [797] = {.lex_state = 7},
  [798] = {.lex_state = 7},
  [799] = {.lex_state = 7},
  [800] = {.lex_state = 7},
  [801] = {.lex_state = 7},
  [802] = {.lex_state = 7},
  [803] = {.lex_state = 7},
  [804] = {.lex_state = 77},
  [805] = {.lex_state = 77},
  [806] = {.lex_state = 7},
  [807] = {.lex_state = 7},
  [808] = {.lex_state = 7},
  [809] = {.lex_state = 7},
  [810] = {.lex_state = 7},
  [811] = {.lex_state = 7},
  [812] = {.lex_state = 7},
  [813] = {.lex_state = 7},
  [814] = {.lex_state = 7},
  [815] = {.lex_state = 8},
  [816] = {.lex_state = 7},
  [817] = {.lex_state = 8},
  [818] = {.lex_state = 8},
  [819] = {.lex_state = 8},
  [820] = {.lex_state = 8},
  [821] = {.lex_state = 78},
  [822] = {.lex_state = 7},
  [823] = {.lex_state = 7},
  [824] = {.lex_state = 77},
  [825] = {.lex_state = 7},
  [826] = {.lex_state = 77},
  [827] = {.lex_state = 7},
  [828] = {.lex_state = 77},
  [829] = {.lex_state = 7},
  [830] = {.lex_state = 77},
  [831] = {.lex_state = 7},
  [832] = {.lex_state = 7},
  [833] = {.lex_state = 7},
  [834] = {.lex_state = 7},
  [835] = {.lex_state = 7},
  [836] = {.lex_state = 7},
  [837] = {.lex_state = 7},
  [838] = {.lex_state = 7},
  [839] = {.lex_state = 7},
  [840] = {.lex_state = 77},
  [841] = {.lex_state = 7},
  [842] = {.lex_state = 77},
  [843] = {.lex_state = 77},
  [844] = {.lex_state = 77},
  [845] = {.lex_state = 77},
  [846] = {.lex_state = 77},
  [847] = {.lex_state = 77},
  [848] = {.lex_state = 77},
  [849] = {.lex_state = 77},
  [850] = {.lex_state = 77},
  [851] = {.lex_state = 77},
  [852] = {.lex_state = 77},
  [853] = {.lex_state = 77},
  [854] = {.lex_state = 77},
  [855] = {.lex_state = 77},
  [856] = {.lex_state = 77},
  [857] = {.lex_state = 77},
  [858] = {.lex_state = 77},
  [859] = {.lex_state = 77},
  [860] = {.lex_state = 77},
  [861] = {.lex_state = 77},
  [862] = {.lex_state = 77},
  [863] = {.lex_state = 77},
  [864] = {.lex_state = 77},
  [865] = {.lex_state = 77},
  [866] = {.lex_state = 77},
  [867] = {.lex_state = 77},
  [868] = {.lex_state = 7},
  [869] = {.lex_state = 7},
  [870] = {.lex_state = 7},
  [871] = {.lex_state = 7},
  [872] = {.lex_state = 7},
  [873] = {.lex_state = 7},
  [874] = {.lex_state = 7},
  [875] = {.lex_state = 7},
  [876] = {.lex_state = 7},
  [877] = {.lex_state = 7},
  [878] = {.lex_state = 7},
  [879] = {.lex_state = 7},
  [880] = {.lex_state = 7},
  [881] = {.lex_state = 7},
  [882] = {.lex_state = 7},
  [883] = {.lex_state = 7},
  [884] = {.lex_state = 7},
  [885] = {.lex_state = 7},
  [886] = {.lex_state = 7},
  [887] = {.lex_state = 7},
  [888] = {.lex_state = 7},
  [889] = {.lex_state = 7},
  [890] = {.lex_state = 77},
  [891] = {.lex_state = 7},
  [892] = {.lex_state = 7},
  [893] = {.lex_state = 7},
  [894] = {.lex_state = 7},
  [895] = {.lex_state = 7},
  [896] = {.lex_state = 7},
  [897] = {.lex_state = 77},
  [898] = {.lex_state = 77},
  [899] = {.lex_state = 77},
  [900] = {.lex_state = 77},
  [901] = {.lex_state = 7},
  [902] = {.lex_state = 77},
  [903] = {.lex_state = 77},
  [904] = {.lex_state = 7},
  [905] = {.lex_state = 7},
  [906] = {.lex_state = 7},
  [907] = {.lex_state = 77},
  [908] = {.lex_state = 7},
  [909] = {.lex_state = 8},
  [910] = {.lex_state = 77},
  [911] = {.lex_state = 7},
  [912] = {.lex_state = 7},
  [913] = {.lex_state = 7},
  [914] = {.lex_state = 7},
  [915] = {.lex_state = 7},
  [916] = {.lex_state = 7},
  [917] = {.lex_state = 7},
  [918] = {.lex_state = 7},
  [919] = {.lex_state = 7},
  [920] = {.lex_state = 7},
  [921] = {.lex_state = 7},
  [922] = {.lex_state = 7},
  [923] = {.lex_state = 7},
  [924] = {.lex_state = 7},
  [925] = {.lex_state = 7},
  [926] = {.lex_state = 77},
  [927] = {.lex_state = 77},
  [928] = {.lex_state = 77},
  [929] = {.lex_state = 77},
  [930] = {.lex_state = 77},
  [931] = {.lex_state = 7},
  [932] = {.lex_state = 77},
  [933] = {.lex_state = 77},
  [934] = {.lex_state = 77},
  [935] = {.lex_state = 77},
  [936] = {.lex_state = 77},
  [937] = {.lex_state = 7},
  [938] = {.lex_state = 77},
  [939] = {.lex_state = 7},
  [940] = {.lex_state = 7},
  [941] = {.lex_state = 7},
  [942] = {.lex_state = 7},
  [943] = {.lex_state = 7},
  [944] = {.lex_state = 77},
  [945] = {.lex_state = 77},
  [946] = {.lex_state = 77},
  [947] = {.lex_state = 77},
  [948] = {.lex_state = 7},
  [949] = {.lex_state = 7},
  [950] = {.lex_state = 7},
  [951] = {.lex_state = 77},
  [952] = {.lex_state = 77},
  [953] = {.lex_state = 77},
  [954] = {.lex_state = 77},
  [955] = {.lex_state = 77},
  [956] = {.lex_state = 77},
  [957] = {.lex_state = 77},
  [958] = {.lex_state = 77},
  [959] = {.lex_state = 77},
  [960] = {.lex_state = 77},
  [961] = {.lex_state = 77},
  [962] = {.lex_state = 77},
  [963] = {.lex_state = 77},
  [964] = {.lex_state = 77},
  [965] = {.lex_state = 77},
  [966] = {.lex_state = 77},
  [967] = {.lex_state = 77},
  [968] = {.lex_state = 77},
  [969] = {.lex_state = 77},
  [970] = {.lex_state = 77},
  [971] = {.lex_state = 77},
  [972] = {.lex_state = 77},
  [973] = {.lex_state = 77},
  [974] = {.lex_state = 77},
  [975] = {.lex_state = 77},
  [976] = {.lex_state = 77},
  [977] = {.lex_state = 77},
  [978] = {.lex_state = 77},
  [979] = {.lex_state = 77},
  [980] = {.lex_state = 7},
  [981] = {.lex_state = 7},
  [982] = {.lex_state = 7},
  [983] = {.lex_state = 7},
  [984] = {.lex_state = 7},
  [985] = {.lex_state = 7},
  [986] = {.lex_state = 7},
  [987] = {.lex_state = 7},
  [988] = {.lex_state = 7},
  [989] = {.lex_state = 7},
  [990] = {.lex_state = 7},
  [991] = {.lex_state = 7},
  [992] = {.lex_state = 7},
  [993] = {.lex_state = 7},
  [994] = {.lex_state = 7},
  [995] = {.lex_state = 7},
  [996] = {.lex_state = 7},
  [997] = {.lex_state = 7},
  [998] = {.lex_state = 7},
  [999] = {.lex_state = 7},
  [1000] = {.lex_state = 7},
  [1001] = {.lex_state = 7},
  [1002] = {.lex_state = 7},
  [1003] = {.lex_state = 7},
  [1004] = {.lex_state = 7},
  [1005] = {.lex_state = 7},
  [1006] = {.lex_state = 7},
  [1007] = {.lex_state = 7},
  [1008] = {.lex_state = 7},
  [1009] = {.lex_state = 7},
  [1010] = {.lex_state = 7},
  [1011] = {.lex_state = 7},
  [1012] = {.lex_state = 7},
  [1013] = {.lex_state = 7},
  [1014] = {.lex_state = 7},
  [1015] = {.lex_state = 7},
  [1016] = {.lex_state = 7},
  [1017] = {.lex_state = 7},
  [1018] = {.lex_state = 7},
  [1019] = {.lex_state = 7},
  [1020] = {.lex_state = 7},
  [1021] = {.lex_state = 7},
  [1022] = {.lex_state = 7},
  [1023] = {.lex_state = 7},
  [1024] = {.lex_state = 7},
  [1025] = {.lex_state = 7},
  [1026] = {.lex_state = 7},
  [1027] = {.lex_state = 7},
  [1028] = {.lex_state = 7},
  [1029] = {.lex_state = 7},
  [1030] = {.lex_state = 7},
  [1031] = {.lex_state = 7},
  [1032] = {.lex_state = 7},
  [1033] = {.lex_state = 7},
  [1034] = {.lex_state = 7},
  [1035] = {.lex_state = 7},
  [1036] = {.lex_state = 7},
  [1037] = {.lex_state = 7},
  [1038] = {.lex_state = 7},
  [1039] = {.lex_state = 7},
  [1040] = {.lex_state = 7},
  [1041] = {.lex_state = 7},
  [1042] = {.lex_state = 7},
  [1043] = {.lex_state = 7},
  [1044] = {.lex_state = 7},
  [1045] = {.lex_state = 7},
  [1046] = {.lex_state = 7},
  [1047] = {.lex_state = 7},
  [1048] = {.lex_state = 7},
  [1049] = {.lex_state = 7},
  [1050] = {.lex_state = 7},
  [1051] = {.lex_state = 7},
  [1052] = {.lex_state = 7},
  [1053] = {.lex_state = 7},
  [1054] = {.lex_state = 7},
  [1055] = {.lex_state = 77},
  [1056] = {.lex_state = 77},
  [1057] = {.lex_state = 7},
  [1058] = {.lex_state = 7},
  [1059] = {.lex_state = 77},
  [1060] = {.lex_state = 77},
  [1061] = {.lex_state = 77},
  [1062] = {.lex_state = 77},
  [1063] = {.lex_state = 77},
  [1064] = {.lex_state = 77},
  [1065] = {.lex_state = 77},
  [1066] = {.lex_state = 77},
  [1067] = {.lex_state = 7},
  [1068] = {.lex_state = 77},
  [1069] = {.lex_state = 8},
  [1070] = {.lex_state = 77},
  [1071] = {.lex_state = 77},
  [1072] = {.lex_state = 7},
  [1073] = {.lex_state = 7},
  [1074] = {.lex_state = 7},
  [1075] = {.lex_state = 7},
  [1076] = {.lex_state = 7},
  [1077] = {.lex_state = 7},
  [1078] = {.lex_state = 7},
  [1079] = {.lex_state = 7},
  [1080] = {.lex_state = 7},
  [1081] = {.lex_state = 7},
  [1082] = {.lex_state = 7},
  [1083] = {.lex_state = 7},
  [1084] = {.lex_state = 7},
  [1085] = {.lex_state = 7},
  [1086] = {.lex_state = 7},
  [1087] = {.lex_state = 7},
  [1088] = {.lex_state = 7},
  [1089] = {.lex_state = 7},
  [1090] = {.lex_state = 7},
  [1091] = {.lex_state = 7},
  [1092] = {.lex_state = 7},
  [1093] = {.lex_state = 7},
  [1094] = {.lex_state = 7},
  [1095] = {.lex_state = 7},
  [1096] = {.lex_state = 7},
  [1097] = {.lex_state = 7},
  [1098] = {.lex_state = 7},
  [1099] = {.lex_state = 7},
  [1100] = {.lex_state = 7},
  [1101] = {.lex_state = 7},
  [1102] = {.lex_state = 7},
  [1103] = {.lex_state = 7},
  [1104] = {.lex_state = 7},
  [1105] = {.lex_state = 7},
  [1106] = {.lex_state = 7},
  [1107] = {.lex_state = 77},
  [1108] = {.lex_state = 7},
  [1109] = {.lex_state = 7},
  [1110] = {.lex_state = 7},
  [1111] = {.lex_state = 7},
  [1112] = {.lex_state = 7},
  [1113] = {.lex_state = 7},
  [1114] = {.lex_state = 7},
  [1115] = {.lex_state = 7},
  [1116] = {.lex_state = 7},
  [1117] = {.lex_state = 7},
  [1118] = {.lex_state = 7},
  [1119] = {.lex_state = 7},
  [1120] = {.lex_state = 7},
  [1121] = {.lex_state = 7},
  [1122] = {.lex_state = 7},
  [1123] = {.lex_state = 7},
  [1124] = {.lex_state = 7},
  [1125] = {.lex_state = 7},
  [1126] = {.lex_state = 7},
  [1127] = {.lex_state = 7},
  [1128] = {.lex_state = 7},
  [1129] = {.lex_state = 7},
  [1130] = {.lex_state = 7},
  [1131] = {.lex_state = 7},
  [1132] = {.lex_state = 7},
  [1133] = {.lex_state = 7},
  [1134] = {.lex_state = 7},
  [1135] = {.lex_state = 7},
  [1136] = {.lex_state = 7},
  [1137] = {.lex_state = 7},
  [1138] = {.lex_state = 7},
  [1139] = {.lex_state = 7},
  [1140] = {.lex_state = 7},
  [1141] = {.lex_state = 7},
  [1142] = {.lex_state = 7},
  [1143] = {.lex_state = 7},
  [1144] = {.lex_state = 7},
  [1145] = {.lex_state = 7},
  [1146] = {.lex_state = 7},
  [1147] = {.lex_state = 7},
  [1148] = {.lex_state = 7},
  [1149] = {.lex_state = 7},
  [1150] = {.lex_state = 7},
  [1151] = {.lex_state = 7},
  [1152] = {.lex_state = 7},
  [1153] = {.lex_state = 7},
  [1154] = {.lex_state = 7},
  [1155] = {.lex_state = 7},
  [1156] = {.lex_state = 7},
  [1157] = {.lex_state = 7},
  [1158] = {.lex_state = 7},
  [1159] = {.lex_state = 7},
  [1160] = {.lex_state = 7},
  [1161] = {.lex_state = 7},
  [1162] = {.lex_state = 7},
  [1163] = {.lex_state = 7},
  [1164] = {.lex_state = 7},
  [1165] = {.lex_state = 7},
  [1166] = {.lex_state = 7},
  [1167] = {.lex_state = 7},
  [1168] = {.lex_state = 7},
  [1169] = {.lex_state = 7},
  [1170] = {.lex_state = 7},
  [1171] = {.lex_state = 7},
  [1172] = {.lex_state = 7},
  [1173] = {.lex_state = 7},
  [1174] = {.lex_state = 7},
  [1175] = {.lex_state = 7},
  [1176] = {.lex_state = 7},
  [1177] = {.lex_state = 7},
  [1178] = {.lex_state = 7},
  [1179] = {.lex_state = 7},
  [1180] = {.lex_state = 7},
  [1181] = {.lex_state = 7},
  [1182] = {.lex_state = 7},
  [1183] = {.lex_state = 7},
  [1184] = {.lex_state = 7},
  [1185] = {.lex_state = 7},
  [1186] = {.lex_state = 7},
  [1187] = {.lex_state = 7},
  [1188] = {.lex_state = 7},
  [1189] = {.lex_state = 7},
  [1190] = {.lex_state = 7},
  [1191] = {.lex_state = 7},
  [1192] = {.lex_state = 7},
  [1193] = {.lex_state = 7},
  [1194] = {.lex_state = 7},
  [1195] = {.lex_state = 7},
  [1196] = {.lex_state = 7},
  [1197] = {.lex_state = 7},
  [1198] = {.lex_state = 7},
  [1199] = {.lex_state = 7},
  [1200] = {.lex_state = 7},
  [1201] = {.lex_state = 7},
  [1202] = {.lex_state = 7},
  [1203] = {.lex_state = 7},
  [1204] = {.lex_state = 7},
  [1205] = {.lex_state = 7},
  [1206] = {.lex_state = 7},
  [1207] = {.lex_state = 7},
  [1208] = {.lex_state = 7},
  [1209] = {.lex_state = 7},
  [1210] = {.lex_state = 7},
  [1211] = {.lex_state = 7},
  [1212] = {.lex_state = 7},
  [1213] = {.lex_state = 7},
  [1214] = {.lex_state = 7},
  [1215] = {.lex_state = 7},
  [1216] = {.lex_state = 7},
  [1217] = {.lex_state = 7},
  [1218] = {.lex_state = 7},
  [1219] = {.lex_state = 7},
  [1220] = {.lex_state = 7},
  [1221] = {.lex_state = 7},
  [1222] = {.lex_state = 7},
  [1223] = {.lex_state = 7},
  [1224] = {.lex_state = 7},
  [1225] = {.lex_state = 7},
  [1226] = {.lex_state = 7},
  [1227] = {.lex_state = 7},
  [1228] = {.lex_state = 7},
  [1229] = {.lex_state = 80},
  [1230] = {.lex_state = 80},
  [1231] = {.lex_state = 80},
  [1232] = {.lex_state = 80},
  [1233] = {.lex_state = 80},
  [1234] = {.lex_state = 80},
  [1235] = {.lex_state = 80},
  [1236] = {.lex_state = 80},
  [1237] = {.lex_state = 16},
  [1238] = {.lex_state = 16},
  [1239] = {.lex_state = 16},
  [1240] = {.lex_state = 16},
  [1241] = {.lex_state = 16},
  [1242] = {.lex_state = 16},
  [1243] = {.lex_state = 16},
  [1244] = {.lex_state = 16},
  [1245] = {.lex_state = 16},
  [1246] = {.lex_state = 16},
  [1247] = {.lex_state = 16},
  [1248] = {.lex_state = 16},
  [1249] = {.lex_state = 16},
  [1250] = {.lex_state = 16},
  [1251] = {.lex_state = 16},
  [1252] = {.lex_state = 16},
  [1253] = {.lex_state = 16},
  [1254] = {.lex_state = 16},
  [1255] = {.lex_state = 16},
  [1256] = {.lex_state = 16},
  [1257] = {.lex_state = 16},
  [1258] = {.lex_state = 16},
  [1259] = {.lex_state = 15},
  [1260] = {.lex_state = 14},
  [1261] = {.lex_state = 16},
  [1262] = {.lex_state = 14},
  [1263] = {.lex_state = 14},
  [1264] = {.lex_state = 16},
  [1265] = {.lex_state = 16},
  [1266] = {.lex_state = 16},
  [1267] = {.lex_state = 16},
  [1268] = {.lex_state = 16},
  [1269] = {.lex_state = 16},
  [1270] = {.lex_state = 16},
  [1271] = {.lex_state = 16},
  [1272] = {.lex_state = 16},
  [1273] = {.lex_state = 16},
  [1274] = {.lex_state = 16},
  [1275] = {.lex_state = 16},
  [1276] = {.lex_state = 16},
  [1277] = {.lex_state = 16},
  [1278] = {.lex_state = 16},
  [1279] = {.lex_state = 16},
  [1280] = {.lex_state = 16},
  [1281] = {.lex_state = 16},
  [1282] = {.lex_state = 16},
  [1283] = {.lex_state = 7},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 0},
  [1286] = {.lex_state = 17},
  [1287] = {.lex_state = 7},
  [1288] = {.lex_state = 7},
  [1289] = {.lex_state = 17},
  [1290] = {.lex_state = 17},
  [1291] = {.lex_state = 17},
  [1292] = {.lex_state = 7},
  [1293] = {.lex_state = 7},
  [1294] = {.lex_state = 17},
  [1295] = {.lex_state = 7},
  [1296] = {.lex_state = 7},
  [1297] = {.lex_state = 17},
  [1298] = {.lex_state = 7},
  [1299] = {.lex_state = 7},
  [1300] = {.lex_state = 17},
  [1301] = {.lex_state = 17},
  [1302] = {.lex_state = 17},
  [1303] = {.lex_state = 17},
  [1304] = {.lex_state = 17},
  [1305] = {.lex_state = 7},
  [1306] = {.lex_state = 7},
  [1307] = {.lex_state = 7},
  [1308] = {.lex_state = 7},
  [1309] = {.lex_state = 7},
  [1310] = {.lex_state = 7},
  [1311] = {.lex_state = 7},
  [1312] = {.lex_state = 7},
  [1313] = {.lex_state = 7},
  [1314] = {.lex_state = 16},
  [1315] = {.lex_state = 7},
  [1316] = {.lex_state = 7},
  [1317] = {.lex_state = 7},
  [1318] = {.lex_state = 0},
  [1319] = {.lex_state = 7},
  [1320] = {.lex_state = 7},
  [1321] = {.lex_state = 16},
  [1322] = {.lex_state = 7},
  [1323] = {.lex_state = 16},
  [1324] = {.lex_state = 16},
  [1325] = {.lex_state = 7},
  [1326] = {.lex_state = 7},
  [1327] = {.lex_state = 7},
  [1328] = {.lex_state = 7},
  [1329] = {.lex_state = 7},
  [1330] = {.lex_state = 7},
  [1331] = {.lex_state = 7},
  [1332] = {.lex_state = 7},
  [1333] = {.lex_state = 7},
  [1334] = {.lex_state = 7},
  [1335] = {.lex_state = 16},
  [1336] = {.lex_state = 16},
  [1337] = {.lex_state = 7},
  [1338] = {.lex_state = 7},
  [1339] = {.lex_state = 7},
  [1340] = {.lex_state = 16},
  [1341] = {.lex_state = 7},
  [1342] = {.lex_state = 7},
  [1343] = {.lex_state = 7},
  [1344] = {.lex_state = 7},
  [1345] = {.lex_state = 7},
  [1346] = {.lex_state = 7},
  [1347] = {.lex_state = 7},
  [1348] = {.lex_state = 7},
  [1349] = {.lex_state = 7},
  [1350] = {.lex_state = 7},
  [1351] = {.lex_state = 7},
  [1352] = {.lex_state = 7},
  [1353] = {.lex_state = 16},
  [1354] = {.lex_state = 16},
  [1355] = {.lex_state = 77},
  [1356] = {.lex_state = 16},
  [1357] = {.lex_state = 16},
  [1358] = {.lex_state = 13},
  [1359] = {.lex_state = 7},
  [1360] = {.lex_state = 13},
  [1361] = {.lex_state = 13},
  [1362] = {.lex_state = 13},
  [1363] = {.lex_state = 0},
  [1364] = {.lex_state = 13},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 13},
  [1367] = {.lex_state = 13},
  [1368] = {.lex_state = 13},
  [1369] = {.lex_state = 7},
  [1370] = {.lex_state = 7},
  [1371] = {.lex_state = 7},
  [1372] = {.lex_state = 0},
  [1373] = {.lex_state = 13},
  [1374] = {.lex_state = 0},
  [1375] = {.lex_state = 7},
  [1376] = {.lex_state = 7},
  [1377] = {.lex_state = 7},
  [1378] = {.lex_state = 7},
  [1379] = {.lex_state = 0},
  [1380] = {.lex_state = 7},
  [1381] = {.lex_state = 13},
  [1382] = {.lex_state = 13},
  [1383] = {.lex_state = 7},
  [1384] = {.lex_state = 7},
  [1385] = {.lex_state = 12},
  [1386] = {.lex_state = 12},
  [1387] = {.lex_state = 13},
  [1388] = {.lex_state = 77},
  [1389] = {.lex_state = 7},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 7},
  [1392] = {.lex_state = 13},
  [1393] = {.lex_state = 0},
  [1394] = {.lex_state = 0},
  [1395] = {.lex_state = 13},
  [1396] = {.lex_state = 13},
  [1397] = {.lex_state = 12},
  [1398] = {.lex_state = 13},
  [1399] = {.lex_state = 13},
  [1400] = {.lex_state = 7},
  [1401] = {.lex_state = 13},
  [1402] = {.lex_state = 7},
  [1403] = {.lex_state = 12},
  [1404] = {.lex_state = 12},
  [1405] = {.lex_state = 13},
  [1406] = {.lex_state = 7},
  [1407] = {.lex_state = 13},
  [1408] = {.lex_state = 7},
  [1409] = {.lex_state = 13},
  [1410] = {.lex_state = 13},
  [1411] = {.lex_state = 7},
  [1412] = {.lex_state = 7},
  [1413] = {.lex_state = 7},
  [1414] = {.lex_state = 13},
  [1415] = {.lex_state = 0},
  [1416] = {.lex_state = 7},
  [1417] = {.lex_state = 7},
  [1418] = {.lex_state = 7},
  [1419] = {.lex_state = 7},
  [1420] = {.lex_state = 7},
  [1421] = {.lex_state = 7},
  [1422] = {.lex_state = 7},
  [1423] = {.lex_state = 0},
  [1424] = {.lex_state = 7},
  [1425] = {.lex_state = 0},
  [1426] = {.lex_state = 7},
  [1427] = {.lex_state = 7},
  [1428] = {.lex_state = 7},
  [1429] = {.lex_state = 0},
  [1430] = {.lex_state = 7},
  [1431] = {.lex_state = 0},
  [1432] = {.lex_state = 0},
  [1433] = {.lex_state = 0},
  [1434] = {.lex_state = 13},
  [1435] = {.lex_state = 0},
  [1436] = {.lex_state = 12},
  [1437] = {.lex_state = 0},
  [1438] = {.lex_state = 7},
  [1439] = {.lex_state = 7},
  [1440] = {.lex_state = 7},
  [1441] = {.lex_state = 0},
  [1442] = {.lex_state = 7},
  [1443] = {.lex_state = 0},
  [1444] = {.lex_state = 7},
  [1445] = {.lex_state = 7},
  [1446] = {.lex_state = 7},
  [1447] = {.lex_state = 0},
  [1448] = {.lex_state = 0},
  [1449] = {.lex_state = 0},
  [1450] = {.lex_state = 0},
  [1451] = {.lex_state = 0},
  [1452] = {.lex_state = 7},
  [1453] = {.lex_state = 7},
  [1454] = {.lex_state = 7},
  [1455] = {.lex_state = 7},
  [1456] = {.lex_state = 7},
  [1457] = {.lex_state = 7},
  [1458] = {.lex_state = 0},
  [1459] = {.lex_state = 7},
  [1460] = {.lex_state = 0},
  [1461] = {.lex_state = 7},
  [1462] = {.lex_state = 0},
  [1463] = {.lex_state = 0},
  [1464] = {.lex_state = 0},
  [1465] = {.lex_state = 7},
  [1466] = {.lex_state = 0},
  [1467] = {.lex_state = 7},
  [1468] = {.lex_state = 7},
  [1469] = {.lex_state = 0},
  [1470] = {.lex_state = 0},
  [1471] = {.lex_state = 0},
  [1472] = {.lex_state = 7},
  [1473] = {.lex_state = 7},
  [1474] = {.lex_state = 7},
  [1475] = {.lex_state = 7},
  [1476] = {.lex_state = 7},
  [1477] = {.lex_state = 0},
  [1478] = {.lex_state = 7},
  [1479] = {.lex_state = 7},
  [1480] = {.lex_state = 7},
  [1481] = {.lex_state = 0},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 0},
  [1484] = {.lex_state = 19},
  [1485] = {.lex_state = 0},
  [1486] = {.lex_state = 19},
  [1487] = {.lex_state = 0},
  [1488] = {.lex_state = 7},
  [1489] = {.lex_state = 0},
  [1490] = {.lex_state = 7},
  [1491] = {.lex_state = 0},
  [1492] = {.lex_state = 0},
  [1493] = {.lex_state = 0},
  [1494] = {.lex_state = 0},
  [1495] = {.lex_state = 7},
  [1496] = {.lex_state = 19},
  [1497] = {.lex_state = 84},
  [1498] = {.lex_state = 0},
  [1499] = {.lex_state = 7},
  [1500] = {.lex_state = 7},
  [1501] = {.lex_state = 7},
  [1502] = {.lex_state = 7},
  [1503] = {.lex_state = 0},
  [1504] = {.lex_state = 7},
  [1505] = {.lex_state = 7},
  [1506] = {.lex_state = 7},
  [1507] = {.lex_state = 7},
  [1508] = {.lex_state = 7},
  [1509] = {.lex_state = 0},
  [1510] = {.lex_state = 7},
  [1511] = {.lex_state = 0},
  [1512] = {.lex_state = 7},
  [1513] = {.lex_state = 0},
  [1514] = {.lex_state = 0},
  [1515] = {.lex_state = 19},
  [1516] = {.lex_state = 0},
  [1517] = {.lex_state = 7},
  [1518] = {.lex_state = 0},
  [1519] = {.lex_state = 7},
  [1520] = {.lex_state = 7},
  [1521] = {.lex_state = 0},
  [1522] = {.lex_state = 7},
  [1523] = {.lex_state = 0},
  [1524] = {.lex_state = 7},
  [1525] = {.lex_state = 7},
  [1526] = {.lex_state = 0},
  [1527] = {.lex_state = 0},
  [1528] = {.lex_state = 7},
  [1529] = {.lex_state = 0},
  [1530] = {.lex_state = 0},
  [1531] = {.lex_state = 0},
  [1532] = {.lex_state = 7},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 0},
  [1535] = {.lex_state = 0},
  [1536] = {.lex_state = 0},
  [1537] = {.lex_state = 0},
  [1538] = {.lex_state = 0},
  [1539] = {.lex_state = 0},
  [1540] = {.lex_state = 7},
  [1541] = {.lex_state = 76},
  [1542] = {.lex_state = 0},
  [1543] = {.lex_state = 0},
  [1544] = {.lex_state = 7},
  [1545] = {.lex_state = 0},
  [1546] = {.lex_state = 0},
  [1547] = {.lex_state = 303},
  [1548] = {.lex_state = 0},
  [1549] = {.lex_state = 0},
  [1550] = {.lex_state = 0},
  [1551] = {.lex_state = 0},
  [1552] = {.lex_state = 0},
  [1553] = {.lex_state = 84},
  [1554] = {.lex_state = 7},
  [1555] = {.lex_state = 0},
  [1556] = {.lex_state = 7},
  [1557] = {.lex_state = 7},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 0},
  [1560] = {.lex_state = 7},
  [1561] = {.lex_state = 0},
  [1562] = {.lex_state = 0},
  [1563] = {.lex_state = 0},
  [1564] = {.lex_state = 76},
  [1565] = {.lex_state = 0},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 0},
  [1570] = {.lex_state = 0},
  [1571] = {.lex_state = 7},
  [1572] = {.lex_state = 0},
  [1573] = {.lex_state = 7},
  [1574] = {.lex_state = 0},
  [1575] = {.lex_state = 0},
  [1576] = {.lex_state = 0},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 7},
  [1579] = {.lex_state = 0},
  [1580] = {.lex_state = 0},
  [1581] = {.lex_state = 0},
  [1582] = {.lex_state = 0},
  [1583] = {.lex_state = 0},
  [1584] = {.lex_state = 0},
  [1585] = {.lex_state = 7},
  [1586] = {.lex_state = 7},
  [1587] = {.lex_state = 7},
  [1588] = {.lex_state = 0},
  [1589] = {.lex_state = 0},
  [1590] = {.lex_state = 0},
  [1591] = {.lex_state = 7},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 7},
  [1594] = {.lex_state = 0},
  [1595] = {.lex_state = 0},
  [1596] = {.lex_state = 0},
  [1597] = {.lex_state = 0},
  [1598] = {.lex_state = 7},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 0},
  [1601] = {.lex_state = 7},
  [1602] = {.lex_state = 0},
  [1603] = {.lex_state = 7},
  [1604] = {.lex_state = 0},
  [1605] = {.lex_state = 7},
  [1606] = {.lex_state = 7},
  [1607] = {.lex_state = 76},
  [1608] = {.lex_state = 84},
  [1609] = {.lex_state = 0},
  [1610] = {.lex_state = 0},
  [1611] = {.lex_state = 7},
  [1612] = {.lex_state = 0},
  [1613] = {.lex_state = 7},
  [1614] = {.lex_state = 7},
  [1615] = {.lex_state = 0},
  [1616] = {.lex_state = 0},
  [1617] = {.lex_state = 0},
  [1618] = {.lex_state = 7},
  [1619] = {.lex_state = 7},
  [1620] = {.lex_state = 7},
  [1621] = {.lex_state = 0},
  [1622] = {.lex_state = 7},
  [1623] = {.lex_state = 7},
  [1624] = {.lex_state = 7},
  [1625] = {.lex_state = 7},
  [1626] = {.lex_state = 7},
  [1627] = {.lex_state = 0},
  [1628] = {.lex_state = 7},
  [1629] = {.lex_state = 0},
  [1630] = {.lex_state = 0},
  [1631] = {.lex_state = 0},
  [1632] = {.lex_state = 7},
  [1633] = {.lex_state = 7},
  [1634] = {.lex_state = 7},
  [1635] = {.lex_state = 7},
  [1636] = {.lex_state = 7},
  [1637] = {.lex_state = 0},
  [1638] = {.lex_state = 7},
  [1639] = {.lex_state = 7},
  [1640] = {.lex_state = 7},
  [1641] = {.lex_state = 0},
  [1642] = {.lex_state = 0},
  [1643] = {.lex_state = 7},
  [1644] = {.lex_state = 0},
  [1645] = {.lex_state = 0},
  [1646] = {.lex_state = 0},
  [1647] = {.lex_state = 7},
  [1648] = {.lex_state = 0},
  [1649] = {.lex_state = 0},
  [1650] = {.lex_state = 0},
  [1651] = {.lex_state = 0},
  [1652] = {.lex_state = 0},
  [1653] = {.lex_state = 0},
  [1654] = {.lex_state = 0},
  [1655] = {.lex_state = 0},
  [1656] = {.lex_state = 0},
  [1657] = {.lex_state = 7},
  [1658] = {.lex_state = 0},
  [1659] = {.lex_state = 0},
  [1660] = {.lex_state = 0},
  [1661] = {.lex_state = 0},
  [1662] = {.lex_state = 7},
  [1663] = {.lex_state = 0},
  [1664] = {.lex_state = 0},
  [1665] = {.lex_state = 0},
  [1666] = {.lex_state = 0},
  [1667] = {.lex_state = 0},
  [1668] = {.lex_state = 0},
  [1669] = {.lex_state = 0},
  [1670] = {.lex_state = 0},
  [1671] = {.lex_state = 7},
  [1672] = {.lex_state = 0},
  [1673] = {.lex_state = 0},
  [1674] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_POUND_BANG] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_define] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_spec] = ACTIONS(1),
    [anon_sym_callback] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_bnot] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_div] = ACTIONS(1),
    [anon_sym_rem] = ACTIONS(1),
    [anon_sym_band] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_bor] = ACTIONS(1),
    [anon_sym_bxor] = ACTIONS(1),
    [anon_sym_bsl] = ACTIONS(1),
    [anon_sym_bsr] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_xor] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_EQ_LT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(1),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(1),
    [anon_sym_andalso] = ACTIONS(1),
    [anon_sym_orelse] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_fun] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_receive] = ACTIONS(1),
    [anon_sym_after] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_maybe] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [aux_sym_integer_token1] = ACTIONS(1),
    [aux_sym_integer_token2] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym__atom] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_variable] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_QMARK2] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_tripledot] = ACTIONS(1),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [1] = {
    [sym_source] = STATE(1645),
    [sym_shebang] = STATE(28),
    [sym__statement] = STATE(42),
    [sym_function] = STATE(1625),
    [sym__macro_declaration] = STATE(1624),
    [sym__spec] = STATE(1623),
    [sym_attribute] = STATE(1625),
    [sym__expression_without_call] = STATE(961),
    [sym__expression] = STATE(756),
    [sym_parenthesized_expression] = STATE(960),
    [sym_bitstring] = STATE(962),
    [sym_tuple] = STATE(758),
    [sym_list] = STATE(758),
    [sym_map] = STATE(962),
    [sym_record] = STATE(962),
    [sym_unary_operator] = STATE(758),
    [sym_binary_operator] = STATE(962),
    [sym__literal] = STATE(1458),
    [sym_anonymous_function] = STATE(758),
    [sym__named_stab_clause] = STATE(1459),
    [sym_call] = STATE(961),
    [sym__qualified_function] = STATE(1489),
    [sym__unqualified_function] = STATE(1487),
    [sym_function_capture] = STATE(962),
    [sym_function_type] = STATE(962),
    [sym_block] = STATE(962),
    [sym_if] = STATE(962),
    [sym_case] = STATE(962),
    [sym_receive] = STATE(962),
    [sym_try] = STATE(758),
    [sym_maybe] = STATE(962),
    [sym_character] = STATE(759),
    [sym__number] = STATE(960),
    [sym_integer] = STATE(760),
    [sym__identifier] = STATE(761),
    [sym_atom] = STATE(729),
    [sym__quoted_atom] = STATE(762),
    [sym_macro] = STATE(4),
    [sym__macro_constant] = STATE(45),
    [sym__macro_call] = STATE(46),
    [sym__strings] = STATE(962),
    [sym_string] = STATE(733),
    [sym_comment] = STATE(1),
    [sym_line_comment] = STATE(42),
    [aux_sym_source_repeat2] = STATE(42),
    [aux_sym__strings_repeat1] = STATE(715),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_POUND_BANG] = ACTIONS(7),
    [anon_sym_DASH] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LT_LT] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_not] = ACTIONS(23),
    [anon_sym_bnot] = ACTIONS(23),
    [anon_sym_catch] = ACTIONS(25),
    [anon_sym_fun] = ACTIONS(27),
    [anon_sym_begin] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_receive] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_maybe] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [aux_sym_integer_token1] = ACTIONS(41),
    [aux_sym_integer_token2] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [sym__atom] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [sym_variable] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(55),
    [sym_tripledot] = ACTIONS(57),
    [aux_sym_comment_token1] = ACTIONS(59),
  },
  [2] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(734),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(3),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(2),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_RBRACE] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_RBRACK] = ACTIONS(61),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(83),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [3] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(734),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(3),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(3),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(61),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_RBRACE] = ACTIONS(61),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_RBRACK] = ACTIONS(61),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(83),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [4] = {
    [sym__expression_without_call] = STATE(961),
    [sym__expression] = STATE(944),
    [sym_parenthesized_expression] = STATE(963),
    [sym_bitstring] = STATE(962),
    [sym_tuple] = STATE(752),
    [sym_list] = STATE(752),
    [sym_map] = STATE(962),
    [sym_record] = STATE(962),
    [sym_unary_operator] = STATE(752),
    [sym_binary_operator] = STATE(962),
    [sym__literal] = STATE(1458),
    [sym_anonymous_function] = STATE(752),
    [sym_call] = STATE(961),
    [sym__qualified_function] = STATE(1489),
    [sym__unqualified_function] = STATE(1487),
    [sym_function_capture] = STATE(962),
    [sym_function_type] = STATE(962),
    [sym_block] = STATE(962),
    [sym_if] = STATE(962),
    [sym_case] = STATE(962),
    [sym_receive] = STATE(962),
    [sym_try] = STATE(752),
    [sym_maybe] = STATE(962),
    [sym_character] = STATE(759),
    [sym__number] = STATE(963),
    [sym_integer] = STATE(760),
    [sym__identifier] = STATE(755),
    [sym_atom] = STATE(763),
    [sym__quoted_atom] = STATE(762),
    [sym_macro] = STATE(16),
    [sym__macro_constant] = STATE(55),
    [sym__macro_call] = STATE(62),
    [sym__strings] = STATE(962),
    [sym_string] = STATE(733),
    [sym_comment] = STATE(4),
    [aux_sym_function_repeat1] = STATE(1476),
    [aux_sym__strings_repeat1] = STATE(715),
    [ts_builtin_sym_end] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(64),
    [anon_sym_LF] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(115),
    [anon_sym_SEMI] = ACTIONS(119),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LT_LT] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(123),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_POUND] = ACTIONS(64),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(23),
    [anon_sym_bnot] = ACTIONS(23),
    [anon_sym_catch] = ACTIONS(25),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(64),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(64),
    [anon_sym_DASH_DASH] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(64),
    [anon_sym_SLASH_EQ] = ACTIONS(64),
    [anon_sym_EQ_LT] = ACTIONS(64),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(64),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(64),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(64),
    [anon_sym_QMARK_EQ] = ACTIONS(64),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(64),
    [anon_sym_COLON_COLON] = ACTIONS(64),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(64),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_GT] = ACTIONS(64),
    [anon_sym_COLON_EQ] = ACTIONS(64),
    [anon_sym_fun] = ACTIONS(127),
    [anon_sym_begin] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_receive] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_maybe] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [aux_sym_integer_token1] = ACTIONS(41),
    [aux_sym_integer_token2] = ACTIONS(41),
    [sym_float] = ACTIONS(131),
    [sym__atom] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(133),
    [sym_variable] = ACTIONS(135),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(109),
    [sym_tripledot] = ACTIONS(137),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [5] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(987),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym_arguments] = STATE(1619),
    [sym__items] = STATE(1618),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(5),
    [aux_sym__strings_repeat1] = STATE(713),
    [ts_builtin_sym_end] = ACTIONS(67),
    [anon_sym_COMMA] = ACTIONS(81),
    [anon_sym_LF] = ACTIONS(67),
    [anon_sym_DOT] = ACTIONS(141),
    [anon_sym_DASH] = ACTIONS(144),
    [anon_sym_LPAREN] = ACTIONS(147),
    [anon_sym_COLON] = ACTIONS(81),
    [anon_sym_when] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(150),
    [anon_sym_LBRACE] = ACTIONS(152),
    [anon_sym_LBRACK] = ACTIONS(154),
    [anon_sym_POUND] = ACTIONS(156),
    [anon_sym_PLUS] = ACTIONS(144),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_SLASH] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_div] = ACTIONS(81),
    [anon_sym_rem] = ACTIONS(81),
    [anon_sym_band] = ACTIONS(81),
    [anon_sym_and] = ACTIONS(81),
    [anon_sym_bor] = ACTIONS(81),
    [anon_sym_bxor] = ACTIONS(81),
    [anon_sym_bsl] = ACTIONS(81),
    [anon_sym_bsr] = ACTIONS(81),
    [anon_sym_or] = ACTIONS(81),
    [anon_sym_xor] = ACTIONS(81),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [anon_sym_EQ_EQ] = ACTIONS(81),
    [anon_sym_SLASH_EQ] = ACTIONS(81),
    [anon_sym_EQ_LT] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(81),
    [anon_sym_GT_EQ] = ACTIONS(81),
    [anon_sym_GT] = ACTIONS(81),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(81),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(81),
    [anon_sym_andalso] = ACTIONS(81),
    [anon_sym_orelse] = ACTIONS(81),
    [anon_sym_EQ] = ACTIONS(81),
    [anon_sym_BANG] = ACTIONS(81),
    [anon_sym_QMARK_EQ] = ACTIONS(81),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(81),
    [anon_sym_COLON_COLON] = ACTIONS(81),
    [anon_sym_PIPE] = ACTIONS(81),
    [anon_sym_LT_DASH] = ACTIONS(81),
    [anon_sym_LT_EQ] = ACTIONS(81),
    [anon_sym_EQ_GT] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(81),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(97),
    [sym_float] = ACTIONS(167),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(169),
    [sym_variable] = ACTIONS(171),
    [anon_sym_QMARK] = ACTIONS(173),
    [anon_sym_DQUOTE] = ACTIONS(175),
    [sym_tripledot] = ACTIONS(177),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [6] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(942),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(6),
    [sym__macro_constant] = STATE(51),
    [sym__macro_call] = STATE(60),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(6),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(179),
    [anon_sym_bnot] = ACTIONS(179),
    [anon_sym_catch] = ACTIONS(181),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(183),
    [anon_sym_end] = ACTIONS(64),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_after] = ACTIONS(64),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [7] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(797),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(7),
    [sym__macro_constant] = STATE(56),
    [sym__macro_call] = STATE(74),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(7),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(185),
    [anon_sym_bnot] = ACTIONS(185),
    [anon_sym_catch] = ACTIONS(64),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(187),
    [anon_sym_end] = ACTIONS(64),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_of] = ACTIONS(64),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_after] = ACTIONS(64),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [8] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(734),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(3),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(8),
    [aux_sym_function_repeat1] = STATE(1451),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(189),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(83),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [9] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(797),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(7),
    [sym__macro_constant] = STATE(56),
    [sym__macro_call] = STATE(74),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(9),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(185),
    [anon_sym_bnot] = ACTIONS(185),
    [anon_sym_catch] = ACTIONS(64),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(187),
    [anon_sym_end] = ACTIONS(64),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_of] = ACTIONS(64),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_after] = ACTIONS(64),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [10] = {
    [sym__expression_without_call] = STATE(961),
    [sym__expression] = STATE(944),
    [sym_parenthesized_expression] = STATE(963),
    [sym_bitstring] = STATE(962),
    [sym_tuple] = STATE(752),
    [sym_list] = STATE(752),
    [sym_map] = STATE(962),
    [sym_record] = STATE(962),
    [sym_unary_operator] = STATE(752),
    [sym_binary_operator] = STATE(962),
    [sym__literal] = STATE(1458),
    [sym_anonymous_function] = STATE(752),
    [sym_call] = STATE(961),
    [sym__qualified_function] = STATE(1489),
    [sym__unqualified_function] = STATE(1487),
    [sym_function_capture] = STATE(962),
    [sym_function_type] = STATE(962),
    [sym_block] = STATE(962),
    [sym_if] = STATE(962),
    [sym_case] = STATE(962),
    [sym_receive] = STATE(962),
    [sym_try] = STATE(752),
    [sym_maybe] = STATE(962),
    [sym_character] = STATE(759),
    [sym__number] = STATE(963),
    [sym_integer] = STATE(760),
    [sym__identifier] = STATE(755),
    [sym_atom] = STATE(763),
    [sym__quoted_atom] = STATE(762),
    [sym_macro] = STATE(16),
    [sym__macro_constant] = STATE(55),
    [sym__macro_call] = STATE(62),
    [sym__strings] = STATE(962),
    [sym_string] = STATE(733),
    [sym_comment] = STATE(10),
    [aux_sym__strings_repeat1] = STATE(715),
    [ts_builtin_sym_end] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(64),
    [anon_sym_LF] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(64),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LT_LT] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(123),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_POUND] = ACTIONS(64),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(23),
    [anon_sym_bnot] = ACTIONS(23),
    [anon_sym_catch] = ACTIONS(25),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(64),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(64),
    [anon_sym_DASH_DASH] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(64),
    [anon_sym_SLASH_EQ] = ACTIONS(64),
    [anon_sym_EQ_LT] = ACTIONS(64),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(64),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(64),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(64),
    [anon_sym_QMARK_EQ] = ACTIONS(64),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(64),
    [anon_sym_COLON_COLON] = ACTIONS(64),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(64),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_GT] = ACTIONS(64),
    [anon_sym_COLON_EQ] = ACTIONS(64),
    [anon_sym_fun] = ACTIONS(127),
    [anon_sym_begin] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_receive] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_maybe] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [aux_sym_integer_token1] = ACTIONS(41),
    [aux_sym_integer_token2] = ACTIONS(41),
    [sym_float] = ACTIONS(131),
    [sym__atom] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(133),
    [sym_variable] = ACTIONS(135),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(109),
    [sym_tripledot] = ACTIONS(137),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [11] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(950),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(815),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(14),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(11),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(64),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(194),
    [anon_sym_bnot] = ACTIONS(194),
    [anon_sym_catch] = ACTIONS(196),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(198),
    [anon_sym_DASH_GT] = ACTIONS(61),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [12] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(788),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(15),
    [sym__macro_constant] = STATE(51),
    [sym__macro_call] = STATE(60),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(12),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(200),
    [anon_sym_bnot] = ACTIONS(200),
    [anon_sym_catch] = ACTIONS(64),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(202),
    [anon_sym_end] = ACTIONS(64),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_after] = ACTIONS(64),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [13] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(942),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(6),
    [sym__macro_constant] = STATE(51),
    [sym__macro_call] = STATE(60),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(13),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(179),
    [anon_sym_bnot] = ACTIONS(179),
    [anon_sym_catch] = ACTIONS(181),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(183),
    [anon_sym_end] = ACTIONS(64),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_after] = ACTIONS(64),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [14] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(950),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(815),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(14),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(14),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(64),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(194),
    [anon_sym_bnot] = ACTIONS(194),
    [anon_sym_catch] = ACTIONS(196),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(198),
    [anon_sym_DASH_GT] = ACTIONS(61),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [15] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(788),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(15),
    [sym__macro_constant] = STATE(51),
    [sym__macro_call] = STATE(60),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(15),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(200),
    [anon_sym_bnot] = ACTIONS(200),
    [anon_sym_catch] = ACTIONS(64),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(202),
    [anon_sym_end] = ACTIONS(64),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_after] = ACTIONS(64),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [16] = {
    [sym__expression_without_call] = STATE(961),
    [sym__expression] = STATE(944),
    [sym_parenthesized_expression] = STATE(963),
    [sym_bitstring] = STATE(962),
    [sym_tuple] = STATE(752),
    [sym_list] = STATE(752),
    [sym_map] = STATE(962),
    [sym_record] = STATE(962),
    [sym_unary_operator] = STATE(752),
    [sym_binary_operator] = STATE(962),
    [sym__literal] = STATE(1458),
    [sym_anonymous_function] = STATE(752),
    [sym_call] = STATE(961),
    [sym__qualified_function] = STATE(1489),
    [sym__unqualified_function] = STATE(1487),
    [sym_function_capture] = STATE(962),
    [sym_function_type] = STATE(962),
    [sym_block] = STATE(962),
    [sym_if] = STATE(962),
    [sym_case] = STATE(962),
    [sym_receive] = STATE(962),
    [sym_try] = STATE(752),
    [sym_maybe] = STATE(962),
    [sym_character] = STATE(759),
    [sym__number] = STATE(963),
    [sym_integer] = STATE(760),
    [sym__identifier] = STATE(755),
    [sym_atom] = STATE(763),
    [sym__quoted_atom] = STATE(762),
    [sym_macro] = STATE(16),
    [sym__macro_constant] = STATE(55),
    [sym__macro_call] = STATE(62),
    [sym__strings] = STATE(962),
    [sym_string] = STATE(733),
    [sym_comment] = STATE(16),
    [aux_sym__strings_repeat1] = STATE(715),
    [ts_builtin_sym_end] = ACTIONS(61),
    [anon_sym_COMMA] = ACTIONS(64),
    [anon_sym_LF] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(64),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(64),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LT_LT] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(123),
    [anon_sym_LBRACK] = ACTIONS(125),
    [anon_sym_POUND] = ACTIONS(64),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(23),
    [anon_sym_bnot] = ACTIONS(23),
    [anon_sym_catch] = ACTIONS(25),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(64),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(64),
    [anon_sym_DASH_DASH] = ACTIONS(64),
    [anon_sym_EQ_EQ] = ACTIONS(64),
    [anon_sym_SLASH_EQ] = ACTIONS(64),
    [anon_sym_EQ_LT] = ACTIONS(64),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(64),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(64),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(64),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(64),
    [anon_sym_QMARK_EQ] = ACTIONS(64),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(64),
    [anon_sym_COLON_COLON] = ACTIONS(64),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(64),
    [anon_sym_LT_EQ] = ACTIONS(64),
    [anon_sym_EQ_GT] = ACTIONS(64),
    [anon_sym_COLON_EQ] = ACTIONS(64),
    [anon_sym_fun] = ACTIONS(127),
    [anon_sym_begin] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_receive] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_maybe] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(129),
    [aux_sym_integer_token1] = ACTIONS(41),
    [aux_sym_integer_token2] = ACTIONS(41),
    [sym_float] = ACTIONS(131),
    [sym__atom] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(133),
    [sym_variable] = ACTIONS(135),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(109),
    [sym_tripledot] = ACTIONS(137),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [17] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(734),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(3),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(17),
    [aux_sym_function_repeat1] = STATE(1451),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(189),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(204),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(83),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [18] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1054),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(18),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(18),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(212),
    [anon_sym_end] = ACTIONS(64),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [19] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1054),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(18),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(19),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(212),
    [anon_sym_end] = ACTIONS(64),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [20] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(981),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(25),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(20),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(218),
    [anon_sym_DASH_GT] = ACTIONS(61),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [21] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(984),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(815),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(21),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(21),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(64),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(220),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [22] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1034),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(22),
    [sym__macro_constant] = STATE(77),
    [sym__macro_call] = STATE(108),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(22),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(222),
    [anon_sym_bnot] = ACTIONS(222),
    [anon_sym_catch] = ACTIONS(224),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(226),
    [anon_sym_end] = ACTIONS(64),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_else] = ACTIONS(64),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [23] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(984),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(815),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(21),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(23),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(64),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(220),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [24] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1034),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(22),
    [sym__macro_constant] = STATE(77),
    [sym__macro_call] = STATE(108),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(24),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(222),
    [anon_sym_bnot] = ACTIONS(222),
    [anon_sym_catch] = ACTIONS(224),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(226),
    [anon_sym_end] = ACTIONS(64),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_else] = ACTIONS(64),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [25] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(981),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(25),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(25),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_COMMA] = ACTIONS(61),
    [anon_sym_SEMI] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(218),
    [anon_sym_DASH_GT] = ACTIONS(61),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [26] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1171),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(26),
    [sym__macro_constant] = STATE(112),
    [sym__macro_call] = STATE(118),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(26),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(61),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(228),
    [anon_sym_bnot] = ACTIONS(228),
    [anon_sym_catch] = ACTIONS(230),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(232),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_of] = ACTIONS(64),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [27] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1171),
    [sym_parenthesized_expression] = STATE(690),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(641),
    [sym_list] = STATE(641),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(641),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(641),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(641),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(690),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(689),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(26),
    [sym__macro_constant] = STATE(112),
    [sym__macro_call] = STATE(118),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(27),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(64),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_COLON] = ACTIONS(64),
    [anon_sym_when] = ACTIONS(64),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(64),
    [anon_sym_not] = ACTIONS(228),
    [anon_sym_bnot] = ACTIONS(228),
    [anon_sym_catch] = ACTIONS(230),
    [anon_sym_SLASH] = ACTIONS(64),
    [anon_sym_STAR] = ACTIONS(61),
    [anon_sym_div] = ACTIONS(64),
    [anon_sym_rem] = ACTIONS(64),
    [anon_sym_band] = ACTIONS(64),
    [anon_sym_and] = ACTIONS(64),
    [anon_sym_bor] = ACTIONS(64),
    [anon_sym_bxor] = ACTIONS(64),
    [anon_sym_bsl] = ACTIONS(64),
    [anon_sym_bsr] = ACTIONS(64),
    [anon_sym_or] = ACTIONS(64),
    [anon_sym_xor] = ACTIONS(64),
    [anon_sym_PLUS_PLUS] = ACTIONS(61),
    [anon_sym_DASH_DASH] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(61),
    [anon_sym_SLASH_EQ] = ACTIONS(61),
    [anon_sym_EQ_LT] = ACTIONS(61),
    [anon_sym_LT] = ACTIONS(64),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(64),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(61),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(61),
    [anon_sym_andalso] = ACTIONS(64),
    [anon_sym_orelse] = ACTIONS(64),
    [anon_sym_EQ] = ACTIONS(64),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_QMARK_EQ] = ACTIONS(61),
    [anon_sym_DOT_DOT] = ACTIONS(81),
    [anon_sym_PIPE_PIPE] = ACTIONS(61),
    [anon_sym_COLON_COLON] = ACTIONS(61),
    [anon_sym_PIPE] = ACTIONS(64),
    [anon_sym_LT_DASH] = ACTIONS(61),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_GT] = ACTIONS(61),
    [anon_sym_COLON_EQ] = ACTIONS(61),
    [anon_sym_fun] = ACTIONS(232),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_of] = ACTIONS(64),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(109),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [28] = {
    [sym_shebang] = STATE(1565),
    [sym__statement] = STATE(41),
    [sym_function] = STATE(1625),
    [sym__macro_declaration] = STATE(1624),
    [sym__spec] = STATE(1623),
    [sym_attribute] = STATE(1625),
    [sym__expression_without_call] = STATE(961),
    [sym__expression] = STATE(780),
    [sym_parenthesized_expression] = STATE(960),
    [sym_bitstring] = STATE(962),
    [sym_tuple] = STATE(758),
    [sym_list] = STATE(758),
    [sym_map] = STATE(962),
    [sym_record] = STATE(962),
    [sym_unary_operator] = STATE(758),
    [sym_binary_operator] = STATE(962),
    [sym__literal] = STATE(1458),
    [sym_anonymous_function] = STATE(758),
    [sym__named_stab_clause] = STATE(1459),
    [sym_call] = STATE(961),
    [sym__qualified_function] = STATE(1489),
    [sym__unqualified_function] = STATE(1487),
    [sym_function_capture] = STATE(962),
    [sym_function_type] = STATE(962),
    [sym_block] = STATE(962),
    [sym_if] = STATE(962),
    [sym_case] = STATE(962),
    [sym_receive] = STATE(962),
    [sym_try] = STATE(758),
    [sym_maybe] = STATE(962),
    [sym_character] = STATE(759),
    [sym__number] = STATE(960),
    [sym_integer] = STATE(760),
    [sym__identifier] = STATE(761),
    [sym_atom] = STATE(729),
    [sym__quoted_atom] = STATE(762),
    [sym_macro] = STATE(4),
    [sym__macro_constant] = STATE(45),
    [sym__macro_call] = STATE(46),
    [sym__strings] = STATE(962),
    [sym_string] = STATE(733),
    [sym_comment] = STATE(28),
    [sym_line_comment] = STATE(41),
    [aux_sym_source_repeat2] = STATE(41),
    [aux_sym__strings_repeat1] = STATE(715),
    [ts_builtin_sym_end] = ACTIONS(234),
    [anon_sym_POUND_BANG] = ACTIONS(236),
    [anon_sym_DASH] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LT_LT] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(21),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_not] = ACTIONS(23),
    [anon_sym_bnot] = ACTIONS(23),
    [anon_sym_catch] = ACTIONS(25),
    [anon_sym_fun] = ACTIONS(27),
    [anon_sym_begin] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_receive] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_maybe] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [aux_sym_integer_token1] = ACTIONS(41),
    [aux_sym_integer_token2] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [sym__atom] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [sym_variable] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(55),
    [sym_tripledot] = ACTIONS(57),
    [aux_sym_comment_token1] = ACTIONS(59),
  },
  [29] = {
    [sym_arguments] = STATE(31),
    [sym_comment] = STATE(29),
    [anon_sym_COMMA] = ACTIONS(238),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_SEMI] = ACTIONS(238),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(242),
    [anon_sym_RPAREN] = ACTIONS(238),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_when] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_GT_GT] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_RBRACE] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_RBRACK] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(238),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_bnot] = ACTIONS(240),
    [anon_sym_catch] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(238),
    [anon_sym_div] = ACTIONS(240),
    [anon_sym_rem] = ACTIONS(240),
    [anon_sym_band] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_bor] = ACTIONS(240),
    [anon_sym_bxor] = ACTIONS(240),
    [anon_sym_bsl] = ACTIONS(240),
    [anon_sym_bsr] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_xor] = ACTIONS(240),
    [anon_sym_PLUS_PLUS] = ACTIONS(238),
    [anon_sym_DASH_DASH] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_EQ_LT] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(238),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(238),
    [anon_sym_andalso] = ACTIONS(240),
    [anon_sym_orelse] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_QMARK_EQ] = ACTIONS(238),
    [anon_sym_DOT_DOT] = ACTIONS(240),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_LT_DASH] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_EQ_GT] = ACTIONS(238),
    [anon_sym_COLON_EQ] = ACTIONS(238),
    [anon_sym_fun] = ACTIONS(240),
    [anon_sym_DASH_GT] = ACTIONS(238),
    [anon_sym_begin] = ACTIONS(240),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_receive] = ACTIONS(240),
    [anon_sym_try] = ACTIONS(240),
    [anon_sym_maybe] = ACTIONS(240),
    [anon_sym_DOLLAR] = ACTIONS(238),
    [aux_sym_integer_token1] = ACTIONS(240),
    [aux_sym_integer_token2] = ACTIONS(238),
    [sym_float] = ACTIONS(238),
    [sym__atom] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [sym_variable] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(240),
    [anon_sym_DQUOTE] = ACTIONS(238),
    [sym_tripledot] = ACTIONS(238),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [30] = {
    [sym_comment] = STATE(30),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_DOT] = ACTIONS(246),
    [anon_sym_SEMI] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_RPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_GT_GT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_RBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_RBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_DASH_GT] = ACTIONS(244),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym__atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [31] = {
    [sym_comment] = STATE(31),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_DOT] = ACTIONS(250),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_RPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_GT_GT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_RBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_RBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_DASH_GT] = ACTIONS(248),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym__atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [32] = {
    [sym_comment] = STATE(32),
    [anon_sym_COMMA] = ACTIONS(252),
    [anon_sym_DOT] = ACTIONS(254),
    [anon_sym_SEMI] = ACTIONS(252),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_GT_GT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_RBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_RBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_DASH_GT] = ACTIONS(252),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym__atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [33] = {
    [sym_comment] = STATE(33),
    [anon_sym_COMMA] = ACTIONS(256),
    [anon_sym_DOT] = ACTIONS(258),
    [anon_sym_SEMI] = ACTIONS(256),
    [anon_sym_DASH] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(256),
    [anon_sym_RPAREN] = ACTIONS(256),
    [anon_sym_COLON] = ACTIONS(258),
    [anon_sym_when] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_LT_LT] = ACTIONS(256),
    [anon_sym_GT_GT] = ACTIONS(256),
    [anon_sym_LBRACE] = ACTIONS(256),
    [anon_sym_RBRACE] = ACTIONS(256),
    [anon_sym_LBRACK] = ACTIONS(256),
    [anon_sym_RBRACK] = ACTIONS(256),
    [anon_sym_POUND] = ACTIONS(256),
    [anon_sym_PLUS] = ACTIONS(258),
    [anon_sym_not] = ACTIONS(258),
    [anon_sym_bnot] = ACTIONS(258),
    [anon_sym_catch] = ACTIONS(258),
    [anon_sym_SLASH] = ACTIONS(258),
    [anon_sym_STAR] = ACTIONS(256),
    [anon_sym_div] = ACTIONS(258),
    [anon_sym_rem] = ACTIONS(258),
    [anon_sym_band] = ACTIONS(258),
    [anon_sym_and] = ACTIONS(258),
    [anon_sym_bor] = ACTIONS(258),
    [anon_sym_bxor] = ACTIONS(258),
    [anon_sym_bsl] = ACTIONS(258),
    [anon_sym_bsr] = ACTIONS(258),
    [anon_sym_or] = ACTIONS(258),
    [anon_sym_xor] = ACTIONS(258),
    [anon_sym_PLUS_PLUS] = ACTIONS(256),
    [anon_sym_DASH_DASH] = ACTIONS(256),
    [anon_sym_EQ_EQ] = ACTIONS(256),
    [anon_sym_SLASH_EQ] = ACTIONS(256),
    [anon_sym_EQ_LT] = ACTIONS(256),
    [anon_sym_LT] = ACTIONS(258),
    [anon_sym_GT_EQ] = ACTIONS(256),
    [anon_sym_GT] = ACTIONS(258),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(256),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(256),
    [anon_sym_andalso] = ACTIONS(258),
    [anon_sym_orelse] = ACTIONS(258),
    [anon_sym_EQ] = ACTIONS(258),
    [anon_sym_BANG] = ACTIONS(256),
    [anon_sym_QMARK_EQ] = ACTIONS(256),
    [anon_sym_DOT_DOT] = ACTIONS(258),
    [anon_sym_PIPE_PIPE] = ACTIONS(256),
    [anon_sym_COLON_COLON] = ACTIONS(256),
    [anon_sym_PIPE] = ACTIONS(258),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_LT_EQ] = ACTIONS(256),
    [anon_sym_EQ_GT] = ACTIONS(256),
    [anon_sym_COLON_EQ] = ACTIONS(256),
    [anon_sym_fun] = ACTIONS(258),
    [anon_sym_DASH_GT] = ACTIONS(256),
    [anon_sym_begin] = ACTIONS(258),
    [anon_sym_case] = ACTIONS(258),
    [anon_sym_receive] = ACTIONS(258),
    [anon_sym_try] = ACTIONS(258),
    [anon_sym_maybe] = ACTIONS(258),
    [anon_sym_DOLLAR] = ACTIONS(256),
    [aux_sym_integer_token1] = ACTIONS(258),
    [aux_sym_integer_token2] = ACTIONS(256),
    [sym_float] = ACTIONS(256),
    [sym__atom] = ACTIONS(258),
    [anon_sym_SQUOTE] = ACTIONS(256),
    [sym_variable] = ACTIONS(256),
    [anon_sym_QMARK] = ACTIONS(258),
    [anon_sym_DQUOTE] = ACTIONS(256),
    [sym_tripledot] = ACTIONS(256),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [34] = {
    [sym_comment] = STATE(34),
    [anon_sym_COMMA] = ACTIONS(260),
    [anon_sym_DOT] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(260),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_LPAREN] = ACTIONS(260),
    [anon_sym_RPAREN] = ACTIONS(260),
    [anon_sym_COLON] = ACTIONS(262),
    [anon_sym_when] = ACTIONS(262),
    [anon_sym_if] = ACTIONS(262),
    [anon_sym_LT_LT] = ACTIONS(260),
    [anon_sym_GT_GT] = ACTIONS(260),
    [anon_sym_LBRACE] = ACTIONS(260),
    [anon_sym_RBRACE] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(260),
    [anon_sym_RBRACK] = ACTIONS(260),
    [anon_sym_POUND] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_not] = ACTIONS(262),
    [anon_sym_bnot] = ACTIONS(262),
    [anon_sym_catch] = ACTIONS(262),
    [anon_sym_SLASH] = ACTIONS(262),
    [anon_sym_STAR] = ACTIONS(260),
    [anon_sym_div] = ACTIONS(262),
    [anon_sym_rem] = ACTIONS(262),
    [anon_sym_band] = ACTIONS(262),
    [anon_sym_and] = ACTIONS(262),
    [anon_sym_bor] = ACTIONS(262),
    [anon_sym_bxor] = ACTIONS(262),
    [anon_sym_bsl] = ACTIONS(262),
    [anon_sym_bsr] = ACTIONS(262),
    [anon_sym_or] = ACTIONS(262),
    [anon_sym_xor] = ACTIONS(262),
    [anon_sym_PLUS_PLUS] = ACTIONS(260),
    [anon_sym_DASH_DASH] = ACTIONS(260),
    [anon_sym_EQ_EQ] = ACTIONS(260),
    [anon_sym_SLASH_EQ] = ACTIONS(260),
    [anon_sym_EQ_LT] = ACTIONS(260),
    [anon_sym_LT] = ACTIONS(262),
    [anon_sym_GT_EQ] = ACTIONS(260),
    [anon_sym_GT] = ACTIONS(262),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(260),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(260),
    [anon_sym_andalso] = ACTIONS(262),
    [anon_sym_orelse] = ACTIONS(262),
    [anon_sym_EQ] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(260),
    [anon_sym_QMARK_EQ] = ACTIONS(260),
    [anon_sym_DOT_DOT] = ACTIONS(262),
    [anon_sym_PIPE_PIPE] = ACTIONS(260),
    [anon_sym_COLON_COLON] = ACTIONS(260),
    [anon_sym_PIPE] = ACTIONS(262),
    [anon_sym_LT_DASH] = ACTIONS(260),
    [anon_sym_LT_EQ] = ACTIONS(260),
    [anon_sym_EQ_GT] = ACTIONS(260),
    [anon_sym_COLON_EQ] = ACTIONS(260),
    [anon_sym_fun] = ACTIONS(262),
    [anon_sym_DASH_GT] = ACTIONS(260),
    [anon_sym_begin] = ACTIONS(262),
    [anon_sym_case] = ACTIONS(262),
    [anon_sym_receive] = ACTIONS(262),
    [anon_sym_try] = ACTIONS(262),
    [anon_sym_maybe] = ACTIONS(262),
    [anon_sym_DOLLAR] = ACTIONS(260),
    [aux_sym_integer_token1] = ACTIONS(262),
    [aux_sym_integer_token2] = ACTIONS(260),
    [sym_float] = ACTIONS(260),
    [sym__atom] = ACTIONS(262),
    [anon_sym_SQUOTE] = ACTIONS(260),
    [sym_variable] = ACTIONS(260),
    [anon_sym_QMARK] = ACTIONS(262),
    [anon_sym_DQUOTE] = ACTIONS(260),
    [sym_tripledot] = ACTIONS(260),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [35] = {
    [sym_comment] = STATE(35),
    [anon_sym_COMMA] = ACTIONS(264),
    [anon_sym_DOT] = ACTIONS(266),
    [anon_sym_SEMI] = ACTIONS(264),
    [anon_sym_DASH] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_RPAREN] = ACTIONS(264),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_when] = ACTIONS(266),
    [anon_sym_if] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(264),
    [anon_sym_GT_GT] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(264),
    [anon_sym_RBRACE] = ACTIONS(264),
    [anon_sym_LBRACK] = ACTIONS(264),
    [anon_sym_RBRACK] = ACTIONS(264),
    [anon_sym_POUND] = ACTIONS(264),
    [anon_sym_PLUS] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(266),
    [anon_sym_bnot] = ACTIONS(266),
    [anon_sym_catch] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(266),
    [anon_sym_STAR] = ACTIONS(264),
    [anon_sym_div] = ACTIONS(266),
    [anon_sym_rem] = ACTIONS(266),
    [anon_sym_band] = ACTIONS(266),
    [anon_sym_and] = ACTIONS(266),
    [anon_sym_bor] = ACTIONS(266),
    [anon_sym_bxor] = ACTIONS(266),
    [anon_sym_bsl] = ACTIONS(266),
    [anon_sym_bsr] = ACTIONS(266),
    [anon_sym_or] = ACTIONS(266),
    [anon_sym_xor] = ACTIONS(266),
    [anon_sym_PLUS_PLUS] = ACTIONS(264),
    [anon_sym_DASH_DASH] = ACTIONS(264),
    [anon_sym_EQ_EQ] = ACTIONS(264),
    [anon_sym_SLASH_EQ] = ACTIONS(264),
    [anon_sym_EQ_LT] = ACTIONS(264),
    [anon_sym_LT] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(264),
    [anon_sym_GT] = ACTIONS(266),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(264),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(264),
    [anon_sym_andalso] = ACTIONS(266),
    [anon_sym_orelse] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(266),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_QMARK_EQ] = ACTIONS(264),
    [anon_sym_DOT_DOT] = ACTIONS(266),
    [anon_sym_PIPE_PIPE] = ACTIONS(264),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_LT_DASH] = ACTIONS(264),
    [anon_sym_LT_EQ] = ACTIONS(264),
    [anon_sym_EQ_GT] = ACTIONS(264),
    [anon_sym_COLON_EQ] = ACTIONS(264),
    [anon_sym_fun] = ACTIONS(266),
    [anon_sym_DASH_GT] = ACTIONS(264),
    [anon_sym_begin] = ACTIONS(266),
    [anon_sym_case] = ACTIONS(266),
    [anon_sym_receive] = ACTIONS(266),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_maybe] = ACTIONS(266),
    [anon_sym_DOLLAR] = ACTIONS(264),
    [aux_sym_integer_token1] = ACTIONS(266),
    [aux_sym_integer_token2] = ACTIONS(264),
    [sym_float] = ACTIONS(264),
    [sym__atom] = ACTIONS(266),
    [anon_sym_SQUOTE] = ACTIONS(264),
    [sym_variable] = ACTIONS(264),
    [anon_sym_QMARK] = ACTIONS(266),
    [anon_sym_DQUOTE] = ACTIONS(264),
    [sym_tripledot] = ACTIONS(264),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [36] = {
    [sym_comment] = STATE(36),
    [anon_sym_COMMA] = ACTIONS(268),
    [anon_sym_DOT] = ACTIONS(270),
    [anon_sym_SEMI] = ACTIONS(268),
    [anon_sym_DASH] = ACTIONS(270),
    [anon_sym_LPAREN] = ACTIONS(268),
    [anon_sym_RPAREN] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_when] = ACTIONS(270),
    [anon_sym_if] = ACTIONS(270),
    [anon_sym_LT_LT] = ACTIONS(268),
    [anon_sym_GT_GT] = ACTIONS(268),
    [anon_sym_LBRACE] = ACTIONS(268),
    [anon_sym_RBRACE] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(268),
    [anon_sym_RBRACK] = ACTIONS(268),
    [anon_sym_POUND] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(270),
    [anon_sym_not] = ACTIONS(270),
    [anon_sym_bnot] = ACTIONS(270),
    [anon_sym_catch] = ACTIONS(270),
    [anon_sym_SLASH] = ACTIONS(270),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_div] = ACTIONS(270),
    [anon_sym_rem] = ACTIONS(270),
    [anon_sym_band] = ACTIONS(270),
    [anon_sym_and] = ACTIONS(270),
    [anon_sym_bor] = ACTIONS(270),
    [anon_sym_bxor] = ACTIONS(270),
    [anon_sym_bsl] = ACTIONS(270),
    [anon_sym_bsr] = ACTIONS(270),
    [anon_sym_or] = ACTIONS(270),
    [anon_sym_xor] = ACTIONS(270),
    [anon_sym_PLUS_PLUS] = ACTIONS(268),
    [anon_sym_DASH_DASH] = ACTIONS(268),
    [anon_sym_EQ_EQ] = ACTIONS(268),
    [anon_sym_SLASH_EQ] = ACTIONS(268),
    [anon_sym_EQ_LT] = ACTIONS(268),
    [anon_sym_LT] = ACTIONS(270),
    [anon_sym_GT_EQ] = ACTIONS(268),
    [anon_sym_GT] = ACTIONS(270),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(268),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(268),
    [anon_sym_andalso] = ACTIONS(270),
    [anon_sym_orelse] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(270),
    [anon_sym_BANG] = ACTIONS(268),
    [anon_sym_QMARK_EQ] = ACTIONS(268),
    [anon_sym_DOT_DOT] = ACTIONS(270),
    [anon_sym_PIPE_PIPE] = ACTIONS(268),
    [anon_sym_COLON_COLON] = ACTIONS(268),
    [anon_sym_PIPE] = ACTIONS(270),
    [anon_sym_LT_DASH] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(268),
    [anon_sym_EQ_GT] = ACTIONS(268),
    [anon_sym_COLON_EQ] = ACTIONS(268),
    [anon_sym_fun] = ACTIONS(270),
    [anon_sym_DASH_GT] = ACTIONS(268),
    [anon_sym_begin] = ACTIONS(270),
    [anon_sym_case] = ACTIONS(270),
    [anon_sym_receive] = ACTIONS(270),
    [anon_sym_try] = ACTIONS(270),
    [anon_sym_maybe] = ACTIONS(270),
    [anon_sym_DOLLAR] = ACTIONS(268),
    [aux_sym_integer_token1] = ACTIONS(270),
    [aux_sym_integer_token2] = ACTIONS(268),
    [sym_float] = ACTIONS(268),
    [sym__atom] = ACTIONS(270),
    [anon_sym_SQUOTE] = ACTIONS(268),
    [sym_variable] = ACTIONS(268),
    [anon_sym_QMARK] = ACTIONS(270),
    [anon_sym_DQUOTE] = ACTIONS(268),
    [sym_tripledot] = ACTIONS(268),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [37] = {
    [sym_comment] = STATE(37),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_SEMI] = ACTIONS(272),
    [anon_sym_DASH] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(272),
    [anon_sym_RPAREN] = ACTIONS(272),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_when] = ACTIONS(274),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_RBRACE] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(272),
    [anon_sym_RBRACK] = ACTIONS(272),
    [anon_sym_POUND] = ACTIONS(272),
    [anon_sym_PLUS] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_bnot] = ACTIONS(274),
    [anon_sym_catch] = ACTIONS(274),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(272),
    [anon_sym_div] = ACTIONS(274),
    [anon_sym_rem] = ACTIONS(274),
    [anon_sym_band] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_bor] = ACTIONS(274),
    [anon_sym_bxor] = ACTIONS(274),
    [anon_sym_bsl] = ACTIONS(274),
    [anon_sym_bsr] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_xor] = ACTIONS(274),
    [anon_sym_PLUS_PLUS] = ACTIONS(272),
    [anon_sym_DASH_DASH] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_SLASH_EQ] = ACTIONS(272),
    [anon_sym_EQ_LT] = ACTIONS(272),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(272),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(272),
    [anon_sym_andalso] = ACTIONS(274),
    [anon_sym_orelse] = ACTIONS(274),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_BANG] = ACTIONS(272),
    [anon_sym_QMARK_EQ] = ACTIONS(272),
    [anon_sym_DOT_DOT] = ACTIONS(274),
    [anon_sym_PIPE_PIPE] = ACTIONS(272),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_LT_DASH] = ACTIONS(272),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(272),
    [anon_sym_fun] = ACTIONS(274),
    [anon_sym_DASH_GT] = ACTIONS(272),
    [anon_sym_begin] = ACTIONS(274),
    [anon_sym_case] = ACTIONS(274),
    [anon_sym_receive] = ACTIONS(274),
    [anon_sym_try] = ACTIONS(274),
    [anon_sym_maybe] = ACTIONS(274),
    [anon_sym_DOLLAR] = ACTIONS(272),
    [aux_sym_integer_token1] = ACTIONS(274),
    [aux_sym_integer_token2] = ACTIONS(272),
    [sym_float] = ACTIONS(272),
    [sym__atom] = ACTIONS(274),
    [anon_sym_SQUOTE] = ACTIONS(272),
    [sym_variable] = ACTIONS(272),
    [anon_sym_QMARK] = ACTIONS(274),
    [anon_sym_DQUOTE] = ACTIONS(272),
    [sym_tripledot] = ACTIONS(272),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [38] = {
    [sym_comment] = STATE(38),
    [anon_sym_COMMA] = ACTIONS(276),
    [anon_sym_DOT] = ACTIONS(278),
    [anon_sym_SEMI] = ACTIONS(276),
    [anon_sym_DASH] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(276),
    [anon_sym_RPAREN] = ACTIONS(276),
    [anon_sym_COLON] = ACTIONS(278),
    [anon_sym_when] = ACTIONS(278),
    [anon_sym_if] = ACTIONS(278),
    [anon_sym_LT_LT] = ACTIONS(276),
    [anon_sym_GT_GT] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(276),
    [anon_sym_RBRACE] = ACTIONS(276),
    [anon_sym_LBRACK] = ACTIONS(276),
    [anon_sym_RBRACK] = ACTIONS(276),
    [anon_sym_POUND] = ACTIONS(276),
    [anon_sym_PLUS] = ACTIONS(278),
    [anon_sym_not] = ACTIONS(278),
    [anon_sym_bnot] = ACTIONS(278),
    [anon_sym_catch] = ACTIONS(278),
    [anon_sym_SLASH] = ACTIONS(278),
    [anon_sym_STAR] = ACTIONS(276),
    [anon_sym_div] = ACTIONS(278),
    [anon_sym_rem] = ACTIONS(278),
    [anon_sym_band] = ACTIONS(278),
    [anon_sym_and] = ACTIONS(278),
    [anon_sym_bor] = ACTIONS(278),
    [anon_sym_bxor] = ACTIONS(278),
    [anon_sym_bsl] = ACTIONS(278),
    [anon_sym_bsr] = ACTIONS(278),
    [anon_sym_or] = ACTIONS(278),
    [anon_sym_xor] = ACTIONS(278),
    [anon_sym_PLUS_PLUS] = ACTIONS(276),
    [anon_sym_DASH_DASH] = ACTIONS(276),
    [anon_sym_EQ_EQ] = ACTIONS(276),
    [anon_sym_SLASH_EQ] = ACTIONS(276),
    [anon_sym_EQ_LT] = ACTIONS(276),
    [anon_sym_LT] = ACTIONS(278),
    [anon_sym_GT_EQ] = ACTIONS(276),
    [anon_sym_GT] = ACTIONS(278),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(276),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(276),
    [anon_sym_andalso] = ACTIONS(278),
    [anon_sym_orelse] = ACTIONS(278),
    [anon_sym_EQ] = ACTIONS(278),
    [anon_sym_BANG] = ACTIONS(276),
    [anon_sym_QMARK_EQ] = ACTIONS(276),
    [anon_sym_DOT_DOT] = ACTIONS(278),
    [anon_sym_PIPE_PIPE] = ACTIONS(276),
    [anon_sym_COLON_COLON] = ACTIONS(276),
    [anon_sym_PIPE] = ACTIONS(278),
    [anon_sym_LT_DASH] = ACTIONS(276),
    [anon_sym_LT_EQ] = ACTIONS(276),
    [anon_sym_EQ_GT] = ACTIONS(276),
    [anon_sym_COLON_EQ] = ACTIONS(276),
    [anon_sym_fun] = ACTIONS(278),
    [anon_sym_DASH_GT] = ACTIONS(276),
    [anon_sym_begin] = ACTIONS(278),
    [anon_sym_case] = ACTIONS(278),
    [anon_sym_receive] = ACTIONS(278),
    [anon_sym_try] = ACTIONS(278),
    [anon_sym_maybe] = ACTIONS(278),
    [anon_sym_DOLLAR] = ACTIONS(276),
    [aux_sym_integer_token1] = ACTIONS(278),
    [aux_sym_integer_token2] = ACTIONS(276),
    [sym_float] = ACTIONS(276),
    [sym__atom] = ACTIONS(278),
    [anon_sym_SQUOTE] = ACTIONS(276),
    [sym_variable] = ACTIONS(276),
    [anon_sym_QMARK] = ACTIONS(278),
    [anon_sym_DQUOTE] = ACTIONS(276),
    [sym_tripledot] = ACTIONS(276),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [39] = {
    [sym_comment] = STATE(39),
    [anon_sym_COMMA] = ACTIONS(280),
    [anon_sym_DOT] = ACTIONS(282),
    [anon_sym_SEMI] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_RPAREN] = ACTIONS(280),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_when] = ACTIONS(282),
    [anon_sym_if] = ACTIONS(282),
    [anon_sym_LT_LT] = ACTIONS(280),
    [anon_sym_GT_GT] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_RBRACE] = ACTIONS(280),
    [anon_sym_LBRACK] = ACTIONS(280),
    [anon_sym_RBRACK] = ACTIONS(280),
    [anon_sym_POUND] = ACTIONS(280),
    [anon_sym_PLUS] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_bnot] = ACTIONS(282),
    [anon_sym_catch] = ACTIONS(282),
    [anon_sym_SLASH] = ACTIONS(282),
    [anon_sym_STAR] = ACTIONS(280),
    [anon_sym_div] = ACTIONS(282),
    [anon_sym_rem] = ACTIONS(282),
    [anon_sym_band] = ACTIONS(282),
    [anon_sym_and] = ACTIONS(282),
    [anon_sym_bor] = ACTIONS(282),
    [anon_sym_bxor] = ACTIONS(282),
    [anon_sym_bsl] = ACTIONS(282),
    [anon_sym_bsr] = ACTIONS(282),
    [anon_sym_or] = ACTIONS(282),
    [anon_sym_xor] = ACTIONS(282),
    [anon_sym_PLUS_PLUS] = ACTIONS(280),
    [anon_sym_DASH_DASH] = ACTIONS(280),
    [anon_sym_EQ_EQ] = ACTIONS(280),
    [anon_sym_SLASH_EQ] = ACTIONS(280),
    [anon_sym_EQ_LT] = ACTIONS(280),
    [anon_sym_LT] = ACTIONS(282),
    [anon_sym_GT_EQ] = ACTIONS(280),
    [anon_sym_GT] = ACTIONS(282),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(280),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(280),
    [anon_sym_andalso] = ACTIONS(282),
    [anon_sym_orelse] = ACTIONS(282),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_BANG] = ACTIONS(280),
    [anon_sym_QMARK_EQ] = ACTIONS(280),
    [anon_sym_DOT_DOT] = ACTIONS(282),
    [anon_sym_PIPE_PIPE] = ACTIONS(280),
    [anon_sym_COLON_COLON] = ACTIONS(280),
    [anon_sym_PIPE] = ACTIONS(282),
    [anon_sym_LT_DASH] = ACTIONS(280),
    [anon_sym_LT_EQ] = ACTIONS(280),
    [anon_sym_EQ_GT] = ACTIONS(280),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_fun] = ACTIONS(282),
    [anon_sym_DASH_GT] = ACTIONS(280),
    [anon_sym_begin] = ACTIONS(282),
    [anon_sym_case] = ACTIONS(282),
    [anon_sym_receive] = ACTIONS(282),
    [anon_sym_try] = ACTIONS(282),
    [anon_sym_maybe] = ACTIONS(282),
    [anon_sym_DOLLAR] = ACTIONS(280),
    [aux_sym_integer_token1] = ACTIONS(282),
    [aux_sym_integer_token2] = ACTIONS(280),
    [sym_float] = ACTIONS(280),
    [sym__atom] = ACTIONS(282),
    [anon_sym_SQUOTE] = ACTIONS(280),
    [sym_variable] = ACTIONS(280),
    [anon_sym_QMARK] = ACTIONS(282),
    [anon_sym_DQUOTE] = ACTIONS(280),
    [sym_tripledot] = ACTIONS(280),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [40] = {
    [sym__statement] = STATE(40),
    [sym_function] = STATE(1625),
    [sym__macro_declaration] = STATE(1624),
    [sym__spec] = STATE(1623),
    [sym_attribute] = STATE(1625),
    [sym__expression_without_call] = STATE(961),
    [sym__expression] = STATE(840),
    [sym_parenthesized_expression] = STATE(960),
    [sym_bitstring] = STATE(962),
    [sym_tuple] = STATE(758),
    [sym_list] = STATE(758),
    [sym_map] = STATE(962),
    [sym_record] = STATE(962),
    [sym_unary_operator] = STATE(758),
    [sym_binary_operator] = STATE(962),
    [sym__literal] = STATE(1458),
    [sym_anonymous_function] = STATE(758),
    [sym__named_stab_clause] = STATE(1459),
    [sym_call] = STATE(961),
    [sym__qualified_function] = STATE(1489),
    [sym__unqualified_function] = STATE(1487),
    [sym_function_capture] = STATE(962),
    [sym_function_type] = STATE(962),
    [sym_block] = STATE(962),
    [sym_if] = STATE(962),
    [sym_case] = STATE(962),
    [sym_receive] = STATE(962),
    [sym_try] = STATE(758),
    [sym_maybe] = STATE(962),
    [sym_character] = STATE(759),
    [sym__number] = STATE(960),
    [sym_integer] = STATE(760),
    [sym__identifier] = STATE(761),
    [sym_atom] = STATE(729),
    [sym__quoted_atom] = STATE(762),
    [sym_macro] = STATE(4),
    [sym__macro_constant] = STATE(45),
    [sym__macro_call] = STATE(46),
    [sym__strings] = STATE(962),
    [sym_string] = STATE(733),
    [sym_comment] = STATE(40),
    [sym_line_comment] = STATE(40),
    [aux_sym_source_repeat2] = STATE(40),
    [aux_sym__strings_repeat1] = STATE(715),
    [ts_builtin_sym_end] = ACTIONS(284),
    [anon_sym_DASH] = ACTIONS(286),
    [anon_sym_LPAREN] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(292),
    [anon_sym_LT_LT] = ACTIONS(295),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(301),
    [anon_sym_POUND] = ACTIONS(304),
    [anon_sym_PLUS] = ACTIONS(307),
    [anon_sym_not] = ACTIONS(307),
    [anon_sym_bnot] = ACTIONS(307),
    [anon_sym_catch] = ACTIONS(310),
    [anon_sym_fun] = ACTIONS(313),
    [anon_sym_begin] = ACTIONS(316),
    [anon_sym_case] = ACTIONS(319),
    [anon_sym_receive] = ACTIONS(322),
    [anon_sym_try] = ACTIONS(325),
    [anon_sym_maybe] = ACTIONS(328),
    [anon_sym_DOLLAR] = ACTIONS(331),
    [aux_sym_integer_token1] = ACTIONS(334),
    [aux_sym_integer_token2] = ACTIONS(337),
    [sym_float] = ACTIONS(340),
    [sym__atom] = ACTIONS(343),
    [anon_sym_SQUOTE] = ACTIONS(346),
    [sym_variable] = ACTIONS(349),
    [anon_sym_QMARK] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [sym_tripledot] = ACTIONS(358),
    [aux_sym_comment_token1] = ACTIONS(361),
  },
  [41] = {
    [sym__statement] = STATE(40),
    [sym_function] = STATE(1625),
    [sym__macro_declaration] = STATE(1624),
    [sym__spec] = STATE(1623),
    [sym_attribute] = STATE(1625),
    [sym__expression_without_call] = STATE(961),
    [sym__expression] = STATE(840),
    [sym_parenthesized_expression] = STATE(960),
    [sym_bitstring] = STATE(962),
    [sym_tuple] = STATE(758),
    [sym_list] = STATE(758),
    [sym_map] = STATE(962),
    [sym_record] = STATE(962),
    [sym_unary_operator] = STATE(758),
    [sym_binary_operator] = STATE(962),
    [sym__literal] = STATE(1458),
    [sym_anonymous_function] = STATE(758),
    [sym__named_stab_clause] = STATE(1459),
    [sym_call] = STATE(961),
    [sym__qualified_function] = STATE(1489),
    [sym__unqualified_function] = STATE(1487),
    [sym_function_capture] = STATE(962),
    [sym_function_type] = STATE(962),
    [sym_block] = STATE(962),
    [sym_if] = STATE(962),
    [sym_case] = STATE(962),
    [sym_receive] = STATE(962),
    [sym_try] = STATE(758),
    [sym_maybe] = STATE(962),
    [sym_character] = STATE(759),
    [sym__number] = STATE(960),
    [sym_integer] = STATE(760),
    [sym__identifier] = STATE(761),
    [sym_atom] = STATE(729),
    [sym__quoted_atom] = STATE(762),
    [sym_macro] = STATE(4),
    [sym__macro_constant] = STATE(45),
    [sym__macro_call] = STATE(46),
    [sym__strings] = STATE(962),
    [sym_string] = STATE(733),
    [sym_comment] = STATE(41),
    [sym_line_comment] = STATE(40),
    [aux_sym_source_repeat2] = STATE(40),
    [aux_sym__strings_repeat1] = STATE(715),
    [ts_builtin_sym_end] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LT_LT] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(366),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_not] = ACTIONS(23),
    [anon_sym_bnot] = ACTIONS(23),
    [anon_sym_catch] = ACTIONS(25),
    [anon_sym_fun] = ACTIONS(27),
    [anon_sym_begin] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_receive] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_maybe] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [aux_sym_integer_token1] = ACTIONS(41),
    [aux_sym_integer_token2] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [sym__atom] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [sym_variable] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(55),
    [sym_tripledot] = ACTIONS(57),
    [aux_sym_comment_token1] = ACTIONS(59),
  },
  [42] = {
    [sym__statement] = STATE(40),
    [sym_function] = STATE(1625),
    [sym__macro_declaration] = STATE(1624),
    [sym__spec] = STATE(1623),
    [sym_attribute] = STATE(1625),
    [sym__expression_without_call] = STATE(961),
    [sym__expression] = STATE(840),
    [sym_parenthesized_expression] = STATE(960),
    [sym_bitstring] = STATE(962),
    [sym_tuple] = STATE(758),
    [sym_list] = STATE(758),
    [sym_map] = STATE(962),
    [sym_record] = STATE(962),
    [sym_unary_operator] = STATE(758),
    [sym_binary_operator] = STATE(962),
    [sym__literal] = STATE(1458),
    [sym_anonymous_function] = STATE(758),
    [sym__named_stab_clause] = STATE(1459),
    [sym_call] = STATE(961),
    [sym__qualified_function] = STATE(1489),
    [sym__unqualified_function] = STATE(1487),
    [sym_function_capture] = STATE(962),
    [sym_function_type] = STATE(962),
    [sym_block] = STATE(962),
    [sym_if] = STATE(962),
    [sym_case] = STATE(962),
    [sym_receive] = STATE(962),
    [sym_try] = STATE(758),
    [sym_maybe] = STATE(962),
    [sym_character] = STATE(759),
    [sym__number] = STATE(960),
    [sym_integer] = STATE(760),
    [sym__identifier] = STATE(761),
    [sym_atom] = STATE(729),
    [sym__quoted_atom] = STATE(762),
    [sym_macro] = STATE(4),
    [sym__macro_constant] = STATE(45),
    [sym__macro_call] = STATE(46),
    [sym__strings] = STATE(962),
    [sym_string] = STATE(733),
    [sym_comment] = STATE(42),
    [sym_line_comment] = STATE(40),
    [aux_sym_source_repeat2] = STATE(40),
    [aux_sym__strings_repeat1] = STATE(715),
    [ts_builtin_sym_end] = ACTIONS(234),
    [anon_sym_DASH] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_LT_LT] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(366),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_not] = ACTIONS(23),
    [anon_sym_bnot] = ACTIONS(23),
    [anon_sym_catch] = ACTIONS(25),
    [anon_sym_fun] = ACTIONS(27),
    [anon_sym_begin] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_receive] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_maybe] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [aux_sym_integer_token1] = ACTIONS(41),
    [aux_sym_integer_token2] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [sym__atom] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [sym_variable] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(55),
    [sym_tripledot] = ACTIONS(57),
    [aux_sym_comment_token1] = ACTIONS(59),
  },
  [43] = {
    [sym_comment] = STATE(43),
    [ts_builtin_sym_end] = ACTIONS(268),
    [anon_sym_COMMA] = ACTIONS(270),
    [anon_sym_LF] = ACTIONS(268),
    [anon_sym_DOT] = ACTIONS(270),
    [anon_sym_SEMI] = ACTIONS(270),
    [anon_sym_DASH] = ACTIONS(270),
    [anon_sym_LPAREN] = ACTIONS(270),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_when] = ACTIONS(270),
    [anon_sym_if] = ACTIONS(270),
    [anon_sym_LT_LT] = ACTIONS(270),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_LBRACK] = ACTIONS(270),
    [anon_sym_POUND] = ACTIONS(270),
    [anon_sym_PLUS] = ACTIONS(270),
    [anon_sym_not] = ACTIONS(270),
    [anon_sym_bnot] = ACTIONS(270),
    [anon_sym_catch] = ACTIONS(270),
    [anon_sym_SLASH] = ACTIONS(270),
    [anon_sym_STAR] = ACTIONS(270),
    [anon_sym_div] = ACTIONS(270),
    [anon_sym_rem] = ACTIONS(270),
    [anon_sym_band] = ACTIONS(270),
    [anon_sym_and] = ACTIONS(270),
    [anon_sym_bor] = ACTIONS(270),
    [anon_sym_bxor] = ACTIONS(270),
    [anon_sym_bsl] = ACTIONS(270),
    [anon_sym_bsr] = ACTIONS(270),
    [anon_sym_or] = ACTIONS(270),
    [anon_sym_xor] = ACTIONS(270),
    [anon_sym_PLUS_PLUS] = ACTIONS(270),
    [anon_sym_DASH_DASH] = ACTIONS(270),
    [anon_sym_EQ_EQ] = ACTIONS(270),
    [anon_sym_SLASH_EQ] = ACTIONS(270),
    [anon_sym_EQ_LT] = ACTIONS(270),
    [anon_sym_LT] = ACTIONS(270),
    [anon_sym_GT_EQ] = ACTIONS(270),
    [anon_sym_GT] = ACTIONS(270),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(270),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(270),
    [anon_sym_andalso] = ACTIONS(270),
    [anon_sym_orelse] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(270),
    [anon_sym_BANG] = ACTIONS(270),
    [anon_sym_QMARK_EQ] = ACTIONS(270),
    [anon_sym_DOT_DOT] = ACTIONS(270),
    [anon_sym_PIPE_PIPE] = ACTIONS(270),
    [anon_sym_COLON_COLON] = ACTIONS(270),
    [anon_sym_PIPE] = ACTIONS(270),
    [anon_sym_LT_DASH] = ACTIONS(270),
    [anon_sym_LT_EQ] = ACTIONS(270),
    [anon_sym_EQ_GT] = ACTIONS(270),
    [anon_sym_COLON_EQ] = ACTIONS(270),
    [anon_sym_fun] = ACTIONS(270),
    [anon_sym_DASH_GT] = ACTIONS(270),
    [anon_sym_begin] = ACTIONS(270),
    [anon_sym_case] = ACTIONS(270),
    [anon_sym_receive] = ACTIONS(270),
    [anon_sym_try] = ACTIONS(270),
    [anon_sym_maybe] = ACTIONS(270),
    [anon_sym_DOLLAR] = ACTIONS(270),
    [aux_sym_integer_token1] = ACTIONS(270),
    [aux_sym_integer_token2] = ACTIONS(270),
    [sym_float] = ACTIONS(270),
    [sym__atom] = ACTIONS(270),
    [anon_sym_SQUOTE] = ACTIONS(270),
    [sym_variable] = ACTIONS(270),
    [anon_sym_QMARK] = ACTIONS(270),
    [anon_sym_DQUOTE] = ACTIONS(270),
    [sym_tripledot] = ACTIONS(270),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [44] = {
    [sym_comment] = STATE(44),
    [ts_builtin_sym_end] = ACTIONS(248),
    [anon_sym_COMMA] = ACTIONS(250),
    [anon_sym_LF] = ACTIONS(248),
    [anon_sym_DOT] = ACTIONS(250),
    [anon_sym_SEMI] = ACTIONS(250),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(368),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(250),
    [anon_sym_LBRACE] = ACTIONS(250),
    [anon_sym_LBRACK] = ACTIONS(250),
    [anon_sym_POUND] = ACTIONS(250),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(250),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(250),
    [anon_sym_DASH_DASH] = ACTIONS(250),
    [anon_sym_EQ_EQ] = ACTIONS(250),
    [anon_sym_SLASH_EQ] = ACTIONS(250),
    [anon_sym_EQ_LT] = ACTIONS(250),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(250),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(250),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(250),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(250),
    [anon_sym_QMARK_EQ] = ACTIONS(250),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(250),
    [anon_sym_COLON_COLON] = ACTIONS(250),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(250),
    [anon_sym_LT_EQ] = ACTIONS(250),
    [anon_sym_EQ_GT] = ACTIONS(250),
    [anon_sym_COLON_EQ] = ACTIONS(250),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_DASH_GT] = ACTIONS(371),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(250),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(250),
    [sym_float] = ACTIONS(250),
    [sym__atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(250),
    [sym_variable] = ACTIONS(250),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(250),
    [sym_tripledot] = ACTIONS(250),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [45] = {
    [sym_arguments] = STATE(44),
    [sym_comment] = STATE(45),
    [ts_builtin_sym_end] = ACTIONS(238),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_LF] = ACTIONS(238),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_SEMI] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(373),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_when] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_POUND] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_bnot] = ACTIONS(240),
    [anon_sym_catch] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_div] = ACTIONS(240),
    [anon_sym_rem] = ACTIONS(240),
    [anon_sym_band] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_bor] = ACTIONS(240),
    [anon_sym_bxor] = ACTIONS(240),
    [anon_sym_bsl] = ACTIONS(240),
    [anon_sym_bsr] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_xor] = ACTIONS(240),
    [anon_sym_PLUS_PLUS] = ACTIONS(240),
    [anon_sym_DASH_DASH] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_SLASH_EQ] = ACTIONS(240),
    [anon_sym_EQ_LT] = ACTIONS(240),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(240),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(240),
    [anon_sym_andalso] = ACTIONS(240),
    [anon_sym_orelse] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(240),
    [anon_sym_QMARK_EQ] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(240),
    [anon_sym_PIPE_PIPE] = ACTIONS(240),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_LT_DASH] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_GT] = ACTIONS(240),
    [anon_sym_COLON_EQ] = ACTIONS(240),
    [anon_sym_fun] = ACTIONS(240),
    [anon_sym_begin] = ACTIONS(240),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_receive] = ACTIONS(240),
    [anon_sym_try] = ACTIONS(240),
    [anon_sym_maybe] = ACTIONS(240),
    [anon_sym_DOLLAR] = ACTIONS(240),
    [aux_sym_integer_token1] = ACTIONS(240),
    [aux_sym_integer_token2] = ACTIONS(240),
    [sym_float] = ACTIONS(240),
    [sym__atom] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(240),
    [sym_variable] = ACTIONS(240),
    [anon_sym_QMARK] = ACTIONS(240),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [sym_tripledot] = ACTIONS(240),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [46] = {
    [sym_arguments] = STATE(1508),
    [sym_comment] = STATE(46),
    [ts_builtin_sym_end] = ACTIONS(264),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_LF] = ACTIONS(264),
    [anon_sym_DOT] = ACTIONS(266),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_DASH] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(375),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_when] = ACTIONS(266),
    [anon_sym_if] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_LBRACE] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(266),
    [anon_sym_POUND] = ACTIONS(266),
    [anon_sym_PLUS] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(266),
    [anon_sym_bnot] = ACTIONS(266),
    [anon_sym_catch] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(266),
    [anon_sym_STAR] = ACTIONS(266),
    [anon_sym_div] = ACTIONS(266),
    [anon_sym_rem] = ACTIONS(266),
    [anon_sym_band] = ACTIONS(266),
    [anon_sym_and] = ACTIONS(266),
    [anon_sym_bor] = ACTIONS(266),
    [anon_sym_bxor] = ACTIONS(266),
    [anon_sym_bsl] = ACTIONS(266),
    [anon_sym_bsr] = ACTIONS(266),
    [anon_sym_or] = ACTIONS(266),
    [anon_sym_xor] = ACTIONS(266),
    [anon_sym_PLUS_PLUS] = ACTIONS(266),
    [anon_sym_DASH_DASH] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_SLASH_EQ] = ACTIONS(266),
    [anon_sym_EQ_LT] = ACTIONS(266),
    [anon_sym_LT] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(266),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(266),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(266),
    [anon_sym_andalso] = ACTIONS(266),
    [anon_sym_orelse] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(266),
    [anon_sym_BANG] = ACTIONS(266),
    [anon_sym_QMARK_EQ] = ACTIONS(266),
    [anon_sym_DOT_DOT] = ACTIONS(266),
    [anon_sym_PIPE_PIPE] = ACTIONS(266),
    [anon_sym_COLON_COLON] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_LT_DASH] = ACTIONS(266),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_GT] = ACTIONS(266),
    [anon_sym_COLON_EQ] = ACTIONS(266),
    [anon_sym_fun] = ACTIONS(266),
    [anon_sym_begin] = ACTIONS(266),
    [anon_sym_case] = ACTIONS(266),
    [anon_sym_receive] = ACTIONS(266),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_maybe] = ACTIONS(266),
    [anon_sym_DOLLAR] = ACTIONS(266),
    [aux_sym_integer_token1] = ACTIONS(266),
    [aux_sym_integer_token2] = ACTIONS(266),
    [sym_float] = ACTIONS(266),
    [sym__atom] = ACTIONS(266),
    [anon_sym_SQUOTE] = ACTIONS(266),
    [sym_variable] = ACTIONS(266),
    [anon_sym_QMARK] = ACTIONS(266),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_tripledot] = ACTIONS(266),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [47] = {
    [sym_comment] = STATE(47),
    [ts_builtin_sym_end] = ACTIONS(260),
    [anon_sym_COMMA] = ACTIONS(262),
    [anon_sym_LF] = ACTIONS(260),
    [anon_sym_DOT] = ACTIONS(262),
    [anon_sym_SEMI] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_LPAREN] = ACTIONS(262),
    [anon_sym_COLON] = ACTIONS(262),
    [anon_sym_when] = ACTIONS(262),
    [anon_sym_if] = ACTIONS(262),
    [anon_sym_LT_LT] = ACTIONS(262),
    [anon_sym_LBRACE] = ACTIONS(262),
    [anon_sym_LBRACK] = ACTIONS(262),
    [anon_sym_POUND] = ACTIONS(262),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_not] = ACTIONS(262),
    [anon_sym_bnot] = ACTIONS(262),
    [anon_sym_catch] = ACTIONS(262),
    [anon_sym_SLASH] = ACTIONS(262),
    [anon_sym_STAR] = ACTIONS(262),
    [anon_sym_div] = ACTIONS(262),
    [anon_sym_rem] = ACTIONS(262),
    [anon_sym_band] = ACTIONS(262),
    [anon_sym_and] = ACTIONS(262),
    [anon_sym_bor] = ACTIONS(262),
    [anon_sym_bxor] = ACTIONS(262),
    [anon_sym_bsl] = ACTIONS(262),
    [anon_sym_bsr] = ACTIONS(262),
    [anon_sym_or] = ACTIONS(262),
    [anon_sym_xor] = ACTIONS(262),
    [anon_sym_PLUS_PLUS] = ACTIONS(262),
    [anon_sym_DASH_DASH] = ACTIONS(262),
    [anon_sym_EQ_EQ] = ACTIONS(262),
    [anon_sym_SLASH_EQ] = ACTIONS(262),
    [anon_sym_EQ_LT] = ACTIONS(262),
    [anon_sym_LT] = ACTIONS(262),
    [anon_sym_GT_EQ] = ACTIONS(262),
    [anon_sym_GT] = ACTIONS(262),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(262),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(262),
    [anon_sym_andalso] = ACTIONS(262),
    [anon_sym_orelse] = ACTIONS(262),
    [anon_sym_EQ] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_QMARK_EQ] = ACTIONS(262),
    [anon_sym_DOT_DOT] = ACTIONS(262),
    [anon_sym_PIPE_PIPE] = ACTIONS(262),
    [anon_sym_COLON_COLON] = ACTIONS(262),
    [anon_sym_PIPE] = ACTIONS(262),
    [anon_sym_LT_DASH] = ACTIONS(262),
    [anon_sym_LT_EQ] = ACTIONS(262),
    [anon_sym_EQ_GT] = ACTIONS(262),
    [anon_sym_COLON_EQ] = ACTIONS(262),
    [anon_sym_fun] = ACTIONS(262),
    [anon_sym_DASH_GT] = ACTIONS(262),
    [anon_sym_begin] = ACTIONS(262),
    [anon_sym_case] = ACTIONS(262),
    [anon_sym_receive] = ACTIONS(262),
    [anon_sym_try] = ACTIONS(262),
    [anon_sym_maybe] = ACTIONS(262),
    [anon_sym_DOLLAR] = ACTIONS(262),
    [aux_sym_integer_token1] = ACTIONS(262),
    [aux_sym_integer_token2] = ACTIONS(262),
    [sym_float] = ACTIONS(262),
    [sym__atom] = ACTIONS(262),
    [anon_sym_SQUOTE] = ACTIONS(262),
    [sym_variable] = ACTIONS(262),
    [anon_sym_QMARK] = ACTIONS(262),
    [anon_sym_DQUOTE] = ACTIONS(262),
    [sym_tripledot] = ACTIONS(262),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [48] = {
    [sym_comment] = STATE(48),
    [ts_builtin_sym_end] = ACTIONS(280),
    [anon_sym_COMMA] = ACTIONS(282),
    [anon_sym_LF] = ACTIONS(280),
    [anon_sym_DOT] = ACTIONS(282),
    [anon_sym_SEMI] = ACTIONS(282),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_LPAREN] = ACTIONS(282),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_when] = ACTIONS(282),
    [anon_sym_if] = ACTIONS(282),
    [anon_sym_LT_LT] = ACTIONS(282),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(282),
    [anon_sym_POUND] = ACTIONS(282),
    [anon_sym_PLUS] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_bnot] = ACTIONS(282),
    [anon_sym_catch] = ACTIONS(282),
    [anon_sym_SLASH] = ACTIONS(282),
    [anon_sym_STAR] = ACTIONS(282),
    [anon_sym_div] = ACTIONS(282),
    [anon_sym_rem] = ACTIONS(282),
    [anon_sym_band] = ACTIONS(282),
    [anon_sym_and] = ACTIONS(282),
    [anon_sym_bor] = ACTIONS(282),
    [anon_sym_bxor] = ACTIONS(282),
    [anon_sym_bsl] = ACTIONS(282),
    [anon_sym_bsr] = ACTIONS(282),
    [anon_sym_or] = ACTIONS(282),
    [anon_sym_xor] = ACTIONS(282),
    [anon_sym_PLUS_PLUS] = ACTIONS(282),
    [anon_sym_DASH_DASH] = ACTIONS(282),
    [anon_sym_EQ_EQ] = ACTIONS(282),
    [anon_sym_SLASH_EQ] = ACTIONS(282),
    [anon_sym_EQ_LT] = ACTIONS(282),
    [anon_sym_LT] = ACTIONS(282),
    [anon_sym_GT_EQ] = ACTIONS(282),
    [anon_sym_GT] = ACTIONS(282),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(282),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(282),
    [anon_sym_andalso] = ACTIONS(282),
    [anon_sym_orelse] = ACTIONS(282),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_BANG] = ACTIONS(282),
    [anon_sym_QMARK_EQ] = ACTIONS(282),
    [anon_sym_DOT_DOT] = ACTIONS(282),
    [anon_sym_PIPE_PIPE] = ACTIONS(282),
    [anon_sym_COLON_COLON] = ACTIONS(282),
    [anon_sym_PIPE] = ACTIONS(282),
    [anon_sym_LT_DASH] = ACTIONS(282),
    [anon_sym_LT_EQ] = ACTIONS(282),
    [anon_sym_EQ_GT] = ACTIONS(282),
    [anon_sym_COLON_EQ] = ACTIONS(282),
    [anon_sym_fun] = ACTIONS(282),
    [anon_sym_begin] = ACTIONS(282),
    [anon_sym_case] = ACTIONS(282),
    [anon_sym_receive] = ACTIONS(282),
    [anon_sym_try] = ACTIONS(282),
    [anon_sym_maybe] = ACTIONS(282),
    [anon_sym_DOLLAR] = ACTIONS(282),
    [aux_sym_integer_token1] = ACTIONS(282),
    [aux_sym_integer_token2] = ACTIONS(282),
    [sym_float] = ACTIONS(282),
    [sym__atom] = ACTIONS(282),
    [anon_sym_SQUOTE] = ACTIONS(282),
    [sym_variable] = ACTIONS(282),
    [anon_sym_QMARK] = ACTIONS(282),
    [anon_sym_DQUOTE] = ACTIONS(282),
    [sym_tripledot] = ACTIONS(282),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [49] = {
    [sym_comment] = STATE(49),
    [ts_builtin_sym_end] = ACTIONS(252),
    [anon_sym_COMMA] = ACTIONS(254),
    [anon_sym_LF] = ACTIONS(252),
    [anon_sym_DOT] = ACTIONS(254),
    [anon_sym_SEMI] = ACTIONS(254),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(254),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(254),
    [anon_sym_LBRACE] = ACTIONS(254),
    [anon_sym_LBRACK] = ACTIONS(254),
    [anon_sym_POUND] = ACTIONS(254),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(254),
    [anon_sym_DASH_DASH] = ACTIONS(254),
    [anon_sym_EQ_EQ] = ACTIONS(254),
    [anon_sym_SLASH_EQ] = ACTIONS(254),
    [anon_sym_EQ_LT] = ACTIONS(254),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(254),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(254),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(254),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(254),
    [anon_sym_QMARK_EQ] = ACTIONS(254),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(254),
    [anon_sym_COLON_COLON] = ACTIONS(254),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(254),
    [anon_sym_LT_EQ] = ACTIONS(254),
    [anon_sym_EQ_GT] = ACTIONS(254),
    [anon_sym_COLON_EQ] = ACTIONS(254),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(254),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(254),
    [sym_float] = ACTIONS(254),
    [sym__atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(254),
    [sym_variable] = ACTIONS(254),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(254),
    [sym_tripledot] = ACTIONS(254),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [50] = {
    [sym_comment] = STATE(50),
    [ts_builtin_sym_end] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(274),
    [anon_sym_LF] = ACTIONS(272),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_SEMI] = ACTIONS(274),
    [anon_sym_DASH] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_when] = ACTIONS(274),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(274),
    [anon_sym_LBRACE] = ACTIONS(274),
    [anon_sym_LBRACK] = ACTIONS(274),
    [anon_sym_POUND] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_bnot] = ACTIONS(274),
    [anon_sym_catch] = ACTIONS(274),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(274),
    [anon_sym_div] = ACTIONS(274),
    [anon_sym_rem] = ACTIONS(274),
    [anon_sym_band] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_bor] = ACTIONS(274),
    [anon_sym_bxor] = ACTIONS(274),
    [anon_sym_bsl] = ACTIONS(274),
    [anon_sym_bsr] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_xor] = ACTIONS(274),
    [anon_sym_PLUS_PLUS] = ACTIONS(274),
    [anon_sym_DASH_DASH] = ACTIONS(274),
    [anon_sym_EQ_EQ] = ACTIONS(274),
    [anon_sym_SLASH_EQ] = ACTIONS(274),
    [anon_sym_EQ_LT] = ACTIONS(274),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_GT_EQ] = ACTIONS(274),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(274),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(274),
    [anon_sym_andalso] = ACTIONS(274),
    [anon_sym_orelse] = ACTIONS(274),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_BANG] = ACTIONS(274),
    [anon_sym_QMARK_EQ] = ACTIONS(274),
    [anon_sym_DOT_DOT] = ACTIONS(274),
    [anon_sym_PIPE_PIPE] = ACTIONS(274),
    [anon_sym_COLON_COLON] = ACTIONS(274),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_LT_DASH] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(274),
    [anon_sym_EQ_GT] = ACTIONS(274),
    [anon_sym_COLON_EQ] = ACTIONS(274),
    [anon_sym_fun] = ACTIONS(274),
    [anon_sym_begin] = ACTIONS(274),
    [anon_sym_case] = ACTIONS(274),
    [anon_sym_receive] = ACTIONS(274),
    [anon_sym_try] = ACTIONS(274),
    [anon_sym_maybe] = ACTIONS(274),
    [anon_sym_DOLLAR] = ACTIONS(274),
    [aux_sym_integer_token1] = ACTIONS(274),
    [aux_sym_integer_token2] = ACTIONS(274),
    [sym_float] = ACTIONS(274),
    [sym__atom] = ACTIONS(274),
    [anon_sym_SQUOTE] = ACTIONS(274),
    [sym_variable] = ACTIONS(274),
    [anon_sym_QMARK] = ACTIONS(274),
    [anon_sym_DQUOTE] = ACTIONS(274),
    [sym_tripledot] = ACTIONS(274),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [51] = {
    [sym_arguments] = STATE(59),
    [sym_comment] = STATE(51),
    [anon_sym_COMMA] = ACTIONS(238),
    [anon_sym_SEMI] = ACTIONS(238),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(377),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_when] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(238),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_bnot] = ACTIONS(240),
    [anon_sym_catch] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(238),
    [anon_sym_div] = ACTIONS(240),
    [anon_sym_rem] = ACTIONS(240),
    [anon_sym_band] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_bor] = ACTIONS(240),
    [anon_sym_bxor] = ACTIONS(240),
    [anon_sym_bsl] = ACTIONS(240),
    [anon_sym_bsr] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_xor] = ACTIONS(240),
    [anon_sym_PLUS_PLUS] = ACTIONS(238),
    [anon_sym_DASH_DASH] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_EQ_LT] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(238),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(238),
    [anon_sym_andalso] = ACTIONS(240),
    [anon_sym_orelse] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_QMARK_EQ] = ACTIONS(238),
    [anon_sym_DOT_DOT] = ACTIONS(240),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_LT_DASH] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_EQ_GT] = ACTIONS(238),
    [anon_sym_COLON_EQ] = ACTIONS(238),
    [anon_sym_fun] = ACTIONS(240),
    [anon_sym_end] = ACTIONS(240),
    [anon_sym_begin] = ACTIONS(240),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_receive] = ACTIONS(240),
    [anon_sym_after] = ACTIONS(240),
    [anon_sym_try] = ACTIONS(240),
    [anon_sym_maybe] = ACTIONS(240),
    [anon_sym_DOLLAR] = ACTIONS(238),
    [aux_sym_integer_token1] = ACTIONS(240),
    [aux_sym_integer_token2] = ACTIONS(238),
    [sym_float] = ACTIONS(238),
    [sym__atom] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [sym_variable] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(240),
    [anon_sym_DQUOTE] = ACTIONS(238),
    [sym_tripledot] = ACTIONS(238),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [52] = {
    [sym_comment] = STATE(52),
    [ts_builtin_sym_end] = ACTIONS(276),
    [anon_sym_COMMA] = ACTIONS(278),
    [anon_sym_LF] = ACTIONS(276),
    [anon_sym_DOT] = ACTIONS(278),
    [anon_sym_SEMI] = ACTIONS(278),
    [anon_sym_DASH] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(278),
    [anon_sym_COLON] = ACTIONS(278),
    [anon_sym_when] = ACTIONS(278),
    [anon_sym_if] = ACTIONS(278),
    [anon_sym_LT_LT] = ACTIONS(278),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_LBRACK] = ACTIONS(278),
    [anon_sym_POUND] = ACTIONS(278),
    [anon_sym_PLUS] = ACTIONS(278),
    [anon_sym_not] = ACTIONS(278),
    [anon_sym_bnot] = ACTIONS(278),
    [anon_sym_catch] = ACTIONS(278),
    [anon_sym_SLASH] = ACTIONS(278),
    [anon_sym_STAR] = ACTIONS(278),
    [anon_sym_div] = ACTIONS(278),
    [anon_sym_rem] = ACTIONS(278),
    [anon_sym_band] = ACTIONS(278),
    [anon_sym_and] = ACTIONS(278),
    [anon_sym_bor] = ACTIONS(278),
    [anon_sym_bxor] = ACTIONS(278),
    [anon_sym_bsl] = ACTIONS(278),
    [anon_sym_bsr] = ACTIONS(278),
    [anon_sym_or] = ACTIONS(278),
    [anon_sym_xor] = ACTIONS(278),
    [anon_sym_PLUS_PLUS] = ACTIONS(278),
    [anon_sym_DASH_DASH] = ACTIONS(278),
    [anon_sym_EQ_EQ] = ACTIONS(278),
    [anon_sym_SLASH_EQ] = ACTIONS(278),
    [anon_sym_EQ_LT] = ACTIONS(278),
    [anon_sym_LT] = ACTIONS(278),
    [anon_sym_GT_EQ] = ACTIONS(278),
    [anon_sym_GT] = ACTIONS(278),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(278),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(278),
    [anon_sym_andalso] = ACTIONS(278),
    [anon_sym_orelse] = ACTIONS(278),
    [anon_sym_EQ] = ACTIONS(278),
    [anon_sym_BANG] = ACTIONS(278),
    [anon_sym_QMARK_EQ] = ACTIONS(278),
    [anon_sym_DOT_DOT] = ACTIONS(278),
    [anon_sym_PIPE_PIPE] = ACTIONS(278),
    [anon_sym_COLON_COLON] = ACTIONS(278),
    [anon_sym_PIPE] = ACTIONS(278),
    [anon_sym_LT_DASH] = ACTIONS(278),
    [anon_sym_LT_EQ] = ACTIONS(278),
    [anon_sym_EQ_GT] = ACTIONS(278),
    [anon_sym_COLON_EQ] = ACTIONS(278),
    [anon_sym_fun] = ACTIONS(278),
    [anon_sym_begin] = ACTIONS(278),
    [anon_sym_case] = ACTIONS(278),
    [anon_sym_receive] = ACTIONS(278),
    [anon_sym_try] = ACTIONS(278),
    [anon_sym_maybe] = ACTIONS(278),
    [anon_sym_DOLLAR] = ACTIONS(278),
    [aux_sym_integer_token1] = ACTIONS(278),
    [aux_sym_integer_token2] = ACTIONS(278),
    [sym_float] = ACTIONS(278),
    [sym__atom] = ACTIONS(278),
    [anon_sym_SQUOTE] = ACTIONS(278),
    [sym_variable] = ACTIONS(278),
    [anon_sym_QMARK] = ACTIONS(278),
    [anon_sym_DQUOTE] = ACTIONS(278),
    [sym_tripledot] = ACTIONS(278),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [53] = {
    [sym_comment] = STATE(53),
    [ts_builtin_sym_end] = ACTIONS(256),
    [anon_sym_COMMA] = ACTIONS(258),
    [anon_sym_LF] = ACTIONS(256),
    [anon_sym_DOT] = ACTIONS(258),
    [anon_sym_SEMI] = ACTIONS(258),
    [anon_sym_DASH] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(258),
    [anon_sym_COLON] = ACTIONS(258),
    [anon_sym_when] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_LT_LT] = ACTIONS(258),
    [anon_sym_LBRACE] = ACTIONS(258),
    [anon_sym_LBRACK] = ACTIONS(258),
    [anon_sym_POUND] = ACTIONS(258),
    [anon_sym_PLUS] = ACTIONS(258),
    [anon_sym_not] = ACTIONS(258),
    [anon_sym_bnot] = ACTIONS(258),
    [anon_sym_catch] = ACTIONS(258),
    [anon_sym_SLASH] = ACTIONS(258),
    [anon_sym_STAR] = ACTIONS(258),
    [anon_sym_div] = ACTIONS(258),
    [anon_sym_rem] = ACTIONS(258),
    [anon_sym_band] = ACTIONS(258),
    [anon_sym_and] = ACTIONS(258),
    [anon_sym_bor] = ACTIONS(258),
    [anon_sym_bxor] = ACTIONS(258),
    [anon_sym_bsl] = ACTIONS(258),
    [anon_sym_bsr] = ACTIONS(258),
    [anon_sym_or] = ACTIONS(258),
    [anon_sym_xor] = ACTIONS(258),
    [anon_sym_PLUS_PLUS] = ACTIONS(258),
    [anon_sym_DASH_DASH] = ACTIONS(258),
    [anon_sym_EQ_EQ] = ACTIONS(258),
    [anon_sym_SLASH_EQ] = ACTIONS(258),
    [anon_sym_EQ_LT] = ACTIONS(258),
    [anon_sym_LT] = ACTIONS(258),
    [anon_sym_GT_EQ] = ACTIONS(258),
    [anon_sym_GT] = ACTIONS(258),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(258),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(258),
    [anon_sym_andalso] = ACTIONS(258),
    [anon_sym_orelse] = ACTIONS(258),
    [anon_sym_EQ] = ACTIONS(258),
    [anon_sym_BANG] = ACTIONS(258),
    [anon_sym_QMARK_EQ] = ACTIONS(258),
    [anon_sym_DOT_DOT] = ACTIONS(258),
    [anon_sym_PIPE_PIPE] = ACTIONS(258),
    [anon_sym_COLON_COLON] = ACTIONS(258),
    [anon_sym_PIPE] = ACTIONS(258),
    [anon_sym_LT_DASH] = ACTIONS(258),
    [anon_sym_LT_EQ] = ACTIONS(258),
    [anon_sym_EQ_GT] = ACTIONS(258),
    [anon_sym_COLON_EQ] = ACTIONS(258),
    [anon_sym_fun] = ACTIONS(258),
    [anon_sym_begin] = ACTIONS(258),
    [anon_sym_case] = ACTIONS(258),
    [anon_sym_receive] = ACTIONS(258),
    [anon_sym_try] = ACTIONS(258),
    [anon_sym_maybe] = ACTIONS(258),
    [anon_sym_DOLLAR] = ACTIONS(258),
    [aux_sym_integer_token1] = ACTIONS(258),
    [aux_sym_integer_token2] = ACTIONS(258),
    [sym_float] = ACTIONS(258),
    [sym__atom] = ACTIONS(258),
    [anon_sym_SQUOTE] = ACTIONS(258),
    [sym_variable] = ACTIONS(258),
    [anon_sym_QMARK] = ACTIONS(258),
    [anon_sym_DQUOTE] = ACTIONS(258),
    [sym_tripledot] = ACTIONS(258),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [54] = {
    [sym_comment] = STATE(54),
    [ts_builtin_sym_end] = ACTIONS(244),
    [anon_sym_COMMA] = ACTIONS(246),
    [anon_sym_LF] = ACTIONS(244),
    [anon_sym_DOT] = ACTIONS(246),
    [anon_sym_SEMI] = ACTIONS(246),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(246),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(246),
    [anon_sym_LBRACE] = ACTIONS(246),
    [anon_sym_LBRACK] = ACTIONS(246),
    [anon_sym_POUND] = ACTIONS(246),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(246),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(246),
    [anon_sym_DASH_DASH] = ACTIONS(246),
    [anon_sym_EQ_EQ] = ACTIONS(246),
    [anon_sym_SLASH_EQ] = ACTIONS(246),
    [anon_sym_EQ_LT] = ACTIONS(246),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(246),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(246),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(246),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(246),
    [anon_sym_QMARK_EQ] = ACTIONS(246),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(246),
    [anon_sym_COLON_COLON] = ACTIONS(246),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(246),
    [anon_sym_LT_EQ] = ACTIONS(246),
    [anon_sym_EQ_GT] = ACTIONS(246),
    [anon_sym_COLON_EQ] = ACTIONS(246),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(246),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(246),
    [sym_float] = ACTIONS(246),
    [sym__atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(246),
    [sym_variable] = ACTIONS(246),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(246),
    [sym_tripledot] = ACTIONS(246),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [55] = {
    [sym_arguments] = STATE(78),
    [sym_comment] = STATE(55),
    [ts_builtin_sym_end] = ACTIONS(238),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym_LF] = ACTIONS(238),
    [anon_sym_DOT] = ACTIONS(240),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(373),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_when] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(240),
    [anon_sym_LBRACE] = ACTIONS(240),
    [anon_sym_LBRACK] = ACTIONS(240),
    [anon_sym_POUND] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_bnot] = ACTIONS(240),
    [anon_sym_catch] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(240),
    [anon_sym_div] = ACTIONS(240),
    [anon_sym_rem] = ACTIONS(240),
    [anon_sym_band] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_bor] = ACTIONS(240),
    [anon_sym_bxor] = ACTIONS(240),
    [anon_sym_bsl] = ACTIONS(240),
    [anon_sym_bsr] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_xor] = ACTIONS(240),
    [anon_sym_PLUS_PLUS] = ACTIONS(240),
    [anon_sym_DASH_DASH] = ACTIONS(240),
    [anon_sym_EQ_EQ] = ACTIONS(240),
    [anon_sym_SLASH_EQ] = ACTIONS(240),
    [anon_sym_EQ_LT] = ACTIONS(240),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(240),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(240),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(240),
    [anon_sym_andalso] = ACTIONS(240),
    [anon_sym_orelse] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(240),
    [anon_sym_QMARK_EQ] = ACTIONS(240),
    [anon_sym_DOT_DOT] = ACTIONS(240),
    [anon_sym_PIPE_PIPE] = ACTIONS(240),
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_LT_DASH] = ACTIONS(240),
    [anon_sym_LT_EQ] = ACTIONS(240),
    [anon_sym_EQ_GT] = ACTIONS(240),
    [anon_sym_COLON_EQ] = ACTIONS(240),
    [anon_sym_fun] = ACTIONS(240),
    [anon_sym_begin] = ACTIONS(240),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_receive] = ACTIONS(240),
    [anon_sym_try] = ACTIONS(240),
    [anon_sym_maybe] = ACTIONS(240),
    [anon_sym_DOLLAR] = ACTIONS(240),
    [aux_sym_integer_token1] = ACTIONS(240),
    [aux_sym_integer_token2] = ACTIONS(240),
    [sym_float] = ACTIONS(240),
    [sym__atom] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(240),
    [sym_variable] = ACTIONS(240),
    [anon_sym_QMARK] = ACTIONS(240),
    [anon_sym_DQUOTE] = ACTIONS(240),
    [sym_tripledot] = ACTIONS(240),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [56] = {
    [sym_arguments] = STATE(57),
    [sym_comment] = STATE(56),
    [anon_sym_COMMA] = ACTIONS(238),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(379),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_when] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(238),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_bnot] = ACTIONS(240),
    [anon_sym_catch] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(238),
    [anon_sym_div] = ACTIONS(240),
    [anon_sym_rem] = ACTIONS(240),
    [anon_sym_band] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_bor] = ACTIONS(240),
    [anon_sym_bxor] = ACTIONS(240),
    [anon_sym_bsl] = ACTIONS(240),
    [anon_sym_bsr] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_xor] = ACTIONS(240),
    [anon_sym_PLUS_PLUS] = ACTIONS(238),
    [anon_sym_DASH_DASH] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_EQ_LT] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(238),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(238),
    [anon_sym_andalso] = ACTIONS(240),
    [anon_sym_orelse] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_QMARK_EQ] = ACTIONS(238),
    [anon_sym_DOT_DOT] = ACTIONS(240),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_LT_DASH] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_EQ_GT] = ACTIONS(238),
    [anon_sym_COLON_EQ] = ACTIONS(238),
    [anon_sym_fun] = ACTIONS(240),
    [anon_sym_end] = ACTIONS(240),
    [anon_sym_begin] = ACTIONS(240),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_of] = ACTIONS(240),
    [anon_sym_receive] = ACTIONS(240),
    [anon_sym_after] = ACTIONS(240),
    [anon_sym_try] = ACTIONS(240),
    [anon_sym_maybe] = ACTIONS(240),
    [anon_sym_DOLLAR] = ACTIONS(238),
    [aux_sym_integer_token1] = ACTIONS(240),
    [aux_sym_integer_token2] = ACTIONS(238),
    [sym_float] = ACTIONS(238),
    [sym__atom] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [sym_variable] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(240),
    [anon_sym_DQUOTE] = ACTIONS(238),
    [sym_tripledot] = ACTIONS(238),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [57] = {
    [sym_comment] = STATE(57),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_of] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_after] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym__atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [58] = {
    [sym_comment] = STATE(58),
    [anon_sym_COMMA] = ACTIONS(252),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_end] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_of] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_after] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym__atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [59] = {
    [sym_comment] = STATE(59),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_after] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym__atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [60] = {
    [sym_comment] = STATE(60),
    [anon_sym_COMMA] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(264),
    [anon_sym_DASH] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_when] = ACTIONS(266),
    [anon_sym_if] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(264),
    [anon_sym_LBRACK] = ACTIONS(264),
    [anon_sym_POUND] = ACTIONS(264),
    [anon_sym_PLUS] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(266),
    [anon_sym_bnot] = ACTIONS(266),
    [anon_sym_catch] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(266),
    [anon_sym_STAR] = ACTIONS(264),
    [anon_sym_div] = ACTIONS(266),
    [anon_sym_rem] = ACTIONS(266),
    [anon_sym_band] = ACTIONS(266),
    [anon_sym_and] = ACTIONS(266),
    [anon_sym_bor] = ACTIONS(266),
    [anon_sym_bxor] = ACTIONS(266),
    [anon_sym_bsl] = ACTIONS(266),
    [anon_sym_bsr] = ACTIONS(266),
    [anon_sym_or] = ACTIONS(266),
    [anon_sym_xor] = ACTIONS(266),
    [anon_sym_PLUS_PLUS] = ACTIONS(264),
    [anon_sym_DASH_DASH] = ACTIONS(264),
    [anon_sym_EQ_EQ] = ACTIONS(264),
    [anon_sym_SLASH_EQ] = ACTIONS(264),
    [anon_sym_EQ_LT] = ACTIONS(264),
    [anon_sym_LT] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(264),
    [anon_sym_GT] = ACTIONS(266),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(264),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(264),
    [anon_sym_andalso] = ACTIONS(266),
    [anon_sym_orelse] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(266),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_QMARK_EQ] = ACTIONS(264),
    [anon_sym_DOT_DOT] = ACTIONS(266),
    [anon_sym_PIPE_PIPE] = ACTIONS(264),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_LT_DASH] = ACTIONS(264),
    [anon_sym_LT_EQ] = ACTIONS(264),
    [anon_sym_EQ_GT] = ACTIONS(264),
    [anon_sym_COLON_EQ] = ACTIONS(264),
    [anon_sym_fun] = ACTIONS(266),
    [anon_sym_end] = ACTIONS(266),
    [anon_sym_begin] = ACTIONS(266),
    [anon_sym_case] = ACTIONS(266),
    [anon_sym_receive] = ACTIONS(266),
    [anon_sym_after] = ACTIONS(266),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_maybe] = ACTIONS(266),
    [anon_sym_DOLLAR] = ACTIONS(264),
    [aux_sym_integer_token1] = ACTIONS(266),
    [aux_sym_integer_token2] = ACTIONS(264),
    [sym_float] = ACTIONS(264),
    [sym__atom] = ACTIONS(266),
    [anon_sym_SQUOTE] = ACTIONS(264),
    [sym_variable] = ACTIONS(264),
    [anon_sym_QMARK] = ACTIONS(266),
    [anon_sym_DQUOTE] = ACTIONS(264),
    [sym_tripledot] = ACTIONS(264),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [61] = {
    [sym_comment] = STATE(61),
    [anon_sym_COMMA] = ACTIONS(276),
    [anon_sym_SEMI] = ACTIONS(276),
    [anon_sym_DASH] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(276),
    [anon_sym_COLON] = ACTIONS(278),
    [anon_sym_when] = ACTIONS(278),
    [anon_sym_if] = ACTIONS(278),
    [anon_sym_LT_LT] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(276),
    [anon_sym_LBRACK] = ACTIONS(276),
    [anon_sym_POUND] = ACTIONS(276),
    [anon_sym_PLUS] = ACTIONS(278),
    [anon_sym_not] = ACTIONS(278),
    [anon_sym_bnot] = ACTIONS(278),
    [anon_sym_catch] = ACTIONS(278),
    [anon_sym_SLASH] = ACTIONS(278),
    [anon_sym_STAR] = ACTIONS(276),
    [anon_sym_div] = ACTIONS(278),
    [anon_sym_rem] = ACTIONS(278),
    [anon_sym_band] = ACTIONS(278),
    [anon_sym_and] = ACTIONS(278),
    [anon_sym_bor] = ACTIONS(278),
    [anon_sym_bxor] = ACTIONS(278),
    [anon_sym_bsl] = ACTIONS(278),
    [anon_sym_bsr] = ACTIONS(278),
    [anon_sym_or] = ACTIONS(278),
    [anon_sym_xor] = ACTIONS(278),
    [anon_sym_PLUS_PLUS] = ACTIONS(276),
    [anon_sym_DASH_DASH] = ACTIONS(276),
    [anon_sym_EQ_EQ] = ACTIONS(276),
    [anon_sym_SLASH_EQ] = ACTIONS(276),
    [anon_sym_EQ_LT] = ACTIONS(276),
    [anon_sym_LT] = ACTIONS(278),
    [anon_sym_GT_EQ] = ACTIONS(276),
    [anon_sym_GT] = ACTIONS(278),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(276),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(276),
    [anon_sym_andalso] = ACTIONS(278),
    [anon_sym_orelse] = ACTIONS(278),
    [anon_sym_EQ] = ACTIONS(278),
    [anon_sym_BANG] = ACTIONS(276),
    [anon_sym_QMARK_EQ] = ACTIONS(276),
    [anon_sym_DOT_DOT] = ACTIONS(278),
    [anon_sym_PIPE_PIPE] = ACTIONS(276),
    [anon_sym_COLON_COLON] = ACTIONS(276),
    [anon_sym_PIPE] = ACTIONS(278),
    [anon_sym_LT_DASH] = ACTIONS(276),
    [anon_sym_LT_EQ] = ACTIONS(276),
    [anon_sym_EQ_GT] = ACTIONS(276),
    [anon_sym_COLON_EQ] = ACTIONS(276),
    [anon_sym_fun] = ACTIONS(278),
    [anon_sym_end] = ACTIONS(278),
    [anon_sym_begin] = ACTIONS(278),
    [anon_sym_case] = ACTIONS(278),
    [anon_sym_receive] = ACTIONS(278),
    [anon_sym_after] = ACTIONS(278),
    [anon_sym_try] = ACTIONS(278),
    [anon_sym_maybe] = ACTIONS(278),
    [anon_sym_DOLLAR] = ACTIONS(276),
    [aux_sym_integer_token1] = ACTIONS(278),
    [aux_sym_integer_token2] = ACTIONS(276),
    [sym_float] = ACTIONS(276),
    [sym__atom] = ACTIONS(278),
    [anon_sym_SQUOTE] = ACTIONS(276),
    [sym_variable] = ACTIONS(276),
    [anon_sym_QMARK] = ACTIONS(278),
    [anon_sym_DQUOTE] = ACTIONS(276),
    [sym_tripledot] = ACTIONS(276),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [62] = {
    [sym_comment] = STATE(62),
    [ts_builtin_sym_end] = ACTIONS(264),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_LF] = ACTIONS(264),
    [anon_sym_DOT] = ACTIONS(266),
    [anon_sym_DASH] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(266),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_when] = ACTIONS(266),
    [anon_sym_if] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_LBRACE] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(266),
    [anon_sym_POUND] = ACTIONS(266),
    [anon_sym_PLUS] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(266),
    [anon_sym_bnot] = ACTIONS(266),
    [anon_sym_catch] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(266),
    [anon_sym_STAR] = ACTIONS(266),
    [anon_sym_div] = ACTIONS(266),
    [anon_sym_rem] = ACTIONS(266),
    [anon_sym_band] = ACTIONS(266),
    [anon_sym_and] = ACTIONS(266),
    [anon_sym_bor] = ACTIONS(266),
    [anon_sym_bxor] = ACTIONS(266),
    [anon_sym_bsl] = ACTIONS(266),
    [anon_sym_bsr] = ACTIONS(266),
    [anon_sym_or] = ACTIONS(266),
    [anon_sym_xor] = ACTIONS(266),
    [anon_sym_PLUS_PLUS] = ACTIONS(266),
    [anon_sym_DASH_DASH] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_SLASH_EQ] = ACTIONS(266),
    [anon_sym_EQ_LT] = ACTIONS(266),
    [anon_sym_LT] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(266),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(266),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(266),
    [anon_sym_andalso] = ACTIONS(266),
    [anon_sym_orelse] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(266),
    [anon_sym_BANG] = ACTIONS(266),
    [anon_sym_QMARK_EQ] = ACTIONS(266),
    [anon_sym_DOT_DOT] = ACTIONS(266),
    [anon_sym_PIPE_PIPE] = ACTIONS(266),
    [anon_sym_COLON_COLON] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_LT_DASH] = ACTIONS(266),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_GT] = ACTIONS(266),
    [anon_sym_COLON_EQ] = ACTIONS(266),
    [anon_sym_fun] = ACTIONS(266),
    [anon_sym_begin] = ACTIONS(266),
    [anon_sym_case] = ACTIONS(266),
    [anon_sym_receive] = ACTIONS(266),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_maybe] = ACTIONS(266),
    [anon_sym_DOLLAR] = ACTIONS(266),
    [aux_sym_integer_token1] = ACTIONS(266),
    [aux_sym_integer_token2] = ACTIONS(266),
    [sym_float] = ACTIONS(266),
    [sym__atom] = ACTIONS(266),
    [anon_sym_SQUOTE] = ACTIONS(266),
    [sym_variable] = ACTIONS(266),
    [anon_sym_QMARK] = ACTIONS(266),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_tripledot] = ACTIONS(266),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [63] = {
    [sym_comment] = STATE(63),
    [anon_sym_COMMA] = ACTIONS(260),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_LPAREN] = ACTIONS(260),
    [anon_sym_COLON] = ACTIONS(262),
    [anon_sym_when] = ACTIONS(262),
    [anon_sym_if] = ACTIONS(262),
    [anon_sym_LT_LT] = ACTIONS(260),
    [anon_sym_LBRACE] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(260),
    [anon_sym_POUND] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_not] = ACTIONS(262),
    [anon_sym_bnot] = ACTIONS(262),
    [anon_sym_catch] = ACTIONS(262),
    [anon_sym_SLASH] = ACTIONS(262),
    [anon_sym_STAR] = ACTIONS(260),
    [anon_sym_div] = ACTIONS(262),
    [anon_sym_rem] = ACTIONS(262),
    [anon_sym_band] = ACTIONS(262),
    [anon_sym_and] = ACTIONS(262),
    [anon_sym_bor] = ACTIONS(262),
    [anon_sym_bxor] = ACTIONS(262),
    [anon_sym_bsl] = ACTIONS(262),
    [anon_sym_bsr] = ACTIONS(262),
    [anon_sym_or] = ACTIONS(262),
    [anon_sym_xor] = ACTIONS(262),
    [anon_sym_PLUS_PLUS] = ACTIONS(260),
    [anon_sym_DASH_DASH] = ACTIONS(260),
    [anon_sym_EQ_EQ] = ACTIONS(260),
    [anon_sym_SLASH_EQ] = ACTIONS(260),
    [anon_sym_EQ_LT] = ACTIONS(260),
    [anon_sym_LT] = ACTIONS(262),
    [anon_sym_GT_EQ] = ACTIONS(260),
    [anon_sym_GT] = ACTIONS(262),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(260),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(260),
    [anon_sym_andalso] = ACTIONS(262),
    [anon_sym_orelse] = ACTIONS(262),
    [anon_sym_EQ] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(260),
    [anon_sym_QMARK_EQ] = ACTIONS(260),
    [anon_sym_DOT_DOT] = ACTIONS(262),
    [anon_sym_PIPE_PIPE] = ACTIONS(260),
    [anon_sym_COLON_COLON] = ACTIONS(260),
    [anon_sym_PIPE] = ACTIONS(262),
    [anon_sym_LT_DASH] = ACTIONS(260),
    [anon_sym_LT_EQ] = ACTIONS(260),
    [anon_sym_EQ_GT] = ACTIONS(260),
    [anon_sym_COLON_EQ] = ACTIONS(260),
    [anon_sym_fun] = ACTIONS(262),
    [anon_sym_end] = ACTIONS(262),
    [anon_sym_begin] = ACTIONS(262),
    [anon_sym_case] = ACTIONS(262),
    [anon_sym_of] = ACTIONS(262),
    [anon_sym_receive] = ACTIONS(262),
    [anon_sym_after] = ACTIONS(262),
    [anon_sym_try] = ACTIONS(262),
    [anon_sym_maybe] = ACTIONS(262),
    [anon_sym_DOLLAR] = ACTIONS(260),
    [aux_sym_integer_token1] = ACTIONS(262),
    [aux_sym_integer_token2] = ACTIONS(260),
    [sym_float] = ACTIONS(260),
    [sym__atom] = ACTIONS(262),
    [anon_sym_SQUOTE] = ACTIONS(260),
    [sym_variable] = ACTIONS(260),
    [anon_sym_QMARK] = ACTIONS(262),
    [anon_sym_DQUOTE] = ACTIONS(260),
    [sym_tripledot] = ACTIONS(260),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [64] = {
    [sym_comment] = STATE(64),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_DASH] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(272),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_when] = ACTIONS(274),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(272),
    [anon_sym_POUND] = ACTIONS(272),
    [anon_sym_PLUS] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_bnot] = ACTIONS(274),
    [anon_sym_catch] = ACTIONS(274),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(272),
    [anon_sym_div] = ACTIONS(274),
    [anon_sym_rem] = ACTIONS(274),
    [anon_sym_band] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_bor] = ACTIONS(274),
    [anon_sym_bxor] = ACTIONS(274),
    [anon_sym_bsl] = ACTIONS(274),
    [anon_sym_bsr] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_xor] = ACTIONS(274),
    [anon_sym_PLUS_PLUS] = ACTIONS(272),
    [anon_sym_DASH_DASH] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_SLASH_EQ] = ACTIONS(272),
    [anon_sym_EQ_LT] = ACTIONS(272),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(272),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(272),
    [anon_sym_andalso] = ACTIONS(274),
    [anon_sym_orelse] = ACTIONS(274),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_BANG] = ACTIONS(272),
    [anon_sym_QMARK_EQ] = ACTIONS(272),
    [anon_sym_DOT_DOT] = ACTIONS(274),
    [anon_sym_PIPE_PIPE] = ACTIONS(272),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_LT_DASH] = ACTIONS(272),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(272),
    [anon_sym_fun] = ACTIONS(274),
    [anon_sym_end] = ACTIONS(274),
    [anon_sym_begin] = ACTIONS(274),
    [anon_sym_case] = ACTIONS(274),
    [anon_sym_of] = ACTIONS(274),
    [anon_sym_receive] = ACTIONS(274),
    [anon_sym_after] = ACTIONS(274),
    [anon_sym_try] = ACTIONS(274),
    [anon_sym_maybe] = ACTIONS(274),
    [anon_sym_DOLLAR] = ACTIONS(272),
    [aux_sym_integer_token1] = ACTIONS(274),
    [aux_sym_integer_token2] = ACTIONS(272),
    [sym_float] = ACTIONS(272),
    [sym__atom] = ACTIONS(274),
    [anon_sym_SQUOTE] = ACTIONS(272),
    [sym_variable] = ACTIONS(272),
    [anon_sym_QMARK] = ACTIONS(274),
    [anon_sym_DQUOTE] = ACTIONS(272),
    [sym_tripledot] = ACTIONS(272),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [65] = {
    [sym_comment] = STATE(65),
    [anon_sym_COMMA] = ACTIONS(256),
    [anon_sym_DASH] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(256),
    [anon_sym_COLON] = ACTIONS(258),
    [anon_sym_when] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_LT_LT] = ACTIONS(256),
    [anon_sym_LBRACE] = ACTIONS(256),
    [anon_sym_LBRACK] = ACTIONS(256),
    [anon_sym_POUND] = ACTIONS(256),
    [anon_sym_PLUS] = ACTIONS(258),
    [anon_sym_not] = ACTIONS(258),
    [anon_sym_bnot] = ACTIONS(258),
    [anon_sym_catch] = ACTIONS(258),
    [anon_sym_SLASH] = ACTIONS(258),
    [anon_sym_STAR] = ACTIONS(256),
    [anon_sym_div] = ACTIONS(258),
    [anon_sym_rem] = ACTIONS(258),
    [anon_sym_band] = ACTIONS(258),
    [anon_sym_and] = ACTIONS(258),
    [anon_sym_bor] = ACTIONS(258),
    [anon_sym_bxor] = ACTIONS(258),
    [anon_sym_bsl] = ACTIONS(258),
    [anon_sym_bsr] = ACTIONS(258),
    [anon_sym_or] = ACTIONS(258),
    [anon_sym_xor] = ACTIONS(258),
    [anon_sym_PLUS_PLUS] = ACTIONS(256),
    [anon_sym_DASH_DASH] = ACTIONS(256),
    [anon_sym_EQ_EQ] = ACTIONS(256),
    [anon_sym_SLASH_EQ] = ACTIONS(256),
    [anon_sym_EQ_LT] = ACTIONS(256),
    [anon_sym_LT] = ACTIONS(258),
    [anon_sym_GT_EQ] = ACTIONS(256),
    [anon_sym_GT] = ACTIONS(258),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(256),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(256),
    [anon_sym_andalso] = ACTIONS(258),
    [anon_sym_orelse] = ACTIONS(258),
    [anon_sym_EQ] = ACTIONS(258),
    [anon_sym_BANG] = ACTIONS(256),
    [anon_sym_QMARK_EQ] = ACTIONS(256),
    [anon_sym_DOT_DOT] = ACTIONS(258),
    [anon_sym_PIPE_PIPE] = ACTIONS(256),
    [anon_sym_COLON_COLON] = ACTIONS(256),
    [anon_sym_PIPE] = ACTIONS(258),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_LT_EQ] = ACTIONS(256),
    [anon_sym_EQ_GT] = ACTIONS(256),
    [anon_sym_COLON_EQ] = ACTIONS(256),
    [anon_sym_fun] = ACTIONS(258),
    [anon_sym_end] = ACTIONS(258),
    [anon_sym_begin] = ACTIONS(258),
    [anon_sym_case] = ACTIONS(258),
    [anon_sym_of] = ACTIONS(258),
    [anon_sym_receive] = ACTIONS(258),
    [anon_sym_after] = ACTIONS(258),
    [anon_sym_try] = ACTIONS(258),
    [anon_sym_maybe] = ACTIONS(258),
    [anon_sym_DOLLAR] = ACTIONS(256),
    [aux_sym_integer_token1] = ACTIONS(258),
    [aux_sym_integer_token2] = ACTIONS(256),
    [sym_float] = ACTIONS(256),
    [sym__atom] = ACTIONS(258),
    [anon_sym_SQUOTE] = ACTIONS(256),
    [sym_variable] = ACTIONS(256),
    [anon_sym_QMARK] = ACTIONS(258),
    [anon_sym_DQUOTE] = ACTIONS(256),
    [sym_tripledot] = ACTIONS(256),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [66] = {
    [sym_arguments] = STATE(80),
    [sym_comment] = STATE(66),
    [anon_sym_COMMA] = ACTIONS(238),
    [anon_sym_SEMI] = ACTIONS(238),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(242),
    [anon_sym_RPAREN] = ACTIONS(238),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_when] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(238),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_bnot] = ACTIONS(240),
    [anon_sym_catch] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(238),
    [anon_sym_div] = ACTIONS(240),
    [anon_sym_rem] = ACTIONS(240),
    [anon_sym_band] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_bor] = ACTIONS(240),
    [anon_sym_bxor] = ACTIONS(240),
    [anon_sym_bsl] = ACTIONS(240),
    [anon_sym_bsr] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_xor] = ACTIONS(240),
    [anon_sym_PLUS_PLUS] = ACTIONS(238),
    [anon_sym_DASH_DASH] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_EQ_LT] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(238),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(238),
    [anon_sym_andalso] = ACTIONS(240),
    [anon_sym_orelse] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_QMARK_EQ] = ACTIONS(238),
    [anon_sym_DOT_DOT] = ACTIONS(240),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_LT_DASH] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_EQ_GT] = ACTIONS(238),
    [anon_sym_COLON_EQ] = ACTIONS(238),
    [anon_sym_fun] = ACTIONS(240),
    [anon_sym_begin] = ACTIONS(240),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_receive] = ACTIONS(240),
    [anon_sym_try] = ACTIONS(240),
    [anon_sym_maybe] = ACTIONS(240),
    [anon_sym_DOLLAR] = ACTIONS(238),
    [aux_sym_integer_token1] = ACTIONS(240),
    [aux_sym_integer_token2] = ACTIONS(238),
    [sym_float] = ACTIONS(238),
    [sym__atom] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [sym_variable] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(240),
    [anon_sym_DQUOTE] = ACTIONS(238),
    [sym_tripledot] = ACTIONS(238),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [67] = {
    [sym_comment] = STATE(67),
    [anon_sym_COMMA] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_when] = ACTIONS(282),
    [anon_sym_if] = ACTIONS(282),
    [anon_sym_LT_LT] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_LBRACK] = ACTIONS(280),
    [anon_sym_POUND] = ACTIONS(280),
    [anon_sym_PLUS] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_bnot] = ACTIONS(282),
    [anon_sym_catch] = ACTIONS(282),
    [anon_sym_SLASH] = ACTIONS(282),
    [anon_sym_STAR] = ACTIONS(280),
    [anon_sym_div] = ACTIONS(282),
    [anon_sym_rem] = ACTIONS(282),
    [anon_sym_band] = ACTIONS(282),
    [anon_sym_and] = ACTIONS(282),
    [anon_sym_bor] = ACTIONS(282),
    [anon_sym_bxor] = ACTIONS(282),
    [anon_sym_bsl] = ACTIONS(282),
    [anon_sym_bsr] = ACTIONS(282),
    [anon_sym_or] = ACTIONS(282),
    [anon_sym_xor] = ACTIONS(282),
    [anon_sym_PLUS_PLUS] = ACTIONS(280),
    [anon_sym_DASH_DASH] = ACTIONS(280),
    [anon_sym_EQ_EQ] = ACTIONS(280),
    [anon_sym_SLASH_EQ] = ACTIONS(280),
    [anon_sym_EQ_LT] = ACTIONS(280),
    [anon_sym_LT] = ACTIONS(282),
    [anon_sym_GT_EQ] = ACTIONS(280),
    [anon_sym_GT] = ACTIONS(282),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(280),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(280),
    [anon_sym_andalso] = ACTIONS(282),
    [anon_sym_orelse] = ACTIONS(282),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_BANG] = ACTIONS(280),
    [anon_sym_QMARK_EQ] = ACTIONS(280),
    [anon_sym_DOT_DOT] = ACTIONS(282),
    [anon_sym_PIPE_PIPE] = ACTIONS(280),
    [anon_sym_COLON_COLON] = ACTIONS(280),
    [anon_sym_PIPE] = ACTIONS(282),
    [anon_sym_LT_DASH] = ACTIONS(280),
    [anon_sym_LT_EQ] = ACTIONS(280),
    [anon_sym_EQ_GT] = ACTIONS(280),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_fun] = ACTIONS(282),
    [anon_sym_end] = ACTIONS(282),
    [anon_sym_begin] = ACTIONS(282),
    [anon_sym_case] = ACTIONS(282),
    [anon_sym_of] = ACTIONS(282),
    [anon_sym_receive] = ACTIONS(282),
    [anon_sym_after] = ACTIONS(282),
    [anon_sym_try] = ACTIONS(282),
    [anon_sym_maybe] = ACTIONS(282),
    [anon_sym_DOLLAR] = ACTIONS(280),
    [aux_sym_integer_token1] = ACTIONS(282),
    [aux_sym_integer_token2] = ACTIONS(280),
    [sym_float] = ACTIONS(280),
    [sym__atom] = ACTIONS(282),
    [anon_sym_SQUOTE] = ACTIONS(280),
    [sym_variable] = ACTIONS(280),
    [anon_sym_QMARK] = ACTIONS(282),
    [anon_sym_DQUOTE] = ACTIONS(280),
    [sym_tripledot] = ACTIONS(280),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [68] = {
    [sym_comment] = STATE(68),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_of] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_after] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym__atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [69] = {
    [sym_comment] = STATE(69),
    [anon_sym_COMMA] = ACTIONS(268),
    [anon_sym_SEMI] = ACTIONS(268),
    [anon_sym_DASH] = ACTIONS(270),
    [anon_sym_LPAREN] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_when] = ACTIONS(270),
    [anon_sym_if] = ACTIONS(270),
    [anon_sym_LT_LT] = ACTIONS(268),
    [anon_sym_LBRACE] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(268),
    [anon_sym_POUND] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(270),
    [anon_sym_not] = ACTIONS(270),
    [anon_sym_bnot] = ACTIONS(270),
    [anon_sym_catch] = ACTIONS(270),
    [anon_sym_SLASH] = ACTIONS(270),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_div] = ACTIONS(270),
    [anon_sym_rem] = ACTIONS(270),
    [anon_sym_band] = ACTIONS(270),
    [anon_sym_and] = ACTIONS(270),
    [anon_sym_bor] = ACTIONS(270),
    [anon_sym_bxor] = ACTIONS(270),
    [anon_sym_bsl] = ACTIONS(270),
    [anon_sym_bsr] = ACTIONS(270),
    [anon_sym_or] = ACTIONS(270),
    [anon_sym_xor] = ACTIONS(270),
    [anon_sym_PLUS_PLUS] = ACTIONS(268),
    [anon_sym_DASH_DASH] = ACTIONS(268),
    [anon_sym_EQ_EQ] = ACTIONS(268),
    [anon_sym_SLASH_EQ] = ACTIONS(268),
    [anon_sym_EQ_LT] = ACTIONS(268),
    [anon_sym_LT] = ACTIONS(270),
    [anon_sym_GT_EQ] = ACTIONS(268),
    [anon_sym_GT] = ACTIONS(270),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(268),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(268),
    [anon_sym_andalso] = ACTIONS(270),
    [anon_sym_orelse] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(270),
    [anon_sym_BANG] = ACTIONS(268),
    [anon_sym_QMARK_EQ] = ACTIONS(268),
    [anon_sym_DOT_DOT] = ACTIONS(270),
    [anon_sym_PIPE_PIPE] = ACTIONS(268),
    [anon_sym_COLON_COLON] = ACTIONS(268),
    [anon_sym_PIPE] = ACTIONS(270),
    [anon_sym_LT_DASH] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(268),
    [anon_sym_EQ_GT] = ACTIONS(268),
    [anon_sym_COLON_EQ] = ACTIONS(268),
    [anon_sym_fun] = ACTIONS(270),
    [anon_sym_end] = ACTIONS(270),
    [anon_sym_begin] = ACTIONS(270),
    [anon_sym_case] = ACTIONS(270),
    [anon_sym_receive] = ACTIONS(270),
    [anon_sym_after] = ACTIONS(270),
    [anon_sym_try] = ACTIONS(270),
    [anon_sym_maybe] = ACTIONS(270),
    [anon_sym_DOLLAR] = ACTIONS(268),
    [aux_sym_integer_token1] = ACTIONS(270),
    [aux_sym_integer_token2] = ACTIONS(268),
    [sym_float] = ACTIONS(268),
    [sym__atom] = ACTIONS(270),
    [anon_sym_SQUOTE] = ACTIONS(268),
    [sym_variable] = ACTIONS(268),
    [anon_sym_QMARK] = ACTIONS(270),
    [anon_sym_DQUOTE] = ACTIONS(268),
    [sym_tripledot] = ACTIONS(268),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [70] = {
    [sym_comment] = STATE(70),
    [anon_sym_COMMA] = ACTIONS(280),
    [anon_sym_SEMI] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_when] = ACTIONS(282),
    [anon_sym_if] = ACTIONS(282),
    [anon_sym_LT_LT] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_LBRACK] = ACTIONS(280),
    [anon_sym_POUND] = ACTIONS(280),
    [anon_sym_PLUS] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_bnot] = ACTIONS(282),
    [anon_sym_catch] = ACTIONS(282),
    [anon_sym_SLASH] = ACTIONS(282),
    [anon_sym_STAR] = ACTIONS(280),
    [anon_sym_div] = ACTIONS(282),
    [anon_sym_rem] = ACTIONS(282),
    [anon_sym_band] = ACTIONS(282),
    [anon_sym_and] = ACTIONS(282),
    [anon_sym_bor] = ACTIONS(282),
    [anon_sym_bxor] = ACTIONS(282),
    [anon_sym_bsl] = ACTIONS(282),
    [anon_sym_bsr] = ACTIONS(282),
    [anon_sym_or] = ACTIONS(282),
    [anon_sym_xor] = ACTIONS(282),
    [anon_sym_PLUS_PLUS] = ACTIONS(280),
    [anon_sym_DASH_DASH] = ACTIONS(280),
    [anon_sym_EQ_EQ] = ACTIONS(280),
    [anon_sym_SLASH_EQ] = ACTIONS(280),
    [anon_sym_EQ_LT] = ACTIONS(280),
    [anon_sym_LT] = ACTIONS(282),
    [anon_sym_GT_EQ] = ACTIONS(280),
    [anon_sym_GT] = ACTIONS(282),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(280),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(280),
    [anon_sym_andalso] = ACTIONS(282),
    [anon_sym_orelse] = ACTIONS(282),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_BANG] = ACTIONS(280),
    [anon_sym_QMARK_EQ] = ACTIONS(280),
    [anon_sym_DOT_DOT] = ACTIONS(282),
    [anon_sym_PIPE_PIPE] = ACTIONS(280),
    [anon_sym_COLON_COLON] = ACTIONS(280),
    [anon_sym_PIPE] = ACTIONS(282),
    [anon_sym_LT_DASH] = ACTIONS(280),
    [anon_sym_LT_EQ] = ACTIONS(280),
    [anon_sym_EQ_GT] = ACTIONS(280),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_fun] = ACTIONS(282),
    [anon_sym_end] = ACTIONS(282),
    [anon_sym_begin] = ACTIONS(282),
    [anon_sym_case] = ACTIONS(282),
    [anon_sym_receive] = ACTIONS(282),
    [anon_sym_after] = ACTIONS(282),
    [anon_sym_try] = ACTIONS(282),
    [anon_sym_maybe] = ACTIONS(282),
    [anon_sym_DOLLAR] = ACTIONS(280),
    [aux_sym_integer_token1] = ACTIONS(282),
    [aux_sym_integer_token2] = ACTIONS(280),
    [sym_float] = ACTIONS(280),
    [sym__atom] = ACTIONS(282),
    [anon_sym_SQUOTE] = ACTIONS(280),
    [sym_variable] = ACTIONS(280),
    [anon_sym_QMARK] = ACTIONS(282),
    [anon_sym_DQUOTE] = ACTIONS(280),
    [sym_tripledot] = ACTIONS(280),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [71] = {
    [sym_comment] = STATE(71),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_SEMI] = ACTIONS(272),
    [anon_sym_DASH] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(272),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_when] = ACTIONS(274),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(272),
    [anon_sym_POUND] = ACTIONS(272),
    [anon_sym_PLUS] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_bnot] = ACTIONS(274),
    [anon_sym_catch] = ACTIONS(274),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(272),
    [anon_sym_div] = ACTIONS(274),
    [anon_sym_rem] = ACTIONS(274),
    [anon_sym_band] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_bor] = ACTIONS(274),
    [anon_sym_bxor] = ACTIONS(274),
    [anon_sym_bsl] = ACTIONS(274),
    [anon_sym_bsr] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_xor] = ACTIONS(274),
    [anon_sym_PLUS_PLUS] = ACTIONS(272),
    [anon_sym_DASH_DASH] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_SLASH_EQ] = ACTIONS(272),
    [anon_sym_EQ_LT] = ACTIONS(272),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(272),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(272),
    [anon_sym_andalso] = ACTIONS(274),
    [anon_sym_orelse] = ACTIONS(274),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_BANG] = ACTIONS(272),
    [anon_sym_QMARK_EQ] = ACTIONS(272),
    [anon_sym_DOT_DOT] = ACTIONS(274),
    [anon_sym_PIPE_PIPE] = ACTIONS(272),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_LT_DASH] = ACTIONS(272),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(272),
    [anon_sym_fun] = ACTIONS(274),
    [anon_sym_end] = ACTIONS(274),
    [anon_sym_begin] = ACTIONS(274),
    [anon_sym_case] = ACTIONS(274),
    [anon_sym_receive] = ACTIONS(274),
    [anon_sym_after] = ACTIONS(274),
    [anon_sym_try] = ACTIONS(274),
    [anon_sym_maybe] = ACTIONS(274),
    [anon_sym_DOLLAR] = ACTIONS(272),
    [aux_sym_integer_token1] = ACTIONS(274),
    [aux_sym_integer_token2] = ACTIONS(272),
    [sym_float] = ACTIONS(272),
    [sym__atom] = ACTIONS(274),
    [anon_sym_SQUOTE] = ACTIONS(272),
    [sym_variable] = ACTIONS(272),
    [anon_sym_QMARK] = ACTIONS(274),
    [anon_sym_DQUOTE] = ACTIONS(272),
    [sym_tripledot] = ACTIONS(272),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [72] = {
    [sym_comment] = STATE(72),
    [anon_sym_COMMA] = ACTIONS(276),
    [anon_sym_DASH] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(276),
    [anon_sym_COLON] = ACTIONS(278),
    [anon_sym_when] = ACTIONS(278),
    [anon_sym_if] = ACTIONS(278),
    [anon_sym_LT_LT] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(276),
    [anon_sym_LBRACK] = ACTIONS(276),
    [anon_sym_POUND] = ACTIONS(276),
    [anon_sym_PLUS] = ACTIONS(278),
    [anon_sym_not] = ACTIONS(278),
    [anon_sym_bnot] = ACTIONS(278),
    [anon_sym_catch] = ACTIONS(278),
    [anon_sym_SLASH] = ACTIONS(278),
    [anon_sym_STAR] = ACTIONS(276),
    [anon_sym_div] = ACTIONS(278),
    [anon_sym_rem] = ACTIONS(278),
    [anon_sym_band] = ACTIONS(278),
    [anon_sym_and] = ACTIONS(278),
    [anon_sym_bor] = ACTIONS(278),
    [anon_sym_bxor] = ACTIONS(278),
    [anon_sym_bsl] = ACTIONS(278),
    [anon_sym_bsr] = ACTIONS(278),
    [anon_sym_or] = ACTIONS(278),
    [anon_sym_xor] = ACTIONS(278),
    [anon_sym_PLUS_PLUS] = ACTIONS(276),
    [anon_sym_DASH_DASH] = ACTIONS(276),
    [anon_sym_EQ_EQ] = ACTIONS(276),
    [anon_sym_SLASH_EQ] = ACTIONS(276),
    [anon_sym_EQ_LT] = ACTIONS(276),
    [anon_sym_LT] = ACTIONS(278),
    [anon_sym_GT_EQ] = ACTIONS(276),
    [anon_sym_GT] = ACTIONS(278),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(276),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(276),
    [anon_sym_andalso] = ACTIONS(278),
    [anon_sym_orelse] = ACTIONS(278),
    [anon_sym_EQ] = ACTIONS(278),
    [anon_sym_BANG] = ACTIONS(276),
    [anon_sym_QMARK_EQ] = ACTIONS(276),
    [anon_sym_DOT_DOT] = ACTIONS(278),
    [anon_sym_PIPE_PIPE] = ACTIONS(276),
    [anon_sym_COLON_COLON] = ACTIONS(276),
    [anon_sym_PIPE] = ACTIONS(278),
    [anon_sym_LT_DASH] = ACTIONS(276),
    [anon_sym_LT_EQ] = ACTIONS(276),
    [anon_sym_EQ_GT] = ACTIONS(276),
    [anon_sym_COLON_EQ] = ACTIONS(276),
    [anon_sym_fun] = ACTIONS(278),
    [anon_sym_end] = ACTIONS(278),
    [anon_sym_begin] = ACTIONS(278),
    [anon_sym_case] = ACTIONS(278),
    [anon_sym_of] = ACTIONS(278),
    [anon_sym_receive] = ACTIONS(278),
    [anon_sym_after] = ACTIONS(278),
    [anon_sym_try] = ACTIONS(278),
    [anon_sym_maybe] = ACTIONS(278),
    [anon_sym_DOLLAR] = ACTIONS(276),
    [aux_sym_integer_token1] = ACTIONS(278),
    [aux_sym_integer_token2] = ACTIONS(276),
    [sym_float] = ACTIONS(276),
    [sym__atom] = ACTIONS(278),
    [anon_sym_SQUOTE] = ACTIONS(276),
    [sym_variable] = ACTIONS(276),
    [anon_sym_QMARK] = ACTIONS(278),
    [anon_sym_DQUOTE] = ACTIONS(276),
    [sym_tripledot] = ACTIONS(276),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [73] = {
    [sym_comment] = STATE(73),
    [anon_sym_COMMA] = ACTIONS(256),
    [anon_sym_SEMI] = ACTIONS(256),
    [anon_sym_DASH] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(256),
    [anon_sym_COLON] = ACTIONS(258),
    [anon_sym_when] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_LT_LT] = ACTIONS(256),
    [anon_sym_LBRACE] = ACTIONS(256),
    [anon_sym_LBRACK] = ACTIONS(256),
    [anon_sym_POUND] = ACTIONS(256),
    [anon_sym_PLUS] = ACTIONS(258),
    [anon_sym_not] = ACTIONS(258),
    [anon_sym_bnot] = ACTIONS(258),
    [anon_sym_catch] = ACTIONS(258),
    [anon_sym_SLASH] = ACTIONS(258),
    [anon_sym_STAR] = ACTIONS(256),
    [anon_sym_div] = ACTIONS(258),
    [anon_sym_rem] = ACTIONS(258),
    [anon_sym_band] = ACTIONS(258),
    [anon_sym_and] = ACTIONS(258),
    [anon_sym_bor] = ACTIONS(258),
    [anon_sym_bxor] = ACTIONS(258),
    [anon_sym_bsl] = ACTIONS(258),
    [anon_sym_bsr] = ACTIONS(258),
    [anon_sym_or] = ACTIONS(258),
    [anon_sym_xor] = ACTIONS(258),
    [anon_sym_PLUS_PLUS] = ACTIONS(256),
    [anon_sym_DASH_DASH] = ACTIONS(256),
    [anon_sym_EQ_EQ] = ACTIONS(256),
    [anon_sym_SLASH_EQ] = ACTIONS(256),
    [anon_sym_EQ_LT] = ACTIONS(256),
    [anon_sym_LT] = ACTIONS(258),
    [anon_sym_GT_EQ] = ACTIONS(256),
    [anon_sym_GT] = ACTIONS(258),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(256),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(256),
    [anon_sym_andalso] = ACTIONS(258),
    [anon_sym_orelse] = ACTIONS(258),
    [anon_sym_EQ] = ACTIONS(258),
    [anon_sym_BANG] = ACTIONS(256),
    [anon_sym_QMARK_EQ] = ACTIONS(256),
    [anon_sym_DOT_DOT] = ACTIONS(258),
    [anon_sym_PIPE_PIPE] = ACTIONS(256),
    [anon_sym_COLON_COLON] = ACTIONS(256),
    [anon_sym_PIPE] = ACTIONS(258),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_LT_EQ] = ACTIONS(256),
    [anon_sym_EQ_GT] = ACTIONS(256),
    [anon_sym_COLON_EQ] = ACTIONS(256),
    [anon_sym_fun] = ACTIONS(258),
    [anon_sym_end] = ACTIONS(258),
    [anon_sym_begin] = ACTIONS(258),
    [anon_sym_case] = ACTIONS(258),
    [anon_sym_receive] = ACTIONS(258),
    [anon_sym_after] = ACTIONS(258),
    [anon_sym_try] = ACTIONS(258),
    [anon_sym_maybe] = ACTIONS(258),
    [anon_sym_DOLLAR] = ACTIONS(256),
    [aux_sym_integer_token1] = ACTIONS(258),
    [aux_sym_integer_token2] = ACTIONS(256),
    [sym_float] = ACTIONS(256),
    [sym__atom] = ACTIONS(258),
    [anon_sym_SQUOTE] = ACTIONS(256),
    [sym_variable] = ACTIONS(256),
    [anon_sym_QMARK] = ACTIONS(258),
    [anon_sym_DQUOTE] = ACTIONS(256),
    [sym_tripledot] = ACTIONS(256),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [74] = {
    [sym_comment] = STATE(74),
    [anon_sym_COMMA] = ACTIONS(264),
    [anon_sym_DASH] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_when] = ACTIONS(266),
    [anon_sym_if] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(264),
    [anon_sym_LBRACK] = ACTIONS(264),
    [anon_sym_POUND] = ACTIONS(264),
    [anon_sym_PLUS] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(266),
    [anon_sym_bnot] = ACTIONS(266),
    [anon_sym_catch] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(266),
    [anon_sym_STAR] = ACTIONS(264),
    [anon_sym_div] = ACTIONS(266),
    [anon_sym_rem] = ACTIONS(266),
    [anon_sym_band] = ACTIONS(266),
    [anon_sym_and] = ACTIONS(266),
    [anon_sym_bor] = ACTIONS(266),
    [anon_sym_bxor] = ACTIONS(266),
    [anon_sym_bsl] = ACTIONS(266),
    [anon_sym_bsr] = ACTIONS(266),
    [anon_sym_or] = ACTIONS(266),
    [anon_sym_xor] = ACTIONS(266),
    [anon_sym_PLUS_PLUS] = ACTIONS(264),
    [anon_sym_DASH_DASH] = ACTIONS(264),
    [anon_sym_EQ_EQ] = ACTIONS(264),
    [anon_sym_SLASH_EQ] = ACTIONS(264),
    [anon_sym_EQ_LT] = ACTIONS(264),
    [anon_sym_LT] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(264),
    [anon_sym_GT] = ACTIONS(266),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(264),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(264),
    [anon_sym_andalso] = ACTIONS(266),
    [anon_sym_orelse] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(266),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_QMARK_EQ] = ACTIONS(264),
    [anon_sym_DOT_DOT] = ACTIONS(266),
    [anon_sym_PIPE_PIPE] = ACTIONS(264),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_LT_DASH] = ACTIONS(264),
    [anon_sym_LT_EQ] = ACTIONS(264),
    [anon_sym_EQ_GT] = ACTIONS(264),
    [anon_sym_COLON_EQ] = ACTIONS(264),
    [anon_sym_fun] = ACTIONS(266),
    [anon_sym_end] = ACTIONS(266),
    [anon_sym_begin] = ACTIONS(266),
    [anon_sym_case] = ACTIONS(266),
    [anon_sym_of] = ACTIONS(266),
    [anon_sym_receive] = ACTIONS(266),
    [anon_sym_after] = ACTIONS(266),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_maybe] = ACTIONS(266),
    [anon_sym_DOLLAR] = ACTIONS(264),
    [aux_sym_integer_token1] = ACTIONS(266),
    [aux_sym_integer_token2] = ACTIONS(264),
    [sym_float] = ACTIONS(264),
    [sym__atom] = ACTIONS(266),
    [anon_sym_SQUOTE] = ACTIONS(264),
    [sym_variable] = ACTIONS(264),
    [anon_sym_QMARK] = ACTIONS(266),
    [anon_sym_DQUOTE] = ACTIONS(264),
    [sym_tripledot] = ACTIONS(264),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [75] = {
    [sym_comment] = STATE(75),
    [anon_sym_COMMA] = ACTIONS(252),
    [anon_sym_SEMI] = ACTIONS(252),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_end] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_after] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym__atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [76] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_stab_clause] = STATE(1370),
    [sym__named_stab_clause] = STATE(1349),
    [sym__anonymous_stab_clause] = STATE(1347),
    [sym_arguments] = STATE(1500),
    [sym__items] = STATE(1616),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(1069),
    [sym_atom] = STATE(909),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(85),
    [sym__macro_call] = STATE(95),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(76),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_RPAREN] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(389),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [77] = {
    [sym_arguments] = STATE(111),
    [sym_comment] = STATE(77),
    [anon_sym_COMMA] = ACTIONS(238),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(395),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_when] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(238),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_bnot] = ACTIONS(240),
    [anon_sym_catch] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(238),
    [anon_sym_div] = ACTIONS(240),
    [anon_sym_rem] = ACTIONS(240),
    [anon_sym_band] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_bor] = ACTIONS(240),
    [anon_sym_bxor] = ACTIONS(240),
    [anon_sym_bsl] = ACTIONS(240),
    [anon_sym_bsr] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_xor] = ACTIONS(240),
    [anon_sym_PLUS_PLUS] = ACTIONS(238),
    [anon_sym_DASH_DASH] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_EQ_LT] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(238),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(238),
    [anon_sym_andalso] = ACTIONS(240),
    [anon_sym_orelse] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_QMARK_EQ] = ACTIONS(238),
    [anon_sym_DOT_DOT] = ACTIONS(240),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_LT_DASH] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_EQ_GT] = ACTIONS(238),
    [anon_sym_COLON_EQ] = ACTIONS(238),
    [anon_sym_fun] = ACTIONS(240),
    [anon_sym_end] = ACTIONS(240),
    [anon_sym_begin] = ACTIONS(240),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_receive] = ACTIONS(240),
    [anon_sym_try] = ACTIONS(240),
    [anon_sym_maybe] = ACTIONS(240),
    [anon_sym_else] = ACTIONS(240),
    [anon_sym_DOLLAR] = ACTIONS(238),
    [aux_sym_integer_token1] = ACTIONS(240),
    [aux_sym_integer_token2] = ACTIONS(238),
    [sym_float] = ACTIONS(238),
    [sym__atom] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [sym_variable] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(240),
    [anon_sym_DQUOTE] = ACTIONS(238),
    [sym_tripledot] = ACTIONS(238),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [78] = {
    [sym_comment] = STATE(78),
    [ts_builtin_sym_end] = ACTIONS(248),
    [anon_sym_COMMA] = ACTIONS(250),
    [anon_sym_LF] = ACTIONS(248),
    [anon_sym_DOT] = ACTIONS(250),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(250),
    [anon_sym_LBRACE] = ACTIONS(250),
    [anon_sym_LBRACK] = ACTIONS(250),
    [anon_sym_POUND] = ACTIONS(250),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(250),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(250),
    [anon_sym_DASH_DASH] = ACTIONS(250),
    [anon_sym_EQ_EQ] = ACTIONS(250),
    [anon_sym_SLASH_EQ] = ACTIONS(250),
    [anon_sym_EQ_LT] = ACTIONS(250),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(250),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(250),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(250),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(250),
    [anon_sym_QMARK_EQ] = ACTIONS(250),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(250),
    [anon_sym_COLON_COLON] = ACTIONS(250),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(250),
    [anon_sym_LT_EQ] = ACTIONS(250),
    [anon_sym_EQ_GT] = ACTIONS(250),
    [anon_sym_COLON_EQ] = ACTIONS(250),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(250),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(250),
    [sym_float] = ACTIONS(250),
    [sym__atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(250),
    [sym_variable] = ACTIONS(250),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(250),
    [sym_tripledot] = ACTIONS(250),
    [aux_sym_comment_token1] = ACTIONS(139),
  },
  [79] = {
    [sym_arguments] = STATE(90),
    [sym_comment] = STATE(79),
    [anon_sym_COMMA] = ACTIONS(238),
    [anon_sym_SEMI] = ACTIONS(238),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(397),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_when] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(238),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_bnot] = ACTIONS(240),
    [anon_sym_catch] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(238),
    [anon_sym_div] = ACTIONS(240),
    [anon_sym_rem] = ACTIONS(240),
    [anon_sym_band] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_bor] = ACTIONS(240),
    [anon_sym_bxor] = ACTIONS(240),
    [anon_sym_bsl] = ACTIONS(240),
    [anon_sym_bsr] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_xor] = ACTIONS(240),
    [anon_sym_PLUS_PLUS] = ACTIONS(238),
    [anon_sym_DASH_DASH] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_EQ_LT] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(238),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(238),
    [anon_sym_andalso] = ACTIONS(240),
    [anon_sym_orelse] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_QMARK_EQ] = ACTIONS(238),
    [anon_sym_DOT_DOT] = ACTIONS(240),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_LT_DASH] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_EQ_GT] = ACTIONS(238),
    [anon_sym_COLON_EQ] = ACTIONS(238),
    [anon_sym_fun] = ACTIONS(240),
    [anon_sym_end] = ACTIONS(240),
    [anon_sym_begin] = ACTIONS(240),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_receive] = ACTIONS(240),
    [anon_sym_try] = ACTIONS(240),
    [anon_sym_maybe] = ACTIONS(240),
    [anon_sym_DOLLAR] = ACTIONS(238),
    [aux_sym_integer_token1] = ACTIONS(240),
    [aux_sym_integer_token2] = ACTIONS(238),
    [sym_float] = ACTIONS(238),
    [sym__atom] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [sym_variable] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(240),
    [anon_sym_DQUOTE] = ACTIONS(238),
    [sym_tripledot] = ACTIONS(238),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [80] = {
    [sym_comment] = STATE(80),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_RPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(399),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_DASH_GT] = ACTIONS(402),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym__atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [81] = {
    [sym_comment] = STATE(81),
    [anon_sym_COMMA] = ACTIONS(268),
    [anon_sym_DASH] = ACTIONS(270),
    [anon_sym_LPAREN] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_when] = ACTIONS(270),
    [anon_sym_if] = ACTIONS(270),
    [anon_sym_LT_LT] = ACTIONS(268),
    [anon_sym_LBRACE] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(268),
    [anon_sym_POUND] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(270),
    [anon_sym_not] = ACTIONS(270),
    [anon_sym_bnot] = ACTIONS(270),
    [anon_sym_catch] = ACTIONS(270),
    [anon_sym_SLASH] = ACTIONS(270),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_div] = ACTIONS(270),
    [anon_sym_rem] = ACTIONS(270),
    [anon_sym_band] = ACTIONS(270),
    [anon_sym_and] = ACTIONS(270),
    [anon_sym_bor] = ACTIONS(270),
    [anon_sym_bxor] = ACTIONS(270),
    [anon_sym_bsl] = ACTIONS(270),
    [anon_sym_bsr] = ACTIONS(270),
    [anon_sym_or] = ACTIONS(270),
    [anon_sym_xor] = ACTIONS(270),
    [anon_sym_PLUS_PLUS] = ACTIONS(268),
    [anon_sym_DASH_DASH] = ACTIONS(268),
    [anon_sym_EQ_EQ] = ACTIONS(268),
    [anon_sym_SLASH_EQ] = ACTIONS(268),
    [anon_sym_EQ_LT] = ACTIONS(268),
    [anon_sym_LT] = ACTIONS(270),
    [anon_sym_GT_EQ] = ACTIONS(268),
    [anon_sym_GT] = ACTIONS(270),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(268),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(268),
    [anon_sym_andalso] = ACTIONS(270),
    [anon_sym_orelse] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(270),
    [anon_sym_BANG] = ACTIONS(268),
    [anon_sym_QMARK_EQ] = ACTIONS(268),
    [anon_sym_DOT_DOT] = ACTIONS(270),
    [anon_sym_PIPE_PIPE] = ACTIONS(268),
    [anon_sym_COLON_COLON] = ACTIONS(268),
    [anon_sym_PIPE] = ACTIONS(270),
    [anon_sym_LT_DASH] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(268),
    [anon_sym_EQ_GT] = ACTIONS(268),
    [anon_sym_COLON_EQ] = ACTIONS(268),
    [anon_sym_fun] = ACTIONS(270),
    [anon_sym_end] = ACTIONS(270),
    [anon_sym_begin] = ACTIONS(270),
    [anon_sym_case] = ACTIONS(270),
    [anon_sym_of] = ACTIONS(270),
    [anon_sym_receive] = ACTIONS(270),
    [anon_sym_after] = ACTIONS(270),
    [anon_sym_try] = ACTIONS(270),
    [anon_sym_maybe] = ACTIONS(270),
    [anon_sym_DOLLAR] = ACTIONS(268),
    [aux_sym_integer_token1] = ACTIONS(270),
    [aux_sym_integer_token2] = ACTIONS(268),
    [sym_float] = ACTIONS(268),
    [sym__atom] = ACTIONS(270),
    [anon_sym_SQUOTE] = ACTIONS(268),
    [sym_variable] = ACTIONS(268),
    [anon_sym_QMARK] = ACTIONS(270),
    [anon_sym_DQUOTE] = ACTIONS(268),
    [sym_tripledot] = ACTIONS(268),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [82] = {
    [sym_arguments] = STATE(1520),
    [sym_comment] = STATE(82),
    [anon_sym_COMMA] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(264),
    [anon_sym_DASH] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_RPAREN] = ACTIONS(264),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_when] = ACTIONS(266),
    [anon_sym_if] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(264),
    [anon_sym_LBRACK] = ACTIONS(264),
    [anon_sym_POUND] = ACTIONS(264),
    [anon_sym_PLUS] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(266),
    [anon_sym_bnot] = ACTIONS(266),
    [anon_sym_catch] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(266),
    [anon_sym_STAR] = ACTIONS(264),
    [anon_sym_div] = ACTIONS(266),
    [anon_sym_rem] = ACTIONS(266),
    [anon_sym_band] = ACTIONS(266),
    [anon_sym_and] = ACTIONS(266),
    [anon_sym_bor] = ACTIONS(266),
    [anon_sym_bxor] = ACTIONS(266),
    [anon_sym_bsl] = ACTIONS(266),
    [anon_sym_bsr] = ACTIONS(266),
    [anon_sym_or] = ACTIONS(266),
    [anon_sym_xor] = ACTIONS(266),
    [anon_sym_PLUS_PLUS] = ACTIONS(264),
    [anon_sym_DASH_DASH] = ACTIONS(264),
    [anon_sym_EQ_EQ] = ACTIONS(264),
    [anon_sym_SLASH_EQ] = ACTIONS(264),
    [anon_sym_EQ_LT] = ACTIONS(264),
    [anon_sym_LT] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(264),
    [anon_sym_GT] = ACTIONS(266),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(264),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(264),
    [anon_sym_andalso] = ACTIONS(266),
    [anon_sym_orelse] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(266),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_QMARK_EQ] = ACTIONS(264),
    [anon_sym_DOT_DOT] = ACTIONS(266),
    [anon_sym_PIPE_PIPE] = ACTIONS(264),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_LT_DASH] = ACTIONS(264),
    [anon_sym_LT_EQ] = ACTIONS(264),
    [anon_sym_EQ_GT] = ACTIONS(264),
    [anon_sym_COLON_EQ] = ACTIONS(264),
    [anon_sym_fun] = ACTIONS(266),
    [anon_sym_begin] = ACTIONS(266),
    [anon_sym_case] = ACTIONS(266),
    [anon_sym_receive] = ACTIONS(266),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_maybe] = ACTIONS(266),
    [anon_sym_DOLLAR] = ACTIONS(264),
    [aux_sym_integer_token1] = ACTIONS(266),
    [aux_sym_integer_token2] = ACTIONS(264),
    [sym_float] = ACTIONS(264),
    [sym__atom] = ACTIONS(266),
    [anon_sym_SQUOTE] = ACTIONS(264),
    [sym_variable] = ACTIONS(264),
    [anon_sym_QMARK] = ACTIONS(266),
    [anon_sym_DQUOTE] = ACTIONS(264),
    [sym_tripledot] = ACTIONS(264),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [83] = {
    [sym_comment] = STATE(83),
    [anon_sym_COMMA] = ACTIONS(260),
    [anon_sym_SEMI] = ACTIONS(260),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_LPAREN] = ACTIONS(260),
    [anon_sym_COLON] = ACTIONS(262),
    [anon_sym_when] = ACTIONS(262),
    [anon_sym_if] = ACTIONS(262),
    [anon_sym_LT_LT] = ACTIONS(260),
    [anon_sym_LBRACE] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(260),
    [anon_sym_POUND] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_not] = ACTIONS(262),
    [anon_sym_bnot] = ACTIONS(262),
    [anon_sym_catch] = ACTIONS(262),
    [anon_sym_SLASH] = ACTIONS(262),
    [anon_sym_STAR] = ACTIONS(260),
    [anon_sym_div] = ACTIONS(262),
    [anon_sym_rem] = ACTIONS(262),
    [anon_sym_band] = ACTIONS(262),
    [anon_sym_and] = ACTIONS(262),
    [anon_sym_bor] = ACTIONS(262),
    [anon_sym_bxor] = ACTIONS(262),
    [anon_sym_bsl] = ACTIONS(262),
    [anon_sym_bsr] = ACTIONS(262),
    [anon_sym_or] = ACTIONS(262),
    [anon_sym_xor] = ACTIONS(262),
    [anon_sym_PLUS_PLUS] = ACTIONS(260),
    [anon_sym_DASH_DASH] = ACTIONS(260),
    [anon_sym_EQ_EQ] = ACTIONS(260),
    [anon_sym_SLASH_EQ] = ACTIONS(260),
    [anon_sym_EQ_LT] = ACTIONS(260),
    [anon_sym_LT] = ACTIONS(262),
    [anon_sym_GT_EQ] = ACTIONS(260),
    [anon_sym_GT] = ACTIONS(262),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(260),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(260),
    [anon_sym_andalso] = ACTIONS(262),
    [anon_sym_orelse] = ACTIONS(262),
    [anon_sym_EQ] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(260),
    [anon_sym_QMARK_EQ] = ACTIONS(260),
    [anon_sym_DOT_DOT] = ACTIONS(262),
    [anon_sym_PIPE_PIPE] = ACTIONS(260),
    [anon_sym_COLON_COLON] = ACTIONS(260),
    [anon_sym_PIPE] = ACTIONS(262),
    [anon_sym_LT_DASH] = ACTIONS(260),
    [anon_sym_LT_EQ] = ACTIONS(260),
    [anon_sym_EQ_GT] = ACTIONS(260),
    [anon_sym_COLON_EQ] = ACTIONS(260),
    [anon_sym_fun] = ACTIONS(262),
    [anon_sym_end] = ACTIONS(262),
    [anon_sym_begin] = ACTIONS(262),
    [anon_sym_case] = ACTIONS(262),
    [anon_sym_receive] = ACTIONS(262),
    [anon_sym_after] = ACTIONS(262),
    [anon_sym_try] = ACTIONS(262),
    [anon_sym_maybe] = ACTIONS(262),
    [anon_sym_DOLLAR] = ACTIONS(260),
    [aux_sym_integer_token1] = ACTIONS(262),
    [aux_sym_integer_token2] = ACTIONS(260),
    [sym_float] = ACTIONS(260),
    [sym__atom] = ACTIONS(262),
    [anon_sym_SQUOTE] = ACTIONS(260),
    [sym_variable] = ACTIONS(260),
    [anon_sym_QMARK] = ACTIONS(262),
    [anon_sym_DQUOTE] = ACTIONS(260),
    [sym_tripledot] = ACTIONS(260),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [84] = {
    [sym_comment] = STATE(84),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_SEMI] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_after] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym__atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [85] = {
    [sym_arguments] = STATE(96),
    [sym_comment] = STATE(85),
    [anon_sym_COMMA] = ACTIONS(238),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(242),
    [anon_sym_RPAREN] = ACTIONS(238),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_when] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(238),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_bnot] = ACTIONS(240),
    [anon_sym_catch] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(238),
    [anon_sym_div] = ACTIONS(240),
    [anon_sym_rem] = ACTIONS(240),
    [anon_sym_band] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_bor] = ACTIONS(240),
    [anon_sym_bxor] = ACTIONS(240),
    [anon_sym_bsl] = ACTIONS(240),
    [anon_sym_bsr] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_xor] = ACTIONS(240),
    [anon_sym_PLUS_PLUS] = ACTIONS(238),
    [anon_sym_DASH_DASH] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_EQ_LT] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(238),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(238),
    [anon_sym_andalso] = ACTIONS(240),
    [anon_sym_orelse] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_QMARK_EQ] = ACTIONS(238),
    [anon_sym_DOT_DOT] = ACTIONS(240),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_LT_DASH] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_EQ_GT] = ACTIONS(238),
    [anon_sym_COLON_EQ] = ACTIONS(238),
    [anon_sym_fun] = ACTIONS(240),
    [anon_sym_begin] = ACTIONS(240),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_receive] = ACTIONS(240),
    [anon_sym_try] = ACTIONS(240),
    [anon_sym_maybe] = ACTIONS(240),
    [anon_sym_DOLLAR] = ACTIONS(238),
    [aux_sym_integer_token1] = ACTIONS(240),
    [aux_sym_integer_token2] = ACTIONS(238),
    [sym_float] = ACTIONS(238),
    [sym__atom] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [sym_variable] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(240),
    [anon_sym_DQUOTE] = ACTIONS(238),
    [sym_tripledot] = ACTIONS(238),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [86] = {
    [sym_comment] = STATE(86),
    [anon_sym_COMMA] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_when] = ACTIONS(282),
    [anon_sym_if] = ACTIONS(282),
    [anon_sym_LT_LT] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_LBRACK] = ACTIONS(280),
    [anon_sym_POUND] = ACTIONS(280),
    [anon_sym_PLUS] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_bnot] = ACTIONS(282),
    [anon_sym_catch] = ACTIONS(282),
    [anon_sym_SLASH] = ACTIONS(282),
    [anon_sym_STAR] = ACTIONS(280),
    [anon_sym_div] = ACTIONS(282),
    [anon_sym_rem] = ACTIONS(282),
    [anon_sym_band] = ACTIONS(282),
    [anon_sym_and] = ACTIONS(282),
    [anon_sym_bor] = ACTIONS(282),
    [anon_sym_bxor] = ACTIONS(282),
    [anon_sym_bsl] = ACTIONS(282),
    [anon_sym_bsr] = ACTIONS(282),
    [anon_sym_or] = ACTIONS(282),
    [anon_sym_xor] = ACTIONS(282),
    [anon_sym_PLUS_PLUS] = ACTIONS(280),
    [anon_sym_DASH_DASH] = ACTIONS(280),
    [anon_sym_EQ_EQ] = ACTIONS(280),
    [anon_sym_SLASH_EQ] = ACTIONS(280),
    [anon_sym_EQ_LT] = ACTIONS(280),
    [anon_sym_LT] = ACTIONS(282),
    [anon_sym_GT_EQ] = ACTIONS(280),
    [anon_sym_GT] = ACTIONS(282),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(280),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(280),
    [anon_sym_andalso] = ACTIONS(282),
    [anon_sym_orelse] = ACTIONS(282),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_BANG] = ACTIONS(280),
    [anon_sym_QMARK_EQ] = ACTIONS(280),
    [anon_sym_DOT_DOT] = ACTIONS(282),
    [anon_sym_PIPE_PIPE] = ACTIONS(280),
    [anon_sym_COLON_COLON] = ACTIONS(280),
    [anon_sym_PIPE] = ACTIONS(282),
    [anon_sym_LT_DASH] = ACTIONS(280),
    [anon_sym_LT_EQ] = ACTIONS(280),
    [anon_sym_EQ_GT] = ACTIONS(280),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_fun] = ACTIONS(282),
    [anon_sym_end] = ACTIONS(282),
    [anon_sym_begin] = ACTIONS(282),
    [anon_sym_case] = ACTIONS(282),
    [anon_sym_receive] = ACTIONS(282),
    [anon_sym_try] = ACTIONS(282),
    [anon_sym_maybe] = ACTIONS(282),
    [anon_sym_else] = ACTIONS(282),
    [anon_sym_DOLLAR] = ACTIONS(280),
    [aux_sym_integer_token1] = ACTIONS(282),
    [aux_sym_integer_token2] = ACTIONS(280),
    [sym_float] = ACTIONS(280),
    [sym__atom] = ACTIONS(282),
    [anon_sym_SQUOTE] = ACTIONS(280),
    [sym_variable] = ACTIONS(280),
    [anon_sym_QMARK] = ACTIONS(282),
    [anon_sym_DQUOTE] = ACTIONS(280),
    [sym_tripledot] = ACTIONS(280),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [87] = {
    [sym_function] = STATE(1529),
    [sym__semicolon_separated_expressions] = STATE(1548),
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(937),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__named_stab_clause] = STATE(1423),
    [sym__body] = STATE(1509),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(818),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(8),
    [sym__macro_constant] = STATE(66),
    [sym__macro_call] = STATE(82),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(87),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(408),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [88] = {
    [sym_comment] = STATE(88),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_SEMI] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym__atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [89] = {
    [sym_comment] = STATE(89),
    [anon_sym_COMMA] = ACTIONS(268),
    [anon_sym_SEMI] = ACTIONS(268),
    [anon_sym_DASH] = ACTIONS(270),
    [anon_sym_LPAREN] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_when] = ACTIONS(270),
    [anon_sym_if] = ACTIONS(270),
    [anon_sym_LT_LT] = ACTIONS(268),
    [anon_sym_LBRACE] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(268),
    [anon_sym_POUND] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(270),
    [anon_sym_not] = ACTIONS(270),
    [anon_sym_bnot] = ACTIONS(270),
    [anon_sym_catch] = ACTIONS(270),
    [anon_sym_SLASH] = ACTIONS(270),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_div] = ACTIONS(270),
    [anon_sym_rem] = ACTIONS(270),
    [anon_sym_band] = ACTIONS(270),
    [anon_sym_and] = ACTIONS(270),
    [anon_sym_bor] = ACTIONS(270),
    [anon_sym_bxor] = ACTIONS(270),
    [anon_sym_bsl] = ACTIONS(270),
    [anon_sym_bsr] = ACTIONS(270),
    [anon_sym_or] = ACTIONS(270),
    [anon_sym_xor] = ACTIONS(270),
    [anon_sym_PLUS_PLUS] = ACTIONS(268),
    [anon_sym_DASH_DASH] = ACTIONS(268),
    [anon_sym_EQ_EQ] = ACTIONS(268),
    [anon_sym_SLASH_EQ] = ACTIONS(268),
    [anon_sym_EQ_LT] = ACTIONS(268),
    [anon_sym_LT] = ACTIONS(270),
    [anon_sym_GT_EQ] = ACTIONS(268),
    [anon_sym_GT] = ACTIONS(270),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(268),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(268),
    [anon_sym_andalso] = ACTIONS(270),
    [anon_sym_orelse] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(270),
    [anon_sym_BANG] = ACTIONS(268),
    [anon_sym_QMARK_EQ] = ACTIONS(268),
    [anon_sym_DOT_DOT] = ACTIONS(270),
    [anon_sym_PIPE_PIPE] = ACTIONS(268),
    [anon_sym_COLON_COLON] = ACTIONS(268),
    [anon_sym_PIPE] = ACTIONS(270),
    [anon_sym_LT_DASH] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(268),
    [anon_sym_EQ_GT] = ACTIONS(268),
    [anon_sym_COLON_EQ] = ACTIONS(268),
    [anon_sym_fun] = ACTIONS(270),
    [anon_sym_end] = ACTIONS(270),
    [anon_sym_begin] = ACTIONS(270),
    [anon_sym_case] = ACTIONS(270),
    [anon_sym_receive] = ACTIONS(270),
    [anon_sym_try] = ACTIONS(270),
    [anon_sym_maybe] = ACTIONS(270),
    [anon_sym_DOLLAR] = ACTIONS(268),
    [aux_sym_integer_token1] = ACTIONS(270),
    [aux_sym_integer_token2] = ACTIONS(268),
    [sym_float] = ACTIONS(268),
    [sym__atom] = ACTIONS(270),
    [anon_sym_SQUOTE] = ACTIONS(268),
    [sym_variable] = ACTIONS(268),
    [anon_sym_QMARK] = ACTIONS(270),
    [anon_sym_DQUOTE] = ACTIONS(268),
    [sym_tripledot] = ACTIONS(268),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [90] = {
    [sym_comment] = STATE(90),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym__atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [91] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1331),
    [sym__items] = STATE(1525),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_after] = STATE(1603),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(91),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_end] = ACTIONS(412),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_after] = ACTIONS(414),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [92] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(943),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1583),
    [sym_arguments] = STATE(1619),
    [sym__items] = STATE(1375),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym__if_clause] = STATE(1479),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(11),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(92),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DOT] = ACTIONS(416),
    [anon_sym_DASH] = ACTIONS(194),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(194),
    [anon_sym_not] = ACTIONS(194),
    [anon_sym_bnot] = ACTIONS(194),
    [anon_sym_catch] = ACTIONS(196),
    [anon_sym_fun] = ACTIONS(420),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [93] = {
    [sym_comment] = STATE(93),
    [anon_sym_COMMA] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(264),
    [anon_sym_DASH] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_when] = ACTIONS(266),
    [anon_sym_if] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(264),
    [anon_sym_LBRACK] = ACTIONS(264),
    [anon_sym_POUND] = ACTIONS(264),
    [anon_sym_PLUS] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(266),
    [anon_sym_bnot] = ACTIONS(266),
    [anon_sym_catch] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(266),
    [anon_sym_STAR] = ACTIONS(264),
    [anon_sym_div] = ACTIONS(266),
    [anon_sym_rem] = ACTIONS(266),
    [anon_sym_band] = ACTIONS(266),
    [anon_sym_and] = ACTIONS(266),
    [anon_sym_bor] = ACTIONS(266),
    [anon_sym_bxor] = ACTIONS(266),
    [anon_sym_bsl] = ACTIONS(266),
    [anon_sym_bsr] = ACTIONS(266),
    [anon_sym_or] = ACTIONS(266),
    [anon_sym_xor] = ACTIONS(266),
    [anon_sym_PLUS_PLUS] = ACTIONS(264),
    [anon_sym_DASH_DASH] = ACTIONS(264),
    [anon_sym_EQ_EQ] = ACTIONS(264),
    [anon_sym_SLASH_EQ] = ACTIONS(264),
    [anon_sym_EQ_LT] = ACTIONS(264),
    [anon_sym_LT] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(264),
    [anon_sym_GT] = ACTIONS(266),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(264),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(264),
    [anon_sym_andalso] = ACTIONS(266),
    [anon_sym_orelse] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(266),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_QMARK_EQ] = ACTIONS(264),
    [anon_sym_DOT_DOT] = ACTIONS(266),
    [anon_sym_PIPE_PIPE] = ACTIONS(264),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_LT_DASH] = ACTIONS(264),
    [anon_sym_LT_EQ] = ACTIONS(264),
    [anon_sym_EQ_GT] = ACTIONS(264),
    [anon_sym_COLON_EQ] = ACTIONS(264),
    [anon_sym_fun] = ACTIONS(266),
    [anon_sym_end] = ACTIONS(266),
    [anon_sym_begin] = ACTIONS(266),
    [anon_sym_case] = ACTIONS(266),
    [anon_sym_receive] = ACTIONS(266),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_maybe] = ACTIONS(266),
    [anon_sym_DOLLAR] = ACTIONS(264),
    [aux_sym_integer_token1] = ACTIONS(266),
    [aux_sym_integer_token2] = ACTIONS(264),
    [sym_float] = ACTIONS(264),
    [sym__atom] = ACTIONS(266),
    [anon_sym_SQUOTE] = ACTIONS(264),
    [sym_variable] = ACTIONS(264),
    [anon_sym_QMARK] = ACTIONS(266),
    [anon_sym_DQUOTE] = ACTIONS(264),
    [sym_tripledot] = ACTIONS(264),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [94] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1345),
    [sym__items] = STATE(1525),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_after] = STATE(1540),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(94),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_end] = ACTIONS(422),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_after] = ACTIONS(414),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [95] = {
    [sym_arguments] = STATE(1524),
    [sym_comment] = STATE(95),
    [anon_sym_COMMA] = ACTIONS(264),
    [anon_sym_DASH] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(404),
    [anon_sym_RPAREN] = ACTIONS(264),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_when] = ACTIONS(266),
    [anon_sym_if] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(264),
    [anon_sym_LBRACK] = ACTIONS(264),
    [anon_sym_POUND] = ACTIONS(264),
    [anon_sym_PLUS] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(266),
    [anon_sym_bnot] = ACTIONS(266),
    [anon_sym_catch] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(266),
    [anon_sym_STAR] = ACTIONS(264),
    [anon_sym_div] = ACTIONS(266),
    [anon_sym_rem] = ACTIONS(266),
    [anon_sym_band] = ACTIONS(266),
    [anon_sym_and] = ACTIONS(266),
    [anon_sym_bor] = ACTIONS(266),
    [anon_sym_bxor] = ACTIONS(266),
    [anon_sym_bsl] = ACTIONS(266),
    [anon_sym_bsr] = ACTIONS(266),
    [anon_sym_or] = ACTIONS(266),
    [anon_sym_xor] = ACTIONS(266),
    [anon_sym_PLUS_PLUS] = ACTIONS(264),
    [anon_sym_DASH_DASH] = ACTIONS(264),
    [anon_sym_EQ_EQ] = ACTIONS(264),
    [anon_sym_SLASH_EQ] = ACTIONS(264),
    [anon_sym_EQ_LT] = ACTIONS(264),
    [anon_sym_LT] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(264),
    [anon_sym_GT] = ACTIONS(266),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(264),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(264),
    [anon_sym_andalso] = ACTIONS(266),
    [anon_sym_orelse] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(266),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_QMARK_EQ] = ACTIONS(264),
    [anon_sym_DOT_DOT] = ACTIONS(266),
    [anon_sym_PIPE_PIPE] = ACTIONS(264),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_LT_DASH] = ACTIONS(264),
    [anon_sym_LT_EQ] = ACTIONS(264),
    [anon_sym_EQ_GT] = ACTIONS(264),
    [anon_sym_COLON_EQ] = ACTIONS(264),
    [anon_sym_fun] = ACTIONS(266),
    [anon_sym_begin] = ACTIONS(266),
    [anon_sym_case] = ACTIONS(266),
    [anon_sym_receive] = ACTIONS(266),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_maybe] = ACTIONS(266),
    [anon_sym_DOLLAR] = ACTIONS(264),
    [aux_sym_integer_token1] = ACTIONS(266),
    [aux_sym_integer_token2] = ACTIONS(264),
    [sym_float] = ACTIONS(264),
    [sym__atom] = ACTIONS(266),
    [anon_sym_SQUOTE] = ACTIONS(264),
    [sym_variable] = ACTIONS(264),
    [anon_sym_QMARK] = ACTIONS(266),
    [anon_sym_DQUOTE] = ACTIONS(264),
    [sym_tripledot] = ACTIONS(264),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [96] = {
    [sym_comment] = STATE(96),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_RPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(424),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_DASH_GT] = ACTIONS(427),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym__atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [97] = {
    [sym_comment] = STATE(97),
    [anon_sym_COMMA] = ACTIONS(276),
    [anon_sym_SEMI] = ACTIONS(276),
    [anon_sym_DASH] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(276),
    [anon_sym_COLON] = ACTIONS(278),
    [anon_sym_when] = ACTIONS(278),
    [anon_sym_if] = ACTIONS(278),
    [anon_sym_LT_LT] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(276),
    [anon_sym_LBRACK] = ACTIONS(276),
    [anon_sym_POUND] = ACTIONS(276),
    [anon_sym_PLUS] = ACTIONS(278),
    [anon_sym_not] = ACTIONS(278),
    [anon_sym_bnot] = ACTIONS(278),
    [anon_sym_catch] = ACTIONS(278),
    [anon_sym_SLASH] = ACTIONS(278),
    [anon_sym_STAR] = ACTIONS(276),
    [anon_sym_div] = ACTIONS(278),
    [anon_sym_rem] = ACTIONS(278),
    [anon_sym_band] = ACTIONS(278),
    [anon_sym_and] = ACTIONS(278),
    [anon_sym_bor] = ACTIONS(278),
    [anon_sym_bxor] = ACTIONS(278),
    [anon_sym_bsl] = ACTIONS(278),
    [anon_sym_bsr] = ACTIONS(278),
    [anon_sym_or] = ACTIONS(278),
    [anon_sym_xor] = ACTIONS(278),
    [anon_sym_PLUS_PLUS] = ACTIONS(276),
    [anon_sym_DASH_DASH] = ACTIONS(276),
    [anon_sym_EQ_EQ] = ACTIONS(276),
    [anon_sym_SLASH_EQ] = ACTIONS(276),
    [anon_sym_EQ_LT] = ACTIONS(276),
    [anon_sym_LT] = ACTIONS(278),
    [anon_sym_GT_EQ] = ACTIONS(276),
    [anon_sym_GT] = ACTIONS(278),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(276),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(276),
    [anon_sym_andalso] = ACTIONS(278),
    [anon_sym_orelse] = ACTIONS(278),
    [anon_sym_EQ] = ACTIONS(278),
    [anon_sym_BANG] = ACTIONS(276),
    [anon_sym_QMARK_EQ] = ACTIONS(276),
    [anon_sym_DOT_DOT] = ACTIONS(278),
    [anon_sym_PIPE_PIPE] = ACTIONS(276),
    [anon_sym_COLON_COLON] = ACTIONS(276),
    [anon_sym_PIPE] = ACTIONS(278),
    [anon_sym_LT_DASH] = ACTIONS(276),
    [anon_sym_LT_EQ] = ACTIONS(276),
    [anon_sym_EQ_GT] = ACTIONS(276),
    [anon_sym_COLON_EQ] = ACTIONS(276),
    [anon_sym_fun] = ACTIONS(278),
    [anon_sym_end] = ACTIONS(278),
    [anon_sym_begin] = ACTIONS(278),
    [anon_sym_case] = ACTIONS(278),
    [anon_sym_receive] = ACTIONS(278),
    [anon_sym_try] = ACTIONS(278),
    [anon_sym_maybe] = ACTIONS(278),
    [anon_sym_DOLLAR] = ACTIONS(276),
    [aux_sym_integer_token1] = ACTIONS(278),
    [aux_sym_integer_token2] = ACTIONS(276),
    [sym_float] = ACTIONS(276),
    [sym__atom] = ACTIONS(278),
    [anon_sym_SQUOTE] = ACTIONS(276),
    [sym_variable] = ACTIONS(276),
    [anon_sym_QMARK] = ACTIONS(278),
    [anon_sym_DQUOTE] = ACTIONS(276),
    [sym_tripledot] = ACTIONS(276),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [98] = {
    [sym_comment] = STATE(98),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_SEMI] = ACTIONS(272),
    [anon_sym_DASH] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(272),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_when] = ACTIONS(274),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(272),
    [anon_sym_POUND] = ACTIONS(272),
    [anon_sym_PLUS] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_bnot] = ACTIONS(274),
    [anon_sym_catch] = ACTIONS(274),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(272),
    [anon_sym_div] = ACTIONS(274),
    [anon_sym_rem] = ACTIONS(274),
    [anon_sym_band] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_bor] = ACTIONS(274),
    [anon_sym_bxor] = ACTIONS(274),
    [anon_sym_bsl] = ACTIONS(274),
    [anon_sym_bsr] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_xor] = ACTIONS(274),
    [anon_sym_PLUS_PLUS] = ACTIONS(272),
    [anon_sym_DASH_DASH] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_SLASH_EQ] = ACTIONS(272),
    [anon_sym_EQ_LT] = ACTIONS(272),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(272),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(272),
    [anon_sym_andalso] = ACTIONS(274),
    [anon_sym_orelse] = ACTIONS(274),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_BANG] = ACTIONS(272),
    [anon_sym_QMARK_EQ] = ACTIONS(272),
    [anon_sym_DOT_DOT] = ACTIONS(274),
    [anon_sym_PIPE_PIPE] = ACTIONS(272),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_LT_DASH] = ACTIONS(272),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(272),
    [anon_sym_fun] = ACTIONS(274),
    [anon_sym_end] = ACTIONS(274),
    [anon_sym_begin] = ACTIONS(274),
    [anon_sym_case] = ACTIONS(274),
    [anon_sym_receive] = ACTIONS(274),
    [anon_sym_try] = ACTIONS(274),
    [anon_sym_maybe] = ACTIONS(274),
    [anon_sym_DOLLAR] = ACTIONS(272),
    [aux_sym_integer_token1] = ACTIONS(274),
    [aux_sym_integer_token2] = ACTIONS(272),
    [sym_float] = ACTIONS(272),
    [sym__atom] = ACTIONS(274),
    [anon_sym_SQUOTE] = ACTIONS(272),
    [sym_variable] = ACTIONS(272),
    [anon_sym_QMARK] = ACTIONS(274),
    [anon_sym_DQUOTE] = ACTIONS(272),
    [sym_tripledot] = ACTIONS(272),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [99] = {
    [sym_comment] = STATE(99),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_DASH] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(272),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_when] = ACTIONS(274),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(272),
    [anon_sym_POUND] = ACTIONS(272),
    [anon_sym_PLUS] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_bnot] = ACTIONS(274),
    [anon_sym_catch] = ACTIONS(274),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(272),
    [anon_sym_div] = ACTIONS(274),
    [anon_sym_rem] = ACTIONS(274),
    [anon_sym_band] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_bor] = ACTIONS(274),
    [anon_sym_bxor] = ACTIONS(274),
    [anon_sym_bsl] = ACTIONS(274),
    [anon_sym_bsr] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_xor] = ACTIONS(274),
    [anon_sym_PLUS_PLUS] = ACTIONS(272),
    [anon_sym_DASH_DASH] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_SLASH_EQ] = ACTIONS(272),
    [anon_sym_EQ_LT] = ACTIONS(272),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(272),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(272),
    [anon_sym_andalso] = ACTIONS(274),
    [anon_sym_orelse] = ACTIONS(274),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_BANG] = ACTIONS(272),
    [anon_sym_QMARK_EQ] = ACTIONS(272),
    [anon_sym_DOT_DOT] = ACTIONS(274),
    [anon_sym_PIPE_PIPE] = ACTIONS(272),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_LT_DASH] = ACTIONS(272),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(272),
    [anon_sym_fun] = ACTIONS(274),
    [anon_sym_end] = ACTIONS(274),
    [anon_sym_begin] = ACTIONS(274),
    [anon_sym_case] = ACTIONS(274),
    [anon_sym_receive] = ACTIONS(274),
    [anon_sym_try] = ACTIONS(274),
    [anon_sym_maybe] = ACTIONS(274),
    [anon_sym_else] = ACTIONS(274),
    [anon_sym_DOLLAR] = ACTIONS(272),
    [aux_sym_integer_token1] = ACTIONS(274),
    [aux_sym_integer_token2] = ACTIONS(272),
    [sym_float] = ACTIONS(272),
    [sym__atom] = ACTIONS(274),
    [anon_sym_SQUOTE] = ACTIONS(272),
    [sym_variable] = ACTIONS(272),
    [anon_sym_QMARK] = ACTIONS(274),
    [anon_sym_DQUOTE] = ACTIONS(272),
    [sym_tripledot] = ACTIONS(272),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [100] = {
    [sym_comment] = STATE(100),
    [anon_sym_COMMA] = ACTIONS(276),
    [anon_sym_DASH] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(276),
    [anon_sym_COLON] = ACTIONS(278),
    [anon_sym_when] = ACTIONS(278),
    [anon_sym_if] = ACTIONS(278),
    [anon_sym_LT_LT] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(276),
    [anon_sym_LBRACK] = ACTIONS(276),
    [anon_sym_POUND] = ACTIONS(276),
    [anon_sym_PLUS] = ACTIONS(278),
    [anon_sym_not] = ACTIONS(278),
    [anon_sym_bnot] = ACTIONS(278),
    [anon_sym_catch] = ACTIONS(278),
    [anon_sym_SLASH] = ACTIONS(278),
    [anon_sym_STAR] = ACTIONS(276),
    [anon_sym_div] = ACTIONS(278),
    [anon_sym_rem] = ACTIONS(278),
    [anon_sym_band] = ACTIONS(278),
    [anon_sym_and] = ACTIONS(278),
    [anon_sym_bor] = ACTIONS(278),
    [anon_sym_bxor] = ACTIONS(278),
    [anon_sym_bsl] = ACTIONS(278),
    [anon_sym_bsr] = ACTIONS(278),
    [anon_sym_or] = ACTIONS(278),
    [anon_sym_xor] = ACTIONS(278),
    [anon_sym_PLUS_PLUS] = ACTIONS(276),
    [anon_sym_DASH_DASH] = ACTIONS(276),
    [anon_sym_EQ_EQ] = ACTIONS(276),
    [anon_sym_SLASH_EQ] = ACTIONS(276),
    [anon_sym_EQ_LT] = ACTIONS(276),
    [anon_sym_LT] = ACTIONS(278),
    [anon_sym_GT_EQ] = ACTIONS(276),
    [anon_sym_GT] = ACTIONS(278),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(276),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(276),
    [anon_sym_andalso] = ACTIONS(278),
    [anon_sym_orelse] = ACTIONS(278),
    [anon_sym_EQ] = ACTIONS(278),
    [anon_sym_BANG] = ACTIONS(276),
    [anon_sym_QMARK_EQ] = ACTIONS(276),
    [anon_sym_DOT_DOT] = ACTIONS(278),
    [anon_sym_PIPE_PIPE] = ACTIONS(276),
    [anon_sym_COLON_COLON] = ACTIONS(276),
    [anon_sym_PIPE] = ACTIONS(278),
    [anon_sym_LT_DASH] = ACTIONS(276),
    [anon_sym_LT_EQ] = ACTIONS(276),
    [anon_sym_EQ_GT] = ACTIONS(276),
    [anon_sym_COLON_EQ] = ACTIONS(276),
    [anon_sym_fun] = ACTIONS(278),
    [anon_sym_end] = ACTIONS(278),
    [anon_sym_begin] = ACTIONS(278),
    [anon_sym_case] = ACTIONS(278),
    [anon_sym_receive] = ACTIONS(278),
    [anon_sym_try] = ACTIONS(278),
    [anon_sym_maybe] = ACTIONS(278),
    [anon_sym_else] = ACTIONS(278),
    [anon_sym_DOLLAR] = ACTIONS(276),
    [aux_sym_integer_token1] = ACTIONS(278),
    [aux_sym_integer_token2] = ACTIONS(276),
    [sym_float] = ACTIONS(276),
    [sym__atom] = ACTIONS(278),
    [anon_sym_SQUOTE] = ACTIONS(276),
    [sym_variable] = ACTIONS(276),
    [anon_sym_QMARK] = ACTIONS(278),
    [anon_sym_DQUOTE] = ACTIONS(276),
    [sym_tripledot] = ACTIONS(276),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [101] = {
    [sym_comment] = STATE(101),
    [anon_sym_COMMA] = ACTIONS(256),
    [anon_sym_DASH] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(256),
    [anon_sym_COLON] = ACTIONS(258),
    [anon_sym_when] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_LT_LT] = ACTIONS(256),
    [anon_sym_LBRACE] = ACTIONS(256),
    [anon_sym_LBRACK] = ACTIONS(256),
    [anon_sym_POUND] = ACTIONS(256),
    [anon_sym_PLUS] = ACTIONS(258),
    [anon_sym_not] = ACTIONS(258),
    [anon_sym_bnot] = ACTIONS(258),
    [anon_sym_catch] = ACTIONS(258),
    [anon_sym_SLASH] = ACTIONS(258),
    [anon_sym_STAR] = ACTIONS(256),
    [anon_sym_div] = ACTIONS(258),
    [anon_sym_rem] = ACTIONS(258),
    [anon_sym_band] = ACTIONS(258),
    [anon_sym_and] = ACTIONS(258),
    [anon_sym_bor] = ACTIONS(258),
    [anon_sym_bxor] = ACTIONS(258),
    [anon_sym_bsl] = ACTIONS(258),
    [anon_sym_bsr] = ACTIONS(258),
    [anon_sym_or] = ACTIONS(258),
    [anon_sym_xor] = ACTIONS(258),
    [anon_sym_PLUS_PLUS] = ACTIONS(256),
    [anon_sym_DASH_DASH] = ACTIONS(256),
    [anon_sym_EQ_EQ] = ACTIONS(256),
    [anon_sym_SLASH_EQ] = ACTIONS(256),
    [anon_sym_EQ_LT] = ACTIONS(256),
    [anon_sym_LT] = ACTIONS(258),
    [anon_sym_GT_EQ] = ACTIONS(256),
    [anon_sym_GT] = ACTIONS(258),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(256),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(256),
    [anon_sym_andalso] = ACTIONS(258),
    [anon_sym_orelse] = ACTIONS(258),
    [anon_sym_EQ] = ACTIONS(258),
    [anon_sym_BANG] = ACTIONS(256),
    [anon_sym_QMARK_EQ] = ACTIONS(256),
    [anon_sym_DOT_DOT] = ACTIONS(258),
    [anon_sym_PIPE_PIPE] = ACTIONS(256),
    [anon_sym_COLON_COLON] = ACTIONS(256),
    [anon_sym_PIPE] = ACTIONS(258),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_LT_EQ] = ACTIONS(256),
    [anon_sym_EQ_GT] = ACTIONS(256),
    [anon_sym_COLON_EQ] = ACTIONS(256),
    [anon_sym_fun] = ACTIONS(258),
    [anon_sym_end] = ACTIONS(258),
    [anon_sym_begin] = ACTIONS(258),
    [anon_sym_case] = ACTIONS(258),
    [anon_sym_receive] = ACTIONS(258),
    [anon_sym_try] = ACTIONS(258),
    [anon_sym_maybe] = ACTIONS(258),
    [anon_sym_else] = ACTIONS(258),
    [anon_sym_DOLLAR] = ACTIONS(256),
    [aux_sym_integer_token1] = ACTIONS(258),
    [aux_sym_integer_token2] = ACTIONS(256),
    [sym_float] = ACTIONS(256),
    [sym__atom] = ACTIONS(258),
    [anon_sym_SQUOTE] = ACTIONS(256),
    [sym_variable] = ACTIONS(256),
    [anon_sym_QMARK] = ACTIONS(258),
    [anon_sym_DQUOTE] = ACTIONS(256),
    [sym_tripledot] = ACTIONS(256),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [102] = {
    [sym_comment] = STATE(102),
    [anon_sym_COMMA] = ACTIONS(252),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_end] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_else] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym__atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [103] = {
    [sym_comment] = STATE(103),
    [anon_sym_COMMA] = ACTIONS(260),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_LPAREN] = ACTIONS(260),
    [anon_sym_COLON] = ACTIONS(262),
    [anon_sym_when] = ACTIONS(262),
    [anon_sym_if] = ACTIONS(262),
    [anon_sym_LT_LT] = ACTIONS(260),
    [anon_sym_LBRACE] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(260),
    [anon_sym_POUND] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_not] = ACTIONS(262),
    [anon_sym_bnot] = ACTIONS(262),
    [anon_sym_catch] = ACTIONS(262),
    [anon_sym_SLASH] = ACTIONS(262),
    [anon_sym_STAR] = ACTIONS(260),
    [anon_sym_div] = ACTIONS(262),
    [anon_sym_rem] = ACTIONS(262),
    [anon_sym_band] = ACTIONS(262),
    [anon_sym_and] = ACTIONS(262),
    [anon_sym_bor] = ACTIONS(262),
    [anon_sym_bxor] = ACTIONS(262),
    [anon_sym_bsl] = ACTIONS(262),
    [anon_sym_bsr] = ACTIONS(262),
    [anon_sym_or] = ACTIONS(262),
    [anon_sym_xor] = ACTIONS(262),
    [anon_sym_PLUS_PLUS] = ACTIONS(260),
    [anon_sym_DASH_DASH] = ACTIONS(260),
    [anon_sym_EQ_EQ] = ACTIONS(260),
    [anon_sym_SLASH_EQ] = ACTIONS(260),
    [anon_sym_EQ_LT] = ACTIONS(260),
    [anon_sym_LT] = ACTIONS(262),
    [anon_sym_GT_EQ] = ACTIONS(260),
    [anon_sym_GT] = ACTIONS(262),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(260),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(260),
    [anon_sym_andalso] = ACTIONS(262),
    [anon_sym_orelse] = ACTIONS(262),
    [anon_sym_EQ] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(260),
    [anon_sym_QMARK_EQ] = ACTIONS(260),
    [anon_sym_DOT_DOT] = ACTIONS(262),
    [anon_sym_PIPE_PIPE] = ACTIONS(260),
    [anon_sym_COLON_COLON] = ACTIONS(260),
    [anon_sym_PIPE] = ACTIONS(262),
    [anon_sym_LT_DASH] = ACTIONS(260),
    [anon_sym_LT_EQ] = ACTIONS(260),
    [anon_sym_EQ_GT] = ACTIONS(260),
    [anon_sym_COLON_EQ] = ACTIONS(260),
    [anon_sym_fun] = ACTIONS(262),
    [anon_sym_end] = ACTIONS(262),
    [anon_sym_begin] = ACTIONS(262),
    [anon_sym_case] = ACTIONS(262),
    [anon_sym_receive] = ACTIONS(262),
    [anon_sym_try] = ACTIONS(262),
    [anon_sym_maybe] = ACTIONS(262),
    [anon_sym_else] = ACTIONS(262),
    [anon_sym_DOLLAR] = ACTIONS(260),
    [aux_sym_integer_token1] = ACTIONS(262),
    [aux_sym_integer_token2] = ACTIONS(260),
    [sym_float] = ACTIONS(260),
    [sym__atom] = ACTIONS(262),
    [anon_sym_SQUOTE] = ACTIONS(260),
    [sym_variable] = ACTIONS(260),
    [anon_sym_QMARK] = ACTIONS(262),
    [anon_sym_DQUOTE] = ACTIONS(260),
    [sym_tripledot] = ACTIONS(260),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [104] = {
    [sym_comment] = STATE(104),
    [anon_sym_COMMA] = ACTIONS(268),
    [anon_sym_DASH] = ACTIONS(270),
    [anon_sym_LPAREN] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_when] = ACTIONS(270),
    [anon_sym_if] = ACTIONS(270),
    [anon_sym_LT_LT] = ACTIONS(268),
    [anon_sym_LBRACE] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(268),
    [anon_sym_POUND] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(270),
    [anon_sym_not] = ACTIONS(270),
    [anon_sym_bnot] = ACTIONS(270),
    [anon_sym_catch] = ACTIONS(270),
    [anon_sym_SLASH] = ACTIONS(270),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_div] = ACTIONS(270),
    [anon_sym_rem] = ACTIONS(270),
    [anon_sym_band] = ACTIONS(270),
    [anon_sym_and] = ACTIONS(270),
    [anon_sym_bor] = ACTIONS(270),
    [anon_sym_bxor] = ACTIONS(270),
    [anon_sym_bsl] = ACTIONS(270),
    [anon_sym_bsr] = ACTIONS(270),
    [anon_sym_or] = ACTIONS(270),
    [anon_sym_xor] = ACTIONS(270),
    [anon_sym_PLUS_PLUS] = ACTIONS(268),
    [anon_sym_DASH_DASH] = ACTIONS(268),
    [anon_sym_EQ_EQ] = ACTIONS(268),
    [anon_sym_SLASH_EQ] = ACTIONS(268),
    [anon_sym_EQ_LT] = ACTIONS(268),
    [anon_sym_LT] = ACTIONS(270),
    [anon_sym_GT_EQ] = ACTIONS(268),
    [anon_sym_GT] = ACTIONS(270),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(268),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(268),
    [anon_sym_andalso] = ACTIONS(270),
    [anon_sym_orelse] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(270),
    [anon_sym_BANG] = ACTIONS(268),
    [anon_sym_QMARK_EQ] = ACTIONS(268),
    [anon_sym_DOT_DOT] = ACTIONS(270),
    [anon_sym_PIPE_PIPE] = ACTIONS(268),
    [anon_sym_COLON_COLON] = ACTIONS(268),
    [anon_sym_PIPE] = ACTIONS(270),
    [anon_sym_LT_DASH] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(268),
    [anon_sym_EQ_GT] = ACTIONS(268),
    [anon_sym_COLON_EQ] = ACTIONS(268),
    [anon_sym_fun] = ACTIONS(270),
    [anon_sym_end] = ACTIONS(270),
    [anon_sym_begin] = ACTIONS(270),
    [anon_sym_case] = ACTIONS(270),
    [anon_sym_receive] = ACTIONS(270),
    [anon_sym_try] = ACTIONS(270),
    [anon_sym_maybe] = ACTIONS(270),
    [anon_sym_else] = ACTIONS(270),
    [anon_sym_DOLLAR] = ACTIONS(268),
    [aux_sym_integer_token1] = ACTIONS(270),
    [aux_sym_integer_token2] = ACTIONS(268),
    [sym_float] = ACTIONS(268),
    [sym__atom] = ACTIONS(270),
    [anon_sym_SQUOTE] = ACTIONS(268),
    [sym_variable] = ACTIONS(268),
    [anon_sym_QMARK] = ACTIONS(270),
    [anon_sym_DQUOTE] = ACTIONS(268),
    [sym_tripledot] = ACTIONS(268),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [105] = {
    [sym_comment] = STATE(105),
    [anon_sym_COMMA] = ACTIONS(260),
    [anon_sym_SEMI] = ACTIONS(260),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_LPAREN] = ACTIONS(260),
    [anon_sym_COLON] = ACTIONS(262),
    [anon_sym_when] = ACTIONS(262),
    [anon_sym_if] = ACTIONS(262),
    [anon_sym_LT_LT] = ACTIONS(260),
    [anon_sym_LBRACE] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(260),
    [anon_sym_POUND] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_not] = ACTIONS(262),
    [anon_sym_bnot] = ACTIONS(262),
    [anon_sym_catch] = ACTIONS(262),
    [anon_sym_SLASH] = ACTIONS(262),
    [anon_sym_STAR] = ACTIONS(260),
    [anon_sym_div] = ACTIONS(262),
    [anon_sym_rem] = ACTIONS(262),
    [anon_sym_band] = ACTIONS(262),
    [anon_sym_and] = ACTIONS(262),
    [anon_sym_bor] = ACTIONS(262),
    [anon_sym_bxor] = ACTIONS(262),
    [anon_sym_bsl] = ACTIONS(262),
    [anon_sym_bsr] = ACTIONS(262),
    [anon_sym_or] = ACTIONS(262),
    [anon_sym_xor] = ACTIONS(262),
    [anon_sym_PLUS_PLUS] = ACTIONS(260),
    [anon_sym_DASH_DASH] = ACTIONS(260),
    [anon_sym_EQ_EQ] = ACTIONS(260),
    [anon_sym_SLASH_EQ] = ACTIONS(260),
    [anon_sym_EQ_LT] = ACTIONS(260),
    [anon_sym_LT] = ACTIONS(262),
    [anon_sym_GT_EQ] = ACTIONS(260),
    [anon_sym_GT] = ACTIONS(262),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(260),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(260),
    [anon_sym_andalso] = ACTIONS(262),
    [anon_sym_orelse] = ACTIONS(262),
    [anon_sym_EQ] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(260),
    [anon_sym_QMARK_EQ] = ACTIONS(260),
    [anon_sym_DOT_DOT] = ACTIONS(262),
    [anon_sym_PIPE_PIPE] = ACTIONS(260),
    [anon_sym_COLON_COLON] = ACTIONS(260),
    [anon_sym_PIPE] = ACTIONS(262),
    [anon_sym_LT_DASH] = ACTIONS(260),
    [anon_sym_LT_EQ] = ACTIONS(260),
    [anon_sym_EQ_GT] = ACTIONS(260),
    [anon_sym_COLON_EQ] = ACTIONS(260),
    [anon_sym_fun] = ACTIONS(262),
    [anon_sym_end] = ACTIONS(262),
    [anon_sym_begin] = ACTIONS(262),
    [anon_sym_case] = ACTIONS(262),
    [anon_sym_receive] = ACTIONS(262),
    [anon_sym_try] = ACTIONS(262),
    [anon_sym_maybe] = ACTIONS(262),
    [anon_sym_DOLLAR] = ACTIONS(260),
    [aux_sym_integer_token1] = ACTIONS(262),
    [aux_sym_integer_token2] = ACTIONS(260),
    [sym_float] = ACTIONS(260),
    [sym__atom] = ACTIONS(262),
    [anon_sym_SQUOTE] = ACTIONS(260),
    [sym_variable] = ACTIONS(260),
    [anon_sym_QMARK] = ACTIONS(262),
    [anon_sym_DQUOTE] = ACTIONS(260),
    [sym_tripledot] = ACTIONS(260),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [106] = {
    [sym_comment] = STATE(106),
    [anon_sym_COMMA] = ACTIONS(252),
    [anon_sym_SEMI] = ACTIONS(252),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_end] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym__atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [107] = {
    [sym_comment] = STATE(107),
    [anon_sym_COMMA] = ACTIONS(256),
    [anon_sym_SEMI] = ACTIONS(256),
    [anon_sym_DASH] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(256),
    [anon_sym_COLON] = ACTIONS(258),
    [anon_sym_when] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_LT_LT] = ACTIONS(256),
    [anon_sym_LBRACE] = ACTIONS(256),
    [anon_sym_LBRACK] = ACTIONS(256),
    [anon_sym_POUND] = ACTIONS(256),
    [anon_sym_PLUS] = ACTIONS(258),
    [anon_sym_not] = ACTIONS(258),
    [anon_sym_bnot] = ACTIONS(258),
    [anon_sym_catch] = ACTIONS(258),
    [anon_sym_SLASH] = ACTIONS(258),
    [anon_sym_STAR] = ACTIONS(256),
    [anon_sym_div] = ACTIONS(258),
    [anon_sym_rem] = ACTIONS(258),
    [anon_sym_band] = ACTIONS(258),
    [anon_sym_and] = ACTIONS(258),
    [anon_sym_bor] = ACTIONS(258),
    [anon_sym_bxor] = ACTIONS(258),
    [anon_sym_bsl] = ACTIONS(258),
    [anon_sym_bsr] = ACTIONS(258),
    [anon_sym_or] = ACTIONS(258),
    [anon_sym_xor] = ACTIONS(258),
    [anon_sym_PLUS_PLUS] = ACTIONS(256),
    [anon_sym_DASH_DASH] = ACTIONS(256),
    [anon_sym_EQ_EQ] = ACTIONS(256),
    [anon_sym_SLASH_EQ] = ACTIONS(256),
    [anon_sym_EQ_LT] = ACTIONS(256),
    [anon_sym_LT] = ACTIONS(258),
    [anon_sym_GT_EQ] = ACTIONS(256),
    [anon_sym_GT] = ACTIONS(258),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(256),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(256),
    [anon_sym_andalso] = ACTIONS(258),
    [anon_sym_orelse] = ACTIONS(258),
    [anon_sym_EQ] = ACTIONS(258),
    [anon_sym_BANG] = ACTIONS(256),
    [anon_sym_QMARK_EQ] = ACTIONS(256),
    [anon_sym_DOT_DOT] = ACTIONS(258),
    [anon_sym_PIPE_PIPE] = ACTIONS(256),
    [anon_sym_COLON_COLON] = ACTIONS(256),
    [anon_sym_PIPE] = ACTIONS(258),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_LT_EQ] = ACTIONS(256),
    [anon_sym_EQ_GT] = ACTIONS(256),
    [anon_sym_COLON_EQ] = ACTIONS(256),
    [anon_sym_fun] = ACTIONS(258),
    [anon_sym_end] = ACTIONS(258),
    [anon_sym_begin] = ACTIONS(258),
    [anon_sym_case] = ACTIONS(258),
    [anon_sym_receive] = ACTIONS(258),
    [anon_sym_try] = ACTIONS(258),
    [anon_sym_maybe] = ACTIONS(258),
    [anon_sym_DOLLAR] = ACTIONS(256),
    [aux_sym_integer_token1] = ACTIONS(258),
    [aux_sym_integer_token2] = ACTIONS(256),
    [sym_float] = ACTIONS(256),
    [sym__atom] = ACTIONS(258),
    [anon_sym_SQUOTE] = ACTIONS(256),
    [sym_variable] = ACTIONS(256),
    [anon_sym_QMARK] = ACTIONS(258),
    [anon_sym_DQUOTE] = ACTIONS(256),
    [sym_tripledot] = ACTIONS(256),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [108] = {
    [sym_comment] = STATE(108),
    [anon_sym_COMMA] = ACTIONS(264),
    [anon_sym_DASH] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_when] = ACTIONS(266),
    [anon_sym_if] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(264),
    [anon_sym_LBRACK] = ACTIONS(264),
    [anon_sym_POUND] = ACTIONS(264),
    [anon_sym_PLUS] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(266),
    [anon_sym_bnot] = ACTIONS(266),
    [anon_sym_catch] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(266),
    [anon_sym_STAR] = ACTIONS(264),
    [anon_sym_div] = ACTIONS(266),
    [anon_sym_rem] = ACTIONS(266),
    [anon_sym_band] = ACTIONS(266),
    [anon_sym_and] = ACTIONS(266),
    [anon_sym_bor] = ACTIONS(266),
    [anon_sym_bxor] = ACTIONS(266),
    [anon_sym_bsl] = ACTIONS(266),
    [anon_sym_bsr] = ACTIONS(266),
    [anon_sym_or] = ACTIONS(266),
    [anon_sym_xor] = ACTIONS(266),
    [anon_sym_PLUS_PLUS] = ACTIONS(264),
    [anon_sym_DASH_DASH] = ACTIONS(264),
    [anon_sym_EQ_EQ] = ACTIONS(264),
    [anon_sym_SLASH_EQ] = ACTIONS(264),
    [anon_sym_EQ_LT] = ACTIONS(264),
    [anon_sym_LT] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(264),
    [anon_sym_GT] = ACTIONS(266),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(264),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(264),
    [anon_sym_andalso] = ACTIONS(266),
    [anon_sym_orelse] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(266),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_QMARK_EQ] = ACTIONS(264),
    [anon_sym_DOT_DOT] = ACTIONS(266),
    [anon_sym_PIPE_PIPE] = ACTIONS(264),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_LT_DASH] = ACTIONS(264),
    [anon_sym_LT_EQ] = ACTIONS(264),
    [anon_sym_EQ_GT] = ACTIONS(264),
    [anon_sym_COLON_EQ] = ACTIONS(264),
    [anon_sym_fun] = ACTIONS(266),
    [anon_sym_end] = ACTIONS(266),
    [anon_sym_begin] = ACTIONS(266),
    [anon_sym_case] = ACTIONS(266),
    [anon_sym_receive] = ACTIONS(266),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_maybe] = ACTIONS(266),
    [anon_sym_else] = ACTIONS(266),
    [anon_sym_DOLLAR] = ACTIONS(264),
    [aux_sym_integer_token1] = ACTIONS(266),
    [aux_sym_integer_token2] = ACTIONS(264),
    [sym_float] = ACTIONS(264),
    [sym__atom] = ACTIONS(266),
    [anon_sym_SQUOTE] = ACTIONS(264),
    [sym_variable] = ACTIONS(264),
    [anon_sym_QMARK] = ACTIONS(266),
    [anon_sym_DQUOTE] = ACTIONS(264),
    [sym_tripledot] = ACTIONS(264),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [109] = {
    [sym_comment] = STATE(109),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_end] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_else] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym__atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [110] = {
    [sym_comment] = STATE(110),
    [anon_sym_COMMA] = ACTIONS(280),
    [anon_sym_SEMI] = ACTIONS(280),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_when] = ACTIONS(282),
    [anon_sym_if] = ACTIONS(282),
    [anon_sym_LT_LT] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_LBRACK] = ACTIONS(280),
    [anon_sym_POUND] = ACTIONS(280),
    [anon_sym_PLUS] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_bnot] = ACTIONS(282),
    [anon_sym_catch] = ACTIONS(282),
    [anon_sym_SLASH] = ACTIONS(282),
    [anon_sym_STAR] = ACTIONS(280),
    [anon_sym_div] = ACTIONS(282),
    [anon_sym_rem] = ACTIONS(282),
    [anon_sym_band] = ACTIONS(282),
    [anon_sym_and] = ACTIONS(282),
    [anon_sym_bor] = ACTIONS(282),
    [anon_sym_bxor] = ACTIONS(282),
    [anon_sym_bsl] = ACTIONS(282),
    [anon_sym_bsr] = ACTIONS(282),
    [anon_sym_or] = ACTIONS(282),
    [anon_sym_xor] = ACTIONS(282),
    [anon_sym_PLUS_PLUS] = ACTIONS(280),
    [anon_sym_DASH_DASH] = ACTIONS(280),
    [anon_sym_EQ_EQ] = ACTIONS(280),
    [anon_sym_SLASH_EQ] = ACTIONS(280),
    [anon_sym_EQ_LT] = ACTIONS(280),
    [anon_sym_LT] = ACTIONS(282),
    [anon_sym_GT_EQ] = ACTIONS(280),
    [anon_sym_GT] = ACTIONS(282),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(280),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(280),
    [anon_sym_andalso] = ACTIONS(282),
    [anon_sym_orelse] = ACTIONS(282),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_BANG] = ACTIONS(280),
    [anon_sym_QMARK_EQ] = ACTIONS(280),
    [anon_sym_DOT_DOT] = ACTIONS(282),
    [anon_sym_PIPE_PIPE] = ACTIONS(280),
    [anon_sym_COLON_COLON] = ACTIONS(280),
    [anon_sym_PIPE] = ACTIONS(282),
    [anon_sym_LT_DASH] = ACTIONS(280),
    [anon_sym_LT_EQ] = ACTIONS(280),
    [anon_sym_EQ_GT] = ACTIONS(280),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_fun] = ACTIONS(282),
    [anon_sym_end] = ACTIONS(282),
    [anon_sym_begin] = ACTIONS(282),
    [anon_sym_case] = ACTIONS(282),
    [anon_sym_receive] = ACTIONS(282),
    [anon_sym_try] = ACTIONS(282),
    [anon_sym_maybe] = ACTIONS(282),
    [anon_sym_DOLLAR] = ACTIONS(280),
    [aux_sym_integer_token1] = ACTIONS(282),
    [aux_sym_integer_token2] = ACTIONS(280),
    [sym_float] = ACTIONS(280),
    [sym__atom] = ACTIONS(282),
    [anon_sym_SQUOTE] = ACTIONS(280),
    [sym_variable] = ACTIONS(280),
    [anon_sym_QMARK] = ACTIONS(282),
    [anon_sym_DQUOTE] = ACTIONS(280),
    [sym_tripledot] = ACTIONS(280),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [111] = {
    [sym_comment] = STATE(111),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_end] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_else] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym__atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [112] = {
    [sym_arguments] = STATE(128),
    [sym_comment] = STATE(112),
    [anon_sym_DASH] = ACTIONS(240),
    [anon_sym_LPAREN] = ACTIONS(429),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_when] = ACTIONS(240),
    [anon_sym_if] = ACTIONS(240),
    [anon_sym_LT_LT] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(238),
    [anon_sym_POUND] = ACTIONS(238),
    [anon_sym_PLUS] = ACTIONS(240),
    [anon_sym_not] = ACTIONS(240),
    [anon_sym_bnot] = ACTIONS(240),
    [anon_sym_catch] = ACTIONS(240),
    [anon_sym_SLASH] = ACTIONS(240),
    [anon_sym_STAR] = ACTIONS(238),
    [anon_sym_div] = ACTIONS(240),
    [anon_sym_rem] = ACTIONS(240),
    [anon_sym_band] = ACTIONS(240),
    [anon_sym_and] = ACTIONS(240),
    [anon_sym_bor] = ACTIONS(240),
    [anon_sym_bxor] = ACTIONS(240),
    [anon_sym_bsl] = ACTIONS(240),
    [anon_sym_bsr] = ACTIONS(240),
    [anon_sym_or] = ACTIONS(240),
    [anon_sym_xor] = ACTIONS(240),
    [anon_sym_PLUS_PLUS] = ACTIONS(238),
    [anon_sym_DASH_DASH] = ACTIONS(238),
    [anon_sym_EQ_EQ] = ACTIONS(238),
    [anon_sym_SLASH_EQ] = ACTIONS(238),
    [anon_sym_EQ_LT] = ACTIONS(238),
    [anon_sym_LT] = ACTIONS(240),
    [anon_sym_GT_EQ] = ACTIONS(238),
    [anon_sym_GT] = ACTIONS(240),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(238),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(238),
    [anon_sym_andalso] = ACTIONS(240),
    [anon_sym_orelse] = ACTIONS(240),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_QMARK_EQ] = ACTIONS(238),
    [anon_sym_DOT_DOT] = ACTIONS(240),
    [anon_sym_PIPE_PIPE] = ACTIONS(238),
    [anon_sym_COLON_COLON] = ACTIONS(238),
    [anon_sym_PIPE] = ACTIONS(240),
    [anon_sym_LT_DASH] = ACTIONS(238),
    [anon_sym_LT_EQ] = ACTIONS(238),
    [anon_sym_EQ_GT] = ACTIONS(238),
    [anon_sym_COLON_EQ] = ACTIONS(238),
    [anon_sym_fun] = ACTIONS(240),
    [anon_sym_begin] = ACTIONS(240),
    [anon_sym_case] = ACTIONS(240),
    [anon_sym_of] = ACTIONS(240),
    [anon_sym_receive] = ACTIONS(240),
    [anon_sym_try] = ACTIONS(240),
    [anon_sym_maybe] = ACTIONS(240),
    [anon_sym_DOLLAR] = ACTIONS(238),
    [aux_sym_integer_token1] = ACTIONS(240),
    [aux_sym_integer_token2] = ACTIONS(238),
    [sym_float] = ACTIONS(238),
    [sym__atom] = ACTIONS(240),
    [anon_sym_SQUOTE] = ACTIONS(238),
    [sym_variable] = ACTIONS(238),
    [anon_sym_QMARK] = ACTIONS(240),
    [anon_sym_DQUOTE] = ACTIONS(238),
    [sym_tripledot] = ACTIONS(238),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [113] = {
    [sym_comment] = STATE(113),
    [anon_sym_DASH] = ACTIONS(254),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(254),
    [anon_sym_when] = ACTIONS(254),
    [anon_sym_if] = ACTIONS(254),
    [anon_sym_LT_LT] = ACTIONS(252),
    [anon_sym_LBRACE] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_POUND] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(254),
    [anon_sym_not] = ACTIONS(254),
    [anon_sym_bnot] = ACTIONS(254),
    [anon_sym_catch] = ACTIONS(254),
    [anon_sym_SLASH] = ACTIONS(254),
    [anon_sym_STAR] = ACTIONS(252),
    [anon_sym_div] = ACTIONS(254),
    [anon_sym_rem] = ACTIONS(254),
    [anon_sym_band] = ACTIONS(254),
    [anon_sym_and] = ACTIONS(254),
    [anon_sym_bor] = ACTIONS(254),
    [anon_sym_bxor] = ACTIONS(254),
    [anon_sym_bsl] = ACTIONS(254),
    [anon_sym_bsr] = ACTIONS(254),
    [anon_sym_or] = ACTIONS(254),
    [anon_sym_xor] = ACTIONS(254),
    [anon_sym_PLUS_PLUS] = ACTIONS(252),
    [anon_sym_DASH_DASH] = ACTIONS(252),
    [anon_sym_EQ_EQ] = ACTIONS(252),
    [anon_sym_SLASH_EQ] = ACTIONS(252),
    [anon_sym_EQ_LT] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(254),
    [anon_sym_GT_EQ] = ACTIONS(252),
    [anon_sym_GT] = ACTIONS(254),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(252),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(252),
    [anon_sym_andalso] = ACTIONS(254),
    [anon_sym_orelse] = ACTIONS(254),
    [anon_sym_EQ] = ACTIONS(254),
    [anon_sym_BANG] = ACTIONS(252),
    [anon_sym_QMARK_EQ] = ACTIONS(252),
    [anon_sym_DOT_DOT] = ACTIONS(254),
    [anon_sym_PIPE_PIPE] = ACTIONS(252),
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_PIPE] = ACTIONS(254),
    [anon_sym_LT_DASH] = ACTIONS(252),
    [anon_sym_LT_EQ] = ACTIONS(252),
    [anon_sym_EQ_GT] = ACTIONS(252),
    [anon_sym_COLON_EQ] = ACTIONS(252),
    [anon_sym_fun] = ACTIONS(254),
    [anon_sym_begin] = ACTIONS(254),
    [anon_sym_case] = ACTIONS(254),
    [anon_sym_of] = ACTIONS(254),
    [anon_sym_receive] = ACTIONS(254),
    [anon_sym_try] = ACTIONS(254),
    [anon_sym_maybe] = ACTIONS(254),
    [anon_sym_DOLLAR] = ACTIONS(252),
    [aux_sym_integer_token1] = ACTIONS(254),
    [aux_sym_integer_token2] = ACTIONS(252),
    [sym_float] = ACTIONS(252),
    [sym__atom] = ACTIONS(254),
    [anon_sym_SQUOTE] = ACTIONS(252),
    [sym_variable] = ACTIONS(252),
    [anon_sym_QMARK] = ACTIONS(254),
    [anon_sym_DQUOTE] = ACTIONS(252),
    [sym_tripledot] = ACTIONS(252),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [114] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1583),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym__if_clause] = STATE(1490),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(114),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [115] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1105),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_arguments] = STATE(1602),
    [sym__items] = STATE(1616),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(115),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_RPAREN] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [116] = {
    [sym_comment] = STATE(116),
    [anon_sym_DASH] = ACTIONS(278),
    [anon_sym_LPAREN] = ACTIONS(276),
    [anon_sym_COLON] = ACTIONS(278),
    [anon_sym_when] = ACTIONS(278),
    [anon_sym_if] = ACTIONS(278),
    [anon_sym_LT_LT] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(276),
    [anon_sym_LBRACK] = ACTIONS(276),
    [anon_sym_POUND] = ACTIONS(276),
    [anon_sym_PLUS] = ACTIONS(278),
    [anon_sym_not] = ACTIONS(278),
    [anon_sym_bnot] = ACTIONS(278),
    [anon_sym_catch] = ACTIONS(278),
    [anon_sym_SLASH] = ACTIONS(278),
    [anon_sym_STAR] = ACTIONS(276),
    [anon_sym_div] = ACTIONS(278),
    [anon_sym_rem] = ACTIONS(278),
    [anon_sym_band] = ACTIONS(278),
    [anon_sym_and] = ACTIONS(278),
    [anon_sym_bor] = ACTIONS(278),
    [anon_sym_bxor] = ACTIONS(278),
    [anon_sym_bsl] = ACTIONS(278),
    [anon_sym_bsr] = ACTIONS(278),
    [anon_sym_or] = ACTIONS(278),
    [anon_sym_xor] = ACTIONS(278),
    [anon_sym_PLUS_PLUS] = ACTIONS(276),
    [anon_sym_DASH_DASH] = ACTIONS(276),
    [anon_sym_EQ_EQ] = ACTIONS(276),
    [anon_sym_SLASH_EQ] = ACTIONS(276),
    [anon_sym_EQ_LT] = ACTIONS(276),
    [anon_sym_LT] = ACTIONS(278),
    [anon_sym_GT_EQ] = ACTIONS(276),
    [anon_sym_GT] = ACTIONS(278),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(276),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(276),
    [anon_sym_andalso] = ACTIONS(278),
    [anon_sym_orelse] = ACTIONS(278),
    [anon_sym_EQ] = ACTIONS(278),
    [anon_sym_BANG] = ACTIONS(276),
    [anon_sym_QMARK_EQ] = ACTIONS(276),
    [anon_sym_DOT_DOT] = ACTIONS(278),
    [anon_sym_PIPE_PIPE] = ACTIONS(276),
    [anon_sym_COLON_COLON] = ACTIONS(276),
    [anon_sym_PIPE] = ACTIONS(278),
    [anon_sym_LT_DASH] = ACTIONS(276),
    [anon_sym_LT_EQ] = ACTIONS(276),
    [anon_sym_EQ_GT] = ACTIONS(276),
    [anon_sym_COLON_EQ] = ACTIONS(276),
    [anon_sym_fun] = ACTIONS(278),
    [anon_sym_begin] = ACTIONS(278),
    [anon_sym_case] = ACTIONS(278),
    [anon_sym_of] = ACTIONS(278),
    [anon_sym_receive] = ACTIONS(278),
    [anon_sym_try] = ACTIONS(278),
    [anon_sym_maybe] = ACTIONS(278),
    [anon_sym_DOLLAR] = ACTIONS(276),
    [aux_sym_integer_token1] = ACTIONS(278),
    [aux_sym_integer_token2] = ACTIONS(276),
    [sym_float] = ACTIONS(276),
    [sym__atom] = ACTIONS(278),
    [anon_sym_SQUOTE] = ACTIONS(276),
    [sym_variable] = ACTIONS(276),
    [anon_sym_QMARK] = ACTIONS(278),
    [anon_sym_DQUOTE] = ACTIONS(276),
    [sym_tripledot] = ACTIONS(276),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [117] = {
    [sym_comment] = STATE(117),
    [anon_sym_DASH] = ACTIONS(258),
    [anon_sym_LPAREN] = ACTIONS(256),
    [anon_sym_COLON] = ACTIONS(258),
    [anon_sym_when] = ACTIONS(258),
    [anon_sym_if] = ACTIONS(258),
    [anon_sym_LT_LT] = ACTIONS(256),
    [anon_sym_LBRACE] = ACTIONS(256),
    [anon_sym_LBRACK] = ACTIONS(256),
    [anon_sym_POUND] = ACTIONS(256),
    [anon_sym_PLUS] = ACTIONS(258),
    [anon_sym_not] = ACTIONS(258),
    [anon_sym_bnot] = ACTIONS(258),
    [anon_sym_catch] = ACTIONS(258),
    [anon_sym_SLASH] = ACTIONS(258),
    [anon_sym_STAR] = ACTIONS(256),
    [anon_sym_div] = ACTIONS(258),
    [anon_sym_rem] = ACTIONS(258),
    [anon_sym_band] = ACTIONS(258),
    [anon_sym_and] = ACTIONS(258),
    [anon_sym_bor] = ACTIONS(258),
    [anon_sym_bxor] = ACTIONS(258),
    [anon_sym_bsl] = ACTIONS(258),
    [anon_sym_bsr] = ACTIONS(258),
    [anon_sym_or] = ACTIONS(258),
    [anon_sym_xor] = ACTIONS(258),
    [anon_sym_PLUS_PLUS] = ACTIONS(256),
    [anon_sym_DASH_DASH] = ACTIONS(256),
    [anon_sym_EQ_EQ] = ACTIONS(256),
    [anon_sym_SLASH_EQ] = ACTIONS(256),
    [anon_sym_EQ_LT] = ACTIONS(256),
    [anon_sym_LT] = ACTIONS(258),
    [anon_sym_GT_EQ] = ACTIONS(256),
    [anon_sym_GT] = ACTIONS(258),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(256),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(256),
    [anon_sym_andalso] = ACTIONS(258),
    [anon_sym_orelse] = ACTIONS(258),
    [anon_sym_EQ] = ACTIONS(258),
    [anon_sym_BANG] = ACTIONS(256),
    [anon_sym_QMARK_EQ] = ACTIONS(256),
    [anon_sym_DOT_DOT] = ACTIONS(258),
    [anon_sym_PIPE_PIPE] = ACTIONS(256),
    [anon_sym_COLON_COLON] = ACTIONS(256),
    [anon_sym_PIPE] = ACTIONS(258),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_LT_EQ] = ACTIONS(256),
    [anon_sym_EQ_GT] = ACTIONS(256),
    [anon_sym_COLON_EQ] = ACTIONS(256),
    [anon_sym_fun] = ACTIONS(258),
    [anon_sym_begin] = ACTIONS(258),
    [anon_sym_case] = ACTIONS(258),
    [anon_sym_of] = ACTIONS(258),
    [anon_sym_receive] = ACTIONS(258),
    [anon_sym_try] = ACTIONS(258),
    [anon_sym_maybe] = ACTIONS(258),
    [anon_sym_DOLLAR] = ACTIONS(256),
    [aux_sym_integer_token1] = ACTIONS(258),
    [aux_sym_integer_token2] = ACTIONS(256),
    [sym_float] = ACTIONS(256),
    [sym__atom] = ACTIONS(258),
    [anon_sym_SQUOTE] = ACTIONS(256),
    [sym_variable] = ACTIONS(256),
    [anon_sym_QMARK] = ACTIONS(258),
    [anon_sym_DQUOTE] = ACTIONS(256),
    [sym_tripledot] = ACTIONS(256),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [118] = {
    [sym_comment] = STATE(118),
    [anon_sym_DASH] = ACTIONS(266),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_when] = ACTIONS(266),
    [anon_sym_if] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(264),
    [anon_sym_LBRACE] = ACTIONS(264),
    [anon_sym_LBRACK] = ACTIONS(264),
    [anon_sym_POUND] = ACTIONS(264),
    [anon_sym_PLUS] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(266),
    [anon_sym_bnot] = ACTIONS(266),
    [anon_sym_catch] = ACTIONS(266),
    [anon_sym_SLASH] = ACTIONS(266),
    [anon_sym_STAR] = ACTIONS(264),
    [anon_sym_div] = ACTIONS(266),
    [anon_sym_rem] = ACTIONS(266),
    [anon_sym_band] = ACTIONS(266),
    [anon_sym_and] = ACTIONS(266),
    [anon_sym_bor] = ACTIONS(266),
    [anon_sym_bxor] = ACTIONS(266),
    [anon_sym_bsl] = ACTIONS(266),
    [anon_sym_bsr] = ACTIONS(266),
    [anon_sym_or] = ACTIONS(266),
    [anon_sym_xor] = ACTIONS(266),
    [anon_sym_PLUS_PLUS] = ACTIONS(264),
    [anon_sym_DASH_DASH] = ACTIONS(264),
    [anon_sym_EQ_EQ] = ACTIONS(264),
    [anon_sym_SLASH_EQ] = ACTIONS(264),
    [anon_sym_EQ_LT] = ACTIONS(264),
    [anon_sym_LT] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(264),
    [anon_sym_GT] = ACTIONS(266),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(264),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(264),
    [anon_sym_andalso] = ACTIONS(266),
    [anon_sym_orelse] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(266),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_QMARK_EQ] = ACTIONS(264),
    [anon_sym_DOT_DOT] = ACTIONS(266),
    [anon_sym_PIPE_PIPE] = ACTIONS(264),
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_LT_DASH] = ACTIONS(264),
    [anon_sym_LT_EQ] = ACTIONS(264),
    [anon_sym_EQ_GT] = ACTIONS(264),
    [anon_sym_COLON_EQ] = ACTIONS(264),
    [anon_sym_fun] = ACTIONS(266),
    [anon_sym_begin] = ACTIONS(266),
    [anon_sym_case] = ACTIONS(266),
    [anon_sym_of] = ACTIONS(266),
    [anon_sym_receive] = ACTIONS(266),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_maybe] = ACTIONS(266),
    [anon_sym_DOLLAR] = ACTIONS(264),
    [aux_sym_integer_token1] = ACTIONS(266),
    [aux_sym_integer_token2] = ACTIONS(264),
    [sym_float] = ACTIONS(264),
    [sym__atom] = ACTIONS(266),
    [anon_sym_SQUOTE] = ACTIONS(264),
    [sym_variable] = ACTIONS(264),
    [anon_sym_QMARK] = ACTIONS(266),
    [anon_sym_DQUOTE] = ACTIONS(264),
    [sym_tripledot] = ACTIONS(264),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [119] = {
    [sym_comment] = STATE(119),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_LPAREN] = ACTIONS(260),
    [anon_sym_COLON] = ACTIONS(262),
    [anon_sym_when] = ACTIONS(262),
    [anon_sym_if] = ACTIONS(262),
    [anon_sym_LT_LT] = ACTIONS(260),
    [anon_sym_LBRACE] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(260),
    [anon_sym_POUND] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_not] = ACTIONS(262),
    [anon_sym_bnot] = ACTIONS(262),
    [anon_sym_catch] = ACTIONS(262),
    [anon_sym_SLASH] = ACTIONS(262),
    [anon_sym_STAR] = ACTIONS(260),
    [anon_sym_div] = ACTIONS(262),
    [anon_sym_rem] = ACTIONS(262),
    [anon_sym_band] = ACTIONS(262),
    [anon_sym_and] = ACTIONS(262),
    [anon_sym_bor] = ACTIONS(262),
    [anon_sym_bxor] = ACTIONS(262),
    [anon_sym_bsl] = ACTIONS(262),
    [anon_sym_bsr] = ACTIONS(262),
    [anon_sym_or] = ACTIONS(262),
    [anon_sym_xor] = ACTIONS(262),
    [anon_sym_PLUS_PLUS] = ACTIONS(260),
    [anon_sym_DASH_DASH] = ACTIONS(260),
    [anon_sym_EQ_EQ] = ACTIONS(260),
    [anon_sym_SLASH_EQ] = ACTIONS(260),
    [anon_sym_EQ_LT] = ACTIONS(260),
    [anon_sym_LT] = ACTIONS(262),
    [anon_sym_GT_EQ] = ACTIONS(260),
    [anon_sym_GT] = ACTIONS(262),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(260),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(260),
    [anon_sym_andalso] = ACTIONS(262),
    [anon_sym_orelse] = ACTIONS(262),
    [anon_sym_EQ] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(260),
    [anon_sym_QMARK_EQ] = ACTIONS(260),
    [anon_sym_DOT_DOT] = ACTIONS(262),
    [anon_sym_PIPE_PIPE] = ACTIONS(260),
    [anon_sym_COLON_COLON] = ACTIONS(260),
    [anon_sym_PIPE] = ACTIONS(262),
    [anon_sym_LT_DASH] = ACTIONS(260),
    [anon_sym_LT_EQ] = ACTIONS(260),
    [anon_sym_EQ_GT] = ACTIONS(260),
    [anon_sym_COLON_EQ] = ACTIONS(260),
    [anon_sym_fun] = ACTIONS(262),
    [anon_sym_begin] = ACTIONS(262),
    [anon_sym_case] = ACTIONS(262),
    [anon_sym_of] = ACTIONS(262),
    [anon_sym_receive] = ACTIONS(262),
    [anon_sym_try] = ACTIONS(262),
    [anon_sym_maybe] = ACTIONS(262),
    [anon_sym_DOLLAR] = ACTIONS(260),
    [aux_sym_integer_token1] = ACTIONS(262),
    [aux_sym_integer_token2] = ACTIONS(260),
    [sym_float] = ACTIONS(260),
    [sym__atom] = ACTIONS(262),
    [anon_sym_SQUOTE] = ACTIONS(260),
    [sym_variable] = ACTIONS(260),
    [anon_sym_QMARK] = ACTIONS(262),
    [anon_sym_DQUOTE] = ACTIONS(260),
    [sym_tripledot] = ACTIONS(260),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [120] = {
    [sym_comment] = STATE(120),
    [anon_sym_DASH] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(272),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_when] = ACTIONS(274),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(272),
    [anon_sym_POUND] = ACTIONS(272),
    [anon_sym_PLUS] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_bnot] = ACTIONS(274),
    [anon_sym_catch] = ACTIONS(274),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(272),
    [anon_sym_div] = ACTIONS(274),
    [anon_sym_rem] = ACTIONS(274),
    [anon_sym_band] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_bor] = ACTIONS(274),
    [anon_sym_bxor] = ACTIONS(274),
    [anon_sym_bsl] = ACTIONS(274),
    [anon_sym_bsr] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_xor] = ACTIONS(274),
    [anon_sym_PLUS_PLUS] = ACTIONS(272),
    [anon_sym_DASH_DASH] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_SLASH_EQ] = ACTIONS(272),
    [anon_sym_EQ_LT] = ACTIONS(272),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(272),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(272),
    [anon_sym_andalso] = ACTIONS(274),
    [anon_sym_orelse] = ACTIONS(274),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_BANG] = ACTIONS(272),
    [anon_sym_QMARK_EQ] = ACTIONS(272),
    [anon_sym_DOT_DOT] = ACTIONS(274),
    [anon_sym_PIPE_PIPE] = ACTIONS(272),
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_LT_DASH] = ACTIONS(272),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(272),
    [anon_sym_fun] = ACTIONS(274),
    [anon_sym_begin] = ACTIONS(274),
    [anon_sym_case] = ACTIONS(274),
    [anon_sym_of] = ACTIONS(274),
    [anon_sym_receive] = ACTIONS(274),
    [anon_sym_try] = ACTIONS(274),
    [anon_sym_maybe] = ACTIONS(274),
    [anon_sym_DOLLAR] = ACTIONS(272),
    [aux_sym_integer_token1] = ACTIONS(274),
    [aux_sym_integer_token2] = ACTIONS(272),
    [sym_float] = ACTIONS(272),
    [sym__atom] = ACTIONS(274),
    [anon_sym_SQUOTE] = ACTIONS(272),
    [sym_variable] = ACTIONS(272),
    [anon_sym_QMARK] = ACTIONS(274),
    [anon_sym_DQUOTE] = ACTIONS(272),
    [sym_tripledot] = ACTIONS(272),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [121] = {
    [sym_comment] = STATE(121),
    [anon_sym_DASH] = ACTIONS(270),
    [anon_sym_LPAREN] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(270),
    [anon_sym_when] = ACTIONS(270),
    [anon_sym_if] = ACTIONS(270),
    [anon_sym_LT_LT] = ACTIONS(268),
    [anon_sym_LBRACE] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(268),
    [anon_sym_POUND] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(270),
    [anon_sym_not] = ACTIONS(270),
    [anon_sym_bnot] = ACTIONS(270),
    [anon_sym_catch] = ACTIONS(270),
    [anon_sym_SLASH] = ACTIONS(270),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_div] = ACTIONS(270),
    [anon_sym_rem] = ACTIONS(270),
    [anon_sym_band] = ACTIONS(270),
    [anon_sym_and] = ACTIONS(270),
    [anon_sym_bor] = ACTIONS(270),
    [anon_sym_bxor] = ACTIONS(270),
    [anon_sym_bsl] = ACTIONS(270),
    [anon_sym_bsr] = ACTIONS(270),
    [anon_sym_or] = ACTIONS(270),
    [anon_sym_xor] = ACTIONS(270),
    [anon_sym_PLUS_PLUS] = ACTIONS(268),
    [anon_sym_DASH_DASH] = ACTIONS(268),
    [anon_sym_EQ_EQ] = ACTIONS(268),
    [anon_sym_SLASH_EQ] = ACTIONS(268),
    [anon_sym_EQ_LT] = ACTIONS(268),
    [anon_sym_LT] = ACTIONS(270),
    [anon_sym_GT_EQ] = ACTIONS(268),
    [anon_sym_GT] = ACTIONS(270),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(268),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(268),
    [anon_sym_andalso] = ACTIONS(270),
    [anon_sym_orelse] = ACTIONS(270),
    [anon_sym_EQ] = ACTIONS(270),
    [anon_sym_BANG] = ACTIONS(268),
    [anon_sym_QMARK_EQ] = ACTIONS(268),
    [anon_sym_DOT_DOT] = ACTIONS(270),
    [anon_sym_PIPE_PIPE] = ACTIONS(268),
    [anon_sym_COLON_COLON] = ACTIONS(268),
    [anon_sym_PIPE] = ACTIONS(270),
    [anon_sym_LT_DASH] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(268),
    [anon_sym_EQ_GT] = ACTIONS(268),
    [anon_sym_COLON_EQ] = ACTIONS(268),
    [anon_sym_fun] = ACTIONS(270),
    [anon_sym_begin] = ACTIONS(270),
    [anon_sym_case] = ACTIONS(270),
    [anon_sym_of] = ACTIONS(270),
    [anon_sym_receive] = ACTIONS(270),
    [anon_sym_try] = ACTIONS(270),
    [anon_sym_maybe] = ACTIONS(270),
    [anon_sym_DOLLAR] = ACTIONS(268),
    [aux_sym_integer_token1] = ACTIONS(270),
    [aux_sym_integer_token2] = ACTIONS(268),
    [sym_float] = ACTIONS(268),
    [sym__atom] = ACTIONS(270),
    [anon_sym_SQUOTE] = ACTIONS(268),
    [sym_variable] = ACTIONS(268),
    [anon_sym_QMARK] = ACTIONS(270),
    [anon_sym_DQUOTE] = ACTIONS(268),
    [sym_tripledot] = ACTIONS(268),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [122] = {
    [sym_comment] = STATE(122),
    [anon_sym_DASH] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(244),
    [anon_sym_COLON] = ACTIONS(246),
    [anon_sym_when] = ACTIONS(246),
    [anon_sym_if] = ACTIONS(246),
    [anon_sym_LT_LT] = ACTIONS(244),
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_LBRACK] = ACTIONS(244),
    [anon_sym_POUND] = ACTIONS(244),
    [anon_sym_PLUS] = ACTIONS(246),
    [anon_sym_not] = ACTIONS(246),
    [anon_sym_bnot] = ACTIONS(246),
    [anon_sym_catch] = ACTIONS(246),
    [anon_sym_SLASH] = ACTIONS(246),
    [anon_sym_STAR] = ACTIONS(244),
    [anon_sym_div] = ACTIONS(246),
    [anon_sym_rem] = ACTIONS(246),
    [anon_sym_band] = ACTIONS(246),
    [anon_sym_and] = ACTIONS(246),
    [anon_sym_bor] = ACTIONS(246),
    [anon_sym_bxor] = ACTIONS(246),
    [anon_sym_bsl] = ACTIONS(246),
    [anon_sym_bsr] = ACTIONS(246),
    [anon_sym_or] = ACTIONS(246),
    [anon_sym_xor] = ACTIONS(246),
    [anon_sym_PLUS_PLUS] = ACTIONS(244),
    [anon_sym_DASH_DASH] = ACTIONS(244),
    [anon_sym_EQ_EQ] = ACTIONS(244),
    [anon_sym_SLASH_EQ] = ACTIONS(244),
    [anon_sym_EQ_LT] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(246),
    [anon_sym_GT_EQ] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(246),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(244),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(244),
    [anon_sym_andalso] = ACTIONS(246),
    [anon_sym_orelse] = ACTIONS(246),
    [anon_sym_EQ] = ACTIONS(246),
    [anon_sym_BANG] = ACTIONS(244),
    [anon_sym_QMARK_EQ] = ACTIONS(244),
    [anon_sym_DOT_DOT] = ACTIONS(246),
    [anon_sym_PIPE_PIPE] = ACTIONS(244),
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(246),
    [anon_sym_LT_DASH] = ACTIONS(244),
    [anon_sym_LT_EQ] = ACTIONS(244),
    [anon_sym_EQ_GT] = ACTIONS(244),
    [anon_sym_COLON_EQ] = ACTIONS(244),
    [anon_sym_fun] = ACTIONS(246),
    [anon_sym_begin] = ACTIONS(246),
    [anon_sym_case] = ACTIONS(246),
    [anon_sym_of] = ACTIONS(246),
    [anon_sym_receive] = ACTIONS(246),
    [anon_sym_try] = ACTIONS(246),
    [anon_sym_maybe] = ACTIONS(246),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [aux_sym_integer_token1] = ACTIONS(246),
    [aux_sym_integer_token2] = ACTIONS(244),
    [sym_float] = ACTIONS(244),
    [sym__atom] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(244),
    [sym_variable] = ACTIONS(244),
    [anon_sym_QMARK] = ACTIONS(246),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [sym_tripledot] = ACTIONS(244),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [123] = {
    [sym_comment] = STATE(123),
    [anon_sym_DASH] = ACTIONS(282),
    [anon_sym_LPAREN] = ACTIONS(280),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_when] = ACTIONS(282),
    [anon_sym_if] = ACTIONS(282),
    [anon_sym_LT_LT] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_LBRACK] = ACTIONS(280),
    [anon_sym_POUND] = ACTIONS(280),
    [anon_sym_PLUS] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(282),
    [anon_sym_bnot] = ACTIONS(282),
    [anon_sym_catch] = ACTIONS(282),
    [anon_sym_SLASH] = ACTIONS(282),
    [anon_sym_STAR] = ACTIONS(280),
    [anon_sym_div] = ACTIONS(282),
    [anon_sym_rem] = ACTIONS(282),
    [anon_sym_band] = ACTIONS(282),
    [anon_sym_and] = ACTIONS(282),
    [anon_sym_bor] = ACTIONS(282),
    [anon_sym_bxor] = ACTIONS(282),
    [anon_sym_bsl] = ACTIONS(282),
    [anon_sym_bsr] = ACTIONS(282),
    [anon_sym_or] = ACTIONS(282),
    [anon_sym_xor] = ACTIONS(282),
    [anon_sym_PLUS_PLUS] = ACTIONS(280),
    [anon_sym_DASH_DASH] = ACTIONS(280),
    [anon_sym_EQ_EQ] = ACTIONS(280),
    [anon_sym_SLASH_EQ] = ACTIONS(280),
    [anon_sym_EQ_LT] = ACTIONS(280),
    [anon_sym_LT] = ACTIONS(282),
    [anon_sym_GT_EQ] = ACTIONS(280),
    [anon_sym_GT] = ACTIONS(282),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(280),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(280),
    [anon_sym_andalso] = ACTIONS(282),
    [anon_sym_orelse] = ACTIONS(282),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_BANG] = ACTIONS(280),
    [anon_sym_QMARK_EQ] = ACTIONS(280),
    [anon_sym_DOT_DOT] = ACTIONS(282),
    [anon_sym_PIPE_PIPE] = ACTIONS(280),
    [anon_sym_COLON_COLON] = ACTIONS(280),
    [anon_sym_PIPE] = ACTIONS(282),
    [anon_sym_LT_DASH] = ACTIONS(280),
    [anon_sym_LT_EQ] = ACTIONS(280),
    [anon_sym_EQ_GT] = ACTIONS(280),
    [anon_sym_COLON_EQ] = ACTIONS(280),
    [anon_sym_fun] = ACTIONS(282),
    [anon_sym_begin] = ACTIONS(282),
    [anon_sym_case] = ACTIONS(282),
    [anon_sym_of] = ACTIONS(282),
    [anon_sym_receive] = ACTIONS(282),
    [anon_sym_try] = ACTIONS(282),
    [anon_sym_maybe] = ACTIONS(282),
    [anon_sym_DOLLAR] = ACTIONS(280),
    [aux_sym_integer_token1] = ACTIONS(282),
    [aux_sym_integer_token2] = ACTIONS(280),
    [sym_float] = ACTIONS(280),
    [sym__atom] = ACTIONS(282),
    [anon_sym_SQUOTE] = ACTIONS(280),
    [sym_variable] = ACTIONS(280),
    [anon_sym_QMARK] = ACTIONS(282),
    [anon_sym_DQUOTE] = ACTIONS(280),
    [sym_tripledot] = ACTIONS(280),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [124] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1105),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_arguments] = STATE(1617),
    [sym__items] = STATE(1616),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(124),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_RPAREN] = ACTIONS(433),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [125] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1105),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_arguments] = STATE(1602),
    [sym__items] = STATE(1616),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(125),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(381),
    [anon_sym_RPAREN] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [126] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1583),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym__if_clause] = STATE(1479),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(126),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [127] = {
    [sym__expression_without_call] = STATE(961),
    [sym__expression] = STATE(959),
    [sym_parenthesized_expression] = STATE(963),
    [sym_bitstring] = STATE(962),
    [sym_tuple] = STATE(752),
    [sym_list] = STATE(752),
    [sym_map] = STATE(962),
    [sym_record] = STATE(962),
    [sym_unary_operator] = STATE(752),
    [sym_binary_operator] = STATE(962),
    [sym__literal] = STATE(1458),
    [sym_anonymous_function] = STATE(752),
    [sym_call] = STATE(961),
    [sym__qualified_function] = STATE(1489),
    [sym__unqualified_function] = STATE(1487),
    [sym_function_capture] = STATE(962),
    [sym_function_type] = STATE(962),
    [sym_block] = STATE(962),
    [sym_if] = STATE(962),
    [sym_case] = STATE(962),
    [sym_receive] = STATE(962),
    [sym_try] = STATE(752),
    [sym_maybe] = STATE(962),
    [sym_character] = STATE(759),
    [sym__number] = STATE(963),
    [sym_integer] = STATE(760),
    [sym__identifier] = STATE(755),
    [sym_atom] = STATE(5),
    [sym__quoted_atom] = STATE(53),
    [sym_macro] = STATE(16),
    [sym__macro_constant] = STATE(55),
    [sym__macro_call] = STATE(62),
    [sym__strings] = STATE(962),
    [sym_string] = STATE(733),
    [sym_comment] = STATE(127),
    [aux_sym__strings_repeat1] = STATE(715),
    [anon_sym_DASH] = ACTIONS(23),
    [anon_sym_define] = ACTIONS(437),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_spec] = ACTIONS(439),
    [anon_sym_callback] = ACTIONS(439),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_LT_LT] = ACTIONS(15),
    [anon_sym_LBRACE] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(366),
    [anon_sym_PLUS] = ACTIONS(23),
    [anon_sym_not] = ACTIONS(23),
    [anon_sym_bnot] = ACTIONS(23),
    [anon_sym_catch] = ACTIONS(25),
    [anon_sym_fun] = ACTIONS(127),
    [anon_sym_begin] = ACTIONS(29),
    [anon_sym_case] = ACTIONS(31),
    [anon_sym_receive] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_maybe] = ACTIONS(37),
    [anon_sym_DOLLAR] = ACTIONS(39),
    [aux_sym_integer_token1] = ACTIONS(41),
    [aux_sym_integer_token2] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [sym__atom] = ACTIONS(443),
    [anon_sym_SQUOTE] = ACTIONS(445),
    [sym_variable] = ACTIONS(447),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(55),
    [sym_tripledot] = ACTIONS(57),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [128] = {
    [sym_comment] = STATE(128),
    [anon_sym_DASH] = ACTIONS(250),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_when] = ACTIONS(250),
    [anon_sym_if] = ACTIONS(250),
    [anon_sym_LT_LT] = ACTIONS(248),
    [anon_sym_LBRACE] = ACTIONS(248),
    [anon_sym_LBRACK] = ACTIONS(248),
    [anon_sym_POUND] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(250),
    [anon_sym_not] = ACTIONS(250),
    [anon_sym_bnot] = ACTIONS(250),
    [anon_sym_catch] = ACTIONS(250),
    [anon_sym_SLASH] = ACTIONS(250),
    [anon_sym_STAR] = ACTIONS(248),
    [anon_sym_div] = ACTIONS(250),
    [anon_sym_rem] = ACTIONS(250),
    [anon_sym_band] = ACTIONS(250),
    [anon_sym_and] = ACTIONS(250),
    [anon_sym_bor] = ACTIONS(250),
    [anon_sym_bxor] = ACTIONS(250),
    [anon_sym_bsl] = ACTIONS(250),
    [anon_sym_bsr] = ACTIONS(250),
    [anon_sym_or] = ACTIONS(250),
    [anon_sym_xor] = ACTIONS(250),
    [anon_sym_PLUS_PLUS] = ACTIONS(248),
    [anon_sym_DASH_DASH] = ACTIONS(248),
    [anon_sym_EQ_EQ] = ACTIONS(248),
    [anon_sym_SLASH_EQ] = ACTIONS(248),
    [anon_sym_EQ_LT] = ACTIONS(248),
    [anon_sym_LT] = ACTIONS(250),
    [anon_sym_GT_EQ] = ACTIONS(248),
    [anon_sym_GT] = ACTIONS(250),
    [anon_sym_EQ_COLON_EQ] = ACTIONS(248),
    [anon_sym_EQ_SLASH_EQ] = ACTIONS(248),
    [anon_sym_andalso] = ACTIONS(250),
    [anon_sym_orelse] = ACTIONS(250),
    [anon_sym_EQ] = ACTIONS(250),
    [anon_sym_BANG] = ACTIONS(248),
    [anon_sym_QMARK_EQ] = ACTIONS(248),
    [anon_sym_DOT_DOT] = ACTIONS(250),
    [anon_sym_PIPE_PIPE] = ACTIONS(248),
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_PIPE] = ACTIONS(250),
    [anon_sym_LT_DASH] = ACTIONS(248),
    [anon_sym_LT_EQ] = ACTIONS(248),
    [anon_sym_EQ_GT] = ACTIONS(248),
    [anon_sym_COLON_EQ] = ACTIONS(248),
    [anon_sym_fun] = ACTIONS(250),
    [anon_sym_begin] = ACTIONS(250),
    [anon_sym_case] = ACTIONS(250),
    [anon_sym_of] = ACTIONS(250),
    [anon_sym_receive] = ACTIONS(250),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_maybe] = ACTIONS(250),
    [anon_sym_DOLLAR] = ACTIONS(248),
    [aux_sym_integer_token1] = ACTIONS(250),
    [aux_sym_integer_token2] = ACTIONS(248),
    [sym_float] = ACTIONS(248),
    [sym__atom] = ACTIONS(250),
    [anon_sym_SQUOTE] = ACTIONS(248),
    [sym_variable] = ACTIONS(248),
    [anon_sym_QMARK] = ACTIONS(250),
    [anon_sym_DQUOTE] = ACTIONS(248),
    [sym_tripledot] = ACTIONS(248),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [129] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1583),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym__if_clause] = STATE(1427),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(129),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [130] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1522),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(130),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [131] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1648),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(131),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(453),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [132] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1637),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(132),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_RBRACE] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [133] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1085),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1337),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(133),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [134] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1037),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1315),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(134),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [135] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1380),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(135),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [136] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1327),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(136),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [137] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1085),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1316),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(137),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [138] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1085),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1308),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(138),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [139] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1085),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1317),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(139),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [140] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(794),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1371),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(12),
    [sym__macro_constant] = STATE(51),
    [sym__macro_call] = STATE(60),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(140),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(200),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(200),
    [anon_sym_not] = ACTIONS(200),
    [anon_sym_bnot] = ACTIONS(200),
    [anon_sym_catch] = ACTIONS(457),
    [anon_sym_fun] = ACTIONS(459),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [141] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1085),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1315),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(141),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [142] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1085),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1319),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(142),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [143] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1033),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1316),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(143),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [144] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1033),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1308),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(144),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [145] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1033),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1317),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(145),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [146] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1033),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1315),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(146),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [147] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1590),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(147),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [148] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1033),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1319),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(148),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [149] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1582),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(149),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [150] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1033),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1327),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(150),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [151] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1581),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(151),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [152] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1580),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(152),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [153] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1576),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(153),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [154] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1376),
    [sym__items] = STATE(1502),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(154),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [155] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1085),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1327),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(155),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [156] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(794),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1380),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(12),
    [sym__macro_constant] = STATE(51),
    [sym__macro_call] = STATE(60),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(156),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(200),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(200),
    [anon_sym_not] = ACTIONS(200),
    [anon_sym_bnot] = ACTIONS(200),
    [anon_sym_catch] = ACTIONS(457),
    [anon_sym_fun] = ACTIONS(459),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [157] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1319),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(157),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [158] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1315),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(158),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [159] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1646),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(159),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(463),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [160] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1105),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1616),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(160),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [161] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1659),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(161),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [162] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1667),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(162),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [163] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1672),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(163),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [164] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1631),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(164),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(465),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [165] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1604),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(165),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [166] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1673),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(166),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [167] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1550),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(167),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [168] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1616),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(168),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [169] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1549),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(169),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [170] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1546),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(170),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_RBRACE] = ACTIONS(469),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [171] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1663),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(171),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [172] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1032),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1316),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(172),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [173] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1032),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1308),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(173),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [174] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1032),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1317),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(174),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [175] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1032),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1315),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(175),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [176] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1568),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(176),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_RBRACE] = ACTIONS(471),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [177] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1032),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1319),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(177),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [178] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1032),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1327),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(178),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [179] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1032),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1306),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(179),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [180] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1032),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1337),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(180),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [181] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1537),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(181),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(473),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [182] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1037),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1319),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(182),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [183] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1661),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(183),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [184] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1584),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(184),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [185] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1337),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(185),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [186] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1660),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(186),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [187] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1666),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(187),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [188] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1067),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1512),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(24),
    [sym__macro_constant] = STATE(77),
    [sym__macro_call] = STATE(108),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(188),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(222),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(222),
    [anon_sym_not] = ACTIONS(222),
    [anon_sym_bnot] = ACTIONS(222),
    [anon_sym_catch] = ACTIONS(224),
    [anon_sym_fun] = ACTIONS(475),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(477),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [189] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1475),
    [sym__items] = STATE(1505),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(189),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [190] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(775),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1341),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(9),
    [sym__macro_constant] = STATE(56),
    [sym__macro_call] = STATE(74),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(190),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_not] = ACTIONS(185),
    [anon_sym_bnot] = ACTIONS(185),
    [anon_sym_catch] = ACTIONS(479),
    [anon_sym_fun] = ACTIONS(481),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(483),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [191] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1376),
    [sym__items] = STATE(1525),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(191),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [192] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1536),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(192),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_RBRACE] = ACTIONS(485),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [193] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1085),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1306),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(193),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [194] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1116),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1544),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(194),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_end] = ACTIONS(487),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [195] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1592),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(195),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [196] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(931),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1380),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(13),
    [sym__macro_constant] = STATE(51),
    [sym__macro_call] = STATE(60),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(196),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(179),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(179),
    [anon_sym_not] = ACTIONS(179),
    [anon_sym_bnot] = ACTIONS(179),
    [anon_sym_catch] = ACTIONS(181),
    [anon_sym_fun] = ACTIONS(489),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [197] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1371),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(197),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [198] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1305),
    [sym__items] = STATE(1525),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(198),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [199] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1317),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(199),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [200] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1287),
    [sym__items] = STATE(1502),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(200),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [201] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1593),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(201),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [202] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1308),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(202),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [203] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1664),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(203),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [204] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1418),
    [sym__items] = STATE(1505),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(204),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [205] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1575),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(205),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_RBRACK] = ACTIONS(491),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [206] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1577),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(206),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [207] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1579),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(207),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_GT_GT] = ACTIONS(495),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [208] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1595),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(208),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [209] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1037),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1327),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(209),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [210] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1535),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(210),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_RBRACK] = ACTIONS(497),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [211] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1316),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(211),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [212] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1652),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(212),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(499),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [213] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1562),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(213),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(501),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [214] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1654),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(214),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [215] = {
    [sym_function] = STATE(1491),
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(996),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__named_stab_clause] = STATE(1471),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(818),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(17),
    [sym__macro_constant] = STATE(66),
    [sym__macro_call] = STATE(82),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(215),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(408),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [216] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1574),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(216),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [217] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1330),
    [sym__items] = STATE(1525),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(217),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [218] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1628),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(218),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [219] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1627),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(219),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_RBRACE] = ACTIONS(505),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [220] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1116),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1532),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(220),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_end] = ACTIONS(507),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [221] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1037),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1316),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(221),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [222] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1310),
    [sym__items] = STATE(1525),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(222),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [223] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1307),
    [sym__items] = STATE(1525),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(223),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [224] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1037),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1308),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(224),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [225] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1444),
    [sym__items] = STATE(1505),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(225),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [226] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1288),
    [sym__items] = STATE(1502),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(226),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [227] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1350),
    [sym__items] = STATE(1525),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(227),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [228] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1376),
    [sym__items] = STATE(1505),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(228),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [229] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1445),
    [sym__items] = STATE(1505),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(229),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [230] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1067),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1519),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(24),
    [sym__macro_constant] = STATE(77),
    [sym__macro_call] = STATE(108),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(230),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(222),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(222),
    [anon_sym_not] = ACTIONS(222),
    [anon_sym_bnot] = ACTIONS(222),
    [anon_sym_catch] = ACTIONS(224),
    [anon_sym_fun] = ACTIONS(475),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(477),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [231] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(775),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1329),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(9),
    [sym__macro_constant] = STATE(56),
    [sym__macro_call] = STATE(74),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(231),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_not] = ACTIONS(185),
    [anon_sym_bnot] = ACTIONS(185),
    [anon_sym_catch] = ACTIONS(479),
    [anon_sym_fun] = ACTIONS(481),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(483),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [232] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1563),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(232),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(509),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [233] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1037),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1317),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(233),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [234] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_guard] = STATE(1665),
    [sym__items] = STATE(1477),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(234),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [235] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1152),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym_clause] = STATE(1326),
    [sym__items] = STATE(1525),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(235),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [236] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(931),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1371),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(13),
    [sym__macro_constant] = STATE(51),
    [sym__macro_call] = STATE(60),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(236),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(179),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(179),
    [anon_sym_not] = ACTIONS(179),
    [anon_sym_bnot] = ACTIONS(179),
    [anon_sym_catch] = ACTIONS(181),
    [anon_sym_fun] = ACTIONS(489),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [237] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1039),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__body] = STATE(1306),
    [sym_body] = STATE(1283),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(19),
    [sym__macro_constant] = STATE(79),
    [sym__macro_call] = STATE(93),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(237),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(208),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_bnot] = ACTIONS(208),
    [anon_sym_catch] = ACTIONS(210),
    [anon_sym_fun] = ACTIONS(449),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [238] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1433),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(238),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [239] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(987),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1438),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(239),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [240] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(987),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1439),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(240),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [241] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1447),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(241),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [242] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(987),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1441),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1457),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(820),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(819),
    [sym__identifier] = STATE(817),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(23),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(242),
    [aux_sym__strings_repeat1] = STATE(713),
    [anon_sym_DASH] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(418),
    [anon_sym_PLUS] = ACTIONS(159),
    [anon_sym_not] = ACTIONS(159),
    [anon_sym_bnot] = ACTIONS(159),
    [anon_sym_catch] = ACTIONS(161),
    [anon_sym_fun] = ACTIONS(163),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [243] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(1017),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1526),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(20),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(243),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(214),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(214),
    [anon_sym_not] = ACTIONS(214),
    [anon_sym_bnot] = ACTIONS(214),
    [anon_sym_catch] = ACTIONS(216),
    [anon_sym_fun] = ACTIONS(410),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
  [244] = {
    [sym__expression_without_call] = STATE(677),
    [sym__expression] = STATE(741),
    [sym_parenthesized_expression] = STATE(649),
    [sym_bitstring] = STATE(676),
    [sym_tuple] = STATE(642),
    [sym_list] = STATE(642),
    [sym_map] = STATE(676),
    [sym_record] = STATE(676),
    [sym_unary_operator] = STATE(642),
    [sym_binary_operator] = STATE(676),
    [sym__literal] = STATE(1431),
    [sym_anonymous_function] = STATE(642),
    [sym__items] = STATE(1438),
    [sym_call] = STATE(677),
    [sym__qualified_function] = STATE(1513),
    [sym__unqualified_function] = STATE(1518),
    [sym_function_capture] = STATE(676),
    [sym_function_type] = STATE(676),
    [sym_block] = STATE(676),
    [sym_if] = STATE(676),
    [sym_case] = STATE(676),
    [sym_receive] = STATE(676),
    [sym_try] = STATE(642),
    [sym_maybe] = STATE(676),
    [sym_character] = STATE(678),
    [sym__number] = STATE(649),
    [sym_integer] = STATE(688),
    [sym__identifier] = STATE(648),
    [sym_atom] = STATE(643),
    [sym__quoted_atom] = STATE(627),
    [sym_macro] = STATE(2),
    [sym__macro_constant] = STATE(29),
    [sym__macro_call] = STATE(35),
    [sym__strings] = STATE(676),
    [sym_string] = STATE(635),
    [sym_comment] = STATE(244),
    [aux_sym__strings_repeat1] = STATE(618),
    [anon_sym_DASH] = ACTIONS(77),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_POUND] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(77),
    [anon_sym_not] = ACTIONS(77),
    [anon_sym_bnot] = ACTIONS(77),
    [anon_sym_catch] = ACTIONS(79),
    [anon_sym_fun] = ACTIONS(387),
    [anon_sym_begin] = ACTIONS(85),
    [anon_sym_case] = ACTIONS(87),
    [anon_sym_receive] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_maybe] = ACTIONS(93),
    [anon_sym_DOLLAR] = ACTIONS(95),
    [aux_sym_integer_token1] = ACTIONS(97),
    [aux_sym_integer_token2] = ACTIONS(99),
    [sym_float] = ACTIONS(101),
    [sym__atom] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(105),
    [sym_variable] = ACTIONS(107),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(393),
    [sym_tripledot] = ACTIONS(113),
    [aux_sym_comment_token1] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(210), 1,
      anon_sym_catch,
    ACTIONS(212), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(451), 1,
      anon_sym_QMARK,
    STATE(18), 1,
      sym_macro,
    STATE(79), 1,
      sym__macro_constant,
    STATE(93), 1,
      sym__macro_call,
    STATE(245), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(1004), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(208), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [153] = 45,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(216), 1,
      anon_sym_catch,
    ACTIONS(218), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(391), 1,
      anon_sym_QMARK,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    STATE(25), 1,
      sym_macro,
    STATE(29), 1,
      sym__macro_constant,
    STATE(35), 1,
      sym__macro_call,
    STATE(246), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(677), 1,
      sym_call,
    STATE(678), 1,
      sym_character,
    STATE(687), 1,
      sym__expression_without_call,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(1220), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(214), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [308] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(247), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(812), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [461] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(248), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(811), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [614] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(249), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(810), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [767] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(250), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(809), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [920] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(251), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(808), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1073] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(252), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(807), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1226] = 45,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(253), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(677), 1,
      sym_call,
    STATE(678), 1,
      sym_character,
    STATE(687), 1,
      sym__expression_without_call,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(1212), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1381] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(254), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(806), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1534] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(255), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(868), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1687] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(256), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(869), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1840] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(257), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(870), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [1993] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(258), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(871), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2146] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(259), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(872), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2299] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(260), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(874), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2452] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(261), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(886), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2605] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(79), 1,
      anon_sym_catch,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(387), 1,
      anon_sym_fun,
    ACTIONS(391), 1,
      anon_sym_QMARK,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_macro,
    STATE(29), 1,
      sym__macro_constant,
    STATE(35), 1,
      sym__macro_call,
    STATE(262), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1188), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(77), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2758] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(210), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(449), 1,
      anon_sym_fun,
    ACTIONS(451), 1,
      anon_sym_QMARK,
    STATE(19), 1,
      sym_macro,
    STATE(79), 1,
      sym__macro_constant,
    STATE(93), 1,
      sym__macro_call,
    STATE(263), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1117), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(208), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [2911] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(264), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(889), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3064] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(265), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(891), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3217] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(266), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(892), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3370] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(267), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(893), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3523] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(268), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(894), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3676] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(269), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(895), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3829] = 45,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(270), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(677), 1,
      sym_call,
    STATE(678), 1,
      sym_character,
    STATE(687), 1,
      sym__expression_without_call,
    STATE(688), 1,
      sym_integer,
    STATE(1217), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [3984] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(459), 1,
      anon_sym_fun,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(12), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(271), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(896), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4137] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(272), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(901), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4290] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(273), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(905), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4443] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(196), 1,
      anon_sym_catch,
    ACTIONS(391), 1,
      anon_sym_QMARK,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(418), 1,
      anon_sym_POUND,
    ACTIONS(420), 1,
      anon_sym_fun,
    STATE(11), 1,
      sym_macro,
    STATE(29), 1,
      sym__macro_constant,
    STATE(35), 1,
      sym__macro_call,
    STATE(274), 1,
      sym_comment,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(713), 1,
      aux_sym__strings_repeat1,
    STATE(817), 1,
      sym__identifier,
    STATE(819), 1,
      sym_integer,
    STATE(820), 1,
      sym_character,
    STATE(1050), 1,
      sym__expression,
    STATE(1441), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(194), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4596] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(275), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(913), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4749] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(276), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(915), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [4902] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(277), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(916), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5055] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(278), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(917), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5208] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(279), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(918), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5361] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(280), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(919), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5514] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(281), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(920), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5667] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(282), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(921), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5820] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(283), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(922), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [5973] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(284), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(923), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6126] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(285), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(924), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6279] = 45,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(286), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(677), 1,
      sym_call,
    STATE(678), 1,
      sym_character,
    STATE(687), 1,
      sym__expression_without_call,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(1214), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6434] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(183), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(6), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(287), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(925), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6587] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(288), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1072), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6740] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(289), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1073), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [6893] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(290), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1074), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7046] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(291), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1075), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7199] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(292), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(813), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7352] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(293), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1076), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7505] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(294), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(814), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7658] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(295), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1077), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7811] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(296), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1078), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [7964] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(297), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1079), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8117] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(298), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1080), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8270] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(299), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1081), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8423] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(300), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1082), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8576] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(301), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1083), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8729] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(302), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1084), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [8882] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(303), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(816), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9035] = 45,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(304), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(677), 1,
      sym_call,
    STATE(678), 1,
      sym_character,
    STATE(687), 1,
      sym__expression_without_call,
    STATE(688), 1,
      sym_integer,
    STATE(1219), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9190] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(181), 1,
      anon_sym_catch,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    ACTIONS(489), 1,
      anon_sym_fun,
    STATE(13), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(305), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(648), 1,
      sym__identifier,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(1086), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(649), 2,
      sym_parenthesized_expression,
      sym__number,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    ACTIONS(179), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(642), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9343] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(224), 1,
      anon_sym_catch,
    ACTIONS(226), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(477), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_macro,
    STATE(77), 1,
      sym__macro_constant,
    STATE(108), 1,
      sym__macro_call,
    STATE(306), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(1087), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(222), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9496] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(224), 1,
      anon_sym_catch,
    ACTIONS(226), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(477), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_macro,
    STATE(77), 1,
      sym__macro_constant,
    STATE(108), 1,
      sym__macro_call,
    STATE(307), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(1088), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(222), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9649] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(202), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(457), 1,
      anon_sym_catch,
    ACTIONS(461), 1,
      anon_sym_QMARK,
    STATE(15), 1,
      sym_macro,
    STATE(51), 1,
      sym__macro_constant,
    STATE(60), 1,
      sym__macro_call,
    STATE(308), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(825), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(200), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9802] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(224), 1,
      anon_sym_catch,
    ACTIONS(226), 1,
      anon_sym_fun,
    ACTIONS(385), 1,
      anon_sym_POUND,
    ACTIONS(393), 1,
      anon_sym_DQUOTE,
    ACTIONS(406), 1,
      anon_sym_LPAREN,
    ACTIONS(477), 1,
      anon_sym_QMARK,
    STATE(22), 1,
      sym_macro,
    STATE(77), 1,
      sym__macro_constant,
    STATE(108), 1,
      sym__macro_call,
    STATE(309), 1,
      sym_comment,
    STATE(618), 1,
      aux_sym__strings_repeat1,
    STATE(627), 1,
      sym__quoted_atom,
    STATE(635), 1,
      sym_string,
    STATE(643), 1,
      sym_atom,
    STATE(678), 1,
      sym_character,
    STATE(688), 1,
      sym_integer,
    STATE(689), 1,
      sym__identifier,
    STATE(1089), 1,
      sym__expression,
    STATE(1431), 1,
      sym__literal,
    STATE(1513), 1,
      sym__qualified_function,
    STATE(1518), 1,
      sym__unqualified_function,
    STATE(677), 2,
      sym__expression_without_call,
      sym_call,
    STATE(690), 2,
      sym_parenthesized_expression,
      sym__number,
    ACTIONS(222), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_bnot,
    STATE(641), 5,
      sym_tuple,
      sym_list,
      sym_unary_operator,
      sym_anonymous_function,
      sym_try,
    STATE(676), 12,
      sym_bitstring,
      sym_map,
      sym_record,
      sym_binary_operator,
      sym_function_capture,
      sym_function_type,
      sym_block,
      sym_if,
      sym_case,
      sym_receive,
      sym_maybe,
      sym__strings,
  [9955] = 44,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(69), 1,
      anon_sym_if,
    ACTIONS(71), 1,
      anon_sym_LT_LT,
    ACTIONS(73), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_begin,
    ACTIONS(87), 1,
      anon_sym_case,
    ACTIONS(89), 1,
      anon_sym_receive,
    ACTIONS(91), 1,
      anon_sym_try,
    ACTIONS(93), 1,
      anon_sym_maybe,
    ACTIONS(95), 1,
      anon_sym_DOLLAR,
    ACTIONS(97), 1,
      aux_sym_integer_token1,
    ACTIONS(99), 1,
      aux_sym_integer_token2,
    ACTIONS(101), 1,
      sym_float,
    ACTIONS(103), 1,
      sym__atom,
    ACTIONS(105), 1,
      anon_sym_SQUOTE,
    ACTIONS(107), 1,
      sym_variable,
    ACTIONS(113), 1,
      sym_tripledot,
    ACTIONS(224), 1,
      anon_sym_catch,
    ACTI