#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 417
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 129
#define ALIAS_COUNT 0
#define TOKEN_COUNT 60
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum {
  anon_sym_targetScope = 1,
  anon_sym_param = 2,
  anon_sym_var = 3,
  anon_sym_output = 4,
  anon_sym_resource = 5,
  anon_sym_existing = 6,
  anon_sym_module = 7,
  anon_sym_import = 8,
  anon_sym_from = 9,
  sym__assignment = 10,
  anon_sym_LPAREN = 11,
  anon_sym_RPAREN = 12,
  anon_sym_COMMA = 13,
  sym_nullLiteral = 14,
  anon_sym_true = 15,
  anon_sym_false = 16,
  sym_integerLiteral = 17,
  aux_sym_identifier_token1 = 18,
  anon_sym_LBRACE = 19,
  anon_sym_RBRACE = 20,
  anon_sym_COLON = 21,
  anon_sym_if = 22,
  anon_sym_LBRACK = 23,
  anon_sym_LF = 24,
  anon_sym_RBRACK = 25,
  anon_sym_SQUOTE = 26,
  anon_sym_DOLLAR = 27,
  sym_escapeSequence = 28,
  anon_sym_DOLLAR_LBRACE = 29,
  sym_stringLiteral = 30,
  anon_sym_SQUOTE_SQUOTE_SQUOTE = 31,
  aux_sym_multilineString_token1 = 32,
  sym_multilineStringLiteral = 33,
  anon_sym_for = 34,
  anon_sym_in = 35,
  anon_sym_AT = 36,
  anon_sym_DOT = 37,
  anon_sym_COLON_COLON = 38,
  anon_sym_STAR = 39,
  anon_sym_PERCENT = 40,
  anon_sym_SLASH = 41,
  anon_sym_PLUS = 42,
  anon_sym_DASH = 43,
  anon_sym_GT = 44,
  anon_sym_GT_EQ = 45,
  anon_sym_LT = 46,
  anon_sym_LT_EQ = 47,
  anon_sym_EQ_EQ = 48,
  anon_sym_BANG_EQ = 49,
  anon_sym_EQ_TILDE = 50,
  anon_sym_BANG_TILDE = 51,
  anon_sym_AMP_AMP = 52,
  anon_sym_PIPE_PIPE = 53,
  anon_sym_QMARK_QMARK = 54,
  anon_sym_QMARK = 55,
  anon_sym_BANG = 56,
  aux_sym_comment_token1 = 57,
  anon_sym_SLASH_STAR = 58,
  aux_sym_comment_token2 = 59,
  sym_program = 60,
  sym_statement = 61,
  sym__declaration = 62,
  sym_targetScope = 63,
  sym_parameterDeclaration = 64,
  sym_parameterDefaultValue = 65,
  sym_variableDeclaration = 66,
  sym_outputDeclaration = 67,
  sym_resourceDeclaration = 68,
  sym_moduleDeclaration = 69,
  sym_importDeclaration = 70,
  sym_type = 71,
  sym__expression = 72,
  sym__primaryExpression = 73,
  sym_variableAccess = 74,
  sym_localVariable = 75,
  sym_functionCall = 76,
  sym__arguments = 77,
  sym_functionArgument = 78,
  sym_parenthesizedExpression = 79,
  sym__literalValue = 80,
  sym_booleanLiteral = 81,
  sym_identifier = 82,
  sym_object = 83,
  sym_objectProperty = 84,
  sym_ifCondition = 85,
  sym_array = 86,
  sym_arrayItem = 87,
  sym_string = 88,
  sym__stringContent = 89,
  sym__interpolation = 90,
  sym_multilineString = 91,
  sym_for = 92,
  sym__forBody = 93,
  sym_forVariableBlock = 94,
  sym_decorator = 95,
  sym_binaryOperation = 96,
  sym__memberExpression = 97,
  sym_propertyAccess = 98,
  sym_arrayAccess = 99,
  sym_resourceAccess = 100,
  sym__multiplication = 101,
  sym__modulo = 102,
  sym__division = 103,
  sym__addition = 104,
  sym__subtraction = 105,
  sym__greaterThan = 106,
  sym__greaterThanOrEqual = 107,
  sym__lessThan = 108,
  sym__lessThanOrEqual = 109,
  sym__equals = 110,
  sym__notEquals = 111,
  sym__equalsInsensitive = 112,
  sym__notEqualsInsensitive = 113,
  sym__logicalAnd = 114,
  sym__logicalOr = 115,
  sym__coalesce = 116,
  sym_ternaryOperation = 117,
  sym__conditionalExpression = 118,
  sym_unaryOperation = 119,
  sym__negation = 120,
  sym__minus = 121,
  sym_comment = 122,
  aux_sym_program_repeat1 = 123,
  aux_sym_statement_repeat1 = 124,
  aux_sym__arguments_repeat1 = 125,
  aux_sym_object_repeat1 = 126,
  aux_sym_array_repeat1 = 127,
  aux_sym__stringContent_repeat1 = 128,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_targetScope] = "targetScope",
  [anon_sym_param] = "param",
  [anon_sym_var] = "var",
  [anon_sym_output] = "output",
  [anon_sym_resource] = "resource",
  [anon_sym_existing] = "existing",
  [anon_sym_module] = "module",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [sym__assignment] = "_assignment",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [sym_nullLiteral] = "nullLiteral",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_integerLiteral] = "integerLiteral",
  [aux_sym_identifier_token1] = "identifier_token1",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COLON] = ":",
  [anon_sym_if] = "if",
  [anon_sym_LBRACK] = "[",
  [anon_sym_LF] = "\n",
  [anon_sym_RBRACK] = "]",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DOLLAR] = "$",
  [sym_escapeSequence] = "escapeSequence",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [sym_stringLiteral] = "stringLiteral",
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = "'''",
  [aux_sym_multilineString_token1] = "multilineString_token1",
  [sym_multilineStringLiteral] = "stringLiteral",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_AT] = "@",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_STAR] = "*",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH] = "/",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_BANG_TILDE] = "!~",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_QMARK] = "\?",
  [anon_sym_BANG] = "!",
  [aux_sym_comment_token1] = "comment_token1",
  [anon_sym_SLASH_STAR] = "/*",
  [aux_sym_comment_token2] = "comment_token2",
  [sym_program] = "program",
  [sym_statement] = "statement",
  [sym__declaration] = "_declaration",
  [sym_targetScope] = "targetScope",
  [sym_parameterDeclaration] = "parameterDeclaration",
  [sym_parameterDefaultValue] = "parameterDefaultValue",
  [sym_variableDeclaration] = "variableDeclaration",
  [sym_outputDeclaration] = "outputDeclaration",
  [sym_resourceDeclaration] = "resourceDeclaration",
  [sym_moduleDeclaration] = "moduleDeclaration",
  [sym_importDeclaration] = "importDeclaration",
  [sym_type] = "type",
  [sym__expression] = "_expression",
  [sym__primaryExpression] = "_primaryExpression",
  [sym_variableAccess] = "variableAccess",
  [sym_localVariable] = "localVariable",
  [sym_functionCall] = "functionCall",
  [sym__arguments] = "_arguments",
  [sym_functionArgument] = "functionArgument",
  [sym_parenthesizedExpression] = "parenthesizedExpression",
  [sym__literalValue] = "_literalValue",
  [sym_booleanLiteral] = "booleanLiteral",
  [sym_identifier] = "identifier",
  [sym_object] = "object",
  [sym_objectProperty] = "objectProperty",
  [sym_ifCondition] = "ifCondition",
  [sym_array] = "array",
  [sym_arrayItem] = "arrayItem",
  [sym_string] = "string",
  [sym__stringContent] = "_stringContent",
  [sym__interpolation] = "_interpolation",
  [sym_multilineString] = "string",
  [sym_for] = "for",
  [sym__forBody] = "_forBody",
  [sym_forVariableBlock] = "forVariableBlock",
  [sym_decorator] = "decorator",
  [sym_binaryOperation] = "binaryOperation",
  [sym__memberExpression] = "_memberExpression",
  [sym_propertyAccess] = "propertyAccess",
  [sym_arrayAccess] = "arrayAccess",
  [sym_resourceAccess] = "resourceAccess",
  [sym__multiplication] = "_multiplication",
  [sym__modulo] = "_modulo",
  [sym__division] = "_division",
  [sym__addition] = "_addition",
  [sym__subtraction] = "_subtraction",
  [sym__greaterThan] = "_greaterThan",
  [sym__greaterThanOrEqual] = "_greaterThanOrEqual",
  [sym__lessThan] = "_lessThan",
  [sym__lessThanOrEqual] = "_lessThanOrEqual",
  [sym__equals] = "_equals",
  [sym__notEquals] = "_notEquals",
  [sym__equalsInsensitive] = "_equalsInsensitive",
  [sym__notEqualsInsensitive] = "_notEqualsInsensitive",
  [sym__logicalAnd] = "_logicalAnd",
  [sym__logicalOr] = "_logicalOr",
  [sym__coalesce] = "_coalesce",
  [sym_ternaryOperation] = "ternaryOperation",
  [sym__conditionalExpression] = "_conditionalExpression",
  [sym_unaryOperation] = "unaryOperation",
  [sym__negation] = "_negation",
  [sym__minus] = "_minus",
  [sym_comment] = "comment",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_statement_repeat1] = "statement_repeat1",
  [aux_sym__arguments_repeat1] = "_arguments_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym__stringContent_repeat1] = "_stringContent_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_targetScope] = anon_sym_targetScope,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_output] = anon_sym_output,
  [anon_sym_resource] = anon_sym_resource,
  [anon_sym_existing] = anon_sym_existing,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [sym__assignment] = sym__assignment,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym_nullLiteral] = sym_nullLiteral,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_integerLiteral] = sym_integerLiteral,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym_escapeSequence] = sym_escapeSequence,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [sym_stringLiteral] = sym_stringLiteral,
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE_SQUOTE,
  [aux_sym_multilineString_token1] = aux_sym_multilineString_token1,
  [sym_multilineStringLiteral] = sym_stringLiteral,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_BANG_TILDE] = anon_sym_BANG_TILDE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_BANG] = anon_sym_BANG,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [anon_sym_SLASH_STAR] = anon_sym_SLASH_STAR,
  [aux_sym_comment_token2] = aux_sym_comment_token2,
  [sym_program] = sym_program,
  [sym_statement] = sym_statement,
  [sym__declaration] = sym__declaration,
  [sym_targetScope] = sym_targetScope,
  [sym_parameterDeclaration] = sym_parameterDeclaration,
  [sym_parameterDefaultValue] = sym_parameterDefaultValue,
  [sym_variableDeclaration] = sym_variableDeclaration,
  [sym_outputDeclaration] = sym_outputDeclaration,
  [sym_resourceDeclaration] = sym_resourceDeclaration,
  [sym_moduleDeclaration] = sym_moduleDeclaration,
  [sym_importDeclaration] = sym_importDeclaration,
  [sym_type] = sym_type,
  [sym__expression] = sym__expression,
  [sym__primaryExpression] = sym__primaryExpression,
  [sym_variableAccess] = sym_variableAccess,
  [sym_localVariable] = sym_localVariable,
  [sym_functionCall] = sym_functionCall,
  [sym__arguments] = sym__arguments,
  [sym_functionArgument] = sym_functionArgument,
  [sym_parenthesizedExpression] = sym_parenthesizedExpression,
  [sym__literalValue] = sym__literalValue,
  [sym_booleanLiteral] = sym_booleanLiteral,
  [sym_identifier] = sym_identifier,
  [sym_object] = sym_object,
  [sym_objectProperty] = sym_objectProperty,
  [sym_ifCondition] = sym_ifCondition,
  [sym_array] = sym_array,
  [sym_arrayItem] = sym_arrayItem,
  [sym_string] = sym_string,
  [sym__stringContent] = sym__stringContent,
  [sym__interpolation] = sym__interpolation,
  [sym_multilineString] = sym_string,
  [sym_for] = sym_for,
  [sym__forBody] = sym__forBody,
  [sym_forVariableBlock] = sym_forVariableBlock,
  [sym_decorator] = sym_decorator,
  [sym_binaryOperation] = sym_binaryOperation,
  [sym__memberExpression] = sym__memberExpression,
  [sym_propertyAccess] = sym_propertyAccess,
  [sym_arrayAccess] = sym_arrayAccess,
  [sym_resourceAccess] = sym_resourceAccess,
  [sym__multiplication] = sym__multiplication,
  [sym__modulo] = sym__modulo,
  [sym__division] = sym__division,
  [sym__addition] = sym__addition,
  [sym__subtraction] = sym__subtraction,
  [sym__greaterThan] = sym__greaterThan,
  [sym__greaterThanOrEqual] = sym__greaterThanOrEqual,
  [sym__lessThan] = sym__lessThan,
  [sym__lessThanOrEqual] = sym__lessThanOrEqual,
  [sym__equals] = sym__equals,
  [sym__notEquals] = sym__notEquals,
  [sym__equalsInsensitive] = sym__equalsInsensitive,
  [sym__notEqualsInsensitive] = sym__notEqualsInsensitive,
  [sym__logicalAnd] = sym__logicalAnd,
  [sym__logicalOr] = sym__logicalOr,
  [sym__coalesce] = sym__coalesce,
  [sym_ternaryOperation] = sym_ternaryOperation,
  [sym__conditionalExpression] = sym__conditionalExpression,
  [sym_unaryOperation] = sym_unaryOperation,
  [sym__negation] = sym__negation,
  [sym__minus] = sym__minus,
  [sym_comment] = sym_comment,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_statement_repeat1] = aux_sym_statement_repeat1,
  [aux_sym__arguments_repeat1] = aux_sym__arguments_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym__stringContent_repeat1] = aux_sym__stringContent_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_targetScope] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_output] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_resource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_existing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [sym__assignment] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_nullLiteral] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_integerLiteral] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym_escapeSequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_stringLiteral] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_multilineString_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_multilineStringLiteral] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_targetScope] = {
    .visible = true,
    .named = true,
  },
  [sym_parameterDeclaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameterDefaultValue] = {
    .visible = true,
    .named = true,
  },
  [sym_variableDeclaration] = {
    .visible = true,
    .named = true,
  },
  [sym_outputDeclaration] = {
    .visible = true,
    .named = true,
  },
  [sym_resourceDeclaration] = {
    .visible = true,
    .named = true,
  },
  [sym_moduleDeclaration] = {
    .visible = true,
    .named = true,
  },
  [sym_importDeclaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__primaryExpression] = {
    .visible = false,
    .named = true,
  },
  [sym_variableAccess] = {
    .visible = true,
    .named = true,
  },
  [sym_localVariable] = {
    .visible = true,
    .named = true,
  },
  [sym_functionCall] = {
    .visible = true,
    .named = true,
  },
  [sym__arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_functionArgument] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesizedExpression] = {
    .visible = true,
    .named = true,
  },
  [sym__literalValue] = {
    .visible = false,
    .named = true,
  },
  [sym_booleanLiteral] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_objectProperty] = {
    .visible = true,
    .named = true,
  },
  [sym_ifCondition] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_arrayItem] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__stringContent] = {
    .visible = false,
    .named = true,
  },
  [sym__interpolation] = {
    .visible = false,
    .named = true,
  },
  [sym_multilineString] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym__forBody] = {
    .visible = false,
    .named = true,
  },
  [sym_forVariableBlock] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_binaryOperation] = {
    .visible = true,
    .named = true,
  },
  [sym__memberExpression] = {
    .visible = false,
    .named = true,
  },
  [sym_propertyAccess] = {
    .visible = true,
    .named = true,
  },
  [sym_arrayAccess] = {
    .visible = true,
    .named = true,
  },
  [sym_resourceAccess] = {
    .visible = true,
    .named = true,
  },
  [sym__multiplication] = {
    .visible = false,
    .named = true,
  },
  [sym__modulo] = {
    .visible = false,
    .named = true,
  },
  [sym__division] = {
    .visible = false,
    .named = true,
  },
  [sym__addition] = {
    .visible = false,
    .named = true,
  },
  [sym__subtraction] = {
    .visible = false,
    .named = true,
  },
  [sym__greaterThan] = {
    .visible = false,
    .named = true,
  },
  [sym__greaterThanOrEqual] = {
    .visible = false,
    .named = true,
  },
  [sym__lessThan] = {
    .visible = false,
    .named = true,
  },
  [sym__lessThanOrEqual] = {
    .visible = false,
    .named = true,
  },
  [sym__equals] = {
    .visible = false,
    .named = true,
  },
  [sym__notEquals] = {
    .visible = false,
    .named = true,
  },
  [sym__equalsInsensitive] = {
    .visible = false,
    .named = true,
  },
  [sym__notEqualsInsensitive] = {
    .visible = false,
    .named = true,
  },
  [sym__logicalAnd] = {
    .visible = false,
    .named = true,
  },
  [sym__logicalOr] = {
    .visible = false,
    .named = true,
  },
  [sym__coalesce] = {
    .visible = false,
    .named = true,
  },
  [sym_ternaryOperation] = {
    .visible = true,
    .named = true,
  },
  [sym__conditionalExpression] = {
    .visible = false,
    .named = true,
  },
  [sym_unaryOperation] = {
    .visible = true,
    .named = true,
  },
  [sym__negation] = {
    .visible = false,
    .named = true,
  },
  [sym__minus] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__stringContent_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 6,
  [10] = 7,
  [11] = 5,
  [12] = 12,
  [13] = 12,
  [14] = 6,
  [15] = 7,
  [16] = 5,
  [17] = 12,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 22,
  [27] = 24,
  [28] = 28,
  [29] = 29,
  [30] = 20,
  [31] = 31,
  [32] = 24,
  [33] = 33,
  [34] = 19,
  [35] = 35,
  [36] = 29,
  [37] = 20,
  [38] = 38,
  [39] = 39,
  [40] = 31,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 25,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 33,
  [50] = 19,
  [51] = 41,
  [52] = 42,
  [53] = 53,
  [54] = 43,
  [55] = 44,
  [56] = 56,
  [57] = 25,
  [58] = 46,
  [59] = 47,
  [60] = 48,
  [61] = 53,
  [62] = 62,
  [63] = 62,
  [64] = 64,
  [65] = 39,
  [66] = 38,
  [67] = 64,
  [68] = 35,
  [69] = 29,
  [70] = 70,
  [71] = 35,
  [72] = 72,
  [73] = 31,
  [74] = 33,
  [75] = 19,
  [76] = 39,
  [77] = 77,
  [78] = 22,
  [79] = 41,
  [80] = 42,
  [81] = 64,
  [82] = 62,
  [83] = 53,
  [84] = 48,
  [85] = 47,
  [86] = 46,
  [87] = 25,
  [88] = 44,
  [89] = 43,
  [90] = 42,
  [91] = 41,
  [92] = 38,
  [93] = 33,
  [94] = 31,
  [95] = 20,
  [96] = 29,
  [97] = 21,
  [98] = 98,
  [99] = 43,
  [100] = 70,
  [101] = 101,
  [102] = 21,
  [103] = 21,
  [104] = 46,
  [105] = 47,
  [106] = 101,
  [107] = 107,
  [108] = 48,
  [109] = 53,
  [110] = 70,
  [111] = 62,
  [112] = 64,
  [113] = 39,
  [114] = 101,
  [115] = 38,
  [116] = 44,
  [117] = 35,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 142,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 149,
  [169] = 160,
  [170] = 151,
  [171] = 152,
  [172] = 154,
  [173] = 153,
  [174] = 144,
  [175] = 145,
  [176] = 155,
  [177] = 157,
  [178] = 150,
  [179] = 158,
  [180] = 148,
  [181] = 159,
  [182] = 156,
  [183] = 165,
  [184] = 163,
  [185] = 162,
  [186] = 161,
  [187] = 138,
  [188] = 162,
  [189] = 137,
  [190] = 141,
  [191] = 136,
  [192] = 128,
  [193] = 121,
  [194] = 132,
  [195] = 140,
  [196] = 118,
  [197] = 139,
  [198] = 127,
  [199] = 120,
  [200] = 145,
  [201] = 144,
  [202] = 153,
  [203] = 152,
  [204] = 151,
  [205] = 150,
  [206] = 149,
  [207] = 148,
  [208] = 165,
  [209] = 163,
  [210] = 158,
  [211] = 161,
  [212] = 154,
  [213] = 156,
  [214] = 159,
  [215] = 160,
  [216] = 119,
  [217] = 135,
  [218] = 134,
  [219] = 133,
  [220] = 122,
  [221] = 131,
  [222] = 130,
  [223] = 129,
  [224] = 126,
  [225] = 125,
  [226] = 124,
  [227] = 123,
  [228] = 155,
  [229] = 157,
  [230] = 230,
  [231] = 231,
  [232] = 140,
  [233] = 152,
  [234] = 234,
  [235] = 130,
  [236] = 236,
  [237] = 156,
  [238] = 234,
  [239] = 131,
  [240] = 240,
  [241] = 241,
  [242] = 241,
  [243] = 136,
  [244] = 141,
  [245] = 122,
  [246] = 126,
  [247] = 234,
  [248] = 138,
  [249] = 137,
  [250] = 142,
  [251] = 129,
  [252] = 125,
  [253] = 154,
  [254] = 254,
  [255] = 255,
  [256] = 241,
  [257] = 128,
  [258] = 121,
  [259] = 132,
  [260] = 161,
  [261] = 118,
  [262] = 139,
  [263] = 127,
  [264] = 120,
  [265] = 124,
  [266] = 123,
  [267] = 162,
  [268] = 240,
  [269] = 163,
  [270] = 240,
  [271] = 165,
  [272] = 148,
  [273] = 149,
  [274] = 150,
  [275] = 151,
  [276] = 240,
  [277] = 153,
  [278] = 144,
  [279] = 279,
  [280] = 145,
  [281] = 155,
  [282] = 282,
  [283] = 282,
  [284] = 255,
  [285] = 282,
  [286] = 255,
  [287] = 159,
  [288] = 160,
  [289] = 119,
  [290] = 135,
  [291] = 134,
  [292] = 133,
  [293] = 158,
  [294] = 157,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 306,
  [311] = 306,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 314,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 314,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 323,
  [325] = 325,
  [326] = 325,
  [327] = 323,
  [328] = 325,
  [329] = 329,
  [330] = 329,
  [331] = 331,
  [332] = 332,
  [333] = 331,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 301,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 304,
  [343] = 305,
  [344] = 344,
  [345] = 345,
  [346] = 345,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 345,
  [354] = 349,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 349,
  [361] = 361,
  [362] = 349,
  [363] = 345,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 367,
  [370] = 370,
  [371] = 368,
  [372] = 366,
  [373] = 364,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 385,
  [387] = 384,
  [388] = 388,
  [389] = 381,
  [390] = 385,
  [391] = 391,
  [392] = 392,
  [393] = 381,
  [394] = 394,
  [395] = 384,
  [396] = 388,
  [397] = 388,
  [398] = 398,
  [399] = 379,
  [400] = 378,
  [401] = 401,
  [402] = 402,
  [403] = 377,
  [404] = 404,
  [405] = 405,
  [406] = 392,
  [407] = 379,
  [408] = 378,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 377,
  [414] = 375,
  [415] = 415,
  [416] = 416,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(93);
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '$') ADVANCE(149);
      if (lookahead == '%') ADVANCE(172);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '\'') ADVANCE(147);
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == ')') ADVANCE(107);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(108);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '.') ADVANCE(169);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == ':') ADVANCE(140);
      if (lookahead == '<') ADVANCE(179);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(177);
      if (lookahead == '?') ADVANCE(188);
      if (lookahead == '@') ADVANCE(168);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == '\\') ADVANCE(86);
      if (lookahead == ']') ADVANCE(145);
      if (lookahead == 'e') ADVANCE(82);
      if (lookahead == 'f') ADVANCE(23);
      if (lookahead == 'i') ADVANCE(39);
      if (lookahead == 'm') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead == 'o') ADVANCE(76);
      if (lookahead == 'p') ADVANCE(24);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 't') ADVANCE(27);
      if (lookahead == 'v') ADVANCE(28);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(89)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(144);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '%') ADVANCE(172);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == '-') ADVANCE(175);
      if (lookahead == '.') ADVANCE(169);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == ':') ADVANCE(19);
      if (lookahead == '<') ADVANCE(179);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(177);
      if (lookahead == '?') ADVANCE(188);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '\'') ADVANCE(147);
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == ')') ADVANCE(107);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == ']') ADVANCE(145);
      if (lookahead == 'f') ADVANCE(117);
      if (lookahead == 'n') ADVANCE(135);
      if (lookahead == 'r') ADVANCE(119);
      if (lookahead == 't') ADVANCE(131);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '\'') ADVANCE(147);
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == ']') ADVANCE(145);
      if (lookahead == 'f') ADVANCE(116);
      if (lookahead == 'n') ADVANCE(135);
      if (lookahead == 'r') ADVANCE(119);
      if (lookahead == 't') ADVANCE(131);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '\'') ADVANCE(147);
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == 'f') ADVANCE(117);
      if (lookahead == 'i') ADVANCE(123);
      if (lookahead == 'n') ADVANCE(135);
      if (lookahead == 'r') ADVANCE(119);
      if (lookahead == 't') ADVANCE(131);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '%') ADVANCE(172);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '\'') ADVANCE(146);
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == ')') ADVANCE(107);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(108);
      if (lookahead == '-') ADVANCE(175);
      if (lookahead == '.') ADVANCE(169);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == ':') ADVANCE(140);
      if (lookahead == '<') ADVANCE(179);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(177);
      if (lookahead == '?') ADVANCE(188);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == ']') ADVANCE(145);
      if (lookahead == 'r') ADVANCE(119);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '%') ADVANCE(172);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '\'') ADVANCE(146);
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == '-') ADVANCE(175);
      if (lookahead == '.') ADVANCE(169);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == ':') ADVANCE(19);
      if (lookahead == '<') ADVANCE(179);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(177);
      if (lookahead == '?') ADVANCE(188);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == 'r') ADVANCE(119);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 7:
      if (lookahead == '$') ADVANCE(148);
      if (lookahead == '\'') ADVANCE(146);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == '\\') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(152);
      if (lookahead != 0) ADVANCE(155);
      END_STATE();
    case 8:
      if (lookahead == '$') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '{') ADVANCE(155);
      END_STATE();
    case 9:
      if (lookahead == '&') ADVANCE(185);
      END_STATE();
    case 10:
      if (lookahead == '\'') ADVANCE(158);
      END_STATE();
    case 11:
      if (lookahead == '\'') ADVANCE(159);
      END_STATE();
    case 12:
      if (lookahead == '\'') ADVANCE(88);
      if (lookahead != 0) ADVANCE(162);
      END_STATE();
    case 13:
      if (lookahead == '\'') ADVANCE(11);
      END_STATE();
    case 14:
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == 'i') ADVANCE(127);
      if (lookahead == 'r') ADVANCE(119);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 15:
      if (lookahead == '*') ADVANCE(197);
      if (lookahead == '/') ADVANCE(196);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(199);
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(199);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '/') ADVANCE(195);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == ':') ADVANCE(170);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(182);
      if (lookahead == '~') ADVANCE(184);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(181);
      if (lookahead == '~') ADVANCE(183);
      END_STATE();
    case 22:
      if (lookahead == 'S') ADVANCE(29);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(46);
      if (lookahead == 'o') ADVANCE(61);
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(66);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(51);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(62);
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(63);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(55);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(36);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(79);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(113);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 39:
      if (lookahead == 'f') ADVANCE(141);
      if (lookahead == 'm') ADVANCE(58);
      if (lookahead == 'n') ADVANCE(166);
      END_STATE();
    case 40:
      if (lookahead == 'g') ADVANCE(100);
      END_STATE();
    case 41:
      if (lookahead == 'g') ADVANCE(38);
      END_STATE();
    case 42:
      if (lookahead == 'i') ADVANCE(52);
      END_STATE();
    case 43:
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(109);
      END_STATE();
    case 45:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(69);
      END_STATE();
    case 47:
      if (lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 48:
      if (lookahead == 'm') ADVANCE(58);
      END_STATE();
    case 49:
      if (lookahead == 'm') ADVANCE(58);
      if (lookahead == 'n') ADVANCE(166);
      END_STATE();
    case 50:
      if (lookahead == 'm') ADVANCE(103);
      END_STATE();
    case 51:
      if (lookahead == 'm') ADVANCE(95);
      END_STATE();
    case 52:
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 53:
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 54:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 55:
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 56:
      if (lookahead == 'o') ADVANCE(81);
      END_STATE();
    case 57:
      if (lookahead == 'o') ADVANCE(67);
      END_STATE();
    case 58:
      if (lookahead == 'p') ADVANCE(57);
      END_STATE();
    case 59:
      if (lookahead == 'p') ADVANCE(80);
      END_STATE();
    case 60:
      if (lookahead == 'p') ADVANCE(37);
      END_STATE();
    case 61:
      if (lookahead == 'r') ADVANCE(164);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 63:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 64:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 65:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 68:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 69:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(56);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(22);
      END_STATE();
    case 74:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 76:
      if (lookahead == 'u') ADVANCE(75);
      END_STATE();
    case 77:
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 78:
      if (lookahead == 'u') ADVANCE(45);
      END_STATE();
    case 79:
      if (lookahead == 'u') ADVANCE(47);
      END_STATE();
    case 80:
      if (lookahead == 'u') ADVANCE(72);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(64);
      END_STATE();
    case 82:
      if (lookahead == 'x') ADVANCE(43);
      END_STATE();
    case 83:
      if (lookahead == '{') ADVANCE(87);
      END_STATE();
    case 84:
      if (lookahead == '|') ADVANCE(186);
      END_STATE();
    case 85:
      if (lookahead == '}') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(85);
      END_STATE();
    case 86:
      if (lookahead == '$' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(150);
      if (lookahead == 'u') ADVANCE(83);
      END_STATE();
    case 87:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(85);
      END_STATE();
    case 88:
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(162);
      END_STATE();
    case 89:
      if (eof) ADVANCE(93);
      if (lookahead == '!') ADVANCE(190);
      if (lookahead == '$') ADVANCE(149);
      if (lookahead == '%') ADVANCE(172);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '\'') ADVANCE(147);
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == ')') ADVANCE(107);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(108);
      if (lookahead == '-') ADVANCE(176);
      if (lookahead == '.') ADVANCE(169);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == ':') ADVANCE(140);
      if (lookahead == '<') ADVANCE(179);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(177);
      if (lookahead == '?') ADVANCE(188);
      if (lookahead == '@') ADVANCE(168);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == ']') ADVANCE(145);
      if (lookahead == 'e') ADVANCE(82);
      if (lookahead == 'f') ADVANCE(23);
      if (lookahead == 'i') ADVANCE(39);
      if (lookahead == 'm') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(78);
      if (lookahead == 'o') ADVANCE(76);
      if (lookahead == 'p') ADVANCE(24);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 't') ADVANCE(27);
      if (lookahead == 'v') ADVANCE(28);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(89)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 90:
      if (eof) ADVANCE(93);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '%') ADVANCE(172);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '\'') ADVANCE(146);
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == ')') ADVANCE(107);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(108);
      if (lookahead == '-') ADVANCE(175);
      if (lookahead == '.') ADVANCE(169);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == ':') ADVANCE(140);
      if (lookahead == '<') ADVANCE(179);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(177);
      if (lookahead == '?') ADVANCE(188);
      if (lookahead == '@') ADVANCE(168);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == ']') ADVANCE(145);
      if (lookahead == 'e') ADVANCE(82);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'i') ADVANCE(49);
      if (lookahead == 'm') ADVANCE(53);
      if (lookahead == 'o') ADVANCE(76);
      if (lookahead == 'p') ADVANCE(24);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 't') ADVANCE(26);
      if (lookahead == 'v') ADVANCE(28);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(90)
      END_STATE();
    case 91:
      if (eof) ADVANCE(93);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '%') ADVANCE(172);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '\'') ADVANCE(13);
      if (lookahead == '(') ADVANCE(106);
      if (lookahead == ')') ADVANCE(107);
      if (lookahead == '*') ADVANCE(171);
      if (lookahead == '+') ADVANCE(174);
      if (lookahead == ',') ADVANCE(108);
      if (lookahead == '-') ADVANCE(175);
      if (lookahead == '.') ADVANCE(169);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == ':') ADVANCE(140);
      if (lookahead == '<') ADVANCE(179);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == '>') ADVANCE(177);
      if (lookahead == '?') ADVANCE(188);
      if (lookahead == '@') ADVANCE(168);
      if (lookahead == '[') ADVANCE(143);
      if (lookahead == ']') ADVANCE(145);
      if (lookahead == 'i') ADVANCE(48);
      if (lookahead == 'm') ADVANCE(53);
      if (lookahead == 'o') ADVANCE(76);
      if (lookahead == 'p') ADVANCE(24);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 't') ADVANCE(26);
      if (lookahead == 'v') ADVANCE(28);
      if (lookahead == '{') ADVANCE(138);
      if (lookahead == '|') ADVANCE(84);
      if (lookahead == '}') ADVANCE(139);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(91)
      END_STATE();
    case 92:
      if (eof) ADVANCE(93);
      if (lookahead == '/') ADVANCE(15);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '@') ADVANCE(168);
      if (lookahead == 'e') ADVANCE(82);
      if (lookahead == 'i') ADVANCE(48);
      if (lookahead == 'm') ADVANCE(53);
      if (lookahead == 'o') ADVANCE(76);
      if (lookahead == 'p') ADVANCE(24);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 't') ADVANCE(26);
      if (lookahead == 'v') ADVANCE(28);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(92)
      END_STATE();
    case 93:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_targetScope);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_param);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_output);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_resource);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_resource);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_existing);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym__assignment);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym__assignment);
      if (lookahead == '=') ADVANCE(181);
      if (lookahead == '~') ADVANCE(183);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_nullLiteral);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_nullLiteral);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_integerLiteral);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(125);
      if (lookahead == 'o') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'a') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'c') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'e') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'f') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'l') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'n') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'o') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'r') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 's') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'u') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'u') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == 'u') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(170);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(10);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(153);
      if (lookahead == '{') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(155);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(151);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_escapeSequence);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_stringLiteral);
      if (lookahead == '$') ADVANCE(148);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(152);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_stringLiteral);
      if (lookahead == '$') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(155);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_stringLiteral);
      if (lookahead == '$') ADVANCE(8);
      if (lookahead == '*') ADVANCE(155);
      if (lookahead == '/') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_stringLiteral);
      if (lookahead == '$') ADVANCE(8);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(155);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_stringLiteral);
      if (lookahead == '$') ADVANCE(191);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(156);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_stringLiteral);
      if (lookahead == '$') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'') ADVANCE(156);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(155);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym_multilineString_token1);
      if (lookahead == '\'') ADVANCE(159);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_multilineStringLiteral);
      if (lookahead == '\'') ADVANCE(12);
      if (lookahead == '*') ADVANCE(162);
      if (lookahead == '/') ADVANCE(163);
      if (lookahead != 0) ADVANCE(162);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_multilineStringLiteral);
      if (lookahead == '\'') ADVANCE(12);
      if (lookahead == '/') ADVANCE(160);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(161);
      if (lookahead != 0) ADVANCE(162);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_multilineStringLiteral);
      if (lookahead == '\'') ADVANCE(12);
      if (lookahead != 0) ADVANCE(162);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_multilineStringLiteral);
      if (lookahead == '\'') ADVANCE(193);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(162);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_in);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(137);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(197);
      if (lookahead == '/') ADVANCE(196);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(178);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(180);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_BANG_TILDE);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '?') ADVANCE(187);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(182);
      if (lookahead == '~') ADVANCE(184);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '$') ADVANCE(157);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(155);
      if (lookahead == '\'' ||
          lookahead == '{') ADVANCE(196);
      if (lookahead != 0) ADVANCE(156);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '\'') ADVANCE(196);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(162);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(162);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '*') ADVANCE(194);
      if (lookahead == '/') ADVANCE(196);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(17);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '*') ADVANCE(194);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(17);
      if (lookahead != 0) ADVANCE(195);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(17);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(aux_sym_comment_token2);
      if (lookahead == '*') ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(17);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 3},
  [3] = {.lex_state = 3},
  [4] = {.lex_state = 3},
  [5] = {.lex_state = 2},
  [6] = {.lex_state = 4},
  [7] = {.lex_state = 4},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 4},
  [10] = {.lex_state = 4},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 4},
  [15] = {.lex_state = 4},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 2},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 2},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 2},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 2},
  [30] = {.lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 2},
  [33] = {.lex_state = 2},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 2},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 2},
  [43] = {.lex_state = 2},
  [44] = {.lex_state = 2},
  [45] = {.lex_state = 2},
  [46] = {.lex_state = 2},
  [47] = {.lex_state = 2},
  [48] = {.lex_state = 2},
  [49] = {.lex_state = 2},
  [50] = {.lex_state = 2},
  [51] = {.lex_state = 2},
  [52] = {.lex_state = 2},
  [53] = {.lex_state = 2},
  [54] = {.lex_state = 2},
  [55] = {.lex_state = 2},
  [56] = {.lex_state = 2},
  [57] = {.lex_state = 2},
  [58] = {.lex_state = 2},
  [59] = {.lex_state = 2},
  [60] = {.lex_state = 2},
  [61] = {.lex_state = 2},
  [62] = {.lex_state = 2},
  [63] = {.lex_state = 2},
  [64] = {.lex_state = 2},
  [65] = {.lex_state = 2},
  [66] = {.lex_state = 2},
  [67] = {.lex_state = 2},
  [68] = {.lex_state = 2},
  [69] = {.lex_state = 2},
  [70] = {.lex_state = 2},
  [71] = {.lex_state = 2},
  [72] = {.lex_state = 2},
  [73] = {.lex_state = 2},
  [74] = {.lex_state = 2},
  [75] = {.lex_state = 2},
  [76] = {.lex_state = 2},
  [77] = {.lex_state = 2},
  [78] = {.lex_state = 2},
  [79] = {.lex_state = 2},
  [80] = {.lex_state = 2},
  [81] = {.lex_state = 2},
  [82] = {.lex_state = 2},
  [83] = {.lex_state = 2},
  [84] = {.lex_state = 2},
  [85] = {.lex_state = 2},
  [86] = {.lex_state = 2},
  [87] = {.lex_state = 2},
  [88] = {.lex_state = 2},
  [89] = {.lex_state = 2},
  [90] = {.lex_state = 2},
  [91] = {.lex_state = 2},
  [92] = {.lex_state = 2},
  [93] = {.lex_state = 2},
  [94] = {.lex_state = 2},
  [95] = {.lex_state = 2},
  [96] = {.lex_state = 2},
  [97] = {.lex_state = 2},
  [98] = {.lex_state = 2},
  [99] = {.lex_state = 2},
  [100] = {.lex_state = 2},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 2},
  [103] = {.lex_state = 2},
  [104] = {.lex_state = 2},
  [105] = {.lex_state = 2},
  [106] = {.lex_state = 2},
  [107] = {.lex_state = 2},
  [108] = {.lex_state = 2},
  [109] = {.lex_state = 2},
  [110] = {.lex_state = 2},
  [111] = {.lex_state = 2},
  [112] = {.lex_state = 2},
  [113] = {.lex_state = 2},
  [114] = {.lex_state = 2},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 90},
  [119] = {.lex_state = 90},
  [120] = {.lex_state = 91},
  [121] = {.lex_state = 91},
  [122] = {.lex_state = 91},
  [123] = {.lex_state = 91},
  [124] = {.lex_state = 91},
  [125] = {.lex_state = 91},
  [126] = {.lex_state = 91},
  [127] = {.lex_state = 91},
  [128] = {.lex_state = 91},
  [129] = {.lex_state = 91},
  [130] = {.lex_state = 91},
  [131] = {.lex_state = 91},
  [132] = {.lex_state = 91},
  [133] = {.lex_state = 91},
  [134] = {.lex_state = 91},
  [135] = {.lex_state = 91},
  [136] = {.lex_state = 91},
  [137] = {.lex_state = 91},
  [138] = {.lex_state = 91},
  [139] = {.lex_state = 91},
  [140] = {.lex_state = 91},
  [141] = {.lex_state = 91},
  [142] = {.lex_state = 90},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 91},
  [145] = {.lex_state = 91},
  [146] = {.lex_state = 91},
  [147] = {.lex_state = 91},
  [148] = {.lex_state = 91},
  [149] = {.lex_state = 91},
  [150] = {.lex_state = 91},
  [151] = {.lex_state = 91},
  [152] = {.lex_state = 91},
  [153] = {.lex_state = 91},
  [154] = {.lex_state = 91},
  [155] = {.lex_state = 91},
  [156] = {.lex_state = 91},
  [157] = {.lex_state = 91},
  [158] = {.lex_state = 91},
  [159] = {.lex_state = 91},
  [160] = {.lex_state = 91},
  [161] = {.lex_state = 91},
  [162] = {.lex_state = 91},
  [163] = {.lex_state = 91},
  [164] = {.lex_state = 91},
  [165] = {.lex_state = 91},
  [166] = {.lex_state = 91},
  [167] = {.lex_state = 91},
  [168] = {.lex_state = 91},
  [169] = {.lex_state = 91},
  [170] = {.lex_state = 91},
  [171] = {.lex_state = 91},
  [172] = {.lex_state = 91},
  [173] = {.lex_state = 91},
  [174] = {.lex_state = 91},
  [175] = {.lex_state = 91},
  [176] = {.lex_state = 91},
  [177] = {.lex_state = 91},
  [178] = {.lex_state = 91},
  [179] = {.lex_state = 91},
  [180] = {.lex_state = 91},
  [181] = {.lex_state = 91},
  [182] = {.lex_state = 91},
  [183] = {.lex_state = 91},
  [184] = {.lex_state = 91},
  [185] = {.lex_state = 91},
  [186] = {.lex_state = 91},
  [187] = {.lex_state = 6},
  [188] = {.lex_state = 6},
  [189] = {.lex_state = 6},
  [190] = {.lex_state = 6},
  [191] = {.lex_state = 6},
  [192] = {.lex_state = 6},
  [193] = {.lex_state = 6},
  [194] = {.lex_state = 6},
  [195] = {.lex_state = 6},
  [196] = {.lex_state = 6},
  [197] = {.lex_state = 6},
  [198] = {.lex_state = 6},
  [199] = {.lex_state = 6},
  [200] = {.lex_state = 6},
  [201] = {.lex_state = 6},
  [202] = {.lex_state = 6},
  [203] = {.lex_state = 6},
  [204] = {.lex_state = 6},
  [205] = {.lex_state = 6},
  [206] = {.lex_state = 6},
  [207] = {.lex_state = 6},
  [208] = {.lex_state = 6},
  [209] = {.lex_state = 6},
  [210] = {.lex_state = 6},
  [211] = {.lex_state = 6},
  [212] = {.lex_state = 6},
  [213] = {.lex_state = 6},
  [214] = {.lex_state = 6},
  [215] = {.lex_state = 6},
  [216] = {.lex_state = 6},
  [217] = {.lex_state = 6},
  [218] = {.lex_state = 6},
  [219] = {.lex_state = 6},
  [220] = {.lex_state = 6},
  [221] = {.lex_state = 6},
  [222] = {.lex_state = 6},
  [223] = {.lex_state = 6},
  [224] = {.lex_state = 6},
  [225] = {.lex_state = 6},
  [226] = {.lex_state = 6},
  [227] = {.lex_state = 6},
  [228] = {.lex_state = 6},
  [229] = {.lex_state = 6},
  [230] = {.lex_state = 6},
  [231] = {.lex_state = 91},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 91},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 91},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 91},
  [241] = {.lex_state = 91},
  [242] = {.lex_state = 91},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 91},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 91},
  [255] = {.lex_state = 91},
  [256] = {.lex_state = 91},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 91},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 91},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 91},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 91},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 91},
  [283] = {.lex_state = 91},
  [284] = {.lex_state = 91},
  [285] = {.lex_state = 91},
  [286] = {.lex_state = 91},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 1},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 1},
  [293] = {.lex_state = 1},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 91},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 2},
  [300] = {.lex_state = 92},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 92},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 5},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 5},
  [311] = {.lex_state = 5},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 5},
  [315] = {.lex_state = 5},
  [316] = {.lex_state = 5},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 5},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 7},
  [322] = {.lex_state = 7},
  [323] = {.lex_state = 14},
  [324] = {.lex_state = 14},
  [325] = {.lex_state = 7},
  [326] = {.lex_state = 7},
  [327] = {.lex_state = 14},
  [328] = {.lex_state = 7},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 7},
  [335] = {.lex_state = 7},
  [336] = {.lex_state = 5},
  [337] = {.lex_state = 5},
  [338] = {.lex_state = 5},
  [339] = {.lex_state = 5},
  [340] = {.lex_state = 5},
  [341] = {.lex_state = 5},
  [342] = {.lex_state = 5},
  [343] = {.lex_state = 5},
  [344] = {.lex_state = 5},
  [345] = {.lex_state = 5},
  [346] = {.lex_state = 5},
  [347] = {.lex_state = 5},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 5},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 5},
  [354] = {.lex_state = 5},
  [355] = {.lex_state = 5},
  [356] = {.lex_state = 5},
  [357] = {.lex_state = 5},
  [358] = {.lex_state = 5},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 5},
  [361] = {.lex_state = 5},
  [362] = {.lex_state = 5},
  [363] = {.lex_state = 5},
  [364] = {.lex_state = 90},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 92},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 90},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 92},
  [373] = {.lex_state = 90},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 90},
  [379] = {.lex_state = 91},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 3},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 161},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 3},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 161},
  [397] = {.lex_state = 161},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 91},
  [400] = {.lex_state = 90},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 90},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 3},
  [406] = {.lex_state = 3},
  [407] = {.lex_state = 91},
  [408] = {.lex_state = 90},
  [409] = {.lex_state = 3},
  [410] = {.lex_state = 3},
  [411] = {.lex_state = 16},
  [412] = {.lex_state = 1},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {(TSStateId)(-1)},
  [416] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_targetScope] = ACTIONS(1),
    [anon_sym_param] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_output] = ACTIONS(1),
    [anon_sym_resource] = ACTIONS(1),
    [anon_sym_existing] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [sym__assignment] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [sym_nullLiteral] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_integerLiteral] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym_escapeSequence] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_BANG_TILDE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
  [1] = {
    [sym_program] = STATE(398),
    [sym_statement] = STATE(308),
    [sym__declaration] = STATE(309),
    [sym_targetScope] = STATE(317),
    [sym_parameterDeclaration] = STATE(317),
    [sym_variableDeclaration] = STATE(317),
    [sym_outputDeclaration] = STATE(317),
    [sym_resourceDeclaration] = STATE(317),
    [sym_moduleDeclaration] = STATE(317),
    [sym_importDeclaration] = STATE(317),
    [sym_decorator] = STATE(320),
    [sym_comment] = STATE(1),
    [aux_sym_program_repeat1] = STATE(296),
    [aux_sym_statement_repeat1] = STATE(298),
    [ts_builtin_sym_end] = ACTIONS(7),
    [anon_sym_targetScope] = ACTIONS(9),
    [anon_sym_param] = ACTIONS(11),
    [anon_sym_var] = ACTIONS(13),
    [anon_sym_output] = ACTIONS(15),
    [anon_sym_resource] = ACTIONS(17),
    [anon_sym_module] = ACTIONS(19),
    [anon_sym_import] = ACTIONS(21),
    [anon_sym_AT] = ACTIONS(23),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 27,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(39), 1,
      anon_sym_RBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_for,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(2), 1,
      sym_comment,
    STATE(11), 1,
      aux_sym_array_repeat1,
    STATE(236), 1,
      sym__expression,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(412), 1,
      sym_arrayItem,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [114] = 27,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    ACTIONS(51), 1,
      anon_sym_RBRACK,
    ACTIONS(53), 1,
      anon_sym_for,
    STATE(3), 1,
      sym_comment,
    STATE(5), 1,
      aux_sym_array_repeat1,
    STATE(236), 1,
      sym__expression,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(412), 1,
      sym_arrayItem,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [228] = 27,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      anon_sym_RBRACK,
    ACTIONS(57), 1,
      anon_sym_for,
    STATE(4), 1,
      sym_comment,
    STATE(16), 1,
      aux_sym_array_repeat1,
    STATE(236), 1,
      sym__expression,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(412), 1,
      sym_arrayItem,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [342] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    ACTIONS(59), 1,
      anon_sym_RBRACK,
    STATE(5), 1,
      sym_comment,
    STATE(8), 1,
      aux_sym_array_repeat1,
    STATE(236), 1,
      sym__expression,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(412), 1,
      sym_arrayItem,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [453] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_if,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(6), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(279), 1,
      sym__expression,
    STATE(376), 1,
      sym_ifCondition,
    STATE(390), 1,
      sym__forBody,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [564] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_if,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(7), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(279), 1,
      sym__expression,
    STATE(376), 1,
      sym_ifCondition,
    STATE(395), 1,
      sym__forBody,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [675] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(88), 1,
      anon_sym_LPAREN,
    ACTIONS(91), 1,
      sym_nullLiteral,
    ACTIONS(97), 1,
      sym_integerLiteral,
    ACTIONS(100), 1,
      anon_sym_LBRACE,
    ACTIONS(103), 1,
      anon_sym_LBRACK,
    ACTIONS(106), 1,
      anon_sym_RBRACK,
    ACTIONS(108), 1,
      anon_sym_SQUOTE,
    ACTIONS(111), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(114), 1,
      anon_sym_DASH,
    ACTIONS(117), 1,
      anon_sym_BANG,
    STATE(236), 1,
      sym__expression,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(412), 1,
      sym_arrayItem,
    ACTIONS(85), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(94), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(8), 2,
      sym_comment,
      aux_sym_array_repeat1,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [784] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_if,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(9), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(279), 1,
      sym__expression,
    STATE(376), 1,
      sym_ifCondition,
    STATE(385), 1,
      sym__forBody,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [895] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_if,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(10), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(279), 1,
      sym__expression,
    STATE(376), 1,
      sym_ifCondition,
    STATE(384), 1,
      sym__forBody,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [1006] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    ACTIONS(120), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      aux_sym_array_repeat1,
    STATE(11), 1,
      sym_comment,
    STATE(236), 1,
      sym__expression,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(412), 1,
      sym_arrayItem,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [1117] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    ACTIONS(122), 1,
      anon_sym_RPAREN,
    STATE(12), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(231), 1,
      sym__expression,
    STATE(359), 1,
      sym_functionArgument,
    STATE(393), 1,
      sym__arguments,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [1228] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    ACTIONS(124), 1,
      anon_sym_RPAREN,
    STATE(13), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(231), 1,
      sym__expression,
    STATE(359), 1,
      sym_functionArgument,
    STATE(389), 1,
      sym__arguments,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [1339] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_if,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(14), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(279), 1,
      sym__expression,
    STATE(376), 1,
      sym_ifCondition,
    STATE(386), 1,
      sym__forBody,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [1450] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(73), 1,
      anon_sym_if,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(15), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(279), 1,
      sym__expression,
    STATE(376), 1,
      sym_ifCondition,
    STATE(387), 1,
      sym__forBody,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [1561] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    ACTIONS(126), 1,
      anon_sym_RBRACK,
    STATE(8), 1,
      aux_sym_array_repeat1,
    STATE(16), 1,
      sym_comment,
    STATE(236), 1,
      sym__expression,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(412), 1,
      sym_arrayItem,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [1672] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    ACTIONS(128), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(231), 1,
      sym__expression,
    STATE(359), 1,
      sym_functionArgument,
    STATE(381), 1,
      sym__arguments,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [1783] = 24,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(18), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(231), 1,
      sym__expression,
    STATE(365), 1,
      sym_functionArgument,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [1888] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(19), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(183), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [1990] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(20), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(260), 1,
      sym__expression,
    STATE(266), 1,
      sym_booleanLiteral,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [2092] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(21), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(268), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [2194] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(22), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(256), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [2296] = 24,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(23), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(167), 1,
      sym_functionCall,
    STATE(295), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 8,
      sym_variableAccess,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [2400] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(24), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(238), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [2502] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(25), 1,
      sym_comment,
    STATE(233), 1,
      sym__expression,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [2604] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(26), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(242), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [2706] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(27), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(247), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [2808] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(28), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(166), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [2910] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(29), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(154), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [3012] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(30), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(161), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [3114] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(31), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(162), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [3216] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(32), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(234), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [3318] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(33), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(163), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [3420] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(34), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(165), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [3522] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(35), 1,
      sym_comment,
    STATE(213), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [3624] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(36), 1,
      sym_comment,
    STATE(212), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [3726] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(37), 1,
      sym_comment,
    STATE(211), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [3828] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(38), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(169), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [3930] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(39), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(181), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [4032] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(40), 1,
      sym_comment,
    STATE(188), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [4134] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(41), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(148), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [4236] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(42), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(149), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [4338] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(43), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(150), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [4440] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(44), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(151), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [4542] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(45), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(152), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [4644] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(46), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(153), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [4746] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(47), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(144), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [4848] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(48), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(145), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [4950] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(49), 1,
      sym_comment,
    STATE(209), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [5052] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(50), 1,
      sym_comment,
    STATE(208), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [5154] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(51), 1,
      sym_comment,
    STATE(207), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [5256] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(52), 1,
      sym_comment,
    STATE(206), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [5358] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(53), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(155), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [5460] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(54), 1,
      sym_comment,
    STATE(205), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [5562] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(55), 1,
      sym_comment,
    STATE(204), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [5664] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(56), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(164), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [5766] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(57), 1,
      sym_comment,
    STATE(203), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [5868] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(58), 1,
      sym_comment,
    STATE(202), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [5970] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(59), 1,
      sym_comment,
    STATE(201), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [6072] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(60), 1,
      sym_comment,
    STATE(200), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [6174] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(61), 1,
      sym_comment,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    STATE(228), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [6276] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(62), 1,
      sym_comment,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    STATE(229), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [6378] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(63), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(157), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [6480] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(64), 1,
      sym_comment,
    STATE(210), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [6582] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(65), 1,
      sym_comment,
    STATE(214), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [6684] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(66), 1,
      sym_comment,
    STATE(215), 1,
      sym__expression,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [6786] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(67), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(158), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [6888] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(68), 1,
      sym_comment,
    STATE(237), 1,
      sym__expression,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [6990] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(69), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(253), 1,
      sym__expression,
    STATE(266), 1,
      sym_booleanLiteral,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [7092] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(70), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(283), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [7194] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(71), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(182), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [7296] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(72), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(254), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [7398] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(73), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(267), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [7500] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(74), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(269), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [7602] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(75), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(271), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [7704] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(76), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(159), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [7806] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(77), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(147), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [7908] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(78), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [8010] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(79), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(272), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [8112] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(80), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(273), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [8214] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(81), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(179), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [8316] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(82), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(177), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [8418] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(83), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(176), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [8520] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(84), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(175), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [8622] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(85), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(174), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [8724] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(86), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(173), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [8826] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(87), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(171), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [8928] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(88), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(170), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [9030] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(89), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(178), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [9132] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(90), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(168), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [9234] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(91), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(180), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [9336] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(92), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(160), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [9438] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(93), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(184), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [9540] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(94), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(185), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [9642] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(95), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(186), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [9744] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(96), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(172), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [9846] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(97), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(276), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [9948] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(98), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(146), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [10050] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(99), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(274), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [10152] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(100), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(285), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [10254] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(101), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(284), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [10356] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(102), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(270), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [10458] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(103), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(240), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [10560] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(104), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(277), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [10662] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(105), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(278), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [10764] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(106), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(255), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [10866] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(136), 1,
      anon_sym_LPAREN,
    ACTIONS(138), 1,
      sym_nullLiteral,
    ACTIONS(142), 1,
      sym_integerLiteral,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(146), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DASH,
    ACTIONS(154), 1,
      anon_sym_BANG,
    STATE(107), 1,
      sym_comment,
    STATE(220), 1,
      sym__conditionalExpression,
    STATE(223), 1,
      sym_identifier,
    STATE(227), 1,
      sym_booleanLiteral,
    STATE(230), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(140), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(219), 2,
      sym__negation,
      sym__minus,
    STATE(222), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(225), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(224), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(221), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [10968] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(108), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(280), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [11070] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(109), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(281), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [11172] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(110), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(282), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [11274] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(111), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(294), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [11376] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(112), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(293), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [11478] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(113), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(287), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [11580] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_DASH,
    ACTIONS(83), 1,
      anon_sym_BANG,
    STATE(114), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(286), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [11682] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(115), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(288), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [11784] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      sym_nullLiteral,
    ACTIONS(33), 1,
      sym_integerLiteral,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_BANG,
    STATE(116), 1,
      sym_comment,
    STATE(245), 1,
      sym__conditionalExpression,
    STATE(251), 1,
      sym_identifier,
    STATE(266), 1,
      sym_booleanLiteral,
    STATE(275), 1,
      sym__expression,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(31), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(292), 2,
      sym__negation,
      sym__minus,
    STATE(235), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(252), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(246), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(239), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [11886] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      sym_nullLiteral,
    ACTIONS(69), 1,
      sym_integerLiteral,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(132), 1,
      anon_sym_DASH,
    ACTIONS(134), 1,
      anon_sym_BANG,
    STATE(117), 1,
      sym_comment,
    STATE(122), 1,
      sym__conditionalExpression,
    STATE(123), 1,
      sym_booleanLiteral,
    STATE(129), 1,
      sym_identifier,
    STATE(156), 1,
      sym__expression,
    ACTIONS(67), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(133), 2,
      sym__negation,
      sym__minus,
    STATE(130), 3,
      sym_propertyAccess,
      sym_arrayAccess,
      sym_resourceAccess,
    STATE(125), 5,
      sym__primaryExpression,
      sym_binaryOperation,
      sym__memberExpression,
      sym_ternaryOperation,
      sym_unaryOperation,
    STATE(126), 9,
      sym_variableAccess,
      sym_functionCall,
      sym_parenthesizedExpression,
      sym__literalValue,
      sym_object,
      sym_array,
      sym_string,
      sym_multilineString,
      sym_for,
    STATE(131), 16,
      sym__multiplication,
      sym__modulo,
      sym__division,
      sym__addition,
      sym__subtraction,
      sym__greaterThan,
      sym__greaterThanOrEqual,
      sym__lessThan,
      sym__lessThanOrEqual,
      sym__equals,
      sym__notEquals,
      sym__equalsInsensitive,
      sym__notEqualsInsensitive,
      sym__logicalAnd,
      sym__logicalOr,
      sym__coalesce,
  [11988] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(118), 1,
      sym_comment,
    ACTIONS(158), 6,
      sym__assignment,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(156), 31,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12039] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(119), 1,
      sym_comment,
    ACTIONS(162), 6,
      sym__assignment,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(160), 31,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_existing,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12090] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(120), 1,
      sym_comment,
    ACTIONS(166), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(164), 31,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12140] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(121), 1,
      sym_comment,
    ACTIONS(170), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(168), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12189] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(122), 1,
      sym_comment,
    ACTIONS(174), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(172), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12238] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(123), 1,
      sym_comment,
    ACTIONS(178), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(176), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12287] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(124), 1,
      sym_comment,
    ACTIONS(182), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(180), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12336] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(125), 1,
      sym_comment,
    ACTIONS(186), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(184), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12385] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(126), 1,
      sym_comment,
    ACTIONS(190), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(188), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12434] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(127), 1,
      sym_comment,
    ACTIONS(194), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(192), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12483] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(128), 1,
      sym_comment,
    ACTIONS(198), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(196), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12532] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(129), 1,
      sym_comment,
    ACTIONS(202), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(200), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12581] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(130), 1,
      sym_comment,
    ACTIONS(206), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(204), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12630] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(131), 1,
      sym_comment,
    ACTIONS(210), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(208), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12679] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(132), 1,
      sym_comment,
    ACTIONS(214), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(212), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12728] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(133), 1,
      sym_comment,
    ACTIONS(218), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(216), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12777] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(134), 1,
      sym_comment,
    ACTIONS(222), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(220), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12826] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(135), 1,
      sym_comment,
    ACTIONS(226), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(224), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12875] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(136), 1,
      sym_comment,
    ACTIONS(230), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(228), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12924] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(137), 1,
      sym_comment,
    ACTIONS(234), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(232), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [12973] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(138), 1,
      sym_comment,
    ACTIONS(238), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(236), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13022] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(139), 1,
      sym_comment,
    ACTIONS(242), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(240), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13071] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(140), 1,
      sym_comment,
    ACTIONS(246), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(244), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13120] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(141), 1,
      sym_comment,
    ACTIONS(250), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(248), 30,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13169] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(142), 1,
      sym_comment,
    ACTIONS(254), 5,
      sym__assignment,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(252), 28,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_from,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_in,
      anon_sym_AT,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13216] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(143), 1,
      sym_comment,
    ACTIONS(254), 8,
      anon_sym_resource,
      sym__assignment,
      aux_sym_identifier_token1,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(252), 23,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13261] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    STATE(144), 1,
      sym_comment,
    ACTIONS(272), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(256), 20,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13319] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    STATE(145), 1,
      sym_comment,
    ACTIONS(276), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(274), 20,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13377] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(292), 1,
      anon_sym_EQ_EQ,
    ACTIONS(294), 1,
      anon_sym_BANG_EQ,
    ACTIONS(296), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(298), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(302), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(304), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(306), 1,
      anon_sym_QMARK,
    STATE(146), 1,
      sym_comment,
    ACTIONS(278), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [13461] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(292), 1,
      anon_sym_EQ_EQ,
    ACTIONS(294), 1,
      anon_sym_BANG_EQ,
    ACTIONS(296), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(298), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(302), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(304), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(306), 1,
      anon_sym_QMARK,
    STATE(147), 1,
      sym_comment,
    ACTIONS(308), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [13545] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(312), 1,
      anon_sym_QMARK,
    STATE(148), 1,
      sym_comment,
    ACTIONS(310), 16,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13615] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(316), 1,
      anon_sym_QMARK,
    STATE(149), 1,
      sym_comment,
    ACTIONS(314), 16,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13685] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    STATE(150), 1,
      sym_comment,
    ACTIONS(320), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(318), 18,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13747] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    STATE(151), 1,
      sym_comment,
    ACTIONS(324), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(322), 18,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13809] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    STATE(152), 1,
      sym_comment,
    ACTIONS(328), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(326), 18,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13871] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    STATE(153), 1,
      sym_comment,
    ACTIONS(332), 3,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(330), 18,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [13933] = 24,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(292), 1,
      anon_sym_EQ_EQ,
    ACTIONS(294), 1,
      anon_sym_BANG_EQ,
    ACTIONS(296), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(298), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(302), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(306), 1,
      anon_sym_QMARK,
    STATE(154), 1,
      sym_comment,
    ACTIONS(334), 10,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_QMARK_QMARK,
  [14015] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    STATE(155), 1,
      sym_comment,
    ACTIONS(338), 4,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(336), 22,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14067] = 24,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(292), 1,
      anon_sym_EQ_EQ,
    ACTIONS(294), 1,
      anon_sym_BANG_EQ,
    ACTIONS(296), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(298), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(302), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(306), 1,
      anon_sym_QMARK,
    STATE(156), 1,
      sym_comment,
    ACTIONS(340), 10,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_QMARK_QMARK,
  [14149] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    STATE(157), 1,
      sym_comment,
    ACTIONS(344), 4,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(342), 22,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14201] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    STATE(158), 1,
      sym_comment,
    ACTIONS(348), 4,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(346), 22,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14253] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    STATE(159), 1,
      sym_comment,
    ACTIONS(352), 4,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(350), 22,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14305] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    STATE(160), 1,
      sym_comment,
    ACTIONS(356), 4,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(354), 22,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14357] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(292), 1,
      anon_sym_EQ_EQ,
    ACTIONS(294), 1,
      anon_sym_BANG_EQ,
    ACTIONS(296), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(298), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(360), 1,
      anon_sym_QMARK,
    STATE(161), 1,
      sym_comment,
    ACTIONS(358), 11,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14437] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(292), 1,
      anon_sym_EQ_EQ,
    ACTIONS(294), 1,
      anon_sym_BANG_EQ,
    ACTIONS(296), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(298), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(364), 1,
      anon_sym_QMARK,
    STATE(162), 1,
      sym_comment,
    ACTIONS(362), 12,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14515] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(368), 1,
      anon_sym_QMARK,
    STATE(163), 1,
      sym_comment,
    ACTIONS(366), 16,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14585] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(292), 1,
      anon_sym_EQ_EQ,
    ACTIONS(294), 1,
      anon_sym_BANG_EQ,
    ACTIONS(296), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(298), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(302), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(304), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(306), 1,
      anon_sym_QMARK,
    STATE(164), 1,
      sym_comment,
    ACTIONS(370), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [14669] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(374), 1,
      anon_sym_QMARK,
    STATE(165), 1,
      sym_comment,
    ACTIONS(372), 16,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14739] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(264), 1,
      anon_sym_COLON_COLON,
    ACTIONS(266), 1,
      anon_sym_STAR,
    ACTIONS(268), 1,
      anon_sym_PERCENT,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    ACTIONS(280), 1,
      anon_sym_PLUS,
    ACTIONS(282), 1,
      anon_sym_DASH,
    ACTIONS(284), 1,
      anon_sym_GT,
    ACTIONS(286), 1,
      anon_sym_GT_EQ,
    ACTIONS(288), 1,
      anon_sym_LT,
    ACTIONS(290), 1,
      anon_sym_LT_EQ,
    ACTIONS(292), 1,
      anon_sym_EQ_EQ,
    ACTIONS(294), 1,
      anon_sym_BANG_EQ,
    ACTIONS(296), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(298), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(300), 1,
      anon_sym_AMP_AMP,
    ACTIONS(302), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(304), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(306), 1,
      anon_sym_QMARK,
    STATE(166), 1,
      sym_comment,
    ACTIONS(376), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [14823] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(167), 1,
      sym_comment,
    ACTIONS(190), 4,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(378), 8,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
    ACTIONS(188), 17,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14868] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    STATE(168), 1,
      sym_comment,
    ACTIONS(316), 2,
      anon_sym_COLON,
      anon_sym_QMARK,
    ACTIONS(314), 11,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14934] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    STATE(169), 1,
      sym_comment,
    ACTIONS(356), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(354), 17,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [14982] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    STATE(170), 1,
      sym_comment,
    ACTIONS(324), 4,
      anon_sym_COLON,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(322), 13,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15040] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    STATE(171), 1,
      sym_comment,
    ACTIONS(328), 4,
      anon_sym_COLON,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(326), 13,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15098] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(402), 1,
      anon_sym_COLON,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    STATE(172), 1,
      sym_comment,
    ACTIONS(334), 5,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_QMARK_QMARK,
  [15178] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    STATE(173), 1,
      sym_comment,
    ACTIONS(332), 4,
      anon_sym_COLON,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(330), 13,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15236] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    STATE(174), 1,
      sym_comment,
    ACTIONS(272), 4,
      anon_sym_COLON,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(256), 15,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15290] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    STATE(175), 1,
      sym_comment,
    ACTIONS(276), 4,
      anon_sym_COLON,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(274), 15,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15344] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    STATE(176), 1,
      sym_comment,
    ACTIONS(338), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(336), 17,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15392] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    STATE(177), 1,
      sym_comment,
    ACTIONS(344), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(342), 17,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15440] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    STATE(178), 1,
      sym_comment,
    ACTIONS(320), 4,
      anon_sym_COLON,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(318), 13,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15498] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    STATE(179), 1,
      sym_comment,
    ACTIONS(348), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(346), 17,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15546] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    STATE(180), 1,
      sym_comment,
    ACTIONS(312), 2,
      anon_sym_COLON,
      anon_sym_QMARK,
    ACTIONS(310), 11,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15612] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    STATE(181), 1,
      sym_comment,
    ACTIONS(352), 5,
      anon_sym_COLON,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(350), 17,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15660] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(418), 1,
      anon_sym_COLON,
    STATE(182), 1,
      sym_comment,
    ACTIONS(340), 5,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_QMARK_QMARK,
  [15740] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    STATE(183), 1,
      sym_comment,
    ACTIONS(374), 2,
      anon_sym_COLON,
      anon_sym_QMARK,
    ACTIONS(372), 11,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15806] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    STATE(184), 1,
      sym_comment,
    ACTIONS(368), 2,
      anon_sym_COLON,
      anon_sym_QMARK,
    ACTIONS(366), 11,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15872] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    STATE(185), 1,
      sym_comment,
    ACTIONS(364), 2,
      anon_sym_COLON,
      anon_sym_QMARK,
    ACTIONS(362), 7,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [15946] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    STATE(186), 1,
      sym_comment,
    ACTIONS(360), 2,
      anon_sym_COLON,
      anon_sym_QMARK,
    ACTIONS(358), 6,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16022] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(187), 1,
      sym_comment,
    ACTIONS(238), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(236), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16061] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    ACTIONS(438), 1,
      anon_sym_GT,
    ACTIONS(440), 1,
      anon_sym_GT_EQ,
    ACTIONS(442), 1,
      anon_sym_LT,
    ACTIONS(444), 1,
      anon_sym_LT_EQ,
    ACTIONS(446), 1,
      anon_sym_EQ_EQ,
    ACTIONS(448), 1,
      anon_sym_BANG_EQ,
    ACTIONS(450), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(452), 1,
      anon_sym_BANG_TILDE,
    STATE(188), 1,
      sym_comment,
    ACTIONS(364), 3,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_QMARK,
    ACTIONS(362), 5,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16134] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(189), 1,
      sym_comment,
    ACTIONS(234), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(232), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16173] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(190), 1,
      sym_comment,
    ACTIONS(250), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(248), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16212] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(191), 1,
      sym_comment,
    ACTIONS(230), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(228), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16251] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(192), 1,
      sym_comment,
    ACTIONS(198), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(196), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16290] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(193), 1,
      sym_comment,
    ACTIONS(170), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(168), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16329] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(194), 1,
      sym_comment,
    ACTIONS(214), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(212), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16368] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(195), 1,
      sym_comment,
    ACTIONS(246), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(244), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16407] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(196), 1,
      sym_comment,
    ACTIONS(158), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(156), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16446] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(197), 1,
      sym_comment,
    ACTIONS(242), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(240), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16485] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(198), 1,
      sym_comment,
    ACTIONS(194), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(192), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16524] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(199), 1,
      sym_comment,
    ACTIONS(166), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(164), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16563] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    STATE(200), 1,
      sym_comment,
    ACTIONS(276), 5,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(274), 13,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16616] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    STATE(201), 1,
      sym_comment,
    ACTIONS(272), 5,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(256), 13,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16669] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    STATE(202), 1,
      sym_comment,
    ACTIONS(332), 5,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(330), 11,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16726] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    STATE(203), 1,
      sym_comment,
    ACTIONS(328), 5,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(326), 11,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16783] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    STATE(204), 1,
      sym_comment,
    ACTIONS(324), 5,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(322), 11,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16840] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    STATE(205), 1,
      sym_comment,
    ACTIONS(320), 5,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(318), 11,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16897] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    ACTIONS(438), 1,
      anon_sym_GT,
    ACTIONS(440), 1,
      anon_sym_GT_EQ,
    ACTIONS(442), 1,
      anon_sym_LT,
    ACTIONS(444), 1,
      anon_sym_LT_EQ,
    STATE(206), 1,
      sym_comment,
    ACTIONS(316), 3,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_QMARK,
    ACTIONS(314), 9,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [16962] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    ACTIONS(438), 1,
      anon_sym_GT,
    ACTIONS(440), 1,
      anon_sym_GT_EQ,
    ACTIONS(442), 1,
      anon_sym_LT,
    ACTIONS(444), 1,
      anon_sym_LT_EQ,
    STATE(207), 1,
      sym_comment,
    ACTIONS(312), 3,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_QMARK,
    ACTIONS(310), 9,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17027] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    ACTIONS(438), 1,
      anon_sym_GT,
    ACTIONS(440), 1,
      anon_sym_GT_EQ,
    ACTIONS(442), 1,
      anon_sym_LT,
    ACTIONS(444), 1,
      anon_sym_LT_EQ,
    STATE(208), 1,
      sym_comment,
    ACTIONS(374), 3,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_QMARK,
    ACTIONS(372), 9,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17092] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    ACTIONS(438), 1,
      anon_sym_GT,
    ACTIONS(440), 1,
      anon_sym_GT_EQ,
    ACTIONS(442), 1,
      anon_sym_LT,
    ACTIONS(444), 1,
      anon_sym_LT_EQ,
    STATE(209), 1,
      sym_comment,
    ACTIONS(368), 3,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_QMARK,
    ACTIONS(366), 9,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17157] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    STATE(210), 1,
      sym_comment,
    ACTIONS(348), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(346), 15,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17204] = 23,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    ACTIONS(438), 1,
      anon_sym_GT,
    ACTIONS(440), 1,
      anon_sym_GT_EQ,
    ACTIONS(442), 1,
      anon_sym_LT,
    ACTIONS(444), 1,
      anon_sym_LT_EQ,
    ACTIONS(446), 1,
      anon_sym_EQ_EQ,
    ACTIONS(448), 1,
      anon_sym_BANG_EQ,
    ACTIONS(450), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(452), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(454), 1,
      anon_sym_AMP_AMP,
    STATE(211), 1,
      sym_comment,
    ACTIONS(360), 3,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_QMARK,
    ACTIONS(358), 4,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17279] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    ACTIONS(438), 1,
      anon_sym_GT,
    ACTIONS(440), 1,
      anon_sym_GT_EQ,
    ACTIONS(442), 1,
      anon_sym_LT,
    ACTIONS(444), 1,
      anon_sym_LT_EQ,
    ACTIONS(446), 1,
      anon_sym_EQ_EQ,
    ACTIONS(448), 1,
      anon_sym_BANG_EQ,
    ACTIONS(450), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(452), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(454), 1,
      anon_sym_AMP_AMP,
    ACTIONS(456), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(458), 1,
      anon_sym_QMARK,
    STATE(212), 1,
      sym_comment,
    ACTIONS(402), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(334), 3,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_QMARK_QMARK,
  [17358] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    ACTIONS(438), 1,
      anon_sym_GT,
    ACTIONS(440), 1,
      anon_sym_GT_EQ,
    ACTIONS(442), 1,
      anon_sym_LT,
    ACTIONS(444), 1,
      anon_sym_LT_EQ,
    ACTIONS(446), 1,
      anon_sym_EQ_EQ,
    ACTIONS(448), 1,
      anon_sym_BANG_EQ,
    ACTIONS(450), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(452), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(454), 1,
      anon_sym_AMP_AMP,
    ACTIONS(456), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(458), 1,
      anon_sym_QMARK,
    STATE(213), 1,
      sym_comment,
    ACTIONS(418), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(340), 3,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_QMARK_QMARK,
  [17437] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    STATE(214), 1,
      sym_comment,
    ACTIONS(352), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(350), 15,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17484] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    STATE(215), 1,
      sym_comment,
    ACTIONS(356), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(354), 15,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17531] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(216), 1,
      sym_comment,
    ACTIONS(162), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(160), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17570] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(217), 1,
      sym_comment,
    ACTIONS(226), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(224), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17609] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(218), 1,
      sym_comment,
    ACTIONS(222), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(220), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17648] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(219), 1,
      sym_comment,
    ACTIONS(218), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(216), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17687] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(220), 1,
      sym_comment,
    ACTIONS(174), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(172), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17726] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(221), 1,
      sym_comment,
    ACTIONS(210), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(208), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17765] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(222), 1,
      sym_comment,
    ACTIONS(206), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(204), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17804] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(223), 1,
      sym_comment,
    ACTIONS(202), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(200), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17843] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(224), 1,
      sym_comment,
    ACTIONS(190), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(188), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17882] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(225), 1,
      sym_comment,
    ACTIONS(186), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(184), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17921] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(226), 1,
      sym_comment,
    ACTIONS(182), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(180), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17960] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(227), 1,
      sym_comment,
    ACTIONS(178), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(176), 19,
      anon_sym_LPAREN,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_SQUOTE,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [17999] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    STATE(228), 1,
      sym_comment,
    ACTIONS(338), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(336), 15,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [18046] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    STATE(229), 1,
      sym_comment,
    ACTIONS(344), 6,
      anon_sym_resource,
      aux_sym_identifier_token1,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_QMARK,
    ACTIONS(342), 15,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
  [18093] = 26,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(420), 1,
      anon_sym_LPAREN,
    ACTIONS(422), 1,
      anon_sym_LBRACK,
    ACTIONS(424), 1,
      anon_sym_DOT,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      anon_sym_STAR,
    ACTIONS(430), 1,
      anon_sym_PERCENT,
    ACTIONS(432), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PLUS,
    ACTIONS(436), 1,
      anon_sym_DASH,
    ACTIONS(438), 1,
      anon_sym_GT,
    ACTIONS(440), 1,
      anon_sym_GT_EQ,
    ACTIONS(442), 1,
      anon_sym_LT,
    ACTIONS(444), 1,
      anon_sym_LT_EQ,
    ACTIONS(446), 1,
      anon_sym_EQ_EQ,
    ACTIONS(448), 1,
      anon_sym_BANG_EQ,
    ACTIONS(450), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(452), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(454), 1,
      anon_sym_AMP_AMP,
    ACTIONS(456), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(458), 1,
      anon_sym_QMARK,
    ACTIONS(464), 1,
      anon_sym_QMARK_QMARK,
    STATE(230), 1,
      sym_comment,
    ACTIONS(460), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(462), 2,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
  [18174] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    STATE(231), 1,
      sym_comment,
    ACTIONS(466), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [18251] = 5,
    ACTIONS(244), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(232), 1,
      sym_comment,
    ACTIONS(246), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [18287] = 14,
    ACTIONS(326), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    STATE(233), 1,
      sym_comment,
    ACTIONS(328), 12,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [18341] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(492), 1,
      anon_sym_RPAREN,
    STATE(234), 1,
      sym_comment,
  [18417] = 5,
    ACTIONS(204), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(235), 1,
      sym_comment,
    ACTIONS(206), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [18453] = 25,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    ACTIONS(494), 1,
      anon_sym_LF,
    ACTIONS(496), 1,
      anon_sym_GT,
    ACTIONS(498), 1,
      anon_sym_GT_EQ,
    ACTIONS(500), 1,
      anon_sym_LT,
    ACTIONS(502), 1,
      anon_sym_LT_EQ,
    ACTIONS(504), 1,
      anon_sym_EQ_EQ,
    ACTIONS(506), 1,
      anon_sym_BANG_EQ,
    ACTIONS(508), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(510), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(512), 1,
      anon_sym_AMP_AMP,
    ACTIONS(514), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(516), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(518), 1,
      anon_sym_QMARK,
    STATE(236), 1,
      sym_comment,
  [18529] = 25,
    ACTIONS(340), 1,
      anon_sym_LF,
    ACTIONS(418), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    ACTIONS(496), 1,
      anon_sym_GT,
    ACTIONS(498), 1,
      anon_sym_GT_EQ,
    ACTIONS(500), 1,
      anon_sym_LT,
    ACTIONS(502), 1,
      anon_sym_LT_EQ,
    ACTIONS(504), 1,
      anon_sym_EQ_EQ,
    ACTIONS(506), 1,
      anon_sym_BANG_EQ,
    ACTIONS(508), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(510), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(512), 1,
      anon_sym_AMP_AMP,
    ACTIONS(514), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(518), 1,
      anon_sym_QMARK,
    STATE(237), 1,
      sym_comment,
  [18605] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(520), 1,
      anon_sym_RPAREN,
    STATE(238), 1,
      sym_comment,
  [18681] = 5,
    ACTIONS(208), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(239), 1,
      sym_comment,
    ACTIONS(210), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [18717] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(522), 1,
      anon_sym_COLON,
    STATE(240), 1,
      sym_comment,
  [18793] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(524), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym_comment,
  [18869] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(526), 1,
      anon_sym_RBRACK,
    STATE(242), 1,
      sym_comment,
  [18945] = 5,
    ACTIONS(228), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(243), 1,
      sym_comment,
    ACTIONS(230), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [18981] = 5,
    ACTIONS(248), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(244), 1,
      sym_comment,
    ACTIONS(250), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19017] = 5,
    ACTIONS(172), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(245), 1,
      sym_comment,
    ACTIONS(174), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19053] = 5,
    ACTIONS(188), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(246), 1,
      sym_comment,
    ACTIONS(190), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19089] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(528), 1,
      anon_sym_RPAREN,
    STATE(247), 1,
      sym_comment,
  [19165] = 5,
    ACTIONS(236), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(248), 1,
      sym_comment,
    ACTIONS(238), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19201] = 5,
    ACTIONS(232), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(249), 1,
      sym_comment,
    ACTIONS(234), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19237] = 5,
    ACTIONS(252), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(250), 1,
      sym_comment,
    ACTIONS(254), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19273] = 5,
    ACTIONS(200), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(251), 1,
      sym_comment,
    ACTIONS(202), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19309] = 5,
    ACTIONS(184), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(252), 1,
      sym_comment,
    ACTIONS(186), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19345] = 25,
    ACTIONS(334), 1,
      anon_sym_LF,
    ACTIONS(402), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    ACTIONS(496), 1,
      anon_sym_GT,
    ACTIONS(498), 1,
      anon_sym_GT_EQ,
    ACTIONS(500), 1,
      anon_sym_LT,
    ACTIONS(502), 1,
      anon_sym_LT_EQ,
    ACTIONS(504), 1,
      anon_sym_EQ_EQ,
    ACTIONS(506), 1,
      anon_sym_BANG_EQ,
    ACTIONS(508), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(510), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(512), 1,
      anon_sym_AMP_AMP,
    ACTIONS(514), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(518), 1,
      anon_sym_QMARK,
    STATE(253), 1,
      sym_comment,
  [19421] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(530), 1,
      anon_sym_RBRACE,
    STATE(254), 1,
      sym_comment,
  [19497] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(532), 1,
      anon_sym_COLON,
    STATE(255), 1,
      sym_comment,
  [19573] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(534), 1,
      anon_sym_RBRACK,
    STATE(256), 1,
      sym_comment,
  [19649] = 5,
    ACTIONS(196), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(257), 1,
      sym_comment,
    ACTIONS(198), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19685] = 5,
    ACTIONS(168), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(258), 1,
      sym_comment,
    ACTIONS(170), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19721] = 5,
    ACTIONS(212), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(259), 1,
      sym_comment,
    ACTIONS(214), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19757] = 23,
    ACTIONS(358), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    ACTIONS(496), 1,
      anon_sym_GT,
    ACTIONS(498), 1,
      anon_sym_GT_EQ,
    ACTIONS(500), 1,
      anon_sym_LT,
    ACTIONS(502), 1,
      anon_sym_LT_EQ,
    ACTIONS(504), 1,
      anon_sym_EQ_EQ,
    ACTIONS(506), 1,
      anon_sym_BANG_EQ,
    ACTIONS(508), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(510), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(512), 1,
      anon_sym_AMP_AMP,
    STATE(260), 1,
      sym_comment,
    ACTIONS(360), 3,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19829] = 5,
    ACTIONS(156), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(261), 1,
      sym_comment,
    ACTIONS(158), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19865] = 5,
    ACTIONS(240), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(262), 1,
      sym_comment,
    ACTIONS(242), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19901] = 5,
    ACTIONS(192), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(263), 1,
      sym_comment,
    ACTIONS(194), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19937] = 5,
    ACTIONS(164), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(264), 1,
      sym_comment,
    ACTIONS(166), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [19973] = 5,
    ACTIONS(180), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(265), 1,
      sym_comment,
    ACTIONS(182), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20009] = 5,
    ACTIONS(176), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(266), 1,
      sym_comment,
    ACTIONS(178), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20045] = 22,
    ACTIONS(362), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    ACTIONS(496), 1,
      anon_sym_GT,
    ACTIONS(498), 1,
      anon_sym_GT_EQ,
    ACTIONS(500), 1,
      anon_sym_LT,
    ACTIONS(502), 1,
      anon_sym_LT_EQ,
    ACTIONS(504), 1,
      anon_sym_EQ_EQ,
    ACTIONS(506), 1,
      anon_sym_BANG_EQ,
    ACTIONS(508), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(510), 1,
      anon_sym_BANG_TILDE,
    STATE(267), 1,
      sym_comment,
    ACTIONS(364), 4,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20115] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(536), 1,
      anon_sym_COLON,
    STATE(268), 1,
      sym_comment,
  [20191] = 18,
    ACTIONS(366), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    ACTIONS(496), 1,
      anon_sym_GT,
    ACTIONS(498), 1,
      anon_sym_GT_EQ,
    ACTIONS(500), 1,
      anon_sym_LT,
    ACTIONS(502), 1,
      anon_sym_LT_EQ,
    STATE(269), 1,
      sym_comment,
    ACTIONS(368), 8,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20253] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(538), 1,
      anon_sym_COLON,
    STATE(270), 1,
      sym_comment,
  [20329] = 18,
    ACTIONS(372), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    ACTIONS(496), 1,
      anon_sym_GT,
    ACTIONS(498), 1,
      anon_sym_GT_EQ,
    ACTIONS(500), 1,
      anon_sym_LT,
    ACTIONS(502), 1,
      anon_sym_LT_EQ,
    STATE(271), 1,
      sym_comment,
    ACTIONS(374), 8,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20391] = 18,
    ACTIONS(310), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    ACTIONS(496), 1,
      anon_sym_GT,
    ACTIONS(498), 1,
      anon_sym_GT_EQ,
    ACTIONS(500), 1,
      anon_sym_LT,
    ACTIONS(502), 1,
      anon_sym_LT_EQ,
    STATE(272), 1,
      sym_comment,
    ACTIONS(312), 8,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20453] = 18,
    ACTIONS(314), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    ACTIONS(496), 1,
      anon_sym_GT,
    ACTIONS(498), 1,
      anon_sym_GT_EQ,
    ACTIONS(500), 1,
      anon_sym_LT,
    ACTIONS(502), 1,
      anon_sym_LT_EQ,
    STATE(273), 1,
      sym_comment,
    ACTIONS(316), 8,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20515] = 14,
    ACTIONS(318), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    STATE(274), 1,
      sym_comment,
    ACTIONS(320), 12,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20569] = 14,
    ACTIONS(322), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    STATE(275), 1,
      sym_comment,
    ACTIONS(324), 12,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20623] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(540), 1,
      anon_sym_COLON,
    STATE(276), 1,
      sym_comment,
  [20699] = 14,
    ACTIONS(330), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    ACTIONS(488), 1,
      anon_sym_PLUS,
    ACTIONS(490), 1,
      anon_sym_DASH,
    STATE(277), 1,
      sym_comment,
    ACTIONS(332), 12,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20753] = 12,
    ACTIONS(256), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    STATE(278), 1,
      sym_comment,
    ACTIONS(272), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20803] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(542), 1,
      anon_sym_RBRACK,
    STATE(279), 1,
      sym_comment,
  [20879] = 12,
    ACTIONS(274), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    ACTIONS(482), 1,
      anon_sym_STAR,
    ACTIONS(484), 1,
      anon_sym_PERCENT,
    ACTIONS(486), 1,
      anon_sym_SLASH,
    STATE(280), 1,
      sym_comment,
    ACTIONS(276), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20929] = 9,
    ACTIONS(336), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    STATE(281), 1,
      sym_comment,
    ACTIONS(338), 17,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [20973] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(544), 1,
      anon_sym_COLON,
    STATE(282), 1,
      sym_comment,
  [21049] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(546), 1,
      anon_sym_COLON,
    STATE(283), 1,
      sym_comment,
  [21125] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(548), 1,
      anon_sym_COLON,
    STATE(284), 1,
      sym_comment,
  [21201] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(550), 1,
      anon_sym_COLON,
    STATE(285), 1,
      sym_comment,
  [21277] = 25,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    ACTIONS(552), 1,
      anon_sym_COLON,
    STATE(286), 1,
      sym_comment,
  [21353] = 9,
    ACTIONS(350), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    STATE(287), 1,
      sym_comment,
    ACTIONS(352), 17,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [21397] = 9,
    ACTIONS(354), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    STATE(288), 1,
      sym_comment,
    ACTIONS(356), 17,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [21441] = 5,
    ACTIONS(160), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(289), 1,
      sym_comment,
    ACTIONS(162), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [21477] = 5,
    ACTIONS(224), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(290), 1,
      sym_comment,
    ACTIONS(226), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [21513] = 5,
    ACTIONS(220), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(291), 1,
      sym_comment,
    ACTIONS(222), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [21549] = 5,
    ACTIONS(216), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(292), 1,
      sym_comment,
    ACTIONS(218), 21,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [21585] = 9,
    ACTIONS(346), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    STATE(293), 1,
      sym_comment,
    ACTIONS(348), 17,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [21629] = 9,
    ACTIONS(342), 1,
      anon_sym_LF,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(474), 1,
      anon_sym_LPAREN,
    ACTIONS(476), 1,
      anon_sym_LBRACK,
    ACTIONS(478), 1,
      anon_sym_DOT,
    ACTIONS(480), 1,
      anon_sym_COLON_COLON,
    STATE(294), 1,
      sym_comment,
    ACTIONS(344), 17,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK_QMARK,
      anon_sym_QMARK,
  [21673] = 24,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      anon_sym_LBRACK,
    ACTIONS(380), 1,
      anon_sym_DOT,
    ACTIONS(382), 1,
      anon_sym_COLON_COLON,
    ACTIONS(384), 1,
      anon_sym_STAR,
    ACTIONS(386), 1,
      anon_sym_PERCENT,
    ACTIONS(388), 1,
      anon_sym_SLASH,
    ACTIONS(390), 1,
      anon_sym_PLUS,
    ACTIONS(392), 1,
      anon_sym_DASH,
    ACTIONS(394), 1,
      anon_sym_GT,
    ACTIONS(396), 1,
      anon_sym_GT_EQ,
    ACTIONS(398), 1,
      anon_sym_LT,
    ACTIONS(400), 1,
      anon_sym_LT_EQ,
    ACTIONS(404), 1,
      anon_sym_EQ_EQ,
    ACTIONS(406), 1,
      anon_sym_BANG_EQ,
    ACTIONS(408), 1,
      anon_sym_EQ_TILDE,
    ACTIONS(410), 1,
      anon_sym_BANG_TILDE,
    ACTIONS(412), 1,
      anon_sym_AMP_AMP,
    ACTIONS(414), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(416), 1,
      anon_sym_QMARK,
    ACTIONS(468), 1,
      anon_sym_QMARK_QMARK,
    STATE(295), 1,
      sym_comment,
  [21746] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_targetScope,
    ACTIONS(11), 1,
      anon_sym_param,
    ACTIONS(13), 1,
      anon_sym_var,
    ACTIONS(15), 1,
      anon_sym_output,
    ACTIONS(17), 1,
      anon_sym_resource,
    ACTIONS(19), 1,
      anon_sym_module,
    ACTIONS(21), 1,
      anon_sym_import,
    ACTIONS(23), 1,
      anon_sym_AT,
    ACTIONS(554), 1,
      ts_builtin_sym_end,
    STATE(296), 1,
      sym_comment,
    STATE(297), 1,
      aux_sym_program_repeat1,
    STATE(298), 1,
      aux_sym_statement_repeat1,
    STATE(308), 1,
      sym_statement,
    STATE(309), 1,
      sym__declaration,
    STATE(320), 1,
      sym_decorator,
    STATE(317), 7,
      sym_targetScope,
      sym_parameterDeclaration,
      sym_variableDeclaration,
      sym_outputDeclaration,
      sym_resourceDeclaration,
      sym_moduleDeclaration,
      sym_importDeclaration,
  [21807] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(556), 1,
      ts_builtin_sym_end,
    ACTIONS(558), 1,
      anon_sym_targetScope,
    ACTIONS(561), 1,
      anon_sym_param,
    ACTIONS(564), 1,
      anon_sym_var,
    ACTIONS(567), 1,
      anon_sym_output,
    ACTIONS(570), 1,
      anon_sym_resource,
    ACTIONS(573), 1,
      anon_sym_module,
    ACTIONS(576), 1,
      anon_sym_import,
    ACTIONS(579), 1,
      anon_sym_AT,
    STATE(298), 1,
      aux_sym_statement_repeat1,
    STATE(308), 1,
      sym_statement,
    STATE(309), 1,
      sym__declaration,
    STATE(320), 1,
      sym_decorator,
    STATE(297), 2,
      sym_comment,
      aux_sym_program_repeat1,
    STATE(317), 7,
      sym_targetScope,
      sym_parameterDeclaration,
      sym_variableDeclaration,
      sym_outputDeclaration,
      sym_resourceDeclaration,
      sym_moduleDeclaration,
      sym_importDeclaration,
  [21866] = 15,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_targetScope,
    ACTIONS(11), 1,
      anon_sym_param,
    ACTIONS(13), 1,
      anon_sym_var,
    ACTIONS(15), 1,
      anon_sym_output,
    ACTIONS(17), 1,
      anon_sym_resource,
    ACTIONS(19), 1,
      anon_sym_module,
    ACTIONS(21), 1,
      anon_sym_import,
    ACTIONS(23), 1,
      anon_sym_AT,
    STATE(298), 1,
      sym_comment,
    STATE(302), 1,
      aux_sym_statement_repeat1,
    STATE(318), 1,
      sym__declaration,
    STATE(320), 1,
      sym_decorator,
    STATE(317), 7,
      sym_targetScope,
      sym_parameterDeclaration,
      sym_variableDeclaration,
      sym_outputDeclaration,
      sym_resourceDeclaration,
      sym_moduleDeclaration,
      sym_importDeclaration,
  [21918] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(299), 1,
      sym_comment,
    ACTIONS(106), 7,
      anon_sym_LPAREN,
      sym_integerLiteral,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_BANG,
    ACTIONS(582), 7,
      anon_sym_resource,
      sym_nullLiteral,
      anon_sym_true,
      anon_sym_false,
      aux_sym_identifier_token1,
      anon_sym_SQUOTE,
      anon_sym_DASH,
  [21946] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(586), 1,
      sym__assignment,
    STATE(300), 1,
      sym_comment,
    STATE(307), 1,
      sym_parameterDefaultValue,
    ACTIONS(584), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [21973] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(301), 1,
      sym_comment,
    ACTIONS(588), 10,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
  [21995] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(592), 1,
      anon_sym_AT,
    STATE(320), 1,
      sym_decorator,
    STATE(302), 2,
      sym_comment,
      aux_sym_statement_repeat1,
    ACTIONS(590), 7,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
  [22021] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(303), 1,
      sym_comment,
    ACTIONS(595), 10,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      sym__assignment,
      anon_sym_AT,
  [22043] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(304), 1,
      sym_comment,
    ACTIONS(597), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [22064] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(305), 1,
      sym_comment,
    ACTIONS(599), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [22085] = 10,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(61), 1,
      aux_sym_identifier_token1,
    ACTIONS(601), 1,
      anon_sym_resource,
    ACTIONS(603), 1,
      anon_sym_RBRACE,
    ACTIONS(605), 1,
      anon_sym_SQUOTE,
    STATE(306), 1,
      sym_comment,
    STATE(319), 1,
      aux_sym_object_repeat1,
    STATE(339), 2,
      sym_resourceDeclaration,
      sym_objectProperty,
    STATE(394), 2,
      sym_identifier,
      sym_string,
  [22118] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(307), 1,
      sym_comment,
    ACTIONS(607), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [22139] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(308), 1,
      sym_comment,
    ACTIONS(609), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [22160] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(309), 1,
      sym_comment,
    ACTIONS(611), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [22181] = 10,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(61), 1,
      aux_sym_identifier_token1,
    ACTIONS(601), 1,
      anon_sym_resource,
    ACTIONS(605), 1,
      anon_sym_SQUOTE,
    ACTIONS(613), 1,
      anon_sym_RBRACE,
    STATE(310), 1,
      sym_comment,
    STATE(315), 1,
      aux_sym_object_repeat1,
    STATE(339), 2,
      sym_resourceDeclaration,
      sym_objectProperty,
    STATE(394), 2,
      sym_identifier,
      sym_string,
  [22214] = 10,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(61), 1,
      aux_sym_identifier_token1,
    ACTIONS(601), 1,
      anon_sym_resource,
    ACTIONS(605), 1,
      anon_sym_SQUOTE,
    ACTIONS(615), 1,
      anon_sym_RBRACE,
    STATE(311), 1,
      sym_comment,
    STATE(314), 1,
      aux_sym_object_repeat1,
    STATE(339), 2,
      sym_resourceDeclaration,
      sym_objectProperty,
    STATE(394), 2,
      sym_identifier,
      sym_string,
  [22247] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(312), 1,
      sym_comment,
    ACTIONS(617), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [22268] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(313), 1,
      sym_comment,
    ACTIONS(619), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [22289] = 10,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(61), 1,
      aux_sym_identifier_token1,
    ACTIONS(601), 1,
      anon_sym_resource,
    ACTIONS(605), 1,
      anon_sym_SQUOTE,
    ACTIONS(621), 1,
      anon_sym_RBRACE,
    STATE(314), 1,
      sym_comment,
    STATE(316), 1,
      aux_sym_object_repeat1,
    STATE(339), 2,
      sym_resourceDeclaration,
      sym_objectProperty,
    STATE(394), 2,
      sym_identifier,
      sym_string,
  [22322] = 10,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(61), 1,
      aux_sym_identifier_token1,
    ACTIONS(601), 1,
      anon_sym_resource,
    ACTIONS(605), 1,
      anon_sym_SQUOTE,
    ACTIONS(623), 1,
      anon_sym_RBRACE,
    STATE(315), 1,
      sym_comment,
    STATE(316), 1,
      aux_sym_object_repeat1,
    STATE(339), 2,
      sym_resourceDeclaration,
      sym_objectProperty,
    STATE(394), 2,
      sym_identifier,
      sym_string,
  [22355] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(625), 1,
      anon_sym_resource,
    ACTIONS(628), 1,
      aux_sym_identifier_token1,
    ACTIONS(631), 1,
      anon_sym_RBRACE,
    ACTIONS(633), 1,
      anon_sym_SQUOTE,
    STATE(316), 2,
      sym_comment,
      aux_sym_object_repeat1,
    STATE(339), 2,
      sym_resourceDeclaration,
      sym_objectProperty,
    STATE(394), 2,
      sym_identifier,
      sym_string,
  [22386] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(317), 1,
      sym_comment,
    ACTIONS(636), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [22407] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(318), 1,
      sym_comment,
    ACTIONS(638), 9,
      ts_builtin_sym_end,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [22428] = 10,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(61), 1,
      aux_sym_identifier_token1,
    ACTIONS(601), 1,
      anon_sym_resource,
    ACTIONS(605), 1,
      anon_sym_SQUOTE,
    ACTIONS(640), 1,
      anon_sym_RBRACE,
    STATE(316), 1,
      aux_sym_object_repeat1,
    STATE(319), 1,
      sym_comment,
    STATE(339), 2,
      sym_resourceDeclaration,
      sym_objectProperty,
    STATE(394), 2,
      sym_identifier,
      sym_string,
  [22461] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(320), 1,
      sym_comment,
    ACTIONS(642), 8,
      anon_sym_targetScope,
      anon_sym_param,
      anon_sym_var,
      anon_sym_output,
      anon_sym_resource,
      anon_sym_module,
      anon_sym_import,
      anon_sym_AT,
  [22481] = 7,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(649), 1,
      anon_sym_DOLLAR_LBRACE,
    STATE(335), 1,
      sym__interpolation,
    ACTIONS(644), 2,
      anon_sym_SQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(646), 2,
      sym_escapeSequence,
      sym_stringLiteral,
    STATE(321), 2,
      sym_comment,
      aux_sym__stringContent_repeat1,
  [22506] = 9,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(652), 1,
      anon_sym_SQUOTE,
    ACTIONS(654), 1,
      anon_sym_DOLLAR,
    ACTIONS(658), 1,
      anon_sym_DOLLAR_LBRACE,
    STATE(321), 1,
      aux_sym__stringContent_repeat1,
    STATE(322), 1,
      sym_comment,
    STATE(335), 1,
      sym__interpolation,
    ACTIONS(656), 2,
      sym_escapeSequence,
      sym_stringLiteral,
  [22535] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(660), 1,
      anon_sym_LPAREN,
    ACTIONS(662), 1,
      anon_sym_in,
    STATE(323), 1,
      sym_comment,
    STATE(352), 1,
      sym_identifier,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(377), 2,
      sym_localVariable,
      sym_forVariableBlock,
  [22562] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(660), 1,
      anon_sym_LPAREN,
    ACTIONS(664), 1,
      anon_sym_in,
    STATE(324), 1,
      sym_comment,
    STATE(352), 1,
      sym_identifier,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(413), 2,
      sym_localVariable,
      sym_forVariableBlock,
  [22589] = 9,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(658), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(666), 1,
      anon_sym_SQUOTE,
    STATE(322), 1,
      aux_sym__stringContent_repeat1,
    STATE(325), 1,
      sym_comment,
    STATE(335), 1,
      sym__interpolation,
    STATE(378), 1,
      sym__stringContent,
    ACTIONS(656), 2,
      sym_escapeSequence,
      sym_stringLiteral,
  [22618] = 9,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(658), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(668), 1,
      anon_sym_SQUOTE,
    STATE(322), 1,
      aux_sym__stringContent_repeat1,
    STATE(326), 1,
      sym_comment,
    STATE(335), 1,
      sym__interpolation,
    STATE(400), 1,
      sym__stringContent,
    ACTIONS(656), 2,
      sym_escapeSequence,
      sym_stringLiteral,
  [22647] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(660), 1,
      anon_sym_LPAREN,
    ACTIONS(670), 1,
      anon_sym_in,
    STATE(327), 1,
      sym_comment,
    STATE(352), 1,
      sym_identifier,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    STATE(403), 2,
      sym_localVariable,
      sym_forVariableBlock,
  [22674] = 9,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(658), 1,
      anon_sym_DOLLAR_LBRACE,
    ACTIONS(672), 1,
      anon_sym_SQUOTE,
    STATE(322), 1,
      aux_sym__stringContent_repeat1,
    STATE(328), 1,
      sym_comment,
    STATE(335), 1,
      sym__interpolation,
    STATE(408), 1,
      sym__stringContent,
    ACTIONS(656), 2,
      sym_escapeSequence,
      sym_stringLiteral,
  [22703] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(674), 1,
      anon_sym_if,
    ACTIONS(676), 1,
      anon_sym_LBRACK,
    STATE(329), 1,
      sym_comment,
    STATE(305), 3,
      sym_object,
      sym_ifCondition,
      sym_for,
  [22727] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(678), 1,
      anon_sym_if,
    ACTIONS(680), 1,
      anon_sym_LBRACK,
    STATE(330), 1,
      sym_comment,
    STATE(343), 3,
      sym_object,
      sym_ifCondition,
      sym_for,
  [22751] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(674), 1,
      anon_sym_if,
    ACTIONS(676), 1,
      anon_sym_LBRACK,
    STATE(331), 1,
      sym_comment,
    STATE(304), 3,
      sym_object,
      sym_ifCondition,
      sym_for,
  [22775] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    ACTIONS(674), 1,
      anon_sym_if,
    ACTIONS(676), 1,
      anon_sym_LBRACK,
    STATE(332), 1,
      sym_comment,
    STATE(312), 3,
      sym_object,
      sym_ifCondition,
      sym_for,
  [22799] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    ACTIONS(678), 1,
      anon_sym_if,
    ACTIONS(680), 1,
      anon_sym_LBRACK,
    STATE(333), 1,
      sym_comment,
    STATE(342), 3,
      sym_object,
      sym_ifCondition,
      sym_for,
  [22823] = 5,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(334), 1,
      sym_comment,
    ACTIONS(684), 2,
      sym_escapeSequence,
      sym_stringLiteral,
    ACTIONS(682), 3,
      anon_sym_SQUOTE,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_LBRACE,
  [22842] = 5,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    STATE(335), 1,
      sym_comment,
    ACTIONS(688), 2,
      sym_escapeSequence,
      sym_stringLiteral,
    ACTIONS(686), 3,
      anon_sym_SQUOTE,
      anon_sym_DOLLAR,
      anon_sym_DOLLAR_LBRACE,
  [22861] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(336), 1,
      sym_comment,
    STATE(352), 1,
      sym_identifier,
    STATE(382), 1,
      sym_localVariable,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [22881] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(337), 1,
      sym_comment,
    ACTIONS(588), 2,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
    ACTIONS(690), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [22899] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(252), 1,
      anon_sym_COLON,
    STATE(338), 1,
      sym_comment,
    STATE(373), 1,
      sym_identifier,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [22919] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(339), 1,
      sym_comment,
    ACTIONS(692), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
    ACTIONS(694), 2,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
  [22937] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(300), 1,
      sym_type,
    STATE(303), 1,
      sym_identifier,
    STATE(340), 1,
      sym_comment,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [22957] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(341), 1,
      sym_comment,
    STATE(352), 1,
      sym_identifier,
    STATE(404), 1,
      sym_localVariable,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [22977] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(342), 1,
      sym_comment,
    ACTIONS(597), 2,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
    ACTIONS(696), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [22995] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(343), 1,
      sym_comment,
    ACTIONS(599), 2,
      anon_sym_RBRACE,
      anon_sym_SQUOTE,
    ACTIONS(698), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23013] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(303), 1,
      sym_identifier,
    STATE(344), 1,
      sym_comment,
    STATE(409), 1,
      sym_type,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23033] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(128), 1,
      sym_identifier,
    STATE(345), 1,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23050] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(128), 1,
      sym_identifier,
    STATE(346), 1,
      sym_comment,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23067] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(340), 1,
      sym_identifier,
    STATE(347), 1,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23084] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(700), 1,
      anon_sym_RPAREN,
    ACTIONS(702), 1,
      anon_sym_COMMA,
    STATE(348), 2,
      sym_comment,
      aux_sym__arguments_repeat1,
  [23101] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(121), 1,
      sym_identifier,
    STATE(349), 1,
      sym_comment,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23118] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(705), 1,
      anon_sym_RPAREN,
    ACTIONS(707), 1,
      anon_sym_COMMA,
    STATE(348), 1,
      aux_sym__arguments_repeat1,
    STATE(350), 1,
      sym_comment,
  [23137] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(344), 1,
      sym_identifier,
    STATE(351), 1,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23154] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(352), 1,
      sym_comment,
    ACTIONS(709), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_in,
  [23169] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(257), 1,
      sym_identifier,
    STATE(353), 1,
      sym_comment,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23186] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(258), 1,
      sym_identifier,
    STATE(354), 1,
      sym_comment,
    ACTIONS(25), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23203] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(355), 1,
      sym_comment,
    STATE(364), 1,
      sym_identifier,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23220] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(356), 1,
      sym_comment,
    STATE(370), 1,
      sym_identifier,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23237] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(357), 1,
      sym_comment,
    STATE(401), 1,
      sym_identifier,
    ACTIONS(130), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23254] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(358), 1,
      sym_comment,
    STATE(383), 1,
      sym_identifier,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23271] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(707), 1,
      anon_sym_COMMA,
    ACTIONS(711), 1,
      anon_sym_RPAREN,
    STATE(350), 1,
      aux_sym__arguments_repeat1,
    STATE(359), 1,
      sym_comment,
  [23290] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(121), 1,
      sym_identifier,
    STATE(360), 1,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23307] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(361), 1,
      sym_comment,
    STATE(374), 1,
      sym_identifier,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23324] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(193), 1,
      sym_identifier,
    STATE(362), 1,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23341] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(192), 1,
      sym_identifier,
    STATE(363), 1,
      sym_comment,
    ACTIONS(61), 2,
      anon_sym_resource,
      aux_sym_identifier_token1,
  [23358] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(605), 1,
      anon_sym_SQUOTE,
    STATE(364), 1,
      sym_comment,
    STATE(372), 1,
      sym_string,
  [23374] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(365), 1,
      sym_comment,
    ACTIONS(700), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [23388] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(713), 1,
      anon_sym_existing,
    ACTIONS(715), 1,
      sym__assignment,
    STATE(366), 1,
      sym_comment,
  [23404] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    STATE(301), 1,
      sym_object,
    STATE(367), 1,
      sym_comment,
  [23420] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    STATE(367), 1,
      sym_parenthesizedExpression,
    STATE(368), 1,
      sym_comment,
  [23436] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(144), 1,
      anon_sym_LBRACE,
    STATE(337), 1,
      sym_object,
    STATE(369), 1,
      sym_comment,
  [23452] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(605), 1,
      anon_sym_SQUOTE,
    STATE(370), 1,
      sym_comment,
    STATE(405), 1,
      sym_string,
  [23468] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    STATE(369), 1,
      sym_parenthesizedExpression,
    STATE(371), 1,
      sym_comment,
  [23484] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(717), 1,
      anon_sym_existing,
    ACTIONS(719), 1,
      sym__assignment,
    STATE(372), 1,
      sym_comment,
  [23500] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(605), 1,
      anon_sym_SQUOTE,
    STATE(366), 1,
      sym_string,
    STATE(373), 1,
      sym_comment,
  [23516] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(71), 1,
      anon_sym_LBRACE,
    STATE(313), 1,
      sym_object,
    STATE(374), 1,
      sym_comment,
  [23532] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(721), 1,
      anon_sym_for,
    STATE(375), 1,
      sym_comment,
  [23545] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(542), 1,
      anon_sym_RBRACK,
    STATE(376), 1,
      sym_comment,
  [23558] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(723), 1,
      anon_sym_in,
    STATE(377), 1,
      sym_comment,
  [23571] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(725), 1,
      anon_sym_SQUOTE,
    STATE(378), 1,
      sym_comment,
  [23584] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(727), 1,
      aux_sym_multilineString_token1,
    STATE(379), 1,
      sym_comment,
  [23597] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(729), 1,
      anon_sym_SLASH,
    STATE(380), 1,
      sym_comment,
  [23610] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(731), 1,
      anon_sym_RPAREN,
    STATE(381), 1,
      sym_comment,
  [23623] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(733), 1,
      anon_sym_COMMA,
    STATE(382), 1,
      sym_comment,
  [23636] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(735), 1,
      sym__assignment,
    STATE(383), 1,
      sym_comment,
  [23649] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(737), 1,
      anon_sym_RBRACK,
    STATE(384), 1,
      sym_comment,
  [23662] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(739), 1,
      anon_sym_RBRACK,
    STATE(385), 1,
      sym_comment,
  [23675] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(741), 1,
      anon_sym_RBRACK,
    STATE(386), 1,
      sym_comment,
  [23688] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(743), 1,
      anon_sym_RBRACK,
    STATE(387), 1,
      sym_comment,
  [23701] = 4,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(745), 1,
      sym_multilineStringLiteral,
    STATE(388), 1,
      sym_comment,
  [23714] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(747), 1,
      anon_sym_RPAREN,
    STATE(389), 1,
      sym_comment,
  [23727] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(749), 1,
      anon_sym_RBRACK,
    STATE(390), 1,
      sym_comment,
  [23740] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(751), 1,
      anon_sym_in,
    STATE(391), 1,
      sym_comment,
  [23753] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(753), 1,
      sym__assignment,
    STATE(392), 1,
      sym_comment,
  [23766] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(755), 1,
      anon_sym_RPAREN,
    STATE(393), 1,
      sym_comment,
  [23779] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(757), 1,
      anon_sym_COLON,
    STATE(394), 1,
      sym_comment,
  [23792] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(759), 1,
      anon_sym_RBRACK,
    STATE(395), 1,
      sym_comment,
  [23805] = 4,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(761), 1,
      sym_multilineStringLiteral,
    STATE(396), 1,
      sym_comment,
  [23818] = 4,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(763), 1,
      sym_multilineStringLiteral,
    STATE(397), 1,
      sym_comment,
  [23831] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(765), 1,
      ts_builtin_sym_end,
    STATE(398), 1,
      sym_comment,
  [23844] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(767), 1,
      aux_sym_multilineString_token1,
    STATE(399), 1,
      sym_comment,
  [23857] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(769), 1,
      anon_sym_SQUOTE,
    STATE(400), 1,
      sym_comment,
  [23870] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(771), 1,
      anon_sym_from,
    STATE(401), 1,
      sym_comment,
  [23883] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(773), 1,
      anon_sym_SQUOTE,
    STATE(402), 1,
      sym_comment,
  [23896] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(775), 1,
      anon_sym_in,
    STATE(403), 1,
      sym_comment,
  [23909] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(777), 1,
      anon_sym_RPAREN,
    STATE(404), 1,
      sym_comment,
  [23922] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(779), 1,
      sym__assignment,
    STATE(405), 1,
      sym_comment,
  [23935] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(781), 1,
      sym__assignment,
    STATE(406), 1,
      sym_comment,
  [23948] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(783), 1,
      aux_sym_multilineString_token1,
    STATE(407), 1,
      sym_comment,
  [23961] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(785), 1,
      anon_sym_SQUOTE,
    STATE(408), 1,
      sym_comment,
  [23974] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(787), 1,
      sym__assignment,
    STATE(409), 1,
      sym_comment,
  [23987] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(789), 1,
      sym__assignment,
    STATE(410), 1,
      sym_comment,
  [24000] = 4,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(791), 1,
      aux_sym_comment_token2,
    STATE(411), 1,
      sym_comment,
  [24013] = 4,
    ACTIONS(470), 1,
      aux_sym_comment_token1,
    ACTIONS(472), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(793), 1,
      anon_sym_LF,
    STATE(412), 1,
      sym_comment,
  [24026] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(795), 1,
      anon_sym_in,
    STATE(413), 1,
      sym_comment,
  [24039] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(797), 1,
      anon_sym_for,
    STATE(414), 1,
      sym_comment,
  [24052] = 1,
    ACTIONS(799), 1,
      ts_builtin_sym_end,
  [24056] = 1,
    ACTIONS(801), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 114,
  [SMALL_STATE(4)] = 228,
  [SMALL_STATE(5)] = 342,
  [SMALL_STATE(6)] = 453,
  [SMALL_STATE(7)] = 564,
  [SMALL_STATE(8)] = 675,
  [SMALL_STATE(9)] = 784,
  [SMALL_STATE(10)] = 895,
  [SMALL_STATE(11)] = 1006,
  [SMALL_STATE(12)] = 1117,
  [SMALL_STATE(13)] = 1228,
  [SMALL_STATE(14)] = 1339,
  [SMALL_STATE(15)] = 1450,
  [SMALL_STATE(16)] = 1561,
  [SMALL_STATE(17)] = 1672,
  [SMALL_STATE(18)] = 1783,
  [SMALL_STATE(19)] = 1888,
  [SMALL_STATE(20)] = 1990,
  [SMALL_STATE(21)] = 2092,
  [SMALL_STATE(22)] = 2194,
  [SMALL_STATE(23)] = 2296,
  [SMALL_STATE(24)] = 2400,
  [SMALL_STATE(25)] = 2502,
  [SMALL_STATE(26)] = 2604,
  [SMALL_STATE(27)] = 2706,
  [SMALL_STATE(28)] = 2808,
  [SMALL_STATE(29)] = 2910,
  [SMALL_STATE(30)] = 3012,
  [SMALL_STATE(31)] = 3114,
  [SMALL_STATE(32)] = 3216,
  [SMALL_STATE(33)] = 3318,
  [SMALL_STATE(34)] = 3420,
  [SMALL_STATE(35)] = 3522,
  [SMALL_STATE(36)] = 3624,
  [SMALL_STATE(37)] = 3726,
  [SMALL_STATE(38)] = 3828,
  [SMALL_STATE(39)] = 3930,
  [SMALL_STATE(40)] = 4032,
  [SMALL_STATE(41)] = 4134,
  [SMALL_STATE(42)] = 4236,
  [SMALL_STATE(43)] = 4338,
  [SMALL_STATE(44)] = 4440,
  [SMALL_STATE(45)] = 4542,
  [SMALL_STATE(46)] = 4644,
  [SMALL_STATE(47)] = 4746,
  [SMALL_STATE(48)] = 4848,
  [SMALL_STATE(49)] = 4950,
  [SMALL_STATE(50)] = 5052,
  [SMALL_STATE(51)] = 5154,
  [SMALL_STATE(52)] = 5256,
  [SMALL_STATE(53)] = 5358,
  [SMALL_STATE(54)] = 5460,
  [SMALL_STATE(55)] = 5562,
  [SMALL_STATE(56)] = 5664,
  [SMALL_STATE(57)] = 5766,
  [SMALL_STATE(58)] = 5868,
  [SMALL_STATE(59)] = 5970,
  [SMALL_STATE(60)] = 6072,
  [SMALL_STATE(61)] = 6174,
  [SMALL_STATE(62)] = 6276,
  [SMALL_STATE(63)] = 6378,
  [SMALL_STATE(64)] = 6480,
  [SMALL_STATE(65)] = 6582,
  [SMALL_STATE(66)] = 6684,
  [SMALL_STATE(67)] = 6786,
  [SMALL_STATE(68)] = 6888,
  [SMALL_STATE(69)] = 6990,
  [SMALL_STATE(70)] = 7092,
  [SMALL_STATE(71)] = 7194,
  [SMALL_STATE(72)] = 7296,
  [SMALL_STATE(73)] = 7398,
  [SMALL_STATE(74)] = 7500,
  [SMALL_STATE(75)] = 7602,
  [SMALL_STATE(76)] = 7704,
  [SMALL_STATE(77)] = 7806,
  [SMALL_STATE(78)] = 7908,
  [SMALL_STATE(79)] = 8010,
  [SMALL_STATE(80)] = 8112,
  [SMALL_STATE(81)] = 8214,
  [SMALL_STATE(82)] = 8316,
  [SMALL_STATE(83)] = 8418,
  [SMALL_STATE(84)] = 8520,
  [SMALL_STATE(85)] = 8622,
  [SMALL_STATE(86)] = 8724,
  [SMALL_STATE(87)] = 8826,
  [SMALL_STATE(88)] = 8928,
  [SMALL_STATE(89)] = 9030,
  [SMALL_STATE(90)] = 9132,
  [SMALL_STATE(91)] = 9234,
  [SMALL_STATE(92)] = 9336,
  [SMALL_STATE(93)] = 9438,
  [SMALL_STATE(94)] = 9540,
  [SMALL_STATE(95)] = 9642,
  [SMALL_STATE(96)] = 9744,
  [SMALL_STATE(97)] = 9846,
  [SMALL_STATE(98)] = 9948,
  [SMALL_STATE(99)] = 10050,
  [SMALL_STATE(100)] = 10152,
  [SMALL_STATE(101)] = 10254,
  [SMALL_STATE(102)] = 10356,
  [SMALL_STATE(103)] = 10458,
  [SMALL_STATE(104)] = 10560,
  [SMALL_STATE(105)] = 10662,
  [SMALL_STATE(106)] = 10764,
  [SMALL_STATE(107)] = 10866,
  [SMALL_STATE(108)] = 10968,
  [SMALL_STATE(109)] = 11070,
  [SMALL_STATE(110)] = 11172,
  [SMALL_STATE(111)] = 11274,
  [SMALL_STATE(112)] = 11376,
  [SMALL_STATE(113)] = 11478,
  [SMALL_STATE(114)] = 11580,
  [SMALL_STATE(115)] = 11682,
  [SMALL_STATE(116)] = 11784,
  [SMALL_STATE(117)] = 11886,
  [SMALL_STATE(118)] = 11988,
  [SMALL_STATE(119)] = 12039,
  [SMALL_STATE(120)] = 12090,
  [SMALL_STATE(121)] = 12140,
  [SMALL_STATE(122)] = 12189,
  [SMALL_STATE(123)] = 12238,
  [SMALL_STATE(124)] = 12287,
  [SMALL_STATE(125)] = 12336,
  [SMALL_STATE(126)] = 12385,
  [SMALL_STATE(127)] = 12434,
  [SMALL_STATE(128)] = 12483,
  [SMALL_STATE(129)] = 12532,
  [SMALL_STATE(130)] = 12581,
  [SMALL_STATE(131)] = 12630,
  [SMALL_STATE(132)] = 12679,
  [SMALL_STATE(133)] = 12728,
  [SMALL_STATE(134)] = 12777,
  [SMALL_STATE(135)] = 12826,
  [SMALL_STATE(136)] = 12875,
  [SMALL_STATE(137)] = 12924,
  [SMALL_STATE(138)] = 12973,
  [SMALL_STATE(139)] = 13022,
  [SMALL_STATE(140)] = 13071,
  [SMALL_STATE(141)] = 13120,
  [SMALL_STATE(142)] = 13169,
  [SMALL_STATE(143)] = 13216,
  [SMALL_STATE(144)] = 13261,
  [SMALL_STATE(145)] = 13319,
  [SMALL_STATE(146)] = 13377,
  [SMALL_STATE(147)] = 13461,
  [SMALL_STATE(148)] = 13545,
  [SMALL_STATE(149)] = 13615,
  [SMALL_STATE(150)] = 13685,
  [SMALL_STATE(151)] = 13747,
  [SMALL_STATE(152)] = 13809,
  [SMALL_STATE(153)] = 13871,
  [SMALL_STATE(154)] = 13933,
  [SMALL_STATE(155)] = 14015,
  [SMALL_STATE(156)] = 14067,
  [SMALL_STATE(157)] = 14149,
  [SMALL_STATE(158)] = 14201,
  [SMALL_STATE(159)] = 14253,
  [SMALL_STATE(160)] = 14305,
  [SMALL_STATE(161)] = 14357,
  [SMALL_STATE(162)] = 14437,
  [SMALL_STATE(163)] = 14515,
  [SMALL_STATE(164)] = 14585,
  [SMALL_STATE(165)] = 14669,
  [SMALL_STATE(166)] = 14739,
  [SMALL_STATE(167)] = 14823,
  [SMALL_STATE(168)] = 14868,
  [SMALL_STATE(169)] = 14934,
  [SMALL_STATE(170)] = 14982,
  [SMALL_STATE(171)] = 15040,
  [SMALL_STATE(172)] = 15098,
  [SMALL_STATE(173)] = 15178,
  [SMALL_STATE(174)] = 15236,
  [SMALL_STATE(175)] = 15290,
  [SMALL_STATE(176)] = 15344,
  [SMALL_STATE(177)] = 15392,
  [SMALL_STATE(178)] = 15440,
  [SMALL_STATE(179)] = 15498,
  [SMALL_STATE(180)] = 15546,
  [SMALL_STATE(181)] = 15612,
  [SMALL_STATE(182)] = 15660,
  [SMALL_STATE(183)] = 15740,
  [SMALL_STATE(184)] = 15806,
  [SMALL_STATE(185)] = 15872,
  [SMALL_STATE(186)] = 15946,
  [SMALL_STATE(187)] = 16022,
  [SMALL_STATE(188)] = 16061,
  [SMALL_STATE(189)] = 16134,
  [SMALL_STATE(190)] = 16173,
  [SMALL_STATE(191)] = 16212,
  [SMALL_STATE(192)] = 16251,
  [SMALL_STATE(193)] = 16290,
  [SMALL_STATE(194)] = 16329,
  [SMALL_STATE(195)] = 16368,
  [SMALL_STATE(196)] = 16407,
  [SMALL_STATE(197)] = 16446,
  [SMALL_STATE(198)] = 16485,
  [SMALL_STATE(199)] = 16524,
  [SMALL_STATE(200)] = 16563,
  [SMALL_STATE(201)] = 16616,
  [SMALL_STATE(202)] = 16669,
  [SMALL_STATE(203)] = 16726,
  [SMALL_STATE(204)] = 16783,
  [SMALL_STATE(205)] = 16840,
  [SMALL_STATE(206)] = 16897,
  [SMALL_STATE(207)] = 16962,
  [SMALL_STATE(208)] = 17027,
  [SMALL_STATE(209)] = 17092,
  [SMALL_STATE(210)] = 17157,
  [SMALL_STATE(211)] = 17204,
  [SMALL_STATE(212)] = 17279,
  [SMALL_STATE(213)] = 17358,
  [SMALL_STATE(214)] = 17437,
  [SMALL_STATE(215)] = 17484,
  [SMALL_STATE(216)] = 17531,
  [SMALL_STATE(217)] = 17570,
  [SMALL_STATE(218)] = 17609,
  [SMALL_STATE(219)] = 17648,
  [SMALL_STATE(220)] = 17687,
  [SMALL_STATE(221)] = 17726,
  [SMALL_STATE(222)] = 17765,
  [SMALL_STATE(223)] = 17804,
  [SMALL_STATE(224)] = 17843,
  [SMALL_STATE(225)] = 17882,
  [SMALL_STATE(226)] = 17921,
  [SMALL_STATE(227)] = 17960,
  [SMALL_STATE(228)] = 17999,
  [SMALL_STATE(229)] = 18046,
  [SMALL_STATE(230)] = 18093,
  [SMALL_STATE(231)] = 18174,
  [SMALL_STATE(232)] = 18251,
  [SMALL_STATE(233)] = 18287,
  [SMALL_STATE(234)] = 18341,
  [SMALL_STATE(235)] = 18417,
  [SMALL_STATE(236)] = 18453,
  [SMALL_STATE(237)] = 18529,
  [SMALL_STATE(238)] = 18605,
  [SMALL_STATE(239)] = 18681,
  [SMALL_STATE(240)] = 18717,
  [SMALL_STATE(241)] = 18793,
  [SMALL_STATE(242)] = 18869,
  [SMALL_STATE(243)] = 18945,
  [SMALL_STATE(244)] = 18981,
  [SMALL_STATE(245)] = 19017,
  [SMALL_STATE(246)] = 19053,
  [SMALL_STATE(247)] = 19089,
  [SMALL_STATE(248)] = 19165,
  [SMALL_STATE(249)] = 19201,
  [SMALL_STATE(250)] = 19237,
  [SMALL_STATE(251)] = 19273,
  [SMALL_STATE(252)] = 19309,
  [SMALL_STATE(253)] = 19345,
  [SMALL_STATE(254)] = 19421,
  [SMALL_STATE(255)] = 19497,
  [SMALL_STATE(256)] = 19573,
  [SMALL_STATE(257)] = 19649,
  [SMALL_STATE(258)] = 19685,
  [SMALL_STATE(259)] = 19721,
  [SMALL_STATE(260)] = 19757,
  [SMALL_STATE(261)] = 19829,
  [SMALL_STATE(262)] = 19865,
  [SMALL_STATE(263)] = 19901,
  [SMALL_STATE(264)] = 19937,
  [SMALL_STATE(265)] = 19973,
  [SMALL_STATE(266)] = 20009,
  [SMALL_STATE(267)] = 20045,
  [SMALL_STATE(268)] = 20115,
  [SMALL_STATE(269)] = 20191,
  [SMALL_STATE(270)] = 20253,
  [SMALL_STATE(271)] = 20329,
  [SMALL_STATE(272)] = 20391,
  [SMALL_STATE(273)] = 20453,
  [SMALL_STATE(274)] = 20515,
  [SMALL_STATE(275)] = 20569,
  [SMALL_STATE(276)] = 20623,
  [SMALL_STATE(277)] = 20699,
  [SMALL_STATE(278)] = 20753,
  [SMALL_STATE(279)] = 20803,
  [SMALL_STATE(280)] = 20879,
  [SMALL_STATE(281)] = 20929,
  [SMALL_STATE(282)] = 20973,
  [SMALL_STATE(283)] = 21049,
  [SMALL_STATE(284)] = 21125,
  [SMALL_STATE(285)] = 21201,
  [SMALL_STATE(286)] = 21277,
  [SMALL_STATE(287)] = 21353,
  [SMALL_STATE(288)] = 21397,
  [SMALL_STATE(289)] = 21441,
  [SMALL_STATE(290)] = 21477,
  [SMALL_STATE(291)] = 21513,
  [SMALL_STATE(292)] = 21549,
  [SMALL_STATE(293)] = 21585,
  [SMALL_STATE(294)] = 21629,
  [SMALL_STATE(295)] = 21673,
  [SMALL_STATE(296)] = 21746,
  [SMALL_STATE(297)] = 21807,
  [SMALL_STATE(298)] = 21866,
  [SMALL_STATE(299)] = 21918,
  [SMALL_STATE(300)] = 21946,
  [SMALL_STATE(301)] = 21973,
  [SMALL_STATE(302)] = 21995,
  [SMALL_STATE(303)] = 22021,
  [SMALL_STATE(304)] = 22043,
  [SMALL_STATE(305)] = 22064,
  [SMALL_STATE(306)] = 22085,
  [SMALL_STATE(307)] = 22118,
  [SMALL_STATE(308)] = 22139,
  [SMALL_STATE(309)] = 22160,
  [SMALL_STATE(310)] = 22181,
  [SMALL_STATE(311)] = 22214,
  [SMALL_STATE(312)] = 22247,
  [SMALL_STATE(313)] = 22268,
  [SMALL_STATE(314)] = 22289,
  [SMALL_STATE(315)] = 22322,
  [SMALL_STATE(316)] = 22355,
  [SMALL_STATE(317)] = 22386,
  [SMALL_STATE(318)] = 22407,
  [SMALL_STATE(319)] = 22428,
  [SMALL_STATE(320)] = 22461,
  [SMALL_STATE(321)] = 22481,
  [SMALL_STATE(322)] = 22506,
  [SMALL_STATE(323)] = 22535,
  [SMALL_STATE(324)] = 22562,
  [SMALL_STATE(325)] = 22589,
  [SMALL_STATE(326)] = 22618,
  [SMALL_STATE(327)] = 22647,
  [SMALL_STATE(328)] = 22674,
  [SMALL_STATE(329)] = 22703,
  [SMALL_STATE(330)] = 22727,
  [SMALL_STATE(331)] = 22751,
  [SMALL_STATE(332)] = 22775,
  [SMALL_STATE(333)] = 22799,
  [SMALL_STATE(334)] = 22823,
  [SMALL_STATE(335)] = 22842,
  [SMALL_STATE(336)] = 22861,
  [SMALL_STATE(337)] = 22881,
  [SMALL_STATE(338)] = 22899,
  [SMALL_STATE(339)] = 22919,
  [SMALL_STATE(340)] = 22937,
  [SMALL_STATE(341)] = 22957,
  [SMALL_STATE(342)] = 22977,
  [SMALL_STATE(343)] = 22995,
  [SMALL_STATE(344)] = 23013,
  [SMALL_STATE(345)] = 23033,
  [SMALL_STATE(346)] = 23050,
  [SMALL_STATE(347)] = 23067,
  [SMALL_STATE(348)] = 23084,
  [SMALL_STATE(349)] = 23101,
  [SMALL_STATE(350)] = 23118,
  [SMALL_STATE(351)] = 23137,
  [SMALL_STATE(352)] = 23154,
  [SMALL_STATE(353)] = 23169,
  [SMALL_STATE(354)] = 23186,
  [SMALL_STATE(355)] = 23203,
  [SMALL_STATE(356)] = 23220,
  [SMALL_STATE(357)] = 23237,
  [SMALL_STATE(358)] = 23254,
  [SMALL_STATE(359)] = 23271,
  [SMALL_STATE(360)] = 23290,
  [SMALL_STATE(361)] = 23307,
  [SMALL_STATE(362)] = 23324,
  [SMALL_STATE(363)] = 23341,
  [SMALL_STATE(364)] = 23358,
  [SMALL_STATE(365)] = 23374,
  [SMALL_STATE(366)] = 23388,
  [SMALL_STATE(367)] = 23404,
  [SMALL_STATE(368)] = 23420,
  [SMALL_STATE(369)] = 23436,
  [SMALL_STATE(370)] = 23452,
  [SMALL_STATE(371)] = 23468,
  [SMALL_STATE(372)] = 23484,
  [SMALL_STATE(373)] = 23500,
  [SMALL_STATE(374)] = 23516,
  [SMALL_STATE(375)] = 23532,
  [SMALL_STATE(376)] = 23545,
  [SMALL_STATE(377)] = 23558,
  [SMALL_STATE(378)] = 23571,
  [SMALL_STATE(379)] = 23584,
  [SMALL_STATE(380)] = 23597,
  [SMALL_STATE(381)] = 23610,
  [SMALL_STATE(382)] = 23623,
  [SMALL_STATE(383)] = 23636,
  [SMALL_STATE(384)] = 23649,
  [SMALL_STATE(385)] = 23662,
  [SMALL_STATE(386)] = 23675,
  [SMALL_STATE(387)] = 23688,
  [SMALL_STATE(388)] = 23701,
  [SMALL_STATE(389)] = 23714,
  [SMALL_STATE(390)] = 23727,
  [SMALL_STATE(391)] = 23740,
  [SMALL_STATE(392)] = 23753,
  [SMALL_STATE(393)] = 23766,
  [SMALL_STATE(394)] = 23779,
  [SMALL_STATE(395)] = 23792,
  [SMALL_STATE(396)] = 23805,
  [SMALL_STATE(397)] = 23818,
  [SMALL_STATE(398)] = 23831,
  [SMALL_STATE(399)] = 23844,
  [SMALL_STATE(400)] = 23857,
  [SMALL_STATE(401)] = 23870,
  [SMALL_STATE(402)] = 23883,
  [SMALL_STATE(403)] = 23896,
  [SMALL_STATE(404)] = 23909,
  [SMALL_STATE(405)] = 23922,
  [SMALL_STATE(406)] = 23935,
  [SMALL_STATE(407)] = 23948,
  [SMALL_STATE(408)] = 23961,
  [SMALL_STATE(409)] = 23974,
  [SMALL_STATE(410)] = 23987,
  [SMALL_STATE(411)] = 24000,
  [SMALL_STATE(412)] = 24013,
  [SMALL_STATE(413)] = 24026,
  [SMALL_STATE(414)] = 24039,
  [SMALL_STATE(415)] = 24052,
  [SMALL_STATE(416)] = 24056,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(266),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(326),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(323),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [85] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(250),
  [88] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(27),
  [91] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(266),
  [94] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(265),
  [97] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(266),
  [100] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(306),
  [103] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(4),
  [106] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2),
  [108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(326),
  [111] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(388),
  [114] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(115),
  [117] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2), SHIFT_REPEAT(113),
  [120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [130] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [132] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [138] = {.entry = {.count = 1, .reusable = false}}, SHIFT(227),
  [140] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [148] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [152] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [158] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [162] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesizedExpression, 3),
  [166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesizedExpression, 3),
  [168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_propertyAccess, 3),
  [170] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_propertyAccess, 3),
  [172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ternaryOperation, 1),
  [174] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ternaryOperation, 1),
  [176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literalValue, 1),
  [178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__literalValue, 1),
  [180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_booleanLiteral, 1),
  [182] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_booleanLiteral, 1),
  [184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [186] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__primaryExpression, 1),
  [190] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__primaryExpression, 1),
  [192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 3),
  [194] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 3),
  [196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_resourceAccess, 3),
  [198] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_resourceAccess, 3),
  [200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variableAccess, 1),
  [202] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variableAccess, 1),
  [204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__memberExpression, 1),
  [206] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__memberExpression, 1),
  [208] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binaryOperation, 1),
  [210] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binaryOperation, 1),
  [212] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_functionCall, 3),
  [214] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_functionCall, 3),
  [216] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unaryOperation, 1),
  [218] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unaryOperation, 1),
  [220] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_object, 2),
  [222] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_object, 2),
  [224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 2),
  [226] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 2),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_functionCall, 4),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_functionCall, 4),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for, 8),
  [234] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for, 8),
  [236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for, 7),
  [238] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for, 7),
  [240] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 3),
  [242] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 3),
  [244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multilineString, 3),
  [246] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multilineString, 3),
  [248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arrayAccess, 4),
  [250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arrayAccess, 4),
  [252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier, 1),
  [254] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier, 1),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__subtraction, 3),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [270] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__subtraction, 3),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__addition, 3),
  [276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__addition, 3),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameterDefaultValue, 2),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [284] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [288] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [306] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_outputDeclaration, 5),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__notEquals, 3),
  [312] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__notEquals, 3),
  [314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__equals, 3),
  [316] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__equals, 3),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__lessThanOrEqual, 3),
  [320] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__lessThanOrEqual, 3),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__lessThan, 3),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__lessThan, 3),
  [326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__greaterThanOrEqual, 3),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__greaterThanOrEqual, 3),
  [330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__greaterThan, 3),
  [332] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__greaterThan, 3),
  [334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__coalesce, 3),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__division, 3),
  [338] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__division, 3),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__conditionalExpression, 5),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__modulo, 3),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__modulo, 3),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__multiplication, 3),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__multiplication, 3),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__negation, 2),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__negation, 2),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__minus, 2),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__minus, 2),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__logicalOr, 3),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__logicalOr, 3),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__logicalAnd, 3),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__logicalAnd, 3),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__notEqualsInsensitive, 3),
  [368] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__notEqualsInsensitive, 3),
  [370] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variableDeclaration, 4),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__equalsInsensitive, 3),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__equalsInsensitive, 3),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_targetScope, 3),
  [378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decorator, 2),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [398] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__coalesce, 3),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [416] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__conditionalExpression, 5),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [438] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [442] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [458] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_objectProperty, 3),
  [462] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_objectProperty, 3),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_functionArgument, 1),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(415),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(411),
  [474] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [478] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [480] = {.entry = {.count = 1, .reusable = false}}, SHIFT(353),
  [482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [484] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [486] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arrayItem, 1),
  [496] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [500] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [502] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [504] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [506] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [508] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [510] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [512] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [514] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [516] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [518] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [522] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [532] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [536] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [540] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [542] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__forBody, 1),
  [544] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [546] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [548] = {.entry = {.count = 1, .reusable = false}}, SHIFT(14),
  [550] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [552] = {.entry = {.count = 1, .reusable = false}}, SHIFT(9),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2),
  [558] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(410),
  [561] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(347),
  [564] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(358),
  [567] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(351),
  [570] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(355),
  [573] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(356),
  [576] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(357),
  [579] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(23),
  [582] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_array_repeat1, 2),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameterDeclaration, 3),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ifCondition, 3),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat1, 2),
  [592] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_repeat1, 2), SHIFT_REPEAT(23),
  [595] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1),
  [597] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_resourceDeclaration, 5),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_resourceDeclaration, 6),
  [601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(338),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameterDeclaration, 4),
  [609] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 1),
  [611] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [617] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_moduleDeclaration, 5),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_importDeclaration, 5),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [625] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_object_repeat1, 2), SHIFT_REPEAT(338),
  [628] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_object_repeat1, 2), SHIFT_REPEAT(143),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_object_repeat1, 2),
  [633] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_object_repeat1, 2), SHIFT_REPEAT(328),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__declaration, 1),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_repeat1, 1),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__stringContent_repeat1, 2),
  [646] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__stringContent_repeat1, 2), SHIFT_REPEAT(335),
  [649] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__stringContent_repeat1, 2), SHIFT_REPEAT(72),
  [652] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__stringContent, 1),
  [654] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [658] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [662] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [664] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [666] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [668] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [670] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [672] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [680] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [682] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__interpolation, 3),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__interpolation, 3),
  [686] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__stringContent_repeat1, 1),
  [688] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__stringContent_repeat1, 1),
  [690] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ifCondition, 3),
  [692] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_object_repeat1, 1),
  [694] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_object_repeat1, 1),
  [696] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_resourceDeclaration, 5),
  [698] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_resourceDeclaration, 6),
  [700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2),
  [702] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2), SHIFT_REPEAT(18),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__arguments, 2),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [709] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_localVariable, 1),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__arguments, 1),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [729] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_forVariableBlock, 5),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [765] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [773] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__stringContent, 2),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [791] = {.entry = {.count = 1, .reusable = false}}, SHIFT(380),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1),
  [801] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 3),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_bicep(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
