#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 615
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 137
#define ALIAS_COUNT 0
#define TOKEN_COUNT 69
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 30
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 94

enum {
  anon_sym_LF = 1,
  anon_sym_CR = 2,
  sym__eol = 3,
  aux_sym__any_token1 = 4,
  aux_sym__org_stars_token1 = 5,
  aux_sym_headline_token1 = 6,
  sym__indent = 7,
  sym__pipe = 8,
  sym_atat = 9,
  sym_at = 10,
  sym_lcurllcurl = 11,
  sym_rcurlrcurl = 12,
  sym_lcurl = 13,
  sym_rcurl = 14,
  sym__equal = 15,
  sym__comma = 16,
  sym__tilde = 17,
  sym__hash = 18,
  sym_asterisk = 19,
  sym_slash = 20,
  sym__colon = 21,
  sym_plus = 22,
  sym_minus = 23,
  sym__lparen = 24,
  sym__rparen = 25,
  sym_flag = 26,
  sym_TXN = 27,
  sym_BALANCE = 28,
  sym_OPEN = 29,
  sym_CLOSE = 30,
  sym_COMMODITY = 31,
  sym_PAD = 32,
  sym_EVENT = 33,
  sym_PRICE = 34,
  sym_NOTE = 35,
  sym_DOCUMENT = 36,
  sym_QUERY = 37,
  sym_CUSTOM = 38,
  sym_PUSHTAG = 39,
  sym_POPTAG = 40,
  sym_PUSHMETA = 41,
  sym_POPMETA = 42,
  sym_OPTION = 43,
  sym_INCLUDE = 44,
  sym_PLUGIN = 45,
  sym__none = 46,
  sym_bool = 47,
  sym_date = 48,
  sym_account = 49,
  sym_currency = 50,
  sym_string = 51,
  sym_number = 52,
  sym_tag = 53,
  sym_link = 54,
  sym_key = 55,
  anon_sym_SEMI = 56,
  sym__UTF_8_1 = 57,
  aux_sym__UTF_8_2_token1 = 58,
  aux_sym__UTF_8_3_token1 = 59,
  aux_sym__UTF_8_3_token2 = 60,
  aux_sym__UTF_8_3_token3 = 61,
  aux_sym__UTF_8_3_token4 = 62,
  aux_sym__UTF_8_4_token1 = 63,
  aux_sym__UTF_8_4_token2 = 64,
  aux_sym__UTF_8_4_token3 = 65,
  sym__stars = 66,
  sym__sectionend = 67,
  sym__eof = 68,
  sym_file = 69,
  sym__nl = 70,
  sym__any = 71,
  sym_section = 72,
  sym__org_stars = 73,
  sym_headline = 74,
  sym_item = 75,
  sym_txn = 76,
  sym__number_expr = 77,
  sym__paren__number_expr = 78,
  sym_unary_number_expr = 79,
  sym_binary_number_expr = 80,
  sym_txn_strings = 81,
  sym_tags_links = 82,
  sym_transaction = 83,
  sym_optflag = 84,
  sym_price_annotation = 85,
  sym_posting = 86,
  sym_key_value = 87,
  sym_key_value_line = 88,
  sym__key_value_value = 89,
  sym_posting_or_kv_list = 90,
  sym_key_value_list = 91,
  sym_currency_list = 92,
  sym_pushtag = 93,
  sym_poptag = 94,
  sym_pushmeta = 95,
  sym_popmeta = 96,
  sym_open = 97,
  sym_opt_booking = 98,
  sym_close = 99,
  sym_commodity = 100,
  sym_pad = 101,
  sym_balance = 102,
  sym_amount = 103,
  sym_amount_tolerance = 104,
  sym_compound_amount = 105,
  sym_incomplete_amount = 106,
  sym_cost_spec = 107,
  sym_cost_comp_list = 108,
  sym_cost_comp = 109,
  sym_price = 110,
  sym_event = 111,
  sym_query = 112,
  sym_note = 113,
  sym_filename = 114,
  sym_document = 115,
  sym_custom_value = 116,
  sym_custom_value_list = 117,
  sym_custom = 118,
  sym__entry = 119,
  sym_option = 120,
  sym_include = 121,
  sym_plugin = 122,
  sym__directive = 123,
  sym__declarations = 124,
  sym_comment = 125,
  sym__skipped_lines = 126,
  aux_sym_file_repeat1 = 127,
  aux_sym_section_repeat1 = 128,
  aux_sym_section_repeat2 = 129,
  aux_sym_tags_links_repeat1 = 130,
  aux_sym_posting_or_kv_list_repeat1 = 131,
  aux_sym_key_value_list_repeat1 = 132,
  aux_sym_currency_list_repeat1 = 133,
  aux_sym_open_repeat1 = 134,
  aux_sym_cost_comp_list_repeat1 = 135,
  aux_sym_custom_value_list_repeat1 = 136,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_LF] = "\n",
  [anon_sym_CR] = "\r",
  [sym__eol] = "_eol",
  [aux_sym__any_token1] = "_any_token1",
  [aux_sym__org_stars_token1] = "_org_stars_token1",
  [aux_sym_headline_token1] = "headline_token1",
  [sym__indent] = "_indent",
  [sym__pipe] = "_pipe",
  [sym_atat] = "atat",
  [sym_at] = "at",
  [sym_lcurllcurl] = "lcurllcurl",
  [sym_rcurlrcurl] = "rcurlrcurl",
  [sym_lcurl] = "lcurl",
  [sym_rcurl] = "rcurl",
  [sym__equal] = "_equal",
  [sym__comma] = "_comma",
  [sym__tilde] = "_tilde",
  [sym__hash] = "_hash",
  [sym_asterisk] = "asterisk",
  [sym_slash] = "slash",
  [sym__colon] = "_colon",
  [sym_plus] = "plus",
  [sym_minus] = "minus",
  [sym__lparen] = "_lparen",
  [sym__rparen] = "_rparen",
  [sym_flag] = "flag",
  [sym_TXN] = "TXN",
  [sym_BALANCE] = "balance",
  [sym_OPEN] = "open",
  [sym_CLOSE] = "close",
  [sym_COMMODITY] = "commodity",
  [sym_PAD] = "pad",
  [sym_EVENT] = "event",
  [sym_PRICE] = "price",
  [sym_NOTE] = "note",
  [sym_DOCUMENT] = "document",
  [sym_QUERY] = "query",
  [sym_CUSTOM] = "custom",
  [sym_PUSHTAG] = "pushtag",
  [sym_POPTAG] = "poptag",
  [sym_PUSHMETA] = "pushmeta",
  [sym_POPMETA] = "popmeta",
  [sym_OPTION] = "option",
  [sym_INCLUDE] = "include",
  [sym_PLUGIN] = "plugin",
  [sym__none] = "_none",
  [sym_bool] = "bool",
  [sym_date] = "date",
  [sym_account] = "account",
  [sym_currency] = "currency",
  [sym_string] = "string",
  [sym_number] = "number",
  [sym_tag] = "tag",
  [sym_link] = "link",
  [sym_key] = "key",
  [anon_sym_SEMI] = ";",
  [sym__UTF_8_1] = "_UTF_8_1",
  [aux_sym__UTF_8_2_token1] = "_UTF_8_2_token1",
  [aux_sym__UTF_8_3_token1] = "_UTF_8_3_token1",
  [aux_sym__UTF_8_3_token2] = "_UTF_8_3_token2",
  [aux_sym__UTF_8_3_token3] = "_UTF_8_3_token3",
  [aux_sym__UTF_8_3_token4] = "_UTF_8_3_token4",
  [aux_sym__UTF_8_4_token1] = "_UTF_8_4_token1",
  [aux_sym__UTF_8_4_token2] = "_UTF_8_4_token2",
  [aux_sym__UTF_8_4_token3] = "_UTF_8_4_token3",
  [sym__stars] = "_stars",
  [sym__sectionend] = "_sectionend",
  [sym__eof] = "_eof",
  [sym_file] = "file",
  [sym__nl] = "_nl",
  [sym__any] = "_any",
  [sym_section] = "section",
  [sym__org_stars] = "_org_stars",
  [sym_headline] = "headline",
  [sym_item] = "item",
  [sym_txn] = "txn",
  [sym__number_expr] = "_number_expr",
  [sym__paren__number_expr] = "_paren__number_expr",
  [sym_unary_number_expr] = "unary_number_expr",
  [sym_binary_number_expr] = "binary_number_expr",
  [sym_txn_strings] = "txn_strings",
  [sym_tags_links] = "tags_links",
  [sym_transaction] = "transaction",
  [sym_optflag] = "optflag",
  [sym_price_annotation] = "price_annotation",
  [sym_posting] = "posting",
  [sym_key_value] = "key_value",
  [sym_key_value_line] = "key_value_line",
  [sym__key_value_value] = "_key_value_value",
  [sym_posting_or_kv_list] = "posting_or_kv_list",
  [sym_key_value_list] = "key_value_list",
  [sym_currency_list] = "currency_list",
  [sym_pushtag] = "pushtag",
  [sym_poptag] = "poptag",
  [sym_pushmeta] = "pushmeta",
  [sym_popmeta] = "popmeta",
  [sym_open] = "open",
  [sym_opt_booking] = "opt_booking",
  [sym_close] = "close",
  [sym_commodity] = "commodity",
  [sym_pad] = "pad",
  [sym_balance] = "balance",
  [sym_amount] = "amount",
  [sym_amount_tolerance] = "amount_tolerance",
  [sym_compound_amount] = "compound_amount",
  [sym_incomplete_amount] = "incomplete_amount",
  [sym_cost_spec] = "cost_spec",
  [sym_cost_comp_list] = "cost_comp_list",
  [sym_cost_comp] = "cost_comp",
  [sym_price] = "price",
  [sym_event] = "event",
  [sym_query] = "query",
  [sym_note] = "note",
  [sym_filename] = "filename",
  [sym_document] = "document",
  [sym_custom_value] = "custom_value",
  [sym_custom_value_list] = "custom_value_list",
  [sym_custom] = "custom",
  [sym__entry] = "_entry",
  [sym_option] = "option",
  [sym_include] = "include",
  [sym_plugin] = "plugin",
  [sym__directive] = "_directive",
  [sym__declarations] = "_declarations",
  [sym_comment] = "comment",
  [sym__skipped_lines] = "_skipped_lines",
  [aux_sym_file_repeat1] = "file_repeat1",
  [aux_sym_section_repeat1] = "section_repeat1",
  [aux_sym_section_repeat2] = "section_repeat2",
  [aux_sym_tags_links_repeat1] = "tags_links_repeat1",
  [aux_sym_posting_or_kv_list_repeat1] = "posting_or_kv_list_repeat1",
  [aux_sym_key_value_list_repeat1] = "key_value_list_repeat1",
  [aux_sym_currency_list_repeat1] = "currency_list_repeat1",
  [aux_sym_open_repeat1] = "open_repeat1",
  [aux_sym_cost_comp_list_repeat1] = "cost_comp_list_repeat1",
  [aux_sym_custom_value_list_repeat1] = "custom_value_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR] = anon_sym_CR,
  [sym__eol] = sym__eol,
  [aux_sym__any_token1] = aux_sym__any_token1,
  [aux_sym__org_stars_token1] = aux_sym__org_stars_token1,
  [aux_sym_headline_token1] = aux_sym_headline_token1,
  [sym__indent] = sym__indent,
  [sym__pipe] = sym__pipe,
  [sym_atat] = sym_atat,
  [sym_at] = sym_at,
  [sym_lcurllcurl] = sym_lcurllcurl,
  [sym_rcurlrcurl] = sym_rcurlrcurl,
  [sym_lcurl] = sym_lcurl,
  [sym_rcurl] = sym_rcurl,
  [sym__equal] = sym__equal,
  [sym__comma] = sym__comma,
  [sym__tilde] = sym__tilde,
  [sym__hash] = sym__hash,
  [sym_asterisk] = sym_asterisk,
  [sym_slash] = sym_slash,
  [sym__colon] = sym__colon,
  [sym_plus] = sym_plus,
  [sym_minus] = sym_minus,
  [sym__lparen] = sym__lparen,
  [sym__rparen] = sym__rparen,
  [sym_flag] = sym_flag,
  [sym_TXN] = sym_TXN,
  [sym_BALANCE] = sym_BALANCE,
  [sym_OPEN] = sym_OPEN,
  [sym_CLOSE] = sym_CLOSE,
  [sym_COMMODITY] = sym_COMMODITY,
  [sym_PAD] = sym_PAD,
  [sym_EVENT] = sym_EVENT,
  [sym_PRICE] = sym_PRICE,
  [sym_NOTE] = sym_NOTE,
  [sym_DOCUMENT] = sym_DOCUMENT,
  [sym_QUERY] = sym_QUERY,
  [sym_CUSTOM] = sym_CUSTOM,
  [sym_PUSHTAG] = sym_PUSHTAG,
  [sym_POPTAG] = sym_POPTAG,
  [sym_PUSHMETA] = sym_PUSHMETA,
  [sym_POPMETA] = sym_POPMETA,
  [sym_OPTION] = sym_OPTION,
  [sym_INCLUDE] = sym_INCLUDE,
  [sym_PLUGIN] = sym_PLUGIN,
  [sym__none] = sym__none,
  [sym_bool] = sym_bool,
  [sym_date] = sym_date,
  [sym_account] = sym_account,
  [sym_currency] = sym_currency,
  [sym_string] = sym_string,
  [sym_number] = sym_number,
  [sym_tag] = sym_tag,
  [sym_link] = sym_link,
  [sym_key] = sym_key,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [sym__UTF_8_1] = sym__UTF_8_1,
  [aux_sym__UTF_8_2_token1] = aux_sym__UTF_8_2_token1,
  [aux_sym__UTF_8_3_token1] = aux_sym__UTF_8_3_token1,
  [aux_sym__UTF_8_3_token2] = aux_sym__UTF_8_3_token2,
  [aux_sym__UTF_8_3_token3] = aux_sym__UTF_8_3_token3,
  [aux_sym__UTF_8_3_token4] = aux_sym__UTF_8_3_token4,
  [aux_sym__UTF_8_4_token1] = aux_sym__UTF_8_4_token1,
  [aux_sym__UTF_8_4_token2] = aux_sym__UTF_8_4_token2,
  [aux_sym__UTF_8_4_token3] = aux_sym__UTF_8_4_token3,
  [sym__stars] = sym__stars,
  [sym__sectionend] = sym__sectionend,
  [sym__eof] = sym__eof,
  [sym_file] = sym_file,
  [sym__nl] = sym__nl,
  [sym__any] = sym__any,
  [sym_section] = sym_section,
  [sym__org_stars] = sym__org_stars,
  [sym_headline] = sym_headline,
  [sym_item] = sym_item,
  [sym_txn] = sym_txn,
  [sym__number_expr] = sym__number_expr,
  [sym__paren__number_expr] = sym__paren__number_expr,
  [sym_unary_number_expr] = sym_unary_number_expr,
  [sym_binary_number_expr] = sym_binary_number_expr,
  [sym_txn_strings] = sym_txn_strings,
  [sym_tags_links] = sym_tags_links,
  [sym_transaction] = sym_transaction,
  [sym_optflag] = sym_optflag,
  [sym_price_annotation] = sym_price_annotation,
  [sym_posting] = sym_posting,
  [sym_key_value] = sym_key_value,
  [sym_key_value_line] = sym_key_value_line,
  [sym__key_value_value] = sym__key_value_value,
  [sym_posting_or_kv_list] = sym_posting_or_kv_list,
  [sym_key_value_list] = sym_key_value_list,
  [sym_currency_list] = sym_currency_list,
  [sym_pushtag] = sym_pushtag,
  [sym_poptag] = sym_poptag,
  [sym_pushmeta] = sym_pushmeta,
  [sym_popmeta] = sym_popmeta,
  [sym_open] = sym_open,
  [sym_opt_booking] = sym_opt_booking,
  [sym_close] = sym_close,
  [sym_commodity] = sym_commodity,
  [sym_pad] = sym_pad,
  [sym_balance] = sym_balance,
  [sym_amount] = sym_amount,
  [sym_amount_tolerance] = sym_amount_tolerance,
  [sym_compound_amount] = sym_compound_amount,
  [sym_incomplete_amount] = sym_incomplete_amount,
  [sym_cost_spec] = sym_cost_spec,
  [sym_cost_comp_list] = sym_cost_comp_list,
  [sym_cost_comp] = sym_cost_comp,
  [sym_price] = sym_price,
  [sym_event] = sym_event,
  [sym_query] = sym_query,
  [sym_note] = sym_note,
  [sym_filename] = sym_filename,
  [sym_document] = sym_document,
  [sym_custom_value] = sym_custom_value,
  [sym_custom_value_list] = sym_custom_value_list,
  [sym_custom] = sym_custom,
  [sym__entry] = sym__entry,
  [sym_option] = sym_option,
  [sym_include] = sym_include,
  [sym_plugin] = sym_plugin,
  [sym__directive] = sym__directive,
  [sym__declarations] = sym__declarations,
  [sym_comment] = sym_comment,
  [sym__skipped_lines] = sym__skipped_lines,
  [aux_sym_file_repeat1] = aux_sym_file_repeat1,
  [aux_sym_section_repeat1] = aux_sym_section_repeat1,
  [aux_sym_section_repeat2] = aux_sym_section_repeat2,
  [aux_sym_tags_links_repeat1] = aux_sym_tags_links_repeat1,
  [aux_sym_posting_or_kv_list_repeat1] = aux_sym_posting_or_kv_list_repeat1,
  [aux_sym_key_value_list_repeat1] = aux_sym_key_value_list_repeat1,
  [aux_sym_currency_list_repeat1] = aux_sym_currency_list_repeat1,
  [aux_sym_open_repeat1] = aux_sym_open_repeat1,
  [aux_sym_cost_comp_list_repeat1] = aux_sym_cost_comp_list_repeat1,
  [aux_sym_custom_value_list_repeat1] = aux_sym_custom_value_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [sym__eol] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__any_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__org_stars_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_headline_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__pipe] = {
    .visible = false,
    .named = true,
  },
  [sym_atat] = {
    .visible = true,
    .named = true,
  },
  [sym_at] = {
    .visible = true,
    .named = true,
  },
  [sym_lcurllcurl] = {
    .visible = true,
    .named = true,
  },
  [sym_rcurlrcurl] = {
    .visible = true,
    .named = true,
  },
  [sym_lcurl] = {
    .visible = true,
    .named = true,
  },
  [sym_rcurl] = {
    .visible = true,
    .named = true,
  },
  [sym__equal] = {
    .visible = false,
    .named = true,
  },
  [sym__comma] = {
    .visible = false,
    .named = true,
  },
  [sym__tilde] = {
    .visible = false,
    .named = true,
  },
  [sym__hash] = {
    .visible = false,
    .named = true,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_slash] = {
    .visible = true,
    .named = true,
  },
  [sym__colon] = {
    .visible = false,
    .named = true,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym__lparen] = {
    .visible = false,
    .named = true,
  },
  [sym__rparen] = {
    .visible = false,
    .named = true,
  },
  [sym_flag] = {
    .visible = true,
    .named = true,
  },
  [sym_TXN] = {
    .visible = true,
    .named = true,
  },
  [sym_BALANCE] = {
    .visible = true,
    .named = false,
  },
  [sym_OPEN] = {
    .visible = true,
    .named = false,
  },
  [sym_CLOSE] = {
    .visible = true,
    .named = false,
  },
  [sym_COMMODITY] = {
    .visible = true,
    .named = false,
  },
  [sym_PAD] = {
    .visible = true,
    .named = false,
  },
  [sym_EVENT] = {
    .visible = true,
    .named = false,
  },
  [sym_PRICE] = {
    .visible = true,
    .named = false,
  },
  [sym_NOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_DOCUMENT] = {
    .visible = true,
    .named = false,
  },
  [sym_QUERY] = {
    .visible = true,
    .named = false,
  },
  [sym_CUSTOM] = {
    .visible = true,
    .named = false,
  },
  [sym_PUSHTAG] = {
    .visible = true,
    .named = false,
  },
  [sym_POPTAG] = {
    .visible = true,
    .named = false,
  },
  [sym_PUSHMETA] = {
    .visible = true,
    .named = false,
  },
  [sym_POPMETA] = {
    .visible = true,
    .named = false,
  },
  [sym_OPTION] = {
    .visible = true,
    .named = false,
  },
  [sym_INCLUDE] = {
    .visible = true,
    .named = false,
  },
  [sym_PLUGIN] = {
    .visible = true,
    .named = false,
  },
  [sym__none] = {
    .visible = false,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_date] = {
    .visible = true,
    .named = true,
  },
  [sym_account] = {
    .visible = true,
    .named = true,
  },
  [sym_currency] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_link] = {
    .visible = true,
    .named = true,
  },
  [sym_key] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [sym__UTF_8_1] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__UTF_8_2_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__UTF_8_3_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__UTF_8_3_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__UTF_8_3_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__UTF_8_3_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__UTF_8_4_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__UTF_8_4_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__UTF_8_4_token3] = {
    .visible = false,
    .named = false,
  },
  [sym__stars] = {
    .visible = false,
    .named = true,
  },
  [sym__sectionend] = {
    .visible = false,
    .named = true,
  },
  [sym__eof] = {
    .visible = false,
    .named = true,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym__nl] = {
    .visible = false,
    .named = true,
  },
  [sym__any] = {
    .visible = false,
    .named = true,
  },
  [sym_section] = {
    .visible = true,
    .named = true,
  },
  [sym__org_stars] = {
    .visible = false,
    .named = true,
  },
  [sym_headline] = {
    .visible = true,
    .named = true,
  },
  [sym_item] = {
    .visible = true,
    .named = true,
  },
  [sym_txn] = {
    .visible = true,
    .named = true,
  },
  [sym__number_expr] = {
    .visible = false,
    .named = true,
  },
  [sym__paren__number_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_number_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_number_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_txn_strings] = {
    .visible = true,
    .named = true,
  },
  [sym_tags_links] = {
    .visible = true,
    .named = true,
  },
  [sym_transaction] = {
    .visible = true,
    .named = true,
  },
  [sym_optflag] = {
    .visible = true,
    .named = true,
  },
  [sym_price_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_posting] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value_line] = {
    .visible = true,
    .named = true,
  },
  [sym__key_value_value] = {
    .visible = false,
    .named = true,
  },
  [sym_posting_or_kv_list] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value_list] = {
    .visible = true,
    .named = true,
  },
  [sym_currency_list] = {
    .visible = true,
    .named = true,
  },
  [sym_pushtag] = {
    .visible = true,
    .named = true,
  },
  [sym_poptag] = {
    .visible = true,
    .named = true,
  },
  [sym_pushmeta] = {
    .visible = true,
    .named = true,
  },
  [sym_popmeta] = {
    .visible = true,
    .named = true,
  },
  [sym_open] = {
    .visible = true,
    .named = true,
  },
  [sym_opt_booking] = {
    .visible = true,
    .named = true,
  },
  [sym_close] = {
    .visible = true,
    .named = true,
  },
  [sym_commodity] = {
    .visible = true,
    .named = true,
  },
  [sym_pad] = {
    .visible = true,
    .named = true,
  },
  [sym_balance] = {
    .visible = true,
    .named = true,
  },
  [sym_amount] = {
    .visible = true,
    .named = true,
  },
  [sym_amount_tolerance] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_amount] = {
    .visible = true,
    .named = true,
  },
  [sym_incomplete_amount] = {
    .visible = true,
    .named = true,
  },
  [sym_cost_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_cost_comp_list] = {
    .visible = true,
    .named = true,
  },
  [sym_cost_comp] = {
    .visible = true,
    .named = true,
  },
  [sym_price] = {
    .visible = true,
    .named = true,
  },
  [sym_event] = {
    .visible = true,
    .named = true,
  },
  [sym_query] = {
    .visible = true,
    .named = true,
  },
  [sym_note] = {
    .visible = true,
    .named = true,
  },
  [sym_filename] = {
    .visible = true,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_custom_value] = {
    .visible = true,
    .named = true,
  },
  [sym_custom_value_list] = {
    .visible = true,
    .named = true,
  },
  [sym_custom] = {
    .visible = true,
    .named = true,
  },
  [sym__entry] = {
    .visible = false,
    .named = true,
  },
  [sym_option] = {
    .visible = true,
    .named = true,
  },
  [sym_include] = {
    .visible = true,
    .named = true,
  },
  [sym_plugin] = {
    .visible = true,
    .named = true,
  },
  [sym__directive] = {
    .visible = false,
    .named = true,
  },
  [sym__declarations] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__skipped_lines] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_section_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tags_links_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_posting_or_kv_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_key_value_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_currency_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_open_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cost_comp_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_custom_value_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_account = 1,
  field_amount = 2,
  field_comment = 3,
  field_cost_comp_list = 4,
  field_cost_spec = 5,
  field_currencies = 6,
  field_currency = 7,
  field_custom_value_list = 8,
  field_date = 9,
  field_desc = 10,
  field_filename = 11,
  field_from_account = 12,
  field_headline = 13,
  field_item = 14,
  field_key = 15,
  field_name = 16,
  field_note = 17,
  field_opt_booking = 18,
  field_optflag = 19,
  field_per = 20,
  field_posting_or_kv_list = 21,
  field_price_annotation = 22,
  field_query = 23,
  field_subsection = 24,
  field_tags_links = 25,
  field_total = 26,
  field_txn = 27,
  field_txn_strings = 28,
  field_type = 29,
  field_value = 30,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_account] = "account",
  [field_amount] = "amount",
  [field_comment] = "comment",
  [field_cost_comp_list] = "cost_comp_list",
  [field_cost_spec] = "cost_spec",
  [field_currencies] = "currencies",
  [field_currency] = "currency",
  [field_custom_value_list] = "custom_value_list",
  [field_date] = "date",
  [field_desc] = "desc",
  [field_filename] = "filename",
  [field_from_account] = "from_account",
  [field_headline] = "headline",
  [field_item] = "item",
  [field_key] = "key",
  [field_name] = "name",
  [field_note] = "note",
  [field_opt_booking] = "opt_booking",
  [field_optflag] = "optflag",
  [field_per] = "per",
  [field_posting_or_kv_list] = "posting_or_kv_list",
  [field_price_annotation] = "price_annotation",
  [field_query] = "query",
  [field_subsection] = "subsection",
  [field_tags_links] = "tags_links",
  [field_total] = "total",
  [field_txn] = "txn",
  [field_txn_strings] = "txn_strings",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 2},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 2},
  [7] = {.index = 10, .length = 2},
  [8] = {.index = 12, .length = 2},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 3},
  [11] = {.index = 19, .length = 3},
  [12] = {.index = 22, .length = 3},
  [13] = {.index = 25, .length = 3},
  [14] = {.index = 28, .length = 1},
  [15] = {.index = 29, .length = 2},
  [16] = {.index = 31, .length = 3},
  [17] = {.index = 34, .length = 3},
  [18] = {.index = 37, .length = 3},
  [19] = {.index = 40, .length = 3},
  [20] = {.index = 43, .length = 3},
  [21] = {.index = 46, .length = 3},
  [22] = {.index = 49, .length = 3},
  [23] = {.index = 52, .length = 3},
  [24] = {.index = 55, .length = 3},
  [25] = {.index = 58, .length = 3},
  [26] = {.index = 61, .length = 3},
  [27] = {.index = 64, .length = 3},
  [28] = {.index = 67, .length = 4},
  [29] = {.index = 71, .length = 4},
  [30] = {.index = 75, .length = 4},
  [31] = {.index = 79, .length = 4},
  [32] = {.index = 83, .length = 4},
  [33] = {.index = 87, .length = 4},
  [34] = {.index = 91, .length = 4},
  [35] = {.index = 95, .length = 4},
  [36] = {.index = 99, .length = 4},
  [37] = {.index = 103, .length = 4},
  [38] = {.index = 107, .length = 4},
  [39] = {.index = 111, .length = 4},
  [40] = {.index = 115, .length = 1},
  [41] = {.index = 116, .length = 5},
  [42] = {.index = 121, .length = 5},
  [43] = {.index = 126, .length = 5},
  [44] = {.index = 131, .length = 5},
  [45] = {.index = 136, .length = 5},
  [46] = {.index = 141, .length = 1},
  [47] = {.index = 142, .length = 1},
  [48] = {.index = 143, .length = 2},
  [49] = {.index = 145, .length = 2},
  [50] = {.index = 147, .length = 2},
  [51] = {.index = 149, .length = 2},
  [52] = {.index = 151, .length = 6},
  [53] = {.index = 157, .length = 2},
  [54] = {.index = 159, .length = 2},
  [55] = {.index = 161, .length = 1},
  [56] = {.index = 162, .length = 2},
  [57] = {.index = 164, .length = 1},
  [58] = {.index = 165, .length = 3},
  [59] = {.index = 168, .length = 3},
  [60] = {.index = 171, .length = 3},
  [61] = {.index = 174, .length = 3},
  [62] = {.index = 177, .length = 3},
  [63] = {.index = 180, .length = 3},
  [64] = {.index = 183, .length = 3},
  [65] = {.index = 186, .length = 2},
  [66] = {.index = 188, .length = 2},
  [67] = {.index = 190, .length = 3},
  [68] = {.index = 193, .length = 3},
  [69] = {.index = 196, .length = 4},
  [70] = {.index = 200, .length = 3},
  [71] = {.index = 203, .length = 3},
  [72] = {.index = 206, .length = 3},
  [73] = {.index = 209, .length = 3},
  [74] = {.index = 212, .length = 4},
  [75] = {.index = 216, .length = 4},
  [76] = {.index = 220, .length = 4},
  [77] = {.index = 224, .length = 3},
  [78] = {.index = 227, .length = 4},
  [79] = {.index = 231, .length = 4},
  [80] = {.index = 235, .length = 4},
  [81] = {.index = 239, .length = 4},
  [82] = {.index = 243, .length = 4},
  [83] = {.index = 247, .length = 4},
  [84] = {.index = 251, .length = 4},
  [85] = {.index = 255, .length = 5},
  [86] = {.index = 260, .length = 4},
  [87] = {.index = 264, .length = 4},
  [88] = {.index = 268, .length = 5},
  [89] = {.index = 273, .length = 5},
  [90] = {.index = 278, .length = 5},
  [91] = {.index = 283, .length = 5},
  [92] = {.index = 288, .length = 5},
  [93] = {.index = 293, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_headline, 0},
  [1] =
    {field_subsection, 0},
  [2] =
    {field_date, 0},
    {field_txn, 1},
  [4] =
    {field_headline, 0},
    {field_subsection, 1, .inherited = true},
  [6] =
    {field_subsection, 0, .inherited = true},
    {field_subsection, 1, .inherited = true},
  [8] =
    {field_key, 1},
    {field_value, 2},
  [10] =
    {field_account, 2},
    {field_date, 0},
  [12] =
    {field_currency, 2},
    {field_date, 0},
  [14] =
    {field_date, 0},
    {field_name, 2},
  [16] =
    {field_date, 0},
    {field_posting_or_kv_list, 3},
    {field_txn, 1},
  [19] =
    {field_date, 0},
    {field_txn, 1},
    {field_txn_strings, 2},
  [22] =
    {field_date, 0},
    {field_tags_links, 2},
    {field_txn, 1},
  [25] =
    {field_comment, 2},
    {field_date, 0},
    {field_txn, 1},
  [28] =
    {field_item, 2},
  [29] =
    {field_headline, 0},
    {field_subsection, 2, .inherited = true},
  [31] =
    {field_account, 2},
    {field_amount, 3},
    {field_date, 0},
  [34] =
    {field_account, 2},
    {field_date, 0},
    {field_opt_booking, 3},
  [37] =
    {field_account, 2},
    {field_comment, 3},
    {field_date, 0},
  [40] =
    {field_account, 2},
    {field_currencies, 3},
    {field_date, 0},
  [43] =
    {field_comment, 3},
    {field_currency, 2},
    {field_date, 0},
  [46] =
    {field_account, 2},
    {field_date, 0},
    {field_from_account, 3},
  [49] =
    {field_date, 0},
    {field_desc, 3},
    {field_type, 2},
  [52] =
    {field_amount, 3},
    {field_currency, 2},
    {field_date, 0},
  [55] =
    {field_account, 2},
    {field_date, 0},
    {field_note, 3},
  [58] =
    {field_account, 2},
    {field_date, 0},
    {field_filename, 3},
  [61] =
    {field_date, 0},
    {field_name, 2},
    {field_query, 3},
  [64] =
    {field_custom_value_list, 3},
    {field_date, 0},
    {field_name, 2},
  [67] =
    {field_date, 0},
    {field_posting_or_kv_list, 4},
    {field_txn, 1},
    {field_txn_strings, 2},
  [71] =
    {field_date, 0},
    {field_tags_links, 3},
    {field_txn, 1},
    {field_txn_strings, 2},
  [75] =
    {field_comment, 3},
    {field_date, 0},
    {field_txn, 1},
    {field_txn_strings, 2},
  [79] =
    {field_date, 0},
    {field_posting_or_kv_list, 4},
    {field_tags_links, 2},
    {field_txn, 1},
  [83] =
    {field_comment, 3},
    {field_date, 0},
    {field_tags_links, 2},
    {field_txn, 1},
  [87] =
    {field_comment, 2},
    {field_date, 0},
    {field_posting_or_kv_list, 4},
    {field_txn, 1},
  [91] =
    {field_account, 2},
    {field_amount, 3},
    {field_comment, 4},
    {field_date, 0},
  [95] =
    {field_account, 2},
    {field_comment, 4},
    {field_date, 0},
    {field_opt_booking, 3},
  [99] =
    {field_account, 2},
    {field_currencies, 3},
    {field_date, 0},
    {field_opt_booking, 4},
  [103] =
    {field_account, 2},
    {field_comment, 4},
    {field_currencies, 3},
    {field_date, 0},
  [107] =
    {field_account, 2},
    {field_comment, 4},
    {field_date, 0},
    {field_from_account, 3},
  [111] =
    {field_account, 2},
    {field_date, 0},
    {field_filename, 3},
    {field_tags_links, 4},
  [115] =
    {field_account, 1},
  [116] =
    {field_date, 0},
    {field_posting_or_kv_list, 5},
    {field_tags_links, 3},
    {field_txn, 1},
    {field_txn_strings, 2},
  [121] =
    {field_comment, 4},
    {field_date, 0},
    {field_tags_links, 3},
    {field_txn, 1},
    {field_txn_strings, 2},
  [126] =
    {field_comment, 3},
    {field_date, 0},
    {field_posting_or_kv_list, 5},
    {field_txn, 1},
    {field_txn_strings, 2},
  [131] =
    {field_comment, 3},
    {field_date, 0},
    {field_posting_or_kv_list, 5},
    {field_tags_links, 2},
    {field_txn, 1},
  [136] =
    {field_account, 2},
    {field_comment, 5},
    {field_currencies, 3},
    {field_date, 0},
    {field_opt_booking, 4},
  [141] =
    {field_currency, 0},
  [142] =
    {field_per, 0},
  [143] =
    {field_account, 1},
    {field_amount, 2},
  [145] =
    {field_account, 1},
    {field_cost_spec, 2},
  [147] =
    {field_account, 1},
    {field_comment, 2},
  [149] =
    {field_account, 2},
    {field_optflag, 1},
  [151] =
    {field_comment, 4},
    {field_date, 0},
    {field_posting_or_kv_list, 6},
    {field_tags_links, 3},
    {field_txn, 1},
    {field_txn_strings, 2},
  [157] =
    {field_account, 1},
    {field_price_annotation, 3},
  [159] =
    {field_account, 1},
    {field_comment, 3},
  [161] =
    {field_currency, 1},
  [162] =
    {field_currency, 1},
    {field_per, 0},
  [164] =
    {field_cost_comp_list, 1},
  [165] =
    {field_account, 1},
    {field_amount, 2},
    {field_cost_spec, 3},
  [168] =
    {field_account, 1},
    {field_amount, 2},
    {field_comment, 3},
  [171] =
    {field_account, 1},
    {field_comment, 3},
    {field_cost_spec, 2},
  [174] =
    {field_account, 2},
    {field_amount, 3},
    {field_optflag, 1},
  [177] =
    {field_account, 2},
    {field_cost_spec, 3},
    {field_optflag, 1},
  [180] =
    {field_account, 2},
    {field_comment, 3},
    {field_optflag, 1},
  [183] =
    {field_account, 1},
    {field_comment, 4},
    {field_price_annotation, 3},
  [186] =
    {field_currency, 2},
    {field_total, 1},
  [188] =
    {field_currency, 2},
    {field_per, 0},
  [190] =
    {field_account, 1},
    {field_amount, 2},
    {field_price_annotation, 4},
  [193] =
    {field_account, 1},
    {field_amount, 2},
    {field_comment, 4},
  [196] =
    {field_account, 1},
    {field_amount, 2},
    {field_comment, 4},
    {field_cost_spec, 3},
  [200] =
    {field_account, 1},
    {field_cost_spec, 2},
    {field_price_annotation, 4},
  [203] =
    {field_account, 1},
    {field_comment, 4},
    {field_cost_spec, 2},
  [206] =
    {field_account, 2},
    {field_optflag, 1},
    {field_price_annotation, 4},
  [209] =
    {field_account, 2},
    {field_comment, 4},
    {field_optflag, 1},
  [212] =
    {field_account, 2},
    {field_amount, 3},
    {field_cost_spec, 4},
    {field_optflag, 1},
  [216] =
    {field_account, 2},
    {field_amount, 3},
    {field_comment, 4},
    {field_optflag, 1},
  [220] =
    {field_account, 2},
    {field_comment, 4},
    {field_cost_spec, 3},
    {field_optflag, 1},
  [224] =
    {field_currency, 3},
    {field_per, 0},
    {field_total, 2},
  [227] =
    {field_account, 1},
    {field_amount, 2},
    {field_comment, 5},
    {field_price_annotation, 4},
  [231] =
    {field_account, 1},
    {field_amount, 2},
    {field_cost_spec, 3},
    {field_price_annotation, 5},
  [235] =
    {field_account, 1},
    {field_amount, 2},
    {field_comment, 5},
    {field_cost_spec, 3},
  [239] =
    {field_account, 1},
    {field_comment, 5},
    {field_cost_spec, 2},
    {field_price_annotation, 4},
  [243] =
    {field_account, 2},
    {field_comment, 5},
    {field_optflag, 1},
    {field_price_annotation, 4},
  [247] =
    {field_account, 2},
    {field_amount, 3},
    {field_optflag, 1},
    {field_price_annotation, 5},
  [251] =
    {field_account, 2},
    {field_amount, 3},
    {field_comment, 5},
    {field_optflag, 1},
  [255] =
    {field_account, 2},
    {field_amount, 3},
    {field_comment, 5},
    {field_cost_spec, 4},
    {field_optflag, 1},
  [260] =
    {field_account, 2},
    {field_cost_spec, 3},
    {field_optflag, 1},
    {field_price_annotation, 5},
  [264] =
    {field_account, 2},
    {field_comment, 5},
    {field_cost_spec, 3},
    {field_optflag, 1},
  [268] =
    {field_account, 1},
    {field_amount, 2},
    {field_comment, 6},
    {field_cost_spec, 3},
    {field_price_annotation, 5},
  [273] =
    {field_account, 2},
    {field_amount, 3},
    {field_comment, 6},
    {field_optflag, 1},
    {field_price_annotation, 5},
  [278] =
    {field_account, 2},
    {field_amount, 3},
    {field_cost_spec, 4},
    {field_optflag, 1},
    {field_price_annotation, 6},
  [283] =
    {field_account, 2},
    {field_amount, 3},
    {field_comment, 6},
    {field_cost_spec, 4},
    {field_optflag, 1},
  [288] =
    {field_account, 2},
    {field_comment, 6},
    {field_cost_spec, 3},
    {field_optflag, 1},
    {field_price_annotation, 5},
  [293] =
    {field_account, 2},
    {field_amount, 3},
    {field_comment, 7},
    {field_cost_spec, 4},
    {field_optflag, 1},
    {field_price_annotation, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym_flag_character_set_1(int32_t c) {
  return (c < '?'
    ? (c < '%'
      ? (c < '#'
        ? c == '!'
        : c <= '#')
      : (c <= '&' || c == '*'))
    : (c <= '?' || (c < 'P'
      ? (c < 'M'
        ? c == 'C'
        : c <= 'M')
      : (c <= 'P' || (c >= 'R' && c <= 'U')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(177);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '\n') ADVANCE(178);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '#') ADVANCE(201);
      if (lookahead == '(') ADVANCE(208);
      if (lookahead == ')') ADVANCE(209);
      if (lookahead == '*') ADVANCE(203);
      if (lookahead == '+') ADVANCE(206);
      if (lookahead == ',') ADVANCE(198);
      if (lookahead == '-') ADVANCE(207);
      if (lookahead == '/') ADVANCE(204);
      if (lookahead == ':') ADVANCE(205);
      if (lookahead == ';') ADVANCE(301);
      if (lookahead == '=') ADVANCE(197);
      if (lookahead == '@') ADVANCE(191);
      if (lookahead == 'N') ADVANCE(42);
      if (lookahead == '^') ADVANCE(173);
      if (lookahead == 'b') ADVANCE(43);
      if (lookahead == 'c') ADVANCE(80);
      if (lookahead == 'd') ADVANCE(96);
      if (lookahead == 'e') ADVANCE(122);
      if (lookahead == 'i') ADVANCE(92);
      if (lookahead == 'n') ADVANCE(97);
      if (lookahead == 'o') ADVANCE(102);
      if (lookahead == 'p') ADVANCE(44);
      if (lookahead == 'q') ADVANCE(119);
      if (lookahead == 't') ADVANCE(123);
      if (lookahead == '{') ADVANCE(194);
      if (lookahead == '|') ADVANCE(189);
      if (lookahead == '}') ADVANCE(196);
      if (lookahead == '~') ADVANCE(199);
      if (lookahead == 224) ADVANCE(168);
      if (lookahead == 237) ADVANCE(167);
      if (lookahead == 240) ADVANCE(170);
      if (lookahead == 244) ADVANCE(166);
      if (lookahead == '1' ||
          lookahead == '2') ADVANCE(295);
      if (lookahead == 238 ||
          lookahead == 239) ADVANCE(307);
      if ((241 <= lookahead && lookahead <= 243)) ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '?' ||
          lookahead == 'C' ||
          lookahead == 'M' ||
          lookahead == 'P' ||
          ('R' <= lookahead && lookahead <= 'U')) ADVANCE(210);
      if ((225 <= lookahead && lookahead <= 236)) ADVANCE(305);
      if ((194 <= lookahead && lookahead <= 223)) ADVANCE(303);
      if ((128 <= lookahead && lookahead <= 191)) ADVANCE(302);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(291);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == ',') ADVANCE(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      END_STATE();
    case 3:
      if (lookahead == '-') ADVANCE(30);
      END_STATE();
    case 4:
      if (lookahead == '-') ADVANCE(31);
      END_STATE();
    case 5:
      if (lookahead == '-') ADVANCE(38);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(169);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(267);
      END_STATE();
    case 6:
      if (lookahead == '-') ADVANCE(5);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(139);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(239);
      END_STATE();
    case 7:
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(142);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(242);
      END_STATE();
    case 8:
      if (lookahead == '-') ADVANCE(6);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(140);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(240);
      END_STATE();
    case 9:
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(144);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(244);
      END_STATE();
    case 10:
      if (lookahead == '-') ADVANCE(7);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(141);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(241);
      END_STATE();
    case 11:
      if (lookahead == '-') ADVANCE(12);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(146);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(246);
      END_STATE();
    case 12:
      if (lookahead == '-') ADVANCE(9);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(143);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(243);
      END_STATE();
    case 13:
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(148);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(248);
      END_STATE();
    case 14:
      if (lookahead == '-') ADVANCE(11);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(145);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(245);
      END_STATE();
    case 15:
      if (lookahead == '-') ADVANCE(16);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(150);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(250);
      END_STATE();
    case 16:
      if (lookahead == '-') ADVANCE(13);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(147);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(247);
      END_STATE();
    case 17:
      if (lookahead == '-') ADVANCE(18);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(152);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(252);
      END_STATE();
    case 18:
      if (lookahead == '-') ADVANCE(15);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(149);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(249);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(154);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 20:
      if (lookahead == '-') ADVANCE(17);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(251);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(256);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(253);
      END_STATE();
    case 23:
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(262);
      END_STATE();
    case 24:
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(255);
      END_STATE();
    case 25:
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'A') ADVANCE(263);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z')) ADVANCE(266);
      END_STATE();
    case 26:
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'R') ADVANCE(265);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(266);
      END_STATE();
    case 27:
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'U') ADVANCE(264);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(266);
      END_STATE();
    case 28:
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(266);
      END_STATE();
    case 29:
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(260);
      END_STATE();
    case 30:
      if (lookahead == '0') ADVANCE(160);
      if (lookahead == '1') ADVANCE(137);
      END_STATE();
    case 31:
      if (lookahead == '0') ADVANCE(161);
      if (lookahead == '3') ADVANCE(128);
      if (lookahead == '1' ||
          lookahead == '2') ADVANCE(162);
      END_STATE();
    case 32:
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'A') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 33:
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'E') ADVANCE(235);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 34:
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'L') ADVANCE(36);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 35:
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'R') ADVANCE(37);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 36:
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'S') ADVANCE(33);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 37:
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'U') ADVANCE(33);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 38:
      if (lookahead == ':') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead > ',' &&
          (lookahead < '.' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(268);
      END_STATE();
    case 39:
      if (lookahead == ':') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 40:
      if (lookahead == 'L') ADVANCE(231);
      END_STATE();
    case 41:
      if (lookahead == 'L') ADVANCE(40);
      END_STATE();
    case 42:
      if (lookahead == 'U') ADVANCE(41);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(78);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(55);
      if (lookahead == 'l') ADVANCE(118);
      if (lookahead == 'o') ADVANCE(103);
      if (lookahead == 'r') ADVANCE(74);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(55);
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(227);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(226);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(70);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(71);
      END_STATE();
    case 50:
      if (lookahead == 'a') ADVANCE(95);
      END_STATE();
    case 51:
      if (lookahead == 'c') ADVANCE(81);
      END_STATE();
    case 52:
      if (lookahead == 'c') ADVANCE(120);
      END_STATE();
    case 53:
      if (lookahead == 'c') ADVANCE(61);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(62);
      END_STATE();
    case 55:
      if (lookahead == 'd') ADVANCE(217);
      END_STATE();
    case 56:
      if (lookahead == 'd') ADVANCE(75);
      END_STATE();
    case 57:
      if (lookahead == 'd') ADVANCE(63);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(213);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(229);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(89);
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 70:
      if (lookahead == 'g') ADVANCE(225);
      END_STATE();
    case 71:
      if (lookahead == 'g') ADVANCE(224);
      END_STATE();
    case 72:
      if (lookahead == 'g') ADVANCE(77);
      END_STATE();
    case 73:
      if (lookahead == 'h') ADVANCE(86);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(53);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(113);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(101);
      END_STATE();
    case 77:
      if (lookahead == 'i') ADVANCE(91);
      END_STATE();
    case 78:
      if (lookahead == 'l') ADVANCE(50);
      END_STATE();
    case 79:
      if (lookahead == 'l') ADVANCE(118);
      if (lookahead == 'o') ADVANCE(103);
      if (lookahead == 'u') ADVANCE(107);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(99);
      if (lookahead == 'o') ADVANCE(83);
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 81:
      if (lookahead == 'l') ADVANCE(121);
      END_STATE();
    case 82:
      if (lookahead == 'm') ADVANCE(223);
      END_STATE();
    case 83:
      if (lookahead == 'm') ADVANCE(84);
      END_STATE();
    case 84:
      if (lookahead == 'm') ADVANCE(98);
      END_STATE();
    case 85:
      if (lookahead == 'm') ADVANCE(67);
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 86:
      if (lookahead == 'm') ADVANCE(69);
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 87:
      if (lookahead == 'm') ADVANCE(68);
      END_STATE();
    case 88:
      if (lookahead == 'n') ADVANCE(212);
      END_STATE();
    case 89:
      if (lookahead == 'n') ADVANCE(214);
      END_STATE();
    case 90:
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 91:
      if (lookahead == 'n') ADVANCE(230);
      END_STATE();
    case 92:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 93:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 94:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 95:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 96:
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 97:
      if (lookahead == 'o') ADVANCE(114);
      END_STATE();
    case 98:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 99:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 100:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 101:
      if (lookahead == 'o') ADVANCE(90);
      END_STATE();
    case 102:
      if (lookahead == 'p') ADVANCE(66);
      END_STATE();
    case 103:
      if (lookahead == 'p') ADVANCE(85);
      END_STATE();
    case 104:
      if (lookahead == 'p') ADVANCE(112);
      END_STATE();
    case 105:
      if (lookahead == 'p') ADVANCE(65);
      END_STATE();
    case 106:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 107:
      if (lookahead == 's') ADVANCE(73);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(116);
      END_STATE();
    case 109:
      if (lookahead == 's') ADVANCE(60);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(218);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(221);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(100);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 118:
      if (lookahead == 'u') ADVANCE(72);
      END_STATE();
    case 119:
      if (lookahead == 'u') ADVANCE(58);
      END_STATE();
    case 120:
      if (lookahead == 'u') ADVANCE(87);
      END_STATE();
    case 121:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 122:
      if (lookahead == 'v') ADVANCE(64);
      END_STATE();
    case 123:
      if (lookahead == 'x') ADVANCE(88);
      END_STATE();
    case 124:
      if (lookahead == 'y') ADVANCE(222);
      END_STATE();
    case 125:
      if (lookahead == 'y') ADVANCE(216);
      END_STATE();
    case 126:
      if (lookahead == '}') ADVANCE(193);
      END_STATE();
    case 127:
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(187);
      if (lookahead == '\r') SKIP(127)
      END_STATE();
    case 128:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(236);
      END_STATE();
    case 129:
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(129)
      if (lookahead == '\n') ADVANCE(182);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '(') ADVANCE(208);
      if (lookahead == ')') ADVANCE(209);
      if (lookahead == '*') ADVANCE(202);
      if (lookahead == '+') ADVANCE(206);
      if (lookahead == '-') ADVANCE(207);
      if (lookahead == '/') ADVANCE(204);
      if (lookahead == ';') ADVANCE(301);
      if (lookahead == '@') ADVANCE(191);
      if (lookahead == 'F') ADVANCE(25);
      if (lookahead == 'N') ADVANCE(27);
      if (lookahead == 'T') ADVANCE(26);
      if (lookahead == '^') ADVANCE(173);
      if (lookahead == '{') ADVANCE(194);
      if (lookahead == '}') ADVANCE(195);
      if (lookahead == '1' ||
          lookahead == '2') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(28);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      if (lookahead != 0 &&
          lookahead > 127) ADVANCE(39);
      END_STATE();
    case 130:
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(130)
      if (lookahead == '\n') ADVANCE(182);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '(') ADVANCE(208);
      if (lookahead == '*') ADVANCE(202);
      if (lookahead == '+') ADVANCE(206);
      if (lookahead == '-') ADVANCE(207);
      if (lookahead == ';') ADVANCE(301);
      if (lookahead == '@') ADVANCE(191);
      if (lookahead == 'b') ADVANCE(43);
      if (lookahead == 'c') ADVANCE(80);
      if (lookahead == 'd') ADVANCE(96);
      if (lookahead == 'e') ADVANCE(122);
      if (lookahead == 'n') ADVANCE(97);
      if (lookahead == 'o') ADVANCE(105);
      if (lookahead == 'p') ADVANCE(45);
      if (lookahead == 'q') ADVANCE(119);
      if (lookahead == 't') ADVANCE(123);
      if (lookahead == '{') ADVANCE(194);
      if (lookahead == '}') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '?' ||
          lookahead == 'C' ||
          lookahead == 'M' ||
          lookahead == 'P' ||
          ('R' <= lookahead && lookahead <= 'U')) ADVANCE(210);
      END_STATE();
    case 131:
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(131)
      if (lookahead == '\n') ADVANCE(182);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '(') ADVANCE(208);
      if (lookahead == '*') ADVANCE(186);
      if (lookahead == '+') ADVANCE(206);
      if (lookahead == '-') ADVANCE(207);
      if (lookahead == 'F') ADVANCE(32);
      if (lookahead == 'T') ADVANCE(35);
      if (lookahead == '1' ||
          lookahead == '2') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      if (lookahead != 0 &&
          lookahead > '@' &&
          (lookahead < '[' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 132:
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(132)
      if (lookahead == '\n') ADVANCE(182);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '(') ADVANCE(208);
      if (lookahead == '*') ADVANCE(202);
      if (lookahead == '+') ADVANCE(206);
      if (lookahead == ',') ADVANCE(198);
      if (lookahead == '-') ADVANCE(207);
      if (lookahead == '/') ADVANCE(204);
      if (lookahead == ';') ADVANCE(301);
      if (lookahead == '}') ADVANCE(195);
      if (lookahead == '~') ADVANCE(199);
      if (lookahead == '1' ||
          lookahead == '2') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(138);
      END_STATE();
    case 133:
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(133)
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '(') ADVANCE(208);
      if (lookahead == '*') ADVANCE(202);
      if (lookahead == '+') ADVANCE(206);
      if (lookahead == '-') ADVANCE(207);
      if (lookahead == '}') ADVANCE(126);
      if (lookahead == '1' ||
          lookahead == '2') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(138);
      END_STATE();
    case 134:
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(134)
      if (lookahead == '\n') ADVANCE(182);
      if (lookahead == '#') ADVANCE(201);
      if (lookahead == '*') ADVANCE(202);
      if (lookahead == ';') ADVANCE(301);
      if (lookahead == '^') ADVANCE(173);
      if (lookahead == '!' ||
          lookahead == '%' ||
          lookahead == '&' ||
          lookahead == '?') ADVANCE(210);
      if (lookahead == 'C' ||
          lookahead == 'M' ||
          lookahead == 'P' ||
          ('R' <= lookahead && lookahead <= 'U')) ADVANCE(211);
      if (lookahead != 0 &&
          lookahead > '@' &&
          (lookahead < '[' || 127 < lookahead)) ADVANCE(39);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 135:
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(135)
      if (lookahead == '\n') ADVANCE(182);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '(') ADVANCE(208);
      if (lookahead == '*') ADVANCE(202);
      if (lookahead == '+') ADVANCE(206);
      if (lookahead == '-') ADVANCE(207);
      if (lookahead == '/') ADVANCE(204);
      if (lookahead == 'F') ADVANCE(25);
      if (lookahead == 'T') ADVANCE(26);
      if (lookahead == '1' ||
          lookahead == '2') ADVANCE(295);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(28);
      if (lookahead != 0 &&
          lookahead > 127) ADVANCE(39);
      END_STATE();
    case 136:
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(136)
      if (lookahead == '\n') ADVANCE(182);
      if (lookahead == '#') ADVANCE(200);
      if (lookahead == '(') ADVANCE(208);
      if (lookahead == ')') ADVANCE(209);
      if (lookahead == '*') ADVANCE(202);
      if (lookahead == '+') ADVANCE(206);
      if (lookahead == ',') ADVANCE(198);
      if (lookahead == '-') ADVANCE(207);
      if (lookahead == '/') ADVANCE(204);
      if (lookahead == '}') ADVANCE(196);
      if (lookahead == '~') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(138);
      END_STATE();
    case 137:
      if (('0' <= lookahead && lookahead <= '2')) ADVANCE(4);
      END_STATE();
    case 138:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(289);
      END_STATE();
    case 139:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(290);
      END_STATE();
    case 140:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(269);
      END_STATE();
    case 141:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(272);
      END_STATE();
    case 142:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(270);
      END_STATE();
    case 143:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(274);
      END_STATE();
    case 144:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(271);
      END_STATE();
    case 145:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(276);
      END_STATE();
    case 146:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(273);
      END_STATE();
    case 147:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(278);
      END_STATE();
    case 148:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(275);
      END_STATE();
    case 149:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(280);
      END_STATE();
    case 150:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(277);
      END_STATE();
    case 151:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(282);
      END_STATE();
    case 152:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(279);
      END_STATE();
    case 153:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(284);
      END_STATE();
    case 154:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(281);
      END_STATE();
    case 155:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(286);
      END_STATE();
    case 156:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(283);
      END_STATE();
    case 157:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(288);
      END_STATE();
    case 158:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(285);
      END_STATE();
    case 159:
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(287);
      END_STATE();
    case 160:
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(4);
      END_STATE();
    case 161:
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(236);
      END_STATE();
    case 162:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(236);
      END_STATE();
    case 163:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(3);
      END_STATE();
    case 164:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(163);
      END_STATE();
    case 165:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(164);
      END_STATE();
    case 166:
      if ((128 <= lookahead && lookahead <= 143)) ADVANCE(310);
      END_STATE();
    case 167:
      if ((128 <= lookahead && lookahead <= 159)) ADVANCE(306);
      END_STATE();
    case 168:
      if ((160 <= lookahead && lookahead <= 191)) ADVANCE(304);
      END_STATE();
    case 169:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(238);
      END_STATE();
    case 170:
      if ((144 <= lookahead && lookahead <= 191)) ADVANCE(308);
      END_STATE();
    case 171:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(300);
      END_STATE();
    case 172:
      if (('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(298);
      END_STATE();
    case 173:
      if (('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(299);
      END_STATE();
    case 174:
      if (lookahead != 0 &&
          lookahead > '/' &&
          (lookahead < ':' || '@' < lookahead) &&
          (lookahead < '[' || 127 < lookahead)) ADVANCE(237);
      END_STATE();
    case 175:
      if (eof) ADVANCE(177);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(175)
      if (lookahead == '\n') ADVANCE(178);
      if (lookahead == '\r') ADVANCE(179);
      if (lookahead == ':') ADVANCE(205);
      if (lookahead == ';') ADVANCE(301);
      if (lookahead == 'i') ADVANCE(92);
      if (lookahead == 'o') ADVANCE(104);
      if (lookahead == 'p') ADVANCE(79);
      if (lookahead == '1' ||
          lookahead == '2') ADVANCE(165);
      if (sym_flag_character_set_1(lookahead)) ADVANCE(210);
      END_STATE();
    case 176:
      if (eof) ADVANCE(177);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(188);
      if (lookahead == '\n') ADVANCE(178);
      if (lookahead == '\r') ADVANCE(180);
      if (lookahead == ':') ADVANCE(205);
      if (lookahead == ';') ADVANCE(301);
      if (lookahead == 'i') ADVANCE(92);
      if (lookahead == 'o') ADVANCE(104);
      if (lookahead == 'p') ADVANCE(79);
      if (lookahead == '1' ||
          lookahead == '2') ADVANCE(165);
      if (sym_flag_character_set_1(lookahead)) ADVANCE(210);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\r') ADVANCE(179);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(188);
      if (lookahead == '\r') ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(183);
      if (lookahead == '\r') ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym__eol);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym__any_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(183);
      if (lookahead == '\r') ADVANCE(181);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(185);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym__any_token1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(184);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(185);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym__any_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(185);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym__org_stars_token1);
      if (lookahead == '*') ADVANCE(186);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_headline_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(187);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym__indent);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(188);
      if (lookahead == '\r') ADVANCE(180);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym__pipe);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_atat);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_at);
      if (lookahead == '@') ADVANCE(190);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_lcurllcurl);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_rcurlrcurl);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_lcurl);
      if (lookahead == '{') ADVANCE(192);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_rcurl);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_rcurl);
      if (lookahead == '}') ADVANCE(193);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym__equal);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym__comma);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym__tilde);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym__hash);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym__hash);
      if (('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(298);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_asterisk);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_asterisk);
      if (lookahead == '*') ADVANCE(186);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_slash);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym__colon);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_plus);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_minus);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym__lparen);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym__rparen);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_flag);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_flag);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_TXN);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_BALANCE);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_OPEN);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_CLOSE);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_COMMODITY);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_PAD);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_EVENT);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_PRICE);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_NOTE);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_DOCUMENT);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_QUERY);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_CUSTOM);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_PUSHTAG);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_POPTAG);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_PUSHMETA);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_POPMETA);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_OPTION);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_INCLUDE);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_PLUGIN);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym__none);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym__none);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(255);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_bool);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(256);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_bool);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(255);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_bool);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_date);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_account);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(237);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_currency);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(38);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(169);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(267);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(5);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(139);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(239);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(8);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(142);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(242);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(6);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(140);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(240);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(10);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(144);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(244);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(7);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(141);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(241);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(12);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(146);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(246);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(9);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(143);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(243);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(14);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(148);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(248);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(11);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(145);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(245);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(16);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(150);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(250);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(13);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(147);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(247);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(18);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(152);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(252);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(15);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(149);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(249);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(154);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(17);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(151);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(251);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(22);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(256);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(253);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'E') ADVANCE(234);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(262);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'L') ADVANCE(232);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(262);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'S') ADVANCE(261);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(262);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(158);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(262);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'E') ADVANCE(233);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(255);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(255);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'L') ADVANCE(259);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(260);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'L') ADVANCE(258);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(260);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == 'U') ADVANCE(257);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(260);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead == '\'' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(157);
      if (lookahead != 0 &&
          lookahead > '`' &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(260);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead > ',' &&
          (lookahead < '.' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(268);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == ':') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead > ',' &&
          lookahead != '.' &&
          lookahead != '/' &&
          (lookahead < ';' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || 127 < lookahead)) ADVANCE(39);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(290);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(269);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(272);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(270);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(274);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(271);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(276);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(273);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(278);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(275);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(280);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(277);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(282);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(279);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(284);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(281);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(286);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(283);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(158);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(288);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(285);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_currency);
      if (lookahead == '\'' ||
          lookahead == '-' ||
          lookahead == '.' ||
          lookahead == '_') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(287);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_currency);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z')) ADVANCE(238);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == ',') ADVANCE(2);
      if (lookahead == '-') ADVANCE(30);
      if (lookahead == '.') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == ',') ADVANCE(2);
      if (lookahead == '.') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(292);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == ',') ADVANCE(2);
      if (lookahead == '.') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(293);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == ',') ADVANCE(2);
      if (lookahead == '.') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(294);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == ',') ADVANCE(2);
      if (lookahead == '.') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(296);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(297);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_tag);
      if (('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(298);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_link);
      if (('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(299);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_key);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(300);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym__UTF_8_1);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(aux_sym__UTF_8_2_token1);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(aux_sym__UTF_8_3_token1);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(aux_sym__UTF_8_3_token2);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(aux_sym__UTF_8_3_token3);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(aux_sym__UTF_8_3_token4);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(aux_sym__UTF_8_4_token1);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(aux_sym__UTF_8_4_token2);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(aux_sym__UTF_8_4_token3);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 175, .external_lex_state = 2},
  [2] = {.lex_state = 175, .external_lex_state = 3},
  [3] = {.lex_state = 175, .external_lex_state = 3},
  [4] = {.lex_state = 175, .external_lex_state = 3},
  [5] = {.lex_state = 175, .external_lex_state = 3},
  [6] = {.lex_state = 175, .external_lex_state = 2},
  [7] = {.lex_state = 175, .external_lex_state = 2},
  [8] = {.lex_state = 175, .external_lex_state = 3},
  [9] = {.lex_state = 176, .external_lex_state = 2},
  [10] = {.lex_state = 176, .external_lex_state = 2},
  [11] = {.lex_state = 176, .external_lex_state = 2},
  [12] = {.lex_state = 176, .external_lex_state = 2},
  [13] = {.lex_state = 176, .external_lex_state = 2},
  [14] = {.lex_state = 176, .external_lex_state = 3},
  [15] = {.lex_state = 176, .external_lex_state = 3},
  [16] = {.lex_state = 176, .external_lex_state = 3},
  [17] = {.lex_state = 176, .external_lex_state = 3},
  [18] = {.lex_state = 176, .external_lex_state = 2},
  [19] = {.lex_state = 176, .external_lex_state = 2},
  [20] = {.lex_state = 176, .external_lex_state = 3},
  [21] = {.lex_state = 176, .external_lex_state = 3},
  [22] = {.lex_state = 176, .external_lex_state = 2},
  [23] = {.lex_state = 176, .external_lex_state = 3},
  [24] = {.lex_state = 176, .external_lex_state = 3},
  [25] = {.lex_state = 176, .external_lex_state = 3},
  [26] = {.lex_state = 176, .external_lex_state = 3},
  [27] = {.lex_state = 176, .external_lex_state = 3},
  [28] = {.lex_state = 176, .external_lex_state = 3},
  [29] = {.lex_state = 176, .external_lex_state = 3},
  [30] = {.lex_state = 176, .external_lex_state = 3},
  [31] = {.lex_state = 176, .external_lex_state = 3},
  [32] = {.lex_state = 176, .external_lex_state = 3},
  [33] = {.lex_state = 176, .external_lex_state = 3},
  [34] = {.lex_state = 176, .external_lex_state = 3},
  [35] = {.lex_state = 176, .external_lex_state = 3},
  [36] = {.lex_state = 176, .external_lex_state = 2},
  [37] = {.lex_state = 176, .external_lex_state = 3},
  [38] = {.lex_state = 176, .external_lex_state = 3},
  [39] = {.lex_state = 176, .external_lex_state = 3},
  [40] = {.lex_state = 176, .external_lex_state = 3},
  [41] = {.lex_state = 176, .external_lex_state = 3},
  [42] = {.lex_state = 176, .external_lex_state = 3},
  [43] = {.lex_state = 176, .external_lex_state = 2},
  [44] = {.lex_state = 176, .external_lex_state = 3},
  [45] = {.lex_state = 176, .external_lex_state = 3},
  [46] = {.lex_state = 176, .external_lex_state = 2},
  [47] = {.lex_state = 176, .external_lex_state = 2},
  [48] = {.lex_state = 176, .external_lex_state = 3},
  [49] = {.lex_state = 176, .external_lex_state = 2},
  [50] = {.lex_state = 176, .external_lex_state = 2},
  [51] = {.lex_state = 176, .external_lex_state = 2},
  [52] = {.lex_state = 176, .external_lex_state = 3},
  [53] = {.lex_state = 176, .external_lex_state = 3},
  [54] = {.lex_state = 176, .external_lex_state = 2},
  [55] = {.lex_state = 176, .external_lex_state = 3},
  [56] = {.lex_state = 176, .external_lex_state = 3},
  [57] = {.lex_state = 176, .external_lex_state = 3},
  [58] = {.lex_state = 176, .external_lex_state = 2},
  [59] = {.lex_state = 176, .external_lex_state = 2},
  [60] = {.lex_state = 176, .external_lex_state = 2},
  [61] = {.lex_state = 176, .external_lex_state = 2},
  [62] = {.lex_state = 176, .external_lex_state = 2},
  [63] = {.lex_state = 176, .external_lex_state = 2},
  [64] = {.lex_state = 176, .external_lex_state = 2},
  [65] = {.lex_state = 176, .external_lex_state = 2},
  [66] = {.lex_state = 176, .external_lex_state = 2},
  [67] = {.lex_state = 176, .external_lex_state = 2},
  [68] = {.lex_state = 176, .external_lex_state = 2},
  [69] = {.lex_state = 176, .external_lex_state = 2},
  [70] = {.lex_state = 176, .external_lex_state = 3},
  [71] = {.lex_state = 176, .external_lex_state = 2},
  [72] = {.lex_state = 176, .external_lex_state = 2},
  [73] = {.lex_state = 176, .external_lex_state = 2},
  [74] = {.lex_state = 176, .external_lex_state = 2},
  [75] = {.lex_state = 176, .external_lex_state = 2},
  [76] = {.lex_state = 176, .external_lex_state = 2},
  [77] = {.lex_state = 176, .external_lex_state = 2},
  [78] = {.lex_state = 176, .external_lex_state = 3},
  [79] = {.lex_state = 176, .external_lex_state = 2},
  [80] = {.lex_state = 176, .external_lex_state = 3},
  [81] = {.lex_state = 129},
  [82] = {.lex_state = 176, .external_lex_state = 2},
  [83] = {.lex_state = 176, .external_lex_state = 3},
  [84] = {.lex_state = 130},
  [85] = {.lex_state = 130},
  [86] = {.lex_state = 131},
  [87] = {.lex_state = 176, .external_lex_state = 3},
  [88] = {.lex_state = 176, .external_lex_state = 3},
  [89] = {.lex_state = 176, .external_lex_state = 3},
  [90] = {.lex_state = 176, .external_lex_state = 3},
  [91] = {.lex_state = 176, .external_lex_state = 3},
  [92] = {.lex_state = 176, .external_lex_state = 3},
  [93] = {.lex_state = 176, .external_lex_state = 3},
  [94] = {.lex_state = 176, .external_lex_state = 3},
  [95] = {.lex_state = 176, .external_lex_state = 3},
  [96] = {.lex_state = 176, .external_lex_state = 3},
  [97] = {.lex_state = 176, .external_lex_state = 3},
  [98] = {.lex_state = 176, .external_lex_state = 3},
  [99] = {.lex_state = 176, .external_lex_state = 3},
  [100] = {.lex_state = 176, .external_lex_state = 3},
  [101] = {.lex_state = 176, .external_lex_state = 3},
  [102] = {.lex_state = 176, .external_lex_state = 3},
  [103] = {.lex_state = 176, .external_lex_state = 3},
  [104] = {.lex_state = 176, .external_lex_state = 3},
  [105] = {.lex_state = 176, .external_lex_state = 3},
  [106] = {.lex_state = 176, .external_lex_state = 3},
  [107] = {.lex_state = 176, .external_lex_state = 3},
  [108] = {.lex_state = 176, .external_lex_state = 3},
  [109] = {.lex_state = 176, .external_lex_state = 3},
  [110] = {.lex_state = 176, .external_lex_state = 3},
  [111] = {.lex_state = 176, .external_lex_state = 3},
  [112] = {.lex_state = 176, .external_lex_state = 3},
  [113] = {.lex_state = 176, .external_lex_state = 3},
  [114] = {.lex_state = 176, .external_lex_state = 3},
  [115] = {.lex_state = 176, .external_lex_state = 3},
  [116] = {.lex_state = 176, .external_lex_state = 3},
  [117] = {.lex_state = 176, .external_lex_state = 3},
  [118] = {.lex_state = 176, .external_lex_state = 3},
  [119] = {.lex_state = 176, .external_lex_state = 3},
  [120] = {.lex_state = 176, .external_lex_state = 3},
  [121] = {.lex_state = 176, .external_lex_state = 3},
  [122] = {.lex_state = 176, .external_lex_state = 3},
  [123] = {.lex_state = 176, .external_lex_state = 3},
  [124] = {.lex_state = 176, .external_lex_state = 3},
  [125] = {.lex_state = 176, .external_lex_state = 3},
  [126] = {.lex_state = 176, .external_lex_state = 3},
  [127] = {.lex_state = 176, .external_lex_state = 3},
  [128] = {.lex_state = 176, .external_lex_state = 3},
  [129] = {.lex_state = 176, .external_lex_state = 3},
  [130] = {.lex_state = 176, .external_lex_state = 3},
  [131] = {.lex_state = 176, .external_lex_state = 3},
  [132] = {.lex_state = 176, .external_lex_state = 3},
  [133] = {.lex_state = 176, .external_lex_state = 3},
  [134] = {.lex_state = 176, .external_lex_state = 3},
  [135] = {.lex_state = 176, .external_lex_state = 3},
  [136] = {.lex_state = 176, .external_lex_state = 3},
  [137] = {.lex_state = 176, .external_lex_state = 3},
  [138] = {.lex_state = 176, .external_lex_state = 2},
  [139] = {.lex_state = 176, .external_lex_state = 2},
  [140] = {.lex_state = 176, .external_lex_state = 2},
  [141] = {.lex_state = 176, .external_lex_state = 2},
  [142] = {.lex_state = 176, .external_lex_state = 2},
  [143] = {.lex_state = 176, .external_lex_state = 2},
  [144] = {.lex_state = 176, .external_lex_state = 2},
  [145] = {.lex_state = 176, .external_lex_state = 2},
  [146] = {.lex_state = 131},
  [147] = {.lex_state = 176, .external_lex_state = 2},
  [148] = {.lex_state = 176, .external_lex_state = 2},
  [149] = {.lex_state = 176, .external_lex_state = 2},
  [150] = {.lex_state = 176, .external_lex_state = 2},
  [151] = {.lex_state = 176, .external_lex_state = 2},
  [152] = {.lex_state = 176, .external_lex_state = 2},
  [153] = {.lex_state = 176, .external_lex_state = 2},
  [154] = {.lex_state = 176, .external_lex_state = 2},
  [155] = {.lex_state = 176, .external_lex_state = 2},
  [156] = {.lex_state = 176, .external_lex_state = 2},
  [157] = {.lex_state = 176, .external_lex_state = 2},
  [158] = {.lex_state = 176, .external_lex_state = 2},
  [159] = {.lex_state = 176, .external_lex_state = 2},
  [160] = {.lex_state = 176, .external_lex_state = 2},
  [161] = {.lex_state = 176, .external_lex_state = 2},
  [162] = {.lex_state = 176, .external_lex_state = 2},
  [163] = {.lex_state = 176, .external_lex_state = 2},
  [164] = {.lex_state = 176, .external_lex_state = 2},
  [165] = {.lex_state = 176, .external_lex_state = 2},
  [166] = {.lex_state = 176, .external_lex_state = 2},
  [167] = {.lex_state = 130},
  [168] = {.lex_state = 176, .external_lex_state = 2},
  [169] = {.lex_state = 176, .external_lex_state = 2},
  [170] = {.lex_state = 176, .external_lex_state = 2},
  [171] = {.lex_state = 176, .external_lex_state = 2},
  [172] = {.lex_state = 176, .external_lex_state = 2},
  [173] = {.lex_state = 176, .external_lex_state = 2},
  [174] = {.lex_state = 176, .external_lex_state = 2},
  [175] = {.lex_state = 176, .external_lex_state = 2},
  [176] = {.lex_state = 176, .external_lex_state = 2},
  [177] = {.lex_state = 176, .external_lex_state = 2},
  [178] = {.lex_state = 176, .external_lex_state = 2},
  [179] = {.lex_state = 176, .external_lex_state = 2},
  [180] = {.lex_state = 176, .external_lex_state = 2},
  [181] = {.lex_state = 176, .external_lex_state = 2},
  [182] = {.lex_state = 176, .external_lex_state = 2},
  [183] = {.lex_state = 176, .external_lex_state = 2},
  [184] = {.lex_state = 176, .external_lex_state = 2},
  [185] = {.lex_state = 176, .external_lex_state = 2},
  [186] = {.lex_state = 176, .external_lex_state = 2},
  [187] = {.lex_state = 176, .external_lex_state = 2},
  [188] = {.lex_state = 176, .external_lex_state = 2},
  [189] = {.lex_state = 130},
  [190] = {.lex_state = 176, .external_lex_state = 2},
  [191] = {.lex_state = 132},
  [192] = {.lex_state = 133},
  [193] = {.lex_state = 176, .external_lex_state = 2},
  [194] = {.lex_state = 175, .external_lex_state = 3},
  [195] = {.lex_state = 175, .external_lex_state = 2},
  [196] = {.lex_state = 175, .external_lex_state = 2},
  [197] = {.lex_state = 175, .external_lex_state = 2},
  [198] = {.lex_state = 175, .external_lex_state = 2},
  [199] = {.lex_state = 175, .external_lex_state = 2},
  [200] = {.lex_state = 175, .external_lex_state = 2},
  [201] = {.lex_state = 175, .external_lex_state = 2},
  [202] = {.lex_state = 175, .external_lex_state = 2},
  [203] = {.lex_state = 175, .external_lex_state = 2},
  [204] = {.lex_state = 175, .external_lex_state = 2},
  [205] = {.lex_state = 175, .external_lex_state = 2},
  [206] = {.lex_state = 175, .external_lex_state = 2},
  [207] = {.lex_state = 175, .external_lex_state = 2},
  [208] = {.lex_state = 175, .external_lex_state = 3},
  [209] = {.lex_state = 175, .external_lex_state = 2},
  [210] = {.lex_state = 175, .external_lex_state = 2},
  [211] = {.lex_state = 175, .external_lex_state = 3},
  [212] = {.lex_state = 175, .external_lex_state = 3},
  [213] = {.lex_state = 175, .external_lex_state = 3},
  [214] = {.lex_state = 175, .external_lex_state = 3},
  [215] = {.lex_state = 175, .external_lex_state = 2},
  [216] = {.lex_state = 175, .external_lex_state = 2},
  [217] = {.lex_state = 175, .external_lex_state = 3},
  [218] = {.lex_state = 175, .external_lex_state = 2},
  [219] = {.lex_state = 175, .external_lex_state = 3},
  [220] = {.lex_state = 175, .external_lex_state = 2},
  [221] = {.lex_state = 175, .external_lex_state = 2},
  [222] = {.lex_state = 175, .external_lex_state = 3},
  [223] = {.lex_state = 175, .external_lex_state = 2},
  [224] = {.lex_state = 175, .external_lex_state = 2},
  [225] = {.lex_state = 175, .external_lex_state = 2},
  [226] = {.lex_state = 175, .external_lex_state = 3},
  [227] = {.lex_state = 175, .external_lex_state = 2},
  [228] = {.lex_state = 175, .external_lex_state = 2},
  [229] = {.lex_state = 175, .external_lex_state = 2},
  [230] = {.lex_state = 175, .external_lex_state = 3},
  [231] = {.lex_state = 130},
  [232] = {.lex_state = 175, .external_lex_state = 3},
  [233] = {.lex_state = 175, .external_lex_state = 3},
  [234] = {.lex_state = 175, .external_lex_state = 3},
  [235] = {.lex_state = 175, .external_lex_state = 3},
  [236] = {.lex_state = 175, .external_lex_state = 3},
  [237] = {.lex_state = 175, .external_lex_state = 3},
  [238] = {.lex_state = 175, .external_lex_state = 3},
  [239] = {.lex_state = 175, .external_lex_state = 3},
  [240] = {.lex_state = 175, .external_lex_state = 3},
  [241] = {.lex_state = 175, .external_lex_state = 3},
  [242] = {.lex_state = 175, .external_lex_state = 2},
  [243] = {.lex_state = 175, .external_lex_state = 2},
  [244] = {.lex_state = 175, .external_lex_state = 2},
  [245] = {.lex_state = 175, .external_lex_state = 3},
  [246] = {.lex_state = 175, .external_lex_state = 3},
  [247] = {.lex_state = 175, .external_lex_state = 3},
  [248] = {.lex_state = 175, .external_lex_state = 3},
  [249] = {.lex_state = 130},
  [250] = {.lex_state = 175, .external_lex_state = 2},
  [251] = {.lex_state = 175, .external_lex_state = 3},
  [252] = {.lex_state = 175, .external_lex_state = 3},
  [253] = {.lex_state = 175, .external_lex_state = 3},
  [254] = {.lex_state = 175, .external_lex_state = 2},
  [255] = {.lex_state = 175, .external_lex_state = 3},
  [256] = {.lex_state = 175, .external_lex_state = 2},
  [257] = {.lex_state = 175, .external_lex_state = 2},
  [258] = {.lex_state = 175, .external_lex_state = 3},
  [259] = {.lex_state = 175, .external_lex_state = 3},
  [260] = {.lex_state = 175, .external_lex_state = 2},
  [261] = {.lex_state = 175, .external_lex_state = 2},
  [262] = {.lex_state = 175, .external_lex_state = 2},
  [263] = {.lex_state = 175, .external_lex_state = 3},
  [264] = {.lex_state = 175, .external_lex_state = 3},
  [265] = {.lex_state = 175, .external_lex_state = 3},
  [266] = {.lex_state = 175, .external_lex_state = 2},
  [267] = {.lex_state = 175, .external_lex_state = 3},
  [268] = {.lex_state = 175, .external_lex_state = 2},
  [269] = {.lex_state = 131},
  [270] = {.lex_state = 175, .external_lex_state = 3},
  [271] = {.lex_state = 175, .external_lex_state = 2},
  [272] = {.lex_state = 131},
  [273] = {.lex_state = 175, .external_lex_state = 3},
  [274] = {.lex_state = 175, .external_lex_state = 2},
  [275] = {.lex_state = 175, .external_lex_state = 2},
  [276] = {.lex_state = 175, .external_lex_state = 3},
  [277] = {.lex_state = 175, .external_lex_state = 3},
  [278] = {.lex_state = 175, .external_lex_state = 2},
  [279] = {.lex_state = 175, .external_lex_state = 3},
  [280] = {.lex_state = 175, .external_lex_state = 3},
  [281] = {.lex_state = 175, .external_lex_state = 3},
  [282] = {.lex_state = 175, .external_lex_state = 2},
  [283] = {.lex_state = 175, .external_lex_state = 3},
  [284] = {.lex_state = 175, .external_lex_state = 2},
  [285] = {.lex_state = 175, .external_lex_state = 2},
  [286] = {.lex_state = 175, .external_lex_state = 3},
  [287] = {.lex_state = 175, .external_lex_state = 2},
  [288] = {.lex_state = 132},
  [289] = {.lex_state = 134},
  [290] = {.lex_state = 134},
  [291] = {.lex_state = 130},
  [292] = {.lex_state = 130},
  [293] = {.lex_state = 130},
  [294] = {.lex_state = 130},
  [295] = {.lex_state = 130},
  [296] = {.lex_state = 130},
  [297] = {.lex_state = 130},
  [298] = {.lex_state = 130},
  [299] = {.lex_state = 130},
  [300] = {.lex_state = 130},
  [301] = {.lex_state = 130},
  [302] = {.lex_state = 130},
  [303] = {.lex_state = 130},
  [304] = {.lex_state = 130},
  [305] = {.lex_state = 130},
  [306] = {.lex_state = 130},
  [307] = {.lex_state = 135},
  [308] = {.lex_state = 136},
  [309] = {.lex_state = 135},
  [310] = {.lex_state = 135},
  [311] = {.lex_state = 136},
  [312] = {.lex_state = 136},
  [313] = {.lex_state = 136},
  [314] = {.lex_state = 135},
  [315] = {.lex_state = 135},
  [316] = {.lex_state = 136},
  [317] = {.lex_state = 129},
  [318] = {.lex_state = 130},
  [319] = {.lex_state = 130},
  [320] = {.lex_state = 136},
  [321] = {.lex_state = 130},
  [322] = {.lex_state = 131},
  [323] = {.lex_state = 136},
  [324] = {.lex_state = 131},
  [325] = {.lex_state = 130},
  [326] = {.lex_state = 129},
  [327] = {.lex_state = 132},
  [328] = {.lex_state = 132},
  [329] = {.lex_state = 130},
  [330] = {.lex_state = 129},
  [331] = {.lex_state = 130},
  [332] = {.lex_state = 129},
  [333] = {.lex_state = 129},
  [334] = {.lex_state = 130},
  [335] = {.lex_state = 132},
  [336] = {.lex_state = 130},
  [337] = {.lex_state = 130},
  [338] = {.lex_state = 130},
  [339] = {.lex_state = 132},
  [340] = {.lex_state = 130},
  [341] = {.lex_state = 130},
  [342] = {.lex_state = 130},
  [343] = {.lex_state = 129},
  [344] = {.lex_state = 129},
  [345] = {.lex_state = 129},
  [346] = {.lex_state = 132},
  [347] = {.lex_state = 0, .external_lex_state = 3},
  [348] = {.lex_state = 132},
  [349] = {.lex_state = 132},
  [350] = {.lex_state = 132},
  [351] = {.lex_state = 132},
  [352] = {.lex_state = 183},
  [353] = {.lex_state = 132},
  [354] = {.lex_state = 0, .external_lex_state = 3},
  [355] = {.lex_state = 129},
  [356] = {.lex_state = 0, .external_lex_state = 3},
  [357] = {.lex_state = 0, .external_lex_state = 3},
  [358] = {.lex_state = 0, .external_lex_state = 3},
  [359] = {.lex_state = 132},
  [360] = {.lex_state = 129},
  [361] = {.lex_state = 129},
  [362] = {.lex_state = 129},
  [363] = {.lex_state = 132},
  [364] = {.lex_state = 129},
  [365] = {.lex_state = 129},
  [366] = {.lex_state = 129},
  [367] = {.lex_state = 132},
  [368] = {.lex_state = 129},
  [369] = {.lex_state = 129},
  [370] = {.lex_state = 129},
  [371] = {.lex_state = 132},
  [372] = {.lex_state = 132},
  [373] = {.lex_state = 129},
  [374] = {.lex_state = 129},
  [375] = {.lex_state = 132},
  [376] = {.lex_state = 129},
  [377] = {.lex_state = 129},
  [378] = {.lex_state = 129},
  [379] = {.lex_state = 129},
  [380] = {.lex_state = 129},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 129},
  [383] = {.lex_state = 129},
  [384] = {.lex_state = 129},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 129},
  [388] = {.lex_state = 129},
  [389] = {.lex_state = 129},
  [390] = {.lex_state = 129},
  [391] = {.lex_state = 129},
  [392] = {.lex_state = 129},
  [393] = {.lex_state = 129},
  [394] = {.lex_state = 129},
  [395] = {.lex_state = 129},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 129},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 129},
  [401] = {.lex_state = 129},
  [402] = {.lex_state = 129},
  [403] = {.lex_state = 129},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 129},
  [406] = {.lex_state = 129},
  [407] = {.lex_state = 129},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 129},
  [411] = {.lex_state = 129},
  [412] = {.lex_state = 129},
  [413] = {.lex_state = 129},
  [414] = {.lex_state = 129},
  [415] = {.lex_state = 129},
  [416] = {.lex_state = 175},
  [417] = {.lex_state = 129},
  [418] = {.lex_state = 129},
  [419] = {.lex_state = 129},
  [420] = {.lex_state = 129},
  [421] = {.lex_state = 129},
  [422] = {.lex_state = 129},
  [423] = {.lex_state = 129},
  [424] = {.lex_state = 129},
  [425] = {.lex_state = 129},
  [426] = {.lex_state = 129},
  [427] = {.lex_state = 129},
  [428] = {.lex_state = 129},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 129},
  [432] = {.lex_state = 0, .external_lex_state = 3},
  [433] = {.lex_state = 129},
  [434] = {.lex_state = 175},
  [435] = {.lex_state = 129},
  [436] = {.lex_state = 129},
  [437] = {.lex_state = 0, .external_lex_state = 3},
  [438] = {.lex_state = 0, .external_lex_state = 3},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 129},
  [441] = {.lex_state = 0, .external_lex_state = 3},
  [442] = {.lex_state = 129},
  [443] = {.lex_state = 0, .external_lex_state = 3},
  [444] = {.lex_state = 129},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 129},
  [447] = {.lex_state = 129},
  [448] = {.lex_state = 129},
  [449] = {.lex_state = 132},
  [450] = {.lex_state = 129},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 129},
  [453] = {.lex_state = 129},
  [454] = {.lex_state = 129},
  [455] = {.lex_state = 129},
  [456] = {.lex_state = 0},
  [457] = {.lex_state = 129},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 129},
  [460] = {.lex_state = 129},
  [461] = {.lex_state = 129},
  [462] = {.lex_state = 129},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 129},
  [465] = {.lex_state = 129},
  [466] = {.lex_state = 129},
  [467] = {.lex_state = 129},
  [468] = {.lex_state = 129},
  [469] = {.lex_state = 129},
  [470] = {.lex_state = 129},
  [471] = {.lex_state = 129},
  [472] = {.lex_state = 129},
  [473] = {.lex_state = 129},
  [474] = {.lex_state = 129},
  [475] = {.lex_state = 129},
  [476] = {.lex_state = 129},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 129},
  [479] = {.lex_state = 129},
  [480] = {.lex_state = 129},
  [481] = {.lex_state = 129},
  [482] = {.lex_state = 129},
  [483] = {.lex_state = 129},
  [484] = {.lex_state = 129},
  [485] = {.lex_state = 129},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 129},
  [488] = {.lex_state = 129},
  [489] = {.lex_state = 129},
  [490] = {.lex_state = 129},
  [491] = {.lex_state = 129},
  [492] = {.lex_state = 129},
  [493] = {.lex_state = 184},
  [494] = {.lex_state = 129},
  [495] = {.lex_state = 129},
  [496] = {.lex_state = 129},
  [497] = {.lex_state = 129},
  [498] = {.lex_state = 129},
  [499] = {.lex_state = 129},
  [500] = {.lex_state = 129},
  [501] = {.lex_state = 132},
  [502] = {.lex_state = 129},
  [503] = {.lex_state = 129},
  [504] = {.lex_state = 129},
  [505] = {.lex_state = 129},
  [506] = {.lex_state = 129},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 129},
  [509] = {.lex_state = 129},
  [510] = {.lex_state = 129},
  [511] = {.lex_state = 129},
  [512] = {.lex_state = 129},
  [513] = {.lex_state = 129},
  [514] = {.lex_state = 129},
  [515] = {.lex_state = 129},
  [516] = {.lex_state = 129},
  [517] = {.lex_state = 129},
  [518] = {.lex_state = 129},
  [519] = {.lex_state = 129},
  [520] = {.lex_state = 129},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 129},
  [523] = {.lex_state = 129},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 129},
  [526] = {.lex_state = 129},
  [527] = {.lex_state = 129},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 129},
  [530] = {.lex_state = 129},
  [531] = {.lex_state = 129},
  [532] = {.lex_state = 129},
  [533] = {.lex_state = 129},
  [534] = {.lex_state = 129},
  [535] = {.lex_state = 129},
  [536] = {.lex_state = 129},
  [537] = {.lex_state = 129},
  [538] = {.lex_state = 129},
  [539] = {.lex_state = 129},
  [540] = {.lex_state = 129},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 129},
  [544] = {.lex_state = 129},
  [545] = {.lex_state = 129},
  [546] = {.lex_state = 129},
  [547] = {.lex_state = 129},
  [548] = {.lex_state = 129},
  [549] = {.lex_state = 129},
  [550] = {.lex_state = 129},
  [551] = {.lex_state = 129},
  [552] = {.lex_state = 129},
  [553] = {.lex_state = 129},
  [554] = {.lex_state = 129},
  [555] = {.lex_state = 129},
  [556] = {.lex_state = 129},
  [557] = {.lex_state = 129},
  [558] = {.lex_state = 129},
  [559] = {.lex_state = 129},
  [560] = {.lex_state = 129},
  [561] = {.lex_state = 129},
  [562] = {.lex_state = 130},
  [563] = {.lex_state = 184},
  [564] = {.lex_state = 129},
  [565] = {.lex_state = 132},
  [566] = {.lex_state = 129},
  [567] = {.lex_state = 129},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 129},
  [570] = {.lex_state = 129},
  [571] = {.lex_state = 129},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 129},
  [574] = {.lex_state = 129},
  [575] = {.lex_state = 129},
  [576] = {.lex_state = 129},
  [577] = {.lex_state = 129},
  [578] = {.lex_state = 129},
  [579] = {.lex_state = 129},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 129},
  [582] = {.lex_state = 129},
  [583] = {.lex_state = 129},
  [584] = {.lex_state = 184},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 129},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 127},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 129},
  [594] = {.lex_state = 129},
  [595] = {.lex_state = 132},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 129},
  [598] = {.lex_state = 129},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 127},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 131},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 129},
  [605] = {.lex_state = 129},
  [606] = {.lex_state = 129},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 129},
  [609] = {.lex_state = 129},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 132},
  [612] = {.lex_state = 129},
  [613] = {.lex_state = 129},
  [614] = {.lex_state = 0},
};

enum {
  ts_external_token__stars = 0,
  ts_external_token__sectionend = 1,
  ts_external_token__eof = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__stars] = sym__stars,
  [ts_external_token__sectionend] = sym__sectionend,
  [ts_external_token__eof] = sym__eof,
};

static const bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__stars] = true,
    [ts_external_token__sectionend] = true,
    [ts_external_token__eof] = true,
  },
  [2] = {
    [ts_external_token__stars] = true,
  },
  [3] = {
    [ts_external_token__stars] = true,
    [ts_external_token__sectionend] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_LF] = ACTIONS(1),
    [sym__eol] = ACTIONS(1),
    [aux_sym__org_stars_token1] = ACTIONS(1),
    [sym__pipe] = ACTIONS(1),
    [sym_atat] = ACTIONS(1),
    [sym_at] = ACTIONS(1),
    [sym_lcurllcurl] = ACTIONS(1),
    [sym_rcurlrcurl] = ACTIONS(1),
    [sym_lcurl] = ACTIONS(1),
    [sym_rcurl] = ACTIONS(1),
    [sym__equal] = ACTIONS(1),
    [sym__comma] = ACTIONS(1),
    [sym__tilde] = ACTIONS(1),
    [sym__hash] = ACTIONS(1),
    [sym_asterisk] = ACTIONS(1),
    [sym_slash] = ACTIONS(1),
    [sym__colon] = ACTIONS(1),
    [sym_plus] = ACTIONS(1),
    [sym_minus] = ACTIONS(1),
    [sym__lparen] = ACTIONS(1),
    [sym__rparen] = ACTIONS(1),
    [sym_flag] = ACTIONS(1),
    [sym_TXN] = ACTIONS(1),
    [sym_BALANCE] = ACTIONS(1),
    [sym_OPEN] = ACTIONS(1),
    [sym_CLOSE] = ACTIONS(1),
    [sym_COMMODITY] = ACTIONS(1),
    [sym_PAD] = ACTIONS(1),
    [sym_EVENT] = ACTIONS(1),
    [sym_PRICE] = ACTIONS(1),
    [sym_NOTE] = ACTIONS(1),
    [sym_DOCUMENT] = ACTIONS(1),
    [sym_QUERY] = ACTIONS(1),
    [sym_CUSTOM] = ACTIONS(1),
    [sym_PUSHTAG] = ACTIONS(1),
    [sym_POPTAG] = ACTIONS(1),
    [sym_PUSHMETA] = ACTIONS(1),
    [sym_POPMETA] = ACTIONS(1),
    [sym_OPTION] = ACTIONS(1),
    [sym_INCLUDE] = ACTIONS(1),
    [sym_PLUGIN] = ACTIONS(1),
    [sym__none] = ACTIONS(1),
    [sym_date] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_tag] = ACTIONS(1),
    [sym_link] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [sym__UTF_8_1] = ACTIONS(1),
    [aux_sym__UTF_8_2_token1] = ACTIONS(1),
    [aux_sym__UTF_8_3_token1] = ACTIONS(1),
    [aux_sym__UTF_8_3_token2] = ACTIONS(1),
    [aux_sym__UTF_8_3_token3] = ACTIONS(1),
    [aux_sym__UTF_8_3_token4] = ACTIONS(1),
    [aux_sym__UTF_8_4_token1] = ACTIONS(1),
    [aux_sym__UTF_8_4_token2] = ACTIONS(1),
    [aux_sym__UTF_8_4_token3] = ACTIONS(1),
    [sym__stars] = ACTIONS(1),
    [sym__sectionend] = ACTIONS(1),
    [sym__eof] = ACTIONS(1),
  },
  [1] = {
    [sym_file] = STATE(568),
    [sym__nl] = STATE(7),
    [sym_section] = STATE(7),
    [sym__org_stars] = STATE(590),
    [sym_headline] = STATE(2),
    [sym_transaction] = STATE(7),
    [sym_pushtag] = STATE(7),
    [sym_poptag] = STATE(7),
    [sym_pushmeta] = STATE(7),
    [sym_popmeta] = STATE(7),
    [sym_open] = STATE(7),
    [sym_close] = STATE(7),
    [sym_commodity] = STATE(7),
    [sym_pad] = STATE(7),
    [sym_balance] = STATE(7),
    [sym_price] = STATE(7),
    [sym_event] = STATE(7),
    [sym_query] = STATE(7),
    [sym_note] = STATE(7),
    [sym_document] = STATE(7),
    [sym_custom] = STATE(7),
    [sym__entry] = STATE(7),
    [sym_option] = STATE(7),
    [sym_include] = STATE(7),
    [sym_plugin] = STATE(7),
    [sym__directive] = STATE(7),
    [sym__declarations] = STATE(7),
    [sym_comment] = STATE(597),
    [sym__skipped_lines] = STATE(7),
    [aux_sym_file_repeat1] = STATE(7),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_LF] = ACTIONS(5),
    [anon_sym_CR] = ACTIONS(7),
    [sym__eol] = ACTIONS(5),
    [sym__colon] = ACTIONS(9),
    [sym_flag] = ACTIONS(9),
    [sym_PUSHTAG] = ACTIONS(11),
    [sym_POPTAG] = ACTIONS(13),
    [sym_PUSHMETA] = ACTIONS(15),
    [sym_POPMETA] = ACTIONS(17),
    [sym_OPTION] = ACTIONS(19),
    [sym_INCLUDE] = ACTIONS(21),
    [sym_PLUGIN] = ACTIONS(23),
    [sym_date] = ACTIONS(25),
    [anon_sym_SEMI] = ACTIONS(27),
    [sym__stars] = ACTIONS(29),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 20,
    ACTIONS(27), 1,
      anon_sym_SEMI,
    ACTIONS(29), 1,
      sym__stars,
    ACTIONS(33), 1,
      anon_sym_CR,
    ACTIONS(37), 1,
      sym_PUSHTAG,
    ACTIONS(39), 1,
      sym_POPTAG,
    ACTIONS(41), 1,
      sym_PUSHMETA,
    ACTIONS(43), 1,
      sym_POPMETA,
    ACTIONS(45), 1,
      sym_OPTION,
    ACTIONS(47), 1,
      sym_INCLUDE,
    ACTIONS(49), 1,
      sym_PLUGIN,
    ACTIONS(51), 1,
      sym_date,
    ACTIONS(53), 1,
      sym__sectionend,
    STATE(4), 1,
      sym_headline,
    STATE(354), 1,
      aux_sym_section_repeat2,
    STATE(443), 1,
      sym_section,
    STATE(487), 1,
      sym_comment,
    STATE(590), 1,
      sym__org_stars,
    ACTIONS(31), 2,
      anon_sym_LF,
      sym__eol,
    ACTIONS(35), 2,
      sym__colon,
      sym_flag,
    STATE(5), 25,
      sym__nl,
      sym_transaction,
      sym_pushtag,
      sym_poptag,
      sym_pushmeta,
      sym_popmeta,
      sym_open,
      sym_close,
      sym_commodity,
      sym_pad,
      sym_balance,
      sym_price,
      sym_event,
      sym_query,
      sym_note,
      sym_document,
      sym_custom,
      sym__entry,
      sym_option,
      sym_include,
      sym_plugin,
      sym__directive,
      sym__declarations,
      sym__skipped_lines,
      aux_sym_section_repeat1,
  [87] = 20,
    ACTIONS(27), 1,
      anon_sym_SEMI,
    ACTIONS(29), 1,
      sym__stars,
    ACTIONS(37), 1,
      sym_PUSHTAG,
    ACTIONS(39), 1,
      sym_POPTAG,
    ACTIONS(41), 1,
      sym_PUSHMETA,
    ACTIONS(43), 1,
      sym_POPMETA,
    ACTIONS(45), 1,
      sym_OPTION,
    ACTIONS(47), 1,
      sym_INCLUDE,
    ACTIONS(49), 1,
      sym_PLUGIN,
    ACTIONS(51), 1,
      sym_date,
    ACTIONS(57), 1,
      anon_sym_CR,
    ACTIONS(59), 1,
      sym__sectionend,
    STATE(4), 1,
      sym_headline,
    STATE(356), 1,
      aux_sym_section_repeat2,
    STATE(443), 1,
      sym_section,
    STATE(487), 1,
      sym_comment,
    STATE(590), 1,
      sym__org_stars,
    ACTIONS(35), 2,
      sym__colon,
      sym_flag,
    ACTIONS(55), 2,
      anon_sym_LF,
      sym__eol,
    STATE(8), 25,
      sym__nl,
      sym_transaction,
      sym_pushtag,
      sym_poptag,
      sym_pushmeta,
      sym_popmeta,
      sym_open,
      sym_close,
      sym_commodity,
      sym_pad,
      sym_balance,
      sym_price,
      sym_event,
      sym_query,
      sym_note,
      sym_document,
      sym_custom,
      sym__entry,
      sym_option,
      sym_include,
      sym_plugin,
      sym__directive,
      sym__declarations,
      sym__skipped_lines,
      aux_sym_section_repeat1,
  [174] = 20,
    ACTIONS(27), 1,
      anon_sym_SEMI,
    ACTIONS(29), 1,
      sym__stars,
    ACTIONS(37), 1,
      sym_PUSHTAG,
    ACTIONS(39), 1,
      sym_POPTAG,
    ACTIONS(41), 1,
      sym_PUSHMETA,
    ACTIONS(43), 1,
      sym_POPMETA,
    ACTIONS(45), 1,
      sym_OPTION,
    ACTIONS(47), 1,
      sym_INCLUDE,
    ACTIONS(49), 1,
      sym_PLUGIN,
    ACTIONS(51), 1,
      sym_date,
    ACTIONS(63), 1,
      anon_sym_CR,
    ACTIONS(65), 1,
      sym__sectionend,
    STATE(4), 1,
      sym_headline,
    STATE(347), 1,
      aux_sym_section_repeat2,
    STATE(443), 1,
      sym_section,
    STATE(487), 1,
      sym_comment,
    STATE(590), 1,
      sym__org_stars,
    ACTIONS(35), 2,
      sym__colon,
      sym_flag,
    ACTIONS(61), 2,
      anon_sym_LF,
      sym__eol,
    STATE(3), 25,
      sym__nl,
      sym_transaction,
      sym_pushtag,
      sym_poptag,
      sym_pushmeta,
      sym_popmeta,
      sym_open,
      sym_close,
      sym_commodity,
      sym_pad,
      sym_balance,
      sym_price,
      sym_event,
      sym_query,
      sym_note,
      sym_document,
      sym_custom,
      sym__entry,
      sym_option,
      sym_include,
      sym_plugin,
      sym__directive,
      sym__declarations,
      sym__skipped_lines,
      aux_sym_section_repeat1,
  [261] = 20,
    ACTIONS(27), 1,
      anon_sym_SEMI,
    ACTIONS(29), 1,
      sym__stars,
    ACTIONS(37), 1,
      sym_PUSHTAG,
    ACTIONS(39), 1,
      sym_POPTAG,
    ACTIONS(41), 1,
      sym_PUSHMETA,
    ACTIONS(43), 1,
      sym_POPMETA,
    ACTIONS(45), 1,
      sym_OPTION,
    ACTIONS(47), 1,
      sym_INCLUDE,
    ACTIONS(49), 1,
      sym_PLUGIN,
    ACTIONS(51), 1,
      sym_date,
    ACTIONS(57), 1,
      anon_sym_CR,
    ACTIONS(67), 1,
      sym__sectionend,
    STATE(4), 1,
      sym_headline,
    STATE(357), 1,
      aux_sym_section_repeat2,
    STATE(443), 1,
      sym_section,
    STATE(487), 1,
      sym_comment,
    STATE(590), 1,
      sym__org_stars,
    ACTIONS(35), 2,
      sym__colon,
      sym_flag,
    ACTIONS(55), 2,
      anon_sym_LF,
      sym__eol,
    STATE(8), 25,
      sym__nl,
      sym_transaction,
      sym_pushtag,
      sym_poptag,
      sym_pushmeta,
      sym_popmeta,
      sym_open,
      sym_close,
      sym_commodity,
      sym_pad,
      sym_balance,
      sym_price,
      sym_event,
      sym_query,
      sym_note,
      sym_document,
      sym_custom,
      sym__entry,
      sym_option,
      sym_include,
      sym_plugin,
      sym__directive,
      sym__declarations,
      sym__skipped_lines,
      aux_sym_section_repeat1,
  [348] = 18,
    ACTIONS(69), 1,
      ts_builtin_sym_end,
    ACTIONS(74), 1,
      anon_sym_CR,
    ACTIONS(80), 1,
      sym_PUSHTAG,
    ACTIONS(83), 1,
      sym_POPTAG,
    ACTIONS(86), 1,
      sym_PUSHMETA,
    ACTIONS(89), 1,
      sym_POPMETA,
    ACTIONS(92), 1,
      sym_OPTION,
    ACTIONS(95), 1,
      sym_INCLUDE,
    ACTIONS(98), 1,
      sym_PLUGIN,
    ACTIONS(101), 1,
      sym_date,
    ACTIONS(104), 1,
      anon_sym_SEMI,
    ACTIONS(107), 1,
      sym__stars,
    STATE(2), 1,
      sym_headline,
    STATE(590), 1,
      sym__org_stars,
    STATE(597), 1,
      sym_comment,
    ACTIONS(71), 2,
      anon_sym_LF,
      sym__eol,
    ACTIONS(77), 2,
      sym__colon,
      sym_flag,
    STATE(6), 26,
      sym__nl,
      sym_section,
      sym_transaction,
      sym_pushtag,
      sym_poptag,
      sym_pushmeta,
      sym_popmeta,
      sym_open,
      sym_close,
      sym_commodity,
      sym_pad,
      sym_balance,
      sym_price,
      sym_event,
      sym_query,
      sym_note,
      sym_document,
      sym_custom,
      sym__entry,
      sym_option,
      sym_include,
      sym_plugin,
      sym__directive,
      sym__declarations,
      sym__skipped_lines,
      aux_sym_file_repeat1,
  [430] = 18,
    ACTIONS(11), 1,
      sym_PUSHTAG,
    ACTIONS(13), 1,
      sym_POPTAG,
    ACTIONS(15), 1,
      sym_PUSHMETA,
    ACTIONS(17), 1,
      sym_POPMETA,
    ACTIONS(19), 1,
      sym_OPTION,
    ACTIONS(21), 1,
      sym_INCLUDE,
    ACTIONS(23), 1,
      sym_PLUGIN,
    ACTIONS(25), 1,
      sym_date,
    ACTIONS(27), 1,
      anon_sym_SEMI,
    ACTIONS(29), 1,
      sym__stars,
    ACTIONS(110), 1,
      ts_builtin_sym_end,
    ACTIONS(114), 1,
      anon_sym_CR,
    STATE(2), 1,
      sym_headline,
    STATE(590), 1,
      sym__org_stars,
    STATE(597), 1,
      sym_comment,
    ACTIONS(9), 2,
      sym__colon,
      sym_flag,
    ACTIONS(112), 2,
      anon_sym_LF,
      sym__eol,
    STATE(6), 26,
      sym__nl,
      sym_section,
      sym_transaction,
      sym_pushtag,
      sym_poptag,
      sym_pushmeta,
      sym_popmeta,
      sym_open,
      sym_close,
      sym_commodity,
      sym_pad,
      sym_balance,
      sym_price,
      sym_event,
      sym_query,
      sym_note,
      sym_document,
      sym_custom,
      sym__entry,
      sym_option,
      sym_include,
      sym_plugin,
      sym__directive,
      sym__declarations,
      sym__skipped_lines,
      aux_sym_file_repeat1,
  [512] = 15,
    ACTIONS(119), 1,
      anon_sym_CR,
    ACTIONS(125), 1,
      sym_PUSHTAG,
    ACTIONS(128), 1,
      sym_POPTAG,
    ACTIONS(131), 1,
      sym_PUSHMETA,
    ACTIONS(134), 1,
      sym_POPMETA,
    ACTIONS(137), 1,
      sym_OPTION,
    ACTIONS(140), 1,
      sym_INCLUDE,
    ACTIONS(143), 1,
      sym_PLUGIN,
    ACTIONS(146), 1,
      sym_date,
    ACTIONS(149), 1,
      anon_sym_SEMI,
    STATE(487), 1,
      sym_comment,
    ACTIONS(116), 2,
      anon_sym_LF,
      sym__eol,
    ACTIONS(122), 2,
      sym__colon,
      sym_flag,
    ACTIONS(152), 2,
      sym__stars,
      sym__sectionend,
    STATE(8), 25,
      sym__nl,
      sym_transaction,
      sym_pushtag,
      sym_poptag,
      sym_pushmeta,
      sym_popmeta,
      sym_open,
      sym_close,
      sym_commodity,
      sym_pad,
      sym_balance,
      sym_price,
      sym_event,
      sym_query,
      sym_note,
      sym_document,
      sym_custom,
      sym__entry,
      sym_option,
      sym_include,
      sym_plugin,
      sym__directive,
      sym__declarations,
      sym__skipped_lines,
      aux_sym_section_repeat1,
  [585] = 5,
    ACTIONS(158), 1,
      sym__indent,
    STATE(282), 1,
      sym_posting_or_kv_list,
    ACTIONS(154), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(36), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(156), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [617] = 5,
    ACTIONS(158), 1,
      sym__indent,
    STATE(268), 1,
      sym_posting_or_kv_list,
    ACTIONS(160), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(36), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(162), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [649] = 5,
    ACTIONS(158), 1,
      sym__indent,
    STATE(218), 1,
      sym_posting_or_kv_list,
    ACTIONS(164), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(36), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(166), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [681] = 5,
    ACTIONS(158), 1,
      sym__indent,
    STATE(220), 1,
      sym_posting_or_kv_list,
    ACTIONS(168), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(36), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(170), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [713] = 5,
    ACTIONS(158), 1,
      sym__indent,
    STATE(221), 1,
      sym_posting_or_kv_list,
    ACTIONS(172), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(36), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(174), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [745] = 5,
    ACTIONS(176), 1,
      sym__indent,
    STATE(277), 1,
      sym_posting_or_kv_list,
    ACTIONS(154), 2,
      sym__stars,
      sym__sectionend,
    STATE(38), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(156), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [777] = 5,
    ACTIONS(176), 1,
      sym__indent,
    STATE(246), 1,
      sym_posting_or_kv_list,
    ACTIONS(172), 2,
      sym__stars,
      sym__sectionend,
    STATE(38), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(174), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [809] = 5,
    ACTIONS(176), 1,
      sym__indent,
    STATE(276), 1,
      sym_posting_or_kv_list,
    ACTIONS(168), 2,
      sym__stars,
      sym__sectionend,
    STATE(38), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(170), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [841] = 5,
    ACTIONS(176), 1,
      sym__indent,
    STATE(239), 1,
      sym_posting_or_kv_list,
    ACTIONS(164), 2,
      sym__stars,
      sym__sectionend,
    STATE(38), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(166), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [873] = 5,
    ACTIONS(158), 1,
      sym__indent,
    STATE(275), 1,
      sym_posting_or_kv_list,
    ACTIONS(178), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(36), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(180), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [905] = 5,
    ACTIONS(158), 1,
      sym__indent,
    STATE(256), 1,
      sym_posting_or_kv_list,
    ACTIONS(182), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(36), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(184), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [937] = 5,
    ACTIONS(176), 1,
      sym__indent,
    STATE(263), 1,
      sym_posting_or_kv_list,
    ACTIONS(182), 2,
      sym__stars,
      sym__sectionend,
    STATE(38), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(184), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [969] = 5,
    ACTIONS(176), 1,
      sym__indent,
    STATE(286), 1,
      sym_posting_or_kv_list,
    ACTIONS(160), 2,
      sym__stars,
      sym__sectionend,
    STATE(38), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(162), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1001] = 5,
    ACTIONS(158), 1,
      sym__indent,
    STATE(271), 1,
      sym_posting_or_kv_list,
    ACTIONS(186), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(36), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(188), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1033] = 5,
    ACTIONS(176), 1,
      sym__indent,
    STATE(267), 1,
      sym_posting_or_kv_list,
    ACTIONS(186), 2,
      sym__stars,
      sym__sectionend,
    STATE(38), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(188), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1065] = 5,
    ACTIONS(176), 1,
      sym__indent,
    STATE(273), 1,
      sym_posting_or_kv_list,
    ACTIONS(178), 2,
      sym__stars,
      sym__sectionend,
    STATE(38), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(180), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1097] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(281), 1,
      sym_key_value_list,
    ACTIONS(194), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(190), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1128] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(247), 1,
      sym_key_value_list,
    ACTIONS(198), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(196), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1159] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(219), 1,
      sym_key_value_list,
    ACTIONS(202), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(200), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1190] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(230), 1,
      sym_key_value_list,
    ACTIONS(206), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(204), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1221] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(234), 1,
      sym_key_value_list,
    ACTIONS(210), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(208), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1252] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(236), 1,
      sym_key_value_list,
    ACTIONS(214), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(212), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1283] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(240), 1,
      sym_key_value_list,
    ACTIONS(218), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(216), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1314] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(241), 1,
      sym_key_value_list,
    ACTIONS(222), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(220), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1345] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(194), 1,
      sym_key_value_list,
    ACTIONS(226), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(224), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1376] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(245), 1,
      sym_key_value_list,
    ACTIONS(230), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(228), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1407] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(251), 1,
      sym_key_value_list,
    ACTIONS(234), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(232), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1438] = 4,
    ACTIONS(158), 1,
      sym__indent,
    ACTIONS(236), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(58), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(238), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1467] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(259), 1,
      sym_key_value_list,
    ACTIONS(242), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(240), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1498] = 4,
    ACTIONS(176), 1,
      sym__indent,
    ACTIONS(236), 2,
      sym__stars,
      sym__sectionend,
    STATE(48), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(238), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1527] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(279), 1,
      sym_key_value_list,
    ACTIONS(246), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(244), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1558] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(280), 1,
      sym_key_value_list,
    ACTIONS(250), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(248), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1589] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(283), 1,
      sym_key_value_list,
    ACTIONS(254), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(252), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1620] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(264), 1,
      sym_key_value_list,
    ACTIONS(258), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(256), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1651] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(257), 1,
      sym_key_value_list,
    ACTIONS(258), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(256), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1682] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(213), 1,
      sym_key_value_list,
    ACTIONS(264), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(262), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1713] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(211), 1,
      sym_key_value_list,
    ACTIONS(268), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(266), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1744] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(229), 1,
      sym_key_value_list,
    ACTIONS(270), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(272), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1775] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(228), 1,
      sym_key_value_list,
    ACTIONS(274), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(276), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1806] = 4,
    ACTIONS(280), 1,
      sym__indent,
    ACTIONS(283), 2,
      sym__stars,
      sym__sectionend,
    STATE(48), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(278), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1835] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(227), 1,
      sym_key_value_list,
    ACTIONS(285), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(287), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1866] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(225), 1,
      sym_key_value_list,
    ACTIONS(289), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(291), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1897] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(224), 1,
      sym_key_value_list,
    ACTIONS(293), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(295), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1928] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(258), 1,
      sym_key_value_list,
    ACTIONS(270), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(272), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1959] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(255), 1,
      sym_key_value_list,
    ACTIONS(274), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(276), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [1990] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(223), 1,
      sym_key_value_list,
    ACTIONS(198), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(196), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2021] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(217), 1,
      sym_key_value_list,
    ACTIONS(299), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(297), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2052] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(253), 1,
      sym_key_value_list,
    ACTIONS(285), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(287), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2083] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(248), 1,
      sym_key_value_list,
    ACTIONS(293), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(295), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2114] = 4,
    ACTIONS(301), 1,
      sym__indent,
    ACTIONS(283), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(58), 3,
      sym_posting,
      sym_key_value_line,
      aux_sym_posting_or_kv_list_repeat1,
    ACTIONS(278), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2143] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(206), 1,
      sym_key_value_list,
    ACTIONS(268), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(266), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2174] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(242), 1,
      sym_key_value_list,
    ACTIONS(264), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(262), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2205] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(203), 1,
      sym_key_value_list,
    ACTIONS(299), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(297), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2236] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(202), 1,
      sym_key_value_list,
    ACTIONS(202), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(200), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2267] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(201), 1,
      sym_key_value_list,
    ACTIONS(206), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(204), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2298] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(200), 1,
      sym_key_value_list,
    ACTIONS(210), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(208), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2329] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(198), 1,
      sym_key_value_list,
    ACTIONS(214), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(212), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2360] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(197), 1,
      sym_key_value_list,
    ACTIONS(218), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(216), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2391] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(196), 1,
      sym_key_value_list,
    ACTIONS(222), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(220), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2422] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(209), 1,
      sym_key_value_list,
    ACTIONS(226), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(224), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2453] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(210), 1,
      sym_key_value_list,
    ACTIONS(230), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(228), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2484] = 5,
    ACTIONS(192), 1,
      sym__indent,
    STATE(252), 1,
      sym_key_value_list,
    ACTIONS(289), 2,
      sym__stars,
      sym__sectionend,
    STATE(80), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(291), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2515] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(195), 1,
      sym_key_value_list,
    ACTIONS(234), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(232), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2546] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(261), 1,
      sym_key_value_list,
    ACTIONS(250), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(248), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2577] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(250), 1,
      sym_key_value_list,
    ACTIONS(242), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(240), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2608] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(260), 1,
      sym_key_value_list,
    ACTIONS(194), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(190), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2639] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(205), 1,
      sym_key_value_list,
    ACTIONS(246), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(244), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2670] = 5,
    ACTIONS(260), 1,
      sym__indent,
    STATE(216), 1,
      sym_key_value_list,
    ACTIONS(254), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(77), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(252), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2701] = 4,
    ACTIONS(260), 1,
      sym__indent,
    ACTIONS(304), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(79), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(306), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2729] = 4,
    ACTIONS(310), 1,
      sym__indent,
    ACTIONS(313), 2,
      sym__stars,
      sym__sectionend,
    STATE(78), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(308), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2757] = 4,
    ACTIONS(315), 1,
      sym__indent,
    ACTIONS(313), 2,
      sym__stars,
      ts_builtin_sym_end,
    STATE(79), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(308), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2785] = 4,
    ACTIONS(192), 1,
      sym__indent,
    ACTIONS(304), 2,
      sym__stars,
      sym__sectionend,
    STATE(78), 2,
      sym_key_value_line,
      aux_sym_key_value_list_repeat1,
    ACTIONS(306), 14,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2813] = 8,
    ACTIONS(318), 1,
      sym__eol,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(328), 1,
      sym_number,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(480), 2,
      sym__key_value_value,
      sym_amount,
    ACTIONS(324), 3,
      sym__none,
      sym_bool,
      sym_currency,
    ACTIONS(326), 4,
      sym_date,
      sym_account,
      sym_string,
      sym_tag,
    STATE(350), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [2848] = 2,
    ACTIONS(330), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(332), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2870] = 2,
    ACTIONS(336), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(334), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [2892] = 13,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(338), 1,
      sym__eol,
    ACTIONS(340), 1,
      sym_atat,
    ACTIONS(342), 1,
      sym_at,
    ACTIONS(344), 1,
      sym_lcurllcurl,
    ACTIONS(346), 1,
      sym_lcurl,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    STATE(332), 1,
      sym_incomplete_amount,
    STATE(379), 1,
      sym_cost_spec,
    STATE(552), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [2936] = 13,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(344), 1,
      sym_lcurllcurl,
    ACTIONS(346), 1,
      sym_lcurl,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(352), 1,
      sym__eol,
    ACTIONS(354), 1,
      sym_atat,
    ACTIONS(356), 1,
      sym_at,
    STATE(330), 1,
      sym_incomplete_amount,
    STATE(360), 1,
      sym_cost_spec,
    STATE(540), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [2980] = 10,
    ACTIONS(358), 1,
      sym__eol,
    ACTIONS(362), 1,
      sym__lparen,
    ACTIONS(364), 1,
      sym_bool,
    ACTIONS(368), 1,
      sym_number,
    STATE(322), 1,
      sym_amount,
    STATE(519), 1,
      sym_custom_value_list,
    ACTIONS(360), 2,
      sym_plus,
      sym_minus,
    STATE(272), 2,
      sym_custom_value,
      aux_sym_custom_value_list_repeat1,
    ACTIONS(366), 3,
      sym_date,
      sym_account,
      sym_string,
    STATE(310), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [3018] = 2,
    ACTIONS(372), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(370), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3040] = 2,
    ACTIONS(376), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(374), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3062] = 2,
    ACTIONS(380), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(378), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3084] = 2,
    ACTIONS(384), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(382), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3106] = 2,
    ACTIONS(388), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(386), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3128] = 2,
    ACTIONS(392), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(390), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3150] = 2,
    ACTIONS(396), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(394), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3172] = 2,
    ACTIONS(400), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(398), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3194] = 2,
    ACTIONS(404), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(402), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3216] = 2,
    ACTIONS(408), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(406), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3238] = 2,
    ACTIONS(412), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(410), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3260] = 2,
    ACTIONS(416), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(414), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3282] = 2,
    ACTIONS(420), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(418), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3304] = 2,
    ACTIONS(424), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(422), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3326] = 2,
    ACTIONS(428), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(426), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3348] = 2,
    ACTIONS(432), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(430), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3370] = 2,
    ACTIONS(436), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(434), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3392] = 2,
    ACTIONS(440), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(438), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3414] = 2,
    ACTIONS(444), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(442), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3436] = 2,
    ACTIONS(448), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(446), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3458] = 2,
    ACTIONS(452), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(450), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3480] = 2,
    ACTIONS(456), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(454), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3502] = 2,
    ACTIONS(330), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(332), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3524] = 2,
    ACTIONS(460), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(458), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3546] = 2,
    ACTIONS(464), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(462), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3568] = 2,
    ACTIONS(468), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(466), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3590] = 2,
    ACTIONS(472), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(470), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3612] = 2,
    ACTIONS(476), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(474), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3634] = 2,
    ACTIONS(480), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(478), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3656] = 2,
    ACTIONS(484), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(482), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3678] = 2,
    ACTIONS(488), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(486), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3700] = 2,
    ACTIONS(492), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(490), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3722] = 2,
    ACTIONS(496), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(494), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3744] = 2,
    ACTIONS(500), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(498), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3766] = 2,
    ACTIONS(504), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(502), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3788] = 2,
    ACTIONS(508), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(506), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3810] = 2,
    ACTIONS(512), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(510), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3832] = 2,
    ACTIONS(516), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(514), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3854] = 2,
    ACTIONS(520), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(518), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3876] = 2,
    ACTIONS(524), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(522), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3898] = 2,
    ACTIONS(528), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(526), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3920] = 2,
    ACTIONS(532), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(530), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3942] = 2,
    ACTIONS(536), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(534), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3964] = 2,
    ACTIONS(540), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(538), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [3986] = 2,
    ACTIONS(544), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(542), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4008] = 2,
    ACTIONS(548), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(546), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4030] = 2,
    ACTIONS(552), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(550), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4052] = 2,
    ACTIONS(556), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(554), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4074] = 2,
    ACTIONS(560), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(558), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4096] = 2,
    ACTIONS(313), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(308), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4118] = 2,
    ACTIONS(283), 2,
      sym__stars,
      sym__sectionend,
    ACTIONS(278), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4140] = 2,
    ACTIONS(372), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(370), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4162] = 2,
    ACTIONS(336), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(334), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4184] = 2,
    ACTIONS(376), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(374), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4206] = 2,
    ACTIONS(380), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(378), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4228] = 2,
    ACTIONS(384), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(382), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4250] = 2,
    ACTIONS(388), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(386), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4272] = 2,
    ACTIONS(392), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(390), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4294] = 2,
    ACTIONS(396), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(394), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4316] = 10,
    ACTIONS(362), 1,
      sym__lparen,
    ACTIONS(364), 1,
      sym_bool,
    ACTIONS(368), 1,
      sym_number,
    ACTIONS(562), 1,
      sym__eol,
    STATE(322), 1,
      sym_amount,
    STATE(465), 1,
      sym_custom_value_list,
    ACTIONS(360), 2,
      sym_plus,
      sym_minus,
    STATE(272), 2,
      sym_custom_value,
      aux_sym_custom_value_list_repeat1,
    ACTIONS(366), 3,
      sym_date,
      sym_account,
      sym_string,
    STATE(310), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [4354] = 2,
    ACTIONS(400), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(398), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4376] = 2,
    ACTIONS(404), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(402), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4398] = 2,
    ACTIONS(408), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(406), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4420] = 2,
    ACTIONS(412), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(410), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4442] = 2,
    ACTIONS(416), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(414), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4464] = 2,
    ACTIONS(420), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(418), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4486] = 2,
    ACTIONS(424), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(422), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4508] = 2,
    ACTIONS(428), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(426), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4530] = 2,
    ACTIONS(432), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(430), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4552] = 2,
    ACTIONS(436), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(434), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4574] = 2,
    ACTIONS(440), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(438), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4596] = 2,
    ACTIONS(444), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(442), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4618] = 2,
    ACTIONS(448), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(446), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4640] = 2,
    ACTIONS(452), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(450), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4662] = 2,
    ACTIONS(456), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(454), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4684] = 2,
    ACTIONS(460), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(458), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4706] = 2,
    ACTIONS(464), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(462), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4728] = 2,
    ACTIONS(468), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(466), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4750] = 2,
    ACTIONS(283), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(278), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4772] = 2,
    ACTIONS(472), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(470), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4794] = 13,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(344), 1,
      sym_lcurllcurl,
    ACTIONS(346), 1,
      sym_lcurl,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(564), 1,
      sym__eol,
    ACTIONS(566), 1,
      sym_atat,
    ACTIONS(568), 1,
      sym_at,
    STATE(343), 1,
      sym_incomplete_amount,
    STATE(362), 1,
      sym_cost_spec,
    STATE(482), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [4838] = 2,
    ACTIONS(476), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(474), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4860] = 2,
    ACTIONS(480), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(478), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4882] = 2,
    ACTIONS(484), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(482), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4904] = 2,
    ACTIONS(488), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(486), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4926] = 2,
    ACTIONS(492), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(490), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4948] = 2,
    ACTIONS(496), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(494), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4970] = 2,
    ACTIONS(500), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(498), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [4992] = 2,
    ACTIONS(504), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(502), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5014] = 2,
    ACTIONS(508), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(506), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5036] = 2,
    ACTIONS(512), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(510), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5058] = 2,
    ACTIONS(516), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(514), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5080] = 2,
    ACTIONS(520), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(518), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5102] = 2,
    ACTIONS(524), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(522), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5124] = 2,
    ACTIONS(528), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(526), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5146] = 2,
    ACTIONS(532), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(530), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5168] = 2,
    ACTIONS(536), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(534), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5190] = 2,
    ACTIONS(540), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(538), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5212] = 2,
    ACTIONS(313), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(308), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5234] = 2,
    ACTIONS(544), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(542), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5256] = 2,
    ACTIONS(548), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(546), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5278] = 2,
    ACTIONS(552), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(550), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5300] = 13,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(344), 1,
      sym_lcurllcurl,
    ACTIONS(346), 1,
      sym_lcurl,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(570), 1,
      sym__eol,
    ACTIONS(572), 1,
      sym_atat,
    ACTIONS(574), 1,
      sym_at,
    STATE(333), 1,
      sym_incomplete_amount,
    STATE(374), 1,
      sym_cost_spec,
    STATE(545), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [5344] = 2,
    ACTIONS(556), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(554), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5366] = 11,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(576), 1,
      sym_rcurl,
    ACTIONS(578), 1,
      sym__hash,
    ACTIONS(582), 1,
      sym_currency,
    ACTIONS(584), 1,
      sym_number,
    STATE(381), 1,
      sym_cost_comp,
    STATE(398), 1,
      sym_compound_amount,
    STATE(556), 1,
      sym_cost_comp_list,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    ACTIONS(580), 3,
      sym_asterisk,
      sym_date,
      sym_string,
    STATE(316), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [5406] = 11,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(576), 1,
      sym_rcurlrcurl,
    ACTIONS(578), 1,
      sym__hash,
    ACTIONS(582), 1,
      sym_currency,
    ACTIONS(584), 1,
      sym_number,
    STATE(381), 1,
      sym_cost_comp,
    STATE(398), 1,
      sym_compound_amount,
    STATE(562), 1,
      sym_cost_comp_list,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    ACTIONS(580), 3,
      sym_asterisk,
      sym_date,
      sym_string,
    STATE(316), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [5446] = 2,
    ACTIONS(560), 2,
      sym__stars,
      ts_builtin_sym_end,
    ACTIONS(558), 15,
      anon_sym_LF,
      anon_sym_CR,
      sym__eol,
      sym__indent,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5468] = 2,
    ACTIONS(588), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(586), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5489] = 2,
    ACTIONS(590), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(592), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5510] = 2,
    ACTIONS(594), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(596), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5531] = 2,
    ACTIONS(598), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(600), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5552] = 2,
    ACTIONS(602), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(604), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5573] = 2,
    ACTIONS(606), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(608), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5594] = 2,
    ACTIONS(610), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(612), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5615] = 2,
    ACTIONS(614), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(616), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5636] = 2,
    ACTIONS(618), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(620), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5657] = 2,
    ACTIONS(622), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(624), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5678] = 2,
    ACTIONS(626), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(628), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5699] = 2,
    ACTIONS(630), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(632), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5720] = 2,
    ACTIONS(634), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(636), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5741] = 2,
    ACTIONS(638), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(640), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5762] = 2,
    ACTIONS(644), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(642), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5783] = 2,
    ACTIONS(588), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(586), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5804] = 2,
    ACTIONS(646), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(648), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5825] = 2,
    ACTIONS(634), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(636), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5846] = 2,
    ACTIONS(652), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(650), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5867] = 2,
    ACTIONS(656), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(654), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5888] = 2,
    ACTIONS(660), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(658), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5909] = 2,
    ACTIONS(662), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(664), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5930] = 2,
    ACTIONS(666), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(668), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5951] = 2,
    ACTIONS(622), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(624), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5972] = 2,
    ACTIONS(670), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(672), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [5993] = 2,
    ACTIONS(618), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(620), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6014] = 2,
    ACTIONS(674), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(676), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6035] = 2,
    ACTIONS(678), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(680), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6056] = 2,
    ACTIONS(684), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(682), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6077] = 2,
    ACTIONS(686), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(688), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6098] = 2,
    ACTIONS(690), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(692), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6119] = 2,
    ACTIONS(694), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(696), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6140] = 2,
    ACTIONS(700), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(698), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6161] = 2,
    ACTIONS(702), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(704), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6182] = 2,
    ACTIONS(706), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(708), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6203] = 2,
    ACTIONS(710), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(712), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6224] = 2,
    ACTIONS(614), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(616), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6245] = 14,
    ACTIONS(716), 1,
      sym_flag,
    ACTIONS(718), 1,
      sym_BALANCE,
    ACTIONS(720), 1,
      sym_OPEN,
    ACTIONS(722), 1,
      sym_CLOSE,
    ACTIONS(724), 1,
      sym_COMMODITY,
    ACTIONS(726), 1,
      sym_PAD,
    ACTIONS(728), 1,
      sym_EVENT,
    ACTIONS(730), 1,
      sym_PRICE,
    ACTIONS(732), 1,
      sym_NOTE,
    ACTIONS(734), 1,
      sym_DOCUMENT,
    ACTIONS(736), 1,
      sym_QUERY,
    ACTIONS(738), 1,
      sym_CUSTOM,
    STATE(326), 1,
      sym_txn,
    ACTIONS(714), 3,
      sym__hash,
      sym_asterisk,
      sym_TXN,
  [6290] = 2,
    ACTIONS(662), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(664), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6311] = 2,
    ACTIONS(638), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(640), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6332] = 2,
    ACTIONS(610), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(612), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6353] = 2,
    ACTIONS(742), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(740), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6374] = 2,
    ACTIONS(602), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(604), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6395] = 2,
    ACTIONS(606), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(608), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6416] = 2,
    ACTIONS(626), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(628), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6437] = 2,
    ACTIONS(670), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(672), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6458] = 2,
    ACTIONS(598), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(600), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6479] = 2,
    ACTIONS(594), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(596), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6500] = 2,
    ACTIONS(656), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(654), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6521] = 2,
    ACTIONS(742), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(740), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6542] = 2,
    ACTIONS(652), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(650), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6563] = 2,
    ACTIONS(646), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(648), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6584] = 2,
    ACTIONS(678), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(680), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6605] = 2,
    ACTIONS(686), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(688), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6626] = 2,
    ACTIONS(690), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(692), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6647] = 14,
    ACTIONS(716), 1,
      sym_flag,
    ACTIONS(744), 1,
      sym_BALANCE,
    ACTIONS(746), 1,
      sym_OPEN,
    ACTIONS(748), 1,
      sym_CLOSE,
    ACTIONS(750), 1,
      sym_COMMODITY,
    ACTIONS(752), 1,
      sym_PAD,
    ACTIONS(754), 1,
      sym_EVENT,
    ACTIONS(756), 1,
      sym_PRICE,
    ACTIONS(758), 1,
      sym_NOTE,
    ACTIONS(760), 1,
      sym_DOCUMENT,
    ACTIONS(762), 1,
      sym_QUERY,
    ACTIONS(764), 1,
      sym_CUSTOM,
    STATE(317), 1,
      sym_txn,
    ACTIONS(714), 3,
      sym__hash,
      sym_asterisk,
      sym_TXN,
  [6692] = 2,
    ACTIONS(766), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(768), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6713] = 2,
    ACTIONS(590), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(592), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6734] = 2,
    ACTIONS(694), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(696), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6755] = 2,
    ACTIONS(702), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(704), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6776] = 2,
    ACTIONS(770), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(772), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6797] = 2,
    ACTIONS(706), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(708), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6818] = 2,
    ACTIONS(774), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(776), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6839] = 2,
    ACTIONS(778), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(780), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6860] = 2,
    ACTIONS(710), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(712), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6881] = 2,
    ACTIONS(766), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(768), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6902] = 2,
    ACTIONS(782), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(784), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6923] = 2,
    ACTIONS(786), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(788), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6944] = 2,
    ACTIONS(790), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(792), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6965] = 2,
    ACTIONS(774), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(776), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [6986] = 2,
    ACTIONS(778), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(780), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7007] = 2,
    ACTIONS(796), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(794), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7028] = 2,
    ACTIONS(644), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(642), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7049] = 2,
    ACTIONS(800), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(798), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7070] = 2,
    ACTIONS(802), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(804), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7091] = 9,
    ACTIONS(806), 1,
      sym__eol,
    ACTIONS(811), 1,
      sym__lparen,
    ACTIONS(814), 1,
      sym_bool,
    ACTIONS(820), 1,
      sym_number,
    STATE(322), 1,
      sym_amount,
    ACTIONS(808), 2,
      sym_plus,
      sym_minus,
    STATE(269), 2,
      sym_custom_value,
      aux_sym_custom_value_list_repeat1,
    ACTIONS(817), 3,
      sym_date,
      sym_account,
      sym_string,
    STATE(310), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7126] = 2,
    ACTIONS(825), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(823), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7147] = 2,
    ACTIONS(800), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(798), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7168] = 9,
    ACTIONS(362), 1,
      sym__lparen,
    ACTIONS(364), 1,
      sym_bool,
    ACTIONS(368), 1,
      sym_number,
    ACTIONS(827), 1,
      sym__eol,
    STATE(322), 1,
      sym_amount,
    ACTIONS(360), 2,
      sym_plus,
      sym_minus,
    STATE(269), 2,
      sym_custom_value,
      aux_sym_custom_value_list_repeat1,
    ACTIONS(366), 3,
      sym_date,
      sym_account,
      sym_string,
    STATE(310), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7203] = 2,
    ACTIONS(831), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(829), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7224] = 2,
    ACTIONS(700), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(698), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7245] = 2,
    ACTIONS(831), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(829), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7266] = 2,
    ACTIONS(674), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(676), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7287] = 2,
    ACTIONS(835), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(833), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7308] = 2,
    ACTIONS(684), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(682), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7329] = 2,
    ACTIONS(630), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(632), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7350] = 2,
    ACTIONS(786), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(788), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7371] = 2,
    ACTIONS(782), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(784), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7392] = 2,
    ACTIONS(835), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(833), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7413] = 2,
    ACTIONS(666), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(668), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7434] = 2,
    ACTIONS(837), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(839), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7455] = 2,
    ACTIONS(841), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(843), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7476] = 2,
    ACTIONS(802), 3,
      sym__stars,
      sym__sectionend,
      anon_sym_CR,
    ACTIONS(804), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7497] = 2,
    ACTIONS(660), 3,
      sym__stars,
      ts_builtin_sym_end,
      anon_sym_CR,
    ACTIONS(658), 13,
      anon_sym_LF,
      sym__eol,
      sym__colon,
      sym_flag,
      sym_PUSHTAG,
      sym_POPTAG,
      sym_PUSHMETA,
      sym_POPMETA,
      sym_OPTION,
      sym_INCLUDE,
      sym_PLUGIN,
      sym_date,
      anon_sym_SEMI,
  [7518] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(578), 1,
      sym__hash,
    ACTIONS(582), 1,
      sym_currency,
    ACTIONS(584), 1,
      sym_number,
    STATE(398), 1,
      sym_compound_amount,
    STATE(430), 1,
      sym_cost_comp,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    ACTIONS(580), 3,
      sym_asterisk,
      sym_date,
      sym_string,
    STATE(316), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7552] = 11,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(845), 1,
      sym__eol,
    ACTIONS(849), 1,
      sym_asterisk,
    ACTIONS(851), 1,
      sym_account,
    ACTIONS(855), 1,
      sym_key,
    STATE(373), 1,
      aux_sym_tags_links_repeat1,
    STATE(534), 1,
      sym_key_value,
    STATE(605), 1,
      sym_optflag,
    ACTIONS(847), 2,
      sym__hash,
      sym_flag,
    ACTIONS(853), 2,
      sym_tag,
      sym_link,
    STATE(533), 2,
      sym_tags_links,
      sym_comment,
  [7589] = 11,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(849), 1,
      sym_asterisk,
    ACTIONS(855), 1,
      sym_key,
    ACTIONS(857), 1,
      sym__eol,
    ACTIONS(859), 1,
      sym_account,
    STATE(373), 1,
      aux_sym_tags_links_repeat1,
    STATE(484), 1,
      sym_optflag,
    STATE(494), 1,
      sym_key_value,
    ACTIONS(847), 2,
      sym__hash,
      sym_flag,
    ACTIONS(853), 2,
      sym_tag,
      sym_link,
    STATE(500), 2,
      sym_tags_links,
      sym_comment,
  [7626] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(861), 1,
      sym__eol,
    STATE(403), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(543), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7658] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(863), 1,
      sym__eol,
    STATE(425), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(479), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7690] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(865), 1,
      sym__eol,
    STATE(390), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(581), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7722] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(867), 1,
      sym__eol,
    STATE(391), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(577), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7754] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(869), 1,
      sym__eol,
    STATE(392), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(573), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7786] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(871), 1,
      sym__eol,
    STATE(393), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(569), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7818] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(873), 1,
      sym__eol,
    STATE(410), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(537), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7850] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(875), 1,
      sym__eol,
    STATE(400), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(561), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7882] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(877), 1,
      sym__eol,
    STATE(428), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(462), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7914] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(879), 1,
      sym__eol,
    STATE(397), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(468), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7946] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(881), 1,
      sym__eol,
    STATE(401), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(559), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [7978] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(883), 1,
      sym__eol,
    STATE(414), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(520), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8010] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(885), 1,
      sym__eol,
    STATE(417), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(506), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8042] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(887), 1,
      sym__eol,
    STATE(402), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(555), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8074] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(889), 1,
      sym__eol,
    STATE(412), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(453), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8106] = 9,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(348), 1,
      sym_number,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(891), 1,
      sym__eol,
    STATE(389), 1,
      sym_price_annotation,
    STATE(442), 1,
      sym_incomplete_amount,
    STATE(574), 1,
      sym_comment,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(359), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8138] = 2,
    ACTIONS(895), 3,
      sym_bool,
      sym_currency,
      sym_number,
    ACTIONS(893), 9,
      sym__eol,
      sym_asterisk,
      sym_slash,
      sym_plus,
      sym_minus,
      sym__lparen,
      sym_date,
      sym_account,
      sym_string,
  [8155] = 2,
    ACTIONS(895), 1,
      sym_rcurl,
    ACTIONS(893), 11,
      sym__eol,
      sym_rcurlrcurl,
      sym__comma,
      sym__tilde,
      sym__hash,
      sym_asterisk,
      sym_slash,
      sym_plus,
      sym_minus,
      sym__rparen,
      sym_currency,
  [8172] = 2,
    ACTIONS(899), 3,
      sym_bool,
      sym_currency,
      sym_number,
    ACTIONS(897), 9,
      sym__eol,
      sym_asterisk,
      sym_slash,
      sym_plus,
      sym_minus,
      sym__lparen,
      sym_date,
      sym_account,
      sym_string,
  [8189] = 5,
    ACTIONS(909), 1,
      sym_currency,
    ACTIONS(903), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(905), 2,
      sym_plus,
      sym_minus,
    ACTIONS(907), 2,
      sym_bool,
      sym_number,
    ACTIONS(901), 5,
      sym__eol,
      sym__lparen,
      sym_date,
      sym_account,
      sym_string,
  [8212] = 2,
    ACTIONS(899), 1,
      sym_rcurl,
    ACTIONS(897), 11,
      sym__eol,
      sym_rcurlrcurl,
      sym__comma,
      sym__tilde,
      sym__hash,
      sym_asterisk,
      sym_slash,
      sym_plus,
      sym_minus,
      sym__rparen,
      sym_currency,
  [8229] = 3,
    ACTIONS(895), 1,
      sym_rcurl,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(893), 9,
      sym__eol,
      sym_rcurlrcurl,
      sym__comma,
      sym__tilde,
      sym__hash,
      sym_plus,
      sym_minus,
      sym__rparen,
      sym_currency,
  [8248] = 2,
    ACTIONS(915), 1,
      sym_rcurl,
    ACTIONS(913), 11,
      sym__eol,
      sym_rcurlrcurl,
      sym__comma,
      sym__tilde,
      sym__hash,
      sym_asterisk,
      sym_slash,
      sym_plus,
      sym_minus,
      sym__rparen,
      sym_currency,
  [8265] = 2,
    ACTIONS(915), 3,
      sym_bool,
      sym_currency,
      sym_number,
    ACTIONS(913), 9,
      sym__eol,
      sym_asterisk,
      sym_slash,
      sym_plus,
      sym_minus,
      sym__lparen,
      sym_date,
      sym_account,
      sym_string,
  [8282] = 3,
    ACTIONS(903), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(895), 3,
      sym_bool,
      sym_currency,
      sym_number,
    ACTIONS(893), 7,
      sym__eol,
      sym_plus,
      sym_minus,
      sym__lparen,
      sym_date,
      sym_account,
      sym_string,
  [8301] = 6,
    ACTIONS(919), 1,
      sym_rcurl,
    ACTIONS(921), 1,
      sym__hash,
    ACTIONS(925), 1,
      sym_currency,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(917), 2,
      sym_rcurlrcurl,
      sym__comma,
    ACTIONS(923), 2,
      sym_plus,
      sym_minus,
  [8323] = 8,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(927), 1,
      sym__eol,
    ACTIONS(929), 1,
      sym_string,
    STATE(344), 1,
      sym_txn_strings,
    STATE(373), 1,
      aux_sym_tags_links_repeat1,
    STATE(427), 1,
      sym_tags_links,
    STATE(485), 1,
      sym_comment,
    ACTIONS(853), 2,
      sym_tag,
      sym_link,
  [8349] = 5,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(931), 1,
      sym_number,
    STATE(470), 1,
      sym_amount,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(367), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8369] = 5,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(931), 1,
      sym_number,
    STATE(515), 1,
      sym_amount,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(367), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8389] = 5,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(933), 1,
      sym_currency,
    ACTIONS(935), 1,
      sym_number,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(363), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8409] = 5,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(937), 1,
      sym_number,
    STATE(418), 1,
      sym_amount_tolerance,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(346), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8429] = 2,
    ACTIONS(907), 2,
      sym_bool,
      sym_number,
    ACTIONS(901), 7,
      sym__eol,
      sym_plus,
      sym_minus,
      sym__lparen,
      sym_date,
      sym_account,
      sym_string,
  [8443] = 5,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(939), 1,
      sym_currency,
    ACTIONS(941), 1,
      sym_number,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(371), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8463] = 2,
    ACTIONS(945), 2,
      sym_bool,
      sym_number,
    ACTIONS(943), 7,
      sym__eol,
      sym_plus,
      sym_minus,
      sym__lparen,
      sym_date,
      sym_account,
      sym_string,
  [8477] = 5,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(937), 1,
      sym_number,
    STATE(405), 1,
      sym_amount_tolerance,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(346), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8497] = 8,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(929), 1,
      sym_string,
    ACTIONS(947), 1,
      sym__eol,
    STATE(345), 1,
      sym_txn_strings,
    STATE(373), 1,
      aux_sym_tags_links_repeat1,
    STATE(419), 1,
      sym_tags_links,
    STATE(504), 1,
      sym_comment,
    ACTIONS(853), 2,
      sym_tag,
      sym_link,
  [8523] = 7,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(949), 1,
      sym__eol,
    ACTIONS(951), 1,
      sym_currency,
    ACTIONS(953), 1,
      sym_string,
    STATE(424), 1,
      sym_opt_booking,
    STATE(475), 1,
      sym_comment,
    STATE(335), 2,
      sym_currency_list,
      aux_sym_open_repeat1,
  [8546] = 7,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(951), 1,
      sym_currency,
    ACTIONS(953), 1,
      sym_string,
    ACTIONS(955), 1,
      sym__eol,
    STATE(411), 1,
      sym_opt_booking,
    STATE(529), 1,
      sym_comment,
    STATE(351), 2,
      sym_currency_list,
      aux_sym_open_repeat1,
  [8569] = 4,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(957), 1,
      sym_number,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(375), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8586] = 8,
    ACTIONS(344), 1,
      sym_lcurllcurl,
    ACTIONS(346), 1,
      sym_lcurl,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(959), 1,
      sym__eol,
    ACTIONS(961), 1,
      sym_atat,
    ACTIONS(963), 1,
      sym_at,
    STATE(376), 1,
      sym_cost_spec,
    STATE(546), 1,
      sym_comment,
  [8611] = 4,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(965), 1,
      sym_number,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(361), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8628] = 8,
    ACTIONS(344), 1,
      sym_lcurllcurl,
    ACTIONS(346), 1,
      sym_lcurl,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(967), 1,
      sym__eol,
    ACTIONS(969), 1,
      sym_atat,
    ACTIONS(971), 1,
      sym_at,
    STATE(380), 1,
      sym_cost_spec,
    STATE(564), 1,
      sym_comment,
  [8653] = 8,
    ACTIONS(344), 1,
      sym_lcurllcurl,
    ACTIONS(346), 1,
      sym_lcurl,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(973), 1,
      sym__eol,
    ACTIONS(975), 1,
      sym_atat,
    ACTIONS(977), 1,
      sym_at,
    STATE(365), 1,
      sym_cost_spec,
    STATE(502), 1,
      sym_comment,
  [8678] = 4,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(979), 1,
      sym_number,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(311), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8695] = 7,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(951), 1,
      sym_currency,
    ACTIONS(953), 1,
      sym_string,
    ACTIONS(981), 1,
      sym__eol,
    STATE(421), 1,
      sym_opt_booking,
    STATE(454), 1,
      sym_comment,
    STATE(351), 2,
      sym_currency_list,
      aux_sym_open_repeat1,
  [8718] = 4,
    ACTIONS(362), 1,
      sym__lparen,
    ACTIONS(983), 1,
      sym_number,
    ACTIONS(360), 2,
      sym_plus,
      sym_minus,
    STATE(309), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8735] = 4,
    ACTIONS(362), 1,
      sym__lparen,
    ACTIONS(985), 1,
      sym_number,
    ACTIONS(360), 2,
      sym_plus,
      sym_minus,
    STATE(307), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8752] = 4,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(987), 1,
      sym_number,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(312), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8769] = 7,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(951), 1,
      sym_currency,
    ACTIONS(953), 1,
      sym_string,
    ACTIONS(989), 1,
      sym__eol,
    STATE(387), 1,
      sym_opt_booking,
    STATE(509), 1,
      sym_comment,
    STATE(328), 2,
      sym_currency_list,
      aux_sym_open_repeat1,
  [8792] = 4,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(991), 1,
      sym_number,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(308), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8809] = 4,
    ACTIONS(362), 1,
      sym__lparen,
    ACTIONS(993), 1,
      sym_number,
    ACTIONS(360), 2,
      sym_plus,
      sym_minus,
    STATE(315), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8826] = 4,
    ACTIONS(322), 1,
      sym__lparen,
    ACTIONS(995), 1,
      sym_number,
    ACTIONS(320), 2,
      sym_plus,
      sym_minus,
    STATE(368), 4,
      sym__number_expr,
      sym__paren__number_expr,
      sym_unary_number_expr,
      sym_binary_number_expr,
  [8843] = 8,
    ACTIONS(344), 1,
      sym_lcurllcurl,
    ACTIONS(346), 1,
      sym_lcurl,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(997), 1,
      sym__eol,
    ACTIONS(999), 1,
      sym_atat,
    ACTIONS(1001), 1,
      sym_at,
    STATE(377), 1,
      sym_cost_spec,
    STATE(550), 1,
      sym_comment,
  [8868] = 6,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1003), 1,
      sym__eol,
    STATE(373), 1,
      aux_sym_tags_links_repeat1,
    STATE(394), 1,
      sym_tags_links,
    STATE(461), 1,
      sym_comment,
    ACTIONS(853), 2,
      sym_tag,
      sym_link,
  [8888] = 6,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1005), 1,
      sym__eol,
    STATE(373), 1,
      aux_sym_tags_links_repeat1,
    STATE(415), 1,
      sym_tags_links,
    STATE(522), 1,
      sym_comment,
    ACTIONS(853), 2,
      sym_tag,
      sym_link,
  [8908] = 4,
    ACTIONS(1007), 1,
      sym__tilde,
    ACTIONS(1009), 1,
      sym_currency,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(923), 2,
      sym_plus,
      sym_minus,
  [8923] = 6,
    ACTIONS(29), 1,
      sym__stars,
    ACTIONS(1011), 1,
      sym__sectionend,
    STATE(4), 1,
      sym_headline,
    STATE(358), 1,
      aux_sym_section_repeat2,
    STATE(443), 1,
      sym_section,
    STATE(590), 1,
      sym__org_stars,
  [8942] = 3,
    ACTIONS(1015), 1,
      sym__comma,
    STATE(349), 1,
      aux_sym_currency_list_repeat1,
    ACTIONS(1013), 4,
      sym__eol,
      sym_currency,
      sym_string,
      anon_sym_SEMI,
  [8955] = 3,
    ACTIONS(1015), 1,
      sym__comma,
    STATE(353), 1,
      aux_sym_currency_list_repeat1,
    ACTIONS(1017), 4,
      sym__eol,
      sym_currency,
      sym_string,
      anon_sym_SEMI,
  [8968] = 4,
    ACTIONS(1019), 1,
      sym__eol,
    ACTIONS(1021), 1,
      sym_currency,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(923), 2,
      sym_plus,
      sym_minus,
  [8983] = 3,
    ACTIONS(1025), 1,
      sym_currency,
    STATE(351), 2,
      sym_currency_list,
      aux_sym_open_repeat1,
    ACTIONS(1023), 3,
      sym__eol,
      sym_string,
      anon_sym_SEMI,
  [8996] = 5,
    ACTIONS(1030), 1,
      aux_sym__any_token1,
    STATE(270), 1,
      sym__nl,
    STATE(416), 1,
      sym_item,
    STATE(434), 1,
      sym__any,
    ACTIONS(1028), 2,
      anon_sym_LF,
      anon_sym_CR,
  [9013] = 3,
    ACTIONS(1034), 1,
      sym__comma,
    STATE(353), 1,
      aux_sym_currency_list_repeat1,
    ACTIONS(1032), 4,
      sym__eol,
      sym_currency,
      sym_string,
      anon_sym_SEMI,
  [9026] = 6,
    ACTIONS(29), 1,
      sym__stars,
    ACTIONS(1037), 1,
      sym__sectionend,
    STATE(4), 1,
      sym_headline,
    STATE(358), 1,
      aux_sym_section_repeat2,
    STATE(443), 1,
      sym_section,
    STATE(590), 1,
      sym__org_stars,
  [9045] = 2,
    ACTIONS(1041), 2,
      sym_at,
      sym_lcurl,
    ACTIONS(1039), 4,
      sym__eol,
      sym_atat,
      sym_lcurllcurl,
      anon_sym_SEMI,
  [9056] = 6,
    ACTIONS(29), 1,
      sym__stars,
    ACTIONS(1043), 1,
      sym__sectionend,
    STATE(4), 1,
      sym_headline,
    STATE(358), 1,
      aux_sym_section_repeat2,
    STATE(443), 1,
      sym_section,
    STATE(590), 1,
      sym__org_stars,
  [9075] = 6,
    ACTIONS(29), 1,
      sym__stars,
    ACTIONS(1045), 1,
      sym__sectionend,
    STATE(4), 1,
      sym_headline,
    STATE(358), 1,
      aux_sym_section_repeat2,
    STATE(443), 1,
      sym_section,
    STATE(590), 1,
      sym__org_stars,
  [9094] = 6,
    ACTIONS(1047), 1,
      sym__stars,
    ACTIONS(1050), 1,
      sym__sectionend,
    STATE(4), 1,
      sym_headline,
    STATE(358), 1,
      aux_sym_section_repeat2,
    STATE(443), 1,
      sym_section,
    STATE(590), 1,
      sym__org_stars,
  [9113] = 3,
    ACTIONS(1052), 1,
      sym_currency,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(923), 2,
      sym_plus,
      sym_minus,
  [9125] = 5,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1054), 1,
      sym__eol,
    ACTIONS(1056), 1,
      sym_atat,
    ACTIONS(1058), 1,
      sym_at,
    STATE(548), 1,
      sym_comment,
  [9141] = 3,
    ACTIONS(1060), 1,
      sym__rparen,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(923), 2,
      sym_plus,
      sym_minus,
  [9153] = 5,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1062), 1,
      sym__eol,
    ACTIONS(1064), 1,
      sym_atat,
    ACTIONS(1066), 1,
      sym_at,
    STATE(547), 1,
      sym_comment,
  [9169] = 3,
    ACTIONS(1068), 1,
      sym_currency,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(923), 2,
      sym_plus,
      sym_minus,
  [9181] = 1,
    ACTIONS(1070), 5,
      sym__eol,
      sym_string,
      sym_tag,
      sym_link,
      anon_sym_SEMI,
  [9189] = 5,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1072), 1,
      sym__eol,
    ACTIONS(1074), 1,
      sym_atat,
    ACTIONS(1076), 1,
      sym_at,
    STATE(466), 1,
      sym_comment,
  [9205] = 3,
    STATE(366), 1,
      aux_sym_tags_links_repeat1,
    ACTIONS(1078), 2,
      sym__eol,
      anon_sym_SEMI,
    ACTIONS(1080), 2,
      sym_tag,
      sym_link,
  [9217] = 3,
    ACTIONS(1021), 1,
      sym_currency,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(923), 2,
      sym_plus,
      sym_minus,
  [9229] = 3,
    ACTIONS(1083), 1,
      sym__rparen,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(923), 2,
      sym_plus,
      sym_minus,
  [9241] = 4,
    ACTIONS(1085), 1,
      sym__eol,
    STATE(373), 1,
      aux_sym_tags_links_repeat1,
    STATE(474), 1,
      sym_tags_links,
    ACTIONS(853), 2,
      sym_tag,
      sym_link,
  [9255] = 2,
    ACTIONS(1089), 1,
      sym_string,
    ACTIONS(1087), 4,
      sym__eol,
      sym_tag,
      sym_link,
      anon_sym_SEMI,
  [9265] = 3,
    ACTIONS(1091), 1,
      sym_currency,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(923), 2,
      sym_plus,
      sym_minus,
  [9277] = 1,
    ACTIONS(1032), 5,
      sym__eol,
      sym__comma,
      sym_currency,
      sym_string,
      anon_sym_SEMI,
  [9285] = 3,
    STATE(366), 1,
      aux_sym_tags_links_repeat1,
    ACTIONS(1093), 2,
      sym__eol,
      anon_sym_SEMI,
    ACTIONS(1095), 2,
      sym_tag,
      sym_link,
  [9297] = 5,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1097), 1,
      sym__eol,
    ACTIONS(1099), 1,
      sym_atat,
    ACTIONS(1101), 1,
      sym_at,
    STATE(498), 1,
      sym_comment,
  [9313] = 3,
    ACTIONS(1103), 1,
      sym_currency,
    ACTIONS(911), 2,
      sym_asterisk,
      sym_slash,
    ACTIONS(923), 2,
      sym_plus,
      sym_minus,
  [9325] = 5,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1105), 1,
      sym__eol,
    ACTIONS(1107), 1,
      sym_atat,
    ACTIONS(1109), 1,
      sym_at,
    STATE(557), 1,
      sym_comment,
  [9341] = 5,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1111), 1,
      sym__eol,
    ACTIONS(1113), 1,
      sym_atat,
    ACTIONS(1115), 1,
      sym_at,
    STATE(532), 1,
      sym_comment,
  [9357] = 4,
    ACTIONS(1117), 1,
      sym__eol,
    STATE(373), 1,
      aux_sym_tags_links_repeat1,
    STATE(531), 1,
      sym_tags_links,
    ACTIONS(853), 2,
      sym_tag,
      sym_link,
  [9371] = 5,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1119), 1,
      sym__eol,
    ACTIONS(1121), 1,
      sym_atat,
    ACTIONS(1123), 1,
      sym_at,
    STATE(566), 1,
      sym_comment,
  [9387] = 5,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1125), 1,
      sym__eol,
    ACTIONS(1127), 1,
      sym_atat,
    ACTIONS(1129), 1,
      sym_at,
    STATE(575), 1,
      sym_comment,
  [9403] = 4,
    ACTIONS(1131), 1,
      sym_rcurlrcurl,
    ACTIONS(1133), 1,
      sym_rcurl,
    ACTIONS(1135), 1,
      sym__comma,
    STATE(385), 1,
      aux_sym_cost_comp_list_repeat1,
  [9416] = 2,
    ACTIONS(1139), 1,
      sym_at,
    ACTIONS(1137), 3,
      sym__eol,
      sym_atat,
      anon_sym_SEMI,
  [9425] = 1,
    ACTIONS(1141), 4,
      sym__eol,
      sym_tag,
      sym_link,
      anon_sym_SEMI,
  [9432] = 2,
    ACTIONS(1145), 1,
      sym_at,
    ACTIONS(1143), 3,
      sym__eol,
      sym_atat,
      anon_sym_SEMI,
  [9441] = 4,
    ACTIONS(1135), 1,
      sym__comma,
    ACTIONS(1147), 1,
      sym_rcurlrcurl,
    ACTIONS(1149), 1,
      sym_rcurl,
    STATE(386), 1,
      aux_sym_cost_comp_list_repeat1,
  [9454] = 4,
    ACTIONS(1151), 1,
      sym_rcurlrcurl,
    ACTIONS(1153), 1,
      sym_rcurl,
    ACTIONS(1155), 1,
      sym__comma,
    STATE(386), 1,
      aux_sym_cost_comp_list_repeat1,
  [9467] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1158), 1,
      sym__eol,
    STATE(527), 1,
      sym_comment,
  [9477] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1160), 1,
      sym__eol,
    STATE(448), 1,
      sym_comment,
  [9487] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1162), 1,
      sym__eol,
    STATE(544), 1,
      sym_comment,
  [9497] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1164), 1,
      sym__eol,
    STATE(583), 1,
      sym_comment,
  [9507] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1166), 1,
      sym__eol,
    STATE(582), 1,
      sym_comment,
  [9517] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1168), 1,
      sym__eol,
    STATE(579), 1,
      sym_comment,
  [9527] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1170), 1,
      sym__eol,
    STATE(578), 1,
      sym_comment,
  [9537] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1172), 1,
      sym__eol,
    STATE(517), 1,
      sym_comment,
  [9547] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1174), 1,
      sym__eol,
    STATE(459), 1,
      sym_comment,
  [9557] = 2,
    ACTIONS(1178), 1,
      sym_rcurl,
    ACTIONS(1176), 2,
      sym_rcurlrcurl,
      sym__comma,
  [9565] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1180), 1,
      sym__eol,
    STATE(455), 1,
      sym_comment,
  [9575] = 2,
    ACTIONS(1184), 1,
      sym_rcurl,
    ACTIONS(1182), 2,
      sym_rcurlrcurl,
      sym__comma,
  [9583] = 2,
    ACTIONS(1188), 1,
      sym_rcurl,
    ACTIONS(1186), 2,
      sym_rcurlrcurl,
      sym__comma,
  [9591] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1190), 1,
      sym__eol,
    STATE(571), 1,
      sym_comment,
  [9601] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1192), 1,
      sym__eol,
    STATE(570), 1,
      sym_comment,
  [9611] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1194), 1,
      sym__eol,
    STATE(567), 1,
      sym_comment,
  [9621] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1196), 1,
      sym__eol,
    STATE(553), 1,
      sym_comment,
  [9631] = 2,
    ACTIONS(1200), 1,
      sym_rcurl,
    ACTIONS(1198), 2,
      sym_rcurlrcurl,
      sym__comma,
  [9639] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1202), 1,
      sym__eol,
    STATE(499), 1,
      sym_comment,
  [9649] = 1,
    ACTIONS(1204), 3,
      sym__eol,
      sym_tag,
      sym_link,
  [9655] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1206), 1,
      sym__eol,
    STATE(473), 1,
      sym_comment,
  [9665] = 2,
    ACTIONS(1210), 1,
      sym_rcurl,
    ACTIONS(1208), 2,
      sym_rcurlrcurl,
      sym__comma,
  [9673] = 2,
    ACTIONS(1214), 1,
      sym_rcurl,
    ACTIONS(1212), 2,
      sym_rcurlrcurl,
      sym__comma,
  [9681] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1216), 1,
      sym__eol,
    STATE(483), 1,
      sym_comment,
  [9691] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1218), 1,
      sym__eol,
    STATE(536), 1,
      sym_comment,
  [9701] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1220), 1,
      sym__eol,
    STATE(530), 1,
      sym_comment,
  [9711] = 3,
    ACTIONS(855), 1,
      sym_key,
    ACTIONS(1222), 1,
      sym__eol,
    STATE(534), 1,
      sym_key_value,
  [9721] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1224), 1,
      sym__eol,
    STATE(478), 1,
      sym_comment,
  [9731] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1226), 1,
      sym__eol,
    STATE(535), 1,
      sym_comment,
  [9741] = 3,
    ACTIONS(1228), 1,
      anon_sym_LF,
    ACTIONS(1230), 1,
      anon_sym_CR,
    STATE(265), 1,
      sym__nl,
  [9751] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1232), 1,
      sym__eol,
    STATE(476), 1,
      sym_comment,
  [9761] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1234), 1,
      sym__eol,
    STATE(525), 1,
      sym_comment,
  [9771] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1236), 1,
      sym__eol,
    STATE(523), 1,
      sym_comment,
  [9781] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1238), 1,
      sym__eol,
    STATE(472), 1,
      sym_comment,
  [9791] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1240), 1,
      sym__eol,
    STATE(508), 1,
      sym_comment,
  [9801] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1242), 1,
      sym__eol,
    STATE(512), 1,
      sym_comment,
  [9811] = 3,
    ACTIONS(855), 1,
      sym_key,
    ACTIONS(1244), 1,
      sym__eol,
    STATE(494), 1,
      sym_key_value,
  [9821] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1246), 1,
      sym__eol,
    STATE(450), 1,
      sym_comment,
  [9831] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1248), 1,
      sym__eol,
    STATE(457), 1,
      sym_comment,
  [9841] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1250), 1,
      sym__eol,
    STATE(511), 1,
      sym_comment,
  [9851] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1252), 1,
      sym__eol,
    STATE(447), 1,
      sym_comment,
  [9861] = 3,
    ACTIONS(350), 1,
      anon_sym_SEMI,
    ACTIONS(1254), 1,
      sym__eol,
    STATE(452), 1,
      sym_comment,
  [9871] = 2,
    ACTIONS(1258), 1,
      sym_rcurl,
    ACTIONS(1256), 2,
      sym_rcurlrcurl,
      sym__comma,
  [9879] = 2,
    ACTIONS(1153), 1,
      sym_rcurl,
    ACTIONS(1151), 2,
      sym_rcurlrcurl,
      sym__comma,
  [9887] = 2,
    ACTIONS(855), 1,
      sym_key,
    STATE(513), 1,
      sym_key_value,
  [9894] = 1,
    ACTIONS(770), 2,
      sym__stars,
      sym__sectionend,
  [9899] = 1,
    ACTIONS(1260), 2,
      sym__eol,
      anon_sym_SEMI,
  [9904] = 2,
    ACTIONS(1262), 1,
      anon_sym_LF,
    ACTIONS(1264), 1,
      anon_sym_CR,
  [9911] = 2,
    ACTIONS(1266), 1,
      sym__eol,
    ACTIONS(1268), 1,
      sym_string,
  [9918] = 1,
    ACTIONS(1270), 2,
      sym__eol,
      anon_sym_SEMI,
  [9923] = 1,
    ACTIONS(837), 2,
      sym__stars,
      sym__sectionend,
  [9928] = 1,
    ACTIONS(841), 2,
      sym__stars,
      sym__sectionend,
  [9933] = 2,
    ACTIONS(1272), 1,
      sym_string,
    STATE(369), 1,
      sym_filename,
  [9940] = 2,
    ACTIONS(855), 1,
      sym_key,
    STATE(491), 1,
      sym_key_value,
  [9947] = 1,
    ACTIONS(790), 2,
      sym__stars,
      sym__sectionend,
  [9952] = 1,
    ACTIONS(1274), 2,
      sym__eol,
      anon_sym_SEMI,
  [9957] = 1,
    ACTIONS(1276), 2,
      sym__stars,
      sym__sectionend,
  [9962] = 2,
    ACTIONS(1278), 1,
      sym__eol,
    ACTIONS(1280), 1,
      sym_string,
  [9969] = 2,
    ACTIONS(1272), 1,
      sym_string,
    STATE(378), 1,
      sym_filename,
  [9976] = 1,
    ACTIONS(1282), 2,
      sym__eol,
      anon_sym_SEMI,
  [9981] = 1,
    ACTIONS(1284), 1,
      sym__eol,
  [9985] = 1,
    ACTIONS(1286), 1,
      sym__eol,
  [9989] = 1,
    ACTIONS(1288), 1,
      sym_currency,
  [9993] = 1,
    ACTIONS(1290), 1,
      sym__eol,
  [9997] = 1,
    ACTIONS(1292), 1,
      sym_tag,
  [10001] = 1,
    ACTIONS(1294), 1,
      sym__eol,
  [10005] = 1,
    ACTIONS(1296), 1,
      sym__eol,
  [10009] = 1,
    ACTIONS(1298), 1,
      sym__eol,
  [10013] = 1,
    ACTIONS(1300), 1,
      sym__eol,
  [10017] = 1,
    ACTIONS(1302), 1,
      sym_string,
  [10021] = 1,
    ACTIONS(1304), 1,
      sym__eol,
  [10025] = 1,
    ACTIONS(1306), 1,
      sym_string,
  [10029] = 1,
    ACTIONS(1308), 1,
      sym__eol,
  [10033] = 1,
    ACTIONS(1310), 1,
      sym__eol,
  [10037] = 1,
    ACTIONS(1312), 1,
      sym__eol,
  [10041] = 1,
    ACTIONS(1314), 1,
      sym__eol,
  [10045] = 1,
    ACTIONS(1316), 1,
      sym_string,
  [10049] = 1,
    ACTIONS(1318), 1,
      sym_account,
  [10053] = 1,
    ACTIONS(1320), 1,
      sym__eol,
  [10057] = 1,
    ACTIONS(1322), 1,
      sym__eol,
  [10061] = 1,
    ACTIONS(1324), 1,
      sym__eol,
  [10065] = 1,
    ACTIONS(1326), 1,
      sym__eol,
  [10069] = 1,
    ACTIONS(1328), 1,
      sym__eol,
  [10073] = 1,
    ACTIONS(1330), 1,
      sym__eol,
  [10077] = 1,
    ACTIONS(1332), 1,
      sym__eol,
  [10081] = 1,
    ACTIONS(1334), 1,
      sym__eol,
  [10085] = 1,
    ACTIONS(1336), 1,
      sym__eol,
  [10089] = 1,
    ACTIONS(1338), 1,
      sym__eol,
  [10093] = 1,
    ACTIONS(1340), 1,
      sym__eol,
  [10097] = 1,
    ACTIONS(1342), 1,
      sym__eol,
  [10101] = 1,
    ACTIONS(1344), 1,
      sym_string,
  [10105] = 1,
    ACTIONS(1346), 1,
      sym__eol,
  [10109] = 1,
    ACTIONS(1348), 1,
      sym__eol,
  [10113] = 1,
    ACTIONS(1350), 1,
      sym__eol,
  [10117] = 1,
    ACTIONS(1352), 1,
      sym_account,
  [10121] = 1,
    ACTIONS(1354), 1,
      sym__eol,
  [10125] = 1,
    ACTIONS(1356), 1,
      sym__eol,
  [10129] = 1,
    ACTIONS(1358), 1,
      sym_account,
  [10133] = 1,
    ACTIONS(1360), 1,
      sym__eol,
  [10137] = 1,
    ACTIONS(1362), 1,
      sym_tag,
  [10141] = 1,
    ACTIONS(1364), 1,
      sym__eol,
  [10145] = 1,
    ACTIONS(1366), 1,
      sym__eol,
  [10149] = 1,
    ACTIONS(1368), 1,
      sym__eol,
  [10153] = 1,
    ACTIONS(1370), 1,
      sym__eol,
  [10157] = 1,
    ACTIONS(1372), 1,
      sym__eol,
  [10161] = 1,
    ACTIONS(1374), 1,
      sym__eol,
  [10165] = 1,
    ACTIONS(1376), 1,
      aux_sym__any_token1,
  [10169] = 1,
    ACTIONS(1378), 1,
      sym__eol,
  [10173] = 1,
    ACTIONS(1380), 1,
      sym__eol,
  [10177] = 1,
    ACTIONS(1382), 1,
      sym__eol,
  [10181] = 1,
    ACTIONS(1384), 1,
      sym__eol,
  [10185] = 1,
    ACTIONS(1386), 1,
      sym__eol,
  [10189] = 1,
    ACTIONS(1388), 1,
      sym__eol,
  [10193] = 1,
    ACTIONS(1390), 1,
      sym__eol,
  [10197] = 1,
    ACTIONS(1392), 1,
      sym_currency,
  [10201] = 1,
    ACTIONS(1394), 1,
      sym__eol,
  [10205] = 1,
    ACTIONS(1396), 1,
      sym__eol,
  [10209] = 1,
    ACTIONS(1398), 1,
      sym__eol,
  [10213] = 1,
    ACTIONS(1400), 1,
      sym__eol,
  [10217] = 1,
    ACTIONS(1402), 1,
      sym__eol,
  [10221] = 1,
    ACTIONS(1404), 1,
      sym__colon,
  [10225] = 1,
    ACTIONS(1406), 1,
      sym__eol,
  [10229] = 1,
    ACTIONS(1408), 1,
      sym__eol,
  [10233] = 1,
    ACTIONS(1410), 1,
      sym_key,
  [10237] = 1,
    ACTIONS(1412), 1,
      sym__eol,
  [10241] = 1,
    ACTIONS(1414), 1,
      sym__eol,
  [10245] = 1,
    ACTIONS(1416), 1,
      sym__eol,
  [10249] = 1,
    ACTIONS(1418), 1,
      sym__eol,
  [10253] = 1,
    ACTIONS(1420), 1,
      sym__eol,
  [10257] = 1,
    ACTIONS(1422), 1,
      sym__eol,
  [10261] = 1,
    ACTIONS(1424), 1,
      sym__eol,
  [10265] = 1,
    ACTIONS(1426), 1,
      sym__eol,
  [10269] = 1,
    ACTIONS(1428), 1,
      sym__eol,
  [10273] = 1,
    ACTIONS(1430), 1,
      sym__eol,
  [10277] = 1,
    ACTIONS(1432), 1,
      sym__colon,
  [10281] = 1,
    ACTIONS(1434), 1,
      sym__eol,
  [10285] = 1,
    ACTIONS(1436), 1,
      sym__eol,
  [10289] = 1,
    ACTIONS(1438), 1,
      sym_string,
  [10293] = 1,
    ACTIONS(1440), 1,
      sym__eol,
  [10297] = 1,
    ACTIONS(1442), 1,
      sym__eol,
  [10301] = 1,
    ACTIONS(1444), 1,
      sym__eol,
  [10305] = 1,
    ACTIONS(1446), 1,
      sym_string,
  [10309] = 1,
    ACTIONS(1448), 1,
      sym__eol,
  [10313] = 1,
    ACTIONS(1450), 1,
      sym__eol,
  [10317] = 1,
    ACTIONS(1452), 1,
      sym__eol,
  [10321] = 1,
    ACTIONS(1454), 1,
      sym__eol,
  [10325] = 1,
    ACTIONS(1456), 1,
      sym__eol,
  [10329] = 1,
    ACTIONS(1458), 1,
      sym__eol,
  [10333] = 1,
    ACTIONS(1460), 1,
      sym__eol,
  [10337] = 1,
    ACTIONS(1462), 1,
      sym__eol,
  [10341] = 1,
    ACTIONS(1464), 1,
      sym__eol,
  [10345] = 1,
    ACTIONS(1466), 1,
      sym_account,
  [10349] = 1,
    ACTIONS(1468), 1,
      sym_account,
  [10353] = 1,
    ACTIONS(1470), 1,
      sym__eol,
  [10357] = 1,
    ACTIONS(1472), 1,
      sym_string,
  [10361] = 1,
    ACTIONS(1474), 1,
      sym_string,
  [10365] = 1,
    ACTIONS(1476), 1,
      sym__eol,
  [10369] = 1,
    ACTIONS(1478), 1,
      sym__eol,
  [10373] = 1,
    ACTIONS(1480), 1,
      sym__eol,
  [10377] = 1,
    ACTIONS(1482), 1,
      sym__eol,
  [10381] = 1,
    ACTIONS(1484), 1,
      sym__eol,
  [10385] = 1,
    ACTIONS(1486), 1,
      sym__eol,
  [10389] = 1,
    ACTIONS(1488), 1,
      sym__eol,
  [10393] = 1,
    ACTIONS(1490), 1,
      sym__eol,
  [10397] = 1,
    ACTIONS(1492), 1,
      sym__eol,
  [10401] = 1,
    ACTIONS(1494), 1,
      sym__eol,
  [10405] = 1,
    ACTIONS(1496), 1,
      sym__eol,
  [10409] = 1,
    ACTIONS(1498), 1,
      sym_account,
  [10413] = 1,
    ACTIONS(1500), 1,
      sym__eol,
  [10417] = 1,
    ACTIONS(1502), 1,
      sym_rcurl,
  [10421] = 1,
    ACTIONS(1504), 1,
      sym__eol,
  [10425] = 1,
    ACTIONS(1506), 1,
      sym_account,
  [10429] = 1,
    ACTIONS(1508), 1,
      sym__eol,
  [10433] = 1,
    ACTIONS(1510), 1,
      sym_account,
  [10437] = 1,
    ACTIONS(1512), 1,
      sym__eol,
  [10441] = 1,
    ACTIONS(1502), 1,
      sym_rcurlrcurl,
  [10445] = 1,
    ACTIONS(1514), 1,
      aux_sym__any_token1,
  [10449] = 1,
    ACTIONS(1516), 1,
      sym__eol,
  [10453] = 1,
    ACTIONS(1518), 1,
      sym_currency,
  [10457] = 1,
    ACTIONS(1520), 1,
      sym__eol,
  [10461] = 1,
    ACTIONS(1522), 1,
      sym__eol,
  [10465] = 1,
    ACTIONS(1524), 1,
      ts_builtin_sym_end,
  [10469] = 1,
    ACTIONS(1526), 1,
      sym__eol,
  [10473] = 1,
    ACTIONS(1528), 1,
      sym__eol,
  [10477] = 1,
    ACTIONS(1530), 1,
      sym__eol,
  [10481] = 1,
    ACTIONS(1532), 1,
      sym_string,
  [10485] = 1,
    ACTIONS(1534), 1,
      sym__eol,
  [10489] = 1,
    ACTIONS(1536), 1,
      sym__eol,
  [10493] = 1,
    ACTIONS(1538), 1,
      sym__eol,
  [10497] = 1,
    ACTIONS(1540), 1,
      sym_account,
  [10501] = 1,
    ACTIONS(1542), 1,
      sym__eol,
  [10505] = 1,
    ACTIONS(1544), 1,
      sym__eol,
  [10509] = 1,
    ACTIONS(1546), 1,
      sym__eol,
  [10513] = 1,
    ACTIONS(1548), 1,
      sym_string,
  [10517] = 1,
    ACTIONS(1550), 1,
      sym__eol,
  [10521] = 1,
    ACTIONS(1552), 1,
      sym__eol,
  [10525] = 1,
    ACTIONS(1554), 1,
      sym__eol,
  [10529] = 1,
    ACTIONS(1556), 1,
      aux_sym__any_token1,
  [10533] = 1,
    ACTIONS(1558), 1,
      sym_tag,
  [10537] = 1,
    ACTIONS(1560), 1,
      sym_tag,
  [10541] = 1,
    ACTIONS(1562), 1,
      sym__eol,
  [10545] = 1,
    ACTIONS(1564), 1,
      sym_string,
  [10549] = 1,
    ACTIONS(1566), 1,
      sym_string,
  [10553] = 1,
    ACTIONS(1568), 1,
      aux_sym_headline_token1,
  [10557] = 1,
    ACTIONS(1570), 1,
      sym__colon,
  [10561] = 1,
    ACTIONS(1572), 1,
      sym_string,
  [10565] = 1,
    ACTIONS(1574), 1,
      sym_account,
  [10569] = 1,
    ACTIONS(1576), 1,
      sym_account,
  [10573] = 1,
    ACTIONS(1578), 1,
      sym_currency,
  [10577] = 1,
    ACTIONS(1580), 1,
      sym_string,
  [10581] = 1,
    ACTIONS(1582), 1,
      sym__eol,
  [10585] = 1,
    ACTIONS(1584), 1,
      sym_account,
  [10589] = 1,
    ACTIONS(1586), 1,
      sym_string,
  [10593] = 1,
    ACTIONS(1588), 1,
      aux_sym_headline_token1,
  [10597] = 1,
    ACTIONS(1590), 1,
      sym_string,
  [10601] = 1,
    ACTIONS(1592), 1,
      aux_sym__org_stars_token1,
  [10605] = 1,
    ACTIONS(1594), 1,
      sym_string,
  [10609] = 1,
    ACTIONS(1596), 1,
      sym__eol,
  [10613] = 1,
    ACTIONS(1598), 1,
      sym_account,
  [10617] = 1,
    ACTIONS(1600), 1,
      sym_key,
  [10621] = 1,
    ACTIONS(1602), 1,
      sym_string,
  [10625] = 1,
    ACTIONS(1604), 1,
      sym_account,
  [10629] = 1,
    ACTIONS(1606), 1,
      sym_account,
  [10633] = 1,
    ACTIONS(1608), 1,
      sym_string,
  [10637] = 1,
    ACTIONS(1610), 1,
      sym_currency,
  [10641] = 1,
    ACTIONS(1612), 1,
      sym_account,
  [10645] = 1,
    ACTIONS(1614), 1,
      sym_account,
  [10649] = 1,
    ACTIONS(1616), 1,
      sym_string,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 87,
  [SMALL_STATE(4)] = 174,
  [SMALL_STATE(5)] = 261,
  [SMALL_STATE(6)] = 348,
  [SMALL_STATE(7)] = 430,
  [SMALL_STATE(8)] = 512,
  [SMALL_STATE(9)] = 585,
  [SMALL_STATE(10)] = 617,
  [SMALL_STATE(11)] = 649,
  [SMALL_STATE(12)] = 681,
  [SMALL_STATE(13)] = 713,
  [SMALL_STATE(14)] = 745,
  [SMALL_STATE(15)] = 777,
  [SMALL_STATE(16)] = 809,
  [SMALL_STATE(17)] = 841,
  [SMALL_STATE(18)] = 873,
  [SMALL_STATE(19)] = 905,
  [SMALL_STATE(20)] = 937,
  [SMALL_STATE(21)] = 969,
  [SMALL_STATE(22)] = 1001,
  [SMALL_STATE(23)] = 1033,
  [SMALL_STATE(24)] = 1065,
  [SMALL_STATE(25)] = 1097,
  [SMALL_STATE(26)] = 1128,
  [SMALL_STATE(27)] = 1159,
  [SMALL_STATE(28)] = 1190,
  [SMALL_STATE(29)] = 1221,
  [SMALL_STATE(30)] = 1252,
  [SMALL_STATE(31)] = 1283,
  [SMALL_STATE(32)] = 1314,
  [SMALL_STATE(33)] = 1345,
  [SMALL_STATE(34)] = 1376,
  [SMALL_STATE(35)] = 1407,
  [SMALL_STATE(36)] = 1438,
  [SMALL_STATE(37)] = 1467,
  [SMALL_STATE(38)] = 1498,
  [SMALL_STATE(39)] = 1527,
  [SMALL_STATE(40)] = 1558,
  [SMALL_STATE(41)] = 1589,
  [SMALL_STATE(42)] = 1620,
  [SMALL_STATE(43)] = 1651,
  [SMALL_STATE(44)] = 1682,
  [SMALL_STATE(45)] = 1713,
  [SMALL_STATE(46)] = 1744,
  [SMALL_STATE(47)] = 1775,
  [SMALL_STATE(48)] = 1806,
  [SMALL_STATE(49)] = 1835,
  [SMALL_STATE(50)] = 1866,
  [SMALL_STATE(51)] = 1897,
  [SMALL_STATE(52)] = 1928,
  [SMALL_STATE(53)] = 1959,
  [SMALL_STATE(54)] = 1990,
  [SMALL_STATE(55)] = 2021,
  [SMALL_STATE(56)] = 2052,
  [SMALL_STATE(57)] = 2083,
  [SMALL_STATE(58)] = 2114,
  [SMALL_STATE(59)] = 2143,
  [SMALL_STATE(60)] = 2174,
  [SMALL_STATE(61)] = 2205,
  [SMALL_STATE(62)] = 2236,
  [SMALL_STATE(63)] = 2267,
  [SMALL_STATE(64)] = 2298,
  [SMALL_STATE(65)] = 2329,
  [SMALL_STATE(66)] = 2360,
  [SMALL_STATE(67)] = 2391,
  [SMALL_STATE(68)] = 2422,
  [SMALL_STATE(69)] = 2453,
  [SMALL_STATE(70)] = 2484,
  [SMALL_STATE(71)] = 2515,
  [SMALL_STATE(72)] = 2546,
  [SMALL_STATE(73)] = 2577,
  [SMALL_STATE(74)] = 2608,
  [SMALL_STATE(75)] = 2639,
  [SMALL_STATE(76)] = 2670,
  [SMALL_STATE(77)] = 2701,
  [SMALL_STATE(78)] = 2729,
  [SMALL_STATE(79)] = 2757,
  [SMALL_STATE(80)] = 2785,
  [SMALL_STATE(81)] = 2813,
  [SMALL_STATE(82)] = 2848,
  [SMALL_STATE(83)] = 2870,
  [SMALL_STATE(84)] = 2892,
  [SMALL_STATE(85)] = 2936,
  [SMALL_STATE(86)] = 2980,
  [SMALL_STATE(87)] = 3018,
  [SMALL_STATE(88)] = 3040,
  [SMALL_STATE(89)] = 3062,
  [SMALL_STATE(90)] = 3084,
  [SMALL_STATE(91)] = 3106,
  [SMALL_STATE(92)] = 3128,
  [SMALL_STATE(93)] = 3150,
  [SMALL_STATE(94)] = 3172,
  [SMALL_STATE(95)] = 3194,
  [SMALL_STATE(96)] = 3216,
  [SMALL_STATE(97)] = 3238,
  [SMALL_STATE(98)] = 3260,
  [SMALL_STATE(99)] = 3282,
  [SMALL_STATE(100)] = 3304,
  [SMALL_STATE(101)] = 3326,
  [SMALL_STATE(102)] = 3348,
  [SMALL_STATE(103)] = 3370,
  [SMALL_STATE(104)] = 3392,
  [SMALL_STATE(105)] = 3414,
  [SMALL_STATE(106)] = 3436,
  [SMALL_STATE(107)] = 3458,
  [SMALL_STATE(108)] = 3480,
  [SMALL_STATE(109)] = 3502,
  [SMALL_STATE(110)] = 3524,
  [SMALL_STATE(111)] = 3546,
  [SMALL_STATE(112)] = 3568,
  [SMALL_STATE(113)] = 3590,
  [SMALL_STATE(114)] = 3612,
  [SMALL_STATE(115)] = 3634,
  [SMALL_STATE(116)] = 3656,
  [SMALL_STATE(117)] = 3678,
  [SMALL_STATE(118)] = 3700,
  [SMALL_STATE(119)] = 3722,
  [SMALL_STATE(120)] = 3744,
  [SMALL_STATE(121)] = 3766,
  [SMALL_STATE(122)] = 3788,
  [SMALL_STATE(123)] = 3810,
  [SMALL_STATE(124)] = 3832,
  [SMALL_STATE(125)] = 3854,
  [SMALL_STATE(126)] = 3876,
  [SMALL_STATE(127)] = 3898,
  [SMALL_STATE(128)] = 3920,
  [SMALL_STATE(129)] = 3942,
  [SMALL_STATE(130)] = 3964,
  [SMALL_STATE(131)] = 3986,
  [SMALL_STATE(132)] = 4008,
  [SMALL_STATE(133)] = 4030,
  [SMALL_STATE(134)] = 4052,
  [SMALL_STATE(135)] = 4074,
  [SMALL_STATE(136)] = 4096,
  [SMALL_STATE(137)] = 4118,
  [SMALL_STATE(138)] = 4140,
  [SMALL_STATE(139)] = 4162,
  [SMALL_STATE(140)] = 4184,
  [SMALL_STATE(141)] = 4206,
  [SMALL_STATE(142)] = 4228,
  [SMALL_STATE(143)] = 4250,
  [SMALL_STATE(144)] = 4272,
  [SMALL_STATE(145)] = 4294,
  [SMALL_STATE(146)] = 4316,
  [SMALL_STATE(147)] = 4354,
  [SMALL_STATE(148)] = 4376,
  [SMALL_STATE(149)] = 4398,
  [SMALL_STATE(150)] = 4420,
  [SMALL_STATE(151)] = 4442,
  [SMALL_STATE(152)] = 4464,
  [SMALL_STATE(153)] = 4486,
  [SMALL_STATE(154)] = 4508,
  [SMALL_STATE(155)] = 4530,
  [SMALL_STATE(156)] = 4552,
  [SMALL_STATE(157)] = 4574,
  [SMALL_STATE(158)] = 4596,
  [SMALL_STATE(159)] = 4618,
  [SMALL_STATE(160)] = 4640,
  [SMALL_STATE(161)] = 4662,
  [SMALL_STATE(162)] = 4684,
  [SMALL_STATE(163)] = 4706,
  [SMALL_STATE(164)] = 4728,
  [SMALL_STATE(165)] = 4750,
  [SMALL_STATE(166)] = 4772,
  [SMALL_STATE(167)] = 4794,
  [SMALL_STATE(168)] = 4838,
  [SMALL_STATE(169)] = 4860,
  [SMALL_STATE(170)] = 4882,
  [SMALL_STATE(171)] = 4904,
  [SMALL_STATE(172)] = 4926,
  [SMALL_STATE(173)] = 4948,
  [SMALL_STATE(174)] = 4970,
  [SMALL_STATE(175)] = 4992,
  [SMALL_STATE(176)] = 5014,
  [SMALL_STATE(177)] = 5036,
  [SMALL_STATE(178)] = 5058,
  [SMALL_STATE(179)] = 5080,
  [SMALL_STATE(180)] = 5102,
  [SMALL_STATE(181)] = 5124,
  [SMALL_STATE(182)] = 5146,
  [SMALL_STATE(183)] = 5168,
  [SMALL_STATE(184)] = 5190,
  [SMALL_STATE(185)] = 5212,
  [SMALL_STATE(186)] = 5234,
  [SMALL_STATE(187)] = 5256,
  [SMALL_STATE(188)] = 5278,
  [SMALL_STATE(189)] = 5300,
  [SMALL_STATE(190)] = 5344,
  [SMALL_STATE(191)] = 5366,
  [SMALL_STATE(192)] = 5406,
  [SMALL_STATE(193)] = 5446,
  [SMALL_STATE(194)] = 5468,
  [SMALL_STATE(195)] = 5489,
  [SMALL_STATE(196)] = 5510,
  [SMALL_STATE(197)] = 5531,
  [SMALL_STATE(198)] = 5552,
  [SMALL_STATE(199)] = 5573,
  [SMALL_STATE(200)] = 5594,
  [SMALL_STATE(201)] = 5615,
  [SMALL_STATE(202)] = 5636,
  [SMALL_STATE(203)] = 5657,
  [SMALL_STATE(204)] = 5678,
  [SMALL_STATE(205)] = 5699,
  [SMALL_STATE(206)] = 5720,
  [SMALL_STATE(207)] = 5741,
  [SMALL_STATE(208)] = 5762,
  [SMALL_STATE(209)] = 5783,
  [SMALL_STATE(210)] = 5804,
  [SMALL_STATE(211)] = 5825,
  [SMALL_STATE(212)] = 5846,
  [SMALL_STATE(213)] = 5867,
  [SMALL_STATE(214)] = 5888,
  [SMALL_STATE(215)] = 5909,
  [SMALL_STATE(216)] = 5930,
  [SMALL_STATE(217)] = 5951,
  [SMALL_STATE(218)] = 5972,
  [SMALL_STATE(219)] = 5993,
  [SMALL_STATE(220)] = 6014,
  [SMALL_STATE(221)] = 6035,
  [SMALL_STATE(222)] = 6056,
  [SMALL_STATE(223)] = 6077,
  [SMALL_STATE(224)] = 6098,
  [SMALL_STATE(225)] = 6119,
  [SMALL_STATE(226)] = 6140,
  [SMALL_STATE(227)] = 6161,
  [SMALL_STATE(228)] = 6182,
  [SMALL_STATE(229)] = 6203,
  [SMALL_STATE(230)] = 6224,
  [SMALL_STATE(231)] = 6245,
  [SMALL_STATE(232)] = 6290,
  [SMALL_STATE(233)] = 6311,
  [SMALL_STATE(234)] = 6332,
  [SMALL_STATE(235)] = 6353,
  [SMALL_STATE(236)] = 6374,
  [SMALL_STATE(237)] = 6395,
  [SMALL_STATE(238)] = 6416,
  [SMALL_STATE(239)] = 6437,
  [SMALL_STATE(240)] = 6458,
  [SMALL_STATE(241)] = 6479,
  [SMALL_STATE(242)] = 6500,
  [SMALL_STATE(243)] = 6521,
  [SMALL_STATE(244)] = 6542,
  [SMALL_STATE(245)] = 6563,
  [SMALL_STATE(246)] = 6584,
  [SMALL_STATE(247)] = 6605,
  [SMALL_STATE(248)] = 6626,
  [SMALL_STATE(249)] = 6647,
  [SMALL_STATE(250)] = 6692,
  [SMALL_STATE(251)] = 6713,
  [SMALL_STATE(252)] = 6734,
  [SMALL_STATE(253)] = 6755,
  [SMALL_STATE(254)] = 6776,
  [SMALL_STATE(255)] = 6797,
  [SMALL_STATE(256)] = 6818,
  [SMALL_STATE(257)] = 6839,
  [SMALL_STATE(258)] = 6860,
  [SMALL_STATE(259)] = 6881,
  [SMALL_STATE(260)] = 6902,
  [SMALL_STATE(261)] = 6923,
  [SMALL_STATE(262)] = 6944,
  [SMALL_STATE(263)] = 6965,
  [SMALL_STATE(264)] = 6986,
  [SMALL_STATE(265)] = 7007,
  [SMALL_STATE(266)] = 7028,
  [SMALL_STATE(267)] = 7049,
  [SMALL_STATE(268)] = 7070,
  [SMALL_STATE(269)] = 7091,
  [SMALL_STATE(270)] = 7126,
  [SMALL_STATE(271)] = 7147,
  [SMALL_STATE(272)] = 7168,
  [SMALL_STATE(273)] = 7203,
  [SMALL_STATE(274)] = 7224,
  [SMALL_STATE(275)] = 7245,
  [SMALL_STATE(276)] = 7266,
  [SMALL_STATE(277)] = 7287,
  [SMALL_STATE(278)] = 7308,
  [SMALL_STATE(279)] = 7329,
  [SMALL_STATE(280)] = 7350,
  [SMALL_STATE(281)] = 7371,
  [SMALL_STATE(282)] = 7392,
  [SMALL_STATE(283)] = 7413,
  [SMALL_STATE(284)] = 7434,
  [SMALL_STATE(285)] = 7455,
  [SMALL_STATE(286)] = 7476,
  [SMALL_STATE(287)] = 7497,
  [SMALL_STATE(288)] = 7518,
  [SMALL_STATE(289)] = 7552,
  [SMALL_STATE(290)] = 7589,
  [SMALL_STATE(291)] = 7626,
  [SMALL_STATE(292)] = 7658,
  [SMALL_STATE(293)] = 7690,
  [SMALL_STATE(294)] = 7722,
  [SMALL_STATE(295)] = 7754,
  [SMALL_STATE(296)] = 7786,
  [SMALL_STATE(297)] = 7818,
  [SMALL_STATE(298)] = 7850,
  [SMALL_STATE(299)] = 7882,
  [SMALL_STATE(300)] = 7914,
  [SMALL_STATE(301)] = 7946,
  [SMALL_STATE(302)] = 7978,
  [SMALL_STATE(303)] = 8010,
  [SMALL_STATE(304)] = 8042,
  [SMALL_STATE(305)] = 8074,
  [SMALL_STATE(306)] = 8106,
  [SMALL_STATE(307)] = 8138,
  [SMALL_STATE(308)] = 8155,
  [SMALL_STATE(309)] = 8172,
  [SMALL_STATE(310)] = 8189,
  [SMALL_STATE(311)] = 8212,
  [SMALL_STATE(312)] = 8229,
  [SMALL_STATE(313)] = 8248,
  [SMALL_STATE(314)] = 8265,
  [SMALL_STATE(315)] = 8282,
  [SMALL_STATE(316)] = 8301,
  [SMALL_STATE(317)] = 8323,
  [SMALL_STATE(318)] = 8349,
  [SMALL_STATE(319)] = 8369,
  [SMALL_STATE(320)] = 8389,
  [SMALL_STATE(321)] = 8409,
  [SMALL_STATE(322)] = 8429,
  [SMALL_STATE(323)] = 8443,
  [SMALL_STATE(324)] = 8463,
  [SMALL_STATE(325)] = 8477,
  [SMALL_STATE(326)] = 8497,
  [SMALL_STATE(327)] = 8523,
  [SMALL_STATE(328)] = 8546,
  [SMALL_STATE(329)] = 8569,
  [SMALL_STATE(330)] = 8586,
  [SMALL_STATE(331)] = 8611,
  [SMALL_STATE(332)] = 8628,
  [SMALL_STATE(333)] = 8653,
  [SMALL_STATE(334)] = 8678,
  [SMALL_STATE(335)] = 8695,
  [SMALL_STATE(336)] = 8718,
  [SMALL_STATE(337)] = 8735,
  [SMALL_STATE(338)] = 8752,
  [SMALL_STATE(339)] = 8769,
  [SMALL_STATE(340)] = 8792,
  [SMALL_STATE(341)] = 8809,
  [SMALL_STATE(342)] = 8826,
  [SMALL_STATE(343)] = 8843,
  [SMALL_STATE(344)] = 8868,
  [SMALL_STATE(345)] = 8888,
  [SMALL_STATE(346)] = 8908,
  [SMALL_STATE(347)] = 8923,
  [SMALL_STATE(348)] = 8942,
  [SMALL_STATE(349)] = 8955,
  [SMALL_STATE(350)] = 8968,
  [SMALL_STATE(351)] = 8983,
  [SMALL_STATE(352)] = 8996,
  [SMALL_STATE(353)] = 9013,
  [SMALL_STATE(354)] = 9026,
  [SMALL_STATE(355)] = 9045,
  [SMALL_STATE(356)] = 9056,
  [SMALL_STATE(357)] = 9075,
  [SMALL_STATE(358)] = 9094,
  [SMALL_STATE(359)] = 9113,
  [SMALL_STATE(360)] = 9125,
  [SMALL_STATE(361)] = 9141,
  [SMALL_STATE(362)] = 9153,
  [SMALL_STATE(363)] = 9169,
  [SMALL_STATE(364)] = 9181,
  [SMALL_STATE(365)] = 9189,
  [SMALL_STATE(366)] = 9205,
  [SMALL_STATE(367)] = 9217,
  [SMALL_STATE(368)] = 9229,
  [SMALL_STATE(369)] = 9241,
  [SMALL_STATE(370)] = 9255,
  [SMALL_STATE(371)] = 9265,
  [SMALL_STATE(372)] = 9277,
  [SMALL_STATE(373)] = 9285,
  [SMALL_STATE(374)] = 9297,
  [SMALL_STATE(375)] = 9313,
  [SMALL_STATE(376)] = 9325,
  [SMALL_STATE(377)] = 9341,
  [SMALL_STATE(378)] = 9357,
  [SMALL_STATE(379)] = 9371,
  [SMALL_STATE(380)] = 9387,
  [SMALL_STATE(381)] = 9403,
  [SMALL_STATE(382)] = 9416,
  [SMALL_STATE(383)] = 9425,
  [SMALL_STATE(384)] = 9432,
  [SMALL_STATE(385)] = 9441,
  [SMALL_STATE(386)] = 9454,
  [SMALL_STATE(387)] = 9467,
  [SMALL_STATE(388)] = 9477,
  [SMALL_STATE(389)] = 9487,
  [SMALL_STATE(390)] = 9497,
  [SMALL_STATE(391)] = 9507,
  [SMALL_STATE(392)] = 9517,
  [SMALL_STATE(393)] = 9527,
  [SMALL_STATE(394)] = 9537,
  [SMALL_STATE(395)] = 9547,
  [SMALL_STATE(396)] = 9557,
  [SMALL_STATE(397)] = 9565,
  [SMALL_STATE(398)] = 9575,
  [SMALL_STATE(399)] = 9583,
  [SMALL_STATE(400)] = 9591,
  [SMALL_STATE(401)] = 9601,
  [SMALL_STATE(402)] = 9611,
  [SMALL_STATE(403)] = 9621,
  [SMALL_STATE(404)] = 9631,
  [SMALL_STATE(405)] = 9639,
  [SMALL_STATE(406)] = 9649,
  [SMALL_STATE(407)] = 9655,
  [SMALL_STATE(408)] = 9665,
  [SMALL_STATE(409)] = 9673,
  [SMALL_STATE(410)] = 9681,
  [SMALL_STATE(411)] = 9691,
  [SMALL_STATE(412)] = 9701,
  [SMALL_STATE(413)] = 9711,
  [SMALL_STATE(414)] = 9721,
  [SMALL_STATE(415)] = 9731,
  [SMALL_STATE(416)] = 9741,
  [SMALL_STATE(417)] = 9751,
  [SMALL_STATE(418)] = 9761,
  [SMALL_STATE(419)] = 9771,
  [SMALL_STATE(420)] = 9781,
  [SMALL_STATE(421)] = 9791,
  [SMALL_STATE(422)] = 9801,
  [SMALL_STATE(423)] = 9811,
  [SMALL_STATE(424)] = 9821,
  [SMALL_STATE(425)] = 9831,
  [SMALL_STATE(426)] = 9841,
  [SMALL_STATE(427)] = 9851,
  [SMALL_STATE(428)] = 9861,
  [SMALL_STATE(429)] = 9871,
  [SMALL_STATE(430)] = 9879,
  [SMALL_STATE(431)] = 9887,
  [SMALL_STATE(432)] = 9894,
  [SMALL_STATE(433)] = 9899,
  [SMALL_STATE(434)] = 9904,
  [SMALL_STATE(435)] = 9911,
  [SMALL_STATE(436)] = 9918,
  [SMALL_STATE(437)] = 9923,
  [SMALL_STATE(438)] = 9928,
  [SMALL_STATE(439)] = 9933,
  [SMALL_STATE(440)] = 9940,
  [SMALL_STATE(441)] = 9947,
  [SMALL_STATE(442)] = 9952,
  [SMALL_STATE(443)] = 9957,
  [SMALL_STATE(444)] = 9962,
  [SMALL_STATE(445)] = 9969,
  [SMALL_STATE(446)] = 9976,
  [SMALL_STATE(447)] = 9981,
  [SMALL_STATE(448)] = 9985,
  [SMALL_STATE(449)] = 9989,
  [SMALL_STATE(450)] = 9993,
  [SMALL_STATE(451)] = 9997,
  [SMALL_STATE(452)] = 10001,
  [SMALL_STATE(453)] = 10005,
  [SMALL_STATE(454)] = 10009,
  [SMALL_STATE(455)] = 10013,
  [SMALL_STATE(456)] = 10017,
  [SMALL_STATE(457)] = 10021,
  [SMALL_STATE(458)] = 10025,
  [SMALL_STATE(459)] = 10029,
  [SMALL_STATE(460)] = 10033,
  [SMALL_STATE(461)] = 10037,
  [SMALL_STATE(462)] = 10041,
  [SMALL_STATE(463)] = 10045,
  [SMALL_STATE(464)] = 10049,
  [SMALL_STATE(465)] = 10053,
  [SMALL_STATE(466)] = 10057,
  [SMALL_STATE(467)] = 10061,
  [SMALL_STATE(468)] = 10065,
  [SMALL_STATE(469)] = 10069,
  [SMALL_STATE(470)] = 10073,
  [SMALL_STATE(471)] = 10077,
  [SMALL_STATE(472)] = 10081,
  [SMALL_STATE(473)] = 10085,
  [SMALL_STATE(474)] = 10089,
  [SMALL_STATE(475)] = 10093,
  [SMALL_STATE(476)] = 10097,
  [SMALL_STATE(477)] = 10101,
  [SMALL_STATE(478)] = 10105,
  [SMALL_STATE(479)] = 10109,
  [SMALL_STATE(480)] = 10113,
  [SMALL_STATE(481)] = 10117,
  [SMALL_STATE(482)] = 10121,
  [SMALL_STATE(483)] = 10125,
  [SMALL_STATE(484)] = 10129,
  [SMALL_STATE(485)] = 10133,
  [SMALL_STATE(486)] = 10137,
  [SMALL_STATE(487)] = 10141,
  [SMALL_STATE(488)] = 10145,
  [SMALL_STATE(489)] = 10149,
  [SMALL_STATE(490)] = 10153,
  [SMALL_STATE(491)] = 10157,
  [SMALL_STATE(492)] = 10161,
  [SMALL_STATE(493)] = 10165,
  [SMALL_STATE(494)] = 10169,
  [SMALL_STATE(495)] = 10173,
  [SMALL_STATE(496)] = 10177,
  [SMALL_STATE(497)] = 10181,
  [SMALL_STATE(498)] = 10185,
  [SMALL_STATE(499)] = 10189,
  [SMALL_STATE(500)] = 10193,
  [SMALL_STATE(501)] = 10197,
  [SMALL_STATE(502)] = 10201,
  [SMALL_STATE(503)] = 10205,
  [SMALL_STATE(504)] = 10209,
  [SMALL_STATE(505)] = 10213,
  [SMALL_STATE(506)] = 10217,
  [SMALL_STATE(507)] = 10221,
  [SMALL_STATE(508)] = 10225,
  [SMALL_STATE(509)] = 10229,
  [SMALL_STATE(510)] = 10233,
  [SMALL_STATE(511)] = 10237,
  [SMALL_STATE(512)] = 10241,
  [SMALL_STATE(513)] = 10245,
  [SMALL_STATE(514)] = 10249,
  [SMALL_STATE(515)] = 10253,
  [SMALL_STATE(516)] = 10257,
  [SMALL_STATE(517)] = 10261,
  [SMALL_STATE(518)] = 10265,
  [SMALL_STATE(519)] = 10269,
  [SMALL_STATE(520)] = 10273,
  [SMALL_STATE(521)] = 10277,
  [SMALL_STATE(522)] = 10281,
  [SMALL_STATE(523)] = 10285,
  [SMALL_STATE(524)] = 10289,
  [SMALL_STATE(525)] = 10293,
  [SMALL_STATE(526)] = 10297,
  [SMALL_STATE(527)] = 10301,
  [SMALL_STATE(528)] = 10305,
  [SMALL_STATE(529)] = 10309,
  [SMALL_STATE(530)] = 10313,
  [SMALL_STATE(531)] = 10317,
  [SMALL_STATE(532)] = 10321,
  [SMALL_STATE(533)] = 10325,
  [SMALL_STATE(534)] = 10329,
  [SMALL_STATE(535)] = 10333,
  [SMALL_STATE(536)] = 10337,
  [SMALL_STATE(537)] = 10341,
  [SMALL_STATE(538)] = 10345,
  [SMALL_STATE(539)] = 10349,
  [SMALL_STATE(540)] = 10353,
  [SMALL_STATE(541)] = 10357,
  [SMALL_STATE(542)] = 10361,
  [SMALL_STATE(543)] = 10365,
  [SMALL_STATE(544)] = 10369,
  [SMALL_STATE(545)] = 10373,
  [SMALL_STATE(546)] = 10377,
  [SMALL_STATE(547)] = 10381,
  [SMALL_STATE(548)] = 10385,
  [SMALL_STATE(549)] = 10389,
  [SMALL_STATE(550)] = 10393,
  [SMALL_STATE(551)] = 10397,
  [SMALL_STATE(552)] = 10401,
  [SMALL_STATE(553)] = 10405,
  [SMALL_STATE(554)] = 10409,
  [SMALL_STATE(555)] = 10413,
  [SMALL_STATE(556)] = 10417,
  [SMALL_STATE(557)] = 10421,
  [SMALL_STATE(558)] = 10425,
  [SMALL_STATE(559)] = 10429,
  [SMALL_STATE(560)] = 10433,
  [SMALL_STATE(561)] = 10437,
  [SMALL_STATE(562)] = 10441,
  [SMALL_STATE(563)] = 10445,
  [SMALL_STATE(564)] = 10449,
  [SMALL_STATE(565)] = 10453,
  [SMALL_STATE(566)] = 10457,
  [SMALL_STATE(567)] = 10461,
  [SMALL_STATE(568)] = 10465,
  [SMALL_STATE(569)] = 10469,
  [SMALL_STATE(570)] = 10473,
  [SMALL_STATE(571)] = 10477,
  [SMALL_STATE(572)] = 10481,
  [SMALL_STATE(573)] = 10485,
  [SMALL_STATE(574)] = 10489,
  [SMALL_STATE(575)] = 10493,
  [SMALL_STATE(576)] = 10497,
  [SMALL_STATE(577)] = 10501,
  [SMALL_STATE(578)] = 10505,
  [SMALL_STATE(579)] = 10509,
  [SMALL_STATE(580)] = 10513,
  [SMALL_STATE(581)] = 10517,
  [SMALL_STATE(582)] = 10521,
  [SMALL_STATE(583)] = 10525,
  [SMALL_STATE(584)] = 10529,
  [SMALL_STATE(585)] = 10533,
  [SMALL_STATE(586)] = 10537,
  [SMALL_STATE(587)] = 10541,
  [SMALL_STATE(588)] = 10545,
  [SMALL_STATE(589)] = 10549,
  [SMALL_STATE(590)] = 10553,
  [SMALL_STATE(591)] = 10557,
  [SMALL_STATE(592)] = 10561,
  [SMALL_STATE(593)] = 10565,
  [SMALL_STATE(594)] = 10569,
  [SMALL_STATE(595)] = 10573,
  [SMALL_STATE(596)] = 10577,
  [SMALL_STATE(597)] = 10581,
  [SMALL_STATE(598)] = 10585,
  [SMALL_STATE(599)] = 10589,
  [SMALL_STATE(600)] = 10593,
  [SMALL_STATE(601)] = 10597,
  [SMALL_STATE(602)] = 10601,
  [SMALL_STATE(603)] = 10605,
  [SMALL_STATE(604)] = 10609,
  [SMALL_STATE(605)] = 10613,
  [SMALL_STATE(606)] = 10617,
  [SMALL_STATE(607)] = 10621,
  [SMALL_STATE(608)] = 10625,
  [SMALL_STATE(609)] = 10629,
  [SMALL_STATE(610)] = 10633,
  [SMALL_STATE(611)] = 10637,
  [SMALL_STATE(612)] = 10641,
  [SMALL_STATE(613)] = 10645,
  [SMALL_STATE(614)] = 10649,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 0),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(493),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(486),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(451),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(431),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(510),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(528),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(541),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(542),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(563),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(584),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(585),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(586),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(440),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(606),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(607),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(588),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(589),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2),
  [71] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(6),
  [74] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(6),
  [77] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(493),
  [80] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(486),
  [83] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(451),
  [86] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(431),
  [89] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(510),
  [92] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(528),
  [95] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(541),
  [98] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(542),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(249),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(563),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(602),
  [110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 1),
  [112] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [116] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(8),
  [119] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(8),
  [122] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(584),
  [125] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(585),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(586),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(440),
  [134] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(606),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(607),
  [140] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(588),
  [143] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(589),
  [146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(231),
  [149] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_section_repeat1, 2), SHIFT_REPEAT(563),
  [152] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_section_repeat1, 2),
  [154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 4, .production_id = 11),
  [156] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 4, .production_id = 11),
  [158] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 3, .production_id = 3),
  [162] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 3, .production_id = 3),
  [164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 5, .production_id = 29),
  [166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 5, .production_id = 29),
  [168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 5, .production_id = 30),
  [170] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 5, .production_id = 30),
  [172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 5, .production_id = 32),
  [174] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 5, .production_id = 32),
  [176] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 4, .production_id = 12),
  [180] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 4, .production_id = 12),
  [182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 6, .production_id = 42),
  [184] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 6, .production_id = 42),
  [186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 4, .production_id = 13),
  [188] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 4, .production_id = 13),
  [190] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_close, 4, .production_id = 7),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(413),
  [194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_close, 4, .production_id = 7),
  [196] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_balance, 6, .production_id = 34),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_balance, 6, .production_id = 34),
  [200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_note, 5, .production_id = 24),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_note, 5, .production_id = 24),
  [204] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_price, 5, .production_id = 23),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_price, 5, .production_id = 23),
  [208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_event, 5, .production_id = 22),
  [210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event, 5, .production_id = 22),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pad, 5, .production_id = 21),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pad, 5, .production_id = 21),
  [216] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_commodity, 5, .production_id = 20),
  [218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_commodity, 5, .production_id = 20),
  [220] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_close, 5, .production_id = 18),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_close, 5, .production_id = 18),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 5, .production_id = 19),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 5, .production_id = 19),
  [228] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 5, .production_id = 18),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 5, .production_id = 18),
  [232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 5, .production_id = 17),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 5, .production_id = 17),
  [236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting_or_kv_list, 1),
  [238] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting_or_kv_list, 1),
  [240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_balance, 5, .production_id = 16),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_balance, 5, .production_id = 16),
  [244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_custom, 4, .production_id = 9),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom, 4, .production_id = 9),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_commodity, 4, .production_id = 8),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_commodity, 4, .production_id = 8),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 4, .production_id = 7),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 4, .production_id = 7),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 7, .production_id = 45),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 7, .production_id = 45),
  [260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 5, .production_id = 26),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 5, .production_id = 26),
  [266] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_custom, 5, .production_id = 27),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom, 5, .production_id = 27),
  [270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 6, .production_id = 39),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_document, 6, .production_id = 39),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pad, 6, .production_id = 38),
  [276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pad, 6, .production_id = 38),
  [278] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_posting_or_kv_list_repeat1, 2),
  [280] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_posting_or_kv_list_repeat1, 2), SHIFT_REPEAT(289),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_posting_or_kv_list_repeat1, 2),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 6, .production_id = 37),
  [287] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 6, .production_id = 37),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 6, .production_id = 36),
  [291] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 6, .production_id = 36),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 6, .production_id = 35),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 6, .production_id = 35),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_document, 5, .production_id = 25),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 5, .production_id = 25),
  [301] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_posting_or_kv_list_repeat1, 2), SHIFT_REPEAT(290),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_value_list, 1),
  [306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_value_list, 1),
  [308] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_key_value_list_repeat1, 2),
  [310] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_key_value_list_repeat1, 2), SHIFT_REPEAT(413),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_key_value_list_repeat1, 2),
  [315] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_key_value_list_repeat1, 2), SHIFT_REPEAT(423),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_value, 2),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [324] = {.entry = {.count = 1, .reusable = false}}, SHIFT(480),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [328] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 72),
  [332] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 72),
  [334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 8, .production_id = 92),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 8, .production_id = 92),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [342] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [346] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(291),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [364] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [368] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 9, .production_id = 93),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 9, .production_id = 93),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 8, .production_id = 91),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 8, .production_id = 91),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 8, .production_id = 90),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 8, .production_id = 90),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 8, .production_id = 89),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 8, .production_id = 89),
  [386] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 8, .production_id = 88),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 8, .production_id = 88),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 87),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 87),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 86),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 86),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 85),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 85),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 74),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 74),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 84),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 84),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 83),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 83),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 82),
  [416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 82),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 81),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 81),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 80),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 80),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 79),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 79),
  [430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 7, .production_id = 78),
  [432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 7, .production_id = 78),
  [434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 76),
  [436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 76),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 62),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 62),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 75),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 75),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 74),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 74),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 61),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 61),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 73),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 73),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 71),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 71),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 70),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 70),
  [466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 69),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 69),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 58),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 58),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 68),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 68),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 67),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 67),
  [482] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 6, .production_id = 64),
  [484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 6, .production_id = 64),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 63),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 63),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 62),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 62),
  [494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 61),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 61),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 51),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 51),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 60),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 60),
  [506] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 49),
  [508] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 49),
  [510] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 59),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 59),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 58),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 58),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 48),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 48),
  [522] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 54),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 54),
  [526] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 5, .production_id = 53),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 5, .production_id = 53),
  [530] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 4, .production_id = 51),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 4, .production_id = 51),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 4, .production_id = 50),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 4, .production_id = 50),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 4, .production_id = 49),
  [540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 4, .production_id = 49),
  [542] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 4, .production_id = 48),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 4, .production_id = 48),
  [546] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 4, .production_id = 40),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 4, .production_id = 40),
  [550] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_key_value_line, 3),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_value_line, 3),
  [554] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_posting_or_kv_list_repeat1, 3),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_posting_or_kv_list_repeat1, 3),
  [558] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_posting, 3, .production_id = 40),
  [560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_posting, 3, .production_id = 40),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [568] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(316),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 6, .production_id = 19),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 6, .production_id = 19),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 6, .production_id = 17),
  [592] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 6, .production_id = 17),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_close, 6, .production_id = 18),
  [596] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_close, 6, .production_id = 18),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_commodity, 6, .production_id = 20),
  [600] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_commodity, 6, .production_id = 20),
  [602] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pad, 6, .production_id = 21),
  [604] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pad, 6, .production_id = 21),
  [606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__skipped_lines, 3),
  [608] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__skipped_lines, 3),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event, 6, .production_id = 22),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_event, 6, .production_id = 22),
  [614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_price, 6, .production_id = 23),
  [616] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_price, 6, .production_id = 23),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_note, 6, .production_id = 24),
  [620] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_note, 6, .production_id = 24),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 6, .production_id = 25),
  [624] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_document, 6, .production_id = 25),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__skipped_lines, 2),
  [628] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__skipped_lines, 2),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom, 5, .production_id = 9),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_custom, 5, .production_id = 9),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom, 6, .production_id = 27),
  [636] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_custom, 6, .production_id = 27),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_poptag, 3),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_poptag, 3),
  [642] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_plugin, 4),
  [644] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_plugin, 4),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 6, .production_id = 18),
  [648] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 6, .production_id = 18),
  [650] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_option, 4, .production_id = 6),
  [652] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_option, 4, .production_id = 6),
  [654] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_query, 6, .production_id = 26),
  [656] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 6, .production_id = 26),
  [658] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_popmeta, 4),
  [660] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_popmeta, 4),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pushmeta, 3),
  [664] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pushmeta, 3),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 5, .production_id = 7),
  [668] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 5, .production_id = 7),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 6, .production_id = 41),
  [672] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 6, .production_id = 41),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 6, .production_id = 43),
  [676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 6, .production_id = 43),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 6, .production_id = 44),
  [680] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 6, .production_id = 44),
  [682] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_plugin, 3),
  [684] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_plugin, 3),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_balance, 7, .production_id = 34),
  [688] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_balance, 7, .production_id = 34),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 7, .production_id = 35),
  [692] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 7, .production_id = 35),
  [694] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 7, .production_id = 36),
  [696] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 7, .production_id = 36),
  [698] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include, 3),
  [700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include, 3),
  [702] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 7, .production_id = 37),
  [704] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 7, .production_id = 37),
  [706] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pad, 7, .production_id = 38),
  [708] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pad, 7, .production_id = 38),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 7, .production_id = 39),
  [712] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_document, 7, .production_id = 39),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [716] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(613),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [740] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pushtag, 3),
  [742] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pushtag, 3),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [766] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_balance, 6, .production_id = 16),
  [768] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_balance, 6, .production_id = 16),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section, 2, .production_id = 1),
  [772] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_section, 2, .production_id = 1),
  [774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 7, .production_id = 52),
  [776] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 7, .production_id = 52),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_open, 8, .production_id = 45),
  [780] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_open, 8, .production_id = 45),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_close, 5, .production_id = 7),
  [784] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_close, 5, .production_id = 7),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_commodity, 5, .production_id = 8),
  [788] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_commodity, 5, .production_id = 8),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section, 4, .production_id = 15),
  [792] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_section, 4, .production_id = 15),
  [794] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headline, 4, .production_id = 14),
  [796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headline, 4, .production_id = 14),
  [798] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 5, .production_id = 33),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 5, .production_id = 33),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 4, .production_id = 10),
  [804] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 4, .production_id = 10),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_custom_value_list_repeat1, 2),
  [808] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_value_list_repeat1, 2), SHIFT_REPEAT(336),
  [811] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_value_list_repeat1, 2), SHIFT_REPEAT(342),
  [814] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_value_list_repeat1, 2), SHIFT_REPEAT(322),
  [817] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_value_list_repeat1, 2), SHIFT_REPEAT(322),
  [820] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_custom_value_list_repeat1, 2), SHIFT_REPEAT(310),
  [823] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_headline, 3),
  [825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_headline, 3),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom_value_list, 1),
  [829] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 5, .production_id = 31),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 5, .production_id = 31),
  [833] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transaction, 5, .production_id = 28),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transaction, 5, .production_id = 28),
  [837] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section, 3, .production_id = 1),
  [839] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_section, 3, .production_id = 1),
  [841] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section, 3, .production_id = 4),
  [843] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_section, 3, .production_id = 4),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [847] = {.entry = {.count = 1, .reusable = false}}, SHIFT(481),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_number_expr, 3),
  [895] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_number_expr, 3),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_number_expr, 2),
  [899] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_number_expr, 2),
  [901] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom_value, 1),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [907] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_custom_value, 1),
  [909] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren__number_expr, 3),
  [915] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren__number_expr, 3),
  [917] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_amount, 1, .production_id = 47),
  [919] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_amount, 1, .production_id = 47),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [943] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_amount, 2),
  [945] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_amount, 2),
  [947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [963] = {.entry = {.count = 1, .reusable = false}}, SHIFT(304),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [971] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [977] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1001] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1013] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_currency_list, 1),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1017] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_currency_list, 2),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__key_value_value, 1),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_open_repeat1, 2),
  [1025] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_open_repeat1, 2), SHIFT_REPEAT(348),
  [1028] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [1030] = {.entry = {.count = 1, .reusable = false}}, SHIFT(434),
  [1032] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_currency_list_repeat1, 2),
  [1034] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_currency_list_repeat1, 2), SHIFT_REPEAT(449),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1039] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_incomplete_amount, 2),
  [1041] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_incomplete_amount, 2),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1047] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_section_repeat2, 2, .production_id = 5), SHIFT_REPEAT(602),
  [1050] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_section_repeat2, 2, .production_id = 5),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1058] = {.entry = {.count = 1, .reusable = false}}, SHIFT(301),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1066] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1070] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_txn, 1),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1076] = {.entry = {.count = 1, .reusable = false}}, SHIFT(305),
  [1078] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tags_links_repeat1, 2),
  [1080] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_tags_links_repeat1, 2), SHIFT_REPEAT(366),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1087] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_txn_strings, 1),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1093] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tags_links, 1),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [1123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [1131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cost_comp_list, 1),
  [1133] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cost_comp_list, 1),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cost_spec, 2),
  [1139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cost_spec, 2),
  [1141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_txn_strings, 2),
  [1143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cost_spec, 3, .production_id = 57),
  [1145] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cost_spec, 3, .production_id = 57),
  [1147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cost_comp_list, 2),
  [1149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cost_comp_list, 2),
  [1151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_cost_comp_list_repeat1, 2),
  [1153] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_cost_comp_list_repeat1, 2),
  [1155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_cost_comp_list_repeat1, 2), SHIFT_REPEAT(288),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_amount, 4, .production_id = 77),
  [1178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_amount, 4, .production_id = 77),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [1182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cost_comp, 1),
  [1184] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cost_comp, 1),
  [1186] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_amount, 1, .production_id = 46),
  [1188] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_amount, 1, .production_id = 46),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [1198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_amount, 3, .production_id = 66),
  [1200] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_amount, 3, .production_id = 66),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filename, 1),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1208] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_amount, 2, .production_id = 55),
  [1210] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_amount, 2, .production_id = 55),
  [1212] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_amount, 2, .production_id = 56),
  [1214] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_amount, 2, .production_id = 56),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(265),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [1256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_amount, 3, .production_id = 65),
  [1258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_amount, 3, .production_id = 65),
  [1260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_amount_tolerance, 2),
  [1262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item, 1),
  [1264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item, 1),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_opt_booking, 1),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_price_annotation, 1),
  [1276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_section_repeat2, 1, .production_id = 2),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_amount_tolerance, 4),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [1294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_value, 3),
  [1352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optflag, 1),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [1416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [1418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [1456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [1458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [1472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [1474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [1486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [1500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [1512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [1516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1524] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2),
  [1564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__org_stars, 2),
  [1590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [1594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [1602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [1604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [1606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [1608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [1610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [1612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [1614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_beancount_external_scanner_create(void);
void tree_sitter_beancount_external_scanner_destroy(void *);
bool tree_sitter_beancount_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_beancount_external_scanner_serialize(void *, char *);
void tree_sitter_beancount_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_beancount(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_beancount_external_scanner_create,
      tree_sitter_beancount_external_scanner_destroy,
      tree_sitter_beancount_external_scanner_scan,
      tree_sitter_beancount_external_scanner_serialize,
      tree_sitter_beancount_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
