/* Arch/Port/ui.c
	vi:ts=3 sw=3:
 */

/* $Id: ui.c,v 5.0 1995/10/21 14:55:42 espie Exp espie $
 * $Log: ui.c,v $
 * Revision 5.0  1995/10/21 14:55:42  espie
 * New
 *
 * Revision 1.1  1995/09/03 15:50:30  espie
 * Initial revision
 *
 */

/* this is just a set of stub routines.
 * In case you have Unix, try to use Unix/ui.c  with USE_TERMIOS or USE_SGTTY.
 * If these don't work, look at the #define'd code and try to add an entry
 * for your system
 */


#include "defs.h"
#include "extern.h"
#include "tags.h"
#include "prefs.h"


#include <ctype.h>


extern char *VERSION;

LOCAL void sane_tty P((void));



/* Assume we always run in fg */
int run_in_fg()
   {
   return TRUE;
   }

/* should put the tty back in working order */
LOCAL void sane_tty()
   {
   }

/* return a dummy ui */
LOCAL struct tag end_marker;

struct tag *get_ui()
   {
   end_marker.type = TAG_END;
   return &end_marker;
   }

/* what to do in a signal handler */
LOCAL void goodbye(sig)
int sig;
   {
	char pter[50];
		/* reset the color to standard */

		/* inform the user about the signal */
	sprintf(pter, "Signal %d", sig);
		/* quit correctly */
   end_all(pter);
   }

/* what to do if we are stopped */
LOCAL void suspend(sig)
int sig;
   {
		/* reset the color to standard */

		/* restore the tty */
   sane_tty();

		/* do some OS processing */
   }


/* Here are all the default display functions.
 * They already get the part about sync_audio right,
 * all of them use stdio.
 */

void notice(s)
char *s;
   {
   fprintf(stderr, "%s\n", s);
   }

void status(s)
char *s;
   {
   if (run_in_fg())
      {
		if (s)
         {
         puts(s);
         }
      else
         putchar('\n');
      }
   }

LOCAL char title[25];

void song_title(s)
char *s;
   {
	int i;

	for (i = 0; *s && i < 24; s++)
		if (isprint(*s))
		    title[i++] = *s;
	title[i] = 0;
   }


LOCAL char scroll_buffer[200];

GENERIC begin_info(title)
char *title;
   {
   if (run_in_fg())
      return scroll_buffer;
   else
      return 0;
   }

void infos(handle, s)
GENERIC handle;
char *s;
   {
   if (handle)
      printf(s);
   }

void info(handle, line)
GENERIC handle;
char *line;
   {
   if (handle)
      puts(line);
   }

void end_info(handle)
GENERIC handle;
   {
   if (handle)
      fflush(stdout);
   }

LOCAL char *last_result = 0;

LOCAL int ntracks;

void set_number_tracks(n)
int n;
	{
	ntracks = n;
	}

LOCAL void clear_scroll(temp)
char *temp;
	{
	int i;

		/* put normal values for a scroll line there */
	for (i = 0; i < 190; i++)
		temp[i] = ' ';
	temp[i] = 0;
	}

char *new_scroll()
   {
	last_result = 0;

   if (run_in_fg()) {
      last_result = malloc(200);
	if (last_result)
		clear_scroll(last_result);
      }
   return last_result;
   }
   
LOCAL void do_scroll(line)
GENERIC line;
	{
   if (run_in_fg())
		{
      puts((char *)line);
		fflush(stdout);
		}
	free(line);
   }

LOCAL void free_p(line)
GENERIC line;
	{
	free(line);
	}

void scroll()
   {
	if (last_result)
		sync_audio(do_scroll, free_p, last_result);
	}

struct thingy
	{
	int t0, t1, t2;
	unsigned long u0, u1;
	};

LOCAL void do_display_pattern(param)
GENERIC param;
	{
	struct thingy *thingy = (struct thingy *)param;
	int current, total, real;
	unsigned long uptilnow, totaltime;

	current = thingy->t0;
	total = thingy->t1;
	real = thingy->t2;
	uptilnow = thingy->u0;
	totaltime =thingy->u1;
	free(thingy);

   if (run_in_fg())
		{
		if (get_pref_scalar(PREF_SHOW))
				printf("\n%3d/%3d[%3d] %s\n", current, total, real, title);
		fflush(stdout); 
      }
   }

void display_pattern(current, total, real, uptilnow, totaltime)
int current, total, real;
unsigned long uptilnow, totaltime;
   {
	struct thingy *thingy;

	thingy = malloc(sizeof(struct thingy));
	thingy->t0 = current;
	thingy->t1 = total;
	thingy->t2 = real;
	thingy->u0 = uptilnow;
	thingy->u1 = totaltime;

	sync_audio(do_display_pattern, free_p, thingy);
	}

LOCAL void do_display_time(param)
GENERIC param;
	{
	char buffer[50];
	printf("%s\n", time2string(buffer, (unsigned long)param));
	}

LOCAL void do_nuts(p)
GENERIC p;
	{
	}

void display_time(time, check)
unsigned long time;
unsigned long check;
	{
	if (time/1000 != check/1000)
		{
		sync_audio(do_display_time, do_nuts, (GENERIC)check);
		if (time > check)
			sync_audio(do_display_time, do_nuts, (GENERIC)(time - check));
		else
			sync_audio(do_display_time, do_nuts, (GENERIC)(check - time));
		}
	}
