# Q3 2020 Roadmap

Each quarter the team will highlight areas of focus for our work and upcoming research.
 
We select items to include in the roadmap from community issues and internal priorities. When community pull requests exist for an item, we will prioritize working with the original authors to include their contributions. If the author can no longer take on the implementation, HashiCorp may complete any additional work needed. 

Each release will include necessary tasks that lead to the completion of the stated goals as well as community pull requests, enhancements, and features that are not highlighted in the roadmap. 

To make contribution easier, we’ll be using the [`Help Wanted`](https://github.com/hashicorp/terraform-provider-kubernetes/issues?q=is%3Aopen+is%3Aissue+label%3A%22help+wanted%22) tag to point to issues we’d like to include in this quarter’s series of releases. Please review the [Contributing Guide](_about/CONTRIBUTING.md) for additional information.

This quarter (July-September ‘20) we will prioritize the following areas of work: 

## Currently In Progress

### 2.0.0 

Major version releases include code removals, deprecations, and breaking changes. A corresponding “upgrade guide” will be published alongside the release. 

In the 2.0.0 release we'll focus on three areas:
 - Upgrading to [Terraform Plugin SDK v2](https://www.terraform.io/docs/extend/guides/v2-upgrade-guide.html)
 - [Removing support for Terraform 0.11](https://github.com/hashicorp/terraform-provider-kubernetes/issues/905)
 - [Changing provider credentialling](https://github.com/hashicorp/terraform-provider-kubernetes/issues/909)

### Themes

To improve the provider, we plan to identify and focus on a set of themes each quarter that will address specific areas of the user experience. Here are the 3 themes we plan to work on this quarter.

#### Coverage

Issues: [theme/coverage](https://github.com/hashicorp/terraform-provider-kubernetes/issues?q=is%3Aopen+is%3Aissue+label%3Atheme%2Fcoverage)

Goal: Improve coverage of the Kubernetes API

While our goal for the Kubernetes provider is complete coverage of the Kubernetes API, this is more work than we can accomplish in one quarter.  Initially, we're prioritizing this work based on user feedback, but we'll also look at ways to address coverage gaps more proactively.

#### Lifecycle

Issues: [theme/lifecycle](https://github.com/hashicorp/terraform-provider-kubernetes/issues?q=is%3Aopen+is%3Aissue+label%3Atheme%2Flifecycle)

Goal: Lifecycle improvements to match user workflows

There are several requests to modify behavior based on Kubernetes lifecycle events, for example, waiting or not waiting for a pod to become ready before a deployment is considered complete. We’ll look at this and other areas where additional lifecycle controls make sense in the provider. 

#### Strech Goal: Errors

Issues: [theme/errors](https://github.com/hashicorp/terraform-provider-kubernetes/issues?q=is%3Aopen+is%3Aissue+label%3Atheme%2Ferrors)

Goal: Improve the error messages generated by the Kubernetes provider and clarify error messages that Kubernetes sends

While there aren't many open issues on this at the moment, one thing we consistently hear an ask for is better error messages.  We will take a holistic look at the error messages in the Kubernetes provider and try to clarify them where possible.

## Research Topics

Research topics include features, architectural changes, and ideas that we are pursuing in the longer term that may significantly impact the core user experience of the Kubernetes provider. Research topics are discovery only and are not guaranteed to be included in a future release.

### Kubernetes Manifest Resource

Issue: [#215](https://github.com/hashicorp/terraform-provider-kubernetes/issues/215)

We’ve been evaluating the best way to support custom resources in the Kubernetes provider. The [initial work](https://github.com/hashicorp/terraform-provider-kubernetes-alpha) led us to create a new provider with a single resource, called `kubernetes_manifest`. We did this because the functionality needed to accommodate the dynamic schema of custom resources wasn't available in the Terraform SDK.  

Now that the features we need are planned for a near-term SDK release, we're evaluating the feasibility of merging the Kubernetes-alpha manifest resource into the existing Kubernetes provider.

### Terraform-k8s Kubernetes Operator

Repo: [terraform-k8s](https://github.com/hashicorp/terraform-k8s)

In March 2020, we released an alpha version of the terraform-k8s [Kubernetes operator for Terraform Cloud](https://www.hashicorp.com/blog/creating-workspaces-with-the-hashicorp-terraform-operator-for-kubernetes/). Since then we've continued to [maintain and enhance](https://github.com/hashicorp/terraform-k8s/blob/master/CHANGELOG.md) the project, including adding basic support for Terraform Enterprise. We're currently evaluating where to take the operator next and we're actively seeking user feedback.

## Feedback

We are interested in your thoughts and feedback about these proposals and encourage you to comment on the issue linked above or [schedule time with @redeux](https://calendly.com/philsautter/30min) to discuss.

## Disclosures

The product-development initiatives in this document reflect HashiCorp's current plans and are subject to change and/or cancellation in HashiCorp's sole discretion.
