/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.proxy;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ExpiredNextTokenException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.GetRecordsRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.GetRecordsResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.InvalidArgumentException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.LimitExceededException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ListShardsRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ListShardsResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ResourceInUseException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ShardIteratorType;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamStatus;
import org.apache.flink.streaming.connectors.kinesis.model.StreamShardHandle;
import org.apache.flink.streaming.connectors.kinesis.proxy.GetShardListResult;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxyInterface;
import org.apache.flink.streaming.connectors.kinesis.util.AWSUtil;
import org.apache.flink.streaming.connectors.kinesis.util.KinesisConfigUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KinesisProxy
implements KinesisProxyInterface {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisProxy.class);
    private final AmazonKinesis kinesisClient;
    private static final Random seed = new Random();
    private final long listShardsBaseBackoffMillis;
    private final long listShardsMaxBackoffMillis;
    private final double listShardsExpConstant;
    private final int listShardsMaxRetries;
    private final long getRecordsBaseBackoffMillis;
    private final long getRecordsMaxBackoffMillis;
    private final double getRecordsExpConstant;
    private final int getRecordsMaxRetries;
    private final long getShardIteratorBaseBackoffMillis;
    private final long getShardIteratorMaxBackoffMillis;
    private final double getShardIteratorExpConstant;
    private final int getShardIteratorMaxRetries;
    private final long describeStreamBaseBackoffMillis;
    private final long describeStreamMaxBackoffMillis;
    private final double describeStreamExpConstant;

    protected KinesisProxy(Properties configProps) {
        Preconditions.checkNotNull((Object)configProps);
        KinesisConfigUtil.backfillConsumerKeys(configProps);
        this.kinesisClient = this.createKinesisClient(configProps);
        this.listShardsBaseBackoffMillis = Long.valueOf(configProps.getProperty("flink.list.shards.backoff.base", Long.toString(1000L)));
        this.listShardsMaxBackoffMillis = Long.valueOf(configProps.getProperty("flink.list.shards.backoff.max", Long.toString(5000L)));
        this.listShardsExpConstant = Double.valueOf(configProps.getProperty("flink.list.shards.backoff.expconst", Double.toString(1.5)));
        this.listShardsMaxRetries = Integer.valueOf(configProps.getProperty("flink.list.shards.maxretries", Long.toString(10L)));
        this.describeStreamBaseBackoffMillis = Long.valueOf(configProps.getProperty("flink.stream.describe.backoff.base", Long.toString(1000L)));
        this.describeStreamMaxBackoffMillis = Long.valueOf(configProps.getProperty("flink.stream.describe.backoff.max", Long.toString(5000L)));
        this.describeStreamExpConstant = Double.valueOf(configProps.getProperty("flink.stream.describe.backoff.expconst", Double.toString(1.5)));
        this.getRecordsBaseBackoffMillis = Long.valueOf(configProps.getProperty("flink.shard.getrecords.backoff.base", Long.toString(300L)));
        this.getRecordsMaxBackoffMillis = Long.valueOf(configProps.getProperty("flink.shard.getrecords.backoff.max", Long.toString(1000L)));
        this.getRecordsExpConstant = Double.valueOf(configProps.getProperty("flink.shard.getrecords.backoff.expconst", Double.toString(1.5)));
        this.getRecordsMaxRetries = Integer.valueOf(configProps.getProperty("flink.shard.getrecords.maxretries", Long.toString(3L)));
        this.getShardIteratorBaseBackoffMillis = Long.valueOf(configProps.getProperty("flink.shard.getiterator.backoff.base", Long.toString(300L)));
        this.getShardIteratorMaxBackoffMillis = Long.valueOf(configProps.getProperty("flink.shard.getiterator.backoff.max", Long.toString(1000L)));
        this.getShardIteratorExpConstant = Double.valueOf(configProps.getProperty("flink.shard.getiterator.backoff.expconst", Double.toString(1.5)));
        this.getShardIteratorMaxRetries = Integer.valueOf(configProps.getProperty("flink.shard.getiterator.maxretries", Long.toString(3L)));
    }

    protected AmazonKinesis createKinesisClient(Properties configProps) {
        ClientConfiguration awsClientConfig = new ClientConfigurationFactory().getConfig();
        AWSUtil.setAwsClientConfigProperties(awsClientConfig, configProps);
        return AWSUtil.createKinesisClient(configProps, awsClientConfig);
    }

    public static KinesisProxyInterface create(Properties configProps) {
        return new KinesisProxy(configProps);
    }

    @Override
    public GetRecordsResult getRecords(String shardIterator, int maxRecordsToGet) throws InterruptedException {
        GetRecordsRequest getRecordsRequest = new GetRecordsRequest();
        getRecordsRequest.setShardIterator(shardIterator);
        getRecordsRequest.setLimit(maxRecordsToGet);
        GetRecordsResult getRecordsResult = null;
        int retryCount = 0;
        while (retryCount <= this.getRecordsMaxRetries && getRecordsResult == null) {
            try {
                getRecordsResult = this.kinesisClient.getRecords(getRecordsRequest);
            }
            catch (SdkClientException ex) {
                if (this.isRecoverableSdkClientException(ex)) {
                    long backoffMillis = KinesisProxy.fullJitterBackoff(this.getRecordsBaseBackoffMillis, this.getRecordsMaxBackoffMillis, this.getRecordsExpConstant, retryCount++);
                    LOG.warn("Got recoverable SdkClientException. Backing off for " + backoffMillis + " millis (" + ex.getClass().getName() + ": " + ex.getMessage() + ")");
                    Thread.sleep(backoffMillis);
                    continue;
                }
                throw ex;
            }
        }
        if (getRecordsResult == null) {
            throw new RuntimeException("Retries exceeded for getRecords operation - all " + this.getRecordsMaxRetries + " retry attempts failed.");
        }
        return getRecordsResult;
    }

    @Override
    public GetShardListResult getShardList(Map<String, String> streamNamesWithLastSeenShardIds) throws InterruptedException {
        GetShardListResult result = new GetShardListResult();
        for (Map.Entry<String, String> streamNameWithLastSeenShardId : streamNamesWithLastSeenShardIds.entrySet()) {
            String stream = streamNameWithLastSeenShardId.getKey();
            String lastSeenShardId = streamNameWithLastSeenShardId.getValue();
            result.addRetrievedShardsToStream(stream, this.getShardsOfStream(stream, lastSeenShardId));
        }
        return result;
    }

    @Override
    public String getShardIterator(StreamShardHandle shard, String shardIteratorType, @Nullable Object startingMarker) throws InterruptedException {
        GetShardIteratorRequest getShardIteratorRequest = new GetShardIteratorRequest().withStreamName(shard.getStreamName()).withShardId(shard.getShard().getShardId()).withShardIteratorType(shardIteratorType);
        switch (ShardIteratorType.fromValue(shardIteratorType)) {
            case TRIM_HORIZON: 
            case LATEST: {
                break;
            }
            case AT_TIMESTAMP: {
                if (startingMarker instanceof Date) {
                    getShardIteratorRequest.setTimestamp((Date)startingMarker);
                    break;
                }
                throw new IllegalArgumentException("Invalid object given for GetShardIteratorRequest() when ShardIteratorType is AT_TIMESTAMP. Must be a Date object.");
            }
            case AT_SEQUENCE_NUMBER: 
            case AFTER_SEQUENCE_NUMBER: {
                if (startingMarker instanceof String) {
                    getShardIteratorRequest.setStartingSequenceNumber((String)startingMarker);
                    break;
                }
                throw new IllegalArgumentException("Invalid object given for GetShardIteratorRequest() when ShardIteratorType is AT_SEQUENCE_NUMBER or AFTER_SEQUENCE_NUMBER. Must be a String.");
            }
        }
        return this.getShardIterator(getShardIteratorRequest);
    }

    private String getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws InterruptedException {
        GetShardIteratorResult getShardIteratorResult = null;
        int retryCount = 0;
        while (retryCount <= this.getShardIteratorMaxRetries && getShardIteratorResult == null) {
            try {
                getShardIteratorResult = this.kinesisClient.getShardIterator(getShardIteratorRequest);
            }
            catch (AmazonServiceException ex) {
                if (KinesisProxy.isRecoverableException(ex)) {
                    long backoffMillis = KinesisProxy.fullJitterBackoff(this.getShardIteratorBaseBackoffMillis, this.getShardIteratorMaxBackoffMillis, this.getShardIteratorExpConstant, retryCount++);
                    LOG.warn("Got recoverable AmazonServiceException. Backing off for " + backoffMillis + " millis (" + ex.getClass().getName() + ": " + ex.getMessage() + ")");
                    Thread.sleep(backoffMillis);
                    continue;
                }
                throw ex;
            }
        }
        if (getShardIteratorResult == null) {
            throw new RuntimeException("Retries exceeded for getShardIterator operation - all " + this.getShardIteratorMaxRetries + " retry attempts failed.");
        }
        return getShardIteratorResult.getShardIterator();
    }

    protected boolean isRecoverableSdkClientException(SdkClientException ex) {
        if (ex instanceof AmazonServiceException) {
            return KinesisProxy.isRecoverableException((AmazonServiceException)ex);
        }
        return false;
    }

    protected static boolean isRecoverableException(AmazonServiceException ex) {
        if (ex.getErrorType() == null) {
            return false;
        }
        switch (ex.getErrorType()) {
            case Client: {
                return ex instanceof ProvisionedThroughputExceededException;
            }
            case Service: 
            case Unknown: {
                return true;
            }
        }
        return false;
    }

    private List<StreamShardHandle> getShardsOfStream(String streamName, @Nullable String lastSeenShardId) throws InterruptedException {
        ListShardsResult listShardsResult;
        ArrayList<StreamShardHandle> shardsOfStream = new ArrayList<StreamShardHandle>();
        String startShardToken = null;
        do {
            if ((listShardsResult = this.listShards(streamName, lastSeenShardId, startShardToken)) == null) {
                shardsOfStream.clear();
                return shardsOfStream;
            }
            List<Shard> shards = listShardsResult.getShards();
            for (Shard shard : shards) {
                shardsOfStream.add(new StreamShardHandle(streamName, shard));
            }
        } while ((startShardToken = listShardsResult.getNextToken()) != null);
        return shardsOfStream;
    }

    private ListShardsResult listShards(String streamName, @Nullable String startShardId, @Nullable String startNextToken) throws InterruptedException {
        ListShardsRequest listShardsRequest = new ListShardsRequest();
        if (startNextToken == null) {
            listShardsRequest.setExclusiveStartShardId(startShardId);
            listShardsRequest.setStreamName(streamName);
        } else {
            listShardsRequest.setNextToken(startNextToken);
        }
        ListShardsResult listShardsResults = null;
        int retryCount = 0;
        while (retryCount <= this.listShardsMaxRetries && listShardsResults == null) {
            long backoffMillis;
            try {
                listShardsResults = this.kinesisClient.listShards(listShardsRequest);
            }
            catch (LimitExceededException le) {
                backoffMillis = KinesisProxy.fullJitterBackoff(this.listShardsBaseBackoffMillis, this.listShardsMaxBackoffMillis, this.listShardsExpConstant, retryCount++);
                LOG.warn("Got LimitExceededException when listing shards from stream " + streamName + ". Backing off for " + backoffMillis + " millis.");
                Thread.sleep(backoffMillis);
            }
            catch (ResourceInUseException reInUse) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.info("The stream is currently not in active state. Reusing the older state for the time being");
                break;
            }
            catch (ResourceNotFoundException reNotFound) {
                throw new RuntimeException("Stream not found. Error while getting shard list.", reNotFound);
            }
            catch (InvalidArgumentException inArg) {
                throw new RuntimeException("Invalid Arguments to listShards.", inArg);
            }
            catch (ExpiredNextTokenException expiredToken) {
                LOG.warn("List Shards has an expired token. Reusing the previous state.");
                break;
            }
            catch (SdkClientException ex) {
                if (retryCount < this.listShardsMaxRetries && this.isRecoverableSdkClientException(ex)) {
                    backoffMillis = KinesisProxy.fullJitterBackoff(this.listShardsBaseBackoffMillis, this.listShardsMaxBackoffMillis, this.listShardsExpConstant, retryCount++);
                    LOG.warn("Got SdkClientException when listing shards from stream {}. Backing off for {} millis.", (Object)streamName, (Object)backoffMillis);
                    Thread.sleep(backoffMillis);
                    continue;
                }
                throw ex;
            }
        }
        if (startShardId != null && listShardsResults != null) {
            List<Shard> shards = listShardsResults.getShards();
            Iterator<Shard> shardItr = shards.iterator();
            while (shardItr.hasNext()) {
                if (StreamShardHandle.compareShardIds(shardItr.next().getShardId(), startShardId) > 0) continue;
                shardItr.remove();
            }
        }
        return listShardsResults;
    }

    protected DescribeStreamResult describeStream(String streamName, @Nullable String startShardId) throws InterruptedException {
        DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest();
        describeStreamRequest.setStreamName(streamName);
        describeStreamRequest.setExclusiveStartShardId(startShardId);
        DescribeStreamResult describeStreamResult = null;
        int attemptCount = 0;
        while (describeStreamResult == null) {
            try {
                describeStreamResult = this.kinesisClient.describeStream(describeStreamRequest);
            }
            catch (LimitExceededException le) {
                long backoffMillis = KinesisProxy.fullJitterBackoff(this.describeStreamBaseBackoffMillis, this.describeStreamMaxBackoffMillis, this.describeStreamExpConstant, attemptCount++);
                LOG.warn(String.format("Got LimitExceededException when describing stream %s. Backing off for %d millis.", streamName, backoffMillis));
                Thread.sleep(backoffMillis);
            }
            catch (ResourceNotFoundException re) {
                throw new RuntimeException("Error while getting stream details", re);
            }
        }
        String streamStatus = describeStreamResult.getStreamDescription().getStreamStatus();
        if (!streamStatus.equals(StreamStatus.ACTIVE.toString()) && !streamStatus.equals(StreamStatus.UPDATING.toString()) && LOG.isWarnEnabled()) {
            LOG.warn(String.format("The status of stream %s is %s ; result of the current describeStream operation will not contain any shard information.", streamName, streamStatus));
        }
        return describeStreamResult;
    }

    protected static long fullJitterBackoff(long base, long max, double power, int attempt) {
        long exponentialBackoff = (long)Math.min((double)max, (double)base * Math.pow(power, attempt));
        return (long)(seed.nextDouble() * (double)exponentialBackoff);
    }
}

