/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceResponse;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.Request;
import org.apache.flink.kinesis.shaded.com.amazonaws.Response;
import org.apache.flink.kinesis.shaded.com.amazonaws.ResponseMetadata;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.ThreadSafe;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.apache.flink.kinesis.shaded.com.amazonaws.client.AwsSyncClientParams;
import org.apache.flink.kinesis.shaded.com.amazonaws.handlers.HandlerChainFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.handlers.HandlerContextKey;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.DefaultErrorResponseHandler;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.ExecutionContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.HttpResponseHandler;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.StaxResponseHandler;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.StaticCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.metrics.RequestMetricCollector;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.AWSSecurityTokenServiceException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.GetFederationTokenResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.AssumeRoleRequestMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.AssumeRoleResultStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.AssumeRoleWithSAMLRequestMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.AssumeRoleWithSAMLResultStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.AssumeRoleWithWebIdentityRequestMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.AssumeRoleWithWebIdentityResultStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.DecodeAuthorizationMessageRequestMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.DecodeAuthorizationMessageResultStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.ExpiredTokenExceptionUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.GetCallerIdentityRequestMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.GetCallerIdentityResultStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.GetFederationTokenRequestMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.GetFederationTokenResultStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.GetSessionTokenRequestMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.GetSessionTokenResultStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.IDPCommunicationErrorExceptionUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.IDPRejectedClaimExceptionUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.InvalidAuthorizationMessageExceptionUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.InvalidIdentityTokenExceptionUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.MalformedPolicyDocumentExceptionUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.PackedPolicyTooLargeExceptionUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform.RegionDisabledExceptionUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.StandardErrorUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Unmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.AWSRequestMetrics;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.CredentialUtils;
import org.w3c.dom.Node;

@ThreadSafe
public class AWSSecurityTokenServiceClient
extends AmazonWebServiceClient
implements AWSSecurityTokenService {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSecurityTokenService.class);
    private static final String DEFAULT_SIGNING_NAME = "sts";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    @Deprecated
    public AWSSecurityTokenServiceClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSSecurityTokenServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSSecurityTokenServiceClientBuilder builder() {
        return AWSSecurityTokenServiceClientBuilder.standard();
    }

    AWSSecurityTokenServiceClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new InvalidAuthorizationMessageExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ExpiredTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PackedPolicyTooLargeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new RegionDisabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MalformedPolicyDocumentExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new IDPCommunicationErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidIdentityTokenExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new IDPRejectedClaimExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller(AWSSecurityTokenServiceException.class));
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("sts.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/org/apache/flink/kinesis/shaded/com/amazonaws/services/securitytoken/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/org/apache/flink/kinesis/shaded/com/amazonaws/services/securitytoken/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssumeRoleResult assumeRole(AssumeRoleRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssumeRole(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssumeRoleResult executeAssumeRole(AssumeRoleRequest assumeRoleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(assumeRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssumeRoleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssumeRoleRequestMarshaller().marshall(super.beforeMarshalling(assumeRoleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<AssumeRoleResult> responseHandler = new StaxResponseHandler<AssumeRoleResult>(new AssumeRoleResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssumeRoleResult assumeRoleResult = (AssumeRoleResult)response.getAwsResponse();
            return assumeRoleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssumeRoleWithSAMLResult assumeRoleWithSAML(AssumeRoleWithSAMLRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssumeRoleWithSAML(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssumeRoleWithSAMLResult executeAssumeRoleWithSAML(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(assumeRoleWithSAMLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssumeRoleWithSAMLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssumeRoleWithSAMLRequestMarshaller().marshall(super.beforeMarshalling(assumeRoleWithSAMLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<AssumeRoleWithSAMLResult> responseHandler = new StaxResponseHandler<AssumeRoleWithSAMLResult>(new AssumeRoleWithSAMLResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssumeRoleWithSAMLResult assumeRoleWithSAMLResult = (AssumeRoleWithSAMLResult)response.getAwsResponse();
            return assumeRoleWithSAMLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssumeRoleWithWebIdentityResult assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeAssumeRoleWithWebIdentity(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssumeRoleWithWebIdentityResult executeAssumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(assumeRoleWithWebIdentityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssumeRoleWithWebIdentityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssumeRoleWithWebIdentityRequestMarshaller().marshall(super.beforeMarshalling(assumeRoleWithWebIdentityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<AssumeRoleWithWebIdentityResult> responseHandler = new StaxResponseHandler<AssumeRoleWithWebIdentityResult>(new AssumeRoleWithWebIdentityResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssumeRoleWithWebIdentityResult assumeRoleWithWebIdentityResult = (AssumeRoleWithWebIdentityResult)response.getAwsResponse();
            return assumeRoleWithWebIdentityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DecodeAuthorizationMessageResult decodeAuthorizationMessage(DecodeAuthorizationMessageRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDecodeAuthorizationMessage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DecodeAuthorizationMessageResult executeDecodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(decodeAuthorizationMessageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DecodeAuthorizationMessageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DecodeAuthorizationMessageRequestMarshaller().marshall(super.beforeMarshalling(decodeAuthorizationMessageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<DecodeAuthorizationMessageResult> responseHandler = new StaxResponseHandler<DecodeAuthorizationMessageResult>(new DecodeAuthorizationMessageResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DecodeAuthorizationMessageResult decodeAuthorizationMessageResult = (DecodeAuthorizationMessageResult)response.getAwsResponse();
            return decodeAuthorizationMessageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCallerIdentityResult getCallerIdentity(GetCallerIdentityRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetCallerIdentity(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCallerIdentityResult executeGetCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCallerIdentityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCallerIdentityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCallerIdentityRequestMarshaller().marshall(super.beforeMarshalling(getCallerIdentityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<GetCallerIdentityResult> responseHandler = new StaxResponseHandler<GetCallerIdentityResult>(new GetCallerIdentityResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCallerIdentityResult getCallerIdentityResult = (GetCallerIdentityResult)response.getAwsResponse();
            return getCallerIdentityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFederationTokenResult getFederationToken(GetFederationTokenRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetFederationToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFederationTokenResult executeGetFederationToken(GetFederationTokenRequest getFederationTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFederationTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFederationTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFederationTokenRequestMarshaller().marshall(super.beforeMarshalling(getFederationTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<GetFederationTokenResult> responseHandler = new StaxResponseHandler<GetFederationTokenResult>(new GetFederationTokenResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFederationTokenResult getFederationTokenResult = (GetFederationTokenResult)response.getAwsResponse();
            return getFederationTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSessionTokenResult getSessionToken(GetSessionTokenRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetSessionToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSessionTokenResult executeGetSessionToken(GetSessionTokenRequest getSessionTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSessionTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSessionTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSessionTokenRequestMarshaller().marshall(super.beforeMarshalling(getSessionTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StaxResponseHandler<GetSessionTokenResult> responseHandler = new StaxResponseHandler<GetSessionTokenResult>(new GetSessionTokenResultStaxUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSessionTokenResult getSessionTokenResult = (GetSessionTokenResult)response.getAwsResponse();
            return getSessionTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSessionTokenResult getSessionToken() {
        return this.getSessionToken(new GetSessionTokenRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

