/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.Input;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform.InputParallelismJsonUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform.InputProcessingConfigurationJsonUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform.KinesisFirehoseInputJsonUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform.KinesisStreamsInputJsonUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisanalytics.model.transform.SourceSchemaJsonUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.JsonUnmarshallerContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class InputJsonUnmarshaller
implements Unmarshaller<Input, JsonUnmarshallerContext> {
    private static InputJsonUnmarshaller instance;

    @Override
    public Input unmarshall(JsonUnmarshallerContext context) throws Exception {
        Input input = new Input();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("NamePrefix", targetDepth)) {
                    context.nextToken();
                    input.setNamePrefix(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InputProcessingConfiguration", targetDepth)) {
                    context.nextToken();
                    input.setInputProcessingConfiguration(InputProcessingConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisStreamsInput", targetDepth)) {
                    context.nextToken();
                    input.setKinesisStreamsInput(KinesisStreamsInputJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("KinesisFirehoseInput", targetDepth)) {
                    context.nextToken();
                    input.setKinesisFirehoseInput(KinesisFirehoseInputJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputParallelism", targetDepth)) {
                    context.nextToken();
                    input.setInputParallelism(InputParallelismJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("InputSchema", targetDepth)) {
                    context.nextToken();
                    input.setInputSchema(SourceSchemaJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return input;
    }

    public static InputJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InputJsonUnmarshaller();
        }
        return instance;
    }
}

