/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.waiters.DescribeStreamFunction;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.waiters.StreamExists;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.waiters.StreamNotExists;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.PollingStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.Waiter;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.WaiterBuilder;

public class AmazonKinesisWaiters {
    private final AmazonKinesis client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonKinesisWaiters(AmazonKinesis client) {
        this.client = client;
    }

    public Waiter<DescribeStreamRequest> streamExists() {
        return new WaiterBuilder<DescribeStreamRequest, DescribeStreamResult>().withSdkFunction(new DescribeStreamFunction(this.client)).withAcceptors(new StreamExists.IsACTIVEMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(18), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStreamRequest> streamNotExists() {
        return new WaiterBuilder<DescribeStreamRequest, DescribeStreamResult>().withSdkFunction(new DescribeStreamFunction(this.client)).withAcceptors(new StreamNotExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(18), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

