/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.transform;

import java.util.Date;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.StreamDescription;

@SdkInternalApi
public class StreamDescriptionMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamARN").build();
    private static final MarshallingInfo<String> STREAMSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamStatus").build();
    private static final MarshallingInfo<List> SHARDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shards").build();
    private static final MarshallingInfo<Boolean> HASMORESHARDS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasMoreShards").build();
    private static final MarshallingInfo<Integer> RETENTIONPERIODHOURS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetentionPeriodHours").build();
    private static final MarshallingInfo<Date> STREAMCREATIONTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamCreationTimestamp").build();
    private static final MarshallingInfo<List> ENHANCEDMONITORING_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnhancedMonitoring").build();
    private static final MarshallingInfo<String> ENCRYPTIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionType").build();
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final StreamDescriptionMarshaller instance = new StreamDescriptionMarshaller();

    public static StreamDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(StreamDescription streamDescription, ProtocolMarshaller protocolMarshaller) {
        if (streamDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(streamDescription.getStreamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall(streamDescription.getStreamARN(), STREAMARN_BINDING);
            protocolMarshaller.marshall(streamDescription.getStreamStatus(), STREAMSTATUS_BINDING);
            protocolMarshaller.marshall(streamDescription.getShards(), SHARDS_BINDING);
            protocolMarshaller.marshall(streamDescription.getHasMoreShards(), HASMORESHARDS_BINDING);
            protocolMarshaller.marshall(streamDescription.getRetentionPeriodHours(), RETENTIONPERIODHOURS_BINDING);
            protocolMarshaller.marshall(streamDescription.getStreamCreationTimestamp(), STREAMCREATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall(streamDescription.getEnhancedMonitoring(), ENHANCEDMONITORING_BINDING);
            protocolMarshaller.marshall(streamDescription.getEncryptionType(), ENCRYPTIONTYPE_BINDING);
            protocolMarshaller.marshall(streamDescription.getKeyId(), KEYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

