/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.Date;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;

class InitialPositionInStreamExtended {
    private final InitialPositionInStream position;
    private final Date timestamp;

    private InitialPositionInStreamExtended(InitialPositionInStream position, Date timestamp) {
        this.position = position;
        this.timestamp = timestamp;
    }

    protected InitialPositionInStream getInitialPositionInStream() {
        return this.position;
    }

    protected Date getTimestamp() {
        return this.timestamp;
    }

    protected static InitialPositionInStreamExtended newInitialPosition(InitialPositionInStream position) {
        switch (position) {
            case LATEST: {
                return new InitialPositionInStreamExtended(InitialPositionInStream.LATEST, null);
            }
            case TRIM_HORIZON: {
                return new InitialPositionInStreamExtended(InitialPositionInStream.TRIM_HORIZON, null);
            }
        }
        throw new IllegalArgumentException("Invalid InitialPosition: " + (Object)((Object)position));
    }

    protected static InitialPositionInStreamExtended newInitialPositionAtTimestamp(Date timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Timestamp must be specified for InitialPosition AT_TIMESTAMP");
        }
        return new InitialPositionInStreamExtended(InitialPositionInStream.AT_TIMESTAMP, timestamp);
    }
}

