/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec;

import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.Immutable;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.PathElement;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.SubstitutionContext;

@Immutable
final class ArrayIndexElement
extends PathElement {
    private final int index;

    public ArrayIndexElement(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Invalid array index: " + index);
        }
        this.index = index;
    }

    public String toString() {
        return "[" + this.index + "]";
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayIndexElement)) {
            return false;
        }
        return this.index == ((ArrayIndexElement)obj).index;
    }

    @Override
    String asNestedPath() {
        return "[" + this.index + "]";
    }

    @Override
    String asToken(SubstitutionContext context) {
        throw new IllegalStateException();
    }

    @Override
    String asNestedToken(SubstitutionContext context) {
        return this.asNestedPath();
    }
}

