/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.TableDescription;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.TableStatus;

public class TableUtils {
    private static final int DEFAULT_WAIT_TIMEOUT = 600000;
    private static final int DEFAULT_WAIT_INTERVAL = 20000;
    private static final Log LOG = LogFactory.getLog(TableUtils.class);

    public static void waitUntilExists(AmazonDynamoDB dynamo, String tableName) throws InterruptedException {
        TableUtils.waitUntilExists(dynamo, tableName, 600000, 20000);
    }

    public static void waitUntilExists(AmazonDynamoDB dynamo, String tableName, int timeout, int interval) throws InterruptedException {
        TableDescription table = TableUtils.waitForTableDescription(dynamo, tableName, null, timeout, interval);
        if (table == null) {
            throw new SdkClientException("Table " + tableName + " never returned a result");
        }
    }

    public static void waitUntilActive(AmazonDynamoDB dynamo, String tableName) throws InterruptedException, TableNeverTransitionedToStateException {
        TableUtils.waitUntilActive(dynamo, tableName, 600000, 20000);
    }

    public static void waitUntilActive(AmazonDynamoDB dynamo, String tableName, int timeout, int interval) throws InterruptedException, TableNeverTransitionedToStateException {
        TableDescription table = TableUtils.waitForTableDescription(dynamo, tableName, TableStatus.ACTIVE, timeout, interval);
        if (table == null || !table.getTableStatus().equals(TableStatus.ACTIVE.toString())) {
            throw new TableNeverTransitionedToStateException(tableName, TableStatus.ACTIVE);
        }
    }

    private static TableDescription waitForTableDescription(AmazonDynamoDB dynamo, String tableName, TableStatus desiredStatus, int timeout, int interval) throws InterruptedException, IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        if (interval <= 0 || interval >= timeout) {
            throw new IllegalArgumentException("Interval must be > 0 and < timeout");
        }
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        TableDescription table = null;
        while (System.currentTimeMillis() < endTime) {
            try {
                table = dynamo.describeTable(new DescribeTableRequest(tableName)).getTable();
                if (desiredStatus == null || table.getTableStatus().equals(desiredStatus.toString())) {
                    return table;
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
            Thread.sleep(interval);
        }
        return table;
    }

    public static final boolean createTableIfNotExists(AmazonDynamoDB dynamo, CreateTableRequest createTableRequest) {
        try {
            dynamo.createTable(createTableRequest);
            return true;
        }
        catch (ResourceInUseException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Table " + createTableRequest.getTableName() + " already exists", e);
            }
            return false;
        }
    }

    public static final boolean deleteTableIfExists(AmazonDynamoDB dynamo, DeleteTableRequest deleteTableRequest) {
        try {
            dynamo.deleteTable(deleteTableRequest);
            return true;
        }
        catch (ResourceNotFoundException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Table " + deleteTableRequest.getTableName() + " does not exist", e);
            }
            return false;
        }
    }

    public static class TableNeverTransitionedToStateException
    extends SdkClientException {
        private static final long serialVersionUID = 8920567021104846647L;

        public TableNeverTransitionedToStateException(String tableName, TableStatus desiredStatus) {
            super("Table " + tableName + " never transitioned to desired state of " + desiredStatus.toString());
        }
    }
}

