/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter;

import java.util.concurrent.ExecutorService;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsProxy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;

public class StreamsWorkerFactory {
    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, ExecutorService execService) {
        AmazonDynamoDBStreamsAdapterClient streamsClient = new AmazonDynamoDBStreamsAdapterClient(config.getKinesisCredentialsProvider(), config.getKinesisClientConfiguration());
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).execService(execService).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient(cloudWatchClient).execService(execService).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDB dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).metricsFactory(metricsFactory).execService(execService).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient((AmazonCloudWatch)cloudWatchClient).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).cloudWatchClient((AmazonCloudWatch)cloudWatchClient).execService(execService).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    public static Worker createDynamoDbStreamsWorker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient, AmazonDynamoDBClient dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        return new Worker.Builder().recordProcessorFactory(recordProcessorFactory).config(config).kinesisClient(streamsClient).dynamoDBClient(dynamoDBClient).metricsFactory(metricsFactory).execService(execService).kinesisProxy(StreamsWorkerFactory.getDynamoDBStreamsProxy(config, streamsClient)).shardPrioritization(config.getShardPrioritizationStrategy()).build();
    }

    private static DynamoDBStreamsProxy getDynamoDBStreamsProxy(KinesisClientLibConfiguration config, AmazonDynamoDBStreamsAdapterClient streamsClient) {
        return new DynamoDBStreamsProxy.Builder(config.getStreamName(), config.getKinesisCredentialsProvider(), streamsClient).build();
    }
}

