/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.AttributeTransformer;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;

public class AttributeTransformerChain
implements AttributeTransformer {
    private final List<AttributeTransformer> transformers;

    public AttributeTransformerChain(AttributeTransformer ... transformers) {
        this(Arrays.asList(transformers));
    }

    public AttributeTransformerChain(List<AttributeTransformer> transformers) {
        this.transformers = Collections.unmodifiableList(new ArrayList<AttributeTransformer>(transformers));
    }

    public List<AttributeTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    public Map<String, AttributeValue> transform(AttributeTransformer.Parameters<?> parameters) {
        ProxyParameters proxy = new ProxyParameters(parameters);
        for (int i2 = 0; i2 < this.transformers.size(); ++i2) {
            proxy.setAttributeValues(this.transformers.get(i2).transform(proxy));
        }
        return proxy.getAttributeValues();
    }

    @Override
    public Map<String, AttributeValue> untransform(AttributeTransformer.Parameters<?> parameters) {
        ProxyParameters proxy = new ProxyParameters(parameters);
        for (int i2 = this.transformers.size() - 1; i2 >= 0; --i2) {
            proxy.setAttributeValues(this.transformers.get(i2).untransform(proxy));
        }
        return proxy.getAttributeValues();
    }

    public String toString() {
        return this.transformers.toString();
    }

    private static class ProxyParameters<T>
    implements AttributeTransformer.Parameters<T> {
        private final AttributeTransformer.Parameters<T> delegate;
        private Map<String, AttributeValue> values;

        public ProxyParameters(AttributeTransformer.Parameters<T> delegate) {
            this.delegate = delegate;
            this.values = delegate.getAttributeValues();
        }

        @Override
        public Map<String, AttributeValue> getAttributeValues() {
            return this.values;
        }

        public void setAttributeValues(Map<String, AttributeValue> values) {
            this.values = Collections.unmodifiableMap(values);
        }

        @Override
        public boolean isPartialUpdate() {
            return this.delegate.isPartialUpdate();
        }

        @Override
        public Class<T> getModelClass() {
            return this.delegate.getModelClass();
        }

        @Override
        public DynamoDBMapperConfig getMapperConfig() {
            return this.delegate.getMapperConfig();
        }

        @Override
        public String getTableName() {
            return this.delegate.getTableName();
        }

        @Override
        public String getHashKeyName() {
            return this.delegate.getHashKeyName();
        }

        @Override
        public String getRangeKeyName() {
            return this.delegate.getRangeKeyName();
        }
    }
}

