/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceResponse;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.Request;
import org.apache.flink.kinesis.shaded.com.amazonaws.Response;
import org.apache.flink.kinesis.shaded.com.amazonaws.ResponseMetadata;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.ThreadSafe;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.apache.flink.kinesis.shaded.com.amazonaws.client.AwsSyncClientParams;
import org.apache.flink.kinesis.shaded.com.amazonaws.handlers.HandlerChainFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.handlers.HandlerContextKey;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.ExecutionContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.HttpResponseHandler;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.StaticCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.metrics.RequestMetricCollector;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.json.JsonClientMetadata;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.json.JsonOperationMetadata;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClientBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AmazonDynamoDBException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeStreamResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ExpiredIteratorException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetRecordsRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetRecordsResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetShardIteratorRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GetShardIteratorResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.InternalServerErrorException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.LimitExceededException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ListStreamsResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.TrimmedDataAccessException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.DescribeStreamRequestProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.DescribeStreamResultJsonUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.GetRecordsRequestProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.GetRecordsResultJsonUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.GetShardIteratorRequestProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.GetShardIteratorResultJsonUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.ListStreamsRequestProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform.ListStreamsResultJsonUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.AWSRequestMetrics;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.CredentialUtils;

@ThreadSafe
public class AmazonDynamoDBStreamsClient
extends AmazonWebServiceClient
implements AmazonDynamoDBStreams {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonDynamoDBStreams.class);
    private static final String DEFAULT_SIGNING_NAME = "dynamodb";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TrimmedDataAccessException").withModeledClass(TrimmedDataAccessException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ExpiredIteratorException").withModeledClass(ExpiredIteratorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AmazonDynamoDBException.class));

    @Deprecated
    public AmazonDynamoDBStreamsClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonDynamoDBStreamsClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonDynamoDBStreamsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonDynamoDBStreamsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonDynamoDBStreamsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonDynamoDBStreamsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonDynamoDBStreamsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonDynamoDBStreamsClientBuilder builder() {
        return AmazonDynamoDBStreamsClientBuilder.standard();
    }

    AmazonDynamoDBStreamsClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("streams.dynamodb");
        this.setEndpoint("https://streams.dynamodb.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/org/apache/flink/kinesis/shaded/com/amazonaws/services/dynamodbv2/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/org/apache/flink/kinesis/shaded/com/amazonaws/services/dynamodbv2/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DescribeStreamResult describeStream(DescribeStreamRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeStreamResult executeDescribeStream(DescribeStreamRequest describeStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeStreamRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeStreamResult describeStreamResult = (DescribeStreamResult)response.getAwsResponse();
            return describeStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecordsResult getRecords(GetRecordsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecordsResult executeGetRecords(GetRecordsRequest getRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecordsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecordsResult getRecordsResult = (GetRecordsResult)response.getAwsResponse();
            return getRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetShardIteratorResult getShardIterator(GetShardIteratorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetShardIterator(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetShardIteratorResult executeGetShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getShardIteratorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetShardIteratorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetShardIteratorRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getShardIteratorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetShardIteratorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetShardIteratorResult getShardIteratorResult = (GetShardIteratorResult)response.getAwsResponse();
            return getShardIteratorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListStreamsResult listStreams(ListStreamsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListStreams(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListStreamsResult executeListStreams(ListStreamsRequest listStreamsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStreamsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStreamsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStreamsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listStreamsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListStreamsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListStreamsResult listStreamsResult = (ListStreamsResult)response.getAwsResponse();
            return listStreamsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

