#include <stdlib.h>
#include <string.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#define YYPREFIX "yy"
#line 22 "/home/op/w/telescope/parse.y"

#include "compat.h"

#include <assert.h>
#include <ctype.h>
#include <limits.h>
#include <ncurses.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cmd.h"
#include "defaults.h"
#include "iri.h"
#include "keymap.h"
#include "telescope.h"
#include "utils.h"
#include "xwrapper.h"

typedef struct {
	union {
		char	*str;
		int	 num;
	};
	int lineno;
	int colno;
} yystype;
#define YYSTYPE yystype

static char *current_style;
static int color_type;

static const char *path;

FILE *yyfp;

int parse_errors = 0;

static void yyerror(const char *, ...);
static int yylex(void);
static void setprfx(const char *, const char *);
static void setvari(char *, int);
static void setvars(char *, char *);
static void setvarb(char *, int);
static int colorname(const char *);
static void setcolor(const char *, const char *, const char *);
static int attrname(const char *);
static void setattr(char *, char *, char *);
static void add_proxy(char *, char *);
static void bindkey(const char *, const char *, const char *);
static void do_parseconfig(const char *, int);

#line 67 "parse.c"
#define ATTR 257
#define BIND 258
#define BG 259
#define CONT 260
#define FG 261
#define PRFX 262
#define PROXY 263
#define SET 264
#define STYLE 265
#define UNBIND 266
#define VIA 267
#define TOK_TRUE 268
#define TOK_FALSE 269
#define STRING 270
#define NUMBER 271
#define YYERRCODE 256
const short yylhs[] =
	{                                        -1,
    0,    0,    0,    0,    1,    1,    2,    2,    2,    2,
    2,    3,    3,    3,    9,    4,    8,    8,   12,   12,
   10,   10,   14,   10,   15,   10,   10,   13,   13,   13,
   16,   16,   16,    5,    6,    7,   11,   11,
};
const short yylen[] =
	{                                         2,
    0,    2,    3,    2,    1,    1,    1,    1,    1,    1,
    1,    4,    4,    4,    0,    4,    1,    4,    0,    3,
    2,    3,    0,    3,    0,    3,    2,    1,    2,    3,
    1,    2,    3,    4,    3,    4,    2,    0,
};
const short yydefred[] =
	{                                      0,
    0,    0,    4,    0,    0,    0,    0,    0,    2,    0,
    7,    8,    9,   10,   11,    0,    0,    0,   15,    0,
    3,    0,    0,    0,    0,   35,   34,   36,    5,    6,
   12,   13,   14,    0,   23,   25,    0,    0,   16,   17,
    0,   27,    0,    0,    0,    0,   19,    0,    0,   24,
   26,   22,   37,    0,   33,    0,   18,    0,   30,   20,
};
const short yydgoto[] =
	{                                       2,
   33,   10,   11,   12,   13,   14,   15,   39,   25,   40,
   47,   54,   50,   43,   44,   42,
};
const short yysindex[] =
	{                                   -253,
   -6,  -10,    0, -260, -258, -255, -254, -252,    0,    7,
    0,    0,    0,    0,    0, -250, -245,  -38,    0, -246,
    0, -244, -242, -262, -118,    0,    0,    0,    0,    0,
    0,    0,    0, -241,    0,    0, -240,   15,    0,    0,
 -239,    0, -238, -238, -236,   15,    0, -235, -234,    0,
    0,    0,    0, -112,    0, -233,    0,   15,    0,    0,};
const short yyrindex[] =
	{                                      1,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -106,    0,    0,
   11,    0,    0,    0,   17, -106,    0,   23,   29,    0,
    0,    0,    0,    0,    0,   35,    0, -106,    0,    0,};
const short yygindex[] =
	{                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  -16,
  -44,    0,   -4,    0,    0,    0,
};
#define YYTABLESIZE 297
const short yytable[] =
	{                                       9,
    1,   53,    1,    3,   38,   29,   30,   31,   32,   16,
    1,   17,   57,   60,   18,   19,   21,   20,   38,   22,
   31,   23,   24,   26,   46,   27,   21,   28,   41,   45,
   48,   49,   32,   52,   55,   56,   59,   58,   28,   51,
    0,    0,    0,    0,   29,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   31,    0,    0,   34,    0,
   35,   21,   36,   37,   34,    0,   35,   32,   36,   37,
   38,    0,   38,   28,   38,   38,    0,    0,    0,   29,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    4,    0,    0,
    0,    0,    5,    6,    7,    8,    0,    0,    1,    0,
    0,    0,    0,    1,    1,    1,    1,   31,    0,   31,
    0,   31,   31,   21,    0,   21,    0,   21,   21,   32,
    0,   32,    0,   32,   32,   28,    0,   28,    0,   28,
   28,   29,    0,   29,    0,   29,   29,
};
const short yycheck[] =
	{                                      10,
    0,   46,  256,   10,  123,  268,  269,  270,  271,  270,
   10,  270,  125,   58,  270,  270,   10,  270,  125,  270,
   10,  267,   61,  270,   10,  270,   10,  270,  270,  270,
  270,  270,   10,  270,  270,  270,  270,   54,   10,   44,
   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1,  257,   -1,
  259,  125,  261,  262,  257,   -1,  259,  125,  261,  262,
  257,   -1,  259,  125,  261,  262,   -1,   -1,   -1,  125,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  258,   -1,   -1,
   -1,   -1,  263,  264,  265,  266,   -1,   -1,  258,   -1,
   -1,   -1,   -1,  263,  264,  265,  266,  257,   -1,  259,
   -1,  261,  262,  257,   -1,  259,   -1,  261,  262,  257,
   -1,  259,   -1,  261,  262,  257,   -1,  259,   -1,  261,
  262,  257,   -1,  259,   -1,  261,  262,
};
#define YYFINAL 2
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 271
#if YYDEBUG
const char * const yyname[] =
	{
"end-of-file",0,0,0,0,0,0,0,0,0,"'\\n'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'='",0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"ATTR","BIND",
"BG","CONT","FG","PRFX","PROXY","SET","STYLE","UNBIND","VIA","TOK_TRUE",
"TOK_FALSE","STRING","NUMBER",
};
const char * const yyrule[] =
	{"$accept : grammar",
"grammar :",
"grammar : grammar '\\n'",
"grammar : grammar rule '\\n'",
"grammar : error '\\n'",
"bool : TOK_TRUE",
"bool : TOK_FALSE",
"rule : set",
"rule : style",
"rule : bind",
"rule : unbind",
"rule : proxy",
"set : SET STRING '=' STRING",
"set : SET STRING '=' NUMBER",
"set : SET STRING '=' bool",
"$$1 :",
"style : STYLE STRING $$1 stylespec",
"stylespec : styleopt",
"stylespec : '{' optnl styleopts '}'",
"styleopts :",
"styleopts : styleopts styleopt optnl",
"styleopt : PRFX STRING",
"styleopt : PRFX STRING STRING",
"$$2 :",
"styleopt : BG $$2 colorspec",
"$$3 :",
"styleopt : FG $$3 colorspec",
"styleopt : ATTR attr",
"colorspec : STRING",
"colorspec : STRING STRING",
"colorspec : STRING STRING STRING",
"attr : STRING",
"attr : STRING STRING",
"attr : STRING STRING STRING",
"bind : BIND STRING STRING STRING",
"unbind : UNBIND STRING STRING",
"proxy : PROXY STRING VIA STRING",
"optnl : '\\n' optnl",
"optnl :",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
/* LINTUSED */
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
unsigned int yystacksize;
int yyparse(void);
#line 158 "/home/op/w/telescope/parse.y"

void
yyerror(const char *fmt, ...)
{
	va_list va;

	fprintf(stderr, "%s:%d ", path, yylval.lineno+1);
	va_start(va, fmt);
	vfprintf(stderr, fmt, va);
	va_end(va);
	fprintf(stderr, "\n");
	parse_errors++;
}

static struct keyword {
	const char *word;
	int token;
} keywords[] = {
	{ "attr", ATTR },
	{ "bg", BG },
	{ "bind", BIND },
	{ "cont", CONT },
	{ "false", TOK_FALSE },
	{ "fg", FG },
	{ "prefix", PRFX },
	{ "proxy", PROXY },
	{ "set", SET },
	{ "style", STYLE },
	{ "true", TOK_TRUE },
	{ "unbind", UNBIND },
	{ "via", VIA },
};

int
yylex(void)
{
	char buf[1024], *ebuf, *p, *str;
	const char *errstr;
	int c, quotes = 0, escape = 0, qpos = -1, nonkw = 0;
	size_t i;

	p = buf;
	ebuf = buf + sizeof(buf);

repeat:
	/* skip whitespace first */
	for (c = getc(yyfp); c == ' ' || c == '\t' || c == '\f'; c = getc(yyfp))
		yylval.colno++;

	/* check for special one-character constructions */
	switch (c) {
	case '\r':
		/* silently eat up any \r */
		goto repeat;
	case '\n':
		yylval.colno = 0;
		yylval.lineno++;
		/* fallthrough */
	case '{':
	case '}':
	case '=':
		return c;
	case '#':
		/* skip comments; NUL is allowed; no continuation */
		while ((c = getc(yyfp)) != '\n')
			if (c == EOF)
				goto eof;
		yylval.colno = 0;
		yylval.lineno++;
		return c;
	case EOF:
		goto eof;
	}

	/* parsing next word */
	for (;; c = getc(yyfp), yylval.colno++) {
		switch (c) {
		case '\0':
			yyerror("unallowed character NULL in column %d",
			    yylval.colno+1);
			escape = 0;
			continue;
		case '\\':
			escape = !escape;
			if (escape)
				continue;
			break;
		case '\r':
			/* ignore \r here too */
			continue;
		case '\n':
			if (quotes)
				yyerror("unterminated quotes in column %d",
				    yylval.colno+1);
			if (escape) {
				nonkw = 1;
				escape = 0;
				yylval.colno = 0;
				yylval.lineno++;
			}
			goto eow;
		case EOF:
			if (escape)
				yyerror("unterminated escape in column %d",
				    yylval.colno);
			if (quotes)
				yyerror("unterminated quotes in column %d",
				    qpos + 1);
			goto eow;
		case '{':
		case '}':
		case '=':
		case '#':
		case ' ':
		case '\t':
			if (!escape && !quotes)
				goto eow;
			break;
		case '"':
			if (!escape) {
				quotes = !quotes;
				if (quotes) {
					nonkw = 1;
					qpos = yylval.colno;
				}
				continue;
			}
		}
		*p++ = c;
		if (p == ebuf) {
			yyerror("line too long");
			p = buf;
		}
		escape = 0;
	}

eow:
	*p = 0;
	if (c != EOF)
		ungetc(c, yyfp);
	if (p == buf) {
		/*
		 * There could be a number of reason for empty buffer,
		 * and we handle all of them here, to avoid cluttering
		 * the main loop.
		 */
		if (c == EOF)
			goto eof;
		else if (qpos == -1) /* accept, e.g., empty args: cmd foo args "" */
			goto repeat;
	}
	if (!nonkw) {
		for (i = 0; i < sizeof(keywords) / sizeof(keywords[0]); i++) {
			if (strcmp(buf, keywords[i].word) == 0)
				return keywords[i].token;
		}
	}
	c = *buf;
	if (!nonkw && (c == '-' || isdigit(c))) {
		yylval.num = strtonum(buf, INT_MIN, INT_MAX, &errstr);
		if (errstr != NULL)
			yyerror("number is %s: %s", errstr, buf);
		return NUMBER;
	}
	str = xstrdup(buf);
	yylval.str = str;
	return STRING;

eof:
	if (ferror(yyfp))
		yyerror("input error reading config");
	return 0;
}

static void
setprfx(const char *prfx, const char *cont)
{
	assert(current_style != NULL);

	if (!config_setprfx(current_style, prfx, cont))
		yyerror("invalid style %s", current_style);
}

static void
setvari(char *var, int val)
{
	/*
	 * For some time, fall back to a boolean as compat
	 * with telescope 0.8 and previous.
	 */
	if (!config_setvari(var, val) &&
	    !config_setvarb(var, val))
		yyerror("invalid variable or value: %s = %d",
		    var, val);

	free(var);
}

static void
setvars(char *var, char *val)
{
	if (!config_setvars(var, val))
		yyerror("invalid variable or value: %s = \"%s\"",
		    var, val);

	free(var);
}

static void
setvarb(char *var, int val)
{
	if (!config_setvarb(var, val))
		yyerror("invalid variable or value: %s = %s",
		    var, val ? "true" : "false");

	free(var);
}

static int
colorname(const char *name)
{
	struct {
		const char	*name;
		short		 val;
	} *i, colors[] = {
		{ "default",	-1 },
		{ "black",	COLOR_BLACK },
		{ "red",	COLOR_RED },
		{ "green",	COLOR_GREEN },
		{ "yellow",	COLOR_YELLOW },
		{ "blue",	COLOR_BLUE },
		{ "magenta",	COLOR_MAGENTA },
		{ "cyan",	COLOR_CYAN },
		{ "white",	COLOR_WHITE },
		{ NULL, 0 },
	};
	const char *errstr;
	int n;

	if (!strncmp(name, "colo", 4)) {
		/* people are strange */
		if (!strncmp(name, "color", 5))
			name += 5;
		else if (!strncmp(name, "colour", 6))
			name += 6;
		else
			goto err;

		n = strtonum(name, 0, 256, &errstr);
		if (errstr != NULL)
			yyerror("color number is %s: %s", errstr, name);
		return n;
	}

	for (i = colors; i->name != NULL; ++i) {
		if (!strcmp(i->name, name))
			return i->val;
	}

err:
	yyerror("unknown color name \"%s\"", name);
	return -1;
}

void
setcolor(const char *prfx, const char *line, const char *trail)
{
	int p, l, t;

	assert(current_style != NULL);

	p = colorname(prfx);
	l = colorname(line);
	t = colorname(trail);

	if (!config_setcolor(color_type == BG, current_style, p, l, t))
		yyerror("invalid style %s", current_style);
}

static int
attrname(const char *n)
{
	struct {
		const char	*name;
		unsigned int	 val;
	} *i, attrs[] = {
		{ "normal",	A_NORMAL },
		{ "standout",	A_STANDOUT },
		{ "underline",	A_UNDERLINE },
		{ "reverse",	A_REVERSE },
		{ "blink",	A_BLINK },
		{ "dim",	A_DIM },
		{ "bold",	A_BOLD },
		{ NULL, 0 },
	};
	int ret, found;
	char *ap, *dup, *orig;

	dup = xstrdup(n);

	orig = dup;

	ret = 0;
	while ((ap = strsep(&dup, ",")) != NULL) {
		if (*ap == '\0')
			continue;

		found = 0;
		for (i = attrs; i ->name != NULL; ++i) {
			if (strcmp(i->name, ap))
				continue;
			ret |= i->val;
			found = 1;
			break;
		}

		if (!found)
			yyerror("unknown attribute \"%s\" at col %d",
			    ap, yylval.colno+1);
	}

	free(orig);
	return ret;
}

static void
setattr(char *prfx, char *line, char *trail)
{
	int p, l, t;

	assert(current_style != NULL);

	p = attrname(prfx);
	l = attrname(line);
	t = attrname(trail);

	if (!config_setattr(current_style, p, l, t))
		yyerror("invalid style %s", current_style);
}

static void
add_proxy(char *proto, char *proxy)
{
	static struct iri iri;
	struct proxy *p;

	if (iri_parse(NULL, proxy, &iri) == -1) {
		yyerror("can't parse URL: %s", proxy);
		return;
	}

	if ((iri.iri_flags & (IH_QUERY|IH_FRAGMENT)) ||
	    iri.iri_path[0] != '\0') {
		yyerror("proxy url can't have path, query or fragments");
		return;
	}

	if (strcmp(iri.iri_scheme, "gemini")) {
		yyerror("disallowed proxy protocol %s", iri.iri_scheme);
		return;
	}

	p = xcalloc(1, sizeof(*p));

	p->match_proto = proto;
	p->proto = PROTO_GEMINI;

	p->host = xstrdup(iri.iri_host);

	p->port = xstrdup(iri.iri_portstr);

	TAILQ_INSERT_HEAD(&proxies, p, proxies);
}

static interactivefn *
cmdname(const char *name)
{
	struct cmd *cmd;

	for (cmd = cmds; cmd->cmd != NULL; ++cmd) {
		if (!strcmp(cmd->cmd, name))
			return cmd->fn;
	}

	return NULL;
}

static void
bindkey(const char *map, const char *key, const char *cmd)
{
	struct kmap *kmap;
	interactivefn *fn;

	if (!strcmp(map, "global-map"))
		kmap = &global_map;
	else if (!strcmp(map, "minibuffer-map"))
		kmap = &minibuffer_map;
	else {
		yyerror("unknown map: %s", map);
		return;
	}

	if ((fn = cmdname(cmd)) == NULL) {
		yyerror("unknown cmd: %s", fn);
		return;
	}

	if (!kmap_define_key(kmap, key, fn))
		yyerror("failed to bind %s %s %s", map, key, cmd);
}

static void
do_parseconfig(const char *filename, int fonf)
{
	if ((yyfp = fopen(filename, "r")) == NULL) {
		if (fonf)
			err(1, "%s", filename);
		return;
	}

	path = filename;
	yyparse();
	fclose(yyfp);
	if (parse_errors)
		exit(1);
}

void
parseconfig(const char *filename, int fonf)
{
	char altconf[PATH_MAX], *term;

	/* load the given config file */
	do_parseconfig(filename, fonf);

	/* then try to load file-TERM */

	if ((term = getenv("TERM")) == NULL)
		return;

	strlcpy(altconf, filename, sizeof(altconf));
	strlcat(altconf, "-", sizeof(altconf));
	strlcat(altconf, term, sizeof(altconf));

	do_parseconfig(altconf, 0);
}
#line 725 "parse.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(void)
{
    unsigned int newsize;
    long sslen;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    sslen = yyssp - yyss;
#ifdef SIZE_MAX
#define YY_SIZE_MAX SIZE_MAX
#else
#define YY_SIZE_MAX 0xffffffffU
#endif
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newss)
        goto bail;
    newss = (short *)realloc(yyss, newsize * sizeof *newss);
    if (newss == NULL)
        goto bail;
    yyss = newss;
    yyssp = newss + sslen;
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newvs)
        goto bail;
    newvs = (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs);
    if (newvs == NULL)
        goto bail;
    yyvs = newvs;
    yyvsp = newvs + sslen;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
bail:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return -1;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse(void)
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif /* YYDEBUG */

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yyvsp[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 5:
#line 101 "/home/op/w/telescope/parse.y"
{ yyval.num = 1; }
break;
case 6:
#line 102 "/home/op/w/telescope/parse.y"
{ yyval.num = 0; }
break;
case 8:
#line 106 "/home/op/w/telescope/parse.y"
{
			free(current_style);
			current_style = NULL;
		}
break;
case 12:
#line 115 "/home/op/w/telescope/parse.y"
{ setvars(yyvsp[-2].str, yyvsp[0].str); }
break;
case 13:
#line 116 "/home/op/w/telescope/parse.y"
{ setvari(yyvsp[-2].str, yyvsp[0].num); }
break;
case 14:
#line 117 "/home/op/w/telescope/parse.y"
{ setvarb(yyvsp[-2].str, yyvsp[0].num); }
break;
case 15:
#line 120 "/home/op/w/telescope/parse.y"
{ current_style = yyvsp[0].str; }
break;
case 21:
#line 127 "/home/op/w/telescope/parse.y"
{ setprfx(yyvsp[0].str, yyvsp[0].str); }
break;
case 22:
#line 128 "/home/op/w/telescope/parse.y"
{ setprfx(yyvsp[-1].str, yyvsp[0].str); }
break;
case 23:
#line 129 "/home/op/w/telescope/parse.y"
{ color_type = BG; }
break;
case 25:
#line 130 "/home/op/w/telescope/parse.y"
{ color_type = FG; }
break;
case 28:
#line 134 "/home/op/w/telescope/parse.y"
{ setcolor(yyvsp[0].str, yyvsp[0].str, yyvsp[0].str); free(yyvsp[0].str); }
break;
case 29:
#line 135 "/home/op/w/telescope/parse.y"
{ setcolor(yyvsp[-1].str, yyvsp[0].str, yyvsp[-1].str); free(yyvsp[-1].str); free(yyvsp[0].str); }
break;
case 30:
#line 136 "/home/op/w/telescope/parse.y"
{ setcolor(yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); free(yyvsp[-2].str); free(yyvsp[-1].str); free(yyvsp[0].str); }
break;
case 31:
#line 139 "/home/op/w/telescope/parse.y"
{ setattr(yyvsp[0].str, yyvsp[0].str, yyvsp[0].str); free(yyvsp[0].str); }
break;
case 32:
#line 140 "/home/op/w/telescope/parse.y"
{ setattr(yyvsp[-1].str, yyvsp[0].str, yyvsp[-1].str); free(yyvsp[-1].str); free(yyvsp[0].str); }
break;
case 33:
#line 141 "/home/op/w/telescope/parse.y"
{ setattr(yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); free(yyvsp[-2].str); free(yyvsp[-1].str); free(yyvsp[0].str); }
break;
case 34:
#line 144 "/home/op/w/telescope/parse.y"
{ bindkey(yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); free(yyvsp[-2].str); free(yyvsp[-1].str); free(yyvsp[0].str); }
break;
case 35:
#line 147 "/home/op/w/telescope/parse.y"
{ yyerror("TODO: unbind %s %s", yyvsp[-1].str, yyvsp[0].str); }
break;
case 36:
#line 150 "/home/op/w/telescope/parse.y"
{ add_proxy(yyvsp[-2].str, yyvsp[0].str); free(yyvsp[0].str); }
break;
#line 1000 "parse.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (1);
yyaccept:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (0);
}
