/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/tektoncd/pipeline/pkg/apis/pipeline/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeStepActions implements StepActionInterface
type FakeStepActions struct {
	Fake *FakeTektonV1alpha1
	ns   string
}

var stepactionsResource = v1alpha1.SchemeGroupVersion.WithResource("stepactions")

var stepactionsKind = v1alpha1.SchemeGroupVersion.WithKind("StepAction")

// Get takes name of the stepAction, and returns the corresponding stepAction object, and an error if there is any.
func (c *FakeStepActions) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.StepAction, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(stepactionsResource, c.ns, name), &v1alpha1.StepAction{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.StepAction), err
}

// List takes label and field selectors, and returns the list of StepActions that match those selectors.
func (c *FakeStepActions) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.StepActionList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(stepactionsResource, stepactionsKind, c.ns, opts), &v1alpha1.StepActionList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.StepActionList{ListMeta: obj.(*v1alpha1.StepActionList).ListMeta}
	for _, item := range obj.(*v1alpha1.StepActionList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested stepActions.
func (c *FakeStepActions) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(stepactionsResource, c.ns, opts))

}

// Create takes the representation of a stepAction and creates it.  Returns the server's representation of the stepAction, and an error, if there is any.
func (c *FakeStepActions) Create(ctx context.Context, stepAction *v1alpha1.StepAction, opts v1.CreateOptions) (result *v1alpha1.StepAction, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(stepactionsResource, c.ns, stepAction), &v1alpha1.StepAction{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.StepAction), err
}

// Update takes the representation of a stepAction and updates it. Returns the server's representation of the stepAction, and an error, if there is any.
func (c *FakeStepActions) Update(ctx context.Context, stepAction *v1alpha1.StepAction, opts v1.UpdateOptions) (result *v1alpha1.StepAction, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(stepactionsResource, c.ns, stepAction), &v1alpha1.StepAction{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.StepAction), err
}

// Delete takes name of the stepAction and deletes it. Returns an error if one occurs.
func (c *FakeStepActions) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(stepactionsResource, c.ns, name, opts), &v1alpha1.StepAction{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeStepActions) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(stepactionsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.StepActionList{})
	return err
}

// Patch applies the patch and returns the patched stepAction.
func (c *FakeStepActions) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.StepAction, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(stepactionsResource, c.ns, name, pt, data, subresources...), &v1alpha1.StepAction{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.StepAction), err
}
