#!/usr/bin/perl -w
#
# convert packet size histogram to cumulative persentage
#	input: each line contains <pkt_size> <pkt_count> <byte_count>
#	       should be already sorted by pkt_size
#
# $Id: pktcumul.pl,v 1.1 2000/06/29 05:48:45 kjc Exp $
#
use strict;

my(@entries, $total_pkts, $total_bytes, $cumul_pkts, $cumul_bytes, $i);

$total_pkts = 0;
$total_bytes = 0;
$cumul_pkts = 0;
$cumul_bytes = 0;

while (<>) {
    next if /^#/;	# skip comments
    if (/(\d+)\s(\d+)\s(\d+)/) {
	$total_pkts += $2;
	$total_bytes += $3;
	push(@entries, [ $1, $2, $3 ]);
    }
}

for $i (0 .. $#entries) {
    $cumul_pkts += $entries[$i][1];
    $cumul_bytes += $entries[$i][2];
    print $entries[$i][0], " ",  $cumul_pkts/$total_pkts*100.0, " ",
 	  $cumul_bytes/$total_bytes*100.0, "\n";
}
