#include "cd-utils.h"

extern int cd_length(const SDL_CD * cdrom)
{
    int len = 0, i;
    for (i = 0; i < cdrom->numtracks; i++) {
        len += cdrom->track[i].length;
    }
    return len;
}

static int cddb_sum(unsigned int n)
{
    int result = 0;
    while (n != 0) {
        result += n % 10;
        n /= 10;
    }
    return result;
}

extern unsigned long cddb_discid(const SDL_CD * cdrom)
{
    int i, t = 0, n = 0;
    for (i = 0; i < cdrom->numtracks; i++) {
        n += cddb_sum(cdrom->track[i].offset / CD_FPS);
    }
    if (cdrom->numtracks > 0) {
        t = (cdrom->track[cdrom->numtracks].offset / CD_FPS) -
            (cdrom->track[0].offset / CD_FPS);
    }
    return ((n % 0xff) << 24 | t << 8 | cdrom->numtracks);
}
