/* Copyright (c) 1998 Joe Rumsey (mrogre@mediaone.net) */
#include "copyright.h"

#include <stdio.h>
#include "Wlib.h"
#include "data.h"
#include "struct.h"
#include "defs.h"
#include "images.h"

int t_image_nums[NUMTERRAINS] = {
    I_GRASS,
    I_ROAD,
    I_TREE,
    I_POST,
    I_POST,
    I_WALL_T,
    I_WALL_R,
    I_WALL_TR,
    I_WALL_B,
    I_WALL_TB,
    I_WALL_BR,
    I_WALL_TBR,
    I_WALL_L,
    I_WALL_TL,
    I_WALL_RL,
    I_WALL_TRL,
    I_WALL_BL,
    I_WALL_TBL,
    I_WALL_BRL,
    I_WALL_TBRL,
    I_WATER,
    I_CRATER,
    I_BASE1,
    I_BASE2,
    I_BRIDGE,
};

void draw_local(int x, int y)
{
    int i,j;
    W_Image *img;

    for(i=x/GRIDWIDTH; i<=(x/GRIDWIDTH+1) + WINWIDTH/GRIDWIDTH;i++) {
	for(j=y/GRIDHEIGHT; j <= (y/GRIDHEIGHT+1) + WINHEIGHT/GRIDHEIGHT; j++) {
	    switch(map[i][j]) {
	      case T_TREE:
		img = t_shapes[T_GRASS];
		break;
	      case T_BASE1:
	      case T_BASE2:
		img = t_shapes[T_ROAD];
		break;
	      default:
		img = t_shapes[(int)map[i][j]];
		break;
	    }
	    W_DrawImageNoClip(cwin, i*GRIDWIDTH-x, j*GRIDHEIGHT-y, counter, img, W_Green);
	}
    }
}

void draw_overlays(int x, int y)
{
    int i,j;

    for(i=x/GRIDWIDTH; i<=(x/GRIDWIDTH+1) + WINWIDTH/GRIDWIDTH;i++) {
	for(j=y/GRIDHEIGHT; j <= (y/GRIDHEIGHT+1) + WINHEIGHT/GRIDHEIGHT; j++) {
	    switch(map[i][j]) {
	      case T_TREE:
	      case T_BASE1:
	      case T_BASE2:
		W_DrawImage(cwin, i*GRIDWIDTH-x, j*GRIDHEIGHT-y, 0, t_shapes[(int)map[i][j]], W_Green);
		break;
	      default:
		break;
	    }
	}
    }
}


void draw_players(int cx, int cy)
{
    int dx, dy;
    int i;
    player *p;
    W_Image *img;
    W_Color color;
    char buf[20];

    for(i=0,p=&players[0];i<MAXPLAYERS;i++,p++) {
	if(p->p_status == PALIVE) {
	    dx = (p->p_x>>4) - cx - myTankImg->width/2;
	    dy = (p->p_y>>4) - cy - myTankImg->height/2;

	    if(p == me) {
		my_dx = dx + myTankImg->width/2;
		my_dy = dy + myTankImg->width/2;
	    }

	    if(dx>(-((int)myTankImg->width)) &&
	       dy >(-((int)myTankImg->height)) &&
	       dx < WINWIDTH &&
	       dy < WINHEIGHT) {
		if(p == me)
		    img = myTankImg;
		else
		    img = teamTankImg[(p->p_team == 0) ? 0 : 1];
		W_DrawImage(cwin, dx, dy, (p->p_dir+8) >> 4, img, W_Cyan);
		color = (p==me) ? W_White : W_Yellow;
		if(namesOnTanks)
		    sprintf(buf, "%s(%d)", players[i].p_name, i);
		else
		    sprintf(buf, "%d", i);
		W_MaskText(cwin, dx + (myTankImg->width/2)-(strlen(buf)*W_Textwidth)/2, dy-W_Textheight, 
			   color, buf, strlen(buf), W_BoldFont);
	    }
	} else if(p->p_expfuse > 0) {
	    dx = (p->p_x>>4) - cx - expImg->width/2;
	    dy = (p->p_y>>4) - cy - expImg->height/2;
	    if(dx>(-((int)expImg->width)) &&
	       dy >(-((int)expImg->height)) &&
	       dx < WINWIDTH &&
	       dy < WINHEIGHT) {
		W_DrawImage(cwin, dx, dy, EXPFUSE - p->p_expfuse, expImg, W_Red);
	    }
	    p->p_expfuse--;
	}
    }
}

void draw_shells(int cx, int cy)
{
    int dx, dy;
    int i;
    shell *s;
    W_Image *img;

    for(i=0,s=&shells[0];i<SHELLSPERPLAYER * MAXPLAYERS;i++,s++) {
	if(s->s_status == SALIVE) {
	    dx = (s->s_x>>4) - cx;
	    dy = (s->s_y>>4) - cy;
	    if(dx > 0 &&
	       dy > 0 &&
	       dx < WINWIDTH &&
	       dy < WINHEIGHT) {
		img = shellImg;
		W_DrawImage(cwin, dx - img->width/2, dy - img->height/2, s->s_fuse, img, W_Cyan);
	    } else
		s->s_status = SDEAD;
	}
    }
}

void draw_shell_exps(int cx, int cy)
{
    int dx, dy;
    int i;
    shell *s;
    W_Image *img;

    for(i=0,s=&shells[0];i<SHELLSPERPLAYER * MAXPLAYERS;i++,s++) {
	if(s->s_status == SEXPLODE) {
	    dx = (s->s_x>>4) - cx;
	    dy = (s->s_y>>4) - cy;
	    if(dx > 0 &&
	       dy > 0 &&
	       dx < WINWIDTH &&
	       dy < WINHEIGHT) {
		img = mineExpImg;
		W_DrawImage(cwin, dx - img->width/2, dy - img->height/2, s->s_fuse, img, W_Cyan);
		s->s_fuse++;
		if(s->s_fuse >= img->frames)
		    s->s_status = SDEAD;
	    } else
		s->s_status = SDEAD;
	}
    }
}

void draw_flags(int cx, int cy)
{
    int dx, dy;
    int i;
    flag *f;

    for(i=0,f=&flags[0];i<NUMFLAGS;i++,f++) {
	dx = (f->f_x >> 4) - cx;
	dy = (f->f_y >> 4) - cy;
	if(dx > 0 &&
	   dy > 0 &&
	   dx < WINWIDTH &&
	   dy < WINHEIGHT)
	    W_DrawImage(cwin, dx - flagImg[f->f_team]->width/2, dy - flagImg[f->f_team]->height/2, 
			0, flagImg[f->f_team], W_Cyan);
    }
}

void draw_mines(int cx, int cy)
{
    int dx, dy;
    int i;
    mine *mi;
    W_Image *img;

    for(i=0;i<MAXPLAYERS * MINESPERPLAYER;i++) {
	if(mines[i].mi_status != MIEMPTY) {
	    mi = &mines[i];
	    dx = (mi->mi_x >> 4) - cx;
	    dy = (mi->mi_y >> 4) - cy;
	    if(dx > 0 && 
	       dy > 0 &&
	       dx < WINWIDTH &&
	       dy < WINHEIGHT) {
		if(mines[i].mi_status == MILIVE)
		    img = mineImg;
		else
		    img = mineExpImg;
		W_DrawImage(cwin, dx - img->width/2, dy - img->height/2,
			    mines[i].mi_fuse, img, W_Red);
	    }
	    if(mines[i].mi_status == MIEXPLODE) {
		mines[i].mi_fuse++;
		if(mines[i].mi_fuse >= mineExpImg->frames)
		    mines[i].mi_status = MIEMPTY;
	    }
	}
    }
}

void draw_build_marker(int cx, int cy)
{
    int mapx, mapy, dx, dy;

    if(me->p_speed == 0 && me->p_trees && showBuildMarker) {
	mapx = (me->p_x >> 4)/GRIDWIDTH;
	mapy = (me->p_y >> 4)/GRIDHEIGHT;
	if(me->p_dir < 32 || me->p_dir > 224)
	    mapy--;
	else if(me->p_dir < 96)
	    mapx++;
	else if(me->p_dir < 160)
	    mapy++;
	else
	    mapx--;
	if(mapx < 0 || mapy < 0 || mapx >= map_info.m_width || mapy >= map_info.m_height)
	    return;
	dx = mapx*GRIDWIDTH-cx;
	dy = mapy*GRIDHEIGHT-cy;
	W_MakeLine(cwin, dx, dy, dx+GRIDWIDTH-1, dy, W_Yellow);
	W_MakeLine(cwin, dx+GRIDWIDTH-1, dy, dx+GRIDWIDTH-1, dy+GRIDHEIGHT-1, W_Yellow);
	W_MakeLine(cwin, dx, dy+GRIDHEIGHT-1, dx+GRIDWIDTH-1, dy+GRIDHEIGHT-1, W_Yellow);
	W_MakeLine(cwin, dx, dy+GRIDHEIGHT-1, dx, dy, W_Yellow);
    }
}

int mapx[MAXPLAYERS], mapy[MAXPLAYERS];

void map_square(int x, int y)
{
    W_Color color;

    switch(map[x][y]) {
      case T_GRASS:
	color = W_DarkGreen;
	break;
      case T_TREE:
	color = W_Green2;
	break;
      case T_ROAD:
      case T_BRIDGE:
	color = W_Brown;
	break;
      case T_WATER:
	color = W_Blue;
	break;
      case T_CRATER:
	color = W_Yellow;
	break;
      default:
	if(map[x][y] >= T_GWALL && map[x][y] <= T_WALL_TBRL)
	    color = W_Red;
	else
	    color = W_Grey;
    }
    W_FillArea(mapwin, x*map_pixel, y*map_pixel, map_pixel, map_pixel, color);
}

void update_map()
{
    int i,x,y;
    W_Color color;

    for(i=0;i<MAXPLAYERS;i++) {
	if(mapx[i] >= 0 && mapy[i] >= 0) {
	    map_square(mapx[i], mapy[i]);
	}
	if(players[i].p_status == PALIVE) {
	    x = (players[i].p_x >> 4) / GRIDWIDTH;
	    y = (players[i].p_y >> 4) / GRIDHEIGHT;
	    if(&players[i] == me)
		color = W_White;
	    else if(players[i].p_team == 0)
		color = W_Blue;
	    else
		color = W_Red;
	    W_FillArea(mapwin, x*map_pixel, y*map_pixel, map_pixel, map_pixel, W_White);
	    W_MakeLine(mapwin, x*map_pixel, y*map_pixel, 
		       x*map_pixel + map_pixel - 1, y*map_pixel + map_pixel - 1, color);
/*
	    W_DrawPoint(mapwin, x*2, y*2, W_White);
	    W_DrawPoint(mapwin, x*2+1, y*2, W_White);
	    W_DrawPoint(mapwin, x*2, y*2+1, color);
	    W_DrawPoint(mapwin, x*2+1, y*2+1, color);
*/
	    mapx[i] = x;
	    mapy[i] = y;
	} else {
	    mapx[i] = -1;
	}
    }
}

void redraw_map()
{
    int x, y;

    for(x=0;x<map_info.m_width;x++) {
	for(y=0;y<map_info.m_height;y++) {
	    map_square(x,y);
	}
    }

    update_map();
}

void init_terrain()
{
    int i;

    for(i=0;i<NUMTERRAINS;i++)
	t_shapes[i] = getImage(t_image_nums[i]);
}

void do_redraw()
{
    int cx, cy;

    if(!displayoff) {
	cx = (me->p_x>>4)-WINWIDTH/2;
	cy = (me->p_y>>4)-WINHEIGHT/2;
	if(cx < 0) cx = 0;
	else if(cx > GRIDWIDTH * map_info.m_width - WINWIDTH)
	    cx = GRIDWIDTH * map_info.m_width - WINWIDTH;
	if(cy < 0) cy = 0;
	else if(cy > GRIDHEIGHT * map_info.m_height - WINHEIGHT)
	    cy = GRIDHEIGHT * map_info.m_height - WINHEIGHT;
	
	draw_local(cx,cy);
	draw_mines(cx, cy);
	draw_shells(cx, cy);
	draw_players(cx,cy);
	draw_overlays(cx,cy);
	draw_flags(cx, cy);
	draw_shell_exps(cx, cy);
	draw_build_marker(cx, cy);

	W_DisplayBuffer(cwin);
	W_Flush();
	update_map();
    }
}
