/*      cpuid.cpp
//
//      Copyright 2005-2011 Lucas Tsatiris <systester.project@gmail.com>
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.
//
*/

#if !defined(_CPUID)
#define _CPUID	1

#include <stdio.h>
#include <string.h>
#include "systester.h"

#if defined(__osf__) || defined(__alpha)	/* DEC ALPHA */
#include "alpha-cpuid.cpp"
#else
#if defined(__i386) || defined(__x86_64) || defined (__i386) || defined (__amd64) || defined (_MSC_VER)	/* x86 and amd64 */
#include "x86-cpuid.cpp"
#else
#if defined(__hppa)		/* HP PARISC */
#include "hppa-cpuid.cpp"
#else
#if defined(__sparc)		/* SUN SPARC */
#include "sparc-cpuid.cpp"
#else
#if defined(_POWER)		/* IBM POWER */
#include "power-cpuid.cpp"
#else /* Unknown CPU Vendor */
int
CPUID (char *ChipID, char *VendorID)
{
  strcpy (ChipID, "Unknown CPU");
  strcpy (VendorID, "Unknown Vendor");
  return 0;
}

#endif /* _POWER */
#endif /* __sparc */
#endif /* __hppa */
#endif /* __i386 ... */
#endif /* __osf__ */

#endif /* CPUID */
