/*      MainForm.h
//
//      Copyright 2005-2011 Lucas Tsatiris <systester.project@gmail.com>
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.
//
*/

#if !defined (MAINWINDOW_H)
#define MAINWINDOW_H

#include <QFontDialog>
#include <QFont>
#include <QTimer>
#include <QMessageBox>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include <QDesktopServices>
#include <QScrollBar>
#include "ui_MainWindow.h"
#include "SplashForm.h"

extern QScrollBar *VSBar;

class MainForm:public QMainWindow, private
  Ui::MainWindow
{
  Q_OBJECT
  SplashWindow *Splash;
  void  pimaster (unsigned long long iter, int threads, int algo);
  void  picoremain (int loops, int exec_times, int output_file, int log_file,
	      int threads, int gaussalgo);

public:
  MainForm ();
  ~MainForm ();

  void
  onload ();

  QScrollBar *vsbar; // vertical scroll bar of text terminal

  private slots:
  void
  runButton_clicked ();
  void
  exitButton_clicked ();
  void
  aboutButton_clicked ();
  void
  FontsButton_clicked ();
  void
  flattrButton_clicked ();
  void
  stopButton_clicked ();
  void
  modeButton_clicked ();
  void
  threadsBox_changed ();
  void
  updateButton_clicked ();
  void
  updateReplyFinished (QNetworkReply * updatereply);
  void
  initForm();
};

#endif /* MAINWINDOW_H */
