/*      qcborwein.h
//      
//      Copyright 2005-2011 Lucas Tsatiris <systester.project@gmail.com>
//      
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//      
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//      
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.
//      
*/      



#if !defined (QCBORWEIN_H)
#define QCBORWEIN_H	   1

#include "compthreads.h"
#include "pi.h"

typedef struct borwein_data
{

  mpf_t x1, x2, p1, p2, w1, w2, sqrx, sqr1x, x2plus1, w1plus1, x2divw1;

} bdata;

extern bdata bd[MAX_THREADS];

st_threadfunc_t borwein_initialize (st_threadfuncarg_t idx);
st_threadfunc_t borwein_calculate (st_threadfuncarg_t idx);
st_threadfunc_t borwein_finalize (st_threadfuncarg_t idx);

#endif
