/*      outxdigits.cpp
//      
//      Copyright 2005-2011 Lucas Tsatiris <systester.project@gmail.com>
//      
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//      
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//      
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.
//      
*/      



#include "systester.h"

void
outxdigits (unsigned long long xdigits, char *str)
{

  unsigned long long M = 1024 * 1024, K = 1024;

  if (xdigits >= M)
    {
      sprintf (str, "%dM", (int) (xdigits / M));
      return;
    }

  if (xdigits >= K)
    {
      sprintf (str, "%dK", (int) (xdigits / K));
      return;
    }

  sprintf (str, "%d", (int) xdigits);
}
