/*      osid.cpp
//      
//      Copyright 2005-2011 Lucas Tsatiris <systester.project@gmail.com>
//      
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//      
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//      
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.
//      
*/      


/*
 *   Identify kernels version
 */

#if !defined(OSID)
#define OSID   1

#include <stdio.h>
#include <string.h>

#if defined (_MSC_VER) || defined (__MINGW32__)		/* Microsoft Windows */
#define _CRT_SECURE_NO_WARNINGS
void
osid (char *str)
{
  sprintf (str, "Microsoft Windows");
}
#else /* Unix? */
#include <sys/utsname.h>
void
osid (char *str)
{
  struct utsname unixname;
  if (uname (&unixname) < 0)

    {
      strcpy (str, "");
      return;
    }

  sprintf (str, "%s %s", unixname.sysname, unixname.machine);
}


#endif /* _MSC_VER */

#endif /* OSID */
