#!/bin/sh
#
# @(#)sux.sh,v 1.1.1.1 1999/07/05 04:14:03 kim Exp
#
# Run su keeping our own environment and shell.
#
# 1996-11-05  Kimmo Suominen
#
# We do NOT set the PATH because we are actually trying to
# preserve the environment.  Otherwise we would set it here.
#
# We use the BSD su since it has the convenient "-m" option
# to do most of the work.  Otherwise you have to reinvent
# the wheel and check for the originators shell for syntax.
#
# If we detect Kerberos, we use the standard su program.
#
if [ ! -f /etc/kerberosIV/krb.conf ]
then
    for i in /usr/local/bsd/bin/su /usr/local/gnu/bin/su
    do
	if [ -x $i ]
	then
	    BSDSU=$i
	    break
	fi
    done
fi
#
# Who has the preferred su?
#
case "$BSDSU" in
"")
    case "`osname`" in
    "")
	echo "Could determine OS type, sorry" >&2
	exit 1
	;;
    linux)
	BSDSU=/bin/su
	;;
    netbsd)
	BSDSU=/usr/bin/su
	;;
    *)
	echo "No BSD su, sorry" >&2
	exit 1
	;;
    esac
esac
#
# Get default switches from the current environment.
#
set -- $SUX "$@"
#
# Parse options and check arguments.
#
usage="Usage: $0 [-n] [-s] [user [shell args]]"
while getopts ns opt
do
    case "$opt" in
    n)	agent="";;
    s)	agent="-c sshsh";;
    *)	echo "$usage" >&2; exit 1;;
    esac
done
shift `expr $OPTIND - 1`
case $# in
0)  if [ ! -z "${agent}" ]
    then
	user=root
    fi
    ;;
*)  user=$1
    shift
    ;;
esac
#
# Run a su.
#
if [ "$LOGNAME" != "root" ]
then	if [ -x $BSDSU ]
	then	exec $BSDSU -m -- $user $agent "$@"
	else	echo "No BSD su, sorry" >&2
		exit 1
	fi
else
	exec /bin/su $user
fi
