// Copyright (C) 2021 Storj Labs, Inc.
// See LICENSE for copying information.

package drpcmetadata

import (
	"testing"

	"github.com/zeebo/assert"
)

func TestCompatibility_Append(t *testing.T) {
	assert.Equal(t,
		appendEntry(nil, "key", "value"),
		[]byte{
			0x0a, 0x0c, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x12,
			0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
		},
	)
}

func TestCompatibility_Parse(t *testing.T) {
	order := []string{"5", "1", "2", "3", "4"}
	buf := []byte{
		0x0a, 0x0e, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x35,
		0x12, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x35,
		0x0a, 0x0e, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x31,
		0x12, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x31,
		0x0a, 0x0e, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x32,
		0x12, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x32,
		0x0a, 0x0e, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x33,
		0x12, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x33,
		0x0a, 0x0e, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x34,
		0x12, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x34,
	}

	var key, value []byte
	var ok bool
	var err error

	for i := 0; len(buf) > 0; i++ {
		buf, key, value, ok, err = readEntry(buf)
		assert.That(t, ok)
		assert.NoError(t, err)
		assert.Equal(t, string(key), "key"+order[i])
		assert.Equal(t, string(value), "value"+order[i])
	}
}
