/* This file is part of statist
**
** It is distributed under the GNU General Public License.
** See the file COPYING for details.
** 
** (c) 1997 Dirk Melcher
**  Doerper Damm 4
**  49134 Wallenhorst
**  GERMANY
**  Tel. 05407/7636
**  email: Dirk.Melcher@usf.Uni-Osnabrueck.DE
**
**  some changes by Bernhard Reiter  http://www.usf.Uni-Osnabrueck.DE/~breiter
**  $Id: menue.c,v 1.4 2001/11/15 20:26:55 breiter Exp breiter $
***************************************************************/

/* menue.c fuer STATIST */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "statist.h"
#include "procs.h"
#include "funcs.h"
#include "data.h"
#include "plot.h"
#include "menue.h"

#include "gettext.h"

int getint() {
   int anint=-1;
   if (!empty) {
      status = sscanf(line, "%i", &anint);
      if (status != 1) {
         out_err(ERR, ERR_FILE, ERR_LINE, _("No valid number!", "Keine gueltige Zahl!") );
         empty = TRUE;
      }
   }
   return anint;
}

REAL getreal() {
   REAL areal= -1.0;
   if (!empty) {
      status = sscanf(line, "%lf", &areal);
      if (status != 1) {
         out_err(ERR, ERR_FILE, ERR_LINE, _("Invalid number!", "Keine gueltige Zahl!") );
         empty = TRUE;
      }
   }
   return areal;
}


BOOLEAN equal_rows(int nm) {
/* Prueft, ob Spalten unterschiedliche Laenge besitzen */
  int i;
  for (i=1; i<nm; i++) {
    if (nn[acol[i]] != nn[acol[0]]) {
      out_err(ERR, ERR_FILE, ERR_LINE, 
		_("Columns have differen number of enties!", 
		  "Spalten haben unterschiedlich viele Werte!") );
      return FALSE;
    }
  }
  return TRUE;
}

/* ====================================================================== */

void main_menue() {
   int choice = 99;

   while (choice != QUIT) {
     out_d( _("MAIN MENU: \n\n", "HAUPTMENUE: \n\n") );
     out_d( _("   0 = Quit\n", "   0 = Ende\n") );
     out_d( _("   1 = Data management\n", "   1 = Datenverwaltung\n") );
     out_d( _("   2 = Regressions and correlations\n",
     		  "   2 = Regression und Korrelation\n") );
     out_d(   "   3 = Tests\n");
     out_d( _("   4 = Miscellaneous\n", "   4 = Verschiedenes\n") );
     out_d( _("   5 = Data manipulation\n", "   5 = Datenmanipulation\n") );

     out_d( _("\n  Your choice: ", "\n  Ihre Wahl: ") );
     GETNLINE;
     status = sscanf(line,"%i", &choice);
     if ((status==0) || (empty)) {
       choice = 99;
     }
     out_d("\n\n");

     switch(choice) {
       case 0 : ;
	       break;
       case 1: {
		 PRINTLINE
		 data_menu();
	       }
	       break;
       case 2: {
		 PRINTLINE
		 regress_menu();
	       }
	       break;
       case 3: {
		 PRINTLINE
		 test_menu();
	       }
	       break;
       case 4: {
		 PRINTLINE
		 misc_menu();
	       }
	       break;
       case 5: {
		 PRINTLINE
		 manipulate_menu();
	       }
	       break;	 
       default:out_err(ERR, ERR_FILE, ERR_LINE, 
	 	_("Illegal instruction!", "Ungueltige Anweisung!") );
	       break;
     }
     PRINTLINE
   }
}


/* ====================================================================== */
void misc_menu() {
   int choice = 99, i;
   REAL min, max;

   while (choice != QUIT) {
     out_d(_("MISCELANEOUS: \n\n", "VERSCHIEDENES: \n\n") );
     out_d(_("   0 = Main menu\n", "   0 = Hauptmenue\n") );
     out_d(_("   1 = Standard deviation, mean, median, etc. \n", 
     		 "   1 = Standardabweichung, Mittelwert, Median uva. \n") );
     out_d(_("   2 = Probit analysis\n", "   2 = Probitanalyse\n") );
     out_d(_("   3 = Outliers & Box-Whisker-plot\n", 
     		 "   3 = Ausreisser + Box-Whisker-Plot\n") );     
     out_d(_("   4 = Percentiles\n", 
     		 "   4 = Perzentile\n") );     
#ifndef MSDOS
     if (!noplot)
       out_d(_("   9 = Enter gnuplot commands\n",
	 	   "   9 = gnuplot-Befehle eingeben\n") );
#endif

     out_d(_("\n  Your choice: ", "\n  Ihre Wahl: ") );
     GETRLINE;
     status = sscanf(line,"%i", &choice);
     if ((status==0) || (empty)) {
       choice = 99;
     }
     out_d("\n\n");

     switch(choice) {
       case 0: ;
               break;
       case 1: 
               getcols(1);
               if (!empty) {
		 out_d(_("Number of classes (0 or RETURN for auto): ",
		 	   "Anzahl der Klassen (0 oder ENTER fuer auto): ") );
		 GETNLINE;
		 i = getint();
		 if (empty) {
		   i = 0;
		 }
		 if (i>MCLASS) {
		   out_err(ERR, ERR_FILE, ERR_LINE,
			_("More than %i classes not allowed!",
			  "Mehr als %i Klassen sind nicht erlaubt!"), MCLASS);
		   break;
		 }
		 else if ((i<0)||(i==1)) {
		   out_err(ERR, ERR_FILE, ERR_LINE,
			_("Please enter meaningfull number of classes!",
		      "Bitte SINNVOLLE Angaben fuer Anzahl der Klassen machen!!!") );
		   break;
		 }
		 else {
		   out_d("Minimum (%f): ", get_min(xx[acol[0]], nn[acol[0]]));
		   GETNLINE;
		   min = getreal();
		   if (empty) {
		     min = get_min(xx[acol[0]], nn[acol[0]]);
		   }
		   out_d("Maximum (%f): ", get_max(xx[acol[0]], nn[acol[0]]));
		   GETNLINE;
		   max = getreal();
		   if (empty) {
		     max = get_max(xx[acol[0]], nn[acol[0]]);
		   }
		 }
                 standard(xx[acol[0]], nn[acol[0]], i, min, max);
               }
               break;
       case 2: 
               out_d(
		    _("Set number to 100 (--> percent? ) y/n ",
			"Anzahl auf 100 setzen (--> Prozent? ) j/n") );
               GETBLINE;
               if (line[0]==_('y', 'j') ) {
                 out_d(
		 	  _("Please select columns containing dose and effect data\n", 
			    "Bitte Spalten fuer Dosis und Effekt angeben\n") );
                 getcols(2);
                 if ((!empty) && (equal_rows(2))) {
                   tempcol = (REAL*)m_calloc(nn[acol[0]], sizeof(REAL));
                   for (i=0; i<nn[acol[0]]; i++ ) {
                     tempcol[i] = 100.0;
                   }
                   probit(xx[acol[0]], tempcol, xx[acol[1]], nn[acol[0]]);
                 }
               }
               else {
                 out_d(_("Please select columns containing dose, number, effect data\n",
		     	"Bitte Spalten fuer Dosis, Anzahl, Effekt angeben\n") );
                 getcols(3);
                 if ((!empty) && (equal_rows(3))) {
                   probit(xx[acol[0]], xx[acol[1]], xx[acol[2]], nn[acol[0]]);
                 }
               }
               break;
       case 3:
               getcols(1);
               if (!empty) {
		 outlier(xx[acol[0]], nn[acol[0]]);
	       }
	       break;
       case 4: 
               getcols(1);
               if (!empty) {
                 percentiles(xx[acol[0]], nn[acol[0]]);
               }
               break;
#ifndef MSDOS
       case 9: 
               if (!noplot) {
                 out_d(_("Terminate gnuplot commands with '.'\n\n",
		     "gnuplot-Kommandos bitte mit '.' beenden\n\n") );
                 plot_command();
               }
               break;
#endif
       default:out_err(ERR, ERR_FILE, ERR_LINE, 
	 		_("Illegal instruction!", "Ungueltige Anweisung!") );
               break;
     }
     m_freeall(); /* deallocate used memory for tmp variables */
     if (choice != 0) {
       mywait();
     }
   }
   return;
} /* misc_menu() */

/* =================================================================== */

void test_menu()  {
   int i, k, choice = 99;
   
   while (choice != QUIT) {
     out_d("TESTS: \n\n");
     out_d(_("   0 = Main Menu\n", "   0 = Hauptmenue\n") );
     out_d(_("   1 = t-test for comparison of two means of two sets\n",
     		 "   1 = t-Test zum Vergleich zweier Mittelwerte aus Stichproben\n") );
     out_d(_("   2 = t-test for comparison of pairwise ascertained data sets\n",
		 "   2 = t-test zum Vergleich paarweise erhobener Stichproben\n") );
     out_d(_("   3 = Test of normal distribution (KS-Lillefors-Test)\n",
  		 "   3 = Test auf Normalverteilung (KS-Lillifors-Test)\n") );
     out_d(_("   $ = Chi^2-fourfould-test\n",
     		 "   4 = Chi^2-Vierfeldertafel\n") );
     out_d(_("   5 = Chi^2 two-items-test\n",
     		 "   5 = CHI^2 Zwei-Merkmale-Tafeltest\n") );
     out_d(_("   6 = u-test (Test of independence of two data sets)\n",
     		 "   6 = u-Test (Test auf Unabhaengigkeit 2er Stichproben)\n") );
     out_d(_("   7 = H-test (Kruskal-Wallis) for k independent data sets\n",
     		 "   7 = H-Test (Kruskal-Wallis) fuer k unabhaengige Stichproben\n") );
     out_d(_("   8 = Wilcoxon-Rank-test for pairwise ascertained data sets\n",
     		 "   8 = Wilcoxon-Rang-Test fuer paarweise erhobene Stichproben\n") );
     out_d(_("   9 = Chi^2-test of equal frequency\n",
     		 "   9 = Chi^2-Test auf gleiche Haeufigkeiten\n") );
     out_d(_("  10 = Chi^2-test of correspondence between measured and theoretical frequency\n", 
     		 "  10 = Chi^2-Test auf Gleicheit von gemessenen mit theor. Haeufigkeiten\n") );
/*     
     out_d("  10 = KOLMOGOROFF-SMIRNOFF Test auf Gleichheit 2er Verteilungen\n");
*/     
     out_d(_("\n  Your choice: ", "\n  Ihre Wahl: ") );
     GETRLINE;
     status = sscanf(line,"%i", &choice);
     if ((status==0) || (empty)) {
       choice = 99;
     }
     out_d("\n\n");

     switch(choice) {
       case 0: 
               break;
       case 1: 
               getcols(2);
               if (!empty) {
                 t_test(xx[acol[0]],nn[acol[0]], xx[acol[1]],nn[acol[1]]);
               }
               break;
       case 2: 
               getcols(2);
               if ((!empty) && (equal_rows(2))) {
                 pair_t_test(xx[acol[0]], xx[acol[1]],nn[acol[0]]);
               }
               break;
       case 3: 
               getcols(1);
               if (!empty) {
                 kolmo_test(xx[acol[0]], nn[acol[0]]);
               }
               break;
      case 4:  
               getcols(2);
               if ((!empty) && (equal_rows(2))) {
                 vierfeld_test(xx[acol[0]], xx[acol[1]], nn[acol[0]]);
               }
               break;
      case 5: 
               out_d(_("Please enter numnber of columns to be correlated: ",
		   	"Bitte Anzahl der zu korrelierenden Spalten eingeben: ") );
               GETBLINE;
               if (strstr(line, _ALL_) != NULL) {
                 for (i=0; i<ncol; i++) {
                   acol[i] = i;
                 }
                 alloc_cols(ncol);
               }
               else {
                 i = getint();
                 getcols(i);
               }
               if ((!empty) && (equal_rows(i))) {
                 yy = (REAL**)m_calloc(i, sizeof(PREAL));
                 for (k=0; k<i; k++) {
                   yy[k] = xx[acol[k]];
                 }
                 tafel_test(yy, nn[acol[0]], i);
               }
               break;
       case 6: 
               getcols(2);
               if (!empty) {
                 u_test(xx[acol[0]], nn[acol[0]], xx[acol[1]], nn[acol[1]]);
               }
               break;
       case 7: 
               out_d(_("Please enter number (>2) of columns to be correlated: ",
		   	"Bitte Anzahl (>2) der zu testenden Spalten eingeben: ") );
               GETBLINE;
               if (strstr(line, _ALL_) != NULL) {
                 for (i=0; i<ncol; i++) {
                   acol[i] = i;
                 }
                 alloc_cols(ncol);
               }
               else {
                 i = getint();
                 getcols(i);
               }
               if (i<3) {
                 out_err(ERR, ERR_FILE, ERR_LINE,
			_("At least 3 columns have to be selected!", 
			 "Es muessen mindestens 3 Spalten gewaehlt werden!") );
                 break;
               }
               /* getcols(i);  */
               if (!empty)  {
                 yy = (REAL**)m_calloc(i, sizeof(PREAL));
                 ny = (int*)m_calloc(i, sizeof(int));
                 for (k=0; k<i; k++) {
                   yy[k] = xx[acol[k]];
                   ny[k] = nn[acol[k]];
                 }
                 kruskal_test(yy, ny, i);
               }
               break;
       case 8:
	       getcols(2);
	       if ((!empty) && (equal_rows(2))) {
		 wilcoxon_test(xx[acol[0]], xx[acol[1]], nn[acol[0]]);
	       }
	       break;
       case 9: 
               getcols(1);
               if (!empty) {
                 equal_freq(xx[acol[0]], nn[acol[0]]);
               }
               break;
       case 10:
	       out_d(_("Variable 1 (x) = measured distribution\n",
		 	"Variable 1 (x) = beobachtete Verteilung\n") );
	       out_d(_("Variable 2 (y) = expected (theoretical) distribution\n\n",
		 	"Variable 2 (y) = erwartete (theoretische) Verteilung\n\n") ); 
               getcols(2);
               if (!empty) {
                 compare_freq(xx[acol[0]], nn[acol[0]], xx[acol[1]], nn[acol[1]]);
               }
               break;
/*	       
       case 10:
               getcols(2);
	       x_read[acol[0]]=FALSE; /~ x and y muessen neu geladen werden, ~/
	       x_read[acol[1]]=FALSE; /~ da in der Routine (sort) veraendert ~/
               if (!empty) {
                 compare_dist(xx[acol[0]], nn[acol[0]], xx[acol[1]], nn[acol[1]]);
               }
               break;
*/	      
       default:
	       out_err(ERR, ERR_FILE, ERR_LINE, 
	 		_("Illegal instruction!", "Ungueltige Anweisung!") );
               break;
     }
     m_freeall(); /* deallocate used memory for tmp variables */
     if (choice != 0) {
       mywait();
     }
   }
   return;
} /* test_menu() */

/* =================================================================== */

void regress_menu()  {
   int i, k, choice = 99;

   while (choice != QUIT) {
     out_d(_("REGRESSION & CORRELATION: \n\n", 
     		 "REGRESSION & KORRELATION: \n\n") );
     out_d(_("   0 = Main menu\n", "   0 = Hauptmenue\n") );
     out_d(_("   1 = Linear regression and correlation\n", 
     		 "   1 = Lineare Regression und Korrelation\n") );
     out_d(_("   2 = SPEARMAN rank-correlation-coefficient\n",
     		 "   2 = Rank-Korrelationskoeffizient von SPEARMAN\n") );
     out_d(_("   3 = Multiple linear correlation\n",
     		 "   3 = Multiple lineare Korrelation\n") );
     out_d(_("   4 = Partial linear correlation (maximum: 5 variables)\n",
     		 "   4 = Partielle lineare Korrelation (max. 5 Variablen)\n") );
     out_d(_("   5 = Polynomial regression\n", "   5 = Polynomregression\n") );
     out_d(_("   6 = Matrix of the linear correlation coefficients\n",
     		 "   6 = Matrix der linearen Korrelationskoeffizienten\n") );
     out_d(_("   7 = Matrix of SPEARMAN correlation coefficients\n", 
     		 "   7 = Matrix der SPEARMANN'SCHEN Korrelationskoeffizienten\n") );
     out_d(_("   8 = Point-biserial (linear) correlation\n",
     		 "   8 = Punkt-biserielle (lineare) Korrelation\n") );
     out_d(_("   9 = Cross-validation of multiple linear regression\n",
     		 "   9 = Kreuz-Validierung multipler linearer Regression\n") );
     out_d(_("  10 = Randomization of multiple linear regression\n",
     		 "  10 = Randomisierung multiple linearer Regression\n") );
     out_d(_("\n  Your choice: ", "\n  Ihre Wahl: ") );
     GETRLINE;
     status = sscanf(line,"%i", &choice);
     if ((status==0) || (empty)) {
       choice = 99;
     }
     out_d("\n\n");

     switch(choice) {
       case 0: 
               break;
       case 1: 
               getcols(2);
               if ((!empty) && (equal_rows(2))) {
                 lin_reg(xx[acol[0]], xx[acol[1]], nn[acol[0]]);
               }
               
               break;
       case 2: 
               getcols(2);
               if ((!empty) && (equal_rows(2))) {
                 rank_order(xx[acol[0]], xx[acol[1]], nn[acol[0]]);
               }
               break;
       case 3: 
               out_d(_("Please enter numnber of columns to be correlated,\n",
		   	"Bitte Anzahl der zu korrelierenden Spalten eingeben,\n") );
               out_d(_("First selected column is taken as y-value: ", 
		   		"Erste angewaehlte Spalte wird als y-Wert genommen: ") );
               GETBLINE;
               if (strstr(line, _ALL_) != NULL) {
                 for (i=0; i<ncol; i++) {
                   acol[i] = i;
                 }
                 alloc_cols(ncol);
               }
               else {
                 i = getint();
                 getcols(i);
               }
	       
               if ((!empty) && (equal_rows(i))) {
                 yy = (REAL**)m_calloc((i-1), sizeof(PREAL));
                 for (k=0; k<(i-1); k++) {
                   yy[k] = xx[acol[k+1]];
                 }
                 out_r(_("y = Column %s\n", "y = Spalte %s\n"),
		     			(alias[acol[0]]));
                 for (k=1; k<i; k++) {
                   out_r(_(" x[%i] = Column %s\n", "x[%i] = Spalte %s\n"), 
			 		k, (alias[acol[k]]));
                 }
                 multiple_reg(xx[acol[0]], yy, nn[acol[0]], i-1);
               }
               break;
       case 4: 
               out_d(_("Please enter number of columns to be correlated (3, 4, or 5): ",
		   	"Bitte Anzahl der Spalten eingeben (3, 4 oder 5): ") );
               GETBLINE;
               if (strstr(line, _ALL_) != NULL) {
                 for (i=0; i<ncol; i++) {
                   acol[i] = i;
                 }
                 alloc_cols(ncol);
               }
               else {
                 i = getint();
              /*   getcols(i);  */
               }
               if ((i>=3) && (i<=5)) {
                 getcols(i);
                 if ((!empty) && (equal_rows(i))) {
                   yy = (REAL**)m_calloc(i, sizeof(PREAL));
                   for (k=0; k<i; k++) {
                     yy[k] = xx[acol[k]];
                   }
                   part_corr(yy, nn[acol[0]], i);
                 }
               }
               else {
                 out_err(ERR, ERR_FILE, ERR_LINE,
			 _("Only 3, 4, or 5 columns allowed!",
			 "Es duerfen nur 3, 4 oder 5 Spalten eingegeben werden!") );
               }
               break;
       case 5: 
               out_d(_("Please select columns for x- and y-values (variable 1 = x, variable 2 = y)\n\n",
		   	"Bitte Spalten fuer x- und y-Werte angeben (Variable 1 = x, Variable 2 = y)\n\n") );
               getcols(2);
               if ((!empty) && (equal_rows(2))) {
                 out_d(_("Please enter order of regression polynom (max. %i): ",
		     	"Bitte Grad des anzupassenden Polynoms angeben (max. %i): ")
					,MPOLY);
                 GETBLINE;
                 i = getint();
                 if ( (i>0) && (i<=MPOLY) && (nn[acol[0]]==nn[acol[1]]) ) {
                   poly_reg(xx[acol[0]], xx[acol[1]], nn[acol[0]], i);
                 }
                 else {
                   out_err(ERR, ERR_FILE, ERR_LINE,
			   _("Illegal order or x- and y-columns have different number of values!",
			   "Ungueltigen Grad angegeben oder x- und y-Spalten haben\n\
unterschiedlichiele Werte!") );
                 }
               }
               break;
       case 6: 
               out_d(_("Please enter numnber of columns to be correlated: ",
		   	"Bitte Anzahl der zu korrelierenden Spalten eingeben: ") );
               GETBLINE;
               if (strstr(line, _ALL_) != NULL) {
                 for (i=0; i<ncol; i++) {
                   acol[i] = i;
                 }
                 alloc_cols(ncol);
               }
               else {
                 i = getint();
                 getcols(i);
               }
               if ((!empty) && (equal_rows(i))) {
                 yy = (REAL**)m_calloc(i, sizeof(PREAL));
                 for (k=0; k<i; k++) {
                  yy[k] = xx[acol[k]];
                 }
                 if ((!empty) && (equal_rows(i))) {
                   correl_matrix(yy, nn[acol[0]], i);
                 }
               }
               break;
       case 7: 
               out_d(_("Please enter number of columns to be correlated (or 'all'): ",
		   	"Bitte Anzahl der zu korrelierenden Spalten eingeben (oder \"alle\"): ") );
               GETBLINE;
               if (strstr(line, _ALL_) != NULL) {
                 for (i=0; i<ncol; i++) {
                   acol[i] = i;
                 }
                 alloc_cols(ncol);
               }
               else {
                 i = getint();
                 getcols(i);
               }
               if ((!empty) && (equal_rows(i))) {
                 yy = (REAL**)m_calloc(i, sizeof(PREAL));
                 for (k=0; k<i; k++) {
                   yy[k] = xx[acol[k]];
                 }
                 if ((!empty) && (equal_rows(i))) {
                   rank_matrix(yy, nn[acol[0]], i);
                 }
               }
               break;
       case 8: 
               out_d(_("First column must contain only 0's or 1's!\n",
		   	"Die 1. Spalte darf nur 0 und 1 enthalten!\n") );
               getcols(2);
               if ((!empty) && (equal_rows(2))) {
                 point_biserial_reg(xx[acol[0]], xx[acol[1]], nn[acol[0]]);
               }
               break;
       case 9: 
               out_d("Bitte Anzahl der zu korrelierenden Spalten eingeben,\n");
               out_d("Erste angewaehlte Spalte wird als y-Wert genommen: ");
               GETBLINE;
               if (strstr(line, _ALL_) != NULL) {
                 for (i=0; i<ncol; i++) {
                   acol[i] = i;
                 }
                 alloc_cols(ncol);
               }
               else {
                 i = getint();
                 getcols(i);
               }
	       
               if ((!empty) && (equal_rows(i))) {
                 yy = (REAL**)m_calloc((i-1), sizeof(PREAL));
                 for (k=0; k<(i-1); k++) {
                   yy[k] = xx[acol[k+1]];
                 }
                 out_r("y = Spalte %s\n", (alias[acol[0]]));
                 for (k=1; k<i; k++) {
                   out_r("x[%i] = Spalte %s\n", k, (alias[acol[k]]));
                 }
                 cross_validate(xx[acol[0]], yy, nn[acol[0]], i-1);
               }
               break;

       case 10: 
               out_d(_("Please enter numnber of columns to be correlated,\n",
		   	"Bitte Anzahl der zu korrelierenden Spalten eingeben,\n") );
               out_d(_("First selected column is taken as y-value: ", 
		   		"Erste angewaehlte Spalte wird als y-Wert genommen: ") );
               GETBLINE;
               if (strstr(line, _ALL_) != NULL) {
                 for (i=0; i<ncol; i++) {
                   acol[i] = i;
                 }
                 alloc_cols(ncol);
               }
               else {
                 i = getint();
                 getcols(i);
               }
	       
               if ((!empty) && (equal_rows(i))) {
                 yy = (REAL**)m_calloc((i-1), sizeof(PREAL));
                 for (k=0; k<(i-1); k++) {
                   yy[k] = xx[acol[k+1]];
                 }
                 out_r(_("y = Column %s\n", "y = Spalte %s\n"), 
		     		(alias[acol[0]]));
                 for (k=1; k<i; k++) {
                   out_r(_("x[%i] = Column %s\n", "x[%i] = Spalte %s\n"), 
			 	k, (alias[acol[k]]));
                 }
		 out_d(_("Please enter number of randomizations: ", 
		 	"Bitte Anzahl der Randomisierungen eingeben: ") );
                 GETBLINE;
                 k = getint();
                 random_tupel(xx[acol[0]], yy, nn[acol[0]], i-1, k);
               }
               break;

       default:out_err(ERR, ERR_FILE, ERR_LINE, 
	 		_("Illegal instruction!", "Ungueltige Anweisung!") );
               break;
     }
     m_freeall(); /* deallocate used memory for tmp variables */
     if (choice != 0) {
       mywait();
     }
   }
   return;
} /* regress_menu() */

/* =================================================================== */

void data_menu() {
   int i, j, k, n_max, choice=99;
   FILE *ascii_file;
   char filename[255], label[255];
   BOOLEAN found;

   while (choice != QUIT) {
     out_d(_("DATA MANAGEMENT: \n\n",
     		 "DATENVERWALTUNG: \n\n") );
     out_d(_("   0 = Main menu\n", "   0 = Hauptmenue\n") );
     out_d(_("   1 = List data of one column\n",
     		 "   1 = Daten einer Spalte auflisten\n") );
     out_d(_("   2 = Read another file\n",
     		 "   2 = Neue Datei einlesen\n") );
     out_d(_("   3 = List names of columns\n",
     		 "   3 = Spaltennamen auflisten\n") );
     out_d(_("   4 = Rename columns\n",
     		 "   4 = Spalten umbenennen\n") );
     out_d(_("   5 = Read column from terminal\n", 
     		 "   5 = Spalte vom Terminal lesen\n") );
     out_d(_("   6 = Export columns as ASCII-data\n",
     		 "   6 = Spalten als ASCII-Daten exportieren\n") );
     out_d(_("\n  Your choice: ", "\n  Ihre Wahl: ") );
     GETRLINE;
     status = sscanf(line,"%i", &choice);
     if ((status==0) || (empty)) {
       choice = 99;
     }
     out_d("\n\n");

     switch(choice) {
       case 0:
               break;
       case 1: 
               getcols(1);
               if (!empty) {
                 printcol(xx[acol[0]], nn[acol[0]]);
               }
               break;
       case 2: 
               newsourcefile();
               break;
       case 3: 
               for (i=0; i<ncol; i++) {
                  out_d(_("Column %i = %s\n", "Spalte %i = %s\n"), 
				(i+1), alias[i]);
               }
               out_d("\n");
               break;
       case 4:
	       out_d(_("Columns: ", "Spalten: ") );
	       for (k=0; k<ncol; k++) {
		 out_d("%s ", alias[k]);
	       }
	       out_d("\n\n");

               out_d(_("Please enter name of column: ",
		   		"Bitte Namen der Spalte eingeben: ") );
               GETBLINE;
	       found = FALSE;
	       for (i=0; i<ncol; i++) {
		 if (strcmp(line, alias[i])==0) {
		   found = TRUE;
		   out_d(_("Please enter name for the column: ",
		   	"Bitte neuen Namen fuer die Spalte eingeben: ") );
		   GETBLINE;
		   sscanf(line, "%s", label);
		   myfree(alias[i]);
		   alias[i] = mymalloc(strlen(line)+1);
		   strcpy(alias[i], line);
		   break;
		 }
	       }
	       if (!found) {
		 out_err(ERR, ERR_FILE, ERR_LINE,
			_("Column name %s doesn't exist!\n",
			 "Spaltenname %s existiert nicht!\n") );
	       }               
               break;
       case 5: 
               readcol_from_term();
               break;

       case 6: 
               out_d(_("Please enter number of columns to be exported: ",
		   	"Bitte Anzahl der zu exportierenden Spalten eingeben: ") );
               GETBLINE;
               if (strstr(line, _ALL_) != NULL) {
                 for (i=0; i<ncol; i++) {
                   acol[i] = i;
                 }
                 alloc_cols(ncol);
               }
               else {
                 i = getint();
		 getcols(i);
               }	
               n_max=0;       
	       for (k=0; k<i; k++) {
		 if (nn[acol[k]] > n_max) {
		   n_max = nn[acol[k]];
		 }
	       }
	       if (!empty) {
		 out_d(_("Please enter name of the export file: ",	
		 	"Bitte Namen der Exportdatei angeben: ") );
		 GETBLINE;
		 sscanf(line, "%s", filename);
		 FOPEN(filename, "wt", ascii_file);
		 for (k=0; k<n_max; k++) {
		   for (j=0; j<i; j++) {
		     if (nn[acol[j]]>k) {
		       fprintf(ascii_file, " %10.5e", xx[acol[j]][k]);
		     }
		     else {
		       fprintf(ascii_file, "  .         ");
		     }
                   }
		   fprintf(ascii_file, "\n");
                 }
                 FCLOSE(ascii_file);
                 out_d(_("Created file %s with %i columns!\n",
		     		"Datei %s mit %i Spalten erzeugt!\n" ), filename, i);
               }
	       break;

       default:out_err(ERR, ERR_FILE, ERR_LINE, 
	 		_("Illegal instruction!", "Ungueltige Anweisung!") );
         break;
       }
     m_freeall(); /* deallocate used memory for tmp variables */
     if (choice != 0) {
       mywait();
     }
   }
   return;
} /* data_menu() */



/* =================================================================== */

void manipulate_menu() {
   int i, j, k, choice=99;
   FILE *tempfile;
   char filename[255];

   while (choice != QUIT) {
     out_d(_("DATA MANIPULATION: \n\n",
     		 "DATENMANIPULATION: \n\n") );
     out_d(_("   0 = Main menu\n", "   0 = Hauptmenue\n") );
     out_d(_("   1 = Log-transformation (base 10)\n",
     		 "   1 = Log-Transformation (10er Logarithmus)\n") );
     out_d(_("   2 = Invert values (1/x)\n",
     		 "   2 = Invertierung (1/x)\n") );
     out_d(_("   3 = z-transformation [(x-mu)/sdv]\n",
     		 "   3 = Z-Transformation [(x-mu)/sdv]\n") );
     out_d(_("   4 = Sort\n",
     		 "   4 = Sortieren\n") );
     out_d(_("   5 = Join columns\n",
     		 "   5 = Zusammenfassung von Spalten\n") );
     out_d(_("   6 = Exponentiation to base 10\n",
     		 "   6 = 10er-Exponenzierung\n") );
     out_d(_("   7 = Create columns for weighted mean\n",
     		 "   7 = Spaltenerzeugung fuer gewichtete Mittel\n") );
     out_d(_("   8 = Log-transformation (natural logarithm)\n",
     		 "   8 = Log-Transformation (natuerlicher Logarithmus)\n") );
     out_d(_("   9 = Exponentiation to base 'e'\n",
     		 "   9 = e-Exponenzierung\n") );

     out_d(_("\n  Your choice: ", "\n  Ihre Wahl: ") );
     GETRLINE;
     status = sscanf(line,"%i", &choice);
     if ((status==0) || (empty)) {
       choice = 99;
     }
     out_d("\n\n");

     switch(choice) {
       case 0:
               break;
       case 1: 
               log_transform();
               break;
       case 2: 
               inv_transform();
               break;
       case 3: 
               z_transform();
               break;
       case 4:
	       sort_col();
	       break;
       case 5: 
               out_d(_("Please enter number of columns to be joined: ",
		   		"Bitte Anzahl der zusammenzufassenden Spalten eingeben: ") );
               GETBLINE;
               if (strstr(line, _ALL_) != NULL) {
                 for (i=0; i<ncol; i++) {
                   acol[i] = i;
                 }
                 alloc_cols(ncol);
               }
               else {
                 i = getint();
                 getcols(i);
               }
	       
               if (!empty) {
                 nn[ncol]= 0;
                 FOPEN(makefilename(ncol, filename),"wb", tempfile);
                 for (j=0; j<i; j++) {
                   out_d(_("Number of values in column %s: %i\n", 
				   "Anzahl Werte Spalte %s: %i\n"), 
			 	alias[acol[j]], nn[acol[j]]);
                   nn[ncol] += nn[acol[j]];
                   for (k=0; k<nn[acol[j]]; k++) {
                     FWRITE(&(xx[acol[j]][k]), sizeof(REAL), 1, tempfile);
                   }
                 }
                 FCLOSE(tempfile);
                 out_d(_("\nCreated column %s with %i values!\n",
		     		 "\nSpalte %s mit %i Werten erzeugt!\n"), 
				alias[ncol], nn[ncol]);
		 ncol++;
               }
	       break;

	case 6:
	       power_10_transform();
	       break;
        case 7:
               out_d(_("Columns: ", "Spalten: ") );
	       for (k=0; k<ncol; k++) {
		 out_d("%s ", alias[k]);
	       }
	       out_d("\n\n");
	       out_d(_("Please select column with values and column with factors:\n",
		 	"Bitte Spalte mit Werten und Spalte mit Multiplikatoren angeben:\n") );
	       getcols(2);
	       if ((!empty) && (equal_rows(2))) {
		 nn[ncol] = 0;
		 FOPEN(makefilename(ncol, filename),"wb", tempfile);
		 /* printf("n=%i\n", nn[acol[1]]); */
		 for (i=0; i<nn[acol[1]]; i++) {
		   /* printf("xx[acol[1]][i] = %i\n", (int)xx[acol[1]][i]);   */
		   for (j=0; j<(int)xx[acol[1]][i]; j++) {
		     FWRITE(&(xx[acol[0]][i]), sizeof(REAL), 1, tempfile);
		     /* printf("x%i = %f\n", i, xx[acol[0]][i]);  */
		   }
		   nn[ncol] += (int)xx[acol[1]][i];
		 }
		 FCLOSE(tempfile);
		 out_d(_("\nCreated column %s with %i values!\n",
		 	"\nSpalte %s mit %i Werten erzeugt!\n"), alias[ncol], nn[ncol]);
		 ncol ++;
	       }
	 break;
	case 8:
		ln_transform();
		break;

	case 9:
		power_e_transform();
		break;

       default:out_err(ERR, ERR_FILE, ERR_LINE, 
	 		_("Illegal instruction!", "Ungueltige Anweisung!") );
         break;
     }
     m_freeall(); /* deallocate used memory for tmp variables */
     if (choice != 0) {
       mywait();
     }
   }
   return;
} /* manipulate_menu() */
     
