#!/bin/sh
#
# @(#)sshsh.sh,v 1.1.1.1 1999/07/05 04:31:48 kim Exp
#
# Run a shell that
# a) has a valid connection to an ssh-agent
# b) has at least one identity in the ssh-agent
#
# 1997-01-05  Kimmo Suominen
#
# We use the existing PATH so we get whichever
# version of ssh the user prefers.
#
case `ssh-add -l 2>/dev/null` in
'')
    exec ssh-agent $0 "$@"
    ;;
*'no identities'*)
    if [ -r $HOME/.ssh/identity ]
    then
	ssh-add $HOME/.ssh/identity
    fi
    ;;
*)
    echo "Agent already has identities."
    ;;
esac
exec ${SHELL-/bin/sh} "$@"
