#!/usr/bin/tclsh

source rmcc-6.tcl

#Test options#

set nam "true"
set red "false"
set ecn "false"
set mdpNum 1
set runTime 1200.0

#Setup up for random start/stop tcp
# Flows start randomly from 0 -> startSpread
set startSpread 600.0 
# TCP duration maxTime*0.1 -> maxTime if startStop is "on"
# if startStop is "off", flows last indefinitely  
set startStop "on"
set maxTime 1200.0      
                      
    #Bottleneck setup
    set bottle0(TCPCount) 2
    set bottle0(Rate) 500kb
    set bottle0(Delay) 10ms
    set bottle0(Qsize) 25
    lappend bottleList bottle0
    
    set bottle1(TCPCount) 0
    set bottle1(Rate) 500kb
    set bottle1(Delay) 10ms
    set bottle1(Qsize) 25
    lappend bottleList bottle1
    
    set bottle2(TCPCount) 3
    set bottle2(Rate) 500kb
    set bottle2(Delay) 10ms
    set bottle2(Qsize) 25
    lappend bottleList bottle2
    
    set bottle3(TCPCount) 0
    set bottle3(Rate) 500kb
    set bottle3(Delay) 10ms
    set bottle3(Qsize) 25
    lappend bottleList bottle3
    
    set bottle4(TCPCount) 2
    set bottle4(Rate) 500kb
    set bottle4(Delay) 10ms
    set bottle4(Qsize) 25
    lappend bottleList bottle4

#Run rmcc-6.tcl
RunRMCC6 $bottleList $runTime $mdpNum $red $ecn $nam $startSpread $startStop $maxTime


    

