#!/usr/bin/tclsh

source rmcc-5.tcl

#Test options#

set nam "false"
set red "true"
set ecn "true"
set mdpNum 1
set runTime 720.0

#Setup up for random start/stop tcp
# Flows start randomly from 0 -> startSpread
set startSpread 180.0 
# TCP duration maxTime*0.1 -> maxTime if startStop is "on"
# if startStop is "off", flows last indefinitely  
set startStop "on"
set maxTime 1000.0      
                      
    #Bottleneck setup
    set bottle0(TCPCount) 1
    set bottle0(Rate) 1Mb
    set bottle0(Delay) 1ms
    set bottle0(Qsize) 100
    lappend bottleList bottle0
    
    set bottle1(TCPCount) 2
    set bottle1(Rate) 1Mb
    set bottle1(Delay) 1ms
    set bottle1(Qsize) 100
    lappend bottleList bottle1

    set bottle2(TCPCount) 3
    set bottle2(Rate) 1Mb
    set bottle2(Delay) 1ms
    set bottle2(Qsize) 100
    lappend bottleList bottle2
    
    set bottle3(TCPCount) 0
    set bottle3(Rate) 1Mb
    set bottle3(Delay) 1ms
    set bottle3(Qsize) 100
    lappend bottleList bottle3

#Run rmcc-5.tcl
RunRMCC5 $bottleList $runTime $mdpNum $red $ecn $nam $startSpread $startStop $maxTime


    

