#
proc CBRvsTCP {cbrRate numTCP bottleneckRate duration window} {

# Create multicast enabled simulator ins__tance
set ns_ [new Simulator -multicast on]
$ns_ multicast

# Turn on full ns_/NAM tracing
set f [open out-mcast.tr w]
$ns_ trace-all $f
set nf [open out-mcast.nam w]
$ns_ namtrace-all $nf

$ns_ color 0 red
$ns_ color 2 black
$ns_ color 1 blue

# Set up color mapping for MDPv2 packet types
$ns_ color 41 yellow
$ns_ color 42 blue
$ns_ color 43 darkgreen
$ns_ color 44 purple
$ns_ color 45 orange
$ns_ color 46 red
$ns_ color 47 black

# Create 16 nodes (7 sources, 2 on bottleneck, 7 sinks)
for {set i 0} {$i < 16} {incr i} {
    set n($i) [$ns_ node]
	}

# Make 7 source links 
set angle 1.55
for {set i 0} {$i < 7} {incr i} {
    $ns_ duplex-link $n($i) $n(7) 10Mb 1ms DropTail
    $ns_ queue-limit $n($i) $n(7) 60
    $ns_ duplex-link-op $n($i) $n(7) orient $angle
    $ns_ duplex-link-op $n($i) $n(7) queuePos 0.5
    set angle [expr $angle + 0.15]
    }

# Make 1 bottleneck link (Node 7 -> Node 8 link)
$ns_ duplex-link $n(7) $n(8) $bottleneckRate 10ms DropTail
$ns_ queue-limit $n(7) $n(8) 40
$ns_ duplex-link-op $n(7) $n(8) orient right
$ns_ duplex-link-op $n(7) $n(8) queuePos 0.5

# Make 7 sink links (fanout)
set angle 0.45
for {set i 9} {$i < 16} {incr i} {
    $ns_ duplex-link $n(8) $n($i) 10Mb 1ms DropTail
    $ns_ queue-limit $n(8) $n($i) 60
	$ns_ duplex-link-op $n(8) $n($i) orient $angle
    $ns_ duplex-link-op $n(8) $n($i) queuePos 0.5
    set angle [expr $angle - 0.15]  
    if {$angle < 0.0} {
        set angle 1.85
        }
    }
    
### Start multicast configuration: 5 mproto options_
### CtrMcast   : centralized multicast
### DM         : static DVMRP (can't adapt to link up/down or node up/down)
### detailedDM : dens_e mode protocol that adapts to dynamics (recommended)
### dynamicDM  : dynamic DVMRP 
### pimDM      : PIM dens_e mode

### Uncomment following lines to change default
#DM set PruneTimeout 0.3               ;# default 0.5 (sec)
#dynamicDM set ReportRouteTimeout 0.5  ;# default 1 (sec)

set mproto DM
set mrthandle [$ns_ mrtproto $mproto  {}]
if {$mrthandle != ""} {
    $mrthandle set_c_rp [list $n(3)]
}
### End of multicast configuration

# Create loss module for bottleneck link
set em(8) [new ErrorModel]

# Create loss modules for sink fanout links
for {set i 9} {$i < 16} {incr i} {
	set em($i) [new ErrorModel]
	$em($i) set rate_ 0.0
	$em($i) unit pkt
	$em($i) ranvar [new RandomVariable/Uniform]
    $em($i) drop-target [new Agent/Null]
	}

# Assign loss modules to interesting links
# Bottleneck link
$ns_ lossmodel $em(8) $n(7) $n(8)
$em(8) set rate_ 0.0
# Fanout links
for {set i 9} {$i < 16} {incr i} {
    $ns_ lossmodel $em($i) $n(8) $n($i)
    $em($i) set rate_ 0.0
    }
 
#######################################  
# Create CBR server agent w/ "null" client

set udp [new Agent/UDP]
$ns_ attach-agent $n(0) $udp
set cbr [new Application/Traffic/CBR]
$cbr attach-agent $udp
set null [new Agent/Null]
$ns_ attach-agent $n(9) $null
$ns_ connect $udp $null
$cbr set packet_size_ 536
$cbr set interval_ [expr 536.0 * 8.0 / [bw_parse $cbrRate]]


#########################################   
# Create FTP/TCP source and sink agents
#set numTCP 7
for {set i 0} {$i < $numTCP} {incr i} {
# Which node (0-6) is this connection associated with?
    set k $i
    if {$k > 6} {
        set k 0
        }
        
# Source
    set tcp_src($i) [new Agent/TCP/FullTcp]
    $ns_ attach-agent $n($k) $tcp_src($i)
    $tcp_src($i) set window_ 100
    $tcp_src($i) set packetSize_ 512
         
# Sink 
    set tcp_sink($i) [new Agent/TCP/FullTcp]
    $ns_ attach-agent $n([expr $k + 9]) $tcp_sink($i)
    $ns_ connect $tcp_src($i) $tcp_sink($i) 
    $tcp_sink($i) listen

# FTP App
    set ftp($i) [new Application/FTP]
    $ftp($i) attach-agent $tcp_src($i)
    }
    
# Run CBR and TCP over topology

# Start CBR source
$ns_ at 0.0 "$cbr start"
   
# Start FTP sessions_
for {set i 0} {$i < $numTCP} {incr i} {
    $ns_ at 0.0 "$ftp($i) start"
    } 

set filename $cbrRate
append filename "_cbr_vs_" $numTCP "tcp_" $bottleneckRate

$ns_ at $duration "finish $ns_ $f $nf {out-mcast.tr} $filename $window"

proc finish {ns_ f nf traceFile fileName window} {
    $ns_ flush-trace
	close $f
	close $nf
    
$ns_ halt
delete $ns_

# Analyze ns trace file with "rateplot" (make gif with gnuplot) 
set rateCmd "rateplot gif window $window auto 3 flow X "
append rateCmd "link 7,8 trace $traceFile $fileName.rate"
puts "cbrvstcp: Running rateplot to create $fileName.rate ..."
puts "cbrvstcp: \"$rateCmd\""
catch {eval exec $rateCmd}
puts "cbrvstcp: Running gnuplot to create $fileName.rate.gif ..."
catch {exec gnuplot -persist $fileName.rate}

# Analyze ns trace file with "lossplot" (make gif with gnuplot) 
set lossCmd "lossplot gif window $window auto 3 flow X "
append lossCmd "link 7,8 trace $traceFile $fileName.loss"
puts "cbrvstcp: Running lossplot to create $fileName.loss ..."
puts "cbrvstcp: \"$lossCmd\""
catch {eval exec $lossCmd}
puts "cbrvstcp: Running gnuplot to create $fileName.loss.gif ..."
catch {exec gnuplot -persist $fileName.loss}

}

$ns_ run

}

# Run a set of trials
# Eventually use argv,etc to allow input variables from the console
# But, good enough for now...! ;-)

#Usage: ns mdpvstcp.tcl numMdp numTcp bottleneckRate duration window

if {5 == $argc} {
    set cbrRate [lindex $argv 0]
    set numT [lindex $argv 1]
    set therate [lindex $argv 2]
    set duration [lindex $argv 3]
    set window [lindex $argv 4]
} elseif {0 == $argc} {
    set cbrRate 32kb
    set numT 1
    set therate 64kb
    set duration 60.0
    set window 5.0
} else {
    puts "cbrvstcp: Error! Invalid command line syntax."
    puts "   Usage: \"ns mdpvstcp.tcl [cbrRate numTcp bottleneckRate duration window]\""
    exit
}

puts "Running... (cbrRate:$cbrRate numTCP:$numT bottleneckRate:$therate)"
CBRvsTCP $cbrRate $numT $therate $duration $window



