#
# Copyright 1998 - 2018 Double Precision, Inc.  See COPYING for
# distribution information.


#
#  Need to version-upgrade RH builds due to different directory locations.
#

%if 0%{!?dist:1}
%define courier_release %(release="`rpm -q --queryformat='.%{VERSION}' redhat-release 2>/dev/null`" ; if test $? != 0 ; then release="`rpm -q --queryformat='.%{VERSION}' fedora-release 2>/dev/null`" ; if test $? != 0 ; then release="" ; fi ; fi ; echo "$release")
%else
%define courier_release %{nil}
%endif

%define _missing_doc_files_terminate_build 1
%define _unpackaged_files_terminate_build 1

%{expand:%%define apachedir %(if test -d /home/httpd ; then echo /home/httpd ; else echo /var/www ; fi)}

%define	cgibindir		%{apachedir}/cgi-bin
%define imagedir		%{apachedir}/html/webmail
%define	imageurl		/webmail

%define	cacheowner		bin
%define cachedir		%{_localstatedir}/webmail-logincache

%{expand:%%define initdir %(if test -d /etc/init.d/. ; then echo /etc/init.d ; else echo /etc/rc.d/init.d ; fi)}

Summary: SqWebMail - Maildir Webmail CGI client.
Name: sqwebmail
Version: 6.2.5
Release: 1%{?dist}%{courier_release}
License: GPL
Group: Applications/Mail
Source: http://download.sourceforge.net/courier/sqwebmail-6.2.5.tar.bz2
Url: http://www.courier-mta.org/sqwebmail
BuildRoot: %{_tmppath}/sqwebmail-install
Requires: /etc/cron.hourly expect

%{?_with_gpg2:  %define with_gpg2 1}
%{!?_with_gpg2: %define with_gpg2 0}

%if %with_gpg2
BuildRequires: gnupg2
Requires: gnupg2
%define gpg_option --with-gpg2
%else
BuildRequires: gnupg >= 1.0.5
Requires: gnupg >= 1.0.5
%endif

Requires(post):   systemd
Requires(postun): systemd
Requires(preun):  systemd
Requires:    %{__gzip}

Requires: %{cgibindir}
Obsoletes: %{name}-mysql > 0.0
Obsoletes: %{name}-pgsql > 0.0

BuildRequires: gcc-c++
BuildRequires: procps-ng
BuildRequires: rpm >= 4.0.2 coreutils grep perl
BuildRequires: %(which gpg >/dev/null 2>/dev/null && echo 'gnupg >= 1.0.5' && exit 0; echo gnupg2)
BuildRequires: openldap-devel courier-authlib-devel >= 0.55
BuildRequires: /etc/mime.types
BuildRequires: libidn2-devel
BuildRequires: courier-unicode-devel
BuildRequires: gdbm-devel pcre2-devel
BuildRequires: hunspell
BuildRequires: %{__gzip}
BuildRequires: %{__make}

%define is_fedora %(if rpm -q fedora-release >/dev/null 2>/dev/null; then echo "1"; exit 0; fi; echo "0"; exit 1)

%if %is_fedora
BuildRequires: perl-generators
BuildRequires: /usr/lib/locale/locale-archive
%endif

%description
SqWebMail is a Webmail CGI for Maildir mailboxes.

%package ldap
Group: Applications/Mail
Summary: LDAP address book hook for SqWebMail
Requires: %{name} = 0:%{version}-%{release}

%description ldap
This package installes the SqWebMail LDAP address book lookup module.

%define _prefix /usr/lib/sqwebmail
%define _sysconfdir %{_prefix}/etc
%define _mandir %{_prefix}/man

%define scriptdir %{_datadir}/sqwebmail
%define htmldir %{_datadir}/sqwebmail/html

%prep
%setup -q

%build
%configure -C %{?notice_option} \
	--enable-cgibindir=%{cgibindir} \
	--enable-imagedir=%{imagedir} \
	--enable-imageurl=%{imageurl} \
	--with-cachedir=%{cachedir} \
	--with-cacheowner=%{cacheowner} \
	%{?gpg_option} \
	%{?xflags: %{xflags}}


#
#  --sysconfdir needed for RH 7.x
#

%{__make} %{_smp_mflags}
%{__make} check
%install
%{__rm} -rf $RPM_BUILD_ROOT
%{__make} install DESTDIR=$RPM_BUILD_ROOT
%{__mkdir} -p $RPM_BUILD_ROOT/etc/pam.d
%{__install} -m 0444 libs/sqwebmail/webmail.authpam $RPM_BUILD_ROOT/etc/pam.d/webmail
%{__install} -m 0444 libs/sqwebmail/webmail.authpam $RPM_BUILD_ROOT/etc/pam.d/calendar

%{__rm} $RPM_BUILD_ROOT%{htmldir}/en || exit 1
# Drop the soft link -> en_us, this is taken care of by post script.

%{__mkdir} -p $RPM_BUILD_ROOT/etc/cron.hourly
%{__cat} >$RPM_BUILD_ROOT/etc/cron.hourly/sqwebmail-cron-cleancache <<EOF
#!/bin/sh

su - %{cacheowner} -s /bin/sh -c %{scriptdir}/cleancache.pl
EOF

#
# Red Hat init.d file
#

%{__mkdir} -p $RPM_BUILD_ROOT/lib/systemd/system

%{__cat} >$RPM_BUILD_ROOT/lib/systemd/system/sqwebmail.service <<EOF
[Unit]
Description=SqWebMail
Wants=network.target
Wants=courier-authlib.service
After=network.target
After=courier-authlib.service

[Install]
WantedBy=multi-user.target

[Service]
Type=forking
RemainAfterExit=true
ExecStart=%{_libexecdir}/sqwebmaild.rc start
ExecStop=%{_libexecdir}/sqwebmaild.rc stop
EOF

%{__cp} sysconftool $RPM_BUILD_ROOT%{scriptdir}/sysconftool

%{__cp} libs/pcp/README.html pcp_README.html
%{__cp} libs/gpglib/README.html gpglib_README.html

. libs/pcp/uids
echo '%attr(-, ' "$localcacheowner, $mailgroup) $calendardir" >filelist

(
courierauthconfig --configfiles >configtmp || exit 1
. ./configtmp
echo '%attr(-, '"$mailuser, $mailgroup" ') %{_libexecdir}' >>filelist
) || exit 1

ls $RPM_BUILD_ROOT%{scriptdir} | grep -v ldapsearch | sed 's:^:%attr(555, root, root) %{scriptdir}/:' >>filelist

# Weird rpm bug.
echo '%{cgibindir}/*' >>filelist
echo '%{imagedir}' >>filelist

%post

test -d %{htmldir}/en || ln -fs en-us %{htmldir}/en

if test -f %{initdir}/sqwebmail
then
	/sbin/chkconfig --del sqwebmail
	/bin/systemctl stop sqwebmail.service
fi

%{scriptdir}/sysconftool %{_sysconfdir}/*.dist >/dev/null

%systemd_post sqwebmail.service

if [ $1 -eq 1 ]
then
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi

%preun

%systemd_preun sqwebmail.service

%postun
test -d %{htmldir}/en || %{__rm} -f %{htmldir}/en

%systemd_postun_with_restart sqwebmail.service

%files -f filelist
%defattr(-, root, bin)
%dir %{_prefix}
%if "%{_prefix}" != "%{_exec_prefix}"
%dir %{_exec_prefix}
%endif

%attr(555, root, root) %dir %{scriptdir}
%dir %{_sysconfdir}
%{_sysconfdir}/*.dist

%{_sbindir}

%attr(644, root, root) /lib/systemd/system/*

%attr(700, %{cacheowner}, bin) %{cachedir}
%attr(644, root, root) %config(noreplace) /etc/pam.d/*

%attr(755, bin, bin) /etc/cron.hourly/sqwebmail-cron-cleancache

%attr(-, bin, bin) %doc AUTHORS libs/sqwebmail/BUGS COPYING INSTALL README libs/sqwebmail/SECURITY libs/sqwebmail/TODO gpglib_README.html
%attr(-, bin, bin) %doc libs/sqwebmail/BUGS.html INSTALL.html NEWS README.html libs/sqwebmail/SECURITY.html libs/sqwebmail/TODO.html libs/sqwebmail/ChangeLog pcp_README.html
%attr(-, bin, bin) %doc libs/maildir/README*.html

%files ldap
%attr(755, root, root) %{scriptdir}/ldapsearch

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%changelog

* Sun May 28 2023 Sam Varshavchik <mrsam@courier-mta.com>
- Update spec file
