/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener {
    public ListSearchable(JList list) {
        super(list);
        list.getModel().addListDataListener(this);
        list.addPropertyChangeListener("model", this);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JList) {
            ((JList)this._component).getModel().removeListDataListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        if (incremental) {
            ((JList)this._component).addSelectionInterval(index, index);
        } else if (((JList)this._component).getSelectedIndex() != index) {
            ((JList)this._component).setSelectedIndex(index);
        }
        ((JList)this._component).ensureIndexIsVisible(index);
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this._component).getSelectedIndex();
    }

    @Override
    protected Object getElementAt(int index) {
        ListModel listModel = ((JList)this._component).getModel();
        return listModel.getElementAt(index);
    }

    @Override
    protected int getElementCount() {
        ListModel listModel = ((JList)this._component).getModel();
        return listModel.getSize();
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (e.getIndex0() == -1 && e.getIndex1() == -1) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            ListModel newModel;
            this.hidePopup();
            ListModel oldModel = (ListModel)evt.getOldValue();
            if (oldModel != null) {
                oldModel.removeListDataListener(this);
            }
            if ((newModel = (ListModel)evt.getNewValue()) != null) {
                newModel.addListDataListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }
}

