/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.prefs;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import org.jmeld.util.prefs.Preference;

public class FileChooserPreference
extends Preference {
    private static String FILE = "FILE";
    private JFileChooser target;

    public FileChooserPreference(String preferenceName, JFileChooser target) {
        super("FileChooser-" + preferenceName);
        this.target = target;
        this.init();
    }

    private void init() {
        String fileName = this.getString(FILE, null);
        if (fileName != null) {
            this.target.setCurrentDirectory(new File(fileName));
        }
    }

    public void save() {
        File file = this.target.getSelectedFile();
        if (file != null) {
            try {
                String fileName = file.getCanonicalPath();
                this.putString(FILE, fileName);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

