/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.endresulttransformer;

import java.util.Map;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.endresulttransformer.EndResultTransformer;

public class SimpleEndResultTransformer
implements EndResultTransformer {
    @Override
    public void transform(Map<String, ?> result, ResponseBuilder rb, EndResultTransformer.SolrDocumentSource solrDocumentSource) {
        SimpleOrderedMap commands = new SimpleOrderedMap();
        for (Map.Entry<String, ?> entry : result.entrySet()) {
            SimpleOrderedMap command;
            Object value = entry.getValue();
            if (TopGroups.class.isInstance(value)) {
                TopGroups topGroups = (TopGroups)value;
                command = new SimpleOrderedMap();
                command.add("matches", (Object)rb.totalHitCount);
                if (topGroups.totalGroupCount != null) {
                    command.add("ngroups", (Object)topGroups.totalGroupCount);
                }
                SolrDocumentList docList = new SolrDocumentList();
                docList.setStart((long)rb.getGroupingSpec().getGroupSortSpec().getOffset());
                docList.setNumFound((long)topGroups.totalHitCount);
                float maxScore = Float.NEGATIVE_INFINITY;
                for (GroupDocs groupDocs : topGroups.groups) {
                    for (ScoreDoc scoreDoc : groupDocs.scoreDocs) {
                        SolrDocument solrDocument;
                        if (maxScore < scoreDoc.score) {
                            maxScore = scoreDoc.score;
                        }
                        if ((solrDocument = solrDocumentSource.retrieve(scoreDoc)) == null) continue;
                        docList.add((Object)solrDocument);
                    }
                }
                if (maxScore != Float.NEGATIVE_INFINITY) {
                    docList.setMaxScore(Float.valueOf(maxScore));
                }
                command.add("doclist", (Object)docList);
                commands.add(entry.getKey(), (Object)command);
                continue;
            }
            if (!(value instanceof QueryCommandResult)) continue;
            QueryCommandResult queryCommandResult = (QueryCommandResult)value;
            command = new SimpleOrderedMap();
            command.add("matches", (Object)queryCommandResult.getMatches());
            TopDocs topDocs = queryCommandResult.getTopDocs();
            SolrDocumentList docList = new SolrDocumentList();
            docList.setStart((long)rb.getGroupingSpec().getGroupSortSpec().getOffset());
            docList.setNumFound(topDocs.totalHits.value);
            if (!Float.isNaN(queryCommandResult.getMaxScore())) {
                docList.setMaxScore(Float.valueOf(queryCommandResult.getMaxScore()));
            }
            for (GroupDocs groupDocs : topDocs.scoreDocs) {
                SolrDocument solrDocument = solrDocumentSource.retrieve((ScoreDoc)groupDocs);
                if (solrDocument == null) continue;
                docList.add((Object)solrDocument);
            }
            command.add("doclist", (Object)docList);
            commands.add(entry.getKey(), (Object)command);
        }
        rb.rsp.add("grouped", commands);
    }
}

