/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.ConstNumberSource;

class LongConstValueSource
extends ConstNumberSource {
    final long constant;
    final double dv;
    final float fv;

    public LongConstValueSource(long constant) {
        this.constant = constant;
        this.dv = constant;
        this.fv = constant;
    }

    public String description() {
        return "const(" + this.constant + ")";
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        return new LongDocValues((ValueSource)this){

            public float floatVal(int doc) {
                return LongConstValueSource.this.fv;
            }

            public int intVal(int doc) {
                return (int)LongConstValueSource.this.constant;
            }

            public long longVal(int doc) {
                return LongConstValueSource.this.constant;
            }

            public double doubleVal(int doc) {
                return LongConstValueSource.this.dv;
            }

            public String toString(int doc) {
                return LongConstValueSource.this.description();
            }
        };
    }

    public int hashCode() {
        return (int)this.constant + (int)(this.constant >>> 32);
    }

    public boolean equals(Object o) {
        if (LongConstValueSource.class != o.getClass()) {
            return false;
        }
        LongConstValueSource other = (LongConstValueSource)((Object)o);
        return this.constant == other.constant;
    }

    public int getInt() {
        return (int)this.constant;
    }

    public long getLong() {
        return this.constant;
    }

    public float getFloat() {
        return this.fv;
    }

    public double getDouble() {
        return this.dv;
    }

    public Number getNumber() {
        return this.constant;
    }

    public boolean getBool() {
        return this.constant != 0L;
    }
}

