/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class SetFunction {
    private HashSet distinctValues;
    private final boolean isDistinct;
    private final int setType;
    private final int typeCode;
    private final Type type;
    private final ArrayType arrayType;
    private final Type returnType;
    private long count;
    private boolean hasNull;
    private boolean every = true;
    private boolean some = false;
    private long currentLong;
    private double currentDouble;
    private BigDecimal currentBigDecimal;
    private Object currentValue;
    static final BigInteger multiplier = BigInteger.valueOf(0x100000000L);
    long hi;
    long lo;
    private double sk;
    private double vk;
    private long n;
    private boolean initialized;
    private boolean sample;

    SetFunction(Session session, int n, Type type, Type type2, boolean bl, ArrayType arrayType) {
        this.setType = n;
        this.type = type;
        this.returnType = type2;
        this.isDistinct = bl;
        this.arrayType = arrayType;
        if (bl) {
            this.distinctValues = new HashSet();
            if (type.isRowType() || type.isArrayType()) {
                Type.TypedComparator typedComparator = Type.newComparator(session);
                SortAndSlice sortAndSlice = new SortAndSlice();
                int n2 = type.isRowType() ? ((RowType)type).getTypesArray().length : 1;
                sortAndSlice.prepareMultiColumn(n2);
                typedComparator.setType(type, sortAndSlice);
                this.distinctValues.setComparator(typedComparator);
            }
        }
        if (n == 81 || n == 79) {
            this.sample = true;
        }
        this.typeCode = type == null ? 0 : (type.isIntervalYearMonthType() ? 102 : (type.isIntervalDaySecondType() ? 106 : type.typeCode));
    }

    void add(Session session, Object object) {
        if (object == null) {
            this.hasNull = true;
            return;
        }
        if (this.isDistinct && !this.distinctValues.add(object)) {
            return;
        }
        ++this.count;
        switch (this.setType) {
            case 71: {
                return;
            }
            case 72: 
            case 75: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.currentLong += (long)((Number)object).intValue();
                        return;
                    }
                    case 106: {
                        if (object instanceof IntervalSecondData) {
                            this.addLong(((IntervalSecondData)object).getSeconds());
                            this.currentLong += (long)((IntervalSecondData)object).getNanos();
                            if (Math.abs(this.currentLong) >= (long)DTIType.nanoScaleFactors[0]) {
                                this.addLong(this.currentLong / (long)DTIType.nanoScaleFactors[0]);
                                this.currentLong %= (long)DTIType.nanoScaleFactors[0];
                            }
                        }
                        return;
                    }
                    case 102: {
                        if (object instanceof IntervalMonthData) {
                            this.addLong(((IntervalMonthData)object).units);
                        }
                        return;
                    }
                    case 91: 
                    case 93: 
                    case 95: {
                        this.addLong(((TimestampData)object).getSeconds());
                        this.currentLong += (long)((TimestampData)object).getNanos();
                        if (Math.abs(this.currentLong) >= (long)DTIType.nanoScaleFactors[0]) {
                            this.addLong(this.currentLong / (long)DTIType.nanoScaleFactors[0]);
                            this.currentLong %= (long)DTIType.nanoScaleFactors[0];
                        }
                        this.currentDouble = ((TimestampData)object).getZone();
                        return;
                    }
                    case 25: {
                        this.addLong(((Number)object).longValue());
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += ((Number)object).doubleValue();
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? (BigDecimal)object : this.currentBigDecimal.add((BigDecimal)object);
                        return;
                    }
                }
                throw Error.error(5563);
            }
            case 73: {
                if (this.currentValue == null) {
                    this.currentValue = object;
                    return;
                }
                if (this.type.compare(session, this.currentValue, object) > 0) {
                    this.currentValue = object;
                }
                return;
            }
            case 74: {
                if (this.currentValue == null) {
                    this.currentValue = object;
                    return;
                }
                if (this.type.compare(session, this.currentValue, object) < 0) {
                    this.currentValue = object;
                }
                return;
            }
            case 76: {
                if (!(object instanceof Boolean)) {
                    throw Error.error(5563);
                }
                this.every = this.every && (Boolean)object != false;
                return;
            }
            case 77: {
                if (!(object instanceof Boolean)) {
                    throw Error.error(5563);
                }
                this.some = this.some || (Boolean)object != false;
                return;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                this.addDataPoint((Number)object);
                return;
            }
            case 94: {
                this.currentValue = object;
                return;
            }
        }
        throw Error.runtimeError(201, "SetFunction");
    }

    Object getValue(Session session) {
        if (this.hasNull) {
            session.addWarning(Error.error(1003));
        }
        if (this.setType == 71) {
            if (this.count > 0L && this.isDistinct && this.type.isCharacterType()) {
                Object[] objectArray = new Object[this.distinctValues.size()];
                this.distinctValues.toArray(objectArray);
                SortAndSlice sortAndSlice = new SortAndSlice();
                sortAndSlice.prepareSingleColumn(0);
                this.arrayType.sort(session, objectArray, sortAndSlice);
                this.count = this.arrayType.deDuplicate(session, objectArray, sortAndSlice);
            }
            return ValuePool.getLong(this.count);
        }
        if (this.count == 0L) {
            return null;
        }
        switch (this.setType) {
            case 75: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        if (this.returnType.scale != 0) {
                            return this.returnType.divide(session, this.currentLong, this.count);
                        }
                        return this.currentLong / this.count;
                    }
                    case 25: {
                        long l = this.getLongSum().divide(BigInteger.valueOf(this.count)).longValue();
                        return l;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble / (double)this.count);
                    }
                    case 2: 
                    case 3: {
                        if (this.returnType.scale == this.type.scale) {
                            return this.currentBigDecimal.divide(new BigDecimal(this.count), 1);
                        }
                        return this.returnType.divide(session, this.currentBigDecimal, this.count);
                    }
                    case 102: 
                    case 106: {
                        BigInteger[] bigIntegerArray = this.getLongSum().divideAndRemainder(BigInteger.valueOf(this.count));
                        if (NumberType.compareToLongLimits(bigIntegerArray[0]) != 0) {
                            throw Error.error(3435);
                        }
                        if (((IntervalType)this.type).isIntervalDaySecondType()) {
                            long l = (bigIntegerArray[1].longValue() * 1000000000L + this.currentLong) / this.count;
                            return new IntervalSecondData(bigIntegerArray[0].longValue(), l, (IntervalType)this.type, true);
                        }
                        return IntervalMonthData.newIntervalMonth(bigIntegerArray[0].longValue(), (IntervalType)this.type);
                    }
                    case 91: 
                    case 93: 
                    case 95: {
                        BigInteger bigInteger = this.getLongSum().divide(BigInteger.valueOf(this.count));
                        if (NumberType.compareToLongLimits(bigInteger) != 0) {
                            throw Error.error(3435);
                        }
                        return new TimestampData(bigInteger.longValue(), (int)this.currentLong, (int)this.currentDouble);
                    }
                }
                throw Error.runtimeError(201, "SetFunction");
            }
            case 72: {
                switch (this.typeCode) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return this.currentLong;
                    }
                    case 25: {
                        return new BigDecimal(this.getLongSum());
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal;
                    }
                    case 102: 
                    case 106: {
                        BigInteger bigInteger = this.getLongSum();
                        if (NumberType.compareToLongLimits(bigInteger) != 0) {
                            throw Error.error(3435);
                        }
                        if (((IntervalType)this.type).isIntervalDaySecondType()) {
                            return new IntervalSecondData(bigInteger.longValue(), this.currentLong, (IntervalType)this.type, true);
                        }
                        return IntervalMonthData.newIntervalMonth(bigInteger.longValue(), (IntervalType)this.type);
                    }
                }
                throw Error.runtimeError(201, "SetFunction");
            }
            case 73: 
            case 74: {
                return this.currentValue;
            }
            case 76: {
                return this.every ? Boolean.TRUE : Boolean.FALSE;
            }
            case 77: {
                return this.some ? Boolean.TRUE : Boolean.FALSE;
            }
            case 78: 
            case 79: {
                return this.getStdDev();
            }
            case 80: 
            case 81: {
                return this.getVariance();
            }
            case 94: {
                return this.currentValue;
            }
        }
        throw Error.runtimeError(201, "SetFunction");
    }

    static Type getType(Session session, int n, Type type) {
        if (n == 71) {
            return Type.SQL_BIGINT;
        }
        int n2 = type.typeCode;
        if (type.isIntervalYearMonthType()) {
            n2 = 102;
        } else if (type.isIntervalDaySecondType()) {
            n2 = 106;
        }
        switch (n) {
            case 75: 
            case 85: {
                switch (n2) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 25: {
                        int n3 = session.database.sqlAvgScale;
                        if (n3 <= type.scale) {
                            return type;
                        }
                        int n4 = ((NumberType)type).getDecimalPrecision();
                        return NumberType.getNumberType(3, n4 + n3, n3);
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 91: 
                    case 93: 
                    case 95: 
                    case 102: 
                    case 106: {
                        return type;
                    }
                }
                throw Error.error(5563);
            }
            case 72: {
                switch (n2) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return Type.SQL_BIGINT;
                    }
                    case 25: {
                        return Type.SQL_DECIMAL_BIGINT_SQR;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return Type.SQL_DOUBLE;
                    }
                    case 2: 
                    case 3: {
                        return Type.getType(type.typeCode, null, null, type.precision * 2L, type.scale);
                    }
                    case 102: 
                    case 106: {
                        return IntervalType.newIntervalType(type.typeCode, 9L, type.scale);
                    }
                }
                throw Error.error(5563);
            }
            case 73: 
            case 74: {
                if (type.isArrayType() || type.isLobType()) {
                    throw Error.error(5563);
                }
                return type;
            }
            case 76: 
            case 77: {
                if (!type.isBooleanType()) break;
                return Type.SQL_BOOLEAN;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                if (!type.isNumberType()) break;
                return Type.SQL_DOUBLE;
            }
            case 94: {
                return type;
            }
            default: {
                throw Error.runtimeError(201, "SetFunction");
            }
        }
        throw Error.error(5563);
    }

    void addLong(long l) {
        if (l != 0L) {
            if (l > 0L) {
                this.hi += l >> 32;
                this.lo += l & 0xFFFFFFFFL;
            } else if (l == Long.MIN_VALUE) {
                this.hi -= 0x80000000L;
            } else {
                long l2 = (l ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
                this.hi -= l2 >> 32;
                this.lo -= l2 & 0xFFFFFFFFL;
            }
        }
    }

    BigInteger getLongSum() {
        BigInteger bigInteger = BigInteger.valueOf(this.lo);
        BigInteger bigInteger2 = BigInteger.valueOf(this.hi);
        BigInteger bigInteger3 = bigInteger2.multiply(multiplier).add(bigInteger);
        return bigInteger3;
    }

    private void addDataPoint(Number number) {
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        if (!this.initialized) {
            this.n = 1L;
            this.sk = d;
            this.vk = 0.0;
            this.initialized = true;
            return;
        }
        ++this.n;
        long l = this.n - 1L;
        double d2 = this.sk - d * (double)l;
        this.vk += d2 * d2 / (double)this.n / (double)l;
        this.sk += d;
    }

    private Double getVariance() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : new Double(this.vk / (double)(this.n - 1L))) : new Double(this.vk / (double)this.n);
    }

    private Double getStdDev() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : new Double(Math.sqrt(this.vk / (double)(this.n - 1L)))) : new Double(Math.sqrt(this.vk / (double)this.n));
    }
}

