#!/bin/bash
# Usage: $0 <TARGET-NAME> <PRIVATE_EXCLUDE>

PRIVATE=()
PUBLIC=()
while IFS= read -r source; do
  if grep -q "Q_OBJECT" "$source"; then
    PRIVATE+=("$source")
  else
    PUBLIC+=("$source")
  fi
done < <(find include \( -name "*.h" -or -name "*.hpp" \) | sort)

while IFS= read -r source; do
  if [[ $source != "$2" ]]; then
    PRIVATE+=("$source")
  fi
done < <(find src \( -name "*.c" -or -name "*.cpp" \) | sort)

echo "# This file was autogenerated by 'gen_cmake_sources.sh' - DO NOT EDIT"
echo "target_sources($1"
echo "  PUBLIC"
for source in "${PUBLIC[@]}"; do
  echo "    \"\${CMAKE_CURRENT_SOURCE_DIR}/$source\""
done
echo "  PRIVATE"
for source in "${PRIVATE[@]}"; do
  echo "    \"\${CMAKE_CURRENT_SOURCE_DIR}/$source\""
done
echo ")"
