/*
 * Copyright (c) 1997, Matthew N. Dodd
 * All rights reserved.
 *
 * Portions Copyright (c) 1980, 1990, 1993
 * 	The Regents of the University of California.  All rights reserved.   
 * 
 * Code borrowed from usr.bin/quota/quota.c derived from software 
 * contributed to Berkeley by Robert Elz at The University of Melbourne. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char copyright[] =
	"Copyright (c) 1997 Matthew N. Dodd\n\tAll rights reserved.\n";
#endif /* not lint */

#ifndef lint
static const char rcsid[] =
	"$Id: printquota.c,v 1.9 1997/03/24 04:14:46 winter Exp $";
#endif /* not lint */

#include <sys/param.h>
#include <stdio.h>
#include <ufs/ufs/quota.h>
#include <sys/types.h>
#include <pwd.h>
#include <errno.h>
#include "quotatool.h"

int print_quota(qmstr*);
static char *timeprt(time_t seconds);

int
print_quota(qm)
	qmstr *qm;
{
	printf("%15s%8s%7s%8s %8s%8s%7s%8s %8s\n"
		, f_mode ? "username" : "groupname"
		, "blocks"
		, "soft"
		, "hard"
		, "grace"
		, "files"
		, "soft"
		, "hard"
		, "grace"
	);

	printf("       ------------------------------------------------------------------------\n");

	while(qm) {

		printf("%15s%8lu%7lu%8lu %8s"
			, qm->name
			, (u_long) (dbtob(qm->dq_dqb.dqb_curblocks) / 1024)
			, (u_long) (dbtob(qm->dq_dqb.dqb_bsoftlimit) / 1024)
			, (u_long) (dbtob(qm->dq_dqb.dqb_bhardlimit) / 1024)
			, timeprt(qm->dq_dqb.dqb_btime));
		printf("%8lu%7lu%8lu %8s\n"
 			, (u_long) qm->dq_dqb.dqb_curinodes
			, qm->dq_dqb.dqb_isoftlimit
			, qm->dq_dqb.dqb_ihardlimit
			, timeprt(qm->dq_dqb.dqb_itime));

		qm = qm->next;
	}

	return 0;
}

/*
 * Calculate the grace period and return a printable string for it.
 */
static char *
timeprt(seconds)
        time_t seconds;
{
	time_t hours, minutes;
	static char buf[20];
	static time_t now;

	if (now == 0)
		time(&now);
#ifdef 0
	if (now > seconds)
		return("none");
	seconds -= now;
#endif
	sprintf(buf, "%d", seconds);
	return(buf);
	minutes = (seconds + 30) / 60;
	hours = (minutes + 30) / 60;


	if (hours >= 8760) {
		sprintf(buf, "%dyears", (hours + 12) / 24 / 365);
		return(buf);
	}
	if (hours >= 36) {
		sprintf(buf, "%lddays", (hours + 12) / 24);
		return (buf);
	}
	if (minutes >= 60) {
		sprintf(buf, "%2d:%d", minutes / 60, minutes % 60);
		return (buf);
	}
	sprintf(buf, "%2d", minutes);
	return (buf);
}
