#include <unistd.h>
#include <pwd.h>
#include "strerr.h"
#include "exit.h"
#include "generic-conf.h"
#include "service-conf.h"
#include "fmt.h"

#define FATAL "service-config: fatal: "

void usage(void)
{
  strerr_die1x(100,"service-config: usage: service-config user loguser dir server");
}

char *user;
char *loguser;
char *dir;
char *server;

main(int argc,char **argv)
{
  umask(022);

  user = *++argv;
  if (!user) usage();
  loguser = *++argv;
  if (!loguser) usage();
  dir = *++argv;
  if (!dir) usage();
  if (dir[0] != '/') usage();
  if (!*++argv) usage();

  if (!*user) user = 0;
  if (!*loguser) loguser = 0;

  service(dir,user,loguser,FATAL);
  start("run");
  outs("#!/bin/sh\nexec 2>&1\nexec envdir "); outs(dir); outs("/env \\\n");
  for (;;) {
    outs(*argv);
    if (!*++argv) break;
    outs("\n"); 
  }
  outs("\n");
  finish();
  perm(0755);

  _exit(0);
}
