/*  selectwm - X11 window manager selector
 *
 *  Copyright (C) 1999-2002  Luc Dufresne - luc@ordiluc.net
 *                           26, rue des Comices
 *                           59650 Villeneuve d'Ascq
 *                           FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include "define.h"

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

#include "misc.h"
#include "miscui.h"
#include "modify.h"

static GString *getline (FILE *fichier) {
	GString *temp;
	gchar buf[128];
	
	temp = g_string_new ("");
	do {
		if (NULL == fgets (buf, sizeof (buf), fichier)) {
			return temp;
		}
		g_string_append (temp, buf);
	} while (!g_strrstr (buf, "\n"));
	return temp;
}

static gint read_config_file (config *selectwm_config) {
	FILE *config;
	GString *buf;
	gint n = 0;
	gchar **tab;

	selectwm_config->delay = 15.0;
	selectwm_config->restart_selectwm = 0;
	selectwm_config->goback_btn = 3;
	selectwm_config->default_wm = "0";

	config = fopen (selectwm_config->ConfigFile->str, "rt");
	if (!config) {
		g_warning (_("Unable to read the config file, using the default values"));
		return n;
	}
	buf = g_string_new ("");
	while (!feof (config)) {
		buf = getline (config);

		if (buf->len > 0 && buf->str[0] != '#') {
			if (g_strrstr (buf->str, ":")) {
				tab = g_strsplit (buf->str, ":", 2);
				g_strchomp (tab[1]);
				if (g_strrstr(tab[0], "delay")) selectwm_config->delay = atof (tab[1]);
				if (g_strrstr(tab[0], "restart_selectwm")) selectwm_config->restart_selectwm = atoi (tab[1]);
				if (g_strrstr(tab[0], "default_wm")) selectwm_config->default_wm = g_strdup (tab[1]);
				if (g_strrstr(tab[0], "goback_btn")) selectwm_config->goback_btn = atoi (tab[1]);
				g_strfreev (tab);
			}
			
			if (g_strrstr (buf->str, "=")) {
				tab = g_strsplit (buf->str, "=", 2);
				g_strchomp (tab[1]);
				insert_item (selectwm_config, tab[1], tab[0]);
				g_strfreev (tab);
				n++;
			}
		}
		g_string_free (buf, TRUE);
	}
	fclose (config);
	return n;
}

gint read_config (config *selectwm_config) {
	gint n;
	GtkTreePath *path;
	GtkTreeIter iter;
	
	n = read_config_file (selectwm_config);

	switch (selectwm_config->goback_btn) {
		case 1:
			selectwm_config->restart_selectwm = TRUE;
			break;
		case 2:
			selectwm_config->restart_selectwm = FALSE;
			break;
		case 3:
			break;
	}
	if (n!= 0 && n >= atoi (selectwm_config->default_wm)) {
		path = gtk_tree_path_new_from_string (selectwm_config->default_wm);
		gtk_tree_model_get_iter (selectwm_config->model, &iter, path);
			
		set_defaultwm (GTK_LIST_STORE (selectwm_config->model), &iter);
		gtk_tree_view_set_cursor (GTK_TREE_VIEW (selectwm_config->treeview), path, NULL, FALSE);

		g_free (selectwm_config->default_wm);
		gtk_tree_path_free (path);
	}

	return n;
}

void write_config (config *selectwm_config) {
	FILE *fichier;
	gchar *desc, *cmd;
	gboolean dflt;
        GtkTreeIter iter;
	gint i, default_wm = 0;

	if (selectwm_config->SaveOnExit) {
		if (NULL != (fichier = fopen (selectwm_config->ConfigFile->str, "wt"))) {
			fprintf (fichier,_("# Automatically generated file.\n# Do not edit (or make a backup copy before doing so)\n"));
		        i = 0;
			if (gtk_tree_model_get_iter_first (selectwm_config->model, &iter))
		        do {
				gtk_tree_model_get (selectwm_config->model, &iter, C_CMD, &cmd, C_DESC, & desc, C_DEFAULT, &dflt, -1);
				g_strdelimit (desc, ":=", ' ');
				g_strdelimit (cmd, ":=", ' ');
				fprintf (fichier,"%s=%s\n", desc, cmd);
				if (dflt) default_wm = i;
				i++;
				g_free (cmd);
				g_free (desc);
		        } while (gtk_tree_model_iter_next (selectwm_config->model, &iter));
		
			fprintf (fichier,"delay:%f\n", selectwm_config->delay);
			fprintf (fichier,"restart_selectwm:%d\n", selectwm_config->restart_selectwm);
			fprintf (fichier,"default_wm:%d\n", default_wm);
			fprintf (fichier,"goback_btn:%d\n", selectwm_config->goback_btn);

			fclose (fichier);
		} else 	g_warning (_("Unable to write the config file"));
	}
}
