/*
 * Copyright (C) 1983-1989  Masatoshi Kurihara <kurihara@sra.co.jp>
 * Copyright (C) 1999, 2000 and 2001
 * Jun-ichiro itojun Hagino <itojun@iijlab.net>
 * All rights reserved.
 *
 * Note well: this is not a normal 3-clause BSD copyright;
 * commercial use of the software is restricted.
 *
 * Redistribution and non-commercial use in source and binary
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* Copyright (C) 1985 - 1989 by Software Research Associates, Inc. */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <curses.h>
#include <common.h>
#ifdef MULTIBYTE
# include <wchar.h>
#endif
#ifdef HAVE_REGEX_H
# include <regex.h>
#else
# include <regexp.h>
#endif

#include <def.h>
#include <entry.h>
#include <opts.h>
#include <var.h>

/* windows */
WINDOW *errwin;		/* error message*/
WINDOW *schwin;		/* schedule */
WINDOW *calwin;		/* calander */
WINDOW *schfull;	/* schedule full window */
WINDOW *schhalf;	/* schedule half window */

/* flags */
int updated = FALSE;	/* file should be write back */
int prjsw;		/* project code print */
int calsw = FALSE;	/* calander */
int autowrite = FALSE;	/* auto write back */
int writesw = FALSE;	/* write permission */
int newsw = FALSE;	/* new file */
int msgsw = FALSE;	/* message on bottom line */
int myfile = TRUE;	/* other user's schedule */
int verbose = TRUE;
int tabhour = 2;	/* tab advances N hours */
int hourwidth = 2;	/* 1 hour occupies N chars */
int homezone = -9;	/* home timezone offset against GMT, Japan = -9 */
int curzone = -9;	/* display/edit timezone offset against GMT */
int oldformat = 0;	/* write out in old format */

int scrmsg;		/* Start column of message */
int maxsch, cursch;	/* Pointer for schedule data */
long ltime;		/* Start time */
struct tm inttimebuf;	/* Start time */
struct tm *inttime;	/* Start time */

int daystart = 9;	/* day starts this hour */
int dayend = 21;	/* day ends this hour */

/* Terminal control character */
#ifdef HAVE_TERMIOS_H
struct termios tio;
#else
struct sgttyb ttyb;
#endif

struct sch *sch[MAXDATA];	/* schedule buffer */
struct yank yank[10];		/* yank buffer */

char schfname[MAXPATHLEN];		/* Schedule file name */
char schsname[MAXPATHLEN];		/* Schedule file short name */
char username[10];		/* Target user name */
int mark[10];			/* Marked shedule data */

#ifdef HAVE_REGEX_H
regex_t *psearch = NULL;
#else
struct regexp *psearch = NULL;
#endif

char localelang[OPT_STRLEN];
int localeset = 0;
